#!/usr/bin/perl -w

use strict;
use warnings;

use Lingua::DE::ASCII;
use Test::More tests => 1;

use strict;
use warnings;
use diagnostics;

my $non_ascii_chars = join("", map {chr} (128..255));

while (<DATA>) {
    chomp;
    print STDERR "." if ($. % 5_000) == 1;
    my $ascii_text = to_ascii($_);  
    my $iso_text = to_latin1($ascii_text);
    $ascii_text !~ /[$non_ascii_chars]/o or diag("$_ => $ascii_text"),fail,last;
    $iso_text eq $_                      or diag("$_ => $ascii_text => $iso_text"),fail,last;
}

ok("Foreign words (and symbols) could be translated without errors");

1;

__DATA__
Acadmie franaise
Acheulen
Acheulens
Adrema
Agfacolor
Agfa
Agrment
Agrments
Airbus
Alcantara
Alenon
Alenons
Alpacca
Amphiole
Ancien Rgime
Ancien Rgimes
Andr
Andrs
Angostura
Aperu
Aperus
Aprs-Ski
Aprs-Ski-Kleidung
Aprs-Ski-Kleidungen
Apro
Apros
Aragn
Aragns
Art dco
Aspirin
Associ
Associs
Asuncin
Asuncins
Attach
Attache
Attachen
Attachs
Audi
BMW
Bakelit
Balpar
Balpars
Bartk
Bartkes
Bartks
Baumgrad
Baumgrads
Beaut
Beauts
Belle poque
Birkenstocksandale
Bjrnson
Bjrnsons
Bogot
Bogots
Bokml
Bokmls
Bostitch
Boucl
Boucls
Bourre
Bourres
Bruyreholz
Bruyreholzes
Bruyrepfeife
Bruyrepfeifen
Bulldog
Buna
Bb
Bbs
Bchamelkartoffel
Bchamelkartoffeln
Bchamelsauce
Bchamelsoe
Bret
Brets
Cadillac
Caf
Caf complet
Caf crme
Cafs
Cafs complets
Cafs crme
Caldern
Calderns
Callanetics
Campari
Cames
Canap
Canaps
Carborundum
Castor
Cause clbre
Causes clbres
Cellophane
Cellophanpapier
Cellophan
Centsimo
Centsimos
Chambre spare
Chambres spares
Champs-lyses
Chansonnire
Chansonniren
Charit
Charits
Chartreuse
Chemine
Chemines
Chicore
Chicoren
Chicores
Chteau
Chteaus
Cigny
Cignys
Cinecitt
Cinemascope
Cinerama
Clich
Clichs
Clipper
Cloisonn
Cloisonns
Cloqu
Cloqus
Coca-Cola
Cognac
Coke
Collico
Colt
Commedia dellArte
Communiqu
Communiqus
Comprette
Consomm
Consomms
Cortina dAmpezzo
Coup dEtat
Coups dEtat
Coup
Coups
Craquel
Craquels
Crois
Croiss
Cromargan
Crme frache
Crmes fraches
Crpe
Crpe Georgette
Crpe Satin
Crpe Suzette
Crpe de Chine
Crpe marocain
Crpes
Crpes Georgette
Crpes Georgetten
Crpes Satin
Crpes Suzette
Crpes de Chine
Crpes marocain
Csiks
Csrds
Cur
Curs
Cdiz
Cntimo
Cntimos
Czanne
Czannes
Crdoba
Crdobas
DAX
DDT
DIN
Dauphin
Dekollet
Dekollets
Deux-Pices
Deuxpices
Diolen
Dolby-System
Dralon
Drap
Draps
Duralumin
Dvork
Dvorks
Dj-vu-Erlebnis
Dj-vu-Erlebnisse
Dj-vu-Erlebnissen
Dj-vu-Erlebnisses
Dtente
Dtentepolitik
EC
Eiscaf
Eiscafs
Ekart
Ekartes
Ekarts
El Nio
El Nios
Elektron
Eloxal
Eloxals
Epingl
Epingls
Eternit
Eurocity
Everglaze
Expos
Exposs
Faur
Faurs
Ferrari
Fiat
Fillr
Fillrn
Fillrs
Filtertte
Fin de Sicle
Folies-Bergre
Folies-Bergren
Ford
Formalin
Fouch
Fouchs
Fouqu
Fouqus
Franais fondamental
Franais lmentaire
Franaise
Franaisen
Fraternit
Fraternits
Frauencaf
Frauencafs
Frigidaire
Frisbee
Frisesalat
Frisesalate
Frisesalaten
Frisesalates
Froiss
Froisss
Frott
Frotts
Fum
Fums
Fn
Gameboy
Garon
Garonne
Garonnen
Garonnire
Garonniren
Garons
Gemchte
Gemchtem
Gemchten
Gemchter
Gemchtes
Genve
Genves
Geodreieck
Gervaise
Gervaisen
Gervais
Glac
Glachandschuh
Glachandschuhe
Glachandschuhen
Glachandschuhes
Glacleder
Glacleders
Glacs
Glysantin
Godemich
Godemichs
Godthb
Godthbs
Goldlam
Goldlams
Grammophon
Gruyre
Gruyres
Grge
Grgeseide
Guinness
Gulys
Guttiole
Habitu
Habitus
Halr
Halrs
Hansaplast
Helanca
Helancas
Horvth
Horvths
Hcek
Hceks
ICE
IC
IMAX
IR
Inbus
Indanthren
Indiaca
Insulin
Intercityexpresszug
Intercity
Internetcaf
Internetcafs
Interrailticket
Interregio
Jacuzzis
Jacuzzi
Java
Jeep
Jenaer Glas
Jeunesse dore
Jupiterlampen
Jupiterlampe
Jrme
Jrmes
Kettcar
Klepper
Knirps
Knorr-Bremsen
Knorr-Bremse
Kodak
Kodly
Kodlys
Kommuniqu
Kommuniqus
Kulturattach
Kulturattachs
Klmn
Klmns
Landrover
Leica
Leukoplast
Leuna
Libert, galit, Fraternit
Liebfrauenmilch
Liebig
Linn
Linns
Linotype
Lom
Loms
Lurex
Lysol
Maggi
Maggis
Magnetophon
Makor
Makors
Mallarm
Mallarms
Marineattach
Marineattachs
Martin-Horn
Mares
Matre de Plaisir
Matre de Plaisirs
Melissengeist
Memory
Mercedes-Benz
Metaxa
Mifegyne
Militrattach
Militrattachs
Molire
Moltopren
Monopoly
Monotype
Moulin
Moulins
Moustrien
Moustriens
Mlaga
Mlagas
Mche
Mchen
Mchende
Mchendem
Mchenden
Mchender
Mchendes
Mchens
Mrime
Mnster (Westf.)
Napalm
Neglig
Negligs
Neopren
Nirosta
Nouveaut
Nouveauts
Nylon
Ngritude
Opel
Ottomotor
Ozalid
Panach
Panachs
Pappmach
Pappmachs
Parabellum
Paran
Parans
Pathtique
Pendolino
Pentium
Perlon
Pernod
Playstation
Plexiglas
Porsche
Pour le Mrite
Pour le Mriten
Prcis
Punktalglas
Ratin
Ratins
Ray
Rays
Regenhaut
Renault
Renforc
Renforcs
Ren
Resopal
Rexapparat
Rexglas
Rigipsplatte
Riksml
Riksmls
Rollerblade
Rolls-Royce
Rotaprint
Saint-Exupry
Saint-Exuprys
Saint-Sans
Salvator
San Jos
San Joss
San-Jos-Schildlaus
San-Jos-Schildluse
San-Jos-Schildlusen
Sangrita
Sauce brnaise
Sane
Schuko
Schwedenbombe
Scrabble
Segerkegel
Sekurit
Seor
Seora
Seoras
Seores
Seorita
Seoritas
Seors
Showview
Siemens
Simmering
Sommelire
Souffl
Souffls
Sportcoup
Sportcoups
Stal
Steadicam
Strandcaf
Strandcafs
Straencaf
Straencafs
Styropor
Surez
So
So Tom
So Toms
Sance
Sancen
Srac
Sracs
Svres
Svresporzellan
Svresporzellans
Tabasco
Tanzcaf
Tanzcafs
Teflon
Teletubbies
Tesafilm
Tetralin
Thermit
Thermopane
Thermosflasche
Tipp-Ex
Transrapid
Trevira
Troms
Tromss
Trouvre
Trouvres
Tnder
Tnders
Ufa
VW
Variet
Variets
Vespa
Viagra
Vlieseline
Volkswagen
Walkman
Wankel
Weckapparat
Weckglas
Wellin
Wellins
Wellinss
Westinghousebremse
Whirlpool
Ytong
Yucatn
Yucatns
Zipp
dm
dm
gemcht
gemchte
gemchtem
gemchten
gemchter
gemchtes
km
km
lam
linnsch
linnsche
linnschem
linnschen
linnscher
linnsches
mm
mm
m
m
mche
mchen
mchend
mchende
mchendem
mchenden
mchender
mchendes
mchest
mchet
mchst
mcht
mchte
mchten
mchtest
mchtet
mtallis
oh, l, l
ol
peu  peu
sans gne
skl
tte--tte
tff, tff
voil


landinseln
ngstrm
galit
 condition
 deux mains
 discrtion
 fonds perdu
 gogo
 jour
 la
 la baisse
 la bonne heure
 la carte
 la hausse
 la longue
 la mode
es gibt ja laut
