package WebService::Async::Onfido::Base::Address;

use strict;
use warnings;

use utf8;

our $VERSION = '0.006';    # VERSION

=head1 NAME

WebService::Async::Onfido::Base::Address - represents data for Onfido

=head1 DESCRIPTION

This is autogenerated from the documentation in L<https://documentation.onfido.com>.

=cut

sub new {
    my ($class, %args) = @_;
    Scalar::Util::weaken($args{onfido}) if $args{onfido};
    return bless \%args, $class;
}

=head1 METHODS
=head2 flat_number

The flat number of this address.

=cut

sub flat_number : method { return shift->{flat_number} }

=head2 building_number

The building number of this address.

=cut

sub building_number : method { return shift->{building_number} }

=head2 building_name

The building name of this address.

=cut

sub building_name : method { return shift->{building_name} }

=head2 street

The street of the applicant's address. There is a 32-character limit on this field for UK addresses.

=cut

sub street : method { return shift->{street} }

=head2 sub_street

The sub-street of the applicant's address.

=cut

sub sub_street : method { return shift->{sub_street} }

=head2 town

The town of the applicant's address.

=cut

sub town : method { return shift->{town} }

=head2 state

The address state.  US states must use the USPS abbreviation (see also ISO 3166-2:US), for example AK, CA, or TX..

=cut

## no critic (ProhibitBuiltinHomonyms)
sub state : method { return shift->{state} }

=head2 postcode

The postcode or ZIP of the applicant's address. For UK postcode, specify the value in the following format: SW4 6EH.

=cut

sub postcode : method { return shift->{postcode} }

=head2 country

The 3 character ISO country code of this address. For example, GBR is the country code for the United Kingdom.

=cut

sub country : method { return shift->{country} }

=head2 start_date

The date the applicant started living at this address in yyyy-mm-dd format.

=cut

sub start_date : method { return shift->{start_date} }

=head2 end_date

The date the applicant left this address in yyyy-mm-dd format. If current residence, leave null.

=cut

sub end_date : method { return shift->{end_date} }

1;

__END__

=head1 AUTHOR

deriv.com C<< DERIV@cpan.org >>

=head1 LICENSE

Copyright deriv.com 2019. Licensed under the same terms as Perl itself.

