package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-06-12'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240612.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'KIMOTO' => '',
    'SKIM' => '',
    'ETHER' => '',
    'LNATION' => '',
    'GENE' => '',
    'PLICEASE' => '',
    'HAARG' => '',
    'HANJE' => '',
    'NHORNE' => '',
    'EHUELS' => '',
    'BRIANDFOY' => '',
    'RJBS' => '',
    'WYANT' => '',
    'EXODIST' => '',
    'GBROWN' => '',
    'REEDFISH' => '',
    'CORION' => '',
    'ETJ' => '',
    'KALDOR' => '',
    'LHRST' => '',
    'MARKOV' => '',
    'OALDERS' => '',
    'TVIGNAUD' => '',
    'BINGOS' => '',
    'BRTASTIC' => '',
    'DAMI' => '',
    'GSG' => '',
    'JJATRIA' => '',
    'JV' => '',
    'MARIOROY' => '',
    'PATJOL' => '',
    'PEVANS' => '',
    'PJCJ' => '',
    'SHLOMIF' => '',
    'TIMKA' => '',
    'ASPOSE' => '',
    'BALDUR' => '',
    'BURAK' => '',
    'CADE' => '',
    'CHEVALIER' => '',
    'DCANTRELL' => '',
    'DDRP' => '',
    'DVEEDEN' => '',
    'EXTISM' => '',
    'HIREPLAN' => '',
    'INGY' => '',
    'JAVONET' => '',
    'JONASBN' => '',
    'KARMAN' => '',
    'KIM' => '',
    'LEEJO' => '',
    'MBARBON' => '',
    'MELMOTHX' => '',
    'NLNETLABS' => '',
    'PROCH' => '',
    'SRI' => '',
    'TRIZEN' => '',
    'TURNERJW' => '',
    'VVELOX' => '',
    'YTURTLE' => '',
    'ARFREITAS' => '',
    'CHOROBA' => '',
    'CHRISARG' => '',
    'DBOOK' => '',
    'DERF' => '',
    'FSEITZ' => '',
    'KRYDE' => '',
    'RADIUSCZ' => '',
    'RKELSCH' => '',
    'RWF' => '',
    'SHOGO' => '',
    'TIMLEGGE' => '',
    'TONYC' => '',
    'TYRRMINAL' => '',
    'VOEGELAS' => '',
    'WDAEMS' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240612.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-06-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-06-12, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 512 | 2014-08-24 | ongoing     |
  | KIMOTO    |  21 | 2024-01-21 | ongoing     |
  | SKIM      |  21 | 2024-01-21 | ongoing     |
  | ETHER     |  17 | 2024-02-18 | ongoing     |
  | LNATION   |   6 | 2024-04-28 | might-break |
  | GENE      |   6 | 2024-05-05 | ongoing     |
  | PLICEASE  |   5 | 2024-05-05 | might-break |
  | HAARG     |   5 | 2024-05-12 | ongoing     |
  | HANJE     |   5 | 2024-05-12 | ongoing     |
  | NHORNE    |   5 | 2024-05-12 | ongoing     |
  | EHUELS    |   4 | 2024-05-12 | might-break |
  | BRIANDFOY |   4 | 2024-05-19 | ongoing     |
  | RJBS      |   3 | 2024-05-19 | might-break |
  | WYANT     |   3 | 2024-05-19 | might-break |
  | EXODIST   |   3 | 2024-05-26 | ongoing     |
  | GBROWN    |   3 | 2024-05-26 | ongoing     |
  | REEDFISH  |   3 | 2024-05-26 | ongoing     |
  | CORION    |   2 | 2024-05-26 | might-break |
  | ETJ       |   2 | 2024-05-26 | might-break |
  | KALDOR    |   2 | 2024-05-26 | might-break |
  | LHRST     |   2 | 2024-05-26 | might-break |
  | MARKOV    |   2 | 2024-05-26 | might-break |
  | OALDERS   |   2 | 2024-05-26 | might-break |
  | TVIGNAUD  |   2 | 2024-05-26 | might-break |
  | BINGOS    |   2 | 2024-06-02 | ongoing     |
  | BRTASTIC  |   2 | 2024-06-02 | ongoing     |
  | DAMI      |   2 | 2024-06-02 | ongoing     |
  | GSG       |   2 | 2024-06-02 | ongoing     |
  | JJATRIA   |   2 | 2024-06-02 | ongoing     |
  | JV        |   2 | 2024-06-02 | ongoing     |
  | MARIOROY  |   2 | 2024-06-02 | ongoing     |
  | PATJOL    |   2 | 2024-06-02 | ongoing     |
  | PEVANS    |   2 | 2024-06-02 | ongoing     |
  | PJCJ      |   2 | 2024-06-02 | ongoing     |
  | SHLOMIF   |   2 | 2024-06-02 | ongoing     |
  | TIMKA     |   2 | 2024-06-02 | ongoing     |
  | ASPOSE    |   1 | 2024-06-02 | might-break |
  | BALDUR    |   1 | 2024-06-02 | might-break |
  | BURAK     |   1 | 2024-06-02 | might-break |
  | CADE      |   1 | 2024-06-02 | might-break |
  | CHEVALIER |   1 | 2024-06-02 | might-break |
  | DCANTRELL |   1 | 2024-06-02 | might-break |
  | DDRP      |   1 | 2024-06-02 | might-break |
  | DVEEDEN   |   1 | 2024-06-02 | might-break |
  | EXTISM    |   1 | 2024-06-02 | might-break |
  | HIREPLAN  |   1 | 2024-06-02 | might-break |
  | INGY      |   1 | 2024-06-02 | might-break |
  | JAVONET   |   1 | 2024-06-02 | might-break |
  | JONASBN   |   1 | 2024-06-02 | might-break |
  | KARMAN    |   1 | 2024-06-02 | might-break |
  | KIM       |   1 | 2024-06-02 | might-break |
  | LEEJO     |   1 | 2024-06-02 | might-break |
  | MBARBON   |   1 | 2024-06-02 | might-break |
  | MELMOTHX  |   1 | 2024-06-02 | might-break |
  | NLNETLABS |   1 | 2024-06-02 | might-break |
  | PROCH     |   1 | 2024-06-02 | might-break |
  | SRI       |   1 | 2024-06-02 | might-break |
  | TRIZEN    |   1 | 2024-06-02 | might-break |
  | TURNERJW  |   1 | 2024-06-02 | might-break |
  | VVELOX    |   1 | 2024-06-02 | might-break |
  | YTURTLE   |   1 | 2024-06-02 | might-break |
  | ARFREITAS |   1 | 2024-06-09 | ongoing     |
  | CHOROBA   |   1 | 2024-06-09 | ongoing     |
  | CHRISARG  |   1 | 2024-06-09 | ongoing     |
  | DBOOK     |   1 | 2024-06-09 | ongoing     |
  | DERF      |   1 | 2024-06-09 | ongoing     |
  | FSEITZ    |   1 | 2024-06-09 | ongoing     |
  | KRYDE     |   1 | 2024-06-09 | ongoing     |
  | RADIUSCZ  |   1 | 2024-06-09 | ongoing     |
  | RKELSCH   |   1 | 2024-06-09 | ongoing     |
  | RWF       |   1 | 2024-06-09 | ongoing     |
  | SHOGO     |   1 | 2024-06-09 | ongoing     |
  | TIMLEGGE  |   1 | 2024-06-09 | ongoing     |
  | TONYC     |   1 | 2024-06-09 | ongoing     |
  | TYRRMINAL |   1 | 2024-06-09 | ongoing     |
  | VOEGELAS  |   1 | 2024-06-09 | ongoing     |
  | WDAEMS    |   1 | 2024-06-09 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
