######################################################################
#
# 1041_qr_posixclass.t
#
# Copyright (c) 2020 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# This file is encoded in UTF-8.
die "This file is not encoded in UTF-8.\n" if 'あ' ne "\xe3\x81\x82";
die "This script is for perl only. You are using $^X.\n" if $^X =~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use UTF8::R2;

tie my %r2, 'UTF8::R2';

my %posix_class = (

    '[:alnum:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        30 31 32 33 34 35 36 37 38 39 -- -- -- -- -- -- 
        -- 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A -- -- -- -- -- 
        -- 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A -- -- -- -- -- 
    )],

    '[:alpha:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A -- -- -- -- -- 
        -- 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A -- -- -- -- -- 
    )],

    '[:ascii:]' => [qw(
        00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 
        10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F 
        20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 
        30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 
        40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 
        60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F 
    )],

    '[:blank:]' => [qw(
        -- -- -- -- -- -- -- -- -- 09 -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        20 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
    )],

    '[:cntrl:]' => [qw(
        00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 
        10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 7F 
    )],

    '[:digit:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        30 31 32 33 34 35 36 37 38 39 -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
    )],

    '[:graph:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 
        30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 
        40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 
        60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F 
    )],

    '[:lower:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A -- -- -- -- -- 
    )],

    '[:print:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 
        30 31 32 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 
        40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 
        60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F 
    )],

    '[:punct:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 
        -- -- -- -- -- -- -- -- -- -- 3A 3B 3C 3D 3E 3F 
        40 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- 5B 5C 5D 5E 5F 
        60 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- 7B 7C 7D 7E -- 
    )],

    '[:space:]' => [qw(
        -- -- -- -- -- -- -- -- -- 09 0A 0B 0C 0D -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        20 -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
    )],

    '[:upper:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
    )],

    '[:word:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        30 31 32 33 34 35 36 37 38 39 -- -- -- -- -- -- 
        -- 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 
        50 51 52 53 54 55 56 57 58 59 5A -- -- -- -- 5F 
        -- 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F 
        70 71 72 73 74 75 76 77 78 79 7A -- -- -- -- -- 
    )],

    '[:xdigit:]' => [qw(
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        30 31 32 33 34 35 36 37 38 39 -- -- -- -- -- -- 
        -- 41 42 43 44 45 46 -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
        -- 61 62 63 64 65 66 -- -- -- -- -- -- -- -- -- 
        -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
    )],
);

$| = 1;
print "1..3584\n";

my $t = 1;
for my $posix_class_name (sort keys %posix_class) {
    my %classmate = map { pack('H*',$_) => 1 } grep( ! /--/, @{$posix_class{$posix_class_name}});
    for my $codepoint (map { pack('C',$_) } 0..255) {
        if ($classmate{$codepoint}) {
            if ($codepoint =~ $r2{qr/[$posix_class_name]/}) {
                printf(qq{ok $t - "\\x%s" =~ /[$posix_class_name]/\n}, uc unpack('H*', $codepoint));
            }
            else {
                printf(qq{not ok $t - "\\x%s" =~ /[$posix_class_name]/\n}, uc unpack('H*', $codepoint));
            }
        }
        else {
            if ($codepoint !~ $r2{qr/[$posix_class_name]/}) {
                printf(qq{ok $t - "\\x%s" !~ /[$posix_class_name]/\n}, uc unpack('H*', $codepoint));
            }
            else {
                printf(qq{not ok $t - "\\x%s" !~ /[$posix_class_name]/\n}, uc unpack('H*', $codepoint));
            }
        }
        $t++;
    }
}

__END__
