# Generated by default/object.tt
package Paws::AppRunner::SourceConfiguration;
  use Moose;
  has AuthenticationConfiguration => (is => 'ro', isa => 'Paws::AppRunner::AuthenticationConfiguration');
  has AutoDeploymentsEnabled => (is => 'ro', isa => 'Bool');
  has CodeRepository => (is => 'ro', isa => 'Paws::AppRunner::CodeRepository');
  has ImageRepository => (is => 'ro', isa => 'Paws::AppRunner::ImageRepository');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::SourceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::SourceConfiguration object:

  $service_obj->Method(Att1 => { AuthenticationConfiguration => $value, ..., ImageRepository => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::SourceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthenticationConfiguration

=head1 DESCRIPTION

Describes the source deployed to an AWS App Runner service. It can be a
code or an image repository.

=head1 ATTRIBUTES


=head2 AuthenticationConfiguration => L<Paws::AppRunner::AuthenticationConfiguration>

Describes the resources that are needed to authenticate access to some
source repositories.


=head2 AutoDeploymentsEnabled => Bool

If C<true>, continuous integration from the source repository is
enabled for the App Runner service. Each repository change (source code
commit or new image version) starts a deployment.

Default: C<true>


=head2 CodeRepository => L<Paws::AppRunner::CodeRepository>

The description of a source code repository.

You must provide either this member or C<ImageRepository> (but not
both).


=head2 ImageRepository => L<Paws::AppRunner::ImageRepository>

The description of a source image repository.

You must provide either this member or C<CodeRepository> (but not
both).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

