package Nano::Types;

use 5.014;

use strict;
use warnings;

use Data::Object::Types::Keywords;

use base 'Data::Object::Types::Library';

extends 'Types::Standard';

our $VERSION = '0.01'; # VERSION

register {
  name => 'Nano',
  parent => 'Object',
  validation => is_instance_of('Nano'),
};

register {
  name => 'Node',
  parent => 'Object',
  validation => is_instance_of('Nano::Node'),
};

register {
  name => 'Nodes',
  parent => 'Object',
  validation => is_instance_of('Nano::Nodes'),
};

register {
  name => 'Search',
  parent => 'Object',
  validation => is_instance_of('Nano::Search'),
};

register {
  name => 'Cursor',
  parent => 'Object',
  validation => is_instance_of('Zing::Cursor'),
};

register {
  name => 'Domain',
  parent => 'Object',
  validation => is_instance_of('Zing::Domain'),
};

register {
  name => 'Env',
  parent => 'Object',
  validation => is_instance_of('Zing::Env'),
};

register {
  name => 'Lookup',
  parent => 'Object',
  validation => is_instance_of('Zing::Lookup'),
};

1;

=encoding utf8

=head1 NAME

Nano::Types - Type Library

=cut

=head1 ABSTRACT

Type Library

=cut

=head1 SYNOPSIS

  package main;

  use Nano::Types;

  1;

=cut

=head1 DESCRIPTION

This package provides type constraints for the L<Nano> object persistence
framework.

=cut

=head1 LIBRARIES

This package uses type constraints from:

L<Types::Standard>

=cut

=head1 CONSTRAINTS

This package declares the following type constraints:

=cut

=head2 cursor

  Cursor

This type is defined in the L<Nano::Types> library.

=over 4

=item cursor parent

  Object

=back

=over 4

=item cursor composition

  InstanceOf["Zing::Cursor"]

=back

=over 4

=item cursor example #1

  # given: synopsis

  use Zing::Cursor;
  use Zing::Lookup;

  my $cursor = Zing::Cursor->new(lookup => Zing::Lookup->new(name => 'users'));

=back

=cut

=head2 domain

  Domain

This type is defined in the L<Nano::Types> library.

=over 4

=item domain parent

  Object

=back

=over 4

=item domain composition

  InstanceOf["Zing::Domain"]

=back

=over 4

=item domain example #1

  # given: synopsis

  use Zing::Domain;

  my $domain = Zing::Domain->new(name => 'user-12345');

=back

=cut

=head2 env

  Env

This type is defined in the L<Nano::Types> library.

=over 4

=item env parent

  Object

=back

=over 4

=item env composition

  InstanceOf["Zing::Env"]

=back

=over 4

=item env example #1

  # given: synopsis

  use Zing::Env;

  my $env = Zing::Env->new;

=back

=cut

=head2 lookup

  Lookup

This type is defined in the L<Nano::Types> library.

=over 4

=item lookup parent

  Object

=back

=over 4

=item lookup composition

  InstanceOf["Zing::Lookup"]

=back

=over 4

=item lookup example #1

  # given: synopsis

  use Zing::Lookup;

  my $lookup = Zing::Lookup->new(name => 'users');

=back

=cut

=head2 nano

  Nano

This type is defined in the L<Nano::Types> library.

=over 4

=item nano parent

  Object

=back

=over 4

=item nano composition

  InstanceOf["Nano"]

=back

=over 4

=item nano example #1

  # given: synopsis

  use Nano;

  my $nano = Nano->new;

=back

=cut

=head2 node

  Node

This type is defined in the L<Nano::Types> library.

=over 4

=item node parent

  Object

=back

=over 4

=item node composition

  InstanceOf["Nano::Node"]

=back

=over 4

=item node example #1

  # given: synopsis

  use Nano::Node;

  my $node = Nano::Node->new;

=back

=cut

=head2 nodes

  Nodes

This type is defined in the L<Nano::Types> library.

=over 4

=item nodes parent

  Object

=back

=over 4

=item nodes composition

  InstanceOf["Nano::Nodes"]

=back

=over 4

=item nodes example #1

  # given: synopsis

  use Nano::Nodes;

  my $nodes = Nano::Nodes->new;

=back

=cut

=head2 search

  Search

This type is defined in the L<Nano::Types> library.

=over 4

=item search parent

  Object

=back

=over 4

=item search composition

  InstanceOf["Nano::Search"]

=back

=over 4

=item search example #1

  # given: synopsis

  use Nano::Nodes;
  use Nano::Search;

  my $search = Nano::Search->new(nodes => Nano::Nodes->new);

=back

=cut

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the L<"license
file"|https://github.com/cpanery/nano/blob/master/LICENSE>.

=head1 PROJECT

L<Wiki|https://github.com/cpanery/nano/wiki>

L<Project|https://github.com/cpanery/nano>

L<Initiatives|https://github.com/cpanery/nano/projects>

L<Milestones|https://github.com/cpanery/nano/milestones>

L<Contributing|https://github.com/cpanery/nano/blob/master/CONTRIBUTE.md>

L<Issues|https://github.com/cpanery/nano/issues>

=cut