use Test::More;
use File::Spec;
use File::Temp;
use t::CLI;

#--------------------------------------------------------------------------#
# Get optional test support
#--------------------------------------------------------------------------#

eval "use Test::Differences";
my $HAVE_DIFF = $@ eq '' ? 1 : 0;

sub diff_or_is {
    my ($got, $expected, $label ) = @_;

    if ( $HAVE_DIFF ) {
        eq_or_diff( $got, $expected, $label );
    }
    else {
        is( $got, $expected, $label );
    }
}

#--------------------------------------------------------------------------#
# setup program
#--------------------------------------------------------------------------#

my $script = File::Spec->catfile( "scripts", "wikidoc" );

if ( ! -r $script ) {
    plan skip_all => "because I couldn't find the wikidoc script to test";
}
else {
    plan tests => 6;
}

my $wikidoc = t::CLI->new($script);

#--------------------------------------------------------------------------#
# setup input and expected
#--------------------------------------------------------------------------#

my $input_string = <<'INPUT';
=for wikidoc = Version %%VERSION%%

=cut
INPUT

my $no_define = <<'EXPECTED_NO';
=pod

=head1 Version %%VERSION%%

EXPECTED_NO

my $with_define = <<'EXPECTED_WITH';
=pod

=head1 Version 3.14

EXPECTED_WITH

my $got;

#--------------------------------------------------------------------------#
# wikidoc file file -- no keyword defined
#--------------------------------------------------------------------------#

$wikidoc->stdin( $input_string );
$wikidoc->runs_ok();

$got = $wikidoc->stdout; 
$got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line

diff_or_is( $got, $no_define, 
    "wikidoc script output without a defined keyword" 
);

#--------------------------------------------------------------------------#
# wikidoc file file -- with VERSION keyword defined (-d)
#--------------------------------------------------------------------------#

$wikidoc->stdin( $input_string );
$wikidoc->runs_ok( "-d", "VERSION=3.14" );

$got = $wikidoc->stdout; 
$got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line

diff_or_is( $got, $with_define, 
    "wikidoc script output with a defined keyword" 
);

#--------------------------------------------------------------------------#
# wikidoc file file -- with VERSION keyword defined (--define)
#--------------------------------------------------------------------------#

$wikidoc->stdin( $input_string );
$wikidoc->runs_ok( "--define", "VERSION=3.14" );

$got = $wikidoc->stdout; 
$got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line

diff_or_is( $got, $with_define, 
    "wikidoc script output with a defined keyword" 
);

