#define PERL_NO_GET_CONTEXT // we'll define thread context if necessary (faster)
#include "EXTERN.h"         // globals/constant import locations
#include "perl.h"           // Perl symbols, structures and constants definition
#include "XSUB.h"           // xsubpp functions and macros

#ifndef sv_sethek
#    define sv_sethek(a, b)  Perl_sv_sethek(aTHX_ a, b)
#endif

static SV * _new (SV * class, HV * hash) {
	dTHX;
	if (SvTYPE(class) != SVt_PV) {
		char * name = HvNAME(SvSTASH(SvRV(class)));
		class = newSVpv(name, strlen(name));
	}
	return sv_bless(newRV_noinc((SV*)hash), gv_stashsv(class, 0));
}

char *substr(char const *input, size_t start, size_t len) { 
	dTHX;
	char *ret = malloc(len - start + 1);
	memcpy(ret, input+start, len);
	ret[len - start] = '\0';
	return ret;
}

int find_last( const char *str,  const char word ) {
	dTHX;
	int lastIndex = -1, i = 0;
	for (i = 0; str[i] != '\0'; i++) {
		if (str[i] == word) {
			lastIndex = i;
		}
	}
	return lastIndex;
}

void get_caller_and_method(const char *name, char **callr_out, char **ex_out) {
	dTHX;
	SV * caller = newSV(0);
	HEK * stash_hek = HvNAME_HEK((HV*)CopSTASH(PL_curcop));
	sv_sethek(caller, stash_hek);
	STRLEN retlen;
	char * callr = SvPV(caller, retlen);
	*callr_out = strdup(callr);
	size_t ex_len = strlen(name) + 2 + retlen;
	*ex_out = malloc(ex_len + 1);
	sprintf(*ex_out, "%s::%s", callr, name);
	SvREFCNT_dec(caller);
}

void get_class_and_method(SV *cv_name_sv, char **class_out, char **method_out) {
	dTHX;
	STRLEN len;
	char *full = SvPV(cv_name_sv, len);
	int idx = find_last(full, ':');
	if (idx == -1 || idx < 1) {
		*class_out = strdup("");
		*method_out = strdup(full);
		return;
	}
	// Find the last '::'
	int sep = idx;
	if (sep > 0 && full[sep-1] == ':') sep--;
	*class_out = substr(full, 0, sep);
	*method_out = substr(full, idx+1, len);
}

HV * get_metadata(const char *class) {
	dTHX;
	char meta[strlen(class) + 10];
	sprintf(meta, "%s::METADATA", class);
	return get_hv(meta, GV_ADD);
}

MODULE = Meow  PACKAGE = Meow
PROTOTYPES: ENABLE

SV *
new(pkg, ...)
	SV * pkg
	CODE:
		HV * args;
		if (items > 2) {
			if ((items - 1) % 2 != 0) {
				croak("Odd number of elements in hash assignment");
			}
			args = newHV();
			int i = 1;
			for (i = 1; i < items; i += 2) {
				STRLEN retlen;
				char * key = SvPV(ST(i), retlen);
				SV * value = newSVsv(ST(i + 1));
				hv_store(args, key, retlen, value, 0);
			}
		} else {
			if (! SvOK(ST(1))) {
				args = newHV();
			} else if (! SvROK(ST(1)) || SvTYPE(SvRV(ST(1))) != SVt_PVHV) {
				croak("Not a hash assignment");
			} else {
				args = (HV*)SvRV(newSVsv(ST(1)));
			}
		}

		char * class;
		if (SvTYPE(pkg) != SVt_PV) {
			class = HvNAME(SvSTASH(SvRV(pkg)));
		} else {
			STRLEN retlen;
 			class = SvPV(pkg, retlen);
		}

		HV * right = get_metadata(class);
		
		HE * entry;
		(void)hv_iterinit(args);
		while ((entry = hv_iternext(args)))  {
			STRLEN retlen;
			char * key =  SvPV(hv_iterkeysv(entry), retlen);
			SV * value = *hv_fetch(args, key, retlen, 0);

			if ( hv_exists(right, key, retlen) ) {
				HV * spec = (HV*)SvRV(newSVsv(*hv_fetch(right, key, retlen, 0)));
				if (hv_exists(spec, "isa", 3)) {
					SV * sv = *hv_fetch(spec, "isa", 3, 0);
					dSP;
					PUSHMARK(SP);
					XPUSHs(newSVsv(value));
					PUTBACK;
					call_sv(sv, G_SCALAR);
					SPAGAIN;
					value = POPs;
					PUTBACK;
				}
			}

			hv_store(args, key, retlen, value, 0);
		}

		RETVAL = _new(newSVsv(ST(0)), args);
	OUTPUT:
		RETVAL

SV *
attribute(...)
	CODE:
		char *class = NULL, *method = NULL;
		get_class_and_method((SV*)cv_name((CV*)ST(items), 0, 0), &class, &method);
		if (class == NULL || method == NULL) {
			croak("Invalid class or method name");
		}
		HV * right = get_metadata(class);
		if (!hv_exists(right, method, strlen(method))) {
			croak("Method '%s' not found in class '%s'", method, class);
		}

		HV * spec = (HV*)SvRV(newSVsv(*hv_fetch(right, method, strlen(method), 0)));
		HV * self = (HV*)SvRV(ST(0));
		SV * val;
		if (items > 1) {
			if (hv_exists(spec, "isa", 3)) {
				SV * sv = *hv_fetch(spec, "isa", 3, 0);
				dSP;
				PUSHMARK(SP);
				XPUSHs(newSVsv(ST(1)));
				PUTBACK;
				call_sv(sv, G_SCALAR);
				SPAGAIN;
				ST(1) = POPs;
				PUTBACK;
			}
			val = newSVsv(ST(1));
			hv_store(self, method, strlen(method), newSVsv(val), 0);
		} else {
			val = newSVsv(hv_exists(self, method, strlen(method)) ? *hv_fetch(self, method, strlen(method), 0) : NULL);
		}

		RETVAL = val;
		free(class);
		free(method);
	OUTPUT:
		RETVAL

SV *
rw(name, attr)
	char * name
	SV * attr
	CODE:
		char *callr = NULL, *ex = NULL;
		get_caller_and_method(name, &callr, &ex);

		if (!SvROK(attr)) {
			attr = newRV_noinc((SV*)newHV());
		} else {
			SV * rv = SvRV(attr);

			if (SvTYPE(rv) != SVt_PVHV || ! hv_exists((HV*)rv, "isa", 3)) {
				HV * n = newHV();
				hv_store(n, "isa", 3, newSVsv(attr), 0);
				attr = newRV_noinc((SV*)n);
			}
		}

		HV * right = get_metadata(callr);
		hv_store(right, name, strlen(name), newSVsv(attr), 0);
		CV * cv = newXS(ex, XS_Meow_attribute, __FILE__);

		free(callr);
		free(ex);
		RETVAL = newSViv(1);
	OUTPUT:
		RETVAL

void
import(pkg, ...)
	char * pkg
	CODE:
		char *callr = NULL, *method = NULL;
		get_caller_and_method(pkg, &callr, &method);
		char * export[] = { "new", "rw" };
		int i = 0;
		for (i = 0; i < 2; i++) {
			char * ex = export[i];
	    		char name [strlen(callr) + 2 + strlen(ex)];
			sprintf(name, "%s::%s", callr, ex);
			if (strcmp(ex, "new") == 0) {
				newXS(name, XS_Meow_new, __FILE__);
			} else if (strcmp(ex, "rw") == 0) {
				newXS(name, XS_Meow_rw, __FILE__);
			}
		}
		free(callr);
		free(method);
