/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.xmp.convert;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.xmp.convert.AbstractConverter;
import org.apache.tika.xmp.convert.Namespace;

public class MSOfficeBinaryConverter
extends AbstractConverter {
    protected static final Set<Namespace> ADDITIONAL_NAMESPACES = Collections.unmodifiableSet(new HashSet<Namespace>(Arrays.asList(new Namespace("http://schemas.openxmlformats.org/package/2006/metadata/core-properties/", "cp"), new Namespace("http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "extended-properties"))));

    @Override
    public XMPMeta process(Metadata metadata) throws XMPException {
        super.setMetadata(metadata);
        this.createProperty("Content-Type", "http://purl.org/dc/elements/1.1/", "format");
        this.createProperty(OfficeOpenXMLExtended.APPLICATION, "http://ns.adobe.com/xap/1.0/", "CreatorTool");
        this.createCommaSeparatedArray(TikaCoreProperties.CREATOR, "http://purl.org/dc/elements/1.1/", "creator", 1024);
        this.createProperty(OfficeOpenXMLCore.CATEGORY, "http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "intellectualGenre");
        this.createProperty(TikaCoreProperties.CREATED, "http://ns.adobe.com/xap/1.0/", "CreateDate");
        this.createProperty(Office.CHARACTER_COUNT, "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "Characters");
        this.createProperty(TikaCoreProperties.COMMENTS, "http://ns.adobe.com/pdfx/1.3/", "Comments");
        this.createProperty(OfficeOpenXMLExtended.COMPANY, "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "Company");
        this.createCommaSeparatedArray(TikaCoreProperties.KEYWORDS, "http://purl.org/dc/elements/1.1/", "subject", 512);
        this.createLangAltProperty(TikaCoreProperties.DESCRIPTION, "http://purl.org/dc/elements/1.1/", "description");
        this.createProperty(TikaCoreProperties.LANGUAGE, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties/", "language");
        this.createProperty(TikaCoreProperties.PRINT_DATE, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties/", "lastPrinted");
        this.createProperty(TikaCoreProperties.MODIFIED, "http://ns.adobe.com/xap/1.0/", "ModifyDate");
        this.createProperty(Office.PAGE_COUNT, "http://ns.adobe.com/xap/1.0/t/pg/", "NPages");
        this.createProperty(OfficeOpenXMLCore.REVISION, "http://schemas.openxmlformats.org/package/2006/metadata/core-properties/", "revision");
        this.createProperty(Office.SLIDE_COUNT, "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "Pages");
        this.createProperty(OfficeOpenXMLExtended.TEMPLATE, "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "Template");
        this.createLangAltProperty(TikaCoreProperties.TITLE, "http://purl.org/dc/elements/1.1/", "title");
        this.createProperty(Office.WORD_COUNT, "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/", "Words");
        return super.getXMPMeta();
    }

    @Override
    protected Set<Namespace> getAdditionalNamespaces() {
        return ADDITIONAL_NAMESPACES;
    }
}

