/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.apache.tika.langdetect.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/language")
public class LanguageResource {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageResource.class);

    @PUT
    @POST
    @Path(value="/stream")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String detect(InputStream is) throws IOException {
        String fileTxt = IOUtils.toString(is, StandardCharsets.UTF_8);
        LanguageResult language = new OptimaizeLangDetector().loadModels().detect(fileTxt);
        String detectedLang = language.getLanguage();
        LOG.info("Detecting language for incoming resource: [{}]", (Object)detectedLang);
        return detectedLang;
    }

    @PUT
    @POST
    @Path(value="/string")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String detect(String string) throws IOException {
        LanguageResult language = new OptimaizeLangDetector().loadModels().detect(string);
        String detectedLang = language.getLanguage();
        LOG.info("Detecting language for incoming resource: [{}]", (Object)detectedLang);
        return detectedLang;
    }
}

