/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.openxml4j.util.ZipFileZipEntrySource;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.iwork.iwana.IWork13PackageParser;
import org.apache.tika.parser.pkg.CompressorParser;
import org.apache.tika.parser.pkg.PackageParser;

public class ZipContainerDetector
implements Detector {
    private static final MediaType TIFF = MediaType.image("tiff");
    private static final byte[][] TIFF_SIGNATURES = new byte[3][];
    private static final Pattern MACRO_TEMPLATE_PATTERN;
    private static final String VISIO_DOCUMENT = "http://schemas.microsoft.com/visio/2010/relationships/document";
    private static final String STRICT_CORE_DOCUMENT = "http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument";
    private static final String XPS_DOCUMENT = "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation";
    private static final long serialVersionUID = 2891763938430295453L;
    private static HashSet<Pattern> ipaEntryPatterns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get(input, tmp);
            byte[] prefix = new byte[1024];
            int length = tis.peek(prefix);
            MediaType type = ZipContainerDetector.detectArchiveFormat(prefix, length);
            if (type == TIFF) {
                MediaType mediaType = TIFF;
                return mediaType;
            }
            if (PackageParser.isZipArchive(type) && TikaInputStream.isTikaInputStream(input)) {
                MediaType mediaType = ZipContainerDetector.detectZipFormat(tis);
                return mediaType;
            }
            if (!type.equals(MediaType.OCTET_STREAM)) {
                MediaType mediaType = type;
                return mediaType;
            }
            MediaType mediaType = ZipContainerDetector.detectCompressorFormat(prefix, length);
            return mediaType;
        }
        finally {
            try {
                tmp.dispose();
            }
            catch (TikaException tikaException) {}
        }
    }

    private static MediaType detectCompressorFormat(byte[] prefix, int length) {
        try {
            String type = CompressorStreamFactory.detect(new ByteArrayInputStream(prefix, 0, length));
            return CompressorParser.getMediaType(type);
        }
        catch (CompressorException e) {
            return MediaType.OCTET_STREAM;
        }
    }

    private static boolean isTiff(byte[] prefix) {
        for (byte[] sig : TIFF_SIGNATURES) {
            if (!ZipContainerDetector.arrayStartWith(sig, prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean arrayStartWith(byte[] needle, byte[] haystack) {
        if (haystack.length < needle.length) {
            return false;
        }
        for (int i = 0; i < needle.length; ++i) {
            if (haystack[i] == needle[i]) continue;
            return false;
        }
        return true;
    }

    private static MediaType detectArchiveFormat(byte[] prefix, int length) {
        if (ZipContainerDetector.isTiff(prefix)) {
            return TIFF;
        }
        try {
            String name = ArchiveStreamFactory.detect(new ByteArrayInputStream(prefix, 0, length));
            return PackageParser.getMediaType(name);
        }
        catch (ArchiveException e) {
            return MediaType.OCTET_STREAM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MediaType detectZipFormat(TikaInputStream tis) {
        try {
            MediaType type = ZipContainerDetector.detectOPCBased(tis);
            if (type != null) {
                return type;
            }
            ZipFile zip = new ZipFile(tis.getFile());
            try {
                type = ZipContainerDetector.detectOpenDocument(zip);
                if (type == null) {
                    type = ZipContainerDetector.detectIWork13(zip);
                }
                if (type == null) {
                    type = ZipContainerDetector.detectIWork(zip);
                }
                if (type == null) {
                    type = ZipContainerDetector.detectJar(zip);
                }
                if (type == null) {
                    type = ZipContainerDetector.detectKmz(zip);
                }
                if (type == null) {
                    type = ZipContainerDetector.detectIpa(zip);
                }
                if (type == null) return MediaType.APPLICATION_ZIP;
                MediaType mediaType = type;
                return mediaType;
            }
            finally {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return MediaType.APPLICATION_ZIP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MediaType detectOpenDocument(ZipFile zip) {
        try {
            ZipArchiveEntry mimetype = zip.getEntry("mimetype");
            if (mimetype == null) return null;
            try (InputStream stream = zip.getInputStream(mimetype);){
                MediaType mediaType = MediaType.parse(IOUtils.toString(stream, StandardCharsets.UTF_8));
                return mediaType;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static MediaType detectOPCBased(TikaInputStream stream) {
        ZipFileZipEntrySource zipEntrySource = null;
        try {
            zipEntrySource = new ZipFileZipEntrySource(new ZipFile(stream.getFile()));
        }
        catch (IOException e) {
            return null;
        }
        OPCPackage pkg = null;
        try {
            pkg = OPCPackage.open(zipEntrySource);
        }
        catch (SecurityException e) {
            ZipContainerDetector.closeQuietly(zipEntrySource);
            throw e;
        }
        catch (RuntimeException | InvalidFormatException e) {
            ZipContainerDetector.closeQuietly(zipEntrySource);
            return null;
        }
        MediaType type = null;
        try {
            type = ZipContainerDetector.detectOfficeOpenXML(pkg);
            if (type == null) {
                type = ZipContainerDetector.detectXPSOPC(pkg);
            }
            if (type == null) {
                type = ZipContainerDetector.detectAutoCADOPC(pkg);
            }
        }
        catch (SecurityException e) {
            ZipContainerDetector.closeQuietly(zipEntrySource);
            throw e;
        }
        catch (RuntimeException e) {
            ZipContainerDetector.closeQuietly(zipEntrySource);
            return null;
        }
        stream.setOpenContainer(pkg);
        return type;
    }

    private static void closeQuietly(ZipEntrySource zipEntrySource) {
        if (zipEntrySource == null) {
            return;
        }
        try {
            zipEntrySource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static MediaType detectOfficeOpenXML(OPCPackage pkg) {
        PackageRelationshipCollection core = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (core.size() == 0) {
            core = pkg.getRelationshipsByType(STRICT_CORE_DOCUMENT);
        }
        if (core.size() == 0) {
            core = pkg.getRelationshipsByType(VISIO_DOCUMENT);
        }
        if (core.size() != 1) {
            return null;
        }
        PackagePart corePart = pkg.getPart(core.getRelationship(0));
        String coreType = corePart.getContentType();
        if (coreType.contains(".xps")) {
            return MediaType.application("vnd.ms-package.xps");
        }
        String docType = coreType.substring(0, coreType.lastIndexOf(46));
        if (docType.toLowerCase(Locale.ROOT).endsWith("macroenabled")) {
            docType = docType.toLowerCase(Locale.ROOT) + ".12";
        }
        if (docType.toLowerCase(Locale.ROOT).endsWith("macroenabledtemplate")) {
            docType = MACRO_TEMPLATE_PATTERN.matcher(docType).replaceAll("macroenabled.12");
        }
        return MediaType.parse(docType);
    }

    public static MediaType detectXPSOPC(OPCPackage pkg) {
        PackageRelationshipCollection xps = pkg.getRelationshipsByType(XPS_DOCUMENT);
        if (xps.size() == 1) {
            return MediaType.application("vnd.ms-xpsdocument");
        }
        return null;
    }

    private static MediaType detectAutoCADOPC(OPCPackage pkg) {
        PackageRelationshipCollection dwfxSeq = pkg.getRelationshipsByType("http://schemas.autodesk.com/dwfx/2007/relationships/documentsequence");
        if (dwfxSeq.size() == 1) {
            return MediaType.parse("model/vnd.dwfx+xps");
        }
        return null;
    }

    private static MediaType detectIWork13(ZipFile zip) {
        if (zip.getEntry("Metadata/BuildVersionHistory.plist") != null) {
            return IWork13PackageParser.IWork13DocumentType.detect(zip);
        }
        return null;
    }

    private static MediaType detectIWork(ZipFile zip) {
        if (zip.getEntry("buildVersionHistory.plist") != null) {
            for (String entryName : IWorkPackageParser.IWORK_CONTENT_ENTRIES) {
                IWorkPackageParser.IWORKDocumentType type = IWorkPackageParser.IWORKDocumentType.detectType(zip.getEntry(entryName), zip);
                if (type == null) continue;
                return type.getType();
            }
            return MediaType.application("vnd.apple.iwork");
        }
        return null;
    }

    private static MediaType detectJar(ZipFile zip) {
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            if (zip.getEntry("AndroidManifest.xml") != null) {
                return MediaType.application("vnd.android.package-archive");
            }
            if (zip.getEntry("WEB-INF/") != null) {
                return MediaType.application("x-tika-java-web-archive");
            }
            if (zip.getEntry("META-INF/application.xml") != null) {
                return MediaType.application("x-tika-java-enterprise-archive");
            }
            return MediaType.application("java-archive");
        }
        if (zip.getEntry("AndroidManifest.xml") != null) {
            return MediaType.application("vnd.android.package-archive");
        }
        return null;
    }

    private static MediaType detectKmz(ZipFile zip) {
        boolean kmlFound = false;
        Enumeration<ZipArchiveEntry> entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || name.indexOf(47) != -1 || name.indexOf(92) != -1) continue;
            if (name.endsWith(".kml") && !kmlFound) {
                kmlFound = true;
                continue;
            }
            return null;
        }
        if (kmlFound) {
            return MediaType.application("vnd.google-earth.kmz");
        }
        return null;
    }

    private static MediaType detectIpa(ZipFile zip) {
        Set tmpPatterns = (Set)ipaEntryPatterns.clone();
        Enumeration<ZipArchiveEntry> entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            String name = entry.getName();
            Iterator ip = tmpPatterns.iterator();
            while (ip.hasNext()) {
                if (!((Pattern)ip.next()).matcher(name).matches()) continue;
                ip.remove();
            }
            if (!tmpPatterns.isEmpty()) continue;
            return MediaType.application("x-itunes-ipa");
        }
        return null;
    }

    static {
        ZipContainerDetector.TIFF_SIGNATURES[0] = new byte[]{77, 77, 0, 42};
        ZipContainerDetector.TIFF_SIGNATURES[1] = new byte[]{73, 73, 42, 0};
        ZipContainerDetector.TIFF_SIGNATURES[2] = new byte[]{77, 77, 0, 43};
        MACRO_TEMPLATE_PATTERN = Pattern.compile("macroenabledtemplate$", 2);
        ipaEntryPatterns = new HashSet<Pattern>(){
            private static final long serialVersionUID = 6545295886322115362L;
            {
                this.add(Pattern.compile("^Payload/$"));
                this.add(Pattern.compile("^Payload/.*\\.app/$"));
                this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/$"));
                this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/CodeResources$"));
                this.add(Pattern.compile("^Payload/.*\\.app/Info\\.plist$"));
                this.add(Pattern.compile("^Payload/.*\\.app/PkgInfo$"));
            }
        };
    }
}

