/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk8.BinaryOperator;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="EX_Extent_Type", propOrder={"description", "geographicElements", "temporalElements", "verticalElements"})
@XmlRootElement(name="EX_Extent")
public class DefaultExtent
extends ISOMetadata
implements Extent {
    private static final long serialVersionUID = 2979058128422252800L;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<VerticalExtent> verticalElements;
    private Collection<TemporalExtent> temporalElements;

    public DefaultExtent() {
    }

    public DefaultExtent(CharSequence charSequence, GeographicExtent geographicExtent, VerticalExtent verticalExtent, TemporalExtent temporalExtent) {
        this.description = Types.toInternationalString(charSequence);
        this.geographicElements = this.singleton(geographicExtent, GeographicExtent.class);
        this.verticalElements = this.singleton(verticalExtent, VerticalExtent.class);
        this.temporalElements = this.singleton(temporalExtent, TemporalExtent.class);
    }

    public DefaultExtent(Extent extent) {
        super(extent);
        if (extent != null) {
            this.description = extent.getDescription();
            this.geographicElements = this.copyCollection(extent.getGeographicElements(), GeographicExtent.class);
            this.temporalElements = this.copyCollection(extent.getTemporalElements(), TemporalExtent.class);
            this.verticalElements = this.copyCollection(extent.getVerticalElements(), VerticalExtent.class);
        }
    }

    public static DefaultExtent castOrCopy(Extent extent) {
        if (extent == null || extent instanceof DefaultExtent) {
            return (DefaultExtent)extent;
        }
        return new DefaultExtent(extent);
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="geographicElement")
    public Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public void setGeographicElements(Collection<? extends GeographicExtent> collection) {
        this.geographicElements = this.writeCollection(collection, this.geographicElements, GeographicExtent.class);
    }

    @XmlElement(name="verticalElement")
    public Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public void setVerticalElements(Collection<? extends VerticalExtent> collection) {
        this.verticalElements = this.writeCollection(collection, this.verticalElements, VerticalExtent.class);
    }

    @XmlElement(name="temporalElement")
    public Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public void setTemporalElements(Collection<? extends TemporalExtent> collection) {
        this.temporalElements = this.writeCollection(collection, this.temporalElements, TemporalExtent.class);
    }

    public void addElements(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull("envelope", envelope);
        ReferencingServices.getInstance().addElements(envelope, this);
    }

    public void intersect(Extent extent) {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull("other", extent);
        InternationalString internationalString = extent.getDescription();
        if (internationalString != null && !(this.description instanceof NilObject)) {
            if (this.description == null || internationalString instanceof NilObject) {
                this.description = internationalString;
            } else if (!this.description.equals(internationalString)) {
                this.description = NilReason.MISSING.createNilObject(InternationalString.class);
            }
        }
        this.geographicElements = this.intersect(GeographicExtent.class, this.geographicElements, extent.getGeographicElements(), new BinaryOperator<GeographicExtent>(){

            @Override
            public GeographicExtent apply(GeographicExtent geographicExtent, GeographicExtent geographicExtent2) {
                return Extents.intersection(geographicExtent, geographicExtent2);
            }
        });
        this.verticalElements = this.intersect(VerticalExtent.class, this.verticalElements, extent.getVerticalElements(), new BinaryOperator<VerticalExtent>(){

            @Override
            public VerticalExtent apply(VerticalExtent verticalExtent, VerticalExtent verticalExtent2) {
                return Extents.intersection(verticalExtent, verticalExtent2);
            }
        });
        this.temporalElements = this.intersect(TemporalExtent.class, this.temporalElements, extent.getTemporalElements(), new BinaryOperator<TemporalExtent>(){

            @Override
            public TemporalExtent apply(TemporalExtent temporalExtent, TemporalExtent temporalExtent2) {
                return Extents.intersection(temporalExtent, temporalExtent2);
            }
        });
    }

    private <T> Collection<T> intersect(Class<T> clazz, Collection<T> collection, Collection<? extends T> collection2, BinaryOperator<T> binaryOperator) {
        if (!Containers.isNullOrEmpty(collection2)) {
            if (!Containers.isNullOrEmpty(collection)) {
                LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(Containers.hashMapCapacity(collection.size()));
                Object var6_6 = null;
                for (Object object : collection) {
                    for (T t : collection2) {
                        Object r = binaryOperator.apply(object, t);
                        linkedHashSet.add(r);
                        if (var6_6 != null || r == t || r == object || !(r instanceof AbstractMetadata) || !((AbstractMetadata)r).isEmpty()) continue;
                        var6_6 = r;
                    }
                }
                linkedHashSet.remove(null);
                if (linkedHashSet.size() > 1) {
                    linkedHashSet.remove(var6_6);
                }
                collection2 = linkedHashSet;
            }
            collection = this.writeCollection(collection2, collection, clazz);
        }
        return collection;
    }
}

