/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;

public final class DoubleDouble
extends Number {
    private static final long serialVersionUID = -7602414219228638550L;
    public static final boolean DISABLED = false;
    private static final int ZERO_THRESHOLD = 2;
    private static final double SPLIT = 1.34217729E8;
    public static final double MAX_VALUE = 1.3393857490036326E300;
    private static final double[] VALUES = new double[]{4.84813681109536E-6, 2.777777777777778E-4, 0.002777777777777778, 0.016666666666666666, Math.PI / 180, 0.7853981633974483, 1.1111111111111112, 1.4142135623730951, 1.5707963267948966, 2.356194490192345, Math.PI, Math.PI * 2, 57.29577951308232};
    private static final double[] ERRORS = new double[]{9.320078015422868E-23, 2.4093381610788987E-22, -1.0601087908747154E-19, 2.312964634635743E-19, 2.9486522708701687E-19, 3.061616997868383E-17, -4.9343245538895844E-17, -9.667293313452913E-17, 6.123233995736766E-17, 9.184850993605148E-17, 1.2246467991473532E-16, 2.4492935982947064E-16, -1.9878495670576283E-15};
    public double value;
    public double error;

    public DoubleDouble() {
    }

    public DoubleDouble(DoubleDouble doubleDouble) {
        this.value = doubleDouble.value;
        this.error = doubleDouble.error;
    }

    public DoubleDouble(Number number) {
        if (number instanceof Fraction) {
            this.value = ((Fraction)number).denominator;
            this.inverseDivide(((Fraction)number).numerator, 0.0);
        } else {
            if (number instanceof BigInteger) {
                number = new BigDecimal((BigInteger)number, MathContext.DECIMAL128);
            }
            this.value = number.doubleValue();
            this.error = number instanceof DoubleDouble ? ((DoubleDouble)number).error : (number instanceof BigDecimal ? ((BigDecimal)number).subtract(new BigDecimal(this.value), MathContext.DECIMAL64).doubleValue() : DoubleDouble.errorForWellKnownValue(this.value));
        }
    }

    public static boolean shouldConvert(Number number) {
        return number instanceof Fraction || number instanceof BigInteger || number instanceof BigDecimal;
    }

    public DoubleDouble(double d) {
        this.value = d;
        this.error = DoubleDouble.errorForWellKnownValue(d);
    }

    public DoubleDouble(double d, double d2) {
        this.value = d;
        this.error = d2;
        assert (!(Math.abs(d2) >= Math.ulp(d))) : this;
    }

    public static DoubleDouble castOrCopy(Number number) {
        return number == null || number instanceof DoubleDouble ? (DoubleDouble)number : new DoubleDouble(number);
    }

    public static DoubleDouble verbatim(double d) {
        return new DoubleDouble(d, 0.0);
    }

    public static DoubleDouble createRadiansToDegrees() {
        return new DoubleDouble(57.29577951308232, -1.9878495670576283E-15);
    }

    public static DoubleDouble createDegreesToRadians() {
        return new DoubleDouble(Math.PI / 180, 2.9486522708701687E-19);
    }

    public static DoubleDouble createSecondsToRadians() {
        return new DoubleDouble(4.84813681109536E-6, 9.320078015422868E-23);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return Math.round(this.value);
    }

    @Override
    public int intValue() {
        return JDK8.toIntExact(this.longValue());
    }

    public static double errorForWellKnownValue(double d) {
        int n = Arrays.binarySearch(VALUES, Math.abs(d));
        if (n >= 0) {
            return MathFunctions.xorSign(ERRORS[n], d);
        }
        double d2 = DecimalFunctions.deltaForDoubleToDecimal(d);
        return Double.isNaN(d2) ? 0.0 : d2;
    }

    public boolean isZero() {
        return this.value == 0.0 && this.error == 0.0;
    }

    public void clear() {
        this.value = 0.0;
        this.error = 0.0;
    }

    public void setFrom(DoubleDouble doubleDouble) {
        this.value = doubleDouble.value;
        this.error = doubleDouble.error;
    }

    public void setFrom(double[] dArray, int n, int n2) {
        this.value = dArray[n];
        this.error = dArray[n + n2];
    }

    final void normalize() {
        this.error += this.value - (this.value += this.error);
    }

    public void setToQuickSum(double d, double d2) {
        this.value = d + d2;
        this.error = d2 - (this.value - d);
    }

    public void setToSum(double d, double d2) {
        this.value = d + d2;
        double d3 = this.value - d;
        this.error = d - (this.value - d3) + (d2 - d3);
    }

    public void setToProduct(double d, double d2) {
        this.value = d * d2;
        double d3 = 1.34217729E8 * d;
        double d4 = d3 - (d3 - d);
        double d5 = d - d4;
        d3 = 1.34217729E8 * d2;
        double d6 = d3 - (d3 - d2);
        double d7 = d2 - d6;
        this.error = d4 * d6 - this.value + d4 * d7 + d5 * d6 + d5 * d7;
    }

    public void storeTo(double[] dArray, int n, int n2) {
        dArray[n] = this.value;
        dArray[n + n2] = this.error;
    }

    public static void swap(double[] dArray, int n, int n2, int n3) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
        d = dArray[n += n3];
        dArray[n] = dArray[n2 += n3];
        dArray[n2] = d;
    }

    public void negate() {
        this.value = -this.value;
        this.error = -this.error;
    }

    public void add(DoubleDouble doubleDouble) {
        this.add(doubleDouble.value, doubleDouble.error);
    }

    public void add(Number number) {
        if (number instanceof DoubleDouble) {
            this.add((DoubleDouble)number);
        } else if (DoubleDouble.shouldConvert(number)) {
            this.add(new DoubleDouble(number));
        } else {
            this.add(number.doubleValue());
        }
    }

    public void add(double d) {
        this.add(d, DoubleDouble.errorForWellKnownValue(d));
    }

    public void add(double d, double d2) {
        double d3 = this.value;
        this.value += d;
        this.error += d3 - (this.value + (d3 -= this.value)) + (d + d3);
        this.error += d2;
        if (this.value == 0.0 && this.error != 0.0 && Math.abs(this.error) <= Math.scalb(Math.ulp(d), -50)) {
            this.error = 0.0;
            return;
        }
        this.normalize();
    }

    public void add(double[] dArray, int n, int n2) {
        this.add(dArray[n], dArray[n + n2]);
    }

    public void subtract(DoubleDouble doubleDouble) {
        this.subtract(doubleDouble.value, doubleDouble.error);
    }

    public void subtract(Number number) {
        if (number instanceof DoubleDouble) {
            this.subtract((DoubleDouble)number);
        } else if (DoubleDouble.shouldConvert(number)) {
            this.subtract(new DoubleDouble(number));
        } else {
            this.subtract(number.doubleValue());
        }
    }

    public void subtract(double d) {
        this.subtract(d, DoubleDouble.errorForWellKnownValue(d));
    }

    public void subtract(double d, double d2) {
        this.add(-d, -d2);
    }

    public void subtract(double[] dArray, int n, int n2) {
        this.subtract(dArray[n], dArray[n + n2]);
    }

    public void multiply(DoubleDouble doubleDouble) {
        this.multiply(doubleDouble.value, doubleDouble.error);
    }

    public void multiply(Number number) {
        if (number instanceof DoubleDouble) {
            this.multiply((DoubleDouble)number);
        } else if (DoubleDouble.shouldConvert(number)) {
            this.multiply(new DoubleDouble(number));
        } else {
            this.multiply(number.doubleValue());
        }
    }

    public void multiply(double d) {
        this.multiply(d, DoubleDouble.errorForWellKnownValue(d));
    }

    public void multiply(double d, double d2) {
        double d3 = this.value;
        double d4 = this.error;
        this.setToProduct(d3, d);
        this.error += d2 * d3;
        this.error += d * d4;
        this.normalize();
    }

    public void multiply(double[] dArray, int n, int n2) {
        this.multiply(dArray[n], dArray[n + n2]);
    }

    public void divide(DoubleDouble doubleDouble) {
        this.divide(doubleDouble.value, doubleDouble.error);
    }

    public void divide(Number number) {
        if (number instanceof DoubleDouble) {
            this.divide((DoubleDouble)number);
        } else if (DoubleDouble.shouldConvert(number)) {
            this.divide(new DoubleDouble(number));
        } else {
            this.divide(number.doubleValue());
        }
    }

    public void divide(double d) {
        this.divide(d, DoubleDouble.errorForWellKnownValue(d));
    }

    public void divide(double d, double d2) {
        double d3 = this.value;
        double d4 = this.error;
        this.value = d;
        this.error = d2;
        this.inverseDivide(d3, d4);
    }

    public void divide(double[] dArray, int n, int n2) {
        this.divide(dArray[n], dArray[n + n2]);
    }

    public void inverseDivide(DoubleDouble doubleDouble) {
        this.inverseDivide(doubleDouble.value, doubleDouble.error);
    }

    public void inverseDivide(Number number) {
        if (number instanceof DoubleDouble) {
            this.inverseDivide((DoubleDouble)number);
        } else if (DoubleDouble.shouldConvert(number)) {
            this.inverseDivide(new DoubleDouble(number));
        } else {
            this.inverseDivide(number.doubleValue());
        }
    }

    public void inverseDivide(double d) {
        this.inverseDivide(d, DoubleDouble.errorForWellKnownValue(d));
    }

    public void inverseDivide(double d, double d2) {
        double d3 = this.value;
        double d4 = d / d3;
        this.multiply(d4, 0.0);
        double d5 = this.error;
        this.setToSum(d, -this.value);
        this.error -= d5;
        this.error += d2;
        this.setToQuickSum(d4, (this.value + this.error) / d3);
    }

    public void inverseDivide(double[] dArray, int n, int n2) {
        this.inverseDivide(dArray[n], dArray[n + n2]);
    }

    public void ratio_1m_1p() {
        DoubleDouble doubleDouble = new DoubleDouble(1.0, 0.0);
        doubleDouble.subtract(this);
        this.add(1.0, 0.0);
        this.inverseDivide(doubleDouble);
    }

    public void square() {
        this.multiply(this.value, this.error);
    }

    public void sqrt() {
        if (this.value != 0.0) {
            double d = this.value;
            double d2 = this.error;
            double d3 = Math.sqrt(d);
            this.setToProduct(d3, d3);
            this.subtract(d, d2);
            this.divide(-2.0 * d3, 0.0);
            this.setToQuickSum(d3, this.value);
        }
    }

    public void series(double ... dArray) {
        DoubleDouble doubleDouble = new DoubleDouble(this);
        this.value = dArray[0];
        this.error = 0.0;
        int n = dArray.length - 1;
        if (n >= 1) {
            DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
            DoubleDouble doubleDouble3 = new DoubleDouble(doubleDouble2);
            for (int i = 1; i < n; ++i) {
                doubleDouble3.multiply(dArray[i], 0.0);
                this.add(doubleDouble3);
                doubleDouble2.multiply(doubleDouble);
                doubleDouble3.setFrom(doubleDouble2);
            }
            doubleDouble3.multiply(dArray[n], 0.0);
            this.add(doubleDouble3);
        }
    }

    public int hashCode() {
        return Numerics.hashCode(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.error));
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleDouble) {
            DoubleDouble doubleDouble = (DoubleDouble)object;
            return Numerics.equals(this.value, doubleDouble.value) && Numerics.equals(this.error, doubleDouble.error);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

