# Generated by default/object.tt
package Paws::CodeGuruReviewer::S3BucketRepository;
  use Moose;
  has Details => (is => 'ro', isa => 'Paws::CodeGuruReviewer::S3RepositoryDetails');
  has Name => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::S3BucketRepository

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::S3BucketRepository object:

  $service_obj->Method(Att1 => { Details => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::S3BucketRepository object:

  $result = $service_obj->Method(...);
  $result->Att1->Details

=head1 DESCRIPTION

Information about an associated repository in an S3 bucket. The
associated repository contains a source code .zip file and a build
artifacts .zip file that contains .jar or .class files.

=head1 ATTRIBUTES


=head2 Details => L<Paws::CodeGuruReviewer::S3RepositoryDetails>

An C<S3RepositoryDetails> object that specifies the name of an S3
bucket and a C<CodeArtifacts> object. The C<CodeArtifacts> object
includes the S3 object keys for a source code .zip file and for a build
artifacts .zip file.


=head2 B<REQUIRED> Name => Str

The name of the repository when the C<ProviderType> is C<S3Bucket>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

