#!/usr/bin/env perl

use strict;

use Test::More tests => 3925;

use FindBin;
use lib "$FindBin::Bin/lib";
use My_Growth_Test;

require_ok('Medical::Growth::NHANES_2000::Height_for_Age::Child::Female');

my $h = Medical::Growth::NHANES_2000::Height_for_Age::Child::Female->new;
My_Growth_Test::run_data_tests($h);

__DATA__
# age %ile value
 24.0	 3	 78.438
 24.0	 5	 79.260
 24.0	10	 80.525
 24.0	25	 82.635
 24.0	50	 84.976
 24.0	75	 87.311
 24.0	90	 89.410
 24.0	95	 90.664
 24.0	97	 91.477
 24.5	 3	 78.821
 24.5	 5	 79.648
 24.5	10	 80.919
 24.5	25	 83.042
 24.5	50	 85.397
 24.5	75	 87.749
 24.5	90	 89.863
 24.5	95	 91.127
 24.5	97	 91.947
 25.5	 3	 79.602
 25.5	 5	 80.442
 25.5	10	 81.735
 25.5	25	 83.894
 25.5	50	 86.290
 25.5	75	 88.683
 25.5	90	 90.835
 25.5	95	 92.122
 25.5	97	 92.957
 26.5	 3	 80.376
 26.5	 5	 81.227
 26.5	10	 82.537
 26.5	25	 84.726
 26.5	50	 87.157
 26.5	75	 89.588
 26.5	90	 91.774
 26.5	95	 93.083
 26.5	97	 93.932
 27.5	 3	 81.136
 27.5	 5	 81.995
 27.5	10	 83.320
 27.5	25	 85.534
 27.5	50	 87.996
 27.5	75	 90.460
 27.5	90	 92.680
 27.5	95	 94.009
 27.5	97	 94.872
 28.5	 3	 81.877
 28.5	 5	 82.744
 28.5	10	 84.080
 28.5	25	 86.316
 28.5	50	 88.806
 28.5	75	 91.301
 28.5	90	 93.551
 28.5	95	 94.900
 28.5	97	 95.776
 29.5	 3	 82.597
 29.5	 5	 83.470
 29.5	10	 84.815
 29.5	25	 87.070
 29.5	50	 89.585
 29.5	75	 92.109
 29.5	90	 94.388
 29.5	95	 95.756
 29.5	97	 96.645
 30.5	 3	 83.292
 30.5	 5	 84.170
 30.5	10	 85.524
 30.5	25	 87.796
 30.5	50	 90.333
 30.5	75	 92.884
 30.5	90	 95.191
 30.5	95	 96.576
 30.5	97	 97.478
 31.5	 3	 83.961
 31.5	 5	 84.843
 31.5	10	 86.205
 31.5	25	 88.493
 31.5	50	 91.052
 31.5	75	 93.627
 31.5	90	 95.960
 31.5	95	 97.363
 31.5	97	 98.276
 32.5	 3	 84.602
 32.5	 5	 85.488
 32.5	10	 86.858
 32.5	25	 89.161
 32.5	50	 91.740
 32.5	75	 94.340
 32.5	90	 96.697
 32.5	95	 98.116
 32.5	97	 99.041
 33.5	 3	 85.216
 33.5	 5	 86.107
 33.5	10	 87.483
 33.5	25	 89.800
 33.5	50	 92.399
 33.5	75	 95.021
 33.5	90	 97.403
 33.5	95	 98.838
 33.5	97	 99.773
 34.5	 3	 85.804
 34.5	 5	 86.698
 34.5	10	 88.082
 34.5	25	 90.413
 34.5	50	 93.029
 34.5	75	 95.674
 34.5	90	 98.079
 34.5	95	 99.529
 34.5	97	100.475
 35.5	 3	 86.366
 35.5	 5	 87.264
 35.5	10	 88.654
 35.5	25	 90.999
 35.5	50	 93.634
 35.5	75	 96.300
 35.5	90	 98.727
 35.5	95	100.191
 35.5	97	101.147
 36.5	 3	 86.903
 36.5	 5	 87.805
 36.5	10	 89.203
 36.5	25	 91.561
 36.5	50	 94.213
 36.5	75	 96.901
 36.5	90	 99.349
 36.5	95	100.828
 36.5	97	101.793
 37.5	 3	 87.435
 37.5	 5	 88.342
 37.5	10	 89.749
 37.5	25	 92.123
 37.5	50	 94.796
 37.5	75	 97.507
 37.5	90	 99.979
 37.5	95	101.473
 37.5	97	102.448
 38.5	 3	 87.959
 38.5	 5	 88.873
 38.5	10	 90.288
 38.5	25	 92.679
 38.5	50	 95.374
 38.5	75	 98.109
 38.5	90	100.604
 38.5	95	102.113
 38.5	97	103.099
 39.5	 3	 88.478
 39.5	 5	 89.397
 39.5	10	 90.822
 39.5	25	 93.231
 39.5	50	 95.947
 39.5	75	 98.706
 39.5	90	101.225
 39.5	95	102.749
 39.5	97	103.746
 40.5	 3	 88.993
 40.5	 5	 89.918
 40.5	10	 91.352
 40.5	25	 93.778
 40.5	50	 96.516
 40.5	75	 99.300
 40.5	90	101.843
 40.5	95	103.383
 40.5	97	104.390
 41.5	 3	 89.505
 41.5	 5	 90.436
 41.5	10	 91.880
 41.5	25	 94.323
 41.5	50	 97.083
 41.5	75	 99.891
 41.5	90	102.459
 41.5	95	104.014
 41.5	97	105.032
 42.5	 3	 90.015
 42.5	 5	 90.951
 42.5	10	 92.405
 42.5	25	 94.866
 42.5	50	 97.648
 42.5	75	100.481
 42.5	90	103.073
 42.5	95	104.644
 42.5	97	105.673
 43.5	 3	 90.523
 43.5	 5	 91.465
 43.5	10	 92.929
 43.5	25	 95.408
 43.5	50	 98.212
 43.5	75	101.070
 43.5	90	103.687
 43.5	95	105.274
 43.5	97	106.313
 44.5	 3	 91.031
 44.5	 5	 91.979
 44.5	10	 93.453
 44.5	25	 95.949
 44.5	50	 98.776
 44.5	75	101.658
 44.5	90	104.300
 44.5	95	105.902
 44.5	97	106.952
 45.5	 3	 91.539
 45.5	 5	 92.493
 45.5	10	 93.976
 45.5	25	 96.491
 45.5	50	 99.339
 45.5	75	102.246
 45.5	90	104.913
 45.5	95	106.532
 45.5	97	107.592
 46.5	 3	 92.048
 46.5	 5	 93.008
 46.5	10	 94.500
 46.5	25	 97.033
 46.5	50	 99.903
 46.5	75	102.835
 46.5	90	105.526
 46.5	95	107.161
 46.5	97	108.233
 47.5	 3	 92.557
 47.5	 5	 93.523
 47.5	10	 95.025
 47.5	25	 97.575
 47.5	50	100.468
 47.5	75	103.425
 47.5	90	106.141
 47.5	95	107.792
 47.5	97	108.874
 48.5	 3	 93.069
 48.5	 5	 94.040
 48.5	10	 95.552
 48.5	25	 98.119
 48.5	50	101.034
 48.5	75	104.015
 48.5	90	106.757
 48.5	95	108.424
 48.5	97	109.517
 49.5	 3	 93.581
 49.5	 5	 94.559
 49.5	10	 96.080
 49.5	25	 98.664
 49.5	50	101.601
 49.5	75	104.608
 49.5	90	107.374
 49.5	95	109.057
 49.5	97	110.161
 50.5	 3	 94.096
 50.5	 5	 95.079
 50.5	10	 96.609
 50.5	25	 99.211
 50.5	50	102.170
 50.5	75	105.201
 50.5	90	107.992
 50.5	95	109.692
 50.5	97	110.807
 51.5	 3	 94.613
 51.5	 5	 95.601
 51.5	10	 97.141
 51.5	25	 99.760
 51.5	50	102.741
 51.5	75	105.797
 51.5	90	108.613
 51.5	95	110.328
 51.5	97	111.455
 52.5	 3	 95.131
 52.5	 5	 96.126
 52.5	10	 97.674
 52.5	25	100.311
 52.5	50	103.313
 52.5	75	106.394
 52.5	90	109.235
 52.5	95	110.967
 52.5	97	112.104
 53.5	 3	 95.652
 53.5	 5	 96.652
 53.5	10	 98.210
 53.5	25	100.863
 53.5	50	103.887
 53.5	75	106.993
 53.5	90	109.859
 53.5	95	111.607
 53.5	97	112.755
 54.5	 3	 96.175
 54.5	 5	 97.180
 54.5	10	 98.747
 54.5	25	101.418
 54.5	50	104.463
 54.5	75	107.593
 54.5	90	110.484
 54.5	95	112.248
 54.5	97	113.408
 55.5	 3	 96.700
 55.5	 5	 97.711
 55.5	10	 99.287
 55.5	25	101.974
 55.5	50	105.041
 55.5	75	108.196
 55.5	90	111.111
 55.5	95	112.892
 55.5	97	114.062
 56.5	 3	 97.227
 56.5	 5	 98.243
 56.5	10	 99.828
 56.5	25	102.533
 56.5	50	105.621
 56.5	75	108.800
 56.5	90	111.740
 56.5	95	113.537
 56.5	97	114.718
 57.5	 3	 97.755
 57.5	 5	 98.777
 57.5	10	100.372
 57.5	25	103.093
 57.5	50	106.203
 57.5	75	109.406
 57.5	90	112.371
 57.5	95	114.183
 57.5	97	115.376
 58.5	 3	 98.286
 58.5	 5	 99.313
 58.5	10	100.917
 58.5	25	103.655
 58.5	50	106.786
 58.5	75	110.013
 58.5	90	113.003
 58.5	95	114.831
 58.5	97	116.035
 59.5	 3	 98.817
 59.5	 5	 99.850
 59.5	10	101.463
 59.5	25	104.218
 59.5	50	107.371
 59.5	75	110.622
 59.5	90	113.636
 59.5	95	115.480
 59.5	97	116.694
 60.5	 3	 99.350
 60.5	 5	100.389
 60.5	10	102.011
 60.5	25	104.783
 60.5	50	107.957
 60.5	75	111.232
 60.5	90	114.270
 60.5	95	116.130
 60.5	97	117.355
 61.5	 3	 99.885
 61.5	 5	100.929
 61.5	10	102.560
 61.5	25	105.349
 61.5	50	108.544
 61.5	75	111.843
 61.5	90	114.905
 61.5	95	116.781
 61.5	97	118.017
 62.5	 3	100.420
 62.5	 5	101.470
 62.5	10	103.110
 62.5	25	105.916
 62.5	50	109.132
 62.5	75	112.455
 62.5	90	115.541
 62.5	95	117.432
 62.5	97	118.678
 63.5	 3	100.956
 63.5	 5	102.011
 63.5	10	103.660
 63.5	25	106.483
 63.5	50	109.720
 63.5	75	113.067
 63.5	90	116.177
 63.5	95	118.083
 63.5	97	119.340
 64.5	 3	101.492
 64.5	 5	102.553
 64.5	10	104.212
 64.5	25	107.051
 64.5	50	110.309
 64.5	75	113.680
 64.5	90	116.813
 64.5	95	118.735
 64.5	97	120.002
 65.5	 3	102.028
 65.5	 5	103.095
 65.5	10	104.763
 65.5	25	107.619
 65.5	50	110.898
 65.5	75	114.292
 65.5	90	117.449
 65.5	95	119.386
 65.5	97	120.663
 66.5	 3	102.564
 66.5	 5	103.637
 66.5	10	105.314
 66.5	25	108.188
 66.5	50	111.488
 66.5	75	114.905
 66.5	90	118.085
 66.5	95	120.036
 66.5	97	121.324
 67.5	 3	103.100
 67.5	 5	104.178
 67.5	10	105.865
 67.5	25	108.756
 67.5	50	112.076
 67.5	75	115.517
 67.5	90	118.719
 67.5	95	120.686
 67.5	97	121.983
 68.5	 3	103.635
 68.5	 5	104.719
 68.5	10	106.415
 68.5	25	109.323
 68.5	50	112.665
 68.5	75	116.128
 68.5	90	119.353
 68.5	95	121.334
 68.5	97	122.641
 69.5	 3	104.169
 69.5	 5	105.259
 69.5	10	106.965
 69.5	25	109.890
 69.5	50	113.252
 69.5	75	116.738
 69.5	90	119.986
 69.5	95	121.981
 69.5	97	123.298
 70.5	 3	104.701
 70.5	 5	105.798
 70.5	10	107.513
 70.5	25	110.455
 70.5	50	113.838
 70.5	75	117.347
 70.5	90	120.616
 70.5	95	122.626
 70.5	97	123.952
 71.5	 3	105.232
 71.5	 5	106.335
 71.5	10	108.060
 71.5	25	111.019
 71.5	50	114.423
 71.5	75	117.954
 71.5	90	121.245
 71.5	95	123.268
 71.5	97	124.604
 72.5	 3	105.761
 72.5	 5	106.870
 72.5	10	108.605
 72.5	25	111.581
 72.5	50	115.005
 72.5	75	118.559
 72.5	90	121.872
 72.5	95	123.909
 72.5	97	125.254
 73.5	 3	106.289
 73.5	 5	107.403
 73.5	10	109.148
 73.5	25	112.142
 73.5	50	115.586
 73.5	75	119.162
 73.5	90	122.496
 73.5	95	124.546
 73.5	97	125.900
 74.5	 3	106.813
 74.5	 5	107.934
 74.5	10	109.689
 74.5	25	112.700
 74.5	50	116.165
 74.5	75	119.762
 74.5	90	123.117
 74.5	95	125.180
 74.5	97	126.543
 75.5	 3	107.335
 75.5	 5	108.462
 75.5	10	110.227
 75.5	25	113.255
 75.5	50	116.741
 75.5	75	120.359
 75.5	90	123.735
 75.5	95	125.811
 75.5	97	127.183
 76.5	 3	107.854
 76.5	 5	108.988
 76.5	10	110.762
 76.5	25	113.808
 76.5	50	117.314
 76.5	75	120.954
 76.5	90	124.350
 76.5	95	126.439
 76.5	97	127.818
 77.5	 3	108.370
 77.5	 5	109.510
 77.5	10	111.294
 77.5	25	114.357
 77.5	50	117.883
 77.5	75	121.545
 77.5	90	124.961
 77.5	95	127.062
 77.5	97	128.450
 78.5	 3	108.882
 78.5	 5	110.029
 78.5	10	111.823
 78.5	25	114.903
 78.5	50	118.450
 78.5	75	122.132
 78.5	90	125.568
 78.5	95	127.681
 78.5	97	129.077
 79.5	 3	109.390
 79.5	 5	110.543
 79.5	10	112.348
 79.5	25	115.446
 79.5	50	119.012
 79.5	75	122.715
 79.5	90	126.171
 79.5	95	128.296
 79.5	97	129.700
 80.5	 3	109.895
 80.5	 5	111.054
 80.5	10	112.870
 80.5	25	115.985
 80.5	50	119.571
 80.5	75	123.295
 80.5	90	126.769
 80.5	95	128.906
 80.5	97	130.317
 81.5	 3	110.395
 81.5	 5	111.561
 81.5	10	113.387
 81.5	25	116.519
 81.5	50	120.125
 81.5	75	123.869
 81.5	90	127.362
 81.5	95	129.511
 81.5	97	130.929
 82.5	 3	110.891
 82.5	 5	112.064
 82.5	10	113.899
 82.5	25	117.050
 82.5	50	120.676
 82.5	75	124.440
 82.5	90	127.951
 82.5	95	130.110
 82.5	97	131.537
 83.5	 3	111.382
 83.5	 5	112.562
 83.5	10	114.408
 83.5	25	117.575
 83.5	50	121.221
 83.5	75	125.005
 83.5	90	128.534
 83.5	95	130.705
 83.5	97	132.138
 84.5	 3	111.868
 84.5	 5	113.055
 84.5	10	114.911
 84.5	25	118.096
 84.5	50	121.762
 84.5	75	125.566
 84.5	90	129.113
 84.5	95	131.294
 84.5	97	132.734
 85.5	 3	112.350
 85.5	 5	113.543
 85.5	10	115.410
 85.5	25	118.613
 85.5	50	122.297
 85.5	75	126.121
 85.5	90	129.685
 85.5	95	131.877
 85.5	97	133.324
 86.5	 3	112.826
 86.5	 5	114.026
 86.5	10	115.903
 86.5	25	119.124
 86.5	50	122.828
 86.5	75	126.671
 86.5	90	130.253
 86.5	95	132.454
 86.5	97	133.908
 87.5	 3	113.296
 87.5	 5	114.503
 87.5	10	116.391
 87.5	25	119.629
 87.5	50	123.353
 87.5	75	127.215
 87.5	90	130.814
 87.5	95	133.026
 87.5	97	134.486
 88.5	 3	113.762
 88.5	 5	114.975
 88.5	10	116.874
 88.5	25	120.130
 88.5	50	123.873
 88.5	75	127.754
 88.5	90	131.370
 88.5	95	133.591
 88.5	97	135.057
 89.5	 3	114.221
 89.5	 5	115.442
 89.5	10	117.351
 89.5	25	120.625
 89.5	50	124.387
 89.5	75	128.287
 89.5	90	131.919
 89.5	95	134.150
 89.5	97	135.623
 90.5	 3	114.675
 90.5	 5	115.903
 90.5	10	117.823
 90.5	25	121.114
 90.5	50	124.896
 90.5	75	128.814
 90.5	90	132.463
 90.5	95	134.704
 90.5	97	136.182
 91.5	 3	115.123
 91.5	 5	116.358
 91.5	10	118.289
 91.5	25	121.597
 91.5	50	125.398
 91.5	75	129.336
 91.5	90	133.001
 91.5	95	135.251
 91.5	97	136.736
 92.5	 3	115.565
 92.5	 5	116.807
 92.5	10	118.749
 92.5	25	122.075
 92.5	50	125.896
 92.5	75	129.852
 92.5	90	133.533
 92.5	95	135.792
 92.5	97	137.283
 93.5	 3	116.001
 93.5	 5	117.250
 93.5	10	119.203
 93.5	25	122.547
 93.5	50	126.387
 93.5	75	130.362
 93.5	90	134.059
 93.5	95	136.327
 93.5	97	137.824
 94.5	 3	116.431
 94.5	 5	117.688
 94.5	10	119.651
 94.5	25	123.014
 94.5	50	126.872
 94.5	75	130.866
 94.5	90	134.579
 94.5	95	136.856
 94.5	97	138.359
 95.5	 3	116.856
 95.5	 5	118.119
 95.5	10	120.093
 95.5	25	123.474
 95.5	50	127.352
 95.5	75	131.364
 95.5	90	135.093
 95.5	95	137.380
 95.5	97	138.888
 96.5	 3	117.274
 96.5	 5	118.544
 96.5	10	120.530
 96.5	25	123.929
 96.5	50	127.826
 96.5	75	131.857
 96.5	90	135.602
 96.5	95	137.897
 96.5	97	139.411
 97.5	 3	117.686
 97.5	 5	118.964
 97.5	10	120.961
 97.5	25	124.377
 97.5	50	128.295
 97.5	75	132.344
 97.5	90	136.105
 97.5	95	138.410
 97.5	97	139.929
 98.5	 3	118.092
 98.5	 5	119.377
 98.5	10	121.386
 98.5	25	124.821
 98.5	50	128.758
 98.5	75	132.825
 98.5	90	136.602
 98.5	95	138.917
 98.5	97	140.442
 99.5	 3	118.492
 99.5	 5	119.785
 99.5	10	121.805
 99.5	25	125.258
 99.5	50	129.215
 99.5	75	133.302
 99.5	90	137.095
 99.5	95	139.418
 99.5	97	140.949
100.5	 3	118.887
100.5	 5	120.187
100.5	10	122.218
100.5	25	125.691
100.5	50	129.668
100.5	75	133.773
100.5	90	137.583
100.5	95	139.916
100.5	97	141.452
101.5	 3	119.276
101.5	 5	120.584
101.5	10	122.626
101.5	25	126.118
101.5	50	130.115
101.5	75	134.240
101.5	90	138.066
101.5	95	140.408
101.5	97	141.951
102.5	 3	119.659
102.5	 5	120.975
102.5	10	123.029
102.5	25	126.540
102.5	50	130.557
102.5	75	134.702
102.5	90	138.545
102.5	95	140.897
102.5	97	142.445
103.5	 3	120.037
103.5	 5	121.361
103.5	10	123.427
103.5	25	126.957
103.5	50	130.995
103.5	75	135.160
103.5	90	139.020
103.5	95	141.382
103.5	97	142.936
104.5	 3	120.410
104.5	 5	121.741
104.5	10	123.820
104.5	25	127.369
104.5	50	131.429
104.5	75	135.615
104.5	90	139.492
104.5	95	141.863
104.5	97	143.424
105.5	 3	120.777
105.5	 5	122.117
105.5	10	124.208
105.5	25	127.778
105.5	50	131.859
105.5	75	136.065
105.5	90	139.960
105.5	95	142.342
105.5	97	143.910
106.5	 3	121.141
106.5	 5	122.488
106.5	10	124.592
106.5	25	128.182
106.5	50	132.286
106.5	75	136.513
106.5	90	140.427
106.5	95	142.819
106.5	97	144.393
107.5	 3	121.499
107.5	 5	122.855
107.5	10	124.972
107.5	25	128.583
107.5	50	132.709
107.5	75	136.958
107.5	90	140.891
107.5	95	143.294
107.5	97	144.875
108.5	 3	121.854
108.5	 5	123.219
108.5	10	125.348
108.5	25	128.981
108.5	50	133.130
108.5	75	137.402
108.5	90	141.353
108.5	95	143.767
108.5	97	145.355
109.5	 3	122.204
109.5	 5	123.578
109.5	10	125.721
109.5	25	129.376
109.5	50	133.549
109.5	75	137.844
109.5	90	141.815
109.5	95	144.241
109.5	97	145.836
110.5	 3	122.552
110.5	 5	123.935
110.5	10	126.091
110.5	25	129.769
110.5	50	133.967
110.5	75	138.285
110.5	90	142.276
110.5	95	144.714
110.5	97	146.317
111.5	 3	122.896
111.5	 5	124.289
111.5	10	126.459
111.5	25	130.160
111.5	50	134.383
111.5	75	138.726
111.5	90	142.738
111.5	95	145.188
111.5	97	146.798
112.5	 3	123.238
112.5	 5	124.640
112.5	10	126.825
112.5	25	130.551
112.5	50	134.800
112.5	75	139.167
112.5	90	143.201
112.5	95	145.663
112.5	97	147.282
113.5	 3	123.579
113.5	 5	124.990
113.5	10	127.191
113.5	25	130.941
113.5	50	135.216
113.5	75	139.609
113.5	90	143.666
113.5	95	146.141
113.5	97	147.768
114.5	 3	123.917
114.5	 5	125.339
114.5	10	127.555
114.5	25	131.331
114.5	50	135.634
114.5	75	140.054
114.5	90	144.133
114.5	95	146.621
114.5	97	148.256
115.5	 3	124.255
115.5	 5	125.688
115.5	10	127.920
115.5	25	131.722
115.5	50	136.054
115.5	75	140.501
115.5	90	144.604
115.5	95	147.106
115.5	97	148.749
116.5	 3	124.593
116.5	 5	126.037
116.5	10	128.286
116.5	25	132.116
116.5	50	136.477
116.5	75	140.952
116.5	90	145.079
116.5	95	147.594
116.5	97	149.246
117.5	 3	124.932
117.5	 5	126.387
117.5	10	128.654
117.5	25	132.511
117.5	50	136.903
117.5	75	141.407
117.5	90	145.558
117.5	95	148.087
117.5	97	149.748
118.5	 3	125.272
118.5	 5	126.739
118.5	10	129.024
118.5	25	132.911
118.5	50	137.333
118.5	75	141.867
118.5	90	146.043
118.5	95	148.587
118.5	97	150.256
119.5	 3	125.614
119.5	 5	127.094
119.5	10	129.397
119.5	25	133.315
119.5	50	137.769
119.5	75	142.332
119.5	90	146.534
119.5	95	149.092
119.5	97	150.771
120.5	 3	125.960
120.5	 5	127.452
120.5	10	129.775
120.5	25	133.724
120.5	50	138.211
120.5	75	142.805
120.5	90	147.032
120.5	95	149.604
120.5	97	151.292
121.5	 3	126.309
121.5	 5	127.815
121.5	10	130.158
121.5	25	134.139
121.5	50	138.660
121.5	75	143.285
121.5	90	147.538
121.5	95	150.124
121.5	97	151.821
122.5	 3	126.664
122.5	 5	128.184
122.5	10	130.548
122.5	25	134.562
122.5	50	139.117
122.5	75	143.773
122.5	90	148.052
122.5	95	150.652
122.5	97	152.357
123.5	 3	127.025
123.5	 5	128.559
123.5	10	130.945
123.5	25	134.993
123.5	50	139.583
123.5	75	144.271
123.5	90	148.574
123.5	95	151.188
123.5	97	152.901
124.5	 3	127.393
124.5	 5	128.942
124.5	10	131.350
124.5	25	135.433
124.5	50	140.058
124.5	75	144.777
124.5	90	149.105
124.5	95	151.733
124.5	97	153.453
125.5	 3	127.769
125.5	 5	129.333
125.5	10	131.764
125.5	25	135.883
125.5	50	140.543
125.5	75	145.294
125.5	90	149.646
125.5	95	152.286
125.5	97	154.014
126.5	 3	128.154
126.5	 5	129.735
126.5	10	132.188
126.5	25	136.343
126.5	50	141.040
126.5	75	145.821
126.5	90	150.196
126.5	95	152.847
126.5	97	154.582
127.5	 3	128.550
127.5	 5	130.147
127.5	10	132.624
127.5	25	136.815
127.5	50	141.547
127.5	75	146.358
127.5	90	150.755
127.5	95	153.417
127.5	97	155.159
128.5	 3	128.957
128.5	 5	130.570
128.5	10	133.072
128.5	25	137.300
128.5	50	142.066
128.5	75	146.906
128.5	90	151.324
128.5	95	153.996
128.5	97	155.742
129.5	 3	129.377
129.5	 5	131.007
129.5	10	133.533
129.5	25	137.797
129.5	50	142.597
129.5	75	147.464
129.5	90	151.901
129.5	95	154.581
129.5	97	156.332
130.5	 3	129.811
130.5	 5	131.457
130.5	10	134.007
130.5	25	138.307
130.5	50	143.140
130.5	75	148.033
130.5	90	152.486
130.5	95	155.174
130.5	97	156.928
131.5	 3	130.259
131.5	 5	131.922
131.5	10	134.496
131.5	25	138.830
131.5	50	143.695
131.5	75	148.611
131.5	90	153.079
131.5	95	155.772
131.5	97	157.529
132.5	 3	130.722
132.5	 5	132.401
132.5	10	134.998
132.5	25	139.366
132.5	50	144.261
132.5	75	149.198
132.5	90	153.678
132.5	95	156.375
132.5	97	158.133
133.5	 3	131.201
133.5	 5	132.896
133.5	10	135.516
133.5	25	139.916
133.5	50	144.838
133.5	75	149.794
133.5	90	154.283
133.5	95	156.982
133.5	97	158.741
134.5	 3	131.696
134.5	 5	133.407
134.5	10	136.048
134.5	25	140.477
134.5	50	145.424
134.5	75	150.396
134.5	90	154.892
134.5	95	157.592
134.5	97	159.349
135.5	 3	132.207
135.5	 5	133.933
135.5	10	136.594
135.5	25	141.051
135.5	50	146.019
135.5	75	151.004
135.5	90	155.503
135.5	95	158.202
135.5	97	159.957
136.5	 3	132.735
136.5	 5	134.474
136.5	10	137.153
136.5	25	141.635
136.5	50	146.622
136.5	75	151.615
136.5	90	156.116
136.5	95	158.811
136.5	97	160.563
137.5	 3	133.279
137.5	 5	135.030
137.5	10	137.726
137.5	25	142.229
137.5	50	147.230
137.5	75	152.229
137.5	90	156.727
137.5	95	159.418
137.5	97	161.166
138.5	 3	133.839
138.5	 5	135.600
138.5	10	138.310
138.5	25	142.830
138.5	50	147.842
138.5	75	152.844
138.5	90	157.336
138.5	95	160.021
138.5	97	161.763
139.5	 3	134.413
139.5	 5	136.183
139.5	10	138.904
139.5	25	143.438
139.5	50	148.457
139.5	75	153.457
139.5	90	157.941
139.5	95	160.618
139.5	97	162.354
140.5	 3	134.999
140.5	 5	136.777
140.5	10	139.507
140.5	25	144.050
140.5	50	149.071
140.5	75	154.066
140.5	90	158.540
140.5	95	161.208
140.5	97	162.936
141.5	 3	135.597
141.5	 5	137.380
141.5	10	140.116
141.5	25	144.664
141.5	50	149.684
141.5	75	154.670
141.5	90	159.130
141.5	95	161.787
141.5	97	163.508
142.5	 3	136.205
142.5	 5	137.990
142.5	10	140.729
142.5	25	145.278
142.5	50	150.292
142.5	75	155.266
142.5	90	159.711
142.5	95	162.356
142.5	97	164.069
143.5	 3	136.819
143.5	 5	138.606
143.5	10	141.345
143.5	25	145.889
143.5	50	150.894
143.5	75	155.853
143.5	90	160.280
143.5	95	162.913
143.5	97	164.617
144.5	 3	137.438
144.5	 5	139.224
144.5	10	141.959
144.5	25	146.496
144.5	50	151.487
144.5	75	156.428
144.5	90	160.835
144.5	95	163.455
144.5	97	165.150
145.5	 3	138.059
145.5	 5	139.841
145.5	10	142.571
145.5	25	147.095
145.5	50	152.069
145.5	75	156.990
145.5	90	161.376
145.5	95	163.983
145.5	97	165.669
146.5	 3	138.678
146.5	 5	140.455
146.5	10	143.177
146.5	25	147.684
146.5	50	152.638
146.5	75	157.537
146.5	90	161.902
146.5	95	164.494
146.5	97	166.171
147.5	 3	139.294
147.5	 5	141.064
147.5	10	143.774
147.5	25	148.262
147.5	50	153.193
147.5	75	158.068
147.5	90	162.410
147.5	95	164.988
147.5	97	166.656
148.5	 3	139.903
148.5	 5	141.664
148.5	10	144.361
148.5	25	148.826
148.5	50	153.732
148.5	75	158.581
148.5	90	162.900
148.5	95	165.465
148.5	97	167.123
149.5	 3	140.502
149.5	 5	142.253
149.5	10	144.934
149.5	25	149.375
149.5	50	154.253
149.5	75	159.076
149.5	90	163.371
149.5	95	165.923
149.5	97	167.572
150.5	 3	141.088
150.5	 5	142.828
150.5	10	145.493
150.5	25	149.906
150.5	50	154.756
150.5	75	159.551
150.5	90	163.824
150.5	95	166.362
150.5	97	168.003
151.5	 3	141.660
151.5	 5	143.388
151.5	10	146.034
151.5	25	150.418
151.5	50	155.238
151.5	75	160.007
151.5	90	164.257
151.5	95	166.782
151.5	97	168.415
152.5	 3	142.215
152.5	 5	143.929
152.5	10	146.556
152.5	25	150.911
152.5	50	155.701
152.5	75	160.442
152.5	90	164.670
152.5	95	167.183
152.5	97	168.808
153.5	 3	142.750
153.5	 5	144.452
153.5	10	147.059
153.5	25	151.384
153.5	50	156.143
153.5	75	160.858
153.5	90	165.064
153.5	95	167.565
153.5	97	169.183
154.5	 3	143.265
154.5	 5	144.953
154.5	10	147.540
154.5	25	151.835
154.5	50	156.564
154.5	75	161.252
154.5	90	165.438
154.5	95	167.928
154.5	97	169.539
155.5	 3	143.758
155.5	 5	145.433
155.5	10	148.000
155.5	25	152.264
155.5	50	156.964
155.5	75	161.627
155.5	90	165.793
155.5	95	168.272
155.5	97	169.877
156.5	 3	144.229
156.5	 5	145.889
156.5	10	148.438
156.5	25	152.672
156.5	50	157.344
156.5	75	161.982
156.5	90	166.129
156.5	95	168.599
156.5	97	170.198
157.5	 3	144.676
157.5	 5	146.323
157.5	10	148.853
157.5	25	153.058
157.5	50	157.702
157.5	75	162.317
157.5	90	166.447
157.5	95	168.907
157.5	97	170.501
158.5	 3	145.099
158.5	 5	146.734
158.5	10	149.245
158.5	25	153.423
158.5	50	158.041
158.5	75	162.634
158.5	90	166.747
158.5	95	169.199
158.5	97	170.788
159.5	 3	145.498
159.5	 5	147.121
159.5	10	149.615
159.5	25	153.767
159.5	50	158.360
159.5	75	162.932
159.5	90	167.030
159.5	95	169.474
159.5	97	171.059
160.5	 3	145.874
160.5	 5	147.486
160.5	10	149.963
160.5	25	154.091
160.5	50	158.661
160.5	75	163.213
160.5	90	167.296
160.5	95	169.733
160.5	97	171.314
161.5	 3	146.227
161.5	 5	147.828
161.5	10	150.290
161.5	25	154.395
161.5	50	158.943
161.5	75	163.477
161.5	90	167.547
161.5	95	169.978
161.5	97	171.554
162.5	 3	146.557
162.5	 5	148.149
162.5	10	150.597
162.5	25	154.680
162.5	50	159.207
162.5	75	163.725
162.5	90	167.783
162.5	95	170.207
162.5	97	171.781
163.5	 3	146.866
163.5	 5	148.448
163.5	10	150.883
163.5	25	154.947
163.5	50	159.456
163.5	75	163.958
163.5	90	168.004
163.5	95	170.423
163.5	97	171.994
164.5	 3	147.154
164.5	 5	148.728
164.5	10	151.151
164.5	25	155.197
164.5	50	159.688
164.5	75	164.176
164.5	90	168.212
164.5	95	170.626
164.5	97	172.194
165.5	 3	147.422
165.5	 5	148.988
165.5	10	151.400
165.5	25	155.430
165.5	50	159.906
165.5	75	164.381
165.5	90	168.407
165.5	95	170.817
165.5	97	172.382
166.5	 3	147.671
166.5	 5	149.231
166.5	10	151.633
166.5	25	155.648
166.5	50	160.109
166.5	75	164.573
166.5	90	168.591
166.5	95	170.996
166.5	97	172.558
167.5	 3	147.903
167.5	 5	149.456
167.5	10	151.849
167.5	25	155.851
167.5	50	160.300
167.5	75	164.752
167.5	90	168.763
167.5	95	171.164
167.5	97	172.724
168.5	 3	148.117
168.5	 5	149.666
168.5	10	152.051
168.5	25	156.040
168.5	50	160.478
168.5	75	164.921
168.5	90	168.924
168.5	95	171.322
168.5	97	172.880
169.5	 3	148.316
169.5	 5	149.860
169.5	10	152.238
169.5	25	156.217
169.5	50	160.644
169.5	75	165.078
169.5	90	169.075
169.5	95	171.470
169.5	97	173.026
170.5	 3	148.501
170.5	 5	150.040
170.5	10	152.412
170.5	25	156.381
170.5	50	160.800
170.5	75	165.226
170.5	90	169.217
170.5	95	171.608
170.5	97	173.163
171.5	 3	148.672
171.5	 5	150.207
171.5	10	152.574
171.5	25	156.535
171.5	50	160.945
171.5	75	165.364
171.5	90	169.350
171.5	95	171.739
171.5	97	173.292
172.5	 3	148.830
172.5	 5	150.362
172.5	10	152.724
172.5	25	156.678
172.5	50	161.081
172.5	75	165.494
172.5	90	169.475
172.5	95	171.861
172.5	97	173.412
173.5	 3	148.976
173.5	 5	150.506
173.5	10	152.864
173.5	25	156.811
173.5	50	161.208
173.5	75	165.616
173.5	90	169.592
173.5	95	171.976
173.5	97	173.526
174.5	 3	149.112
174.5	 5	150.639
174.5	10	152.994
174.5	25	156.936
174.5	50	161.327
174.5	75	165.730
174.5	90	169.702
174.5	95	172.084
174.5	97	173.632
175.5	 3	149.238
175.5	 5	150.763
175.5	10	153.114
175.5	25	157.052
175.5	50	161.438
175.5	75	165.837
175.5	90	169.806
175.5	95	172.185
175.5	97	173.733
176.5	 3	149.354
176.5	 5	150.878
176.5	10	153.227
176.5	25	157.160
176.5	50	161.542
176.5	75	165.937
176.5	90	169.903
176.5	95	172.281
176.5	97	173.827
177.5	 3	149.462
177.5	 5	150.984
177.5	10	153.331
177.5	25	157.261
177.5	50	161.640
177.5	75	166.031
177.5	90	169.994
177.5	95	172.370
177.5	97	173.915
178.5	 3	149.562
178.5	 5	151.083
178.5	10	153.429
178.5	25	157.356
178.5	50	161.731
178.5	75	166.120
178.5	90	170.080
178.5	95	172.454
178.5	97	173.998
179.5	 3	149.655
179.5	 5	151.175
179.5	10	153.519
179.5	25	157.444
179.5	50	161.817
179.5	75	166.203
179.5	90	170.161
179.5	95	172.534
179.5	97	174.077
180.5	 3	149.742
180.5	 5	151.261
180.5	10	153.604
180.5	25	157.527
180.5	50	161.898
180.5	75	166.281
180.5	90	170.237
180.5	95	172.608
180.5	97	174.151
181.5	 3	149.822
181.5	 5	151.341
181.5	10	153.683
181.5	25	157.605
181.5	50	161.974
181.5	75	166.355
181.5	90	170.308
181.5	95	172.679
181.5	97	174.220
182.5	 3	149.897
182.5	 5	151.415
182.5	10	153.757
182.5	25	157.677
182.5	50	162.045
182.5	75	166.424
182.5	90	170.376
182.5	95	172.745
182.5	97	174.285
183.5	 3	149.966
183.5	 5	151.485
183.5	10	153.826
183.5	25	157.746
183.5	50	162.112
183.5	75	166.490
183.5	90	170.440
183.5	95	172.808
183.5	97	174.347
184.5	 3	150.031
184.5	 5	151.550
184.5	10	153.891
184.5	25	157.810
184.5	50	162.175
184.5	75	166.552
184.5	90	170.500
184.5	95	172.867
184.5	97	174.406
185.5	 3	150.092
185.5	 5	151.610
185.5	10	153.951
185.5	25	157.870
185.5	50	162.235
185.5	75	166.610
185.5	90	170.557
185.5	95	172.922
185.5	97	174.461
186.5	 3	150.148
186.5	 5	151.667
186.5	10	154.008
186.5	25	157.927
186.5	50	162.291
186.5	75	166.665
186.5	90	170.610
186.5	95	172.975
186.5	97	174.513
187.5	 3	150.201
187.5	 5	151.720
187.5	10	154.062
187.5	25	157.980
187.5	50	162.344
187.5	75	166.717
187.5	90	170.661
187.5	95	173.025
187.5	97	174.562
188.5	 3	150.251
188.5	 5	151.770
188.5	10	154.112
188.5	25	158.031
188.5	50	162.394
188.5	75	166.766
188.5	90	170.709
188.5	95	173.072
188.5	97	174.608
189.5	 3	150.298
189.5	 5	151.817
189.5	10	154.159
189.5	25	158.078
189.5	50	162.441
189.5	75	166.813
189.5	90	170.755
189.5	95	173.117
189.5	97	174.652
190.5	 3	150.341
190.5	 5	151.861
190.5	10	154.204
190.5	25	158.123
190.5	50	162.486
190.5	75	166.857
190.5	90	170.798
190.5	95	173.159
190.5	97	174.694
191.5	 3	150.382
191.5	 5	151.903
191.5	10	154.246
191.5	25	158.166
191.5	50	162.529
191.5	75	166.899
191.5	90	170.839
191.5	95	173.199
191.5	97	174.733
192.5	 3	150.421
192.5	 5	151.942
192.5	10	154.285
192.5	25	158.206
192.5	50	162.569
192.5	75	166.939
192.5	90	170.878
192.5	95	173.237
192.5	97	174.771
193.5	 3	150.457
193.5	 5	151.979
193.5	10	154.323
193.5	25	158.244
193.5	50	162.607
193.5	75	166.977
193.5	90	170.914
193.5	95	173.273
193.5	97	174.806
194.5	 3	150.492
194.5	 5	152.014
194.5	10	154.358
194.5	25	158.280
194.5	50	162.644
194.5	75	167.012
194.5	90	170.949
194.5	95	173.308
194.5	97	174.840
195.5	 3	150.524
195.5	 5	152.046
195.5	10	154.392
195.5	25	158.315
195.5	50	162.678
195.5	75	167.047
195.5	90	170.983
195.5	95	173.340
195.5	97	174.872
196.5	 3	150.555
196.5	 5	152.078
196.5	10	154.424
196.5	25	158.347
196.5	50	162.711
196.5	75	167.079
196.5	90	171.014
196.5	95	173.371
196.5	97	174.902
197.5	 3	150.584
197.5	 5	152.107
197.5	10	154.454
197.5	25	158.378
197.5	50	162.742
197.5	75	167.110
197.5	90	171.045
197.5	95	173.401
197.5	97	174.931
198.5	 3	150.611
198.5	 5	152.135
198.5	10	154.483
198.5	25	158.408
198.5	50	162.772
198.5	75	167.139
198.5	90	171.073
198.5	95	173.429
198.5	97	174.959
199.5	 3	150.637
199.5	 5	152.162
199.5	10	154.510
199.5	25	158.436
199.5	50	162.800
199.5	75	167.168
199.5	90	171.101
199.5	95	173.455
199.5	97	174.985
200.5	 3	150.662
200.5	 5	152.187
200.5	10	154.536
200.5	25	158.462
200.5	50	162.827
200.5	75	167.194
200.5	90	171.127
200.5	95	173.481
200.5	97	175.010
201.5	 3	150.685
201.5	 5	152.211
201.5	10	154.561
201.5	25	158.488
201.5	50	162.853
201.5	75	167.220
201.5	90	171.152
201.5	95	173.505
201.5	97	175.034
202.5	 3	150.708
202.5	 5	152.234
202.5	10	154.584
202.5	25	158.512
202.5	50	162.878
202.5	75	167.244
202.5	90	171.175
202.5	95	173.528
202.5	97	175.057
203.5	 3	150.729
203.5	 5	152.256
203.5	10	154.607
203.5	25	158.536
203.5	50	162.901
203.5	75	167.268
203.5	90	171.198
203.5	95	173.551
203.5	97	175.078
204.5	 3	150.749
204.5	 5	152.276
204.5	10	154.628
204.5	25	158.558
204.5	50	162.924
204.5	75	167.290
204.5	90	171.220
204.5	95	173.572
204.5	97	175.099
205.5	 3	150.768
205.5	 5	152.296
205.5	10	154.649
205.5	25	158.579
205.5	50	162.945
205.5	75	167.311
205.5	90	171.241
205.5	95	173.592
205.5	97	175.119
206.5	 3	150.787
206.5	 5	152.315
206.5	10	154.668
206.5	25	158.599
206.5	50	162.966
206.5	75	167.332
206.5	90	171.260
206.5	95	173.611
206.5	97	175.138
207.5	 3	150.804
207.5	 5	152.333
207.5	10	154.687
207.5	25	158.619
207.5	50	162.986
207.5	75	167.351
207.5	90	171.279
207.5	95	173.630
207.5	97	175.156
208.5	 3	150.821
208.5	 5	152.350
208.5	10	154.705
208.5	25	158.637
208.5	50	163.005
208.5	75	167.370
208.5	90	171.297
208.5	95	173.647
208.5	97	175.173
209.5	 3	150.837
209.5	 5	152.367
209.5	10	154.722
209.5	25	158.655
209.5	50	163.023
209.5	75	167.388
209.5	90	171.315
209.5	95	173.664
209.5	97	175.189
210.5	 3	150.853
210.5	 5	152.383
210.5	10	154.738
210.5	25	158.672
210.5	50	163.040
210.5	75	167.405
210.5	90	171.332
210.5	95	173.680
210.5	97	175.205
211.5	 3	150.867
211.5	 5	152.398
211.5	10	154.754
211.5	25	158.689
211.5	50	163.057
211.5	75	167.422
211.5	90	171.347
211.5	95	173.696
211.5	97	175.220
212.5	 3	150.881
212.5	 5	152.412
212.5	10	154.769
212.5	25	158.704
212.5	50	163.073
212.5	75	167.438
212.5	90	171.363
212.5	95	173.710
212.5	97	175.234
213.5	 3	150.895
213.5	 5	152.426
213.5	10	154.784
213.5	25	158.719
213.5	50	163.088
213.5	75	167.453
213.5	90	171.377
213.5	95	173.725
213.5	97	175.248
214.5	 3	150.908
214.5	 5	152.440
214.5	10	154.797
214.5	25	158.734
214.5	50	163.103
214.5	75	167.467
214.5	90	171.392
214.5	95	173.738
214.5	97	175.262
215.5	 3	150.920
215.5	 5	152.452
215.5	10	154.811
215.5	25	158.748
215.5	50	163.117
215.5	75	167.481
215.5	90	171.405
215.5	95	173.751
215.5	97	175.274
216.5	 3	150.932
216.5	 5	152.465
216.5	10	154.824
216.5	25	158.761
216.5	50	163.131
216.5	75	167.495
216.5	90	171.418
216.5	95	173.764
216.5	97	175.286
217.5	 3	150.943
217.5	 5	152.476
217.5	10	154.836
217.5	25	158.774
217.5	50	163.144
217.5	75	167.508
217.5	90	171.430
217.5	95	173.776
217.5	97	175.298
218.5	 3	150.954
218.5	 5	152.488
218.5	10	154.848
218.5	25	158.786
218.5	50	163.156
218.5	75	167.520
218.5	90	171.442
218.5	95	173.787
218.5	97	175.309
219.5	 3	150.965
219.5	 5	152.499
219.5	10	154.859
219.5	25	158.798
219.5	50	163.169
219.5	75	167.532
219.5	90	171.454
219.5	95	173.798
219.5	97	175.320
220.5	 3	150.975
220.5	 5	152.509
220.5	10	154.870
220.5	25	158.810
220.5	50	163.180
220.5	75	167.544
220.5	90	171.465
220.5	95	173.809
220.5	97	175.330
221.5	 3	150.985
221.5	 5	152.519
221.5	10	154.880
221.5	25	158.821
221.5	50	163.191
221.5	75	167.555
221.5	90	171.475
221.5	95	173.819
221.5	97	175.340
222.5	 3	150.994
222.5	 5	152.529
222.5	10	154.891
222.5	25	158.831
222.5	50	163.202
222.5	75	167.565
222.5	90	171.486
222.5	95	173.829
222.5	97	175.350
223.5	 3	151.003
223.5	 5	152.538
223.5	10	154.900
223.5	25	158.842
223.5	50	163.213
223.5	75	167.575
223.5	90	171.495
223.5	95	173.838
223.5	97	175.359
224.5	 3	151.012
224.5	 5	152.547
224.5	10	154.910
224.5	25	158.851
224.5	50	163.223
224.5	75	167.585
224.5	90	171.505
224.5	95	173.847
224.5	97	175.368
225.5	 3	151.020
225.5	 5	152.556
225.5	10	154.919
225.5	25	158.861
225.5	50	163.232
225.5	75	167.595
225.5	90	171.514
225.5	95	173.856
225.5	97	175.376
226.5	 3	151.028
226.5	 5	152.564
226.5	10	154.927
226.5	25	158.870
226.5	50	163.241
226.5	75	167.604
226.5	90	171.523
226.5	95	173.864
226.5	97	175.384
227.5	 3	151.036
227.5	 5	152.572
227.5	10	154.936
227.5	25	158.879
227.5	50	163.250
227.5	75	167.613
227.5	90	171.531
227.5	95	173.873
227.5	97	175.392
228.5	 3	151.043
228.5	 5	152.580
228.5	10	154.944
228.5	25	158.887
228.5	50	163.259
228.5	75	167.621
228.5	90	171.539
228.5	95	173.880
228.5	97	175.399
229.5	 3	151.050
229.5	 5	152.587
229.5	10	154.952
229.5	25	158.895
229.5	50	163.267
229.5	75	167.629
229.5	90	171.547
229.5	95	173.888
229.5	97	175.406
230.5	 3	151.057
230.5	 5	152.594
230.5	10	154.959
230.5	25	158.903
230.5	50	163.275
230.5	75	167.637
230.5	90	171.554
230.5	95	173.895
230.5	97	175.413
231.5	 3	151.064
231.5	 5	152.601
231.5	10	154.966
231.5	25	158.911
231.5	50	163.283
231.5	75	167.645
231.5	90	171.562
231.5	95	173.902
231.5	97	175.420
232.5	 3	151.070
232.5	 5	152.608
232.5	10	154.973
232.5	25	158.918
232.5	50	163.290
232.5	75	167.652
232.5	90	171.568
232.5	95	173.908
232.5	97	175.426
233.5	 3	151.076
233.5	 5	152.614
233.5	10	154.980
233.5	25	158.925
233.5	50	163.298
233.5	75	167.659
233.5	90	171.575
233.5	95	173.915
233.5	97	175.433
234.5	 3	151.082
234.5	 5	152.621
234.5	10	154.986
234.5	25	158.932
234.5	50	163.304
234.5	75	167.666
234.5	90	171.582
234.5	95	173.921
234.5	97	175.438
235.5	 3	151.088
235.5	 5	152.626
235.5	10	154.993
235.5	25	158.938
235.5	50	163.311
235.5	75	167.672
235.5	90	171.588
235.5	95	173.927
235.5	97	175.444
236.5	 3	151.093
236.5	 5	152.632
236.5	10	154.999
236.5	25	158.945
236.5	50	163.318
236.5	75	167.678
236.5	90	171.594
236.5	95	173.932
236.5	97	175.450
237.5	 3	151.099
237.5	 5	152.638
237.5	10	155.004
237.5	25	158.951
237.5	50	163.324
237.5	75	167.685
237.5	90	171.599
237.5	95	173.938
237.5	97	175.455
238.5	 3	151.104
238.5	 5	152.643
238.5	10	155.010
238.5	25	158.957
238.5	50	163.330
238.5	75	167.690
238.5	90	171.605
238.5	95	173.943
238.5	97	175.460
239.5	 3	151.109
239.5	 5	152.648
239.5	10	155.015
239.5	25	158.962
239.5	50	163.335
239.5	75	167.696
239.5	90	171.610
239.5	95	173.948
239.5	97	175.465
240.0	 3	151.111
240.0	 5	152.651
240.0	10	155.018
240.0	25	158.965
240.0	50	163.338
240.0	75	167.699
240.0	90	171.613
240.0	95	173.951
240.0	97	175.467
