/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.tagger.io.TSVTaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TextTaggedFileReader;
import edu.stanford.nlp.tagger.io.TreeTaggedFileReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class TaggedFileRecord {
    final String file;
    final Format format;
    final String encoding;
    final String tagSeparator;
    final TreeTransformer treeTransformer;
    final TreeNormalizer treeNormalizer;
    final NumberRangesFileFilter treeRange;
    final Filter<Tree> treeFilter;
    final Integer wordColumn;
    final Integer tagColumn;
    public static final String FORMAT = "format";
    public static final String ENCODING = "encoding";
    public static final String TAG_SEPARATOR = "tagSeparator";
    public static final String TREE_TRANSFORMER = "treeTransformer";
    public static final String TREE_NORMALIZER = "treeNormalizer";
    public static final String TREE_RANGE = "treeRange";
    public static final String TREE_FILTER = "treeFilter";
    public static final String WORD_COLUMN = "wordColumn";
    public static final String TAG_COLUMN = "tagColumn";

    private TaggedFileRecord(String file, Format format, String encoding, String tagSeparator, TreeTransformer treeTransformer, TreeNormalizer treeNormalizer, NumberRangesFileFilter treeRange, Filter<Tree> treeFilter, Integer wordColumn, Integer tagColumn) {
        this.file = file;
        this.format = format;
        this.encoding = encoding;
        this.tagSeparator = tagSeparator;
        this.treeTransformer = treeTransformer;
        this.treeNormalizer = treeNormalizer;
        this.treeRange = treeRange;
        this.treeFilter = treeFilter;
        this.wordColumn = wordColumn;
        this.tagColumn = tagColumn;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("format=" + (Object)((Object)this.format));
        s.append(",encoding=" + this.encoding);
        s.append(",tagSeparator=" + this.tagSeparator);
        if (this.treeTransformer != null) {
            s.append(",treeTransformer=" + this.treeTransformer.getClass().getName());
        }
        if (this.treeNormalizer != null) {
            s.append(",treeNormalizer=" + this.treeNormalizer.getClass().getName());
        }
        if (this.treeRange != null) {
            s.append(",treeRange=" + this.treeRange.toString().replaceAll(",", ":"));
        }
        if (this.treeRange != null) {
            s.append(",treeFilter=" + this.treeFilter.getClass().toString());
        }
        if (this.wordColumn != null) {
            s.append(",wordColumn=" + this.wordColumn);
        }
        if (this.tagColumn != null) {
            s.append(",tagColumn=" + this.tagColumn);
        }
        return s.toString();
    }

    public String filename() {
        return this.file;
    }

    public TaggedFileReader reader() {
        switch (this.format) {
            case TEXT: {
                return new TextTaggedFileReader(this);
            }
            case TREES: {
                return new TreeTaggedFileReader(this);
            }
            case TSV: {
                return new TSVTaggedFileReader(this);
            }
        }
        throw new IllegalArgumentException("Unknown format " + (Object)((Object)this.format));
    }

    public static List<TaggedFileRecord> createRecords(Properties config, String description) {
        String[] pieces = description.split(";");
        ArrayList<TaggedFileRecord> records = new ArrayList<TaggedFileRecord>();
        for (String piece : pieces) {
            records.add(TaggedFileRecord.createRecord(config, piece));
        }
        return records;
    }

    public static TaggedFileRecord createRecord(Properties config, String description) {
        String[] pieces = description.split(",");
        if (pieces.length == 1) {
            return new TaggedFileRecord(description, Format.TEXT, TaggedFileRecord.getEncoding(config), TaggedFileRecord.getTagSeparator(config), null, null, null, null, null, null);
        }
        String[] args = new String[pieces.length - 1];
        System.arraycopy(pieces, 0, args, 0, pieces.length - 1);
        String file = pieces[pieces.length - 1];
        Format format = Format.TEXT;
        String encoding = TaggedFileRecord.getEncoding(config);
        String tagSeparator = TaggedFileRecord.getTagSeparator(config);
        TreeTransformer treeTransformer = null;
        TreeNormalizer treeNormalizer = null;
        NumberRangesFileFilter treeRange = null;
        Filter treeFilter = null;
        Integer wordColumn = null;
        Integer tagColumn = null;
        for (String arg : args) {
            String[] argPieces = arg.split("=", 2);
            if (argPieces.length != 2) {
                throw new IllegalArgumentException("TaggedFileRecord argument " + arg + " has an unexpected number of =s");
            }
            if (argPieces[0].equalsIgnoreCase(FORMAT)) {
                format = Format.valueOf(argPieces[1]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(ENCODING)) {
                encoding = argPieces[1];
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TAG_SEPARATOR)) {
                tagSeparator = argPieces[1];
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_TRANSFORMER)) {
                treeTransformer = (TreeTransformer)ReflectionLoading.loadByReflection(argPieces[1], new Object[0]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_NORMALIZER)) {
                treeNormalizer = (TreeNormalizer)ReflectionLoading.loadByReflection(argPieces[1], new Object[0]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_RANGE)) {
                String range = argPieces[1].replaceAll(":", ",");
                treeRange = new NumberRangesFileFilter(range, true);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TREE_FILTER)) {
                treeFilter = (Filter)ReflectionLoading.loadByReflection(argPieces[1], new Object[0]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(WORD_COLUMN)) {
                wordColumn = Integer.valueOf(argPieces[1]);
                continue;
            }
            if (argPieces[0].equalsIgnoreCase(TAG_COLUMN)) {
                tagColumn = Integer.valueOf(argPieces[1]);
                continue;
            }
            throw new IllegalArgumentException("TaggedFileRecord argument " + argPieces[0] + " is unknown");
        }
        return new TaggedFileRecord(file, format, encoding, tagSeparator, treeTransformer, treeNormalizer, treeRange, treeFilter, wordColumn, tagColumn);
    }

    public static String getEncoding(Properties config) {
        String encoding = config.getProperty(ENCODING);
        if (encoding == null) {
            return "UTF-8";
        }
        return encoding;
    }

    public static String getTagSeparator(Properties config) {
        String tagSeparator = config.getProperty(TAG_SEPARATOR);
        if (tagSeparator == null) {
            return "/";
        }
        return tagSeparator;
    }

    public static enum Format {
        TEXT,
        TSV,
        TREES;

    }
}

