package JIRA::REST::Class::Issue::Status::Category;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.02';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the category of an issue's status.

__PACKAGE__->mk_data_ro_accessors(qw/ name colorName id key self /);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Status::Category - A helper class for C<JIRA::REST::Class> that represents the category of an issue's status.

=head1 VERSION

version 0.02

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
