# Generated by default/object.tt
package Paws::CloudFront::RealtimeLogConfigs;
  use Moose;
  has IsTruncated => (is => 'ro', isa => 'Bool', required => 1);
  has Items => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::RealtimeLogConfig]');
  has Marker => (is => 'ro', isa => 'Str', required => 1);
  has MaxItems => (is => 'ro', isa => 'Int', required => 1);
  has NextMarker => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::RealtimeLogConfigs

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::RealtimeLogConfigs object:

  $service_obj->Method(Att1 => { IsTruncated => $value, ..., NextMarker => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::RealtimeLogConfigs object:

  $result = $service_obj->Method(...);
  $result->Att1->IsTruncated

=head1 DESCRIPTION

A list of real-time log configurations.

=head1 ATTRIBUTES


=head2 B<REQUIRED> IsTruncated => Bool

A flag that indicates whether there are more real-time log
configurations than are contained in this list.


=head2 Items => ArrayRef[L<Paws::CloudFront::RealtimeLogConfig>]

Contains the list of real-time log configurations.


=head2 B<REQUIRED> Marker => Str

This parameter indicates where this list of real-time log
configurations begins. This list includes real-time log configurations
that occur after the marker.


=head2 B<REQUIRED> MaxItems => Int

The maximum number of real-time log configurations requested.


=head2 NextMarker => Str

If there are more items in the list than are in this response, this
element is present. It contains the value that you should use in the
C<Marker> field of a subsequent request to continue listing real-time
log configurations where you left off.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

