#!/usr/bin/perl

package eBay::API::XML::DataType::SiteDefaultsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteDefaultsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SiteDefaultsType

=head1 DESCRIPTION

A container node for feature definitions that apply to the entire site.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SiteDefaultsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ListingDurationReferenceType;
use eBay::API::XML::DataType::ListingEnhancementDurationReferenceType;
use eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType;
use eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType;
use eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType;
use eBay::API::XML::DataType::Enum::GeographicExposureCodeType;
use eBay::API::XML::DataType::Enum::INEscrowWorkflowTimelineCodeType;
use eBay::API::XML::DataType::Enum::ItemSpecificsEnabledCodeType;


my @gaProperties = ( [ 'AdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'BasicUpgradePackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferCounterEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BuyerGuaranteeEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'ClassifiedAdCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdPayPerLeadEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdPaymentMethodEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'ClassifiedAdPhoneCount', 'xs:int', '', '', '' ]
	, [ 'ClassifiedAdShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ClassifiedAdStreetCount', 'xs:int', '', '', '' ]
	, [ 'CombinedFixedPriceTreatmentEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeAustraliaEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeGBEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossBorderTradeNorthAmericaEnabled', 'xs:boolean', '', '', '' ]
	, [ 'DutchBINEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ExpressConditionRequired', 'xs:boolean', '', '', '' ]
	, [ 'ExpressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ExpressPicturesRequired', 'xs:boolean', '', '', '' ]
	, [ 'GalleryFeaturedDurations', 'ns:ListingEnhancementDurationReferenceType', ''
	     ,'eBay::API::XML::DataType::ListingEnhancementDurationReferenceType', '1' ]
	, [ 'HomePageFeaturedEnabled', 'xs:boolean', '', '', '' ]
	, [ 'INEscrowWorkflowTimeline', 'ns:INEscrowWorkflowTimelineCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::INEscrowWorkflowTimelineCodeType', '' ]
	, [ 'ItemSpecificsEnabled', 'ns:ItemSpecificsEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSpecificsEnabledCodeType', '' ]
	, [ 'ListingDuration', 'ns:ListingDurationReferenceType', '1'
	     ,'eBay::API::XML::DataType::ListingDurationReferenceType', '1' ]
	, [ 'LocalListingDistancesNonSubscription', 'xs:string', '', '', '' ]
	, [ 'LocalListingDistancesRegular', 'xs:string', '', '', '' ]
	, [ 'LocalListingDistancesSpecialty', 'xs:string', '', '', '' ]
	, [ 'LocalMarketAdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'LocalMarketAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'LocalMarketCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketNonSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketPaymentMethodCheckOutEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'LocalMarketPhoneCount', 'xs:int', '', '', '' ]
	, [ 'LocalMarketPremiumSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketRegularSubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketSellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketSpecialitySubscription', 'xs:boolean', '', '', '' ]
	, [ 'LocalMarketStreetCount', 'xs:int', '', '', '' ]
	, [ 'MinimumReservePrice', 'xs:double', '', '', '' ]
	, [ 'NonSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'PaisaPayFullEscrowEnabled', 'xs:boolean', '', '', '' ]
	, [ 'PayPalBuyerProtectionEnabled', 'xs:boolean', '', '', '' ]
	, [ 'PayPalRequired', 'xs:boolean', '', '', '' ]
	, [ 'PremiumSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'ProPackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ProPackPlusEnabled', 'xs:boolean', '', '', '' ]
	, [ 'RegularSubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'SafePaymentRequired', 'xs:boolean', '', '', '' ]
	, [ 'SellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'ShippingTermsRequired', 'xs:boolean', '', '', '' ]
	, [ 'SkypeMeNonTransactionalEnabled', 'xs:boolean', '', '', '' ]
	, [ 'SkypeMeTransactionalEnabled', 'xs:boolean', '', '', '' ]
	, [ 'SpecialitySubscription', 'ns:GeographicExposureCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GeographicExposureCodeType', '' ]
	, [ 'StoreInventoryEnabled', 'xs:boolean', '', '', '' ]
	, [ 'TransactionConfirmationRequestEnabled', 'xs:boolean', '', '', '' ]
	, [ 'UserConsentRequired', 'xs:boolean', '', '', '' ]
	, [ 'ValuePackEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProAdFormatEnabled', 'ns:AdFormatEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AdFormatEnabledCodeType', '' ]
	, [ 'eBayMotorsProAutoAcceptEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProAutoDeclineEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdBestOfferEnabledCodeType', '' ]
	, [ 'eBayMotorsProCompanyNameEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByAddressEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByEmailEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProContactByPhoneEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProCounterOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProPaymentMethodCheckOutEnabled', 'ns:ClassifiedAdPaymentMethodEnabledCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ClassifiedAdPaymentMethodEnabledCodeType', '' ]
	, [ 'eBayMotorsProPhoneCount', 'xs:int', '', '', '' ]
	, [ 'eBayMotorsProSellerContactDetailsEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProShippingMethodEnabled', 'xs:boolean', '', '', '' ]
	, [ 'eBayMotorsProStreetCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdFormatEnabled()

Specifies the default site setting for whether categories allow
Classified Ad format listings. True means the feature is allowed site-wide,
unless a specific category overrides the setting.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setAdFormatEnabled {
  my $self = shift;
  $self->{'AdFormatEnabled'} = shift
}

=head2 getAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getAdFormatEnabled {
  my $self = shift;
  return $self->{'AdFormatEnabled'};
}


=head2 setBasicUpgradePackEnabled()

Specifies the default site setting for whether
categories allow the BasicUpgradePack feature (a feature pack).
No longer allowed on any sites.
Formerly, Australia site (site ID 15, abbreviation AU) only.

#    Argument: 'xs:boolean'

=cut

sub setBasicUpgradePackEnabled {
  my $self = shift;
  $self->{'BasicUpgradePackEnabled'} = shift
}

=head2 isBasicUpgradePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBasicUpgradePackEnabled {
  my $self = shift;
  return $self->{'BasicUpgradePackEnabled'};
}


=head2 setBestOfferAutoAcceptEnabled()

Specifies the default site setting for whether categories allow
auto-accept for Best Offers.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferAutoAcceptEnabled {
  my $self = shift;
  $self->{'BestOfferAutoAcceptEnabled'} = shift
}

=head2 isBestOfferAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferAutoAcceptEnabled {
  my $self = shift;
  return $self->{'BestOfferAutoAcceptEnabled'};
}


=head2 setBestOfferAutoDeclineEnabled()

Specifies the default site setting for whether categories allow
auto decline for Best Offers. True means auto decline is allowed site-wide,
unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferAutoDeclineEnabled {
  my $self = shift;
  $self->{'BestOfferAutoDeclineEnabled'} = shift
}

=head2 isBestOfferAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferAutoDeclineEnabled {
  my $self = shift;
  return $self->{'BestOfferAutoDeclineEnabled'};
}


=head2 setBestOfferCounterEnabled()

Specifies the default site setting for whether categories allow counter offers
for Best Offers. True means counter offers are allowed site-wide, unless a
specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferCounterEnabled {
  my $self = shift;
  $self->{'BestOfferCounterEnabled'} = shift
}

=head2 isBestOfferCounterEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferCounterEnabled {
  my $self = shift;
  return $self->{'BestOfferCounterEnabled'};
}


=head2 setBestOfferEnabled()

Specifies the default site setting for whether categories allow
Best Offers. True means Best Offers are allowed site-wide,
unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 isBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferEnabled {
  my $self = shift;
  return $self->{'BestOfferEnabled'};
}


=head2 setBuyerGuaranteeEnabled()

For the Australia site, if both PayPalBuyerProtectionEnabled and
BuyerGuaranteeEnabled are returned, then the default site setting
is that categories allow buyer protection.

#    Argument: 'xs:boolean'

=cut

sub setBuyerGuaranteeEnabled {
  my $self = shift;
  $self->{'BuyerGuaranteeEnabled'} = shift
}

=head2 isBuyerGuaranteeEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBuyerGuaranteeEnabled {
  my $self = shift;
  return $self->{'BuyerGuaranteeEnabled'};
}


=head2 setClassifiedAdAutoAcceptEnabled()

Specifies the default site setting for whether categories allow
auto-accept for Best Offers for Classified Ads.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoAcceptEnabled'} = shift
}

=head2 isClassifiedAdAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdAutoAcceptEnabled'};
}


=head2 setClassifiedAdAutoDeclineEnabled()

Indicates whether automatic decline for Best Offers is allowed for most
categories.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoDeclineEnabled'} = shift
}

=head2 isClassifiedAdAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdAutoDeclineEnabled'};
}


=head2 setClassifiedAdBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings
in most categories.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setClassifiedAdBestOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdBestOfferEnabled'} = shift
}

=head2 getClassifiedAdBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getClassifiedAdBestOfferEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdBestOfferEnabled'};
}


=head2 setClassifiedAdCompanyNameEnabled()

Indicates whether most categories support including a company name in the
seller's contact information. This element is for For Sale By Owner.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdCompanyNameEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCompanyNameEnabled'} = shift
}

=head2 isClassifiedAdCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdCompanyNameEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdCompanyNameEnabled'};
}


=head2 setClassifiedAdContactByAddressEnabled()

Indicates whether most categories support including an address in the seller's
contact information. This element is for For Sale By Owner.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByAddressEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByAddressEnabled'} = shift
}

=head2 isClassifiedAdContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByAddressEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByAddressEnabled'};
}


=head2 setClassifiedAdContactByEmailEnabled()

Indicates whether most categories support including an email address in the
seller's contact information.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByEmailEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByEmailEnabled'} = shift
}

=head2 isClassifiedAdContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByEmailEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByEmailEnabled'};
}


=head2 setClassifiedAdContactByPhoneEnabled()

Indicates whether most categories support including a phone number in the
seller's contact information.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByPhoneEnabled'} = shift
}

=head2 isClassifiedAdContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdContactByPhoneEnabled'};
}


=head2 setClassifiedAdCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for
most categories.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdCounterOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCounterOfferEnabled'} = shift
}

=head2 isClassifiedAdCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdCounterOfferEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdCounterOfferEnabled'};
}


=head2 setClassifiedAdPayPerLeadEnabled()

Specifies the default site setting for whether the pay-per-lead feature
is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPayPerLeadEnabled'} = shift
}

=head2 isClassifiedAdPayPerLeadEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdPayPerLeadEnabled'};
}


=head2 setClassifiedAdPaymentMethodEnabled()

Indicates if the payment method should be displayed to the user
for most categories. Even if enabled, checkout may or may not
be enabled.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPaymentMethodEnabled'} = shift
}

=head2 getClassifiedAdPaymentMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdPaymentMethodEnabled'};
}


=head2 setClassifiedAdPhoneCount()

Indicates which telephone option is enabled to
contact the seller. This element is for For Sale By Owner.

#    Argument: 'xs:int'

=cut

sub setClassifiedAdPhoneCount {
  my $self = shift;
  $self->{'ClassifiedAdPhoneCount'} = shift
}

=head2 getClassifiedAdPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getClassifiedAdPhoneCount {
  my $self = shift;
  return $self->{'ClassifiedAdPhoneCount'};
}


=head2 setClassifiedAdShippingMethodEnabled()

Indicates if shipping options are available for most categories.

#    Argument: 'xs:boolean'

=cut

sub setClassifiedAdShippingMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdShippingMethodEnabled'} = shift
}

=head2 isClassifiedAdShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isClassifiedAdShippingMethodEnabled {
  my $self = shift;
  return $self->{'ClassifiedAdShippingMethodEnabled'};
}


=head2 setClassifiedAdStreetCount()

Indicates which address option is enabled to
contact the seller. This element is for For Sale By Owner.

#    Argument: 'xs:int'

=cut

sub setClassifiedAdStreetCount {
  my $self = shift;
  $self->{'ClassifiedAdStreetCount'} = shift
}

=head2 getClassifiedAdStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getClassifiedAdStreetCount {
  my $self = shift;
  return $self->{'ClassifiedAdStreetCount'};
}


=head2 setCombinedFixedPriceTreatmentEnabled()

On the Italy site, specifies the default site setting
that categories allow combined fixed price treatment of
the following listing types: Store Inventory Format and
Basic Fixed Price.

#    Argument: 'xs:boolean'

=cut

sub setCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  $self->{'CombinedFixedPriceTreatmentEnabled'} = shift
}

=head2 isCombinedFixedPriceTreatmentEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  return $self->{'CombinedFixedPriceTreatmentEnabled'};
}


=head2 setCrossBorderTradeAustraliaEnabled()

Specifies the default site setting for whether categories allow
you to specify that listings be displayed in the default search
results of the respective site.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeAustraliaEnabled'} = shift
}

=head2 isCrossBorderTradeAustraliaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeAustraliaEnabled'};
}


=head2 setCrossBorderTradeGBEnabled()

Specifies the default site setting for whether categories allow
you to specify that listings be displayed in the default search
results of the respective site.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeGBEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeGBEnabled'} = shift
}

=head2 isCrossBorderTradeGBEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeGBEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeGBEnabled'};
}


=head2 setCrossBorderTradeNorthAmericaEnabled()

Specifies the default site setting for whether categories allow
you to specify that listings be displayed in the default search
results of the respective sites.

#    Argument: 'xs:boolean'

=cut

sub setCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeNorthAmericaEnabled'} = shift
}

=head2 isCrossBorderTradeNorthAmericaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  return $self->{'CrossBorderTradeNorthAmericaEnabled'};
}


=head2 setDutchBINEnabled()

Specifies the default site setting for whether categories allow
DutchBIN. True means Best Offers are allowed site-wide,
unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setDutchBINEnabled {
  my $self = shift;
  $self->{'DutchBINEnabled'} = shift
}

=head2 isDutchBINEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isDutchBINEnabled {
  my $self = shift;
  return $self->{'DutchBINEnabled'};
}


=head2 setExpressConditionRequired()

Specifies whether most categories on the site require a listing to include the
Item Condition attribute in order to qualify for eBay Express.
<br><br>
If true, items on the site require the Item Condition in order to qualify for
Express, but specific categories can override this requirement. For example,
on the US site, the Item Condition is normally required for Express listings.
However, the Event Tickets category could override this requirement because
there is little need to distinguish between new and used tickets. (People
rarely sell used tickets after an event unless the ticket is also a
collectible item.)<br>
If false, items on the site do not require the Item Condition,
but some categories may override the setting.<br><br>
Only meaningful if ExpressEnabled is true for the category.

#    Argument: 'xs:boolean'

=cut

sub setExpressConditionRequired {
  my $self = shift;
  $self->{'ExpressConditionRequired'} = shift
}

=head2 isExpressConditionRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressConditionRequired {
  my $self = shift;
  return $self->{'ExpressConditionRequired'};
}


=head2 setExpressEnabled()

Specifies whether most categories on the site are eligible for eBay Express.
eBay Express is a specialty site where customers can buy new, fixed-price
goods in a more conventional e-commerce experience.<br><br>
If true, items on the site are eligible for Express,
but specific categories can override the setting if they don't support Express.
For example, categories that are not covered by PayPal Buyer Protection
(e.g., Live Auctions and Motors vehicles) are excluded from Express.<br>
If false, items on the site are not eligible for Express,
but some categories may override the setting.<br><br>
If you list in an Express-enabled category, it does not necessarily mean that
the item will appear in that category when buyers browse and search Express.
It only means that the item can also be included on Express,
assuming all other Express eligibility requirements are met.
See "eBay Express" in the eBay Web Services guide for information about other
eligibility requirements.

#    Argument: 'xs:boolean'

=cut

sub setExpressEnabled {
  my $self = shift;
  $self->{'ExpressEnabled'} = shift
}

=head2 isExpressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressEnabled {
  my $self = shift;
  return $self->{'ExpressEnabled'};
}


=head2 setExpressPicturesRequired()

Specifies whether most categories on the site require a listing to include a picture
in order to qualify for eBay Express.<br><br>
If true, items on the site require a picture in order to qualify for Express,
but specific categories can override this requirement. For example, on the US
site, pictures are normally required for Express listings. However, the Event
Tickets category could override this requirement if pictures are not commonly
expected for tickets.<br>
If false, items on the site do not require a picture,
but some categories may override the setting.<br><br>
Only meaningful if ExpressEnabled is true for the category.

#    Argument: 'xs:boolean'

=cut

sub setExpressPicturesRequired {
  my $self = shift;
  $self->{'ExpressPicturesRequired'} = shift
}

=head2 isExpressPicturesRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpressPicturesRequired {
  my $self = shift;
  return $self->{'ExpressPicturesRequired'};
}


=head2 setGalleryFeaturedDurations()

On the Italy site, specifies the default site setting
that enables durations for "Gallery Featured".

#    Argument: 'ns:ListingEnhancementDurationReferenceType'

=cut

sub setGalleryFeaturedDurations {
  my $self = shift;
  $self->{'GalleryFeaturedDurations'} = shift
}

=head2 getGalleryFeaturedDurations()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ListingEnhancementDurationReferenceType'

=cut

sub getGalleryFeaturedDurations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'GalleryFeaturedDurations'
		,'eBay::API::XML::DataType::ListingEnhancementDurationReferenceType');
}


=head2 setHomePageFeaturedEnabled()

Indicates whether or not it is possible to enhance a listing by putting
it into a rotation for display on a special area of the eBay home page.
Support for this feature varies by site. Item or feedback restrictions may apply.

#    Argument: 'xs:boolean'

=cut

sub setHomePageFeaturedEnabled {
  my $self = shift;
  $self->{'HomePageFeaturedEnabled'} = shift
}

=head2 isHomePageFeaturedEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isHomePageFeaturedEnabled {
  my $self = shift;
  return $self->{'HomePageFeaturedEnabled'};
}


=head2 setINEscrowWorkflowTimeline()

Indicates the workflow timeline that applies to the category on the India
site: Default Workflow, Workflow A or Workflow B.

#    Argument: 'ns:INEscrowWorkflowTimelineCodeType'

=cut

sub setINEscrowWorkflowTimeline {
  my $self = shift;
  $self->{'INEscrowWorkflowTimeline'} = shift
}

=head2 getINEscrowWorkflowTimeline()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:INEscrowWorkflowTimelineCodeType'

=cut

sub getINEscrowWorkflowTimeline {
  my $self = shift;
  return $self->{'INEscrowWorkflowTimeline'};
}


=head2 setItemSpecificsEnabled()

Specifies whether most categories support on the site support
custom Item Specifics. If enabled, sellers can use the
Item.ItemSpecifics node in AddItem and related calls to fill in
Item Specifics.<br>
<br>
Item Specifics are typical aspects of items in the same category.
They enable users to classify items by presenting descriptive details
in a structured way. For example, in a jewelry category, sellers might
describe lockets with specifics like "Chain Length=18 in." and
"Main Shape=Heart", but in a Washers & Dryers category,
sellers might include "Type=Top-Loading" instead of "Main Shape=Heart".<br>
<br>
<span class="tablenote"><b>Note:</b> This does not
indicate whether categories support ID-based attributes.
For attributes, use GetCategory2CS instead.</span>

#    Argument: 'ns:ItemSpecificsEnabledCodeType'

=cut

sub setItemSpecificsEnabled {
  my $self = shift;
  $self->{'ItemSpecificsEnabled'} = shift
}

=head2 getItemSpecificsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ItemSpecificsEnabledCodeType'

=cut

sub getItemSpecificsEnabled {
  my $self = shift;
  return $self->{'ItemSpecificsEnabled'};
}


=head2 setListingDuration()

Specifies the ID of a set of default durations for a certain type of listing.
The actual duration values are returned within the FeatureDefinitions node.
The type of listing is named in the type attribute.

#    Argument: reference to an array  
                      of 'ns:ListingDurationReferenceType'

=cut

sub setListingDuration {
  my $self = shift;
  $self->{'ListingDuration'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getListingDuration()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'ns:ListingDurationReferenceType'

=cut

sub getListingDuration {
  my $self = shift;
  return $self->_getDataTypeArray('ListingDuration');
}


=head2 setLocalListingDistancesNonSubscription()

Specifies the supported local listing distances for most categories,
for users who have not subscribed to either Regular or Specialty vehicles.

#    Argument: 'xs:string'

=cut

sub setLocalListingDistancesNonSubscription {
  my $self = shift;
  $self->{'LocalListingDistancesNonSubscription'} = shift
}

=head2 getLocalListingDistancesNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getLocalListingDistancesNonSubscription {
  my $self = shift;
  return $self->{'LocalListingDistancesNonSubscription'};
}


=head2 setLocalListingDistancesRegular()

Specifies the supported local listing distances of regular vehicles
for most categories.

#    Argument: 'xs:string'

=cut

sub setLocalListingDistancesRegular {
  my $self = shift;
  $self->{'LocalListingDistancesRegular'} = shift
}

=head2 getLocalListingDistancesRegular()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getLocalListingDistancesRegular {
  my $self = shift;
  return $self->{'LocalListingDistancesRegular'};
}


=head2 setLocalListingDistancesSpecialty()

Specifies the supported local listing distances of specialty vehicles
for most categories.

#    Argument: 'xs:string'

=cut

sub setLocalListingDistancesSpecialty {
  my $self = shift;
  $self->{'LocalListingDistancesSpecialty'} = shift
}

=head2 getLocalListingDistancesSpecialty()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getLocalListingDistancesSpecialty {
  my $self = shift;
  return $self->{'LocalListingDistancesSpecialty'};
}


=head2 setLocalMarketAdFormatEnabled()

Specifies the default site setting for whether categories allow Classified Ad
listings. True means the feature is allowed site-wide, unless a specific
category overrides the setting. This element is for Local Market dealers.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setLocalMarketAdFormatEnabled {
  my $self = shift;
  $self->{'LocalMarketAdFormatEnabled'} = shift
}

=head2 getLocalMarketAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getLocalMarketAdFormatEnabled {
  my $self = shift;
  return $self->{'LocalMarketAdFormatEnabled'};
}


=head2 setLocalMarketAutoAcceptEnabled()

Specifies the default site setting for whether categories allow
auto-accept for Best Offers for Classified Ads.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketAutoAcceptEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoAcceptEnabled'} = shift
}

=head2 isLocalMarketAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketAutoAcceptEnabled {
  my $self = shift;
  return $self->{'LocalMarketAutoAcceptEnabled'};
}


=head2 setLocalMarketAutoDeclineEnabled()

Specifies the default site setting for whether categories allow
auto-decline for Best Offers for Classified Ads.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketAutoDeclineEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoDeclineEnabled'} = shift
}

=head2 isLocalMarketAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketAutoDeclineEnabled {
  my $self = shift;
  return $self->{'LocalMarketAutoDeclineEnabled'};
}


=head2 setLocalMarketBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings
in most categories. This element is for Local Market dealers.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setLocalMarketBestOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketBestOfferEnabled'} = shift
}

=head2 getLocalMarketBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getLocalMarketBestOfferEnabled {
  my $self = shift;
  return $self->{'LocalMarketBestOfferEnabled'};
}


=head2 setLocalMarketCompanyNameEnabled()

Indicates whether most categories support including a company name in the
seller's contact information. This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketCompanyNameEnabled {
  my $self = shift;
  $self->{'LocalMarketCompanyNameEnabled'} = shift
}

=head2 isLocalMarketCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketCompanyNameEnabled {
  my $self = shift;
  return $self->{'LocalMarketCompanyNameEnabled'};
}


=head2 setLocalMarketContactByAddressEnabled()

Indicates whether most categories support including an address in the seller's
contact information. This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByAddressEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByAddressEnabled'} = shift
}

=head2 isLocalMarketContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByAddressEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByAddressEnabled'};
}


=head2 setLocalMarketContactByEmailEnabled()

Indicates whether most categories support including an email address in the
seller's contact information. This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByEmailEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByEmailEnabled'} = shift
}

=head2 isLocalMarketContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByEmailEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByEmailEnabled'};
}


=head2 setLocalMarketContactByPhoneEnabled()

Indicates whether most categories support including a phone number in the
seller's contact information. This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketContactByPhoneEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByPhoneEnabled'} = shift
}

=head2 isLocalMarketContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketContactByPhoneEnabled {
  my $self = shift;
  return $self->{'LocalMarketContactByPhoneEnabled'};
}


=head2 setLocalMarketCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for
most categories. This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketCounterOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketCounterOfferEnabled'} = shift
}

=head2 isLocalMarketCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketCounterOfferEnabled {
  my $self = shift;
  return $self->{'LocalMarketCounterOfferEnabled'};
}


=head2 setLocalMarketNonSubscription()

Specifies the default site setting for whether LocalMarketNonSubscription
feature is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketNonSubscription {
  my $self = shift;
  $self->{'LocalMarketNonSubscription'} = shift
}

=head2 isLocalMarketNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketNonSubscription {
  my $self = shift;
  return $self->{'LocalMarketNonSubscription'};
}


=head2 setLocalMarketPaymentMethodCheckOutEnabled()

Indicates if the payment method should be displayed to the user
for most categories. Even if enabled, checkout may or may not
be enabled. This element is for Local Market dealers.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'LocalMarketPaymentMethodCheckOutEnabled'} = shift
}

=head2 getLocalMarketPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->{'LocalMarketPaymentMethodCheckOutEnabled'};
}


=head2 setLocalMarketPhoneCount()

Indicates which telephone option is enabled to
contact the seller. This element is for Local Market dealers.

#    Argument: 'xs:int'

=cut

sub setLocalMarketPhoneCount {
  my $self = shift;
  $self->{'LocalMarketPhoneCount'} = shift
}

=head2 getLocalMarketPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getLocalMarketPhoneCount {
  my $self = shift;
  return $self->{'LocalMarketPhoneCount'};
}


=head2 setLocalMarketPremiumSubscription()

Specifies the default site setting for whether LocalMarketPremiumSubscription
feature is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketPremiumSubscription {
  my $self = shift;
  $self->{'LocalMarketPremiumSubscription'} = shift
}

=head2 isLocalMarketPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketPremiumSubscription {
  my $self = shift;
  return $self->{'LocalMarketPremiumSubscription'};
}


=head2 setLocalMarketRegularSubscription()

Specifies the default site setting for whether LocalMarketRegularSubscription
feature is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketRegularSubscription {
  my $self = shift;
  $self->{'LocalMarketRegularSubscription'} = shift
}

=head2 isLocalMarketRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketRegularSubscription {
  my $self = shift;
  return $self->{'LocalMarketRegularSubscription'};
}


=head2 setLocalMarketSellerContactDetailsEnabled()

Specifies the default site setting for whether most categories allow seller-
level contact information for Classified Ad format listings. A value of true
means seller-level contact information is available for Classified Ad format
listings site-wide, unless a specific category overrides the setting. This
element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'LocalMarketSellerContactDetailsEnabled'} = shift
}

=head2 isLocalMarketSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'LocalMarketSellerContactDetailsEnabled'};
}


=head2 setLocalMarketShippingMethodEnabled()

Indicates if shipping options are available for most categories.
This element is for Local Market dealers.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketShippingMethodEnabled {
  my $self = shift;
  $self->{'LocalMarketShippingMethodEnabled'} = shift
}

=head2 isLocalMarketShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketShippingMethodEnabled {
  my $self = shift;
  return $self->{'LocalMarketShippingMethodEnabled'};
}


=head2 setLocalMarketSpecialitySubscription()

Specifies the default site setting for whether
LocalMarketSpecialitySubscription feature is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setLocalMarketSpecialitySubscription {
  my $self = shift;
  $self->{'LocalMarketSpecialitySubscription'} = shift
}

=head2 isLocalMarketSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLocalMarketSpecialitySubscription {
  my $self = shift;
  return $self->{'LocalMarketSpecialitySubscription'};
}


=head2 setLocalMarketStreetCount()

Indicates which address option is enabled to
contact the seller. This element is for Local Market dealers.

#    Argument: 'xs:int'

=cut

sub setLocalMarketStreetCount {
  my $self = shift;
  $self->{'LocalMarketStreetCount'} = shift
}

=head2 getLocalMarketStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getLocalMarketStreetCount {
  my $self = shift;
  return $self->{'LocalMarketStreetCount'};
}


=head2 setMinimumReservePrice()

Specifies the default site setting for whether the Minimum Reserve Price
feature is supported for most categories.

#    Argument: 'xs:double'

=cut

sub setMinimumReservePrice {
  my $self = shift;
  $self->{'MinimumReservePrice'} = shift
}

=head2 getMinimumReservePrice()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:double'

=cut

sub getMinimumReservePrice {
  my $self = shift;
  return $self->{'MinimumReservePrice'};
}


=head2 setNonSubscription()

Specifies the supported local listing distances for most categories,
for users who have not subscribed to either Regular or Specialty vehicles.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setNonSubscription {
  my $self = shift;
  $self->{'NonSubscription'} = shift
}

=head2 getNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getNonSubscription {
  my $self = shift;
  return $self->{'NonSubscription'};
}


=head2 setPaisaPayFullEscrowEnabled()

Indicates whether the site is enabled for PaisaPayEscrow payment method. If
"true" sellers can offer PaisaPayEscrow and PaisaPayEscrow EMI payment methods
in the site.

#    Argument: 'xs:boolean'

=cut

sub setPaisaPayFullEscrowEnabled {
  my $self = shift;
  $self->{'PaisaPayFullEscrowEnabled'} = shift
}

=head2 isPaisaPayFullEscrowEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPaisaPayFullEscrowEnabled {
  my $self = shift;
  return $self->{'PaisaPayFullEscrowEnabled'};
}


=head2 setPayPalBuyerProtectionEnabled()

For the Australia site, if both PayPalBuyerProtectionEnabled and
BuyerGuaranteeEnabled are returned, then the default site setting
is that categories allow buyer protection.

#    Argument: 'xs:boolean'

=cut

sub setPayPalBuyerProtectionEnabled {
  my $self = shift;
  $self->{'PayPalBuyerProtectionEnabled'} = shift
}

=head2 isPayPalBuyerProtectionEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPayPalBuyerProtectionEnabled {
  my $self = shift;
  return $self->{'PayPalBuyerProtectionEnabled'};
}


=head2 setPayPalRequired()

Specifies the default site setting for whether
categories have PayPal as a required payment method for listings.

#    Argument: 'xs:boolean'

=cut

sub setPayPalRequired {
  my $self = shift;
  $self->{'PayPalRequired'} = shift
}

=head2 isPayPalRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPayPalRequired {
  my $self = shift;
  return $self->{'PayPalRequired'};
}


=head2 setPremiumSubscription()

Specifies the default site setting for whether LocalMarketPremiumSubscription
feature is supported for most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setPremiumSubscription {
  my $self = shift;
  $self->{'PremiumSubscription'} = shift
}

=head2 getPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getPremiumSubscription {
  my $self = shift;
  return $self->{'PremiumSubscription'};
}


=head2 setProPackEnabled()

Specifies the default site setting for whether categories allow
the ProPack feature (a feature pack). True means ProPack is allowed site-wide,
unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setProPackEnabled {
  my $self = shift;
  $self->{'ProPackEnabled'} = shift
}

=head2 isProPackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isProPackEnabled {
  my $self = shift;
  return $self->{'ProPackEnabled'};
}


=head2 setProPackPlusEnabled()

Specifies the default site setting for whether
categories allow the ProPackPlus feature (a feature pack).
True means it is allowed site-wide, unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setProPackPlusEnabled {
  my $self = shift;
  $self->{'ProPackPlusEnabled'} = shift
}

=head2 isProPackPlusEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isProPackPlusEnabled {
  my $self = shift;
  return $self->{'ProPackPlusEnabled'};
}


=head2 setRegularSubscription()

Specifies the default site setting for whether LocalMarketRegularSubscription
feature is supported for most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setRegularSubscription {
  my $self = shift;
  $self->{'RegularSubscription'} = shift
}

=head2 getRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getRegularSubscription {
  my $self = shift;
  return $self->{'RegularSubscription'};
}


=head2 setSafePaymentRequired()

Specifies whether most categories on the site should require a seller who
registered after January 17, 2007 to offer a safe payment method, i.e.
PaisaPay/PayPal or one of the credit cards specified in Item.PaymentMethods).
If a seller has a 'SafePaymentExempt' status, they are exempt from the
category requirement to offer at least one safe payment method, even if the
site and category have the safe payment method turned on. If true, items on
the site need to have the safe payment method selected, but specific
categories can override the setting if they don't need this requirement. For
example, Business and Industrial, Motors, Real Estate, and Mature Audiences
categories, and all listings that don't support Item.PaymentMethods are
exempt from this requirement, which means that any seller can list without
any safe payment method selected.
<br>
If false, all sellers in all categories can list without any safe payment
method selected and this setting cannot be overridden at the category level.
If site is not enabled, there is no category where this requirement is
enabled on that site.

#    Argument: 'xs:boolean'

=cut

sub setSafePaymentRequired {
  my $self = shift;
  $self->{'SafePaymentRequired'} = shift
}

=head2 isSafePaymentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSafePaymentRequired {
  my $self = shift;
  return $self->{'SafePaymentRequired'};
}


=head2 setSellerContactDetailsEnabled()

Specifies the default site setting for whether most categories allow seller-
level contact information for Classified Ad listings. A value of true means
seller-level contact information is available for Classified Ad format
listings site-wide, unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'SellerContactDetailsEnabled'} = shift
}

=head2 isSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'SellerContactDetailsEnabled'};
}


=head2 setShippingTermsRequired()

Specifies the default site setting for whether sellers are
required to specify a domestic shipping service and its associated cost
when listing items. True means the shipping terms are required
unless a specific category overrides this setting.

#    Argument: 'xs:boolean'

=cut

sub setShippingTermsRequired {
  my $self = shift;
  $self->{'ShippingTermsRequired'} = shift
}

=head2 isShippingTermsRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isShippingTermsRequired {
  my $self = shift;
  return $self->{'ShippingTermsRequired'};
}


=head2 setSkypeMeNonTransactionalEnabled()

Specifies the default site setting for whether most
categories allow the addition of Skype buttons to listings
for non-transactional formats (e.g., the advertisement format).

#    Argument: 'xs:boolean'

=cut

sub setSkypeMeNonTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeNonTransactionalEnabled'} = shift
}

=head2 isSkypeMeNonTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSkypeMeNonTransactionalEnabled {
  my $self = shift;
  return $self->{'SkypeMeNonTransactionalEnabled'};
}


=head2 setSkypeMeTransactionalEnabled()

Specifies the default site setting for whether most
categories allow the addition of Skype buttons to listings
for transactional formats (e.g., the Chinese auction format).

#    Argument: 'xs:boolean'

=cut

sub setSkypeMeTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeTransactionalEnabled'} = shift
}

=head2 isSkypeMeTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSkypeMeTransactionalEnabled {
  my $self = shift;
  return $self->{'SkypeMeTransactionalEnabled'};
}


=head2 setSpecialitySubscription()

Specifies the default site setting for whether
LocalMarketSpecialitySubscription feature is supported for most categories.

#    Argument: 'ns:GeographicExposureCodeType'

=cut

sub setSpecialitySubscription {
  my $self = shift;
  $self->{'SpecialitySubscription'} = shift
}

=head2 getSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:GeographicExposureCodeType'

=cut

sub getSpecialitySubscription {
  my $self = shift;
  return $self->{'SpecialitySubscription'};
}


=head2 setStoreInventoryEnabled()

Specifies the default site setting for whether categories allow the Store
Inventory Format feature. True means the feature is allowed site-wide, unless
a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setStoreInventoryEnabled {
  my $self = shift;
  $self->{'StoreInventoryEnabled'} = shift
}

=head2 isStoreInventoryEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isStoreInventoryEnabled {
  my $self = shift;
  return $self->{'StoreInventoryEnabled'};
}


=head2 setTransactionConfirmationRequestEnabled()

Specifies the default site setting for whether the Transaction Confirmation
Request feature is supported for most categories.

#    Argument: 'xs:boolean'

=cut

sub setTransactionConfirmationRequestEnabled {
  my $self = shift;
  $self->{'TransactionConfirmationRequestEnabled'} = shift
}

=head2 isTransactionConfirmationRequestEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isTransactionConfirmationRequestEnabled {
  my $self = shift;
  return $self->{'TransactionConfirmationRequestEnabled'};
}


=head2 setUserConsentRequired()

Specifies the default site setting for whether a bidder must consent to the
bid by confirming that he or she read and agrees to the terms in eBay's
privacy policy.

#    Argument: 'xs:boolean'

=cut

sub setUserConsentRequired {
  my $self = shift;
  $self->{'UserConsentRequired'} = shift
}

=head2 isUserConsentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isUserConsentRequired {
  my $self = shift;
  return $self->{'UserConsentRequired'};
}


=head2 setValuePackEnabled()

Specifies the default site setting for whether
categories allow the ValuePack feature (a feature pack).
True means it is allowed site-wide, unless a specific category overrides the setting.

#    Argument: 'xs:boolean'

=cut

sub setValuePackEnabled {
  my $self = shift;
  $self->{'ValuePackEnabled'} = shift
}

=head2 isValuePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isValuePackEnabled {
  my $self = shift;
  return $self->{'ValuePackEnabled'};
}


=head2 setEBayMotorsProAdFormatEnabled()

Specifies the default site setting for whether categories allow
Classified Ad listings. True means the feature is allowed site-wide,
unless a specific category overrides the setting. This element is for eBay Motors Pro users.

#    Argument: 'ns:AdFormatEnabledCodeType'

=cut

sub setEBayMotorsProAdFormatEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAdFormatEnabled'} = shift
}

=head2 getEBayMotorsProAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:AdFormatEnabledCodeType'

=cut

sub getEBayMotorsProAdFormatEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAdFormatEnabled'};
}


=head2 setEBayMotorsProAutoAcceptEnabled()

Specifies the default site setting for whether categories allow
auto-accept for Best Offers for Classified Ads.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoAcceptEnabled'} = shift
}

=head2 isEBayMotorsProAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAutoAcceptEnabled'};
}


=head2 setEBayMotorsProAutoDeclineEnabled()

Specifies the default site setting for whether categories allow
auto-decline for Best Offers for Classified Ads.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoDeclineEnabled'} = shift
}

=head2 isEBayMotorsProAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProAutoDeclineEnabled'};
}


=head2 setEBayMotorsProBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings
in most categories. This element is for eBay Motors Pro users.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub setEBayMotorsProBestOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProBestOfferEnabled'} = shift
}

=head2 getEBayMotorsProBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledCodeType'

=cut

sub getEBayMotorsProBestOfferEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProBestOfferEnabled'};
}


=head2 setEBayMotorsProCompanyNameEnabled()

Indicates whether most categories support including a company name in the
seller's contact information. This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCompanyNameEnabled'} = shift
}

=head2 isEBayMotorsProCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProCompanyNameEnabled'};
}


=head2 setEBayMotorsProContactByAddressEnabled()

Indicates whether most categories support including an address in the seller's
contact information. This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByAddressEnabled'} = shift
}

=head2 isEBayMotorsProContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByAddressEnabled'};
}


=head2 setEBayMotorsProContactByEmailEnabled()

Indicates whether most categories support including an email address in the
seller's contact information. This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByEmailEnabled'} = shift
}

=head2 isEBayMotorsProContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByEmailEnabled'};
}


=head2 setEBayMotorsProContactByPhoneEnabled()

Indicates whether most categories support including a phone number in the
seller's contact information. This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByPhoneEnabled'} = shift
}

=head2 isEBayMotorsProContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProContactByPhoneEnabled'};
}


=head2 setEBayMotorsProCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for
most categories. This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCounterOfferEnabled'} = shift
}

=head2 isEBayMotorsProCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProCounterOfferEnabled'};
}


=head2 setEBayMotorsProPaymentMethodCheckOutEnabled()

Indicates if the payment method should be displayed to the user
for most categories. Even if enabled, checkout may or may not
be enabled. This element is for eBay Motors Pro users.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub setEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'eBayMotorsProPaymentMethodCheckOutEnabled'} = shift
}

=head2 getEBayMotorsProPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledCodeType'

=cut

sub getEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProPaymentMethodCheckOutEnabled'};
}


=head2 setEBayMotorsProPhoneCount()

Indicates which telephone option is enabled to
contact the seller. This element is for eBay Motors Pro users.

#    Argument: 'xs:int'

=cut

sub setEBayMotorsProPhoneCount {
  my $self = shift;
  $self->{'eBayMotorsProPhoneCount'} = shift
}

=head2 getEBayMotorsProPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getEBayMotorsProPhoneCount {
  my $self = shift;
  return $self->{'eBayMotorsProPhoneCount'};
}


=head2 setEBayMotorsProSellerContactDetailsEnabled()

Specifies the default site setting for whether most categories allow seller-
level contact information for Classified Ad format listings. A value of true
means seller-level contact information is available for Classified Ad listings
site-wide, unless a specific category overrides the setting. This element is
for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'eBayMotorsProSellerContactDetailsEnabled'} = shift
}

=head2 isEBayMotorsProSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProSellerContactDetailsEnabled'};
}


=head2 setEBayMotorsProShippingMethodEnabled()

Indicates if shipping options are available for most categories.
This element is for eBay Motors Pro users.

#    Argument: 'xs:boolean'

=cut

sub setEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  $self->{'eBayMotorsProShippingMethodEnabled'} = shift
}

=head2 isEBayMotorsProShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  return $self->{'eBayMotorsProShippingMethodEnabled'};
}


=head2 setEBayMotorsProStreetCount()

Indicates which address option is enabled to
contact the seller. This element is for eBay Motors Pro users.

#    Argument: 'xs:int'

=cut

sub setEBayMotorsProStreetCount {
  my $self = shift;
  $self->{'eBayMotorsProStreetCount'} = shift
}

=head2 getEBayMotorsProStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getEBayMotorsProStreetCount {
  my $self = shift;
  return $self->{'eBayMotorsProStreetCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
