#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ErrorHandlingCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ErrorHandlingCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ErrorHandlingCodeType

=head1 DESCRIPTION

Preferences that specify how eBay should handle certain requests that contain
invalid data or that could partially fail. These preferences give you some control
over whether eBay returns warnings or errors in response to invalid data and how
eBay handles listing requests when such data is passed in. For example, these
preferences are applicable to AddItem and related calls when Item Specifics are
specified, and to CompleteSale. See the eBay Web Services Guide
for details about these preferences and their effects.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Legacy

(in) Apply validation rules that were in effect prior to the time
the call started supporting ErrorHandling.



=cut


use constant Legacy => scalar('Legacy');


=head2 BestEffort

(in) Drop the invalid data, continue processing the request with the
valid data. If dropping the invalid data leaves the request in a
state where required data is missing, reject the request.<br>
<br>
If BestEffort is specified for CompleteSale, the Ack field in the
response could return PartialFailure if one change fails but
another succeeds. For example, if the seller attempts to
leave feedback twice for the same transaction, the feedback changes
would fail but any paid or shipped status changes would succeed.



=cut


use constant BestEffort => scalar('BestEffort');


=head2 AllOrNothing

(in) If any attribute data is invalid, drop the entire attribute set and
proceed with listing the item. If the category has required attributes
and the attribute set is dropped, reject the listing.



=cut


use constant AllOrNothing => scalar('AllOrNothing');


=head2 FailOnError

(in) If any data is invalid, reject the request.



=cut


use constant FailOnError => scalar('FailOnError');







1;   
