#!/usr/bin/perl

package eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetPromotionalSaleListingsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsRequestType

=head1 DESCRIPTION

Used to change which item listings are affected by a promotional sale.
Item listings affected by a promotional sale have a reduced price 
and/or free shipping and are displayed as items on sale.
Use the Action field to specify addition of listings to, or deletion
of listings from, a promotional sale.
This call is part of the Promotional Price Display feature, 
which enables sellers to apply discounts across many listings.
Promotional sales apply to single and multi-quantity Store Inventory format, 
regular fixed-price format, auction, and auction/BIN formats. 
Auction and auction/BIN format listings can be added free shipping sales only.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetPromotionalSaleListings::SetPromotionalSaleListingsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDArrayType;
use eBay::API::XML::DataType::Enum::ModifyActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:ModifyActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ModifyActionCodeType', '' ]
	, [ 'AllAuctionItems', 'xs:boolean', '', '', '' ]
	, [ 'AllFixedPriceItems', 'xs:boolean', '', '', '' ]
	, [ 'AllStoreInventoryItems', 'xs:boolean', '', '', '' ]
	, [ 'CategoryID', 'xs:long', '', '', '' ]
	, [ 'PromotionalSaleID', 'xs:long', '', '', '' ]
	, [ 'PromotionalSaleItemIDArray', 'ns:ItemIDArrayType', ''
	     ,'eBay::API::XML::DataType::ItemIDArrayType', '1' ]
	, [ 'StoreCategoryID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

You must specify either Add or Delete.
This field determines whether you are adding listings to,
or deleting listings from,
the promotional sale you specify in the PromotionalSaleID field.
If you specify Delete, you must specify
PromotionalSaleItemIDArray. Delete is applicable only in 
cases where you specify PromotionalSaleItemIDArray.
Auction or auction/BIN format listings cannot be added to or deleted 
from a promotional sale if the item has bids.

  RequiredInput: Yes
  OnlyTheseValues: Add, Delete
#    Argument: 'ns:ModifyActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:ModifyActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setAllAuctionItems()

Adds to the promotional sale all the seller's item listings 
that are auction items. Auction and auction/BIN format listings
can be added to free shipping sales only. 
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setAllAuctionItems {
  my $self = shift;
  $self->{'AllAuctionItems'} = shift
}

=head2 isAllAuctionItems()

#    Returns: 'xs:boolean'

=cut

sub isAllAuctionItems {
  my $self = shift;
  return $self->{'AllAuctionItems'};
}


=head2 setAllFixedPriceItems()

Adds to the promotional sale all the seller's item listings 
that are fixed price items.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setAllFixedPriceItems {
  my $self = shift;
  $self->{'AllFixedPriceItems'} = shift
}

=head2 isAllFixedPriceItems()

#    Returns: 'xs:boolean'

=cut

sub isAllFixedPriceItems {
  my $self = shift;
  return $self->{'AllFixedPriceItems'};
}


=head2 setAllStoreInventoryItems()

Adds to the promotional sale all the seller's item listings 
that are store inventory items.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setAllStoreInventoryItems {
  my $self = shift;
  $self->{'AllStoreInventoryItems'} = shift
}

=head2 isAllStoreInventoryItems()

#    Returns: 'xs:boolean'

=cut

sub isAllStoreInventoryItems {
  my $self = shift;
  return $self->{'AllStoreInventoryItems'};
}


=head2 setCategoryID()

Adds to the promotional sale all the seller's item listings with
the CategoryID specified in this field. 
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:long'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

#    Returns: 'xs:long'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setPromotionalSaleID()

The ID of the promotional sale that you want to add listings to or
delete listings from.

  RequiredInput: Yes
#    Argument: 'xs:long'

=cut

sub setPromotionalSaleID {
  my $self = shift;
  $self->{'PromotionalSaleID'} = shift
}

=head2 getPromotionalSaleID()

#    Returns: 'xs:long'

=cut

sub getPromotionalSaleID {
  my $self = shift;
  return $self->{'PromotionalSaleID'};
}


=head2 setPromotionalSaleItemIDArray()

The IDs of the item listings to be affected
by the action you specify in the Action field.

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDArrayType'

=cut

sub setPromotionalSaleItemIDArray {
  my $self = shift;
  $self->{'PromotionalSaleItemIDArray'} = shift
}

=head2 getPromotionalSaleItemIDArray()

#    Returns: 'ns:ItemIDArrayType'

=cut

sub getPromotionalSaleItemIDArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalSaleItemIDArray'
		,'eBay::API::XML::DataType::ItemIDArrayType');
}


=head2 setStoreCategoryID()

Adds to the promotional sale all the seller's item listings with
the StoreCategoryID specified in this field.
Requires that you specify Add in the Action field.

  RequiredInput: No
#    Argument: 'xs:long'

=cut

sub setStoreCategoryID {
  my $self = shift;
  $self->{'StoreCategoryID'} = shift
}

=head2 getStoreCategoryID()

#    Returns: 'xs:long'

=cut

sub getStoreCategoryID {
  my $self = shift;
  return $self->{'StoreCategoryID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
