#!/usr/bin/perl

package eBay::API::XML::Call::SellerReverseDispute::SellerReverseDisputeRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerReverseDisputeRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SellerReverseDispute::SellerReverseDisputeRequestType

=head1 DESCRIPTION

Enables a seller to "reverse" an Unpaid Item dispute that has been closed, for
example, if buyer and seller reach an agreement. The seller's Final Value Fee
credit and the buyer's strike are both reversed, if applicable.
The dispute might have resulted
in a strike to the buyer and a Final Value Fee credit to the seller. A buyer and
seller sometimes come to agreement after a dispute has been closed. In particular,
the seller might discover that the buyer actually paid, or the buyer might agree
to pay the seller's fees in exchange for having the strike removed.
<br><br>
A dispute can only be reversed if it was closed with DisputeActivity set to
SellerEndCommunication, CameToAgreementNeedFVFCredit, or
MutualAgreementOrNoBuyerResponse.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SellerReverseDispute::SellerReverseDisputeRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::DisputeIDType;
use eBay::API::XML::DataType::Enum::DisputeResolutionReasonCodeType;


my @gaProperties = ( [ 'DisputeID', 'ns:DisputeIDType', ''
	     ,'eBay::API::XML::DataType::DisputeIDType', '1' ]
	, [ 'DisputeResolutionReason', 'ns:DisputeResolutionReasonCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeResolutionReasonCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisputeID()

The unique identifier of the dispute that was returned when the dispute was created.
The dispute must be an Unpaid Item dispute that the seller opened.

  RequiredInput: Yes
#    Argument: 'ns:DisputeIDType'

=cut

sub setDisputeID {
  my $self = shift;
  $self->{'DisputeID'} = shift
}

=head2 getDisputeID()

#    Returns: 'ns:DisputeIDType'

=cut

sub getDisputeID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DisputeID'
		,'eBay::API::XML::DataType::DisputeIDType');
}


=head2 setDisputeResolutionReason()

The reason the dispute is being reversed.

  RequiredInput: Yes
#    Argument: 'ns:DisputeResolutionReasonCodeType'

=cut

sub setDisputeResolutionReason {
  my $self = shift;
  $self->{'DisputeResolutionReason'} = shift
}

=head2 getDisputeResolutionReason()

#    Returns: 'ns:DisputeResolutionReasonCodeType'

=cut

sub getDisputeResolutionReason {
  my $self = shift;
  return $self->{'DisputeResolutionReason'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
