#!/usr/bin/perl

package eBay::API::XML::Call::GetSearchResultsExpress;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSearchResultsExpress.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSearchResultsExpress

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSearchResultsExpress inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressRequestType;
use eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSearchResultsExpress';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSearchResultsExpress::GetSearchResultsExpressResponseType';
}

#
# input properties
#

=head2 setAffiliateTrackingDetails()

Container for affiliate tags.
If you use affiliate tags, it is possible to get affiliate commissions
based on calls made by your application.
(See the <a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>
for information about commissions.)
Affiliate tags enable the tracking of user activity.
You can use child tags of AffiliateTrackingDetails if you want
call output to include a string, in
ItemArray.Item.ListingDetails.ViewItemURL, that includes
affiliate tracking information.
For GetSearchResultsExpress, the ViewItemURL field is returned only if you specify AffiliateTrackingDetails in the request.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut
       
sub setAffiliateTrackingDetails {
   my $self   = shift;
   my $pAffiliateTrackingDetails = shift;
   $self->getRequestDataType()->setAffiliateTrackingDetails($pAffiliateTrackingDetails);
}

=head2 setAisleName()

An aisle is a grouping of product types that share a common theme. This
filter limits the search to the specified Express aisle. If not specified,
this filter is ignored by the search engine.<br>
<br>
See DepartmentName for information about how to retrieve all available
department, aisle, and product type names. The valid aisle names are
returned in the Histogram.Department.Aisle.DomainDetails.Name
fields.<br>
<br>
At least one of Query, ProductReferenceID, ExternalProductIDValue (and
Type), SellerID, DepartmentName, AisleName, or ProductTypeName is required.
Optionally, both DepartmentName and AisleName can be specified in the same
request. In this case, the search engine treats the combination as a fully
qualified aisle name (and it returns an error if the combination is
invalid).

MaxLength: 200

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setAisleName {
   my $self   = shift;
   my $sAisleName = shift;
   $self->getRequestDataType()->setAisleName($sAisleName);
}

=head2 setCondition()

A filter that limits the results by the item condition. If not specified,
the default is New. If the item is listed in a category that does not
normally require the condition to be specified (like Event Tickets), the
item is returned regardless of this condition setting.

Default: New

  RequiredInput: No
#    Argument: 'ns:ConditionSelectionCodeType'

=cut
       
sub setCondition {
   my $self   = shift;
   my $sCondition = shift;
   $self->getRequestDataType()->setCondition($sCondition);
}

=head2 setDepartmentName()

A department is a grouping of aisles and/or product types that share a
common theme. This filter limits the search to the specified Express
department. If not specified, this filter is ignored by the search
engine.<br>
<br>
You can specify the value "Express" (without quotes) as the department
name to retrieve all departments on Express. With this use case, the
ItemArray and ProductArray nodes aren't returned. The valid department
names are returned in the Histogram.Department.DomainDetails.Name fields.
When DepartmentName=Express, you can only specify HistogramSort and/or
HistogramDetails. Set HistogramDetail to Fine to also retrieve all aisles
and product types. Do not specify ItemDetails or ProductDetails at all in
the request. (Setting the values to None will return an error). Also do
not specify any other query, pagination, price, or sorting fields in the
request.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.

MaxLength: 200

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setDepartmentName {
   my $self   = shift;
   my $sDepartmentName = shift;
   $self->getRequestDataType()->setDepartmentName($sDepartmentName);
}

=head2 setEntriesPerPage()

The maximum number of entries to return in the ProductArray or ItemArray.
That is, if you specify 10, then up to 10 products and up to 10 items are
returned in the current call's response.<br>
<br>
If the number of entries found is less than the value specified in
EntriesPerPage, then that number of entries is returned instead. For
example, if you specify 10, Express might only return 4 products and 9
items (if no more matches are found). If not specified, the default is 15.

Max: 200
Default: 15
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setEntriesPerPage {
   my $self   = shift;
   my $sEntriesPerPage = shift;
   $self->getRequestDataType()->setEntriesPerPage($sEntriesPerPage);
}

=head2 setExternalProductIDType()

The combination of ExternalProductIDType and ExternalProductIDValue create
a query that only retrieves items that were listed with
Pre-filled Item Information in categories that support
ISBN or UPC codes (such as Books, DVDs and Movies,
Music, and Video Games).
ExternalProductIDType identifies which type of code you are
searching for. If specified, also specify the ISBN or UPC
code number in ExternalProductIDValue.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats
are mutually exclusive. That is, they cannot be used together in the same request. At least one of Query, ProductReferenceID,
ExternalProductIDValue (and Type), SellerID, DepartmentName,
AisleName, or ProductTypeName is required.

  RequiredInput: Conditionally
  OnlyTheseValues: ISBN, UPC
#    Argument: 'ns:ExternalProductCodeType'

=cut
       
sub setExternalProductIDType {
   my $self   = shift;
   my $sExternalProductIDType = shift;
   $self->getRequestDataType()->setExternalProductIDType($sExternalProductIDType);
}

=head2 setExternalProductIDValue()

An ISBN or UPC code (depending on ExternalProductIDType) for the eBay
catalog product that you are searching for. Only valid when
ExternalProductIDType is specified.

MaxLength: 15

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setExternalProductIDValue {
   my $self   = shift;
   my $sExternalProductIDValue = shift;
   $self->getRequestDataType()->setExternalProductIDValue($sExternalProductIDValue);
}

=head2 setHighestPrice()

A filter that limits the results to items with a SellingStatus.CurrentPrice
value lower than this value. For example, if you specify 10.01, the results
will include items with a CurrentPrice of 10.00 or lower. Use without
LowestPrice to specify a maximum price, or use with LowestPrice to define a
price range that bounds the results. Must be higher than LowestPrice if both
are specified. If not specified, no maximum price filter is applied to the
query.<br>
<br>
You can specify any double value, but in practice the highest price of any
item on Express is USD 10000 for Express US and (in the future) EUR 10000
for Express Germany. If you specify a value of 0.0 or lower, this filter is
ignored. See "Data Types" in the eBay Web Services Guide for information
about specifying double values.<br>
<br>
Does not control the order in which items are returned. (To sort by highest
total price, use ItemSort.)

Max: Default: Min: 
  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut
       
sub setHighestPrice {
   my $self   = shift;
   my $pHighestPrice = shift;
   $self->getRequestDataType()->setHighestPrice($pHighestPrice);
}

=head2 setHistogramDetails()

Controls the amount of statistical data to return in the response. If not
specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
how much detail to retrieve in the resulting histogram. This setting has
no effect on the product or item details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut
       
sub setHistogramDetails {
   my $self   = shift;
   my $sHistogramDetails = shift;
   $self->getRequestDataType()->setHistogramDetails($sHistogramDetails);
}

=head2 setHistogramSort()

Specifies the order of the data in the histogram (if any). Controls the
way the histogram data is organized in the response (not the details to
return). If not specified, the default sort order is ItemCount.<br>
<br>
This option has no effect on how item or product results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve the desired histogram data and then sort the results
locally in your application.

Default: ItemCount

  RequiredInput: No
#    Argument: 'ns:ExpressHistogramSortCodeType'

=cut
       
sub setHistogramSort {
   my $self   = shift;
   my $sHistogramSort = shift;
   $self->getRequestDataType()->setHistogramSort($sHistogramSort);
}

=head2 setItemDetails()

Selects the set of fields to retrieve for each item that matches the
query. If not specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
which fields to retrieve for each item found. This setting has no effect
on the histogram or product details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut
       
sub setItemDetails {
   my $self   = shift;
   my $sItemDetails = shift;
   $self->getRequestDataType()->setItemDetails($sItemDetails);
}

=head2 setItemSort()

Specifies the order in which listings (if any) are returned in the result
set. If not specified, the items are sorted by relevance (as determined by
eBay). If you choose to sort by total cost, a PostalCode must also be
specified (so that eBay can calculate the shipping cost as part of the
total cost for each item).<br>
<br>
Controls the way the data is organized in the response (not the details to
return).<br>
<br>
This option has no effect on how histogram or product results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve all available pages and then sort the results locally in
your application.

Default: Relevance

  RequiredInput: No
#    Argument: 'ns:ExpressItemSortCodeType'

=cut
       
sub setItemSort {
   my $self   = shift;
   my $sItemSort = shift;
   $self->getRequestDataType()->setItemSort($sItemSort);
}

=head2 setLowestPrice()

A filter that limits the results to items with a
SellingStatus.CurrentPrice value equal to or higher than this value. For
example, if you specify 6.00, the results will include items with a
CurrentPrice of 6.00 or higher. If specified, HighestPrice must also be
specified; otherwise, the lowest price filter is ignored. Must be lower
than HighestPrice. If not specified or if the value is less than 0.0, no
minimum price filter is applied to the query.<br>
<br>
You can specify any double value, but in practice the highest price of any
item on Express is USD 10000 for Express US and (in the future) EUR 10000
for Express Germany. See "Data Types" in the eBay Web Services Guide for
information about specifying double values .<br>
<br>
Does not control the order in which items are returned. (To sort by lowest
total price, use ItemSort.)

Max: Default: Min: 
  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setLowestPrice {
   my $self   = shift;
   my $pLowestPrice = shift;
   $self->getRequestDataType()->setLowestPrice($pLowestPrice);
}

=head2 setPageNumber()

Specifies the number of the page of data to return in the current call. If
not specified, the default is 1 (the first page).

Max: 90
Default: 1
Min: 1

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setPageNumber {
   my $self   = shift;
   my $sPageNumber = shift;
   $self->getRequestDataType()->setPageNumber($sPageNumber);
}

=head2 setPostalCode()

Postal code of the buyer. For the US site, this is a 5-digit zip code.
(Other sites may support longer alphanumeric values in the future.) The
postal code enables Express to calculate the item's default shipping cost
based on the buyer's postal code, the postal code defined on the item, and
the cost of the default shipping service that the seller specified in the
listing. The default shipping cost is returned in the
Item.ShippingDetails.DefaultShippingCost field. If not specified, items
with calculated shipping will return an
Item.ShippingDetails.ShippingRateErrorMessage string that indicates that a
postal code is needed to calculate shipping.<br>
<br>
Required if ItemSort is set to LowestTotalCost or HighestTotalCost
(because the total cost calculation depends on the shipping cost
calculation).<br>
<br>
This is not a query or filter, so it has no effect on which items or
products are returned.

MaxLength: 5

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setPostalCode {
   my $self   = shift;
   my $sPostalCode = shift;
   $self->getRequestDataType()->setPostalCode($sPostalCode);
}

=head2 setProductDetails()

Selects the set of fields to retrieve for each catalog product that
matches the query. If not specified, the default is Coarse.<br>
<br>
This setting is not a filter that limits the search; it only configures
which fields to retrieve for each product found. This setting has no
effect on the histogram or item details.

Default: Coarse

  RequiredInput: No
#    Argument: 'ns:ExpressDetailLevelCodeType'

=cut
       
sub setProductDetails {
   my $self   = shift;
   my $sProductDetails = shift;
   $self->getRequestDataType()->setProductDetails($sProductDetails);
}

=head2 setProductReferenceID()

The global reference ID for an eBay catalog product. eBay catalog products
provide stock information that sellers can use to pre-fill Item Specifics
and other listing details. Use this query to retrieve basic details about
the catalog product (returned in ProductArray) along with items (in
ItemArray) that were
listed with any version of the product.<br>
<br>
To determine valid reference IDs, call GetSearchResultsExpress without
using this value. The IDs that match the query (if any) are returned in
ProductArray.Product.ProductReferenceID fields.<br>
<br>
<span class="tablenote"><b>Note:</b>
This value is not the same as the ProductID used in AddItem and related calls. A ProductID represents a particular version
of a catalog product, which is associated with a particular set of
Item Specifics and other details. A ProductReferenceID is a more generic
or global reference to a catalog product, which is useful for buy-side searching. One ProductReferenceID can be associated with multiple ProductIDs.</span><br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.<br>
<br>
As of mid-2008, some sites (such as eBay US, Germany, Austria, and Switzerland) are 
updating, replacing, deleting, or merging some products (as a result of migrating from one
catalog data provider to another). 
If you specify one of these products, the call may return a warning, 
or it may return an error if the product has been deleted.

Max: Default: Min: 
  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut
       
sub setProductReferenceID {
   my $self   = shift;
   my $sProductReferenceID = shift;
   $self->getRequestDataType()->setProductReferenceID($sProductReferenceID);
}

=head2 setProductSort()

Specifies the order in which Express products are returned in a result
set. If not specified, the products are sorted by sales rank (bestselling
first).<br>
<br>
This option has no effect on how histogram or item results are sorted.
Histogram, item, and product results are sorted independently.<br>
<br>
Note: If you want to sort the results by criteria that eBay has not
defined, retrieve all available pages and then sort the results locally in
your application.<br>
<br>
Controls the way the data is organized in the response (not the details to
return).

Default: SalesRank

  RequiredInput: No
#    Argument: 'ns:ExpressProductSortCodeType'

=cut
       
sub setProductSort {
   my $self   = shift;
   my $sProductSort = shift;
   $self->getRequestDataType()->setProductSort($sProductSort);
}

=head2 setProductTypeName()

A product type is a type of good or service that can be purchased. This
filter limits the search to the specified Express product type. If not
specified, this filter is ignored by the search engine.<br>
<br>
<b>Note:</b> Express product types are not eBay catalog
products. This field does not support eBay catalog product names or
IDs.<br>
<br>
See DepartmentName for information about how to retrieve all available
department, aisle, and product type names. The valid product type names
are returned in Histogram.Department.Aisle.ProductType.DomainDetails.Name
fields.<br>
<br>
Optionally, DepartmentName and/or AisleName can be specified in the same
request with ProductTypeName. In this case, the search engine treats the
combination as a fully qualified product type name (and it returns an
error if the combination is invalid).

MaxLength: 200

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setProductTypeName {
   my $self   = shift;
   my $sProductTypeName = shift;
   $self->getRequestDataType()->setProductTypeName($sProductTypeName);
}

=head2 setQuery()

A free-text query that retrieves items, information about eBay catalog
products that were used to list the items, and/or applicable domain
details. For a quick, targeted search, use keywords that best fit the item
you're looking for. You can also search by brand name or descriptive
features. The search engine checks all specified keywords against the item
title, description, eBay category, Item Specifics, and/or Pre-filled Item
Information. (Express does not necessarily check all Item Specifics
defined on the item.) The exact combination of fields that are checked for
any given set of keywords varies by a number of factors that are not
disclosed in this documentation.<br>
<br>
Specify at least two characters when you use Query. If you specify
multiple words, AND logic is used. The keywords can be specified any
order. The words "and" and "or" are treated like any other word. Only use
"and", "or", or "the" if you are searching for listings containing these
words.<br>
<br>
You can control AND or OR logic by including certain modifiers. Wildcards
(e.g., *) are also supported. Be careful when using spaces before or after
modifiers and wildcards (+, -, or *). These are the same modifiers that
GetSearchResults supports. See "Searching by Keywords" in the eBay Web
Services Guide for a list of valid modifiers and examples. Modifiers do
not count in the 2-character minimum.
<br>
<br>
Alternatively, you can specify an item ID to retrieve a specific item's
Express search details. To search by ISBN or UPC, use
ExternalProductIDType and ExternalProductIDValue instead.<br>
<br>
The Query, ProductReferenceID, and ExternalProductID query formats are
mutually exclusive. That is, they cannot be used together in the same
request. At least one of Query, ProductReferenceID, ExternalProductIDValue
(and Type), SellerID, DepartmentName, AisleName, or ProductTypeName is
required.

MaxLength: 350

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setQuery {
   my $self   = shift;
   my $sQuery = shift;
   $self->getRequestDataType()->setQuery($sQuery);
}

=head2 setSellerID()

A filter that limits the search to a particular seller's listings that are
included on Express. Retrieves all of the seller's eligible items, without
consolidating (deduping) similar items into single representative results.
If specified, you can only search within one seller's listings per call.
(It is not possible to exclude a particular seller's listings from the
search.) If not specified, the engine searches across all listings on
Express. If the seller has no items listed on Express, no results are
returned.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut
       
sub setSellerID {
   my $self   = shift;
   my $pSellerID = shift;
   $self->getRequestDataType()->setSellerID($pSellerID);
}



#
# output properties
#

=head2 getEntriesPerPage()

Indicates the number of item and product results per page that you
originally requested (not the number of items or products
that were returned).
To determine how many items or products were actually returned,
count the number of Item nodes in ItemArray (if any) and the
number of Product nodes in ProductArray (if any).

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getEntriesPerPage {
   my $self = shift;
   return $self->getResponseDataType()->getEntriesPerPage();
}

=head2 isHasMoreEntries()

If true, there are additional item and/or product results (on higher-
numbered pages) that match the query. To retrieve them, call
GetSearchResultsExpress again and increment the page number or specify a
higher value for EntriesPerPage in the request.

  Returned: Always
#    Returns: 'xs:boolean'

=cut
       
sub isHasMoreEntries {
   my $self = shift;
   return $self->getResponseDataType()->isHasMoreEntries();
}

=head2 getHistogram()

Indicates the quantity of items and catalog products that fall into
departments, aisles, and/or product types that match the criteria in the
request. The sort order is controlled by the value of HistogramSort in the
request. Only returned when matching data is found and HistogramDetails is
Coarse (the default) or Fine.<br>
<br>
When HistogramDetails==Coarse and no DepartmentName, AisleName, or
ProductTypeName is specified in the request, Express only returns
histogram details for departments. In this particular case, Express
returns no histogram details when no departments match the request.
This could occur when Express only finds matching results in
stand-alone product types or stand-alone aisles (because they aren't
grouped into departments).

  Returned: Conditionally
#    Returns: 'ns:DomainHistogramType'

=cut
       
sub getHistogram {
   my $self = shift;
   return $self->getResponseDataType()->getHistogram();
}

=head2 getItemArray()

Contains a list of items on Express that match all the criteria specified in
the request. The sort order is controlled by the value of ItemSort in the
request. Only returned when matching data is found and ItemDetails is Coarse
(the default) or Fine.<br>
<br>
If the same seller has listed multiple items with the same title and
costs, only one of
those items is returned by default. This is treated as a consolidated
(deduped) search result item
that represents the seller's other, identical items.
If you want to retrieve all duplicates for an item, pass the seller's
user ID in the SellerID field
in the request. Use the results to identify items with duplicate
titles and costs.<br>
<br>
Items can belong to multiple departments, aisles, or product types at
any given time,
and this information is not stored or returned in the item data. To
determine which items
are currently available in a given domain, specify the
DepartmentName, AisleName, or ProductTypeName
in the request.

  Returned: Conditionally
#    Returns: 'ns:ItemArrayType'

=cut
       
sub getItemArray {
   my $self = shift;
   return $self->getResponseDataType()->getItemArray();
}

=head2 getPageNumber()

Indicates the page of data returned by the current call.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getProductArray()

Contains a list of eBay catalog products have been used to pre-fill
listings that match the criteria specified in the request. The sort order
is controlled by the value of ProductSort in the request. Only returned
when matching data is found and ProductDetails is Coarse (the default) or
Fine. To determine which products are currently available in a given
domain, specify the DepartmentName, AisleName, or ProductTypeName in the
request.

  Returned: Conditionally
#    Returns: 'ns:ProductArrayType'

=cut
       
sub getProductArray {
   my $self = shift;
   return $self->getResponseDataType()->getProductArray();
}





1;   
