#!/usr/bin/perl

package eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPopularKeywordsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsResponseType

=head1 DESCRIPTION

Contains the keyword data for the requested categories. A category's data are contained in a CategoryArrayType object if there is no error (one or more CategoryType objects). Each CategoryType contains its ID, parent ID and keyword list.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPopularKeywords::GetPopularKeywordsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::CategoryArrayType;
use eBay::API::XML::DataType::PaginationResultType;


my @gaProperties = ( [ 'CategoryArray', 'ns:CategoryArrayType', ''
	     ,'eBay::API::XML::DataType::CategoryArrayType', '1' ]
	, [ 'HasMore', 'xs:boolean', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryArray()

Organization of keywords by category. For each
category, its ID and its parent's ID and keywords
are listed.

#    Argument: 'ns:CategoryArrayType'

=cut

sub setCategoryArray {
  my $self = shift;
  $self->{'CategoryArray'} = shift
}

=head2 getCategoryArray()

  Returned: Always
#    Returns: 'ns:CategoryArrayType'

=cut

sub getCategoryArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CategoryArray'
		,'eBay::API::XML::DataType::CategoryArrayType');
}


=head2 setHasMore()

Indicates whether there are more categories beyond the
subset returned in the last
call to GetPopularKeywords. Returned only when
IncludeChildCategories is true.

#    Argument: 'xs:boolean'

=cut

sub setHasMore {
  my $self = shift;
  $self->{'HasMore'} = shift
}

=head2 isHasMore()

  Returned: Conditionally
#    Returns: 'xs:boolean'

=cut

sub isHasMore {
  my $self = shift;
  return $self->{'HasMore'};
}


=head2 setPaginationResult()

Contains information regarding the pagination of data (if pagination is used),
including total number of pages and total number of entries.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Conditionally
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
