#!/usr/bin/perl

package eBay::API::XML::Call::GetAdFormatLeads::GetAdFormatLeadsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAdFormatLeadsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAdFormatLeads::GetAdFormatLeadsResponseType

=head1 DESCRIPTION

Returns number of leads and contact and other information for each lead. One
AdFormatLead node is returned for each lead.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAdFormatLeads::GetAdFormatLeadsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AdFormatLeadType;


my @gaProperties = ( [ 'AdFormatLead', 'ns:AdFormatLeadType', '1'
	     ,'eBay::API::XML::DataType::AdFormatLeadType', '1' ]
	, [ 'AdFormatLeadCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdFormatLead()

Contains contact and other information for one lead. One node is
returned for each lead. Only returned at a detail level of ReturnAll. At
least one lead must be available for the specified item to return
AdFormatLead.

#    Argument: reference to an array  
                      of 'ns:AdFormatLeadType'

=cut

sub setAdFormatLead {
  my $self = shift;
  $self->{'AdFormatLead'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAdFormatLead()

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: reference to an array  
                      of 'ns:AdFormatLeadType'

=cut

sub getAdFormatLead {
  my $self = shift;
  return $self->_getDataTypeArray('AdFormatLead');
}


=head2 setAdFormatLeadCount()

The total number of leads returned. Only returned if you do not
specify a detail level.

#    Argument: 'xs:int'

=cut

sub setAdFormatLeadCount {
  my $self = shift;
  $self->{'AdFormatLeadCount'} = shift
}

=head2 getAdFormatLeadCount()

  Returned: Conditionally
  Details: DetailLevel: none
#    Returns: 'xs:int'

=cut

sub getAdFormatLeadCount {
  my $self = shift;
  return $self->{'AdFormatLeadCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
