#!/usr/bin/perl

package eBay::API::XML::DataType::VeROSiteDetailType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VeROSiteDetailType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::VeROSiteDetailType

=head1 DESCRIPTION

Container for reason code details for a given site.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::VeROSiteDetailType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ReasonCodeDetailType;
use eBay::API::XML::DataType::Enum::SiteCodeType;


my @gaProperties = ( [ 'ReasonCodeDetail', 'ns:ReasonCodeDetailType', '1'
	     ,'eBay::API::XML::DataType::ReasonCodeDetailType', '1' ]
	, [ 'Site', 'ns:SiteCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setReasonCodeDetail()

Contains details for a given reason code.

#    Argument: reference to an array  
                      of 'ns:ReasonCodeDetailType'

=cut

sub setReasonCodeDetail {
  my $self = shift;
  $self->{'ReasonCodeDetail'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getReasonCodeDetail()

  Calls: GetVeROReasonCodeDetails
  Returned: Always

#    Returns: reference to an array  
                      of 'ns:ReasonCodeDetailType'

=cut

sub getReasonCodeDetail {
  my $self = shift;
  return $self->_getDataTypeArray('ReasonCodeDetail');
}


=head2 setSite()

The site for which reason code details are returned.

#    Argument: 'ns:SiteCodeType'

=cut

sub setSite {
  my $self = shift;
  $self->{'Site'} = shift
}

=head2 getSite()

  Calls: GetVeROReasonCodeDetails
  Returned: Always

#    Returns: 'ns:SiteCodeType'

=cut

sub getSite {
  my $self = shift;
  return $self->{'Site'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
