#!/usr/bin/perl

package eBay::API::XML::DataType::SuggestedCategoryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SuggestedCategoryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SuggestedCategoryType

=head1 DESCRIPTION

Defines a suggested category, returned
in response to a search for categories that contain
listings with certain keywords in their titles and descriptions.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SuggestedCategoryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::CategoryType;


my @gaProperties = ( [ 'Category', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'PercentItemFound', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategory()

Describes a category that contains items that match the query.

#    Argument: 'ns:CategoryType'

=cut

sub setCategory {
  my $self = shift;
  $self->{'Category'} = shift
}

=head2 getCategory()

  Calls: GetSuggestedCategories
  Returned: Conditionally

#    Returns: 'ns:CategoryType'

=cut

sub getCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Category'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setPercentItemFound()

Percentage of the matching items that were found in this category, 
relative to other categories in which matching items were also found. 
Indicates the distribution of matching items across the suggested categories.

#    Argument: 'xs:int'

=cut

sub setPercentItemFound {
  my $self = shift;
  $self->{'PercentItemFound'} = shift
}

=head2 getPercentItemFound()

  Calls: GetSuggestedCategories
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getPercentItemFound {
  my $self = shift;
  return $self->{'PercentItemFound'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
