#!/usr/bin/perl

package eBay::API::XML::DataType::SiteDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SiteDetailsType

=head1 DESCRIPTION

Details about a specific site.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SiteDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::SiteCodeType;


my @gaProperties = ( [ 'Site', 'ns:SiteCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteCodeType', '' ]
	, [ 'SiteID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSite()

Short name that identifies an eBay site. Usually, an eBay site is associated
with a particular country or region (e.g., US or Belgium_French).
Specialty sites (e.g., eBay Express or eBay Stores) use the same site ID as
their associated main eBay site. The US eBay Motors site is an exception to this convention.<br><br>
Related fields:<br>
Item.Site in AddItem<br>
User.Site in GetUser

#    Argument: 'ns:SiteCodeType'

=cut

sub setSite {
  my $self = shift;
  $self->{'Site'} = shift
}

=head2 getSite()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'ns:SiteCodeType'

=cut

sub getSite {
  my $self = shift;
  return $self->{'Site'};
}


=head2 setSiteID()

Numeric identifier for an eBay site. If you are using the
SOAP API, you use numeric site IDs in the request URL.
If you are using the XML API, you use numeric site IDs in the
X-EBAY-API-SITEID header.

#    Argument: 'xs:int'

=cut

sub setSiteID {
  my $self = shift;
  $self->{'SiteID'} = shift
}

=head2 getSiteID()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getSiteID {
  my $self = shift;
  return $self->{'SiteID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
