#!/usr/bin/perl

package eBay::API::XML::Call::GetOrderTransactions;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetOrderTransactions.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetOrderTransactions

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetOrderTransactions inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetOrderTransactions::GetOrderTransactionsRequestType;
use eBay::API::XML::Call::GetOrderTransactions::GetOrderTransactionsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetOrderTransactions';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetOrderTransactions::GetOrderTransactionsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetOrderTransactions::GetOrderTransactionsResponseType';
}

#
# input properties
#

=head2 setIncludeFinalValueFees()

Indicates whether to include the final value fee in the 
following field of the response: Transaction.FinalValueFee.
For most listing types, the fee is returned in Transaction.FinalValueFee.
For Dutch auctions that end with bids (not Buy It Now purchases), the fee
is returned in the following field 
regardless of what you specify in the IncludeFinalValueFees field: 
Item.SellingStatus.FinalValueFee.
The Final Value Fee for FixedPriceItem, StoresFixedPrice, and Buy It Now
Dutch listing types is returned on a transaction-by-transaction basis.
For all other listing types, including Chinese and Dutch (not Buy It Now
purchases), the Final Value Fee is returned when the listing status is
Completed.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeFinalValueFees {
   my $self   = shift;
   my $sIncludeFinalValueFees = shift;
   $self->getRequestDataType()->setIncludeFinalValueFees($sIncludeFinalValueFees);
}

=head2 setItemTransactionIDArray()

An array of ItemTransactionIDs.

  RequiredInput: Conditionally
#    Argument: 'ns:ItemTransactionIDArrayType'

=cut
       
sub setItemTransactionIDArray {
   my $self   = shift;
   my $pItemTransactionIDArray = shift;
   $self->getRequestDataType()->setItemTransactionIDArray($pItemTransactionIDArray);
}

=head2 setOrderIDArray()

An array of OrderIDs. You can specify, at most, twenty OrderIDs.

  RequiredInput: Conditionally
#    Argument: 'ns:OrderIDArrayType'

=cut
       
sub setOrderIDArray {
   my $self   = shift;
   my $pOrderIDArray = shift;
   $self->getRequestDataType()->setOrderIDArray($pOrderIDArray);
}

=head2 setPlatform()

Name of the eBay co-branded site upon which the transaction was made.
This will serve as a filter for the transactions to get emitted in the response.

  RequiredInput: No
#    Argument: 'ns:TransactionPlatformCodeType'

=cut
       
sub setPlatform {
   my $self   = shift;
   my $sPlatform = shift;
   $self->getRequestDataType()->setPlatform($sPlatform);
}



#
# output properties
#

=head2 getOrderArray()

An array of Orders.

  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
#    Returns: 'ns:OrderArrayType'

=cut
       
sub getOrderArray {
   my $self = shift;
   return $self->getResponseDataType()->getOrderArray();
}





1;   
