#!/usr/bin/perl

package eBay::API::XML::Call::GetMyeBaySelling;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyeBaySelling.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyeBaySelling

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyeBaySelling inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingRequestType;
use eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetMyeBaySelling';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMyeBaySelling::GetMyeBaySellingResponseType';
}

#
# input properties
#

=head2 setActiveList()

Contains the list of items the user is actively selling whose listings are active.
Valid subelements are Sort, IncludeNotes, Pagination, and ListingType (with valid
values Auction, FixedPriceItem, StoresFixedPrice, or AdType).
Note that if a DetailLevel of ReturnAll is specified in the request, this element is ignored as a way to filter the response, and ALL containers are returned.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setActiveList {
   my $self   = shift;
   my $pActiveList = shift;
   $self->getRequestDataType()->setActiveList($pActiveList);
}

=head2 setBidList()

Specifies how to return the list of items bid on in the seller's My eBay
Active Selling/Items I'm Selling list. Allowed values are Sort and
IncludeNotes.Include in the request to return this container
at a DetailLevel of ReturnSummary.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setBidList {
   my $self   = shift;
   my $pBidList = shift;
   $self->getRequestDataType()->setBidList($pBidList);
}

=head2 setDeletedFromSoldList()

Specifies how to return the list of items the seller has sold and then deleted
from My eBay. Allowed values are DurationInDays (0-90), Sort, IncludeNotes,
and Pagination. Note that if a DetailLevel of ReturnAll is specified
in the request, this element is ignored as a way to filter the response,
and ALL containers are returned.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setDeletedFromSoldList {
   my $self   = shift;
   my $pDeletedFromSoldList = shift;
   $self->getRequestDataType()->setDeletedFromSoldList($pDeletedFromSoldList);
}

=head2 setDeletedFromUnsoldList()

Specifies how to return the list of items the seller has either ended or not sold which
have been deleted from My eBay. Allowed values are DurationInDays (0-90), Sort, IncludeNotes,
and Pagination. Note that if a DetailLevel of ReturnAll is specified
in the request, this element is ignored as a way to filter the response,
and ALL containers are returned.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setDeletedFromUnsoldList {
   my $self   = shift;
   my $pDeletedFromUnsoldList = shift;
   $self->getRequestDataType()->setDeletedFromUnsoldList($pDeletedFromUnsoldList);
}

=head2 setScheduledList()

Contains the list of items the user has scheduled to sell but whose listings have not yet opened.
Valid subelements are Sort, IncludeNotes, and Pagination.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setScheduledList {
   my $self   = shift;
   my $pScheduledList = shift;
   $self->getRequestDataType()->setScheduledList($pScheduledList);
}

=head2 setSoldList()

Contains the list of items the user has sold. Valid subelements are DurationInDays
(with valid values 0-60), IncludeNotes, and Pagination.
Note that if a DetailLevel of ReturnAll is specified in the request, this element is ignored as a way to filter the response, and ALL containers are returned.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setSoldList {
   my $self   = shift;
   my $pSoldList = shift;
   $self->getRequestDataType()->setSoldList($pSoldList);
}

=head2 setUnsoldList()

Contains the list of items the user has listed but whose listings have ended
without being sold. Valid subelements are DurationInDays (with valid values 0-60),
Sort, IncludeNotes, and Pagination.
Note that if a DetailLevel of ReturnAll is specified in the request, this element is ignored as a way to filter the response, and ALL containers are returned.

  RequiredInput: No
#    Argument: 'ns:ItemListCustomizationType'

=cut
       
sub setUnsoldList {
   my $self   = shift;
   my $pUnsoldList = shift;
   $self->getRequestDataType()->setUnsoldList($pUnsoldList);
}



#
# output properties
#

=head2 getActiveList()

Contains the items the user is selling that have active listings.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut
       
sub getActiveList {
   my $self = shift;
   return $self->getResponseDataType()->getActiveList();
}

=head2 getBidList()

Contains the seller's active listings with bids.
Only returned if items exist that meet the request criteria.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut
       
sub getBidList {
   my $self = shift;
   return $self->getResponseDataType()->getBidList();
}

=head2 getDeletedFromSoldList()

Contains the items the seller has sold and deleted from My eBay.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut
       
sub getDeletedFromSoldList {
   my $self = shift;
   return $self->getResponseDataType()->getDeletedFromSoldList();
}

=head2 getDeletedFromUnsoldList()

Contains the items with listings that were ended or did not sell and have been deleted from My eBay.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut
       
sub getDeletedFromUnsoldList {
   my $self = shift;
   return $self->getResponseDataType()->getDeletedFromUnsoldList();
}

=head2 getScheduledList()

Contains the items the user has scheduled for sale, but whose listings have
not yet started.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut
       
sub getScheduledList {
   my $self = shift;
   return $self->getResponseDataType()->getScheduledList();
}

=head2 getSellingSummary()

Contains summary information about the items the user is selling.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:SellingSummaryType'

=cut
       
sub getSellingSummary {
   my $self = shift;
   return $self->getResponseDataType()->getSellingSummary();
}

=head2 getSoldList()

Contains the items the user has sold.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut
       
sub getSoldList {
   my $self = shift;
   return $self->getResponseDataType()->getSoldList();
}

=head2 getSummary()

Contains summary information about the items the user is selling.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:MyeBaySellingSummaryType'

=cut
       
sub getSummary {
   my $self = shift;
   return $self->getResponseDataType()->getSummary();
}

=head2 getUnsoldList()

Contains the items whose listings have ended but that have not sold.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut
       
sub getUnsoldList {
   my $self = shift;
   return $self->getResponseDataType()->getUnsoldList();
}





1;   
