#!/usr/bin/perl

package eBay::API::XML::Call::GetItemShipping::GetItemShippingRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetItemShippingRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetItemShipping::GetItemShippingRequestType

=head1 DESCRIPTION

Returns shipping cost estimates for an item for every calculated shipping service
that the seller has offered with the listing. This is analogous to the Shipping
Calculator seen in both the buyer and seller web pages.
It is another way for a buyer or seller to obtain shipping cost information for an
existing item (for which the caller is either the buyer or seller) at any point in
the life of of the listing, before or after a buyer has committed to purchasing
the item(s).
<p>Note:
<ul>
<li>Shipping insurance cost can only be determined once the
final item price is known.
<li>It is possible for a seller to offer a shipping service which turns out
to be a mismatch in some way with the item(s) being shipped. For example, if a
buyer purchases more than one of an item, the weight might be too great for First
Class mail. In such a case, GetItemShipping will omit that shipping service from
the response.
</ul>



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetItemShipping::GetItemShippingRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::CountryCodeType;


my @gaProperties = ( [ 'DestinationCountryCode', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'DestinationPostalCode', 'xs:string', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'QuantitySold', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDestinationCountryCode()

Destination country code. If DestinationCountryCode is US,
postal code is required and represents US zip code.

Default: US

  RequiredInput: Conditionally
#    Argument: 'ns:CountryCodeType'

=cut

sub setDestinationCountryCode {
  my $self = shift;
  $self->{'DestinationCountryCode'} = shift
}

=head2 getDestinationCountryCode()

#    Returns: 'ns:CountryCodeType'

=cut

sub getDestinationCountryCode {
  my $self = shift;
  return $self->{'DestinationCountryCode'};
}


=head2 setDestinationPostalCode()

Destination country postal code (or zipcode, for US). Ignored if no
country code is provided. Optional tag for some countries. More likely to
be required for large countries.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setDestinationPostalCode {
  my $self = shift;
  $self->{'DestinationPostalCode'} = shift
}

=head2 getDestinationPostalCode()

#    Returns: 'xs:string'

=cut

sub getDestinationPostalCode {
  my $self = shift;
  return $self->{'DestinationPostalCode'};
}


=head2 setItemID()

The item ID that uniquely identifies the item listing for which
to retrieve the data. Required input.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setQuantitySold()

Number of items sold to a single buyer and to be shipped together.

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setQuantitySold {
  my $self = shift;
  $self->{'QuantitySold'} = shift
}

=head2 getQuantitySold()

#    Returns: 'xs:int'

=cut

sub getQuantitySold {
  my $self = shift;
  return $self->{'QuantitySold'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
