#!/usr/bin/perl

package eBay::API::XML::Call::GetCategoryFeatures;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoryFeatures.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategoryFeatures

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategoryFeatures inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesRequestType;
use eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetCategoryFeatures';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesResponseType';
}

#
# input properties
#

=head2 setCategoryID()

Defines one category for which you want feature settings.
If not specified, returns feature settings for all
categories on the site (assuming you set the DetailLevel
to ReturnAll and ViewAllNodes to true).

MaxLength: 10

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}

=head2 setFeatureID()

Retrieves data related to the specified feature setting only.
If no feature IDs are specified, the call retrieves data for all
feature settings.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:FeatureIDCodeType'

=cut
       
sub setFeatureID {
   my $self   = shift;
   my $sFeatureID = shift;
   $self->getRequestDataType()->setFeatureID($sFeatureID);
}

=head2 setLevelLimit()

A level of depth in the category hierarchy.
Retrieves all category nodes with a CategoryLevel less
than or equal to the LevelLimit value.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setLevelLimit {
   my $self   = shift;
   my $sLevelLimit = shift;
   $self->getRequestDataType()->setLevelLimit($sLevelLimit);
}

=head2 setViewAllNodes()

Set this value to true to retrieve useful results.
If true, retrieves all categories that override the
site default settings.
(If false or not specified, only retrieves data about
leaf categories. If the details about overridden settings
are only defined on a category's ancestor, the call does
not return those settings if you only retrieve leaf categories.)

  RequiredInput: Conditionally
  Default: false
#    Argument: 'xs:boolean'

=cut
       
sub setViewAllNodes {
   my $self   = shift;
   my $sViewAllNodes = shift;
   $self->getRequestDataType()->setViewAllNodes($sViewAllNodes);
}



#
# output properties
#

=head2 getCategory()

A category whose feature settings are different from the settings of its parent category.<br<
<br<
For example, suppose there is a branch of the category tree with 5 category levels 
(L1, L2, L3, L4, and L5). Suppose the feature settings for SiteDefaults, L1, L4, and L5 
are all "A", and the settings for L2 and L3 are "B". In this case:<br<
L1's settings (A) match the site default, so L1 is not returned.<br<
L2's settings (B) are different from L1's, so L2 is returned.<br<
L3's settings (B) are the same as L2's, so L3 is not returned<br<
L4's settings (A) are different from L3's, so L4 is returned<br<
L5's settings (A) are the same as L4's, so L5 is not returned.<br<
<br<
If you specified a particular FeatureID in the request, this field
only returns feature settings for that feature.
Only returned when the category is different from its parent.
If the category has children and they aren't returned,
it means the children inherit the category's feature settings.

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: reference to an array  
                      of 'ns:CategoryFeatureType'

=cut
       
sub getCategory {
   my $self = shift;
   return $self->getResponseDataType()->getCategory();
}

=head2 getCategoryVersion()

Returns the current version of the set of feature meta-data.
Compare this value to the version of the last version you
downloaded to determine whether the data may have changed.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'xs:string'

=cut
       
sub getCategoryVersion {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryVersion();
}

=head2 getFeatureDefinitions()

Returns definitions of the various features on the site,
or the features you requested in FeatureID (if any).
Each feature has a node within FeatureDefinitions.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:FeatureDefinitionsType'

=cut
       
sub getFeatureDefinitions {
   my $self = shift;
   return $self->getResponseDataType()->getFeatureDefinitions();
}

=head2 getSiteDefaults()

Returns the feature settings defined for most categories on the site.
Most categories share these settings. However, some categories can
override some settings, as indicated in the Category nodes
(if any).

  Returned: Always
  Details: DetailLevel: ReturnAll
#    Returns: 'ns:SiteDefaultsType'

=cut
       
sub getSiteDefaults {
   my $self = shift;
   return $self->getResponseDataType()->getSiteDefaults();
}

=head2 getUpdateTime()

Gives the time in GMT that the feature flags for the
category hierarchy were last updated.

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'xs:dateTime'

=cut
       
sub getUpdateTime {
   my $self = shift;
   return $self->getResponseDataType()->getUpdateTime();
}





1;   
