#!/usr/bin/perl -w

=comment

The data after __END__ were generated by analysing the common symbols
in the three libraries I built on Linux for 1.85, 1.86, and 2.3.14.

=cut

use strict;

my $v = shift @ARGV or die "Usage: $0 185|186";
die "Usage: $0 185|186" unless $v==185 or $v==186;

my $res = "#ifdef DB_SURVIVAL_KIT\n\n";
while (<DATA>) {
  chomp;
  if (/\#/) {
    warn "$0: skipping $_\n";
    next;
  }
  $res .= sprintf "#define %-25s db_survive_$v\_%s\n", $_, $_;
}
$res .= "#endif\n\n";

open F, ">db-survive-$v.h" or die "Could not open >db-survive-$v.h: $!";
print F $res;
close F;

__END__
__big_delete
dbm_clearerr
__split_page
collect_data
__bt_pgin
bt_psplit
dbopen
hash_close
swap_header_copy
fetch
__rec_fmap
mpool_look
hcreate
__bt_search
mpool_open
dbm_nextkey
rec_total
hsearch
__bt_new
__rec_ret
flush_meta
dbm_fetch
__bt_defpfx
__bt_pdelete
__rec_iput
bt_root
bt_broot
__rec_seq
__rec_fd
hash_get
bt_rroot
__rec_search
__cur_db
__addel
bt_meta
__rec_open
__ibitmap
__bt_snext
store
mpool_new
__big_keydata
hash_put
__delpair
bt_fast
first_free
init_hash
mpool_sync
__expand_table
vsnprintf
retval
overflow_page
rec_rdelete
__bt_open
putpair
nroot
__bt_curdel
__bt_ret
dbm_store
dbminit
mswap
byteorder
__bt_split
__bt_dleaf
__rec_dleaf
__free_ovflpage
__rec_get
__bt_seq
bt_preserve
swap_header
__rec_sync
__bt_delete
hash_delete
__big_insert
dbm_open
__bt_setcur
__bt_close
__rec_close
__rec_put
__log2
dbm_dirfno
dbm_error
dbm_firstkey
__bt_bdelete
collect_key
__bt_seqadv
__bt_fd
__bt_defcmp
dbm_delete
__rec_vmap
hash_fd
__bt_sync
mpool_write
dbp
hash_sync
__rec_delete
__bt_free
dbm_close
copyright
__bt_sprev
__bt_cmp
__bt_get
__put_page
sccsid
__get_page
__add_ovflpage
__find_bigpair
mpool_bkt
__ovfl_delete
mpool_filter
__dbpanic
# snprintf
__default_hash
__bt_seqset
firstkey
__bt_relink
__bt_pgout
__bt_put
__rec_fpipe
__ovfl_get
__rec_vpipe
__bt_first
mpool_get
bt_page
__bt_stkacq
mpool_close
__call_hash
nextkey
__dberr
__ovfl_put
__big_return
delete
hash_access
mpool_put
fetch_bitmap
init_htab
hash_seq
tmp
hdestroy
__hash_open
hash1
hash2
hash3
hash4
