use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.052

use Test::More 0.94;

plan tests => 34 + ($ENV{AUTHOR_TESTING} ? 1 : 0);

my @module_files = (
    'HiD.pm',
    'HiD/App.pm',
    'HiD/App/Command.pm',
    'HiD/App/Command/config.pm',
    'HiD/App/Command/init.pm',
    'HiD/App/Command/publish.pm',
    'HiD/App/Command/server.pm',
    'HiD/File.pm',
    'HiD/Generator.pm',
    'HiD/Generator/ArchivePage.pm',
    'HiD/Generator/AtomFeed.pm',
    'HiD/Generator/CategoryPages.pm',
    'HiD/Generator/RSSFeed.pm',
    'HiD/Generator/TagPages.pm',
    'HiD/Layout.pm',
    'HiD/Page.pm',
    'HiD/Pager.pm',
    'HiD/Plugin.pm',
    'HiD/Post.pm',
    'HiD/Processor.pm',
    'HiD/Processor/Handlebars.pm',
    'HiD/Processor/IIBlog.pm',
    'HiD/Processor/Template.pm',
    'HiD/Role/DoesLogging.pm',
    'HiD/Role/IsConverted.pm',
    'HiD/Role/IsPost.pm',
    'HiD/Role/IsPublished.pm',
    'HiD/Role/PublishesDrafts.pm',
    'HiD/Server.pm',
    'HiD/Server/Handler.pm',
    'HiD/Server/Loader.pm',
    'HiD/Types.pm',
    'HiD/VirtualPage.pm'
);

my @scripts = (
    'bin/hid'
);

# no fake home requested

my $inc_switch = -d 'blib' ? '-Mblib' : '-Ilib';

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}

foreach my $file (@scripts)
{ SKIP: {
    open my $fh, '<', $file or warn("Unable to open $file: $!"), next;
    my $line = <$fh>;

    close $fh and skip("$file isn't perl", 1) unless $line =~ /^#!\s*(?:\S*perl\S*)((?:\s+-\w*)*)(?:\s*#.*)?$/;
    my @flags = $1 ? split(' ', $1) : ();

    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, @flags, '-c', $file);
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$file compiled ok");

   # in older perls, -c output is simply the file portion of the path being tested
    if (@_warnings = grep { !/\bsyntax OK$/ }
        grep { chomp; $_ ne (File::Spec->splitpath($file))[2] } @_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
} }



is(scalar(@warnings), 0, 'no warnings found')
    or diag 'got warnings: ', explain(\@warnings) if $ENV{AUTHOR_TESTING};

BAIL_OUT("Compilation problems") if !Test::More->builder->is_passing;
