# Generated by default/object.tt
package Paws::DevOpsGuru::ServiceInsightHealth;
  use Moose;
  has OpenProactiveInsights => (is => 'ro', isa => 'Int');
  has OpenReactiveInsights => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ServiceInsightHealth

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ServiceInsightHealth object:

  $service_obj->Method(Att1 => { OpenProactiveInsights => $value, ..., OpenReactiveInsights => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ServiceInsightHealth object:

  $result = $service_obj->Method(...);
  $result->Att1->OpenProactiveInsights

=head1 DESCRIPTION

Contains the number of open proactive and reactive insights in an
analyzed AWS service.

=head1 ATTRIBUTES


=head2 OpenProactiveInsights => Int

The number of open proactive insights in the AWS service


=head2 OpenReactiveInsights => Int

The number of open reactive insights in the AWS service



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

