# Generated by default/object.tt
package Paws::LookoutVision::DetectAnomalyResult;
  use Moose;
  has Confidence => (is => 'ro', isa => 'Num');
  has IsAnomalous => (is => 'ro', isa => 'Bool');
  has Source => (is => 'ro', isa => 'Paws::LookoutVision::ImageSource');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutVision::DetectAnomalyResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutVision::DetectAnomalyResult object:

  $service_obj->Method(Att1 => { Confidence => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutVision::DetectAnomalyResult object:

  $result = $service_obj->Method(...);
  $result->Att1->Confidence

=head1 DESCRIPTION

The prediction results from a call to DetectAnomalies.

=head1 ATTRIBUTES


=head2 Confidence => Num

The confidence that Amazon Lookout for Vision has in the accuracy of
the prediction.


=head2 IsAnomalous => Bool

True if the image contains an anomaly, otherwise false.


=head2 Source => L<Paws::LookoutVision::ImageSource>

The source of the image that was analyzed. C<direct> means that the
images was supplied from the local computer. No other values are
supported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutVision>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

