# Generated by default/object.tt
package Paws::GroundStation::Source;
  use Moose;
  has ConfigDetails => (is => 'ro', isa => 'Paws::GroundStation::ConfigDetails', request_name => 'configDetails', traits => ['NameInRequest']);
  has ConfigId => (is => 'ro', isa => 'Str', request_name => 'configId', traits => ['NameInRequest']);
  has ConfigType => (is => 'ro', isa => 'Str', request_name => 'configType', traits => ['NameInRequest']);
  has DataflowSourceRegion => (is => 'ro', isa => 'Str', request_name => 'dataflowSourceRegion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GroundStation::Source

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GroundStation::Source object:

  $service_obj->Method(Att1 => { ConfigDetails => $value, ..., DataflowSourceRegion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GroundStation::Source object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfigDetails

=head1 DESCRIPTION

Dataflow details for the source side.

=head1 ATTRIBUTES


=head2 ConfigDetails => L<Paws::GroundStation::ConfigDetails>

Additional details for a C<Config>, if type is dataflow endpoint or
antenna demod decode.


=head2 ConfigId => Str

UUID of a C<Config>.


=head2 ConfigType => Str

Type of a C<Config>.


=head2 DataflowSourceRegion => Str

Region of a dataflow source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GroundStation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

