// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Created by postproc-cld2 4.0 on 2014-02-04 09:02:17
// From command line:
//  --cld2 --cc --opensource --just_read_raw --quad --standard --minchars=2 
//  --mincount=2 --max_items_per_langscript=12000 --flatmap --rr_alloc 
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=18 --thresh=240 
//  --v25 --kentries=1024 --tablename=Quad0122 --suppress=bs-Cyrl sr-ME-Latn 
//  sh-Cyrl sh-Latn ce-Cyrl cv-Cyrl    az-Arab az-Cyrl bs-Cyrl kk-Latn 
//  ku-Latn my-Latn ru-Latn tg-Arab tk-Arab ug-Latn za-Hani zzb-Latn 
//  zze-Latn zzh-Latn --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn 
//  nd-Latn=>nr-Latn blu-Latn=>hmn-Latn  --ko_english --force_to_lang_soft 
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10 
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 
//  --langcounts --writebin --list_items=120 --max_langs_per_item=3 
//  /hdb1/cld2/probs/p90_raw_quadgrams_2014.utf8 
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives ICELANDIC
static const uint32 kQuad0122BuildDate = 20140204;    // yyyymmdd


// Of 1061893 offered items into 1048576 table entries:
// 842536 filled (79%), 4898 merged (0%), 214459 dropped (20%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 143 languages in range ENGLISH..X_KLINGON:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG 
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN LATIN 
//     MALAY WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE OCCITAN URDU 
//     BIHARI ARABIC CATALAN ESPERANTO BASQUE INTERLINGUA 
//     SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE VIETNAMESE 
//     FRISIAN SLOVAK FAROESE SUNDANESE UZBEK AMHARIC AZERBAIJANI 
//     TIGRINYA PERSIAN BOSNIAN NORWEGIAN_N XHOSA ZULU GUARANI 
//     SESOTHO TURKMEN KYRGYZ BRETON YIDDISH SOMALI UIGHUR KURDISH 
//     MONGOLIAN SINDHI RHAETO_ROMANCE AFRIKAANS LUXEMBOURGISH 
//     TIBETAN ASSAMESE CORSICAN INTERLINGUE KAZAKH LINGALA PASHTO 
//     QUECHUA SHONA TAJIK TATAR TONGA YORUBA MAORI WOLOF ABKHAZIAN 
//     AFAR AYMARA BASHKIR BISLAMA DZONGKHA FIJIAN GREENLANDIC HAUSA 
//     HAITIAN_CREOLE INUPIAK KASHMIRI KINYARWANDA MALAGASY NAURU 
//     OROMO RUNDI SAMOAN SANGO SANSKRIT SISWANT TSONGA TSWANA 
//     VOLAPUK ZHUANG KHASI SCOTS GANDA MANX AKAN IGBO 
//     MAURITIAN_CREOLE HAWAIIAN CEBUANO HMONG NYANJA PEDI SESELWA 
//     VENDA WARAY_PHILIPPINES NDEBELE X_PIG_LATIN X_KLINGON 

// TopLanguage  TokenCount
//  ENGLISH 5681
//  DANISH 6791
//  DUTCH 4519
//  FINNISH 8294
//  FRENCH 5204
//  GERMAN 6989
//  HEBREW 8816
//  ITALIAN 1634
//  Japanese 4553
//  Korean 136
//  NORWEGIAN 5433
//  POLISH 8733
//  PORTUGUESE 4461
//  RUSSIAN 8677
//  SPANISH 3008
//  SWEDISH 8227
//  CZECH 14701
//  ICELANDIC 8790
//  LATVIAN 8793
//  LITHUANIAN 8709
//  ROMANIAN 11257
//  HUNGARIAN 8732
//  ESTONIAN 8101
//  Unknown 14021
//  BULGARIAN 8663
//  CROATIAN 4585
//  SERBIAN 12191
//  IRISH 7706
//  GALICIAN 3529
//  TAGALOG 1633
//  TURKISH 8711
//  UKRAINIAN 8685
//  HINDI 14214
//  MACEDONIAN 8723
//  BENGALI 8685
//  INDONESIAN 2759
//  LATIN 4713
//  MALAY 2253
//  WELSH 6895
//  NEPALI 8768
//  ALBANIAN 7660
//  BELARUSIAN 8787
//  JAVANESE 4431
//  OCCITAN 4645
//  URDU 8717
//  BIHARI 9074
//  ARABIC 9023
//  CATALAN 4450
//  ESPERANTO 6594
//  BASQUE 4267
//  INTERLINGUA 612
//  SCOTS_GAELIC 5572
//  SWAHILI 3370
//  SLOVENIAN 5809
//  MARATHI 8775
//  MALTESE 8102
//  VIETNAMESE 7636
//  FRISIAN 4270
//  SLOVAK 8704
//  ChineseT 585
//  FAROESE 8247
//  SUNDANESE 4679
//  UZBEK 21885
//  AMHARIC 8748
//  AZERBAIJANI 8799
//  TIGRINYA 8728
//  PERSIAN 8853
//  BOSNIAN 2628
//  NORWEGIAN_N 4517
//  XHOSA 5240
//  ZULU 2750
//  GUARANI 8147
//  SESOTHO 1622
//  TURKMEN 14775
//  KYRGYZ 17420
//  BRETON 5427
//  YIDDISH 8744
//  SOMALI 5941
//  UIGHUR 14978
//  KURDISH 8764
//  MONGOLIAN 8782
//  SINDHI 8783
//  RHAETO_ROMANCE 3965
//  AFRIKAANS 4856
//  LUXEMBOURGISH 5496
//  TIBETAN 5186
//  ASSAMESE 8713
//  CORSICAN 2969
//  INTERLINGUE 1228
//  KAZAKH 17354
//  LINGALA 1565
//  PASHTO 8755
//  QUECHUA 4818
//  SHONA 3250
//  TAJIK 8640
//  TATAR 17530
//  TONGA 2533
//  YORUBA 8664
//  MAORI 4207
//  WOLOF 5651
//  ABKHAZIAN 8687
//  AFAR 3411
//  AYMARA 1704
//  BASHKIR 8723
//  BISLAMA 822
//  DZONGKHA 754
//  FIJIAN 1490
//  GREENLANDIC 3033
//  HAUSA 2610
//  HAITIAN_CREOLE 5977
//  INUPIAK 939
//  KASHMIRI 7012
//  KINYARWANDA 3236
//  MALAGASY 2985
//  NAURU 2324
//  OROMO 3183
//  RUNDI 1168
//  SAMOAN 2483
//  SANGO 1432
//  SANSKRIT 17558
//  SISWANT 2565
//  TSONGA 1828
//  TSWANA 1066
//  VOLAPUK 2883
//  ZHUANG 2870
//  KHASI 1534
//  SCOTS 2165
//  GANDA 4246
//  MANX 5320
//  AKAN 3082
//  IGBO 3500
//  MAURITIAN_CREOLE 1358
//  HAWAIIAN 1363
//  CEBUANO 1388
//  HMONG 2053
//  NYANJA 2052
//  PEDI 531
//  SESELWA 698
//  VENDA 1125
//  WARAY_PHILIPPINES 1702
//  NDEBELE 138
//  X_PIG_LATIN 6757
//  X_KLINGON 5786



// Recognized language-script combinations [193]:
static const char* const kQuad0122RecognizedLangScripts = 
  "aa-Latn ab-Cyrl af-Latn ak-Latn am-Ethi ar-Arab ar-Beng ar-Cyrl "
  "ar-Deva ar-Hebr ar-Latn as-Beng ay-Latn az-Latn ba-Cyrl be-Cyrl "
  "bg-Cyrl bg-Latn bh-Deva bi-Latn bn-Beng bn-Latn bo-Cyrl bo-Tibt "
  "br-Latn bs-Arab bs-Latn ca-Latn ceb-Latn co-Latn crs-Latn cs-Cyrl "
  "cs-Latn cy-Latn da-Arab da-Latn de-Latn dz-Tibt en-Arab en-Latn "
  "eo-Latn es-Cyrl es-Latn et-Latn eu-Latn fa-Arab fa-Hebr fa-Latn "
  "fi-Latn fj-Latn fo-Latn fr-Arab fr-Cyrl fr-Latn fy-Latn ga-Latn "
  "gd-Latn gl-Latn gn-Latn gv-Latn ha-Latn haw-Latn hi-Arab hi-Deva "
  "hi-Latn hmn-Latn hr-Arab hr-Latn ht-Latn hu-Cyrl hu-Latn ia-Latn "
  "id-Arab id-Latn ie-Latn ig-Latn ik-Latn is-Latn it-Latn iw-Hebr "
  "iw-Latn ja-Arab ja-Cyrl ja-Latn jw-Latn kha-Latn kk-Arab kk-Cyrl "
  "kl-Latn ko-Cyrl ko-Latn ks-Arab ks-Deva ku-Arab ky-Arab ky-Cyrl "
  "la-Latn lb-Latn lg-Latn ln-Latn lt-Latn lv-Latn mfe-Latn mg-Latn "
  "mi-Latn mk-Cyrl mk-Latn mn-Cyrl mn-Latn mr-Deva ms-Latn mt-Latn "
  "na-Latn ne-Deva nl-Latn nn-Latn no-Latn nr-Latn nso-Latn ny-Latn "
  "oc-Arab oc-Latn om-Latn pl-Cyrl pl-Latn ps-Arab pt-Latn qu-Latn "
  "rm-Latn rn-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn sa-Deva sa-Latn "
  "sco-Latn sd-Arab sg-Latn sk-Latn sl-Cyrl sl-Latn sm-Latn sn-Latn "
  "so-Latn sq-Cyrl sq-Latn sr-Cyrl sr-Latn ss-Latn st-Latn su-Latn "
  "sv-Cyrl sv-Latn sw-Latn tg-Cyrl ti-Ethi tk-Cyrl tk-Latn tl-Arab "
  "tl-Cyrl tl-Latn tlh-Latn tn-Latn to-Latn tr-Cyrl tr-Latn ts-Latn "
  "tt-Cyrl tt-Latn ug-Arab ug-Cyrl uk-Cyrl uk-Latn un-Cyrl un-Latn "
  "ur-Arab uz-Arab uz-Cyrl uz-Latn ve-Latn vi-Arab vi-Latn vo-Latn "
  "war-Latn wo-Latn xh-Latn yi-Hebr yo-Latn za-Latn zh-Hant-Latn zu-Latn "
  "zzp-Latn ";

static const uint32 kQuad0122Size = 262144;    // Bucket count
static const uint32 kQuad0122KeyMask = 0xfffc0000;    // Mask hash key

static const IndirectProbBucket4 kQuad0122[kQuad0122Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x7bc40002,0x58fc0003,0x39580004,0x62880005}},	// [000] rniu, _ཟུངས_, _pbrs_, nxeo, 
   {{0x7bc40006,0x63a80007,0x69c40008,0x27ec0009}},	//   sniu, hhen, gnhe, _ahen_, 
   {{0x6b8c000a,0x52e0000b,0x27ec000c,0xa3c4000d}},	//   bjag, _पर्स, _bhen_, उचा_, 
   {{0x06b4000e,0x69c4000f,0x63a80010,0x81c80011}},	//   _জড়ি, anhe, jhen, লতি_, 
   {{0x63a80012,0x27ec0013,0x13b40014,0x00000000}},	//   dhen, _dhen_, یٖتھ_, --, 
   {{0x6fdc0015,0x24500016,0x99740017,0x63a80018}},	//   léct, _bơm_, _тумш, ehen, 
   {{0x93a40019,0x24500016,0x9484001a,0xd3a4001b}},	//   ишид, _cơm_, рылд, ирип, 
   {{0x6fdc001c,0x63a8001d,0x27ec001e,0xb444001f}},	//   néct, ghen, _ghen_, _የክልሉ, 
   {{0xca440020,0x06040021,0x51840022,0x20a00023}},	//   _ዕይታዎ, _внук_, ауна, _ዝመረጹ_, 
   {{0x68040024,0x63a80025,0x55e40026,0x0f1c0027}},	//   _sėdi, ahen, _тозб, पर्स_, 
   {{0x63a80028,0x75280029,0x6aac002a,0x2474002b}},	//   bhen, _iedz, zzaf, _gām_, 
   {{0x63a8002c,0x7528002d,0x6e3c002e,0x6f1c002f}},	//   chen, _hedz, trsb, ubsc, 
   {{0x75280030,0x6e3c0031,0xd1740032,0x69c40033}},	//   _kedz, ursb, _ҡыҫы, ynhe, 
   {{0x75280034,0x70540035,0x7bc80036,0x41a00037}},	//   _jedz, _هنتا, édun, _ओतएस, 
   {{0x75280038,0x6b8c0039,0x6fdc003a,0x69c4003b}},	//   _medz, tjag, féct, vnhe, 
   {{0x7528003c,0x69c4003d,0x6d400008,0x2fc8003e}},	//   _ledz, wnhe, ólab, _ujag_, 
   {{0x6b8c003f,0x75280040,0x69340041,0x27ec0042}},	// [010] rjag, _oedz, йнау, _rhen_, 
   {{0x27ec0043,0x63a80044,0x75280045,0x7ac40046}},	//   _shen_, zhen, _nedz, істе, 
   {{0x69c40047,0x2b580048,0x27ec0049,0x6fdc004a}},	//   rnhe, _tbsc_, _phen_, sécu, 
   {{0x63a8004b,0x7528004c,0x2450004d,0x4ba4004e}},	//   xhen, _aedz, _rơm_, _төгү_, 
   {{0x7528004f,0xd5ac0050,0x24500051,0x00000000}},	//   _bedz, کہٕ_, _sơm_, --, 
   {{0x27ec0052,0x63a80053,0x7df40054,0x24740055}},	//   _when_, when, _uńst, _pām_, 
   {{0x27ec0056,0x75280057,0x21680058,0x63a80059}},	//   _then_, _dedz, қини_, then, 
   {{0x27ec003e,0x6288005a,0x63a8005b,0x387c005c}},	//   _uhen_, txeo, uhen, ævre_, 
   {{0x63a8005d,0xe298005e,0x6728005f,0x16580060}},	//   rhen, уап_, _ieej, _مسلک_, 
   {{0x24740061,0x21a40062,0x21680063,0x75280064}},	//   _tām_, сиом, ћини_, _gedz, 
   {{0x2a680065,0x66080066,0x66000067,0x5f040068}},	//   hwab_, _huek, _iilk, йзна, 
   {{0x66080069,0x63a4006a,0x6600006b,0xf374006c}},	//   _kuek, êhnd, _hilk, _وطند, 
   {{0x6600006d,0x6728006e,0x7528006f,0x2a68003e}},	//   _kilk, _meej, _yedz, jwab_, 
   {{0x67280070,0x66000071,0x66080072,0x3cf40073}},	//   _leej, _jilk, _muek, ंधले_, 
   {{0x66000074,0x7b840075,0x66080076,0x6fdc0077}},	//   _milk, يارە, _luek, téct, 
   {{0x67280078,0x66000079,0x28bc007a,0x1db80073}},	//   _neej, _lilk, ्पनि, _उगवत, 
   {{0x6d40007b,0x6600007c,0x00000000,0x00000000}},	// [020] ólac, _oilk, --, --, 
   {{0x46d8007d,0x2d980032,0x6600007e,0x75e4007f}},	//   _बड़ह, _көсө_, _nilk, tòzm, 
   {{0x75280080,0x67280081,0xdb040082,0x63b80083}},	//   _redz, _beej, _omkø, _omwn, 
   {{0x75280084,0x2a6c0085,0x2a680086,0x66080087}},	//   _sedz, ́mbɛ_, bwab_, _buek, 
   {{0x66000088,0x67280089,0x7528008a,0x6608008b}},	//   _bilk, _deej, _pedz, _cuek, 
   {{0xdb14008c,0x8e54008d,0x6600008e,0x5d78008f}},	//   ábær, מינג_, _cilk, ראַק, 
   {{0x66000050,0x75280090,0x67280091,0x986c0092}},	//   _dilk, _vedz, _feej, _ባልሆኑ_, 
   {{0x66080093,0x67280094,0x75280095,0x66000096}},	//   _fuek, _geej, _wedz, _eilk, 
   {{0x66080097,0x6fdc0098,0x68040064,0x00000000}},	//   _guek, kécr, _dėdu, --, 
   {{0x41380020,0x75280099,0x6728009a,0x2008009b}},	//   _በአገሪ, _uedz, _zeej, _čair_, 
   {{0x6728009c,0x6608009d,0x81e4009e,0x45f4009f}},	//   _yeej, _zuek, _মূহ_, _افلح_, 
   {{0x7bc800a0,0x660000a1,0x6608009a,0x613400a2}},	//   édul, _zilk, _yuek, _aýlı, 
   {{0x2fd800a3,0x660000a4,0x00000000,0x00000000}},	//   rosg_, _yilk, --, --, 
   {{0x66000050,0xa2c400a5,0x4ea400a6,0x816400a7}},	//   _xilk, ापर्, арҳа, _гръб_, 
   {{0x7c8400a8,0x63b800a9,0x417000aa,0x6fb4007b}},	//   путе, _ymwn, _راوس, _ومتا, 
   {{0x48ec00ab,0x00000000,0x00000000,0x00000000}},	//   _अरबो_, --, --, --, 
   {{0x681400ac,0x672800ad,0xedd400ae,0x00000000}},	// [030] _işdə, _reej, _ويبد, --, 
   {{0x672800af,0x660800b0,0x48a800b1,0x00000000}},	//   _seej, _ruek, лтем_, --, 
   {{0xd24400b2,0xe71800b3,0x672800b4,0x660800b5}},	//   _ڪن_, ليات_, _peej, _suek, 
   {{0xd36400b6,0x932800b7,0x950c00b8,0x00000000}},	//   _غه_, ተንቀሳ, _ākāṃ, --, 
   {{0xd24400b9,0x660000ba,0x672800bb,0xf1c800bc}},	//   _تن_, _pilk, _veej, िचान, 
   {{0xcfcc00bd,0x6728002e,0xe8940023,0xe44800be}},	//   রতিন, _weej, _ዘጸግም_, للتى_, 
   {{0x660000bf,0x6728000d,0x680400c0,0x00000000}},	//   _vilk, _teej, _pėdu, --, 
   {{0xe3b000c1,0x625800c2,0xa2c40073,0x660800c3}},	//   برت_, арор_, ापल्, _tuek, 
   {{0x660000c4,0x660800c5,0x68040064,0x00000000}},	//   _tilk, _uuek, _vėdu, --, 
   {{0x6600002d,0x11d400c6,0x00000000,0x00000000}},	//   _uilk, يوية_, --, --, 
   {{0xdf1400c7,0x00000000,0x00000000,0x00000000}},	//   жьгь, --, --, --, 
   {{0x14d400c8,0x225800c9,0x63b800ca,0x00000000}},	//   _וועל_, _виды_, _umwn, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa0a400cb,0xd9bc00cc,0x5be000cd,0x00000000}},	//   _малд, _অৱনম, पत्व, --, 
   {{0x28d800ce,0xd12c009f,0x00000000,0x00000000}},	//   _बुलि, _شمي_, --, --, 
   {{0xd43c0092,0x00000000,0x00000000,0x00000000}},	//   _አይጠቅ, --, --, --, 
   {{0x5f8000cf,0x00000000,0x00000000,0x00000000}},	// [040] _فۇگە, --, --, --, 
   {{0x999000d0,0x00000000,0x00000000,0x00000000}},	//   kryť_, --, --, --, 
   {{0xe7c800d1,0x00000000,0x00000000,0x00000000}},	//   ﻫﯟﺍﻟ, --, --, --, 
   {{0x6ac400d2,0x00000000,0x00000000,0x00000000}},	//   étfú, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x45b400d3,0x85b400d4,0x00000000,0x00000000}},	//   огію_, оліс_, --, --, 
   {{0xdb0400d5,0x00000000,0x00000000,0x00000000}},	//   _alké, --, --, --, 
   {{0xd32400d6,0xddc400d7,0xd25800d8,0x8c1800d9}},	//   цьки, sukň, ацо_, בוקי, 
   {{0xdcfc00da,0x2c1000c5,0x00000000,0x00000000}},	//   _kopē, _दूनू_, --, --, 
   {{0xd76400db,0x60cc00dc,0x00000000,0x00000000}},	//   _دەچى_, _śama, --, --, 
   {{0xdb0400dd,0xdcfc00de,0x897800df,0xef1000cf}},	//   _elké, _mopē, בריצ, нүйө, 
   {{0x28bc00e0,0x09a400dc,0xb4c800e1,0x649800cf}},	//   ्पति, _गत्य, ैथी_, _утур_, 
   {{0x2308004b,0x00000000,0x00000000,0x00000000}},	//   _اتمي_, --, --, --, 
   {{0xdcfc00e2,0x717400e3,0x24a800e4,0xa11400e5}},	//   _nopē, _رهبا, _ñumí_, _ٹوٹت, 
   {{0xac9400e6,0x2ca400e7,0xdb1400e8,0xac1800e9}},	//   чавш, áld_, fiyà, собу_, 
   {{0x7b8800ea,0x81c800eb,0x00000000,0x00000000}},	//   ољуб_, লতঃ_, --, --, 
   {{0x1ea800ec,0x00000000,0x00000000,0x00000000}},	// [050] _هاٿي_, --, --, --, 
   {{0x3ea400ed,0x0c8400ee,0xdcfc00ef,0xc87800f0}},	//   ømte_, _дымм, _copē, иџе_, 
   {{0xbdf800f1,0xfeb800f2,0x00000000,0x00000000}},	//   _بريا_, _هایت_, --, --, 
   {{0xaa5800f3,0x00000000,0x00000000,0x00000000}},	//   _лиму_, --, --, --, 
   {{0xa9c000f4,0xff7c008f,0x68040024,0x466800f5}},	//   _كۅرۉ, יטאמ, _pėds, ррем_, 
   {{0xdc5400f6,0xe79400f2,0x00000000,0x00000000}},	//   _بریک, _کاسک, --, --, 
   {{0xdb1400d2,0xb50800f7,0x00000000,0x00000000}},	//   liyá, زۉنۅ_, --, --, 
   {{0xd90c00f8,0x00000000,0x00000000,0x00000000}},	//   _لیے_, --, --, --, 
   {{0x970000d1,0x00000000,0x00000000,0x00000000}},	//   _كېمى, --, --, --, 
   {{0xd6c400f9,0x20d400fa,0x00000000,0x00000000}},	//   _عملی, зімс, --, --, 
   {{0x9d4400fb,0x00000000,0x00000000,0x00000000}},	//   үемд, --, --, --, 
   {{0x6d4000fc,0x5f0400fd,0x92b800fe,0x1e9400d8}},	//   ólan, язма, _আঁৰ_, пргр, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdd9000ff,0xddc40083,0x75e40100,0xb0680101}},	//   روز_, mukŋ, tòzi, حصیل_, 
   {{0xa0a40102,0x00000000,0x00000000,0x00000000}},	//   _хайд, --, --, --, 
   {{0x5f740103,0x3c18007f,0x9b080104,0x00000000}},	//   _رابر, _nčve_, снаб_, --, 
   {{0x0b400105,0x00000000,0x00000000,0x00000000}},	// [060] энтн, --, --, --, 
   {{0x7e640106,0xeb980107,0x8e5400df,0x00000000}},	//   _ipip, биӣ_, _צייג_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x87000108,0xe79c000d,0x55e40108,0x00000000}},	//   няше, _तारs, подб, --, 
   {{0x7e640109,0x00000000,0x00000000,0x00000000}},	//   _mpip, --, --, --, 
   {{0x7e64010a,0x3394010b,0x00000000,0x00000000}},	//   _lpip, дайё, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x154400d8,0x00000000,0x00000000,0x00000000}},	//   _неам, --, --, --, 
   {{0xc0f0010c,0x3014010d,0xdddc010e,0x4a98010f}},	//   _ግርም_, мдор, _çyňs, צייג, 
   {{0x7e640110,0xc0540111,0x25a00112,0x00000000}},	//   _apip, пія_, öhle_, --, 
   {{0xdb140113,0x92680114,0x00000000,0x00000000}},	//   yiyá, _грка_, --, --, 
   {{0xc7b000d9,0xc3300115,0x00000000,0x00000000}},	//   תבר_, _נוס_, --, --, 
   {{0xbf140116,0x0dc80117,0x3d180118,0x00000000}},	//   _җүрә, суми_, बुले_, --, 
   {{0x7e640119,0x4158011a,0x00000000,0x00000000}},	//   _epip, _הדוג, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xeb98010b,0x2dd4011b,0x7ac4011c,0x00000000}},	// [070] биң_, _ожир, нсфе, --, 
   {{0xdb14010e,0x00000000,0x00000000,0x00000000}},	//   mnyý, --, --, --, 
   {{0xdd14011d,0xdb14011e,0x9a64001f,0xd1c00092}},	//   _توپخ, siyá, ስተኛው_, _ስኬት_, 
   {{0xdb14011f,0xdc34010f,0xdba00023,0xd9bc00cc}},	//   piyá, _קארט_, _ወለዶም_, _অৱদম, 
   {{0xa5080120,0x25d80121,0x3d14000d,0x00000000}},	//   оела_, омды_, _दलमे_, --, 
   {{0xddd40122,0xf6500123,0xf6d40101,0xe94400f2}},	//   _kryš, طئه_, رزند, _ترحی, 
   {{0x07440124,0x00000000,0x00000000,0x00000000}},	//   _нхам, --, --, --, 
   {{0xc0f00125,0x22140126,0xe3b00127,0x60cc0055}},	//   _ግርማ_, мфор, ضرب_, _śamo, 
   {{0xd24c0128,0x7bc80129,0xd11c0073,0x28bc012a}},	//   لني_, édui, _म्हण_, ्पवि, 
   {{0x6d40012b,0xd24c006c,0x6d1c012c,0xb0c8012d}},	//   ólal, گنی_, _ब्लग_, ाऊंग, 
   {{0x5f4400f1,0x00000000,0x00000000,0x00000000}},	//   وندل, --, --, --, 
   {{0xd24c012e,0xe290012f,0xdd8400e5,0x00000000}},	//   دنی_, _لذت_, ڈجسٹ, --, 
   {{0xe2980130,0xdcb00131,0xc2e80132,0xf1a80133}},	//   _фал_, ھىر_, _اعام_, زایه_, 
   {{0x44c40134,0x4a280135,0xdcb00136,0xd1280137}},	//   _kɑ_, _སྦེལ_, پىر_, _ۇقۇۇ_, 
   {{0x3a200113,0x5fd40138,0x00000000,0x00000000}},	//   wpip_, _оциф, --, --, 
   {{0x44c40134,0x5f4400f1,0x00000000,0x00000000}},	//   _mɑ_, _ځنګل, --, --, 
   {{0x98b00139,0x00000000,0x00000000,0x00000000}},	// [080] _ıbız_, --, --, --, 
   {{0xddd4013a,0x1dd000cd,0x00000000,0x00000000}},	//   _fryš, _सदित, --, --, 
   {{0x44c4013b,0xddc400b0,0x00000000,0x00000000}},	//   _nɑ_, nukō, --, --, 
   {{0x3a20013c,0x07a0013d,0x00000000,0x00000000}},	//   ppip_, кахн, --, --, 
   {{0x9f50003e,0x7bc4013c,0x35c4013e,0x00000000}},	//   _chyé_, miiu, надҳ, --, 
   {{0x44c4013f,0x7bc40140,0x28d80141,0xe7380142}},	//   _bɑ_, liiu, _बुकि, _blŵs_, 
   {{0x5efc00dc,0x799c0143,0x00000000,0x00000000}},	//   रेत्_, _iorw, --, --, 
   {{0x799c0144,0xb2740145,0x28bc0146,0x7bc4003a}},	//   _horw, елиш, ्परि, niiu, 
   {{0x799c0147,0x6f080122,0x31340148,0x00000000}},	//   _korw, žeck, непр, --, 
   {{0x799c0149,0xdb14014a,0xd468014b,0x00000000}},	//   _jorw, liyä, _мизе_, --, 
   {{0x799c014c,0x7bc40093,0x93a8014d,0x6d40014e}},	//   _morw, kiiu, _واصف_, ólam, 
   {{0x799c014f,0xefd00023,0xee200150,0x00000000}},	//   _lorw, ኩምዎ_, лемi_, --, 
   {{0x799c0151,0x41700152,0xdcfc0153,0xeac80154}},	//   _oorw, رایس, _kopė, _শর্ম, 
   {{0x799c0155,0x00000000,0x00000000,0x00000000}},	//   _norw, --, --, --, 
   {{0xe94400e5,0xdb140139,0x00000000,0x00000000}},	//   ہرای, kiyä, --, --, 
   {{0x4a280156,0x53dc0157,0x799c0158,0x7bc40140}},	//   _སྦུལ_, मविश, _aorw, giiu, 
   {{0x799c0159,0x6f0c015a,0xed00015b,0x00000000}},	// [090] _borw, _igac, ্রেস_, --, 
   {{0x6e2c015c,0x7bc40093,0x799c015d,0x88c4015e}},	//   _iwab, aiiu, _corw, وتال, 
   {{0x799c015f,0x6e2c0160,0xa37c0161,0x7bc40162}},	//   _dorw, _hwab, loŵe, biiu, 
   {{0x6e2c0163,0xa6340164,0x44c40165,0xdb140166}},	//   _kwab, енді, _rɑ_, giyä, 
   {{0x6e2c0167,0x799c0168,0x6f0c0169,0x00000000}},	//   _jwab, _forw, _mgac, --, 
   {{0xc864016a,0x44c4016b,0xe298016c,0x6b9c016d}},	//   _отби, _pɑ_, ҷаи_, _hosg, 
   {{0x6e2c016e,0x6b9c016f,0x69c40170,0x316c0171}},	//   _lwab, _kosg, mihe, dedz_, 
   {{0x6f0c0172,0x6e2c0173,0xe298016c,0xdb140174}},	//   _ngac, _owab, заи_, ábør, 
   {{0x6e2c00d2,0x799c0099,0x65600175,0x6b9c0176}},	//   _nwab, _yorw, _tblh, _mosg, 
   {{0x6f0c0177,0x69c40178,0x6b9c0179,0x44c40165}},	//   _agac, nihe, _losg, _tɑ_, 
   {{0x6b9c017a,0x60e8011b,0x00000000,0x00000000}},	//   _oosg, ямом_, --, --, 
   {{0x69c4017b,0x6e2c017c,0x6b9c017d,0x8280017e}},	//   hihe, _bwab, _nosg, _ақид, 
   {{0x69c4017f,0x1d0800cf,0x00000000,0x00000000}},	//   kihe, зеги_, --, --, 
   {{0x236c0180,0x69c40181,0x6f0c0182,0xeac80183}},	//   leej_, jihe, _egac, _শৰ্ম, 
   {{0x30740046,0xae040184,0x6b9c0185,0x6e2c0186}},	//   _ауыс, торҙ, _bosg, _ewab, 
   {{0x63a80187,0x6b9c0188,0x799c0189,0x61e0018a}},	//   nken, _cosg, _sorw, loll, 
   {{0x799c018b,0x63a8018c,0x6e2c018d,0x6b9c00a3}},	// [0a0] _porw, iken, _gwab, _dosg, 
   {{0x61e0018e,0x63a8018f,0x236c0190,0x69c40191}},	//   noll, hken, heej_, gihe, 
   {{0x6b9c0192,0x799c0193,0x7bc40194,0x57440195}},	//   _fosg, _vorw, piiu, енеб, 
   {{0x63a80196,0x69c40197,0x236c0198,0x1bb80199}},	//   jken, aihe, jeej_, _راجع_, 
   {{0x61e0019a,0x63a8019b,0x69c4019c,0x799c019d}},	//   koll, dken, bihe, _torw, 
   {{0x61e0019e,0x69c4019f,0x63a801a0,0x224c01a1}},	//   joll, cihe, eken, duek_, 
   {{0x316c01a2,0x61e001a3,0x63a801a4,0x9f500166}},	//   vedz_, doll, fken, _biyü_, 
   {{0x63a801a5,0x6f0801a6,0x1b0400cc,0x00000000}},	//   gken, žeci, ষুণে_, --, 
   {{0x61e001a7,0x224c0097,0x6d4001a8,0x6f0c01a9}},	//   foll, guek_, ólak, _rgac, 
   {{0x6e2c01aa,0x756400dd,0x6f0c01ab,0x23b00118}},	//   _rwab, _شیعہ_, _sgac, _ráje_, 
   {{0x6e2c01ac,0x316c005f,0x2ee8003e,0x4ac401ad}},	//   _swab, redz_, _syaf_, _रेनव, 
   {{0x9b9400c6,0x63a801ae,0x61e001af,0xb4cc01b0}},	//   _ảήǎ_, cken, aoll, रपी_, 
   {{0x61e001b1,0x69c401b2,0x6e2c01b3,0x6b9c01b4}},	//   boll, yihe, _qwab, _rosg, 
   {{0x61e001b5,0x6b9c01b6,0x28d800bc,0x00000000}},	//   coll, _sosg, _बुझि, --, 
   {{0x6b9c01b7,0x645401b8,0x10080150,0x6f0c01b9}},	//   _posg, _äzit, _ةتتى_, _tgac, 
   {{0x6e2c01ba,0x6f0c01bb,0x69c401b2,0x09b801bc}},	//   _twab, _ugac, wihe, ोच्य, 
   {{0x6e2c01bd,0x6b9c01be,0x61f401bf,0xeb98010b}},	// [0b0] _uwab, _vosg, _æglæ, пиң_, 
   {{0x63a801c0,0x00000000,0x00000000,0x00000000}},	//   zken, --, --, --, 
   {{0x69c401c1,0x63a801c2,0x6b9c01c3,0x224c01c4}},	//   rihe, yken, _tosg, zuek_, 
   {{0x69c401c5,0x38c801c6,0x63a801c7,0xc6d001c4}},	//   sihe, хуун_, xken, лслө, 
   {{0x63a801c8,0x61e001c9,0x224c005a,0x659401ca}},	//   vken, yoll, xuek_, каду, 
   {{0x61e001cb,0x00000000,0x00000000,0x00000000}},	//   xoll, --, --, --, 
   {{0x61e001cc,0x69d40196,0x63a801cd,0xa71401ce}},	//   voll, _ijze, tken, _амбі, 
   {{0x61e001cf,0x224c01c0,0xfa2400cc,0x63a801d0}},	//   woll, tuek_, _পিতল_, uken, 
   {{0x61e001d1,0xe73801d2,0xe1f801b9,0x7d0801d3}},	//   toll, _нең_, мги_, _kérü, 
   {{0x236c01d4,0x224c01c6,0xf7700014,0xd3e401d5}},	//   seej_, ruek_, _پاہ_, _یقلی, 
   {{0x63a801d6,0x224c009d,0x00000000,0x00000000}},	//   pken, suek_, --, --, 
   {{0x61e001d7,0x224c005a,0x00000000,0x00000000}},	//   soll, puek_, --, --, 
   {{0x61e001d8,0x33b00137,0xdb5001d9,0x00000000}},	//   poll, _دەير, یَس_, --, 
   {{0x614401da,0x61e001db,0xdd90009f,0x00000000}},	//   _река, qoll, جوس_, --, 
   {{0xb02401dc,0x1fb401dd,0xdb7800c7,0x00000000}},	//   _trườ, _аспр, мсаш_, --, 
   {{0x1e8401de,0x9f4000d0,0xcb6401df,0xede401e0}},	//   _алим, blká_, касе_, кһөҙ_, 
   {{0xdcfc005f,0x7eb801e1,0xda6401e2,0x00000000}},	// [0c0] _kopī, _dúpé, خازي, --, 
   {{0xdb0401e3,0x00000000,0x00000000,0x00000000}},	//   _omkö, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d401e4,0x7774001f,0x00000000,0x00000000}},	//   _ejze, _በዝቋላ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xceb0010f,0xdcfc00ef,0xd94401e5,0xb8d800cc}},	//   סיג_, _nopī, _шеги, _ছশ_, 
   {{0x629c01e6,0x6d4001e7,0x52c800cd,0xd394008e}},	//   äson, ólai, ाप्स, кәдә_, 
   {{0xc7a001e8,0x43800075,0x07a001e9,0xd43c0092}},	//   _киск, للىق, _касн, _አይፈቀ, 
   {{0x07a001ea,0xa66401eb,0xc7a001a9,0x00000000}},	//   _татн, _مطلو, _титк, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3db800eb,0x70540066,0x00000000,0x00000000}},	//   ঁচাল, دنجا, --, --, 
   {{0x75380010,0x12e40150,0x00000000,0x00000000}},	//   lavz, _иілг, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcfc002b,0x2614012d,0xbb4c01ec,0xc234011a}},	//   _gopī, _फंसी_, _ﺍﻻﻨ_, _ירדו_, 
   {{0xc1f4008f,0x00000000,0x00000000,0x00000000}},	//   _שמוץ_, --, --, --, 
   {{0x7d0801ed,0x6ce40137,0x23b0013a,0x00000000}},	//   _sérü, _ۅزجە, _kája_, --, 
   {{0x395801ee,0x317c0139,0x23b001ef,0x7b1401f0}},	// [0d0] _bcrs_, _kavz_, _jája_, рдух, 
   {{0x23b001f1,0x395800a3,0x700001f2,0x6fe00073}},	//   _mája_, _ccrs_, _ịcha, नववं, 
   {{0x23b00022,0xc7b801d5,0xeff801f3,0x090401f4}},	//   _lája_, мёд_, _ወረድ_, тчам, 
   {{0x6d5401f5,0xe6d4009d,0x6f1c01f6,0x66b40150}},	//   lgza, лцлэ, ncsc, лбеу, 
   {{0x2b5801f7,0x499001ed,0x9de401d9,0x00000000}},	//   _icsc_, _پیار, _شہہٕ_, --, 
   {{0x6d5401f8,0x248401f9,0x2b5801fa,0x273001fb}},	//   ngza, _prlm_, _hcsc_, ạn_, 
   {{0xa3e801fc,0x87d801fd,0x67d401fe,0x00000000}},	//   ндка_, _قبرس_, _бову, --, 
   {{0xe3e801ff,0x9f400200,0x94c801e2,0x00000000}},	//   رکان_, rokë_, عاوې_, --, 
   {{0xd1c00201,0x3d1400bc,0x3878012d,0x00000000}},	//   ስጠት_, _दलले_, _zsrr_, --, 
   {{0x05740202,0x45a00131,0x2bc401f2,0x6738010e}},	//   _جارد, _خەتك, ịcha_, lawj, 
   {{0x9fc80203,0x6e3c002f,0x00000000,0x00000000}},	//   егна_, essb, --, --, 
   {{0x44240204,0xc5f80198,0x2618004d,0x3c180100}},	//   mpn_, ɓɓai_, _kèo_, _sčvo_, 
   {{0xdb040205,0x00000000,0x00000000,0x00000000}},	//   _ilkç, --, --, --, 
   {{0xd00c0206,0x237c0207,0x2618001e,0x5fc400af}},	//   _کلي_, _hawj_, _mèo_, _लगवल, 
   {{0x26180208,0x00000000,0x00000000,0x00000000}},	//   _lèo_, --, --, --, 
   {{0x29100209,0x6d5401a4,0x9f400066,0x7c3c00d8}},	//   _agza_, agza, koké_, rsrr, 
   {{0x1988020a,0x44240175,0x26180208,0x00000000}},	// [0e0] нбаи_, hpn_, _nèo_, --, 
   {{0x237c01d4,0x4424020b,0x9f40020c,0xa78400e5}},	//   _lawj_, kpn_, doké_, یشنو, 
   {{0x180c020d,0x6ee4020e,0x5748020f,0xddc40210}},	//   िदेव_, _مسیل, езем_, pukł, 
   {{0x237c0211,0x29100165,0x261801fb,0xded00023}},	//   _nawj_, _egza_, _bèo_, _ኩሉን_, 
   {{0x9f400066,0x20000010,0x47300212,0x75380010}},	//   goké_, imki_, сніс, tavz, 
   {{0xa5080131,0x00000000,0x00000000,0x00000000}},	//   ھىيە_, --, --, --, 
   {{0xdd300213,0x4424007f,0x38c80214,0x00000000}},	//   zəşt, gpn_, _شاسی_, --, 
   {{0x237c0007,0x7f440215,0x9f400216,0x6e3c0217}},	//   _cawj_, _ndiq, boké_, yssb, 
   {{0x237c0218,0x75380219,0x00000000,0x00000000}},	//   _dawj_, pavz, --, --, 
   {{0x74c4021a,0x1048021b,0x7f44021c,0x4638008f}},	//   _پښتن, нями_, _adiq, _נעבע, 
   {{0x9424021d,0x4424021e,0x6674021f,0x260000bc}},	//   _смее, cpn_, _مدەر, षगरी_, 
   {{0x92b00154,0xae4c0220,0x00000000,0x00000000}},	//   _ঐশী_, _ﺑﻪﺭﯞ_, --, --, 
   {{0x518400d1,0x2618004d,0x6e3c0221,0xcae00027}},	//   _буйа, _xèo_, ussb, _कुंड_, 
   {{0xad240222,0x2a780223,0x7c840224,0x6d5401f5}},	//   شىرى, _rssb_, әуре, ugza, 
   {{0x2ca40225,0x237c0226,0x67380227,0xef100228}},	//   âld_, _yawj_, yawj, _мүнө, 
   {{0x8bb40116,0x06dc0154,0x00000000,0x00000000}},	//   уқму_, বেটি, --, --, 
   {{0xeff80125,0xc9840229,0x68040064,0x00000000}},	// [0f0] _ወረዳ_, лужи, _gėdy, --, 
   {{0x9f40022a,0x00000000,0x00000000,0x00000000}},	//   voké_, --, --, --, 
   {{0x6d44022b,0x7640022c,0x2618007f,0xac9400ee}},	//   _idha, _avmy, _sèo_, _танш, 
   {{0x4424022d,0x9f400066,0x4ae4022e,0x00000000}},	//   vpn_, toké_, _бўга, --, 
   {{0x2c400064,0x00000000,0x00000000,0x00000000}},	//   lėd_, --, --, --, 
   {{0x9f400122,0x237c0097,0x6d44022f,0x44240230}},	//   roké_, _sawj_, _jdha, tpn_, 
   {{0x29040231,0x9f400232,0x6d440233,0x27e80198}},	//   _àla_, soké_, _mdha, ƴan_, 
   {{0x67d40234,0x26180235,0xd3440236,0x00000000}},	//   _тобу, _tèo_, لیمه_, --, 
   {{0x6d440237,0x44240109,0x602000ef,0x00000000}},	//   _odha, spn_, _mēme, --, 
   {{0x6d440238,0x44240239,0x1304023a,0x2114023b}},	//   _ndha, ppn_, шный_, шфиё, 
   {{0x237c0070,0x68040024,0x3d1c01e1,0x66e401ee}},	//   _tawj_, _sėdy, _làwó_, _соҡа, 
   {{0x6d44023c,0x6440023d,0xe7b4023e,0x00000000}},	//   _adha, _ivli, ंसिप, --, 
   {{0xdea0023f,0x2000009b,0x7f440240,0xd1e80092}},	//   زیدی, rmki_, _vdiq, መሮች_, 
   {{0x6d4400b8,0x23b00241,0x224c0242,0x5bac0243}},	//   _cdha, _kájo_, mrek_, घस्व, 
   {{0x6d44002b,0xe0600244,0x00000000,0x00000000}},	//   _ddha, _بێجی, --, --, 
   {{0x6d440245,0x23b001e1,0xf9a40023,0x224c0210}},	//   _edha, _májo_, _ወከፎም_, orek_, 
   {{0x19c40246,0x9d44010b,0x224c0247,0x23b00248}},	// [100] абам, _кепд, nrek_, _lájo_, 
   {{0xd9440249,0x3d1c01e1,0x6440012c,0x6d4001a8}},	//   режи, _dàwó_, _ovli, ólat, 
   {{0xa3e4024a,0x3f80024b,0x1b48024c,0x9f040133}},	//   पका_, _kaiu_, _изни_, _حوکو, 
   {{0xd628024d,0xad24024e,0x06dc0154,0x00000000}},	//   воде_, _پریو, বেছি, --, 
   {{0x3f80024f,0x64400250,0x99740251,0x6d400252}},	//   _maiu_, _avli, _кувш, ðlag, 
   {{0x224c0253,0x3f800254,0x00000000,0x00000000}},	//   drek_, _laiu_, --, --, 
   {{0x224c0255,0xdcec007f,0x98a40256,0x39380257}},	//   erek_, kebč, _тиве, ዮናውያ, 
   {{0x224c0258,0xb17c01e4,0x3d1c0241,0x98500133}},	//   frek_, toĥo, _yàwó_, _هێڕش, 
   {{0x64400259,0x9f40025a,0x224c025b,0x672c00c7}},	//   _evli, tokî_, grek_, ñaje, 
   {{0xd5a800af,0xb17c0115,0xdd18025c,0x00000000}},	//   _कविज, roĥo, għżi, --, 
   {{0x09f4025d,0x6d4400cd,0x224c025e,0x22500210}},	//   שמים_, _rdha, arek_, ązka_, 
   {{0xc474025f,0x224c0260,0x3f800261,0x4fc40262}},	//   _כתבו_, brek_, _caiu_, рсоа, 
   {{0x6d440263,0x224c0264,0x80c40154,0x00000000}},	//   _pdha, crek_, _রুদ্, --, 
   {{0x60200265,0x0dc80266,0x705801b9,0x3ea40267}},	//   _sēme, туми_, _бакр_, ämta_, 
   {{0x3f800268,0x8bc40269,0xab94026a,0x7c84026b}},	//   _faiu_, асад, бављ, оуте, 
   {{0x3f80026c,0x21f800e4,0x00000000,0x00000000}},	//   _gaiu_, mèha_, --, --, 
   {{0x2fc8026d,0x6d40008c,0xba7400db,0x21f8020c}},	// [110] _imag_, ólas, ياكت, lèha_, 
   {{0x6d44026e,0x48a8026f,0xbd6c0023,0x6d400162}},	//   _udha, ктем_, _ድሌቶም_, ðlad, 
   {{0x2d800270,0xb440010a,0x2ed80154,0xec140271}},	//   _iahe_, _доiи, _সরিষ, _دوجد, 
   {{0xd3640272,0x2d800273,0xc60c00dc,0x224c0274}},	//   _عه_, _hahe_, ाद्य_, yrek_, 
   {{0x2d800275,0x6440026c,0xb644013d,0x00000000}},	//   _kahe_, _svli, _şürä, --, 
   {{0x2fc801a9,0x6aac0083,0x69340276,0x224c0277}},	//   _lmag_, myaf, _ынгу, vrek_, 
   {{0x2d800278,0x23b001d3,0x6aac01d3,0x00000000}},	//   _mahe_, _fájl_, lyaf, --, 
   {{0x86b0005e,0x224c0279,0x2d8000af,0xe3b0027a}},	//   _мәлі, trek_, _lahe_, ثرت_, 
   {{0x6aac027b,0x27ec027c,0xc568027d,0x224c027e}},	//   nyaf, _iken_, _لحال_, urek_, 
   {{0x224c027f,0x2fc80280,0x3f800281,0x2d800282}},	//   rrek_, _amag_, _saiu_, _nahe_, 
   {{0x60080283,0x27ec017a,0x25a401ab,0x224c003e}},	//   лном_, _kken_, _ioll_, srek_, 
   {{0x1fb40284,0x25a40285,0x2fc80286,0x224c0287}},	//   ссор, _holl_, _cmag_, prek_, 
   {{0x21680288,0x25a40289,0x4ac4028a,0x2d80028b}},	//   _били_, _koll_, _रेलव, _bahe_, 
   {{0x3f80028c,0x2fc80276,0x6aac0099,0x25a400ef}},	//   _waiu_, _emag_, dyaf, _joll_, 
   {{0x27ec028d,0x2d800198,0x6054028e,0x00000000}},	//   _oken_, _dahe_, _انعط, --, 
   {{0x25a4028f,0x6d400252,0x3f8000d8,0x69d80036}},	//   _loll_, ólar, _uaiu_, éwen, 
   {{0x6aac016b,0x1dd8007b,0x2b380276,0x00000000}},	// [120] gyaf, _مبدع_, рясэ_, --, 
   {{0x2d800290,0x25a40291,0x27ec0292,0x20100293}},	//   _gahe_, _noll_, _aken_, _hiyi_, 
   {{0x20100294,0xddd40006,0x1834007b,0x00000000}},	//   _kiyi_, _kryž, صراح, --, 
   {{0x27ec0295,0x9f400296,0x6aac0297,0x2010002e}},	//   _cken_, kokí_, byaf, _jiyi_, 
   {{0x95c80298,0x6aac0230,0x25a40299,0x75e4026c}},	//   лука_, cyaf, _boll_, mòzz, 
   {{0x27ec029a,0x2010029b,0x9474029c,0x4e78010f}},	//   _eken_, _liyi_, مدعا, טאנצ, 
   {{0x9484026f,0x25a4029d,0xf484029e,0x00000000}},	//   сылд, _doll_, تاشی, --, 
   {{0x2ca4022c,0x2914029f,0xe81c02a0,0x201002a1}},	//   øldi_, ğdaş_, _बंता_, _niyi_, 
   {{0x1a9800c8,0x25a402a2,0x518402a3,0x1544010b}},	//   ריִע, _foll_, буна, _гезм, 
   {{0x25a402a4,0x2fc802a5,0x20100295,0x00000000}},	//   _goll_, _smag_, _aiyi_, --, 
   {{0x201000ca,0x2ed000dc,0x00000000,0x00000000}},	//   _biyi_, सप्त, --, --, 
   {{0x06dc02a6,0x25a402a7,0x6aac02a8,0x03a002a9}},	//   _বৃটি, _zoll_, yyaf, _нихо, 
   {{0x2d8002aa,0xa3e402ab,0xddd40153,0x91e40117}},	//   _pahe_, पकर_, _dryž, _лоде, 
   {{0x25a402ac,0x00000000,0x00000000,0x00000000}},	//   _xoll_, --, --, --, 
   {{0x2d8002ad,0xe81c00e1,0x2d18012d,0x4bd800f2}},	//   _vahe_, _बंधा_, _दलील_, هبرد_, 
   {{0x2fc802ae,0x6d400008,0x2d8000f2,0xb004002b}},	//   _umag_, ðlab, _wahe_, _kuḍy, 
   {{0x0dc802af,0x2d8002b0,0xaa580063,0xe94401b9}},	// [130] _буни_, _tahe_, ризу_, قرای, 
   {{0x602002b1,0x201002b2,0xe81c02ab,0x27ec02b3}},	//   _hēma, _ziyi_, _बंदा_, _sken_, 
   {{0x6aac02b4,0x602002b5,0x201002b6,0x25a402b7}},	//   syaf, _kēma, _yiyi_, _roll_, 
   {{0x25a402b8,0x201002b9,0x9f400022,0xaa9402ba}},	//   _soll_, _xiyi_, mokã_, _димч, 
   {{0xe5a402bb,0x25a402bc,0x60200171,0x00000000}},	//   жили, _poll_, _mēma, --, 
   {{0x3c1802bd,0x00000000,0x00000000,0x00000000}},	//   _sčvi_, --, --, --, 
   {{0x25a402be,0x8728022e,0x00000000,0x00000000}},	//   _voll_, _бўза_, --, --, 
   {{0x27ec02bf,0xe79402c0,0x25a402c1,0x661c020c}},	//   _uken_, _باسک, _woll_, _ésko, 
   {{0x7d000241,0x25a402c2,0xe81c02c3,0x00000000}},	//   _kárí, _toll_, _बूता_, --, 
   {{0xd5840272,0x201002c4,0xa5f802c5,0x00000000}},	//   _وێنه_, _siyi_, _тезу_, --, 
   {{0xa06802c6,0x201002c7,0x349402c8,0x6aa80129}},	//   шана_, _piyi_, _нафр, _àeff, 
   {{0x7d000241,0x229402c9,0x00000000,0x00000000}},	//   _lárí, _ولاس, --, --, 
   {{0x614402ca,0x712401b9,0x23b000e5,0x828402cb}},	//   _дела, غریل, _lájk_, _دجال, 
   {{0x6d4002cc,0x00000000,0x00000000,0x00000000}},	//   ólap, --, --, --, 
   {{0x1d0802cd,0x201002ce,0x628802cf,0x00000000}},	//   реви_, _tiyi_, lveo, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d000241,0x660002d0,0x00000000,0x00000000}},	// [140] _bárí, _ohlk, --, --, 
   {{0x7e6402d1,0x63b80042,0x7cf402d2,0x00000000}},	//   _iqip, _llwn, gþrú, --, 
   {{0xdb0402d3,0x3e6402d4,0x2d9402d5,0xdcfc0064}},	//   _kokë, löt_, _хрыс, _kapč, 
   {{0x62880254,0x00000000,0x00000000,0x00000000}},	//   kveo, --, --, --, 
   {{0x1828006c,0x3e6402d6,0x672c0054,0x75f4022e}},	//   اقچی_, nöt_, ñaja, _bоzо, 
   {{0xdcfc007f,0xd1c0001f,0xd4f001c6,0x85000133}},	//   _lapč, ድበት_, мжлө, ژوون, 
   {{0xa3e400cd,0x00000000,0x00000000,0x00000000}},	//   पकं_, --, --, --, 
   {{0x938802d7,0xdb040036,0x3e6402d8,0x8c18011a}},	//   рска_, _nokë, köt_, סופי, 
   {{0x602002b1,0x6288000f,0x00000000,0x00000000}},	//   _rēma, gveo, --, --, 
   {{0x506402d9,0x7174007b,0x11d402da,0x00000000}},	//   отма, أهدا, تتعد, --, 
   {{0x7e640194,0xdb040200,0xab300139,0x1c1402db}},	//   _aqip, _bokë, _uñçı_, _दंगल_, 
   {{0x4fc402dc,0xe2a80014,0xd99c02dd,0x3e6401a8}},	//   існа, _گامن_, _ﺍﻷﺴﺩ_, föt_, 
   {{0x8d7402de,0xdcfc02df,0x776002e0,0x9f4c01d3}},	//   ياسا, _dapč, _mcmx, ónál_, 
   {{0xe2a802e1,0x75e402e2,0x00000000,0x00000000}},	//   _دامن_, tòzy, --, --, 
   {{0x6020005f,0x3b2802e3,0x0ba4014b,0xd66c0150}},	//   _tēma, _ọyị_, ошам, _ﺴﻔﻴﺭ_, 
   {{0xc05002e4,0x35cc02e5,0x00000000,0x00000000}},	//   _חזק_, ़फड़, --, --, 
   {{0x9a940201,0x7ac402e6,0xdb2402e7,0xaa5402e8}},	// [150] _መካከል_, мсфе, سولی, яваш, 
   {{0x49b802e9,0x9f4000e4,0xf7700133,0x00000000}},	//   جارد_, pokã_, ێان_, --, 
   {{0x9f4002ea,0xe71802eb,0xdb14007f,0x00000000}},	//   loká_, ميات_, riyò, --, 
   {{0x5c78008f,0x6b7402ec,0x628802ed,0x7af80162}},	//   _פארה, _элму, yveo, ðatæ, 
   {{0xa5f802ee,0xf77002ef,0x00000000,0x00000000}},	//   беду_, ئام_, --, --, 
   {{0x75f4022e,0x00000000,0x00000000,0x00000000}},	//   _qоzо, --, --, --, 
   {{0x23b002f0,0xe3b0007b,0x00000000,0x00000000}},	//   _háji_, فرة_, --, --, 
   {{0x58000131,0x3e64023a,0x33f402f1,0x625801d5}},	//   _كۈلك, yöt_, мчыс, брор_, 
   {{0xdb04020c,0xdcfc0100,0xf3c802f2,0x68f401ef}},	//   _cokè, _rapč, تبوه_, _hyzd, 
   {{0x23b000d0,0x31240137,0x62880254,0x7abc011a}},	//   _máji_, үдөг, rveo, יצחו, 
   {{0x602402f3,0xf1a8027d,0xdef40023,0x00000000}},	//   ядна, تايه_, ሉውን_, --, 
   {{0xdee402f4,0x1ae402f5,0x3e6402f6,0xd00c0133}},	//   зоми, পেয়া, töt_, ێلی_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3e6402f7,0x00000000,0x00000000,0x00000000}},	//   röt_, --, --, --, 
   {{0x9f9002f8,0xdb0402d3,0x3e6402f9,0x00000000}},	//   lší_, _tokë, söt_, --, 
   {{0x656002fa,0x9f4002fb,0x3e6402fc,0xab6400de}},	//   _lclh, boká_, pöt_, _neļā, 
   {{0x9f9002fd,0x2bac02fe,0x99740108,0x00000000}},	// [160] nší_, _टकरा, зуеш, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xad240131,0x985402ff,0x9f900030,0x779400f2}},	//   _تىپى, яташ, hší_, ویسا, 
   {{0xdb040098,0xab6400ef,0x9f9000d7,0x00000000}},	//   _loké, _ceļā, kší_, --, 
   {{0x9f900300,0x656c0301,0x0b40010b,0xb17c01e4}},	//   jší_, đahn, _янян, soĥi, 
   {{0x8af80302,0x9f9002fd,0xbbdc0303,0x00000000}},	//   _להכי, dší_, _यदुक, --, 
   {{0x68f4010b,0x00000000,0x00000000,0x00000000}},	//   _gyzd, --, --, --, 
   {{0xdb04011c,0xc8d8011a,0x97c40304,0x440000db}},	//   _pokè, _הקלט, _эйбе, нчыб, 
   {{0xe890001f,0xd0440213,0x31340305,0x51840114}},	//   _የሚሰጡ_, əmək, мепр, пуна, 
   {{0xdb040098,0x9f400306,0x00000000,0x00000000}},	//   _coké, voká_, --, --, 
   {{0x26140307,0x60200171,0x00000000,0x00000000}},	//   _फूटी_, _dēmo, --, --, 
   {{0x57d80034,0x9f900308,0x212401ab,0x76440309}},	//   _भदोह, bší_, aclh_, šiyu, 
   {{0xc20401b9,0xc7b0011a,0x7188024c,0x00000000}},	//   تقین_, גבר_, _мадҳ_, --, 
   {{0x9f400122,0x8d84010b,0x23b00118,0x00000000}},	//   roká_, чумд, _ráji_, --, 
   {{0x9f400232,0x00000000,0x00000000,0x00000000}},	//   soká_, --, --, --, 
   {{0xdb04030a,0x2d840010,0xe8780014,0x00000000}},	//   _zoké, žle_, ۪ماغ_, --, 
   {{0xdcf000da,0xfe70030b,0xad84030c,0x6a14030d}},	// [170] īgāk, _یدی_, _قادۇ, дмау, 
   {{0x6e2c030e,0xc0d0001f,0xfe240124,0x8b64030f}},	//   _itab, _ያጋሩ_, _џьын, _کادم, 
   {{0x6e2c003e,0x9f900118,0x672c0022,0x00000000}},	//   _htab, zší_, ñajo, --, 
   {{0x68f40122,0x9f900118,0xaa5c01ec,0x00000000}},	//   _vyzd, yší_, _кемi, --, 
   {{0xd2440310,0x6e280311,0xc6680312,0xe81c01ad}},	//   _جن_, _îmbă, сшее_, _बूरा_, 
   {{0x9f900313,0x68f401f1,0x6e2c01f7,0xd90c004b}},	//   vší_, _tyzd, _mtab, ایې_, 
   {{0x24080314,0xdb04003e,0x2a680315,0xdcfc00cd}},	//   онки_, _roké, ltab_, _kapā, 
   {{0x9f900316,0x6e2c0317,0xdcfc0318,0x46f000db}},	//   tší_, _otab, _japā, _كۋار, 
   {{0x6e2c0319,0x2a68031a,0xd764031b,0x6728031c}},	//   _ntab, ntab_, _تنقی, _ifej, 
   {{0x9f90031d,0xdcfc00e2,0xd24c006c,0x00000000}},	//   rší_, _lapā, شچه_, --, 
   {{0x2a68031e,0x60e80108,0x00000000,0x00000000}},	//   htab_, юмом_, --, --, 
   {{0x9f90031f,0x2a680320,0x6728031c,0x6d400321}},	//   pší_, ktab_, _jfej, ðlan, 
   {{0x6e2c01ab,0xfe780322,0xc61c0154,0x93600022}},	//   _ctab, чүп_, নীরা_, _рҭыҧ, 
   {{0xfd640323,0x6e2c00c6,0x2a680324,0x00000000}},	//   энгү, _dtab, dtab_, --, 
   {{0x98b80325,0x9b940326,0x00000000,0x00000000}},	//   kapā_, ولست, --, --, 
   {{0x67280327,0x7e640124,0xdb1c0139,0x00000000}},	//   _nfej, _зеиҧ, _äyüp, --, 
   {{0xdcfc0055,0x6e2c00a2,0x98b80055,0x00000000}},	// [180] _dapā, _gtab, dapā_, --, 
   {{0x8d740328,0xdb0400fd,0x00000000,0x00000000}},	//   _قاپا, _ilkü, --, --, 
   {{0x2d8c013f,0x2a6800c5,0xfa8c001f,0x1d080329}},	//   ɛee_, atab_, _መካኒክ_, _фени_, 
   {{0x2a68032a,0x00000000,0x00000000,0x00000000}},	//   btab_, --, --, --, 
   {{0x4cd000bd,0x473002bf,0x2fd8032b,0x6e2c01a9}},	//   _দুপু, тніс, érgi_, _xtab, 
   {{0x672800ef,0x23b000d7,0x38c800f2,0x00000000}},	//   _efej, _máju_, _فازی_, --, 
   {{0x644c005f,0xdcfc0055,0x00000000,0x00000000}},	//   ņain, _yapā, --, --, 
   {{0x4338001f,0x12c40150,0x00000000,0x00000000}},	//   _በኢየሩ, _ﺨﻁﻭﺭ, --, --, 
   {{0xe7bc032c,0x2128032d,0x00000000,0x00000000}},	//   ्फरप, _şaha_, --, --, 
   {{0x6e2c0327,0xa6e0032e,0xa114032f,0x00000000}},	//   _rtab, _óðag, کوپت, --, 
   {{0x200002b1,0x82300330,0x934400d8,0x00000000}},	//   _ūhia_, _یروا, _жнее, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6444000a,0xdde00331,0xc330011a,0x2a680332}},	//   šhit, _šušk, _סוס_, xtab_, 
   {{0x6e2c0333,0x2a680334,0xdcfc002b,0x00000000}},	//   _vtab, vtab_, _sapā, --, 
   {{0xdb0400dd,0xdb14007f,0xdcfc0335,0x00000000}},	//   _elkü, lkyè, _papā, --, 
   {{0x2a680336,0x6e2c0337,0xdd980107,0xcf240338}},	//   ttab_, _ttab, ошӣ_, _غربي, 
   {{0x6e2c0339,0x8e38007b,0x6934033a,0xdb14033b}},	// [190] _utab, _بسعر_, ензу, nkyè, 
   {{0x2a68033c,0x3df4023a,0x98b802b1,0x67280327}},	//   rtab_, _изыс, wapā_, _sfej, 
   {{0x2a68033d,0x98b8033e,0x2250033f,0xdcfc0340}},	//   stab_, tapā_, ązki_, _tapā, 
   {{0x2a680341,0x3ec40342,0x3774013d,0x00000000}},	//   ptab_, _örtü_, вышс, --, 
   {{0x2a680343,0xc79001e0,0x00000000,0x00000000}},	//   qtab_, ерҙы, --, --, 
   {{0xb5c80344,0xdb4c01d9,0xf6500345,0x00000000}},	//   وونم_, _پێے_, شئه_, --, 
   {{0x98b802b5,0x6728031c,0x39140117,0x00000000}},	//   papā_, _tfej, _амрр, --, 
   {{0xf804013d,0x78b80158,0x672801bf,0xe3b00346}},	//   _ачун, øvve, _ufej, طرب_, 
   {{0xd24c0347,0xe7380348,0xd76401b9,0x4cd00349}},	//   مني_, _мең_, _سنلی, _দুমু, 
   {{0x85b800cf,0x1300034a,0xd1c4034b,0x11e002dd}},	//   _بارس_, ызым, елье_, лжым, 
   {{0x21f8034c,0x00000000,0x00000000,0x00000000}},	//   nèhi_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf1a8034d,0xb17c01e4,0x33b000d1,0x00000000}},	//   سایه_, toĥt, _خەير, --, 
   {{0xd24c034e,0x6fdc00e4,0x00000000,0x00000000}},	//   _انو_, hĩch, --, --, 
   {{0xa07400ee,0x23b000e5,0x00000000,0x00000000}},	//   _чылш, _fájt_, --, --, 
   {{0xefe0001f,0x00000000,0x00000000,0x00000000}},	//   ነችው_, --, --, --, 
   {{0xdb04033b,0x1a04034f,0x00000000,0x00000000}},	// [1a0] _alkò, епам, --, --, 
   {{0xdcfc0276,0x99840350,0xd8240351,0x4f040352}},	//   _capă, علاو, еджи, _янын_, 
   {{0x9f4000e4,0x0d38011a,0x00000000,0x00000000}},	//   pokä_, _מגיב, --, --, 
   {{0x627801e4,0xd7080353,0x9a9c0354,0x00000000}},	//   rʈoj, пнее_, _лугi, --, 
   {{0x2b140354,0x00000000,0x00000000,0x00000000}},	//   _аьрр, --, --, --, 
   {{0xa5c00022,0x00000000,0x00000000,0x00000000}},	//   аҩуе, --, --, --, 
   {{0x09e00355,0x799c02d0,0x00000000,0x00000000}},	//   _сорн, _inrw, --, --, 
   {{0x7bc401f4,0x2ca40254,0x00000000,0x00000000}},	//   nhiu, äldi_, --, --, 
   {{0xc3e001e2,0x629c0108,0x00000000,0x00000000}},	//   دګلو, äsop, --, --, 
   {{0x98b80356,0x461000f2,0x00000000,0x00000000}},	//   capă_, _موقر, --, --, 
   {{0x6444000a,0x7bc40357,0xdb10008c,0xc1b401c0}},	//   šhir, khiu, _ágæt, хлэх_, 
   {{0xe3b00014,0xd2440166,0x00000000,0x00000000}},	//   _پرٔ_, _зэки, --, --, 
   {{0x7bc40066,0x82b00214,0x80a000cf,0x00000000}},	//   dhiu, _محوط, _ەمىن, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb3a40358,0x00000000,0x00000000,0x00000000}},	//   _खचाख, --, --, --, 
   {{0x7bc40359,0x799c035a,0x7b640276,0xdb0c01e1}},	//   ghiu, _anrw, лтуе, _ńjáj, 
   {{0xdbcc035b,0x8880035c,0x21f800f2,0x00000000}},	// [1b0] _añón, گیزن, wèhi_, --, 
   {{0x7bc40270,0x00000000,0x00000000,0x00000000}},	//   ahiu, --, --, --, 
   {{0x799c02d0,0xbdf8035d,0x00000000,0x00000000}},	//   _dnrw, _ثريا_, --, --, 
   {{0x7bc4035e,0x21f8020c,0x57b0035f,0xeb04004e}},	//   chiu, rèhi_, ғбәт, _үпүп, 
   {{0x6b9c0360,0x6b8c0361,0xdbcc0022,0x21f800f2}},	//   _insg, mdag, _eñón, sèhi_, 
   {{0x6b8c0362,0x2484003e,0xfa780023,0x00000000}},	//   ldag, _pslm_, _ካላኣይ_, --, 
   {{0x6b8c0363,0x765c00b8,0x00000000,0x00000000}},	//   odag, _ārye, --, --, 
   {{0xe2980364,0xe65c0365,0xc6a4014b,0x00000000}},	//   даи_, ştığ, _прзи, --, 
   {{0x6b8c0366,0x24840367,0x27fc0042,0x00000000}},	//   idag, _wslm_, mlwn_, --, 
   {{0x27fc0368,0x69c40369,0x6b8c036a,0x9e7c0023}},	//   llwn_, nhhe, hdag, _ዕላማና_, 
   {{0x602002b5,0x6b8c036b,0x6e28010f,0x00000000}},	//   _kēmi, kdag, ŭebl, --, 
   {{0x6b8c036c,0xc3c8036d,0x7bc4036e,0x00000000}},	//   jdag, _عظام_, xhiu, --, 
   {{0x63a8036f,0x6b8c0370,0x93b4025f,0x21680371}},	//   mjen, ddag, _שלנו_, _жили_, 
   {{0x1d080372,0x6b8c0373,0x7bc40374,0xd2540375}},	//   деги_, edag, whiu, _ישנה_, 
   {{0x7bc40376,0x22500034,0x63a80377,0x6b8c0378}},	//   thiu, ązku_, ojen, fdag, 
   {{0x63a80379,0x6b8c037a,0xa00800c6,0x00000000}},	//   njen, gdag, _تقبل_, --, 
   {{0x4b2000d6,0xd00c037b,0x65bc00f2,0x1988037c}},	// [1c0] рмув, _بلي_, _rèhn, мбаи_, 
   {{0x63a8037d,0x7f440369,0x7bc4037e,0x38780109}},	//   hjen, _heiq, shiu, _pprr_, 
   {{0x63a8037f,0x6b8c0380,0x7bc40381,0x00000000}},	//   kjen, bdag, phiu, --, 
   {{0x7bc40357,0x63a80382,0x99800383,0x6b8c0076}},	//   qhiu, jjen, _kukū_, cdag, 
   {{0x63a80384,0xcf90008f,0x7f44003a,0x2b5c033f}},	//   djen, יטא_, _meiq, ówce_, 
   {{0x69c40385,0x986401ed,0x589401e0,0x63a80386}},	//   chhe, _لیئے_, _ишбу, ejen, 
   {{0x94840387,0x63a80388,0x53e40022,0xa614035b}},	//   тылд, fjen, кциа, ызшә, 
   {{0x63a80389,0x66040184,0x61e0038a,0x00000000}},	//   gjen, _ҡотҡ, enll, --, 
   {{0x8260038b,0x721801a9,0x9f40038c,0x00000000}},	//   لهين, нжир_, bokú_, --, 
   {{0x6b8c038d,0xa3f4038e,0xdcfc0030,0xd54801d5}},	//   zdag, ější_, _dopĺ, _آلاو_, 
   {{0x63a8038f,0x6b8c0390,0x30140391,0xe3b001d9}},	//   bjen, ydag, лдор, _گرٕ_, 
   {{0x7f440007,0x63a80392,0x69c40165,0x6b8c0169}},	//   _ceiq, cjen, zhhe, xdag, 
   {{0x7f440393,0xe3b001d9,0x6b8c0394,0x81400116}},	//   _deiq, _درٕ_, vdag, اھۇم, 
   {{0x3df40395,0x225800d7,0x00000000,0x00000000}},	//   изяс, áske_, --, --, 
   {{0x6b8c0396,0x80a00397,0x76400211,0x4fc40398}},	//   tdag, _نمون, _lwmy, _аспа, 
   {{0x7f440399,0x321c039a,0x8e24039b,0x6b8c039c}},	//   _geiq, _hivy_, _ифод, udag, 
   {{0x321c0170,0x69c4039d,0xc984039e,0x00000000}},	// [1d0] _kivy_, thhe, кужи, --, 
   {{0x6b8c039f,0x602003a0,0x69c40369,0x2fd800a3}},	//   sdag, _sēmi, uhhe, lisg_, 
   {{0x6b8c03a1,0x660c03a2,0xdb040022,0x2fd801ab}},	//   pdag, ïakm, _pokã, oisg_, 
   {{0x6b8c01b9,0x69c40023,0xe114008f,0x2fd801ab}},	//   qdag, shhe, אַנז_, nisg_, 
   {{0x6d4403a3,0x63a803a4,0x61e00368,0x76400042}},	//   _keha, vjen, ynll, _cwmy, 
   {{0x6d4403a5,0xa50803a6,0x2b4801d9,0x321c03a7}},	//   _jeha, нела_, laac_, _nivy_, 
   {{0x63a803a8,0x6d4403a9,0x69d40327,0x9f4000d0}},	//   tjen, _meha, _imze, rokú_, 
   {{0x6d4403aa,0x9f400030,0x63a8030a,0x638401c6}},	//   _leha, sokú_, ujen, угиа, 
   {{0x63a803ab,0x7f440393,0x6d4403ac,0x442401ab}},	//   rjen, _reiq, _oeha, sqn_, 
   {{0x6d4403ad,0x004403ae,0x7f440097,0xc50803af}},	//   _neha, نیتي_, _seiq, _قتال_, 
   {{0x046403b0,0x63a8031c,0x321c02f0,0x61e00042}},	//   _штам, pjen, _divy_, rnll, 
   {{0xdb0403b1,0x6440014f,0x321c03b2,0x1ec8008e}},	//   _loká, _iwli, _eivy_, елми_, 
   {{0x6d4403b3,0x7f4403b4,0x69d403b5,0xfb8403b6}},	//   _beha, _veiq, _omze, یدری, 
   {{0x614403b7,0x6d4403b8,0x7dd403b9,0xbbbc03ba}},	//   _сека, _ceha, _küsə, ईस्क, 
   {{0x6d4403bb,0x224c03bc,0x2b480014,0x2fd800e8}},	//   _deha, lsek_, faac_, bisg_, 
   {{0x69d403bd,0x7dd403be,0x6d4403bf,0x1f640262}},	//   _amze, _müsə, _eeha, _ским, 
   {{0x224c03c0,0x6d4403c1,0xc0dc0092,0x9b0403c2}},	// [1e0] nsek_, _feha, ነውም_, узад, 
   {{0x6d4403c3,0x644003c4,0x5fb80073,0x98a403c5}},	//   _geha, _owli, _उकडल, лизе, 
   {{0xdb0403c6,0x9f0403c7,0x00000000,0x00000000}},	//   _doká, _جوکو, --, --, 
   {{0x6d440323,0x224c0365,0x69d40221,0x2b480009}},	//   _zeha, ksek_, _emze, caac_, 
   {{0x6d4403c8,0x644003c9,0x224c03ca,0x00000000}},	//   _yeha, _awli, jsek_, --, 
   {{0xf484004b,0x6d4401c4,0x644003cb,0x257003cc}},	//   لابی, _xeha, _bwli, يۇقس, 
   {{0x321c007f,0x629c03cd,0x2ee003ce,0xd32403cf}},	//   _rivy_, åson, _पख्त, льпи, 
   {{0x325403d0,0x321c03d1,0x43800131,0xd46800fd}},	//   авир, _sivy_, ملىق, _җиде_, 
   {{0x64400003,0xdb0401ed,0x224c03d2,0xdde00150}},	//   _ewli, _elkö, gsek_, _ﺍﺳﺎﺑ, 
   {{0x602000da,0x644003cb,0x2fd80042,0x8678011a}},	//   _lēmu, _fwli, wisg_, _ארמו, 
   {{0x4610006c,0x224c01c4,0x09f4025d,0x661c007f}},	//   _اولر, asek_, רמים_, _èska, 
   {{0x6d4403d3,0x2fd801ab,0xf4840133,0x00000000}},	//   _seha, uisg_, _ماڵی, --, 
   {{0x80c403d4,0x2fd803d5,0x224c00e5,0x00000000}},	//   _ৰুদ্, risg_, csek_, --, 
   {{0x3134010b,0x2b480009,0x6d440200,0xec340022}},	//   _текр, waac_, _qeha, ингь, 
   {{0x6d4403d6,0x48bc015b,0xdb0400c7,0x2b480009}},	//   _veha, _আশ্র, _roká, taac_, 
   {{0x6d4403d7,0xdb0401ed,0x6e98009d,0x00000000}},	//   _weha, _soká, _авир_, --, 
   {{0x6d4403d8,0x2d84004a,0x2b4803d9,0xdb040306}},	// [1f0] _teha, ôles_, raac_, _poká, 
   {{0x6d44019b,0x00000000,0x00000000,0x00000000}},	//   _ueha, --, --, --, 
   {{0xdb0403da,0x765c00dc,0x224c03db,0x00000000}},	//   _voká, _ārya, zsek_, --, 
   {{0x224c03dc,0xe71803dd,0xdcfc0034,0xe75803de}},	//   ysek_, نيات_, _napę, тиді_, 
   {{0x98a8005f,0xdb0403df,0x6440010a,0xdd0c03e0}},	//   ējām_, _toká, _swli, _kışa, 
   {{0x2d9003e1,0x69d400aa,0x224c03e2,0xefc80092}},	//   ndze_, _umze, vsek_, _አዛዥ_, 
   {{0x2d900099,0x928c0150,0x00000000,0x00000000}},	//   idze_, _ﻓﺴﻭﻑ_, --, --, 
   {{0x7c280005,0x7dd403e3,0xe3b003e4,0x00000000}},	//   ídri, _vüsə, ترت_, --, 
   {{0xae1403e5,0x779003e6,0xa1c4036b,0x224c03e7}},	//   णगान_, _ریوا, ибид, usek_, 
   {{0x224c03e8,0x2d9001fa,0x00000000,0x00000000}},	//   rsek_, jdze_, --, --, 
   {{0x224c03e9,0xa0680063,0x600803ea,0x00000000}},	//   ssek_, њама_, кном_, --, 
   {{0x224c03eb,0x2d9003ec,0x9f8001e1,0x00000000}},	//   psek_, edze_, _tóí_, --, 
   {{0x2bc8000d,0x224c0327,0xe2840066,0x00000000}},	//   रसना, qsek_, _خطای, --, 
   {{0x629803ed,0x7bc800e2,0x2dc401ec,0xdcfc0210}},	//   _irwo, īdum, йқын_, _zapę, 
   {{0xdd0c03ee,0x5ea401b9,0x7bc803ef,0x51b4010f}},	//   _dışa, _چمبل, ūdum, _כּהן_, 
   {{0x5ea40014,0x2d840129,0x2d9000d7,0x62980210}},	//   _نمبل, ôler_, adze_, _krwo, 
   {{0x5d74014b,0x00000000,0x00000000,0x00000000}},	// [200] _кунф, --, --, --, 
   {{0x200003f0,0x27ec01e4,0x13bc00cc,0x00000000}},	//   llki_, _ĉena_, ইফয়, --, 
   {{0xdca403f1,0xdb040109,0x5fb800bc,0x27e8022e}},	//   _тани, _alkô, _उकाल, еan_, 
   {{0x629802d0,0xed0400d1,0xd9e0000d,0x6d4003f2}},	//   _orwo, _دوپپ, _खदकत_, ðlav, 
   {{0x23a803f3,0x95840228,0xdd0c0166,0xaa6401af}},	//   कानद, илде, _yışa, _леяһ, 
   {{0xd9b800c7,0x00000000,0x00000000,0x00000000}},	//   _рымч_, --, --, --, 
   {{0x92e003f4,0xfcd802d3,0x629802d0,0x48e003f5}},	//   _ধরে_, _ጭቡጥ_, _arwo, _дорв, 
   {{0x629800d8,0x672c0113,0x2d900210,0x00000000}},	//   _brwo, ñajt, zdze_, --, 
   {{0xd62803f6,0x95a400ec,0x558800d8,0x00000000}},	//   _розе_, _پٽان, _ибам_, --, 
   {{0x225803f7,0xda1403f8,0x1458010b,0x6298015d}},	//   áska_, थगित_, _ашды_, _drwo, 
   {{0x60cc03f9,0x629803fa,0x93880209,0xc95002e4}},	//   _ƙama, _erwo, _асла_, חמת_, 
   {{0x03a003fb,0x22580306,0x43d001e2,0x439001af}},	//   _михо, šska_, _وڅيړ, _маєс, 
   {{0xb638037e,0xf19403fc,0xd1c801e0,0x00000000}},	//   _ｄｋ_, _гиль, _илде_, --, 
   {{0x2d9003fd,0x200003fe,0x00d403ff,0x1138005b}},	//   udze_, alki_, ابیت_, _ряды_, 
   {{0xf2e800bd,0x2d900400,0xac940108,0x00000000}},	//   _পরিণ, rdze_, щавш, --, 
   {{0x23a80401,0x00000000,0x00000000,0x00000000}},	//   कायद, --, --, --, 
   {{0x29040402,0xe9780137,0x212800a2,0x0a68011c}},	// [210] _šla_, лбаш_, _şahi_, ърви_, 
   {{0x09c000c7,0x00000000,0x00000000,0x00000000}},	//   әаҧҟ, --, --, --, 
   {{0xbef80403,0x65bc020c,0x6d400008,0x272c032e}},	//   _مریض_, _wèhk, ðlau, _nónó_, 
   {{0x7d0800c5,0xdc98008f,0xdb04007c,0x00000000}},	//   üdse, _עירל, _bokä, --, 
   {{0xc98400a8,0x1adc0404,0x4668030d,0x27e80115}},	//   _куви, _नेपथ, трем_, ĵan_, 
   {{0x65bc020c,0x7c940405,0xdcfc012c,0x5f080406}},	//   _kèhi, _اشیا, _napě, _सरस्_, 
   {{0x29040407,0x23d40408,0xf87000d7,0x00000000}},	//   _ála_, йцир, ľším_, --, 
   {{0xf87002fb,0x6298007f,0x92e003d4,0x850000ec}},	//   žším_, _prwo, _ধৰে_, ٽوڊن, 
   {{0xe1f80409,0x661c007f,0x00000000,0x00000000}},	//   лги_, _èsko, --, --, 
   {{0xa2e4040a,0x9440040b,0xbec40024,0x00000000}},	//   _қолд, _کھون, šūki, --, 
   {{0x66e401e0,0xdcfc00d7,0x349401ee,0xf5d40244}},	//   _тоҡа, _sopľ, _мафр, _بڵنگ, 
   {{0x6298040c,0x9f4002fb,0x3b7c0092,0xfa900023}},	//   _trwo, boký_, _ቢሮዎች_, _ብጭብጢ_, 
   {{0xcd3c040d,0x62980223,0xc1b000c7,0x33f401d3}},	//   ﯨﻨﯩﯔ_, _urwo, _дәны, _بسلس, 
   {{0xa068040e,0x8e0400d4,0x00000000,0x00000000}},	//   _бака_, йняв_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcfc040f,0xf2e803d4,0xdca401d5,0x186801a9}},	//   _topľ, _পৰিণ, _ғами, ғади_, 
   {{0x0b400410,0x628803cb,0x765c0055,0x00000000}},	// [220] янтн, nweo, _āryo, --, 
   {{0x5d840411,0xf1c00412,0x6d400413,0x00000000}},	//   _الدل, एसएन, ðlat, --, 
   {{0x9724007b,0x00000000,0x00000000,0x00000000}},	//   مفاو, --, --, --, 
   {{0xd6280414,0x98a40032,0xa3d802a0,0x99800118}},	//   годе_, _һиге, डोम_, _tuků_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f400306,0x18a40415,0x661c007f,0x4d78010f}},	//   voký_, _лагм, _èskl, ָרקע, 
   {{0xd39400d1,0xdcfc0171,0x00000000,0x00000000}},	//   йәдә_, _nopļ, --, --, 
   {{0x13680416,0xb6c40417,0x62880142,0xdef401f3}},	//   ушки_, _мөлд, fweo, ለሞን_, 
   {{0x9f400418,0x023401d3,0x00000000,0x00000000}},	//   hokó_, یثیت_, --, --, 
   {{0x9f400122,0x27200051,0x672c0419,0x00000000}},	//   roký_, _ẳng_, ľaje, --, 
   {{0x672c041a,0x9f400122,0x3448013e,0x395801bf}},	//   žaje, soký_, _тӯли_, _mdrs_, 
   {{0x9268041b,0x00000000,0x00000000,0x00000000}},	//   _брка_, --, --, --, 
   {{0x63ac0086,0xd9f8041c,0x938801ee,0xdcfc00cd}},	//   _òana, ्तात_, _асһа_, _āyāt, 
   {{0xea0001fb,0xe2a80014,0x2b940051,0x00000000}},	//   _đắp_, _خامن_, _ục_, --, 
   {{0x6ae000cd,0x00000000,0x00000000,0x00000000}},	//   पप्र, --, --, --, 
   {{0x39580175,0x27ec00df,0x4fc40209,0xd1b80133}},	//   _adrs_, _ĉeno_, _ысла, _جاڤا_, 
   {{0x8d840276,0x2fc8041d,0x6d40041e,0x00000000}},	// [230] _лунд, _ilag_, ðlas, --, 
   {{0x6f0c041f,0x9f40011f,0x24880034,0x09dc009e}},	//   _izac, bokó_, łami_, _বীজা, 
   {{0x2fc80420,0x645c0421,0x6d400422,0x6e3c0423}},	//   _klag_, _āsio, ılad, lpsb, 
   {{0x6e3c017a,0x00000000,0x00000000,0x00000000}},	//   opsb, --, --, --, 
   {{0xe6100424,0x00000000,0x00000000,0x00000000}},	//   وشت_, --, --, --, 
   {{0x6f0c0425,0x00000000,0x00000000,0x00000000}},	//   _mzac, --, --, --, 
   {{0x6aac0009,0xa508011c,0x00000000,0x00000000}},	//   lxaf, шека_, --, --, 
   {{0x05740426,0xd24c004b,0x39580427,0x6f0c02d0}},	//   _گارد, چني_, _zdrs_, _ozac, 
   {{0x27ec0428,0x6f0c00ca,0x6aac0429,0xc568042a}},	//   _ijen_, _nzac, nxaf, _محال_, 
   {{0x0574042b,0x2fc8042c,0x39580066,0x225802fb}},	//   _دارد, _alag_, _xdrs_, šsko_, 
   {{0x2fc8042d,0x6f0c042e,0xe108042f,0x6e3c0430}},	//   _blag_, _azac, ренд_, epsb, 
   {{0x2fc80431,0x5fb801f9,0x00000000,0x00000000}},	//   _clag_, _उकळल, --, --, 
   {{0x27ec0051,0xb9240124,0x6f0c012d,0x21280432}},	//   _mjen_, resẽ_, _czac, _şahu_, 
   {{0x6f0c0433,0x6aac0009,0xf1940108,0x00000000}},	//   _dzac, dxaf, _ничь, --, 
   {{0x6f0c0434,0x2fc80435,0x79600241,0xc100009d}},	//   _ezac, _flag_, _láwà, _хүнл, 
   {{0x6d400436,0x2fc80437,0xdee401b9,0x2ca401e3}},	//   ðlar, _glag_, _мойи, ålda_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [240] --, --, --, --, 
   {{0x27ec0438,0x00000000,0x00000000,0x00000000}},	//   _ajen_, --, --, --, 
   {{0x2fc80165,0x27ec0439,0x00000000,0x00000000}},	//   _ylag_, _bjen_, --, --, 
   {{0xdb04043a,0x00000000,0x00000000,0x00000000}},	//   _mokú, --, --, --, 
   {{0xdb04043b,0x27ec0051,0x00000000,0x00000000}},	//   _lokú, _djen_, --, --, 
   {{0x27ec043c,0xd1bc0023,0x1dcc0073,0x349400f5}},	//   _ejen_, ቶታት_, होचत, закр, 
   {{0xb17c01e4,0xa86401ee,0x00000000,0x00000000}},	//   niĥe, _нерҙ, --, --, 
   {{0x27ec02d3,0x7bc4043d,0x2bdc043e,0x440000cf}},	//   _gjen_, nkiu, नोपा, мчыб, 
   {{0x5184004e,0xd5740108,0x7bc400c0,0x00000000}},	//   оуна, _мужь, ikiu, --, 
   {{0x2fc8043f,0x05600440,0xe6d401c6,0x00000000}},	//   _slag_, _овун, _эцсэ, --, 
   {{0x2fc80441,0x7bc40442,0x6f0c0034,0x00000000}},	//   _plag_, kkiu, _szac, --, 
   {{0xea00001e,0xdb0400d0,0xac540023,0x00000000}},	//   _đập_, _dokú, ዝኣብሄ, --, 
   {{0x2fc80443,0x00000000,0x00000000,0x00000000}},	//   _vlag_, --, --, --, 
   {{0x6e3c0444,0x4cd000cc,0x7dd001e3,0x6f0c00d7}},	//   rpsb, _দুগু, _läsf, _vzac, 
   {{0x619400aa,0x00000000,0x00000000,0x00000000}},	//   _راوړ, --, --, --, 
   {{0x6e3c0445,0x2fc800ee,0x7dd0007c,0x6aac0009}},	//   ppsb, _ulag_, _näsf, txaf, 
   {{0x6d4003ee,0xfd6800e4,0x6f0c0446,0x00000000}},	// [250] ılab, nesỹ, _uzac, --, 
   {{0x27ec0385,0x88c40447,0xad4000f7,0x2a840092}},	//   _sjen_, يتال, _سۉرۉ, ርተኞች_, 
   {{0x6e2c01d4,0x6e24014b,0x48a80448,0x6aac0449}},	//   _huab, _iihb, штам_, sxaf, 
   {{0x6e2c044a,0xdb040248,0x8b6400f2,0x25dc044b}},	//   _kuab, _lokù, _بادم, कोनी_, 
   {{0xe5a4044c,0xf770044d,0x27ec044e,0x00000000}},	//   зили, ضان_, _vjen_, --, 
   {{0x6e24016d,0x6e2c044f,0x00000000,0x00000000}},	//   _jihb, _muab, --, --, 
   {{0x60cc0198,0xc44401ed,0x27ec0450,0x69c400f1}},	//   _ƙamm, زیشن_, _tjen_, mkhe, 
   {{0x6e24014f,0xd5e001f2,0x89d40451,0xe3a80452}},	//   _lihb, twọ, _اوڀر_, скид_, 
   {{0x67280453,0x6e2c0134,0x03a00454,0x00000000}},	//   _igej, _nuab, зиқо, --, 
   {{0xdb040030,0x6e240455,0x7bc4005a,0xbbb80456}},	//   _pokú, _nihb, zkiu, _इक्क, 
   {{0x6e2c01ab,0x2a680457,0xa0a40458,0x7bc40006}},	//   _auab, huab_, чанд, ykiu, 
   {{0x6e2c0459,0x27fc045a,0x69c4045b,0x3108045c}},	//   _buab, nown_, hkhe, өнөп_, 
   {{0x6e24045d,0x88c0045e,0xdb04045f,0x6e2c004e}},	//   _bihb, ্পিক, _enkê, _cuab, 
   {{0x69c40460,0x6e2c0461,0x20540462,0x7dd0013d}},	//   jkhe, _duab, _етир, _mäsg, 
   {{0x7bc40357,0x63b80463,0x5f800132,0xc18001d3}},	//   tkiu, _kown, _كۇدە, _فیکٹ, 
   {{0x61e00464,0x67280465,0x69c40466,0x7bc40467}},	//   lill, _ngej, ekhe, ukiu, 
   {{0x61e00468,0xc0400020,0x6e2c0469,0x63b80142}},	// [260] oill, _የተባለ, _guab, _mown, 
   {{0x6728046a,0x3ea0046b,0x6e240097,0x6d40046c}},	//   _agej, _irit_, _gihb, ılac, 
   {{0x60c000ee,0x27fc0135,0x00000000,0x00000000}},	//   nylm, fown_, --, --, 
   {{0x3ea0046d,0x88b0036b,0x69c401f5,0x00000000}},	//   _krit_, ریقچ, akhe, --, 
   {{0xd5b8046e,0x3f8000ec,0x2a680211,0x6e2c005a}},	//   йск_, _mbiu_, cuab_, _xuab, 
   {{0x75d4046f,0x61e00470,0xd004009e,0x95f4033f}},	//   بيتا, jill, োদয়_, इवेट_, 
   {{0x672c0471,0x63b80042,0x74140345,0xd8b40472}},	//   žaja, _bown, ووتا, _عمرخ, 
   {{0xb9e8044e,0x660c03a2,0x61e00473,0x93880474}},	//   _ዮም_, ïakr, eill, сска_, 
   {{0x63b80475,0xdb0401e1,0xe7e0000d,0x63bc01f4}},	//   _down, _pokù, _खगता_, ösna, 
   {{0x61e00476,0x3f80003a,0x63b802d0,0x6e2c0332}},	//   gill, _abiu_, _eown, _ruab, 
   {{0x6e240477,0x3ea00478,0x63b80142,0x6e2c0479}},	//   _rihb, _arit_, _fown, _suab, 
   {{0x3ea0047a,0x63b8047b,0x61e0047c,0x6e24047d}},	//   _brit_, _gown, aill, _sihb, 
   {{0x6e24047e,0x23a8047f,0x3ea0045a,0xe2a800ec}},	//   _pihb, कारद, _crit_, _واهن_, 
   {{0x61e00480,0x6e2c0481,0x3ea00482,0x6e24014f}},	//   cill, _vuab, _drit_, _qihb, 
   {{0x3ea00483,0x6e24047e,0x60c002d0,0x7c840484}},	//   _erit_, _vihb, cylm, нуте, 
   {{0x3ea00485,0xcf240486,0x6e2c0487,0x2a680488}},	//   _frit_, _عربي, _tuab, tuab_, 
   {{0x3ea00489,0xadf4048a,0x46d80307,0x7dd0010b}},	// [270] _grit_, _опиш, _मेंह, _bäsd, 
   {{0xfb3401c0,0xfbd001ed,0x8a900051,0x00000000}},	//   _үнээ, پتہ_, nộim, --, 
   {{0x69c4048b,0x2a680070,0x2d8000a3,0x00000000}},	//   rkhe, suab_, _ibhe_, --, 
   {{0x69c4048c,0x7dd0010b,0xda6400ec,0x00000000}},	//   skhe, _päsg, _ڪاٽي, --, 
   {{0x27fc048d,0x63b8048e,0x61e0048f,0x26080490}},	//   rown_, _rown, yill, ितली_, 
   {{0xd1240491,0x63b80492,0x27fc0076,0x998000ef}},	//   _لم_, _sown, sown_, _tukš_, 
   {{0xdb0402bd,0x63b80493,0xf674009d,0x00000000}},	//   _ankè, _pown, _үгсэ, --, 
   {{0x67280223,0x7c380494,0x29100495,0xf7940276}},	//   _ugej, _évre, _izza_, _пасэ, 
   {{0x61e00496,0x24880497,0x614401f0,0x00000000}},	//   till, ňam_, мепа, --, 
   {{0x61e00498,0x7dd00499,0x63b80263,0x3ea00023}},	//   uill, _käse, _wown, _rrit_, 
   {{0x61e0049a,0x7dd0049b,0x00000000,0x00000000}},	//   rill, _jäse, --, --, 
   {{0x61e0049c,0xdee4049d,0x9424049e,0x60c00209}},	//   sill, доми, _قولۇ, rylm, 
   {{0x7dd0049f,0x9f4004a0,0xe06003e6,0x00000000}},	//   _läse, kokö_, رێکی, --, 
   {{0x61e004a1,0xbb2c04a2,0x29100083,0xa3d803ba}},	//   qill, ﻧﺪﻩ_, _ozza_, डोर_, 
   {{0x9f400023,0x7dd000fd,0x3ea004a3,0x00000000}},	//   nikë_, _näse, _writ_, --, 
   {{0x3ea004a4,0xea000016,0xdb040036,0x00000000}},	//   _trit_, _đạp_, _unkë, --, 
   {{0x291004a5,0x3ea004a6,0x2fd801f5,0x997401f4}},	// [280] _azza_, _urit_, ërge_, дуеш, 
   {{0x7dd00139,0x4e000022,0xea9401c6,0x260c012d}},	//   _bäse, _изыб, эшсэ, _ढीली_, 
   {{0x9f400240,0x672c00d0,0xf8a401c6,0x00000000}},	//   jikë_, ľajn, эгжү, --, 
   {{0xbb2c040d,0x672c04a7,0x9f40036e,0x2bdc041c}},	//   ﻧﺪﻯ_, žajn, dikë_, नोदा, 
   {{0x291004a8,0x7dd00139,0x00000000,0x00000000}},	//   _ezza_, _täsd, --, --, 
   {{0x9f400240,0x00000000,0x00000000,0x00000000}},	//   fikë_, --, --, --, 
   {{0x629c00b5,0x9f8001e7,0x438000d1,0x00000000}},	//   æson, _dóú_, چلىق, --, 
   {{0x438004a9,0xa3d804aa,0x00000000,0x00000000}},	//   نلىق, डोल_, --, --, 
   {{0x248400ca,0xd16400a7,0xdcfc00de,0xc0400092}},	//   _eplm_, мъни, _kapē, _የተቻለ, 
   {{0x7dd004ab,0x9f400200,0x056001a9,0x00000000}},	//   _läsb, bikë_, _авфн, --, 
   {{0x1cd80327,0xdcfc0171,0x00000000,0x00000000}},	//   ྡགས_, _mapē, --, --, 
   {{0x7dd00267,0x9f400100,0x68e000a2,0x00000000}},	//   _näsb, nikè_, _ýlde, --, 
   {{0x441804ac,0xff0404ad,0xc7b004ae,0xa3bc04af}},	//   _וואס, вярн, דבר_, ीघर_, 
   {{0x22480432,0x00000000,0x00000000,0x00000000}},	//   _çaka_, --, --, --, 
   {{0xc04c0046,0xac1804b0,0xc170011a,0x00000000}},	//   _ші_, зову_, _יחס_, --, 
   {{0x7dd000fd,0x7b6404b1,0xc0c804b2,0x00000000}},	//   _räse, ктуе, _አካሉ_, --, 
   {{0x9f4002d3,0x98b800b0,0x00000000,0x00000000}},	// [290] zikë_, kapē_, --, --, 
   {{0x7dd0014a,0x2d8000cd,0xac94009b,0x00000000}},	//   _päse, _ubhe_, _заош, --, 
   {{0x6ce404b3,0xbc9404b4,0xbdf8009f,0xfeb80244}},	//   _سزدە, _иңрә, _تريا_, _فایت_, 
   {{0x6d5403d1,0xdb0400e4,0x7dd001e6,0xad10035b}},	//   laza, _hoký, _väse, _аҿҳә, 
   {{0x6b8c04b5,0x248404b6,0xa56401d5,0x672c0427}},	//   meag, _splm_, فگان, žajo, 
   {{0x6d5404b7,0x9f40044e,0xdcec0006,0x6b8c04b8}},	//   naza, tikë_, gebė, leag, 
   {{0x26c804b9,0x291004ba,0x83d8033f,0x67d404bb}},	//   šao_, _uzza_, यफलआ, _зову, 
   {{0x6b8c04bc,0x6d5404bd,0x7dd004be,0x9f400023}},	//   neag, haza, _käsc, rikë_, 
   {{0x601404bf,0xcaa002d3,0x6b8c0363,0x21740107}},	//   náme, _ወጺኦም_, ieag, нунр, 
   {{0x6b8c04c0,0x7dd004c1,0x9f40036e,0xe0d804c2}},	//   heag, _mäsc, pikë_, зво_, 
   {{0x9f4004c3,0x7dd004c4,0xe7e004c5,0x6b8c04c6}},	//   liké_, _läsc, যকীয, keag, 
   {{0xc0c804c7,0x6b8c04c8,0x00000000,0x00000000}},	//   _አካል_, jeag, --, --, 
   {{0x6d540364,0x6d40046c,0x712401ed,0x7dd001c7}},	//   faza, ılan, ٹریل, _näsc, 
   {{0x6b8c00ad,0x00800139,0x00000000,0x00000000}},	//   eeag, _аккү, --, --, 
   {{0x6b8c04c9,0x9f40020c,0xdb0400d7,0x48c00154}},	//   feag, hiké_, _doký, ্পুর, 
   {{0x6b8c04ca,0x7dd00221,0xdcfc00ef,0x00000000}},	//   geag, _bäsc, _sapē, --, 
   {{0x7dd00267,0xdcfc00e2,0x00000000,0x00000000}},	// [2a0] _väsb, _papē, --, --, 
   {{0x200004cb,0x7dd004cc,0x8d740131,0xa7340023}},	//   loki_, _däsc, _كاپا, _ብሓፈሻ, 
   {{0x6b8c04cd,0x7dd00166,0x987c0205,0x00000000}},	//   beag, _täsb, tçıt_, --, 
   {{0x48c000bd,0x2ca404ce,0x601404cf,0x200004d0}},	//   ্পূর, ælde_, lámb, noki_, 
   {{0x7dd004d1,0x601400d2,0x69d000e2,0xdcfc00de}},	//   _gäsc, cáme, _ūdeņ, _tapē, 
   {{0x200004d2,0x38c804d3,0x601404d4,0x00000000}},	//   hoki_, _قازی_, námb, --, 
   {{0x200004d5,0x046000ee,0x765c0055,0x00000000}},	//   koki_, гтым, _āryu, --, 
   {{0x6d5404d6,0x601404d7,0x2000023a,0x00000000}},	//   zaza, hámb, joki_, --, 
   {{0x200004d8,0x6d5404d9,0x46b40034,0x9f400214}},	//   doki_, yaza, _आपयह, ciké_, 
   {{0x6b8c01c0,0xb9e4001f,0x453004da,0x74a00131}},	//   zeag, _ጫና_, _مىكر, _ﺋﯧﭽﯩ, 
   {{0x200003c1,0xc05404db,0xdb0404dc,0x6d5404dd}},	//   foki_, нія_, _kokó, vaza, 
   {{0x6d5404de,0x200004df,0x6b8c01c6,0xdb0400a2}},	//   waza, goki_, xeag, _soký, 
   {{0x6d5404e0,0xdb0404e1,0x6b8c04e2,0x92dc00cc}},	//   taza, _mokó, veag, _দুৰ_, 
   {{0xdb0404e3,0x2bc804e4,0x717404e5,0x7dd004e6}},	//   _lokó, रस्थ, _شهبا, _räsc, 
   {{0x6d5404e7,0x200004e8,0x6b8c04e9,0xc198008f}},	//   raza, boki_, teag, _משגי, 
   {{0x6d5404ea,0x200004eb,0xfc3000c6,0x7dd00036}},	//   saza, coki_, صحف_, _päsc, 
   {{0x6b8c04ec,0x00000000,0x00000000,0x00000000}},	// [2b0] reag, --, --, --, 
   {{0x601404ed,0x6b8c04ee,0x5928031c,0xe7bc0183}},	//   ráme, seag, _སྔངས_, _আগেয, 
   {{0x7dd004ef,0x764000a2,0x636002e3,0x9f40020c}},	//   _wäsc, _atmy, ịnii, wiké_, 
   {{0x7dd00221,0x9f400066,0x6b8c01d5,0x377404f0}},	//   _täsc, tiké_, qeag, гышс, 
   {{0x2b480276,0xdb040139,0xd9f804af,0x00000000}},	//   mbac_, _xokü, ्तखत_, --, 
   {{0x2a6801b9,0x9f40020c,0x200004f1,0x77a801d9}},	//   mrab_, riké_, zoki_, ٘ێہہ_, 
   {{0x20000296,0x76400083,0x9f4004f2,0x23f40107}},	//   yoki_, _etmy, siké_, кчиё, 
   {{0xa82403e6,0x66640014,0x200000f1,0xe3b0007b}},	//   _شکان, _لُرٕ, xoki_, شرب_, 
   {{0x7dd004f3,0x200004f4,0x2a68006e,0x221404f5}},	//   _läsa, voki_, nrab_, кфор, 
   {{0x20000083,0x25dc00bc,0x00000000,0x00000000}},	//   woki_, कोशी_, --, --, 
   {{0x200004f6,0x7dd004f7,0x2a6804f8,0xb9280055}},	//   toki_, _näsa, hrab_, _byuṅ_, 
   {{0x644004f9,0x25dc04fa,0x23e804fb,0x2a6801a9}},	//   _itli, कोरी_, _غذای_, krab_, 
   {{0x200004fc,0x60140085,0x00000000,0x00000000}},	//   roki_, támb, --, --, 
   {{0x2a6804fd,0x7dd00139,0xd6540375,0xa06800cf}},	//   drab_, _bäsa, כישת_, _жака_, 
   {{0x200004fe,0x7dd004ff,0xa074035b,0x20740500}},	//   poki_, _cäsa, _рылш, _рулё, 
   {{0x60140085,0x22580306,0x6aa80501,0x5f74009f}},	//   sámb, šsku_, _šefa, _شابر, 
   {{0x3ae80502,0x50180302,0x48c0015b,0x2a680503}},	// [2c0] ربری_, _קופו, ্পোর, grab_, 
   {{0x656002b9,0xd9440504,0x18a4036b,0x7dd00139}},	//   _ndlh, тежи, казм, _fäsa, 
   {{0xdb040034,0x64400505,0x2a680506,0x764000b5}},	//   _pokó, _ntli, arab_, _stmy, 
   {{0x656002c4,0x5b1400f7,0x00000000,0x00000000}},	//   _adlh, _үмүт, --, --, 
   {{0x64400507,0x320c0209,0xdb0400e4,0x46b40073}},	//   _atli, yldy_, _vokó, _आपणह, 
   {{0xdb040034,0x00000000,0x00000000,0x00000000}},	//   _wokó, --, --, --, 
   {{0x799c03a2,0x64400010,0x00000000,0x00000000}},	//   _iarw, _ctli, --, --, 
   {{0x656002c4,0x799c0508,0x04dc0055,0x32980120}},	//   _edlh, _harw, _jāṇu, евиќ_, 
   {{0x64400509,0x877800c8,0x7640050a,0x3134050b}},	//   _etli, _קאמי, _utmy, лепр, 
   {{0x799c050c,0x5ec40154,0x00000000,0x00000000}},	//   _jarw, _লেভে, --, --, 
   {{0x799c050d,0xdc8c044e,0x225c000d,0x73c401e0}},	//   _marw, ዝነበረ_, _evwk_, _бәпе, 
   {{0x6d40050e,0x799c050f,0x444401d9,0x64980116}},	//   ılam, _larw, _شرمہ, _ятур_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d840510,0x799c0511,0x7dd002d1,0x64400267}},	//   ýle_, _narw, _päsa, _ytli, 
   {{0xf41400c8,0x00000000,0x00000000,0x00000000}},	//   ָפּ_, --, --, --, 
   {{0x04dc0055,0xdcfc00c0,0x2a6801a9,0x98b80064}},	//   _cāṇu, _lapė, trab_, lapė_, 
   {{0x799c0512,0x2ec4010b,0xdb0401e1,0x00000000}},	// [2d0] _barw, _сөнм, _sokò, --, 
   {{0x6f0c0513,0x799c0514,0xc27802e4,0x2a680515}},	//   _iyac, _carw, ורמי, rrab_, 
   {{0x2d900516,0x48c000bd,0xd2440517,0x60140518}},	//   meze_, ্প্র, _گن_, láma, 
   {{0x2d900519,0x6f0c0083,0x26780276,0x6440051a}},	//   leze_, _kyac, ескэ_, _rtli, 
   {{0x799c051b,0xd244051c,0x6440036b,0x1d88001f}},	//   _farw, _دن_, _stli, _ሕዝቦች_, 
   {{0x799c051d,0x2d90051e,0x6f0c051f,0x7dd00520}},	//   _garw, neze_, _myac, _läsn, 
   {{0xfd500521,0x6b9c0522,0x60140523,0x6d400162}},	//   _aghụ, _kasg, háma, ðlay, 
   {{0x2d900524,0x60140525,0x799c0526,0xe2b80063}},	//   heze_, káma, _zarw, ећој_, 
   {{0x2d900527,0x799c0528,0x6b9c0529,0x6f0c052a}},	//   keze_, _yarw, _masg, _nyac, 
   {{0x2d90052b,0x6b9c052c,0xc0c4001f,0x00000000}},	//   jeze_, _lasg, _ችሏል_, --, 
   {{0x2d90052d,0x6f0c052e,0x00000000,0x00000000}},	//   deze_, _ayac, --, --, 
   {{0xa0a4052f,0x6f0c0530,0xd24c0531,0x44240532}},	//   _ҡалд, _byac, _کنو_, _شراف, 
   {{0xdcb00533,0x6f0c0534,0x2d900535,0x62640536}},	//   ڭىز_, _cyac, feze_, _свла, 
   {{0x2d900537,0x6f0c0538,0x00000000,0x00000000}},	//   geze_, _dyac, --, --, 
   {{0x6b9c0539,0x6f0c053a,0xd00c00aa,0x9f400418}},	//   _basg, _eyac, _ډلو_, likí_, 
   {{0x799c053b,0x6b9c053c,0x69d8053d,0xabd40114}},	//   _sarw, _casg, ëwen, ацуј, 
   {{0x799c053e,0xfeb4053f,0x60140540,0x6b9c0541}},	// [2e0] _parw, _төнь, cáma, _dasg, 
   {{0x799c0542,0x6b9c03d5,0x3c940543,0x62980544}},	//   _qarw, _easg, _پیرز, _mswo, 
   {{0x6b9c0545,0x799c0433,0x47c800f1,0x00000000}},	//   _fasg, _varw, کالۍ_, --, 
   {{0x799c0546,0x6b9c0368,0xb8cc000d,0x62980210}},	//   _warw, _gasg, _कछ_, _oswo, 
   {{0x799c0547,0x62980421,0xa5bc00b8,0xdcfc0153}},	//   _tarw, _nswo, _puųp, _papė, 
   {{0x7dd00030,0x9f8001e1,0xd1d40092,0x00000000}},	//   _mäso, _kóó_, ርቱት_, --, 
   {{0x6b9c0548,0x62980549,0x9484054a,0x00000000}},	//   _yasg, _aswo, уылд, --, 
   {{0x2d90054b,0x88f00050,0x6f080034,0x9f400093}},	//   zeze_, _آفت, żeci, fikí_, 
   {{0x2d90054c,0x1544054d,0x7dd0007c,0x57a401af}},	//   yeze_, _безм, _näso, _ишҡа, 
   {{0x6f0c0230,0x2d90054e,0x60140113,0xfa740023}},	//   _ryac, xeze_, váma, እሰናይ_, 
   {{0x6298007f,0x6f0c04ce,0xc68c0014,0xe4740006}},	//   _eswo, _syac, _وِہ_, _вучэ, 
   {{0x2d90054f,0x8f4402d5,0xb4c00550,0xdb0401e1}},	//   weze_, ыход, ँही_, _onkà, 
   {{0x7dd0007c,0x00000000,0x00000000,0x00000000}},	//   _väsn, --, --, --, 
   {{0x6f0c0551,0x6aa80552,0x60140553,0x6b9c0554}},	//   _vyac, _šefo, ráma, _sasg, 
   {{0x6b9c0555,0x80a00214,0xac940556,0x601400e4}},	//   _pasg, _همون, шавш, sáma, 
   {{0x2d900557,0x672c0558,0x6b9c0455,0x7dd001f4}},	//   seze_, žaji, _qasg, _häsl, 
   {{0xeb980559,0x2d90055a,0x6b9c0151,0x63bc049f}},	// [2f0] ниң_, peze_, _vasg, ösni, 
   {{0x6b9c055b,0xddc40064,0x00000000,0x00000000}},	//   _wasg, pukš, --, --, 
   {{0x6b9c055c,0x7dd0008e,0x00000000,0x00000000}},	//   _tasg, _mäsl, --, --, 
   {{0x6b9c007b,0x7dd001e3,0x61540092,0x00000000}},	//   _uasg, _läsl, መቤታች, --, 
   {{0x200c013f,0x9f800241,0x00000000,0x00000000}},	//   _ɔfi_, _kóò_, --, --, 
   {{0xe4c4055d,0xe5a404a9,0x7dd0055e,0x855400f2}},	//   ийли, рики, _näsl, ایار_, 
   {{0x23d4055f,0xdb0400dd,0xd854010b,0x69d400de}},	//   ицир, _inká, _весө, _ilze, 
   {{0x62640560,0xea0001dc,0x57b00220,0x9f400561}},	//   авиа, _đẹp_, _мұхт, tikí_, 
   {{0x7dd00209,0x766800f1,0x00000000,0x00000000}},	//   _bäsl, _مینې_, --, --, 
   {{0x5bd000dc,0xd1c4030d,0xa3d80562,0x1b000154}},	//   _सत्व, илые_, डोज_, লেকে_, 
   {{0x7dd004f3,0xa0680563,0xdb0c03b2,0x00000000}},	//   _säso, ъана_, ádúg, --, 
   {{0x62980564,0x6fcc002d,0x5438008f,0x69d4002f}},	//   _tswo, _jûch, _סענא, _llze, 
   {{0x442c0196,0x733400cf,0xdde801d5,0x3344013d}},	//   _iig_, _ارمئ, نرسه_, _уҗым_, 
   {{0x442c0565,0xdb0401b8,0x5c9002d3,0x1c4401b9}},	//   _hig_, _kokö, _ምልክታ_, ингм, 
   {{0x442c0566,0x3f8400c5,0xe0d001d9,0x1d080567}},	//   _kig_, õmus_, _گٲں_, теви_, 
   {{0x69d40568,0x442c0569,0xdb040124,0x6014056a}},	//   _alze, _jig_, _mokö, mámo, 
   {{0x442c056b,0x3d1c0241,0xdcfc00b8,0x4a4000d8}},	// [300] _mig_, _báwí_, _kapī, жнув, 
   {{0x442c056c,0x26dc0099,0x9c580116,0x7dd00037}},	//   _lig_, dzwo_, _ишму_, _käsm, 
   {{0x6fcc056d,0x60140077,0x8f500150,0x442c056e}},	//   _bûch, námo, _انۋش, _oig_, 
   {{0x442c056f,0xcc38008f,0x7dd00139,0x1b0000cc}},	//   _nig_, _שעכט, _mäsm, লেগে_, 
   {{0x9f800570,0x2d840137,0x00000000,0x00000000}},	//   _yóò_, òleg_, --, --, 
   {{0x442c0571,0x7c2403be,0x98a40572,0xf43401a9}},	//   _aig_, lmir, _киге, бекэ, 
   {{0x442c0573,0x2bdc0574,0x39580575,0x7dd0007c}},	//   _big_, नोका, _iers_, _näsm, 
   {{0x442c0576,0x93880577,0x6fcc002d,0x6014056a}},	//   _cig_, тска_, _gûch, dámo, 
   {{0x442c0578,0x3c3c0579,0x7c24057a,0x3958057b}},	//   _dig_, _lív_, imir, _kers_, 
   {{0x442c057c,0x7c24057d,0x8678011a,0x00000000}},	//   _eig_, hmir, _ברמו, --, 
   {{0x3958057e,0x442c0302,0x321c0109,0x6014057f}},	//   _mers_, _fig_, _vhvy_, gámo, 
   {{0x3958004e,0x6e940580,0x15e00456,0x00000000}},	//   _lers_, биму, कोरर_, --, 
   {{0x7c240581,0x39580582,0xd24c0583,0x7dd00166}},	//   dmir, _oers_, _کنڈ_, _täsl, 
   {{0x442c0584,0x39580585,0x60140005,0x5ec4009e}},	//   _zig_, _ners_, bámo, _লেহে, 
   {{0x442c0586,0x60140587,0xf04404fb,0xdb040588}},	//   _yig_, cámo, _اعتی, _mokõ, 
   {{0x7c240522,0x9f400589,0x442c058a,0x69d402f0}},	//   gmir, rikã_, _xig_, _slze, 
   {{0x3958058b,0x8d84058c,0x69d4058d,0x6fcc045f}},	// [310] _bers_, _кунд, _plze, _rûch, 
   {{0xc6680020,0x3958058e,0x6fcc000f,0x6d98023a}},	//   _አፍሪካ_, _cers_, _sûch, _своё_, 
   {{0x3958058f,0x9f400590,0x7c240200,0x00000000}},	//   _ders_, liká_, bmir, --, 
   {{0x39580591,0x7c240276,0xe7180592,0x26dc0036}},	//   _eers_, cmir, هيات_, tzwo_, 
   {{0x39580593,0x2b580048,0xe6880594,0x9f400122}},	//   _fers_, _iesc_, انتى_, niká_, 
   {{0x442c0595,0x39580596,0x9f8001a8,0xe7740139}},	//   _sig_, _gers_, _lóð_, kıçı, 
   {{0xe3b00597,0x6014056a,0xd90c0451,0x98a8025c}},	//   كرة_, xámo, _ٻڌل_, _rebħ_, 
   {{0x7dd00598,0x442c01d4,0x86e4036b,0x60140599}},	//   _räsm, _qig_, _кўзд, vámo, 
   {{0x36d4059a,0x2b58059b,0xdcfc005f,0x07500131}},	//   _дотр, _mesc_, _papī, _ﺋﻪﯓ_, 
   {{0x7c24005f,0x9f4000d7,0x6014059c,0x00000000}},	//   zmir, diká_, támo, --, 
   {{0x442c059d,0x6514059e,0x291000a2,0x21a4059f}},	//   _tig_, _اوائ, _jyza_, _ҳилм, 
   {{0x601405a0,0x42b000aa,0x672c05a1,0x442c00a3}},	//   rámo, _ولاړ, žaju, _uig_, 
   {{0x53980302,0x60140005,0x02c005a2,0xe1f00150}},	//   _תינו, sámo, _филү, _ىست_, 
   {{0x2b58030a,0x32b800c6,0xdb04035b,0x7dd0023a}},	//   _aesc_, _خدمة_, _mokô, _täsm, 
   {{0x7c2405a3,0x98b802b1,0x714000cf,0x91b8011a}},	//   tmir, rapī_, _تۉپۅ, _תמצי, 
   {{0x9f8005a4,0x395805a5,0x2b5805a6,0x7dd005a7}},	//   _góð_, _sers_, _cesc_, _käsk, 
   {{0x2b5805a8,0xeb5405a9,0x00000000,0x00000000}},	// [320] _desc_, زىلگ, --, --, 
   {{0x7dd00598,0x2b580327,0x7e6400e4,0x2488033f}},	//   _mäsk, _eesc_, _ivip, łamy_, 
   {{0x395805aa,0x2b5805ab,0x7dd00520,0x00000000}},	//   _vers_, _fesc_, _läsk, --, 
   {{0x7e6405ac,0x3958015d,0x29100432,0x00000000}},	//   _kvip, _wers_, _dyza_, --, 
   {{0x395805ad,0xada805ae,0xe77400ac,0xdb040124}},	//   _ters_, _صدیق_, zıçı, _pokõ, 
   {{0x05140055,0x6ca405af,0x00000000,0x00000000}},	//   _hūṃp, _اصیل, --, --, 
   {{0x66d001d3,0x2910010b,0x9f4000d0,0x7f44036e}},	//   tókö, _gyza_, ziká_, _ofiq, 
   {{0x2b58004e,0x544400db,0x00000000,0x00000000}},	//   _xesc_, _ۇنئك, --, --, 
   {{0x9f800174,0x6b880139,0x00000000,0x00000000}},	//   _róð_, _öege, --, --, 
   {{0x104805b0,0x7f4405b1,0x6aa801fa,0x168403e6}},	//   лями_, _afiq, _šefk, _ناڕێ, 
   {{0x7e6400cd,0x672c0010,0x49b800df,0x00000000}},	//   _avip, žajt, אמיס, --, 
   {{0x942405b2,0x9f4000d0,0xb4d405b3,0x82900137}},	//   _умее, tiká_, हनी_, تۇۇچ, 
   {{0x7e640055,0x7dd00166,0x4ed400eb,0x00000000}},	//   _cvip, _gäsk, সপ্ল, --, 
   {{0x7e6405b4,0x604002e3,0x2b580120,0xf53801e4}},	//   _dvip, _ịmep, _sesc_, _maĥo_, 
   {{0xad240075,0x25dc05b5,0x7e64003a,0x7dd00139}},	//   زىرى, कोटी_, _evip, _mäsh, 
   {{0xdb040036,0x1b00015b,0x7dd0007c,0x291005b6}},	//   _onkä, লেছে_, _läsh, _ryza_, 
   {{0x2b58004e,0xb4d400bc,0x00000000,0x00000000}},	// [330] _vesc_, हनु_, --, --, 
   {{0x2ba805b7,0x7dd0007c,0x00000000,0x00000000}},	//   _चोरा, _näsh, --, --, 
   {{0xa8980220,0x8a74016c,0x7e6405b8,0x6d4402d0}},	//   ркеу_, риҷӣ_, _zvip, _ifha, 
   {{0x61c405b9,0xc95401e0,0x7e640022,0x7f440477}},	//   _लक्ष, ртҡы, _yvip, _xfiq, 
   {{0x25ec05ba,0x00000000,0x00000000,0x00000000}},	//   _अगदी_, --, --, --, 
   {{0x3e5c008f,0xd65c030d,0x00000000,0x00000000}},	//   נדוס, _гiод, --, --, 
   {{0x290405bb,0x67d405bc,0xdb0401e6,0x6d4401ab}},	//   _âla_, _дову, _enkä, _mfha, 
   {{0x666401d9,0xb76400fb,0xf41c00fe,0x00000000}},	//   _وُزٕ, _нтуй, _পূবৰ_, --, 
   {{0x6d4401c7,0x622400d1,0x0584014b,0x00000000}},	//   _ofha, يىبل, _гуем, --, 
   {{0xd24c05bd,0x7dd0049f,0x672c05be,0x7f44031c}},	//   کنی_, _väsk, žajs, _sfiq, 
   {{0x7e64008c,0x8c400209,0x00000000,0x00000000}},	//   _svip, üşle, --, --, 
   {{0x6d4405bf,0x2464005f,0x1e0005c0,0x9ea805c1}},	//   _afha, mēm_, लक्ष_, авма_, 
   {{0x6d4403d5,0x630405c2,0x7dd00209,0x2464005f}},	//   _bfha, _بوشل, _häsi, lēm_, 
   {{0x7dd005c3,0x224c05c4,0x25dc03e5,0xd1380139}},	//   _käsi, mpek_, कोची_, _taƅa_, 
   {{0x8c4005c5,0x224c0209,0x2464005f,0x7a300241}},	//   десе, lpek_, nēm_, _lótì, 
   {{0xb06805c6,0x224c05c7,0x7dd000d0,0xe4f0000d}},	//   _اصول_, opek_, _mäsi, _अइनि_, 
   {{0x19c405c8,0x224c009b,0x9a6800c6,0x7dd0007c}},	// [340] обам, npek_, شمال_, _läsi, 
   {{0x3ea005c9,0x00000000,0x00000000,0x00000000}},	//   _isit_, --, --, --, 
   {{0x7dd005ca,0x9f0401b9,0xd7c40108,0x6d400205}},	//   _näsi, _دوکو, жёло, ılat, 
   {{0x224c05cb,0x2464005f,0x3ea00010,0x76440022}},	//   kpek_, dēm_, _ksit_, зҭаа, 
   {{0xd5b805cc,0x07a00022,0x9f400432,0x00000000}},	//   иск_, ьацн, mikä_, --, 
   {{0x7dd000a2,0x9f40008e,0x00000000,0x00000000}},	//   _bäsi, likä_, --, --, 
   {{0xb4d405cd,0x25f001ad,0x00000000,0x00000000}},	//   हने_, ेवजी_, --, --, 
   {{0x7dd0014a,0x6aa805ce,0x98b80006,0xb9e40092}},	//   _däsi, _šefi, lapį_, _ኩሽ_, 
   {{0x73c401e0,0x7e600356,0xfbe80051,0x00000000}},	//   жәһе, âmpl, _đế_, --, 
   {{0x3f8005cf,0xd4680276,0x7dd00139,0xcb1005d0}},	//   _aciu_, _виже_, _fäsi, ולח_, 
   {{0x2464005f,0x3ea005d1,0x629c005c,0x00000000}},	//   cēm_, _asit_, æsor, --, 
   {{0x8c4005d2,0x601400ae,0x00000000,0x00000000}},	//   üşme, námh, --, --, 
   {{0x7dd001b8,0x00000000,0x00000000,0x00000000}},	//   _zäsi, --, --, --, 
   {{0x68e00254,0x821005d3,0x7dd00139,0x00000000}},	//   _üldg, _قونص, _yäsi, --, 
   {{0xfd1005d4,0x3ea005d5,0x320c05d6,0x101400c6}},	//   نجف_, _esit_, mody_, _وبعد, 
   {{0x80d405d7,0x320c05d8,0xb17c01e4,0x9e6401d3}},	//   मनरे, lody_, riĥu, _کاٹن, 
   {{0x2464005f,0x320c002d,0xfb8400c7,0x00000000}},	// [350] zēm_, oody_, ьырн, --, 
   {{0x7dc405d9,0x320c05da,0x48a80139,0xa9c000db}},	//   _يقين, nody_, итем_, رۅزۉ, 
   {{0x2d8005db,0x0ffc05dc,0x9f40013d,0x00000000}},	//   _iche_, _उदाश_, bikä_, --, 
   {{0x320c05dd,0xdec002d3,0x246400e2,0x7dd005de}},	//   hody_, _ኻልእ_, vēm_, _räsi, 
   {{0x320c033f,0x9bb8011a,0x00000000,0x00000000}},	//   kody_, _הצרפ, --, --, 
   {{0x64a405df,0x246400da,0x0dc40023,0x858801a9}},	//   зака, tēm_, _ጽሓፊ_, рёда_, 
   {{0x2d8001f7,0xd5ac05e0,0x00000000,0x00000000}},	//   _mche_, طفي_, --, --, 
   {{0x3cfc05e1,0xe3b805e2,0x7dd005e3,0x2fc805e4}},	//   ילונ, сби_, _väsi, _noag_, 
   {{0x27ec05e5,0xd24c05e6,0x320c0170,0x2d800521}},	//   _imen_, هني_, fody_, _oche_, 
   {{0x7dd00209,0x2d800521,0x320c0034,0x3f80010f}},	//   _täsi, _nche_, gody_, _sciu_, 
   {{0x224c05e7,0x601405e8,0x2fc801c3,0xe04405e9}},	//   spek_, lámi, _boag_, янни, 
   {{0x2fc80005,0xd8d40375,0x224c05ea,0x25a40375}},	//   _coag_, פורט_, ppek_, _hall_, 
   {{0x320c05eb,0x25a405ec,0x27ec007f,0x02a40276}},	//   body_, _kall_, _mmen_, _фрем, 
   {{0x21a405ed,0x25a405ee,0x7dd00267,0x2d8005ef}},	//   _хикм, _jall_, _läsv, _cche_, 
   {{0x27ec05f0,0x25a4011a,0x91b8011a,0x712400cf}},	//   _omen_, _mall_, _למסי, _ۉرۉل, 
   {{0x2d8000b4,0x27ec0280,0x9e6405f1,0x3ea005f2}},	//   _eche_, _nmen_, _евид, _tsit_, 
   {{0x6d4005f3,0x3ea005f4,0x8f78011a,0x9b4400db}},	// [360] ılar, _usit_, _הנפק, _ۉندو, 
   {{0x0b4005f5,0x25a40192,0x27ec05f6,0xd7e801e0}},	//   _үнэн, _nall_, _amen_, әмде_, 
   {{0x18340345,0x9b4400db,0x00000000,0x00000000}},	//   سراح, _ىندو, --, --, 
   {{0x291c0198,0x6ac805f7,0x25a40042,0x779405f8}},	//   ƙwan_, ðsfó, _aall_, بیرا, 
   {{0xb4e405f9,0x25a405fa,0x601401e7,0x00000000}},	//   _पेड़_, _ball_, rámh, --, 
   {{0x25a405fb,0x2d800395,0x60780020,0x7ae405fc}},	//   _call_, _xche_, _በሰጡት_, mzit, 
   {{0x25a405fd,0x320c031d,0x7ae405fe,0x6fdc00e1}},	//   _dall_, vody_, lzit, _पतलू, 
   {{0x2ca4022c,0x320c05ff,0x07a00600,0xc7a00601}},	//   ældi_, wody_, _пасн, _писк, 
   {{0x7ae40602,0x320c0603,0x25a40604,0x2fc801ab}},	//   nzit, tody_, _fall_, _roag_, 
   {{0x20100605,0x7dd000c5,0x27ec0606,0x7ae40165}},	//   _akyi_, _käsu, _zmen_, izit, 
   {{0x2fc80607,0x93140608,0x320c0609,0xc1b401c0}},	//   _poag_, _کوشش, rody_, члэх_, 
   {{0x2d80060a,0x25a4060b,0x14240139,0x27ec0208}},	//   _sche_, _zall_, _эдем, _xmen_, 
   {{0xe80c060c,0xb8d8031c,0x7ae401f5,0x320c0072}},	//   िकता_, _ྙན_, jzit, pody_, 
   {{0x2010016b,0x7ae4060d,0x00000000,0x00000000}},	//   _ekyi_, dzit, --, --, 
   {{0x622400f7,0x104801b9,0x7dd0007c,0x7ae4002f}},	//   _تووە, _уяли_, _näsu, ezit, 
   {{0x7bc40200,0x00000000,0x00000000,0x00000000}},	//   gjiu, --, --, --, 
   {{0x25ec060e,0x2d80060f,0xfd100583,0x00000000}},	// [370] _अगली_, _tche_, نجہ_, --, 
   {{0x2d8000b4,0xab90001f,0x00000000,0x00000000}},	//   _uche_, ዝበዋል_, --, --, 
   {{0x7ae40083,0x25a4030a,0x6d540165,0x00000000}},	//   azit, _rall_, mbza, --, 
   {{0x25a40610,0x60140077,0xa64c0023,0x7ae40327}},	//   _sall_, támi, _ዝተወደ, bzit, 
   {{0xf7700611,0xe5a40612,0x25a40613,0x6b8c0614}},	//   طان_, дили, _pall_, mfag, 
   {{0x60140615,0xf6500616,0xd6cc0617,0x2f240618}},	//   rámi, ائن_, شقى_, _gūgū_, 
   {{0x25a40619,0x27ec0263,0x6b8c0421,0x6aac061a}},	//   _vall_, _tmen_, ofag, lvaf, 
   {{0x7dd0061b,0x27ec061c,0x25a4061d,0x21280115}},	//   _häst, _umen_, _wall_, _ŝaho_, 
   {{0x6448061e,0x6b8c0607,0x7dd0061f,0x25a4011a}},	//   _žlič, ifag, _käst, _tall_, 
   {{0x69c40620,0x7dd00621,0xc5f8007b,0xbb840150}},	//   njhe, _jäst, _اعرض_, _ﺩﻋﻤﻪ_, 
   {{0x7ae40622,0x7dd0049f,0x6b8c0623,0xf62800d4}},	//   zzit, _mäst, kfag, _хіти_, 
   {{0x7dd00624,0x5ec400bd,0x27fc0368,0xc10000d1}},	//   _läst, _লেগে, nnwn_, _җүмл, 
   {{0x21680625,0xdf000083,0x6b8c0626,0x71f80014}},	//   _дили_, kuŋŋ_, dfag, _کرنس_, 
   {{0x63a80627,0x7dd00628,0x6aac022e,0x00000000}},	//   lden, _näst, dvaf, --, 
   {{0x62880629,0xf1a803e6,0x6b8c062a,0xb0680592}},	//   lteo, _راوه_, ffag, _فصيل_, 
   {{0x7ae401c0,0x7dd00139,0x00000000,0x00000000}},	//   tzit, _räsu, --, --, 
   {{0x7dd00628,0x6288062b,0x7ae401c8,0xda640592}},	// [380] _bäst, nteo, uzit, بازي, 
   {{0x63a802f6,0x22580122,0x628800c6,0x6b8c062c}},	//   hden, ásky_, iteo, afag, 
   {{0x63a8062d,0x7ae401d3,0x6288062e,0x00000000}},	//   kden, szit, hteo, --, 
   {{0x63a8062f,0xca7402d3,0xdb040200,0x225800d7}},	//   jden, _ኢልኩም_, _jakë, šsky_, 
   {{0x7dd0049f,0x63a80630,0x1dd00037,0x00000000}},	//   _fäst, dden, _हवात, --, 
   {{0x7dd00631,0x63a80632,0xdb040200,0x74140633}},	//   _gäst, eden, _lakë, کوبا, 
   {{0x7dd00634,0x63a801f5,0x2874010b,0x34940635}},	//   _häss, fden, _пытр, хайр, 
   {{0x63a80226,0xb9e8044e,0xdef4001f,0xb6c80014}},	//   gden, _ኮም_, ፉልን_, _ٹارے_, 
   {{0x3a380636,0x6288017a,0x6aa8032e,0x826001c8}},	//   _kirp_, gteo, _áeft, نهين, 
   {{0x7dd00637,0x63a80638,0x764002d0,0x80a40154}},	//   _mäss, aden, _iumy, গমন্, 
   {{0x7dd00639,0x63a8063a,0xc054063b,0x7760025c}},	//   _läss, bden, мія_, _kemx, 
   {{0xdb040200,0x6aac0162,0x95980092,0x63a80139}},	//   _cakë, yvaf, ፊዎችን_, cden, 
   {{0x6288063c,0x7dd0063d,0x6b8c05ac,0x68e4003e}},	//   cteo, _näss, vfag, zzhd, 
   {{0x7640063e,0x6014003a,0xfe24009d,0x00000000}},	//   _mumy, dámu, вьсн, --, 
   {{0x3b4c063f,0x7640007f,0xab940640,0x7dd00641}},	//   _ọdịk, _lumy, нављ, _räst, 
   {{0xdb0400f2,0x2ba80642,0x7dd00112,0x00000000}},	//   _kakè, _चोखा, _bäss, --, 
   {{0x7dd00643,0x69c40644,0x76400153,0x0dc800f3}},	// [390] _päst, tjhe, _numy, _дуни_, 
   {{0x6b8c0645,0x63a80646,0xdb240647,0xdb0402e2}},	//   sfag, zden, رولی, _makè, 
   {{0x7dd004f3,0x7760009a,0x63a80648,0x61ec0649}},	//   _väst, _bemx, yden, _ïale, 
   {{0x5ec4045e,0x7640064a,0x7dd00065,0x2ca4022c}},	//   _লেটে, _bumy, _fäss, ældu_, 
   {{0x7dd0064b,0x389000e2,0x6014003a,0xf4140154}},	//   _täst, vērš_, cámu, াগার_, 
   {{0xd124064c,0x3a38062c,0x00000000,0x00000000}},	//   _مم_, _girp_, --, --, 
   {{0x63a800a2,0x23d4064d,0x2a68030a,0x7dd0013d}},	//   tden, ецпр, lsab_, _käsr, 
   {{0x63a803bd,0x33f4064e,0x60140419,0x00000000}},	//   uden, кчыс, námt, --, 
   {{0x2a68064f,0x7dd00139,0x76400064,0xe2980120}},	//   nsab_, _mäsr, _gumy, чап_, 
   {{0x62880650,0xdb040100,0x21a401c0,0x00000000}},	//   rteo, _dakè, хиом, --, 
   {{0x62880651,0x63a80652,0xdb0402d3,0x764000ca}},	//   steo, pden, _pakë, _zumy, 
   {{0x64400653,0x65600654,0x2a6800af,0x63a80007}},	//   _iuli, _helh, ksab_, qden, 
   {{0x64400655,0x65600656,0x201c00da,0x2a680218}},	//   _huli, _kelh, ēti_, jsab_, 
   {{0x3f84003d,0x7dd000fd,0xdca40657,0x6560062c}},	//   żmu_, _räss, наги, _jelh, 
   {{0x65600658,0x64400659,0xdb040200,0x00000000}},	//   _melh, _juli, _takë, --, 
   {{0x6440065a,0x3a38065b,0xdb04065c,0x6560065d}},	//   _muli, _sirp_, _haké, _lelh, 
   {{0x6440065e,0xdb040066,0x9b0401e0,0x89d4065f}},	// [3a0] _luli, _kaké, хзад, کولر_, 
   {{0xdb040316,0x64400660,0x7dd001e3,0x76400661}},	//   _jaké, _ouli, _väss, _rumy, 
   {{0x64400662,0xdb040663,0x2ca400b5,0xbc740150}},	//   _nuli, _maké, ældt_, _جۇزب, 
   {{0x7dd00664,0x2a680218,0x3a380309,0x2b480665}},	//   _täss, bsab_, _wirp_, ccac_, 
   {{0x64400666,0x65600667,0x00000000,0x00000000}},	//   _auli, _belh, --, --, 
   {{0x64400668,0xdb040669,0xf484030f,0x99140006}},	//   _buli, _rakè, نابی, _зьбі, 
   {{0x65600652,0x6014066a,0xdb040214,0x6aa802d2}},	//   _delh, náms, _sakè, _áefr, 
   {{0x6440066b,0x7640014a,0xdb0402bd,0x6560066c}},	//   _duli, _tumy, _pakè, _eelh, 
   {{0x6560066d,0x6440066e,0x8a100014,0x5184066f}},	//   _felh, _euli, _شِہت, нуна, 
   {{0x64400670,0x65600671,0x8e700672,0x82300133}},	//   _fuli, _gelh, ққош, ێریا, 
   {{0x91a4063f,0xdb04020c,0xa64c0023,0xfbe000cd}},	//   _atọ_, _daké, _ዝተዓደ, नसाम, 
   {{0x04d80302,0xdb040066,0x656001a4,0x7de401ec}},	//   _מקבל, _takè, _zelh, ңірд, 
   {{0x64400673,0xa3d4033d,0xbed8030d,0x9f4001f4}},	//   _zuli, _सकत_, едях_, ynkö_, 
   {{0x2d840674,0x00000000,0x00000000,0x00000000}},	//   üle_, --, --, --, 
   {{0x64400675,0xd12c0014,0xac180676,0x02140677}},	//   _xuli, _دۅد_, дову_, _רחום_, 
   {{0xfba80678,0x00000000,0x00000000,0x00000000}},	//   нтуй_, --, --, --, 
   {{0x2b480113,0xdec000c7,0x2a680100,0x00000000}},	// [3b0] rcac_, _кәро, usab_, --, 
   {{0xc8640679,0x5e140022,0x2b4801e4,0x2a680205}},	//   етди, _изыӡ, scac_, rsab_, 
   {{0xd364067a,0x2a68067b,0x6560067c,0x6b7405a2}},	//   _په_, ssab_, _relh, _илну, 
   {{0xed78067d,0x6560067e,0x6440067f,0x2a680254}},	//   _እምበር_, _selh, _ruli, psab_, 
   {{0x64400680,0x65600681,0xd2440682,0x7dd00254}},	//   _suli, _pelh, _خن_, _käsp, 
   {{0x65600455,0xe894035b,0x7dd001f4,0x00000000}},	//   _qelh, _иагь, _jäsp, --, 
   {{0x65600683,0xdb040684,0x64400685,0x2eb802f5}},	//   _velh, _raké, _quli, ুনিষ, 
   {{0x64400686,0xdb040687,0x7dd00267,0x65600688}},	//   _vuli, _saké, _läsp, _welh, 
   {{0x9f40044e,0x65600689,0xdb04068a,0x6440068b}},	//   shkë_, _telh, _paké, _wuli, 
   {{0x6560068c,0x7dd0007c,0xc1000166,0x00000000}},	//   _uelh, _näsp, лүлл, --, 
   {{0x6440068d,0x00000000,0x00000000,0x00000000}},	//   _uuli, --, --, --, 
   {{0x2258068e,0x00000000,0x00000000,0x00000000}},	//   _жиды_, --, --, --, 
   {{0x3f8c068f,0xdb0401f1,0x2d90017a,0x73c4007b}},	//   ędu_, _také, ffze_, _حينم, 
   {{0xd24c0690,0xa0c40691,0x00e001d3,0xe9f800e4}},	//   _بنو_, _ليتو, _متعی, tvẽ_, 
   {{0xa0a40692,0xa3d4033f,0xdcb000d1,0x6aa800de}},	//   _райд, _सका_, جىز_, _šefp, 
   {{0xd00c0693,0x8d740014,0x00000000,0x00000000}},	//   _ولو_, _یاپا, --, --, 
   {{0x9f440694,0xd9440695,0xdb200205,0x00000000}},	// [3c0] _ñoñ_, вези, _ütüy, --, 
   {{0x1c440696,0xc0f40023,0x7dd001e3,0xdcec0205}},	//   _ином, _ዋላስ_, _gäsp, şkıs, 
   {{0x1d080697,0x8dd8011a,0x6cb801af,0x00000000}},	//   _цени_, _חקיק, _зыяр_, --, 
   {{0x6298002d,0x200004ce,0x00000000,0x00000000}},	//   _opwo, nnki_, --, --, 
   {{0x68e00037,0x4cd40011,0xc62005ac,0x20000698}},	//   _üldn, _ডেপু, _পঢ়া_, inki_, 
   {{0xd9440063,0x00000000,0x00000000,0x00000000}},	//   _јеви, --, --, --, 
   {{0x62980699,0xbf000034,0x0460069a,0x44a0069b}},	//   _apwo, ैथुन_, атым, لموق, 
   {{0xc0d4069c,0x601400e5,0x71740066,0x00000000}},	//   ኮነስ_, zámr, گهدا, --, 
   {{0xdb0400d2,0xd20805f5,0x6f08033f,0x8c1804ae}},	//   _inkó, дэнд_, żecz, ווקי, 
   {{0xb9cc0023,0xba08069d,0x14c800c7,0xc0540092}},	//   _ዳአ_, _ፋና_, _ҭыҧи_, _የተቸገ, 
   {{0x6298069e,0xdb0403fa,0x066c0131,0x00000000}},	//   _epwo, _ankü, ﭽﯩﻠﯩ, --, 
   {{0xb4c0069f,0x543406a0,0x00000000,0x00000000}},	//   ुही_, _شرار, --, --, 
   {{0xf19406a1,0xd33402d5,0x00000000,0x00000000}},	//   _биль, _рэжы, --, --, 
   {{0x200006a2,0x33780150,0x00000000,0x00000000}},	//   anki_, _ﭼﻴﻠﻲ_, --, --, 
   {{0x61ec06a3,0x709406a4,0x9f400118,0xd7e001f9}},	//   _ïala, _сайф, liký_, पसाच, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3b6402e8,0x7b640354,0xeb980209,0x7c340150}},	// [3d0] ръсв, ртсе, миң_, ретх, 
   {{0x601406a5,0x00000000,0x00000000,0x00000000}},	//   lámp, --, --, --, 
   {{0xdd900014,0x00000000,0x00000000,0x00000000}},	//   _اوپ_, --, --, --, 
   {{0xba2800d1,0xc7b801f4,0x00000000,0x00000000}},	//   ىسەم_, ьёз_, --, --, 
   {{0x3a7406a6,0xd1c40023,0xa5f80107,0x00000000}},	//   _кляр, ሽሓት_, неду_, --, 
   {{0x28f8035b,0xa82403e6,0xf6500244,0x16a406a7}},	//   _зегь_, _ڵکان, زئه_, увши_, 
   {{0x20000034,0x62980076,0x478806a8,0x02d800dc}},	//   ynki_, _spwo, _осам_, यन्न, 
   {{0x3d3c06a9,0x778400db,0xe284011c,0xf77006aa}},	//   וגוס, _ەجەك, глии, _واق_, 
   {{0xba080020,0x23c406ab,0x614406ac,0x21680116}},	//   _ገቢ_, वाबद, лепа, нипи_, 
   {{0x85b806ad,0xa3b40220,0xa1c400d8,0x00000000}},	//   _تارس_, _әбді, убод, --, 
   {{0x20d40046,0xf4840006,0x00000000,0x00000000}},	//   уіпс, _вучн, --, --, 
   {{0xb2240137,0xd24c05a9,0x00000000,0x00000000}},	//   лмөл, زچۇ_, --, --, 
   {{0xf1a803e6,0xe29806ae,0x2000012d,0x91e000cc}},	//   رایه_, _чал_, rnki_, _পদৰ্, 
   {{0x200001fa,0x326400d1,0xdb1c06af,0x00000000}},	//   snki_, _өтәв, _éxéc, --, 
   {{0xa07400c7,0x597401ec,0x00000000,0x00000000}},	//   _сылш, ғызу, --, --, 
   {{0x1d08010b,0x307406b0,0x00000000,0x00000000}},	//   _җеми_, _тушс, --, --, 
   {{0xdb04033b,0x8f980677,0x00000000,0x00000000}},	// [3e0] _ankò, _טיקי, --, --, 
   {{0x2f1c01d3,0x80a4000d,0x00000000,0x00000000}},	//   ságú_, _औनाइ, --, --, 
   {{0x68e00037,0x00000000,0x00000000,0x00000000}},	//   _üldl, --, --, --, 
   {{0xd708034b,0x80a806b1,0x00000000,0x00000000}},	//   ннее_, _जनने, --, --, 
   {{0xdb0402e2,0xcc3800c8,0x00000000,0x00000000}},	//   _enkò, _רעכט, --, --, 
   {{0xe9380131,0x94a800c7,0x394c03e0,0x0f3400df}},	//   رسەت_, етиа_, _üds_, ארנט_, 
   {{0x24640022,0x00000000,0x00000000,0x00000000}},	//   ахыҳ, --, --, --, 
   {{0xb27406b2,0xedd00316,0x752400bc,0x27b400d8}},	//   алиш, _सक्छ, řizo, _кљус, 
   {{0xd620030d,0x00000000,0x00000000,0x00000000}},	//   _дiаа, --, --, --, 
   {{0xb6a406b3,0xbbe000bc,0x00000000,0x00000000}},	//   _йиғл, नसुक, --, --, 
   {{0x50640220,0x335400db,0x70940107,0x569400fb}},	//   ытпа, _күйө_, шанф, _шаҡт, 
   {{0x7528005f,0x9f4001d3,0x8934010f,0x6fd401f9}},	//   _izdz, dikó_, טריע_, _ढवळू, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc330010f,0x0d9001d3,0x0dc806b4,0x00000000}},	//   _פוס_, حیدح, хуми_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xeeb806b5,0x00000000,0x00000000,0x00000000}},	//   _алиш_, --, --, --, 
   {{0xf33002d3,0xab3801ec,0x9fb40055,0x00000000}},	// [3f0] _ብትብዓ, тпау_, cāñ_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3d4033d,0xf98806b6,0x290401ef,0x00000000}},	//   _सकल_, انمي_, _žlab_, --, 
   {{0x68e00037,0x00000000,0x00000000,0x00000000}},	//   _üldm, --, --, --, 
   {{0xe61006b7,0xa6340212,0x872801d5,0x00000000}},	//   يشت_, анді, хўжа_, --, 
   {{0xdb0406b8,0xd1dc0020,0x1d680092,0x8934009f}},	//   _fakâ, ንበብ_, ቲስቶች_, _معزا, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe298013e,0x6d4006b9,0xe8e00490,0xe3b8014b}},	//   ваи_, ılay, पनीच, тби_, 
   {{0xdb040109,0x7cc406ba,0xf65000db,0x00000000}},	//   _zakâ, ﺯﻣﯘﻧ, _فئل_, --, 
   {{0x846406bb,0xdb0400e4,0x6728005f,0xe80c012c}},	//   _бъде, _hakã, _izej, िकका_, 
   {{0x23c406bc,0x3494010b,0xe10806bd,0x6f0c06be}},	//   वादद, _гахр, тенд_, _axac, 
   {{0x229406bf,0xa27806c0,0x442406c1,0x00000000}},	//   _видя, _абду_, _صراف, --, 
   {{0x61ec03a2,0xe1f006c2,0x2ec000c7,0x00000000}},	//   _ïalo, _وست_, зҩым, --, 
   {{0x5f7406c3,0xf274009f,0x00000000,0x00000000}},	//   داگر, _اَوھ, --, --, 
   {{0xdca406c4,0xd00c00ec,0x30b401e2,0x00000000}},	//   шави, _ڪلي_, _هلوځ, --, 
   {{0x3cec0208,0xd12c06c5,0x00000000,0x00000000}},	//   _đkvđ_, _غمي_, --, --, 
  
   {{0x68e000c5,0xdb0406c6,0xd00c06c7,0x00000000}},	// [400] _üldj, _sakâ, _تلي_, --, 
   {{0x7e6406c8,0xad2400d1,0x00000000,0x00000000}},	//   _iwip, _گىپى, --, --, 
   {{0x18a406c9,0x6fa803d4,0x00000000,0x00000000}},	//   раем, গাৰে, --, --, 
   {{0x7e6406ca,0x00000000,0x00000000,0x00000000}},	//   _kwip, --, --, --, 
   {{0x7e64009f,0xdcfc00d0,0x00000000,0x00000000}},	//   _jwip, _napĺ, --, --, 
   {{0xd49806cb,0x5d7804ac,0x7e6400ca,0x6728005f}},	//   ври_, דאַק, _mwip, _dzej, 
   {{0x1ccc038f,0x672806cc,0xdb040109,0x186806cd}},	//   ྱའི_, _ezej, _hakà, _шави_, 
   {{0x7f44013e,0x00000000,0x00000000,0x00000000}},	//   _ngiq, --, --, --, 
   {{0x67280327,0x00000000,0x00000000,0x00000000}},	//   _gzej, --, --, --, 
   {{0x7f44003a,0x00000000,0x00000000,0x00000000}},	//   _agiq, --, --, --, 
   {{0x7e640227,0x461006ce,0x67280327,0x301406cf}},	//   _awip, _بولر, _zzej, йдор, 
   {{0xa4d400db,0x88480023,0x00000000,0x00000000}},	//   _уюуш, _ንነብሰ, --, --, 
   {{0xdb0405da,0x227806d0,0x9f4002e2,0x3f140395}},	//   _nakà, _ملنگ_, tikò_, ждяс, 
   {{0x7e6406d1,0x271401fb,0xfd4406d2,0x8d8406d3}},	//   _dwip, ềng_, жэтн, шумд, 
   {{0x308400c6,0xbc4806d4,0xdcfc00d7,0x00000000}},	//   _العف, ичте_, _zapĺ, --, 
   {{0x80a80490,0x7ff4007b,0x8d780092,0x00000000}},	//   _जनते, _وسيا, ርሳቸው_, --, 
   {{0x6e9406d5,0x7e6405c7,0xdb0400c7,0xbea800ec}},	// [410] _الخا, _gwip, _rakã, _نهين_, 
   {{0x68e000af,0x3978029c,0xdb040022,0x00000000}},	//   _üldk, لصمد_, _sakã, --, 
   {{0x7e6406d6,0x6d4406d7,0x5c30036b,0x672806d8}},	//   _zwip, _igha, تکیز, _szej, 
   {{0xdb0406d9,0xddd4010e,0x27680214,0xef18031c}},	//   _fakà, _atyň, اشای_, żżu_, 
   {{0x23c4024a,0xd7e800cf,0x00000000,0x00000000}},	//   वासद, دونۇ_, --, --, 
   {{0xa50806da,0x6d440135,0xe5a406db,0x625806dc}},	//   лела_, _jgha, сики, қрир_, 
   {{0x6d4406dd,0x00000000,0x00000000,0x00000000}},	//   _mgha, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d406de,0x316c06df,0x6d4406e0,0x02c401b9}},	//   _koze, fadz_, _ogha, рқли_, 
   {{0x6d4406e1,0x69d406e2,0x27fc00a9,0xbbd406e3}},	//   _ngha, _joze, liwn_, _धक्क, 
   {{0x7e6406e4,0xdb04043b,0xa87800c8,0xc3400408}},	//   _swip, _maká, װאָר, _мĕн_, 
   {{0x6d4406e5,0xdb0406e6,0x312400f7,0x27fc015d}},	//   _agha, _laká, өдөг, niwn_, 
   {{0xfe7806e7,0x6d4406e8,0x26dc009a,0x69d402d0}},	//   шүп_, _bgha, nywo_, _ooze, 
   {{0x69d406e9,0x442c00a2,0x27fc0142,0xbbe000cd}},	//   _noze, _hhg_, hiwn_, नस्क, 
   {{0x6d44031c,0xe05400c6,0x68e000c5,0x63ac06ea}},	//   _dgha, _اختب, _üldh, _óans, 
   {{0x69d403bd,0x7e6406eb,0x442c032e,0x21e800d7}},	//   _aoze, _twip, _jhg_, _dúhe_, 
   {{0x69d406ec,0x4a4006ed,0x27fc015d,0x24980092}},	// [420] _boze, знув, diwn_, _መክሊት_, 
   {{0x69d406ee,0xdb0400d2,0x3ea00086,0x442c032e}},	//   _coze, _caká, _ipit_, _lhg_, 
   {{0x442c06ef,0xc310009e,0x97d800c0,0x27fc0042}},	//   _ohg_, াইটি_, льду_, fiwn_, 
   {{0x69d406f0,0x263c0030,0x442c06f1,0x6d440003}},	//   _eoze, _dňom_, _nhg_, _zgha, 
   {{0x236c0399,0x7c2406f2,0x224c0327,0x8c18011a}},	//   daej_, mlir, jqek_, _תוכי, 
   {{0x7c2406f3,0xd1dc0125,0x69d406f4,0x3ea005da}},	//   llir, ንበት_, _goze, _mpit_, 
   {{0x442c06f5,0x3ea00295,0xa8a406f6,0x27fc015d}},	//   _bhg_, _lpit_, _وصفو, biwn_, 
   {{0xdb0403c6,0x73d806f7,0x938806f8,0x325406f9}},	//   _zaká, рдир_, уска_, овир, 
   {{0x316c06fa,0x69d406fb,0xdb040621,0x7c240332}},	//   tadz_, _yoze, _enkö, ilir, 
   {{0x442c0175,0x7c24022e,0x1ad403d4,0xf8dc043e}},	//   _ehg_, hlir, _সেৱা, _यथाय, 
   {{0x316c06fc,0x3ea006fd,0xe80c0073,0x46100133}},	//   radz_, _apit_, िकचा_, _عومر, 
   {{0x442c0280,0x316c0419,0x68e8013a,0x73c401af}},	//   _ghg_, sadz_, _ředk, _фәке, 
   {{0xc0e406fe,0x316c003e,0x74b806ff,0x00000000}},	//   لفین_, padz_, ्मवृ, --, 
   {{0x94240131,0x6d440327,0x799c02d0,0xf15801e0}},	//   _ئوچۇ, _qgha, _nbrw, _тикш_, 
   {{0x3ea00700,0x818402de,0x70540244,0x442c010b}},	//   _epit_, _انىق_, _بنبا, _yhg_, 
   {{0x68e0007d,0x69d400a2,0xdb040701,0x00000000}},	//   _üldi, _soze, _saká, --, 
   {{0x69d40702,0x6d440703,0x2d84067c,0xdb0401ef}},	// [430] _poze, _tgha, òles_, _paká, 
   {{0x6d440704,0x799c03ac,0x7c240705,0x6d980108}},	//   _ugha, _cbrw, alir, _твоё_, 
   {{0xdb040706,0x69d40707,0xd1500023,0x51780092}},	//   _vaká, _voze, _ዘጠቓል, _በአንተ_, 
   {{0x69d40708,0x799c0042,0x80a80709,0xe50c00bc}},	//   _woze, _ebrw, _जनसे, ाअघि_, 
   {{0x69d4070a,0xdb04070b,0x61e00113,0x442c0142}},	//   _toze, _taká, ykll, _rhg_, 
   {{0x27fc00a9,0x442c070c,0x799c03ac,0xd6cc01c8}},	//   siwn_, _shg_, _gbrw, ئقو_, 
   {{0x442c070d,0xd1e8001f,0x2bfc00cd,0x5450070e}},	//   _phg_, ሆኑት_, _एषां_, үвәт, 
   {{0xe788004b,0x61e00113,0xc2b002dd,0xf7940064}},	//   _خپره_, wkll, зөкш, _насэ, 
   {{0x2be0070f,0xd7e800d1,0xb5c80345,0x00000000}},	//   _नवना, _ئوقۇ_, _گولم_, --, 
   {{0xe1f80710,0x21a400f7,0x442c0711,0xbb3c008f}},	//   рго_, циом, _whg_, נעזי, 
   {{0x3ea00712,0x60080713,0xa068026a,0x04b40050}},	//   _spit_, ином_, јама_, _دپاں_, 
   {{0xd9a40714,0x7a300715,0x3ea004e6,0x00000000}},	//   _ऑस्ट, mäte, _ppit_, --, 
   {{0x7a300716,0xa490004b,0xfbcc03d4,0x224c031c}},	//   läte, _ریښت, ৰোঁত, qqek_, 
   {{0x6b9c02d0,0x81bc0154,0x9f400108,0x00000000}},	//   _absg, ীসহ_, kikö_, --, 
   {{0x7a300717,0xdb040139,0x7dd0013d,0x7c240718}},	//   näte, _kakç, _mäsx, tlir, 
   {{0x1ae40719,0x7c24071a,0x799c02d0,0x717000db}},	//   ообм, ulir, _sbrw, _قۇۋا, 
   {{0x3ea0071b,0x533404ac,0x9e64071c,0x7c24071d}},	// [440] _upit_, ַנען_, _باعن, rlir, 
   {{0xa2b0071e,0x7a30071f,0x99880024,0x27ec031c}},	//   _अनन्, käte, _ribų_, _ċena_, 
   {{0x9b440720,0x0d200372,0x7c240721,0xd00c0424}},	//   _وندو, _жүрү, plir, _سلی_, 
   {{0x77940722,0x7a300723,0x6abc0334,0x7c24022e}},	//   ثیرا, däte, _frsf, qlir, 
   {{0xdb040194,0xc7a006ed,0xd6d000f2,0x00000000}},	//   _sakæ, ќичк, بقش_, --, 
   {{0xdcec0205,0x88c401ef,0x7a30013d,0x27300137}},	//   lebı, _spěš, fäte, رۉلس, 
   {{0xdb040724,0xe9700725,0xd14801b9,0x14c80108}},	//   _bakç, _سۇند, یشدن_, рыли_, 
   {{0x7dd002f6,0xd6a80214,0x9998007f,0x942000db}},	//   _väsy, _پدرم_, wopň_, بوعۇ, 
   {{0xd1c8035b,0x7dd00166,0x95c801f4,0x00000000}},	//   аунд_, _fäsx, _клаб_, --, 
   {{0x68e8012c,0x2be00034,0x69cc0316,0x7a30008e}},	//   _ředi, _नवभा, सायी, bäte, 
   {{0xc9500302,0x26c000b0,0x7a300139,0x00000000}},	//   ומת_, āhoe_, cäte, --, 
   {{0x784c044e,0x68300726,0x386c01bf,0x80a80027}},	//   _ብኣንጻ, rådg, _ædru_, _जनरे, 
   {{0xdb040054,0x68e00037,0x37bc0154,0x614000c7}},	//   _jakä, _üldv, _অকার, мҵәа, 
   {{0x68300450,0x9f4001f4,0x01a40153,0x00000000}},	//   måde, yikö_, _мкчк_, --, 
   {{0xad240727,0x68300728,0x661c02d2,0xec240116}},	//   سىرى, låde, _íske, كىسپ, 
   {{0x06c00729,0x3eb0049b,0xaa5402e8,0x9f4001f4}},	//   ্নতি, ältä_, зваш, vikö_, 
   {{0x1618072a,0x201000d0,0x6830072b,0xe978072c}},	// [450] धवार_, ézie_, nåde, йбаш_, 
   {{0xf41003d4,0x9f400108,0xba4400c0,0x00000000}},	//   াতিৰ_, tikö_, _šįry, --, 
   {{0xa8980220,0x6d540034,0x7f84072d,0x00000000}},	//   скеу_, mcza, _علین, --, 
   {{0x27e801ed,0x6d54033f,0x8038008f,0xdb04007c}},	//   óan_, lcza, ַנגע_, _bakä, 
   {{0xf1bc072e,0x6b8c072f,0x9f4002f6,0xabb40022}},	//   ्ञान, mgag, sikö_, _даҟә, 
   {{0x7a300730,0x6b8c0731,0x6aac0732,0xe2980032}},	//   täte, lgag, mwaf, ҡай_, 
   {{0x7d1800fe,0x69cc0490,0x15400733,0x6aac04ba}},	//   _øvst, साठी, нешм, lwaf, 
   {{0x6b8c0734,0x7a300735,0x6aac01f7,0xa3b80736}},	//   ngag, räte, owaf, صابر_, 
   {{0x7a300737,0xe1f80209,0x68300738,0x651401ed}},	//   säte, йги_, rådd, _کوائ, 
   {{0xc4c4023f,0x7a300739,0x6b8c073a,0xf4840116}},	//   _وتاو, päte, hgag, чуән, 
   {{0x6d54068f,0x6aac073b,0x6b8c073c,0xc614073d}},	//   dcza, hwaf, kgag, दकीय_, 
   {{0x6aac013b,0x683000b5,0x6d54033f,0xdd90073e}},	//   kwaf, både, ecza, کوس_, 
   {{0x63a8073f,0x33f40740,0xdea0036b,0x24500741}},	//   meen, _تسلس, ریدی, _hám_, 
   {{0x63a80742,0x6b8c0083,0x52d4011a,0x00000000}},	//   leen, egag, _מונע_, --, 
   {{0x71f80743,0x24500744,0x628801f4,0x00000000}},	//   _برنس_, _jám_, lueo, --, 
   {{0x24500745,0x6b8c0746,0x2f1402e3,0x6d540747}},	//   _mám_, ggag, ụga_, acza, 
   {{0x20000748,0x1fd000cc,0xdcec03e0,0x6d540210}},	// [460] miki_, াসদস, rebı, bcza, 
   {{0x63a80749,0x4ef80375,0xdb040022,0x6b8c074a}},	//   heen, _להפו, _rakä, agag, 
   {{0x2450074b,0x63a8074c,0xf1d001fb,0x4dd80375}},	//   _nám_, keen, _hạch_, _החיו, 
   {{0x6b8c074d,0x63a8074e,0xb8d4074f,0x00000000}},	//   cgag, jeen, _झन_, --, 
   {{0x63a80750,0xdb0401e6,0x20000270,0x1a640133}},	//   deen, _bakå, iiki_, _ریای_, 
   {{0x20000751,0xf1d00016,0x2450001e,0x9b44009f}},	//   hiki_, _mạch_, _bám_, _ونگو, 
   {{0x24500016,0x63a80752,0xddd400b8,0x05700753}},	//   _cám_, feen, _avyū, راود, 
   {{0x63a80754,0x24500755,0x6d54068f,0x20000756}},	//   geen, _dám_, zcza, jiki_, 
   {{0x20000757,0x6d54068f,0xd14801b9,0x00000000}},	//   diki_, ycza, یشگن_, --, 
   {{0x200003a0,0xe56000d7,0x6b8c022e,0x00000000}},	//   eiki_, _päťč, zgag, --, 
   {{0x20000758,0x63a80759,0x92bc00bd,0x68e000c5}},	//   fiki_, been, ীনে_, _üldt, 
   {{0x63a80429,0x2000075a,0xf1d00016,0x6d540034}},	//   ceen, giki_, _bạch_, wcza, 
   {{0xf194075b,0xf1d00208,0x92d800fe,0x00000000}},	//   _жиль, _cạch_, _ডেৰ_, --, 
   {{0x20000270,0x752400bc,0x7e440354,0x00000000}},	//   aiki_, řizu, ехсе, --, 
   {{0x2000075c,0x6d540034,0x245001fb,0x1b58063f}},	//   biki_, rcza, _xám_, _ọnụm, 
   {{0x6aac016b,0x2000075d,0x7f84075e,0x6d40022e}},	//   twaf, ciki_, _كلىن, оlar, 
   {{0x6b8c075f,0xf1d0001e,0xe1e80050,0xdb14007f}},	// [470] rgag, _gạch_, _دى۪و_, ndyè, 
   {{0x2fc801d4,0x6aac0230,0x63a80760,0x78700022}},	//   _hnag_, rwaf, zeen, _ẽvae, 
   {{0x63a80761,0x6aac0762,0x67d40763,0x6fd00764}},	//   yeen, swaf, можу, धापू, 
   {{0x24500765,0x63a80766,0x6aac0767,0x00000000}},	//   _rám_, xeen, pwaf, --, 
   {{0x24500232,0x63a80768,0x0ae80769,0x00000000}},	//   _sám_, veen, _طرحي_, --, 
   {{0x63a8076a,0x64a4076b,0xae1c01ad,0x2fc801e7}},	//   ween, дака, पकिन_, _lnag_, 
   {{0x63a8076c,0x2000076d,0x2bd0076e,0xb7c800f7}},	//   teen, yiki_, हापा, تبەك_, 
   {{0x2450076f,0x2fc80770,0x7a300771,0x320c0109}},	//   _vám_, _nnag_, mäta, endy_, 
   {{0x20000772,0x63a80773,0x27ec0774,0x65840022}},	//   viki_, reen, _ilen_, _ҕыҕз, 
   {{0x13040775,0x63a80776,0x2fc80777,0x68e0007d}},	//   ьный_, seen, _anag_, _ülds, 
   {{0xf1d00016,0x2fc801c3,0x63a80778,0x7a30014a}},	//   _sạch_, _bnag_, peen, näta, 
   {{0x2fc80779,0x63a80429,0x320c00c7,0x9f4001f4}},	//   _cnag_, qeen, andy_, yhkä_, 
   {{0x6288077a,0x2fc8077b,0x784c05d1,0x02a402e8}},	//   queo, _dnag_, _işve, _хрем, 
   {{0xdca4077c,0x7a30077d,0xb8e00135,0xf1d0001e}},	//   маги, käta, _ཀླ_, _vạch_, 
   {{0x27ec077e,0x2000077f,0x7a3001f4,0x5bb401f0}},	//   _olen_, piki_, jäta, мсаф, 
   {{0x7a300780,0xfcd00023,0xf1d00208,0xbb500220}},	//   däta, _ብደገ_, _tạch_, _ﺎﻨﻲ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [480] --, --, --, --, 
   {{0xbe3400db,0x00000000,0x00000000,0x00000000}},	//   _سۉزب, --, --, --, 
   {{0x2fc80781,0x16c40782,0x27ec0783,0x9f400784}},	//   _ynag_, लम्ब, _blen_, shkä_, 
   {{0x9d9801c8,0x00000000,0x00000000,0x00000000}},	//   _انھئ_, --, --, --, 
   {{0xdb040022,0x1ccc031c,0x00000000,0x00000000}},	//   _lakú, ྱའམ_, --, --, 
   {{0x7ae40223,0x1868020f,0xdcfc03e0,0x00000000}},	//   myit, _маги_, _hapı, --, 
   {{0x27ec0785,0xdcfc0365,0xc9240786,0xdb040030}},	//   _flen_, _kapı, _жорж_, _nakú, 
   {{0x27ec0787,0x7ae40788,0x21e80789,0x2bd0078a}},	//   _glen_, oyit, _búho_, हाया, 
   {{0x5184078b,0x2fc8078c,0x68e00037,0x00000000}},	//   муна, _rnag_, _üldr, --, 
   {{0x2fc8078d,0x2258078e,0x978c0354,0x672c0210}},	//   _snag_, íska_, _гiур_, żajc, 
   {{0x764801e2,0x27ec02f6,0x68300267,0x7ae4078f}},	//   _iidy, _ylen_, låda, hyit, 
   {{0x33b40014,0xd24c01d9,0x926806ed,0xdcfc0790}},	//   _سٕتر, _پۆد_, _дрка_, _napı, 
   {{0x201000d0,0x6830007c,0x00000000,0x00000000}},	//   ézia_, nåda, --, --, 
   {{0x7a300227,0x2f14063f,0xdb040419,0x00000000}},	//   yäta, ụgo_, _fakú, --, 
   {{0x76480791,0xd12c0014,0x7ae40337,0x2fc80332}},	//   _midy, _خۅد_, eyit, _tnag_, 
   {{0x68300267,0x76480792,0x7a300108,0x00000000}},	//   kåda, _lidy, väta, --, 
   {{0x2bd0033d,0xdb0401f1,0x3c440024,0x00000000}},	// [490] हाबा, _zakú, тэрв, --, 
   {{0x7a300793,0x27ec02d2,0x7bc002d2,0xa9c000db}},	//   täta, _slen_, _ómun, دۅسۉ, 
   {{0x27ec0794,0x3d100490,0x7ae40795,0x7994010b}},	//   _plen_, णपणे_, ayit, тихф, 
   {{0x7ae40796,0x7a300054,0x76480797,0x2b580798}},	//   byit, räta, _aidy, _ufsc_, 
   {{0xf7700799,0x7a30079a,0x7648079b,0x27ec02d3}},	//   شان_, mätn, _bidy, _vlen_, 
   {{0x7a30079c,0x8b940139,0x00000000,0x00000000}},	//   päta, _эрүч, --, --, 
   {{0xdcfc079d,0x7a300054,0x7648079e,0x24e8079f}},	//   _yapı, qäta, _didy, ямки_, 
   {{0xdb0401f1,0x1ad404c5,0x76480165,0x27ec07a0}},	//   _rakú, _সেয়া, _eidy, _ulen_, 
   {{0x764807a1,0x52a407a2,0x68e407a3,0x00000000}},	//   _fidy, евым_, lyhd, --, 
   {{0x67280022,0x764807a4,0xa4d40024,0x59d000bc}},	//   _iyej, _gidy, _позі, सायर, 
   {{0x67280263,0x68e4005b,0xa0c401f7,0x35d407a5}},	//   _hyej, nyhd, ريحو, _шофё, 
   {{0x6e24001f,0x76480161,0x672804ba,0x7ae407a6}},	//   _akhb, _zidy, _kyej, yyit, 
   {{0xdcb007a7,0xdb040248,0x63b803cb,0x59d000cd}},	//   گىز_, _fakù, _iawn, सामर, 
   {{0xf1d00016,0x7ae407a8,0x63b8003d,0x764807a9}},	//   _hạnh_, vyit, _hawn, _xidy, 
   {{0x229807aa,0x63b807ab,0x672807ac,0x98b80205}},	//   lèk_, _kawn, _lyej, yapı_, 
   {{0xdcfc00ac,0x195407ad,0x7ae4009a,0xef2002e3}},	//   _qapı, _ｋｅｎ_, tyit, ụzịa, 
   {{0xf1d007ae,0x2be007af,0x672806d9,0x229807b0}},	// [4a0] _mạnh_, _नवरा, _nyej, nèk_, 
   {{0xf1d007ae,0x7ae407b1,0x63b807b2,0x4b2000d4}},	//   _lạnh_, ryit, _lawn, умув, 
   {{0xdcfc07b3,0x672807b4,0x8d8402d3,0xdca407b5}},	//   _tapı, _ayej, _ንምባል_, _џами, 
   {{0x764802fa,0x672804ba,0x7ac400c7,0x2bd007b6}},	//   _sidy, _byej, _иҩба, हाणा, 
   {{0x22980214,0x76480042,0x6fd007b7,0xdb080254}},	//   jèk_, _pidy, धातू, önäi, 
   {{0x86c007b8,0x7a3000fd,0x683007b9,0x22980669}},	//   ايون, mäto, råda, dèk_, 
   {{0x764807ba,0x67280117,0x3f800268,0x68e000af}},	//   _vidy, _eyej, _odiu_, _üldp, 
   {{0x764807bb,0xf1d00016,0x6728036e,0xc0d80240}},	//   _widy, _cạnh_, _fyej, ሕኒሕ_, 
   {{0x764807a9,0x63b807bc,0x75280034,0x2bd00490}},	//   _tidy, _dawn, _wydz, हाता, 
   {{0xa2b007bd,0x3f8007be,0x75280034,0x6830050a}},	//   _अनर्, _adiu_, _tydz, nådn, 
   {{0x6814068f,0x63b807bf,0x823007c0,0xeb0c07c1}},	//   ląda, _fawn, دريا, _सख्त_, 
   {{0x63b80363,0x229807c2,0x20d40024,0xdb040162}},	//   _gawn, bèk_, džią_, _fakø, 
   {{0x91e407c3,0x1e70054a,0x22980066,0xd954001f}},	//   _поде, ағыс, cèk_, ውንታን, 
   {{0x92f007c4,0x3f8007c5,0xd174013d,0x68e40108}},	//   ığım, _ediu_, _чыды, yyhd, 
   {{0x63b80072,0xe57000c8,0x7c8407c6,0x7a30007c}},	//   _yawn, יַן_, луте, tätn, 
   {{0x7e0400db,0x00000000,0x00000000,0x00000000}},	//   _ۅسپۅ, --, --, --, 
   {{0xdb24072d,0x00000000,0x00000000,0x00000000}},	// [4b0] نوفی, --, --, --, 
   {{0x8fd001ee,0x00000000,0x00000000,0x00000000}},	//   _рәүә, --, --, --, 
   {{0xa77407c7,0x7a300724,0x2d8007c8,0x6728007f}},	//   влеч, mätl, _idhe_, _syej, 
   {{0x7a30013d,0x672807c9,0x2298034c,0xd12403e6}},	//   lätl, _pyej, yèk_, _ۆم_, 
   {{0x69c007ca,0xd12407cb,0x63b807cc,0x68e4005b}},	//   _óleo, _چم_, _rawn, syhd, 
   {{0xd12407cd,0x63b80399,0xe5a407ce,0x693407cf}},	//   _نم_, _sawn, тики, _ангу, 
   {{0x47880276,0x229800f2,0x64bc07d0,0x00000000}},	//   _нсам_, wèk_, ्मेश, --, 
   {{0xe79400dd,0x229807d1,0x7a300166,0x00000000}},	//   _جاسک, tèk_, hätl, --, 
   {{0x661c06ea,0x88b0015b,0x3f840321,0x45a007d2}},	//   _ísko, _টপিক, ómum_, _مەشك, 
   {{0x229807d3,0x2d800055,0x76b8030d,0x00000000}},	//   rèk_, _ndhe_, _ялур_, --, 
   {{0x63b807d4,0x3f800023,0xa06807d5,0x20100165}},	//   _tawn, _pdiu_, ьана_, ézio_, 
   {{0xdee407d6,0x229800f2,0xb22400cf,0xa07400db}},	//   воми, pèk_, кмөл, нгүч, 
   {{0x7a300166,0x80dc00fe,0xdcec07d7,0x00000000}},	//   fätl, _ফেশ্, dabā, --, 
   {{0x91e007d8,0x6288007b,0x7a3007d9,0x00000000}},	//   _воше, mreo, väto, --, 
   {{0x443c07da,0x3f80022e,0x1d08011c,0x00000000}},	//   omu_, _tdiu_, феви_, --, 
   {{0x2d8007db,0x443c07dc,0x63ac07dd,0x3f8007de}},	//   _edhe_, nmu_, _ñand, _udiu_, 
   {{0x443c07df,0x7a300724,0x628807e0,0x8eb00066}},	// [4c0] imu_, bätl, nreo, _نميش, 
   {{0x443c07e1,0x1868005b,0x628801e7,0x9c5800db}},	//   hmu_, дажи_, ireo, _ошму_, 
   {{0x443c07e2,0x81c0015b,0x9f0407e3,0x7a30005b}},	//   kmu_, _একা_, _سوگو, säto, 
   {{0x1cc007e4,0x628807e5,0x443c0216,0xd70807e6}},	//   _གླར_, kreo, jmu_, мнее_, 
   {{0x443c07e7,0x969406bb,0x75f4067c,0x7c2407e8}},	//   dmu_, треш, _làze, moir, 
   {{0x7c2407e9,0x09b00003,0x1dc0043e,0x661c032e}},	//   loir, _དྲྭ_, शयित, _ískl, 
   {{0x26d807ea,0x7c2401ab,0x00000000,0x00000000}},	//   _àson_, ooir, --, --, 
   {{0x7c2407eb,0x628807ec,0x938800f0,0x25a40142}},	//   noir, freo, фска_, _ebll_, 
   {{0x628807ed,0x98800118,0x427007ee,0x5fd400bc}},	//   greo, _míče_, агыс, धानल, 
   {{0x443c07ef,0x7c2407f0,0x00000000,0x00000000}},	//   amu_, hoir, --, --, 
   {{0x7c2407f1,0x6fb407f2,0x82d40327,0x443c07f3}},	//   koir, همدا, ྲྀཏའ, bmu_, 
   {{0x628807f4,0x25a807f5,0x130401af,0x443c06be}},	//   breo, đale_, _изем, cmu_, 
   {{0x7c2407f6,0x6ad007f7,0x2bd007f8,0xc014005b}},	//   doir, _सपेर, हासा, рмящ, 
   {{0x827404ac,0x80a8012c,0xdb0401a8,0x00000000}},	//   _יעדע_, _जनचे, _bakþ, --, 
   {{0x7c240597,0xfbc407b7,0xd01800f3,0xc0e0009b}},	//   foir, _लोहम, _офи_, _војк, 
   {{0x7c2407f9,0x0a6807fa,0x683000cc,0x00000000}},	//   goir, држи_, vådo, --, 
   {{0x3b5407fb,0x63ac0588,0xba7407fc,0x00000000}},	// [4d0] ркур, _ñane, لالت, --, 
   {{0x2d80036e,0x7c2401f4,0x7a300139,0x00000000}},	//   _udhe_, aoir, bätm, --, 
   {{0x443c07fd,0x7c2407fe,0xef10004b,0x6288030a}},	//   ymu_, boir, _خټک_, zreo, 
   {{0xe678005e,0x628807ff,0x7c240800,0x3b640801}},	//   ейді_, yreo, coir, _върв, 
   {{0xdb040432,0x443c0802,0x00000000,0x00000000}},	//   _kaký, vmu_, --, --, 
   {{0xdb04012c,0x443c0803,0xf62402bf,0x62880804}},	//   _jaký, wmu_, адіо, vreo, 
   {{0x443c0805,0xe3b000c6,0xbe9c01a9,0xf9640345}},	//   tmu_, مرة_, _ta談i, _ئۆمێ, 
   {{0x62880806,0x8d8402d3,0x1cc0025c,0x6934036b}},	//   treo, _ንዝብል_, _གླས_, _анҳу, 
   {{0x6ad00807,0x63b00010,0x32d402d5,0x6814012d}},	//   _सपोर, _čenč, ацэс, lądo, 
   {{0xe0d80808,0x62880809,0x7c24080a,0x00000000}},	//   ево_, rreo, zoir, --, 
   {{0x443c080b,0x7c24009f,0x6288080c,0x00000000}},	//   pmu_, yoir, sreo, --, 
   {{0x6288080d,0x7c24005a,0x7a3001f4,0x443c06be}},	//   preo, xoir, vätm, qmu_, 
   {{0x21a4080e,0x7c24080f,0xdb040432,0x784c06be}},	//   _билм, voir, _baký, _xğvq, 
   {{0x41b40764,0x7c240810,0xa0c40811,0x127800df}},	//   _असिस, woir, _ميتو, _טאנע, 
   {{0x7c240812,0xa0a40813,0x71240814,0xdb040432}},	//   toir, _сайд, _پرول, _daký, 
   {{0x0ca0044e,0xabf40815,0x9ad40816,0xd12c00ae}},	//   _ምግላጽ_, ачущ, люзі, _عمي_, 
   {{0x7c240817,0xdf480818,0x00000000,0x00000000}},	// [4e0] roir, _язид_, --, --, 
   {{0x7e640819,0x7c24081a,0xd944081b,0x00000000}},	//   _itip, soir, гези, --, 
   {{0x7c24081c,0x7a30081d,0x00000000,0x00000000}},	//   poir, lätk, --, --, 
   {{0x788003c6,0x38c801d5,0x661c02d2,0x00000000}},	//   _návš, _یازی_, _ískj, --, 
   {{0x2bd0081e,0x00000000,0x00000000,0x00000000}},	//   हारा, --, --, --, 
   {{0x1cc0081f,0x7e640161,0xda6400ec,0x00000000}},	//   _གློ_, _mtip, _لاڳي, --, 
   {{0x1cd80327,0x54a4007b,0x06c000cc,0x00000000}},	//   འདི_, احتف, ্নগি, --, 
   {{0x7e640820,0x7a30081d,0x00000000,0x00000000}},	//   _otip, kätk, --, --, 
   {{0x7a300821,0x00000000,0x00000000,0x00000000}},	//   jätk, --, --, --, 
   {{0x506401c0,0x7a300822,0x00000000,0x00000000}},	//   лтма, dätk, --, --, 
   {{0x7e640823,0x30140824,0x6ad00825,0xc0540826}},	//   _atip, идор, _सप्र, лія_, 
   {{0x1cc0025c,0x7a300139,0x00000000,0x00000000}},	//   _གླེ_, fätk, --, --, 
   {{0xb8d0031c,0x81e0015b,0x81c00154,0xdb040827}},	//   _ྐད_, _নগর_, _একর_, _makó, 
   {{0xdb0401ed,0x00000000,0x00000000,0x00000000}},	//   _lakó, --, --, --, 
   {{0x9f50007f,0x70940828,0xc98400d1,0x2bd00829}},	//   _olyè_, _тайф, ғузи, हाला, 
   {{0xdb040259,0x7a3001f1,0x49b8082a,0x7e64082b}},	//   _fakü, bätk, کارد_, _ftip, 
   {{0x69c0082c,0xdb0401f1,0x7b640354,0x62840055}},	// [4f0] _ólek, _taký, стсе, _āhok, 
   {{0x2c50033f,0x00000000,0x00000000,0x00000000}},	//   _sądu_, --, --, --, 
   {{0xdb040085,0x87e4082d,0x48a80024,0x00000000}},	//   _bakó, люде, этам_, --, 
   {{0xf868082e,0xaa94082f,0xdb040139,0x37740830}},	//   امني_, _кимч, _yakü, бышс, 
   {{0xc7900831,0xdae401ed,0xe9a801d9,0x5fd40073}},	//   арҙы, _پہلو_, _لگان_, धातल, 
   {{0xdb0c008c,0x2a68000d,0x65c4004e,0x00000000}},	//   _þjál, mpab_, рбка, --, 
   {{0x35f80832,0x7a3001f4,0x98f001e2,0x00000000}},	//   درند_, däth, _وګما, --, 
   {{0x69c80833,0xaac80834,0xe2840835,0x62d40836}},	//   _होती, रिपक, алии, لآخر, 
   {{0x22140837,0x620401b9,0xf3c800ae,0x00000000}},	//   ифор, аtlа, طبيه_, --, 
   {{0x7a3002f6,0xdb04007f,0x7e640166,0xa204004e}},	//   vätk, _kakò, _rtip, рпод, 
   {{0xa0a40838,0xdb0402bd,0x7e640839,0xf4840111}},	//   шанд, _jakò, _stip, _гучн, 
   {{0x7e64083a,0xdb04033b,0xf1a8083b,0x60240657}},	//   _ptip, _makò, پایه_, рдма, 
   {{0x236c047e,0xdb0402bd,0x3f8c083c,0xd1e80092}},	//   mbej_, _lakò, ğdu_, _ህጎች_, 
   {{0x6144083d,0x7e640232,0x3f8c00ac,0x910403e6}},	//   _кела, _vtip, şdu_, اسیۆ, 
   {{0xdcb00075,0x00000000,0x00000000,0x00000000}},	//   غىر_, --, --, --, 
   {{0x7e64009d,0x1ec80107,0x236c047e,0x7a30083e}},	//   _ttip, _алии_, nbej_, mäti, 
   {{0x1a04083f,0x7a300840,0x7e640841,0x00000000}},	// [500] апам, läti, _utip, --, 
   {{0xdb04007f,0x236c0842,0x8e78011a,0x00000000}},	//   _bakò, hbej_, _שניה, --, 
   {{0x7a3001b8,0xd8240843,0x00000000,0x00000000}},	//   näti, аджи, --, --, 
   {{0x2a680218,0x236c016d,0xad6400f2,0x00000000}},	//   bpab_, jbej_, _پایه, --, 
   {{0x4cb802a6,0xddd40232,0x236c014f,0x59740024}},	//   _উপযু, _zvyš, dbej_, _выбу, 
   {{0x7a300844,0xc6f40845,0x85740131,0x473000d4}},	//   käti, шніх_, қсәт_, цніс, 
   {{0x9f4002f6,0x3ea00327,0x7a300108,0x00000000}},	//   lkkä_, _lqit_, jäti, --, 
   {{0x25a805ce,0xd7f0007b,0x236c014f,0xb274009b}},	//   đala_, _بكر_, gbej_, блиш, 
   {{0x9f40005b,0xaac80846,0xf1b8031c,0x7a300847}},	//   nkkä_, रियक, loġi_, täth, 
   {{0x7a3001b8,0x00000000,0x00000000,0x00000000}},	//   fäti, --, --, --, 
   {{0x799c03ac,0x236c047e,0x00000000,0x00000000}},	//   _mcrw, bbej_, --, --, 
   {{0xc0cc02d3,0x95c8010a,0x00000000,0x00000000}},	//   ባብሮ_, _пуçа_, --, --, 
   {{0x63ac0848,0x799c03ac,0x03a000d8,0x00000000}},	//   _ñana, _ocrw, _фичо, --, 
   {{0x7a300793,0x2d84056d,0x23080849,0xfccc0023}},	//   bäti, ûle_, _حتمي_, _ኣሞጽ_, 
   {{0x52b4084a,0x320c084b,0x69c002d2,0xf07801a9}},	//   _अनुस, midy_, _ólei, _ёйиш_, 
   {{0x320c05d6,0x80dc00fe,0x2d8c0356,0x00f4011a}},	//   lidy_, _ফেক্, şee_, _כמוך_, 
   {{0xdd90006c,0xab38084c,0x00000000,0x00000000}},	// [510] _کوپ_, упау_, --, --, 
   {{0x320c06d9,0x53a4084d,0x672c031c,0x00000000}},	//   nidy_, क्तश, żajk, --, 
   {{0xb9c4084e,0x236c014f,0x661c032e,0x00000000}},	//   تقلي, ybej_, _íski, --, 
   {{0xb5c801d9,0x320c03d1,0x1cc0031c,0x799c02d0}},	//   یونم_, hidy_, _གླི_, _ecrw, 
   {{0x320c03d1,0x683005ac,0x7b8400db,0x236c016d}},	//   kidy_, nådi, _باپە, vbej_, 
   {{0xe298016c,0x78bc0175,0x6abc02d0,0x320c030a}},	//   ҳаи_, _fsrv, _issf, jidy_, 
   {{0x320c0170,0xfa340133,0x236c047e,0x00000000}},	//   didy_, _گرێد, tbej_, --, 
   {{0x2488084f,0xe3b80850,0x81c000bd,0xe2980107}},	//   čam_, уби_, _একই_, гаи_, 
   {{0x320c0851,0x236c016d,0xaab801ad,0x00000000}},	//   fidy_, rbej_, ॉटिक, --, 
   {{0x7a300852,0x85b801d9,0x236c016d,0x00000000}},	//   täti, _جارس_, sbej_, --, 
   {{0x236c016d,0xe1240853,0x00000000,0x00000000}},	//   pbej_, смни, --, --, 
   {{0x7a300854,0x9f40005b,0x6abc035a,0x236c016d}},	//   räti, ykkä_, _ossf, qbej_, 
   {{0x62640855,0x7a30049b,0x320c0170,0x6d400209}},	//   _увла, säti, bidy_, ýlan, 
   {{0x8d600021,0x7a300856,0x1d080137,0xda5800d1}},	//   звре, päti, геги_, ғраш_, 
   {{0x6abc0857,0x23bc00cd,0x00000000,0x00000000}},	//   _assf, ्यपद, --, --, 
   {{0x6830013c,0x7a3001e3,0x44c40051,0x00000000}},	//   bådi, nätv, _mđ_, --, 
   {{0x6b9c0175,0x59840858,0x44c4004d,0x799c035a}},	// [520] _dcsg, йлаб, _lđ_, _pcrw, 
   {{0x200c068f,0x9f400859,0x6b9c0142,0x00000000}},	//   ślić_, rkkä_, _ecsg, --, 
   {{0x44c401fb,0x6abc035a,0x18a40108,0x00000000}},	//   _nđ_, _essf, саем, --, 
   {{0xd498085a,0x1cc0025c,0x7794085b,0x00000000}},	//   ҳри_, _གླག_, تیرا, --, 
   {{0xe7f807f7,0xec340133,0x41b4085c,0xd37800d1}},	//   ्फ़ा_, _گوێگ, _असंस, ңчи_, 
   {{0x99d4085d,0xd498085e,0xd944085f,0x7bc40860}},	//   _اتحا, гри_, _геги, ldiu, 
   {{0x320c0170,0x44c4001e,0x1ccc0327,0x00000000}},	//   vidy_, _cđ_, ཱའི_, --, 
   {{0xc7a00861,0x07a005f5,0x44c4004d,0x00000000}},	//   _ниск, _насн, _dđ_, --, 
   {{0xe6b401d5,0x320c0118,0x7bc40862,0x00000000}},	//   _ولفگ, tidy_, idiu, --, 
   {{0xca180075,0x63ac0863,0x46e400d1,0xaac80864}},	//   ﺷﻘﺎ_, _ñann, _удун_, रितक, 
   {{0x320c0865,0x44c4004d,0x546806ed,0x53a4013d}},	//   ridy_, _gđ_, _саем_, _гаеб, 
   {{0x69c00162,0x7bc4036e,0x00000000,0x00000000}},	//   _ólev, jdiu, --, --, 
   {{0xd33400db,0x09b00327,0xd2440304,0x320c0866}},	//   _اعاع, _དྲྀ_, _лэки, pidy_, 
   {{0xc5180597,0x1cc00867,0xacf80868,0x68300869}},	//   _рιӣκ, _གླང_, ангу_, rådi, 
   {{0x5064086a,0x63580055,0x6ad0086b,0x00000000}},	//   _утла, _ṃnib, सम्र, --, 
   {{0xbea800ec,0x00000000,0x00000000,0x00000000}},	//   _ڇهين_, --, --, --, 
   {{0x4e940101,0xeb98086c,0xc0d000cf,0x34b400cd}},	// [530] _اشعر, лиң_, _ويۇب, ंबुद, 
   {{0x7bc4086d,0xdc5401ed,0xde440014,0x6b8800de}},	//   adiu, صرہک, _ویَو_, _ķegu, 
   {{0x3178068f,0x7a3002f6,0xbdf8086e,0xa8740220}},	//   órzy_, jätu, _دريا_, ілді, 
   {{0x7a300166,0x00000000,0x00000000,0x00000000}},	//   dätu, --, --, --, 
   {{0x6abc02d0,0x44c40051,0x7a3001f4,0x00000000}},	//   _ussf, _sđ_, vätv, --, 
   {{0x25a805ce,0x24e8086f,0x4b400014,0x2bd00870}},	//   đalo_, имли_, _وٹھہ, हाका, 
   {{0x69c40871,0x44c401fb,0x00000000,0x00000000}},	//   mdhe, _qđ_, --, --, 
   {{0x69c40872,0xca180873,0x44c40208,0x00000000}},	//   ldhe, ﺴﯩﺰ_, _vđ_, --, 
   {{0xe1f80874,0x6fdc0574,0xca1800d1,0x00000000}},	//   иги_, यानं, ﺷﺘﺎ_, --, 
   {{0x26cc0875,0x7bc40007,0x44c40208,0x00000000}},	//   _ireo_, zdiu, _tđ_, --, 
   {{0x69c40876,0x7a300877,0x2900004e,0x63ac00e4}},	//   idhe, mätt, nzha_, _ñano, 
   {{0x7a300878,0xa2d40879,0x26cc087a,0x6fa40490}},	//   lätt, _ويات, _kreo_, ग्लं, 
   {{0x63a80434,0x69d4087b,0x69c4087c,0xa2e4087d}},	//   mfen, _onze, kdhe, _фолд, 
   {{0xdd90087e,0x63a8087f,0x69c40880,0x7a300881}},	//   بوس_, lfen, jdhe, nätt, 
   {{0x69c40882,0x27140883,0x442c0165,0xdb780884}},	//   ddhe, तपुर_, _kkg_, исаш_, 
   {{0x69d40885,0x63a80886,0x7bc40887,0x7a300888}},	//   _anze, nfen, udiu, hätt, 
   {{0x63a80889,0x7bc4088a,0x7a30088b,0xda64088c}},	// [540] ifen, rdiu, kätt, تازي, 
   {{0x69c4088d,0x8eb0088e,0x7a30088f,0x4a400890}},	//   gdhe, _کمیش, jätt, днув, 
   {{0x7a300891,0x26cc008f,0x442c05c7,0x52b40892}},	//   dätt, _areo_, _okg_, _अन्स, 
   {{0x69d40893,0x26cc0077,0x69c40894,0x63a801a4}},	//   _enze, _breo_, adhe, jfen, 
   {{0x26cc0895,0x33f800e8,0x63a80042,0x7a300139}},	//   _creo_, _néxa_, dfen, fätt, 
   {{0xdb0401b8,0x63a80896,0x26cc0897,0x75240898}},	//   _bakö, efen, _dreo_, şizm, 
   {{0x63a80899,0x5fc8089a,0x26cc0109,0x442c089b}},	//   ffen, ियाल, _ereo_, _bkg_, 
   {{0x63a800a9,0x442c05b1,0x26cc0005,0x044006ed}},	//   gfen, _ckg_, _freo_, мејн, 
   {{0x26cc089c,0x7a30089d,0x442c089e,0x6b60089f}},	//   _greo_, bätt, _dkg_, _hágó, 
   {{0x914808a0,0x154400a8,0x63a80036,0x7a3008a1}},	//   ична_, _дезм, afen, pätu, 
   {{0x53a408a2,0x96c006ab,0x1ddc08a3,0x26cc08a4}},	//   _мажб, लिकॉ, मानत, _zreo_, 
   {{0x442c08a5,0x69c401d3,0x00000000,0x00000000}},	//   _gkg_, zdhe, --, --, 
   {{0x69c408a6,0x53140214,0x7a30007c,0x20f40051}},	//   ydhe, _بذار, näts, ái_, 
   {{0x3f8408a7,0x69c401d9,0xc69008a8,0x2a6c08a9}},	//   ómur_, xdhe, ואש_, _çebi_, 
   {{0x6e3400b5,0xdb1402e2,0x442c00a2,0x00000000}},	//   rlzb, leyè, _ykg_, --, 
   {{0x69c408aa,0x395800ef,0xf1b80327,0x7a3004ab}},	//   wdhe, _agrs_, leġ_, käts, 
   {{0x7a3008ab,0x69c40023,0x8bfc0349,0xdb140100}},	// [550] yätt, tdhe, ্কলন_, neyè, 
   {{0x395804cc,0x69c401a4,0xe7380032,0x7a3004cc}},	//   _cgrs_, udhe, ҙел_, däts, 
   {{0x69c408ac,0x26cc08ad,0x7a3008ae,0x888000f2}},	//   rdhe, _sreo_, vätt, بیزن, 
   {{0x69c40023,0x6b60032e,0x2900030a,0xa7a80108}},	//   sdhe, _dágó, rzha_, ёкла_, 
   {{0x7a3008af,0x9ba008b0,0x63a80165,0x244000e4}},	//   tätt, _سەلى, vfen, nóme_, 
   {{0x26cc084c,0x69d408b1,0x442c08b2,0xd6cc0472}},	//   _vreo_, _unze, _skg_, اقو_, 
   {{0x7a3008b3,0x6ab803be,0xdb2001e1,0xb2d00051}},	//   rätt, şafı, _àtòy, _đềxe, 
   {{0x26cc08b4,0x7a3008b5,0x63a808b6,0xa2e408b7}},	//   _treo_, sätt, ufen, зоид, 
   {{0x63a808b8,0xdb04006a,0x63ac02d1,0x26cc01e4}},	//   rfen, _wakö, _ñanm, _ureo_, 
   {{0x130408b9,0xe1f8009d,0x00000000,0x00000000}},	//   яный_, сго_, --, --, 
   {{0x63a808ba,0x442c003e,0x363401d5,0x35680276}},	//   pfen, _tkg_, _آرقس, _фрун_, 
   {{0x442c08bb,0x601400c0,0xdb1408bc,0x00000000}},	//   _ukg_, kšme, beyè, --, 
   {{0x644808bd,0x317c0010,0xf1b8025c,0x62640408}},	//   mmei, _fevz_, beġ_, _эвла, 
   {{0x644808be,0xc0e00023,0x00000000,0x00000000}},	//   lmei, ምሃር_, --, --, 
   {{0x1fb408bf,0xdb040109,0xd65c02dd,0xe08801f7}},	//   _еспр, _lakô, _бiзд, _اَبو_, 
   {{0x644808c0,0x1e8408c1,0x395804cc,0x717000d1}},	//   nmei, _елим, _sgrs_, _كۇۋا, 
   {{0x644808c2,0x8f9808c3,0x00000000,0x00000000}},	// [560] imei, _היפי, --, --, 
   {{0x644808c4,0xb10000ee,0x7a3008c5,0x5fc800c5}},	//   hmei, _öýün, väts, ियवल, 
   {{0x23bc01bc,0x64480097,0xdb14007f,0x00000000}},	//   ्याद, kmei, zeyè, --, 
   {{0x7a300730,0x6b6001d3,0x5c7401af,0x00000000}},	//   täts, _vágó, _мәғр_, --, 
   {{0x644800af,0xdb0400c7,0x7e600113,0x998400db}},	//   dmei, _pakõ, ímph, _ىلحو, 
   {{0xdb040109,0x7a3008c6,0x644808c7,0x00000000}},	//   _dakô, räts, emei, --, 
   {{0x644808c8,0x7a30013d,0x00000000,0x00000000}},	//   fmei, bätr, --, --, 
   {{0x438008c9,0x279408ca,0x7a30000d,0xf1b80327}},	//   ىلىق, _ошур, päts, weġ_, 
   {{0x683008cb,0x00000000,0x00000000,0x00000000}},	//   rådt, --, --, --, 
   {{0x644808cc,0x6830005c,0x444401d9,0xdb14007f}},	//   amei, båds, _ہرنہ, reyè, 
   {{0x644808cd,0xf1b80003,0x00000000,0x00000000}},	//   bmei, reġ_, --, --, 
   {{0x04d80302,0xdb1402e2,0xf1b80327,0x661c08ce}},	//   _לקבל, peyè, seġ_, _ískr, 
   {{0x80a008cf,0x80ac00cc,0x1ad40073,0x00000000}},	//   ومین, টিষ্, ठमोठ, --, 
   {{0x244000d7,0x00000000,0x00000000,0x00000000}},	//   róme_, --, --, --, 
   {{0x7d2408d0,0x6fa40490,0x00000000,0x00000000}},	//   ефте, _कापू, --, --, 
   {{0x2c0c0574,0x00000000,0x00000000,0x00000000}},	//   _सगळं_, --, --, --, 
   {{0x0a68041b,0x2cc80064,0x7a3001f4,0x00000000}},	// [570] срби_, _žudė_, vätr, --, 
   {{0x64480007,0xba7400cf,0xa2cc08d1,0x00000000}},	//   zmei, عاقت, तित्, --, 
   {{0xe7f8012d,0x00000000,0x00000000,0x00000000}},	//   ंसला_, --, --, --, 
   {{0x27e808d2,0xbea8036b,0x00000000,0x00000000}},	//   ðan_, _بهین_, --, --, 
   {{0x6fa408d3,0x644808d4,0x00000000,0x00000000}},	//   _कानू, vmei, --, --, 
   {{0x25a008d5,0x7a3001e3,0xf5840116,0x00000000}},	//   ühl_, sätr, ىشىپ, --, 
   {{0x644808d6,0x63ac02d1,0x00000000,0x00000000}},	//   tmei, _ñank, --, --, 
   {{0x683008d7,0xf9900050,0x3cfc08d8,0x6448002f}},	//   råds, _لبہ_, מלונ, umei, 
   {{0xb9dc02d3,0x1cc0025c,0x5908031c,0xb2d00051}},	//   _በታ_, _གླན_, _གཟོས_, _đểxe, 
   {{0x644808d9,0xa878008f,0x672c0210,0x00000000}},	//   smei, ֿאָר, żajs, --, 
   {{0xd5a4035c,0xddd4010b,0xc42808da,0x00000000}},	//   _آلمی, _atyş, _люде_, --, 
   {{0xa2f408db,0xdea008dc,0xa2cc08dd,0x00000000}},	//   _опеч, پیدی, तिद्, --, 
   {{0x21a401b9,0x00000000,0x00000000,0x00000000}},	//   _жилм, --, --, --, 
   {{0xdd9008de,0x23bc08df,0x00000000,0x00000000}},	//   ضور_, ्यवद, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xaac806ab,0x8c4008e0,0xf3f800e2,0x00000000}},	//   रिंक, весе, _kuģa_, --, 
   {{0x19c408e1,0x00000000,0x00000000,0x00000000}},	// [580] мбам, --, --, --, 
   {{0x0d8008e2,0xd7c40490,0x00000000,0x00000000}},	//   _ильн, _रोजच, --, --, 
   {{0x3f8008e3,0x1c4408e4,0xaaa800cf,0x1b78007b}},	//   _keiu_, _оном, _ۉچكۅ_, _وصحة_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3e006e3,0x3f8008e5,0x00000000,0x00000000}},	//   दान_, _meiu_, --, --, 
   {{0x3f800254,0x628400b8,0x00000000,0x00000000}},	//   _leiu_, _āhop, --, --, 
   {{0x68300158,0xe8b00137,0x00000000,0x00000000}},	//   rådr, _مەلج, --, --, 
   {{0x3f8000c5,0x4bf8008f,0x93ec0073,0x96b800f3}},	//   _neiu_, ַליס, _जवळच_, _музу_, 
   {{0x6fdc08e6,0x683003cd,0x03e400f1,0x672c0327}},	//   यासं, pådr, بډلي_, żajr, 
   {{0x3f8008e7,0x8640009d,0xfce00023,0x00000000}},	//   _aeiu_, _ануж, _ነውጺ_, --, 
   {{0x3f80026c,0xd4c408e8,0x69c8010e,0x00000000}},	//   _beiu_, _تغذي, _öleň, --, 
   {{0xb4bc08e9,0xc95008c3,0x00000000,0x00000000}},	//   ेटी_, כמת_, --, --, 
   {{0xb8d008ea,0x3f80003e,0x0dc80395,0x00000000}},	//   _ཐད_, _deiu_, оуви_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c84084c,0x3f800437,0x8bc408eb,0x7a300108}},	//   куте, _feiu_, мсад, vätp, 
   {{0x25a80552,0xa3e008ec,0x200008ed,0x2cac031c}},	//   đali_, दाय_, chki_, ċed_, 
   {{0x244008ee,0x59080327,0x00000000,0x00000000}},	// [590] nóma_, _གཟུས_, --, --, 
   {{0x2fc808ef,0xf99008f0,0x00000000,0x00000000}},	//   _haag_, لبم_, --, --, 
   {{0x2fc808f1,0xd7d80490,0xa3e008f2,0x79a402e8}},	//   _kaag_, णांच, दाम_, ърте, 
   {{0x244008f3,0x2fc805e4,0xfaf001ed,0xf77008f4}},	//   kóma_, _jaag_, دثہ_, لاه_, 
   {{0x2d8008f5,0x2fc808f6,0x63ac0022,0x7ac4030d}},	//   _kehe_, _maag_, _ñani, _исре, 
   {{0x2fc808f7,0xa2cc08f8,0x6d400209,0x2d8008f9}},	//   _laag_, तिस्, ýlaw, _jehe_, 
   {{0x2d8008fa,0x6fa40574,0x290408fb,0xd46408fc}},	//   _mehe_, _काढू, _åla_, нище_, 
   {{0x2d8008fd,0x2fc80014,0x00000000,0x00000000}},	//   _lehe_, _naag_, --, --, 
   {{0x3f800254,0xa3e006e3,0xdb0c03b2,0x10a00150}},	//   _reiu_, दाब_, ídøg, қиян, 
   {{0x2d8008fe,0x27ec08ff,0x35b40276,0xc650036b}},	//   _nehe_, _hoen_, _ибур, _شفاک, 
   {{0x2fc800e8,0xb5440022,0x00000000,0x00000000}},	//   _baag_, _иҧша_, --, --, 
   {{0x27ec0900,0x2fc80901,0x5f040902,0x00000000}},	//   _joen_, _caag_, езма, --, 
   {{0x27ec0903,0x2fc80904,0x645801e2,0x2d800905}},	//   _moen_, _daag_, _iiwi, _behe_, 
   {{0x20000906,0x645802b5,0x27ec0907,0xc1e00150}},	//   shki_, _hiwi, _loen_, _شۋجي, 
   {{0x62880908,0x2fc800ad,0x2d800909,0xa2cc090a}},	//   lseo, _faag_, _dehe_, तिव्, 
   {{0x27ec090b,0x2d80090c,0x6458090d,0x2fc8090e}},	//   _noen_, _eehe_, _jiwi, _gaag_, 
   {{0x6458090f,0x62880910,0x00000000,0x00000000}},	// [5a0] _miwi, nseo, --, --, 
   {{0x2d800911,0x7f440912,0x64580913,0x62880914}},	//   _gehe_, _iziq, _liwi, iseo, 
   {{0x27ec03cb,0x2fc800e8,0xe2340023,0x00000000}},	//   _boen_, _yaag_, _ርእስና, --, 
   {{0x27ec0915,0x64580916,0x2d800295,0x25a4015d}},	//   _coen_, _niwi, _zehe_, _acll_, 
   {{0x27ec0917,0x2d8002b9,0xf984013e,0x6830003b}},	//   _doen_, _yehe_, _аҳзо, rådp, 
   {{0x27ec0295,0x64580099,0x2d8001c4,0xceb0010f}},	//   _eoen_, _aiwi, _xehe_, טיד_, 
   {{0x8cd00918,0x64580919,0xb4bc00e1,0x27ec0165}},	//   डियो, _biwi, ेटे_, _foen_, 
   {{0x27ec04c4,0x6458091a,0xb4b0007d,0xe2300344}},	//   _goen_, _ciwi, _ओही_, یکوب, 
   {{0x7ae4091b,0x6458091c,0xa2cc0882,0x2fc8091d}},	//   nxit, _diwi, तिष्, _raag_, 
   {{0x6458091e,0x27ec091f,0x2fc80920,0x7ae4004e}},	//   _eiwi, _zoen_, _saag_, ixit, 
   {{0x7f440921,0x2d8007dd,0x2fc8062c,0x244000e4}},	//   _aziq, _rehe_, _paag_, sóma_, 
   {{0x2d800922,0x64580923,0xa2cc00dc,0x24400124}},	//   _sehe_, _giwi, तिश्, póma_, 
   {{0x2d800924,0xb8ec031c,0x04400354,0xb4b0000d}},	//   _pehe_, _ྱག_, _сецн, _ओहु_, 
   {{0xa2cc0882,0x64580925,0x2fc80926,0x2ee00927}},	//   तिर्, _ziwi, _waag_, _पपीत, 
   {{0x7f440928,0x2fc80929,0x2d800156,0x6458092a}},	//   _eziq, _taag_, _vehe_, _yiwi, 
   {{0x2d80092b,0x41b00137,0x00000000,0x00000000}},	//   _wehe_, _لمۇر, --, --, 
   {{0x27ec092c,0x2d80092d,0x7ae40472,0x6d400793}},	// [5b0] _roen_, _tehe_, gxit, ülab, 
   {{0x27ec092e,0xfe70092f,0x2d800418,0xb4b000af}},	//   _soen_, _ادي_, _uehe_, _ओहू_, 
   {{0xf77004d3,0xe6100930,0x27ec0931,0x00000000}},	//   ڵان_, یشت_, _poen_, --, 
   {{0xe7180597,0x6d440932,0x00000000,0x00000000}},	//   ويات_, _izha, --, --, 
   {{0xf7700933,0x64580934,0x27ec030a,0xc4a80150}},	//   صان_, _riwi, _voen_, _ﺴﻴﺘﻌ, 
   {{0x64580935,0x6aac00ec,0x27ec01c7,0x2bc80118}},	//   _siwi, mtaf, _woen_, ाएका, 
   {{0x27ec0936,0xf98802dd,0x628800a3,0x64580937}},	//   _toen_, _سەنۋ_, wseo, _piwi, 
   {{0xc44400dd,0x64580309,0x6aac022f,0x62880938}},	//   ریشن_, _qiwi, otaf, tseo, 
   {{0x64580939,0x62880354,0x764801d5,0x52800830}},	//   _viwi, useo, _fhdy, агыб, 
   {{0x6458093a,0x6288093b,0x67280327,0x6d4405c7}},	//   _wiwi, rseo, _ixej, _ozha, 
   {{0xa3e0093c,0x3494093d,0x67280327,0x6458093e}},	//   दाद_, _бахр, _hxej, _tiwi, 
   {{0xbbe007f7,0xbec8010b,0x6288093f,0xe31400f3}},	//   _पचेक, еңиз_, pseo, _имењ, 
   {{0x6d440940,0x7648049b,0x67280327,0x7ae40941}},	//   _azha, _yhdy, _jxej, xxit, 
   {{0x67280327,0xdb14010e,0x00000000,0x00000000}},	//   _mxej, gdyý, --, --, 
   {{0x6aac0942,0x5fa80073,0xc22001d3,0x00000000}},	//   etaf, _कापल, _لکھو, --, 
   {{0x6d440943,0x7ae401c0,0x6aac041e,0x9f04004b}},	//   _dzha, txit, ftaf, _لوبو, 
   {{0xdfd0066d,0x7f440944,0x6d44030a,0x6aac005c}},	// [5c0] _ميں_, _uziq, _ezha, gtaf, 
   {{0x8a000945,0x6d400793,0x7ae40946,0x00000000}},	//   азуе, ülac, rxit, --, 
   {{0x7e640947,0x6d44067c,0x18a40948,0x6aac0949}},	//   _huip, _gzha, таем, ataf, 
   {{0x7ae4094a,0x6600094b,0x600408a5,0x0d2000db}},	//   pxit, _allk, _dómg, _түсү, 
   {{0xc7a0094c,0x07a0094d,0x6aac01f5,0x68e401ab}},	//   ричк, рачн, ctaf, axhd, 
   {{0x7e640421,0x8640094e,0x00000000,0x00000000}},	//   _muip, анчж, --, --, 
   {{0x7e640926,0x48e0013e,0x9854094f,0x1cc80327}},	//   _luip, _корв, _аташ, _ླགས_, 
   {{0xd1e002d3,0x44f00145,0xccf000d9,0x8cd00950}},	//   ምዓት_, شسىز, שכה_, डितो, 
   {{0x7e640951,0x60140153,0x98a80210,0x00000000}},	//   _nuip, ešmo, _rybę_, --, 
   {{0xca340952,0x46440022,0x5064004e,0x00000000}},	//   ﻗﻘﺎ_, _азун_, ктма, --, 
   {{0x09f4011a,0x00000000,0x00000000,0x00000000}},	//   דמים_, --, --, --, 
   {{0xc0580953,0x80a00954,0x00000000,0x00000000}},	//   кія_, _कमरे, --, --, 
   {{0x7e640955,0x80ac04c5,0x66000240,0x67280327}},	//   _cuip, টিগ্, _yllk, _xxej, 
   {{0x273007ae,0xfd540055,0xd1740124,0x6e440956}},	//   ỡng_, _hreṣ, _рыды, انسم, 
   {{0xdeb0005e,0xab940957,0xfe240958,0xb4b00959}},	//   _құры, ливі, рьян, _ओहो_, 
   {{0x6aac095a,0x63ac095b,0x7e64095c,0x6d440219}},	//   ttaf, _ñant, _fuip, _vzha, 
   {{0x600403b2,0xdcec00e2,0xfb840006,0x7cfc007c}},	// [5d0] _dómd, fabē, рысн, tärö, 
   {{0x6aac095d,0x49b8095e,0xa4cc0219,0x00000000}},	//   rtaf, بارد_, ščič, --, 
   {{0x7e6401a4,0x67d40261,0x5fa8095f,0x00000000}},	//   _zuip, ложу, _कामल, --, 
   {{0x6e340960,0x6aac01a8,0x9e9400db,0x87700961}},	//   lozb, ptaf, _شاۋچ, рғаш, 
   {{0x3a840962,0xa3e002ab,0x7cfc005b,0x24500118}},	//   _высв, दास_, pärö, _mšmt_, 
   {{0xd1240963,0xc5e804c5,0x2a680964,0x600403b2}},	//   _هم_, কসভা_, mqab_, _tómg, 
   {{0xc7c40965,0x64b40966,0x6004032e,0x00000000}},	//   _исаи, احتر, _hóme, --, 
   {{0x6e3401c4,0x600402d2,0x00000000,0x00000000}},	//   hozb, _kóme, --, --, 
   {{0xca340952,0x316c0175,0xdb14007f,0xdcfc00d7}},	//   ﻗﺘﺎ_, fcdz_, ldyò, _repč, 
   {{0xa0740967,0x6e3408a4,0x66000968,0x60e80969}},	//   лымш, jozb, _ullk, емом_, 
   {{0x7e64096a,0x2a68022e,0x902000ec,0x00000000}},	//   _suip, hqab_, ڍڙيو, --, 
   {{0x7e64096b,0x00000000,0x00000000,0x00000000}},	//   _puip, --, --, --, 
   {{0x443c096c,0xd24c096d,0x7e64096e,0x00000000}},	//   mlu_, تنی_, _quip, --, 
   {{0xdca4096f,0x1ba801d3,0x91e00798,0xa0a4004e}},	//   лаги, کاسٹ_, _гоше, _бакд, 
   {{0x443c0970,0x63ac0309,0x5bb4039b,0xf1a80133}},	//   olu_, _ñans, лсаф, _شاوه_, 
   {{0x443c0971,0x7e640972,0x00000000,0x00000000}},	//   nlu_, _tuip, --, --, 
   {{0x8c400973,0x9e5803a6,0x443c0974,0x8eb00975}},	// [5e0] сете, _проф_, ilu_, _هميش, 
   {{0x443c0976,0x7a3003fa,0x998400e3,0x600402d2}},	//   hlu_, lätz, الاو, _dóme, 
   {{0x443c0977,0x9d380134,0x00000000,0x00000000}},	//   klu_, _ɔyɛɛ_, --, --, 
   {{0x443c0978,0xda640979,0x2a680218,0x236c0010}},	//   jlu_, _ماسي, bqab_, jcej_, 
   {{0x6004097a,0x7414097b,0x00000000,0x00000000}},	//   _góme, یوتا, --, --, 
   {{0x443c097c,0x7c24084c,0x7a30097d,0xd1d402d3}},	//   elu_, lnir, hätz, ራቤት_, 
   {{0x295406bb,0x5fa80574,0x443c097e,0x7c24097f}},	//   _вътр, _काढल, flu_, onir, 
   {{0x7c240980,0x443c0981,0x73d80982,0xdb1400a2}},	//   nnir, glu_, тдир_, ldyñ, 
   {{0x7c240983,0x51840984,0xca3400d1,0x70540345}},	//   inir, луна, ﺗﯘﺵ_, ینخا, 
   {{0x443c0985,0x236c00d0,0x29240986,0x60040241}},	//   alu_, acej_, špaš_, _nómb, 
   {{0x443c0987,0x7c240988,0x52380023,0x98a801ef}},	//   blu_, knir, _ከባቢኦ, _rybě_, 
   {{0x7c240989,0xb4e0098a,0x2a6801a9,0x0440030d}},	//   jnir, दमी_, yqab_, _лехн, 
   {{0xa3e0098b,0x4ea4098c,0xc0e401d3,0xdb2001e1}},	//   दार_, ырна, نفین_, _àtèy, 
   {{0x2fcc098d,0x2a680218,0xae9401e1,0x7c24098e}},	//   žeg_, vqab_, _fẹnu, enir, 
   {{0x02140302,0x2a68098f,0x6e3405d6,0xc0e000ea}},	//   _תחום_, wqab_, rozb, _гојк, 
   {{0xab740990,0x6b740991,0x0a680992,0x2d84033f}},	//   ргаш, рлау, ержи_, źle_, 
   {{0x7a3002f6,0x7c28004a,0x6a140993,0x00000000}},	// [5f0] läty, édra, амау, --, 
   {{0x443c0994,0x7c240995,0x236c0007,0x6fdc05d7}},	//   zlu_, anir, zcej_, याकं, 
   {{0xdd90040d,0x443c0996,0x7a3002f6,0xfbd00014}},	//   _بوپ_, ylu_, näty, _کتٍ_, 
   {{0x443c0997,0x78bc0998,0x60040789,0x7c240999}},	//   xlu_, _dprv, _tóme, cnir, 
   {{0x443c0978,0x66e4099a,0x2a680327,0x7a300108}},	//   vlu_, рола, qqab_, häty, 
   {{0x6abc02d0,0xd5ac0014,0x7a300108,0x443c099b}},	//   _ipsf, ِہٕ_, käty, wlu_, 
   {{0x26c000d0,0xfdf802e4,0x78b80419,0x7a3001f4}},	//   ňho_, רצות_, čavá, jäty, 
   {{0x443c099c,0x7a30023a,0xa934014b,0x00000000}},	//   ulu_, däty, _беҳш, --, 
   {{0x443c099d,0xa204099e,0x13e400fd,0x36d4010a}},	//   rlu_, ипид, рмый_, _лотр, 
   {{0xd24c099f,0x7c240083,0xe1f809a0,0x7a3004e6}},	//   وني_, znir, тго_, wätz, 
   {{0x443c09a1,0x7c2409a2,0x60040162,0x9f4001f4}},	//   plu_, ynir, _rómb, nkkö_, 
   {{0xdcfc005f,0x6abc03ac,0x443c09a3,0x00000000}},	//   _nepā, _opsf, qlu_, --, 
   {{0x63ac0054,0xf38c008f,0x21740137,0x7a30002f}},	//   _ñanq, _טראָ, _куйр, rätz, 
   {{0x7a3009a4,0xdd90036b,0x44c401d3,0xae940241}},	//   sätz, غوز_, _kő_, _tẹnu, 
   {{0xd24c00aa,0xa0a409a5,0x6abc03ac,0xa2cc00dc}},	//   _تنو_, _тайд, _apsf, तिक्, 
   {{0x78bc0158,0xdcfc00ef,0xdca401d5,0xd00c09a6}},	//   _rprv, _cepā, лаҳи, _يلو_, 
   {{0x7c2409a7,0x999c063f,0x78bc09a8,0x600409a9}},	// [600] rnir, _ótū_, _sprv, _tómb, 
   {{0x99740046,0x7c2409aa,0xa3e009ab,0x00000000}},	//   руаш, snir, दाँ_, --, 
   {{0x44c400dd,0x6abc02d0,0x1d0809ac,0xee08008f}},	//   _nő_, _epsf, _рени_, _תּפֿ, 
   {{0xb5fc0327,0xdddc0100,0x7c240113,0x00000000}},	//   _miġe, _sipň, qnir, --, 
   {{0x7bc40276,0x1dc801ad,0x8c1800d9,0xdb140139}},	//   meiu, ाजपत, _יוטי, deyç, 
   {{0x7bc409ad,0x75d4009f,0x44c400e5,0x00000000}},	//   leiu, صيبا, _bő_, --, 
   {{0xb4e009ae,0xb5fc0135,0xa3e000cd,0x7a3000fd}},	//   दमे_, _niġe, दां_, dätx, 
   {{0xc7a009af,0x07a009b0,0x75f400db,0xb6c40209}},	//   _миск, _масн, _vàzq, _гөкд, 
   {{0x47d000ec,0x836001b9,0x0ca00037,0xa2cc00cd}},	//   _بيقر, زگنل, _ओम्म, तिग्, 
   {{0x44c400dd,0xe87400db,0x7bc409b1,0x7a300108}},	//   _fő_, _ئچەگ, heiu, täty, 
   {{0x69d8008f,0x25f409b2,0xd6b4030d,0xdb140432}},	//   אַרו, ्सरी_, _гiум, leyä, 
   {{0x24f409b3,0xb5fc025c,0xa3e009b4,0x63ac02d1}},	//   _учур, _diġe, दाः_, _ñanp, 
   {{0xc7b0025f,0x7bc409b5,0x9f500241,0x7a30005b}},	//   חבר_, deiu, _joyè_, säty, 
   {{0x82300836,0x9f400108,0x90e4009f,0x7a3001f4}},	//   _وروا, ykkö_, _نسبن, päty, 
   {{0x7bc40270,0x09cc015b,0x00000000,0x00000000}},	//   feiu, রামা, --, --, 
   {{0xb5fc0003,0x110400ec,0x00000000,0x00000000}},	//   _jiġb, _مٺڙي_, --, --, 
   {{0x201009b6,0xb5fc0003,0x3c5800a8,0xdcec0153}},	// [610] ëzie_, _miġb, ритэ_, kabė, 
   {{0x2b84004d,0x00000000,0x00000000,0x00000000}},	//   ặc_, --, --, --, 
   {{0xc7c409b7,0x7bc40393,0x600409b8,0x6cd400cf}},	//   исди, beiu, _hóma, _اقجا, 
   {{0x7bc40276,0xf7f404fb,0x600409b9,0xb5fc025c}},	//   ceiu, يسند, _kóma, _niġb, 
   {{0x6b8c09ba,0x09cc00bd,0x25f409bb,0xe9a80214}},	//   maag, রাবা, ्सली_, _مگان_, 
   {{0x6b8c09bc,0x80ac09bd,0x63b80042,0x48740244}},	//   laag, য়িত্, _sbwn, _ندرس, 
   {{0x69c409be,0x247c0020,0xe380001f,0x600403b2}},	//   mehe, _ጥቅምት_, _የቀረበ_, _lóma, 
   {{0x6b8c09bf,0x69c409c0,0xf7700131,0xb5fc025c}},	//   naag, lehe, _ياق_, _riġe, 
   {{0x216809c1,0x65940276,0x600409c2,0x6b8c0194}},	//   липи_, _газу, _nóma, iaag, 
   {{0xa20409c3,0x69c409c4,0x26cc0395,0x6b8c09c5}},	//   спод, nehe, _iseo_, haag, 
   {{0x6b8c09c6,0x629c0122,0x69c405ac,0x6d40000d}},	//   kaag, ásob, iehe, ülal, 
   {{0x6b8c0549,0xdcfc054e,0x24400022,0x92c400fe}},	//   jaag, _lepă, kómi_, _উপৰ_, 
   {{0x69c409c7,0x6b8c09c8,0x60040077,0xe29809c9}},	//   kehe, daag, _cóma, _сал_, 
   {{0x63a809ca,0x69c409cb,0x600409cc,0x26cc0109}},	//   lgen, jehe, _dóma, _mseo_, 
   {{0x63a809cd,0x6b8c09ce,0x7bc40356,0x6c74009d}},	//   ogen, faag, teiu, жуух, 
   {{0x63a809cf,0x6b8c09d0,0x60140006,0x26cc0129}},	//   ngen, gaag, kšmi, _oseo_, 
   {{0x63a809d1,0x69c403d1,0x600409d2,0x7bc409d3}},	// [620] igen, fehe, _góma, reiu, 
   {{0x69c409d4,0x63a80369,0x200009d5,0x9f5006af}},	//   gehe, hgen, lkki_, _noyé_, 
   {{0x63a809d6,0x395c049f,0x26cc09d7,0xdcfc0276}},	//   kgen, ävs_, _aseo_, _depă, 
   {{0x6b8c074d,0x2000049b,0x63a809d8,0xa6e8004d}},	//   caag, nkki_, jgen, _trự, 
   {{0xa3e009d9,0x69c409da,0x9f500085,0xb4e00882}},	//   दाई_, behe, _boyé_, दम्_, 
   {{0x63a809db,0x473002bf,0xb6940092,0x00000000}},	//   egen, чніс, _ኃይለኛ_, --, 
   {{0x63a809dc,0x26cc00df,0xddd40055,0x00000000}},	//   fgen, _eseo_, _atyū, --, 
   {{0x6814006d,0x63a809dd,0xc87c0724,0xb27409de}},	//   ządz, ggen, ışta_, олиш, 
   {{0xb1c80131,0xdcec00c0,0x00000000,0x00000000}},	//   иңда_, pabė, --, --, 
   {{0x6b8c09df,0x600409e0,0x20000108,0xa2cc0303}},	//   zaag, _róma, ekki_, तिज्, 
   {{0x6b8c09e1,0xb5fc0135,0xd24c00ec,0x600408a5}},	//   yaag, _tiġb, ونڊ_, _sóma, 
   {{0x63a809e2,0xc4d0011a,0x69c401c7,0x6b8c058a}},	//   cgen, _מגע_, zehe, xaag, 
   {{0x69c409e3,0x934400ee,0x03a00107,0x5fa8044b}},	//   yehe, _унде, _хичо, _कारल, 
   {{0x6b8c09e4,0x387801ab,0x15f800bc,0x20000108}},	//   waag, _otrr_, ्सिर_, akki_, 
   {{0x6b8c09e5,0x69c409e6,0x00000000,0x00000000}},	//   taag, vehe, --, --, 
   {{0x69c409e7,0x600409e8,0x6814012d,0x00000000}},	//   wehe, _tóma, sądz, --, 
   {{0x69c409e9,0x15f8012c,0xdb2001e1,0x00000000}},	// [630] tehe, ्सार_, _àtìy, --, 
   {{0x26cc0770,0x6b8c09ea,0x63a809eb,0x00000000}},	//   _rseo_, saag, zgen, --, 
   {{0x63a809ec,0x094809ed,0x6b8c09ee,0x69c409ef}},	//   ygen, учаи_, paag, rehe, 
   {{0x69c409f0,0x600400d2,0x6b8c09f1,0x267800a8}},	//   sehe, _lómn, qaag, аскэ_, 
   {{0x69c4052f,0xefd00023,0xe73800ea,0x00000000}},	//   pehe, _ብኢድ_, јел_, --, 
   {{0x69c4009a,0x2a7800ef,0x41d40210,0x00000000}},	//   qehe, _itsb_, _भोंस, --, 
   {{0x63a809f2,0x200009f3,0x60300421,0xa3e809f4}},	//   tgen, ykki_, lāme, идка_, 
   {{0x63a809f5,0x26cc09f6,0xe298035b,0x247400b8}},	//   ugen, _tseo_, ааи_, _nāme_, 
   {{0x232809f7,0xe29809f8,0xa02401f4,0x00000000}},	//   ропи_, шап_, htöä, --, 
   {{0x63a809f9,0x00000000,0x00000000,0x00000000}},	//   sgen, --, --, --, 
   {{0xd12c01ed,0x600401a8,0x00000000,0x00000000}},	//   ہمی_, _dómn, --, --, 
   {{0x3494009d,0x20000108,0x00000000,0x00000000}},	//   _хацр, ukki_, --, --, 
   {{0x2000049b,0xe2980114,0x00000000,0x00000000}},	//   rkki_, _ђак_, --, --, 
   {{0x320c0042,0x00000000,0x00000000,0x00000000}},	//   chdy_, --, --, --, 
   {{0x2120002f,0x00000000,0x00000000,0x00000000}},	//   _ähh_, --, --, --, 
   {{0x1c440111,0xcb6402e8,0x63bc01d5,0x00000000}},	//   інам, жате_, еsni, --, 
   {{0x1988013e,0x8af40213,0x00000000,0x00000000}},	// [640] ибаи_, şənl, --, --, 
   {{0x7f440944,0xa2a009fa,0x00000000,0x00000000}},	//   _iyiq, _खिन्, --, --, 
   {{0x2474002b,0xd87400db,0x00000000,0x00000000}},	//   _yāme_, زااب, --, --, 
   {{0xefd00023,0x00000000,0x00000000,0x00000000}},	//   _ብኢደ_, --, --, --, 
   {{0xdddc01af,0xa3cc00af,0x24400419,0x60300055}},	//   _lipō, शजन_, nómu_, cāme, 
   {{0xd49809fb,0x5d78010f,0x1dc800cd,0x15b809fc}},	//   ари_, באַק, ाजित, рыды_, 
   {{0x1db009fd,0x999800b0,0xc31400cc,0xc924009d}},	//   _जानत, hopū_, _ডুলি_, _дорж_, 
   {{0x7f440921,0x999802b5,0xe3b800e5,0x04500633}},	//   _oyiq, kopū_, gfű_, وئيد, 
   {{0x2488071b,0x1dc8078a,0x2474002b,0x320c015d}},	//   ćama_, ाजात, _rāme_, thdy_, 
   {{0x24740093,0x6ed80118,0x00000000,0x00000000}},	//   _sāme_, मिसु, --, --, 
   {{0x104809fe,0xa3b4069f,0x600409ff,0x7f440a00}},	//   иями_, _चॉक_, _cómo, _ayiq, 
   {{0x320c0a01,0x15f80073,0x00000000,0x00000000}},	//   shdy_, ्सवर_, --, --, 
   {{0x247400cd,0x20100200,0x00000000,0x00000000}},	//   _vāme_, ëzia_, --, --, 
   {{0x60040077,0xa02401f4,0x00000000,0x00000000}},	//   _fómo, ttöä, --, --, 
   {{0x7f4401f0,0x24740a02,0x31740210,0xcf9801ee}},	//   _eyiq, _tāme_, ądzą_, _кјп_, 
   {{0x80c40210,0xa2a00709,0x00000000,0x00000000}},	//   ़बरे, _खिम्, --, --, 
   {{0x09cc015b,0xa0240108,0x00000000,0x00000000}},	// [650] রাসা, stöä, --, --, 
   {{0x1db00882,0x8d8802dd,0x00000000,0x00000000}},	//   _जायत, _ﺒﺩﺃﺕ_, --, --, 
   {{0x2d900a03,0x6030005f,0x00000000,0x00000000}},	//   maze_, sāme, --, --, 
   {{0x2d9005ce,0xb5fc0327,0x7b0401d3,0xdcd8010f}},	//   laze_, _riġa, ötté, _פֿיש, 
   {{0xb5fc0003,0x9aa401af,0x00000000,0x00000000}},	//   _siġa, _нурһ, --, --, 
   {{0x2d900a04,0xb5fc0327,0xdc540133,0x00000000}},	//   naze_, _piġa, _ورێک, --, 
   {{0x69d40a05,0x7e600268,0xf8b4084c,0x92a80154}},	//   _iaze, ìmpi, _обрэ, খবো_, 
   {{0x6d440a06,0x2d900a07,0x60040030,0x00000000}},	//   _myha, haze_, _rómo, --, 
   {{0x26d804d4,0xdddc007f,0x29000a08,0x6fa401f9}},	//   _éso_, _sipō, lyha_, _काजू, 
   {{0x69d40a09,0x659401c0,0x23280116,0x35f80a0a}},	//   _jaze, _хажу, _қоли_, _ورلد_, 
   {{0x69d40a0b,0x6d440a0c,0x290001ed,0x2d9004ba}},	//   _maze, _nyha, nyha_, daze_, 
   {{0x69d40a0d,0x31700032,0x4ab8000d,0x00000000}},	//   _laze, нғәт, _उहंव, --, 
   {{0x442c017a,0x21680a0e,0x6d440a0f,0xb5fc031c}},	//   _ijg_, _лили_, _ayha, _miġn, 
   {{0x2d900a10,0x60040085,0x999802b5,0xb2840006}},	//   gaze_, _tómo, ropū_, _цыцк, 
   {{0x290000c7,0xacf40014,0x00000000,0x00000000}},	//   jyha_, وسِت, --, --, 
   {{0x9f840108,0xa3e001f9,0x00000000,0x00000000}},	//   _эгид, दाट_, --, --, 
   {{0x7f440944,0x6d440857,0xaae40a11,0x9f040a12}},	// [660] _uyiq, _eyha, وسكو, _رودو, 
   {{0x4a400a13,0x2d900a14,0x442c007f,0xed580107}},	//   енув, caze_, _ljg_, соӣ_, 
   {{0x9d440a15,0x290001d3,0x00000000,0x00000000}},	//   _хенд, gyha_, --, --, 
   {{0x69d4011c,0x00000000,0x00000000,0x00000000}},	//   _eaze, --, --, --, 
   {{0x69d40a16,0xb4e40a17,0x00000000,0x00000000}},	//   _faze, कम्प_, --, --, 
   {{0x69d40a18,0x442c007c,0x00000000,0x00000000}},	//   _gaze, _ajg_, --, --, 
   {{0x2d8401ed,0x00000000,0x00000000,0x00000000}},	//   űleg_, --, --, --, 
   {{0x69d40a19,0x2d900a1a,0x442c01a4,0x799c02d0}},	//   _zaze, zaze_, _cjg_, _hdrw, 
   {{0x2d900a1b,0xa3e00a1c,0x69d40a1d,0x32540139}},	//   yaze_, दाज_, _yaze, мвир, 
   {{0x8af80a1e,0x2d90014b,0x442c072b,0x69d40166}},	//   צהיי, xaze_, _ejg_, _xaze, 
   {{0xd54801d9,0x442c0076,0x600403f2,0x2d90013a}},	//   _الاو_, _fjg_, _tóml, vaze_, 
   {{0x2d900a1f,0x38a00311,0x4dc8005e,0x9f5000a2}},	//   waze_, mără_, ﻪﺗﯩﻨ, _alyñ_, 
   {{0x2d900a20,0x93440a21,0x91e401a9,0x00000000}},	//   taze_, _энде, _ноде, --, 
   {{0x6d44035b,0x1db00073,0x00000000,0x00000000}},	//   _pyha, _जाणत, --, --, 
   {{0x69d40a22,0xc1b80302,0x38a00276,0xa3e00490}},	//   _raze, _המוש, nără_, दाच_, 
   {{0x69d40a23,0x2d900a24,0x799c0585,0x6d4402fb}},	//   _saze, saze_, _adrw, _vyha, 
   {{0x69d40a25,0x24740a26,0xfb340a27,0xed5800ee}},	// [670] _paze, _māma_, ентэ, соң_, 
   {{0x799c03ac,0x3ea400d0,0x5e680050,0x69d403e3}},	//   _cdrw, ámte_, _گٔیہ_, _qaze, 
   {{0x799c0368,0x7e44030d,0x3d2005ac,0x00000000}},	//   _ddrw, _яхъе, _মুঠ্_, --, 
   {{0x24740a28,0x69d40a29,0x29000a2a,0x8d8400f2}},	//   _nāma_, _waze, ryha_, _بشکن, 
   {{0x60300a2b,0xd7ec0a2c,0x69d40a2d,0x799c02d0}},	//   nāma, شكو_, _taze, _fdrw, 
   {{0x68e001ed,0x7d080194,0x2900035b,0x2120010b}},	//   _áldo, ødsg, pyha_, _ýhhg_, 
   {{0x442c0a2e,0x2488098d,0x60300882,0xfbd00133}},	//   _pjg_, ćamo_, hāma, _شتێ_, 
   {{0x60300882,0xa2a007b7,0x55700166,0xd0740092}},	//   kāma, _खिद्, нгәт, _አሰራሩ_, 
   {{0x7c280077,0x25f401ad,0x24740a2f,0x00000000}},	//   édri, _एचपी_, _dāma_, --, 
   {{0x85b801d9,0x60300a30,0x38a00311,0xa3b00864}},	//   _دارس_, dāma, bără_, ञ्ज_, 
   {{0x9fc80a31,0x6b9c03ac,0x38a00356,0x12c801ec}},	//   огна_, _odsg, cără_, _ﻓﻴﻜﻭ, 
   {{0x60300421,0xdbf00118,0x00000000,0x00000000}},	//   fāma, třís, --, --, 
   {{0x64480a32,0x443c0a33,0x9440014d,0x00000000}},	//   mlei, mou_, _جھون, --, 
   {{0x443c0a34,0x00000000,0x00000000,0x00000000}},	//   lou_, --, --, --, 
   {{0x64480a35,0x1d080a36,0xe0d40006,0x247400b8}},	//   olei, цеви_, _цюль, _yāma_, 
   {{0x64480a37,0x443c0a38,0xa3b000dc,0xdbf00118}},	//   nlei, nou_, ञ्च_, přís, 
   {{0x64480a39,0x443c0a3a,0x600400d2,0x8c400a3b}},	// [680] ilei, iou_, _lómk, тете, 
   {{0x64480a3c,0x443c0a3d,0xeb540447,0x3e740108}},	//   hlei, hou_, رىلگ, _iät_, 
   {{0x64480a3e,0x443c0a3f,0x3e740a40,0xd7f8084c}},	//   klei, kou_, _hät_, жул_, 
   {{0x443c0a41,0x64480369,0x57480a42,0x3e740a43}},	//   jou_, jlei, озем_, _kät_, 
   {{0x443c0a44,0x7c240a45,0x64480a46,0x629c01ed}},	//   dou_, miir, dlei, ásol, 
   {{0x64480a47,0x3e740a48,0x7c240a49,0x443c0165}},	//   elei, _mät_, liir, eou_, 
   {{0x3e7401e6,0x94a80a4a,0xd94403f6,0x6d40025c}},	//   _lät_, ітка_, _цеви, żlav, 
   {{0x64480a4b,0x443c0a4c,0x7c240a4d,0x60300882}},	//   glei, gou_, niir, yāma, 
   {{0x3e7401e6,0xcd4c0092,0x247400cd,0x00000000}},	//   _nät_, _በድንገ, _vāma_, --, 
   {{0x7c240a4e,0x64480a4f,0x38a00356,0x00000000}},	//   hiir, alei, pără_, --, 
   {{0x64480a50,0x7c240a51,0x6fb40a52,0x93140451}},	//   blei, kiir, ىمدا, _ڪوشش, 
   {{0x443c0a53,0x60300a54,0x7c240a55,0x3e740139}},	//   cou_, tāma, jiir, _bät_, 
   {{0x7c240a56,0x6b9c01ab,0x25f40073,0x69c00139}},	//   diir, _rdsg, ्सची_, _öleg, 
   {{0x60300a2b,0x3e740793,0x14c00490,0x600400ae}},	//   rāma, _dät_, _शहाण, _lómh, 
   {{0x7c240a57,0x603000dc,0xb5fc0135,0x00000000}},	//   fiir, sāma, _riġl, --, 
   {{0x7df80166,0x7c240a58,0x09a40a59,0x09c40a5a}},	//   _aşsı, giir, खल्य, रज्य, 
   {{0xfc6402e8,0xaa540a5b,0x00000000,0x00000000}},	// [690] търн, еваш, --, --, 
   {{0x443c0a5c,0x7c240083,0x64480a5d,0xa2a000af}},	//   zou_, aiir, zlei, _खिस्, 
   {{0x443c0a5e,0x7c240a5f,0x64480a60,0x8ca002dd}},	//   you_, biir, ylei, _جەزو, 
   {{0x27e80a61,0x443c0a62,0x7c240a63,0x7d080a64}},	//   ñan_, xou_, ciir, ødse, 
   {{0x443c0a65,0x64480660,0x65c40064,0x7c28067c}},	//   vou_, vlei, ебла, èdre, 
   {{0x443c0a66,0x64480a67,0x6aac0a68,0x19e40327}},	//   wou_, wlei, muaf, སྐྱབ, 
   {{0x443c0a69,0x60040491,0x64480a6a,0xe3b00597}},	//   tou_, _fómh, tlei, هرة_, 
   {{0x37a80137,0x443c0a6b,0x00000000,0x00000000}},	//   _отун_, uou_, --, --, 
   {{0x64480a6c,0x6aac0a6d,0x20100023,0xb5fc0003}},	//   rlei, nuaf, ëzim_, _miġj, 
   {{0x443c0a6e,0xe1f00491,0x7c240a6f,0xb6100882}},	//   sou_, اسة_, ziir, āṣit, 
   {{0x60240a70,0x64480a71,0x443c0a72,0x6aac0418}},	//   една, plei, pou_, huaf, 
   {{0x600400d2,0x443c0a73,0x6aac0a74,0x64480007}},	//   _kómi, qou_, kuaf, qlei, 
   {{0x7c240a75,0x4f040a76,0x2474002b,0x21a4022e}},	//   viir, енян_, _kāmo_, _зилм, 
   {{0x2c7404ce,0xdd900a77,0x69c00a78,0x7c240a79}},	//   _båd_, طور_, र्मी, wiir, 
   {{0x7c240a7a,0xd00c0a7b,0x3e740139,0x91b40a7c}},	//   tiir, _گلي_, _wät_, _נפקא_, 
   {{0x3e740a7d,0x6aac0a7e,0xb5fc025c,0x2c740a7f}},	//   _tät_, fuaf, _riġm, _dåd_, 
   {{0x60040a80,0x7c240750,0xd00c082e,0x1f6402bf}},	// [6a0] _nómi, riir, _دلي_, _яким, 
   {{0x7c240a81,0x0b400372,0xa3b0033f,0x600401e7}},	//   siir, унун, फ़्त_, _sómh, 
   {{0x7c240a82,0x1be80a83,0xcdb4011a,0xdb1403b9}},	//   piir, _едни_, _אפיה_, leyü, 
   {{0x60040085,0x95f803ce,0x2c0001e0,0x7c240a84}},	//   _bómi, ्स्ट_, _күсм, qiir, 
   {{0x600409ff,0xdb04002f,0x6d400003,0xc8480240}},	//   _cómi, _abkö, żlat, _ዝኣምን, 
   {{0x20100a85,0x60040a86,0x9998012d,0x0f34010f}},	//   ëzij_, _dómi, żyły_, ערסט_, 
   {{0xe3d8009e,0x6fb00073,0x60040a87,0x00000000}},	//   থানব, _झालं, _tómh, --, 
   {{0xccf006a9,0xb5fc0327,0x0440041b,0x60300a88}},	//   רכה_, _xiġj, лејн, dāmo, 
   {{0x07b4007b,0x600402d2,0x52240a89,0xc7a00229}},	//   _سهلة_, _gómi, ефна, _щитк, 
   {{0x872000d4,0x00000000,0x00000000,0x00000000}},	//   _смуж, --, --, --, 
   {{0x313400fd,0x00000000,0x00000000,0x00000000}},	//   тенр, --, --, --, 
   {{0x2c7400ed,0x00000000,0x00000000,0x00000000}},	//   _råd_, --, --, --, 
   {{0x24740055,0x69c00a8a,0x00000000,0x00000000}},	//   _yāmo_, र्डी, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa4a401e1,0x00000000,0x00000000,0x00000000}},	//   _ibòí, --, --, --, 
   {{0x59c406ab,0x6aac0a8b,0xdfd005d9,0x2c7400b5}},	//   _रॉबर, tuaf, _نيٺ_, _våd_, 
   {{0x7b740597,0x314c02d3,0x49c8005b,0x88b400fe}},	// [6b0] اطفا, _ማሕበር, зуем_, ীয়াক, 
   {{0xd8e00327,0x6d400a8c,0x3cec00d7,0x00000000}},	//   སའཕྲ, ülas, ťdva_, --, 
   {{0x48a80a8d,0x6aac0134,0xac18094f,0x247400dc}},	//   ятам_, suaf, _жону_, _rāmo_, 
   {{0x629c01ed,0x6aac0618,0xf7700a8e,0xc8480023}},	//   ások, puaf, ماه_, _ዝኣመን, 
   {{0x6aac0395,0xc6680a8f,0x00000000,0x00000000}},	//   quaf, чшее_, --, --, 
   {{0x60040a90,0xa5640a91,0x64a40a92,0xd7000a93}},	//   _vómi, نگان, вака, рзши, 
   {{0x69c00a94,0x94d001f7,0xe89401c6,0x24740055}},	//   र्णी, ليوش, _шавь, _vāmo_, 
   {{0x60040a95,0x69c003e0,0x86b00150,0x00000000}},	//   _tómi, _öleb, _бәкі, --, 
   {{0x27ec0a96,0x69c00a97,0x64b401ef,0x00000000}},	//   _inen_, र्थी, dřiš, --, 
   {{0x603000b0,0x09cc0154,0x00000000,0x00000000}},	//   tāmo, রাকা, --, --, 
   {{0xba04001f,0xf484033a,0x21680120,0x00000000}},	//   _ግድ_, _бучн, ќини_, --, 
   {{0xe1f00a98,0x69c00a99,0x00000000,0x00000000}},	//   اسک_, र्ती, --, --, 
   {{0xf58400db,0xb9f80092,0x00000000,0x00000000}},	//   _ششەپ, _ዘፀ_, --, --, 
   {{0x1cdc031c,0x603000b0,0xfe78009d,0x614400fb}},	//   _རླུ_, pāmo, _үүн_, _иела, 
   {{0x64580a9a,0x27ec0a9b,0xaec002dd,0x5bb400c0}},	//   _khwi, _onen_, _құрл, ксаф, 
   {{0xdb140100,0x27ec0a9c,0x00000000,0x00000000}},	//   deyò, _nnen_, --, --, 
   {{0xdb0c0a9d,0x19940114,0xda640a9e,0x1b4800d8}},	// [6c0] _öküz, вјер, ناطي, фзаи_, 
   {{0x204c0020,0x27ec0a9f,0x00000000,0x00000000}},	//   _ማህበረ, _anen_, --, --, 
   {{0x6458016b,0x35c4033f,0x05100154,0x00000000}},	//   _ohwi, ल्फ़, িপুর_, --, 
   {{0x645802c4,0x8c400724,0x09cc015b,0x661c0006}},	//   _nhwi, äşte, রাগা, _įska, 
   {{0xc6d00aa0,0x00000000,0x00000000,0x00000000}},	//   لتوت, --, --, --, 
   {{0x27ec0aa1,0x997400db,0x69c00aa2,0x00000000}},	//   _enen_, _шумш, र्दी, --, 
   {{0xb5fc003d,0xaad401e1,0x00000000,0x00000000}},	//   _jiġi, _òlòó_, --, --, 
   {{0x64580aa3,0x38bc0aa4,0x27ec0295,0x983402d5}},	//   _chwi, mír_, _gnen_, _рэгі, 
   {{0x51840aa5,0xf5b400dd,0xb5fc003d,0x38bc03da}},	//   куна, _مشاھ, _liġi, lír_, 
   {{0xf6640137,0x53300022,0x00000000,0x00000000}},	//   _сезү, леқт, --, --, 
   {{0xb5fc0327,0x60040174,0x76480118,0x38bc0aa6}},	//   _niġi, _lómu, _ikdy, nír_, 
   {{0x53440aa7,0x03a00aa8,0x00000000,0x00000000}},	//   _ихла, _вицо, --, --, 
   {{0x40340aa9,0x38bc0aaa,0x4ea40801,0xf2c400d1}},	//   реяс, hír_, ърна, _сөйи, 
   {{0x4204013e,0x270400cc,0x00000000,0x00000000}},	//   _инчо_, _শেডো_, --, --, 
   {{0x82bc038f,0x64b40118,0x60040aab,0x00000000}},	//   _མདོའ, přiš, _rómv, --, 
   {{0xb5fc0003,0x64580472,0x600408a5,0xc0c40114}},	//   _diġi, _xhwi, _bómu, _руше_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [6d0] --, --, --, --, 
   {{0x27ec03f9,0x60040321,0x0e440166,0x8d54013d}},	//   _snen_, _dómu, _шэйм, _үтүч, 
   {{0xe5a40aac,0x38bc032e,0x00000000,0x00000000}},	//   ҳили, gír_, --, --, 
   {{0xac1800d6,0x7648010b,0xfb84074d,0x92000055}},	//   _чому_, _akdy, _вырн, _śālo, 
   {{0xf7700aad,0xe5a40aae,0xa6c40aaf,0x82bc0135}},	//   زان_, гили, اقتى, _མདེའ, 
   {{0xd6cc0220,0x64580ab0,0x00000000,0x00000000}},	//   سقى_, _shwi, --, --, 
   {{0x25a807c4,0x64580161,0xdb140413,0xf650009f}},	//   ğal_, _phwi, leyð, آئن_, 
   {{0x27ec0ab1,0x00000000,0x00000000,0x00000000}},	//   _unen_, --, --, --, 
   {{0x36d402bf,0x53c4010b,0xdb1406ea,0x051000eb}},	//   _котр, угым_, neyð, িপের_, 
   {{0x71a40220,0x00000000,0x00000000,0x00000000}},	//   ңаөз, --, --, --, 
   {{0x66000165,0xe1240ab2,0x00000000,0x00000000}},	//   _iolk, умни, --, --, 
   {{0x6600012c,0x6abc031c,0xb5fc025c,0xc5e80154}},	//   _holk, _oqsf, _riġi, _কতটা_, 
   {{0x66000ab3,0x764809a5,0xd12c0ab4,0xb5fc025c}},	//   _kolk, _ykdy, قمی_, _siġi, 
   {{0xb5fc0327,0x60040162,0x44e00ab5,0x712401b9}},	//   _piġi, _rómu, _kı_, اریل, 
   {{0x66000ab6,0x6abc035a,0x44e006be,0x38bc0306}},	//   _molk, _aqsf, _jı_, xír_, 
   {{0x44e00ab7,0x66000ab8,0x38bc0ab9,0xb5fc0327}},	//   _mı_, _lolk, vír_, _viġi, 
   {{0x44e00aba,0xdee40798,0x66000abb,0x600402d2}},	// [6e0] _lı_, _сопи, _oolk, _dómt, 
   {{0x3ea009d3,0xdddc0100,0x4d440116,0xb5fc0135}},	//   _ivit_, _sipņ, _әпюн_, _tiġi, 
   {{0x44e00abc,0x3ea002bf,0x57a401c6,0x00000000}},	//   _nı_, _hvit_, гшла, --, 
   {{0xb8dc0abd,0x3ea000fe,0x204c001f,0x1cdc031c}},	//   _आम_, _kvit_, _ማኅበረ, _རླག_, 
   {{0xc7a00abe,0x12ac00fe,0x2244017a,0xf1b8031c}},	//   сичк, _কন্দ, kolk_, siġi_, 
   {{0x7ae40abf,0x38bc0ac0,0x66000067,0x44e00ac1}},	//   mvit, pír_, _colk, _bı_, 
   {{0x7ae40ac2,0x66000066,0x44e003be,0x3f800270}},	//   lvit, _dolk, _cı_, _ofiu_, 
   {{0x33740ac3,0x44e00ac4,0x7bc40ac5,0x7ae400c5}},	//   шгир, _dı_, nfiu, ovit, 
   {{0x7ae40ac6,0x66000ac7,0x22440ac8,0x60040ac9}},	//   nvit, _folk, folk_, _lóms, 
   {{0x66000aca,0x66800acb,0x7ae40acc,0x7e60057b}},	//   _golk, _بیول, ivit, ïmpl, 
   {{0x59c40acd,0x3ea00100,0x7ae40ace,0xb0340acf}},	//   र्यर, _avit_, hvit, инош, 
   {{0x660005b1,0x5338074d,0x00000000,0x00000000}},	//   _zolk, _пулă, --, --, 
   {{0x66000ad0,0x3ea001a6,0x22440ad1,0x7ae40477}},	//   _yolk, _cvit_, bolk_, jvit, 
   {{0x27300016,0x7ae40ad2,0x44e003ee,0x1cdc025c}},	//   ạng_, dvit, _yı_, _རླང_, 
   {{0x3ea00ad3,0x7bc40ad4,0x8bc40ad5,0xfe24040e}},	//   _evit_, ffiu, лсад, сьян, 
   {{0x3a380109,0x600409f3,0x60c4000d,0x7ae402d2}},	//   _ajrp_, _dóms, _ähma, fvit, 
   {{0xaed407d6,0xce680ad6,0x59c40ad7,0x7ae40ad8}},	// [6f0] _топш, _прод_, र्भर, gvit, 
   {{0x7bc40194,0xdb140ad9,0x3f1402dd,0xfaa80ada}},	//   afiu, reyð, _ыдыс, اهلي_, 
   {{0x2d800943,0x7ae40adb,0x2ee805c7,0xb5fc0135}},	//   _ifhe_, avit, _hraf_, _jiġu, 
   {{0x47700046,0x2ee80092,0x7ae4020b,0x44e00adc}},	//   сқау, _kraf_, bvit, _rı_, 
   {{0x44e00add,0x6f1c0ade,0x09cc03d4,0xc6a40166}},	//   _sı_, nzsc, ৰাবা, уреи, 
   {{0x6b8c0adf,0x247402b1,0x66000014,0x6aac007f}},	//   lbag, _hāmi_, _qolk, mraf, 
   {{0x66000ae0,0x224405e4,0x67d40209,0x6b8c0363}},	//   _volk, volk_, _кову, obag, 
   {{0x69c40ae1,0x6b8c0ae2,0x22440ae3,0x6aac0ae4}},	//   lfhe, nbag, wolk_, oraf, 
   {{0x2d800943,0x21f402bf,0x6258020a,0xca340ae5}},	//   _ofhe_, аїнс, крор_, ﺗﺘﺎ_, 
   {{0x20c402bf,0x69c4007b,0x6b8c0ae6,0xd04803e3}},	//   айом, nfhe, hbag, _isfə, 
   {{0x7ae40ae7,0x2ee80ae8,0x6aac0ae9,0x60300aea}},	//   zvit, _araf_, hraf, lāmi, 
   {{0x71580aeb,0x2ee80368,0x2d94013f,0x60040030}},	//   ырыс_, _braf_, ɔdeɛ_, _róms, 
   {{0x1f540aec,0x60300aed,0x68e0000f,0x2ee80142}},	//   ртнё, nāmi, _âldf, _craf_, 
   {{0x2ee80aee,0x62880aef,0x6aac0af0,0x24840109}},	//   _draf_, mpeo, draf, _ktlm_, 
   {{0x2ee80af1,0x7bc40af2,0x6aac0549,0x6b8c0076}},	//   _eraf_, tfiu, eraf, fbag, 
   {{0x6b8c0af3,0x69c40af4,0x3ea000f3,0x628800b0}},	//   gbag, efhe, _tvit_, opeo, 
   {{0x7bc40af5,0x9aa40af6,0x7ae404cc,0x603000e2}},	// [700] rfiu, شماو, uvit, jāmi, 
   {{0x20e402b5,0x6b8c0af7,0x600401a8,0x61e00472}},	//   _kēi_, abag, _tóms, ndll, 
   {{0x7ae40af8,0x6aac0af9,0x6b8c0afa,0x18680120}},	//   svit, araf, bbag, важи_, 
   {{0x69c00afb,0x603003a0,0x69c40afc,0x24740055}},	//   _ölen, fāmi, afhe, _gāmi_, 
   {{0xda640afd,0xfe3c00b5,0x68e401ab,0x4cc80154}},	//   _ناسي, pはdb_, avhd, ায়দু, 
   {{0x25a40042,0x69c40afe,0x3a28013d,0xceb0011a}},	//   _cdll_, cfhe, _сегү_, קיו_, 
   {{0xdcfc00e2,0x59c40aff,0x61e00042,0x247400b8}},	//   _iepē, र्णर, ddll, _yāmi_, 
   {{0xb2b80b00,0xd9440b01,0x53e401f4,0x00000000}},	//   глиф_, _беҳи, рцка, --, 
   {{0x73c40184,0x38780076,0xb5fc0327,0x59c40b02}},	//   _ғәйе, _hurr_, _siġu, र्थर, 
   {{0x1db00574,0x387802d3,0x14ac0b03,0x2ee80200}},	//   _जागत, _kurr_, _टिपण, _rraf_, 
   {{0x2ee800f3,0x7d0808fb,0x6b8c0b04,0x855400e5}},	//   _sraf_, ødsl, ybag, _پیٹر_, 
   {{0x6f1c0b05,0x38780004,0x2ee8084c,0x64c002e3}},	//   tzsc, _murr_, _praf_, ịich, 
   {{0xb8d80156,0x69c4017a,0xac180107,0x2ee806be}},	//   _མཀ_, yfhe, ҳову_, _qraf_, 
   {{0x6f1c0b06,0x6aac0395,0x8d14013e,0xdcfc00de}},	//   rzsc, vraf, ангӣ_, _nepē, 
   {{0x6b8c0b07,0xac180b08,0x2450004d,0x38780254}},	//   tbag, гову_, _sơmi_, _nurr_, 
   {{0x6aac0b09,0x2ee80b0a,0x6b740166,0x6b8c0072}},	//   traf, _traf_, слау, ubag, 
   {{0x6b8c0b0b,0xc9840a2c,0xed580032,0x60040413}},	// [710] rbag, لشاي, тоң_, _tómr, 
   {{0x6aac0b0c,0x79f4040e,0x38780b0d,0xdcfc0171}},	//   rraf, озух, _burr_, _cepē, 
   {{0x38780b0e,0xc8640b0f,0x24740b10,0x69c4007b}},	//   _curr_, атди, _tāmi_, rfhe, 
   {{0x62880b11,0x6aac00a8,0x24840b12,0x60300b13}},	//   ypeo, praf, _rtlm_, tāmi, 
   {{0xa6c80b14,0x66e400c2,0x6aac00ac,0x9ba000db}},	//   улла_, сола, qraf, _رەلى, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x38780b15,0x00000000,0x00000000,0x00000000}},	//   _gurr_, --, --, --, 
   {{0xd3440133,0xa0a400fb,0x00000000,0x00000000}},	//   ڕینه_, ҙамд, --, --, 
   {{0x26cc00ec,0xa7140640,0x13e40166,0x00000000}},	//   _upeo_, _удаљ, смый_, --, 
   {{0xe1f80b16,0xe53400c0,0xe0e401e1,0x00000000}},	//   уго_, _лезь, _òòka_, --, 
   {{0xd24c0b17,0x62880b18,0x655400ec,0x00000000}},	//   رچه_, speo, _اپاء, --, 
   {{0x60040b19,0x62880b1a,0x9f0400c6,0x00000000}},	//   _cómp, ppeo, موجو, --, 
   {{0x201c0953,0x64480b1b,0x61e0074d,0x60040162}},	//   ėti_, moei, pdll, _dómp, 
   {{0x64480b1c,0x99e00154,0x00000000,0x00000000}},	//   loei, _মক্ক, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x64480b1d,0xb5fc0003,0x24400419,0x00000000}},	//   noei, _jiġr, tómy_, --, 
   {{0x2a700334,0x2a78058a,0x38780b1e,0xb5fc0327}},	// [720] _bizb_, _cusb_, _surr_, _miġr, 
   {{0x644801a4,0x38780b1f,0x69c001d3,0xd9440395}},	//   hoei, _purr_, _ölel, бези, 
   {{0x1d080b20,0x64480942,0xe8900240,0x00000000}},	//   _сени_, koei, _ዝቐርቡ_, --, 
   {{0x2ca40b21,0x64480120,0xb5fc031c,0x38780254}},	//   âlde_, joei, _niġr, _vurr_, 
   {{0x64480086,0x00000000,0x00000000,0x00000000}},	//   doei, --, --, --, 
   {{0x38780b22,0x19f80276,0x3a2c0139,0xcaf401c8}},	//   _turr_, _сэмь_, _ödp_, _اسٽب, 
   {{0x64480b23,0x387801ab,0x54e400ae,0x00000000}},	//   foei, _uurr_, إستق, --, 
   {{0x64480005,0x1cdc0327,0x24740055,0x61e402d2}},	//   goei, _རླབ_, _nāmu_, _óhlj, 
   {{0xd20801c0,0x8778011a,0x00000000,0x00000000}},	//   гэнд_, _תאמי, --, --, 
   {{0x64480086,0x836001d5,0x2a700139,0xe5c80b24}},	//   aoei, سگنل, _xizb_, _نظمه_, 
   {{0x50640b25,0x644801f5,0x683000d0,0x93e4022e}},	//   йтма, boei, sťde, _гўлл, 
   {{0x68e00a85,0xcfa80271,0xa2a00b26,0x7664009f}},	//   _âlde, دادم_, _खिच्, _اُڄم, 
   {{0x0e40001f,0x247400e2,0x0f100b27,0x00000000}},	//   _የህክም, _dāmu_, डनेस_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6c8400c6,0x6a680006,0x3b380092,0x41c0007b}},	//   تلزم, _užfi, _በመጨመ, _رقيق, 
   {{0x09b000cd,0x00000000,0x00000000,0x00000000}},	//   ुभ्य, --, --, --, 
   {{0xca700b28,0xfd1001ed,0x3c58084c,0xa37c0142}},	// [730] سناک, وجہ_, ситэ_, ndŵa, 
   {{0x6fb40b29,0xff180375,0xae0c00bc,0x00000000}},	//   _امکا, _לקחת_, _सकिन_, --, 
   {{0x9f50033b,0x69c00b2a,0x91c800cd,0x00000000}},	//   _anyè_, _ölem, त्यै, --, 
   {{0x64480077,0x603000e2,0xcfa80154,0x00000000}},	//   xoei, sāmv, গ্রন, --, 
   {{0xc9840b2b,0x64480798,0x66040b2c,0x47d800cc}},	//   _губи, voei, жпла, ণালী, 
   {{0xb5fc0135,0xe89402e8,0xf9640133,0xa5080b2d}},	//   _siġr, _магь, _کۆمێ, иела_, 
   {{0x64480b2e,0xf6500b2f,0x00000000,0x00000000}},	//   toei, رئه_, --, --, 
   {{0x24080b30,0x4cc000eb,0x00000000,0x00000000}},	//   рнии_, শবপু, --, --, 
   {{0x28e0069f,0x64480b31,0x13040b32,0x59c40b33}},	//   फिकि, roei, жный_, र्वर, 
   {{0x7d080b34,0xd1c40108,0x00000000,0x00000000}},	//   ødsk, олье_, --, --, 
   {{0x64480b35,0x247404fe,0xe4d80b36,0xdbc400c5}},	//   poei, _pāmu_, _خوات_, mööd, 
   {{0xdbc40254,0x00000000,0x00000000,0x00000000}},	//   lööd, --, --, --, 
   {{0x5ab80156,0xe2980b37,0xd24c0b38,0x942400cf}},	//   པཕབམ, _тал_, رچۇ_, _بونۇ, 
   {{0x216800d8,0x00000000,0x00000000,0x00000000}},	//   _кили_, --, --, --, 
   {{0xd24c0b39,0x00000000,0x00000000,0x00000000}},	//   _جنو_, --, --, --, 
   {{0x60300b3a,0x82c4031c,0x69c000a2,0x6f0c0332}},	//   tāmu, _ཁྱོའ, _ölej, íocá, 
   {{0x21e002b1,0x1a040b3b,0x5d7401f0,0x00000000}},	// [740] _tōhē_, опам, _мунф, --, 
   {{0x0d80026b,0x00000000,0x00000000,0x00000000}},	//   _ольн, --, --, --, 
   {{0xa3e80b3c,0xd82401f4,0x00000000,0x00000000}},	//   मया_, оджи, --, --, 
   {{0x20000b3d,0x00000000,0x00000000,0x00000000}},	//   njki_, --, --, --, 
   {{0x0aa00046,0x8700034b,0xd6d400db,0x00000000}},	//   _оңтү, дяще, تتاغ, --, 
   {{0x82c4025c,0x94a80124,0xdbc40037,0xcb1000d9}},	//   _ཁྱེའ, атиа_, gööd, _חלש_, 
   {{0x1fb004c5,0x799c04e6,0xf8b001ed,0x08c00b3e}},	//   ট্যস, _ierw, _سکا_, _обрн, 
   {{0x799c0b3f,0xf3f800f0,0x00000000,0x00000000}},	//   _herw, сниш_, --, --, 
   {{0x799c00ee,0x69c00b40,0xcfe00154,0x9f5c01ec}},	//   _kerw, र्की, যামন, _ﺍﺭﻻﯞ_, 
   {{0x3218006d,0x799c0b41,0x63ac02a8,0xd2580b3e}},	//   óry_, _jerw, _ƴanc, јци_, 
   {{0x799c0b42,0xf4840b43,0x6d40003d,0x00000000}},	//   _merw, _راضی, żlaz, --, 
   {{0x799c0b44,0x61ec0b45,0x661c0153,0x00000000}},	//   _lerw, _ɗali, _įski, --, 
   {{0x91e40b46,0x799c0b47,0x3de403d4,0x161c00af}},	//   _моде, _oerw, মানল, _भतार_, 
   {{0x799c0b48,0x00000000,0x00000000,0x00000000}},	//   _nerw, --, --, --, 
   {{0xcfe401b9,0xcc28009d,0xc0f00092,0x00000000}},	//   _дўпп, ацад_, ቃብር_, --, 
   {{0x799c0b49,0xef9801a9,0x7d08007c,0x00000000}},	//   _aerw, _укиш_, ädsa, --, 
   {{0x799c0b4a,0x0dc8006c,0x60cc0b4b,0x3e880356}},	// [750] _berw, _куни_, _ćami, _cîtă_, 
   {{0x799c0142,0x7b6401e0,0x59c40b4c,0x00000000}},	//   _cerw, фтсе, र्लर, --, 
   {{0x799c0b4d,0x69c00b4e,0xdbc40037,0x00000000}},	//   _derw, र्गी, vööd, --, 
   {{0x799c0b4f,0xdddc0166,0x7a2001e3,0x6fac00fe}},	//   _eerw, _kipş, _nötf, ট্ৰে, 
   {{0x799c0b50,0x7db40517,0xdbc400c5,0xf7700b51}},	//   _ferw, _عصیا, tööd, ناه_, 
   {{0x6b9c015d,0x00000000,0x00000000,0x00000000}},	//   _hesg, --, --, --, 
   {{0x6b9c0209,0x7a2001e3,0x2408010b,0x87d4007b}},	//   _kesg, _bötf, йнки_, _وغرا, 
   {{0x6b9c0b52,0xe2980b53,0x5924031c,0x3d3c008f}},	//   _jesg, баи_, _རྟིས_, יגוס, 
   {{0x799c0b54,0x7c28004e,0x6b9c010b,0x3dd80175}},	//   _yerw, èdri, _mesg, yerw_, 
   {{0xdafc0589,0x6b9c01a4,0xd26000fd,0x35b40b55}},	//   _pãºc, _lesg, нкый, _обур, 
   {{0x6b9c0857,0x5574010f,0xa3d402e8,0xf484009b}},	//   _oesg, _זעען_, _ножч, _жучн, 
   {{0xf40802dd,0x349401c0,0x3dd8015d,0x00000000}},	//   _ويلى_, _цацр, werw_, --, 
   {{0xe2840b56,0x6d4006af,0xdd9000e5,0x00000000}},	//   _элли, ûlan, ٹوز_, --, 
   {{0x1d080b57,0xc4bc012c,0x649c0241,0x00000000}},	//   беги_, _एमाओ, _ṣiye, --, 
   {{0x799c0b58,0x6b9c0036,0x3dd800ca,0xa0680b59}},	//   _rerw, _besg, rerw_, _лака_, 
   {{0x799c0b5a,0x6b9c0b5b,0x00000000,0x00000000}},	//   _serw, _cesg, --, --, 
   {{0x6b9c0b5c,0x799c0b5d,0xcb6400a8,0x00000000}},	// [760] _desg, _perw, зате_, --, 
   {{0x09e00b5e,0x00000000,0x00000000,0x00000000}},	//   ноун, --, --, --, 
   {{0x799c0b5f,0x6b9c0b60,0x99480b61,0x5f7401e2}},	//   _verw, _fesg, حلال_, _باګر, 
   {{0x799c0b62,0x6b9c015d,0xf7b800db,0x00000000}},	//   _werw, _gesg, تۇرع_, --, 
   {{0x799c0b63,0x15f80210,0x00000000,0x00000000}},	//   _terw, _एचआर_, --, --, 
   {{0xd4980b64,0x98a40b65,0x6b9c009a,0x799c04e6}},	//   бри_, _ниге, _zesg, _uerw, 
   {{0x62980009,0xcfe00011,0x2c4000c0,0x00000000}},	//   _awwo, যাতন, lėda_, --, 
   {{0x04600b66,0xb4ac0b67,0x493800d9,0xe87400d1}},	//   нтым, _कटी_, _הגלו, _قەلب_, 
   {{0xdb14020c,0x24a40092,0x00000000,0x00000000}},	//   èbèr, _ሊደርስ_, --, --, 
   {{0xe60801e2,0x00000000,0x00000000,0x00000000}},	//   _وزلو_, --, --, --, 
   {{0x69c00b68,0xe0840014,0x00000000,0x00000000}},	//   र्टी, وێوو_, --, --, 
   {{0x5ed4015b,0x7a20010b,0x6cd401ec,0x00000000}},	//   দিনে, _hötd, _ﺘﺴﺨﻴ, --, 
   {{0x6b9c0b69,0x244805d9,0x3f1402e8,0x7a2001e3}},	//   _resg, _بجلي_, едяс, _götg, 
   {{0x99cc03f4,0x6b9c04d4,0xacf80816,0x3e040395}},	//   রযুক, _sesg, онгу_, нясв, 
   {{0x3b000369,0xdddc01ed,0x6b9c0b6a,0x7a200139}},	//   exiq_, _cipő, _pesg, _mötd, 
   {{0x26180100,0x00000000,0x00000000,0x00000000}},	//   _nèon_, --, --, --, 
   {{0x6b9c00e4,0xeb980116,0x8d8400db,0x2c400064}},	// [770] _vesg, йиң_, _нунд, gėda_, 
   {{0x6b9c0b6b,0x00000000,0x00000000,0x00000000}},	//   _wesg, --, --, --, 
   {{0xe6100133,0xddcc0419,0xaadc0118,0x00000000}},	//   ێشت_, dobň, _नैरक, --, 
   {{0xe7180b6c,0x6d44004b,0x69c00b6d,0x1ee8036b}},	//   ييات_, _ixha, र्जी, _اویی_, 
   {{0x37740b6e,0x7c28036e,0x443806be,0x00000000}},	//   нышс, ëdre, _ıq_, --, 
   {{0x8f480023,0x95740092,0x00000000,0x00000000}},	//   _ሓድነቶ, _ራሳችን_, --, --, 
   {{0x39a401d9,0x0744004b,0x999800e5,0x00000000}},	//   _سینہ, _کړای_, cipő_, --, 
   {{0x6d440b6f,0x60c40209,0x3e6401e6,0x41cc00cd}},	//   _mxha, _ähmi, möte_, त्नस, 
   {{0x651400b2,0x7668004b,0x3e640b70,0x00000000}},	//   _ڪوائ, _ځینې_, löte_, --, 
   {{0x6d440b71,0x7a2000a2,0x69c00b72,0x06380b73}},	//   _oxha, _götd, र्ची, _اسرع_, 
   {{0x6d440218,0xa0680b74,0x34940b75,0x6514038b}},	//   _nxha, жана_, _захр, _توائ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d440b76,0x6d480311,0x3b000429,0x7a2006be}},	//   _axha, şeal, xxiq_, _höte, 
   {{0x7a200b77,0x02680108,0x00000000,0x00000000}},	//   _köte, _ушей_, --, --, 
   {{0x442c0050,0x6024041b,0xdcfc00ef,0x00000000}},	//   _kmg_, _одка, _iepī, --, 
   {{0x7a20049f,0x442c0b78,0x59c401ad,0x5dd401ec}},	//   _möte, _jmg_, _रॉजर, _ﺘﻤﻬﻴ, 
   {{0x442c0b79,0x435402d3,0x6d440b7a,0x7a200112}},	// [780] _mmg_, _ምትብባ, _exha, _löte, 
   {{0x4a400b7b,0x00000000,0x00000000,0x00000000}},	//   внув, --, --, --, 
   {{0x41cc0b7c,0xb4ac0b7d,0xd7e402bf,0x57e80b7e}},	//   त्यस, _कटे_, діло, ждем_, 
   {{0x6cd40150,0x00000000,0x00000000,0x00000000}},	//   _ﺘﺴﺠﻴ, --, --, --, 
   {{0xc7a00b7f,0x07a00b80,0x00000000,0x00000000}},	//   тичк, тачн, --, --, 
   {{0x7a200598,0x9508025c,0xd9440b81,0x5ec802dd}},	//   _böte, ཀྱའི_, _жеги, _ﺑﻴﯟﺭ, 
   {{0x442c0209,0x44840032,0xa3e800dc,0xddcc00d7}},	//   _bmg_, үбән_, मयं_, robň, 
   {{0x442c037e,0xdec00b82,0x4cc800eb,0xa4900066}},	//   _cmg_, ድሶን_, ায়কু, اینت, 
   {{0x26b00075,0x07a001c0,0xd2440b83,0x442c0b84}},	//   _مەنز, _шатн, дэни, _dmg_, 
   {{0x6fc00073,0xe2340023,0x8af8010f,0x00000000}},	//   _वाहू, _ክብርና, קהיי, --, 
   {{0x7a200b85,0x442c0b86,0x7d0801e3,0x00000000}},	//   _göte, _fmg_, ädsl, --, 
   {{0x442c0089,0x4de402e5,0xa3e800cd,0x5dd401ec}},	//   _gmg_, _छोड़े_, मयः_, _ﺘﺤﻭﻴ, 
   {{0x244807c0,0x522400d8,0x00000000,0x00000000}},	//   _عجمي_, _офка, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xfe240b87,0x39580b88,0x442c0142,0xc1b8011a}},	//   тьян, _nyrs_, _ymg_, _ומוש, 
   {{0x5064006c,0x91c80882,0x5fc402ab,0x7e6001a4}},	//   _ўтка, त्रै, _वायल, ïmpr, 
   {{0x39580076,0x625c020c,0xc054011a,0xea1800db}},	// [790] _ayrs_, kèol, _בזק_, пжаш_, 
   {{0x6d440b89,0x395802d2,0xc95802d5,0x00000000}},	//   _txha, _byrs_, оўе_, --, 
   {{0x6d440944,0xe9440b8a,0xd2440617,0xff50004b}},	//   _uxha, ررئی, _ەن_, _مخی_, 
   {{0x39580450,0xc61400dc,0x7a200b8b,0x0134011a}},	//   _dyrs_, थस्य_, _röte, ורבת_, 
   {{0x76c40b8c,0x442c01c7,0x7a200166,0x368800fb}},	//   نغول, _rmg_, _söte, үсән_, 
   {{0x37a80b8d,0xe4c400d1,0x7a2001b8,0x649800f7}},	//   птән_, ейки, _pöte, птир_, 
   {{0x7a200139,0x00000000,0x00000000,0x00000000}},	//   _qöte, --, --, --, 
   {{0xe7940b8e,0x7bc00793,0xe7380368,0x7a20007c}},	//   _سارک, _ömut, _ddŵr_, _götb, 
   {{0x38c4068c,0x6e3400a2,0x59c40b8f,0x00000000}},	//   _tèrç_, kizb, र्कर, --, 
   {{0x7a200b90,0x6e3400d0,0x973003c7,0xdb1400e5}},	//   _töte, jizb, _حکما, ngyá, 
   {{0x6e340b91,0x442c0b92,0x4ecc00cc,0x90b0035b}},	//   dizb, _tmg_, িটোল, гәыш, 
   {{0x3074084c,0x7a200139,0x00000000,0x00000000}},	//   куяс, _xötb, --, --, 
   {{0x443c0b93,0x6e340b94,0x7df0013f,0x80a80118}},	//   mnu_, fizb, lɔsɔ, _झिके, 
   {{0x91e0016c,0x61440b95,0x9f500162,0x626401c0}},	//   _боше, _пела, _doyð_, _явла, 
   {{0x1d080b96,0x6138010f,0x00000000,0x00000000}},	//   чеви_, _מײַס, --, --, 
   {{0xc87c0b97,0x00000000,0x00000000,0x00000000}},	//   ışla_, --, --, --, 
   {{0x34dc0b98,0xcfe0015b,0x7e640022,0x34ac00bc}},	// [7a0] _मन्द, যাশন, _иеиҧ, _घट्द, 
   {{0x443c0b99,0x8e940375,0x7df0013f,0xdb1400e5}},	//   hnu_, _רדיו_, kɔsɔ, ggyá, 
   {{0xd7f80262,0x68e0002d,0x625c004e,0x59c40b9a}},	//   зул_, _âldl, vèol, र्गर, 
   {{0x443c0b9b,0x41cc0b9c,0xf6ec031c,0x96e800d3}},	//   jnu_, त्तस, _རླུང, зька_, 
   {{0x443c0b9d,0xc0e40882,0x7c240b9e,0xd37800d1}},	//   dnu_, rāṇi_, mhir, үчи_, 
   {{0x443c0b9f,0xd4980ba0,0x7c240ba1,0x00000000}},	//   enu_, при_, lhir, --, 
   {{0x3b380020,0x1dd00a28,0x443c0ba2,0x5fc40574}},	//   _በመጀመ, द्यत, fnu_, _वाढल, 
   {{0x443c0ba3,0x7c240ba4,0x73d801a9,0x00000000}},	//   gnu_, nhir, фдир_, --, 
   {{0xe7d40ba5,0x7c240175,0xd65c074d,0x27e801e4}},	//   lığı, ihir, _дiад, ɾan_, 
   {{0x443c0ba6,0x7c240ba7,0x00000000,0x00000000}},	//   anu_, hhir, --, --, 
   {{0x7c240ba8,0x443c0ba9,0xe7d40baa,0xd1380212}},	//   khir, bnu_, nığı, яхи_, 
   {{0x6fc00073,0xfd540055,0x00000000,0x00000000}},	//   _वाळू, _upeṣ, --, --, 
   {{0x7c240bab,0x6e340bac,0xad240131,0x4ea40006}},	//   dhir, tizb, ھىرى, эрна, 
   {{0xad2403cc,0xf1a40073,0x231401af,0x00000000}},	//   پىرى, _खजिन, _шєхс, --, 
   {{0xc0e00b3e,0x8c640bad,0xe8200bae,0x6e3400d7}},	//   _бојк, етад, _मतला_, rizb, 
   {{0xe7d40baf,0x50640bb0,0x2ef40bb1,0x6a980150}},	//   dığı, _ятла, _азир, _ﺘﻨﻭﻉ_, 
   {{0xf1a40bb2,0xc87c0abc,0x6b74053f,0x7d08005c}},	// [7b0] _खजान, ışma_, тлау, ødsr, 
   {{0x7c2400ec,0x443c0bb3,0xe91800d4,0x3b54022e}},	//   ahir, znu_, мозі_, укур, 
   {{0x443c0bb4,0x7c240bb5,0xdb1401d3,0xac9402dd}},	//   ynu_, bhir, rgyá, _шанш, 
   {{0x7c240bb6,0x68e0000f,0x443c0009,0x3e6401e3}},	//   chir, _âldm, xnu_, möta_, 
   {{0x66e40bb7,0x6d400174,0x00000000,0x00000000}},	//   тола, úlaf, --, --, 
   {{0x27e80bb8,0x625c026c,0x7bc001a8,0xe7d40bb9}},	//   žan_, tèom, _ömur, bığı, 
   {{0xe7d40342,0x88b80327,0xa81c01ca,0x00000000}},	//   cığı, _པའིར, _дзвi, --, 
   {{0x443c0bba,0xd7ec00b2,0xf9900014,0x67d401e0}},	//   unu_, _وڃن_, _نبہ_, _шобу, 
   {{0x443c0bbb,0x7a2000b0,0x69c00bbc,0x13e4008e}},	//   rnu_, _höta, _öles, тмый_, 
   {{0xd24c0bbd,0x7c240489,0x7a200139,0x7d08007c}},	//   يني_, zhir, _köta, ädsk, 
   {{0x61440bbe,0x65180bbf,0x59c40bc0,0x00000000}},	//   тена, _تقاس_, र्टर, --, 
   {{0x443c0bc1,0x7a200267,0x7c24036e,0x5ed400eb}},	//   qnu_, _möta, xhir, দিসে, 
   {{0x69d40bc2,0x7c240433,0xdb0402fb,0x92e4010b}},	//   _obze, vhir, _odká, _аңың_, 
   {{0x7c240325,0xdb2401e1,0x00000000,0x00000000}},	//   whir, _ìpér, --, --, 
   {{0x7c240bc3,0x2730001e,0xe0440bc4,0xa3b40bc5}},	//   thir, ạnh_, _инки, _जया_, 
   {{0x7c240357,0x8c400261,0x69d40112,0x44e001d3}},	//   uhir, аесе, _abze, _mű_, 
   {{0xeab0066d,0x68f404cc,0x7c240bc6,0x68e0000f}},	// [7c0] یعے_, _arzd, rhir, _âldj, 
   {{0x68f40232,0x7a200309,0x3ea00428,0xe7d40bc7}},	//   _brzd, _böta, _iwit_, tığı, 
   {{0x7c240bc8,0x3ea00165,0xd7c401a9,0x00000000}},	//   phir, _hwit_, вёло, --, 
   {{0x7c240bc9,0x3ea002bd,0x59c40bca,0x00000000}},	//   qhir, _kwit_, र्जर, --, 
   {{0x68f4002f,0xd6280835,0x00000000,0x00000000}},	//   _erzd, моде_, --, --, 
   {{0x7ae40bcb,0xdcec0bcc,0x3ea00428,0x6d400bcd}},	//   mwit, labı, _mwit_, úlag, 
   {{0x7ae405e4,0x7a2001e6,0x98a40131,0xa4900bce}},	//   lwit, _göta, _шиве, میلت, 
   {{0x7bc40bcf,0xa7840597,0x0b9c00b7,0x6d400129}},	//   ngiu, _مشكو, _ጎንደር_, ûlai, 
   {{0x7ae4031c,0x32540bd0,0x6f0800e8,0x3ea00bd1}},	//   nwit, лвир, _mëbë, _nwit_, 
   {{0x3f800bd2,0x7bc40007,0x7e600356,0x7a200108}},	//   _agiu_, hgiu, împl, _yöta, 
   {{0x3ea00bd3,0x85980bd4,0x9f4c0232,0xdcec00fd}},	//   _awit_, _חשבו, čným_, kabı, 
   {{0x7ae40bd5,0xc950025f,0x6e940bd6,0x6f08002e}},	//   kwit, ימת_, лиму, _nëbë, 
   {{0xcd940023,0x00000000,0x00000000,0x00000000}},	//   _ጉዕዞና_, --, --, --, 
   {{0x7ae40bd7,0x7bc400c5,0x01300133,0xab900150}},	//   dwit, egiu, اعید, _ﺑﯩﻴﻚ_, 
   {{0x1dd004e4,0x7ae40354,0x8bc40bd8,0xc2780bd9}},	//   द्धत, ewit, ксад, _קרוי, 
   {{0x7bc40bda,0xdfd000b2,0x3ea002e2,0xe3c80077}},	//   ggiu, _هيٺ_, _fwit_, mañá_, 
   {{0x41cc0882,0x7a200267,0x3c580276,0x7ae40bdb}},	// [7d0] त्वस, _söta, титэ_, gwit, 
   {{0xf7f40502,0x2ee80bdc,0x7bd00024,0x00000000}},	//   یسند, _isaf_, _čiuž, --, 
   {{0x2d800bdd,0x3ea0061c,0x7ae4011f,0x6d400bcd}},	//   _ighe_, _zwit_, awit, úlad, 
   {{0x7ae40bde,0x3ea0007f,0xf9680064,0x7a200254}},	//   bwit, _ywit_, труй_, _vöta, 
   {{0x463007dd,0x52ac0131,0xa3b8000d,0x9ba00116}},	//   аҭар, _ﺳﻪﯞﻩ, _अएब_, _دەقى, 
   {{0x6b8c0bdf,0xc9840be0,0x6aac0be1,0x7a2000b0}},	//   lcag, _шуми, msaf, _töta, 
   {{0xd5ac0be2,0xd8b40214,0x7a2001d3,0x00000000}},	//   سفي_, _مگنا_, _kötn, --, 
   {{0x6b8c0be3,0x69c40be4,0xd4640be5,0x2fc80218}},	//   ncag, lghe, лище_, _ncag_, 
   {{0x6aac0be6,0x2bd40be7,0x65940be8,0x2d800be9}},	//   nsaf, ड्या, _базу, _oghe_, 
   {{0x2d8007ae,0x27ec0bea,0x6aac0099,0x7bc40beb}},	//   _nghe_, _haen_, isaf, zgiu, 
   {{0x69c40bec,0x27ec0bed,0x3ea00bee,0x7ae40bef}},	//   ighe, _kaen_, _swit_, zwit, 
   {{0x25a40bf0,0x7ae40bf1,0x27ec0bf2,0x2484011c}},	//   _hell_, ywit, _jaen_, _iulm_, 
   {{0x25a40bf3,0x63a80bf4,0x27ec0bf5,0x64580bf6}},	//   _kell_, maen, _maen_, _ikwi, 
   {{0x63a80bf7,0x27ec0bf8,0x24840bf9,0x25a40bfa}},	//   laen, _laen_, _kulm_, _jell_, 
   {{0x61e00bfb,0xdcec0bfc,0x25a40bfd,0x2ee801f2}},	//   mell, tabı, _mell_, _esaf_, 
   {{0x61e00bfe,0x63a80bff,0x6b8c074d,0x41cc0c00}},	//   lell, naen, gcag, त्रस, 
   {{0x7bc40c01,0x64580bd7,0xdcec0c02,0x6aac0c03}},	// [7e0] rgiu, _mkwi, rabı, gsaf, 
   {{0x25a40c04,0x7ae40c05,0x63a80c06,0xdcec0c07}},	//   _nell_, rwit, haen, sabı, 
   {{0x61e00801,0x27ec0399,0x63a80c08,0x20100c09}},	//   iell, _baen_, kaen, _koyi_, 
   {{0x27ec0097,0x6b8c0c0a,0x64580c0b,0x69c40731}},	//   _caen_, ccag, _nkwi, aghe, 
   {{0x61e00c0c,0x63a80c0d,0x27ec0c0e,0x20100c0f}},	//   kell, daen, _daen_, _moyi_, 
   {{0x64580c10,0x20100c11,0x61e00c12,0x25a40c13}},	//   _akwi, _loyi_, jell, _cell_, 
   {{0x61e00138,0x27ec0097,0x25a40c14,0x09bc0489}},	//   dell, _faen_, _dell_, _ཁྐྲ_, 
   {{0x63a80c15,0x61e0049b,0x201002b9,0x27ec0493}},	//   gaen, eell, _noyi_, _gaen_, 
   {{0x61e00c16,0x57440c17,0x969007d6,0x25a40c18}},	//   fell, _снаб, _ایتش, _fell_, 
   {{0x64580c19,0x25a40c1a,0x2fc80c1b,0x228808ce}},	//   _ekwi, _gell_, _scag_, _dúk_, 
   {{0x63a80c1c,0x20100c1d,0x27ec0007,0x2bd401ad}},	//   baen, _boyi_, _yaen_, ड्डा, 
   {{0x25a40c1e,0x63a80097,0x0ee805cc,0x69c40c1f}},	//   _zell_, caen, ньги_, zghe, 
   {{0x25a40c20,0x69c40c21,0x248401b9,0x5fc40c22}},	//   _yell_, yghe, _zulm_, _वारल, 
   {{0x7a200a48,0x60c00c23,0x6aac01bf,0x69c40327}},	//   _sötn, bulm, vsaf, xghe, 
   {{0x6b8c074d,0x60c00c24,0x420401d9,0x1b100154}},	//   tcag, culm, _حسنہ, _ঠেলে_, 
   {{0x6aac0c25,0x7c840c26,0x20100b45,0x2ee803f9}},	//   tsaf, суре, _goyi_, _tsaf_, 
   {{0x6b8c0c27,0x27ec0097,0x6d40022c,0x7a2008a5}},	// [7f0] rcag, _raen_, úlab, _vötn, 
   {{0x6b8c0c28,0x6aac0c29,0x69c40363,0x27ec0c2a}},	//   scag, rsaf, ughe, _saen_, 
   {{0x69c40c2b,0x6aac0c2c,0x63a80c2d,0xa3e40c2e}},	//   rghe, ssaf, yaen, _फसल_, 
   {{0x67d40c2f,0x25a40c30,0xac180c31,0x69c40332}},	//   роду, _sell_, _рому_, sghe, 
   {{0x63a80c32,0x25a40c33,0x24840023,0x27ec05c7}},	//   vaen, _pell_, _sulm_, _vaen_, 
   {{0x63a80c34,0x64580c35,0x27ec0c36,0x60c00c37}},	//   waen, _skwi, _waen_, yulm, 
   {{0x25a40c38,0x63a80c39,0x27ec0c3a,0x7a200254}},	//   _vell_, taen, _taen_, _mötl, 
   {{0x25a40c3b,0x60c00c3c,0x81c0035b,0x00000000}},	//   _well_, vulm, әанҧ, --, 
   {{0x61e00c3d,0x25a40c3e,0x21280198,0x52a40006}},	//   tell, _tell_, _ƙaho_, авым_, 
   {{0x63a80c3f,0x60c00c40,0x2010043b,0x04640220}},	//   saen, tulm, _soyi_, _өтем, 
   {{0x63a80c41,0x36040bbf,0x8ca4000d,0x2010022e}},	//   paen, _دولف, टीमो, _poyi_, 
   {{0x61e00c42,0x64580c43,0x60c00c44,0x2288011f}},	//   sell, _ukwi, rulm, _túk_, 
   {{0x60c00c45,0x61e00c46,0x00000000,0x00000000}},	//   sulm, pell, --, --, 
   {{0x61e00c47,0x2010013f,0x6e240076,0x60c00c48}},	//   qell, _woyi_, _clhb, pulm, 
   {{0xdca40c49,0x7a200793,0x2010017a,0x60c00477}},	//   раби, _söto, _toyi_, qulm, 
   {{0x7a2001b8,0x00000000,0x00000000,0x00000000}},	//   _pöto, --, --, --, 
  
   {{0xdee40c4a,0xb0680c4b,0xa2bc0c4c,0x7a2001a8}},	// [800] _топи, _حصول_, _शिफ्, _fötl, 
   {{0x6d400597,0x6e24005a,0x6494031c,0xa2bc01ad}},	//   úlac, _glhb, _iġif, _शिन्, 
   {{0x2d9403a5,0x57a40c4d,0xa3e4012d,0x00000000}},	//   _урыс, ашла, _फसं_, --, 
   {{0xded40201,0x9f400240,0xb17c01e4,0x7d1c0c4e}},	//   _ይሁን_, jekë_, neĥa, myrs, 
   {{0xc6a00371,0xdddc0055,0xdb04036e,0x7d0801bf}},	//   орщи, _nipū, _mekë, ådsf, 
   {{0xdb040023,0x7a20008e,0xe9a80c4f,0x00000000}},	//   _lekë, _kötm, _مدفن_, --, 
   {{0x55040209,0x628402b5,0x00000000,0x00000000}},	//   рчла, _ōhop, --, --, 
   {{0x43800c50,0x999800b0,0x98680276,0x748c00d1}},	//   يلىق, kipū_, _рибб_, _ﻗﺎﭼﯩ, 
   {{0x63bc0c51,0xb17c01e4,0x3a380139,0x7d1c0b6a}},	//   ósna, deĥa, _kmrp_, hyrs, 
   {{0x7d1c06a3,0xf53801e4,0xd4d40953,0xc0340014}},	//   kyrs, _leĥi_, _відэ, ۪ژوک, 
   {{0xdb040c52,0x506401b9,0x92d4015b,0xe4f800dc}},	//   _bekë, итма, াটে_, ्मणि_, 
   {{0x32440032,0x76580c53,0xdb040240,0x7a200166}},	//   реүг, lovy, _cekë, _sötl, 
   {{0x32940597,0x00000000,0x00000000,0x00000000}},	//   _التأ, --, --, --, 
   {{0x76580306,0x8318010f,0x00000000,0x00000000}},	//   novy, _בודז, --, --, 
   {{0x0ba40c54,0x0c84010b,0x7d1c0432,0x00000000}},	//   ишам, рыгм, gyrs, --, 
   {{0xf21c0c2e,0xdb0404e6,0x7658009f,0x6fc00490}},	//   _पकड़_, _gekë, hovy, _वाटू, 
   {{0xc9840588,0x32d001fb,0xaed40640,0x76580c53}},	// [810] ауеи, này_, _уопш, kovy, 
   {{0x765807a8,0x6f1c003e,0x7a2000a2,0x0ca8008e}},	//   jovy, mysc, _hötj, _итми_, 
   {{0x6f1c02d0,0x76580153,0x7d0801e3,0x00000000}},	//   lysc, dovy, ädst, --, 
   {{0xd1240c55,0xa7740c56,0x6d480311,0x6aa8025c}},	//   _ہم_, блеч, şeas, _ħeff, 
   {{0x8b64006c,0xd12400f1,0x8b000210,0x00000000}},	//   _خادم, _ځم_, łębs, --, 
   {{0x2d900c57,0xdddc002b,0x00000000,0x00000000}},	//   ncze_, _ripū, --, --, 
   {{0x92d40c58,0xdb2403e6,0xf6080133,0x9f40036e}},	//   াটো_, _نوێی, شتوه_, tekë_, 
   {{0xa3e80c59,0xded4001f,0x5fc40c5a,0x6f1c00d7}},	//   удиа_, _ይሁኑ_, _वाइल, kysc, 
   {{0x9f400c5b,0x765800c7,0xdb04036e,0x32d00051}},	//   rekë_, bovy, _rekë, gày_, 
   {{0xdb0401bf,0x765802f0,0x32d40006,0xdddc0055}},	//   _udkå, covy, іцыс, _vipū, 
   {{0x1fa801b9,0xe49800d8,0x34940c5c,0x2d900210}},	//   лкни_, _скеч_, _дахр, dcze_, 
   {{0xdee40c5d,0x999802b5,0x7a20007c,0x9f400c5e}},	//   боми, tipū_, _rötm, leké_, 
   {{0x28c802ab,0x7a2001e3,0x00000000,0x00000000}},	//   ांडि, _sötm, --, --, 
   {{0x2168044c,0x7d1c0c5f,0x999800b0,0x656001f4}},	//   _йили_, tyrs, ripū_, _kylh, 
   {{0x6fc00490,0x5bb40c60,0x65600108,0x00000000}},	//   _वाचू, йсаф, _jylh, --, 
   {{0x6f1c0c61,0x6d40022c,0x62640131,0x2d90033f}},	//   bysc, úlaa, _ئاچق, acze_, 
   {{0x20d003df,0x765800ca,0x88d0031c,0x80bc0073}},	// [820] lái_, yovy, _ཌཱུར, लंके, 
   {{0x7d1c06a3,0xf9c40c62,0x00000000,0x00000000}},	//   pyrs, تحری, --, --, 
   {{0x20d00c63,0xd238008f,0xe3ac02f5,0x2ca4000f}},	//   nái_, נגעל, _গানব, âldt_, 
   {{0x7a20008e,0x9f400100,0xb6c801d3,0xdb0400e5}},	//   _kötk, tekè_, لاتے_, _leké, 
   {{0x20d000c7,0x9f5000a2,0x765802f0,0x3cf80175}},	//   hái_, _anyú_, tovy, lvrv_, 
   {{0x20d0035b,0xdb040c64,0x3a28013d,0x38c8030f}},	//   kái_, _rekè, _тегү_, _پاسی_, 
   {{0x76580c65,0x26180c66,0x6f1c0034,0xdb04020c}},	//   rovy, _बकरी_, zysc, _sekè, 
   {{0x76580c67,0x2904041a,0xb2b80c68,0x2d900210}},	//   sovy, _šlag_, алиф_, zcze_, 
   {{0x46a00c69,0x7a200267,0x76580022,0x2d900210}},	//   _натв, _nötk, povy, ycze_, 
   {{0xe46409a5,0xdb040c6a,0xf23806ed,0x388803e0}},	//   _ýöne_, _ceké, рпош_, _ağri_, 
   {{0x20d000c7,0xa5cc00bc,0x09f4011a,0x00000000}},	//   gái_, _सातौ, זמים_, --, 
   {{0x6f1c074d,0x2d90068f,0x897808a8,0x136800d4}},	//   tysc, wcze_, טריצ, _йшли_, 
   {{0x20d0035b,0x814001d5,0x00000000,0x00000000}},	//   aái_, قنین, --, --, 
   {{0x20d00c63,0x2d840c6b,0xdb0401c7,0x388803e0}},	//   bái_, øle_, _geké, _eğri_, 
   {{0x3134040e,0x2d900034,0x20d003df,0xf1a000d1}},	//   _фейр, rcze_, cái_, _ﺋﯘﻗﯘ, 
   {{0x6494031c,0x95580023,0xd378010a,0x2d900210}},	//   _wġig, _ኲናትን_, _рчç_, scze_, 
   {{0x6494031c,0x7a200c6c,0xa66801ee,0x2d900210}},	// [830] _iġie, _köth, _йыhа, pcze_, 
   {{0x6d18031c,0x30ec00dc,0x64940003,0xa9c00137}},	//   ུགདེ_, _जनाः_, _uġig, بۅسۉ, 
   {{0xda180037,0x9f400c6d,0x2ea801f9,0x9dd4011a}},	//   _धवरत_, veké_, _कबुत, _וותק_, 
   {{0x2bc803cc,0x6494031c,0x9f40034c,0x00000000}},	//   _өлүп_, _jġie, weké_, --, 
   {{0x65600649,0x6494025c,0x9f400214,0xd7e401ec}},	//   _sylh, _mġie, teké_, імше_, 
   {{0xa934010b,0xc1b402a0,0x2bd40c6e,0x05b808f0}},	//   _дегш, _आयेग, ड्रा, ادشت_, 
   {{0x2408011b,0xdb04003e,0x00000000,0x00000000}},	//   инки_, _reké, --, --, 
   {{0x64940327,0xa2bc0c6f,0xb17c0115,0x2ea80c70}},	//   _nġie, _शिद्, teĥn, _कबूत, 
   {{0x625c0561,0x20d00789,0xe4f800cd,0x00000000}},	//   dèor, wái_, ्महि_, --, 
   {{0xf7700c71,0x20d00124,0x68e00b21,0x00000000}},	//   _ساق_, tái_, _âlds, --, 
   {{0x21680c72,0xa0a400fd,0x7a20013d,0x00000000}},	//   рини_, әшүл, _sötk, --, 
   {{0x20d0035b,0x7a20005b,0x00000000,0x00000000}},	//   rái_, _pötk, --, --, 
   {{0x443c0c73,0x6d400579,0x64480c74,0x83640c75}},	//   miu_, úlan, mnei, _ادال, 
   {{0x443c0c76,0x62980c77,0x64940135,0xa0a400ee}},	//   liu_, _itwo, _iġib, _дакд, 
   {{0xdcb00c78,0x443c0069,0x64940327,0x64480c79}},	//   بىز_, oiu_, _fġie, onei, 
   {{0x64480c7a,0x00000000,0x00000000,0x00000000}},	//   nnei, --, --, --, 
   {{0x64480c7b,0x443c0093,0x64940135,0x7d08007c}},	// [840] inei, iiu_, _jġib, ådsb, 
   {{0x64480226,0x6298007f,0xc1b400ce,0x6494031c}},	//   hnei, _mtwo, _आयोग, _mġib, 
   {{0x1d080c7c,0x443c0c7d,0x64480c7e,0x8d7405d9}},	//   _тени_, kiu_, knei, _واپا, 
   {{0x64480007,0x62980034,0x443c0c7f,0x7a2001f4}},	//   jnei, _otwo, jiu_, _möti, 
   {{0x443c0c80,0x6494031c,0x64480c81,0x00000000}},	//   diu_, _nġib, dnei, --, 
   {{0x8c1c03f4,0x7c24007d,0x18a40c82,0x1da80490}},	//   নোদন_, lkir, _магм, करित, 
   {{0xfed00c58,0x7a2008d5,0x443c0c83,0x7c240083}},	//   িবিধ, _nöti, fiu_, okir, 
   {{0x7c240c84,0x443c0c85,0x64480c86,0x8898011a}},	//   nkir, giu_, gnei, _כבלי, 
   {{0x7c24071a,0x63b80042,0x64940135,0x1da80c87}},	//   ikir, _ddwn, _rġie, करात, 
   {{0x443c0c88,0x6448021c,0x7c240c89,0x63ac00df}},	//   aiu_, anei, hkir, _ĵane, 
   {{0x7c240c8a,0x82300c8b,0x62980c8c,0xb0c4012d}},	//   kkir, بريا, _etwo, लूंग, 
   {{0x443c0c8d,0x64480c8e,0x00000000,0x00000000}},	//   ciu_, cnei, --, --, 
   {{0xc7b0025f,0x7c240c8f,0xaaa8033f,0x9268033a}},	//   ובר_, dkir, _चौंक, _крка_, 
   {{0x7c240c90,0x99cc0183,0x7a2008a5,0x0dc80c91}},	//   ekir, ৰযুক, _föti, шуми_, 
   {{0x7c240135,0x7a2002d2,0x7d0801e3,0x00000000}},	//   fkir, _göti, ädsp, --, 
   {{0x7c240c92,0x9be4025c,0x09c00c93,0xdd98013e}},	//   gkir, _སྒྱོ, शल्य, ишӣ_, 
   {{0x8d840c94,0x00000000,0x00000000,0x00000000}},	// [850] _мунд, --, --, --, 
   {{0x443c0c95,0x64480226,0x7c240c96,0x3b54023b}},	//   ziu_, znei, akir, фкур, 
   {{0xdb1409a5,0x644802f6,0x443c0198,0xab940212}},	//   mgyý, ynei, yiu_, _нині, 
   {{0x443c0c97,0x9f5002e2,0xa7740c98,0x64480369}},	//   xiu_, _bayè_, плеч, xnei, 
   {{0x9be40c99,0x443c0c9a,0x66040c9b,0x00000000}},	//   _སྒྲོ, viu_, зпла, --, 
   {{0x9f50033b,0x656400af,0x443c0034,0x64480042}},	//   _dayè_, ühho, wiu_, wnei, 
   {{0x443c0c9c,0x62980034,0x64480007,0x666401d9}},	//   tiu_, _stwo, tnei, _ہُرٕ, 
   {{0x644804cc,0xa02401f4,0xb50800db,0x00000000}},	//   unei, isöä, تۉمۅ_, --, 
   {{0x443c0c9d,0x13040c9e,0xe58401e0,0xe2980063}},	//   riu_, зный_, _етеү, љао_, 
   {{0x443c0c9f,0x7c240ca0,0x7a200793,0x64480ca1}},	//   siu_, zkir, _pöti, snei, 
   {{0x443c0ca2,0x7c240ca3,0x6d4006ea,0xa2bc0073}},	//   piu_, ykir, úlal, _शिव्, 
   {{0xdee40ca4,0x44240ca5,0x0d380092,0xecd000eb}},	//   поми, _ظراف, _አስፋል, াবাড, 
   {{0x62980034,0xd5d0000d,0x7c240ca6,0xe3b8002d}},	//   _utwo, _सामज, vkir, shűs_, 
   {{0xe1f00ca7,0x7c24094a,0x7a2002b5,0x9f500ca8}},	//   _سست_, wkir, _töti, _jayé_, 
   {{0x9f500ca9,0x7c240caa,0x0bb80cab,0x7a2001d3}},	//   _mayé_, tkir, өттө_, _kötv, 
   {{0x5fc405ba,0x9f400093,0x7c240cac,0x9f500cad}},	//   _वाटल, lekí_, ukir, _layé_, 
   {{0x7c240cae,0xfe7801ec,0x00000000,0x00000000}},	// [860] rkir, _мүм_, --, --, 
   {{0x7c240caf,0x4ef8008f,0x4dd800bc,0x00000000}},	//   skir, _פליג, ख्दै_, --, 
   {{0xd00c01b9,0x00000000,0x00000000,0x00000000}},	//   _شلی_, --, --, --, 
   {{0x7c240054,0x7f3c001f,0xd7080108,0x8eb00066}},	//   qkir, _አንዳች, йнее_, _تمیش, 
   {{0xa2bc07b7,0x9f500cb0,0x7c28017a,0x38c80133}},	//   _शिष्, _bayé_, ëdru, _ژاری_, 
   {{0x28c808f2,0x00000000,0x00000000,0x00000000}},	//   ांशि, --, --, --, 
   {{0xf8e0069f,0x48e0011b,0xb7e00073,0x98a400f3}},	//   _नहिय, _порв, _गॉथम_, _хибе, 
   {{0xe97004a9,0x18a40cb1,0x32980261,0x9f500100}},	//   _شۇند, _маҳм, овиќ_, _tayè_, 
   {{0x9f5000e8,0x5fc40490,0xb2740131,0xe7d00cb2}},	//   _fayé_, _वाजल, млиш, _हातप, 
   {{0xa2bc0cb3,0xf8e00cb4,0x42700cb5,0x6368009d}},	//   _शिर्, _नहाय, нгыс, өрөг_, 
   {{0x85980302,0x85e401c6,0x5dd402dd,0x00000000}},	//   _השבו, _хдхв_, _ﺘﺤﻘﻴ, --, 
   {{0x68e0013d,0x6d400174,0x00000000,0x00000000}},	//   _älde, úlam, --, --, 
   {{0x7a20032e,0x03a00cb6,0xcf2400ae,0x00000000}},	//   _hötu, _чичо, سرحي, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5fc40574,0x7a20032e,0xaaf406be,0x00000000}},	//   _वाचल, _jötu, _köçü_, --, 
   {{0x7d080158,0x7a200cb7,0x7e600356,0x2d9c010e}},	//   ådsa, _mötu, împr, _şwed_, 
   {{0x2288002d,0x00000000,0x00000000,0x00000000}},	// [870] _tźke_, --, --, --, 
   {{0xe9440cb8,0x7ed400c6,0x79f4011c,0x00000000}},	//   ورای, _أزيا, нзух, --, 
   {{0x3e640008,0xf98800c6,0x9f5006af,0xac180cb9}},	//   götu_, أنمي_, _rayé_, _дону_, 
   {{0xa2bc0cba,0x6fac02ab,0xdb1400e5,0x00000000}},	//   _शिल्, चरिं, ggyó, --, 
   {{0x9f5007ea,0xf77002e9,0xa6c800d4,0xe7040cbb}},	//   _payé_, هاه_, ілка_, بسای, 
   {{0x7a200cbc,0xdb04002d,0xdaa002dd,0xb17c01e4}},	//   _bötu, _fekâ, _شەمپ, reĥj, 
   {{0x80d800ab,0x9f4000d7,0x00000000,0x00000000}},	//   _बहें, vekí_, --, --, 
   {{0x7a2001b8,0x9f500cbd,0x3e6401d3,0x94700cbe}},	//   _dötu, _wayé_, lött_, نگنا, 
   {{0x65940a52,0x9f400093,0x9f5001e1,0xb9fc0092}},	//   _жазу, tekí_, _tayé_, _ቅቤ_, 
   {{0x7a2001a8,0x00000000,0x00000000,0x00000000}},	//   _fötu, --, --, --, 
   {{0x7a200008,0x00000000,0x00000000,0x00000000}},	//   _götu, --, --, --, 
   {{0xeb0c0cbf,0x7a200cc0,0xaaf403e0,0x33d4003b}},	//   _सपूत_, _hött, _göçü_, _зішт, 
   {{0xd0900cc1,0x7a200cc2,0xd24c00aa,0xdb040cc3}},	//   _müəy, _kött, انۍ_, _pekí, 
   {{0x3e6401ed,0x7a2001d3,0xfd6401ec,0x00000000}},	//   jött_, _jött, енгү, --, 
   {{0x7a200cc4,0x21200194,0x3e6401ed,0x00000000}},	//   _mött, _æhh_, dött_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xcb640cc5,0x3e64007c,0x00000000,0x00000000}},	// [880] дате_, fött_, --, --, 
   {{0x7a200267,0x3e6401ed,0x00000000,0x00000000}},	//   _nött, gött_, --, --, 
   {{0xdb1400e5,0x00000000,0x00000000,0x00000000}},	//   tgyó, --, --, --, 
   {{0x81b004c5,0x7a200cc6,0x57440124,0x00000000}},	//   টলি_, _rötu, мнеб, --, 
   {{0xc68c01d9,0x7a200112,0xe6b401d5,0xdb1400e5}},	//   لِن_, _bött, فلنگ, rgyó, 
   {{0x59740064,0x00000000,0x00000000,0x00000000}},	//   _жыбу, --, --, --, 
   {{0x7a200267,0x00000000,0x00000000,0x00000000}},	//   _dött, --, --, --, 
   {{0xf318013e,0x61e403e0,0xe70800db,0x00000000}},	//   зоиш_, _ıhla, تتۅن_, --, 
   {{0x7a20049f,0x02a00276,0xe43001d3,0x00000000}},	//   _fött, крэм, دہند, --, 
   {{0x7a200cc7,0x6d400162,0x00000000,0x00000000}},	//   _gött, úlak, --, --, 
   {{0x845404a9,0xd5480133,0x40a40cc8,0xd1380cc9}},	//   ярәт_, _بلاو_, мъян_, юхи_, 
   {{0x3e64066d,0x53440cca,0x8f0801d5,0x00000000}},	//   zött_, _охла, охга_, --, 
   {{0x7d080158,0x00000000,0x00000000,0x00000000}},	//   ådsn, --, --, --, 
   {{0xb64007ad,0xe2a80ccb,0x42040107,0x4304009f}},	//   _ｍｍ_, _راهن_, _ончо_, _آيوَ_, 
   {{0x7a200ccc,0x82600451,0x3d940063,0x4638010f}},	//   _löts, _جهون, тиср, קעלע, 
   {{0x321c0124,0x9f4005da,0xeeb80075,0x787803b2}},	//   _hovy_, bekà_, _елиш_, lívf, 
   {{0x3e6401ed,0x7c840ccd,0x321c02fb,0x3ec40166}},	// [890] tött_, туре, _kovy_, _исэб, 
   {{0x6ae000fe,0x26d80171,0x00000000,0x00000000}},	//   নিলো, _īso_, --, --, 
   {{0x64dc0cce,0x7a200ccf,0xdd9000db,0x26d80153}},	//   _महेश, _rött, _حوپ_, _ūso_, 
   {{0x9f400cd0,0x9f4c067c,0x61fc00de,0x7a200139}},	//   leká_, ènço_, ēsli, _sött, 
   {{0x200c013f,0xa9080014,0x7a200cd1,0x870400be}},	//   _ɑfi_, _کٲزٕ_, _pött, ببال, 
   {{0xf7700cd2,0x321c0122,0x9f400093,0x81e000fe}},	//   جام_, _novy_, neká_, _পোন_, 
   {{0x69d4014b,0x9f4c00bc,0x7a200254,0x6d400174}},	//   _icze, čném_, _vött, úlah, 
   {{0xe8e800aa,0x00000000,0x00000000,0x00000000}},	//   _ورځو_, --, --, --, 
   {{0x7a200cd3,0x68f40175,0xdddc00d0,0xe2840798}},	//   _göts, _hszd, _lipš, нлии, 
   {{0xf674022e,0x00000000,0x00000000,0x00000000}},	//   _агуэ, --, --, --, 
   {{0x644406af,0xb5c80014,0x321c01f5,0xa878008f}},	//   éhis, _زونم_, _dovy_, ּאָר, 
   {{0xdb0401a2,0xa29400d4,0x934001ec,0x00000000}},	//   _leká, _заді, _әнше, --, 
   {{0xd12c0cd4,0x69d40034,0x442c0cd5,0xd24c0cd6}},	//   لمی_, _ocze, _ilg_, _گنو_, 
   {{0xd00c005e,0x321c010e,0xdc980cd7,0xdb0401ef}},	//   _ۇلى_, _govy_, зташ_, _neká, 
   {{0x22440cd8,0xb28400c7,0xd24c029c,0x00000000}},	//   milk_, _рыцк, _دنو_, --, 
   {{0x69d407c5,0x321c03d1,0x52100075,0xbfa80014}},	//   _acze, _zovy_, _адәт, _کاژٕ_, 
   {{0x442c0cd9,0xba4401d3,0xde3c0092,0x2f5400c0}},	// [8a0] _mlg_, نچسٹ, ደማይገ, _атэс, 
   {{0x4a400cda,0x00000000,0x00000000,0x00000000}},	//   гнув, --, --, --, 
   {{0xd8240cdb,0x442c0cdc,0x9d440cdd,0x7a200267}},	//   нджи, _olg_, _ченд, _söts, 
   {{0x3d1c00af,0x22440076,0xc7ac0592,0xd5d00073}},	//   नहीं_, hilk_, مّم_, _साहज, 
   {{0xdb040cde,0x2c0c00cd,0x00000000,0x00000000}},	//   _feká, हारं_, --, --, 
   {{0xceb00bd9,0x8ca40c22,0xd9440798,0x00000000}},	//   ריג_, टीको, _зеги, --, 
   {{0x442c0cdf,0x85b40050,0x321c00c7,0x22440175}},	//   _blg_, راوس_, _rovy_, dilk_, 
   {{0x442c007b,0xda0c0ce0,0x321c02f0,0x3ea00ce1}},	//   _clg_, सावत_, _sovy_, _otit_, 
   {{0x442c0ce2,0x9f500139,0x06800131,0x676401af}},	//   _dlg_, _bayí_, ъгән, _антҡ, 
   {{0x442c08fb,0xc21400d4,0xf5440240,0x00000000}},	//   _elg_, еєю_, _ንፕረዚ, --, 
   {{0x3ea00ce3,0x6d480276,0x53a40ce4,0xeb0c00dc}},	//   _atit_, şeaz, _заеб, _सप्त_, 
   {{0x442c0ce5,0x6e940166,0x00000000,0x00000000}},	//   _glg_, киму, --, --, 
   {{0x93440ce6,0x321c0022,0x3ea0004d,0x9f4000d0}},	//   _янде, _tovy_, _ctit_, teká_, 
   {{0xbe880ce7,0x44100ce8,0x442c0064,0xdb0c0241}},	//   ессе_, _афәт, _zlg_, _àjùl, 
   {{0x2d840ce9,0xdb040124,0x24880419,0x00000000}},	//   äle_, _reká, ňame_, --, 
   {{0x3ea0038f,0x799c0cea,0xdb0402fb,0x656400c5}},	//   _ftit_, _afrw, _seká, ühhi, 
   {{0xdb040ceb,0x6494031c,0x00000000,0x00000000}},	// [8b0] _peká, _aġil, --, --, 
   {{0xdddc00f3,0x799c03ac,0x7a20032e,0x00000000}},	//   _tipš, _cfrw, _sötr, --, 
   {{0x7a200793,0x6c54016c,0x2d580cec,0xff5000f2}},	//   _pötr, _акну, _цинь_, _نخی_, 
   {{0x69d4068f,0x22440010,0x00000000,0x00000000}},	//   _wcze, zilk_, --, --, 
   {{0x799c00a9,0x8038008f,0x69d40ced,0x041c00cc}},	//   _ffrw, ענדע_, _tcze, _বগলী_, 
   {{0x9f50006a,0x69d4068f,0x442c0005,0xdb04037e}},	//   _yayâ_, _ucze, _slg_, _bekæ, 
   {{0x442c0cee,0x224409a8,0xcacc03d4,0x00000000}},	//   _plg_, vilk_, ৰিওফ, --, 
   {{0x47840022,0x2ca0022e,0x00000000,0x00000000}},	//   _зызб, _mthd_, --, --, 
   {{0xdc2c0a28,0xe6940cef,0x442c0cf0,0x22440427}},	//   _jñān, _ризы, _vlg_, tilk_, 
   {{0x442c0421,0x20c400cd,0x9f400139,0x00000000}},	//   _wlg_, _विदध, lekç_, --, 
   {{0xa2bc0cf1,0x442c0cf2,0x65140cf3,0x3ea00cf4}},	//   _शिक्, _tlg_, _جوائ, _stit_, 
   {{0x442c0cf5,0x22440cf6,0x3ea00cf7,0x728801c6}},	//   _ulg_, silk_, _ptit_, мбөг_, 
   {{0x53980bd4,0x26dc002f,0x22440cf8,0x00000000}},	//   _חינו, ntwo_, pilk_, --, 
   {{0x27fc0cf9,0x78780798,0xabc401e0,0x00000000}},	//   hdwn_, míve, ҫарҙ, --, 
   {{0xdc2800aa,0x2ee8004e,0x78780cfa,0x00000000}},	//   وسره_, _epaf_, líve, --, 
   {{0x5f040cfb,0x153c0055,0x26dc007f,0x00000000}},	//   _азиа, _cāṇī, ktwo_, --, 
   {{0x78780cfc,0x27fc0cfd,0x3ea00194,0x63a803fa}},	// [8c0] níve, ddwn_, _utit_, iben, 
   {{0x3b000cfe,0x7f40003a,0x00000000,0x00000000}},	//   rviq_, úmqu, --, --, 
   {{0x63a80399,0xd7f80cff,0x5f440d00,0x28c80d01}},	//   kben, дул_, _سنگل, ांगि, 
   {{0x69c0025a,0x63a80d02,0x64940135,0x862001b9}},	//   _ôlen, jben, _vġil, یکلل, 
   {{0x63a80d03,0x3b000d04,0x81b400cc,0x6d4006ea}},	//   dben, qviq_, _ছান_, úlav, 
   {{0x63a80d05,0x7878012c,0x6b9c01f5,0x64440066}},	//   eben, díve, _zfsg, èhin, 
   {{0xd9440d06,0xdb040790,0x25a80451,0x00000000}},	//   _реви, _bekç, ردٻي_, --, 
   {{0x63a80d07,0xd7040d08,0xb9dc0092,0x00000000}},	//   gben, _изби, _አሳ_, --, 
   {{0x97e803be,0x26dc068f,0xd1c80d09,0x78780120}},	//   ışdı, ctwo_, мунд_, gíve, 
   {{0x6488009d,0x00000000,0x00000000,0x00000000}},	//   мсөг_, --, --, --, 
   {{0x1be00d0a,0x427001c6,0xdb0401f4,0x00000000}},	//   खभाल_, ргэс, _hekä, --, 
   {{0x9f5001e1,0x78780120,0x705402f2,0xf1d4000d}},	//   _bayà_, bíve, انحا, _दावन, 
   {{0x78780798,0xdd380356,0x61400022,0x00000000}},	//   cíve, _păşe, иҵәа, --, 
   {{0xdb14033b,0xd24c01d9,0xdb0401f4,0x2ba400ce}},	//   mayè, _گنڈ_, _mekä, गुना, 
   {{0xdb040793,0x7d24014b,0x00000000,0x00000000}},	//   _lekä, афте, --, --, 
   {{0xc61c0d0b,0x4fc40d0c,0xe7d00d0d,0x26dc0076}},	//   _भव्य_, _рска, _हाइप, ytwo_, 
   {{0xdb040840,0xeb0c012c,0x6b740d0e,0xdb140100}},	// [8d0] _nekä, समेत_, улау, nayè, 
   {{0x63a80d0f,0x6abc0212,0x4e4002f2,0xacf80064}},	//   zben, _vvsf, _ئێسق, _зноу_, 
   {{0x656c03f9,0xaab40220,0x78780d10,0x00000000}},	//   ƙahi, _әйгі, zíve, --, 
   {{0xdb040d11,0xdb140100,0x64a401ec,0x6d400d12}},	//   _bekä, kayè, ңала, úlau, 
   {{0x787806ed,0x63a801e3,0x27fc015d,0x99b000cc}},	//   xíve, vben, rdwn_, _চাৰক, 
   {{0x787806ed,0x9f500241,0xdb04013d,0x63a80d13}},	//   víve, _jayá_, _dekä, wben, 
   {{0x26dc0034,0xdb0403e0,0x00000000,0x00000000}},	//   stwo_, _pekç, --, --, 
   {{0x78780d14,0x63a80d15,0xc6a4084c,0xdb1402e2}},	//   tíve, uben, _аржи, fayè, 
   {{0xdb040d16,0x06980d17,0xdb140100,0x6ae00011}},	//   _gekä, _آخرت_, gayè, নিকো, 
   {{0x63a80d18,0x78780d19,0x7d080267,0x6e20007c}},	//   sben, ríve, ådsk, ölbl, 
   {{0x787806ed,0x9f4c0316,0x516400f7,0x614400d8}},	//   síve, čním_, лүшү_, уена, 
   {{0xdb080122,0x2ba40d1a,0x05dc002b,0x00000000}},	//   šnéh, गुमा, प्रब, --, 
   {{0x9f500241,0x64480005,0xf8d00950,0x8384005b}},	//   _bayá_, miei, _हम्प, _рыже, 
   {{0xdd900d1b,0x64480d1c,0x00000000,0x00000000}},	//   صور_, liei, --, --, 
   {{0x1fb40276,0x6448062c,0x61440d1d,0x00000000}},	//   _йспр, oiei, _щека, --, 
   {{0x8c400d1e,0xaca800dd,0xdb1406af,0xb17c01e4}},	//   бесе, کھیے_, layé, reĥt, 
   {{0x9b0401ec,0x99e40026,0xddb8011c,0x00000000}},	// [8e0] ызад, лжад, _пунш_, --, 
   {{0x9a680d1f,0x64480d20,0xd5d004af,0x00000000}},	//   رمال_, hiei, _साइज, --, 
   {{0xdb040844,0x64480d21,0x62800142,0x09e00229}},	//   _sekä, kiei, imlo, сохн, 
   {{0x7d540201,0x00000000,0x00000000,0x00000000}},	//   _መሆናቸ, --, --, --, 
   {{0x64480d22,0xb3140327,0x764400c7,0xf1d401f9}},	//   diei, ིདབང_, аҭаа, _दालन, 
   {{0x38c80d23,0x62800d24,0xdb1402e2,0x00000000}},	//   _لاری_, jmlo, vayè, --, 
   {{0x64480d25,0x54e400c6,0x629c04d4,0x20c40d26}},	//   fiei, استق, íson, _विषध, 
   {{0x62800d27,0x4d78008f,0xdef00092,0xdb040a43}},	//   emlo, ערקע, _ልጁን_, _tekä, 
   {{0xd5d40d28,0x73c40032,0x634002d3,0x629c01e4}},	//   _متاث, гәһе, _ክትግበ, ŭson, 
   {{0xdb140d29,0x64480076,0xdb0401e3,0x00000000}},	//   rayè, aiei, _gekå, --, 
   {{0x6448003e,0x80a0072d,0xdcfc0171,0xf1b8025c}},	//   biei, یمین, _cepļ, raġ_, 
   {{0x64480d2a,0x3d080d2b,0x00000000,0x00000000}},	//   ciei, हिने_, --, --, 
   {{0x9f500789,0x5f000d2c,0x6e940d2d,0x00000000}},	//   _payá_, शिष्_, ригу, --, 
   {{0x2c0003d4,0x705400cf,0xc2c001c8,0x00000000}},	//   _একেই_, انڭا, _ايوي, --, 
   {{0x621000dc,0xd9b000cc,0x28c80d2e,0x00000000}},	//   तारौ_, _চাংম, ांछि, --, 
   {{0x80a00d2f,0x00000000,0x00000000,0x00000000}},	//   _امين, --, --, --, 
   {{0xead40d30,0x3c58084c,0xe9d80d31,0x00000000}},	// [8f0] розь, уитэ_, кмач_, --, 
   {{0x6d400d32,0xbf140014,0x7f3c008f,0x64480c86}},	//   úlas, _اوٝب, _רעזו, ziei, 
   {{0x64480368,0x98e0037e,0xdd38054e,0x00000000}},	//   yiei, ne版i, măşa, --, 
   {{0xead40d33,0x79940107,0x00000000,0x00000000}},	//   _комь, _ҳирф, --, --, 
   {{0x2ba40b7c,0x62800072,0x69dc08df,0x9bb8011a}},	//   गुणा, ymlo, _पापी, _בצרפ, 
   {{0xc984013e,0x79940d34,0x78780419,0x00000000}},	//   _буби, _гирф, tívc, --, 
   {{0x64480077,0x3d080d35,0x00000000,0x00000000}},	//   tiei, हिये_, --, --, 
   {{0x7cec0d36,0x57b000cf,0x2408014b,0x00000000}},	//   _hörö, _ۇڭۇز, тнии_, --, 
   {{0x64480428,0x7cec01ed,0x00000000,0x00000000}},	//   riei, _körö, --, --, 
   {{0x64480153,0x3d08000d,0x5ea400f2,0x78780d37}},	//   siei, हिमे_, یمجل, míva, 
   {{0x69dc0d38,0x78780d39,0xc32003f4,0x62800d3a}},	//   _पानी, líva, _বেশি_, rmlo, 
   {{0x5f040d3b,0x660c02a8,0xdb1406af,0x649400c0}},	//   азма, ɓaka, sayé, _ašig, 
   {{0x9e640d3c,0x02a40640,0xdb1406af,0x38bc0248}},	//   لاسن, _срем, payé, _kárá_, 
   {{0xd3540375,0x38bc01e1,0x21a40d3d,0x00000000}},	//   _דיני_, _járá_, _тикм, --, 
   {{0xdea001d3,0x92000171,0x00000000,0x00000000}},	//   _ڈیجی, _šāga, --, --, 
   {{0x38bc01e1,0x38ac01e1,0x78780022,0xdb0400d7}},	//   _lárá_, _lòrò_, kíva, _odkô, 
   {{0x20100d3e,0x6d400d3f,0x451800cc,0xa29c06be}},	// [900] _inyi_, úlar, তনিক_, _ərşə_, 
   {{0x7878012c,0x00000000,0x00000000,0x00000000}},	//   díva, --, --, --, 
   {{0x26180918,0xa3b4000d,0xc8c401d9,0x5cf4010a}},	//   पानी_, झरा_, لوٕن_, _тяпу, 
   {{0x2ca40077,0x20000d40,0x1b4801f0,0x00000000}},	//   ílde_, ndki_, _азми_, --, 
   {{0x38bc01e1,0x38ac0248,0x7cec01e6,0x8f9802e4}},	//   _bárá_, _bòrò_, _förö, דיני, 
   {{0x69dc069f,0x20c40d41,0x7cec01ed,0x4788074d}},	//   _पायी, _विंध, _görö, ĕсем_, 
   {{0x01b80d42,0xc32004c5,0xdb0400d0,0xe8500133}},	//   ংলাদ, _বেলি_, _nekú, _کۆند, 
   {{0x20100d43,0x94840d0e,0xdb2401e1,0x787801ef}},	//   _nnyi_, шылд, _ìpór, bíva, 
   {{0x46a00d44,0x38bc0248,0x38ac01e1,0x7cec0139}},	//   _матв, _fárá_, _fòrò_, _yörö, 
   {{0x201000b4,0x38ac0428,0x2000031c,0x5184009d}},	//   _anyi_, _gòrò_, edki_, иуна, 
   {{0xdb140548,0x2258020c,0x9f8c000d,0x85200107}},	//   kayï, éska_, _mõõk_, _мӯъҷ, 
   {{0x4ea4006c,0x9200005f,0x13680d45,0x04d8011a}},	//   ирга, _šāda, _ишли_, _יקבל, 
   {{0xb8d80d46,0xdb040241,0x2eec0d47,0xc438011a}},	//   _ཚས_, _eekú, ïef_, _בתאי, 
   {{0x20100d48,0xdb0401e1,0xa37401f7,0x00000000}},	//   _enyi_, _fekú, _اَهڙ, --, 
   {{0x1e3801d9,0x2ca40d49,0xdd380356,0x412400f0}},	//   اغُک_, ëld_, răşa, _војо_, 
   {{0x7cec0d4a,0x8f440d4b,0x7054034c,0xc0c40798}},	//   _sörö, _вход, _دنبا, _туше_, 
   {{0x7648009a,0x64940d4c,0xf3f80154,0x7cec00e5}},	// [910] _omdy, _išie, _আচার_, _pörö, 
   {{0x6d340d4d,0xe91800d4,0x0904009b,0x78780d4e}},	//   _геоф, лозі_, ичем, víva, 
   {{0x7cec0d4f,0x88c40228,0x69dc0490,0x38bc0cad}},	//   _vörö, شتال, _पाठी, _rárá_, 
   {{0x27e80510,0x6e24047e,0xa7b800f7,0x78780d50}},	//   ýan_, _hohb, улду_, tíva, 
   {{0x7cec00dd,0x76480175,0xab0000bc,0x38bc01e1}},	//   _törö, _bmdy, _kříž_, _párá_, 
   {{0xd6cc0058,0x78780077,0x00000000,0x00000000}},	//   رقى_, ríva, --, --, 
   {{0x6e24016d,0x29040d51,0xdef0069d,0x787800e4}},	//   _mohb, _éla_, ልቅና_, síva, 
   {{0xd36c05d9,0x3d0801bc,0x95d40d52,0xfd580375}},	//   ڙهي_, हिते_, адәт_, ישוי_, 
   {{0xdb040d53,0x03a0013e,0xe214007b,0x38ac0241}},	//   _sekú, биқо, مبدع, _tòrò_, 
   {{0x6e24014f,0x649400c0,0x00000000,0x00000000}},	//   _nohb, _ašie, --, --, 
   {{0x9f5c038e,0x26180d54,0x20000a73,0x660002d0}},	//   ětí_, पाठी_, tdki_, _ialk, 
   {{0x66000d55,0x6e2401ab,0xca3008b0,0x3ec80107}},	//   _halk, _aohb, ﺭﺍﺭ_, ақим_, 
   {{0x238401d9,0x53980302,0x200000ab,0x1858010f}},	//   _أشِ, _עיסו, rdki_, רכרע, 
   {{0xb3740302,0x6600049b,0xdb0400d2,0x64940cf4}},	//   _بدمش, _jalk, _tekú, _išib, 
   {{0x66000d56,0x6298004c,0xdca40d57,0x6d400162}},	//   _malk, _huwo, саби, úlap, 
   {{0x66000d58,0x62980d59,0xebb80a28,0x201001f2}},	//   _lalk, _kuwo, yoḥ_, _unyi_, 
   {{0x63b800a9,0x62980066,0x1868036b,0x7b840131}},	// [920] _mewn, _juwo, қади_, زارە, 
   {{0x63b80a73,0x62980d5a,0x69dc0490,0x66000d5b}},	//   _lewn, _muwo, _पाणी, _nalk, 
   {{0x6298014f,0x5fbc0254,0xd9440d5c,0xa3f8076e}},	//   _luwo, _्याल, щежи, ्याप_, 
   {{0x63b80d5d,0x66000d5e,0x764802c4,0xb9000d5f}},	//   _newn, _aalk, _smdy, _दम_, 
   {{0x62980d60,0x6e24014f,0xe6b4036b,0xd6280138}},	//   _nuwo, _yohb, قلنگ, лоде_, 
   {{0xceb00bd9,0x7a20002f,0x66000d61,0xd9b00154}},	//   ליד_, _lötz, _calk, _চাকম, 
   {{0x66000d62,0x7ae40d63,0x969001b9,0x5504009d}},	//   _dalk, ltit, _کیتش, счла, 
   {{0x7ae4004b,0x78780048,0x62980d64,0xd24c0014}},	//   otit, mívo, _buwo, کۆت_, 
   {{0x8c180d65,0x1368023a,0x2fdc010e,0x5724007b}},	//   רופי, ышки_, _öwgi_, _ارزق, 
   {{0x66000d66,0x7ae40d67,0x62980d68,0x8af800c8}},	//   _galk, itit, _duwo, נהיי, 
   {{0xefe402d3,0x7ae4034b,0x63b80368,0xd6d8009e}},	//   _ምሳይ_, htit, _fewn, _ধনিয, 
   {{0x6e240d69,0x7ae40d6a,0x787801f1,0xd9dc009e}},	//   _sohb, ktit, zívn, ড়িম, 
   {{0x447804ac,0x62980337,0x6e240076,0x7ae401e4}},	//   _ענדע, _guwo, _pohb, jtit, 
   {{0x7ae40d6b,0x66000d6c,0x63b8068f,0xdb1400d2}},	//   dtit, _xalk, _zewn, gayí, 
   {{0x90a40d6d,0x63b80204,0x7ae40d6e,0x8bc40d6f}},	//   _احتم, _yewn, etit, йсад, 
   {{0x7a200086,0x7ae40d70,0x6e24013f,0x6298020b}},	//   _götz, ftit, _wohb, _yuwo, 
   {{0x2fc80d71,0x7ae40d72,0x78780038,0x9e6404fb}},	// [930] _idag_, gtit, tívn, _ژاپن, 
   {{0x80d8015b,0xdb240d73,0x1828036b,0x00000000}},	//   ববর্, غولی, یقلی_, --, 
   {{0x7ae40af5,0x6f0c0232,0x7d080d74,0x27d80276}},	//   atit, _hrac, ådst, иджь_, 
   {{0x66000d75,0x6f0c0d76,0x2df40014,0x787801f1}},	//   _salk, _krac, _آگر, sívn, 
   {{0x66000d77,0xd3640d78,0xda08000d,0x8c9c0d79}},	//   _palk, _آه_, _होवत_, _खंडो, 
   {{0xd1240d7a,0x6aac0109,0x62980d7b,0x2ba4012c}},	//   _قم_, mpaf, _ruwo, गुरा, 
   {{0x63b8006d,0xe3b00491,0x66000d7c,0x62980d7d}},	//   _pewn, ورة_, _valk, _suwo, 
   {{0x66000d7e,0x6f0c0d7f,0x6aac01f5,0x00000000}},	//   _walk, _orac, opaf, --, 
   {{0x27ec0d80,0x68e40d81,0x6f0c063f,0x66000d82}},	//   _iben_, lthd, _nrac, _talk, 
   {{0x2fc80d83,0x63b8068f,0x60e80d84,0x317c0331}},	//   _adag_, _wewn, амом_, _bzvz_, 
   {{0x6f0c0d85,0x27ec0d86,0x7ae4009d,0x68e40175}},	//   _arac, _kben_, ztit, nthd, 
   {{0x62980d87,0x7ae40d88,0x68e40368,0x6aac01e4}},	//   _tuwo, ytit, ithd, kpaf, 
   {{0xc3040d89,0x27ec0d8a,0x6f0c0d8b,0x64940003}},	//   _دباو, _mben_, _crac, _eġit, 
   {{0x7ae4074d,0x2fc80194,0x5bb005f9,0xf38001e0}},	//   vtit, _edag_, जर्व, _яғым, 
   {{0x27ec09f0,0x6f0c0d8c,0x7ae40784,0x63500092}},	//   _oben_, _erac, wtit, _ይቆጣጠ, 
   {{0x27ec005a,0x2ba40b02,0x00000000,0x00000000}},	//   _nben_, गुला, --, --, 
   {{0x7ae40d8d,0x6f0c0d8e,0x68e40042,0x9aa401d9}},	// [940] utit, _grac, ethd, زماو, 
   {{0x27ec0d8f,0x7ae40d90,0x78780d91,0x2fc80175}},	//   _aben_, rtit, tívo, _zdag_, 
   {{0x7ae40d92,0x6f0c0552,0xd238010f,0xcc800150}},	//   stit, _zrac, סגעל, _ﺣﯟﺍﮔ, 
   {{0x7ae40d93,0xb6c801ed,0x27ec0200,0x6f0c02d0}},	//   ptit, ماتے_, _cben_, _yrac, 
   {{0x7ae40d94,0xd9d00075,0x6f0c00d8,0xa3ac0037}},	//   qtit, _يەرگ, _xrac, कडन_, 
   {{0xd9440d95,0x1f5c0092,0x00000000,0x00000000}},	//   _деги, _ወንድም, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25a40076,0x00000000,0x00000000,0x00000000}},	//   _efll_, --, --, --, 
   {{0xd2580601,0xcc38010f,0x00000000,0x00000000}},	//   ицо_, יעקט, --, --, 
   {{0x6f0c0d96,0xe6d808a5,0x4270013d,0x00000000}},	//   _rrac, _óráð, мгыс, --, 
   {{0x4a7804ac,0x6494012c,0x2fc800ca,0xa5940d97}},	//   שריב, _všic, _pdag_, _хрущ, 
   {{0x40340c9e,0x6aac022c,0x35e000e1,0x00000000}},	//   деюс, ypaf, _नाड़, --, 
   {{0x64940010,0xb8fc0327,0xfbc000eb,0x00000000}},	//   _išia, _ཡའ_, ইলাত, --, 
   {{0xe3b8002d,0x68e40042,0x656c0205,0x00000000}},	//   njűn_, ythd, şahe, --, 
   {{0x6f0c0d98,0xac180d99,0x81e000fe,0x705401ec}},	//   _wrac, бову_, _পোক_, _ىنتا, 
   {{0x2610068f,0x69dc0490,0x2fc80d9a,0x31340075}},	//   _धोनी_, _पाही, _udag_, _меһр, 
   {{0x6f0c0d9b,0x27ec0649,0x97e80d9c,0x785c007f}},	// [950] _urac, _rben_, ışlı, tčvn, 
   {{0x27ec0d9d,0x6aac00df,0x0ba800d1,0x00000000}},	//   _sben_, rpaf, _ھاجى_, --, 
   {{0xeff002d3,0x649400d0,0x6aac01e4,0xc8640d9e}},	//   _ውሑድ_, _ošia, spaf, отди, 
   {{0x9ce801d9,0xae180034,0x68e40d9f,0x3d080da0}},	//   _اوَے_, दावन_, rthd, हिरे_, 
   {{0xe5a40da1,0x00000000,0x00000000,0x00000000}},	//   пили, --, --, --, 
   {{0xe5a40364,0x59e00490,0x80d8009e,0x978001d5}},	//   чики, _पायर, _বনস্, ریله, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x27ec0da2,0x63780276,0x26180da3,0x537000ec}},	//   _uben_, йспр_, पाही_, ڙهيء, 
   {{0x0518015b,0xe3b00da4,0xe7080451,0x28d00da5}},	//   তনের_, ورک_, _دڪان_, _हिडि, 
   {{0x29040789,0x46600c50,0xc6840244,0xb5d400f3}},	//   _álas_, _تۇتق, _بێتن_, _ожуј, 
   {{0x21680da6,0xa30801d9,0x00000000,0x00000000}},	//   сини_, _گراے_, --, --, 
   {{0xc2f0015b,0xd12c0592,0xcfac0150,0x00000000}},	//   জিবি_, امَ_, _ﺳﯩﺮﻗ, --, 
   {{0x443c006f,0xdb140784,0x00000000,0x00000000}},	//   mhu_, kayá, --, --, 
   {{0x443c0da7,0x3d080da8,0x61440da9,0x161c0412}},	//   lhu_, हिले_, _нела, पायर_, 
   {{0x443c0daa,0x91b80375,0x20540dab,0xc3200154}},	//   ohu_, _המצי, _нтир, _বইটি_, 
   {{0x443c0dac,0x4ac40dad,0x70380022,0x98a4010b}},	//   nhu_, _लिखव, _мчыс_, җиде, 
   {{0x443c0dae,0x8c400daf,0x00000000,0x00000000}},	// [960] ihu_, хете, --, --, 
   {{0x443c0db0,0x97e80db1,0x6d4001ab,0x00000000}},	//   hhu_, ışmı, ùlac, --, 
   {{0x443c0db2,0xd88801ed,0x69dc0db3,0x71e800fe}},	//   khu_, مپئن_, _पारी, _কোঁচ_, 
   {{0x443c0db4,0x01c00729,0x261002e5,0x5fbc0490}},	//   jhu_, ্ভিদ, _धोबी_, ्णिल, 
   {{0x443c0db5,0x7878022a,0x7c2403b2,0x90a00150}},	//   dhu_, lívk, mjir, _ﺍﻟﺤﻔ_, 
   {{0x443c0db6,0xa7fc045f,0x7c240db7,0x4b780375}},	//   ehu_, _skűt, ljir, _לאכו, 
   {{0x443c0084,0x5fbc012c,0xe3b8000f,0x785c0100}},	//   fhu_, ्णाल, rjűn_, lčvm, 
   {{0x7c240db8,0x443c0db9,0x3f800268,0xe3b8002d}},	//   njir, ghu_, _oziu_, sjűn_, 
   {{0xdb0401ed,0x97000131,0x26180073,0xa3ac0dba}},	//   _nekü, _سېغى, पाशी_, _कभर_, 
   {{0xdb040124,0x31340dbb,0x7c24026c,0x96640dbc}},	//   _hekó, деор, hjir, _экзе, 
   {{0x443c0dbd,0x64940dbe,0xd538009d,0x00000000}},	//   bhu_, _išin, _уяач_, --, 
   {{0x443c0dbf,0x7c240dc0,0xdb0401ed,0x7878013a}},	//   chu_, jjir, _bekü, dívk, 
   {{0x7c24002d,0x4ea40a89,0x2d740131,0x69dc0027}},	//   djir, ярна, ﺸﯩﻨﻰ_, _पाली, 
   {{0xdb04033f,0xdcfc00b8,0x00000000,0x00000000}},	//   _lekó, _śvād, --, --, 
   {{0xda0800af,0xc2780375,0x629c00d7,0x00000000}},	//   _होइत_, _הרגי, ísov, --, 
   {{0x7c240dc1,0x41580375,0xdb0401d3,0x00000000}},	//   gjir, _לדוג, _fekü, --, 
   {{0xdb040dc2,0x7b180276,0x629c01e4,0x00000000}},	// [970] _gekü, потр_, ŭsov, --, 
   {{0x443c0007,0xca700dc3,0x7c2401c8,0x79a400f0}},	//   zhu_, رناک, ajir, ерце, 
   {{0x24880030,0x7c3809c2,0x7c24058a,0x443c0588}},	//   ňami_, ñará, bjir, yhu_, 
   {{0xf7700dc4,0x64940064,0x443c0200,0x00000000}},	//   گام_, _ašin, xhu_, --, 
   {{0x26180dc5,0x443c0dc6,0x66e4039b,0xdb140407}},	//   पाली_, vhu_, фола, payá, 
   {{0xf7700199,0x00000000,0x00000000,0x00000000}},	//   دام_, --, --, --, 
   {{0x443c0dc7,0x64840332,0xb6cc06be,0x35f80066}},	//   thu_, nóig, _şütü, ثرند_, 
   {{0x2910003e,0xd24c004b,0x443c0418,0x870401af}},	//   _irza_, یني_, uhu_, _нязе, 
   {{0x443c06e4,0x13040dc8,0x64840332,0x00000000}},	//   rhu_, дный_, hóig, --, 
   {{0x443c0dc9,0x68e001e6,0x3c3c00e4,0x64840022}},	//   shu_, _älds, _míva_, kóig, 
   {{0x443c0dca,0xdb040dcb,0x3c3c03b2,0xdcf400e2}},	//   phu_, _jekò, _líva_, ācīb, 
   {{0x291001fa,0x26100dcc,0x3c3c00e4,0x443c01b3}},	//   _mrza_, _धोती_, _oíva_, qhu_, 
   {{0xdb040d29,0x94240075,0x7c24022e,0x23280117}},	//   _lekò, _تونۇ, vjir, _фоли_, 
   {{0x29100dcd,0x64840332,0xdb1406be,0x00000000}},	//   _orza_, fóig, layç, --, 
   {{0xdcb00075,0xa2d80825,0x6484007b,0xc32000fe}},	//   ئىر_, फूर्, róif, _বেচি_, 
   {{0x6e200008,0xbd080150,0x8c9c000d,0x97e803e0}},	//   ölbr, _ورﯨﻨ, _खंरो, ışkı, 
   {{0x1a040dce,0x59e0098a,0x5f740dcf,0x7c240dd0}},	// [980] мпам, _पादर, _تاثر, rjir, 
   {{0x29100dd1,0x648400c6,0x3ea00538,0x7c240009}},	//   _brza_, lóid, _iuit_, sjir, 
   {{0xd00c0dd2,0x78780dd3,0x3ea007ea,0x3c3c00e4}},	//   _صلی_, lívi, _huit_, _eíva_, 
   {{0x3ea00dd4,0xdb040100,0x64840dd5,0xc3200c58}},	//   _kuit_, _dekò, nóid, _বেছি_, 
   {{0x3ea00998,0x787800d8,0x7bc40dd6,0x87000cc9}},	//   _juit_, nívi, maiu, вяще, 
   {{0x3ea000d8,0x7bc40dd7,0x6484007b,0x00000000}},	//   _muit_, laiu, hóid, --, 
   {{0xa8180dd8,0x3ea00dd9,0xdb0400e4,0xf1c80150}},	//   تتەر_, _luit_, _tekó, _ﻓﺘﻨﺘ, 
   {{0x7bc40dda,0x672c0023,0x3ea0007f,0x159000d1}},	//   naiu, ënjë, _ouit_, ﻟﯘﺷﯩ, 
   {{0x68e004f3,0x3ea00ddb,0xa3ac05f9,0x6484007b}},	//   _äldr, _nuit_, कड़_, dóid, 
   {{0x7bc40ddc,0xdb140054,0x7878004e,0x6aa800d8}},	//   haiu, mayä, dívi, _éefe, 
   {{0x7bc40ddd,0x649400bc,0x648401e7,0xdb140dde}},	//   kaiu, _kšil, fóid, bayç, 
   {{0x3ea00ddf,0x68e004f3,0x28d000bc,0x648400ae}},	//   _buit_, _ålde, _हिसि, góid, 
   {{0x3ea00de0,0x7bc401ab,0xc7b0011a,0x02c0010a}},	//   _cuit_, daiu, כבר_, _айчо, 
   {{0x3ea00de1,0x246404fe,0x3c3c03b2,0x3b000327}},	//   _duit_, rēme_, _ríva_, dwiq_, 
   {{0x2f240de2,0x3ea0003a,0xac180de3,0x41d80375}},	//   _bëgë_, _euit_, пову_, _וחוס, 
   {{0x3ea00de4,0xdb040699,0xdb140de5,0x7bc40de6}},	//   _fuit_, _rekò, kayä, gaiu, 
   {{0x2f24002e,0x3ea00ba1,0x787800cf,0x00000000}},	// [990] _dëgë_, _guit_, cívi, --, 
   {{0xdb04007f,0xaf540022,0x648400e4,0x00000000}},	//   _pekò, _онқә, póig, --, 
   {{0x3ea0017a,0x7bc4054e,0x30bc0154,0xe7f40de7}},	//   _zuit_, baiu, _অমুস, ечлэ, 
   {{0xec3404ac,0xb52402a6,0x1ee8036b,0x799c03ac}},	//   _נאָר_, বনাথ_, _بویی_, _egrw, 
   {{0x2ee805b1,0x6b9c03ac,0xe8780014,0x9b4001d9}},	//   _jqaf_, _igsg, _ہجرچ_, _یۆہو, 
   {{0x648400d8,0x6014008e,0x26f000cc,0xd6740116}},	//   zóid, _kümä, চিলো_, ىڭلا_, 
   {{0x67d40640,0x00000000,0x00000000,0x00000000}},	//   _пову, --, --, --, 
   {{0x69c40de8,0x2ca00de9,0x6a78026c,0x58000131}},	//   lahe, _muhd_, dìfi, _مۈمك, 
   {{0xae5c0150,0x00000000,0x00000000,0x00000000}},	//   _ﺍﺳﺎﯞ_, --, --, --, 
   {{0x69c40dea,0x3ea00deb,0x26dc0bd7,0x64940024}},	//   nahe, _ruit_, muwo_, _išim, 
   {{0x26dc0dec,0x64840ded,0x3ea00dee,0x00000000}},	//   luwo_, tóid, _suit_, --, 
   {{0x69c40def,0x78780232,0x3ea00df0,0x6b9c0112}},	//   hahe, tívi, _puit_, _ngsg, 
   {{0x69c40df1,0x64840df2,0x82800116,0x7bc40099}},	//   kahe, róid, _иңиз, vaiu, 
   {{0x3ea000f7,0x63a80df3,0x69c40df4,0x2ca0020c}},	//   _vuit_, lcen, jahe, _buhd_, 
   {{0x63a80df5,0x69c40df6,0x6a780268,0x6abc03ac}},	//   ocen, dahe, cìfi, _awsf, 
   {{0x63a80df7,0x3ea00df8,0x26dc0df9,0x248c0dfa}},	//   ncen, _tuit_, kuwo_, nmem_, 
   {{0x2be00316,0x8d740131,0xcb640276,0x69c40dfb}},	// [9a0] _फारा, _ۋاپا, еате_, fahe, 
   {{0x63a80334,0x26dc0099,0x3b000309,0xda0800c5}},	//   hcen, duwo_, rwiq_, _होखत_, 
   {{0x63a80dfc,0xdb140dfd,0x248c0548,0x6abc03ac}},	//   kcen, wayä, kmem_, _ewsf, 
   {{0x63a80dfe,0x5e440014,0x26dc07a9,0x248c0dff}},	//   jcen, _آنگٕ, fuwo_, jmem_, 
   {{0x69c40e00,0x26dc0e01,0x248c0010,0x00000000}},	//   bahe, guwo_, dmem_, --, 
   {{0x69c40e02,0xdb1403f0,0x55040262,0x672c0e03}},	//   cahe, rayä, ечиа, äaja, 
   {{0x64940e04,0x63a8003a,0x00000000,0x00000000}},	//   _išij, fcen, --, --, 
   {{0x26dc0161,0xc5100150,0x63a80e05,0xdb140113}},	//   buwo_, ابوت, gcen, payä, 
   {{0x9f500548,0x88540375,0x28740124,0x96b80107}},	//   _mayó_, _נשמע_, _рырр, _хубу_, 
   {{0x63a80e06,0x25a806f6,0x7e600e07,0xdbdc01e1}},	//   acen, _قدمي_, émpl, _síìf, 
   {{0x63a80e08,0xc68c009f,0x00000000,0x00000000}},	//   bcen, _اِل_, --, --, 
   {{0x63a80e09,0x69c40e0a,0x161c0490,0x8538011a}},	//   ccen, zahe, पावर_, _מגבי, 
   {{0x69c40e0b,0x601401b8,0x244801f7,0x91e000fb}},	//   yahe, _sümä, _تجلي_, _йәнһ, 
   {{0x28d0000d,0x69c40009,0x00000000,0x00000000}},	//   _हिलि, xahe, --, --, 
   {{0x69c40e0c,0xbd680e0d,0x26dc0161,0x246400e2}},	//   vahe, ерте_, zuwo_, lēma_, 
   {{0x69c40e0e,0x9f500154,0x4178010f,0x8aa401f4}},	//   wahe, _cayó_, _מנוב, ержд, 
   {{0x63bc03b2,0x00000000,0x00000000,0x00000000}},	// [9b0] ðsni, --, --, --, 
   {{0x320c00d8,0x69c40798,0x248c0e0f,0x63a80e10}},	//   nddy_, uahe, zmem_, zcen, 
   {{0x69c40e11,0x26dc0e12,0x63a80e13,0x29000e14}},	//   rahe, wuwo_, ycen, uwha_, 
   {{0x69c40e15,0x26dc0e16,0x63a80e17,0x67d400db}},	//   sahe, tuwo_, xcen, тоду, 
   {{0x69c40e18,0x1cdc0135,0x290002b9,0x377406d3}},	//   pahe, _ལའོ_, swha_, лышс, 
   {{0x26dc0086,0x64940308,0xdb1c0241,0xdaa00116}},	//   ruwo_, _všim, _ìyáp, _ئەلپ, 
   {{0x26dc006f,0x9f5001e1,0x248c0e19,0x61e401e3}},	//   suwo_, _jayò_, tmem_, _öhli, 
   {{0x26dc0e1a,0x756801d3,0x63a80c5e,0x9f4001f4}},	//   puwo_, رینہ_, ucen, mekö_, 
   {{0x23780e1b,0x2b480e1c,0x14200e1d,0x9f500248}},	//   æsj_, nzac_, рдым, _layò_, 
   {{0x63a80e1e,0x248c09ab,0x2b48005a,0xc0240023}},	//   scen, smem_, izac_, _ሲቪላው, 
   {{0xa0680e1f,0x63a80e20,0x1cdc025c,0x00000000}},	//   дана_, pcen, _ལའེ_, --, 
   {{0x321c0e21,0x00000000,0x00000000,0x00000000}},	//   _envy_, --, --, --, 
   {{0xa2e40e22,0x442c058a,0xdcf40205,0x9f5003e3}},	//   _ролд, _iog_, _ıcım, _ücün_, 
   {{0x442c045a,0x2f8400fb,0x2b48012d,0x00000000}},	//   _hog_, ыҙын_, dzac_, --, 
   {{0x1fb40e23,0x442c0114,0xdca40e24,0x217400c8}},	//   _испр, _kog_, таби, _בײַם_, 
   {{0x442c0e25,0xdb0401b8,0x9f5001e1,0x785c0100}},	//   _jog_, _mekö, _dayò_, pčvi, 
   {{0x442c01d4,0x4f040e26,0x1e84049e,0x649401fa}},	// [9c0] _mog_, _анын_, _илим, _ašik, 
   {{0x4a400e27,0x442c0e28,0x8f340375,0x0a140014}},	//   анув, _log_, _סניף_, نہُک_, 
   {{0x442c0e29,0x2dd800c8,0xdb040793,0x9d440e2a}},	//   _oog_, _אַרב, _nekö, _ренд, 
   {{0x442c0e2b,0xca300e2c,0x2b48067c,0x461000f2}},	//   _nog_, ﺭﺍﺕ_, bzac_, یونر, 
   {{0x2b480210,0x98b00205,0x656c0e2d,0x00000000}},	//   czac_, ıcım_, şahl, --, 
   {{0x442c0e2e,0x649405a1,0xdb040e2f,0xdef001f3}},	//   _aog_, _ušij, _bekö, _ሌኒን_, 
   {{0x442c0e30,0x85000e31,0x5d78008f,0xa3ac0073}},	//   _bog_, لوون, ואַק, कडं_, 
   {{0x442c0e32,0x78780e33,0x00000000,0x00000000}},	//   _cog_, tívu, --, --, 
   {{0x442c0c30,0xb2740131,0xdc440092,0x00000000}},	//   _dog_, ллиш, _መወሰኑ, --, 
   {{0x442c0e34,0xc0d0001f,0x00000000,0x00000000}},	//   _eog_, ራለሁ_, --, --, 
   {{0x442c0e35,0xdb040e36,0xd4040116,0x765801f4}},	//   _fog_, _gekö, _аяли, mivy, 
   {{0x765805d9,0x312405f5,0x648401e7,0x73c402dd}},	//   livy, вдүг, róic, _сәке, 
   {{0x1cdc031c,0x9f500241,0x787806ea,0x661002d2}},	//   _ལའུ_, _sayò_, lívs, _ákkú, 
   {{0x442c0190,0xc20c0a81,0xdb0c0241,0x00000000}},	//   _zog_, _ؤن_, _ájùl, --, 
   {{0x442c0e37,0x2d840e38,0x00000000,0x00000000}},	//   _yog_, åle_, --, --, 
   {{0x3d0805ba,0x64b00e39,0x442c01d9,0x76580e3a}},	//   हिजे_, _fāif, _xog_, hivy, 
   {{0xbd680276,0x76580153,0x998801ef,0xfb340e3b}},	// [9d0] ерӂе_, kivy, _bobů_, антэ, 
   {{0x2b480df5,0x5fb40034,0x201c00e2,0x9f40005b}},	//   rzac_, ूरथल, ētie_, tekö_, 
   {{0x2d580323,0x26cc0e3c,0x39a40890,0x7d08005c}},	//   _чинь_, _sveo_, ршув, ædst, 
   {{0x1ab000fe,0xdd38011a,0x672c01f4,0x00000000}},	//   _চিৰা, _נערכ, äajo, --, 
   {{0x442c0e3d,0xd7ec0e3e,0xdb040793,0x64840798}},	//   _rog_, سكو_, _sekö, jóia, 
   {{0x442c07d6,0x69dc0574,0x7f3c0375,0xfd100e3f}},	//   _sog_, _पाटी, ועדו, _اجی_, 
   {{0x442c0e40,0x78780030,0x46dc0037,0x78ac0419}},	//   _pog_, tívt, _नमकह, ľové, 
   {{0x442c0e41,0x76580af9,0x78ac0306,0x48640395}},	//   _qog_, aivy, žové, _ръгб, 
   {{0x97e80e42,0x442c0e43,0xe2980364,0x765807a8}},	//   ıştı, _vog_, наи_, bivy, 
   {{0x442c0e44,0x76580e45,0x93c80050,0x00000000}},	//   _wog_, civy, ٘ایہ_, --, 
   {{0x009c0150,0xd7740023,0x00000000,0x00000000}},	//   _ﺍﻟﺒﺤ_, _ክሓተካ_, --, --, 
   {{0xe0440e46,0xe2980124,0x00000000,0x00000000}},	//   унми, ьаҿ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f400e47,0x21680e48,0x1d0800db,0x26180e49}},	//   ngké_, _пили_, неги_, पाटी_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5f04035b,0x30740354,0x6bb400d4,0x24c400cc}},	//   _бзиа, _вуьс, исує, _এমাহ, 
   {{0x1ec801b9,0xaab801d9,0x00000000,0x00000000}},	// [9e0] _ялпи_, ندٕر_, --, --, 
   {{0xd9ac01ad,0xde040798,0x00000000,0x00000000}},	//   टडेट, _спои, --, --, 
   {{0x1cdc038f,0x9c640e4a,0x61e4007c,0x1c10000d}},	//   _ལའི_, _مهدو, _öhlu, _ढोअल_, 
   {{0x64940135,0x53800092,0x00000000,0x00000000}},	//   _eġiz, _የዳዊት_, --, --, 
   {{0x237c0007,0xdb040022,0x6d680356,0x00000000}},	//   _nywj_, _pekõ, ăpaţ, --, 
   {{0xdb04000f,0x20000e4b,0x00000000,0x00000000}},	//   _dekô, heki_, --, --, 
   {{0x76580e4c,0x20000e4d,0xd944036b,0xd4980e4e}},	//   rivy, keki_, _севи, нри_, 
   {{0x20000e4f,0x76580e50,0x97e80e51,0x53e40006}},	//   jeki_, sivy, ışsı, уцка, 
   {{0x20000e52,0xe8500e53,0x02a0013d,0x00000000}},	//   deki_, _بۆند, йрэм, --, 
   {{0x32540e54,0x967400c0,0x00000000,0x00000000}},	//   рвор, _сыбі, --, --, 
   {{0x427001c6,0x64840332,0x4638010f,0x80a400cc}},	//   сгэс, móin, _רעבע, কীস্, 
   {{0x64840e55,0x2000037e,0x53a401f0,0xc950011a}},	//   lóin, geki_, _садб, ממת_, 
   {{0x26180073,0x00000000,0x00000000,0x00000000}},	//   पाची_, --, --, --, 
   {{0xf194040e,0xc32c0e56,0x648401e7,0x00000000}},	//   _киль, _رەپ_, nóin, --, 
   {{0x64b000a3,0x8c64010b,0x00000000,0x00000000}},	//   _gāid, гтад, --, --, 
   {{0x20000365,0xb3740023,0xade80e57,0x00000000}},	//   ceki_, _ካናዳን_, ञ्जन_, --, 
   {{0xaa540e58,0xdf5400f1,0x0dc80063,0xadd40114}},	// [9f0] аваш, _پريښ, _пуни_, _копљ, 
   {{0xdb040b21,0x64840e59,0x00000000,0x00000000}},	//   _rekô, jóin, --, --, 
   {{0xe7b40e5a,0x648408de,0xfd7401c4,0x00000000}},	//   لماد, dóin, _глээ, --, 
   {{0x64b0005f,0x6fb40e5b,0x27e80037,0x00000000}},	//   _jāie, ंडिं, üan_, --, 
   {{0x65c40e5c,0xe6940022,0x00000000,0x00000000}},	//   абла, аиды, --, --, 
   {{0x20000e5d,0x27e80e5e,0x648408de,0xade800cd}},	//   zeki_, żan_, góin, ञ्चन_, 
   {{0x29040e5f,0x85540e60,0x20000944,0x69d4002d}},	//   _èla_, دیار_, yeki_, _idze, 
   {{0x20000e61,0x00000000,0x00000000,0x00000000}},	//   xeki_, --, --, --, 
   {{0x20000e62,0x009c01ec,0x00000000,0x00000000}},	//   veki_, _ﺍﻟﺘﺤ_, --, --, 
   {{0xf7700e63,0x20000e64,0x99480e65,0xba900150}},	//   _راق_, weki_, nışa_, _ﺒﺎﻟﻙ_, 
   {{0x21680e66,0x60240e67,0x8c380112,0x69ac000d}},	//   тини_, адна, _mißb, _जलनी, 
   {{0x20540cdb,0x00000000,0x00000000,0x00000000}},	//   ртор, --, --, --, 
   {{0x1cdc003d,0x20000e68,0x4f040209,0xdea001d5}},	//   _ལའང_, reki_, анян_, غیدی, 
   {{0x443c0e69,0x20000e6a,0x69d407a9,0x6494031c}},	//   lku_, seki_, _ndze, _aġix, 
   {{0xdd900e6b,0xe1080e6c,0x200008a7,0x6280036e}},	//   زور_, _рейд_, peki_, mllo, 
   {{0x443c0e6d,0x64480e6e,0x69d40e6f,0x3ba4036b}},	//   nku_, nhei, _adze, слаҳ, 
   {{0x62800e70,0x64480e71,0x19c40e72,0x1ae400e9}},	// [a00] ollo, ihei, ибам, розм, 
   {{0x6f0805d1,0x64480e73,0x62800005,0x785c0841}},	//   çece, hhei, nllo, jčvr, 
   {{0x64480e74,0x62800e75,0xaab80e76,0x3c3c022c}},	//   khei, illo, ندەر_, _lívi_, 
   {{0x443c0bb8,0x64480e77,0x62800e78,0x69d40e79}},	//   jku_, jhei, hllo, _edze, 
   {{0x64480e7a,0x648401d3,0x62800200,0x99480139}},	//   dhei, tóin, kllo, bışa_, 
   {{0x443c0e7b,0x7ae40e7c,0x1dc40e7d,0x38c80e7e}},	//   eku_, muit, वरित, _ماری_, 
   {{0x7ae40e7f,0x64480597,0x443c01d9,0x628002c4}},	//   luit, fhei, fku_, dllo, 
   {{0x64480e80,0x62800e81,0x443c0e82,0x7ae4009f}},	//   ghei, ello, gku_, ouit, 
   {{0x77940e83,0x78a000aa,0x55e40e84,0x1dc40e85}},	//   _ایشا, _iimv, _возб, वरात, 
   {{0x443c0e86,0x6448002d,0x7ae402b1,0x62800174}},	//   aku_, ahei, iuit, gllo, 
   {{0x443c0e87,0x7ae40e88,0x78a00085,0x64480e89}},	//   bku_, huit, _kimv, bhei, 
   {{0x7ae40e8a,0x443c0e8b,0x62800e8c,0x3f800198}},	//   kuit, cku_, allo, _byiu_, 
   {{0x7ae40e8d,0x78a00099,0xad240e8e,0xd37004fb}},	//   juit, _mimv, ڭىزى, _بهش_, 
   {{0x7ae40e8f,0x78a00e90,0x6e940e91,0x201c00b0}},	//   duit, _limv, сигу, ētia_, 
   {{0x8bc40724,0x0ed00490,0xb0f8020f,0xc0e00e92}},	//   исад, _तिकड, _сейф_, _дојк, 
   {{0x78a00e93,0x7ae40e94,0xada400d1,0x00000000}},	//   _nimv, fuit, раңл, --, 
   {{0x7ae40e95,0x9988007f,0xf3f8015b,0x994806b9}},	// [a10] guit, _dabō_, _অফার_, tışa_, 
   {{0x64480399,0x443c0e96,0x656c03be,0x8c380e78}},	//   zhei, zku_, şahi, _bißc, 
   {{0x443c0e97,0x78a00085,0x64480151,0x99480e98}},	//   yku_, _bimv, yhei, rışa_, 
   {{0x7ae40e99,0x64480007,0x6f0c0334,0x443c0009}},	//   buit, xhei, _ksac, xku_, 
   {{0x443c0e9a,0x7ae40e9b,0x62800e9c,0x3b6406bb}},	//   vku_, cuit, yllo, _дърв, 
   {{0x64a40e9d,0x6f0c009f,0x2fc80e9e,0xaa440e56}},	//   бака, _msac, _leag_, _انسى, 
   {{0xd5ac0e9f,0x6f0c022e,0x25ec000d,0x62800200}},	//   رفي_, _lsac, _घाठी_, vllo, 
   {{0x6f0c02ce,0x2408013e,0x2fc80356,0x64480ea0}},	//   _osac, унии_, _neag_, uhei, 
   {{0x6f0c063f,0x27ec0ea1,0x628000cf,0x6aac0327}},	//   _nsac, _icen_, tllo, nqaf, 
   {{0x78a00ea2,0xe20801e1,0x00000000,0x00000000}},	//   _zimv, _gbọ́_, --, --, 
   {{0x2fc80ea3,0x6f0c0ea4,0x64480ea5,0x846406bb}},	//   _beag_, _asac, phei, _къде, 
   {{0x7ae40d04,0x53740020,0x64480007,0x443c02d1}},	//   yuit, _አዳዲስ_, qhei, qku_, 
   {{0x64580ea6,0x02a40ea7,0x6f0c0ea8,0x9e6400c6}},	//   _imwi, _трем, _csac, ماسن, 
   {{0xe1f00b28,0x7ae40ea9,0x62800113,0x00000000}},	//   _رست_, vuit, qllo, --, 
   {{0x6f0c0921,0x64580998,0x27ec0eaa,0x6efc01e6}},	//   _esac, _kmwi, _ocen_, _påbö, 
   {{0x68e4089c,0x27ec00f2,0x2fc80ea0,0x648400e4}},	//   duhd, _ncen_, _geag_, kóim, 
   {{0x78a00eab,0x7ae40798,0x44fc0eac,0xdb1400a2}},	// [a20] _rimv, uuit, ্মিক_, bayý, 
   {{0x20100ead,0x27ec0eae,0x64840332,0x5cf400c0}},	//   _hayi_, _acen_, dóim, _ляму, 
   {{0x64580eaf,0x20100eb0,0x00000000,0x00000000}},	//   _omwi, _kayi_, --, --, 
   {{0x7ae40eb1,0x20100eb2,0x44fc00cc,0x00000000}},	//   puit, _jayi_, ্মাক_, --, 
   {{0x20100eb3,0x25a40042,0x00000000,0x00000000}},	//   _mayi_, _bgll_, --, --, 
   {{0x64580eb4,0x20100c09,0x27ec0eb5,0x00000000}},	//   _amwi, _layi_, _ecen_, --, 
   {{0x78a00eb6,0x18680640,0x64840332,0x00000000}},	//   _timv, _бави_, póil, --, 
   {{0x20100eb7,0x00000000,0x00000000,0x00000000}},	//   _nayi_, --, --, --, 
   {{0x2fc8011c,0x661002f6,0x90a001ec,0xa49000f2}},	//   _reag_, ökkä, _ﺍﻟﺘﻔ_, ذیهت, 
   {{0x64580428,0x20100009,0xdb140113,0x6f0c01ab}},	//   _emwi, _aayi_, layó, _rsac, 
   {{0x20100eb8,0x53140eb9,0x25ec05dc,0x00000000}},	//   _bayi_, _گذار, _घाती_, --, 
   {{0x2010011f,0x0ee80eba,0x6f0c0ebb,0xb6cc06be}},	//   _cayi_, льги_, _psac, _şüyü, 
   {{0x64b00374,0x82c4031c,0x20100ebc,0x64940ebd}},	//   _iāia, _གསརའ, _dayi_, _všit, 
   {{0x0af001c6,0x427002dd,0x00000000,0x00000000}},	//   үүнэ, _егіс, --, --, 
   {{0x201000ca,0x64940ebe,0x64b000b0,0x2fc800a3}},	//   _fayi_, _tšit, _kāia, _teag_, 
   {{0x20100198,0x6f0c03f0,0x64940306,0xc98400fb}},	//   _gayi_, _tsac, _ušit, ҡужи, 
   {{0x64b002b5,0x6f0c0ebf,0x6a34026a,0x764800a2}},	// [a30] _māia, _usac, онађ, _oldy, 
   {{0x27ec0ec0,0x6aac0023,0x20100ec1,0xa3800037}},	//   _scen_, rqaf, _zayi_, öõig, 
   {{0x20100ec2,0x6e240109,0x27ec0ec3,0xfe240022}},	//   _yayi_, _inhb, _pcen_, _хьын, 
   {{0xac180ec4,0x64b004fe,0xf99006b7,0x20100429}},	//   _тому_, _nāia, ربل_, _xayi_, 
   {{0x667404fb,0x68e402f6,0xe5a40b3b,0xe70400f2}},	//   يدتر, suhd, оили, تسای, 
   {{0xf7700ec5,0x68e4005b,0x648401e7,0xe6180022}},	//   ران_, puhd, róim, рдк_, 
   {{0x27ec011c,0xdee40023,0xa7e40150,0xdb1400e4}},	//   _tcen_, _ምጣነ_, _وكسى, mbyá, 
   {{0xdb140100,0x78b801d3,0x64840022,0x47f0009d}},	//   mayò, ívve, móik, _хүдр, 
   {{0x52a40ec6,0x20100ec7,0x8c10009e,0x2bb0012c}},	//   овым_, _rayi_, হাপন_, _झलना, 
   {{0x20100ec8,0x00000000,0x00000000,0x00000000}},	//   _sayi_, --, --, --, 
   {{0xdde80ec9,0x20100100,0x648400e4,0xdd0c0166}},	//   یرسه_, _payi_, nóik, dışe, 
   {{0x64580516,0x44f00eca,0x6e240208,0x00000000}},	//   _umwi, mã_, _anhb, --, 
   {{0x44f00c67,0x20100943,0x2d840ecb,0x00000000}},	//   lã_, _vayi_, ülen_, --, 
   {{0x20100ecc,0xdca4041b,0x44f00165,0x648400e4}},	//   _wayi_, жави, oã_, kóik, 
   {{0x20100ecd,0x1d080ece,0x44f00ecf,0xdfd000dd}},	//   _tayi_, шеви_, nã_, _ہيں_, 
   {{0x44f00004,0x00000000,0x00000000,0x00000000}},	//   iã_, --, --, --, 
   {{0xdd940ed0,0xf7cc0ed1,0x44f00ed2,0x7b8400d1}},	// [a40] саңы, ﮔﻪﻧﺪ, hã_, سارە, 
   {{0x09e00131,0x44f00124,0x00000000,0x00000000}},	//   дофн, kã_, --, --, 
   {{0x57a40ed3,0x44f00589,0x6d400165,0xad5802e8}},	//   ошла, jã_, ùlat, _грях_, 
   {{0x7e7c0ed4,0x00000000,0x00000000,0x00000000}},	//   lorp, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e7c0ed5,0xdb14007f,0xc68c01d9,0xe9a8009f}},	//   norp, bayò, نِن_, _هدفن_, 
   {{0x3af40ed6,0x44f00004,0xdb140309,0x00000000}},	//   läp_, gã_, mayñ, --, 
   {{0x7e7c0ed7,0xdfe40b03,0x77940ed8,0x00000000}},	//   horp, _कागद_, _فیضا, --, 
   {{0x166406bb,0x3a380003,0x44f00c67,0xcc38008f}},	//   _двам, _korp_, aã_, שעפט, 
   {{0x44f00589,0x5184036b,0x7e7c0140,0x00000000}},	//   bã_, жума, jorp, --, 
   {{0x32d000d2,0x44f00004,0x7e7c0373,0x3a3805b1}},	//   _bôyá_, cã_, dorp, _morp_, 
   {{0x64b00325,0x3af400a2,0x00000000,0x00000000}},	//   _kāin, käp_, --, --, 
   {{0xdb140784,0x3c3c0174,0xfd540055,0x64b000de}},	//   kayñ, _lívs_, _iveṣ, _jāin, 
   {{0x9de40ed9,0x7e7c0eda,0x6aa800d8,0x421401d9}},	//   _སྐྱེ, gorp, _éefi, _وٲنج_, 
   {{0x82c4081f,0x25b800ac,0xac940edb,0xc5cc0154}},	//   _གསོའ, _əsl_, завш, _রামপ, 
   {{0x5ea800eb,0x00000000,0x00000000,0x00000000}},	//   _কবরে, --, --, --, 
   {{0x7e7c0edc,0x44f00004,0x3af4010e,0x00000000}},	// [a50] borp, zã_, gäp_, --, 
   {{0x09e009bd,0x44f00004,0x7e7c0edd,0xba7400f1}},	//   ন্না, yã_, corp, والت, 
   {{0x3a380e29,0x44f00004,0xefc80023,0x8c34014b}},	//   _dorp_, xã_, _ኽሳዕ_, _донӣ_, 
   {{0x44f00004,0x3af40ede,0x3a3800a3,0xac0800db}},	//   vã_, bäp_, _eorp_, _اردە_, 
   {{0x87040edf,0xfe700133,0xdb14007f,0x3af4008e}},	//   تبال, _سدی_, sayò, cäp_, 
   {{0xd1240597,0x44f00ee0,0x3a380076,0x64a40ee1}},	//   _كم_, tã_, _gorp_, пака, 
   {{0x44f00589,0x35f806c2,0x5b500092,0x00000000}},	//   uã_, ترند_, _መመደቡ, --, 
   {{0x44f00ee2,0xf9640244,0x00000000,0x00000000}},	//   rã_, _تۆمێ, --, --, 
   {{0xfd5400dc,0x44f00ee3,0x16140210,0x00000000}},	//   _dveṣ, sã_, _धोकर_, --, 
   {{0x44f00ee4,0xfd5400b8,0x00000000,0x00000000}},	//   pã_, _eveṣ, --, --, 
   {{0x7e7c0ee5,0xd12c0133,0x1fa8005b,0x00000000}},	//   vorp, ۆمی_, йкни_, --, 
   {{0x44d400a8,0x7e7c0373,0xa0680640,0x2910012d}},	//   mă_, worp, сама_, _msza_, 
   {{0x44d400a8,0x7e7c0ee6,0xd12c0ee7,0xa0c40ee8}},	//   lă_, torp, نمی_, _کيبو, 
   {{0x629c0316,0x04fc0154,0x5398011a,0x00000000}},	//   ůsob, ্মীর_, _פיסו, --, 
   {{0x44d40262,0x64b002b5,0x7e7c0ee9,0x5c680092}},	//   nă_, _māio, rorp, _ተለይቶ_, 
   {{0x5ba80eea,0x09e000bd,0x3a38032e,0x00000000}},	//   скам_, ন্মা, _sorp_, --, 
   {{0x7e7c01e4,0x1cdc031c,0x9aa4007b,0x8f600092}},	// [a60] porp, _ལའམ_, سماو, ለካከቶ, 
   {{0x3af40eeb,0x64b002b1,0x7e7c0eec,0x9e08007b}},	//   räp_, _rāin, qorp, _ايدك_, 
   {{0x44d4084c,0x18a40eed,0x246400de,0x00000000}},	//   jă_, чаем, lēmu_, --, 
   {{0x44d4084c,0x64b002b1,0x3a380582,0x38c80133}},	//   dă_, _pāin, _worp_, ماڵی_, 
   {{0xe79401d9,0x60cc0210,0x00000000,0x00000000}},	//   ٘اوک, _łaml, --, --, 
   {{0x7ae40eee,0x7bc40024,0x44d4054e,0xfd54002b}},	//   mrit, lbiu, fă_, _sveṣ, 
   {{0x44d4084c,0x7ae40eef,0xf8e00034,0x198405d9}},	//   gă_, lrit, _पटिय, _رجسٽ, 
   {{0x64b00ef0,0x7bc4003a,0xe7c80327,0xdb0802d2}},	//   _tāin, nbiu, _ċaħħ, _ínóv, 
   {{0x7ae40ef1,0x00000000,0x00000000,0x00000000}},	//   nrit, --, --, --, 
   {{0x7ae40ef2,0x44d40276,0xc0d0001f,0x09e000cc}},	//   irit, bă_, ያለሁ_, ন্ঠা, 
   {{0x44d40262,0x7ae40ef3,0xfd5400b8,0x66800ef4}},	//   că_, hrit, _tveṣ, _جیول, 
   {{0xd9d000cc,0x2d840ef5,0x00000000,0x00000000}},	//   ালিম, ülem_, --, --, 
   {{0x9fa401e0,0x838001f4,0x00000000,0x00000000}},	//   дырҙ, _пыше, --, --, 
   {{0x8d740ef6,0x693401ef,0x00000000,0x00000000}},	//   كازا, _hřeš, --, --, 
   {{0x7ae40ef7,0x82300ef8,0x09e000bd,0x2d840ef9}},	//   erit, _سروا, ন্ডা, æle_, 
   {{0x7ae40efa,0x81340efb,0x10780131,0xfe700efc}},	//   frit, _ءسوز_, ﻧﺎﺯﯨ, ندۀ_, 
   {{0x44d40262,0xdb100248,0x00000000,0x00000000}},	// [a70] ză_, _ògìr, --, --, 
   {{0x6d5802a8,0x00000000,0x00000000,0x00000000}},	//   _ƙwad, --, --, --, 
   {{0x7ae40efd,0x7bc4026c,0xfeb80424,0xd36403e6}},	//   arit, bbiu, _وایت_, _ڤه_, 
   {{0x44d4084c,0x9cd40375,0xf99000c6,0x64840efe}},	//   vă_, _קורה_, ابك_, lóiv, 
   {{0x8b640eff,0x00000000,0x00000000,0x00000000}},	//   _راحم, --, --, --, 
   {{0x44d40262,0xa5640f00,0x3cf80f01,0x6abc035a}},	//   tă_, وگان, _بعید_, _itsf, 
   {{0x69c40f02,0x44d4054e,0x6d54002f,0xf6500137}},	//   mbhe, uă_, nzza, دئن_, 
   {{0x44d40262,0x69c408c2,0x8a6002f2,0x00000000}},	//   ră_, lbhe, _تێڕۆ, --, 
   {{0x44d400a8,0x7d1c0f03,0x04fc015b,0x64840124}},	//   să_, zvrs, ্মের_, kóiv, 
   {{0xe0d80f04,0x7bc40f05,0x44d4084c,0x61440f06}},	//   ово_, zbiu, pă_, деоа, 
   {{0x69c40f07,0x7ae401a2,0x09e002f5,0x45480120}},	//   ibhe, zrit, ন্থা, _учам_, 
   {{0x7ae40f08,0x69c40f09,0x7158010b,0x00000000}},	//   yrit, hbhe, ярыс_, --, 
   {{0x6d54026c,0x7e600066,0x6d400f0a,0x00000000}},	//   ezza, èmpo, ølan, --, 
   {{0x7ae40f0b,0x6e340200,0x00000000,0x00000000}},	//   vrit, gjzb, --, --, 
   {{0x7ae40f0c,0x6abc02d0,0x91b8011a,0xd12c0f0d}},	//   writ, _atsf, _ומצי, _نمو_, 
   {{0x68e40cf9,0xb5fc031c,0x69c4009a,0x00000000}},	//   drhd, _imġe, ebhe, --, 
   {{0x7ae40f0e,0x6d540f0f,0x7bc40f10,0x64b00421}},	// [a80] urit, azza, rbiu, _sāil, 
   {{0x1cb80f11,0xd94400ee,0xdb100241,0x00000000}},	//   _واجب_, мези, _ògír, --, 
   {{0x27fc0368,0xd8b800db,0x00000000,0x00000000}},	//   ffwn_, زداا_, --, --, 
   {{0x2d9400ee,0x776400db,0x00000000,0x00000000}},	//   _ярыс, úixo, --, --, 
   {{0xc7a00f12,0x202c0020,0x69c401e3,0x00000000}},	//   вицк, _እየተከ, bbhe, --, 
   {{0xf67405f5,0x4aa40131,0x75d40f13,0x69c401c3}},	//   эглэ, _окян_, ريبا, cbhe, 
   {{0xdb0400b5,0x693400bc,0x00000000,0x00000000}},	//   _afkø, _přeš, --, --, 
   {{0xd7040f14,0x73d80440,0x04600f15,0x00000000}},	//   _озби, чдир_, ктым, --, 
   {{0x693401ef,0x00000000,0x00000000,0x00000000}},	//   _vřeš, --, --, --, 
   {{0xba080f16,0xd6240f17,0x6204013a,0x82900116}},	//   _ዋና_, _تعري, _čulí, نۇنچ, 
   {{0x63b8015d,0x693400bc,0x427001c6,0xdcfc013a}},	//   _ffwn, _třeš, тгэс, _vzpě, 
   {{0x741403e6,0x7c580092,0x00000000,0x00000000}},	//   _سوتا, _ሀገሪቱ, --, --, 
   {{0x41bc0825,0x24500162,0x2d980131,0x00000000}},	//   _श्वस, _dámd_, ﻘﯩﻨﻰ_, --, 
   {{0xb63004ce,0x1e7002dd,0x6d540112,0x68e0005c}},	//   _ｐｒ_, лғыс, tzza, _ældg, 
   {{0x6d54011c,0x320c0f18,0x00000000,0x00000000}},	//   uzza, medy_, --, --, 
   {{0x320c0c5e,0xc170011a,0x00000000,0x00000000}},	//   ledy_, _שחק_, --, --, 
   {{0x69c40afe,0xe2300214,0x64840022,0x3f1400c0}},	// [a90] tbhe, _شکیب, póiv, _адыс, 
   {{0x69c40175,0x648401e7,0x00000000,0x00000000}},	//   ubhe, lóit, --, --, 
   {{0x69c40f19,0x24500022,0xf8b000d1,0x00000000}},	//   rbhe, _háme_, لةن_, --, 
   {{0x64840022,0x69c407fc,0x385800f2,0xe47c0205}},	//   nóit, sbhe, وشند_, çtüğ, 
   {{0x320c01a2,0x0c6402d3,0x66e4020a,0x66040f1a}},	//   kedy_, _ተፈጢሩ_, хола, епла, 
   {{0x247c069c,0x24500e96,0xd6cc0f1b,0x7a1c007f}},	//   _ኣባላት_, _máme_, حقو_, pٍta, 
   {{0x64b004fe,0x245002f0,0xf41803d4,0xf8b40153}},	//   _tāim, _láme_, থানৰ_, _абсэ, 
   {{0xe7f8038e,0x00000000,0x00000000,0x00000000}},	//   _एउटा_, --, --, --, 
   {{0x64b002b5,0x25a8034c,0x130407d8,0x63040f1c}},	//   _kāik, _فضای_, еный_, رودل, 
   {{0x320c0f1d,0xc0880b82,0x00000000,0x00000000}},	//   gedy_, _ማህጸን_, --, --, 
   {{0x64b002b5,0xfd9002dd,0x00000000,0x00000000}},	//   _māik, _ﻓﻜﺎﻥ_, --, --, 
   {{0xdee40f1e,0x1b04015b,0x00000000,0x00000000}},	//   номи, রিতে_, --, --, 
   {{0xe80005ba,0x644803fa,0x232800c2,0x320c06d9}},	//   ळ्या_, mkei, _холи_, bedy_, 
   {{0x644802f6,0x24500122,0x320c02fb,0x00000000}},	//   lkei, _dáme_, cedy_, --, 
   {{0x62800f1f,0xda000bae,0x26f400eb,0x00000000}},	//   molo, र्फत_, _ইনফো_, --, 
   {{0x62800f20,0x64480f21,0x64840077,0x26cc003e}},	//   lolo, nkei, cóit, _oweo_, 
   {{0x6d5802a8,0x1e84033a,0x6448005b,0xd1280228}},	// [aa0] _ƙwac, _плим, ikei, _وقۇۇ_, 
   {{0x09e00f22,0x64480f23,0x3d18000d,0x6d6000cd}},	//   ন্সা, hkei, _पनपे_, _śvaś, 
   {{0x64480f24,0x0d200f25,0x64840f26,0x00000000}},	//   kkei, _йүрү, nóis, --, 
   {{0x62800f27,0xdad00075,0x38600013,0x6d400108}},	//   holo, _مەرھ, òir_, älae, 
   {{0x0c200801,0xdb100241,0x00000000,0x00000000}},	//   _смян, _ògàr, --, --, 
   {{0x62800f28,0x64b002b5,0x648400e4,0xa5c000c7}},	//   jolo, _kāih, kóis, иҩуе, 
   {{0x62800af2,0x6448002f,0x320c0419,0x00000000}},	//   dolo, fkei, vedy_, --, 
   {{0x62800f29,0x64480f2a,0x64b002b5,0xd6d00f2b}},	//   eolo, gkei, _māih, _مقر_, 
   {{0x62800f2c,0x68e001e6,0xb27400d1,0xe8180073}},	//   folo, _åldr, клиш, _नोटा_, 
   {{0x42700f2d,0xa6a80137,0x24500419,0x644801f4}},	//   лгыс, _قالق_, _ráme_, akei, 
   {{0x320c0f2e,0x00000000,0x00000000,0x00000000}},	//   redy_, --, --, --, 
   {{0x644802c1,0x62800421,0x320c0306,0x68e0005c}},	//   ckei, aolo, sedy_, _ælde, 
   {{0x62800f2f,0xff040f30,0x320c0a85,0xc4380302}},	//   bolo, лярн, pedy_, _מתאי, 
   {{0x628007d5,0x6e9401a9,0x00000000,0x00000000}},	//   colo, тигу, --, --, 
   {{0xfd100f31,0x8140032f,0x648401e7,0x00000000}},	//   یجہ_, _منون, móir, --, 
   {{0x64840553,0xeb400092,0x00000000,0x00000000}},	//   lóir, _የመግለ, --, --, 
   {{0x64b000b0,0x4ea40f32,0x6604000d,0x0a6800d8}},	// [ab0] _pāik, _проа, õhkk, пржи_, 
   {{0x64840f33,0xc9d003e6,0xdbdc032e,0x60cc033f}},	//   nóir, اماک, _bíóf, _łami, 
   {{0x26cc01af,0x0d480691,0x64480f34,0xe7380042}},	//   _sweo_, _رشدي_, ykei, _ngŵr_, 
   {{0x62800f35,0x64840597,0x00000000,0x00000000}},	//   zolo, hóir, --, --, 
   {{0x81d40729,0x64b002b1,0x648400c7,0x00000000}},	//   িলত_, _tāik, kóir, --, 
   {{0x62800f36,0xa5080cfc,0xdb14019f,0xc9840f37}},	//   xolo, дека_, rayô, _зуби, 
   {{0x62800f38,0x64840597,0x64480f39,0xc1b000c7}},	//   volo, dóir, tkei, қәлы, 
   {{0x62800f3a,0x23280107,0x00000000,0x00000000}},	//   wolo, доии_, --, --, 
   {{0xe2980aa5,0x64480f3b,0x648401e7,0x26d80ca8}},	//   маи_, rkei, fóir, _ìso_, 
   {{0x64480f3c,0x64840597,0x62800618,0xdb040129}},	//   skei, góir, uolo, îmée, 
   {{0x62800f3d,0x00000000,0x00000000,0x00000000}},	//   rolo, --, --, --, 
   {{0x64840597,0x64b002b5,0xb5fc025c,0x14c800f2}},	//   róis, _rāih, _imġa, _آهنی_, 
   {{0x9e640f3e,0x942400cf,0x649401ef,0x00000000}},	//   ناسن, _جونۇ, _ošiz, --, 
   {{0x62800f3f,0x64b000b0,0x3f8c0f40,0x1d0809a5}},	//   qolo, _pāih, ādu_, меги_, 
   {{0x8d600f41,0x248c0de2,0x11d4007b,0x00000000}},	//   авре, olem_, _شوية_, --, 
   {{0x248c0f42,0x00000000,0x00000000,0x00000000}},	//   nlem_, --, --, --, 
   {{0xcb640f43,0x248c0f44,0x70540354,0x00000000}},	// [ac0] вате_, ilem_, _сĕте, --, 
   {{0x248c0671,0x64b000b0,0xddcc00c0,0x00000000}},	//   hlem_, _tāih, lobž, --, 
   {{0x98a40f45,0x328402dd,0x00000000,0x00000000}},	//   виже, _ﺭﺌﻴﺱ_, --, --, 
   {{0x248c01ef,0xa9940116,0x00000000,0x00000000}},	//   jlem_, ھشەت, --, --, 
   {{0x248c0f46,0x9aa40f47,0xd730009d,0x00000000}},	//   dlem_, _لمحو, рдлө, --, 
   {{0x248c0f48,0x629c0f49,0x62f80154,0x00000000}},	//   elem_, ïsol, ্টায়_, --, 
   {{0xd4980354,0xda000f4a,0x00000000,0x00000000}},	//   мри_, र्णत_, --, --, 
   {{0x3dd80036,0x248c0f4b,0x85400166,0x00000000}},	//   harw_, glem_, рэше, --, 
   {{0x64840597,0xa2d40f4c,0xc7a00f4d,0x07a00f4e}},	//   tóir, _मौद्, _витк, _ватн, 
   {{0x248c0f4f,0x54c40022,0x6d400158,0x6eb8012d}},	//   alem_, _абжб, ølak, _एंबु, 
   {{0x64840597,0x38640109,0xc9cc00d1,0x00000000}},	//   róir, _kmmr_, _ﺗﯘﻳﻐ, --, 
   {{0x648400c6,0x248c0393,0xef64009d,0x00000000}},	//   sóir, clem_, гэгү, --, 
   {{0xb8f40f50,0xebb80882,0x291c0374,0x64840f51}},	//   _ེས_, niḥ_, āwai_, póir, 
   {{0x3dd80042,0x3f140798,0x00000000,0x00000000}},	//   garw_, јдрс, --, --, 
   {{0xebb80a28,0x24500f52,0x8c380112,0x00000000}},	//   hiḥ_, _háma_, _mißv, --, 
   {{0x99d003d4,0x09c800dc,0x648400e4,0x8f440117}},	//   ালোক, िर्य, nóip, _аход, 
   {{0x24500f53,0x6e440f54,0x63bc030a,0x99d003d4}},	// [ad0] _jáma_, _منظم, ñsni, ালৈক, 
   {{0x321c0f55,0x248c0f56,0xdb0402d2,0x24500f57}},	//   _javy_, zlem_, _afkó, _máma_, 
   {{0x248c0f58,0x321c00e4,0xb8b4007b,0x648400e4}},	//   ylem_, _mavy_, لإنت, kóip, 
   {{0xdd900f59,0x2fd801ab,0x321c00d7,0x00000000}},	//   _دوپ_, nasg_, _lavy_, --, 
   {{0x2450013a,0xb8140022,0x00000000,0x00000000}},	//   _náma_, шҧтә, --, --, 
   {{0x248c0649,0x321c0f5a,0xfd4c01e1,0x00000000}},	//   wlem_, _navy_, _ninọ, --, 
   {{0x69d40f5b,0x79a40f5c,0x248c0f5d,0x00000000}},	//   _ieze, _врте, tlem_, --, 
   {{0x72080014,0xebb80055,0x00000000,0x00000000}},	//   ێہنہ_, biḥ_, --, --, 
   {{0x248c0f5e,0x69d4066d,0x321c06d9,0x2c040490}},	//   rlem_, _keze, _bavy_, ह्यू_, 
   {{0x69d40f5f,0x24500f60,0x321c0076,0x248c0f61}},	//   _jeze, _dáma_, _cavy_, slem_, 
   {{0x69d40f62,0x248c0f63,0xa0680f64,0x00000000}},	//   _meze, plem_, еана_, --, 
   {{0x69d40f65,0x6d5803f9,0x2fd80192,0x24500cde}},	//   _leze, _ƙwan, gasg_, _fáma_, 
   {{0x442c0f66,0x321c06d9,0x64b000b0,0xa06800d1}},	//   _ing_, _favy_, _pāiw, _җапа_, 
   {{0x69d40f67,0x442c003e,0x321c010e,0x00000000}},	//   _neze, _hng_, _gavy_, --, 
   {{0x442c0f68,0xdc980408,0x00000000,0x00000000}},	//   _kng_, еташ_, --, --, 
   {{0x442c0098,0x69d40156,0x61f00311,0x62200131}},	//   _jng_, _aeze, şelă, _ئۈگە, 
   {{0x0fc0052f,0xdd940ed0,0x442c0f69,0x3dd8020c}},	// [ae0] _уйын, таңы, _mng_, parw_, 
   {{0x442c0f6a,0xdbd00f6b,0x69d40205,0x4a400798}},	//   _lng_, rüñi, _ceze, бнув, 
   {{0x442c0f6c,0x9d440f6d,0x20d00986,0x2d8401ed}},	//   _ong_, _сенд, nši_, ület_, 
   {{0xebb80a28,0x442c0083,0x69d40857,0x37c401e0}},	//   tiḥ_, _nng_, _eeze, рҙаб, 
   {{0x69d40f6e,0xf484030f,0x649c02dd,0x2d840135}},	//   _feze, یابی, _ﺟﺎﭘﭙ, żlet_, 
   {{0x442c0f6f,0x69d40f70,0x20d00960,0x00000000}},	//   _ang_, _geze, kši_, --, 
   {{0x442c0f71,0x20d00f72,0xdcfc005f,0x550401c0}},	//   _bng_, jši_, _izpē, учла, 
   {{0x20d000bc,0x00000000,0x00000000,0x00000000}},	//   dši_, --, --, --, 
   {{0x69d40f73,0x32540f74,0x442c0f75,0xd24405f5}},	//   _yeze, ивир, _dng_, гэни, 
   {{0x442c0f76,0x8b54011a,0x69d40f77,0x245001ef}},	//   _eng_, טיפס_, _xeze, _váma_, 
   {{0x321c0851,0x442c00a3,0xf1940212,0x00000000}},	//   _vavy_, _fng_, ринь, --, 
   {{0xa0340f78,0x442c0f79,0x312401c0,0x67200023}},	//   لىپت, _gng_, гдүг, _ተልእኾ, 
   {{0x321c0f7a,0x3b000477,0x752800d0,0x8c38002f}},	//   _tavy_, jtiq_, _hrdz, _mißt, 
   {{0x20d009a8,0x442c01a6,0x82f4011a,0x00000000}},	//   bši_, _zng_, _עצוב_, --, 
   {{0x442c0f7b,0xefc40f7c,0xad2400d1,0x00000000}},	//   _yng_, _ጸጋይ_, جىزى, --, 
   {{0x69d40f7d,0xda0005f9,0x6b740f7e,0x00000000}},	//   _seze, र्सत_, албу, --, 
   {{0x69d40f7f,0xdbdc0d12,0x81d40154,0x3e900240}},	// [af0] _peze, _víðf, িলর_, _ሓብሬታ_, 
   {{0x6f0c0bf1,0x69d403e3,0x00000000,0x00000000}},	//   _ipac, _qeze, --, --, 
   {{0x69d40f80,0x7e600036,0xac940f81,0x00000000}},	//   _veze, ëmpe, _ванш, --, 
   {{0x69d40f82,0x6f0c02e3,0x64b000b0,0x26dc01ee}},	//   _weze, _kpac, _māit, tswo_, 
   {{0x69d40f83,0x64b00607,0x75280064,0x99880064}},	//   _teze, _lāit, _ardz, _bobų_, 
   {{0xc8d40f84,0x26dc0112,0x20d00bf1,0x442c0f85}},	//   _مزرع, rswo_, yši_, _sng_, 
   {{0xe3b006d5,0x442c0f86,0x05740f87,0x6f0c0055}},	//   يرة_, _png_, داشد, _lpac, 
   {{0x20d00bb8,0x29000f88,0xc8b40032,0xa4440f89}},	//   vši_, mtha_, _асҡы, рнид, 
   {{0x442c0f8a,0x20d00784,0x383401c6,0x290005e0}},	//   _vng_, wši_, _унтр, ltha_, 
   {{0x20d00f8b,0x67280f8c,0x6d5802a8,0x29000f8d}},	//   tši_, _irej, _ƙwal, otha_, 
   {{0x29000f8e,0x6f0c0f8f,0xa2d40f90,0x67280f91}},	//   ntha_, _apac, _मौर्, _hrej, 
   {{0x20d00f92,0x67280f93,0xa0680f94,0x6f0c00ae}},	//   rši_, _krej, тама_, _bpac, 
   {{0x6f0c0334,0x29000f95,0x6d4001f4,0x00000000}},	//   _cpac, htha_, älan, --, 
   {{0x21a40f96,0x67280f97,0x29000f98,0x245002f0}},	//   _килм, _mrej, ktha_, _kámo_, 
   {{0xdb100f99,0x20d003f0,0xe0d4011b,0x2900025c}},	//   _ágús, qši_, _тюль, jtha_, 
   {{0x67280f9a,0x3b000f9b,0x29000f9c,0x245001ef}},	//   _orej, ttiq_, dtha_, _mámo_, 
   {{0x5ba80f9d,0x2d840f9e,0x29000f9f,0x24500248}},	// [b00] ткам_, üler_, etha_, _lámo_, 
   {{0x29000072,0x672c01e4,0x3b0001d5,0x00000000}},	//   ftha_, ĥajl, rtiq_, --, 
   {{0x29000597,0x67280fa0,0xd7f80fa1,0x4f8401d9}},	//   gtha_, _arej, вул_, _مایہ, 
   {{0x6f0c00e4,0xe8e80fa2,0x75280332,0xc7c0005b}},	//   _ypac, ارلو_, _rrdz, осши, 
   {{0x29000fa3,0x68e001bf,0x3b00014f,0x1dd8012d}},	//   atha_, _ældn, qtiq_, _बजात, 
   {{0x6728067d,0x29000fa4,0xdcfc00ef,0x00000000}},	//   _drej, btha_, _uzpē, --, 
   {{0x290000c6,0x672801ed,0x98a402bf,0x0f280092}},	//   ctha_, _erej, _виве, _ሲያስረ, 
   {{0x67280fa5,0x44a00137,0x64b000b0,0x249c0042}},	//   _frej, يموق, _rāit, _chwm_, 
   {{0x67280fa6,0x00000000,0x00000000,0x00000000}},	//   _grej, --, --, --, 
   {{0x64b002b5,0x32540fa7,0x6f0c0fa8,0xdcfc0210}},	//   _pāit, свор, _rpac, _wypę, 
   {{0x6f0c0fa9,0x543401d9,0x672801f1,0xf3e80154}},	//   _spac, _پرار, _zrej, ক্ষর_, 
   {{0x50640faa,0x7c3c001f,0xe1f40124,0x7ea0002f}},	//   ртоа, _አገሪቱ, аҳә_, nöpf, 
   {{0x53a40fab,0x4c14035c,0x61f80fac,0xd250007b}},	//   _тадб, یبرس, åblå, _ونص_, 
   {{0x8d740a2c,0x7ea00fad,0x64b00374,0x7f940212}},	//   لازا, höpf, _tāit, іарх, 
   {{0x8c640fae,0xa3bc060c,0x7ea00e78,0x7d240faf}},	//   атад, _आलम_, köpf, офте, 
   {{0x4fc40120,0x6e940214,0xceb800d8,0x00000000}},	//   _тска, _گلخا, _иљо_, --, 
   {{0x6f0c0fb0,0x22980066,0x9f9400a2,0x2900031c}},	// [b10] _upac, lèka_, _küýi_, wtha_, 
   {{0x290000cd,0x67280240,0x00000000,0x00000000}},	//   ttha_, _rrej, --, --, 
   {{0x290000fb,0x672800f3,0xf9900344,0x3d24005b}},	//   utha_, _srej, وبم_, _дьяв, 
   {{0x67280fb1,0x29000fb2,0x5cc001c6,0xcc840345}},	//   _prej, rtha_, _хөрв, _ئۆره_, 
   {{0x29000fb3,0xdee402d3,0xdc340a1e,0x00000000}},	//   stha_, _ዝባን_, _הארט_, --, 
   {{0x290000c6,0x4f28001f,0xb5c80fb4,0x6728036e}},	//   ptha_, _ሲያደር, لوهم_, _vrej, 
   {{0x48a80fb5,0xe89401c0,0x67280327,0x2900025c}},	//   _атам_, _гавь, _wrej, qtha_, 
   {{0x67280fb6,0x00000000,0x00000000,0x00000000}},	//   _trej, --, --, --, 
   {{0x67280fb7,0xe4d80133,0x00000000,0x00000000}},	//   _urej, _ڕوات_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25d800c7,0x75800116,0x516400cf,0x00000000}},	//   _амҷы_, _оңша, йүшү_, --, 
   {{0x237c0211,0x823c0092,0x00000000,0x00000000}},	//   _txwj_, _ይገመታ, --, --, 
   {{0x443c0fb8,0x2450032e,0x00000000,0x00000000}},	//   mju_, _jámm_, --, --, 
   {{0xb6cc0fb9,0xd00c00f1,0x41d8012d,0x00000000}},	//   _şükü, ولۍ_, _मजिस, --, 
   {{0x443c0006,0xdd900fba,0x20e40014,0x00000000}},	//   oju_, سور_, _آبٲ, --, 
   {{0x1fb40fbb,0x00000000,0x00000000,0x00000000}},	//   _ускр, --, --, --, 
   {{0x8c400fbc,0xbbb80574,0x3a44016c,0x99e400f7}},	// [b20] чете, _अलीक, омаҳ, йжад, 
   {{0x443c0fbd,0xda640150,0x4a400fbe,0x91000345}},	//   hju_, حاري, пнув, _بژیو, 
   {{0x443c0fbf,0xdc680fc0,0x7ea0002f,0x00000000}},	//   kju_, _банд_, töpf, --, 
   {{0x443c0fc1,0x00000000,0x00000000,0x00000000}},	//   jju_, --, --, --, 
   {{0x443c0fc2,0x7c240fc3,0xc5cc015b,0xdb0408a5}},	//   dju_, mdir, _রাজপ, _afkö, 
   {{0x7c240fc4,0x443c0fc5,0x38c80fc6,0x07f40124}},	//   ldir, eju_, _ناری_, ахәы_, 
   {{0x89d80375,0x7c240009,0x443c0fc7,0x00000000}},	//   _תחלי, odir, fju_, --, 
   {{0xa3a80fc8,0x443c0fc9,0x78c401f2,0xc51000d1}},	//   _गृह_, gju_, _ịkwọ_, سبىت, 
   {{0x64b000b0,0x93880fca,0x55e40fcb,0xd4080150}},	//   _pāir, ыска_, _гозб, _ەتتم_, 
   {{0x443c0fcc,0x0504015b,0x00000000,0x00000000}},	//   aju_, লয়ের_, --, --, 
   {{0x7c240fcd,0x443c0fce,0xdcfc0118,0x00000000}},	//   kdir, bju_, _vypě, --, 
   {{0x443c0fcf,0x64b000b0,0x50640108,0x6d400108}},	//   cju_, _wāir, ётна, älam, 
   {{0x7c240fd0,0x09e009bd,0x3f80002e,0x64b002b5}},	//   ddir, ন্টা, _cxiu_, _tāir, 
   {{0x7c240fd1,0xdb1001e1,0x00000000,0x00000000}},	//   edir, _ògùr, --, --, 
   {{0x62640fd2,0x7c2406be,0x00000000,0x00000000}},	//   _بانق, fdir, --, --, 
   {{0x7c240fd3,0x00000000,0x00000000,0x00000000}},	//   gdir, --, --, --, 
   {{0x64b000b0,0xada40116,0x49c80107,0x92e400cc}},	// [b30] _māip, саңл, гуем_, _পহু_, 
   {{0x443c038f,0x7b740597,0x6d400158,0x7c240fd4}},	//   zju_, أطفا, ølas, adir, 
   {{0x7c240fd5,0x443c0fd6,0xba740150,0x00000000}},	//   bdir, yju_, ساكت, --, 
   {{0xd90c004b,0x7c240115,0xf9a40014,0x00000000}},	//   کیې_, cdir, سٕنُ, --, 
   {{0xe7380fd7,0x443c0fd8,0xba0800d1,0x7b64010a}},	//   рел_, vju_, شتەك_, _етре, 
   {{0x1b04015b,0x00000000,0x00000000,0x00000000}},	//   রিখে_, --, --, --, 
   {{0x443c0fd9,0x2eb40d79,0x87e40395,0x00000000}},	//   tju_, ंदुत, _гюзе, --, 
   {{0xc6d402f5,0x443c0fda,0x9f5400e8,0x159401ec}},	//   _সমীচ, uju_, ëgëm_, _ﺀﻭﺗﯩ, 
   {{0x443c0fdb,0x38340fdc,0xa5f8026a,0xa9680724}},	//   rju_, _энтр, _везу_, _сиңа_, 
   {{0x443c0fdd,0x7c240fde,0x95e400db,0x00000000}},	//   sju_, zdir, _ويقۇ, --, 
   {{0x443c0fdf,0xa0a40fe0,0x7c240fe1,0x257401d5}},	//   pju_, жанд, ydir, _بهاس, 
   {{0x1fa80fe2,0x60cc05be,0xbbb80fe3,0x00000000}},	//   икни_, _čamd, _अलेक, --, 
   {{0x64580fe4,0x7c240fe5,0xaab40fe6,0x00000000}},	//   _ilwi, vdir, _अंगक, --, 
   {{0x645801af,0x02a4084c,0x7ea00fe7,0x2174014b}},	//   _hlwi, _урем, köpe, _муйр, 
   {{0xa3bc05ba,0x7c240fe8,0xed340276,0x00000000}},	//   _आला_, tdir, пэтэ, --, 
   {{0x7c240fe9,0xdbc801c6,0x00000000,0x00000000}},	//   udir, ргад_, --, --, 
   {{0x7c240fea,0x53800023,0x6d400feb,0x00000000}},	// [b40] rdir, _ከዳዓት_, ølar, --, 
   {{0x19940063,0xe27000d1,0x1f940092,0x00000000}},	//   ојер, ﺴﺎﻻﻡ_, መዘገበ_, --, 
   {{0x7c240209,0x64580fec,0x00000000,0x00000000}},	//   pdir, _olwi, --, --, 
   {{0x7c240fed,0xb5fc0135,0xdc780092,0x00000000}},	//   qdir, _imġi, _የብሉይ_, --, 
   {{0xc6f40a4a,0x16a80fee,0x00000000,0x00000000}},	//   жніх_, авди_, --, --, 
   {{0x64580fef,0x7ae40ff0,0xd4c40ff1,0x00000000}},	//   _alwi, msit, осип, --, 
   {{0x7ae40ff2,0xdd2400c0,0x00000000,0x00000000}},	//   lsit, _lūžt, --, --, 
   {{0xd8300014,0x7ae40ff3,0xb17c008f,0xe6c400db}},	//   _تٍر_, osit, naĥe, زتۇي, 
   {{0x7ae40ff4,0x78bc047e,0x55e40ff5,0x60c8016b}},	//   nsit, _hurv, _моаб, ɔmmɔ, 
   {{0x78bc0ff6,0x245000c6,0x3cf80ff7,0x645803cb}},	//   _kurv, _lámh_, kurv_, _elwi, 
   {{0x7bc40ff8,0x78bc0108,0x49b80677,0xe634009d}},	//   kciu, _jurv, ימיס, _эхтэ, 
   {{0x7ae40ff9,0x7bc40007,0x00000000,0x00000000}},	//   ksit, jciu, --, --, 
   {{0xb17c01e4,0x78bc007c,0x00000000,0x00000000}},	//   daĥe, _lurv, --, --, 
   {{0x7648033b,0x248801f1,0x30e40116,0xb5d80183}},	//   _jody, čame_, _есиң, _সাঁচ, 
   {{0x7ae40ffa,0x78bc0ffb,0x76480ffc,0x00000000}},	//   esit, _nurv, _mody, --, 
   {{0x2584006a,0x76480ffd,0xeb5c001f,0x66d00cad}},	//   lêlë_, _lody, _ለመግለ, _jókò, 
   {{0x7ae40ffe,0x06cc015b,0x94f8025c,0x78bc00b8}},	// [b50] gsit, _রিভি, _དཀའི_, _aurv, 
   {{0x7bc40fff,0x76481000,0x78bc00e2,0x6e181001}},	//   aciu, _nody, _burv, _ايدس_, 
   {{0xfe701002,0x7ae41003,0xa81400f7,0x9ac00327}},	//   _جدي_, asit, здеш, ċċab, 
   {{0xf7701004,0x78bc1005,0x7ae41006,0x7bc408e5}},	//   ھان_, _durv, bsit, cciu, 
   {{0x2ca81007,0x7ae41008,0x78bc0489,0x76481009}},	//   mmad_, csit, _eurv, _body, 
   {{0x2ca8100a,0x764800cd,0xc984100b,0x6e24100c}},	//   lmad_, _cody, _дуби, _jahb, 
   {{0x69c4100d,0x7648002d,0x67d4100e,0x6e24100f}},	//   mche, _dody, _нову, _mahb, 
   {{0x69c41010,0x7d7c00c8,0x32c0007f,0x2ca8037e}},	//   lche, ינוו, _bòy_, nmad_, 
   {{0x76481011,0x2ca800c5,0x68e4058a,0xe35400ee}},	//   _fody, imad_, lshd, яткэ, 
   {{0x2ca81012,0x09ac00bd,0x35f406d3,0x6abc1013}},	//   hmad_, _চ্যা, _опур, _musf, 
   {{0x69c41014,0x766401d9,0x2ca80067,0xddcc0153}},	//   iche, _تُلم, kmad_, sibū, 
   {{0x7ae41015,0x645800aa,0x69c41016,0x271c007f}},	//   ysit, _ulwi, hche, _kňn_, 
   {{0x6e241017,0x76480161,0x24501018,0x271c007f}},	//   _bahb, _yody, _námi_, _jňn_, 
   {{0x69c41019,0x6e24101a,0x248c0373,0x27fc0007}},	//   jche, _cahb, loem_, hgwn_, 
   {{0x61e0101b,0xdca403a6,0x6abc101c,0x69c4101d}},	//   mall, зави, _ausf, dche, 
   {{0x248c0151,0x24500241,0x27fc0369,0x2ca8058a}},	//   noem_, _bámi_, jgwn_, gmad_, 
   {{0x78bc101e,0x7ae4101f,0x7bc41020,0x69c41021}},	// [b60] _surv, usit, rciu, fche, 
   {{0x7bc41022,0x78bc1023,0x69c41024,0x6abc0175}},	//   sciu, _purv, gche, _dusf, 
   {{0x764802d5,0xda001025,0x7bc41026,0x61e00194}},	//   _rody, र्गत_, pciu, iall, 
   {{0x7ae41027,0x248c1028,0x271c0100,0x76480006}},	//   psit, joem_, _bňn_, _sody, 
   {{0x61e01029,0x69c4102a,0x248c102b,0x7ae4102c}},	//   kall, bche, doem_, qsit, 
   {{0x69c4102d,0x78bc102e,0x1dbc102f,0xdbcc0139}},	//   cche, _turv, ्डित, _bıço, 
   {{0x20c001dc,0x80d800bd,0x76480099,0x00000000}},	//   _nói_, _মৎস্, _vody, --, 
   {{0x76481030,0x6d4002f6,0x6ab4009a,0x32c0007f}},	//   _wody, älai, _zizf, _pòy_, 
   {{0x19581031,0x26d80158,0xd65c030d,0x00000000}},	//   _таңы_, _æsop_, _кiад, --, 
   {{0x20c001fb,0x51841032,0xc0c00023,0x00000000}},	//   _bói_, зума, _ጸማም_, --, 
   {{0x6e24006c,0x60cc08ad,0xefe40020,0x03d80183}},	//   _rahb, _čamc, ዛመዱ_, _ধাৰণ, 
   {{0x61e01033,0x20c00120,0x578802d3,0x69c40b70}},	//   aall, _dói_, _ንሓንቲ_, zche, 
   {{0x61e01034,0x69c41035,0x6e24014f,0x6f1c01a4}},	//   ball, yche, _pahb, uwsc, 
   {{0x61e01036,0x6abc0b34,0x6e24014f,0xbb60001f}},	//   call, _rusf, _qahb, _ለመቋቋ, 
   {{0xac940251,0x8d741037,0x69c41038,0x20c00016}},	//   давш, ساسا, vche, _gói_, 
   {{0x6e2405b1,0x6abc1039,0x3a380356,0x2ca8103a}},	//   _wahb, _pusf, _anrp_, umad_, 
   {{0x69c4103b,0x6e24016d,0x1c1c0dba,0xcee8103c}},	// [b70] tche, _tahb, _पसरल_, _اربن_, 
   {{0x69c4103d,0x2450012c,0x248c017a,0x2ca800ad}},	//   uche, _vámi_, zoem_, smad_, 
   {{0x69c4103e,0x2918103f,0xc0200c58,0xfaa800c6}},	//   rche, تقاد_, ধাৰণ_, أهلي_, 
   {{0x69c41040,0xd1241041,0x68e40009,0x6abc1042}},	//   sche, _یم_, rshd, _tusf, 
   {{0x69c41043,0x68e405b1,0x7ea01044,0x27fc0042}},	//   pche, sshd, löpa, rgwn_, 
   {{0x61e01045,0x660c0e3c,0x2ee80af9,0x63b80142}},	//   xall, đako, _mvaf_, _sgwn, 
   {{0x7ea00793,0x68e4022e,0xf6081046,0x00000000}},	//   nöpa, qshd, ستوه_, --, 
   {{0x20c01047,0x482000db,0x624c032e,0xd3440133}},	//   _rói_, _سۉتق, _núor, ژینه_, 
   {{0x27ec1048,0x20c001fb,0x320c0142,0x00000000}},	//   _iden_, _sói_, ffdy_, --, 
   {{0x7ea00621,0x60e81049,0x248c003e,0x45a008b0}},	//   köpa, омом_, soem_, _كەشك, 
   {{0x26cc0640,0x624c0419,0x00000000,0x00000000}},	//   _hteo_, _súos, --, --, 
   {{0xd36c104a,0x94240131,0x20c00208,0xdee40454}},	//   اهی_, _يولۇ, _vói_, моми, 
   {{0xfe78104b,0xd12c104c,0x9f40036e,0x00000000}},	//   зүп_, همی_, makë_, --, 
   {{0x61e0104d,0x13e0015b,0x02a4104e,0x9f40036e}},	//   qall, _যায়, _эрем, lakë_, 
   {{0x61ec03f9,0x00000000,0x00000000,0x00000000}},	//   _ɓall, --, --, --, 
   {{0x27ec104f,0x26cc1050,0x9f400200,0x00000000}},	//   _nden_, _oteo_, nakë_, --, 
   {{0x20100223,0xe8b80327,0x5dd40137,0x4f20004e}},	// [b80] _ibyi_, _བཤུག, _оюну, _адыб, 
   {{0x27ec1051,0x6d5802a8,0xcf900375,0x00000000}},	//   _aden_, _ƙwat, _בטח_, --, 
   {{0xa3bc0574,0xf3e8015b,0x9f400200,0x00000000}},	//   _आलं_, ক্টর_, kakë_, --, 
   {{0x27ec1052,0x8d741053,0xb17c0115,0x9f400200}},	//   _cden_, _زاپا, naĥa, jakë_, 
   {{0xda641054,0x01e00729,0xaa080014,0x245001ef}},	//   _قاسي, _মানদ, _کزُل_, _jámu_, 
   {{0x27ec1055,0x850004d3,0x2450013a,0x00000000}},	//   _eden_, چوون, _mámu_, --, 
   {{0x201002c4,0x34940124,0x85001056,0x2298020c}},	//   _obyi_, накр, نوون, mèkh_, 
   {{0xb9e80020,0x3e580100,0x2298020c,0x00000000}},	//   _ክስ_, _lٍt_, lèkh_, --, 
   {{0x60cc0552,0x05cc01bc,0x245008a5,0x8cac05c0}},	//   _čama, _स्वब, _námu_, ंगतो, 
   {{0x2488098d,0x657800c6,0x60cc00b0,0xdbd41057}},	//   čama_, ábhá, _ōama, _hääd, 
   {{0x09f4025f,0x7bc8013f,0x9f400066,0x65b81058}},	//   ומים_, _ɑdur, lakè_, _хуур_, 
   {{0xdbd41059,0x9f40036e,0x3f8c0b97,0x00000000}},	//   _jääd, cakë_, ğdun_, --, 
   {{0x9f40020c,0x00000000,0x00000000,0x00000000}},	//   nakè_, --, --, --, 
   {{0x7ea0005b,0x24500306,0x00000000,0x00000000}},	//   töpa, _dámu_, --, --, 
   {{0x2d840724,0xf27001d9,0x313400cf,0x01f8011a}},	//   çle_, _لێکھ, _чейр, _ופול, 
   {{0x4ba40228,0x9f4000f2,0xd9380092,0x06cc00eb}},	//   дөгү_, kakè_, _የሚያዋ, _রিসি, 
   {{0x27ec0295,0x78c40521,0x9f400100,0x7ea001f4}},	// [b90] _rden_, _ịkpọ_, jakè_, söpa, 
   {{0x614400db,0x7ea001e3,0x9f400200,0x00000000}},	//   _زىۋە, löpn, zakë_, --, 
   {{0x26cc0270,0x0fe0033f,0xc86401c6,0xf3e403d4}},	//   _steo_, परपढ, мтди, _গানৰ_, 
   {{0xc1980375,0xad100022,0x6d400108,0x6d540432}},	//   חשבי, _иҿҳә, älau, myza, 
   {{0x7ac4105a,0x6d5401ed,0x4ab0035b,0x6d400158}},	//   _ассе, lyza, _аҩар, ålaf, 
   {{0xe5a4105b,0x00000000,0x00000000,0x00000000}},	//   нили, --, --, --, 
   {{0xdb100086,0xe8b8025c,0x1cd8031c,0x7aa408ca}},	//   _ògòr, _བཤིག, ོེར_, _риёз, 
   {{0x27ec105c,0x39a40014,0xd58403e6,0x383401af}},	//   _uden_, _شینہ, رێنه_, _инср, 
   {{0x2cb801ab,0x9f400240,0x22980214,0x7790105d}},	//   _misd_, rakë_, lèki_, _پیوا, 
   {{0x64b0005f,0x245002fb,0xdbd400a2,0x9f400200}},	//   _jāiz, _rámu_, _täçd, sakë_, 
   {{0x9f40105e,0x398c0023,0x6d5400a2,0x00000000}},	//   maké_, _ንታሕቲ_, jyza, --, 
   {{0x2cb800a3,0x9f40034c,0x00000000,0x00000000}},	//   _nisd_, laké_, --, --, 
   {{0x91dc0c58,0x24500174,0x2d84002d,0xc334009f}},	//   _মাৰ্, _dámt_, ûlen_, _آڻبا_, 
   {{0x2cb800a3,0x2298020c,0x9f40034c,0xd65c0354}},	//   _aisd_, kèki_, naké_, _кiед, 
   {{0xdd90105f,0x9f400066,0x6d5402d0,0x00000000}},	//   اوز_, iaké_, gyza, --, 
   {{0x9f400502,0x6d580c09,0x00000000,0x00000000}},	//   haké_, _ƙwar, --, --, 
   {{0x9f401060,0x85400153,0x00000000,0x00000000}},	// [ba0] kaké_, _šėls, --, --, 
   {{0x9f400232,0xdbd402f6,0xcfb40375,0x2cb801c3}},	//   jaké_, _sääd, _אלפי_, _eisd_, 
   {{0x7ea00793,0xdbd40f23,0x9f400214,0x69a400dc}},	//   löpo, _pääd, daké_, _करणी, 
   {{0x2298020c,0x57a4009d,0xd7f000ae,0x00000000}},	//   sèkh_, ншла, اكش_, --, 
   {{0x9f400214,0xf4e40150,0x00000000,0x00000000}},	//   faké_, _ﺍﻹﺸﻜ, --, --, 
   {{0x9f4000f2,0x6d401061,0x86c0009a,0x00000000}},	//   gaké_, ålag, ديون, --, 
   {{0x2298020c,0x245001a8,0x00000000,0x00000000}},	//   cèki_, _náms_, --, --, 
   {{0x69a41062,0x9f40020c,0x7ea00108,0x5fb001f9}},	//   _करती, pakè_, köpo, ीखाल, 
   {{0x087400c8,0xb5fc0135,0x9f4004fb,0x8410010b}},	//   _נעמט_, _alġe, baké_, умых, 
   {{0x9f400066,0x00000000,0x00000000,0x00000000}},	//   caké_, --, --, --, 
   {{0xe5041063,0x00000000,0x00000000,0x00000000}},	//   _لبني, --, --, --, 
   {{0x25a00e78,0xe534010f,0x00000000,0x00000000}},	//   ühle_, _שטײט_, --, --, 
   {{0x2cb800ca,0xbfa81064,0x2d980131,0x814001d5}},	//   _risd_, етре_, ﺘﯩﻨﻰ_, ننین, 
   {{0x6d540034,0xfe241065,0xc324007b,0x0e440166}},	//   tyza, льсн, _أكون_, хэмм, 
   {{0xf1a800f1,0x3cdc09ab,0x00000000,0x00000000}},	//   _ډاډه_, गीले_, --, --, 
   {{0x6d54068f,0xbc381066,0x9f40020c,0x301400c7}},	//   ryza, ىسقا_, zaké_, _рдир, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [bb0] --, --, --, --, 
   {{0x6d40005b,0x06cc0154,0xb17c00df,0x00000000}},	//   älas, _রিলি, naĥo, --, 
   {{0x9f4000e4,0x6d4001e3,0x5e58009f,0x00000000}},	//   vaké_, ålad, _آلپس_, --, 
   {{0x6b741067,0xe7b400be,0x00000000,0x00000000}},	//   _алму, نماد, --, --, 
   {{0x9f40034c,0x7ea001e3,0x00000000,0x00000000}},	//   také_, köpl, --, --, 
   {{0xf6d40214,0x00000000,0x00000000,0x00000000}},	//   ازند, --, --, --, 
   {{0x9f40034c,0x60cc00f3,0x1fac07f7,0x00000000}},	//   raké_, _čamo, _टण्ड, --, 
   {{0x24881068,0x9f40034c,0x23341069,0x00000000}},	//   čamo_, saké_, вхор, --, 
   {{0x9f40106a,0x130400c9,0xb884010b,0x97300014}},	//   paké_, вный_, _сурй, _پکنا, 
   {{0x68e0037e,0xf770106b,0xfa700023,0x57a401af}},	//   _ælds, _طاق_, _በየናይ_, _рысҡ, 
   {{0x2168106c,0x35d4009d,0xa3c00709,0x3f8c03e0}},	//   фини_, _сохё, ःखद_, ğdum_, 
   {{0x2054106d,0x3f8c106e,0x7ea001f4,0x00000000}},	//   ттор, şdum_, töpo, --, 
   {{0xb17c01e4,0x00000000,0x00000000,0x00000000}},	//   baĥo, --, --, --, 
   {{0x6448106f,0xc44400f2,0x00000000,0x00000000}},	//   ljei, _آیکن_, --, --, 
   {{0x62800158,0x26080b4c,0x2618000d,0x00000000}},	//   mnlo, _सानी_, _मउनी_, --, 
   {{0x64481070,0x00000000,0x00000000,0x00000000}},	//   njei, --, --, --, 
   {{0x62801071,0x6448021c,0x00000000,0x00000000}},	// [bc0] onlo, ijei, --, --, 
   {{0x62801072,0x64481073,0x1b040183,0x4ef808a8}},	//   nnlo, hjei, ৰিলে_, _קליג, 
   {{0xa3d00490,0x62800af9,0x00000000,0x00000000}},	//   वडा_, inlo, --, --, 
   {{0x38600491,0x6280002f,0xdca40a5b,0x00000000}},	//   óir_, hnlo, _јами, --, 
   {{0x8cac01ad,0x8d901074,0x62800327,0x00000000}},	//   ंगरो, _ملیش, knlo, --, 
   {{0x628001a4,0xace800f2,0x00000000,0x00000000}},	//   jnlo, _تریل_, --, --, 
   {{0x9f4002b5,0x97c41075,0xf3f801ec,0x48e0022e}},	//   kakï_, _айбе, еңе_, _восв, 
   {{0xb8b40046,0x98a41076,0x62800051,0xf49800d1}},	//   _сөзі, _рибе, enlo, رھات_, 
   {{0x68e0019b,0x799c00a9,0x846002e8,0xd36c00d1}},	//   _ældr, _hyrw, ръще, غۇت_, 
   {{0x799c03a2,0xd4f4010b,0x6280032e,0x00000000}},	//   _kyrw, _аяды, gnlo, --, 
   {{0x66801077,0xd16402e8,0x8678011a,0x00000000}},	//   _دیول, тъпи, _קרבו, --, 
   {{0x628001f4,0x75280064,0xaed408ca,0x4e780023}},	//   anlo, _isdz, ломш, _ኣብራሃ_, 
   {{0x260806ab,0x2eec0694,0x92681078,0x00000000}},	//   _सामी_, éef_, _орка_, --, 
   {{0x5c1004c5,0xc1701079,0xc7b00375,0x03a00107}},	//   হযোগ_, ادیت, יבר_, _тичо, 
   {{0xac18107a,0x5064107b,0x8cac107c,0x998800de}},	//   нову_, _атпа, ंगलो, _dabū_, 
   {{0x660c107d,0x62780419,0x00000000,0x00000000}},	//   đaki, pňoc, --, --, 
   {{0x6a14107e,0x69a40037,0x98b80064,0x00000000}},	// [bd0] лмау, _करही, lypė_, --, 
   {{0x245000d7,0x79d400d4,0x00000000,0x00000000}},	//   _lámp_, ижує, --, --, 
   {{0x9f4c00dd,0xe7f401c6,0x00000000,0x00000000}},	//   önöm_, гчлэ, --, --, 
   {{0x1ee8107f,0x00000000,0x00000000,0x00000000}},	//   _تویی_, --, --, --, 
   {{0x3c4405f5,0x628003a2,0x69a40825,0xe618011c}},	//   _тээв, ynlo, _करवी, едл_, 
   {{0x66041080,0xdb1c0174,0x00000000,0x00000000}},	//   упка, _ívág, --, --, 
   {{0x26080574,0x799c03cb,0x6b9c03cb,0x62801081}},	//   _साठी_, _gyrw, _hysg, vnlo, 
   {{0x62800475,0x00000000,0x00000000,0x00000000}},	//   wnlo, --, --, --, 
   {{0x29001082,0x86c0004b,0x64480e03,0x3f8c0205}},	//   luha_, _څيړن, rjei, ğduk_, 
   {{0x67281083,0x20d41084,0xe0d800c7,0x00000000}},	//   _isej, лімс, нво_, --, 
   {{0x29001085,0x6f0c0309,0x628003cd,0x507800b8}},	//   nuha_, _aqac, rnlo, _ṇāṃ_, 
   {{0x34941086,0x26080c22,0x942400f7,0xc0f40092}},	//   _кахр, _साडी_, _مومۇ, ላለሻ_, 
   {{0x29001087,0x6b9c1088,0x67280135,0x00000000}},	//   huha_, _nysg, _jsej, --, 
   {{0x29001089,0xfd64108a,0x4e7802d3,0x21a40e46}},	//   kuha_, ангү, _ኣብርሃ_, _йилм, 
   {{0x9f400085,0x6b9c02d0,0x999802b1,0xe0d00214}},	//   makí_, _aysg, tepō_, _ازت_, 
   {{0x2900108b,0x9f400093,0x6b9c03cb,0x672803ac}},	//   duha_, lakí_, _bysg, _osej, 
   {{0xcb64108c,0xabc40184,0x6b9c0368,0x6728025c}},	// [be0] гате_, рауҙ, _cysg, _nsej, 
   {{0x6b9c0cfd,0x9f400418,0xdd380311,0x2900108d}},	//   _dysg, nakí_, _căţe, fuha_, 
   {{0x6728108e,0x2900015c,0x2298108f,0x18a40e92}},	//   _asej, guha_, lèks_, гажм, 
   {{0x9f400093,0xdc6805f5,0xd7cc033f,0x00000000}},	//   hakí_, _чамд_, हुंच, --, 
   {{0x6b9c1090,0x2298007f,0x799c012d,0x050000fe}},	//   _gysg, nèks_, _wyrw, লবোৰ_, 
   {{0x29001091,0x799c06a3,0x9f4006c6,0xd06c0055}},	//   buha_, _tyrw, jakí_, _ṃśaḥ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x26081092,0x04601093,0xc89400db,0xf31800d8}},	//   _साथी_, йтым, _бууө, воиш_, 
   {{0x07a009a5,0x9f400022,0x00000000,0x00000000}},	//   _гатн, hakâ_, --, --, 
   {{0x471800c8,0x22980669,0x00000000,0x00000000}},	//   _אומג, dèks_, --, --, 
   {{0x26081094,0x1fa00150,0x8a94010f,0x94041095}},	//   _साती_, _ﺍﺭﺍﻻ_, רכיװ_, _مواه, 
   {{0xb0e80137,0x70940395,0x00000000,0x00000000}},	//   ндүз_, рамф, --, --, 
   {{0x29001096,0x087400c8,0x04901097,0xa3d01098}},	//   zuha_, רעכט_, _النح, वडर_, 
   {{0x65ac0943,0x29001099,0x7e28109a,0x6b9c109b}},	//   ṱhed, yuha_, ліса_, _rysg, 
   {{0x70a402d3,0x2900031c,0xecc4009d,0x00000000}},	//   ገብረሉ_, xuha_, ршгү, --, 
   {{0x6b9c0368,0xe944109c,0xc9840116,0x29000327}},	//   _pysg, یرای, қузи, vuha_, 
   {{0x2900109d,0xdd380356,0x00000000,0x00000000}},	// [bf0] wuha_, _păţe, --, --, 
   {{0x7ed40491,0x2900109e,0x26080073,0x6e9402da}},	//   _ازيا, tuha_, _साधी_, _خلخا, 
   {{0x66740502,0x6b9c0af9,0x6728109f,0x00000000}},	//   یدتر, _wysg, _ssej, --, 
   {{0x290010a0,0x386401ab,0xab9402bf,0x00000000}},	//   ruha_, _clmr_, _вимі, --, 
   {{0x290010a1,0x260805f9,0x66b410a2,0x6b9c0857}},	//   suha_, _सादी_, абду, _uysg, 
   {{0x09dc00bd,0x290010a3,0x957002d3,0x67280010}},	//   _ঢাকা, puha_, _እንቋዕ_, _vsej, 
   {{0x0ba802dd,0x01e00154,0x00000000,0x00000000}},	//   _زاڭى_, _মালদ, --, --, 
   {{0x67280184,0x9f400085,0x3ce805f9,0xf77002f2}},	//   _tsej, wakí_, _जबसे_, _کاف_, 
   {{0x672810a4,0xe3a8016c,0x9f400418,0x66d401f7}},	//   _usej, ъкид_, takí_, _ضيائ, 
   {{0x9f4000e4,0xbb880150,0x00000000,0x00000000}},	//   hakã_, _ﺭﺃﻴﻪ_, --, --, 
   {{0xe04410a5,0x21a401b9,0x9a740375,0xb46410a6}},	//   анни, ринм, שתתף_, ркөл, 
   {{0x1b2c0020,0xf48410a7,0x2298033b,0x33d40153}},	//   _ብርቱካ, _лучн, tèks_, _лішт, 
   {{0xa2e410a8,0x00000000,0x00000000,0x00000000}},	//   _толд, --, --, --, 
   {{0x442c0ad3,0x8fa0003b,0x00000000,0x00000000}},	//   _hag_, іаре, --, --, 
   {{0x442c10a9,0xa0a4010b,0x216800d1,0x94ec0213}},	//   _kag_, _какд, _шики_, _bəə_, 
   {{0x442c10aa,0x00000000,0x00000000,0x00000000}},	//   _jag_, --, --, --, 
  
   {{0x6b8400c6,0x59d40116,0x94ec03b9,0x1cd80327}},	// [c00] مشكل, لغار, _dəə_, ོེང_, 
   {{0x442c10ab,0x7ea0049f,0xd0e410ac,0x4a4010ad}},	//   _lag_, köpi, _حکیم_, онув, 
   {{0x442c00ca,0x7e7c05be,0xdca410ae,0x00000000}},	//   _oag_, mirp, _вани, --, 
   {{0x442c10af,0x7e7c05b1,0x4904007d,0x6a840022}},	//   _nag_, lirp, _हमरो_, алӡа, 
   {{0x7c2410b0,0xc5cc03d4,0x7e7c01e7,0x00000000}},	//   meir, _ৰাজপ, oirp, --, 
   {{0x7c2410b1,0x442c10b2,0x7e7c0309,0x236c10b3}},	//   leir, _aag_, nirp, dzej_, 
   {{0x442c0c30,0x9f4005da,0xa3c000dc,0x00000000}},	//   _bag_, hakà_, ःखं_, --, 
   {{0x7c2410b4,0x442c10b5,0x7e7c01ab,0xcdb4011a}},	//   neir, _cag_, hirp, ספקה_, 
   {{0x7e7c10b6,0xa30000fd,0xb27400d1,0x938802e8}},	//   kirp, зүче, йлиш, ъска_, 
   {{0x442c03d5,0x59a810b7,0xc0f4001f,0xb17c0115}},	//   _eag_, _करार, ላለሁ_, laĥi, 
   {{0x442c10b8,0x518410b9,0xd5480014,0x25a80198}},	//   _fag_, рупа, _جلاو_, ƙala_, 
   {{0x442c0226,0x7c2410ba,0x044000c2,0xb17c00df}},	//   _gag_, jeir, _мехн, naĥi, 
   {{0x7c2410bb,0x236c068f,0xa3b40864,0xe2f80014}},	//   deir, czej_, छेद_, _مونڈ_, 
   {{0x442c10bc,0xbe88034b,0x00000000,0x00000000}},	//   _zag_, ассе_, --, --, 
   {{0x7c240cfd,0x442c10bd,0xd08400c9,0xb7f80950}},	//   feir, _yag_, _выпи, ुलाम_, 
   {{0x7c2410be,0x442c0014,0xf8b00764,0x2b48004e}},	//   geir, _xag_, जगोप, txac_, 
   {{0x35700092,0x9f4000e4,0x4ea400d8,0x7c840022}},	// [c10] ቻልበት_, rakã_, _врна, цуре, 
   {{0x248810bf,0x9f40035b,0xba740472,0x7e7c00ef}},	//   čami_, sakã_, يالت, cirp, 
   {{0x7c2410c0,0x9f4002ea,0x2d58030d,0xc0d001f3}},	//   beir, maká_, _синь_, ካፈል_, 
   {{0x7c2410c1,0x9f4010c2,0x26080b03,0x00000000}},	//   ceir, laká_, _साही_, --, 
   {{0x442c10c3,0xfe7010c4,0x8d74001f,0xfb84010b}},	//   _rag_, _ردی_, ረጋቸው_, _дырн, 
   {{0x442c10c5,0x9f4002ea,0xc0f4001f,0x1b0403d4}},	//   _sag_, naká_, ላለህ_, ৰিখে_, 
   {{0xe29810c6,0x442c10c7,0x98780882,0x67d401af}},	//   ған_, _pag_, ṣām_, _гобу, 
   {{0xe3e804d3,0x442c01d4,0x4a7000ec,0xa4440b01}},	//   اکان_, _qag_, _اُڀر, снид, 
   {{0x442c10c8,0xe29810c9,0x9f4002ea,0xd8b400dd}},	//   _vag_, лаи_, kaká_, _اگلا_, 
   {{0x442c10ca,0x7c2410cb,0x9f400308,0x236c033f}},	//   _wag_, zeir, jaká_, rzej_, 
   {{0x442c10cc,0x236c006d,0x217410cd,0x7c2400e5}},	//   _tag_, szej_, супр, yeir, 
   {{0x7c2410ce,0x442c0441,0x21a410cf,0x672c0135}},	//   xeir, _uag_, _қийм, ħajf, 
   {{0x7c2410d0,0x6d4010d1,0xa37c02ce,0x7e7c10d2}},	//   veir, ålan, kaŵi, tirp, 
   {{0x1d0810d3,0x53980375,0x7c240368,0x93c00311}},	//   леги_, _גינו, weir, ţăto, 
   {{0x7c2410d4,0xc32c01d9,0x00000000,0x00000000}},	//   teir, _رٕژ_, --, --, 
   {{0x3e7806be,0x600800f3,0x5f28014b,0x00000000}},	//   _mütə_, _сним_, _боим_, --, 
   {{0x7c2410d5,0x5ba806a6,0x7e7c0b1a,0xd7f801a9}},	// [c20] reir, укам_, pirp, ҳул_, 
   {{0x7c2410d6,0x0f340375,0x7e7c0784,0x46c800bc}},	//   seir, _פריט_, qirp, ादनह, 
   {{0xd7f810d7,0x7c2410d8,0x97c400c6,0x2fcc0331}},	//   гул_, peir, مقاو, žege_, 
   {{0x18a410d9,0x574410da,0x6b880010,0x06cc00eb}},	//   щаем, йнеб, _žege, _রিজি, 
   {{0xb17c01e4,0xd49810db,0x9988013a,0x00000000}},	//   raĥi, һри_, _tabů_, --, 
   {{0xc7a00902,0x00000000,0x00000000,0x00000000}},	//   чичк, --, --, --, 
   {{0x260810dc,0x398400f2,0xa2ac00cd,0x00000000}},	//   _सारी_, _بیاف, ुगन्, --, 
   {{0xe9e40589,0x6d5803f9,0x00000000,0x00000000}},	//   ãºva_, _ƙwaz, --, --, 
   {{0xe80c10dd,0xe850105d,0x7794030f,0x00000000}},	//   _हाता_, _تۆند, _بیشا, --, 
   {{0x48fc00bc,0x00000000,0x00000000,0x00000000}},	//   शूको_, --, --, --, 
   {{0x661405d1,0x3b000455,0x614000c7,0x86b4009f}},	//   _özka, hriq_, ҧҵәа, _اُلر_, 
   {{0x518410cf,0xc9500375,0xdbd4008e,0xf48401d5}},	//   _қула, למת_, _cäüd, _باطی, 
   {{0x9f4002ea,0x00000000,0x00000000,0x00000000}},	//   taká_, --, --, --, 
   {{0x8d7410de,0xf1c80075,0x00000000,0x00000000}},	//   مازا, _ئاشۇ_, --, --, 
   {{0x865810df,0xdd380276,0xc20410e0,0xdbd40139}},	//   נדלי, văţa, _اقىن_, _fäüd, 
   {{0x9f4010e1,0x3dcc013f,0x4fc410e2,0xdbd4008e}},	//   saká_, _ɔkwɑ_, _уска, _gäüd, 
   {{0x260810e3,0x9f400270,0xaa5410e4,0xbea800ec}},	// [c30] _साली_, paká_, оваш, _ڏهين_, 
   {{0x7f94010a,0x4e9401e2,0x00000000,0x00000000}},	//   _хаьх, _دشعر, --, --, 
   {{0xac9400c2,0xdd380311,0x7ed4020e,0x3b00022e}},	//   _маош, răţa, _وزیا, ariq_, 
   {{0xf77010e5,0x27e810e6,0xbd8804fb,0x0ff80401}},	//   کام_, úan_, _چنین_, ्लिश_, 
   {{0x94f40135,0x65c410e7,0x499010e8,0x00000000}},	//   ྗེའི_, обла, _کیار, --, 
   {{0xa56410e9,0xdde400cd,0x517402dd,0x00000000}},	//   يگان, _āpūr, _ﺸﺒﺎﻁ_, --, 
   {{0x6d580b45,0x00000000,0x00000000,0x00000000}},	//   _ƙway, --, --, --, 
   {{0xe45810ea,0x66d000c7,0x8cac10eb,0xdb100241}},	//   ржи_, _ẽkur, ंगटो, _ọ̀wọ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x625810ec,0xdbd40724,0xe2900736,0x6e20000d}},	//   ррир_, _säüd, بذب_, õlbl, 
   {{0x60240c98,0x63f810ed,0x6aa40165,0xa3b800f1}},	//   одна, _نفاس_, ilhf, داګر_, 
   {{0x81700150,0x00000000,0x00000000,0x00000000}},	//   _ﺸﺒﻜﺔ_, --, --, --, 
   {{0x69d40221,0x2480020c,0x7ea010ee,0xaaa800bc}},	//   _ofze, éhmu_, köpt, कताक, 
   {{0x68f402fb,0xb8fc031c,0xa3d00073,0x00000000}},	//   _ovzd, _རྕ_, वडक_, --, 
   {{0xdd9010ef,0x1b0403d4,0xdbd40139,0x29000327}},	//   ذور_, ৰিছে_, _täüd, jrha_, 
   {{0x8c4010f0,0x69d40196,0x20f40421,0xc5f0015b}},	//   месе, _afze, māi_, চ্চা_, 
   {{0x2900025c,0x00000000,0x00000000,0x00000000}},	// [c40] erha_, --, --, --, 
   {{0x7ea010f1,0x3b0010f2,0x61e0036e,0x1e84026b}},	//   töpu, rriq_, nbll, _флом, 
   {{0x2d84002d,0x17c800c7,0x3b0000e4,0x00000000}},	//   ûlet_, агеи_, sriq_, --, 
   {{0x186810f3,0xd6d8005b,0x7ac40117,0x00000000}},	//   јади_, атк_, _нимҷ, --, 
   {{0xc5f009bd,0x160c10f4,0xc6d00150,0x3b000113}},	//   চ্ছা_, _सादर_, وتوت, qriq_, 
   {{0x473010f5,0x38c803e6,0x95700023,0x8f9800d9}},	//   ьніс, _هاری_, _እንቛዕ_, סיסי, 
   {{0x29000142,0xc1e00037,0xd94400d8,0x9f400139}},	//   crha_, _ग़जब_, _ќеби, lakä_, 
   {{0xe8b000db,0x00000000,0x00000000,0x00000000}},	//   _كەلج, --, --, --, 
   {{0x833001c6,0x2450013a,0x00000000,0x00000000}},	//   дных, _jámy_, --, --, 
   {{0xd25810f6,0x20f40421,0xf1b80327,0xc60000db}},	//   рци_, fāi_, leġi_, _озуй, 
   {{0x98c800bc,0x645c002f,0x6e200037,0xc1b4009d}},	//   िदिए, ösic, õlbm, жлэх_, 
   {{0x7ea001e6,0xe4e80035,0xb11800db,0xc56000ec}},	//   köps, _طعمه_, _ۇقتا_, _تڏهي, 
   {{0x78a0014b,0x64940208,0x00000000,0x00000000}},	//   _mkmv, _rơix, --, --, 
   {{0x4170004b,0x00000000,0x00000000,0x00000000}},	//   _ښايس, --, --, --, 
   {{0xc10000cf,0xa6e8004d,0x7058013e,0x00000000}},	//   _قووي, _giươ, _гайр_, --, 
   {{0x3e540baa,0x3f8c05d1,0x4bd800f2,0x00000000}},	//   _aştı_, ğdur_, شبرد_, --, 
   {{0x3f8c03be,0x29000327,0x3f6800f3,0x00000000}},	// [c50] şdur_, wrha_, _мићо_, --, 
   {{0xe80c10f7,0x24500122,0x7c60001f,0x00000000}},	//   _हाहा_, _dámy_, ደሌለው_, --, 
   {{0xf7d802e3,0x278801e0,0xa7a80116,0xfeb810f8}},	//   _ịrụp, әреү_, әкла_, _بايت_, 
   {{0x2ee803f9,0x29000393,0x245002f0,0xac9410f9}},	//   _kwaf_, rrha_, _fámy_, _хамш, 
   {{0x872400c6,0x09e0015b,0x490402a0,0x46300022}},	//   تعام, মণবা, _हमको_, мҭар, 
   {{0xe80c10fa,0x00000000,0x00000000,0x00000000}},	//   _हावा_, --, --, --, 
   {{0x2fc80280,0x224810fb,0x363400ae,0x00000000}},	//   _ogag_, _đak_, برنس, --, 
   {{0x2fc80428,0xd70002dd,0x00000000,0x00000000}},	//   _ngag_, _бiра, --, --, 
   {{0xc6a410fc,0xd7e800db,0xa3b4012d,0xa0a40107}},	//   _држи, _دوقۇ_, छें_, ҷанд, 
   {{0x27ec10fd,0xf77010fe,0x2fc810ff,0x6aa81100}},	//   _heen_, _شاق_, _agag_, _कठोर, 
   {{0xa0a41101,0x644c0086,0xba04001f,0x61440aa8}},	//   занд, _òaio, _ውድ_, чена, 
   {{0x26c41102,0x26cc00b0,0x27ec0363,0x24881103}},	//   _hilo_, _kueo_, _jeen_, _ñam_, 
   {{0x27ec1104,0x25a4015d,0x00000000,0x00000000}},	//   _meen_, _hyll_, --, --, 
   {{0x27ec1105,0x64581106,0x2ee81107,0xd35406a9}},	//   _leen_, _howi, _dwaf_, _מיני_, 
   {{0x64581108,0x2fcc1109,0x97300092,0x00000000}},	//   _kowi, žega_, _በውድድ, --, 
   {{0x26c4110a,0x27ec110b,0x3eb8110c,0x6b8801a6}},	//   _lilo_, _neen_, smrt_, _žega, 
   {{0x20100230,0x2ee803f9,0x26c401c4,0x2d84004a}},	// [c60] _icyi_, _gwaf_, _oilo_, ûler_, 
   {{0x6280110d,0x26c4110e,0x6458110f,0x9e280050}},	//   nilo, _nilo_, _lowi, _آدم_, 
   {{0x27ec1110,0x5ca41111,0x9f4000c7,0xf1b80135}},	//   _been_, _ниоб, sakä_, teġi_, 
   {{0x62801112,0x26c40b23,0x27ec002e,0x64581113}},	//   hilo, _ailo_, _ceen_, _nowi, 
   {{0x27ec1114,0x62801115,0xc04c001f,0xe80c1116}},	//   _deen_, kilo, _እየተገ, _हारा_, 
   {{0x6b880f99,0x62801117,0x26c401a6,0x00000000}},	//   _þega, jilo, _cilo_, --, 
   {{0x26c41118,0x62801119,0x6458111a,0x27ec111b}},	//   _dilo_, dilo, _bowi, _feen_, 
   {{0x27ec111c,0x6458111d,0x26c40270,0x62800165}},	//   _geen_, _cowi, _eilo_, eilo, 
   {{0x26c4111e,0x6458111f,0x00000000,0x00000000}},	//   _filo_, _dowi, --, --, 
   {{0x62801120,0x25a41121,0x26c4020c,0x645803ac}},	//   gilo, _fyll_, _gilo_, _eowi, 
   {{0x76481122,0x2ee81123,0x27ec0694,0x25a40142}},	//   _indy, _swaf_, _yeen_, _gyll_, 
   {{0x64581124,0x62800618,0x76440198,0x2f880124}},	//   _gowi, ailo, ɓiya, жәон_, 
   {{0x27e81125,0xe4540b43,0x26c41126,0x8898011a}},	//   ðani_, _تفنگ, _yilo_, מבטי, 
   {{0xdee40201,0x64581127,0x62801128,0xc0f40020}},	//   ሜሪካ_, _zowi, cilo, ላለም_, 
   {{0xbfec0c58,0x64581129,0x8c64112a,0xfe7000e3}},	//   _কাৰণ_, _yowi, птад, ادُ_, 
   {{0x4fc4074d,0x2ee80175,0x00000000,0x00000000}},	//   _эска, _twaf_, --, --, 
   {{0x27ec112b,0xfbd00597,0xddc80311,0x99880010}},	// [c70] _reen_, اتف_, _înşi, _rabš_, 
   {{0x27ec0c3e,0x7ea0112c,0x49c800c7,0x4a2400c7}},	//   _seen_, söpr, суам_, џьаб, 
   {{0x88c4112d,0x80a4112e,0x26c4089c,0x27ec112f}},	//   ستال, _زمین, _rilo_, _peen_, 
   {{0x76481130,0x2c080502,0x26cc0069,0x7f84006c}},	//   _andy, _بعدی_, _pueo_, _آلین, 
   {{0x64581131,0x26c41132,0x27ec1133,0x2ca81134}},	//   _rowi, _pilo_, _veen_, mlad_, 
   {{0x2ca81135,0x64581136,0x27ec1137,0x62801138}},	//   llad_, _sowi, _ween_, xilo, 
   {{0x64581139,0x26c40978,0x27ec113a,0x2ca8058a}},	//   _powi, _vilo_, _teen_, olad_, 
   {{0x7648113b,0x2ca8113c,0x26c4016d,0x260801ad}},	//   _endy, nlad_, _wilo_, _साकी_, 
   {{0x26c4113d,0x2ca800a9,0x64580810,0xe298113e}},	//   _tilo_, ilad_, _vowi, жап_, 
   {{0x6458016b,0x2ca8113f,0x62801140,0x25a41141}},	//   _wowi, hlad_, uilo, _tyll_, 
   {{0x62801142,0x2ca81143,0x25a40076,0x64580f85}},	//   rilo, klad_, _uyll_, _towi, 
   {{0x1de40b4c,0x62780122,0x660c02a8,0xd5980375}},	//   कर्ष_, jňov, ɗaka, _ובעל, 
   {{0x2ca81144,0x62780122,0x248c1145,0x76481146}},	//   dlad_, dňov, mnem_, _yndy, 
   {{0x248c1147,0x62801148,0x21681149,0xe1f000f2}},	//   lnem_, qilo, _мили_, _شست_, 
   {{0x248c0de4,0x2ca801d9,0xdca4114a,0x2d94114b}},	//   onem_, flad_, дави, ертс, 
   {{0x248c114c,0x4e1c0abd,0x9f04114d,0x00000000}},	//   nnem_, म्बई_, _قوبو, --, 
   {{0x248c114e,0xfb84114f,0x00000000,0x00000000}},	// [c80] inem_, ردری, --, --, 
   {{0x2ca81150,0x248c1151,0x77f81152,0x261800c5}},	//   alad_, hnem_, ुल्क_, _मउगी_, 
   {{0x248c1153,0x9f400030,0x627802f0,0xb80800fe}},	//   knem_, jakú_, bňov, _ৰোগত_, 
   {{0x248c1154,0x9f940139,0xe99400f2,0x62781155}},	//   jnem_, _cüçi_, رهنگ, cňov, 
   {{0x248c1156,0x4aac1157,0x00000000,0x00000000}},	//   dnem_, _जीवव, --, --, 
   {{0xa3c002a0,0xf4841158,0x644c0086,0x248c0393}},	//   ंधन_, کاتی, _òaij, enem_, 
   {{0xceb004ac,0x18681159,0xfbb00183,0x248c0010}},	//   דיג_, _дави_, _কলিত, fnem_, 
   {{0x60cc01fa,0x7414115a,0x85400139,0x00000000}},	//   _čamp, روخا, тэше, --, 
   {{0xd6240597,0x3a38115b,0x00000000,0x00000000}},	//   _يعطي, _karp_, --, --, 
   {{0x5184115c,0xfbb002f5,0x041c04c5,0x7648115d}},	//   дума, _কলাত, _মোদী_, _undy, 
   {{0x248c115e,0x1bec01ad,0x62780306,0x2ca8115f}},	//   bnem_, जराल_, yňov, ylad_, 
   {{0x2ca801e3,0x00000000,0x00000000,0x00000000}},	//   xlad_, --, --, --, 
   {{0x2ca81160,0x62780308,0x25b400db,0xcfa800f2}},	//   vlad_, vňov, _قۇۇد_, تادم_, 
   {{0x3a381161,0x2ca81162,0x8d680261,0x91f002e5}},	//   _narp_, wlad_, ојба_, _आजिज_, 
   {{0x62780122,0xf1b80135,0x7ea001e3,0x2ca81163}},	//   tňov, teġu_, röpp, tlad_, 
   {{0x4fc41164,0xa3b400e1,0x3a38045a,0x2ca81165}},	//   _оспа, छेक_, _aarp_, ulad_, 
   {{0x7b181166,0x0dc81167,0x2ca81168,0x627802fb}},	// [c90] мотр_, _муни_, rlad_, rňov, 
   {{0x70541169,0x248c116a,0x627802fb,0x27880137}},	//   _آنکا, znem_, sňov, үрдү_, 
   {{0x248c116b,0x62780232,0x25a803f9,0xfbd001ed}},	//   ynem_, pňov, ƙali_, اتہ_, 
   {{0x248c0369,0x67d40117,0x4aac000d,0x00000000}},	//   xnem_, ходу, _जीरव, --, 
   {{0x248c0fb7,0x2ef8009a,0x0a6800d8,0x64a40022}},	//   vnem_, nssf_, _дрви_, ҽака, 
   {{0x248c116c,0x00000000,0x00000000,0x00000000}},	//   wnem_, --, --, --, 
   {{0x248c0fb7,0x64a4116d,0x00000000,0x00000000}},	//   tnem_, нака, --, --, 
   {{0x248c116e,0x00000000,0x00000000,0x00000000}},	//   unem_, --, --, --, 
   {{0x248c116f,0x97000075,0x3a380309,0x00000000}},	//   rnem_, _مېنى, _yarp_, --, 
   {{0x248c1170,0x22141171,0x3f8403b2,0x00000000}},	//   snem_, хфир, úmum_, --, 
   {{0x248c1172,0x00000000,0x00000000,0x00000000}},	//   pnem_, --, --, --, 
   {{0x24180108,0xef200210,0x00000000,0x00000000}},	//   _ходы_, ężny_, --, --, 
   {{0x270c0574,0x00000000,0x00000000,0x00000000}},	//   _समोर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa068004e,0x00000000,0x00000000,0x00000000}},	//   _нака_, --, --, --, 
   {{0xdca41173,0x3a380afb,0x00000000,0x00000000}},	//   хаби, _sarp_, --, --, 
   {{0x3a381174,0x4dec00cc,0x00000000,0x00000000}},	// [ca0] _parp_, _জাৰ্_, --, --, 
   {{0x7f441175,0x4aa401af,0x9aa41176,0x00000000}},	//   _iriq, екун_, رماو, --, 
   {{0xdb0402f0,0x5804007b,0x00000000,0x00000000}},	//   _myké, فواك, --, --, 
   {{0x3a381177,0x8d741178,0xcdcc004b,0x7f4406be}},	//   _warp_, _ساپا, _نښې_, _kriq, 
   {{0x3a3802d5,0xb5fc0327,0x6d401179,0x7d1c0010}},	//   _tarp_, _joġg, ålav, ltrs, 
   {{0x7ae4117a,0x7f44020c,0x3898007f,0x81c400cc}},	//   mpit, _mriq, dčre_, _োজন_, 
   {{0x7ae4117b,0x7d1c01e0,0xd4c40131,0x00000000}},	//   lpit, ntrs, нсип, --, 
   {{0x7ae40451,0x7f4401a9,0x38c80133,0xf2c8012d}},	//   opit, _oriq, _زازی_, रद्घ, 
   {{0x7ae4117c,0x96b8117d,0x1368117e,0x574400fb}},	//   npit, _فائز_, яшки_, _янаб, 
   {{0xc0f4001f,0x7ae4117f,0x4b78010f,0x7d1c1180}},	//   ዋለሁ_, ipit, פטיג, ktrs, 
   {{0x7f441181,0x27e80004,0x25a0002f,0x00000000}},	//   _ariq, ñang_, ühlt_, --, 
   {{0x7f441182,0xa0341183,0x00000000,0x00000000}},	//   _briq, نىپت, --, --, 
   {{0x7f441184,0x7ae40115,0x00000000,0x00000000}},	//   _criq, jpit, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xac181185,0xcee800f2,0x00000000,0x00000000}},	//   мову_, _کربن_, --, --, 
   {{0x7f441186,0xef100137,0xfa0800eb,0x6aa800cd}},	//   _friq, _күмө, র্মল_, कत्र, 
   {{0x7ae41187,0x6e981188,0x6a140166,0x00000000}},	// [cb0] gpit, _овир_, кмау, --, 
   {{0x6f1c0e78,0x00000000,0x00000000,0x00000000}},	//   mtsc, --, --, --, 
   {{0x6f1c1189,0xfe70004b,0x7ae4118a,0x91a4000d}},	//   ltsc, _ددي_, apit, _घुमै, 
   {{0x6d4400aa,0x6f1c0196,0xbd880014,0x39a4118b}},	//   _irha, otsc, _سنُن_, ушув, 
   {{0xd364118c,0x6f1c118d,0xb8d80c2e,0x752800e2}},	//   _ئه_, ntsc, _घी_, _apdz, 
   {{0x6f1c118e,0xfa080154,0x38980100,0x1670118f}},	//   itsc, র্বল_, včre_, ақур, 
   {{0x6f1c1190,0xc44401ed,0xdddc01ef,0xbba800d1}},	//   htsc, ٹیشن_, _dopň, ﺋﯩﻠﻪ_, 
   {{0x6f1c002f,0x68e4002f,0xa44401d5,0x00000000}},	//   ktsc, mphd, тнид, --, 
   {{0xe718021a,0xa9a400d1,0x6f1c01a4,0x92f4007b}},	//   _زيات_, _чиңд, jtsc, نفيذ_, 
   {{0xe584052f,0x2168016c,0x3e741191,0x6d441192}},	//   _итеү, диои_, _käte_, _orha, 
   {{0x6f1c1193,0xd24c1194,0x6d4401d4,0x7ae41195}},	//   etsc, غچه_, _nrha, zpit, 
   {{0x6f1c1196,0x7f4400d8,0x7ae403f0,0x3e740139}},	//   ftsc, _priq, ypit, _mäte_, 
   {{0x6d441197,0x54780375,0x6728025c,0xdb0400e4}},	//   _arha, _קטנו, _jpej, _tyké, 
   {{0x6d440055,0xa1880354,0x8d8c0023,0x00000000}},	//   _brha, _обла_, _ዘስምዖ_, --, 
   {{0x6f1c1198,0x7ae40309,0x6b8808a5,0x00000000}},	//   atsc, wpit, _þegj, --, 
   {{0x7f441199,0x7bc000d2,0x2c74119a,0x60240022}},	//   _triq, _úmuk, _nådd_, _рдиа, 
   {{0x6d44119b,0x7d1c0fb7,0x6f1c0c8c,0x7ae40841}},	// [cc0] _erha, strs, ctsc, upit, 
   {{0x7ae4119c,0xb5fc0327,0xf9c4009d,0x672c0327}},	//   rpit, _koġe, газү, ħajl, 
   {{0xd8380323,0x67280cad,0x1be8034b,0x6d4400b8}},	//   дэл_, _apej, _одни_, _grha, 
   {{0x7ae4119d,0xa904036b,0xa3c00401,0x05b40210}},	//   ppit, ابلن, ंधा_, ेइनब, 
   {{0x7ae402d1,0xadd8033f,0xca1801ec,0x00000000}},	//   qpit, बुकऔ, _ﺴﻴﺩ_, --, 
   {{0x32f8013f,0x6d440142,0x09e0119e,0x00000000}},	//   _bɛyε_, _yrha, _ворн, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7434084c,0x04600108,0x2bb801f9,0x00000000}},	//   униф, итым, _आरमा, --, 
   {{0xd20801c6,0x660c01d3,0x6f1c119f,0x2bc411a0}},	//   мэнд_, ánké, xtsc, लेपा, 
   {{0x6f1c04cc,0x00000000,0x00000000,0x00000000}},	//   vtsc, --, --, --, 
   {{0x09f4011a,0x00000000,0x00000000,0x00000000}},	//   כמים_, --, --, --, 
   {{0x6f1c11a1,0x2c7401bf,0xc5780375,0x00000000}},	//   ttsc, _kåde_, _קראת, --, 
   {{0x15b4040d,0x7bc000d2,0x6f1c11a2,0x81400214}},	//   ﻤﯩﺰﺩ, _úmuh, utsc, هپیم, 
   {{0x2c74019b,0x6f1c11a3,0x8d7411a4,0x9f5002bd}},	//   _måde_, rtsc, نازا, _meyè_, 
   {{0x6f1c11a5,0x2bc411a6,0x00000000,0x00000000}},	//   stsc, लेना, --, --, 
   {{0x6f1c11a7,0x91f000af,0x6d440306,0x3e7411a8}},	//   ptsc, _आजुओ_, _vrha, _räte_, 
   {{0x201c11a9,0x2c7411aa,0x3e7411ab,0xca1801ec}},	// [cd0] əti_, _rådd_, _säte_, _ﺴﻴﺭ_, 
   {{0x160c0c5a,0x3a7411ac,0x6d4402fb,0x2c7411ad}},	//   _सागर_, алур, _trha, _sådd_, 
   {{0x672811ae,0x2cb80048,0x7ac411af,0x6d4411b0}},	//   _spej, _thsd_, рсте, _urha, 
   {{0x2c7408d7,0x9f50007f,0x3e74007c,0xb95400cf}},	//   _både_, _beyè_, _väte_, جئكت, 
   {{0x160c0574,0x8d7400d1,0xf7700ada,0x362401e1}},	//   _साखर_, _ساھا, ياه_, _ẹ́hì, 
   {{0xa3e404fa,0x9f4004bf,0x9f5002e2,0x3e74002f}},	//   बुन_, jaký_, _deyè_, _täte_, 
   {{0x6ed411b1,0xb5c80472,0x00000000,0x00000000}},	//   _यूसु, نوهم_, --, --, 
   {{0x9f500100,0x6728031c,0x00000000,0x00000000}},	//   _feyè_, _tpej, --, --, 
   {{0x2c74005c,0x86b001ec,0xd5ac01d3,0x00000000}},	//   _gåde_, _кәкі, قہے_, --, 
   {{0x57a401e0,0xe6a40166,0xf77006c2,0x00000000}},	//   _сысҡ, _субү, _باف_, --, 
   {{0x641400c6,0x216811b2,0x250811b3,0x208811b4}},	//   _مواط, хини_, _سرای_, ейни_, 
   {{0xdee411b5,0x2054084c,0xf48411b6,0x00000000}},	//   ломи, утор, _кучн, --, 
   {{0x443c11b7,0x3db00ed1,0x2bc41025,0x730400d4}},	//   mdu_, ﺳﺘﯩﻘ, लेमा, _впіз, 
   {{0x443c11b8,0x91e00114,0x00000000,0x00000000}},	//   ldu_, _лоше, --, --, 
   {{0x443c11b9,0xff1411ba,0x661403e0,0x69c001ef}},	//   odu_, িবেশ_, _özku, _úleh, 
   {{0x443c11bb,0x41dc11bc,0x2bc40073,0x672c0003}},	//   ndu_, पुरस, लेभा, ħajj, 
   {{0xc0dc0020,0x443c11bd,0x8c4000a7,0x6d4007b9}},	// [ce0] ኒየም_, idu_, щете, ålar, 
   {{0xda6411be,0x443c11bf,0x2c7411c0,0x00000000}},	//   داري, hdu_, _råde_, --, 
   {{0x9f5011c1,0xf8a811c2,0x443c0115,0x2bc407af}},	//   _seyè_, نگره_, kdu_, लेबा, 
   {{0x386011c3,0x443c11c4,0xa6d400cc,0x779411c5}},	//   ðir_, jdu_, _সৌধট, لیزا, 
   {{0x9f500098,0x4bf805d0,0x2af40006,0x87000108}},	//   _beyé_, _אלכס, _вясё, бяще, 
   {{0x443c11c6,0x0f34025f,0xda7011c7,0x9f4001b8}},	//   edu_, טרנט_, _اُس_, dakü_, 
   {{0x7c24009a,0xca7402dd,0x48e0010a,0x00000000}},	//   ofir, _сәті_, _госв, --, 
   {{0x7c2411c8,0x443c11c9,0x98a411ca,0xb8b402dd}},	//   nfir, gdu_, _сибе, _төзі, 
   {{0xb27411cb,0x7c2404ba,0x55e411cc,0x5748008e}},	//   илиш, ifir, _бозб, _язам_, 
   {{0x443c11cd,0x7c2411ce,0x427011cf,0xc5b4009d}},	//   adu_, hfir, йгыс, _өрхө, 
   {{0x7c2411d0,0x443c11d1,0x256401d9,0x13e811d2}},	//   kfir, bdu_, _پالُ, _змей_, 
   {{0x94180134,0x443c11d3,0x00000000,0x00000000}},	//   _ɔpɛ_, cdu_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c2411d4,0x6b8808a5,0x938801af,0x00000000}},	//   efir, _þegi, _осһа_, --, 
   {{0x7c2411d5,0x00000000,0x00000000,0x00000000}},	//   ffir, --, --, --, 
   {{0xaed406ed,0x00000000,0x00000000,0x00000000}},	//   _коиш, --, --, --, 
   {{0x6e9400d6,0xeeb801d5,0x629c00e4,0x645c01f4}},	// [cf0] _випу, _илиш_, ésog, ösii, 
   {{0x443c11d6,0x28d811d7,0x7c2411d4,0xce3000f1}},	//   zdu_, _बंदि, afir, _اودک, 
   {{0xa93400a8,0xa3e401ad,0x693401ec,0x5ed80154}},	//   рееш, बुड_, рнеу, বীদে, 
   {{0x443c11d8,0x7c240175,0x00000000,0x00000000}},	//   xdu_, cfir, --, --, 
   {{0x443c11d9,0xe73811da,0xa63402dd,0x4a080064}},	//   vdu_, тел_, инді, _пэвм_, 
   {{0xa50811db,0xe64411dc,0xf9d4010b,0xdb4c0014}},	//   века_, рекп, _горэ, _کێے_, 
   {{0x37a80cef,0x3e7400af,0x443c11dd,0x64980351}},	//   ктән_, _jäta_, tdu_, ктир_, 
   {{0x443c11de,0x3e7411df,0x7cdc0010,0x23280107}},	//   udu_, _mäta_, _očrn, воии_, 
   {{0xe298016c,0xe3b800a7,0xe1f00214,0xe520000d}},	//   каи_, ъби_, يسد_, _महकि_, 
   {{0xc6a411e0,0x443c016d,0xf5980209,0x09e0009e}},	//   _срби, sdu_, ýýär_, মণকা, 
   {{0x443c016d,0x7c240008,0x09d011e1,0x00000000}},	//   pdu_, yfir, _तलैय, --, 
   {{0x942409b3,0x443c11e2,0x44f00276,0xa0a411e3}},	//   _نومۇ, qdu_, mţ_, рамд, 
   {{0xa3c00073,0x44f00356,0xffa4009d,0x42e40024}},	//   ंधळ_, lţ_, ёлгү, _сцеб, 
   {{0x9f4000d2,0x6144074d,0x1d0811e4,0x38bc00c7}},	//   wakó_, _века, кеги_, míre_, 
   {{0x44f0084c,0x8d6011e5,0xd24c11e6,0x4d60041b}},	//   nţ_, овре, _زني_, окрв, 
   {{0x5f7403e6,0x2be0041c,0xdf48009d,0x00000000}},	//   _ناخر, गुलं_, _азид_, --, 
   {{0x5f7403e6,0x0b4011e7,0x38bc11e8,0x657c03b9}},	// [d00] _ڕاگر, онтн, níre_, _əsha, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd00c11e9,0x7c24015c,0x9f5c0724,0x38bc0332}},	//   _علی_, pfir, ştä_, híre_, 
   {{0x7c240009,0x59740022,0x18a40108,0x00000000}},	//   qfir, лыҵу, шаем, --, 
   {{0x27e811ea,0x3e74007c,0x68e80064,0x2bc401f9}},	//   ñana_, _zäta_, _čede, लेदा, 
   {{0xd944074d,0x7ea001f4,0x00000000,0x00000000}},	//   _кеги, töpy, --, --, 
   {{0x74a8010b,0x00000000,0x00000000,0x00000000}},	//   лсиң_, --, --, --, 
   {{0xe97001ec,0x4938011a,0x00000000,0x00000000}},	//   _عۇند, _בגלו, --, --, 
   {{0x9f4002e2,0x3b0001a9,0x04c4104c,0xe72800f1}},	//   zakò_, nsiq_, جويي_, _مسلو_, 
   {{0x6b880432,0x96b811eb,0x00000000,0x00000000}},	//   _ýege, _рубу_, --, --, 
   {{0x705411ec,0x38640109,0x2c7401e6,0xc22000f2}},	//   مندا, _komr_, _låda_, تکنو, 
   {{0x224803f9,0x3e7401e3,0x00000000,0x00000000}},	//   _ɗaki_, _räta_, --, --, 
   {{0x838011ed,0xc37001d9,0x69c00118,0x91a4000d}},	//   _мыше, _وُمب, _úlev, _घुरै, 
   {{0x3e7400d7,0x25a80205,0x00000000,0x00000000}},	//   _päta_, şale_, --, --, 
   {{0xbd680262,0x6b8801e4,0x6fa80073,0x7e68007c}},	//   арте_, _ɾegu, _घडवू, ödpa, 
   {{0x2c7404f3,0x80a4004b,0x3e74007c,0xbbe80014}},	//   _båda_, _ومون, _väta_, ٔرٕم_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [d10] --, --, --, --, 
   {{0x3e740267,0x00000000,0x00000000,0x00000000}},	//   _täta_, --, --, --, 
   {{0xac9811ee,0x00000000,0x00000000,0x00000000}},	//   _مندا_, --, --, --, 
   {{0x1ee80214,0x2fcc01a6,0xec34010f,0x00000000}},	//   _جویی_, žegu_, _פאָר_, --, 
   {{0x321c00e4,0x00000000,0x00000000,0x00000000}},	//   _ocvy_, --, --, --, 
   {{0x2ca80475,0xf77011ef,0xca700244,0x490c0210}},	//   load_, بام_, _بچرک, _डिपो_, 
   {{0x6d4003f2,0x00000000,0x00000000,0x00000000}},	//   ælah, --, --, --, 
   {{0x290011f0,0x4ad811f1,0x38bc0f33,0x8704005b}},	//   msha_, _बढाव, tíre_, _вяже, 
   {{0x290011f2,0x4e14012c,0x87e4014b,0x00000000}},	//   lsha_, तलाई_, _бюҷе, --, 
   {{0x38bc11f3,0x2900022b,0x659411f4,0x6e340841}},	//   ríre_, osha_, _лазу, jezb, 
   {{0x290011f5,0xa06811f6,0xa18811f7,0xd1c4009d}},	//   nsha_, гана_, убна_, йлье_, 
   {{0x290011f8,0x3b000113,0x27fc015d,0xca180150}},	//   isha_, ysiq_, nawn_, _ﺴﻴﺴ_, 
   {{0x248c11f9,0xa0a40131,0x290011fa,0x6fa4012d}},	//   miem_, _қаид, hsha_, _गुआं, 
   {{0x290011fb,0x248c00da,0x3d3802b5,0x27fc0368}},	//   ksha_, liem_, _pōw_, hawn_, 
   {{0xf1a811fc,0x29000240,0xb3240327,0xdcb006ba}},	//   _پاوه_, jsha_, _འདོང_, كىس_, 
   {{0x248c11fd,0x290003a2,0x2ca805c7,0x23840023}},	//   niem_, dsha_, goad_, _ክስዕብ_, 
   {{0x27fc0369,0x6e34009b,0x290011fe,0xdca40b01}},	// [d20] dawn_, bezb, esha_, _ҳани, 
   {{0x290011ff,0x248c1200,0x3b000477,0x00000000}},	//   fsha_, hiem_, rsiq_, --, 
   {{0x248c1201,0x68f40369,0x27fc0204,0x61e0011f}},	//   kiem_, _cwzd, fawn_, icll, 
   {{0x248c11f9,0x69d41202,0x17f80597,0xbc7400cf}},	//   jiem_, _egze, اراة_, _بۇرب, 
   {{0x248c0029,0x50181203,0x29000014,0xb324031c}},	//   diem_, רונו, asha_, _འདེང_, 
   {{0x29001204,0x47300006,0x00000000,0x00000000}},	//   bsha_, яніс, --, --, 
   {{0x490c00e1,0x248c00de,0x00000000,0x00000000}},	//   _डियो_, fiem_, --, --, 
   {{0x248c1205,0x73d8036b,0x06e400fb,0xa81800cf}},	//   giem_, шдир_, шмәк_, _ەتەر_, 
   {{0x6e340007,0x00000000,0x00000000,0x00000000}},	//   yezb, --, --, --, 
   {{0x85741206,0x248c002d,0x47dc00eb,0x00000000}},	//   рсәт_, aiem_, মরণী, --, 
   {{0x248c1207,0x9598084c,0x69c01155,0xc0e41208}},	//   biem_, _стау_, _úlet, یفین_, 
   {{0x248c1209,0x00000000,0x00000000,0x00000000}},	//   ciem_, --, --, --, 
   {{0x934400a8,0x6e34009d,0x2fcc0036,0x00000000}},	//   _ынде, tezb, äeg_, --, 
   {{0x2900120a,0x00000000,0x00000000,0x00000000}},	//   ysha_, --, --, --, 
   {{0x90e4120b,0xb5fc0327,0x2ca8120c,0x7ae8007f}},	//   _استن, _loġo, toad_, _čdta, 
   {{0x81dc015b,0x6b7400d4,0x00000000,0x00000000}},	//   তরণ_, олбу, --, --, 
   {{0x2900120d,0xfbd0007b,0x00000000,0x00000000}},	// [d30] wsha_, فتك_, --, --, 
   {{0x248c120e,0x00000000,0x00000000,0x00000000}},	//   ziem_, --, --, --, 
   {{0x27e8120f,0xdb0402fb,0x39580327,0x29001210}},	//   ñano_, _vyká, _ġesù_, usha_, 
   {{0x29001211,0x248c004e,0xda1c000d,0x00000000}},	//   rsha_, xiem_, _पाथत_, --, 
   {{0x248c1212,0x27fc1213,0x2900031c,0x2bc400cd}},	//   viem_, rawn_, ssha_, लेशा, 
   {{0xf1c8060c,0x248c0034,0x9ba00131,0x2900036e}},	//   रधान, wiem_, _غەلى, psha_, 
   {{0x248c0029,0xe4c41214,0x29000327,0x2bc406e3}},	//   tiem_, ойки, qsha_, लेरा, 
   {{0x7b08008c,0x2ee801b8,0x00000000,0x00000000}},	//   _ástæ, _otaf_, --, --, 
   {{0x248c1215,0xf7701216,0x00000000,0x00000000}},	//   riem_, _كاك_, --, --, 
   {{0x248c0029,0x38bc02fb,0x3e7404cc,0xbb3c008f}},	//   siem_, míra_, _räto_, רעזי, 
   {{0x645c0730,0x248c00e2,0x2ee81217,0x7de001e1}},	//   ösis, piem_, _ataf_, _làsó, 
   {{0x9fc81218,0xb1840030,0x356800d1,0x248c020c}},	//   игна_, íťaz, _урун_, qiem_, 
   {{0x1ea801e2,0x00000000,0x00000000,0x00000000}},	//   لاسي_, --, --, --, 
   {{0x82200003,0xa3e400c5,0xc0740092,0x00000000}},	//   _འཁྲི_, बुर_, _ሊገመግ, --, 
   {{0xa3c003f3,0xc4d40154,0x9cc81219,0x00000000}},	//   ंधक_, _সবুজ, ғыңа_, --, 
   {{0x33b00131,0x1be8013e,0xda700050,0x00000000}},	//   _تەۋر, рдаи_, ڈُر_, --, 
   {{0x68e809a8,0x5ea4121a,0x81dc0183,0xda70009f}},	// [d40] _čeda, _ومبل, তৰণ_, وُر_, 
   {{0x38bc013d,0x00000000,0x00000000,0x00000000}},	//   díra_, --, --, --, 
   {{0x6ee4121b,0x2124014f,0xd7f80958,0xdca4014b}},	//   _وسیل, ntlh_, аул_, _маои, 
   {{0x5748121c,0x38bc02d2,0x00000000,0x00000000}},	//   изем_, fíra_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x81dc0c58,0xad240345,0x00000000,0x00000000}},	//   তৰত_, _بریو, --, --, 
   {{0x81dc0154,0x92e40154,0x00000000,0x00000000}},	//   তরা_, _বটে_, --, --, 
   {{0xa3e4121d,0x00000000,0x00000000,0x00000000}},	//   बुल_, --, --, --, 
   {{0x0a4c02d3,0x00e00150,0x676401ee,0x00000000}},	//   _መማህራ, _ﺍﻟﺨﺘ, _ентҡ, --, 
   {{0x8628121e,0x672c031c,0x00000000,0x00000000}},	//   _نغمہ_, ħajt, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb324025c,0x00000000,0x00000000,0x00000000}},	//   _འདིང_, --, --, --, 
   {{0xb63c00b5,0xdb740092,0x00000000,0x00000000}},	//   _ｇｐ_, _የመያዝ_, --, --, 
   {{0xdb04005b,0x8c6401a9,0x00000000,0x00000000}},	//   _lykä, отад, --, --, 
   {{0xe57000c8,0x2b480301,0x00000000,0x00000000}},	//   ײַל_, tvac_, --, --, 
   {{0xdddc033f,0xdb04121f,0x4fc40a89,0x2ee802d2}},	// [d50] _dopł, _nykä, _ьска, _utaf_, 
   {{0x8a140035,0x63bc0162,0x37c000eb,0x00000000}},	//   تظرا, ýsni, ইশার, --, 
   {{0x09041220,0x4c80036b,0x00000000,0x00000000}},	//   ючам, _قیسق, --, --, 
   {{0xe9e40589,0x00000000,0x00000000,0x00000000}},	//   ãºba_, --, --, --, 
   {{0x81dc0183,0xd6e400fe,0x24e402dd,0x15c001ec}},	//   তৰি_, _নিউয, _ﺍﻨﺘﻬ, _ﺯﺍﺭﺩ, 
   {{0xe7fc01f9,0x00000000,0x00000000,0x00000000}},	//   _उजवा_, --, --, --, 
   {{0x9fa000e8,0x00000000,0x00000000,0x00000000}},	//   tëër_, --, --, --, 
   {{0x92e40154,0x00000000,0x00000000,0x00000000}},	//   _বয়ে_, --, --, --, 
   {{0x383400d3,0x672c0135,0x00000000,0x00000000}},	//   _інфр, ħajs, --, --, 
   {{0xaabc1221,0x7d0802f0,0x00000000,0x00000000}},	//   ्गिक, ádsk, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x55b80375,0x00000000,0x00000000,0x00000000}},	//   _המעו, --, --, --, 
   {{0x442c1222,0xaabc1223,0x64880113,0x1ec80166}},	//   _ibg_, ्गाक, 鯵ill, йлми_, 
   {{0x68e81224,0x442c007c,0xdcfc00d7,0xa6dc00cc}},	//   _čedn, _hbg_, _vypľ, _ডবাট, 
   {{0xdddc012d,0x9f400c5e,0x5fac0073,0x40e40345}},	//   _popł, ické_, _घडवल, _بوبێ_, 
   {{0x442c1225,0xda1c0490,0x98a4031c,0x00000000}},	//   _jbg_, _पाहत_, ċoċ_, --, 
   {{0x20001226,0x442c0221,0x3e74000d,0x6e4803b2}},	// [d60] maki_, _mbg_, _jätk_, ðsbý, 
   {{0x20001227,0xdb041228,0xa6e801fb,0x442c0175}},	//   laki_, _szkó, _khươ, _lbg_, 
   {{0xceb01229,0x20000270,0x442c0798,0x4dd80375}},	//   _איז_, oaki_, _obg_, _לחיו, 
   {{0x2000122a,0xdca40364,0xda1c00af,0x442c122b}},	//   naki_, _хами, _पावत_, _nbg_, 
   {{0x200003a0,0x60d4047e,0x9f4000e4,0xe7fc000d}},	//   iaki_, _miym, pakõ_, _उजरा_, 
   {{0x2000122c,0x442c122d,0x00000000,0x00000000}},	//   haki_, _abg_, --, --, 
   {{0x2000122e,0x442c122f,0xa6e80208,0x00000000}},	//   kaki_, _bbg_, _nhươ, --, 
   {{0x20001230,0xdb04023a,0x28f80262,0xf48410e8}},	//   jaki_, _tykä, _фэрэ_, باتی, 
   {{0x20001231,0x06e0009e,0x442c1232,0x00000000}},	//   daki_, নীবি, _dbg_, --, 
   {{0x20000093,0x877802e4,0x442c1233,0xd2581234}},	//   eaki_, _האמי, _ebg_, сци_, 
   {{0x2bb80b26,0xa6e807ae,0x20001235,0x00000000}},	//   _आर्थ, _chươ, faki_, --, 
   {{0x442c1236,0x20001237,0x9f5000a2,0xa3e40210}},	//   _gbg_, gaki_, _adyñ_, बुआ_, 
   {{0xefc80020,0x60d400ee,0x00000000,0x00000000}},	//   _በዚያ_, _diym, --, --, 
   {{0x3eb80076,0xdb040241,0x8bc40124,0x00000000}},	//   glrt_, _òmùg, ҧсад, --, 
   {{0x20001238,0x68e8009b,0x61ec03e0,0x00000000}},	//   baki_, _čedo, _şalg, --, 
   {{0x60d405d1,0x20001239,0x00000000,0x00000000}},	//   _giym, caki_, --, --, 
   {{0xfc1401c6,0x00000000,0x00000000,0x00000000}},	// [d70] эмтэ, --, --, --, 
   {{0x6d40123a,0x5f100b67,0x3f7c123b,0x00000000}},	//   ælas, _तित्_, _לאחס, --, 
   {{0x20e4123c,0xba740131,0x6d40123d,0xda1c00c5}},	//   _kēia_, راكت, çlad, _पारत_, 
   {{0x6b880432,0x00000000,0x00000000,0x00000000}},	//   _ýego, --, --, --, 
   {{0xcb4405f5,0x442c0165,0x00000000,0x00000000}},	//   _эхни, _rbg_, --, --, 
   {{0x2000123e,0x442c123f,0xf218012d,0x00000000}},	//   zaki_, _sbg_, _दाग़_, --, 
   {{0x20001240,0x0a50001f,0x64a41241,0xb93400ea}},	//   yaki_, _ለማሳካ, мака, _перј, 
   {{0x200000aa,0xc86401a9,0x00000000,0x00000000}},	//   xaki_, _этги, --, --, 
   {{0x200003b4,0x9730004b,0x60d4014f,0xdee40092}},	//   vaki_, _ټکنا, _riym, ማዊና_, 
   {{0xa6e807ae,0x20001242,0x7cdc02b1,0x60d401d5}},	//   _phươ, waki_, _hōre, _siym, 
   {{0x7cdc1243,0x20001244,0xa0a41245,0x26c41246}},	//   _kōre, taki_, данд, _ihlo_, 
   {{0x60d41247,0x44e01248,0x2054016c,0x20000418}},	//   _qiym, _iñ_, фтор, uaki_, 
   {{0x20001249,0x64480cfd,0x7cdc04fe,0x00000000}},	//   raki_, mdei, _mōre, --, 
   {{0x2000124a,0xa6e801dc,0x44e00986,0xe2c8036b}},	//   saki_, _thươ, _kñ_, _بوتو_, 
   {{0x2000124b,0x6280124c,0x26c40418,0xed34124d}},	//   paki_, mhlo, _mhlo_, нэтэ, 
   {{0x2000124e,0x3994007d,0x6280124f,0x3e741250}},	//   qaki_, _तs_, lhlo, _mäti_, 
   {{0x6d40022c,0x3e7400af,0x64481251,0x00000000}},	// [d80] ælar, _läti_, idei, --, 
   {{0x62801252,0x7f441253,0x26c40117,0x44e00428}},	//   nhlo, _isiq, _nhlo_, _oñ_, 
   {{0x64581254,0x3e740139,0x23c800bc,0xdc68014b}},	//   _onwi, _näti_, ाइँद, _данд_, 
   {{0x7d1c1255,0x6458013f,0xccf002e4,0x644801bf}},	//   murs, _nnwi, _שכר_, jdei, 
   {{0x44e01256,0xc6f4063b,0x64481257,0x7d1c1258}},	//   _añ_, дніх_, ddei, lurs, 
   {{0x64581259,0x26c404c4,0x6448125a,0x7d1c0175}},	//   _anwi, _chlo_, edei, ours, 
   {{0x7d1c125b,0x7ae4125c,0x644801a8,0x948400ee}},	//   nurs, lqit, fdei, дыпд, 
   {{0x3ae4125d,0x7f440b6f,0x3e7401b8,0x73c4125e}},	//   _köp_, _osiq, _däti_, нәле, 
   {{0x44e00dd4,0x7ae4125f,0xb5fc0135,0x73340873}},	//   _eñ_, nqit, _loġi, رىدا, 
   {{0x64581260,0x64481261,0x07a01262,0x62801263}},	//   _enwi, adei, _раун, ghlo, 
   {{0x7f441264,0x20e40069,0x7d1c1265,0x7ae40023}},	//   _asiq, _pēia_, jurs, hqit, 
   {{0x7d1c1266,0x62801267,0x76481268,0xc56000ec}},	//   durs, ahlo, _hady, _جڏهي, 
   {{0x27e81269,0x7648126a,0x6280126b,0x2eec002e}},	//   ñani_, _kady, bhlo, ëef_, 
   {{0x6280126c,0x7ae40429,0x7d1c126d,0x7648010b}},	//   chlo, dqit, furs, _jady, 
   {{0x7648126e,0x7f440928,0xa3e40034,0x6458000f}},	//   _mady, _esiq, बुक_, _ynwi, 
   {{0x7648126f,0x290c0115,0x3c580276,0x7ae40327}},	//   _lady, _ĉea_, мисэ_, fqit, 
   {{0x7ae400aa,0x7cdc02b5,0x10e40046,0x8d740092}},	// [d90] gqit, _rōre, _ﺍﻟﺠﻨ, ከላቸው_, 
   {{0x76481270,0x7a381271,0x3ae4007c,0x2bc40401}},	//   _nady, мпур_, _döp_, लेगा, 
   {{0x80a41272,0x6f1c0005,0x64480368,0x7cdc0374}},	//   _سمین, lusc, ydei, _pōre, 
   {{0x6d441273,0x764802d0,0x64480369,0x7f4402d0}},	//   _isha, _aady, xdei, _ysiq, 
   {{0x6f1c1274,0x76481275,0x6d4401d5,0x2bc41276}},	//   nusc, _bady, _hsha, लेखा, 
   {{0x6d440649,0x64480007,0x7648058a,0xec140150}},	//   _ksha, wdei, _cady, _توڭد, 
   {{0x76481277,0x64481278,0x7cdc0374,0x6f1c1279}},	//   _dady, tdei, _tōre, husc, 
   {{0x6d44127a,0x7648127b,0x4dd800fe,0x00000000}},	//   _msha, _eady, _বজোৱ, --, 
   {{0x6448127c,0x6f1c127d,0x7d1c127e,0xe298127f}},	//   rdei, jusc, zurs, зап_, 
   {{0x27281280,0x76481281,0x6d441282,0xe1f00597}},	//   mún_, _gady, _osha, دسة_, 
   {{0x6d441283,0x272800c6,0x9f5c03ee,0x628001b9}},	//   _nsha, lún_, ştü_, rhlo, 
   {{0x6280006c,0x76480209,0x66001284,0x6e241285}},	//   shlo, _zady, _helk, _achb, 
   {{0x66001286,0x6d441287,0x76481288,0x6f1c04cc}},	//   _kelk, _asha, _yady, gusc, 
   {{0x66001289,0x21a4013d,0x9d440114,0xda1c000d}},	//   _jelk, _пилм, негд, _पाइत_, 
   {{0x6600128a,0x7b840131,0x999802b5,0x6d44128b}},	//   _melk, ھارە, repū_, _csha, 
   {{0x6f1c128c,0x8c40128d,0x7f440a2e,0x660000dd}},	//   busc, лесе, _tsiq, _lelk, 
   {{0x6d44128e,0x7f440944,0x6f1c128f,0x1fb40845}},	// [da0] _esha, _usiq, cusc, _яскр, 
   {{0x6d44044e,0x7ae41290,0xabc400fb,0x66001291}},	//   _fsha, rqit, тауҙ, _nelk, 
   {{0x76481292,0xdb04005c,0x98d800f2,0x7d1c022e}},	//   _rady, _lykø, سباز_, qurs, 
   {{0xd704055f,0x76481293,0x3ae40598,0xa2c001ad}},	//   езди, _sady, _töp_, _रीस्, 
   {{0x27281294,0x66001295,0x76481296,0x7ae40eda}},	//   gún_, _belk, _pady, qqit, 
   {{0x66000745,0x2c740194,0x7648058a,0xe7680118}},	//   _celk, _rådi_, _qady, nářů, 
   {{0x76481297,0x6d4407d6,0x6f1c1298,0xceb00a1e}},	//   _vady, _xsha, zusc, איג_, 
   {{0x66001299,0x64a00421,0x7648129a,0x6f1c0789}},	//   _eelk, sēin, _wady, yusc, 
   {{0xc7a003a6,0x6600129b,0x76480882,0xfe2005f9}},	//   _битк, _felk, _tady, _बांस_, 
   {{0x73c40032,0x60c80134,0x7178129c,0x6f1c07c5}},	//   нәһе, ɛmmɔ, дбор_, vusc, 
   {{0x2b9001f1,0x85f405d0,0x7334129d,0x00000000}},	//   môcť_, _נמאס_, رىگا, --, 
   {{0x6d4401a9,0x8230129e,0x00000000,0x00000000}},	//   _rsha, پریا, --, --, 
   {{0x6600129f,0x6f1c0036,0x93240214,0x00000000}},	//   _yelk, uusc, _سرشن, --, 
   {{0x6f1c12a0,0x6d440076,0xdddc0118,0x00000000}},	//   rusc, _psha, _kopř, --, 
   {{0x8d7412a1,0xac9412a2,0xdcec00de,0x00000000}},	//   راسا, вавш, dzbē, --, 
   {{0x6f1c12a3,0x6d4401f5,0xc1b8011a,0x00000000}},	//   pusc, _vsha, _ממוש, --, 
   {{0x00d812a4,0xfaf012a5,0x92dc015b,0x27280005}},	// [db0] _ثبوت_, مثل_, _তবু_, xún_, 
   {{0x6d4412a6,0xdb2412a7,0x6abc01ad,0x6f0c12a8}},	//   _tsha, ئولی, ्गेर, _ivac, 
   {{0x2bc40073,0x7d080332,0x8fd000fb,0x00000000}},	//   लेजा, ádst, _шәүә, --, 
   {{0x6600049b,0x6f0c0882,0x272812a9,0xa97001e1}},	//   _selk, _kvac, tún_, _ìdíè_, 
   {{0x6600049b,0x36e80075,0x00000000,0x00000000}},	//   _pelk, ۈرۈپ_, --, --, 
   {{0x272812aa,0x7cdc0374,0x693412ab,0xd6c401d5}},	//   rún_, _hōra, _ингу, نمنی, 
   {{0x660012ac,0x7cdc04fe,0x272812ad,0xb5fc00e4}},	//   _velk, _kōra, sún_, _noġu, 
   {{0x660012ae,0x3e74092e,0x6f0c08a4,0xdddc00bc}},	//   _welk, _hätt_, _ovac, _dopř, 
   {{0x7cdc02b1,0x130012af,0xd84000bc,0x3e7400c5}},	//   _mōra, азым, áčů_, _kätt_, 
   {{0x60e80454,0xfe2009ab,0x00000000,0x00000000}},	//   ммом_, _बाइस_, --, --, 
   {{0x6f0c12b0,0xfdac0729,0x21a412b1,0x3e7401e6}},	//   _avac, _খণ্ড, тинм, _mätt_, 
   {{0xdee412b2,0x3e7404f3,0x6f0c04ce,0xd24c0014}},	//   коми, _lätt_, _bvac, ٕنی_, 
   {{0x10e401ec,0xcf4001f4,0x00000000,0x00000000}},	//   _ﺍﻟﺼﻨ, аняй, --, --, 
   {{0x443c12b3,0x91e012b4,0x6f0c012c,0x02a40212}},	//   leu_, _коше, _dvac, _ярем, 
   {{0x6f0c12b5,0x27ec12b6,0xdcb012b7,0x00000000}},	//   _evac, _ofen_, لىس_, --, 
   {{0x443c12b8,0x7cdc01ab,0x00000000,0x00000000}},	//   neu_, _cōra, --, --, 
   {{0x8c4012b9,0x00000000,0x00000000,0x00000000}},	// [dc0] шете, --, --, --, 
   {{0x27ec12ba,0x3e7412bb,0x00000000,0x00000000}},	//   _afen_, _pätu_, --, --, 
   {{0x443c12bc,0x6f0c05b8,0xdca400c7,0x984802e8}},	//   keu_, _zvac, _аани, дяла_, 
   {{0xd6e0012d,0xda1c000d,0x00000000,0x00000000}},	//   ykłą_, _पाकत_, --, --, 
   {{0x443c12bd,0x38bc00c7,0x481001ca,0x00000000}},	//   deu_, níri_, рміс, --, 
   {{0x7c2412be,0x27ec12bf,0xdddc00bc,0x15d40014}},	//   lgir, _efen_, _popř, نگاں_, 
   {{0x92dc03f4,0x443c12c0,0x27ec0295,0x349412c1}},	//   _তবে_, feu_, _ffen_, лакр, 
   {{0x443c12c2,0x38c812c3,0x99980118,0x00000000}},	//   geu_, _سازی_, lepů_, --, 
   {{0x938812c4,0x7c2412c5,0xb9d00092,0x61ec010b}},	//   ьска_, igir, _ሴራ_, _şala, 
   {{0x6f0c0301,0x7c2412c6,0x3e7401e3,0x38bc00e4}},	//   _rvac, hgir, _mäts_, díri_, 
   {{0x443c12c7,0x1424035b,0x6f0c12c8,0x00000000}},	//   beu_, _адем, _svac, --, 
   {{0x443c12c9,0x61f412ca,0x638000c7,0x7c2400a2}},	//   ceu_, ızla, рҳәа, jgir, 
   {{0x38bc00e4,0xff040166,0x00000000,0x00000000}},	//   gíri_, иярн, --, --, 
   {{0x7c2412cb,0x7cdc0374,0xb5fc00e4,0x00000000}},	//   egir, _rōra, _toġu, --, 
   {{0x3e740628,0x31340137,0x826800e5,0x00000000}},	//   _rätt_, _сейр, _تشنہ_, --, 
   {{0x3e740628,0x6abc12cc,0x7cdc0374,0x8eb00137}},	//   _sätt_, ्ग्र, _pōra, _چەحت, 
   {{0x4ea412cd,0x3e7412ce,0x6f0c00b8,0xfbd0007b}},	// [dd0] _арна, _pätt_, _uvac, قتك_, 
   {{0x443c12cf,0x3b540733,0x7c2412d0,0x637801e1}},	//   zeu_, шкур, agir, _hùnú, 
   {{0x443c12d1,0xc0bc0023,0x9f4801f4,0xe6880022}},	//   yeu_, _ሰጊሩ_, äkös_, ҕәак_, 
   {{0x443c0137,0x7cdc04fe,0xc1980375,0x3ba00092}},	//   xeu_, _tōra, ושבי, ቂያዎች_, 
   {{0x443c12d2,0x3e7401e6,0x3b6400a7,0xd36412d3}},	//   veu_, _tätt_, _кърв, _اه_, 
   {{0xe5a412d4,0x443c12d5,0x2cb80165,0xd1b8001f}},	//   лили, weu_, _hksd_, _ታላቁ_, 
   {{0x443c12d6,0x2cb80165,0x00000000,0x00000000}},	//   teu_, _kksd_, --, --, 
   {{0x443c0069,0x27ec0295,0xdddc033b,0x67d412d7}},	//   ueu_, _ufen_, _enpň, _бобу, 
   {{0x443c12d8,0x2cb8020b,0xe3b80150,0x00000000}},	//   reu_, _mksd_, эби_, --, 
   {{0x443c12d9,0x7c2412da,0x03a01086,0x53c412db}},	//   seu_, zgir, лиқо, ыгым_, 
   {{0x443c12dc,0x00000000,0x00000000,0x00000000}},	//   peu_, --, --, --, 
   {{0xa35412dd,0x7c240072,0xa06812de,0x38bc0022}},	//   _مختص, xgir, хама_, tíri_, 
   {{0x6d4012df,0xbe840116,0x00000000,0x00000000}},	//   çlan, иқии, --, --, 
   {{0x10a00046,0x53980bd9,0x3cec00d2,0xdb0400a2}},	//   _қиын, _אינו, ídvo_, _cyký, 
   {{0x7c2412e0,0x5bbc0882,0x00000000,0x00000000}},	//   tgir, ्ध्व, --, --, 
   {{0xb5fc0135,0x3e74000d,0x7c240356,0x38bc00c7}},	//   _inġe, _päts_, ugir, píri_, 
   {{0x5f4412e1,0x5ac812e2,0x3d1800e1,0x5ba80c60}},	// [de0] _صندل, елам_, बूजे_, хкам_, 
   {{0xd1b80020,0xddb412e3,0x00000000,0x00000000}},	//   _ታላቅ_, _محجب, --, --, 
   {{0x7c2412e4,0x88bc00eb,0x00000000,0x00000000}},	//   pgir, েদনক, --, --, 
   {{0xd70812e5,0xc0bc02d3,0xd8b800db,0x178400db}},	//   енде_, _ሰፊሩ_, رداا_, лгем, 
   {{0x7cdc00b0,0x47300722,0x7d1c0194,0x2c7400b5}},	//   _hōro, مروز, lrrs, _vådt_, 
   {{0x09e012e6,0x7cdc0374,0xc7a012e7,0xa6140022}},	//   _горн, _kōro, щичк, азшә, 
   {{0x98a4010b,0x74a8010b,0x04c400f2,0x00000000}},	//   _биве, ксиң_, گويي_, --, 
   {{0x7cdc02b5,0x673012e8,0x00000000,0x00000000}},	//   _mōro, økjæ, --, --, 
   {{0xe9d000aa,0xb5fc0327,0x88b012e9,0x04c412ea}},	//   _هغې_, _anġe, _اینچ, دويي_, 
   {{0xd9f412eb,0x00000000,0x00000000,0x00000000}},	//   ेरित_, --, --, --, 
   {{0x27e80fb7,0x3cf801f1,0x00000000,0x00000000}},	//   žane_, jprv_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb040306,0xcf24009f,0x00000000,0x00000000}},	//   _mykó, درجي, --, --, 
   {{0x0cbc12ec,0xc7b00bd4,0x00000000,0x00000000}},	//   ्ष्म, מבר_, --, --, 
   {{0xc278008f,0x2028005b,0x00000000,0x00000000}},	//   _ארגי, ätiö_, --, --, 
   {{0x2c7412ed,0x629c00d7,0x00000000,0x00000000}},	//   _råds_, ésov, --, --, 
   {{0x3a3812ee,0x39580010,0x7d1c12ef,0xebc40166}},	// [df0] _bbrp_, _arrs_, arrs, рәнн, 
   {{0x2fc80165,0x09e00154,0x00000000,0x00000000}},	//   _izag_, যর্থ, --, --, 
   {{0x7ac412f0,0xac18004e,0x00000000,0x00000000}},	//   ссте, _иону_, --, --, 
   {{0xa564034c,0x6f1c0d27,0xa8340640,0x8ca000db}},	//   یگان, orsc, редљ, _اەرو, 
   {{0x660412f1,0x39580254,0x6e480023,0x00000000}},	//   апла, _errs_, _ብምንጽ, --, 
   {{0x955c001f,0xcfc400cc,0x6f1c12f2,0xe5080b24}},	//   ተሰቡን_, _এলান, irsc, نيتو_, 
   {{0x6f1c101d,0x6b8c020c,0x61ec0166,0x00000000}},	//   hrsc, lzag, _şalo, --, 
   {{0x2334013e,0x38bc02f0,0x00000000,0x00000000}},	//   ахор, fíru_, --, --, 
   {{0xe3b012f3,0x6b8c12f4,0x27fc0399,0x130412f5}},	//   غرب_, nzag, mbwn_, аный_, 
   {{0x659412f6,0x6f1c110c,0x6b8c01c4,0x24f800db}},	//   _казу, drsc, izag, _анжы_, 
   {{0x348401c6,0x6b8c022e,0xd24c0133,0x00000000}},	//   ргөг, hzag, بچن_, --, 
   {{0x7cdc02b5,0x622400d1,0x00000000,0x00000000}},	//   _rōro, _چىشل, --, --, 
   {{0xdee412f7,0x22480276,0x63040131,0xaac412f8}},	//   роги, _апли_, _ئوتل, वताक, 
   {{0x6b8c0bd7,0x7cdc02b1,0xe29812f9,0x41e412fa}},	//   dzag, _pōro, _шал_, _сіда, 
   {{0x6f1c12fb,0x2fc8005a,0x9cb412fc,0x00000000}},	//   arsc, _ezag_, لمست, --, 
   {{0x701c00cc,0x00000000,0x00000000,0x00000000}},	//   ধ্বজ_, --, --, --, 
   {{0x2d5401e4,0xed58005f,0xc608015b,0x3ae812fd}},	// [e00] _eĥe_, āža_, _রানা_, ابری_, 
   {{0x7cdc02b1,0x2b5812fe,0x00000000,0x00000000}},	//   _tōro, _drsc_, --, --, 
   {{0xd82412ff,0x6b8c002d,0x09e003d4,0x61ec0166}},	//   иджи, azag, যৰ্থ, _ğall, 
   {{0x2b581300,0x6b8c067c,0x38600789,0x77941079}},	//   _frsc_, bzag, ñir_, میزا, 
   {{0x87001301,0x68f402d0,0x30d800df,0x00000000}},	//   ояще, _etzd, אַװע, --, 
   {{0x66cc01a8,0x38980374,0x3eb8002f,0xc68c01d9}},	//   júkd, pōro_, nort_, وِن_, 
   {{0x3218068f,0x5c440092,0x00000000,0x00000000}},	//   órym_, _የሻዕቢ, --, --, 
   {{0x3eb80493,0x00000000,0x00000000,0x00000000}},	//   hort_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3eb812ed,0xd2581302,0x6aa802d2,0x959801af}},	//   jort_, тци_, _íeft, _итеу_, 
   {{0x6b8c1303,0x3eb81304,0x00000000,0x00000000}},	//   zzag, dort_, --, --, 
   {{0x85980375,0x6d4005d1,0x38bc00bc,0xd7a80073}},	//   _בשבו, çlam, píru_, _कशाच, 
   {{0x3eb81305,0x6f1c1306,0x4fc401c6,0x25a80205}},	//   fort_, ursc, рсна, şalt_, 
   {{0x6f1c1307,0xd1b8001f,0x3eb81308,0x00000000}},	//   rrsc, _ታዋቂ_, gort_, --, 
   {{0x70580323,0x8cb801d9,0xac181309,0x320c130a}},	//   _байр_, ندرس_, лову_, mady_, 
   {{0x6b8c01c0,0x3d18130b,0x66cc00d2,0x705400f1}},	//   tzag, _फिरे_, múke, _چنګا, 
   {{0x6a140961,0x3eb8130c,0x00000000,0x00000000}},	// [e10] ймау, bort_, --, --, 
   {{0x320c130d,0xdb24130e,0x6b8c130f,0xed5001d9}},	//   nady_, صومی, rzag, _ٹھس_, 
   {{0x7ed400c6,0x2ee01310,0xab6400ef,0x6b8c00e5}},	//   _بزيا, _iihf_, _spļā, szag, 
   {{0x320c1311,0x4c8007d6,0x00000000,0x00000000}},	//   hady_, _بیرق, --, --, 
   {{0x320c1312,0xe7381313,0x61ec00a2,0x00000000}},	//   kady_, уел_, _şalm, --, 
   {{0x320c1314,0x2328013e,0x23680135,0x2ee803e0}},	//   jady_, ҳоии_, _ħaj_, _muaf_, 
   {{0xbe3c0375,0x320c0432,0x561000ec,0x00000000}},	//   דעות, dady_, سويء, --, 
   {{0x3eb81315,0x4428067c,0x228800d7,0x6b88010e}},	//   zort_, üc_, _múke_, _ýegs, 
   {{0x320c0170,0x228800d0,0x6aa802d2,0xea9800b8}},	//   fady_, _lúke_, _íefs, cuṃ_, 
   {{0xf6740597,0x320c1316,0x00000000,0x00000000}},	//   _والخ, gady_, --, --, 
   {{0x3eb81317,0x61441318,0xe0d8011c,0x38bc00e5}},	//   vort_, щена, лво_, pírt_, 
   {{0x3eb81319,0xb5fc025c,0xa0a4030d,0x00000000}},	//   wort_, _inġa, самд, --, 
   {{0xd12c0b29,0x3eb8131a,0x23680240,0x320c131b}},	//   ومی_, tort_, _çaj_, bady_, 
   {{0x201c131c,0x320c0009,0x61440816,0xfd6401c6}},	//   şti_, cady_, _гека, онгү, 
   {{0x6280131d,0xd24c131e,0x2244131f,0xdee4039b}},	//   mklo, _سني_, melk_, роҳи, 
   {{0x3eb81320,0xe2981321,0xd12c007b,0x00000000}},	//   sort_, _шаһ_, _أمي_, --, 
   {{0x3eb81322,0xcb641323,0x05900055,0x00000000}},	// [e20] port_, бате_, _vāṇy, --, 
   {{0x9be401ec,0xd9c801e1,0x22440432,0x00000000}},	//   ріңк, _ẹ̀kẹ, nelk_, --, 
   {{0x2b4801d9,0x62801324,0x1ea800ec,0x00000000}},	//   awac_, iklo, _لاھي_, --, 
   {{0xea980882,0xda700050,0xac680023,0x00000000}},	//   tuṃ_, _کُس_, _ሰሪሖም_, --, 
   {{0xb5fc00e4,0x62801325,0x22440064,0x4cb8011a}},	//   _anġa, kklo, kelk_, _תזכו, 
   {{0x628000f3,0x27e80419,0x3c44009f,0x00000000}},	//   jklo, ľana_, _اَڏِ, --, 
   {{0x998406d5,0x27e81326,0x320c0851,0x5d7800c8}},	//   _الأو, žana_, vady_, טאַק, 
   {{0x320c1327,0x00000000,0x00000000,0x00000000}},	//   wady_, --, --, --, 
   {{0x320c1311,0x68e0020c,0xd2081328,0x00000000}},	//   tady_, _èlda, лэнд_, --, 
   {{0xd0ac013f,0x9f500407,0x66cc0af2,0x6280003e}},	//   _fɛɛf, _leyó_, túke, gklo, 
   {{0x320c1329,0x94040bbf,0x5274132a,0x2124067c}},	//   rady_, _هواه, _қуду, gulh_, 
   {{0x320c132b,0x62800d04,0x629c07ea,0x2b48012d}},	//   sady_, aklo, ésor, ywac_, 
   {{0x320c132c,0xff0402e8,0x434000c0,0x00000000}},	//   pady_, зясн, _нецв, --, 
   {{0xacf8132d,0xdddc0100,0x320c0009,0x00000000}},	//   ингу_, _enpō, qady_, --, 
   {{0x2124067c,0x60dc007f,0x00000000,0x00000000}},	//   culh_, ňsma, --, --, 
   {{0xce300502,0x41c0038b,0x00000000,0x00000000}},	//   _کودک, _عقيق, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [e30] --, --, --, --, 
   {{0x2b48132e,0x61ec0139,0xac98132f,0x00000000}},	//   rwac_, _ğalk, _چندا_, --, 
   {{0x61ec1330,0x00000000,0x00000000,0x00000000}},	//   _şalk, --, --, --, 
   {{0xb0c8102f,0xbdf804f2,0xb4c80354,0x62800210}},	//   रतिग, _پریا_, _йоiа, zklo, 
   {{0x2ca81331,0x62801332,0x66b41333,0x00000000}},	//   mnad_, yklo, обду, --, 
   {{0x2ca81334,0x49f00327,0xc68c0014,0xc984014b}},	//   lnad_, _བཅིལ_, ڈِچ_, _луби, 
   {{0x2ca80489,0x224400e2,0x6ac4043e,0x00000000}},	//   onad_, velk_, वतीर, --, 
   {{0x2ca81335,0xa6c800fb,0x22440332,0x00000000}},	//   nnad_, ылһа_, welk_, --, 
   {{0xb5fc0327,0x62801336,0x2ca80254,0x22441337}},	//   _inġn, tklo, inad_, telk_, 
   {{0x2ca800a9,0xe298026a,0x62800100,0x00000000}},	//   hnad_, рао_, uklo, --, 
   {{0xe0441338,0x2ca81339,0xa068133a,0xf5e4010a}},	//   онни, knad_, аана_, _хіум, 
   {{0x6280133b,0xa0980395,0x00000000,0x00000000}},	//   sklo, ртоф_, --, --, 
   {{0x3f84133c,0x2ca8133d,0x6280133e,0x248c0267}},	//   ámu_, dnad_, pklo, mhem_, 
   {{0x248c133f,0xb9400020,0x9f500100,0x3f8c0034}},	//   lhem_, _ነዋሪዎ, _beyò_, ądu_, 
   {{0x7cdc02b1,0x1d081340,0x3f840030,0xdc981341}},	//   _hōri, реби_, šmu_, аташ_, 
   {{0x90c01342,0x9f500699,0x2ca81343,0x248c1344}},	//   _обще, _deyò_, gnad_, nhem_, 
   {{0x9e90069c,0x8af403be,0x2d90011c,0x20000cb4}},	// [e40] _ሃገርና_, _şəra, azze_, mbki_, 
   {{0x7cdc02b1,0x4a4006ed,0x2ca81345,0x9f4400a2}},	//   _mōri, мнув, anad_, _ýoñ_, 
   {{0x248c0649,0x57e81346,0xdb0401e6,0x2ca80009}},	//   khem_, адем_, _nykö, bnad_, 
   {{0x442c056a,0x2ca80009,0xaf3400f2,0x00000000}},	//   _ncg_, cnad_, _بویژ, --, 
   {{0x7d000241,0x69c01347,0x248c1348,0xdd9000f1}},	//   _fàrò, _ølen, dhem_, _روڼ_, 
   {{0x442c00a3,0x2d8405ac,0x248c0135,0x20d00332}},	//   _acg_, øleg_, ehem_, láid_, 
   {{0x442c0296,0x248c0003,0x00000000,0x00000000}},	//   _bcg_, fhem_, --, --, 
   {{0x442c1349,0x99880100,0x248c134a,0x0680134b}},	//   _ccg_, _rebň_, ghem_, згән, 
   {{0x9268134c,0xc7a00139,0x15d001ec,0x845000f7}},	//   арна_, _житк, _ﺘﺭﺩﺩ, بۉنچ, 
   {{0xb5fc0327,0xc21402bf,0x154400ee,0x91e000fb}},	//   _inġo, оєю_, _мезм, мәйһ, 
   {{0x442c0072,0x2ca80009,0x10e402dd,0x00000000}},	//   _fcg_, ynad_, _ﺍﻟﺒﻨ, --, 
   {{0x442c020b,0x2ca8058a,0xbfc001e1,0x00000000}},	//   _gcg_, xnad_, _íbọm_, --, 
   {{0x2ca8134d,0xc6c0030d,0x15fc134e,0x00000000}},	//   vnad_, _айăк, _उभार_, --, 
   {{0x9f500100,0x20000254,0x25fc0b4c,0x00000000}},	//   _peyò_, abki_, रुपी_, --, 
   {{0x2d840e96,0x66cc01a2,0x2ca8134f,0x442c0175}},	//   ále_, núka, tnad_, _ycg_, 
   {{0x61ec0724,0x20d000ae,0x4e1400bc,0x2ca8000d}},	//   _ğali, gáid_, _भएकै_, unad_, 
   {{0x2d840552,0x2ca81350,0x228802d2,0x61ec06be}},	// [e50] šle_, rnad_, _húka_, _şali, 
   {{0x248c0cf4,0x6e940022,0xa5540153,0x228808a5}},	//   zhem_, _хиоу, ščią, _kúka_, 
   {{0x37f801f2,0x2ca807b9,0x228803b2,0x248c1351}},	//   _ịkụz, pnad_, _júka_, yhem_, 
   {{0x63ac0008,0x228800d0,0x66cc06ea,0x20d00f47}},	//   _þang, _múka_, dúka, cáid_, 
   {{0x22881352,0x236c0003,0x20d000e5,0x00000000}},	//   _lúka_, xxej_, sáig_, --, 
   {{0xd62403bd,0x442c1353,0x4ddc03d4,0x7cdc02b5}},	//   _རྐྱབ_, _scg_, _ব্যং, _rōri, 
   {{0x442c1354,0xb5fc0327,0x20000034,0x07080412}},	//   _pcg_, _inġl, ybki_, _सौरव_, 
   {{0x7cdc02b1,0x248c0100,0x00000000,0x00000000}},	//   _pōri, uhem_, --, --, 
   {{0x248c1355,0xec78004d,0x9f50041e,0x00000000}},	//   rhem_, _độc_, _neyð_, --, 
   {{0x248c1356,0x228800d2,0xdb040108,0x00000000}},	//   shem_, _búka_, _tykö, --, 
   {{0x63ac1357,0x6b88033f,0x248c03e0,0x00000000}},	//   _žand, _żegl, phem_, --, 
   {{0x442c1358,0x7cdc0374,0x9f500174,0x228802d2}},	//   _ucg_, _tōri, _beyð_, _dúka_, 
   {{0x64480076,0xef6401c6,0x1ea81359,0x00000000}},	//   meei, мъёо, ماسي_, --, 
   {{0x6448135a,0x9f5006ea,0x228800d7,0x12f8011a}},	//   leei, _deyð_, _fúka_, _ההסב, 
   {{0x40b40276,0x00000000,0x00000000,0x00000000}},	//   _ориӂ, --, --, --, 
   {{0xb5fc0003,0x6448135b,0x201c0024,0x00000000}},	//   _anġl, neei, ėtis_, --, 
   {{0x20d00597,0xcb64135c,0x63ac02d2,0x00000000}},	// [e60] ráid_, пате_, _þand, --, 
   {{0x64480069,0x20d000c6,0x00000000,0x00000000}},	//   heei, sáid_, --, --, 
   {{0x8e780375,0x6448135d,0xc4c8033f,0x5dd800fe}},	//   _הניה, keei, ाताओ, _ব্ৰু, 
   {{0x6448135e,0x8d74135f,0xace80066,0x00000000}},	//   jeei, _راپا, _گریل_, --, 
   {{0x64480158,0xbab401d9,0xebc001af,0x45c00150}},	//   deei, _قۅرب, _аҡти, _ﺨﺼﻭﺼ, 
   {{0x3b0002d1,0x00000000,0x00000000,0x00000000}},	//   mpiq_, --, --, --, 
   {{0xd4981360,0x00000000,0x00000000,0x00000000}},	//   йри_, --, --, --, 
   {{0x73c40184,0xb4c81361,0x64481362,0x228803b2}},	//   мәле, ोगे_, geei, _rúka_, 
   {{0x3b0002d1,0x17840aac,0x10e40220,0x228800d7}},	//   npiq_, _эгам, _ﺍﻟﺘﻨ, _súka_, 
   {{0x46a01363,0x9f500174,0x4b78008f,0x673c0037}},	//   _заув, _reyð_, צטיג, _äsja, 
   {{0x7f441364,0x86b41365,0x7cdc00b0,0x461001d5}},	//   _apiq, _عُمر_, _hōru, _سونر, 
   {{0x7cdc04fe,0x66cc01f1,0x91c00116,0x00000000}},	//   _kōru, núkn, мәқл, --, 
   {{0xd7000064,0x00000000,0x00000000,0x00000000}},	//   _зiха, --, --, --, 
   {{0x7cdc00b0,0x2ee403fa,0x61ec0c3c,0xdb98001f}},	//   _mōru, ölf_, _şalv, _ለመያዝ_, 
   {{0x7280010c,0x7f441366,0x00000000,0x00000000}},	//   _ዕለታዊ_, _epiq, --, --, 
   {{0x6ac401bc,0x3e7400d7,0x00000000,0x00000000}},	//   वत्र, _mäty_, --, --, 
   {{0x9408013f,0x20d001e7,0x2bd800f2,0xa0d40244}},	// [e70] ɑbɔ_, báib_, زارک_, _تحوڵ, 
   {{0x1ee804fb,0x00000000,0x00000000,0x00000000}},	//   _گویی_, --, --, --, 
   {{0x644800ad,0xbec800ef,0xac941367,0x66cc0419}},	//   yeei, _dzīļ, _жанш, fúkn, 
   {{0x6d440028,0xdcb007d2,0x61e40118,0x48c800fe}},	//   _ipha, _لىپ_, _úhle, িদ্ৰ, 
   {{0xb8f405f9,0x0ae80451,0xfe7012e9,0x64481368}},	//   _सी_, _درجي_, _شدی_, veei, 
   {{0x3e740221,0x00000000,0x00000000,0x00000000}},	//   _sätz_, --, --, --, 
   {{0x64480158,0x00000000,0x00000000,0x00000000}},	//   teei, --, --, --, 
   {{0x29001369,0x6d44136a,0x1540136b,0x7658002d}},	//   mpha_, _mpha, теъм, advy, 
   {{0x6448136c,0x2900136d,0xe7180472,0x00000000}},	//   reei, lpha_, _ذيات_, --, 
   {{0xe2980212,0x00000000,0x00000000,0x00000000}},	//   іан_, --, --, --, 
   {{0x6d440211,0xaa5c0092,0x64480076,0x66cc0419}},	//   _npha, _ለማሟላ, peei, lúko, 
   {{0xa0680640,0x55b80375,0xd5a4136e,0x00000000}},	//   цама_, _ומעו, _تلمی, --, 
   {{0x6d44136f,0x29000770,0xdd901370,0x61ec0356}},	//   _apha, hpha_, ھور_, _şalu, 
   {{0xdd901371,0x6d4400d2,0x9d440114,0x915800cd}},	//   پور_, _bpha, мегд, _āśvā, 
   {{0x929003b7,0x00000000,0x00000000,0x00000000}},	//   _јајц, --, --, --, 
   {{0x5f28039b,0x25fc0490,0x8c401372,0x6c5400d4}},	//   _доим_, रुती_, кесе, нтує, 
   {{0x6d441373,0x60d40810,0x92c00183,0x00000000}},	// [e80] _epha, _ihym, ্দৰ_, --, 
   {{0x6d440076,0x3b000194,0x9a681374,0x00000000}},	//   _fpha, rpiq_, غمال_, --, 
   {{0xceb004ac,0x99481375,0x81dc0154,0x00000000}},	//   _ביז_, تلال_, ধুর_, --, 
   {{0x7cdc02b1,0x228800e4,0x3e7401f4,0x5ca41376}},	//   _pōru, _oúko_, _räty_, _цимб, 
   {{0x3b0401e1,0x3b000309,0x38c800e5,0x00000000}},	//   _dépò_, qpiq_, _ہاری_, --, 
   {{0x3e7400d0,0x6d4402d0,0xc5100116,0x00000000}},	//   _päty_, _ypha, ھبىت, --, 
   {{0x98a41377,0x5fdc0073,0x745400e5,0x00000000}},	//   _живе, नेतल, ٹھائ, --, 
   {{0x7cdc02b1,0x60d40042,0x2bd4000d,0x66cc00d7}},	//   _tōru, _nhym, _दरमा, búko, 
   {{0x6560062c,0x00000000,0x00000000,0x00000000}},	//   _erlh, --, --, --, 
   {{0x32541378,0x73c40184,0x66cc00d0,0x8778011a}},	//   хвор, мәһе, núkl, _ואמי, 
   {{0xd73c0354,0x00000000,0x00000000,0x00000000}},	//   _гiуд, --, --, --, 
   {{0x60d41379,0x6d4400d2,0x25a80691,0x61ec00fd}},	//   _chym, _rpha, _عدلي_, _şalt, 
   {{0x6d44137a,0xe2a811fc,0x00000000,0x00000000}},	//   _spha, _کانن_, --, --, 
   {{0x2bd404af,0x2900137b,0x60d40076,0x00000000}},	//   _दरबा, ypha_, _ehym, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xf8b807f7,0x20d000ae,0x00000000,0x00000000}},	//   इकोप, ráic_, --, --, 
   {{0x27e80010,0x20d001e7,0x66cc00d7,0x00000000}},	// [e90] žank_, sáic_, fúkl, --, 
   {{0x6f0c137c,0x2fc80280,0x8d8400cf,0x6d440051}},	//   _iwac, _iyag_, _жумд, _tpha, 
   {{0x6d440028,0x6f0c006f,0xdeb002dd,0x29000129}},	//   _upha, _hwac, _сұры, upha_, 
   {{0x2900137d,0xa7140046,0x229401e1,0x00000000}},	//   rpha_, емді, _kùkù_, --, 
   {{0x2900003a,0x6134137e,0xba0800d1,0xbae400db}},	//   spha_, _külç, ستەك_, ركۅي, 
   {{0x6f0c0925,0x29000354,0xaa44049b,0x92c00eac}},	//   _mwac, ppha_, ävää_, ্দু_, 
   {{0x6f0c009a,0xe89401c4,0xb9c4022e,0x00000000}},	//   _lwac, _завь, _аёти, --, 
   {{0xc0bc044e,0x6f0c137f,0x2fc80c6a,0x20d000e4}},	//   _ሰፊሕ_, _owac, _oyag_, káia_, 
   {{0x27ec1380,0x6f0c1381,0x60d41382,0x572000db}},	//   _igen_, _nwac, _rhym, _مۉنك, 
   {{0x68e81383,0x60d41384,0x00000000,0x00000000}},	//   _hied, _shym, --, --, 
   {{0x68e81385,0x21681386,0x6f0c1387,0xa0a41388}},	//   _kied, чини_, _awac, еанд, 
   {{0x6f0c1389,0x205402f4,0xb4e80e56,0x68e8138a}},	//   _bwac, хтор, _قىلم_, _jied, 
   {{0x68e8138b,0x443c138c,0x6f0c0083,0x645802d0}},	//   _mied, mfu_, _cwac, _iawi, 
   {{0x6458138d,0x00000000,0x00000000,0x00000000}},	//   _hawi, --, --, --, 
   {{0x27ec138e,0x60d4138f,0x64581390,0x6f0c0b6f}},	//   _ogen_, _thym, _kawi, _ewac, 
   {{0x68e81391,0x64581392,0x443c1393,0x27ec1394}},	//   _nied, _jawi, nfu_, _ngen_, 
   {{0x6d401395,0x64581396,0x443c0451,0x6f0c1397}},	// [ea0] çlar, _mawi, ifu_, _gwac, 
   {{0x27ec1398,0x20101399,0x68e8004c,0x443c022e}},	//   _agen_, _heyi_, _aied, hfu_, 
   {{0x68e8139a,0xd7f8139b,0x2010139c,0x443c139d}},	//   _bied, пул_, _keyi_, kfu_, 
   {{0x6458139e,0xb5fc0003,0x25fc00c5,0x26c4139f}},	//   _nawi, _inġi, रुसी_, _aklo_, 
   {{0x201013a0,0x6d500882,0x443c039a,0x00000000}},	//   _meyi_, ādaś, dfu_, --, 
   {{0x201013a1,0x27ec13a2,0x443c13a3,0x645813a4}},	//   _leyi_, _egen_, efu_, _aawi, 
   {{0x68e813a5,0x443c13a6,0x645813a7,0x00000000}},	//   _fied, ffu_, _bawi, --, 
   {{0x63ac13a8,0x645813a9,0x68e813aa,0x443c13ab}},	//   _žana, _cawi, _gied, gfu_, 
   {{0x645813ac,0x36e40022,0x645c0109,0x938813ad}},	//   _dawi, _абаҳ, ôsia, яска_, 
   {{0x68e800da,0x201001e1,0x443c13ae,0x6f0c13af}},	//   _zied, _aeyi_, afu_, _rwac, 
   {{0x2010016b,0xc5ec01d9,0x6f0c13b0,0x13e813b1}},	//   _beyi_, _آم_, _swac, _емей_, 
   {{0x645813b2,0x6f0c007f,0x443c0076,0x92c00011}},	//   _gawi, _pwac, cfu_, ্দে_, 
   {{0x201013b3,0xb4cc01f9,0x00000000,0x00000000}},	//   _deyi_, ळती_, --, --, 
   {{0x6458006d,0x81dc0154,0x00000000,0x00000000}},	//   _zawi, ধুই_, --, --, 
   {{0xb81013b4,0x20d000c6,0xc0bc0023,0x8c6413b5}},	//   ाराम_, máin_, ሰሎም_, нтад, 
   {{0x6f0c13b6,0x20d000c6,0x64580014,0x20100009}},	//   _twac, láin_, _xawi, _geyi_, 
   {{0x68e813b7,0xeeb8006c,0x27ec0295,0x6f0c13b8}},	// [eb0] _ried, _олиш_, _rgen_, _uwac, 
   {{0x68e813b9,0x20100198,0x20d000c6,0x443c0099}},	//   _sied, _zeyi_, náin_, zfu_, 
   {{0x68e813ba,0x2010016b,0x27ec13bb,0x443c13bc}},	//   _pied, _yeyi_, _pgen_, yfu_, 
   {{0x20d006d5,0x26c40232,0x88c413bd,0x443c13be}},	//   háin_, _sklo_, رتال, xfu_, 
   {{0x645813bf,0x68e813c0,0xed58005f,0xe738084c}},	//   _rawi, _vied, āžu_, фел_, 
   {{0x68e813c1,0x645813c2,0xe5a413c3,0x443c0493}},	//   _wied, _sawi, кили, wfu_, 
   {{0x68e80664,0x443c13c4,0xdddc02e2,0x20d000c6}},	//   _tied, tfu_, _enpņ, dáin_, 
   {{0x27ec04ce,0x645802d1,0x443c13c5,0x69d40bbc}},	//   _ugen_, _qawi, ufu_, _izze, 
   {{0xe29813c6,0x443c13c7,0x6458006f,0x2010007f}},	//   дап_, rfu_, _vawi, _reyi_, 
   {{0x645805d9,0x201013c8,0x443c13c9,0x20d000c6}},	//   _wawi, _seyi_, sfu_, gáin_, 
   {{0x201013ca,0x443c13cb,0x6fe80171,0xeaec0118}},	//   _peyi_, pfu_, _līcī, जदुत_, 
   {{0xa0a413cc,0x1e0807af,0x443c13cd,0x237408de}},	//   тамд, वर्ष_, qfu_, _لاتح, 
   {{0x2d8413ce,0xe2b413cf,0xb38400c6,0x20d0007b}},	//   ølen_, _искэ, _مجوه, báin_, 
   {{0x9f9c03b7,0x2010013f,0x20d008de,0x69d40083}},	//   _ação_, _weyi_, cáin_, _ozze, 
   {{0x716413d0,0xdca413d1,0x228802d2,0x00000000}},	//   _مايك, вави, _lúkk_, --, 
   {{0x1f6413d2,0xeaec09ab,0x64940332,0xb92400c7}},	//   _аким, जदूत_, _dáig, pysẽ_, 
   {{0x69d413d3,0xdddc0024,0x00000000,0x00000000}},	// [ec0] _azze, _kopū, --, --, 
   {{0xdee4048a,0x8a0013d4,0x64940332,0x00000000}},	//   _шопи, изуе, _fáig, --, 
   {{0xd00c0046,0x649413d5,0x00000000,0x00000000}},	//   _الۋ_, _káid, --, --, 
   {{0x66cc00d2,0xf81408f0,0x00000000,0x00000000}},	//   lúkh, اساگ, --, --, 
   {{0x69d400dd,0x64940332,0x16a0035b,0x63ac00de}},	//   _ezze, _máid, аҳаҭ, _žann, 
   {{0x64940597,0xc7a013d6,0x1dd4007a,0x3ce0000d}},	//   _láid, шичк, _धरात, lmiv_, 
   {{0xc60800bd,0xd498010a,0x20d001e7,0x00000000}},	//   _রাখা_, дрп_, váin_, --, 
   {{0xb4cc0574,0x236800ef,0xdb240241,0x00000000}},	//   ळते_, _šaja_, _òpóp, --, 
   {{0x20d000c6,0x705413d7,0x430413d8,0x8c40054e}},	//   táin_, ۇندا, кхэм_, âşie, 
   {{0x7694002e,0x28740124,0x38bc0306,0x3ce00477}},	//   _bàye, _аӡәы_, víry_, hmiv_, 
   {{0x63ac00fc,0x20d013d9,0x705400ec,0x649401e7}},	//   _þann, ráin_, هندا, _báid, 
   {{0x2ebc13da,0x20d00491,0x64940332,0x5344030d}},	//   ोत्त, sáin_, _ráig, _ахка, 
   {{0x20d013db,0x64940332,0x8f08074d,0x00000000}},	//   máil_, _dáid, ьхна_, --, 
   {{0x395805be,0x6fe8005f,0x8d740132,0x20d0007b}},	//   _osrs_, _rīcī, پاسا, láil_, 
   {{0x395801fa,0xac9413dc,0x649401e7,0xd174004e}},	//   _nsrs_, гавш, _fáid, _шыды, 
   {{0xb5fc0135,0x649413dd,0x20d0007b,0x705806ed}},	//   _inġu, _gáid, náil_, _чаир_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ed0] --, --, --, --, 
   {{0x20d00491,0x6f1c11a2,0xdb2413de,0x4338010f}},	//   háil_, mssc, اولی, ועמב, 
   {{0x6f1c13df,0x2bd413e0,0x1ea80451,0x2d840037}},	//   lssc, _दरवा, _ساٿي_, äled_, 
   {{0xb4cc0490,0xf77005d9,0x00000000,0x00000000}},	//   ळतो_, ڪام_, --, --, 
   {{0xfeb813e1,0x9cd413e2,0x6f1c13e3,0x20d00597}},	//   _سایت_, _תורה_, nssc, dáil_, 
   {{0xf77013e4,0x2ca813e5,0x6e340399,0x39580175}},	//   تام_, liad_, ngzb, _fsrs_, 
   {{0x88800502,0x64a413e6,0xdbd80166,0x69d402d0}},	//   _پیشن, лака, _eçäk, _uzze, 
   {{0x20d00491,0x2ca80cfd,0x637813e7,0x224801e4}},	//   gáil_, niad_, есор_, _ŝak_, 
   {{0xb5fc031c,0x228803b2,0x649401e7,0x638400d8}},	//   _anġu, _húki_, _ráid, угпа, 
   {{0x6f1c13e8,0x2ca813e9,0x68f401d5,0x3f840162}},	//   dssc, hiad_, _kuzd, ømum_, 
   {{0xe43413ea,0x6f1c13eb,0x649401e7,0x20d000ae}},	//   _مفاد, essc, _páid, báil_, 
   {{0x68f413ec,0x20d00597,0x27e8110c,0x6f1c0e78}},	//   _muzd, cáil_, žanu_, fssc, 
   {{0x2ca80f7b,0x10a013ed,0x3f8400d2,0x6f1c13ee}},	//   diad_, сиян, âmu_, gssc, 
   {{0x248c0316,0x61e400bc,0x00000000,0x00000000}},	//   lkem_, _úhlo, --, --, 
   {{0x2ca80cfd,0x68f405a1,0xdcb013ef,0x6f1c0076}},	//   fiad_, _nuzd, مىس_, assc, 
   {{0xaa700020,0x2ca80cfd,0x7d1c13f0,0x39580120}},	//   _ለማረጋ, giad_, rsrs, _rsrs_, 
   {{0x2b580048,0x395813f1,0x6f1c02d0,0x00000000}},	// [ee0] _cssc_, _ssrs_, cssc, --, 
   {{0x248c033d,0x68f413f2,0x22880162,0x395800e2}},	//   hkem_, _buzd, _búki_, _psrs_, 
   {{0x248c102c,0xdca40e58,0x2ca80368,0x984813f3}},	//   kkem_, _бани, biad_, еяла_, 
   {{0x68f413f4,0x395809a8,0x649401e7,0x2ca803cb}},	//   _duzd, _vsrs_, _láib, ciad_, 
   {{0x248c012c,0x2368009b,0x91c813f5,0xc608015b}},	//   dkem_, _šajn_, _सुनै, _রাজা_, 
   {{0x60c401ee,0x248c13f6,0x3a380113,0xb5fc0327}},	//   hokm, ekem_, _ucrp_, _maġg, 
   {{0x20d00491,0x60c40066,0xd4c401ec,0x2614000d}},	//   táil_, kokm, лсип, _नजरी_, 
   {{0xd3781064,0x00000000,0x00000000,0x00000000}},	//   ечо_, --, --, --, 
   {{0x20d00491,0xb2b807d6,0x60c40306,0x781013f7}},	//   ráil_, клиф_, dokm, ारीक_, 
   {{0x2ca80dd4,0x20d00597,0x68f413f8,0xcb54011a}},	//   ziad_, sáil_, _yuzd, נסיה_, 
   {{0xd14813f9,0x649401e7,0x27e813fa,0x248c0118}},	//   رشدن_, _dáib, žant_, bkem_, 
   {{0x6f1c13fb,0x248c13fc,0x2ca8003e,0x63800124}},	//   tssc, ckem_, xiad_, сҳәа, 
   {{0xb4c009d9,0x6d5413fd,0x03a0034b,0x6f1c0ade}},	//   ंकी_, wwza, _лицо, ussc, 
   {{0x2ca8048e,0x6f1c13fe,0x20bc01f2,0x00000000}},	//   wiad_, rssc, ọkpụ_, --, 
   {{0x2ca800a9,0xac1813ff,0x2d841400,0x6d5401f5}},	//   tiad_, кову_, âle_, uwza, 
   {{0x2b580421,0x81a8015b,0x2ca80165,0x6f1c1401}},	//   _pssc_, _খরচ_, uiad_, pssc, 
   {{0x2ca81402,0x68f41403,0x6494035b,0xdddc007f}},	// [ef0] riad_, _suzd, _háic, _lapň, 
   {{0x2ca800a9,0x68f40030,0x2c1403d4,0x248c1404}},	//   siad_, _puzd, িলেই_, zkem_, 
   {{0x2ca81405,0xc0f4001f,0x248c1406,0x00000000}},	//   piad_, ፋፈል_, ykem_, --, 
   {{0x76481407,0xf77000ec,0x68f40166,0x6c78010f}},	//   _abdy, ڻان_, _vuzd, _סאָפ, 
   {{0xdc3404ac,0x61d01408,0x248c00bc,0x2cb800ef}},	//   _דארט_, _हर्ष, vkem_, _ijsd_, 
   {{0x68f41409,0x66e4140a,0x00000000,0x00000000}},	//   _tuzd, шола, --, --, 
   {{0xd84000c6,0x248c140b,0x60c40369,0x649401e7}},	//   _ŕōś_, tkem_, yokm, _ráib, 
   {{0x64940332,0x3218022e,0x7de000e5,0x38c801c4}},	//   _sáib, аryo_, lásé, _буун_, 
   {{0x248c140c,0xf87002fb,0x2a7001f5,0xa9a40116}},	//   rkem_, šším_, _knzb_, _сиңд, 
   {{0x248c140d,0x3634004b,0x64940332,0x13e4013d}},	//   skem_, _هرمس, _báic, шмый_, 
   {{0xe0d8140e,0x61440408,0x05440137,0x2a6001e7}},	//   кво_, шена, _сүйл_, idhb_, 
   {{0x6e240013,0x00000000,0x00000000,0x00000000}},	//   _adhb, --, --, --, 
   {{0xa3e80243,0x1ea8140f,0x649400ae,0x9878010f}},	//   _मणि_, ناسي_, _táib, דארט, 
   {{0x53980302,0xc1b00124,0x60c40158,0xd36c1410}},	//   _בינו, _гәмы, sokm, _آهو_, 
   {{0x212403e6,0x5de40395,0x00000000,0x00000000}},	//   _ڵبژێ, ржва, --, --, 
   {{0x91b800d9,0x00000000,0x00000000,0x00000000}},	//   _במצי, --, --, --, 
   {{0xcc1405f5,0x63ac0427,0xaf4801d5,0x66cc03b2}},	// [f00] рчсө, _žanj, _یشیل_, lúku, 
   {{0x8f180677,0x5e700244,0x00000000,0x00000000}},	//   _שוית, _بۆسڕ, --, --, 
   {{0xd8380323,0x2a7002b5,0x03f803d4,0x5fa8000d}},	//   вэл_, _dnzb_, _এজনী_, _चेतल, 
   {{0x2d941411,0xb5fc025c,0xdddc0100,0xd1d00023}},	//   _ырыс, _maġe, _rapň, ረፍቲ_, 
   {{0x769401e1,0x473002bf,0x66cc0124,0xc7a01412}},	//   _aàya, жніс, húku, оицк, 
   {{0xd05c03e3,0x81a800cc,0x00000000,0x00000000}},	//   _diqə, _খৰছ_, --, --, 
   {{0x66cc0d12,0x28400092,0x00000000,0x00000000}},	//   júku, _የምኩራ, --, --, 
   {{0xd7041413,0xb4c01414,0x228800d0,0x132c0092}},	//   _взаи, ंके_, _múku_, _በነጻነ, 
   {{0x228800d7,0x00000000,0x00000000,0x00000000}},	//   _lúku_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x09f40302,0x00000000,0x00000000,0x00000000}},	//   ימים_, --, --, --, 
   {{0xdcec02d5,0x629c00db,0x93e401b9,0x9998007f}},	//   mybė, èsor, _кўлл, rapň_, 
   {{0xbfa81415,0x6b4801e4,0xdcec0024,0xd14801d5}},	//   атре_, _oɾga, lybė, رشگن_, 
   {{0x2288043b,0xc0cc0020,0x00000000,0x00000000}},	//   _búku_, _አየር_, --, --, 
   {{0xdcec0006,0xb5fc025c,0x64940022,0x8e7c0092}},	//   nybė, _gaġe, _uáic, _ያገኛሉ_, 
   {{0x30140323,0x228800d2,0x00000000,0x00000000}},	//   _удир, _dúku_, --, --, 
   {{0x3c580276,0xebc4070e,0x7de000e5,0xebd801f0}},	// [f10] шитэ_, сәнн, tásé, удаш_, 
   {{0xdcec0006,0x3a7400a8,0xdb0400e5,0xba740108}},	//   kybė, олур, ámáb, огущ, 
   {{0xd3641416,0x1618006d,0x2904003d,0x6100003a}},	//   _که_, _नज़र_, _ħlas_, _tēle, 
   {{0xb4c00316,0x6844036b,0x4ba400f7,0x6c540137}},	//   ंको_, ёнла, _көзү_, _укму, 
   {{0xdd14010e,0x00000000,0x00000000,0x00000000}},	//   _käşg, --, --, --, 
   {{0x6b8c00dc,0x00000000,0x00000000,0x00000000}},	//   myag, --, --, --, 
   {{0x6b8c1417,0xdcec0024,0xdd1400fd,0xa3c801f9}},	//   lyag, gybė, _mäşg, लॅन_, 
   {{0xe45805c5,0xb834010b,0x6b8c1418,0xb5fc0003}},	//   ужи_, _месщ, oyag, _raġe, 
   {{0x6b8c1419,0x1304034b,0xf7940153,0x00000000}},	//   nyag, бный_, _датэ, --, 
   {{0x6b8c062c,0x66cc00e4,0x25fc0456,0x00000000}},	//   iyag, túku, रुखी_, --, 
   {{0xf65000db,0xd83c0010,0x91c80073,0x60e8009b}},	//   _زئل_, ščec_, _सुदै, лмом_, 
   {{0x65cc0014,0x6b8c141a,0x41400023,0xdb0c01d3}},	//   ीपà_, kyag, _ንካልኦ, őkép, 
   {{0x23280aa5,0x6b8c0796,0x6304141b,0xdd14010e}},	//   _соли_, jyag, _اوتل, _bäşg, 
   {{0xf4840131,0xb5fc0327,0xc20c0014,0xdee4141c}},	//   _гуән, _taġe, _کٔژ_, соги, 
   {{0x753c0730,0x6b8c04ba,0xdcf8141d,0x317802c1}},	//   _ärzt, eyag, افرت_, ärzt_, 
   {{0x30740408,0x00000000,0x00000000,0x00000000}},	//   _дуьс, --, --, --, 
   {{0x6b8c141e,0x5f4401d3,0xdddc01ef,0xc10001f7}},	// [f20] gyag, _انخل, _topů, _اوڊي, 
   {{0x7810141f,0x4b20003b,0x00000000,0x00000000}},	//   ार्क_, ямув, --, --, 
   {{0x6b8c1368,0x18681420,0x00000000,0x00000000}},	//   ayag, лажи_, --, --, 
   {{0xdcec0006,0x6b8c1421,0x2000033f,0x48e01422}},	//   vybė, byag, ncki_, похв, 
   {{0xcb400020,0x20000114,0x6b8c1423,0x00000000}},	//   ንተርኔ, icki_, cyag, --, 
   {{0xdcec02d5,0xb4c001ad,0x00000000,0x00000000}},	//   tybė, ंक्_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcec0006,0x629c0240,0xf48400f2,0xd8b401e2}},	//   rybė, ëson, تاتی, _امرخ, 
   {{0xd6d01424,0xdcec0153,0x00000000,0x00000000}},	//   _فقر_, sybė, --, --, 
   {{0x321801a2,0xd2581425,0x20001426,0x00000000}},	//   úry_, уци_, ecki_, --, 
   {{0xe6b40014,0x66cc1427,0x920000b8,0x00000000}},	//   _ظلمگ, rúkt, _ũāsa, --, 
   {{0x06cc03d4,0x6b8c0198,0x64940332,0x00000000}},	//   িগণি, yyag, _háin, --, 
   {{0xe8181428,0x00000000,0x00000000,0x00000000}},	//   दरता_, --, --, --, 
   {{0x200004ce,0x0dc80f43,0xf1941429,0xc324007b}},	//   acki_, губи_, _миль, _اكون_, 
   {{0x6494007b,0x6b8c0083,0x8140009a,0x25fc044b}},	//   _máin, wyag, _فنون, रुटी_, 
   {{0x6b8c142a,0x64940332,0x63ac142b,0xaa700092}},	//   tyag, _láin, _žani, _ለማሸጋ, 
   {{0xcf2405d4,0x8af403e3,0x00000000,0x00000000}},	// [f30] _اربي, _şəba, --, --, 
   {{0x6b8c142c,0x649408a5,0x00000000,0x00000000}},	//   ryag, _náin, --, --, 
   {{0x2bd4142d,0xad4000f7,0xc86401d5,0x00000000}},	//   _दरका, _تۉزۉ, йтди, --, 
   {{0x66cc0436,0x63ac00ee,0xc6a4142e,0x610000ef}},	//   júkr, _ýang, әрди, _jēla, 
   {{0x41cc0316,0x649401e7,0x074400c0,0x69b80562}},	//   _सुनस, _báin, схем, ्थही, 
   {{0x6494007b,0xaa840133,0x63ac032e,0x00000000}},	//   _cáin, _گۆڕم_, _þani, --, 
   {{0x6494142f,0x20001430,0xe858014b,0xdaa00116}},	//   _dáin, ycki_, _кавш_, _تەلپ, 
   {{0x25fc1431,0x6d401432,0x20d00332,0x00000000}},	//   रुजी_, çlay, láiv_, --, 
   {{0x649400c6,0x00000000,0x00000000,0x00000000}},	//   _fáin, --, --, --, 
   {{0x649401e7,0x66cc03b2,0x00000000,0x00000000}},	//   _gáin, rúks, --, --, 
   {{0xa1c41422,0xdb0401a8,0x00000000,0x00000000}},	//   юбод, _ómög, --, --, 
   {{0xa91006ab,0x7de00241,0x610000ef,0x00000000}},	//   डीएफ_, _lásí, _cēla, --, 
   {{0x2d841433,0x64480fac,0x2bd4033f,0x610000de}},	//   älen_, mfei, _दरगा, _dēla, 
   {{0x21681434,0x64481435,0xdddc0276,0xae0400fb}},	//   _вики_, lfei, _nopţ, зорҙ, 
   {{0xe0d81436,0xd0800092,0x00000000,0x00000000}},	//   _квк_, _ይጨምሩ_, --, --, 
   {{0x64481437,0xdee4013e,0xceb400fb,0x50d400e5}},	//   nfei, соҳи, йҙө_, _وزٹر, 
   {{0xbbb40073,0x64481438,0xdaa80117,0x63ac010b}},	// [f40] ंपेक, ifei, авад_, _ýand, 
   {{0x7cf80115,0x62800c6a,0x6d4001ab,0x64480142}},	//   _aŭre, njlo, àlac, hfei, 
   {{0x358c044e,0x7de00241,0x58841439,0x6448143a}},	//   ንያታት_, _dásí, жыла, kfei, 
   {{0x20c8143b,0x6448002d,0x649401e7,0x00000000}},	//   रविध, jfei, _sáin, --, 
   {{0x7de0143c,0x2ca40af9,0x64480042,0x00000000}},	//   _fásí, ëlde_, dfei, --, 
   {{0x7cf801e4,0x550400a8,0x98a80051,0x00000000}},	//   _eŭre, очиа, _vqbđ_, --, 
   {{0xd498143d,0x86c0143e,0xc92401af,0x00000000}},	//   ири_, بيون, _морж_, --, 
   {{0x64480007,0xb198001e,0x7f44009a,0x672c143f}},	//   gfei, _ngưỡ, _oqiq, šaja, 
   {{0x649400ae,0x00000000,0x00000000,0x00000000}},	//   _táin, --, --, --, 
   {{0x38641440,0x3b000007,0x649400ae,0x96b800db}},	//   _hamr_, iqiq_, _háil, _тубу_, 
   {{0x7f441441,0xc0f402d3,0x3b0005b1,0x99981442}},	//   _aqiq, ጋገሪ_, hqiq_, kapō_, 
   {{0x92c800bd,0x76581443,0x00000000,0x00000000}},	//   লগে_, levy, --, --, 
   {{0x610000da,0xff0402e8,0x649401e7,0x630000d1}},	//   _vēla, дясн, _máil, _كۈيل, 
   {{0x76580451,0x3b001444,0xbbb40490,0x673c1445}},	//   nevy, dqiq_, ंपैक, _åsje, 
   {{0x7f44009a,0x2ee00270,0xc0bc02d3,0x0ca801f0}},	//   _eqiq, _vhhf_, ደሎም_, атаи_, 
   {{0x76581446,0x321c0109,0x90e404fb,0x649400d8}},	//   hevy, _hevy_, _بستن, _náil, 
   {{0x76581447,0x4a7401e0,0x610000ef,0x00000000}},	// [f50] kevy, ҙыҡт, _jēln, --, 
   {{0x321c035b,0x00000000,0x00000000,0x00000000}},	//   _jevy_, --, --, --, 
   {{0x27880372,0x64480368,0x649400ae,0x80a4030f}},	//   өрдү_, yfei, _báil, _رمین, 
   {{0x321c1448,0x64940597,0x6d441449,0x38640009}},	//   _levy_, _cáil, _iqha, _camr_, 
   {{0x649400c6,0xca740032,0x1ee803b6,0x2d90144a}},	//   _dáil, _һуңы, _خویی_, lyze_, 
   {{0x96600046,0xc0f400b7,0x00000000,0x00000000}},	//   екше, ጋገሩ_, --, --, 
   {{0x8554144b,0x64940597,0x4990144c,0xdddc005f}},	//   تیار_, _fáil, _تیار, _kopš, 
   {{0x2334144d,0x20d001f6,0x92000055,0x00000000}},	//   пхор, náit_, _ũāpa, --, 
   {{0x6448144e,0xe3b00597,0x7658144f,0x321c0076}},	//   rfei, عرب_, bevy, _bevy_, 
   {{0x64481450,0x6d441451,0xe298026a,0xdddc0024}},	//   sfei, _oqha, сао_, _lopš, 
   {{0x29001452,0x64481453,0x64940022,0x321c0055}},	//   nqha_, pfei, _háim, _devy_, 
   {{0x69d40240,0x00000000,0x00000000,0x00000000}},	//   _myze, --, --, --, 
   {{0x6d441454,0x29000113,0x00000000,0x00000000}},	//   _aqha, hqha_, --, --, 
   {{0xa528025c,0x00000000,0x00000000,0x00000000}},	//   _ལྷོག_, --, --, --, 
   {{0x64940597,0x999802b5,0x69d4007c,0x63ac010e}},	//   _láim, tapō_, _nyze, _ýanb, 
   {{0x9b04022e,0x00000000,0x00000000,0x00000000}},	//   ззад, --, --, --, 
   {{0x6d440944,0x999800b0,0x75380306,0x649400ae}},	// [f60] _eqha, rapō_, zuvz, _ráil, 
   {{0xc0f40125,0x5cf40d6f,0x649400ae,0x386400b8}},	//   ጋገር_, _няму, _sáil, _samr_, 
   {{0x2d841455,0x649400c7,0xae041456,0x8df8011a}},	//   ølet_, _páil, _توپى, _להית, 
   {{0x20d01457,0x69d41458,0x629c0023,0xbc7400f7}},	//   máis_, _dyze, ësoj, _تۇرب, 
   {{0x76581459,0x672c05ce,0x69d406be,0x20d001e7}},	//   tevy, šajn, _eyze, láis_, 
   {{0x35d4145a,0x649400ae,0x00000000,0x00000000}},	//   молё, _dáim, --, --, 
   {{0x321c145b,0x649400c6,0x7658143a,0x20d0145c}},	//   _revy_, _táil, revy, náis_, 
   {{0x321c04e6,0x75380306,0xd3a4011c,0x00000000}},	//   _sevy_, ruvz, зроп, --, 
   {{0x65600ba1,0xd62800ee,0x321c0022,0x07a0145d}},	//   _eslh, _гозе_, _pevy_, _затн, 
   {{0xcb100375,0x610000e2,0x00000000,0x00000000}},	//   עלת_, _cēlo, --, --, 
   {{0x9f50145e,0xfbc400bd,0x59bc145f,0x20d00789}},	//   _ngyâ_, ্ধিত, ्थिर, jáis_, 
   {{0x20d01460,0x25640014,0x610000de,0x00000000}},	//   dáis_, _زامُ, _tēln, --, 
   {{0x81400edf,0xcb1802ab,0xdddc0064,0x00000000}},	//   ونین, _पौंड_, _ropš, --, 
   {{0x20d001e7,0x59bc07b7,0x00000000,0x00000000}},	//   fáis_, ्थार, --, --, 
   {{0x20d01461,0x81d001f0,0x00000000,0x00000000}},	//   gáis_, _пошх, --, --, 
   {{0x2d900100,0x69d41462,0x00000000,0x00000000}},	//   ryze_, _ryze, --, --, 
   {{0x2900094a,0xff500214,0x69d40240,0x20d01463}},	// [f70] wqha_, _یخی_, _syze, ráit_, 
   {{0x6f0c1464,0x64940332,0x2d84003b,0x20d00042}},	//   _itac, _ráim, øles_, sáit_, 
   {{0xb5fc038f,0x6d441465,0x20d01466,0x96200154}},	//   _paġn, _uqha, cáis_, নলাম_, 
   {{0xdddc1467,0x69d401a2,0x20d000c6,0x00000000}},	//   _uopš, _vyze, láir_, --, 
   {{0x29000054,0x69d40210,0x6b7401a9,0x00000000}},	//   sqha_, _wyze, _ўлгу, --, 
   {{0xa528003d,0x20d00597,0x6f0c009f,0x672c00de}},	//   _ལྷུག_, náir_, _mtac, šajo, 
   {{0x24e81468,0x644c0124,0x2900031c,0x2b4806be}},	//   омки_, _ñaik, qqha_, ltac_, 
   {{0x64940597,0xc21c05f9,0x00d80131,0x20d0007b}},	//   _táim, _मजहब_, ﯟﺍﺗﻘ, háir_, 
   {{0x6f0c1469,0x20d00005,0x86b002dd,0xa2e4146a}},	//   _ntac, záis_, _пәкі, моид, 
   {{0x20d00407,0x4abc146b,0x672803ac,0xc0cc0092}},	//   yáis_, ्विव, _ivej, _አየሁ_, 
   {{0x6100005f,0x5bb8146c,0xb38401c6,0x2b4803e3}},	//   _vēlo, _इश्व, длөл, htac_, 
   {{0xe2f80046,0x20d004d4,0x00000000,0x00000000}},	//   _деді_, váis_, --, --, 
   {{0x4abc07b7,0x10a0146d,0x2b480113,0x6d40146e}},	//   ्वाव, тиян, jtac_, àlan, 
   {{0x12f80302,0x443c146f,0x672800ca,0x20d01470}},	//   _והסב, lgu_, _mvej, táis_, 
   {{0x6f0c1471,0x443c1472,0xdcb01473,0x236c1474}},	//   _etac, ogu_, نىس_, lvej_, 
   {{0x20d00597,0x67281475,0x236c0419,0x00000000}},	//   ráis_, _ovej, ovej_, --, 
   {{0x236c04ce,0x9f041476,0x2d841477,0x443c1478}},	// [f80] nvej_, _توخو, øler_, igu_, 
   {{0x7cf80115,0x443c1479,0x629c0023,0xb5fc0135}},	//   _eŭra, hgu_, ësoh, _raġo, 
   {{0x443c001f,0xaf580020,0xfe140316,0xd7f800a8}},	//   kgu_, ያደርገ, _त्यस_, оул_, 
   {{0x236c00b5,0x00000000,0x00000000,0x00000000}},	//   kvej_, --, --, --, 
   {{0x7c24147a,0x2b48147b,0x672800f3,0x59bc00bc}},	//   mair, ctac_, _cvej, ्थहर, 
   {{0x7c24147c,0x443c147d,0x67280006,0x236c00b5}},	//   lair, egu_, _dvej, dvej_, 
   {{0xd824147e,0x090000c7,0x249c0042,0x236c01bf}},	//   _одви, _апсн, _blwm_, evej_, 
   {{0x7c24147f,0x443c1480,0x09e01481,0x38c81482}},	//   nair, ggu_, _росн, _رازی_, 
   {{0x61ec01e4,0x236c005c,0x00000000,0x00000000}},	//   _ĝala, gvej_, --, --, 
   {{0x7c241483,0x443c1484,0x6f0c036b,0x4b78011a}},	//   hair, agu_, _rtac, קאיו, 
   {{0x7c241485,0x6f0c1486,0x67281487,0x236c01bf}},	//   kair, _stac, _zvej, avej_, 
   {{0x7c241488,0x249c0142,0x6f0c09ab,0xe7f409bb}},	//   jair, _glwm_, _ptac, ुँचा_, 
   {{0x7c241489,0x53e008ec,0xdddc012d,0x20d00332}},	//   dair, _परिश, _napł, táir_, 
   {{0x769400e8,0x8d740014,0x6f0c00d7,0x63ac010b}},	//   _bàyi, ٘ارا, _vtac, _ýana, 
   {{0x7c24148a,0x8c6400cf,0x20d0148b,0xbdd401f4}},	//   fair, мтад, ráir_, ворщ, 
   {{0x6f0c074d,0x7c24148c,0x53e00b8f,0x20d00332}},	//   _ttac, gair, _पराश, sáir_, 
   {{0x6f0c148d,0xfbd0007b,0xaed40798,0x00000000}},	// [f90] _utac, لتك_, _поиш, --, 
   {{0x2b48148e,0x443c148f,0x7c2400e4,0x00000000}},	//   rtac_, zgu_, aair, --, 
   {{0x7c241490,0x443c1491,0x672807f5,0xac9401c0}},	//   bair, ygu_, _svej, _занш, 
   {{0x7c241492,0x4b940020,0xe8c80490,0x66f8010e}},	//   cair, መልክቶ_, िकेच, _aňka, 
   {{0xfe7001ed,0x236c01bf,0x443c0200,0x00000000}},	//   _صدی_, xvej_, vgu_, --, 
   {{0x443c1493,0x236c00b5,0x7f3c010f,0xf804013d}},	//   wgu_, vvej_, קעוו, нчән, 
   {{0xdddc0034,0xfd6400b8,0x249c03cb,0xe2980131}},	//   _zapł, _bhuṃ, _plwm_, җан_, 
   {{0xfdf80302,0x443c1494,0x236c1495,0x3de400cc}},	//   וצות_, ugu_, tvej_, _মলমল, 
   {{0x610000da,0x67281496,0x602800e4,0x00000000}},	//   _vēlm, _uvej, hêmí, --, 
   {{0x7c241497,0x443c0cfd,0x236c1498,0x00000000}},	//   zair, sgu_, rvej_, --, 
   {{0x236c04ce,0x7c241499,0xa068149a,0xb524030d}},	//   svej_, yair, пана_, _аьчк, 
   {{0x236c037e,0x7c240036,0x8af403e3,0x00000000}},	//   pvej_, xair, _şəla, --, 
   {{0x442c149b,0x7c24149c,0xc0cc001f,0xa2940212}},	//   _idg_, vair, _አየለ_, _паді, 
   {{0x442c04e6,0xdea0036b,0x7c24149d,0x00000000}},	//   _hdg_, ایدی, wair, --, 
   {{0x7c24149e,0x442c149f,0x008400ee,0x27e800d0}},	//   tair, _kdg_, _акйү, ľany_, 
   {{0xda6414a0,0x442c14a1,0x27e80306,0x00000000}},	//   کاري, _jdg_, žany_, --, 
   {{0x442c14a2,0x5ba814a3,0x6fe80171,0x00000000}},	// [fa0] _mdg_, чкам_, _cūcī, --, 
   {{0x4a4014a4,0xd00c14a5,0x00000000,0x00000000}},	//   лнув, _پلی_, --, --, 
   {{0x442c14a6,0x00000000,0x00000000,0x00000000}},	//   _odg_, --, --, --, 
   {{0x442c14a7,0xdca414a8,0x4c8000d4,0x5ca401a9}},	//   _ndg_, _чами, _блюв, _чимб, 
   {{0x290414a9,0xa0200254,0x00000000,0x00000000}},	//   _élan_, _ööun, --, --, 
   {{0x442c0221,0xd94400d8,0x610000ef,0x00000000}},	//   _adg_, _пеги, _cēlk, --, 
   {{0x442c14aa,0x38c814ab,0x60d40022,0x98a4085f}},	//   _bdg_, _قاری_, _okym, _зиве, 
   {{0x442c14ac,0x00000000,0x00000000,0x00000000}},	//   _cdg_, --, --, --, 
   {{0x442c009a,0x78a0032e,0x00000000,0x00000000}},	//   _ddg_, _ilmv, --, --, 
   {{0x442c0477,0x60d400ee,0x91e002d9,0x958400d8}},	//   _edg_, _akym, ләйһ, _плзе, 
   {{0x442c14ad,0x63ac00a2,0xc1b4009d,0x00000000}},	//   _fdg_, _ýann, елэх_, --, 
   {{0x442c14ae,0x395813bb,0x312400f7,0x00000000}},	//   _gdg_, _mprs_, ндүг, --, 
   {{0x7cf800df,0xb5fc025c,0x4474010f,0xd25014af}},	//   _aŭro, _raġj, _רעדל_, _منش_, 
   {{0x442c14b0,0x92dc03d4,0x6f080115,0x8d8401d5}},	//   _zdg_, _দূৰ_, ŭeco, нубд, 
   {{0xc17005af,0x6fe8002b,0x646402d2,0x417014b1}},	//   _مديت, _sūcī, _ætiþ, _مايس, 
   {{0x290400e4,0x6fe800ef,0x41d8011a,0x00000000}},	//   _ũlao_, _pūcī, _מחוס, --, 
   {{0x6ad802a6,0x7cf804ac,0x6fb802bf,0xebc41206}},	// [fb0] _ভূগো, _eŭro, _ігор_, тәнн, 
   {{0x8d8401d5,0xab500092,0x00000000,0x00000000}},	//   _зумд, _ሕይወቱ, --, --, 
   {{0xdeb00046,0x69c014b2,0x64940332,0x7ac414b3}},	//   _тұры, _žleb, _iáiv, усте, 
   {{0x64940022,0x00000000,0x00000000,0x00000000}},	//   _háiv, --, --, --, 
   {{0x442c14b4,0xcb4402e8,0x877001ec,0x2204022e}},	//   _rdg_, _яхни, ығаш, 壮hma_, 
   {{0xf548069c,0x2b580048,0xaad800bc,0xe810012d}},	//   _ዘይኮነ, _ipsc_, _बीचक, _ड्रा_, 
   {{0x395814b5,0x442c14b6,0x64a40556,0x569014b7}},	//   _gprs_, _pdg_, кака, рајт, 
   {{0x291014b8,0x61ec01e4,0x00000000,0x00000000}},	//   _itza_, _ŝalo, --, --, 
   {{0xa6f4010b,0x68e802d0,0xa6c80150,0xfa2403d4}},	//   _азаш, _ihed, _قورل_, _পাতল_, 
   {{0x442c063f,0x60d40267,0xb9280208,0x61000171}},	//   _wdg_, _skym, _nhuệ_, _hēli, 
   {{0xa0a40364,0x68e814b9,0x24540244,0x00000000}},	//   ванд, _khed, _لناس, --, 
   {{0x442c14ba,0x68e814bb,0x0048004b,0x00000000}},	//   _udg_, _jhed, ریخي_, --, 
   {{0x626414bc,0x68e814bd,0x64dc01f9,0x00000000}},	//   _авла, _mhed, मतीश, --, 
   {{0x68e80076,0xdee40818,0x00000000,0x00000000}},	//   _lhed, тоги, --, --, 
   {{0x63a814be,0xdef800ee,0x26d801c7,0x68e8007c}},	//   lzen, зың_, _ësou_, _ohed, 
   {{0x39580223,0x68e80076,0x6dbc00c7,0x60d400a2}},	//   _rprs_, _nhed, _ẽkõi, _ukym, 
   {{0x644c0086,0x1ec8013e,0xc0c00092,0x00000000}},	// [fc0] _ñaiu, _олии_, ቶአል_, --, 
   {{0x63a814bf,0x68e814c0,0xfce40032,0x7be80166}},	//   izen, _ahed, тоғо, _ıruı, 
   {{0x68e80a28,0x3eb814c1,0x63a80205,0x00000000}},	//   _bhed, mirt_, hzen, --, 
   {{0x68e814c2,0x38c814c3,0x26c40115,0x7794034c}},	//   _ched, راضی_, _ajlo_, هیزا, 
   {{0x68e814c4,0x63a80196,0x610000e2,0x3eb814c5}},	//   _dhed, jzen, _dēli, oirt_, 
   {{0x63a814c6,0x68e8120c,0xc6f400d4,0xc68c01f7}},	//   dzen, _ehed, вніх_, يِن_, 
   {{0xd9e410f7,0x68e80dc9,0x63a814c7,0xb5fc0003}},	//   _करित_, _fhed, ezen, _jaġi, 
   {{0x3eb814c8,0x68e80731,0x7afc14c9,0x73c414ca}},	//   hirt_, _ghed, _hirt, ләле, 
   {{0x44f4007b,0x3eb80205,0x63ac0432,0x63a814cb}},	//   خروج_, kirt_, _ýanl, gzen, 
   {{0x7afc14cc,0x07a014cd,0xd9e404fa,0x00000000}},	//   _jirt, _таун, _करात_, --, 
   {{0x63a814ce,0x7afc0839,0x00000000,0x00000000}},	//   azen, _mirt, --, --, 
   {{0xb5fc0327,0x22880030,0x68e80200,0x08ac0241}},	//   _naġi, _múky_, _xhed, _àìtó_, 
   {{0x63a814cf,0x7afc14d0,0x228800d0,0x4fc401af}},	//   czen, _oirt, _lúky_, тсна, 
   {{0x717414d1,0x7afc0254,0x3eb80f42,0xdd000205}},	//   _مهتا, _nirt, girt_, çuğu, 
   {{0xb5fc003d,0xc0bc02d3,0xdddc007f,0x00000000}},	//   _baġi, _ደጊም_, _lapņ, --, 
   {{0x7afc14d2,0x3eb80fa3,0x672c00da,0x2fc80218}},	//   _airt, airt_, šaji, _txag_, 
   {{0x68e800a9,0x7afc14d3,0x6b7414d4,0x3eb814d5}},	// [fd0] _rhed, _birt, ылау, birt_, 
   {{0x68e814d6,0x649400c6,0x7afc14d7,0x3eb800ae}},	//   _shed, _háit, _cirt, cirt_, 
   {{0x63a814d8,0x68e814d9,0x7afc14da,0x88c414db}},	//   zzen, _phed, _dirt, پتال, 
   {{0x63a8083a,0x7afc14dc,0x764800a2,0x8c640150}},	//   yzen, _eirt, _acdy, _جەرل_, 
   {{0x7afc14dd,0x6100005f,0x6494007b,0xe7380107}},	//   _firt, _vēli, _máit, хел_, 
   {{0xf77014de,0x64940491,0x4aa414df,0x68e814e0}},	//   غان_, _láit, _गतिव, _whed, 
   {{0x68e814e1,0x6fd402ab,0x6e2403b9,0xdd1006be}},	//   _thed, _युसू, _mehb, _müşv, 
   {{0x63a814e2,0x6e2414e3,0x7afc01c4,0x8af40213}},	//   tzen, _lehb, _zirt, _şəha, 
   {{0x7afc14e4,0x63a814e5,0x00000000,0x00000000}},	//   _yirt, uzen, --, --, 
   {{0x63a814e6,0x7afc01d9,0x6e24016d,0x9f4c003e}},	//   rzen, _xirt, _nehb, _énéh_, 
   {{0x63a814e7,0x60cc00c8,0x649400ae,0xe29814e8}},	//   szen, _ĉamb, _báit, _җай_, 
   {{0x237414e9,0x3eb80e78,0x649401e7,0x1fa8010b}},	//   _ماتح, wirt_, _cáit, екми_, 
   {{0x2b4c04e6,0xd12c0fa2,0x649400ae,0x6e2414ea}},	//   _äech_, يمی_, _dáit, _behb, 
   {{0x614414eb,0xb5fc0327,0xc0bc0023,0x9d44010b}},	//   _бека, _saġi, _ደጊመ_, легд, 
   {{0x6e24025c,0xd83c09a8,0xd24c143e,0x2d9414ec}},	//   _dehb, ščic_, _رني_, артс, 
   {{0x7afc14ed,0x33b00075,0x61000393,0xe72404d3}},	//   _sirt, _دەۋر, _cœle, _وڵ_, 
   {{0x7afc14ee,0x3eb802d3,0x6494007b,0xb5fc025c}},	// [fe0] _pirt, pirt_, _háis, _vaġi, 
   {{0x9a6814ef,0x6600020c,0x9e6414f0,0x7afc0014}},	//   عمال_, _nglk, _свод, _qirt, 
   {{0x7afc14f1,0xdddc005f,0xc0bc02d3,0x61ec0115}},	//   _virt, _sapņ, _ደጊሙ_, _ŝalj, 
   {{0x7afc14f2,0x98d814f3,0x649400c6,0xd82414f4}},	//   _wirt, رباز_, _máis, удди, 
   {{0x3ce014f5,0xf1b80327,0xd6d80022,0x00000000}},	//   mliv_, raġi_, нтк_, --, 
   {{0x7afc14f6,0x3ce00423,0x2d840158,0x05380092}},	//   _uirt, lliv_, åleg_, _አክራሪ, 
   {{0x64940491,0xd40414f7,0x39040022,0x63ac00a2}},	//   _náis, ляпи, _тҟеб, _ýanj, 
   {{0x93880120,0xb4c00037,0x6d4008c2,0x00000000}},	//   есоа_, ूके_, àlai, --, 
   {{0x64940597,0x00000000,0x00000000,0x00000000}},	//   _ráit, --, --, --, 
   {{0x61000270,0x73c40032,0x649400ae,0x518401ca}},	//   _lēlu, ләһе, _báis, гума, 
   {{0x6e2414f8,0x4ea40364,0xdd1000ac,0x649401e7}},	//   _rehb, ҳрва, _rüşv, _cáis, 
   {{0x93e4006c,0x6e2414f9,0x629c02d3,0x764403f9}},	//   _йўлл, _sehb, ësor, ɗiya, 
   {{0xe4380882,0x527414fa,0x00000000,0x00000000}},	//   āṇāṃ_, _ماغز, --, --, 
   {{0x4ea414fb,0x6e24014f,0x649414fc,0x644c00e4}},	//   урма, _qehb, _fáis, _ñair, 
   {{0x6e2414fd,0xc2c014fe,0x64940332,0x6e540092}},	//   _vehb, _ديوي, _táit, _ምዝገባ, 
   {{0x64940597,0x6e2414ff,0x3ce01500,0x61000171}},	//   _háir, _wehb, gliv_, _cēlu, 
   {{0x6e24016d,0x610000ef,0x80a400f1,0x00000000}},	// [ff0] _tehb, _dēlu, _دمين, --, 
   {{0xb5fc0124,0x29040066,0xd1dc0023,0xa3c80073}},	//   _haġu, _élak_, _ቓላት_, लॅट_, 
   {{0x649400c6,0xb5fc031c,0x281403c7,0x00000000}},	//   _máir, _kaġu, لواس, --, 
   {{0xb4c0038e,0xdddc0316,0x6494007b,0xa77400cf}},	//   ूको_, _např, _láir, илеч, 
   {{0xd3641501,0x2ca80597,0xfa2400eb,0x00000000}},	//   _به_, mhad_, _পারল_, --, 
   {{0xd1241502,0x6494007b,0x2ca80489,0x947001d9}},	//   _وم_, _náir, lhad_, ۪گلا, 
   {{0xe5a40075,0x00000000,0x00000000,0x00000000}},	//   рийи, --, --, --, 
   {{0x2ca80142,0x63ac010e,0x00000000,0x00000000}},	//   nhad_, _ýank, --, --, 
   {{0x6494007b,0xbd080055,0xe2c81503,0x2ca8015d}},	//   _báir, _kuũã, клид_, ihad_, 
   {{0x649400ae,0xe2980640,0x2ca80327,0xbb3c00df}},	//   _páis, тао_, hhad_, געזי, 
   {{0x2ca81504,0x20c402bf,0x6494007b,0x41cc085c}},	//   khad_, ийом, _dáir, _सुखस, 
   {{0x672c1505,0x64940077,0x3ce01506,0x24181507}},	//   šaju, _váis, xliv_, _роды_, 
   {{0x64581508,0xdee41180,0x248c01a6,0xfe780137}},	//   _ibwi, иоми, mjem_, гүп_, 
   {{0x2ca81509,0x649400ae,0xdddc0118,0x93100244}},	//   ehad_, _gáir, _zapř, _بووش, 
   {{0x2904150a,0x1d0800f7,0x69c00010,0xa0a40064}},	//   _élah_, теби_, _žlen, _вайд, 
   {{0x2ca8150b,0x98b8150c,0xa3c8150d,0x9f04150e}},	//   ghad_, kupā_, _ईशा_, _پودو, 
  
   {{0x2d84150f,0x64581510,0x3d1c01e1,0xe8a002d3}},	// [1000] äler_, _mbwi, _bàwò_, _ገምጋም_, 
   {{0x3ce01511,0x248c1512,0x8e800022,0x4aa41513}},	//   sliv_, hjem_, _дгье, акун_, 
   {{0x64581514,0x18681515,0x248c00cc,0x5ea407d6}},	//   _obwi, кажи_, kjem_, _ممکل, 
   {{0x248c038f,0x2ca80013,0x6fac0154,0x2138022e}},	//   jjem_, chad_, _টুয়ে, хshi_, 
   {{0x3d1c01e1,0x96640209,0x00000000,0x00000000}},	//   _fàwò_, икде, --, --, 
   {{0x64581516,0x610000ef,0xdef40023,0x248c0210}},	//   _abwi, _jēls, _ገዝኣ_, ejem_, 
   {{0x7cf801e4,0xf77000d1,0x780401f0,0x00000000}},	//   _aŭri, غاچ_, _лӯла, --, 
   {{0xd764066d,0x248c0240,0x649401e7,0xf2c4009d}},	//   _پارٹ, gjem_, _sáir, өөли, 
   {{0x64940491,0xb5fc003d,0x07a00064,0x796001e1}},	//   _páir, _raġu, _датн, bàwò, 
   {{0x64581517,0x82900372,0x2ca80156,0x00000000}},	//   _ebwi, يۇنچ, zhad_, --, 
   {{0x7cf80115,0x248c0219,0x6ecc000d,0x00000000}},	//   _eŭri, bjem_, _सदबु, --, 
   {{0x644c00c7,0xe60403b9,0x65b800db,0x2ca80200}},	//   _ñaip, _köşə, _суур_, xhad_, 
   {{0x64940491,0x00000000,0x00000000,0x00000000}},	//   _táir, --, --, --, 
   {{0x64940022,0x02d00345,0x00000000,0x00000000}},	//   _háip, _وتوخ, --, --, 
   {{0x2ca80192,0x6e940184,0xb5fc00e4,0x7094013d}},	//   thad_, _ғину, _taġu, _гайф, 
   {{0xf548044e,0x20d00077,0xbd44007b,0xacf80137}},	//   _ዘይኰነ, záiz_, تنفي, унбу_, 
   {{0x90a41518,0x2ca81519,0x3d1c01e1,0x4ee400c0}},	// [1010] _محکم, rhad_, _pàwò_, _вінз, 
   {{0x2ca8034c,0x00000000,0x00000000,0x00000000}},	//   shad_, --, --, --, 
   {{0xc864151a,0x248c00d7,0x00000000,0x00000000}},	//   итди, yjem_, --, --, 
   {{0xb8e80902,0x659400c7,0x00000000,0x00000000}},	//   афче_, ҩаду, --, --, 
   {{0x6d400436,0x248c0219,0x27e80267,0x3d1c0241}},	//   álaf, vjem_, åan_, _tàwò_, 
   {{0xe5a4151b,0xe6040213,0x27e800df,0xaa94007b}},	//   йили, _döşə, ĥan_, _الآث, 
   {{0x248c151c,0x27e802f0,0xb93400d8,0x00000000}},	//   tjem_, ťan_, _мерј, --, 
   {{0xdb4c0014,0x6494007b,0xd73c01ec,0x00000000}},	//   _تێے_, _cáip, _бiрд, --, 
   {{0x248c151d,0xa9a4151e,0x7de40210,0x41cc000d}},	//   rjem_, _тиңд, _गर्ग_, _सुजस, 
   {{0x248c0427,0x00000000,0x00000000,0x00000000}},	//   sjem_, --, --, --, 
   {{0x64580175,0x248c0010,0xfa98010f,0x63b400c7}},	//   _tbwi, pjem_, ידזש_, шәҧх, 
   {{0x6458151f,0x00000000,0x00000000,0x00000000}},	//   _ubwi, --, --, --, 
   {{0x64481520,0xe3740137,0x00000000,0x00000000}},	//   mgei, _ылды, --, --, 
   {{0x64481521,0xdc340139,0x64a4030d,0x00000000}},	//   lgei, _bäğd, _каçа, --, 
   {{0xd9e40037,0x1dd00a8a,0xb928002b,0x00000000}},	//   _करइत_, _दुखत, bhuṃ_, --, 
   {{0x64481522,0xede401e0,0x63ac00a2,0xdca40395}},	//   ngei, өһөҙ_, _žany, щаби, 
   {{0x1be8013e,0x64481523,0xbd4401d9,0x5ac80798}},	// [1020] удаи_, igei, _ژھرى, глам_, 
   {{0x64480097,0x00000000,0x00000000,0x00000000}},	//   hgei, --, --, --, 
   {{0xd8380323,0x6448017a,0xceb0008f,0x00000000}},	//   гэл_, kgei, _מיז_, --, 
   {{0x63ac010b,0x1784004e,0x8f500345,0x00000000}},	//   _ýanw, йгем, _بنیش, --, 
   {{0xb8d01524,0x19300023,0x97540114,0x50d8010f}},	//   _ओत_, _ኣፍጋኒ, стељ, נקנא, 
   {{0x22bc1525,0x6d400d12,0x00000000,0x00000000}},	//   yňka_, álag, --, --, 
   {{0x649400c6,0x7d1c020c,0x74a800ee,0x64481526}},	//   _páip, nprs, исиң_, fgei, 
   {{0x7338016c,0x644800d4,0x6d401527,0x00000000}},	//   азир_, ggei, šlag, --, 
   {{0x4c9800df,0x00000000,0x00000000,0x00000000}},	//   טשקע, --, --, --, 
   {{0x64481528,0x926801c6,0x00000000,0x00000000}},	//   agei, уриа_, --, --, 
   {{0x86780302,0x64480334,0xd4d40006,0xdb0402d2}},	//   _תרבו, bgei, _лідэ, _ómæg, 
   {{0x7d1c0122,0x27e8012d,0x00000000,0x00000000}},	//   dprs, żane_, --, --, 
   {{0xdc340166,0x00000000,0x00000000,0x00000000}},	//   _säğd, --, --, --, 
   {{0x2c74063f,0x52b00137,0xc7b0011a,0x00000000}},	//   _ụd_, _رەجئ, לבר_, --, 
   {{0x2cb81529,0x7094152a,0x6100005f,0xdc340166}},	//   _pmsd_, _макф, _vēlr, _qäğd, 
   {{0xdc340166,0x6ad000cd,0x00000000,0x00000000}},	//   _väğd, तक्र, --, --, 
   {{0x3a380048,0x4054152b,0x1ea800f1,0xdc3400fd}},	// [1030] _bdrp_, _رئيس, _چاپي_, _wäğd, 
   {{0xff5000c6,0x6f1c01f5,0x64480399,0x705401d3}},	//   _أخي_, mpsc, zgei, _اچھا, 
   {{0x6d4008de,0x7c5804da,0x6f1c00a3,0x6448152c}},	//   álad, شلەر_, lpsc, ygei, 
   {{0x6d54002f,0x6f1c0064,0x00000000,0x00000000}},	//   mtza, opsc, --, --, 
   {{0x6d54152d,0x644807de,0x645400e5,0x00000000}},	//   ltza, vgei, őzik, --, 
   {{0x6d54152e,0x89f8152f,0x7ac4026b,0x00000000}},	//   otza, _معزز_, _ессе, --, 
   {{0x6d54152d,0x64481530,0x3b640014,0x00000000}},	//   ntza, tgei, _وێہہ, --, 
   {{0x6d5405f5,0x67d41531,0x60cc0115,0xe5a40131}},	//   itza, _добу, _ĉamo, йиһи, 
   {{0x1cb00dd4,0xc6481532,0xc538001f,0x66640014}},	//   ྐྲི_, _مجال_, _አይችሉ, _وُرٕ, 
   {{0xadf81533,0x27ec05f5,0x64481534,0x21f8084c}},	//   ंधान_, _izen_, sgei, ихнэ_, 
   {{0x20881535,0x6f1c01f5,0x00000000,0x00000000}},	//   айни_, epsc, --, --, 
   {{0x34941536,0x74b800c0,0x00000000,0x00000000}},	//   _нахр, _луіс_, --, --, 
   {{0x23280108,0x00000000,0x00000000,0x00000000}},	//   _толи_, --, --, --, 
   {{0x71241537,0x6b8c005a,0x61ec01e4,0x6d541538}},	//   _کرول, dxag, _ŝalu, ftza, 
   {{0x7a400248,0xc0d400d1,0x00000000,0x00000000}},	//   _látà, ﻟﯟﻩﺗ, --, --, 
   {{0x27ec1539,0x6fd4012c,0x00000000,0x00000000}},	//   _ozen_, _युकू, --, --, 
   {{0x6d5405f5,0x765c008c,0x7d1c08a4,0x6b8c153a}},	// [1040] atza, _öryg, sprs, gxag, 
   {{0x63ac00a2,0x00000000,0x00000000,0x00000000}},	//   _ýanu, --, --, --, 
   {{0x656001d4,0x27ec153b,0x7ca80092,0x92040055}},	//   _nplh, _azen_, _መፈለግ_, _upāũ, 
   {{0x7a400ca8,0xf984013e,0x00000000,0x00000000}},	//   _bátà, оҳҳо, --, --, 
   {{0x9a8401e0,0x9058011a,0x00000000,0x00000000}},	//   _һуңл, שכנת, --, --, 
   {{0x6560003e,0x27ec153c,0x66cc0419,0x00000000}},	//   _bplh, _dzen_, tĺka, --, 
   {{0x98a4153d,0x27ec153e,0x09e00131,0x1868153f}},	//   _диве, _ezen_, _жорн, _кави_, 
   {{0x2c000327,0x00000000,0x00000000,0x00000000}},	//   _མུཉྩ_, --, --, --, 
   {{0xb9e81540,0xccf00bd4,0xe8e81541,0x00000000}},	//   _ሮሜ_, וכה_, _طرفو_, --, 
   {{0x32540108,0x610000ef,0x00000000,0x00000000}},	//   чвор, _sēlp, --, --, 
   {{0x52a802e5,0x95c400f1,0x00000000,0x00000000}},	//   _छतीस, _بياه, --, --, 
   {{0xe4640790,0x00000000,0x00000000,0x00000000}},	//   _çöpe_, --, --, --, 
   {{0xf31401c0,0x6b8c0429,0x61ec00df,0x88ac00cc}},	//   _эдлэ, xxag, _ŝalt, _কদমক, 
   {{0x6f1c01a4,0x6d54002f,0x00000000,0x00000000}},	//   rpsc, ttza, --, --, 
   {{0x6d54009d,0x6f1c007c,0x00000000,0x00000000}},	//   utza, spsc, --, --, 
   {{0x6d540323,0x6f1c1542,0x8538008d,0xfa24015b}},	//   rtza, ppsc, יגלי, _পাগল_, 
   {{0x6d541543,0x6d4006ea,0x00000000,0x00000000}},	// [1050] stza, álab, --, --, 
   {{0xdb2401b9,0x528000d1,0x8d84014b,0x00000000}},	//   سومی, _ﺩﯦﯖﯩ, _думд, --, 
   {{0x888004fb,0x6f0c1544,0x27ec1545,0xeb9801e0}},	//   ویسن, _huac, _szen_, шиҡ_, 
   {{0x6f0c05d9,0xdddc03e0,0x53c81546,0x00000000}},	//   _kuac, _hapş, ापाश, --, 
   {{0x0a680640,0xdddc0205,0x807c00df,0x00000000}},	//   _крви_, _kapş, ינאצ, --, 
   {{0xe6101547,0x6f0c001e,0x6f04047e,0xa5081548}},	//   رشت_, _muac, _jihc, бека_, 
   {{0x6f0c1549,0x00000000,0x00000000,0x00000000}},	//   _luac, --, --, --, 
   {{0x27ec01c6,0x2b48030a,0xd1cc0023,0x22480116}},	//   _tzen_, ouac_, ቦነት_, әпни_, 
   {{0x6f0c0491,0x69c00010,0x27ec154a,0x4668011c}},	//   _nuac, _žleh, _uzen_, _врем_, 
   {{0xf770154b,0x672801c8,0x6f04154c,0x7eb0002f}},	//   _جاف_, _iwej, _nihc, _zäpf, 
   {{0x6728154d,0x2168154e,0x2b48154f,0x63041550}},	//   _hwej, щини_, huac_, _کوتل, 
   {{0x67281551,0x6f0c1552,0xf4680092,0x00000000}},	//   _kwej, _buac, ዲቀርብ_, --, 
   {{0x337401c6,0x00000000,0x00000000,0x00000000}},	//   _огцр, --, --, --, 
   {{0x6f040399,0x6f0c0092,0x67280083,0xc444006c}},	//   _cihc, _duac, _mwej, _ایکن_, 
   {{0x67280117,0x6f0c003a,0x21a401c0,0x91e01553}},	//   _lwej, _euac, _хийм, _поше, 
   {{0x5f74027a,0x6728054c,0x6f0c1554,0x236c033f}},	//   _فاخر, _owej, _fuac, owej_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1060] --, --, --, --, 
   {{0x6d400491,0x6f040399,0x0f7808a8,0x99980166}},	//   álac, _gihc, _פריל, gapş_, 
   {{0x58841555,0x236c0477,0x1ea80451,0xdc6801c4}},	//   зыла, hwej_, _ناھي_, _ланд_, 
   {{0x67281556,0x3f8001e4,0x00000000,0x00000000}},	//   _bwej, _kriu_, --, --, 
   {{0x7c241557,0xebb80882,0x6f04009a,0xc7a00b59}},	//   mbir, teḥ_, _yihc, ницк, 
   {{0x7c241558,0x6728025c,0x75280175,0xd65c02dd}},	//   lbir, _dwej, _pwdz, _мiнд, 
   {{0x7c241559,0x00000000,0x00000000,0x00000000}},	//   obir, --, --, --, 
   {{0x7c24155a,0x6728031c,0x49380375,0xe3b8002d}},	//   nbir, _fwej, _לגלו, rbűn_, 
   {{0x7c240e14,0x12e4155b,0x00000000,0x00000000}},	//   ibir, зінг, --, --, 
   {{0x0bb40375,0x6f0c155c,0x7c24155d,0x1d340023}},	//   פלים_, _ruac, hbir, _ክግንዘ, 
   {{0x3f80155e,0x6f0c0051,0x00000000,0x00000000}},	//   _ariu_, _suac, --, --, 
   {{0x3f80068c,0x6b8803b2,0xd0a80107,0xb64802dd}},	//   _briu_, _áegg, стод_, _ﻋﻨ_, 
   {{0x7c24155f,0x6f0c1560,0x3f801561,0x6728031c}},	//   dbir, _quac, _criu_, _xwej, 
   {{0x3f800a73,0x6f04014f,0x6f0c0051,0xdcec00b8}},	//   _driu_, _qihc, _vuac, _ījān, 
   {{0xa2d81562,0x51841563,0x6f04047e,0x6c8400f1}},	//   नकर्, _хула, _vihc, ولسم, 
   {{0xfd7405f5,0x6f0c1564,0x2b48005a,0xdddc00a2}},	//   элсэ, _tuac, tuac_, _wapş, 
   {{0xdddc1565,0x3f801566,0x7864007f,0x6f04014f}},	// [1070] _tapş, _griu_, _mčvč, _tihc, 
   {{0x7c241567,0x0dc81568,0x67281569,0x00000000}},	//   abir, _гуми_, _rwej, --, 
   {{0x7c24156a,0x7eb000a2,0x67280327,0xad4000f7}},	//   bbir, _däpd, _swej, _جۉزۉ, 
   {{0x7c2403e0,0xec34010f,0x00000000,0x00000000}},	//   cbir, _קאָר_, --, --, 
   {{0x3b64156b,0xe738156c,0x66cc0419,0x00000000}},	//   _първ, цел_, bĺkl, --, 
   {{0x0a680798,0x00000000,0x00000000,0x00000000}},	//   _урми_, --, --, --, 
   {{0x5550156d,0xdaa0075e,0x00000000,0x00000000}},	//   نپور, _جەلپ, --, --, 
   {{0x672804ba,0x3fbc00d1,0x236c0210,0x00000000}},	//   _twej, ﻧﻼﺭﻧ, twej_, --, 
   {{0x7eb0023a,0xe3b8156e,0x00000000,0x00000000}},	//   _häpe, юби_, --, --, 
   {{0x21a40131,0x236c0de2,0x7eb001f4,0x00000000}},	//   диом, rwej_, _käpe, --, 
   {{0x7c24156f,0xa0680276,0x854411ca,0xe1f001b9}},	//   ybir, оана_, _хэзе, کسک_, 
   {{0x3f801570,0x7eb001b8,0x7c241571,0xa878008f}},	//   _priu_, _mäpe, xbir, קאָר, 
   {{0x2d800055,0x7f04010b,0x7eb01572,0x13a80345}},	//   _arhe_, нҗид, _läpe, _ونمی_, 
   {{0xf3f40831,0x442c1573,0x76941574,0x1d081575}},	//   _яңы_, _heg_, _bàyy, жеви_, 
   {{0x442c1576,0x386002ce,0xaf3404d3,0x7eb01577}},	//   _keg_, ŵiri_, ووێژ, _näpe, 
   {{0x442c1578,0x7c240a49,0x3cf8033f,0xa3e00073}},	//   _jeg_, ubir, ंगें_, _धडा_, 
   {{0x442c1579,0x7c24157a,0x88d0009e,0x5f44004b}},	// [1080] _meg_, rbir, ়তাক, _غندل, 
   {{0x7c24157b,0x4a4003b7,0xda64157c,0x00000000}},	//   sbir, кнув, باري, --, 
   {{0x9984157d,0x2d800055,0x442c0254,0x00000000}},	//   بلاو, _grhe_, _oeg_, --, 
   {{0x442c157e,0x6b8801a6,0x28a402dd,0x7c24157f}},	//   _neg_, _šege, ншіг, qbir, 
   {{0x69d41580,0x3c4800f1,0x158c00d1,0x27e8025c}},	//   _exze, _وګړی_, _ﻛﯧﺴﯩ, żann_, 
   {{0x442c1581,0x3cf00024,0xa3e00210,0x00000000}},	//   _aeg_, šovė_, _धड़_, --, 
   {{0x442c1582,0x98541086,0x8a00004e,0x00000000}},	//   _beg_, _оташ, _азре, --, 
   {{0x442c0070,0x33741583,0xc4f400db,0x06800304}},	//   _ceg_, егир, وعيا_, егән, 
   {{0x442c1584,0x92681585,0xd24400ee,0x1670014b}},	//   _deg_, орна_, мэни, _ақлр, 
   {{0x39580218,0xc5a400b2,0x46441586,0x442c1587}},	//   _kqrs_, _ڪڏهن_, _озун_, _eeg_, 
   {{0x70541473,0x442c1588,0x00000000,0x00000000}},	//   ىندا, _feg_, --, --, 
   {{0xc5a400b2,0x442c1589,0x3cf8033f,0x312400cf}},	//   _تڏهن_, _geg_, ंगों_, мдүг, 
   {{0xcee8158a,0x9f4c01e1,0x00000000,0x00000000}},	//   قرآن_, _ńfò_, --, --, 
   {{0x442c0cf9,0x8d74158b,0x2d800010,0x00000000}},	//   _zeg_, وازا, _prhe_, --, 
   {{0x442c158c,0x00000000,0x00000000,0x00000000}},	//   _yeg_, --, --, --, 
   {{0x442c0175,0x7eb00108,0x00000000,0x00000000}},	//   _xeg_, _räpe, --, --, 
   {{0x3eb40118,0x6af400d8,0x00000000,0x00000000}},	// [1090] _šatů_, езаф, --, --, 
   {{0x7eb00793,0x76940de2,0xe73800ee,0x271c00eb}},	//   _päpe, _tàyy, җек_, _নিলো_, 
   {{0x2d800004,0xab6c001f,0x6e34022e,0x14dc00bc}},	//   _urhe_, ስተዋል_, mazb, मवाण, 
   {{0x1cb0025c,0x6e3401a6,0xf990007b,0xab9400f3}},	//   ྐྲད_, lazb, جبك_, _замљ, 
   {{0x442c158d,0xfeb804fb,0x2ca805b1,0xcb44010a}},	//   _reg_, _رایت_, mkad_, _юхни, 
   {{0x442c158e,0x2ca801e3,0xa50800c0,0xdb24158f}},	//   _seg_, lkad_, пека_, _سوفی, 
   {{0x442c1590,0x26c81591,0xc5e400eb,0xe45000ae}},	//   _peg_, đao_, গেনা_, هضة_, 
   {{0x2ca81592,0xb8f400eb,0x00000000,0x00000000}},	//   nkad_, _সী_, --, --, 
   {{0x442c1593,0x29101594,0xe3b000c6,0x6e3401c4}},	//   _veg_, _huza_, طرة_, kazb, 
   {{0x442c1595,0x29101596,0x7538003e,0x65941597}},	//   _weg_, _kuza_, bsvz, _пазу, 
   {{0x442c1598,0x2ca81599,0x2910159a,0x80dc000d}},	//   _teg_, kkad_, _juza_, नवले, 
   {{0x442c004e,0x2ca801e3,0x00000000,0x00000000}},	//   _ueg_, jkad_, --, --, 
   {{0xc00003f4,0x2ca8079b,0x6d40159b,0x2910159c}},	//   ূর্ণ_, dkad_, álan, _luza_, 
   {{0x5398159d,0x29100100,0xabd80150,0x00000000}},	//   _מינו, _ouza_, _ﺃﺼﻘﺎ, --, 
   {{0xd24c159e,0x29100223,0x427802d3,0x2ca8007f}},	//   _انى_, _nuza_, _እሙናት_, fkad_, 
   {{0xfe780024,0x00000000,0x00000000,0x00000000}},	//   žį_, --, --, --, 
   {{0x60c4159f,0xcb6415a0,0xdca415a1,0x00000000}},	// [10a0] mikm, нате_, _ҷани, --, 
   {{0x291015a2,0x38c006be,0x8c4003e0,0x00000000}},	//   _buza_, _içrə_, ışab, --, 
   {{0xdca415a3,0x291015a4,0x8e5400d9,0xb8e400f1}},	//   _зани, _cuza_, _אייג_, نګره, 
   {{0x60c415a5,0x2ca8049f,0x99880118,0x1cb80066}},	//   nikm, ckad_, _webů_, _راجب_, 
   {{0x6100003a,0x481000d4,0xab6c0092,0x00000000}},	//   _cœli, уміс, ስተውል_, --, 
   {{0x29100099,0x7e7c05be,0x60c40986,0x00000000}},	//   _fuza_, ndrp, hikm, --, 
   {{0x291007f5,0x55040276,0x00000000,0x00000000}},	//   _guza_, нчиа, --, --, 
   {{0x09e015a6,0x60c415a7,0x20d00135,0x73c40352}},	//   _сосн, jikm, wġin_, кәле, 
   {{0x291015a8,0xc68c01d3,0xe70805a9,0xb7940345}},	//   _zuza_, _گِل_, ستۇن_, _جڤات, 
   {{0xdb080066,0x291015a9,0x4b78011a,0x00000000}},	//   ènèh, _yuza_, לאפו, --, 
   {{0x60c415aa,0xc68c0a81,0xd46815ab,0xefd402d3}},	//   fikm, _دِل_, _ниже_, ከይድ_, 
   {{0x60c415ac,0x25a00112,0x00000000,0x00000000}},	//   gikm, ähle_, --, --, 
   {{0x6e3401c4,0x62200137,0x00000000,0x00000000}},	//   tazb, دۉۉل, --, --, 
   {{0xc0000c58,0x00000000,0x00000000,0x00000000}},	//   ূৰ্ণ_, --, --, --, 
   {{0x6e3415ad,0xc2780302,0x60c415ae,0xad240075}},	//   razb, _מרגי, bikm, ئىرى, 
   {{0x291015af,0x60c4029f,0x20d00327,0x6fb415b0}},	//   _ruza_, cikm, nġil_, _لمبا, 
   {{0x2910098d,0x2ca815b1,0x7bc015b2,0x7f840592}},	// [10b0] _suza_, rkad_, _žmur, _ملين, 
   {{0x2ca815b3,0xed500014,0x6e3403b9,0x00000000}},	//   skad_, _پھس_, qazb, --, 
   {{0xba74021f,0xe8580024,0x00000000,0x00000000}},	//   داقت, даеш_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7eb000b0,0xe694034b,0x973015b4,0x00000000}},	//   _häpa, киды, لکلا, --, 
   {{0x60c415b5,0x291015b6,0x7eb00037,0xe570007b}},	//   zikm, _tuza_, _käpa, لطب_, 
   {{0x60c415b7,0x00000000,0x00000000,0x00000000}},	//   yikm, --, --, --, 
   {{0x38c801c0,0x00000000,0x00000000,0x00000000}},	//   _зуун_, --, --, --, 
   {{0x7eb00037,0x00000000,0x00000000,0x00000000}},	//   _läpa, --, --, --, 
   {{0x2b480129,0xf65000ec,0x6ecc06e3,0x00000000}},	//   irac_, _هئم_, _सदगु, --, 
   {{0x60c415b8,0x7eb00254,0x00000000,0x00000000}},	//   tikm, _näpa, --, --, 
   {{0x2b4815b9,0x622000d1,0x00000000,0x00000000}},	//   krac_, _ھۈجە, --, --, 
   {{0x2bdc01d9,0x60c415ba,0x3f840316,0x6d4002f0}},	//   _मडगा, rikm, ímu_, šlal, 
   {{0x60c415bb,0x2b4815bc,0xc32c0014,0x3af40254}},	//   sikm, drac_, _نٕچ_, käpa_, 
   {{0x60c402e2,0x5c5415bd,0xda700050,0x00000000}},	//   pikm, ктаф, یُر_, --, 
   {{0x9f8400c7,0x8c4015be,0x5cf40212,0xdcb015bf}},	//   _агид, иесе, тягу, جىر_, 
   {{0x25b80213,0x2b4815c0,0x00000000,0x00000000}},	// [10c0] _əsla_, grac_, --, --, 
   {{0x0f34008f,0x00000000,0x00000000,0x00000000}},	//   _שריט_, --, --, --, 
   {{0x386415c1,0x9d380134,0x8c380112,0x00000000}},	//   _pbmr_, _ɛyɛɛ_, _soße, --, 
   {{0xdca415c2,0x8d7415c3,0x2b4815c4,0xc3240011}},	//   _рами, _شاپا, brac_, _মিনি_, 
   {{0x2b48003a,0x81b40154,0xdb0800ae,0x00000000}},	//   crac_, চপি_, únói, --, 
   {{0xad240345,0x00000000,0x00000000,0x00000000}},	//   _جریو, --, --, --, 
   {{0xceb0025f,0x60d400e4,0xd94400f0,0x46a000d8}},	//   שיו_, _ojym, _јеби, рајв, 
   {{0x3804014b,0x14c800c7,0x00000000,0x00000000}},	//   _бобҳ, ьыли_, --, --, 
   {{0xf9f40154,0x833001c6,0x00000000,0x00000000}},	//   _জলিল_, аных, --, --, 
   {{0x73c40184,0x78a0047e,0x60d400a2,0x00000000}},	//   кәһе, _homv, _ajym, --, 
   {{0x78a015c5,0xc1b401c6,0x00000000,0x00000000}},	//   _komv, влэх_, --, --, 
   {{0x934415c6,0x823002d3,0x660c0882,0x2b480129}},	//   _анде, _ጻዕርታ, śakt, yrac_, 
   {{0x78a002ce,0x628c0332,0xddcc00c0,0x00000000}},	//   _momv, ánoí, bebū, --, 
   {{0x78a015c7,0x2b48067c,0x00000000,0x00000000}},	//   _lomv, vrac_, --, --, 
   {{0x2d840914,0x2b480067,0x60dc007f,0x00000000}},	//   íle_, wrac_, ōsma, --, 
   {{0x78a00944,0x60d40023,0x2b4815c8,0x00000000}},	//   _nomv, _gjym, trac_, --, 
   {{0x6100003a,0x80a415c9,0x09c800dc,0x00000000}},	// [10d0] _cœlu, _خمين, ऽप्य, --, 
   {{0x7eb015ca,0x2b4815cb,0x9408016b,0x6144129d}},	//   _täpa, rrac_, ɔbɔ_, _شىۋە, 
   {{0x78a015cc,0x1af00154,0x00000000,0x00000000}},	//   _bomv, _অংশে_, --, --, 
   {{0x78a00491,0xa52400d1,0xdd9000ec,0x3af40022}},	//   _comv, қмид, _اوٽ_, räpa_, 
   {{0x78a015cd,0x46300124,0x00000000,0x00000000}},	//   _domv, иҭар, --, --, 
   {{0xc9840022,0xf624009f,0x3af40139,0x00000000}},	//   _иуби, لّهُ, läpn_, --, 
   {{0x090400c7,0x3af40309,0xa2e415ce,0xe568009d}},	//   _ачам, qäpa_, ғонд, хийд_, 
   {{0x57b015cf,0xb88400db,0x00000000,0x00000000}},	//   рбәт, _кууй, --, --, 
   {{0x68e815d0,0xa0a415d1,0x386000a3,0x363400db}},	//   _iked, ҳанд, òire_, ارۇس, 
   {{0x27ec15d2,0x78a015d3,0x625815d4,0x00000000}},	//   _iyen_, _zomv, хрир_, --, 
   {{0xa0a415d5,0x245415d6,0x68e80083,0x27ec15d7}},	//   ганд, _مناس, _kked, _hyen_, 
   {{0xe3b80108,0x00000000,0x00000000,0x00000000}},	//   _плеч_, --, --, --, 
   {{0x6458009a,0x27ec007f,0x934403cc,0x64a40022}},	//   _icwi, _jyen_, _مىنۇ, _иаҧа, 
   {{0x290c01ee,0x63a815d8,0x27ec15d9,0x00000000}},	//   _liea_, myen, _myen_, --, 
   {{0xdef815da,0x27ec15db,0x68e815dc,0x925414b7}},	//   дың_, _lyen_, _oked, _сајт_, 
   {{0x290c0069,0x27ec0789,0x68e801e1,0x7c2400c7}},	//   _niea_, _oyen_, _nked, рзаҧ, 
   {{0x27ec15dd,0x78a003cd,0x6458045a,0x7b840116}},	// [10e0] _nyen_, _romv, _mcwi, جازە, 
   {{0x290c0b45,0x78a015de,0x68e815df,0xf8ac15e0}},	//   _aiea_, _somv, _aked, चस्प, 
   {{0x7eb002b5,0x27ec02e2,0x78a00161,0x63a80097}},	//   _häpo, _ayen_, _pomv, hyen, 
   {{0xd7f815e1,0x27ec15e2,0x26c40407,0xeaf807a7}},	//   нул_, _byen_, _amlo_, ىرەت_, 
   {{0x63a815e3,0x96e815e4,0x78a00165,0x97c4008e}},	//   jyen, нька_, _vomv, ыйде, 
   {{0x68e815e5,0x27ec002d,0x78a015e6,0x00000000}},	//   _eked, _dyen_, _womv, --, 
   {{0x1c1c0d79,0x00000000,0x00000000,0x00000000}},	//   युअल_, --, --, --, 
   {{0x27ec15e7,0x00000000,0x00000000,0x00000000}},	//   _fyen_, --, --, --, 
   {{0x63a815e8,0x82f405d9,0x939415e9,0x80e000eb}},	//   gyen, گريز_, اجعا, নগঞ্, 
   {{0x64580042,0x201000e5,0x37e4022e,0x00000000}},	//   _ecwi, _agyi_, _боғг, --, 
   {{0x63a8017a,0x68e802d0,0x82f401e2,0x461001e2}},	//   ayen, _yked, دريز_, _اومر, 
   {{0x63a815ea,0x7a4800e2,0x6fb415eb,0x20d0031c}},	//   byen, lītē, لمجا, nġih_, 
   {{0x63a81423,0x4fc415ec,0xb3d40032,0x32e00432}},	//   cyen, усна, _әйҙә, _açyş_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xccf815ed,0x626415ee,0x7eb000c5,0x8c6415ef}},	//   ећа_, _خانق, _täpn, лтад, 
   {{0x7b640daf,0x61f415f0,0x27e815f1,0x953c0092}},	//   әтте, üzle, żani_, _አይነተ, 
   {{0x7afc01ab,0xfce815f2,0xed5001d9,0x00000000}},	// [10f0] _bhrt, افقي_, _ژھر_, --, 
   {{0x68e815f3,0x290c0032,0x27ec15f4,0x7afc0306}},	//   _sked, _siea_, _ryen_, _chrt, 
   {{0x63a815f5,0x7afc0ba7,0xe94415f6,0x27ec0100}},	//   zyen, _dhrt, شرای, _syen_, 
   {{0x27ec007f,0x7afc002f,0x39e8010b,0x2bdc012d}},	//   _pyen_, _ehrt, уьун_, _यशपा, 
   {{0x68e80254,0xae180037,0x00000000,0x00000000}},	//   _vked, _दलान_, --, --, 
   {{0x63a815f7,0x893415f8,0x27ec02e2,0xdd0c013d}},	//   vyen, _معرا, _vyen_, _kışn, 
   {{0x290c15f9,0x63a8017a,0x00000000,0x00000000}},	//   _tiea_, wyen, --, --, 
   {{0x63a815fa,0x68e815fb,0x9f480200,0x00000000}},	//   tyen, _uked, çkës_, --, 
   {{0xe2980598,0x27ec004d,0x6d4000d7,0x00000000}},	//   вап_, _uyen_, šlah, --, 
   {{0x63a815fc,0x26c401e2,0x52a4023a,0xf77003c7}},	//   ryen, _umlo_, ивым_, _عاق_, 
   {{0x63a815fd,0x7eb015fe,0xa3e001f9,0x200c0248}},	//   syen, _däpl, _धडक_, _ńfi_, 
   {{0x63a815ff,0x6458014b,0x60dc007f,0xd598011a}},	//   pyen, _ucwi, čsmo, _בבעל, 
   {{0x2d841600,0x63a80200,0x7798010a,0x98bc0055}},	//   ælen_, qyen, _укăр_, _ūtī_, 
   {{0x27e80209,0x7eb00139,0xe2c81601,0xe29810fc}},	//   ýany_, _gäpl, _جوتو_, _јак_, 
   {{0x7a400008,0x9c580139,0x00000000,0x00000000}},	//   hátí, кшау_, --, --, 
   {{0xdddc02b5,0xdca401b9,0x16d000dc,0x9c241602}},	//   _hapū, шаби, _तद्ब, рдад, 
   {{0x9b441603,0x7a401604,0x2c000574,0x5b34084c}},	// [1100] شناو, játí, लेलं_, рэбу, 
   {{0x62801605,0xcb641606,0x2ee0084d,0x00000000}},	//   ndlo, рафе_, पकृत, --, 
   {{0x2d840a64,0x81e409bd,0x00000000,0x00000000}},	//   ålet_, _মৃত_, --, --, 
   {{0x57a41607,0x62800142,0x25e80456,0x00000000}},	//   ишла, hdlo, _छड़ी_, --, 
   {{0xd7041608,0x00000000,0x00000000,0x00000000}},	//   азди, --, --, --, 
   {{0x7d041609,0x63ac0209,0x62800d27,0xdddc0055}},	//   lmis, _ýany, jdlo, _napū, 
   {{0xc81c0020,0x0570075e,0x6280160a,0x7d041577}},	//   ስትመን, قايد, ddlo, omis, 
   {{0x48e0160b,0x6d4000c6,0x3a38160c,0x99980374}},	//   _досв, álai, _herp_, hapū_, 
   {{0x7d04160d,0x999804fe,0x7eb00793,0xf48403e6}},	//   imis, kapū_, _päpl, لاکی, 
   {{0x6d40143f,0x7d04160e,0x628001f5,0x5184160f}},	//   šlai, hmis, gdlo, аума, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62801610,0xae1805d7,0xd0181086,0x324401e0}},	//   adlo, _दलहन_, ъфо_, шеүг, 
   {{0x7d04007d,0x7eb01611,0x00000000,0x00000000}},	//   dmis, _täpl, --, --, 
   {{0xb8f803bd,0x7d041612,0x00000000,0x00000000}},	//   _ོམ_, emis, --, --, 
   {{0x02f804ae,0x7d04005c,0xdd0c0139,0x00000000}},	//   _שלומ, fmis, _qışn, --, 
   {{0x7d041613,0xb0341614,0xf004014b,0x00000000}},	//   gmis, _униш, _гӯги, --, 
   {{0x80240014,0xf07800c7,0xcee8006c,0x00000000}},	// [1110] _بر٘م, _аиқә_, _لردن_, --, 
   {{0x7d04049b,0xe84002d3,0x2d8401bf,0xc9840124}},	//   amis, _ከምዘሎ, åles_, иуеи, 
   {{0xacb400aa,0x3a3809b1,0x7d041615,0x76580175}},	//   _همدغ, _derp_, bmis, dgvy, 
   {{0x6d541616,0x7f841617,0x620400ac,0xf68801d3}},	//   muza, _الین, ürlə, یننٹ_, 
   {{0x3cf410f7,0x7bd80365,0x386001ab,0x6280015d}},	//   ंतरे_, şvur, òira_, ydlo, 
   {{0x36c400d4,0x00000000,0x00000000,0x00000000}},	//   обіг, --, --, --, 
   {{0x20d00038,0x98580882,0x6d54036e,0xf9d40209}},	//   lšie_, ṇāt_, nuza, _дорэ, 
   {{0x6f1c074d,0x3a3801a6,0x21681618,0xdddc1619}},	//   kqsc, _zerp_, қими_, _sapū, 
   {{0x6d54161a,0xc32404c5,0x20d00030,0x158c0131}},	//   huza, _মিহি_, nšie_, _ﻛﯧﺘﯩ, 
   {{0x6d54161b,0x62800280,0x66e80107,0x00000000}},	//   kuza, udlo, _субҳ_, --, 
   {{0x6280161c,0x7d04161d,0x20d001f1,0xe5f4161e}},	//   rdlo, ymis, hšie_, _اكاد, 
   {{0x6d54161f,0x34941620,0x2418023a,0x20d000d7}},	//   duza, _махр, _соды_, kšie_, 
   {{0x20d00038,0xa0a41621,0xdfd01622,0x25600429}},	//   jšie_, _ҳайд, سيس_, lól_, 
   {{0x6d541623,0x20d000d0,0xb37001d9,0x00000000}},	//   fuza, dšie_, _کۯیش, --, 
   {{0x7d04033d,0xa0a41624,0x6d541625,0x25601626}},	//   tmis, _гайд, guza, nól_, 
   {{0x3a381627,0x7d041628,0x00000000,0x00000000}},	//   _serp_, umis, --, --, 
   {{0x2d841477,0x4a000327,0x5e6000cf,0x00000000}},	// [1120] åler_, _མཛུལ_, _ىچسە, --, 
   {{0x7f440d04,0x6d541629,0x7d1c0175,0xd1f40023}},	//   _iviq, buza, pqrs, ለውቲ_, 
   {{0x5d840597,0xd238008f,0x25600321,0x7d04162a}},	//   _الجل, רגעל, jól_, pmis, 
   {{0x3a380926,0x2560011f,0x20d000d0,0x82f40327}},	//   _werp_, dól_, bšie_, _པེའུ_, 
   {{0x3a380b21,0x6da402a8,0x6d400bcd,0x69d80112}},	//   _terp_, nɗan, álav, ßwer, 
   {{0x6da403f9,0x7eb0010e,0x00000000,0x00000000}},	//   iɗan, _säpj, --, --, 
   {{0x237c0ac5,0xaadc0574,0x6d400153,0xed6c0092}},	//   _aswj_, _मदतक, šlav, _ሴክተር_, 
   {{0x38c80345,0x00000000,0x00000000,0x00000000}},	//   _ئاسی_, --, --, --, 
   {{0x6d54162b,0xd628014b,0x00000000,0x00000000}},	//   zuza, _бозе_, --, --, 
   {{0x2560066d,0x273c02ea,0x6d54162c,0x53e40022}},	//   ból_, _wâná_, yuza, ицҿа, 
   {{0x76480cfd,0x201c00bc,0x2560007b,0x4a98010f}},	//   _iddy, ětin_, cól_, אייג, 
   {{0x9f50011f,0x65b8004e,0x09f4011a,0x00000000}},	//   _iyyê_, _туур_, ממים_, --, 
   {{0x6d54162d,0x73c400fb,0x00000000,0x00000000}},	//   wuza, _фәйе, --, --, 
   {{0x6d54162e,0x20d001a2,0x12180006,0xd1b80372}},	//   tuza, všie_, _сюды_, _ماعا_, 
   {{0xf15801c0,0x55f400eb,0x00000000,0x00000000}},	//   _тийш_, _চলুক_, --, --, 
   {{0x6d54162f,0x853800c8,0x20d000d0,0x4ba4004e}},	//   ruza, טגלי, tšie_, бөгү_, 
   {{0x76481630,0x7b141631,0x3174012d,0x4ee40064}},	// [1130] _oddy, здух, ńczę_, _гінз, 
   {{0x6d540230,0x70541632,0x20d001f1,0x00000000}},	//   puza, _انکا, ršie_, --, 
   {{0x25600429,0x6e9400f1,0xe9781633,0xfeb8007b}},	//   xól_, _هلکا, рбеш_, _دايت_, 
   {{0x76480cfd,0x6d441634,0x20d001a2,0x00000000}},	//   _addy, _ivha, pšie_, --, 
   {{0x65601635,0x752800e2,0x2cb80f85,0x2560007f}},	//   _sqlh, _atdz, _ilsd_, wól_, 
   {{0xf7701636,0x2560066d,0xc3240729,0x7f3c008f}},	//   عان_, tól_, _মিলি_, נעוו, 
   {{0x79a40046,0x0ba80137,0x00000000,0x00000000}},	//   _ерте, _شاڭى_, --, --, 
   {{0x25601637,0x76480731,0x09bc0154,0x00000000}},	//   ról_, _eddy, _আশপা, --, 
   {{0xc10405f5,0x87d80014,0x8c38002f,0x6304009a}},	//   үүлл, _صبرس_, _roßl, يوبل, 
   {{0x67280003,0xc6d401d3,0x00000000,0x00000000}},	//   _itej, _اترت, --, --, 
   {{0x21681638,0xe0d81639,0xa0c41541,0x2a300023}},	//   шини_, иво_, قيدو, _ብኢትዮ, 
   {{0x237c0457,0x6728025c,0x98b40135,0x00000000}},	//   _tswj_, _ktej, ġgħu_, --, 
   {{0x443c163a,0xe298163b,0x67280135,0xd12c01d9}},	//   mau_, _вал_, _jtej, _یمو_, 
   {{0x443c163c,0x6728163d,0x6304163e,0x7eb00254}},	//   lau_, _mtej, _بوتل, _käpi, 
   {{0xa0a4163f,0xde0402dd,0x443c0076,0x00000000}},	//   _макд, іпби, oau_, --, 
   {{0x1b4800cf,0x00000000,0x00000000,0x00000000}},	//   изби_, --, --, --, 
   {{0x6d441640,0x67281641,0x7eb002f6,0x443c0c1f}},	// [1140] _evha, _ntej, _läpi, iau_, 
   {{0x443c1642,0xe8c4038f,0x3f801132,0x1e3400db}},	//   hau_, _གཏུག, _isiu_, _بةةج, 
   {{0x443c1643,0xdca41644,0x67281645,0x6d401646}},	//   kau_, _дани, _atej, álat, 
   {{0x18681647,0x443c1648,0x4524031c,0xa3b80d79}},	//   ради_, jau_, _ལྕེར_, घना_, 
   {{0x443c1649,0xd708164a,0x473002bf,0x7c24164b}},	//   dau_, анде_, дніс, mcir, 
   {{0x443c164c,0xdddc1165,0x00000000,0x00000000}},	//   eau_, _japů, --, --, 
   {{0x443c164d,0x672801f2,0x7c24011c,0x00000000}},	//   fau_, _etej, ocir, --, 
   {{0x443c164e,0x7c24164f,0x00000000,0x00000000}},	//   gau_, ncir, --, --, 
   {{0x7c2401a6,0x25b803e3,0xa8a400ae,0x00000000}},	//   icir, _əsli_, _عصفو, --, 
   {{0x443c0421,0xe7d4006c,0x76481650,0x67440118}},	//   aau_, _عملگ, _uddy, řují, 
   {{0x443c1651,0x69c01652,0x3f801653,0x8af80a1e}},	//   bau_, _žlez, _asiu_, שהיי, 
   {{0xa0200205,0x7c2400d7,0x00000000,0x00000000}},	//   _çöla, jcir, --, --, 
   {{0x7c241654,0x64d8008f,0xbfa81655,0xbf3412e7}},	//   dcir, _פֿעס, отре_, мнящ, 
   {{0x69c00254,0x00000000,0x00000000,0x00000000}},	//   _üleg, --, --, --, 
   {{0xac940cc9,0x7db4007b,0xccc80798,0x00000000}},	//   павш, وصفا, аѓал_, --, 
   {{0x6d4400b5,0x00000000,0x00000000,0x00000000}},	//   _vvha, --, --, --, 
   {{0x1ea800ec,0x3b640395,0x00000000,0x00000000}},	// [1150] _ڇاپي_, дъхв, --, --, 
   {{0x443c1656,0x6384013c,0xba9802bf,0x6d401657}},	//   zau_, lîná, овує_, álas, 
   {{0x443c1658,0x6728038e,0x20d001f1,0x2cb80204}},	//   yau_, _stej, lšia_, _tlsd_, 
   {{0x2d801659,0x5d7800c8,0x443c165a,0x7eb0165b}},	//   _ishe_, _פארק, xau_, _räpi, 
   {{0x443c165c,0x7b64165d,0x8b64165e,0x20d000d0}},	//   vau_, _отре, _باجم, nšia_, 
   {{0x443c165f,0x3ddc0183,0x00000000,0x00000000}},	//   wau_, _ধৰিল, --, --, 
   {{0x443c1660,0x20d00030,0xeaf8012c,0xe5780c60}},	//   tau_, hšia_, ्गीत_, ёзи_, 
   {{0x443c0ef0,0x67280135,0x38c8009d,0x00000000}},	//   uau_, _ttej, _дуун_, --, 
   {{0x443c1661,0x20d001f1,0x67281662,0x00000000}},	//   rau_, jšia_, _utej, --, 
   {{0x443c1663,0x7eb01664,0x20d000d0,0x00000000}},	//   sau_, _täpi, dšia_, --, 
   {{0x443c1665,0xc0e8001f,0x69c01666,0x00000000}},	//   pau_, _መማር_, _üled, --, 
   {{0x443c0286,0xe0d800d8,0x00000000,0x00000000}},	//   qau_, свм_, --, --, 
   {{0x2d801667,0xa29400d6,0x7c241668,0xf3801669}},	//   _ashe_, _наді, vcir, _ағым, 
   {{0xca34166a,0x2260012d,0x00000000,0x00000000}},	//   _koʝu_, órkę_, --, --, 
   {{0x7c2401f5,0xe29801af,0x59740092,0x00000000}},	//   tcir, _ваһ_, _ጽሁፎች_, --, 
   {{0xa0a40022,0x0d8001c6,0x20d00419,0x6c74009d}},	//   _хаид, элсн, bšia_, муух, 
   {{0x6d4008a7,0x5f44166b,0x2d80036e,0x9058011a}},	// [1160] álar, _عندل, _eshe_, _הכפת, 
   {{0x7c24166c,0xca8001c6,0xaae40472,0x2bdc166d}},	//   scir, нгуй, وسلو, _यशरा, 
   {{0xca340069,0x7c240327,0x00000000,0x00000000}},	//   _noʝu_, pcir, --, --, 
   {{0x76440b45,0x00000000,0x00000000,0x00000000}},	//   ɗiyy, --, --, --, 
   {{0x6b8801a6,0x8d9001d5,0x00000000,0x00000000}},	//   _šegv, _قلیش, --, --, 
   {{0xd9440372,0x3ca40ed1,0x7bc4166e,0x00000000}},	//   _неги, ﺎﻳﺴﻰ_, mziu, --, 
   {{0x09e0166f,0xfa2c0327,0x7bc4002f,0x00000000}},	//   _зорн, _ཧྥརན_, lziu, --, 
   {{0x89d80375,0x603c037e,0x00000000,0x00000000}},	//   _החלי, _ｇmai, --, --, 
   {{0x7bc41670,0x00000000,0x00000000,0x00000000}},	//   nziu, --, --, --, 
   {{0x7eb0000d,0x20d000d0,0x00000000,0x00000000}},	//   _käpu, všia_, --, --, 
   {{0x70541671,0x00000000,0x00000000,0x00000000}},	//   وندا, --, --, --, 
   {{0x69c000c5,0x85980375,0x53a400d8,0x20d000d0}},	//   _ülee, _לשבו, _наеб, tšia_, 
   {{0x70ac0073,0x00000000,0x00000000,0x00000000}},	//   _चवील, --, --, --, 
   {{0x20d01672,0x00000000,0x00000000,0x00000000}},	//   ršia_, --, --, --, 
   {{0x7eb000af,0x1aac00fe,0x7bc40153,0x00000000}},	//   _näpu, ছোৱা, eziu, --, 
   {{0x20d00030,0x66140419,0x00000000,0x00000000}},	//   pšia_, _úzke, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1170] --, --, --, --, 
   {{0x2d801673,0x6da40198,0x00000000,0x00000000}},	//   _tshe_, nɗak, --, --, 
   {{0x7bc4060a,0x2d80006f,0xfc3001d3,0x00000000}},	//   aziu, _ushe_, ئحہ_, --, 
   {{0x6d541674,0x00000000,0x00000000,0x00000000}},	//   mrza, --, --, --, 
   {{0x7bc41675,0x2cf80490,0x0b8806ed,0x99600118}},	//   cziu, ंतील_, _усни_, _míře_, 
   {{0x6b8c0796,0x6d541676,0xe61000f2,0x00000000}},	//   mvag, orza, پشت_, --, 
   {{0x56901677,0x6b8c1678,0xe57800d4,0x00000000}},	//   тајт, lvag, ізи_, --, 
   {{0xe3b81679,0x6adc0d2c,0x88800214,0x850000d1}},	//   жби_, _मदुर, _سیتن, رۈشن, 
   {{0x69c4167a,0x6b8c167b,0x6d54167c,0xa3b81291}},	//   lzhe, nvag, hrza, تاثر_, 
   {{0x6b8c0d04,0x69c40200,0x00000000,0x00000000}},	//   ivag, ozhe, --, --, 
   {{0x69c4167d,0x6d540034,0x7bc408e5,0xf8c400cd}},	//   nzhe, jrza, zziu, लोकय, 
   {{0x6d541505,0x9424167e,0x69c40489,0x7eb00254}},	//   drza, _قومۇ, izhe, _läpt, 
   {{0x6d54033f,0x9960013a,0xf434004e,0x4fa0167f}},	//   erza, _díře_, _чечэ, вияв, 
   {{0xe29800a8,0x71241680,0x7bc40023,0x128801e2}},	//   _фак_, بریل, vziu, _ومنی_, 
   {{0x6b8c1681,0x6d54012d,0xa068030d,0xe3f801f7}},	//   evag, grza, _дайа_, _اوڇڻ_, 
   {{0x69c41682,0x7bc41683,0xa2d41684,0xeff80023}},	//   dzhe, tziu, यचक्, ለይዎ_, 
   {{0xcb641685,0x69c40dd4,0x09a80eac,0x6b8c1686}},	// [1180] мате_, ezhe, _গেলা, gvag, 
   {{0x9f500589,0x7bc41687,0x7eb00793,0x0f540375}},	//   _czyå_, rziu, _päpu, _קיים_, 
   {{0x58841688,0x6b8c1689,0x7bc404cc,0x9f940588}},	//   дыла, avag, sziu, _хықә, 
   {{0x7e7c0af5,0x7bc41570,0x00000000,0x00000000}},	//   lerp, pziu, --, --, 
   {{0x69c405c7,0x6b8c00ef,0x00000000,0x00000000}},	//   azhe, cvag, --, --, 
   {{0x7e7c0af5,0x07a0026a,0xca80022e,0x20d000c0}},	//   nerp, таљн, еrеn, kšio_, 
   {{0x7e7c168a,0xe97001ec,0x20d00010,0x00000000}},	//   ierp, _مۇلد, všin_, --, 
   {{0x7e7c168b,0xe464062d,0x00000000,0x00000000}},	//   herp, _çöle_, --, --, 
   {{0x46e400fd,0xfa2c0327,0x20c000ae,0x16640114}},	//   ядән_, _ཧྥོན_, _móid_, _овам, 
   {{0xeb9000c8,0x7e7c168c,0xd2580108,0x00000000}},	//   אָט_, jerp, цци_, --, 
   {{0x20d00301,0x6b8c0810,0xca540a7c,0x7eb00108}},	//   ršin_, zvag, וייז_, _läps, 
   {{0x3b180309,0x049000c6,0x20c001e7,0x00000000}},	//   _lirq_, _للمح, _nóid_, --, 
   {{0x8260168d,0x7e7c168e,0x20d000f3,0x7eb001f4}},	//   رهێن, ferp, pšin_, _näps, 
   {{0x7e7c168f,0xdcfc00bc,0x6d541690,0x20d00784}},	//   gerp, _trpě, trza, qšin_, 
   {{0x7eb00793,0x6d541691,0x41c00014,0xfa2c0327}},	//   _räpt, urza, _لٲوِ, _ཧྥེན_, 
   {{0x20c000c6,0x20d002f0,0x8f6400e5,0x00000000}},	//   _cóid_, nšil_, _قلعے_, --, 
   {{0x6b8c1692,0x69c40369,0x8d980092,0xfa3401d5}},	// [1190] uvag, wzhe, ገላቸው_, چرمد, 
   {{0x6b8c1693,0x3b1804cc,0x32c001e1,0x69c40112}},	//   rvag, _cirq_, _fòye_, tzhe, 
   {{0x6b8c1694,0x6ab401e4,0xe854007b,0xf3880051}},	//   svag, _ĉefĵ, فناد, _lợ_, 
   {{0x69c40dd4,0x23b40248,0x4c8001b9,0x807c010f}},	//   rzhe, _jùjú_, _جیرق, ַנוצ, 
   {{0xe7381695,0xf3880016,0x7eb00139,0x69c400e5}},	//   чел_, _nợ_, _täpt, szhe, 
   {{0xdddc1696,0x66041697,0xbb481698,0x99980050}},	//   _hapš, нпла, _زلفن_, _کپٲر_, 
   {{0x4920016c,0xe5701699,0xdddc0064,0x00000000}},	//   _рӯзҳ, اطت_, _kapš, --, 
   {{0x63840124,0x7e7c169a,0x233414a8,0xf3880208}},	//   егиа, zerp, нхор, _bợ_, 
   {{0x7e7c030d,0x4680169b,0x2b4806af,0x4db800cc}},	//   yerp, _ақла, nsac_, _উখোৱ, 
   {{0x1304169c,0x261802ab,0x7e7c009d,0x45a000db}},	//   нный_, _पलटी_, xerp, _لەتك, 
   {{0xd12c169d,0xe1f802d5,0x00000000,0x00000000}},	//   یمی_, яго_, --, --, 
   {{0xa0a40657,0xd36c0214,0x7eb001f4,0x00000000}},	//   хамд, جهی_, _näpr, --, 
   {{0x7e7c169e,0xfd4c0241,0x645c004e,0x20c00332}},	//   terp, _fonọ, òsiu, _róid_, 
   {{0xdcb00ed1,0x7e7c0e78,0x7eb0005b,0x20c00332}},	//   گىر_, uerp, _räps, _sóid_, 
   {{0x7e7c169f,0x224400b5,0x7eb001f4,0xf3880051}},	//   rerp, malk_, _säps, _zợ_, 
   {{0xdcb016a0,0x7e7c16a1,0xd12c16a2,0xa0c400e3}},	//   دىر_, serp, _امي_, _سيخو, 
   {{0x3b18047e,0xfa2c031c,0x6b8816a3,0x9b0416a4}},	// [11a0] _pirq_, _ཧྥུན_, _šegr, езад, 
   {{0x3b1816a5,0x7e7c16a6,0xab780092,0x22440010}},	//   _qirq_, qerp, _የያዘው_, nalk_, 
   {{0x2d84005c,0x2bd40037,0xcee00150,0x00000000}},	//   ælet_, _ठेठा, _сұрқ, --, 
   {{0x7eb0007d,0x224416a7,0x0d8016a8,0x20d008a4}},	//   _täps, halk_, _слюн, kšim_, 
   {{0x2b4816a9,0x20d0151c,0xb7d80451,0xb8d80037}},	//   csac_, jšim_, ڻوڪا_, _छव_, 
   {{0x09bc015b,0xf3880208,0x224416aa,0xd5140241}},	//   _আশরা, _rợ_, jalk_, _ọ̀d, 
   {{0xf3880016,0xceb00375,0xd6c407d6,0xaa640139}},	//   _sợ_, ריו_, ومچی, _шерһ, 
   {{0xd3a416ab,0x69c000c5,0x3374013e,0x00000000}},	//   ероп, _ülea, вгир, --, 
   {{0x850016ac,0x20d002f0,0x00000000,0x00000000}},	//   دوين, ršil_, --, --, 
   {{0xf38807ae,0x00000000,0x00000000,0x00000000}},	//   _vợ_, --, --, --, 
   {{0x20d002fb,0xf48416ad,0x25a00112,0xfbe400cc}},	//   pšil_, _لاشی, ählt_, _মৰমত, 
   {{0x6adc16ae,0x20d00010,0x2b480076,0x00000000}},	//   _मद्र, bšim_, ysac_, --, 
   {{0x73c416af,0x22440373,0xb4cc10fa,0x60d4007f}},	//   _шәке, balk_, रफी_, èzma, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7eb0014a,0x20c00332,0xe2a80330,0x441001af}},	//   _päpr, _dóib_, _تانن_, _ифәт, 
   {{0xfaa401b9,0xd78800cd,0x00000000,0x00000000}},	//   қшун, _oṃ_, --, --, 
   {{0xdddc01a6,0xafc401e0,0x3c580276,0x00000000}},	// [11b0] _vapš, _рәнй, эитэ_, --, 
   {{0x2d8401bf,0x00000000,0x00000000,0x00000000}},	//   æles_, --, --, --, 
   {{0x2b4816b0,0xd788002b,0xb4b00073,0xdddc00e2}},	//   ssac_, _aṃ_, _ऐकू_, _tapš, 
   {{0x48cc00bd,0xf9680276,0x22440010,0x28140472}},	//   িক্র, эруй_, zalk_, نواس, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69d40574,0x20d008a4,0x2ca800af,0x6120063f}},	//   _येथी, všim_, ljad_, ịlit, 
   {{0xd6cc00cf,0x224416b1,0xfa2c031c,0xe5a40075}},	//   تقو_, valk_, _ཧྥིན_, тийи, 
   {{0x224416b2,0x7eb016b3,0x3af40267,0x2ca80427}},	//   walk_, _läpp, läpp_, njad_, 
   {{0x224416b4,0xe3b00597,0x69d40490,0xd76402dd}},	//   talk_, شرة_, _येती, _لەنى_, 
   {{0x7eb016b5,0x2ca816b6,0xf7700a0a,0x3af40254}},	//   _näpp, hjad_, _داف_, näpp_, 
   {{0xb38405f5,0x22440427,0x1fb812eb,0xd7000024}},	//   влөл, ralk_, उन्ड, _лiта, 
   {{0x2ca816b7,0x20d007f5,0x645c0005,0x3af40036}},	//   jjad_, pšim_, ósid, häpp_, 
   {{0x248c16b8,0x2ca816b9,0x224416ba,0xe28416bb}},	//   mdem_, djad_, palk_, _алли, 
   {{0x248c16bc,0xe194022e,0x236c012d,0x00000000}},	//   ldem_, _ариэ, mtej_, --, 
   {{0x20c00332,0x236c016d,0xdd90007b,0x00000000}},	//   _cóic_, ltej_, جوز_, --, 
   {{0x248c16bd,0xa3e4121d,0x1fb416be,0x2ca803b2}},	//   ndem_, _नशा_, _асор, gjad_, 
   {{0x248c16bf,0x0c2016c0,0x236c0070,0x5a6416c1}},	// [11c0] idem_, рмун, ntej_, ккаб, 
   {{0x248c16c2,0x1d2416c3,0x3ce00218,0x2ca800c5}},	//   hdem_, _имом, sniv_, ajad_, 
   {{0x2ca80327,0x00000000,0x00000000,0x00000000}},	//   bjad_, --, --, --, 
   {{0xd7f816c4,0x248c16c5,0x236c036e,0x00000000}},	//   мул_, jdem_, ktej_, --, 
   {{0x248c16c6,0x69c000c5,0x569002dd,0x00000000}},	//   ddem_, _ülen, ғақт, --, 
   {{0x248c003d,0x7ccc16c7,0xf6280137,0x00000000}},	//   edem_, rşru, رتتۇ_, --, 
   {{0x248c003a,0xd944009b,0xa2c40303,0x00000000}},	//   fdem_, _шеви, िसन्, --, 
   {{0x09e001c0,0x248c15b7,0x00000000,0x00000000}},	//   _тосн, gdem_, --, --, 
   {{0x2c6c00dd,0xb9ec0023,0x53e402e8,0xd7880055}},	//   lódó_, _ኔራ_, ъцка, _uṃ_, 
   {{0x857416c8,0x248c16c9,0x20d00010,0x00000000}},	//   хсәт_, adem_, lših_, --, 
   {{0x154406ed,0x7eb016ca,0x4a5800d9,0x236c0419}},	//   _реем, _räpp, ודיו, atej_, 
   {{0xc5a416cb,0x236c0455,0xa5d8010f,0xef6401c6}},	//   _جڏهن_, btej_, _אַני, лэгү, 
   {{0x35a81533,0x2ca809a8,0x00000000,0x00000000}},	//   _कपड़, vjad_, --, --, 
   {{0x7a48005f,0xb6e00327,0x2ca8058a,0x00000000}},	//   nūtē, _སམྦྷ, wjad_, --, 
   {{0x9104044c,0x2ca800af,0x20d0110c,0x8c640fca}},	//   _ичид, tjad_, kših_, ктад, 
   {{0x20d00fb7,0x2d84013c,0x0214011a,0x6fb416cc}},	//   jših_, æleq_, _בחום_, _ممبا, 
   {{0x2ca816cd,0x7eb016ce,0x0a6800c7,0xe68c0139}},	// [11d0] rjad_, _täpp, дреи_, _ürçü, 
   {{0x2ca800c5,0x248c16cf,0x2d840327,0x00000000}},	//   sjad_, zdem_, ħleb_, --, 
   {{0x29d400db,0x2ca80254,0x7ff416d0,0xe9b4035b}},	//   دياس, pjad_, _مسیا, ыбжь, 
   {{0xcc8404d3,0xa214010f,0x00000000,0x00000000}},	//   _جۆره_, אַנס_, --, --, 
   {{0x27e80a9d,0x20c00120,0xa2c416d1,0x3af40036}},	//   çan_, _jóia_, िसम्, päpp_, 
   {{0x69c00037,0x236c16d2,0x27e8025c,0x26c00022}},	//   _üleo, vtej_, ħan_, óho_, 
   {{0x248c03fa,0x20d00219,0x24f401c0,0x00000000}},	//   tdem_, bših_, лчир, --, 
   {{0xdb1c0122,0x248c16d3,0xdcfc054e,0x386000a3}},	//   _švéd, udem_, _ispă, òirt_, 
   {{0x248c16d4,0x20c00798,0xe2b4009d,0x00000000}},	//   rdem_, _nóia_, гснэ, --, 
   {{0xf77016d5,0x248c0483,0x6d5804fe,0x236c16d6}},	//   _گاہ_, sdem_, _āwan, rtej_, 
   {{0x236c16d7,0xe47416d8,0x00000000,0x00000000}},	//   stej_, _булэ, --, --, 
   {{0xd5b800c8,0xf77001d9,0x20c00798,0x236c16d9}},	//   _אזעל, _داہ_, _bóia_, ptej_, 
   {{0x64480069,0x442c05da,0x2c6c00e5,0x00000000}},	//   maei, _ifg_, zódó_, --, 
   {{0x35d805f9,0x66f416da,0x644816db,0xdcfc054e}},	//   _भेड़, ेतिक_, laei, _ospă, 
   {{0x5de40801,0x68e801e4,0xdc980354,0xf1a800f2}},	//   ужва, _ĉedn, нташ_, _لايه_, 
   {{0x644816dc,0x27e8012d,0x7e640022,0xdb84004e}},	//   naei, żany_, ыхҭҵ, лгби, 
   {{0x20d008a4,0x442c16dd,0xda580e58,0xe3b801d3}},	// [11e0] vših_, _mfg_, ереш_, nyű_, 
   {{0x7bc00cc1,0x644816de,0x1e8416df,0xb4b001ad}},	//   _ümum, haei, _слом, _ऐक्_, 
   {{0x5f7416e0,0x69c016e1,0x628016e2,0x1ce4031c}},	//   _شاکر, _ülel, ielo, ྫོད_, 
   {{0x628016e3,0x5ca416e4,0x2bd40574,0x57e816e5}},	//   helo, _симб, _ठेवा, ндем_, 
   {{0x38c816e6,0x628016e7,0x644816b8,0x20d00427}},	//   _یاری_, kelo, daei, rših_, 
   {{0x628016e8,0x442c07d6,0x69c007f7,0x00000000}},	//   jelo, _afg_, लनशी, --, 
   {{0x628016e9,0x6da40198,0x60d40124,0xcad40115}},	//   delo, lɗar, _omym, _עולת_, 
   {{0x442c16ea,0x628016eb,0x550400fd,0x1ae401d5}},	//   _cfg_, eelo, ычла, _роҳм, 
   {{0x628016ec,0xb4e406e3,0xe3b800e5,0x00000000}},	//   felo, _नदी_, gyű_, --, 
   {{0x628016ed,0x644816ee,0x037416ef,0x00000000}},	//   gelo, aaei, احيت_, --, 
   {{0x442c002d,0xc1b405f5,0x645c04d4,0x6448003a}},	//   _ffg_, глэх_, ósic, baei, 
   {{0x628000fb,0x942400db,0x1304008e,0x6604002f}},	//   aelo, _смде, _өзем, ühke, 
   {{0xb4c016f0,0xba00001f,0x00000000,0x00000000}},	//   ँसी_, _ቁጭ_, --, --, 
   {{0x94000451,0x63bc05ac,0x1db00073,0x8d8401d5}},	//   _پوڙه, øsne, ीनंत, лубд, 
   {{0xb7fc04c5,0x3dd8009e,0xf17003e6,0xc6b4011a}},	//   েশিত_, _দুবল, _بێجگ, נהלי_, 
   {{0xd13c0092,0x28b800bc,0x00000000,0x00000000}},	//   ካባቢው, _आवधि, --, --, 
   {{0x4bd804fb,0x00000000,0x00000000,0x00000000}},	// [11f0] ربرد_, --, --, --, 
   {{0x6e9400cf,0x00000000,0x00000000,0x00000000}},	//   _ئلدا, --, --, --, 
   {{0xad8400d1,0x20c001e7,0xa2c400dc,0x00000000}},	//   _ئاخۇ, _móin_, िसत्, --, 
   {{0xac9416f1,0x628016f2,0x69c016f3,0x20c000ae}},	//   _тамш, zelo, _ülem, _lóin_, 
   {{0x644816f4,0x4920013e,0x499016f5,0x05b80214}},	//   vaei, рӯҳҳ, _گیار, کدشت_, 
   {{0x628016f6,0x9ba002de,0x20c00332,0x00000000}},	//   xelo, _بەكى, _nóin_, --, 
   {{0x628016f7,0x4990168d,0x644816f8,0xb4c00037}},	//   velo, _دیار, taei, ँसू_, 
   {{0x628016f9,0x57b00075,0xe3b801d3,0x38a400d8}},	//   welo, сбәт, tyű_, _лјуб, 
   {{0x628016fa,0x644816fb,0x290c16fc,0x38341142}},	//   telo, raei, _ihea_, _ынтр, 
   {{0x27ec004e,0x673800b5,0x6280017a,0x68e816fd}},	//   _ixen_, mpwj, uelo, _hjed, 
   {{0x26c416fe,0x628016ff,0x68e81700,0x64481701}},	//   _illo_, relo, _kjed, paei, 
   {{0x62801702,0x442c1703,0x6b040327,0x00000000}},	//   selo, _ufg_, _མེའོ_, --, 
   {{0x628016ec,0x68e802d3,0x5f041704,0x20c0007b}},	//   pelo, _mjed, изма, _fóin_, 
   {{0x68e8045f,0x290c062c,0x6280011f,0xfbd0134e}},	//   _ljed, _lhea_, qelo, _सेगम, 
   {{0x68e81705,0x63a80077,0x290c01c4,0xadc401e0}},	//   _ojed, lxen, _ohea_, барһ, 
   {{0x63a81706,0x68e81707,0x290c0332,0x60d400a2}},	//   oxen, _njed, _nhea_, _umym, 
   {{0x63a81708,0x26c41709,0xdee4170a,0x69c000af}},	// [1200] nxen, _ollo_, _вопи, _ülej, 
   {{0x290c170b,0x63a8170c,0x68e8170d,0x19940640}},	//   _ahea_, ixen, _ajed, ијер, 
   {{0x290c01a6,0x68e801a6,0x59840352,0x00000000}},	//   _bhea_, _bjed, рлеб, --, 
   {{0x26c4170e,0x290c170f,0x7f44004b,0x68e81710}},	//   _allo_, _chea_, _kwiq, _cjed, 
   {{0x68e81711,0x290c01e7,0x90740a7c,0x00000000}},	//   _djed, _dhea_, שענא_, --, 
   {{0x68e81712,0x290c02b5,0x00000000,0x00000000}},	//   _ejed, _ehea_, --, --, 
   {{0x68e8037e,0x290c1713,0x20d00030,0x09e001c0}},	//   _fjed, _fhea_, lšiu_, _дорн, 
   {{0x26c41714,0x5fa40574,0xb4c01715,0x68e81716}},	//   _ello_, खमाल, ँसे_, _gjed, 
   {{0x63a81717,0xa5080131,0xd1d4010c,0x20d000d0}},	//   gxen, دىيە_, ርደት_, nšiu_, 
   {{0x68e81718,0x0634001f,0x00000000,0x00000000}},	//   _zjed, ከናወነ, --, --, 
   {{0xd7f81719,0x20d000d0,0x37b800cc,0x59c40b02}},	//   _чуң_, hšiu_, _অধিৰ, लनिर, 
   {{0x7648171a,0xefe8001f,0x2f880022,0x4fc4009d}},	//   _hedy, _መላው_, гәон_, асга, 
   {{0x7528171b,0xdc2c03be,0x7648171c,0x20d001f1}},	//   _hudz, _sığo, _kedy, jšiu_, 
   {{0x7528171d,0x7648068f,0x7b1003fa,0xfbcc0154}},	//   _kudz, _jedy, läuf, লপাত, 
   {{0x7528171e,0x42500244,0x412400f3,0x00000000}},	//   _judz, _بۆپر, _којо_, --, 
   {{0x7528171f,0x76481720,0x00000000,0x00000000}},	//   _mudz, _ledy, --, --, 
   {{0x75281721,0x7f44014b,0x68e81722,0x00000000}},	// [1210] _ludz, _gwiq, _rjed, --, 
   {{0x68e81723,0x69c000af,0x75280099,0x76480214}},	//   _sjed, _ülek, _oudz, _nedy, 
   {{0xc8a806bb,0x290c01ee,0x6e2402d0,0x7b100112}},	//   къде_, _phea_, _ighb, käuf, 
   {{0x2cac0037,0x20d000d7,0xb4c000bc,0x00000000}},	//   _õed_, bšiu_, ँसो_, --, 
   {{0x290c06d6,0x68e8044e,0x75281724,0x764803cb}},	//   _vhea_, _vjed, _audz, _bedy, 
   {{0x75281725,0x290c04fe,0x20d000f3,0x76481726}},	//   _budz, _whea_, lšit_, _cedy, 
   {{0x68e81727,0x76481728,0x290c1729,0x7528172a}},	//   _tjed, _dedy, _thea_, _cudz, 
   {{0x68e81326,0x7528172b,0x7648172c,0x63a8172d}},	//   _ujed, _dudz, _eedy, txen, 
   {{0x6e24047e,0xe2980209,0x82600131,0x7648015d}},	//   _oghb, гап_, قۇشن, _fedy, 
   {{0x63a8172e,0x6d4414dc,0x68f8172f,0x26c41730}},	//   rxen, _owha, lowd, _ullo_, 
   {{0x75281731,0xd24c1732,0x67280200,0x6024009d}},	//   _gudz, ژنی_, _huej, йдна, 
   {{0x67201733,0x6e240477,0xf4841734,0x76481735}},	//   _hilj, _aghb, _мучн, _zedy, 
   {{0x443c1736,0x6d441737,0x67201738,0x66001739}},	//   mbu_, _awha, _kilj, _hylk, 
   {{0x443c173a,0x6d440280,0x7528173b,0x6600023a}},	//   lbu_, _bwha, _yudz, _kylk, 
   {{0x2d94173c,0xdca4173d,0xdafc0589,0x91e0173e}},	//   ортс, бави, pãºl, _ноше, 
   {{0x6720173f,0x443c1740,0x6e24016d,0x5c240154}},	//   _lilj, nbu_, _eghb, বর্গ_, 
   {{0x6d4400b0,0x68f81741,0x67280153,0xdd940150}},	// [1220] _ewha, dowd, _nuej, шаңы, 
   {{0x443c006c,0x6ab40369,0x9e641742,0x20d013aa}},	//   hbu_, _cozf, _увод, ršiu_, 
   {{0x76481743,0x6d440142,0x68f8058a,0x443c025c}},	//   _redy, _gwha, fowd, kbu_, 
   {{0x75281744,0x76481745,0xad240014,0x443c0003}},	//   _rudz, _sedy, _گریو, jbu_, 
   {{0x7d041746,0x75280dc7,0x764805b8,0x8b6400d1}},	//   mlis, _sudz, _pedy, _лияв_, 
   {{0x7d041747,0x6600002d,0x75281748,0x645c148b}},	//   llis, _bylk, _pudz, ósin, 
   {{0x7d041749,0x6720174a,0x7648174b,0x75280810}},	//   olis, _dilj, _vedy, _qudz, 
   {{0x7d04174c,0x764800a9,0x443c05db,0x3f800356}},	//   nlis, _wedy, gbu_, _opiu_, 
   {{0x672800c7,0x67200327,0x57e8023a,0x00000000}},	//   _guej, _filj, _сдам_, --, 
   {{0x7d04174d,0x6600174e,0x6720174f,0x7648020c}},	//   hlis, _fylk, _gilj, _uedy, 
   {{0x443c1750,0x8af805e1,0x75280810,0x5228001f}},	//   bbu_, רהיי, _uudz, _ተናግሯ, 
   {{0x7d041751,0x443c1752,0x7b100112,0x67201753}},	//   jlis, cbu_, bäug, _zilj, 
   {{0x7d041754,0x7eb00108,0x00000000,0x00000000}},	//   dlis, _häpy, --, --, 
   {{0x7d041755,0x7eb0005b,0x660000a2,0xdcfc0055}},	//   elis, _käpy, _yylk, _āvād, 
   {{0x7d041756,0x1cb0025c,0x799c0175,0x6ab402f0}},	//   flis, _དྭང_, _nrrw, _rozf, 
   {{0x7058004e,0x69c00037,0xc0e400f3,0x00000000}},	//   _таир_, _ülei, _нојк, --, 
   {{0xcee81757,0x7eb001f4,0x00000000,0x00000000}},	// [1230] _مردن_, _läpy, --, --, 
   {{0x443c1758,0x6e24014f,0x6728036e,0x0dc80117}},	//   zbu_, _ughb, _ruej, _буми_, 
   {{0x7d041759,0x443c175a,0x6ab4001e,0x20d000bc}},	//   blis, ybu_, _vozf, pšit_, 
   {{0x2d80175b,0x1f2401d9,0x20d0009b,0x00000000}},	//   _iphe_, _دِیہ, lšir_, --, 
   {{0xd364175c,0x6728175d,0x443c0232,0x68f8175e}},	//   _ته_, _quej, vbu_, rowd, 
   {{0xd124175f,0xe5a41760,0x66001761,0x67281762}},	//   _يم_, жики, _pylk, _vuej, 
   {{0x67201763,0x00000000,0x00000000,0x00000000}},	//   _vilj, --, --, --, 
   {{0x2d8001e0,0x443c1764,0x68f8058a,0x67280200}},	//   _mphe_, ubu_, qowd, _tuej, 
   {{0x443c1765,0x7b100e78,0x78ac0306,0xe79400f2}},	//   rbu_, bäud, ťové, _بازک, 
   {{0x660014cf,0x443c1766,0x6720062c,0x799c015d}},	//   _tylk, sbu_, _uilj, _yrrw, 
   {{0x7d041767,0x60e81768,0xd04c00ac,0x7b10002f}},	//   ylis, имом_, licə, säug, 
   {{0x7d04036b,0x443c011f,0xa0681769,0x6b9c176a}},	//   xlis, qbu_, шама_, _orsg, 
   {{0x6458176b,0x7d04176c,0x2d80176d,0x788008a5}},	//   _idwi, vlis, _aphe_, _hávæ, 
   {{0x7d04176e,0x6910005c,0xe3f800ec,0x00000000}},	//   wlis, låed, _ٽوڙڻ_, --, 
   {{0x7d04176f,0x931004d3,0xd4400092,0xd24c009a}},	//   tlis, _تووش, _የቀበሌ, _شني_, 
   {{0x691000b5,0x1be806ed,0xda6400ec,0x00000000}},	//   nåed, адби_, ڪاري, --, 
   {{0x7d041770,0x2d80009f,0x5ba81771,0x3fc801e2}},	// [1240] rlis, _ephe_, шкам_, _ددغی_, 
   {{0xda640597,0xd1c01772,0xd04c03b9,0x00000000}},	//   تاري, _ድርብ_, dicə, --, 
   {{0x1d081773,0x6458068f,0x98481774,0x9984007b}},	//   _вени_, _odwi, аяла_, تلاو, 
   {{0x6458090c,0x7d040548,0x2bd400c5,0x23c80b98}},	//   _ndwi, qlis, _ठेका, िनाद, 
   {{0xda640451,0x6d5800b0,0x473001e2,0x00000000}},	//   _واسي, _āwai, وروز, --, 
   {{0x8f981775,0x64580134,0xd9440364,0x3ce00254}},	//   ייני, _adwi, _меги, liiv_, 
   {{0x628403b2,0x77f400ec,0x00000000,0x00000000}},	//   _óhoy, _کڻائ, --, --, 
   {{0xd3780354,0x6910005c,0x6b9c010e,0x00000000}},	//   ачо_, gåed, _yrsg, --, 
   {{0xb864004b,0x88b0006c,0xc474036b,0x00000000}},	//   _واړو, _تینچ, تینچ_, --, 
   {{0x64581776,0x3ce0007d,0x37c40131,0x4b780a1e}},	//   _edwi, hiiv_, _мәһб, סטיג, 
   {{0xbb5c00b5,0x80d400cc,0xc0cc0023,0xf9ec00cc}},	//   ntzス_, দচন্, _ቢሎም_, _কৰতল_, 
   {{0x53a400ae,0x6ab81777,0x00000000,0x00000000}},	//   _وماك, _ेत्र, --, --, 
   {{0x69c0007d,0x73c40032,0x2428009f,0x00000000}},	//   _ülev, _хәйе, _اسمٿ_, --, 
   {{0x2bd40316,0x82f41778,0x7b101779,0x00000000}},	//   _ठेगा, _وروز_, häub, --, 
   {{0x823000f1,0x463800df,0x00000000,0x00000000}},	//   _غروا, שעלע, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1250] --, --, --, --, 
   {{0x7f84177a,0x6b50032e,0xc98401d5,0x705400e5}},	//   _کلین, _aðgá, жуди, _بچھا, 
   {{0x2d80014b,0xa2a006e3,0x00000000,0x00000000}},	//   _uphe_, _कोफ्, --, --, 
   {{0xd04c0cc1,0x26f40db3,0x3df4177b,0x8ca010de}},	//   ticə, ेत्र_, _ізяс, _تەرو, 
   {{0x6d5401ed,0x23d8177c,0x4788177d,0xdc34008f}},	//   lsza, _बेंद, рсем_, _מארט_, 
   {{0x6b8c177e,0x00000000,0x00000000,0x00000000}},	//   mwag, --, --, --, 
   {{0x6b8c177f,0x6d541780,0x6910005c,0x00000000}},	//   lwag, nsza, tåed, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b8c1781,0x7b10002f,0x00000000,0x00000000}},	//   nwag, säue, --, --, 
   {{0x65941782,0x2cb801ab,0x6b8c01a4,0x6d541783}},	//   _назу, _losd_, iwag, ksza, 
   {{0x6b8c1784,0xe29816c3,0x6d541785,0x7b100112}},	//   hwag, _ҳал_, jsza, läuc, 
   {{0x6b8c1786,0x69c00037,0x34f0013d,0xd3e400cf}},	//   kwag, _üleu, _үҗәт, تتۉۉ, 
   {{0xe2981787,0xe7bc1788,0x6b8c01f5,0x6d54033f}},	//   _гал_, ्निप, jwag, esza, 
   {{0x2cb800a3,0x6b8c0747,0x539805d0,0x00000000}},	//   _aosd_, dwag, _לינו, --, 
   {{0x6d5400dd,0xdca41789,0x3ce00037,0x00000000}},	//   gsza, пави, tiiv_, --, 
   {{0x2cb800a3,0x6b8c178a,0xe7bc01bc,0x91b8011a}},	//   _cosd_, fwag, ्नाप, _למצי, 
   {{0x6b8c178b,0x2cb800d2,0x5b24178c,0x00000000}},	// [1260] gwag, _dosd_, سفال, --, 
   {{0xcff40375,0xff240811,0x0dc40023,0x3ce00254}},	//   _מצפה_, _تبعی, _ጽሒፉ_, siiv_, 
   {{0x6b8c0083,0x7b100e78,0xd83801c6,0x00000000}},	//   awag, täub, бэл_, --, 
   {{0x1868178d,0x6b8c178e,0x779401ed,0x8f5001b9}},	//   сади_, bwag, ویزا, _تنیش, 
   {{0x7b100086,0x6b8c0230,0x4730178f,0x5ba00032}},	//   räub, cwag, еніс, _яһағ, 
   {{0x7b100112,0x00000000,0x00000000,0x00000000}},	//   säub, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd9440107,0x00000000,0x00000000,0x00000000}},	//   _меҳи, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb6c8066d,0x6d541790,0x313401f0,0x261801f9}},	//   _بارے_, ysza, меор, येही_, 
   {{0x6b8c1791,0x69c000af,0x97000131,0x142400f3}},	//   zwag, _ület, _قېچى, _едем, 
   {{0x6b8c0af9,0x00000000,0x00000000,0x00000000}},	//   ywag, --, --, --, 
   {{0x04401792,0x6d5400b5,0xc4d0011a,0x4ea400f0}},	//   _чечн, wsza, _אגף_, прва, 
   {{0x6d541793,0x52740fc0,0x0ee81468,0xe3b400cc}},	//   tsza, _худу, сьми_, _জেকব, 
   {{0x6b8c1794,0xdcfc00bc,0x00000000,0x00000000}},	//   wwag, _uspě, --, --, 
   {{0x902804ce,0x6b8c1795,0x6d541796,0x8538010f}},	//   _уцка_, twag, rsza, מגלי, 
   {{0x6d54066d,0x4ea41797,0xfc3015b0,0x2ef41798}},	// [1270] ssza, _ерна, احف_, _озир, 
   {{0x6b8c1799,0x6d54179a,0x00000000,0x00000000}},	//   rwag, psza, --, --, 
   {{0x6b8c179b,0x7c580131,0x2cb800a3,0x8c34014b}},	//   swag, زلەر_, _tosd_, _нонӣ_, 
   {{0xd1dc02d3,0x6b8c01a4,0x7b100036,0xc7700150}},	//   _ዓዋተ_, pwag, täuc, еткө, 
   {{0x3a380223,0xfb84010a,0x00000000,0x00000000}},	//   _ffrp_, _пырн, --, --, 
   {{0x3a380048,0x660400a8,0x7b100e78,0x00000000}},	//   _gfrp_, мпла, räuc, --, 
   {{0xf650179c,0x60c403cd,0x06ac0154,0x00000000}},	//   ائه_, ykkm, _কতদি, --, 
   {{0x23340107,0xfbc4012d,0xf77002f2,0x61ec0055}},	//   мхор, लैकम, _ڕام_, _śalo, 
   {{0xd36c0451,0xd70000c0,0x00000000,0x00000000}},	//   لهي_, _кiра, --, --, 
   {{0x69c0007d,0x13040a8f,0x41400116,0xa1c40a5b}},	//   _üles, мный_, ндоң, дбод, 
   {{0xf3800220,0x2088179d,0xc1040116,0x00000000}},	//   _ұғым, ойни_, нүкл, --, 
   {{0xd36c0214,0x6594014b,0x00000000,0x00000000}},	//   دهی_, _наҷу, --, --, 
   {{0x343800f2,0xd24c00db,0x00000000,0x00000000}},	//   _رسند_, اچۇ_, --, --, 
   {{0xc444179e,0xd36c0244,0x62240116,0x00000000}},	//   _بیکن_, _ئهو_, _قىشل, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcb00131,0x6e3401c6,0xa2c4179f,0xb3540244}},	//   خىر_, _үхэх, िसक्, _تییا_, 
   {{0xd9d000d1,0x9f1800ae,0x00000000,0x00000000}},	// [1280] ھەرگ, _وآخر_, --, --, 
   {{0xd94417a0,0x00000000,0x00000000,0x00000000}},	//   дежи, --, --, --, 
   {{0x224000c5,0xab6400de,0x4d440064,0x00000000}},	//   _õhku_, _atļā, _опэн_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x46a017a1,0x00000000,0x00000000,0x00000000}},	//   качв, --, --, --, 
   {{0x26180ce0,0x6aa00332,0x00000000,0x00000000}},	//   येली_, _ólfa, --, --, 
   {{0x23c80490,0x27f80129,0x0514007b,0x89d800d9}},	//   िनंद, égné_, وزيع_, _וחלי, 
   {{0x69c000c5,0xe87401b9,0x128802e8,0x48e017a2}},	//   _üler, _سنلگ, ощни_, _ротв, 
   {{0x96c80014,0x4cc40154,0x00000000,0x00000000}},	//   _ببرِ_, রোপু, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x224817a3,0xd4c400c6,0xe4a40212,0x00000000}},	//   _đake_, _تغطي, _пріо, --, 
   {{0x3cf40b98,0x00000000,0x00000000,0x00000000}},	//   ्कने_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6ee8041a,0x00000000,0x00000000,0x00000000}},	//   džbe, --, --, --, 
   {{0x248817a4,0x7bc4003a,0x1af80154,0x00000000}},	// [1290] _ñame_, gyiu, ্গনে_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x806817a5,0xdb2417a6,0x06c40150,0x00000000}},	//   _عمیق_, رومی, _ﺒﺠﻨﺩ, --, 
   {{0xf77003e6,0x3dd800cc,0x00000000,0x00000000}},	//   ڤان_, _দুকল, --, --, 
   {{0xd3640272,0x00000000,0x00000000,0x00000000}},	//   _حه_, --, --, --, 
   {{0xda7c00d0,0x00000000,0x00000000,0x00000000}},	//   íďte_, --, --, --, 
   {{0x2d900223,0xd6240b3b,0x2d840327,0x00000000}},	//   nwze_, ноше_, ħlew_, --, 
   {{0xf77017a7,0xe3b817a8,0x69c4009f,0x00000000}},	//   _چال_, зби_, myhe, --, 
   {{0xf77017a9,0x291c04ba,0x69c400e5,0x07e400f1}},	//   _نال_, mmwa_, lyhe, _کېږی_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69c417aa,0xdb14003e,0xd70002dd,0x2010012d}},	//   nyhe, écén, _кiта, _szyi_, 
   {{0xe0d00214,0x00000000,0x00000000,0x00000000}},	//   ازد_, --, --, --, 
   {{0x248c17ab,0x291c0810,0x7bc40007,0x6f040051}},	//   meem_, imwa_, xyiu, _bkhc, 
   {{0x248c0694,0xe29817ac,0x69c417ad,0x00000000}},	//   leem_, _хак_, kyhe, --, 
   {{0xdd9017ae,0x21a40137,0x1d140798,0x00000000}},	//   دوز_, _чийм, еќар, --, 
   {{0x248c17af,0x02dc00c5,0x00000000,0x00000000}},	//   neem_, _फगुन, --, --, 
   {{0x5ac801d5,0x80cc01f9,0x3dd800cc,0x00000000}},	// [12a0] плам_, ासीं, _দুখল, --, 
   {{0x248c17b0,0x19f40f5c,0xd1c00092,0x00000000}},	//   heem_, нџер, _ድርቅ_, --, 
   {{0x248c17b1,0x69c400e5,0x00000000,0x00000000}},	//   keem_, gyhe, --, --, 
   {{0x58940133,0x248c0de2,0x7bc40022,0xa2a017b2}},	//   عجاز, jeem_, pyiu, _कोस्, 
   {{0x248c17b3,0xc7a017b4,0x00000000,0x00000000}},	//   deem_, лицк, --, --, 
   {{0x69c417b5,0x6d4017b6,0x00000000,0x00000000}},	//   byhe, ílag, --, --, 
   {{0x248c17b7,0x69c00ef5,0x69100267,0x69c40175}},	//   feem_, _ülep, måen, cyhe, 
   {{0x691017b8,0x248c0de2,0xf8d4033f,0x00000000}},	//   låen, geem_, _दतिय, --, 
   {{0xf318016c,0x20c001e7,0x741417b9,0x38380240}},	//   моиш_, _lóis_, کوکا, _ብሓሳብ, 
   {{0x35c400c7,0x7b100112,0xdb040166,0x00000000}},	//   _иазҳ, zäun, _ömäg, --, 
   {{0xb9cc044e,0x20c017ba,0x248c0694,0x00000000}},	//   _ሰነ_, _nóis_, beem_, --, 
   {{0x248c17bb,0x85f4011a,0x00000000,0x00000000}},	//   ceem_, _אצבע_, --, --, 
   {{0xbfa817bc,0x7b10005b,0x00000000,0x00000000}},	//   нтре_, väun, --, --, 
   {{0x63ac0960,0xf48403e6,0x841000d4,0x00000000}},	//   _šang, _ساڵی, _сміх, --, 
   {{0x518417bd,0x290403b2,0x51a80395,0xc0e00240}},	//   _чула, _ílag_, _хълм_, ነሎም_, 
   {{0x0cdc0729,0xdd980107,0x6604002f,0x00000000}},	//   ভক্ত, ӯшӣ_, ühki, --, 
   {{0x7bf817be,0x82440092,0x00000000,0x00000000}},	// [12b0] ентр_, _የአባቶ, --, --, 
   {{0x69c417bf,0x691017c0,0x63bc17c1,0x248c17c2}},	//   tyhe, gåen, øsni, zeem_, 
   {{0x291c00ca,0x248c0083,0x6ac004aa,0x00000000}},	//   tmwa_, yeem_, _शकीर, --, 
   {{0x69c417c3,0x291c17c4,0x248c17c5,0x00000000}},	//   ryhe, umwa_, xeem_, --, 
   {{0x8d24010b,0x248c00d8,0xdcfc0055,0x8038010f}},	//   _онүң_, veem_, _uppā, גנדע_, 
   {{0x69c400b5,0x248c00e8,0x00000000,0x00000000}},	//   pyhe, weem_, --, --, 
   {{0x20f400b0,0xa2a017c6,0x248c17c7,0x20c000ae}},	//   hāia_, _कोष्, teem_, _móir_, 
   {{0x26240198,0x71540023,0x00000000,0x00000000}},	//   rɓo_, _መሰላቶ, --, --, 
   {{0x248c0694,0xc6a40f5c,0x764c00e5,0x00000000}},	//   reem_, _пржи, élyü, --, 
   {{0x248c17c8,0x63ac0327,0x82440092,0x00000000}},	//   seem_, _ġand, _የበሽታ, --, 
   {{0xa06817c9,0x64a400d1,0x63ac17ca,0xc0e00023}},	//   мана_, _җаһа, _šand, _ነጊሱ_, 
   {{0xa2a017cb,0x726c001f,0x20c00332,0x98a800ef}},	//   _कोर्, _ተጠየቀ_, _róis_, _kubā_, 
   {{0x644817cc,0x20c017cd,0x1ea80451,0x442c17ce}},	//   mbei, _sóis_, واسي_, _igg_, 
   {{0x644817cf,0x20c000c6,0xa2e4084c,0x601c00d0}},	//   lbei, _cóir_, _шолд, _rámč, 
   {{0xb8e40135,0xe0d817d0,0x628017d1,0x644801c4}},	//   _ཏྭ_, _овк_, mflo, obei, 
   {{0x644817d2,0x753c00dd,0x6c7401c0,0x00000000}},	//   nbei, _érze, луух, --, 
   {{0x691017d3,0x442c020b,0x644817d4,0x20c001e7}},	// [12c0] tåen, _mgg_, ibei, _fóir_, 
   {{0x628017d5,0x4a4017d6,0x64480369,0xcb64011c}},	//   nflo, инув, hbei, тафе_, 
   {{0x6910003b,0x9d4417d7,0xcee001ec,0x00000000}},	//   råen, _шенд, _тұрқ, --, 
   {{0xc86017d8,0x6a140131,0xd7e4155b,0x0c7000db}},	//   атши, ھبەر, кіло, _ەگەد, 
   {{0x7d0417d9,0x7b1017da,0x6280017a,0x644801ab}},	//   mois, läum, kflo, dbei, 
   {{0x442c17db,0x7d0417dc,0xa2a00829,0x628001e4}},	//   _agg_, lois, _कोल्, jflo, 
   {{0x442c17dd,0x057017de,0x644817df,0x2eec0de2}},	//   _bgg_, لايد, fbei, éefi_, 
   {{0x7d0417e0,0xd3a417e1,0x224817a3,0x6280017a}},	//   nois, вроп, _đaka_, eflo, 
   {{0x628017e2,0x7b100112,0xf48402f2,0x44b00150}},	//   fflo, häum, ناکی, рбыс, 
   {{0x7d0417e3,0x442c0e21,0x644800d8,0x628006ea}},	//   hois, _egg_, abei, gflo, 
   {{0x7d040664,0xf484104a,0x765817e4,0x442c0010}},	//   kois, _ماشی, mavy, _fgg_, 
   {{0x7d04023a,0x63ac00f3,0x6ee80841,0x20f402b1}},	//   jois, _šane, džba, tāia_, 
   {{0x7d0417e5,0xb4c017e6,0x248800c7,0x20c00332}},	//   dois, ुसी_, _ñama_, _póir_, 
   {{0x765817e7,0x69c000d8,0xa4400133,0x00000000}},	//   navy, _àleg, _پێیو, --, 
   {{0x2fcc0bb8,0x7d0417e8,0x1ee80271,0x00000000}},	//   šeg_, fois, روفی_, --, 
   {{0x8c3803fa,0x69101512,0x442c00d8,0x7b100b70}},	//   _maßg, gåel, _xgg_, säul, 
   {{0x765817e9,0x20c00597,0xfb34009d,0x00000000}},	// [12d0] kavy, _tóir_, интэ, --, 
   {{0x765817ea,0x7b100112,0x00000000,0x00000000}},	//   javy, bäum, --, --, 
   {{0x7d0417eb,0x765805b4,0x6d4001e4,0x2d840135}},	//   bois, davy, ŭlab, ħles_, 
   {{0xe7f401c0,0x00000000,0x00000000,0x00000000}},	//   лчлэ, --, --, --, 
   {{0x628017ec,0x644803cd,0xcfe400fe,0x00000000}},	//   yflo, vbei, _গঁড়_, --, 
   {{0x442c17ed,0xba2816a0,0x64480042,0x2ed017ee}},	//   _sgg_, رسەم_, wbei, _हतोत, 
   {{0x644817ef,0x62800158,0xc87800d8,0x00000000}},	//   tbei, vflo, _оџа_, --, 
   {{0x261809bb,0x63ac0327,0x38a400d8,0x00000000}},	//   येगी_, _ġanb, _кјуб, --, 
   {{0x644817f0,0x628017f1,0x765817f2,0xf7940953}},	//   rbei, tflo, bavy, _катэ, 
   {{0x7d0417f3,0x644817f4,0x6280002f,0x39540241}},	//   zois, sbei, uflo, _àasà_, 
   {{0x273817f5,0x628017f6,0x7d0400ec,0x7d000356}},	//   _hèn_, rflo, yois, _hârş, 
   {{0x628009cc,0x20c000c6,0x273817f7,0xb7f403d4}},	//   sflo, _cóip_, _kèn_, _জৰিত_, 
   {{0x27380699,0x7d0417e5,0x6e2803be,0xe3640212}},	//   _jèn_, vois, əmbə, _скли, 
   {{0x249c0457,0x273817f8,0x7d04014b,0xd12c05af}},	//   _hawm_, _mèn_, wois, _کمي_, 
   {{0xa0a4152d,0x691017f9,0x249c0190,0x7d04049b}},	//   _байд, tåel, _kawm_, tois, 
   {{0x7b100730,0x765817fa,0xdb100241,0x00000000}},	//   räum, zavy, _ègús, --, 
   {{0xcb6417fb,0x765817fc,0x2d840274,0x5334010f}},	// [12e0] лате_, yavy, çler_, ָנען_, 
   {{0x249c0b89,0x7f4417fd,0x8f980302,0x7d0402f6}},	//   _lawm_, _itiq, _טיפי, sois, 
   {{0x7d0417fe,0x98a41553,0x9a140276,0x00000000}},	//   pois, лиже, уфаш, --, 
   {{0x249c0218,0x273817ff,0x765801f7,0x00000000}},	//   _nawm_, _bèn_, wavy, --, 
   {{0x76581800,0xe7940014,0x00000000,0x00000000}},	//   tavy, لاوک, --, --, 
   {{0x27381801,0x1ae4004e,0x41d0043e,0x70e000bc}},	//   _dèn_, _согм, दनास, _पग्ल, 
   {{0x76581802,0x7f4401a9,0x00000000,0x00000000}},	//   ravy, _ltiq, --, --, 
   {{0x76581803,0x249c0070,0x2ed01804,0x98a80356}},	//   savy, _cawm_, _हत्त, _dubă_, 
   {{0x249c01d4,0x273800f2,0x76581805,0x07a01806}},	//   _dawm_, _gèn_, pavy, _латн, 
   {{0x63ac0232,0x3254013e,0x4b78008f,0x45d00022}},	//   _šanc, швор, עטיג, рцәт, 
   {{0x249c0218,0x7f441807,0xf0b41808,0x81401809}},	//   _fawm_, _atiq, айнь, ینین, 
   {{0x27380502,0x249c0218,0x6ac000dc,0x00000000}},	//   _yèn_, _gawm_, _शक्र, --, 
   {{0xe4c800ec,0x00000000,0x00000000,0x00000000}},	//   _جبلن_, --, --, --, 
   {{0x11d4180a,0x249c0218,0x8c380e78,0x00000000}},	//   _متعد, _zawm_, _maße, --, 
   {{0x249c0070,0xdb040036,0xbdd400f5,0x0ca8180b}},	//   _yawm_, _erkë, борщ, нтаи_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xaa54055f,0x00000000,0x00000000,0x00000000}},	// [12f0] иваш, --, --, --, 
   {{0x2738180c,0x38640129,0x00000000,0x00000000}},	//   _rèn_, _admr_, --, --, 
   {{0x273802bd,0x2eec00e8,0xe8580153,0x0dc802e8}},	//   _sèn_, éefu_, ваеш_, _чупи_, 
   {{0x386405d5,0x27380669,0x8c040154,0xdd9000ec}},	//   _cdmr_, _pèn_, লেষন_, _بوٽ_, 
   {{0x0a68180d,0x249c01d4,0x3cf40b67,0xc2080037}},	//   _први_, _rawm_, ्करे_, _सुनब_, 
   {{0xc0e0044e,0x249c0211,0x65c4036b,0x27380ba1}},	//   _ነዊሕ_, _sawm_, ибла, _vèn_, 
   {{0x8c0400eb,0x00000000,0x00000000,0x00000000}},	//   লেশন_, --, --, --, 
   {{0x6d44180e,0xdb04020c,0x38600597,0x2738180f}},	//   _mtha, _arkè, óirt_, _tèn_, 
   {{0x6d44089c,0x14b41810,0xc6000171,0x00000000}},	//   _ltha, _आचरण, dzēš_, --, 
   {{0xa2e41811,0x6ee80841,0x87040064,0x00000000}},	//   роод, džbo, _сябе, --, 
   {{0x25b81812,0x249c0190,0x6d441813,0xda0803f9}},	//   _جهاد_, _tawm_, _ntha, ɓuɓɓ, 
   {{0x20541814,0xdb040036,0xb9dc0240,0x00000000}},	//   штор, _erkè, _ኡይ_, --, 
   {{0x6d441815,0x443c1816,0x62940419,0x00000000}},	//   _atha, mcu_, ôzos, --, 
   {{0x6d440649,0x443c1817,0x7f440393,0x00000000}},	//   _btha, lcu_, _vtiq, --, 
   {{0x91e01818,0x443c0ffb,0xdd901819,0x1c380006}},	//   _моше, ocu_, غور_, вязь_, 
   {{0x443c181a,0x1c44181b,0x6d44181c,0xe2a80451}},	//   ncu_, рнам, _dtha, _ساڻن_, 
   {{0x6d44181d,0x7f441730,0x443c181e,0x2b480077}},	// [1300] _etha, _utiq, icu_, gpac_, 
   {{0x443c0369,0x2eec0036,0x00000000,0x00000000}},	//   hcu_, éeft_, --, --, 
   {{0x8c380112,0x1af80154,0x00000000,0x00000000}},	//   _saße, ্গলে_, --, --, 
   {{0x186807d6,0xdca405f5,0x443c181f,0x1be801ee}},	//   тади_, _тами, jcu_, _адми_, 
   {{0x443c1820,0x2b4804ce,0x00000000,0x00000000}},	//   dcu_, cpac_, --, --, 
   {{0x236c1821,0xdb040687,0xb4c0143b,0x60d4015d}},	//   drej_, _orké, ुस्_, _llym, 
   {{0x98640014,0x6d4400a3,0x53780023,0x7fb40118}},	//   _نیاے_, _xtha, _ጠባያት_, ुहुँ, 
   {{0x38640276,0x63ac1822,0x39a40014,0x443c03e0}},	//   _udmr_, _šana, _پیچہ, gcu_, 
   {{0xa3641823,0xdb040264,0x78a0003a,0x236c1824}},	//   مپيۇ, _arké, _iamv, grej_, 
   {{0x443c1825,0x60d40209,0x73c400fb,0x78a01826}},	//   acu_, _alym, иәһе, _hamv, 
   {{0x78a01827,0x443c1828,0x60d41829,0x799c02d0}},	//   _kamv, bcu_, _blym, _jsrw, 
   {{0x443c182a,0x78a0182b,0x4610182c,0x236c182d}},	//   ccu_, _jamv, _بومر, brej_, 
   {{0x77f4107c,0x6d44182e,0xa4f4182f,0xca3008b0}},	//   _अशोक_, _stha, _دکور_, ﺮﻻﺭ_, 
   {{0x0ee81830,0x60d40810,0x78a01831,0x28dc00af}},	//   тьми_, _elym, _lamv, _मतभि, 
   {{0x799c03ac,0x00000000,0x00000000,0x00000000}},	//   _nsrw, --, --, --, 
   {{0x60d41832,0xebc400d1,0x78a01833,0x6d440051}},	//   _glym, бәгн, _namv, _vtha, 
   {{0x6cd400cf,0x00000000,0x00000000,0x00000000}},	// [1310] _ۇقدا, --, --, --, 
   {{0x6e941834,0x6d440086,0x443c1835,0x49c81836}},	//   _الدا, _ttha, zcu_, куем_, 
   {{0x6d441837,0x2b481838,0x78a01839,0x443c183a}},	//   _utha, spac_, _bamv, ycu_, 
   {{0x78a0037e,0x443c011f,0xe6d802d2,0x00000000}},	//   _camv, xcu_, _þrúð, --, 
   {{0x443c0552,0x78a00156,0xfe70183b,0x09dc0154}},	//   vcu_, _damv, _عدی_, _বুখা, 
   {{0x6b9c0005,0x236c0cf4,0x443c033f,0x00000000}},	//   _issg, vrej_, wcu_, --, 
   {{0xe298183c,0x443c183d,0x799c02d0,0x9f9003b2}},	//   қан_, tcu_, _gsrw, _løða_, 
   {{0xfdf80302,0x78a003cd,0x443c183e,0x67d4146a}},	//   ימוש_, _gamv, ucu_, _лобу, 
   {{0x68e8183f,0x290c1840,0xe3e8034c,0x443c1841}},	//   _imed, _ikea_, دکان_, rcu_, 
   {{0x443c1842,0x236c1843,0x78a01844,0x60d40af9}},	//   scu_, rrej_, _zamv, _slym, 
   {{0xa0a41845,0x60d41846,0x78a01847,0x26c41848}},	//   банд, _plym, _yamv, _iolo_, 
   {{0x26c41849,0x236c0fb7,0x6b9c0857,0x00000000}},	//   _holo_, prej_, _ossg, --, 
   {{0x26c40418,0x68e801e0,0x60d40af9,0x64580857}},	//   _kolo_, _mmed, _vlym, _iewi, 
   {{0x6458184a,0xdca400c7,0x00000000,0x00000000}},	//   _hewi, әааи, --, --, 
   {{0x6458184b,0x9f50011f,0x68e8184c,0x290c00b0}},	//   _kewi, _ayyô_, _omed, _okea_, 
   {{0x26c4184d,0x68e80048,0x290c02e3,0x9f900162}},	//   _lolo_, _nmed, _nkea_, _føða_, 
   {{0x78a0016d,0x64580066,0x5ba80006,0x5a6400cf}},	// [1320] _ramv, _mewi, ыкам_, йкаб, 
   {{0x290c166a,0x68e8184e,0x26c4184f,0x20100548}},	//   _akea_, _amed, _nolo_, _iyyi_, 
   {{0x66dc007f,0x78a01850,0xceb00375,0x6b9c002f}},	//   _kèkf, _pamv, _זית_, _essg, 
   {{0x64580cfd,0x26c40069,0xd7f81142,0x2fdc05d1}},	//   _newi, _aolo_, лул_, _özgü_, 
   {{0x26c40038,0x96e81851,0x78a0016d,0x00000000}},	//   _bolo_, лька_, _vamv, --, 
   {{0x68e81852,0x290c1853,0x8f98025d,0x99d40024}},	//   _emed, _ekea_, טיני, _любч, 
   {{0x26c41854,0x290c0270,0x78a00bd7,0x98a41855}},	//   _dolo_, _fkea_, _tamv, _ливе, 
   {{0x26c4011c,0x6458003e,0x00000000,0x00000000}},	//   _eolo_, _cewi, --, --, 
   {{0x64581856,0x26c41857,0x77f405d9,0x00000000}},	//   _dewi, _folo_, _بڻائ, --, 
   {{0x26c41858,0x68e809a8,0x9f90022c,0x09dc03d4}},	//   _golo_, _zmed, _røða_, _বুটা, 
   {{0x20100198,0x64580de2,0x705405d9,0xd9f81223}},	//   _ayyi_, _fewi, يندا, ्थित_, 
   {{0x64581859,0x26c4185a,0x2ed000dc,0xdddc033f}},	//   _gewi, _zolo_, हस्त, _odpł, 
   {{0x26c40472,0xf2c40139,0xe51c00cd,0xe50401f7}},	//   _yolo_, _дөни, _पठति_, _ببلي, 
   {{0xd9f8185b,0x26c4014b,0xee2001ec,0x6d400332}},	//   ्थात_, _xolo_, дегi_, ílao, 
   {{0x64580921,0x8c64185c,0xa2a0185d,0xad24185e}},	//   _yewi, йтад, _कोट्, قىسى, 
   {{0xd24c0050,0xdbd4022c,0x8d840032,0x09dc015b}},	//   _تۆگ_, tøða, _һумд, _বুঝা, 
   {{0x41b000db,0x4fc4004e,0xaf5400ec,0x00000000}},	// [1330] _ومۇر, _ыска, _برعڪ, --, 
   {{0x68e8185f,0x290c045f,0x9408016b,0x63bc0267}},	//   _smed, _skea_, ɛbɔ_, äsni, 
   {{0x26c41860,0x09dc0183,0x8d78001f,0xe9440133}},	//   _rolo_, _বুজা, ርሲቲው_, زرای, 
   {{0x26c41861,0x81c80154,0x41780677,0x7f841862}},	//   _solo_, _রেড_, רנאב, _بلین, 
   {{0x64581863,0x68e80810,0x26c41864,0x645c01d5}},	//   _rewi, _vmed, _polo_, аsin, 
   {{0x64581865,0x26c401d9,0x321c02f0,0x63ac013a}},	//   _sewi, _qolo_, _ozvy_, _šano, 
   {{0x6458033f,0xe450007b,0x00000000,0x00000000}},	//   _pewi, وضة_, --, --, 
   {{0x68e81866,0x26c40085,0xa3b81867,0x24c8004e}},	//   _umed, _wolo_, لاخر_, ргип_, 
   {{0x26c41868,0x108c00d1,0x00000000,0x00000000}},	//   _tolo_, _ﻛﯚﺯﯨ, --, --, 
   {{0x64581869,0x2130003e,0x26c4186a,0xf6d40137}},	//   _wewi, _siyh_, _uolo_, _ىزلد, 
   {{0x64580086,0x6aa40332,0x00000000,0x00000000}},	//   _tewi, idhf, --, --, 
   {{0x7b1003fa,0x140802e3,0xa878010f,0x00000000}},	//   läut, ịrịo, סאָר, --, 
   {{0x7950007f,0x6264014b,0x00000000,0x00000000}},	//   _kòwò, _двла, --, --, 
   {{0x63a8186b,0x21740276,0x73040212,0xa2a000ce}},	//   mven, _дуир, _епіз, _कोच्, 
   {{0x63a8186c,0x712407d6,0x108c00d1,0xc6080154}},	//   lven, تریل, _ﻛﯚﺭﯨ, ষেরা_, 
   {{0x63a8186d,0x161c00e1,0x79600241,0x7b100112}},	//   oven, येटर_, _láwá, häut, 
   {{0x9b44186e,0x00000000,0x00000000,0x00000000}},	// [1340] زناو, --, --, --, 
   {{0x63a8186f,0xeb541870,0x00000000,0x00000000}},	//   iven, سىمگ, --, --, 
   {{0x18a40945,0x63ac010e,0x00000000,0x00000000}},	//   жаем, _šanl, --, --, 
   {{0xa3a801ad,0x0d2000cf,0x00000000,0x00000000}},	//   खटा_, _жүсү, --, --, 
   {{0x63a80cf9,0xd7041871,0x00000000,0x00000000}},	//   jven, озди, --, --, 
   {{0x63a81872,0x645c1873,0x2d8400f7,0x4ff8008f}},	//   dven, ðsin, àleg_, יִונ, 
   {{0x63a81874,0x8c380730,0xd4980114,0x273000db}},	//   even, _maßn, арп_, رۉمس, 
   {{0x94a81875,0xa3d400dc,0x63a81876,0x00000000}},	//   ртка_, सनं_, fven, --, 
   {{0x60cc0135,0x63a81877,0x161c03ce,0x00000000}},	//   _ċamp, gven, येजर_, --, 
   {{0x1440001f,0x0bb40375,0x71780107,0x7b100112}},	//   _የጀመሩ, קלים_, ббор_, mäus, 
   {{0x63a81878,0x3fd001ec,0x7b101196,0x00000000}},	//   aven, _ﮔﺮﺍﻧ, läus, --, 
   {{0x63a81879,0x8598011a,0x00000000,0x00000000}},	//   bven, _כשבו, --, --, 
   {{0x4ea4187a,0x63a800a8,0xdb0402d2,0x00000000}},	//   орва, cven, _arkí, --, 
   {{0xd138187b,0x00000000,0x00000000,0x00000000}},	//   _кхи_, --, --, --, 
   {{0x7b100730,0xd1f402d3,0x00000000,0x00000000}},	//   häus, ፈልቲ_, --, --, 
   {{0xdcec005f,0x00000000,0x00000000,0x00000000}},	//   tubā, --, --, --, 
   {{0x6b7414d4,0x00000000,0x00000000,0x00000000}},	// [1350] ялау, --, --, --, 
   {{0x39580142,0x7054187c,0x423400df,0x00000000}},	//   _bwrs_, _بنکا, ַנדל_, --, 
   {{0x63a805b8,0x395800a9,0x8c34014b,0x00000000}},	//   zven, _cwrs_, _монӣ_, --, 
   {{0xe5a4187d,0x6ee8187e,0x63a8187f,0x672001fa}},	//   ҷики, džbi, yven, _shlj, 
   {{0x66dc07b0,0x24880309,0xf6800118,0x98a801ef}},	//   _lèke, _ñami_, ěžně_, _hubě_, 
   {{0x63a81880,0xe5a41881,0x98a801ef,0x00000000}},	//   vven, зики, _kubě_, --, 
   {{0x395800a9,0x7b100112,0x00000000,0x00000000}},	//   _gwrs_, räut, --, --, 
   {{0x7b1001c7,0x7950007f,0xdb0c01e1,0x00000000}},	//   bäus, _wòwò, _òjòj, --, 
   {{0x3a38030d,0x63a81882,0xed8002d3,0x00000000}},	//   _ygrp_, uven, _ይግበር_, --, 
   {{0x67201883,0x3964005b,0x92601884,0x7674014b}},	//   _uhlj, _ässä_, ىگىم, _олуф, 
   {{0x66dc020c,0xa0a41885,0x00000000,0x00000000}},	//   _cèke, панд, --, --, 
   {{0x21041886,0xd12c04d3,0x659400a6,0xa0a41887}},	//   रवेश_, ێمی_, _маҷу, чамд, 
   {{0xdfd0099f,0x2b5800ca,0xa3481064,0x63a8003a}},	//   ريس_, _nwsc_, _узла_, qven, 
   {{0x6fd00332,0x0afc0154,0xdea01888,0x00000000}},	//   _sócú, ্গুল_, ریجی, --, 
   {{0x2cf81889,0x00000000,0x00000000,0x00000000}},	//   ्कूल_, --, --, --, 
   {{0x201c0cc1,0x2b58031c,0xd944010b,0x1f64011c}},	//   ətin_, _bwsc_, җеди, _еким, 
   {{0x7124188a,0x0df002d3,0x2b580142,0x6d6000b8}},	// [1360] _ترول, _ግደፍ_, _cwsc_, _āvaś, 
   {{0x39580042,0x8c38002f,0x7b1001f4,0x00000000}},	//   _pwrs_, _haßl, väus, --, 
   {{0x1d08188b,0xda08007b,0x00000000,0x00000000}},	//   _гени_, حياه_, --, --, 
   {{0x7b100d16,0x00000000,0x00000000,0x00000000}},	//   täus, --, --, --, 
   {{0x8c38002f,0x00000000,0x00000000,0x00000000}},	//   _maßl, --, --, --, 
   {{0x7b1003fa,0x00000000,0x00000000,0x00000000}},	//   räus, --, --, --, 
   {{0xceb00375,0xe7c001ad,0xc51000f2,0x1d900092}},	//   תיו_, _शपथप, کبوت, _ምግቦች_, 
   {{0x636001f2,0x15b80220,0xd37813d6,0x1cb80327}},	//   _ịnar, _қызы_, бчо_, _ཙོས_, 
   {{0x66dc0066,0x629401e4,0x00000000,0x00000000}},	//   _sèke, ĵzon, --, --, 
   {{0x66dc020c,0xe97000f7,0x43d0007b,0x00000000}},	//   _pèke, _سۇۇد, عزيز, --, 
   {{0xa6a800db,0x00000000,0x00000000,0x00000000}},	//   _باقق_, --, --, --, 
   {{0x09f40375,0x2a600208,0x2c1c000d,0x855400df}},	//   למים_, zahb_, _मरलू_, _זשאב_, 
   {{0xa3cc10dc,0xbff8188c,0xdfd005d9,0x9fa40032}},	//   रहण_, зеях_, نيٽ_, мырҙ, 
   {{0x9f4c022c,0x00000000,0x00000000,0x00000000}},	//   ðnám_, --, --, --, 
   {{0x050c00fe,0x00000000,0x00000000,0x00000000}},	//   াগৰৰ_, --, --, --, 
   {{0xc8a805f9,0xd7bc0073,0x01f8011a,0x00000000}},	//   _घोंट, ्हाच, _לפול, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1370] --, --, --, --, 
   {{0x8018188d,0xa3cc000d,0x6ed000bc,0x98a801ef}},	//   _عزيز_, रहत_, _सकिँ, _tubě_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ce0188e,0xeff00023,0x00000000,0x00000000}},	//   chiv_, _ቃልዕ_, --, --, 
   {{0xd3640272,0x47880408,0x00000000,0x00000000}},	//   _جه_, ссем_, --, --, 
   {{0x2ca8188f,0x7b100e78,0xae000210,0xf1dc07b7}},	//   ldad_, säur, _ईशान_, मनान, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2ca81890,0xdddc007f,0x81c80154,0x00000000}},	//   ndad_, _depň, _রইল_, --, 
   {{0x2ca81891,0x2cb80b45,0xe73800a9,0xdb040419}},	//   idad_, _mnsd_, _grŵp_, _hrká, 
   {{0x2ca80399,0xe2980063,0xe1f81892,0x00000000}},	//   hdad_, цао_, жго_, --, 
   {{0x2ca80198,0x93c81893,0xb5fc0003,0x00000000}},	//   kdad_, مایہ_, _reġg, --, 
   {{0xe3b800f0,0x14c800f1,0x00000000,0x00000000}},	//   _млеч_, _وهلی_, --, --, 
   {{0x2ca81894,0x7648030a,0xdddc0100,0x33b004b3}},	//   ddad_, _yfdy, _zepň, _مەير, 
   {{0x2ca80dd4,0x248c1895,0x00000000,0x00000000}},	//   edad_, lfem_, --, --, 
   {{0xa0a41896,0x3ce00218,0x93100137,0x248c007c}},	//   _жайд, thiv_, _جووش, ofem_, 
   {{0xb5fc031c,0xc97c0092,0x00000000,0x00000000}},	//   _weġg, _ያልፋል_, --, --, 
   {{0xdb041897,0x248800e8,0x69c00ca8,0x00000000}},	// [1380] _arká, _ñamu_, _àlej, --, 
   {{0x3ce00218,0x2ca805d5,0x9db800c0,0x8d640092}},	//   shiv_, adad_, _дыму_, ድባቸው_, 
   {{0x1d2400d1,0x69100267,0x2ca81898,0xb8200037}},	//   _омом, våer, bdad_, _बरहम_, 
   {{0xa3cc1899,0xdddc0100,0xf1a0000d,0x753c00e5}},	//   रहा_, _repň, _ओईसन, _érzi, 
   {{0x8cd8189a,0xd7080276,0xdaa00124,0x2c0000db}},	//   नसरो, онде_, _иҳаҩ, _бүтм, 
   {{0x473000d6,0x248c0158,0xb5fc031c,0x38c80244}},	//   вніс, efem_, _leġe, _کاسی_, 
   {{0x248c015d,0xceb00a7c,0x691001e3,0x00000000}},	//   ffem_, כיג_, råer, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x224805d1,0x81c80154,0x6910007c,0x00000000}},	//   _şaka_, _রেল_, påer, --, 
   {{0xd628189b,0x660c123d,0x662800e5,0x56f0009d}},	//   _дозе_, şaka, áskö, _шүлс, 
   {{0x9484189c,0x97000075,0x02a002d5,0x2ca80067}},	//   _жылд, _كېچى, трым, ydad_, 
   {{0x3d08033f,0x00000000,0x00000000,0x00000000}},	//   वकों_, --, --, --, 
   {{0x0440189d,0xb5fc031c,0xef6401c6,0x823000e5}},	//   _речн, _deġe, ээнү, ٹریا, 
   {{0x2cb8189e,0x8230030f,0x00000000,0x00000000}},	//   _snsd_, عریا, --, --, 
   {{0xdc38189f,0xc3240597,0x2ca80369,0x201c0213}},	//   _açık, _تكون_, tdad_, ətim_, 
   {{0x66dc020c,0x2ca805c7,0xec340139,0x00000000}},	//   _mèka, udad_, енбь, --, 
   {{0x2ca818a0,0x2d8c002e,0x28d40073,0x00000000}},	// [1390] rdad_, ŋee_, _दवबि, --, 
   {{0xcf2418a1,0x7a54007b,0x00000000,0x00000000}},	//   _تربي, نضما, --, --, 
   {{0x2ca80280,0x7c580131,0xeb340131,0xc5f000cc}},	//   pdad_, سلەر_, _ۋىجد, _চুনা_, 
   {{0x2ca80067,0x00000000,0x00000000,0x00000000}},	//   qdad_, --, --, --, 
   {{0xf7f418a2,0xf748007b,0x00000000,0x00000000}},	//   پسند, وجوه_, --, --, 
   {{0xf77018a3,0xdb04037e,0x16a418a4,0xb3b40154}},	//   شاه_, _arkæ, евши_, টহাজ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x291800d2,0xfb0000b0,0x00000000,0x00000000}},	//   _ósa_, āīō_, --, --, 
   {{0xe3b018a5,0xbef8037e,0x93a0022e,0xd36c009f}},	//   ارب_, _sにmn, _ro惣x, مهي_, 
   {{0x248c004e,0xe3b000cf,0x14200022,0x00000000}},	//   sfem_, _ۅرت_, ыдым, --, 
   {{0x22140108,0x668001e2,0x00000000,0x00000000}},	//   эфир, _لیږل, --, --, 
   {{0xe3b0007b,0x00000000,0x00000000,0x00000000}},	//   _مرت_, --, --, --, 
   {{0xca3418a6,0xb5fc0135,0xcf400108,0xd8d400d9}},	//   _iaʝu_, _veġe, лняй, גורט_, 
   {{0xd36c16cb,0xc760010c,0x6224185e,0x644818a7}},	//   _اهو_, _ስደተኛ_, _كىشل, lcei, 
   {{0xca34166a,0x628000b5,0x64480356,0xe0d800d4}},	//   _kaʝu_, mglo, ocei, _нвк_, 
   {{0x644818a8,0x628018a9,0x7cfc0139,0x00000000}},	//   ncei, lglo, gärе, --, 
   {{0xc5f004c5,0x644800a3,0x00000000,0x00000000}},	// [13a0] _চুমা_, icei, --, --, 
   {{0x62800652,0x00000000,0x00000000,0x00000000}},	//   nglo, --, --, --, 
   {{0x984802e8,0x62800142,0x00000000,0x00000000}},	//   пяла_, iglo, --, --, 
   {{0x38600491,0x66dc0066,0x48e000c0,0xe8e80ee8}},	//   úir_, _rèka, лохв, ورنو_, 
   {{0x64480007,0x66dc007f,0xcc38010f,0x47d00154}},	//   dcei, _sèka, _מעכט, _দেবী, 
   {{0x62800427,0x00000000,0x00000000,0x00000000}},	//   jglo, --, --, --, 
   {{0x25a400d8,0x9a7c0092,0x86c002de,0x00000000}},	//   _csll_, _ያምናል_, ايىن, --, 
   {{0xd37818aa,0x628018ab,0x00000000,0x00000000}},	//   пчо_, eglo, --, --, 
   {{0x48e018ac,0x00000000,0x00000000,0x00000000}},	//   _сотв, --, --, --, 
   {{0x628018ad,0x66dc007f,0x15b0129d,0x57bc01f9}},	//   gglo, _tèka, _مەتس, ्हीह, 
   {{0x64480007,0x661018ae,0xdb04013d,0xb5fc031c}},	//   bcei, _پژوا, _irkä, _weġb, 
   {{0x644818af,0xfbe005f9,0x1db801ad,0x62800356}},	//   ccei, फनाम, _उपजत, aglo, 
   {{0xb4dc0490,0x628018b0,0x00000000,0x00000000}},	//   डसी_, bglo, --, --, 
   {{0xa3cc070f,0x00000000,0x00000000,0x00000000}},	//   रहर_, --, --, --, 
   {{0x4d2400d8,0x00000000,0x00000000,0x00000000}},	//   еќаа, --, --, --, 
   {{0x42a402d3,0x7094013d,0x4ba4004e,0x48d800cc}},	//   _ገበናት_, _раиф, нөгү_, _ভদ্ৰ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [13b0] --, --, --, --, 
   {{0xff5000c6,0x64480369,0xbb1800d1,0x3f6402e8}},	//   _اخي_, zcei, ىزلا_, _стъб, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1cb8025c,0x6d5401a4,0x79a40124,0x00000000}},	//   _ཙོག_, mpza, ыруе, --, 
   {{0x6d540d27,0x00000000,0x00000000,0x00000000}},	//   lpza, --, --, --, 
   {{0x6b8c18b1,0xbdf818b2,0x6280062c,0x00000000}},	//   mtag, _آریا_, xglo, --, 
   {{0x6b8c18b3,0xa50818b4,0x660400a7,0x94ec03b9}},	//   ltag, мека_, ъпка, lşən_, 
   {{0xdb040624,0x628018b5,0xe3b818b6,0x69c40472}},	//   _erkä, wglo, дби_, mxhe, 
   {{0xf770086e,0x644818b7,0x628018b8,0x291c0472}},	//   _هال_, rcei, tglo, mlwa_, 
   {{0x6b8c18b9,0x291c18ba,0x644818bb,0x56f018bc}},	//   itag, llwa_, scei, _күчс, 
   {{0x291c18bd,0x69c418be,0x6b8c1368,0xb6e401af}},	//   olwa_, nxhe, htag, _сютк, 
   {{0x63ac0b4b,0x6b8c18bf,0x62800042,0x64480369}},	//   _šanu, ktag, sglo, qcei, 
   {{0x6b8c18c0,0x628018c1,0x6d5401f5,0x69c4036e}},	//   jtag, pglo, epza, hxhe, 
   {{0xe1f01060,0x6b8c18c2,0x1cb80003,0x3ae418c3}},	//   _پست_, dtag, _ཙོང_, _köpe_, 
   {{0x8d6015ed,0x6b8c18c4,0x69c40200,0x00000000}},	//   ивре, etag, jxhe, --, 
   {{0x01c000c7,0xb3540345,0x00000000,0x00000000}},	//   _арҩҭ, _جییا_, --, --, 
   {{0x6b8c10c7,0xcb6418c5,0x291c0a07,0x6d540d27}},	// [13c0] gtag, кате_, dlwa_, apza, 
   {{0x291c18c6,0xc0c400fb,0x61ec00cd,0x1e9418c7}},	//   elwa_, _рәүи, _śaly, _ррир, 
   {{0x7f440d04,0x598418c8,0x394401ef,0x00000000}},	//   _huiq, тлеб, _čmss_, --, 
   {{0x1b48036b,0x291c02e2,0x6b8c18c9,0x00000000}},	//   _озми_, glwa_, btag, --, 
   {{0x6b8c00ad,0x272801f1,0x660c18ca,0xe97000f7}},	//   ctag, kúnd_, şakl, _ۇۇلد, 
   {{0x66dc007f,0x291c18cb,0x68e8031c,0xd5b800d8}},	//   _dèko, alwa_, _ċede, дси_, 
   {{0x66dc04fb,0x1dd018cc,0x186801a9,0x349418cd}},	//   _tèkn, सहित, _оави_, гайр, 
   {{0xdddc00b0,0xa3cc00cd,0xb4dc06e3,0x00000000}},	//   _nepō, रहं_, डसे_, --, 
   {{0xccf0025f,0x07a00598,0xc7a018ce,0x7f440481}},	//   יכה_, _катн, _китк, _nuiq, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xebb80a28,0x6b8c18cf,0xdb040240,0x00000000}},	//   maḥ_, ztag, _askë, --, 
   {{0xebb80882,0x6b8c18d0,0x85f40375,0x290403b2}},	//   laḥ_, ytag, _בצבע_, _ílat_, 
   {{0x7f441730,0xdddc007f,0x6b8c18d1,0x9960012c}},	//   _cuiq, _depō, xtag, _níže_, 
   {{0xebb81161,0x6b8c01e3,0x291c0472,0x41c00014}},	//   naḥ_, vtag, zlwa_, _چٲوِ, 
   {{0xcfc8045e,0xdb0400e8,0x518402dd,0x00000000}},	//   _লেখন, _eskë, _рула, --, 
   {{0xebb81161,0x6b8c18d2,0xa25001d9,0x8c38002f}},	//   haḥ_, ttag, _پھیش, _maßv, 
   {{0xebb80a28,0x6b8c18d3,0xfc6402e8,0x7b4400d1}},	// [13d0] kaḥ_, utag, ръсн, ۇئەل, 
   {{0x6b8c18d4,0x7a400232,0xebb80882,0x2fd80368}},	//   rtag, vští, jaḥ_, mysg_, 
   {{0x6b8c18d5,0xebb80a28,0x291c18d6,0xac98007b}},	//   stag, daḥ_, tlwa_, _كندا_, 
   {{0x6b8c18d7,0x6d44003e,0x69c40023,0x25b8022a}},	//   ptag, _iuha, rxhe, _čsl_, 
   {{0x6d4418d8,0x0a6818d9,0xb5fc0327,0x27280022}},	//   _huha, _орви_, _reġa, húne_, 
   {{0x6f1418da,0xebb80882,0x6604010b,0xdbc4002f}},	//   nozc, gaḥ_, лпла, löße, 
   {{0x6d4418db,0x291c07ab,0x8c38002f,0x00000000}},	//   _juha, plwa_, _paßw, --, 
   {{0x66dc02e2,0x63880240,0xe3a80114,0x2d980150}},	//   _zèkl, _nënç, екид_, _ﺘﺴﻤﻰ_, 
   {{0x6d4418dc,0xdddc0100,0x82600131,0x937001e1}},	//   _luha, _repō, لۇشن, _è̟̟t, 
   {{0x63ac0bb8,0x2fd80cfd,0x130400c9,0xebb80882}},	//   _šans, dysg_, лный_, caḥ_, 
   {{0x6d4418dd,0xc0cc02d3,0x7f4418de,0x85440024}},	//   _nuha, _ኣምር_, _suiq, _рэзе, 
   {{0x69c0004a,0x00000000,0x00000000,0x00000000}},	//   _àleu, --, --, --, 
   {{0x6d44166a,0x7f4418df,0x77600218,0x02c001af}},	//   _auha, _quiq, _xwmx, _вилү, 
   {{0x6d4418e0,0x201c18e1,0x27280419,0x236c01bf}},	//   _buha, āti_, búne_, msej_, 
   {{0x217401c6,0x236c00d7,0x9b0401a9,0x00000000}},	//   _сулр, lsej_, ҳзад, --, 
   {{0x7f440393,0xeff00023,0x00000000,0x00000000}},	//   _tuiq, _ሃልዩ_, --, --, 
   {{0xebb81161,0x6d4418e2,0x9c2418e3,0x00000000}},	// [13e0] yaḥ_, _euha, удад, --, 
   {{0x6d440109,0x656003ac,0x00000000,0x00000000}},	//   _fuha, _owlh, --, --, 
   {{0x6d440537,0xebb80a28,0x57bc02ab,0x79e801d3}},	//   _guha, vaḥ_, ्ह्ह, خواہ_, 
   {{0xf754069c,0x5e440014,0xe6b401b9,0x0d80010a}},	//   _ዝተፈላ, _جنگٕ, یلنگ, _улюн, 
   {{0x7d0418e4,0xebb818e5,0x6d4418e6,0x236c0419}},	//   mnis, taḥ_, _zuha, jsej_, 
   {{0x7d0418e7,0x6d4418e8,0x236c0030,0x0858004e}},	//   lnis, _yuha, dsej_, _үчтө_, 
   {{0xebb81161,0x057017de,0xb9240241,0x00000000}},	//   raḥ_, مايد, _musẹ_, --, 
   {{0x337418e9,0xebb80a28,0x2ed018ea,0x321c0022}},	//   агир, saḥ_, _सक्त, _ryvy_, 
   {{0x7d0418eb,0xd70818ec,0xebb80882,0x324c0092}},	//   inis, _знае_, paḥ_, _ነበረባ, 
   {{0x7d0418ed,0x92b400c6,0x272800e4,0x15440064}},	//   hnis, احظا, túne_, _бежм, 
   {{0xf48403e6,0x6f1402fb,0x25640014,0x2fd80042}},	//   _ناشی, vozc, _نانُ, wysg_, 
   {{0x6d4418ee,0x2ba418ef,0x7d0418f0,0x272800e4}},	//   _ruha, _ऑनला, jnis, rúne_, 
   {{0x7d0418f1,0x6d4418f2,0xdb0400e4,0x799c035a}},	//   dnis, _suha, _eské, _lprw, 
   {{0x6d4418f3,0x0dc818f4,0x02a000a7,0x69c00bcd}},	//   _puha, нуби_, _гръм, _áleg, 
   {{0x7d0418f5,0x6d44002e,0x864802d3,0x6f140866}},	//   fnis, _quha, _ሓጢኣት, rozc, 
   {{0x7d0418f6,0x6d4418f7,0x6c540474,0x506401af}},	//   gnis, _vuha, ркау, _стка, 
   {{0x6d4418f8,0xdbc40730,0x799c127b,0x6f1401e4}},	// [13f0] _wuha, röße, _aprw, pozc, 
   {{0x7d0418f9,0x9f400004,0x1df401d3,0x81c80154}},	//   anis, szkã_, اکیب_, _রেট_, 
   {{0x7d0418fa,0x629c013f,0xce300214,0x2b480784}},	//   bnis, ɑsod, _دودک, sqac_, 
   {{0xd244168d,0x01f8008f,0x61f40aa6,0x660c03e0}},	//   _ژن_, עפאל, úzli, şakk, 
   {{0x2d9005f5,0x0b8800a7,0x00000000,0x00000000}},	//   ltze_, _ясни_, --, --, 
   {{0x2d9001c4,0x6b9c02d0,0x00000000,0x00000000}},	//   otze_, _ipsg, --, --, 
   {{0x2d9018fb,0xe7240051,0xe4c40dab,0x00000000}},	//   ntze_, _cưỡ, ийки, --, 
   {{0x67d418fc,0x2d9001a1,0x23b418fd,0xe7240208}},	//   _кобу, itze_, لمعس, _dưỡ, 
   {{0xd76401ec,0xd3440133,0xe3b0007b,0x78a40037}},	//   _نەنى_, لینه_, زرة_, õive, 
   {{0x3ae404f3,0x00000000,0x00000000,0x00000000}},	//   _köpa_, --, --, --, 
   {{0x20c405f5,0x03c402dd,0x236c00d7,0x1b2000cc}},	//   айнм, _әсем, ssej_, _ভূঁই_, 
   {{0xf53000c6,0x236c18fe,0x00000000,0x00000000}},	//   _فإن_, psej_, --, --, 
   {{0x7d0418ff,0x3ae41900,0x8c380e78,0x2d901901}},	//   vnis, _löpa_, _maßs, etze_, 
   {{0x7d041902,0x00000000,0x00000000,0x00000000}},	//   wnis, --, --, --, 
   {{0x6b9c03ac,0xa3cc012d,0x00000000,0x00000000}},	//   _apsg, रहक_, --, --, 
   {{0x7d041903,0x8c40004e,0x00000000,0x00000000}},	//   unis, жете, --, --, 
  
   {{0x5a641904,0x7d041905,0x959802d3,0x2d901906}},	// [1400] икаб, rnis, _ለይትን_, atze_, 
   {{0x7d041907,0x799c03ac,0x00000000,0x00000000}},	//   snis, _pprw, --, --, 
   {{0x7d041908,0xb5fc0327,0x8e78011a,0x00000000}},	//   pnis, _reġo, _בניה, --, 
   {{0xd7f81909,0x7d04190a,0xfc040166,0x3ae401e3}},	//   кул_, qnis, _гомү, _döpa_, 
   {{0x9ac40014,0x00000000,0x00000000,0x00000000}},	//   _پۯاہ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x18a4059f,0x98a4030d,0xc6a0003b,0x00000000}},	//   _кавм, _киве, ірши, --, 
   {{0xe97001ec,0x63b80042,0xb788190b,0x23b003ce}},	//   _ءۇند, _brwn, _бәке_, जिंद, 
   {{0x63b803cb,0x1cb8031c,0x79540244,0x00000000}},	//   _crwn, _ཙོན_, _ئێڵا, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x80b00011,0x3ce00037,0x94a801ee,0xd4a4022e}},	//   টান্, kkiv_, _атла_, _вией, 
   {{0x1cb0031c,0x63b80142,0x8c38002f,0x8d740345}},	//   ྟབས_, _frwn, _maßr, یازا, 
   {{0x893400c8,0x63b80142,0xaac8190c,0x645c0165}},	//   ירטע_, _grwn, रामक, ñsie, 
   {{0xafc4030c,0x00000000,0x00000000,0x00000000}},	//   _ۇيعى, --, --, --, 
   {{0xdb040054,0x272800c6,0x8c6401b9,0x2d90005a}},	//   _askï, núna_, итад, utze_, 
   {{0x2d9001c0,0x8bb400d1,0x6fb40066,0x00000000}},	//   rtze_, ақму_, _همبا, --, 
   {{0x6f9400c6,0x00000000,0x00000000,0x00000000}},	// [1410] _الخض, --, --, --, 
   {{0x8d8400cf,0x8aa400ea,0x7bc000de,0x00000000}},	//   _кумд, јрад, _šmuc, --, 
   {{0xc984190d,0xdb2401d3,0x41bc190e,0x00000000}},	//   рузи, حولی, एमएस, --, 
   {{0xcc840133,0x00000000,0x00000000,0x00000000}},	//   _خۆره_, --, --, --, 
   {{0x47880408,0xfbc80b98,0xdc980a7c,0x1ac400cc}},	//   тсем_, रमणम, _גירל, _এতৰা, 
   {{0x27280af2,0xd5940092,0x00000000,0x00000000}},	//   fúna_, _መርምሮ_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe91800d6,0x64440477,0xe2840116,0x88440345}},	//   _собі_, _ğhis, әлни, _ئیشق_, 
   {{0xa824190f,0xdd001710,0xd5ac0014,0x5fc4000d}},	//   _اکان, šuću, وہے_, _लपइल, 
   {{0xa2e41910,0x27281911,0xe2c8009d,0x00000000}},	//   соод, búna_, улод_, --, 
   {{0xa0681912,0xa0c41913,0xe04401d5,0x00000000}},	//   лана_, ميدو, йнни, --, 
   {{0x21a4039b,0xa3b800ec,0x00000000,0x00000000}},	//   _ҳикм, _ماتر_, --, --, 
   {{0xe2981914,0x63b80223,0xc32c0014,0x00000000}},	//   _бал_, _urwn, _ہٕچ_, --, 
   {{0x63a81915,0x00000000,0x00000000,0x00000000}},	//   mwen, --, --, --, 
   {{0xd00c00db,0x00000000,0x00000000,0x00000000}},	//   _ۋلى_, --, --, --, 
   {{0x1c4400c0,0x00000000,0x00000000,0x00000000}},	//   снам, --, --, --, 
   {{0x2554002d,0xd0f8008f,0x00000000,0x00000000}},	// [1420] _hāld_, _תּור, --, --, 
   {{0x2554002d,0x9a681916,0x1cb8031c,0x63a801c7}},	//   _kāld_, امال_, _ཙོམ_, iwen, 
   {{0x63a81917,0x60d41918,0xdca4022e,0x00000000}},	//   hwen, _koym, _лани, --, 
   {{0x272800d2,0x60d4037e,0x57e81919,0x69c000bc}},	//   vúna_, _joym, лдем_, _šlec, 
   {{0x63a8191a,0x00000000,0x00000000,0x00000000}},	//   jwen, --, --, --, 
   {{0x63a8191b,0x60d40477,0xaac81221,0x8f9800d9}},	//   dwen, _loym, राणक, ריסי, 
   {{0x63a8191c,0xc7ac01ed,0x38600174,0xc0f80092}},	//   ewen, وڑے_, ðirs_, ፈጽሙ_, 
   {{0x63a8191d,0xf4d8191e,0x98a416a3,0x2728191f}},	//   fwen, рмиш_, dmoć_, rúna_, 
   {{0x96941920,0x73340116,0x00000000,0x00000000}},	//   _греш, يىبا, --, --, 
   {{0xd344036b,0x69c00077,0x77e401ad,0x00000000}},	//   لیچه_, _álec, कनीक_, --, 
   {{0x3ae40793,0x60d401a9,0x63a80036,0x51840108}},	//   _löpo_, _boym, awen, щупа, 
   {{0x63a81921,0x60d40076,0x39580789,0x66dc007f}},	//   bwen, _coym, _mtrs_, _rèki, 
   {{0x63a80944,0x60d41922,0x94a801ee,0x03a000f3}},	//   cwen, _doym, _атһа_, _ницо, 
   {{0xb5fc038f,0x66dc0100,0x39581923,0x63bc1924}},	//   _reġj, _pèki, _otrs_, æsne, 
   {{0xc170007b,0x70581925,0x00000000,0x00000000}},	//   _فديت, _кайр_, --, --, 
   {{0x9984006d,0x60d41926,0x90e41927,0x48c000fe}},	//   łoś_, _goym, _دستن, _শত্ৰ, 
   {{0xdb0400e4,0x4f6801d5,0x4ea400d8,0x8c40030d}},	// [1430] _eskí, _ёшим_, _лрна, çесе, 
   {{0x6e980006,0xaac800bc,0x25a80210,0x00000000}},	//   _твор_, राधक, łali_, --, 
   {{0x63a81928,0x7f3c00c8,0x39580334,0x60d40718}},	//   zwen, _געזו, _ctrs_, _yoym, 
   {{0x63a81929,0x0ca8192a,0x6aa40112,0x77540023}},	//   ywen, _стои_, sehf, _ዝተመሰ, 
   {{0x63a8192b,0x3958004e,0x25540055,0x78a4000d}},	//   xwen, _etrs_, _māle_, õiva, 
   {{0x9ba0192c,0xe738192d,0x63a8192e,0x201c054e}},	//   _تەكى, шел_, vwen, ştig_, 
   {{0x63a8192f,0x55501930,0x04140241,0x00000000}},	//   wwen, وپور, _àjẹk, --, 
   {{0x3ddc0154,0x00000000,0x00000000,0x00000000}},	//   _ডেডল, --, --, --, 
   {{0x68e81931,0x63a81932,0xd36c05d9,0x98f000aa}},	//   _iled, uwen, نهي_, _تګلا, 
   {{0x63a81933,0x68e8038e,0x60d41934,0x2bd000bc}},	//   rwen, _hled, _soym, _सपना, 
   {{0x63a81935,0x68e81936,0x2b58070d,0x290c0158}},	//   swen, _kled, _ltsc_, _kjea_, 
   {{0x63a81937,0x60d41938,0x68e8020c,0x00000000}},	//   pwen, _qoym, _jled, --, 
   {{0x63a80912,0x2b581939,0x60d4062c,0x442400db}},	//   qwen, _ntsc_, _voym, _اراف, 
   {{0x68e80368,0x539802e4,0x77640003,0x00000000}},	//   _lled, _כינו, ġixx, --, 
   {{0x8234193a,0x2b580098,0x290c0005,0x60d4193b}},	//   _ارشا, _atsc_, _ojea_, _toym, 
   {{0x3958193c,0xb3700050,0xdf480276,0xdb0c02d2}},	//   _rtrs_, _تۯیش, _кзид_, _íjúl, 
   {{0xa2cc193d,0xc0f00092,0x00000000,0x00000000}},	// [1440] ताप्, _ሃምሳ_, --, --, 
   {{0x68e8193e,0x290c005a,0x255400e2,0xe7240133}},	//   _aled, _ajea_, _zāle_, _سڵ_, 
   {{0x68e8193f,0x00000000,0x00000000,0x00000000}},	//   _bled, --, --, --, 
   {{0x68e81940,0x718c00df,0xedc801f7,0x00000000}},	//   _cled, רװאַ, _اِٽي_, --, 
   {{0x68e8020c,0x26c401e7,0x26e4033f,0x27281941}},	//   _dled, _bnlo_, कसूर_, rúnn_, 
   {{0x68e81942,0x61ec0b45,0x290c0789,0xda700014}},	//   _eled, _ƙall, _ejea_, _زُر_, 
   {{0x68e81943,0xa2cc1944,0x7a3001e1,0xf8b81945}},	//   _fled, तान्, _dótí, _гөл_, 
   {{0xe3b8031c,0x86040131,0x983400c0,0x00000000}},	//   _ཙནྡ྄, تقىق_, _дэзі, --, 
   {{0xded0069c,0x394401f9,0x00000000,0x00000000}},	//   _ከምኡ_, _iims_, --, --, 
   {{0xb5fc003d,0x068000cf,0x00000000,0x00000000}},	//   _leġi, _огун, --, --, 
   {{0x611000e2,0xf7080208,0x68e803ac,0x255400b8}},	//   zāle, của_, _yled, _pāle_, 
   {{0x39441946,0x4fc40150,0x00000000,0x00000000}},	//   _jims_, осга, --, --, 
   {{0x39440b0e,0x7afc0010,0xe4c802e9,0xc498011a}},	//   _mims_, _omrt, _دبلن_, _כשאת, 
   {{0xdb0401ef,0x00000000,0x00000000,0x00000000}},	//   _prký, --, --, --, 
   {{0xccf80640,0xb62c00b5,0xad240d1f,0x25540055}},	//   аћа_, _ｒｈ_, كىسى, _tāle_, 
   {{0x39440793,0x66dc00f2,0x201407ea,0x8b6400c6}},	//   _nims_, _hèkt, écié_, قائم, 
   {{0xebc4013d,0x00000000,0x00000000,0x00000000}},	// [1450] чәнн, --, --, --, 
   {{0x6110005f,0x39441947,0x29c801e0,0x63bc0efa}},	//   rāle, _aims_, йтеү_, åsni, 
   {{0xba7410e0,0xe9441056,0x68e81948,0x7bc008ce}},	//   باقت, سرای, _pled, _ámun, 
   {{0x39441949,0x66dc007f,0x7648010b,0x68e8037e}},	//   _cims_, _lèkt, _agdy, _qled, 
   {{0x7afc0cf9,0x3944005c,0x68e8194a,0xa2cc194b}},	//   _fmrt, _dims_, _vled, ताम्, 
   {{0x2ca8194c,0x68e813e9,0x9ba00c50,0xf770194d}},	//   lead_, _wled, _سەمى, ئان_, 
   {{0xd6cc194e,0x68e8194f,0x39440100,0x00000000}},	//   اقى_, _tled, _fims_, --, 
   {{0x2ca81950,0xaac800dc,0x999401d9,0x68e803ac}},	//   nead_, रावक, _ژھۆر_, _uled, 
   {{0x291c1951,0xe2981952,0x2c1c00fe,0x53c400db}},	//   mowa_, бап_, পেৰে_, згым_, 
   {{0x291c1953,0x66dc01e1,0x26c40241,0xb9e01954}},	//   lowa_, _pèku, _unlo_, _ጥብ_, 
   {{0x7d080122,0xe1241955,0xd1dc02d3,0xe298190b}},	//   édsk, змни, _ዕርቂ_, _ғай_, 
   {{0x23741956,0xd5980375,0x00000000,0x00000000}},	//   _فاتح, _לבעל, --, --, 
   {{0x2ca81957,0xb5fc038f,0x44380694,0x626400d8}},	//   dead_, _reġi, _àq_, _евла, 
   {{0x291c1958,0x248c1959,0x442c195a,0x835001d3}},	//   howa_, lgem_, _izg_, _ٹھکا, 
   {{0x66dc0066,0x291c195b,0x2ca800c6,0xb4540133}},	//   _hèks, kowa_, fead_, _رخۆش, 
   {{0x248c092e,0x7afc0118,0x2ca80354,0x61e0195c}},	//   ngem_, _smrt, gead_, myll, 
   {{0x291c195d,0x6ab40115,0x61e0195e,0x3944195f}},	// [1460] dowa_, _bazf, lyll, _rims_, 
   {{0xe3280156,0x8b200b32,0x4b2003b7,0x66dc0066}},	//   _ཤེསཔ_, едуе, емув, _mèks, 
   {{0x61e01960,0x66dc020c,0x291c1961,0x00000000}},	//   nyll, _lèks, fowa_, --, 
   {{0x291c1962,0x442c01a9,0x2ca801c3,0x61e000ad}},	//   gowa_, _ozg_, cead_, iyll, 
   {{0x4cb8025f,0x61e01963,0x6cc407d6,0x39440158}},	//   _הזכו, hyll, _ўқув_, _vims_, 
   {{0x61e00652,0xb4b40c2e,0x248c0036,0x645c0165}},	//   kyll, _छोड़_, egem_, ñsin, 
   {{0x291c1964,0x61e01965,0x3944014a,0x66dc020c}},	//   bowa_, jyll, _tims_, _rèkt, 
   {{0x94a80d30,0x38c804d3,0x442c05c7,0x61e01966}},	//   стка_, _باسی_, _bzg_, dyll, 
   {{0x61e000ad,0x81c803d4,0x57e801c6,0x69d00356}},	//   eyll, _ৰেল_, _удам_, ădeş, 
   {{0x61e01967,0x248c0261,0x76480006,0x6b480024}},	//   fyll, agem_, _ugdy, _užge, 
   {{0x66dc0066,0x9f4c0030,0xbbc80864,0x442c022e}},	//   _vèkt, ľným_, रमुक, _ezg_, 
   {{0xc0580046,0x9f4c0122,0x66dc020c,0x442c0112}},	//   зір_, žným_, _wèkt, _fzg_, 
   {{0x61e00731,0xc2041968,0x942400db,0x2ca81163}},	//   ayll, ققین_, _эмде, vead_, 
   {{0x61e01969,0x61340008,0x291c196a,0x823003c7}},	//   byll, jálf, zowa_, ظریا, 
   {{0x291c196b,0xac94196c,0x255400cd,0x4298011a}},	//   yowa_, мавш, _kāla_, _הסוב, 
   {{0x291c196d,0x255400b8,0x48b400fe,0x00000000}},	//   xowa_, _jāla_, _অক্ৰ, --, 
   {{0x57c40574,0x2ca80fb2,0x8aa4196e,0x0f2402bf}},	// [1470] लमोह, read_, зред, _ньом, 
   {{0x291c196f,0x2ca81970,0x61100aed,0xf1b01971}},	//   wowa_, sead_, māla, _जनान, 
   {{0xa2cc085c,0x291c1972,0x80b0015b,0x2ca800c5}},	//   तात्, towa_, টার্, pead_, 
   {{0xfbd01973,0xdddc0316,0xbb50037e,0xd1e0001f}},	//   ختہ_, _nepř, _dgmシ_, _ምኞት_, 
   {{0x291c1974,0x61100061,0xa7b80137,0x00000000}},	//   rowa_, nāla, юлду_, --, 
   {{0x291c1975,0xd2440597,0xe5a40075,0xdb040140}},	//   sowa_, _لن_, дики, _askæ, 
   {{0x67200fb7,0x248c00cf,0x61101976,0xd5ac0691}},	//   _vklj, tgem_, hāla, لفو_, 
   {{0x61101977,0x61e01978,0x248c1979,0x00000000}},	//   kāla, vyll, ugem_, --, 
   {{0x248c197a,0x61e000a9,0xed80044e,0xddcc0086}},	//   rgem_, wyll, _ክግበር_, rabũ, 
   {{0x67200bb8,0xb9dc067d,0x61e0197b,0x80a0197c}},	//   _uklj, _በቲ_, tyll, ग्ने, 
   {{0x61e00076,0xdfd000ec,0x00000000,0x00000000}},	//   uyll, ھيس_, --, --, 
   {{0x61e0197d,0x66dc07b0,0xa2bc197e,0xdfd001c8}},	//   ryll, _tèks, _वोर्, پيس_, 
   {{0x61e00f7b,0x1ea8197f,0xf484074d,0xa2cc0303}},	//   syll, ياسي_, _чухн, ताद्, 
   {{0x61e01980,0x216800d1,0x95940023,0xdddc013a}},	//   pyll, _дики_, _ዘርብሕ_, _zepř, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc4d8015b,0x1be80353,0x61101981,0x00000000}},	//   _বগুড়, одби_, bāla, --, 
   {{0x645802ce,0xaac80d79,0x613401f6,0x6110002b}},	// [1480] _mfwi, रांक, tálf, cāla, 
   {{0x4f041982,0x4aa40137,0x3ae4010e,0xec3401b9}},	//   _онын_, мкун_, _köpi_, رولگ, 
   {{0x64581983,0x98480126,0x61341984,0xd1dc0092}},	//   _ofwi, ояла_, rálf, _ዕይታ_, 
   {{0x395c005f,0x48e01985,0x00000000,0x00000000}},	//   īvs_, кохв, --, --, 
   {{0x7d041986,0xda641987,0x48dc0037,0x00000000}},	//   miis, _ياسي, _ककरो_, --, 
   {{0x7d041988,0x64581989,0x3f5402b5,0x66dc0066}},	//   liis, _afwi, _mäu_, _sèkr, 
   {{0x0570198a,0x25a40036,0xdddc0118,0x255400b8}},	//   نايد, _cpll_, _pepř, _pāla_, 
   {{0x73d8086f,0x46e40724,0xd378074d,0xc5f000cc}},	//   здир_, здән_, очо_, _চুঙা_, 
   {{0xdddc00bc,0x25540055,0x00000000,0x00000000}},	//   _vepř, _vāla_, --, --, 
   {{0x7d04198b,0x64580117,0x66800014,0x68e80327}},	//   hiis, _efwi, _میٖل, _ċedi, 
   {{0x7d04198c,0xdb0400fd,0x2554198d,0x569401af}},	//   kiis, _iskä, _tāla_, _наҡт, 
   {{0x6110198e,0x7d04198f,0xcfa401c6,0x3214002b}},	//   tāla, jiis, мшги, _ādyā_, 
   {{0x7d041990,0x230800aa,0xb9e0001f,0x6b480010}},	//   diis, _کتني_, _ጥጥ_, _ožga, 
   {{0x61101991,0x69c000f3,0x75201992,0x60640022}},	//   rāla, _šlem, lomz, _ҧхыҷ, 
   {{0x7d040050,0x2fcc0356,0x00000000,0x00000000}},	//   fiis, ţeg_, --, --, 
   {{0x7d041993,0x75200921,0x201c0276,0x611000dc}},	//   giis, nomz, ştia_, pāla, 
   {{0xfd4402d5,0xdb0401e3,0x00000000,0x00000000}},	// [1490] тэрн, _oskä, --, --, 
   {{0x0dc806bb,0xc98407d6,0x705401d9,0x94000213}},	//   _думи_, дуди, _تچھا, ükə_, 
   {{0x7d041994,0x75200912,0x61ec02a8,0x00000000}},	//   biis, komz, _ƙali, --, 
   {{0x7d041995,0xa8141996,0x61340789,0x00000000}},	//   ciis, ндеш, rálg, --, 
   {{0xa874005e,0x78640046,0xc7a81997,0xd874007b}},	//   _үлгі, ткіз, تدال_, رموت_, 
   {{0x797c1682,0x6b8c1998,0x7ac41999,0x00000000}},	//   _ṅwet, muag, _иссе, --, 
   {{0xa2cc0882,0x2cb816b8,0x6b8c199a,0xdcec00c0}},	//   तास्, _kasd_, luag, gubė, 
   {{0xdb04013d,0x75200156,0x00000000,0x00000000}},	//   _eskä, gomz, --, --, 
   {{0x61340122,0x6b8c199b,0x2408199c,0xe298199d}},	//   nále, nuag, янии_, пап_, 
   {{0xe1f8199e,0x6b8c0076,0x7d04199f,0xd1b800ec}},	//   зго_, iuag, ziis, ڳاپا_, 
   {{0x6b8c0421,0xb59400c7,0x77500023,0x7d0419a0}},	//   huag, _аихш, _ንተሳተ, yiis, 
   {{0x7d040014,0x68f8029f,0x8cd003ce,0x33b000db}},	//   xiis, _çadı, डाफो, _چەير, 
   {{0x7d0419a1,0x6b8c0407,0xdb04005b,0x255400dc}},	//   viis, juag, _yskä, _kālo_, 
   {{0x61340232,0x6b8c19a2,0x7d0419a3,0x2d5400fe}},	//   dále, duag, wiis, _båe_, 
   {{0x7d0419a4,0xdca40fd7,0xa0a419a5,0x6b8c0076}},	//   tiis, нави, _зайд, euag, 
   {{0x6b8c096b,0x611019a6,0x3f5400b0,0x00000000}},	//   fuag, mālo, _täu_, --, 
   {{0x7d0419a7,0x613419a8,0x6b8c19a9,0x1954037e}},	// [14a0] riis, ráld, guag, _ｊｕｎ_, 
   {{0x7d0419aa,0x2cb80077,0x752019ab,0x2d540158}},	//   siis, _easd_, zomz, _fåe_, 
   {{0x7d0419ac,0x752019ad,0x6b8c00ad,0x611019ae}},	//   piis, yomz, auag, nālo, 
   {{0x7d0419af,0x2cb801c3,0x21200066,0x6b480427}},	//   qiis, _gasd_, nokh_, _vžga, 
   {{0xbb440124,0x255400cd,0x82540092,0xe7940014}},	//   _аҵак, _bālo_, _ቁሳቁሶ, ناوک, 
   {{0x7520014b,0xdb0c01e1,0x00000000,0x00000000}},	//   womz, _ìjàl, --, --, 
   {{0x1868016c,0x940800ac,0x6b480153,0xaa280014}},	//   _нави_, əbə_, _užga, _ہسہٕ_, 
   {{0xdb040036,0x2cb8002e,0xd94419b0,0x932400f2}},	//   _opkë, _xasd_, _чеби, کربن, 
   {{0xc6c00046,0x7520002f,0xc7a00139,0x00000000}},	//   _өйтк, romz, _йитк, --, 
   {{0xb6c8040b,0x877802e4,0x518419b1,0x27e805ac}},	//   _تارے_, _מאמי, нума, øane_, 
   {{0x61340122,0xe6d80008,0x7520009f,0x6b8c005a}},	//   zále, _þráð, pomz, zuag, 
   {{0x6b8c020b,0x2d5403cd,0x814402f2,0x00000000}},	//   yuag, _råe_, ێنین, --, 
   {{0x201c19b2,0x2cb80165,0xa2cc00dc,0x6b8c009d}},	//   ştin_, _rasd_, ताश्, xuag, 
   {{0x6b8c00ca,0x27280321,0x613419b3,0x3ddc0154}},	//   vuag, túni_, vále, _ডেইল, 
   {{0xa2cc0882,0x00000000,0x00000000,0x00000000}},	//   तार्, --, --, --, 
   {{0x6b8c19b4,0x0ccc09bd,0x613402fb,0x6110005f}},	//   tuag, রস্ত, tále, nāll, 
   {{0x7d2402e7,0xc32001af,0x8538011a,0x00000000}},	// [14b0] افقن, _шмәк, לגלי, --, 
   {{0x6b8c19b5,0xbb8419b6,0xca700133,0x61340118}},	//   ruag, اللي, اناک, rále, 
   {{0x6b8c19b7,0x6134043b,0xbf1419b8,0x00000000}},	//   suag, sále, _сүрә, --, 
   {{0x61340122,0x6c7800c8,0x6b8c04c9,0x2cb80789}},	//   pále, _קאָפ, puag, _uasd_, 
   {{0x6b8c19b9,0x255400b8,0x00000000,0x00000000}},	//   quag, _pālo_, --, --, 
   {{0xf1b0012d,0x00000000,0x00000000,0x00000000}},	//   जबान, --, --, --, 
   {{0xdb0c01e1,0x00000000,0x00000000,0x00000000}},	//   _ìjál, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69c000bc,0xd9b000db,0x233419ba,0x25540171}},	//   _šleh, _مەەد, кхор, _tālo_, 
   {{0xa2e419bb,0xdb880150,0x06a800cc,0x00000000}},	//   тоод, _ﺗﻪﺯﻯ_, _গচকি, --, 
   {{0xe3b019bc,0x182801d3,0x00000000,0x00000000}},	//   _چرت_, _فقہی_, --, --, 
   {{0x656019bd,0xf49419be,0xd24c0014,0x00000000}},	//   _itlh, _مشهد, ٝنی_, --, 
   {{0x3ae4049f,0xfe7819bf,0xe29819c0,0x9878010f}},	//   _köpt_, нүп_, _жал_, וארט, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61ec0b45,0x65600455,0x81c40171,0x00000000}},	//   _ƙalu, _jtlh, _blēž, --, 
   {{0xe6d801a8,0x3ae4007c,0x00000000,0x00000000}},	//   _þræð, _löpt_, --, --, 
   {{0x1c4419c1,0x9fac0051,0x00000000,0x00000000}},	// [14c0] тнам, gđôg_, --, --, 
   {{0x6560014c,0xa3c8000d,0x00000000,0x00000000}},	//   _otlh, _लछन_, --, --, 
   {{0x656019c2,0xd94419c3,0xdcec05d1,0x6134021c}},	//   _ntlh, вежи, şkır, cálc, 
   {{0x3ae400b0,0xb4b000c5,0x6b4800c0,0xd86000c7}},	//   _röpu_, _ओसे_, _užgn, рҵаҩ, 
   {{0x656019c4,0x64540118,0x00000000,0x00000000}},	//   _atlh, ězil, --, --, 
   {{0xb8700092,0x00000000,0x00000000,0x00000000}},	//   _አሮጌው_, --, --, --, 
   {{0xe71c037e,0x3ae401e3,0xb27400d1,0xe8b019c5}},	//   _vs嵐_, _döpt_, ңлиш, _گەنج, 
   {{0x399c19c6,0x48e01214,0x98a419c7,0xf4340209}},	//   mís_, _косв, _шибе, лейэ, 
   {{0x656019c8,0x969419c9,0x399c19ca,0xd1e00023}},	//   _etlh, _ареш, lís_, ምዒት_, 
   {{0xf1b000bc,0x69c000c0,0x00000000,0x00000000}},	//   _जनआन, _šlei, --, --, 
   {{0x399c19cb,0x00000000,0x00000000,0x00000000}},	//   nís_, --, --, --, 
   {{0x61340118,0x3ae401e3,0x7cf801d3,0x13e8004e}},	//   válc, _köps_, _hírf, _омей_, 
   {{0x399c0597,0x53b406b1,0x9fa401e0,0xa2bc19cc}},	//   hís_, _अनिश, лырҙ, _वोक्, 
   {{0x80b005ac,0x272819cd,0xf19401af,0x59e000cd}},	//   টাগ্, búnu_, _бикь, पहार, 
   {{0x799c003a,0x00000000,0x00000000,0x00000000}},	//   _nqrw, --, --, --, 
   {{0x399c19ce,0x69c005f7,0xdeb001ec,0x7094014b}},	//   dís_, _álei, _құсы, _саиф, 
   {{0x19c00032,0x7b7400ae,0x00000000,0x00000000}},	// [14d0] ҙәрг, لطلا, --, --, 
   {{0x613419cf,0x399c19d0,0x7af400d4,0x00000000}},	//   mála, fís_, азує, --, 
   {{0xd36419d1,0xce3019d2,0x613400dd,0x399c180f}},	//   _گه_, _خودک, lála, gís_, 
   {{0xfc640c04,0x2d9019d3,0x656001c7,0x50c000dc}},	//   _върн, muze_, _rtlh, षयिष, 
   {{0xd36419d4,0x613400dd,0x9cd40302,0x2d9019d5}},	//   _ده_, nála, _עושה_, luze_, 
   {{0x76c40131,0xddcc19d6,0x399c067c,0xa5b80640}},	//   لغىل, labš, bís_, ећих_, 
   {{0x399c19d7,0x61340597,0x2d900223,0xf9d419d8}},	//   cís_, hála, nuze_, _корэ, 
   {{0x65600455,0x00000000,0x00000000,0x00000000}},	//   _vtlh, --, --, --, 
   {{0x2d9019d9,0x00000000,0x00000000,0x00000000}},	//   huze_, --, --, --, 
   {{0x2d9019da,0xba0800b7,0x613419db,0xdb0403b2}},	//   kuze_, _ገባ_, dála, _sskú, 
   {{0x2d9019dc,0x6560047e,0xb1d80108,0x00000000}},	//   juze_, _utlh, вьях_, --, 
   {{0x2d90016c,0x201c03ee,0x00000000,0x00000000}},	//   duze_, ştim_, --, --, 
   {{0x613419dd,0x2d9001f5,0xd24c00f1,0x6384005b}},	//   gála, euze_, تنۍ_, _сгла, 
   {{0x2d9019de,0xe29819df,0x272819e0,0x6d40004a}},	//   fuze_, _чак_, múns_, ïlan, 
   {{0x2d9019e1,0xd3340375,0x931019e2,0x399c004e}},	//   guze_, _גרסה_, _دووش, xís_, 
   {{0x399c19e3,0x613401e7,0x00000000,0x00000000}},	//   vís_, bála, --, --, 
   {{0x613419e4,0x5f2806ed,0x00000000,0x00000000}},	// [14e0] cála, _поим_, --, --, 
   {{0x80a019e5,0x3f8019e6,0x399c19e7,0x6b480064}},	//   ग्रे, _iviu_, tís_, _užgl, 
   {{0x588419e8,0x80d80490,0x2d900526,0x8cbc19e9}},	//   гыла, यापे, cuze_, _लोको, 
   {{0x399c19ea,0x3ae401b8,0xd83819eb,0x00000000}},	//   rís_, _pöps_, нэл_, --, 
   {{0xb8dc19ec,0xdef40201,0x399c180f,0xd708010b}},	//   _अस_, _ለምን_, sís_, ннде_, 
   {{0xd5b819ed,0x399c19ee,0x00000000,0x00000000}},	//   еси_, pís_, --, --, 
   {{0x7bc419ef,0x63b80113,0x98a40421,0x613400e5}},	//   lviu, _aswn, aloā_, zála, 
   {{0xdb0408fb,0xa2a80412,0x97740c4f,0x7bc40064}},	//   _askø, _जॉब्, _مُرش, oviu, 
   {{0x27280f71,0x12e40046,0x7bc419f0,0x705419f1}},	//   gúns_, гінг, nviu, یندا, 
   {{0x7cf819f2,0x613400dd,0x7bc419f3,0x2d9019f4}},	//   _fírg, vála, iviu, yuze_, 
   {{0x3f8019f5,0xb9cc02d3,0x7cf8004e,0x80b0015b}},	//   _aviu_, _ኰነ_, _gírg, য়ান্, 
   {{0x2d9019f6,0x613419f7,0xd1c8151e,0x27280332}},	//   vuze_, tála, _үлде_, súnt_, 
   {{0x8cbc006d,0x8fe0052f,0x2d9019f8,0x72d403a6}},	//   _लोगो, сәйҙ, wuze_, _волф, 
   {{0x61340597,0x438019f9,0x838000aa,0x2d9019fa}},	//   rála, _الوق, _اټوم, tuze_, 
   {{0x613419fb,0x518419fc,0xad2417de,0x7bc40393}},	//   máln, _сула, لىسى, eviu, 
   {{0x2d90043b,0x613401ed,0xaf5400c7,0x00000000}},	//   ruze_, láln, _ҩнқә, --, 
   {{0x7bc40d04,0xc0c0001f,0x2d9004ba,0x23680327}},	// [14f0] gviu, ትንም_, suze_, _ħajk_, 
   {{0x613419fd,0x2fc819fe,0x3a380204,0x63bc037e}},	//   náln, _irag_, _bzrp_, æsni, 
   {{0xc330025f,0x7bc40869,0xa85400cf,0x00000000}},	//   צוע_, aviu, акеч, --, 
   {{0x2fc80151,0x3f800ffb,0x80d800dc,0xcb440209}},	//   _krag_, _yviu_, याये, _әхми, 
   {{0x613419ff,0x6f14010a,0x7bc40356,0x80b000eb}},	//   káln, onzc, cviu, টাচ্, 
   {{0x6b8c1a00,0x2fc801ab,0x613402f0,0x8038010f}},	//   mrag, _mrag_, jáln, אנדע_, 
   {{0x6b8c1a01,0xdac40075,0xeb341a02,0x61341a03}},	//   lrag, _خېلى_, _مىڭد, dáln, 
   {{0x2bc81a04,0x63841a05,0x7cf81a06,0x6b8c1368}},	//   रिपा, агиа, _vírg, orag, 
   {{0x2fc80218,0xe6940276,0x61340306,0x6b8c1a07}},	//   _nrag_, _визы, fáln, nrag, 
   {{0x61101a08,0x61341a09,0x36d401af,0x201c05d1}},	//   māli, gáln, _лоур, ştik_, 
   {{0x7cf8066d,0x6b8c1a0a,0x2fc801d9,0x6ed8146b}},	//   _híre, hrag, _arag_, मानु, 
   {{0xe0441a0b,0x2fc81a0c,0x6b8c1a0d,0x6f140007}},	//   инни, _brag_, krag, enzc, 
   {{0x613403f7,0x9f040a2c,0x2fc81a0e,0x6110005f}},	//   báln, لوحو, _crag_, nāli, 
   {{0x7cf800c6,0xd5c002b5,0x2fc81a0f,0xdcec00bc}},	//   _míre, _whāū_, _drag_, ědče, 
   {{0x6b8c0731,0x442c1a10,0xdc981a11,0x255400ef}},	//   erag, _hyg_, кташ_, _bāli_, 
   {{0x6b8c1a12,0xa2cc00a5,0x2fc81a13,0x61101a14}},	//   frag, ताक्, _frag_, kāli, 
   {{0x6b8c1a15,0x613400dd,0x9b041a16,0x2fc8017a}},	// [1500] grag, lálo, азад, _grag_, 
   {{0x7bc41a17,0x442c00b5,0x0f78011a,0x61100a88}},	//   rviu, _myg_, _שאיב, dāli, 
   {{0x61340765,0x442c0006,0x7e7c1a18,0x6b8c1a19}},	//   nálo, _lyg_, marp, arag, 
   {{0x6b8c1368,0x7e7c1a1a,0x98a41a1b,0x18a41a1c}},	//   brag, larp, риде, радм, 
   {{0x7bc40d04,0xc7a00e91,0x78b00024,0x6b8c1a1d}},	//   qviu, жичк, _įkvė, crag, 
   {{0x7cf80491,0x7e7c0af5,0x61340cde,0x255400e2}},	//   _díre, narp, kálo, _zāli_, 
   {{0x7e7c013c,0x7cf8007b,0x442c1a1e,0x61341a1f}},	//   iarp, _tírd, _ayg_, váln, 
   {{0x7e7c1a20,0x442c04ce,0xd3a41a21,0xd6e00210}},	//   harp, _byg_, ароп, wałą_, 
   {{0x2bc808dd,0x613403c6,0x395801c7,0x08f80014}},	//   रिया, táln, _hurs_, _شرٲب_, 
   {{0x06f01a22,0x7e7c1a23,0xa2cc00cd,0x00000000}},	//   _अतएव_, jarp, ताग्, --, 
   {{0x61341a24,0x7e7c1a25,0xc68c0014,0x7054158b}},	//   ráln, darp, _زِن_, ینگا, 
   {{0x6b8c0731,0x39581a26,0x2d8400bc,0xd38800a7}},	//   yrag, _murs_, álem_, _айде_, 
   {{0x6ef80268,0x7e7c03cb,0x03a000d8,0x052401af}},	//   _lìbe, farp, _мицо, _тоцк_, 
   {{0x6b8c1a27,0x7e7c1a28,0x2fc81a29,0x613401d3}},	//   vrag, garp, _vrag_, láll, 
   {{0x13b40cb2,0x395800a3,0x2bc81a2a,0x61341a2b}},	//   _अनुभ, _nurs_, रिभा, cálo, 
   {{0x7e7c0140,0x90e403e6,0x613401ed,0x6c54068e}},	//   aarp, _خستن, náll, скау, 
   {{0x6b8c1a2c,0x2fc80098,0xfbd0007b,0x3d080037}},	// [1510] urag, _urag_, وتك_, _सगरे_, 
   {{0x6b8c1a2d,0x395805d1,0x2bc80b4c,0x00000000}},	//   rrag, _burs_, रिबा, --, 
   {{0x39581a2e,0x6b8c1a2f,0x7cf801e7,0x6e280790}},	//   _curs_, srag, _dírb, şebb, 
   {{0x6b8c1a30,0x6110005f,0x69c40158,0x69c000e2}},	//   prag, tāli, rvhe, _šles, 
   {{0xd5ac0050,0x613400e5,0x9cd4011a,0xa7a80114}},	//   ہہٕ_, dáll, _הורה_, укла_, 
   {{0x39580561,0x442c1a31,0x69c402c4,0x7cf8007b}},	//   _furs_, _ryg_, pvhe, _víre, 
   {{0xa50803b7,0x442c1a32,0x094800c7,0x39581a33}},	//   лека_, _syg_, _ачаи_, _gurs_, 
   {{0x201c084c,0x613401ed,0xa84801ed,0x7e7c1a34}},	//   ştii_, gáll, _ملزم_, zarp, 
   {{0xe3b000c6,0xf77018fd,0x7e7c1a35,0x232801f0}},	//   سرة_, _ياك_, yarp, лоии_, 
   {{0x61341a36,0xd3441a37,0x69c002d2,0x232800d8}},	//   tálo, مینه_, _áles, ѓони_, 
   {{0x7e7c1a38,0x2b58004e,0x2d8402f0,0xca3c02dd}},	//   varp, _lusc_, šlej_, _ﺟﺎﺯ_, 
   {{0x613403f7,0x30741a39,0x66dc007f,0x442c1a3a}},	//   rálo, журс, _rèky, _tyg_, 
   {{0x7e7c1a3b,0x442c07d6,0x62240131,0x61440075}},	//   tarp, _uyg_, شىڭل, _һека, 
   {{0x7e7c013c,0x5de40022,0x95981954,0x00000000}},	//   uarp, бжга, _ወርቅን_, --, 
   {{0x61441a3c,0x7e7c1a3d,0x80d81a3e,0x613400e5}},	//   _лека, rarp, यादे, lálm, 
   {{0x7e7c1a3f,0x3d080574,0x2b581a40,0x02b41546}},	//   sarp, _सगळे_, _busc_, _असुन, 
   {{0x7e7c1a41,0x39581a42,0xbe54004b,0x8c401a43}},	// [1520] parp, _surs_, _وردګ, зете, 
   {{0x7e7c0680,0x39581570,0x613401ed,0x6ed8194b}},	//   qarp, _purs_, záll, माणु, 
   {{0x2b580327,0x1d0800ee,0x8e380451,0x8e54008f}},	//   _eusc_, _бени_, _مسٽر_, _לייג_, 
   {{0x2b581a44,0x7e600134,0x39580010,0xd00c00f2}},	//   _fusc_, ɛmpa, _vurs_, _آلی_, 
   {{0x25541a45,0x61341a46,0x02b41a47,0x2bc800dc}},	//   _mālu_, váll, _असंभ, रिणा, 
   {{0x611006c8,0x3ce01a48,0x39581a49,0x7cf80332}},	//   mālu, ljiv_, _turs_, _fírc, 
   {{0xceb00302,0x61100421,0x39580d27,0x613401ed}},	//   פיה_, lālu, _uurs_, táll, 
   {{0x3ce007f5,0x4d78010f,0x8a000166,0x8a14011a}},	//   njiv_, ארקע, _эзсе, _החלו_, 
   {{0xbee80490,0x95c40214,0xe5080208,0x38600113}},	//   _ऐकून_, _گياه, vặt_, ñiru_, 
   {{0x27f8007d,0x2bc8193d,0x2d8419b3,0xa6a80345}},	//   _üsna_, रिता, álek_, _نامق_, 
   {{0x2d84031c,0xc6d4009d,0x00000000,0x00000000}},	//   ġlek_, _устө, --, --, 
   {{0x61101a4a,0x463800c8,0x613401ed,0xca340375}},	//   kālu, _געבע, lálj, מניה_, 
   {{0x92d404c5,0xd4340137,0x304800ec,0x00000000}},	//   _সতী_, _اعاب, شلسٽ_, --, 
   {{0x613400dd,0x2b5800db,0x41701a4b,0x00000000}},	//   nálj, _rusc_, _کاوس, --, 
   {{0xc2781a4c,0xe2a81a4d,0x2b5801fa,0x0ca80107}},	//   _גרוי, _خانن_, _susc_, лтаи_, 
   {{0xdb0400dd,0x6b740139,0x00000000,0x00000000}},	//   _eskü, жлау, --, --, 
   {{0x61101140,0xa2cc08e6,0x3b540107,0x996000d0}},	// [1530] gālu, ताच्, зкур, _ríše_, 
   {{0x7cf8004e,0xdd9005d9,0x34c41a4e,0x6e9400ae}},	//   _pírc, _ڪوٽ_, वयुद, _بلدا, 
   {{0x99600232,0x2b580161,0x0dc81a4f,0x6908022e}},	//   _píše_, _wusc_, _супи_, аsdа, 
   {{0xdcb01a50,0x2b580393,0x4a7401e0,0x38580127}},	//   _قىپ_, _tusc_, рыҡт, مشهد_, 
   {{0x6fc801ad,0x66e41a51,0x7f48072d,0x00000000}},	//   िटिं, жола, _خلیق_, --, 
   {{0x38a000b0,0xf7480fb4,0x613401d3,0x2ca80165}},	//   _rōrō_, ملني_, gálj, lfad_, 
   {{0x7cf801d3,0xa5640244,0x1c5403e0,0x00000000}},	//   _híra, زگان, şüşü, --, 
   {{0xe91802bf,0x611000e2,0x2ca80332,0x24e80117}},	//   _тобі_, nālt, nfad_, рмии_, 
   {{0x9f4c00bc,0x80d818cc,0xb0dc024a,0x613401d3}},	//   žném_, यासे, यानग, bálj, 
   {{0x7cf81a52,0x61341a53,0x00000000,0x00000000}},	//   _míra, rálm, --, --, 
   {{0xf7480491,0x04740517,0x614407c6,0xe0d807a5}},	//   _اللي_, _هلاک_, жена, авн_, 
   {{0x6fb80135,0xa2a810eb,0x2d901a54,0xa2cc1a55}},	//   _བརྡའ, _जॉर्, drze_, ताङ्, 
   {{0x3f840300,0x613400dd,0x03640050,0x22c000b0}},	//   ému_, lálk, _أتی_, _pōkē_, 
   {{0x236c1a56,0x00000000,0x00000000,0x00000000}},	//   mpej_, --, --, --, 
   {{0xdd901a57,0x2ca80267,0x255400e2,0x61341a58}},	//   ظور_, ffad_, _tālu_, nálk, 
   {{0xdcb01a59,0xdc6805f5,0x61101a5a,0x20d40111}},	//   بىر_, раад_, tālu, _фікс, 
   {{0x60d41a5b,0x69c01a5c,0x2d901a5d,0x6e280205}},	// [1540] _inym, _šlep, arze_, ğeba, 
   {{0x2d90068f,0x80d80574,0x7cf81a5e,0x61341a5f}},	//   brze_, यावे, _díra, kálk, 
   {{0x3eb81a60,0x7cf800e4,0xa2a0146c,0x25540171}},	//   mert_, _eíra, _खान्, _māls_, 
   {{0x3eb81a61,0x6fe000bd,0x61341a62,0x2ca80332}},	//   lert_, _পেয়ে, dálk, cfad_, 
   {{0x394000da,0x3eb80204,0x7cf8032e,0x613400e5}},	//   ķis_, oert_, _gíra, tálj, 
   {{0x3eb81a63,0xdb0402e2,0xd56404b0,0xf77000ec}},	//   nert_, _eskò, отип, واڙ_, 
   {{0x3eb804c4,0x611000e2,0x613401d3,0x7cf81a64}},	//   iert_, nāls, rálj, _zíra, 
   {{0x3eb81a65,0x60d40083,0x92d400fe,0x6b840244}},	//   hert_, _nnym, _সতে_, _بشێل, 
   {{0x3eb81a66,0x14a41a67,0xdbd8004e,0x287400c7}},	//   kert_, क्षण, nçàv, _хыср, 
   {{0x60d41a68,0x613400dd,0x20000034,0x3eb8045f}},	//   _anym, lálh, dzki_, jert_, 
   {{0xd62805cc,0x74141a69,0x00000000,0x00000000}},	//   _тоже_, توکا, --, --, 
   {{0x613400dd,0x3eb801a4,0x00000000,0x00000000}},	//   nálh, eert_, --, --, 
   {{0x3eb81a6a,0x200400a2,0x53380354,0x30c800e5}},	//   fert_, _ýoil_, _кукă, لڈکپ_, 
   {{0x6ef801e1,0x2d900034,0x7cf80241,0xfe7001d3}},	//   _bìba, trze_, _ríra, ہدہ_, 
   {{0x417008c9,0x7cf81a6b,0x2d841a6c,0x26d8016b}},	//   _قايس, _síra, éle_, _ɑso_, 
   {{0xac581a6d,0x01f80375,0x7cf808a5,0xc10401e2}},	//   сааф_, _כפול, _píra, _يووي, 
   {{0x2000006d,0x3eb81a6e,0x2ca81a6f,0x80d81152}},	// [1550] czki_, bert_, rfad_, यारे, 
   {{0x3eb800db,0x0a680107,0x7cf81a70,0x8a681a71}},	//   cert_, рраи_, _víra, ршаб_, 
   {{0x6d341a72,0x80b003f4,0x6cd41a73,0xfd1000dd}},	//   _неоф, য়ার্, _فقدا, رجہ_, 
   {{0x7cf81a74,0x7c3806ea,0x02b41a75,0x613400e5}},	//   _tíra, ðaræ, _अस्न, gálh, 
   {{0x39480145,0x00000000,0x00000000,0x00000000}},	//   ڭشەپ_, --, --, --, 
   {{0x61340646,0x00000000,0x00000000,0x00000000}},	//   tálk, --, --, --, 
   {{0xe298052f,0x2bc81a76,0xd6cc131e,0x7cf8012c}},	//   ҙан_, रिवा, طقي_, _mírn, 
   {{0xd5ac099f,0x61340122,0xe2980588,0x79581086}},	//   افي_, rálk, әан_, _фитр_, 
   {{0x25a800e8,0x00000000,0x00000000,0x00000000}},	//   ŋal_, --, --, --, 
   {{0x61341a77,0x68e81a78,0x290c0093,0xa20402bf}},	//   máli, _hoed, _hmea_, зпод, 
   {{0x3eb81a79,0x68e81a7a,0x26c40421,0x80d80316}},	//   vert_, _koed, _ialo_, याले, 
   {{0x3eb81859,0x26c41a7b,0x00000000,0x00000000}},	//   wert_, _halo_, --, --, 
   {{0x68e81a7c,0x26c41a7d,0x3eb81a7e,0x290c0605}},	//   _moed, _kalo_, tert_, _mmea_, 
   {{0x26c41a7f,0x3eb81a80,0x68e801f5,0x611000e2}},	//   _jalo_, uert_, _loed, tāls, 
   {{0x26c41a81,0x3eb81a82,0xca3004a2,0x64581a83}},	//   _malo_, rert_, ﺯﯨﺮ_, _kgwi, 
   {{0x3eb81a84,0x68e808c8,0x61341a85,0x9f840395}},	//   sert_, _noed, káli, _егид, 
   {{0x6458055a,0x26c40421,0x9098011a,0x00000000}},	// [1560] _mgwi, _oalo_, _הספק, --, 
   {{0x290c1a86,0x9ccc0327,0x7cf802d2,0x613416d9}},	//   _amea_, _ཌོམྦ, _gírn, dáli, 
   {{0x68e81a87,0x64581a88,0xf8b801e0,0x64bc0073}},	//   _boed, _ogwi, ҙөң_, ्याळ, 
   {{0x62801a89,0x64581a8a,0x68e81a8b,0x26c41a8c}},	//   halo, _ngwi, _coed, _aalo_, 
   {{0x62801a8d,0x68e81a8e,0x613401d3,0xb6c400c7}},	//   kalo, _doed, gáli, мҩад, 
   {{0x26c41a8f,0x64580bd7,0xcb6400d8,0xda701a90}},	//   _calo_, _agwi, _харе_, _سُر_, 
   {{0x26c4154c,0x62801a91,0x68e80483,0x18681a92}},	//   _dalo_, dalo, _foed, _габи_, 
   {{0x68e81a93,0x290c0270,0x7cf80118,0x2368025c}},	//   _goed, _gmea_, _míro, _ħajr_, 
   {{0x62801a94,0x26c41a95,0x61341a96,0x82f401e2}},	//   falo, _falo_, cáli, ګريز_, 
   {{0x26c41a97,0xa2a00490,0x00000000,0x00000000}},	//   _galo_, _खाण्, --, --, 
   {{0x56940184,0x68e80810,0xd7f81a98,0x7cf801e1}},	//   _маҡт, _yoed, _туң_, _níro, 
   {{0x26c41a99,0x62801a9a,0x6458031c,0x93a81a9b}},	//   _zalo_, aalo, _ggwi, _هاتف_, 
   {{0x26c41a9c,0xe5041a9d,0x2554005f,0x93441a9e}},	//   _yalo_, _تبلي, _tālr_, _енде, 
   {{0x26c4004d,0x7b000254,0x0e0809a5,0x91e00166}},	//   _xalo_, _jöud, бэби_, _зәмһ, 
   {{0xa2a00574,0x61341315,0x39441a9f,0x645802d0}},	//   _खात्, záli, _ohms_, _ygwi, 
   {{0x7cf801ef,0x00000000,0x00000000,0x00000000}},	//   _díro, --, --, --, 
   {{0x68e80f7b,0x201c0ab7,0x00000000,0x00000000}},	// [1570] _roed, ştir_, --, --, 
   {{0x7cf800dd,0x68e81aa0,0x290c01bf,0x00000000}},	//   _hírl, _soed, _smea_, --, 
   {{0x26c41aa1,0x68e81aa2,0x7bc0025a,0x00000000}},	//   _ralo_, _poed, _âmun, --, 
   {{0xf9901aa3,0x26c41aa4,0x61340d10,0x39440810}},	//   ابل_, _salo_, táli, _chms_, 
   {{0x26c41aa5,0x62801aa6,0x68e81aa7,0x79a401e0}},	//   _palo_, yalo, _voed, _үрсе, 
   {{0x68e81aa8,0xd7ec08b0,0x61341aa9,0x26c41aaa}},	//   _woed, شكى_, ráli, _qalo_, 
   {{0x26c41aab,0x61341aac,0x68e81aad,0x7cf80789}},	//   _valo_, sáli, _toed, _oírl, 
   {{0x62801aae,0x290c1aaf,0x61341ab0,0x2248010f}},	//   walo, _umea_, páli, _ŝako_, 
   {{0x26c41ab1,0xa2a01ab2,0xf7940006,0x00000000}},	//   _talo_, _खाद्, _патэ, --, 
   {{0x62800618,0x613401d3,0xd8640150,0x00000000}},	//   ualo, nálv, _ﺷﯩﻌﯟ, --, 
   {{0x62801ab3,0x291c01f7,0x64580165,0x4424179e}},	//   ralo, onwa_, _tgwi, _کراف, 
   {{0x64581ab4,0x291c0223,0x61340162,0x00000000}},	//   _ugwi, nnwa_, hálv, --, 
   {{0x73e402bf,0x291c0099,0x2d84000f,0x9f4c00bc}},	//   _поїз, inwa_, âlen_, žním_, 
   {{0x63a81ab5,0x6134022c,0x62801ab6,0x00000000}},	//   mten, jálv, qalo, --, 
   {{0xdca407d6,0xdddc0171,0x00000000,0x00000000}},	//   мави, _iepū, --, --, 
   {{0x20541ab7,0x7cf81ab8,0x3f840393,0x00000000}},	//   _отпр, _víro, ámus_, --, 
   {{0x0fc01ab9,0xd1e002d3,0x00000000,0x00000000}},	// [1580] _айын, _ዝሞተ_, --, --, 
   {{0xc31c1aba,0xe908025c,0xdb1c01b8,0x8e8000c7}},	//   _নীতি_, _གཏུབ_, _ävüd, _игье, 
   {{0x63a81abb,0x18a41abc,0x8fe403e6,0xdb04007c}},	//   hten, даем, _فزیۆ, _oskö, 
   {{0xf4d8045e,0x63a81abd,0x2d9401c6,0xdddc0064}},	//   _তত্ব, kten, _ярьс, _lepū, 
   {{0x09bc038f,0x63a81abe,0x2d840118,0x4cb8011a}},	//   _ཀརྨ_, jten, šlet_, _וזכו, 
   {{0x613405a4,0x291c0083,0x63a80112,0xd1e00023}},	//   málu, anwa_, dten, _ዝሞቱ_, 
   {{0x63a81abf,0xceb00302,0x613401d3,0x00000000}},	//   eten, דיו_, lálu, --, 
   {{0x63a800ed,0x6b480153,0x89d4007b,0x00000000}},	//   ften, _užgr, _توفر_, --, 
   {{0x63a81ac0,0x613401d3,0xc0180055,0x00000000}},	//   gten, nálu, cūḍe_, --, 
   {{0xdcfc00ef,0x00000000,0x00000000,0x00000000}},	//   _appļ, --, --, --, 
   {{0xae940248,0x572000cf,0x54680500,0x00000000}},	//   _mẹtt, _كۉچك, _даем_, --, 
   {{0x63a804ac,0x776000f1,0x1e701ac1,0x613400e5}},	//   bten, _kumx, ңғыс, zálv, 
   {{0x63a81ac2,0x6f4000b8,0xc0581ac3,0x611000e2}},	//   cten, _aśiṣ, дір_, rālp, 
   {{0x7cf801e7,0xf4240154,0x00000000,0x00000000}},	//   _dírm, _পরপর_, --, --, 
   {{0x291c007f,0x272800d7,0x3f841ac4,0x00000000}},	//   ynwa_, gúny_, ámur_, --, 
   {{0x0ccc0c58,0xdec00240,0xdbd80139,0x00000000}},	//   ৰস্ত, ስትኻ_, kçäv, --, 
   {{0x8aa41ac5,0x8f44014b,0x00000000,0x00000000}},	// [1590] дред, _оход, --, --, 
   {{0x2d841ac6,0x27280419,0x00000000,0x00000000}},	//   áles_, búny_, --, --, 
   {{0x63a81ac7,0x6f141ac8,0x61341ac9,0x705400f2}},	//   zten, mizc, rálv, _تنکا, 
   {{0x63a81aca,0x6f1403ee,0xd2440228,0x00000000}},	//   yten, lizc, _ۅن_, --, 
   {{0x6d4c1acb,0x0ba80e56,0x291c0100,0x00000000}},	//   mmaa, _باجى_, rnwa_, --, 
   {{0xd2441acc,0x6d4c1acd,0x613400dd,0x6f141432}},	//   _من_, lmaa, lált, nizc, 
   {{0x6d4c1ace,0x16841acf,0x3a3800a2,0x79a40408}},	//   omaa, راوێ, _gyrp_, _ирте, 
   {{0x6d4c1ad0,0x613400dd,0xe3b0109c,0x00000000}},	//   nmaa, nált, هرخ_, --, 
   {{0x63a81ad1,0x6d4c1ad2,0x7cf801d3,0x391400db}},	//   uten, imaa, _bírj, _рмтр, 
   {{0x63a81ad3,0x6d4c1ad4,0x61340332,0x061c0023}},	//   rten, hmaa, hált, ትራውነ, 
   {{0xa0a40364,0x6d4c1ad5,0xe1f000f2,0x613400e5}},	//   нанд, kmaa, اسخ_, kált, 
   {{0x6d4c0009,0x64c4009f,0x36040066,0x00000000}},	//   jmaa, _سيتل, _جومف, --, 
   {{0xf4841ad6,0x6d4c1ad7,0x613408de,0xc4cc01ed}},	//   _рухн, dmaa, dált, _مےں_, 
   {{0x65601ad8,0x6d4c0430,0x201c0311,0x00000000}},	//   _kulh, emaa, ăti_, --, 
   {{0x65601ad9,0x61341ada,0x6d4c017a,0xd1b801d3}},	//   _julh, fált, fmaa, _فاٹا_, 
   {{0x65600cfc,0x6d4c1adb,0x613401d3,0x10a0030d}},	//   _mulh, gmaa, gált, _биън, 
   {{0x24e000fe,0x7cf800e5,0x00000000,0x00000000}},	// [15a0] _বতাহ, _hírk, --, --, 
   {{0x6f141adc,0x64bc0a59,0x80d800bc,0xed580107}},	//   cizc, ्युश, याके, зоӣ_, 
   {{0x656001e4,0x6d4c058a,0x613401d3,0xdc68014b}},	//   _nulh, bmaa, bált, _нанд_, 
   {{0x6d4c0050,0x97a41add,0x61340d12,0x57a41ade}},	//   cmaa, еркл, máls, ешка, 
   {{0x65601adf,0x7d0402c4,0x613401d3,0x00000000}},	//   _aulh, mhis, láls, --, 
   {{0x7d041ae0,0x8f9800c8,0x65601ae1,0xc6f41ae2}},	//   lhis, פיצי, _bulh, нніх_, 
   {{0x65601ae3,0x64bc0034,0x9484010b,0x613401d3}},	//   _culh, ्यूश, ныпд, náls, 
   {{0x65600066,0xe8b41ae4,0x73d81086,0x38c81ae5}},	//   _dulh, mışı, ддир_, _غازی_, 
   {{0xe8b41ae6,0xa5080131,0xb4b40124,0xe8b00116}},	//   lışı, بىيە_, еиқә, _خەنج, 
   {{0x55e402bf,0x668001d9,0x613401d3,0x7d041ae7}},	//   _позб, _نیٖل, zált, hhis, 
   {{0xc0cc069c,0x7d041ae8,0xe8b41ae9,0x6d4c1aea}},	//   _ኢሎም_, khis, nışı, ymaa, 
   {{0x7d041aeb,0x6d4c0050,0x7cf80118,0x80d8024a}},	//   jhis, xmaa, _dírk, यागे, 
   {{0x7d041aec,0x04540491,0x73c40184,0x65600ac5}},	//   dhis, _كلمة_, _рәйе, _zulh, 
   {{0xe8b403ee,0x7cf801d3,0x02a002e8,0x6d4c1aed}},	//   kışı, _hírh, _бръм, wmaa, 
   {{0x6d4c1aee,0xd24c01d9,0x7cf8032e,0x7d0401e7}},	//   tmaa, _دۆد_, _gírk, fhis, 
   {{0x7d041aef,0x6d4c1af0,0xe8b40ac1,0x82380375}},	//   ghis, umaa, dışı, _מעוצ, 
   {{0x613419f9,0xf0780022,0x00000000,0x00000000}},	// [15b0] rált, _еиқә_, --, --, 
   {{0x6d4c1af1,0xadf40953,0x7d040009,0x98a40115}},	//   smaa, _апош, ahis, rloĝ_, 
   {{0x7d041af2,0x6d4c1af3,0x4db80011,0xe8b400fd}},	//   bhis, pmaa, _উপকূ, gışı, 
   {{0x69c0006a,0x6d4c1af4,0xfe701af5,0x613401d3}},	//   _âlem, qmaa, _پدی_, lálr, 
   {{0xd3641af6,0x65601af7,0xa2a01af8,0x00000000}},	//   _خه_, _sulh, _खाल्, --, 
   {{0x65601af9,0xe8b4013d,0x00000000,0x00000000}},	//   _pulh, bışı, --, --, 
   {{0x2bc8146b,0x65601afa,0xf9d41afb,0x28c400c7}},	//   रिका, _qulh, _йорэ, _ишаҳ, 
   {{0x09e4015b,0x00000000,0x00000000,0x00000000}},	//   পনদা, --, --, --, 
   {{0xe85801c0,0xd3441afc,0xbd9c0023,0x7cf800e5}},	//   _цааш_, چینه_, ፍነቶም_, _sírk, 
   {{0xdb0c006a,0x779000dd,0x69d41afd,0xf59800ee}},	//   _âkôz, _ایوا, _krze, çýär_, 
   {{0x7d041afe,0x764402a8,0x51f400ec,0x00000000}},	//   yhis, ƙiya, نسٽر, --, 
   {{0x69d41aff,0x7d041b00,0x00000000,0x00000000}},	//   _mrze, xhis, --, --, 
   {{0x7d040084,0x0fc00107,0x00000000,0x00000000}},	//   vhis, айян, --, --, 
   {{0x69d40034,0xe8b406b9,0xd36c00e3,0x00000000}},	//   _orze, yışı, _بهو_, --, 
   {{0x7d041b01,0xe8b400ac,0xc0c00023,0x00000000}},	//   this, xışı, ድሕር_, --, 
   {{0xbddc0241,0x6ef801ab,0xad3802bf,0x61341b02}},	//   _aṣòf, _lìbh, ечує_, ráls, 
   {{0x7d040c11,0x69d41b03,0x5ba81b04,0x00000000}},	// [15c0] rhis, _arze, ькам_, --, 
   {{0x69d41b05,0x7cf81b06,0xe8b41b07,0x597400c0}},	//   _brze, _míri, tışı, выду, 
   {{0x1d0818ec,0x7cf81b08,0xfd240133,0x00000000}},	//   _жени_, _líri, _مودێ, --, 
   {{0xe8b41b09,0x69d41afd,0xd83801c0,0x4c801b0a}},	//   rışı, _drze, мэл_, _клюв, 
   {{0x69d41b0b,0xdb04037e,0x1cc0031c,0xda6416ac}},	//   _erze, _opkø, _གྲར_, _لازي, 
   {{0x4730063b,0xa3d41b0c,0xbc6801ed,0xe8b41b0d}},	//   аніс, हिन_, _تجھے_, pışı, 
   {{0x69d4068f,0x05800046,0x5ee80150,0x75d41b0e}},	//   _grze, ауым, _ءﻭﺭ_, ايبا, 
   {{0x88b00133,0x00000000,0x00000000,0x00000000}},	//   _نیمچ, --, --, --, 
   {{0x7cf80798,0x69d40456,0x660c01e4,0xca3c0150}},	//   _círi, _zrze, ĝaka, _ﺟﺎﺕ_, 
   {{0x7cf800c6,0xe6c400c6,0x6e2803ee,0x572401d5}},	//   _díri, _متمي, şebi, _شرذق, 
   {{0x4a98010f,0xcb1002e4,0x613400e5,0x00000000}},	//   וייג, שלת_, válr, --, 
   {{0x7cf800c6,0x00000000,0x00000000,0x00000000}},	//   _fíri, --, --, --, 
   {{0x7cf81b0f,0x80d8190c,0x33940153,0x00000000}},	//   _gíri, याजे, _салё, --, 
   {{0x04401b10,0xe57001ed,0x439001e0,0xda0001f9}},	//   _течн, _خطے_, _ташс, लनात_, 
   {{0x6fe80de2,0x7f581b11,0xac941b0a,0x00000000}},	//   _bëcë, тарс_, лавш, --, 
   {{0xdde002d1,0xc0e4009b,0x00000000,0x00000000}},	//   ñušu, _воћк, --, --, 
   {{0xdb241b12,0xa3d401ad,0x00000000,0x00000000}},	// [15d0] گولی, हिय_, --, --, 
   {{0x69d41b13,0x2fc8058a,0x00000000,0x00000000}},	//   _prze, _isag_, --, --, 
   {{0xc9841b14,0xbf141b15,0x80d80073,0x20a80b02}},	//   тузи, _түрә, याचे, _कामध, 
   {{0x7c581b16,0x1cc0025c,0xa3d40bc0,0x69d40427}},	//   رلەر_, _གིར_, हिम_, _vrze, 
   {{0x6d5c1b17,0x69d4068f,0xfb840024,0x00000000}},	//   _iisa, _wrze, _высн, --, 
   {{0x6d5c1b18,0x69d4006d,0x6b8c1b19,0x00000000}},	//   _hisa, _trze, msag, --, 
   {{0x7cf81b1a,0x6b8c1b1b,0xdb2410e5,0x48a81b1c}},	//   _síri, lsag, _صوفی, _отам_, 
   {{0x6d5c1b1d,0x7cf80227,0x2fc800a3,0x6b8c1b1e}},	//   _jisa, _píri, _osag_, osag, 
   {{0x6b8c1b1f,0xc6a40022,0xed10004d,0x224000d7}},	//   nsag, _ареи, _đối_, _šhk_, 
   {{0x6d5c1b20,0x6b8c1b21,0x6aa40007,0x7cf81b22}},	//   _lisa, isag, nghf, _víri, 
   {{0x69c41b23,0x6d5c0124,0x6b8c0007,0x5ed00f22}},	//   nwhe, _oisa, hsag, _সকলে, 
   {{0x6d5c1b24,0xd5f8008f,0xdfd00451,0x00000000}},	//   _nisa, _אפער, ٽيس_, --, 
   {{0x2d8002b1,0x69c40175,0x952000f1,0xc2b00150}},	//   _awhe_, hwhe, _دکوم, _көнш, 
   {{0x6b8c1b25,0x6110005f,0x21a40bd6,0x539805d0}},	//   dsag, nālz, _бикм, _ניצו, 
   {{0x6d5c1b26,0x69c0006a,0xa6cc009e,0x6b8c1b27}},	//   _bisa, _âleh, লাপট, esag, 
   {{0x6d5c1b28,0xa0a40364,0x6b8c01a8,0xdb1401f4}},	//   _cisa, _саид, fsag, nvyö, 
   {{0x6b8c1b29,0x6d5c1b2a,0x69c40072,0x09bc031c}},	// [15e0] gsag, _disa, ewhe, _ཀརྴ_, 
   {{0x4aa40372,0x2bc81b2b,0xcb9401d5,0x3ae81b2c}},	//   лкун_, रिजा, انلش_, خبری_, 
   {{0x6d5c1b2d,0x2d941b2e,0x6b8c1b2f,0x00000000}},	//   _fisa, _кряс, asag, --, 
   {{0x98481b30,0xbb7410de,0x386003b2,0x00000000}},	//   няла_, _نۇرع, øir_, --, 
   {{0x9b441b31,0x69c400b0,0x6b8c1b32,0x88e801e2}},	//   _منحو, awhe, csag, عظمې_, 
   {{0x6d5c1b33,0xc86c02d3,0x7e7c0175,0xdb0c01f4}},	//   _zisa, _ብዓይኒ_, nbrp, öjän, 
   {{0x6d5c1b34,0x7b00005b,0x00000000,0x00000000}},	//   _yisa, _yöun, --, --, 
   {{0x1cc01b35,0x6d5c1b36,0x80d41b37,0xd3781b38}},	//   _གིས_, _xisa, _बोले, нчо_, 
   {{0x28e014df,0x96941b39,0xdec00023,0x00000000}},	//   फारि, _бреш, ስስን_, --, 
   {{0xc7d4011a,0x00000000,0x00000000,0x00000000}},	//   _גומי_, --, --, --, 
   {{0xd34401b9,0x22280014,0x613400e4,0xcb340115}},	//   نیچه_, ہٲیی_, tálp, ראיי_, 
   {{0x6b8c1b3a,0x7cf801e1,0x0524030d,0x142400d4}},	//   ysag, _kíru, _йохк_, _йдем, 
   {{0x2d80013f,0x1cc0025c,0xd9b000bc,0xcfa40108}},	//   _swhe_, _གྲེ_, ीबुट, ышни, 
   {{0x6d5c1b3b,0x6b8c1b3c,0x0fe00032,0x69c41b3d}},	//   _sisa, vsag, _ғөмү, ywhe, 
   {{0xd1380354,0x032001e2,0x00000000,0x00000000}},	//   _пхи_, _دفوټ, --, --, 
   {{0x6b8c1b3e,0x2fc80218,0x6d5c1b3f,0x4638008f}},	//   tsag, _tsag_, _qisa, געלע, 
   {{0x6e9400a8,0x6b8c013c,0x7cf801e1,0xab941b40}},	// [15f0] _кипу, usag, _níru, شلاغ, 
   {{0x6b8c1b41,0xa3d41b42,0x6d5c1b43,0x80240014}},	//   rsag, हित_, _wisa, _در٘م, 
   {{0x6b8c1b44,0xfaa81b45,0x69c41b46,0x00000000}},	//   ssag, اهمي_, uwhe, --, 
   {{0x6b8c1b47,0xfc6402e8,0x69c41b48,0x75dc0356}},	//   psag, _гърн, rwhe, _măză, 
   {{0x7648010b,0x75dc054e,0xa684004e,0x00000000}},	//   _azdy, _lăză, аллд, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba74066d,0x6eac038e,0xf77001d3,0x0df40023}},	//   _چاہت, _जानु, _ہال_, _ወልፊ_, 
   {{0xa774156c,0x291801e3,0x611000b8,0x00000000}},	//   _влач, _ösa_, bāly, --, 
   {{0xf7700502,0x320c0030,0x7cf802d2,0x53d00c22}},	//   _فال_, ezdy_, _gíru, तिषश, 
   {{0xdec01b49,0x257800c7,0x7cf800e5,0x3358004e}},	//   ስትን_, _абжь_, _hírt, гүчө_, 
   {{0x75dc0356,0xc0c00023,0xb6e400cf,0x00000000}},	//   _căză, _ድሑር_, _уютк, --, 
   {{0xa3d40034,0xa2a80b7c,0xa0a41b4a,0x00000000}},	//   हिद_, ज्ज्, шамд, --, 
   {{0x320c0034,0xd3e400db,0xe3b000ec,0x00000000}},	//   azdy_, _ەتۉۉ, _ڇرڪ_, --, 
   {{0xe2980a31,0x5398011a,0x00000000,0x00000000}},	//   _рак_, _יינו, --, --, 
   {{0x1cc01b4b,0x21a405f5,0x2cb800a3,0xd12c00ec}},	//   _གྲུ_, _тийм, _bbsd_, _ڪمي_, 
   {{0x25ec1b4c,0xd24c1b4d,0xa3c80034,0xa0740166}},	//   _अपनी_, _غني_, _ऊना_, _тыкш, 
   {{0xcb641b4e,0x2cb80334,0x71240fa2,0xd12c0b24}},	// [1600] иате_, _dbsd_, _درول, _تمي_, 
   {{0x1e941b4f,0x7cf801e1,0x00000000,0x00000000}},	//   _трир, _ríru, --, --, 
   {{0x9f041a69,0xda5801e0,0x9d441b50,0x0e98011a}},	//   _موکو, траш_, _венд, _בשיל, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ab4013d,0xf7040166,0x6eac1b51,0x00000000}},	//   _гәет, бҗам, _जामु, --, 
   {{0x7cf81b52,0xd5b801a9,0x00000000,0x00000000}},	//   _víru, вси_, --, --, 
   {{0x95c81b53,0x2b5401d5,0x55040262,0x349406b4}},	//   тула_, _ایلد_, ичиа, байр, 
   {{0x75dc0356,0x76480216,0x040c0154,0x320c0419}},	//   _răză, _vzdy, াপনী_, vzdy_, 
   {{0x7cf800e5,0xbdec01ec,0x00000000,0x00000000}},	//   _hírs, _ﻋﻤﻴل_, --, --, 
   {{0x87780a7c,0x96b800f5,0x25700228,0x0bb400d9}},	//   _סאבי, _шубу_, زۇۇس, סלים_, 
   {{0x0a440023,0x6ec40073,0x00000000,0x00000000}},	//   _ንኢሰያ, ाजसु, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72d40e58,0x00000000,0x00000000,0x00000000}},	//   _голф, --, --, --, 
   {{0xb8d8025c,0xff041b54,0xef540022,0x62200137}},	//   _མཁ_, оясн, скгь, تۉۉل, 
   {{0x51841b55,0xad241b56,0x0ca80c60,0x00000000}},	//   _тула, مىسى, ктаи_, --, 
   {{0x1cc00327,0x00000000,0x00000000,0x00000000}},	//   _གྲཱ_, --, --, --, 
   {{0xebd8010b,0xc0c00092,0x00000000,0x00000000}},	// [1610] ыдаш_, ስንም_, --, --, 
   {{0x61b0168d,0x7cf801d3,0x37cc0154,0x00000000}},	//   _بڕیا, _bírs, লমার, --, 
   {{0xba740e8e,0x63b4054e,0xc330011a,0x00000000}},	//   تاقت, ăzni, קוע_, --, 
   {{0xe5780107,0x835400b8,0x00000000,0x00000000}},	//   қзи_, _mātṝ, --, --, 
   {{0x1cc00003,0x2d900034,0x2ca8005f,0xc7c400d8}},	//   _གྲི_, lsze_, mgad_, рсеи, 
   {{0xa3d41b57,0x2ca800c5,0xeb34075e,0x637801a9}},	//   हिस_, lgad_, _چىڭد, қсир_, 
   {{0x7cf802d2,0x79940166,0x2d900210,0x253800d8}},	//   _gírs, _мирф, nsze_, лчиќ_, 
   {{0x2ca81b58,0x6fb80073,0x00000000,0x00000000}},	//   ngad_, ेबां, --, --, 
   {{0x291c1b59,0x2ca81b5a,0xe4580108,0x00000000}},	//   miwa_, igad_, ыжи_, --, 
   {{0x291c1b5b,0xdddc1b5c,0x13041b5d,0x0a440023}},	//   liwa_, _lepš, йный_, _ንኢሳያ, 
   {{0x2d900034,0x27fc0175,0x00000000,0x00000000}},	//   jsze_, lywn_, --, --, 
   {{0x291c1b5e,0xf1a803e6,0xb9f0001f,0x83540055}},	//   niwa_, گایه_, _ዐዐ_, _dātṝ, 
   {{0x2ca81b5f,0x00000000,0x00000000,0x00000000}},	//   dgad_, --, --, --, 
   {{0x291c1b60,0xf1a804d3,0xdcb01b61,0x5438008f}},	//   hiwa_, دایه_, ुज्ञ, _גענא, 
   {{0x291c1b62,0x236c044e,0x2ca8007f,0x6b480064}},	//   kiwa_, lqej_, fgad_, _užgy, 
   {{0x2ca81b63,0x291c1b64,0x442c0158,0xf1a804d3}},	//   ggad_, jiwa_, _kxg_, _ئاوه_, 
   {{0x291c1b65,0x817c001f,0x33840023,0x00000000}},	// [1620] diwa_, _የተባሉ_, _ሓደሓደ_, --, 
   {{0xee38013e,0x2ca81b66,0x60c401d3,0x60c01b67}},	//   унӣ_, agad_, lekm, _ñomb, 
   {{0x291c1b68,0x236c036e,0x248c01ef,0x00000000}},	//   fiwa_, hqej_, kaem_, --, 
   {{0x98a41b69,0x291c1b6a,0x1cc00327,0xcca000db}},	//   сиде, giwa_, _གིི_, _ىڭقى, 
   {{0xc7a01b6b,0x1cc00135,0x248c1b6c,0x00000000}},	//   зичк, _གྲག_, daem_, --, 
   {{0xd3781b6d,0x05d00490,0xaee40882,0xf1a81b6e}},	//   қчи_, थिंब, miṣy, _कमलन, 
   {{0x291c1b6f,0xe7080133,0x00000000,0x00000000}},	//   biwa_, گتۆن_, --, --, 
   {{0x291c1b70,0x94a81b71,0x33741b72,0x248c020c}},	//   ciwa_, утка_, огир, gaem_, 
   {{0x2d841b73,0x442c056a,0x037417b9,0x2d900210}},	//   ález_, _cxg_, یحیت_, zsze_, 
   {{0x35c41b74,0x2d900210,0x00000000,0x00000000}},	//   _мазҳ, ysze_, --, --, 
   {{0x2ca81b75,0x7bc001b8,0x442c00d8,0x248c0139}},	//   ygad_, _ämuf, _exg_, baem_, 
   {{0xd46803fb,0x442c045a,0xa3d403ce,0x4a58123b}},	//   _сиде_, _fxg_, हिश_, טדיו, 
   {{0x2d90006d,0x6eac1b76,0xdddc03ef,0x00000000}},	//   wsze_, _जादु, _repš, --, 
   {{0x0dc806c0,0xa3d41b77,0x2d900210,0x00000000}},	//   луби_, हिर_, tsze_, --, 
   {{0x291c1b78,0x1cc00003,0x2d841b79,0x80d4012c}},	//   yiwa_, _གྲང_, èle_, _बोके, 
   {{0x2d901b7a,0x291c1b7b,0x50641b7c,0x60c4083c}},	//   rsze_, xiwa_, _утка, cekm, 
   {{0x2ca81b7d,0x291c1b7e,0x442c00d8,0x2d9001d3}},	// [1630] rgad_, viwa_, _xxg_, ssze_, 
   {{0x291c1b7f,0x2d90068f,0xbb841b80,0x3f14004e}},	//   wiwa_, psze_, سلمي, _ндыс, 
   {{0x291c1b81,0xba740aa0,0x9bb80003,0x248c0007}},	//   tiwa_, سالت, _པདྨོ, yaem_, 
   {{0x27fc020c,0x877001d5,0x46b0012d,0x00000000}},	//   tywn_, зғаш, ूज़्, --, 
   {{0x291c1b82,0xfd44009d,0xaee40055,0x00000000}},	//   riwa_, _хээн, ciṣy, --, 
   {{0x291c1b83,0xbb400131,0xc6a41b84,0x069001d3}},	//   siwa_, ﻜﯩﻦ_, срди, ساتھ, 
   {{0x24e80c04,0x291c1b85,0x248c0bed,0x442c056a}},	//   имки_, piwa_, taem_, _sxg_, 
   {{0x291c1b86,0xa3d41b87,0xa8340063,0x00000000}},	//   qiwa_, हिल_, _дебљ, --, 
   {{0x248c0798,0xd7c0031c,0xe3b000ae,0x00000000}},	//   raem_, _གརགྱ, ذرة_, --, 
   {{0xe2981b88,0x6d04012c,0x60c4020c,0xe5e4158b}},	//   јан_, रसँग_, wekm, _وزای, 
   {{0x60c400da,0xfcbc001f,0x1ea801e2,0x00000000}},	//   tekm, _ታዳጊ_, یاسي_, --, 
   {{0xaee40a28,0x00000000,0x00000000,0x00000000}},	//   yiṣy, --, --, --, 
   {{0x60c41b89,0x1cc00327,0xa03400db,0x00000000}},	//   rekm, _གྲཊ_, زىست, --, 
   {{0x1cc00156,0xaee40a28,0x60c40fda,0x00000000}},	//   _གིང_, viṣy, sekm, --, 
   {{0x62801b8a,0xdd901b8b,0x63b4054e,0x00000000}},	//   mblo, بوز_, ăznu, --, 
   {{0xd47c001f,0x2c14000d,0xd24c00ae,0x00000000}},	//   _የቀድሞ_, _नइखू_, _جنى_, --, 
   {{0x8c401b8c,0x5f741b8d,0x63ac007c,0x00000000}},	// [1640] дете, _بابر, _åand, --, 
   {{0x62801b8e,0xaee40882,0x0ae400a7,0x20a800bc}},	//   nblo, riṣy, одуй_, _काँध, 
   {{0xd12c1b8f,0x76440198,0xa3d41b90,0x62800af9}},	//   _سمی_, ƙiyi, हिँ_, iblo, 
   {{0x7d08002d,0xd7f800a8,0x9d4404b1,0x00000000}},	//   êdsd, иул_, _фемд, --, 
   {{0x7d041b91,0xacb01b92,0x80bc00dc,0x5fc801ad}},	//   mkis, _سەلب, ष्ये, िबिल, 
   {{0x7d041b93,0x96b81b94,0x6280134a,0x00000000}},	//   lkis, руду_, jblo, --, 
   {{0x20a81524,0xf1a80037,0x7d041b95,0x6eac0118}},	//   _कांध, _कमइन, okis, _जासु, 
   {{0x7d041b96,0x628004ce,0xa3d41b97,0x00000000}},	//   nkis, eblo, हिं_, --, 
   {{0x62801b98,0x00000000,0x00000000,0x00000000}},	//   fblo, --, --, --, 
   {{0x7d041b99,0x273000db,0x2aec04af,0x613400e5}},	//   hkis, _كۉنس, घायु_, mály, 
   {{0x7d041b9a,0x157001b9,0x914801d5,0xd5840244}},	//   kkis, _ўқиё, ичма_, _بێعه_, 
   {{0x38600960,0x35c4014b,0x00000000,0x00000000}},	//   žiru_, _маҷҳ, --, --, 
   {{0xf6c8003d,0x10481b9b,0x62801b9c,0x7d041b9d}},	//   _གྲོང, ряни_, bblo, dkis, 
   {{0x8d741b9e,0x69c00598,0x7d041b9f,0x62801ba0}},	//   قارا, _äleg, ekis, cblo, 
   {{0xc278008f,0x9f40023a,0x3eb00030,0x53d0086b}},	//   _דרוי, yykö_, _žltá_, तिकश, 
   {{0xab74016c,0x75200472,0x7d041ba1,0x4598008f}},	//   згаш, nimz, gkis, יסלע, 
   {{0x0a6807dd,0x00000000,0x00000000,0x00000000}},	// [1650] ареи_, --, --, --, 
   {{0x7d041ba2,0xfbd0040b,0x80bc0b7c,0x613401ed}},	//   akis, کتہ_, ष्ठे, dály, 
   {{0x7d041ba3,0x0dc8085f,0xe73801e0,0x75201ba4}},	//   bkis, _тупи_, ҙек_, kimz, 
   {{0x7d041ba5,0x4a7401e0,0x62801ba6,0x39a400d4}},	//   ckis, сыҡт, zblo, ьшув, 
   {{0x66e41ba7,0x62801ba8,0x00000000,0x00000000}},	//   зола, yblo, --, --, 
   {{0x6280019b,0xeb081b06,0xff7c008f,0xdbc40254}},	//   xblo, _اقسى_, סטומ, tööe, 
   {{0x80ac05ba,0x1cc0025c,0xe5a40131,0xe3c800e4}},	//   _झाले, _གྲཌ_, чийи, kuñá_, 
   {{0x6134066d,0x62801ba9,0x24e8013e,0x00000000}},	//   bály, wblo, смии_, --, 
   {{0x13e40166,0x00000000,0x00000000,0x00000000}},	//   змый_, --, --, --, 
   {{0x7d040072,0x46600116,0x00000000,0x00000000}},	//   zkis, _قۇشق, --, --, 
   {{0xa0680661,0x61441baa,0x69c0013d,0x59dc012d}},	//   йана_, зена, _äled, _नज़ार, 
   {{0x55b8011a,0x00000000,0x00000000,0x00000000}},	//   _למעו, --, --, --, 
   {{0x62801bab,0x25701bac,0x14c804fb,0x7d0403e0}},	//   pblo, _hál_, _دهنی_, vkis, 
   {{0x63a81bad,0x7d040bc9,0x2570032e,0x626401f4}},	//   muen, wkis, _kál_, _эвка, 
   {{0x63a81bae,0x7d041baf,0x63ac0fac,0x331800f2}},	//   luen, tkis, _åanb, _بزند_, 
   {{0x25701bb0,0x63a80dd4,0x20c81bb1,0x7d041bb2}},	//   _mál_, ouen, _طبعي_, ukis, 
   {{0x212001af,0x7d041bb3,0x63a80d63,0x80bc043e}},	// [1660] mikh_, rkis, nuen, ष्णे, 
   {{0x7d041bb4,0x60d41bb5,0x75201bb6,0x7d08002d}},	//   skis, _haym, zimz, êdsb, 
   {{0x60d41bb7,0x9d441bb8,0x7d3c001f,0x2000014b}},	//   _kaym, _неод, _በፖለቲ, lyki_, 
   {{0x63a81bb9,0x613401ed,0x57e81bba,0x23bc1bbb}},	//   kuen, tály, йдем_, ्बाद, 
   {{0x60d40588,0x87e011ed,0x63a81bbc,0x9f4000e4}},	//   _maym, еюще, juen, sykõ_, 
   {{0x63a81bbd,0x60d41bbe,0x613401ed,0x25701bbf}},	//   duen, _laym, rály, _bál_, 
   {{0x25700077,0x38c803e6,0x9a8400d1,0x63a80393}},	//   _cál_, _واری_, _муңл, euen, 
   {{0x25700316,0xd3a41bc0,0x613401ed,0x60d41bc1}},	//   _dál_, проп, pály, _naym, 
   {{0x07a01bc2,0x1cc0031c,0xc7a01bc3,0x1488107b}},	//   _патн, _གྲབ_, _питк, _ۇپاي_, 
   {{0x87780bd9,0x257000ae,0xd6281bc4,0x20000210}},	//   _לאמי, _fál_, _лозе_, dyki_, 
   {{0x60d41bc5,0xe6b401d5,0x63a80076,0x54341bc6}},	//   _baym, _آلمگ, auen, _کرار, 
   {{0x63a81bc7,0x60d41bc8,0x26d8013b,0x00000000}},	//   buen, _caym, _ɔsom_, --, 
   {{0x63a81bc9,0x60d41bca,0x35a4008e,0x5ed40154}},	//   cuen, _daym, _хаҗг, দানে, 
   {{0x417000f2,0x733414fb,0x00000000,0x00000000}},	//   بایس, _تىتا, --, --, 
   {{0xb1180050,0x69d800b0,0x60d4002f,0x00000000}},	//   _وقتا_, āwek, _faym, --, 
   {{0x60d41bcb,0x80b400cf,0x00000000,0x00000000}},	//   _gaym, _كەپش, --, --, 
   {{0xa3d4006d,0x3c58084c,0x6454002d,0x2000012d}},	// [1670] हिए_, зитэ_, ęzig, cyki_, 
   {{0xdb14033b,0x88e401ec,0x60d40139,0x00000000}},	//   ntyè, _ﺍﻗﺘﻀ, _zaym, --, 
   {{0x60d41bcc,0x63a81bcd,0x00000000,0x00000000}},	//   _yaym, zuen, --, --, 
   {{0x60d41bce,0xe6c41bcf,0x12800240,0x00000000}},	//   _xaym, लज्ज, ረትኣብ_, --, 
   {{0x25701bd0,0x61340077,0x63a8009d,0xdb14033b}},	//   _sál_, rálx, xuen, ktyè, 
   {{0x25701bd1,0xb9041bd2,0x63a80207,0x00000000}},	//   _pál_, _भो_, vuen, --, 
   {{0x20000034,0x2120014b,0x63a8003e,0x79a400d8}},	//   zyki_, yikh_, wuen, _прте, 
   {{0x63a81bd3,0xa9080be2,0x24080022,0x25701bd4}},	//   tuen, _بيرل_, жнии_, _vál_, 
   {{0x60d40bf1,0x290c1bd5,0xfbe01bd6,0xe7b400f1}},	//   _raym, _ilea_, नियम, _زماد, 
   {{0x63a81bd7,0x68e801f1,0x21200ac5,0x1cc0031c}},	//   ruen, _hned, wikh_, _གྲན_, 
   {{0x63a81bd8,0x68e81bd9,0x290c1bda,0x2120003a}},	//   suen, _kned, _klea_, tikh_, 
   {{0x2000068f,0x245401d5,0x60d41bdb,0x00000000}},	//   tyki_, _قناس, _qaym, --, 
   {{0xe2981bdc,0x21200020,0x63a80c46,0x68e81bdd}},	//   _дал_, rikh_, quen, _mned, 
   {{0x60d41bde,0x2000033f,0x00000000,0x00000000}},	//   _waym, ryki_, --, --, 
   {{0x68e81bdf,0x60d41be0,0xdef800ee,0x60c00124}},	//   _oned, _taym, бың_, _ñomo, 
   {{0x5908025c,0x68e804ba,0x60d402d0,0x00000000}},	//   _གཞེས_, _nned, _uaym, --, 
   {{0xe3b801ed,0x1dcc012d,0x2ba41be1,0x3d14012d}},	// [1680] ntű_, _हैरत, गंगा, नोगे_, 
   {{0x290c1be2,0x68e81be3,0x272000bc,0x5f2800d8}},	//   _alea_, _aned, nčně_, _фоом_, 
   {{0x290c04cc,0x68e80003,0x00000000,0x00000000}},	//   _blea_, _bned, --, --, 
   {{0x290c1be4,0x58b8007b,0x7f680150,0x00000000}},	//   _clea_, تائج_, _ﺒﻭل_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x290c0e39,0x68e81be5,0x6b88005a,0x75d400ae}},	//   _elea_, _ened, _çega, فيتا, 
   {{0x7afc0477,0x63ac0115,0x290c0f85,0xcb640cb6}},	//   _iort, _ĥana, _flea_, _царе_, 
   {{0x7afc1be6,0x68e80076,0x97c401b9,0x14ac0073}},	//   _hort, _gned, _ойбе, _टाळण, 
   {{0x1cc00003,0x96b81be7,0xdec01954,0x8d800092}},	//   _གིན_, _мужу_, ድስን_, ንባታው_, 
   {{0x69c00793,0x7afc1bce,0x39440254,0xf1f4068e}},	//   _älec, _jort, _hkms_, езоэ, 
   {{0x7afc1be8,0x776802d0,0xca880150,0x673c032e}},	//   _mort, _iidx, _ﺗﯘﺳﻪ_, _ísja, 
   {{0x7afc0323,0x249c009f,0x96ac000d,0x272001ef}},	//   _lort, _gdwm_, _घाँउ, ačně_, 
   {{0x7afc0151,0x7648010b,0x00000000,0x00000000}},	//   _oort, _hydy, --, --, 
   {{0x7afc1be9,0x63ac03cd,0x15f0121d,0xd5c00073}},	//   _nort, _åana, _अपार_, _शहाज, 
   {{0x6454033f,0x7768013d,0xccf80063,0x00000000}},	//   ęzie, _midx, оћа_, --, 
   {{0x3cf00a28,0x50641b10,0x61e4032e,0x00000000}},	//   ṣṭvā_, _отпа, _áhla, --, 
   {{0x7afc1bea,0x76481beb,0x00000000,0x00000000}},	// [1690] _bort, _lydy, --, --, 
   {{0x68e81bec,0x5908025c,0x290c0076,0x49b80736}},	//   _sned, _གཞུས_, _slea_, قاصد_, 
   {{0x1cc00135,0x76480217,0x290c1bed,0x31b800e5}},	//   _གྲམ_, _nydy, _plea_, néz_, 
   {{0xe94401b9,0xfe240124,0x00000000,0x00000000}},	//   ررای, _шьын, --, --, 
   {{0x76480209,0x31b801ed,0x293c0046,0x39440009}},	//   _aydy, héz_, ﻟﯩﭗ_, _dkms_, 
   {{0x7afc1bee,0x9de401d9,0x76481bef,0x316802f0}},	//   _gort, _تہہٕ_, _bydy, _liaz_, 
   {{0x76480368,0x68e8025c,0xba900150,0x6e200332}},	//   _cydy, _tned, _ﺗﯘﻧﮕ, úlbh, 
   {{0x67d41bf0,0x7afc05f5,0x68e81bf1,0x764803cb}},	//   _побу, _zort, _uned, _dydy, 
   {{0x7afc0598,0x77680077,0x00000000,0x00000000}},	//   _yort, _fidx, --, --, 
   {{0x7afc1bf2,0x18281bf3,0x05741bf4,0xdedc0023}},	//   _xort, _عقلی_, _قاصد, ቕትን_, 
   {{0x76481bf5,0xe1241bf6,0xe7f8012c,0xf4f801d3}},	//   _gydy, емни, ्नका_, سویں_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3d4069f,0x31681bf7,0x00000000,0x00000000}},	//   हिओ_, _diaz_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c740521,0x23b802bd,0x00000000,0x00000000}},	//   _ụda_, lèj_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1ae41bf8,0xa3d41bf9,0x23b80100,0x5ba81b0a}},	// [16a0] ноам, हिट_, nèj_, якам_, 
   {{0x7afc1bfa,0x9b441bfb,0xcca00150,0xda580120}},	//   _qort, رناو, _ەڭلى, преш_, 
   {{0x7afc1bfc,0x3944020c,0x291c007f,0x59840108}},	//   _vort, _pkms_, ďwan_, хлеб, 
   {{0x76480cfd,0x7afc1bfd,0x3f80003e,0x00000000}},	//   _rydy, _wort, _ktiu_, --, 
   {{0x69d41bfe,0x76480368,0x00000000,0x00000000}},	//   _esze, _sydy, --, --, 
   {{0x7afc01bf,0x8f9800d9,0xcf9000d9,0x00000000}},	//   _uort, ליני, נטו_, --, 
   {{0xceb000c8,0x09e0010a,0x00000000,0x00000000}},	//   טיג_, _йорн, --, --, 
   {{0x69c00793,0x38c8004b,0x799c03ac,0x05700b24}},	//   _älea, _تاسی_, _ivrw, داود, 
   {{0x44f01bff,0x69d40210,0x00000000,0x00000000}},	//   اسىز, _zsze, --, --, 
   {{0x0bb40375,0x78a004e6,0x71781c00,0x76480142}},	//   עלים_, _hdmv, мбор_, _tydy, 
   {{0x95c81c01,0x3f8000b0,0x31680085,0x6234009d}},	//   _хлеб_, _atiu_, _piaz_, күшю_, 
   {{0x31b800e5,0x76440205,0x80bc17ee,0x00000000}},	//   réz_, ğiyd, ष्ले, --, 
   {{0x6454000f,0x506400a8,0x31680419,0x764403e0}},	//   ęzic, этоа, _viaz_, şiyd, 
   {{0xad2403cc,0x55f000fe,0x00000000,0x00000000}},	//   چىسى, জনীক_, --, --, 
   {{0xad241c02,0xac9408e1,0x0ca80022,0x6fd00154}},	//   نىسى, кавш, зтзи_, ামেই, 
   {{0xa3d401f9,0x00000000,0x00000000,0x00000000}},	//   हिच_, --, --, --, 
   {{0x8aa41c03,0x799c02d0,0xcee800ec,0xc0c00092}},	// [16b0] еред, _avrw, _فردن_, ድንም_, 
   {{0x2fc81c04,0xef1000f7,0x69d4033f,0x4f28069d}},	//   _ipag_, _түгө, _psze, ደጊዮር, 
   {{0x7dc41c05,0x3978187f,0x00000000,0x00000000}},	//   _یقین, есію_, --, --, 
   {{0x2fc81c06,0xd24404d3,0x6b880139,0x00000000}},	//   _kpag_, _ۆن_, _çego, --, 
   {{0xd2441c07,0x69d4068f,0x6d4c1c08,0x63ac01e4}},	//   _چن_, _wsze, mlaa, _ĥano, 
   {{0x6d4c1c09,0xd24415fa,0x2d80036e,0xe5a41c0a}},	//   llaa, _نن_, _kthe_, вики, 
   {{0x6d4c1574,0xbb5808ca,0xe6580023,0x00000000}},	//   olaa, _чарх_, _ቅንጸላ, --, 
   {{0x6d4c1c0b,0x23b8033b,0x00000000,0x00000000}},	//   nlaa, tèj_, --, --, 
   {{0x6d4c1c0c,0xe694035b,0x46681c0d,0xe3e80ee8}},	//   ilaa, _аизы, _ерем_, بکان_, 
   {{0x2d801c0e,0x6d4c1c0f,0x77980108,0x21c802dd}},	//   _othe_, hlaa, _чкфр_, _ﺒﻴﺭﻭ, 
   {{0x6d4c1c10,0x3f8000a8,0x2d8001d4,0x2fc80076}},	//   klaa, _stiu_, _nthe_, _apag_, 
   {{0x6d4c01a4,0x23b8007f,0x00000000,0x00000000}},	//   jlaa, pèj_, --, --, 
   {{0x2d801c11,0x6d4c1c12,0x02c01c13,0x4ab0193d}},	//   _athe_, dlaa, _билү, ुभाव, 
   {{0x63a81c14,0xfbe01c15,0x00000000,0x00000000}},	//   mren, निसम, --, --, 
   {{0x6d4c1c16,0x2d8007ab,0x613801c0,0x9d4400e5}},	//   flaa, _cthe_, _очир_, نئرن, 
   {{0x6d4c1c17,0x63a81a44,0xfd64009d,0x00000000}},	//   glaa, oren, унбү, --, 
   {{0x2d801c18,0xefc802d3,0x765c0306,0x8d6001ec}},	// [16c0] _ethe_, ሽቶይ_, _úryv, рвте, 
   {{0xc0480201,0x6d4c1c19,0x63a81c1a,0xb7d40241}},	//   _ማስታወ, alaa, iren, _nṣaf, 
   {{0x63a81c1b,0x6d4c1c1c,0xdca400c7,0x00000000}},	//   hren, blaa, _иани, --, 
   {{0x63a808ad,0x26c41c1d,0x6d4c1af4,0x00000000}},	//   kren, _ablo_, claa, --, 
   {{0x69c001b8,0xcba0010a,0x00000000,0x00000000}},	//   _älen, _каяй, --, --, 
   {{0x799c02d0,0x14d80073,0x4cc803d4,0xdce41c1e}},	//   _tvrw, _मोजण, ৱাণু, _mikč, 
   {{0x28dc0d0a,0x26c4005a,0x2a3400a8,0x00000000}},	//   _नोकि, _dblo_, _бэтр, --, 
   {{0x26c400df,0x46e400fd,0x73d800ee,0xd3780395}},	//   _eblo_, едән_, едир_, мчо_, 
   {{0x63a81c1f,0xda6405d9,0x00000000,0x00000000}},	//   gren, _ساڳي, --, --, 
   {{0x14ac0490,0x6d4c0205,0x00000000,0x00000000}},	//   _टाकण, zlaa, --, --, 
   {{0x63a81c20,0x6d4c1c21,0x2fc80327,0xdce40064}},	//   aren, ylaa, _spag_, _aikč, 
   {{0x94241c22,0x14241c23,0x6d4c0de2,0x2d8000cd}},	//   _имее, _идем, xlaa, _rthe_, 
   {{0x63a81c24,0x73c40032,0x64b00150,0x6d4c01a4}},	//   cren, _сәйе, _اڭىر, vlaa, 
   {{0xb904025c,0xd1b800db,0x6d4c1b9d,0xebc40116}},	//   _ཨལ_, _قاعا_, wlaa, қәмн, 
   {{0x6d4c1c25,0x7e281c26,0x6a7801e1,0xd1380107}},	//   tlaa, віта_, _lúfó, _охи_, 
   {{0x0fe00137,0x6d4c1c27,0x00000000,0x00000000}},	//   _көгү, ulaa, --, --, 
   {{0x6d4c1c28,0x257007f5,0xfbd000c6,0x4ea41c29}},	// [16d0] rlaa, _išle_, يتك_, _ирна, 
   {{0x6d4c1c2a,0xadd8035b,0x00000000,0x00000000}},	//   slaa, _змоу_, --, --, 
   {{0x63a81c2b,0x6d4c1c2c,0x2d800928,0x7b64005e}},	//   zren, plaa, _uthe_, ртте, 
   {{0x6b58026c,0xa81400f7,0x6a780174,0x6d4c0014}},	//   dìge, лдеш, _búfó, qlaa, 
   {{0xa6c8074d,0x499001ed,0xb30c0327,0x61e002d0}},	//   елла_, _چیئر, གྲོང_, zvll, 
   {{0x63a81c2d,0xc6a40137,0x9ba00137,0x00000000}},	//   vren, трди, _دەكى, --, 
   {{0x63a81c2e,0x855401d3,0x00000000,0x00000000}},	//   wren, نیئر_, --, --, 
   {{0x61e00175,0x00000000,0x00000000,0x00000000}},	//   vvll, --, --, --, 
   {{0xe2981c2f,0x63a81c30,0xa9a40116,0x00000000}},	//   нап_, uren, _шиңд, --, 
   {{0xe1f81c31,0x63a81c32,0xd3440345,0xe284035b}},	//   его_, rren, هینه_, ылои, 
   {{0x9af80375,0xdee40107,0xba900150,0x00000000}},	//   תפתח, қови, _ﺗﯘﻳﮕ, --, 
   {{0x645403be,0x63a81c33,0xdce40064,0x00000000}},	//   əzin, pren, _pikč, --, 
   {{0x7d08002d,0x84640395,0xdca41c34,0x00000000}},	//   êdsm, _ръже, ғази, --, 
   {{0xd1b8001f,0xb3700014,0x53980a7c,0x5dd41c35}},	//   ታለች_, _گۯیش, _טינו, любу, 
   {{0xd7d80456,0x00000000,0x00000000,0x00000000}},	//   _मैनच, --, --, --, 
   {{0x7e7c0407,0x2cb806af,0xd24c007b,0x1e840116}},	//   scrp, _ccsd_, _عني_, _өлим, 
   {{0xdc2800f1,0x00000000,0x00000000,0x00000000}},	// [16e0] رسره_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x69c00793,0x2cb80175,0xee38004e,0x5d680798}},	//   _älel, _fcsd_, _үнө_, _пиом_, 
   {{0x2cb80048,0x00000000,0x00000000,0x00000000}},	//   _gcsd_, --, --, --, 
   {{0x6ac809bd,0x00000000,0x00000000,0x00000000}},	//   রয়ো, --, --, --, 
   {{0xda641c36,0x3ce01c37,0x69d802b1,0x2d8400db}},	//   _مازي, ldiv_, āwer, íleg_, 
   {{0x645c1c38,0xceb00302,0x6b580241,0x00000000}},	//   ýsin, ציה_, bìgb, --, 
   {{0xd9441c39,0x3ce01c3a,0x00000000,0x00000000}},	//   _себи, ndiv_, --, --, 
   {{0x28dc1533,0x337410fc,0x61e402d2,0x249803b2}},	//   _नोटि, јгор, _áhlj, ðsma_, 
   {{0x518404a9,0x7d08000f,0x89d41c3b,0x00000000}},	//   лума, êdsj, _جوہر_, --, 
   {{0x1ac400cd,0x00000000,0x00000000,0x00000000}},	//   र्यथ, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ce00334,0xb4e019cc,0xf2c400fb,0x00000000}},	//   ddiv_, दयी_, _көни, --, 
   {{0x4ea41c3c,0x52741c3d,0xefd00023,0x2744013a}},	//   ырма, _суду, _ብኣይ_, cíně_, 
   {{0xc2781a4c,0x3ce00175,0x62241c3e,0x00000000}},	//   _ארוי, fdiv_, _پويە, --, 
   {{0x257005a1,0x3ce00334,0x3ce8012d,0xa1a401af}},	//   _ušle_, gdiv_, _चोदे_, _тышһ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [16f0] --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7c580131,0x00000000,0x00000000,0x00000000}},	//   پلەر_, --, --, --, 
   {{0x6ce40228,0x2cb8045a,0x69c000ee,0x00000000}},	//   _ئزدە, _ucsd_, _älem, --, 
   {{0xa92400d7,0xad2400d1,0x00000000,0x00000000}},	//   _nižň, _مىھى, --, --, 
   {{0x66041c3f,0x16a41363,0x00000000,0x00000000}},	//   ипла, авши_, --, --, 
   {{0x369401ec,0x00000000,0x00000000,0x00000000}},	//   сшіс, --, --, --, 
   {{0x77901c40,0x6d5c0076,0x00000000,0x00000000}},	//   _کیوا, _jhsa, --, --, 
   {{0x739805f5,0x7dcc014a,0x23340107,0x27440118}},	//   лтэс_, _kösö, ихор, tíně_, 
   {{0xa1c40953,0x13041c41,0xae0400e1,0x34940022}},	//   абод, иный_, रहान_, _ҳацр, 
   {{0x6d5c1c42,0xdce400e2,0x65d41c43,0xe4b800c0}},	//   _ohsa, _likā, _خياط, _алеі_, 
   {{0x61441c44,0x3ce00334,0x7dcc01e3,0xd24c00f1}},	//   рема, xdiv_, _lösö, ړنۍ_, 
   {{0x248c1c45,0x3ce0030a,0xfe78049e,0x31d00882}},	//   mbem_, vdiv_, лүп_, āraṃ_, 
   {{0x64581c46,0x6d5c1c47,0xde500b82,0x3ce00175}},	//   _izwi, _ahsa, _መትከል, wdiv_, 
   {{0xdce41c48,0x3ce00334,0x00000000,0x00000000}},	//   _aikā, tdiv_, --, --, 
   {{0xdcb00447,0x6d5c0113,0x248c0548,0x25dc00af}},	//   تىر_, _chsa, nbem_, _कईनी_, 
   {{0x3ce01c49,0xdc6801c6,0x1b480107,0xae480014}},	// [1700] rdiv_, таад_, взаи_, نشہٕ_, 
   {{0x6d5c1c4a,0x6458014b,0x33c00131,0x3ce01c4b}},	//   _ehsa, _mzwi, _ﻣﻪﺯﻣ, sdiv_, 
   {{0xa2bc1c4c,0x2f38001f,0x3ce00175,0x5fdc0f4a}},	//   _शान्, _የህፃና, pdiv_, मिकल, 
   {{0x497002d5,0x1d080f64,0x8cb402dd,0x6c74014b}},	//   іліс, _реми_, _ەگەس_, _гурх, 
   {{0x6458006f,0x87d400f7,0xbd440451,0x18340127}},	//   _nzwi, لبوس_, _ننڍي, جراح, 
   {{0xbd380117,0x00000000,0x00000000,0x00000000}},	//   _рӯҳу_, --, --, --, 
   {{0x645800ca,0xe9380131,0xc6d001d5,0x6d5c010e}},	//   _azwi, خسەت_, زتوت, _yhsa, 
   {{0xb4e000dc,0x3e7c01e1,0x05a4000d,0xf49800d1}},	//   दये_, _yàtó_, _गिरब, اھات_, 
   {{0x74140349,0x00000000,0x00000000,0x00000000}},	//   াপ্ট_, --, --, --, 
   {{0x6fac01ad,0x64581c4d,0x00000000,0x00000000}},	//   _जिबू, _dzwi, --, --, 
   {{0x25a81c4e,0x6458013e,0x248c011f,0xd25800a7}},	//   _مدني_, _ezwi, bbem_, ъци_, 
   {{0xae0407f7,0x00000000,0x00000000,0x00000000}},	//   रहसन_, --, --, --, 
   {{0x53f81c4f,0x9fa40032,0x348400fb,0x22580210}},	//   _جراح_, йырҙ, _кѳҙг, ęska_, 
   {{0x6d5c022e,0xdce40055,0x00000000,0x00000000}},	//   _shsa, _rikā, --, --, 
   {{0x2d841aa7,0xdce40270,0x4d240261,0x70941c50}},	//   ële_, _sikā, аќаа, _лайф, 
   {{0xff1404c5,0x3e7c0ca8,0xdce40055,0x332c0327}},	//   _সদৃশ_, _pàtó_, _pikā, lidx_, 
   {{0x64580175,0xa2bc043e,0x7dcc0108,0x25dc0037}},	// [1710] _xzwi, _शाम्, _pösö, _कैनी_, 
   {{0x4ea41c51,0x332c0175,0x91d8060c,0x69c00139}},	//   _триа, nidx_, _बनाई, _älek, 
   {{0x6d5c02b9,0x257001a6,0xc0e8072d,0x3eb400d7}},	//   _thsa, _ošla_, _صفین_, ňatí_, 
   {{0xdb1400dd,0x6f04014f,0xdce41c52,0xb4e000dc}},	//   rtyá, _hohc, _tikā, दयो_, 
   {{0x27e81c53,0x2ee0006a,0x80bc00dc,0xdb1400e5}},	//   ían_, _kahf_, ष्टे, styá, 
   {{0xfbac0a59,0x320c00a2,0x00000000,0x00000000}},	//   _चितम, kydy_, --, --, 
   {{0x6f04047e,0xa3d807f7,0xa2bc1c54,0x27e8010f}},	//   _mohc, डौन_, _शाब्, ŭan_, 
   {{0x25a81c55,0xe3b81c56,0x8d280023,0x398c01e1}},	//   čal_, гби_, _ተወሃሂ, _wòsò_, 
   {{0x64a41c57,0x6f040076,0x248c15c0,0xb6e00108}},	//   _ғала, _oohc, rbem_, öään, 
   {{0xf7700491,0x6f04014f,0x6594009d,0x00000000}},	//   _قال_, _nohc, _гажу, --, 
   {{0xa2e407d6,0xa2281c58,0xe1080f06,0x6ae00154}},	//   _ҳолд, ужна_, генд_, নাপো, 
   {{0xc568027d,0x201c01e4,0xf49400db,0x00000000}},	//   _شحال_, ŝtim_, _ۇشۇد, --, 
   {{0xa2e41c59,0x63840640,0x6f040455,0x64581c5a}},	//   _голд, _угла, _bohc, _uzwi, 
   {{0xe2981c5b,0x320c010e,0x00000000,0x00000000}},	//   _сак_, bydy_, --, --, 
   {{0x6f040477,0x2c84063f,0x00000000,0x00000000}},	//   _dohc, _ụmị_, --, --, 
   {{0x2d6c1c5c,0xdee4013e,0x8d500023,0xfbac1c5d}},	//   _ﺳﺎﻧﻰ_, шоҳи, _መብርሂ, _चिदम, 
   {{0x5ac81c5e,0x6e2c0020,0x6ae0015b,0xe3c003e0}},	// [1720] ллам_, ደሚገባ, নানো, _çığ_, 
   {{0xda64007b,0x3ce80037,0x9f0415b4,0x00000000}},	//   ماضي, _चोरे_, _چوکو, --, 
   {{0x58841c5f,0x80dc00bc,0x00000000,0x00000000}},	//   была, _बसाइ, --, --, 
   {{0xd838152d,0xd5b8016c,0x00000000,0x00000000}},	//   лэл_, ҳси_, --, --, 
   {{0xdc2c0020,0x62800175,0x37f80276,0xd4980075}},	//   _በመሆኑ, kclo, релэ_, ңри_, 
   {{0x99741c60,0xe7d401d5,0x47300212,0x00000000}},	//   _гуаш, تمهگ, пніс, --, 
   {{0x6d4000fc,0x62800072,0x2c74063f,0x7d08002d}},	//   élag, dclo, _ụdi_, êdsw, 
   {{0x18681c61,0x764403ee,0x7bc4003a,0xe9701c62}},	//   _баби_, şiyo, otiu, _قۇلد, 
   {{0x7bc41c63,0x68fc00a3,0x00000000,0x00000000}},	//   ntiu, _òsda, --, --, 
   {{0x62801c64,0x8a100014,0x7bc4003a,0x00000000}},	//   gclo, _بِہت, itiu, --, 
   {{0x14c81c65,0x8af8008d,0xcfa41206,0x00000000}},	//   _были_, אליז, әшми, --, 
   {{0x7bc40357,0x320c1c66,0x6f04047e,0xdb1401f4}},	//   ktiu, rydy_, _sohc, ltyä, 
   {{0x2570098d,0x6f04014f,0x41c00014,0x6280045a}},	//   _ušla_, _pohc, _ہٲوِ, bclo, 
   {{0x7bc4003a,0x62800072,0xdb1401f4,0x2560032e}},	//   dtiu, cclo, ntyä, gólf_, 
   {{0x91841c67,0x51841c68,0x7bc4003a,0xd1f00023}},	//   _اجتم, _уула, etiu, ግሰቲ_, 
   {{0x69c001b8,0x7bc4036e,0xdb14005b,0x00000000}},	//   _älei, ftiu, htyä, --, 
   {{0x101400f1,0x00000000,0x00000000,0x00000000}},	// [1730] _دبغد, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bc41c69,0x104c001f,0xc278010f,0x00000000}},	//   atiu, _ማስቀመ, ארבי, --, 
   {{0x2040001f,0x764403ee,0xfbd001ed,0x7bc408c2}},	//   _የሕብረ, ğiyl, بتہ_, btiu, 
   {{0x7bc41c6a,0x62801c6b,0x7644083c,0x6ae000fe}},	//   ctiu, yclo, şiyl, নাবো, 
   {{0xe7381c6c,0xdb140139,0x00000000,0x00000000}},	//   јек_, gtyä, --, --, 
   {{0x6b8c0385,0x00000000,0x00000000,0x00000000}},	//   lpag, --, --, --, 
   {{0x69c41253,0x6b8c1c6d,0x62800455,0x63840124}},	//   mthe, opag, wclo, огиа, 
   {{0x6b8c1c6e,0x6280007c,0xf7940064,0x00000000}},	//   npag, tclo, _натэ, --, 
   {{0x6b8c1c6f,0x27ec1c70,0xe298026a,0xcfbc015b}},	//   ipag, _iren_, шао_, ইবান, 
   {{0x27ec1c71,0x69c41c72,0x63ac0115,0xe50814fe}},	//   _hren_, nthe, _ĥanu, _پيشو_, 
   {{0x69c41c73,0x27ec138f,0x291c1c74,0x25701c75}},	//   ithe, _kren_, nhwa_, _išlo_, 
   {{0x291c0810,0x7bc41c76,0x00000000,0x00000000}},	//   ihwa_, xtiu, --, --, 
   {{0x69c41c77,0x6b8c1c78,0x27ec005a,0x00000000}},	//   kthe, dpag, _mren_, --, 
   {{0x1d081c79,0x291c1c7a,0xdc981c7b,0xdca41c7c}},	//   аеви_, khwa_, иташ_, жаби, 
   {{0x27ec1c7d,0x6b8c1c7e,0x7bc41c7f,0x00000000}},	//   _oren_, fpag, ttiu, --, 
   {{0x69c41c80,0x6b8c1c81,0x92cc1c82,0xdee41c83}},	// [1740] ethe, gpag, ৱাৰ_, _допи, 
   {{0x7bc41c84,0x00000000,0x00000000,0x00000000}},	//   rtiu, --, --, --, 
   {{0x7bc41c85,0xd8880952,0x69c41c86,0x27ec1c87}},	//   stiu, لپان_, gthe, _aren_, 
   {{0x7bc41c88,0x57e81c89,0x27ec1c8a,0x61e402d2}},	//   ptiu, идем_, _bren_, _áhlu, 
   {{0x7bc40cfe,0x6b8c010a,0x27ec1c8b,0x07a01c8c}},	//   qtiu, cpag, _cren_, дачн, 
   {{0x69c413ee,0x00000000,0x00000000,0x00000000}},	//   bthe, --, --, --, 
   {{0x27ec1c8d,0x25dc1b76,0xb2740116,0xdb140108}},	//   _eren_, _कैदी_, үлиш, rtyä, 
   {{0x291c1c8e,0x27ec1c8f,0xd1b80201,0xd3a41c90}},	//   chwa_, _fren_, ታወቀ_, ороп, 
   {{0x27ec1c91,0xc0d00240,0x00000000,0x00000000}},	//   _gren_, _ብሳላ_, --, --, 
   {{0xb6c80014,0x92681c92,0x63ac01e4,0xd6280536}},	//   _دارے_, ирна_, _ĥant, _козе_, 
   {{0xf4841c93,0x6b8c1c94,0x4a780677,0x3f8403b2}},	//   _فاشی, zpag, יריב, ímun_, 
   {{0x6b8c1c95,0xb8a40092,0xe1ec00ec,0x00000000}},	//   ypag, _ሊቀጥል_, اڳو_, --, 
   {{0xd1b80020,0x8f081c96,0x6b8c0175,0x69c41c97}},	//   ታወቁ_, ахва_, xpag, zthe, 
   {{0xb8fc0ed9,0x69c41c98,0x291c0810,0x6b8c0175}},	//   _འི_, ythe, zhwa_, vpag, 
   {{0x06280201,0x6b8c1c99,0x69c400a3,0x00000000}},	//   _እንደነ, wpag, xthe, --, 
   {{0x6b8c1c9a,0x69c40998,0x645c000d,0x412800f3}},	//   tpag, vthe, üsig, _мојо_, 
   {{0x6b8c1c9b,0x8c38002f,0xdb9c0150,0xbd6801ec}},	// [1750] upag, _meßg, _ﺀﯨﺮﻯ_, ірсе_, 
   {{0x6b8c1c9c,0x27ec1c9d,0xfbac043e,0x00000000}},	//   rpag, _rren_, _चिरम, --, 
   {{0xa2bc1c9e,0x41241c9f,0x69c41ca0,0xe6881ca1}},	//   _शास्, _رفیق, uthe, ەنتى_, 
   {{0x27ec1ca2,0x6b8c1ca3,0x69c41ca4,0x7d08002d}},	//   _pren_, ppag, rthe, êdst, 
   {{0x6b8c1ca5,0x6d4c1ca6,0xe75801ec,0x00000000}},	//   qpag, moaa, биді_, --, 
   {{0x69c41ca7,0x6d4c1ca8,0x20400092,0xa594020f}},	//   pthe, loaa, _የንብረ, прищ, 
   {{0x79a41ca9,0x27ec1caa,0x291c0161,0x6d4c1cab}},	//   _орте, _wren_, phwa_, ooaa, 
   {{0x6d4c1cac,0x291c1cad,0x00000000,0x00000000}},	//   noaa, qhwa_, --, --, 
   {{0x27ec1cae,0xe3b000c6,0x7bc0014a,0xd1b8001f}},	//   _uren_, ررة_, _ämut, ታወቅ_, 
   {{0x6d4c0108,0x00000000,0x00000000,0x00000000}},	//   hoaa, --, --, --, 
   {{0x6d4c005b,0xf74800f1,0x22480116,0x64740150}},	//   koaa, _بللي_, спни_, _егеу, 
   {{0xfbac03e5,0x61340153,0x74f80b01,0x00000000}},	//   _चिलम, kšle, _мехр_, --, 
   {{0x656808cb,0x20541caf,0x645c1cb0,0x02c001c0}},	//   mmeh, ятор, üsid, _жилү, 
   {{0x65681cb1,0x00000000,0x00000000,0x00000000}},	//   lmeh, --, --, --, 
   {{0x6d4c0607,0x656806d9,0x12f80375,0x00000000}},	//   foaa, omeh, _להסב, --, 
   {{0x65681cb2,0x63ac0fac,0xc2c00451,0x6d4c0108}},	//   nmeh, _åans, _ريڊي, goaa, 
   {{0x25dc0034,0x00000000,0x00000000,0x00000000}},	// [1760] _कैसी_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x58841cb3,0x6d4c06d9,0xed8000d1,0x4f840014}},	//   пыла, boaa, _аңси, _وایہ, 
   {{0x65680477,0x2bdc00cd,0x9d4400fb,0x00000000}},	//   jmeh, _नैवा, _хемд, --, 
   {{0xebc0052f,0x7d0406ea,0x656812bb,0x00000000}},	//   _иҡти, mjis, dmeh, --, 
   {{0x7d041cb4,0x96b81cb5,0x00000000,0x00000000}},	//   ljis, суду_, --, --, 
   {{0x7c24084c,0x7d04037e,0x6b880200,0x97bc01ec}},	//   lzir, ojis, _çegr, _әрбi, 
   {{0x48e01cb6,0x56300023,0x6568000d,0x00000000}},	//   _посв, _ክንክእ, gmeh, --, 
   {{0xa2bc1cb7,0x12e41cb8,0xb9f80240,0x00000000}},	//   _शाश्, пінг, _ዘሁ_, --, 
   {{0x7d041cb9,0x7c240083,0x47d00ccb,0x656800d0}},	//   hjis, izir, _سيمر, ameh, 
   {{0x7c240a40,0xa2bc1cba,0x7d040162,0xf8e001f9}},	//   hzir, _शार्, kjis, _नसाय, 
   {{0x7d041cbb,0x00000000,0x00000000,0x00000000}},	//   jjis, --, --, --, 
   {{0x0f70036b,0x85001cbc,0x1b2000fe,0x6d4c01f4}},	//   нғир, _سوون, _মদনে_, voaa, 
   {{0x7c241cbd,0x69c0168c,0x941c083c,0x645c0112}},	//   dzir, _åleg, ığıy, üsie, 
   {{0xa6c000fe,0x6d4c1cbe,0x7d0408a5,0x00000000}},	//   _এসময়, toaa, fjis, --, 
   {{0x7d04069c,0x6edc0166,0xd0180395,0x0be402dd}},	//   gjis, _bābü, _гфо_, _ﻏﻴﺭﻫ, 
   {{0x2b5005be,0x6f0001ed,0x61441cbf,0x92bc00cc}},	// [1770] _pkzc_, ölcs, _تىيە, ঁজী_, 
   {{0x6d4c1cc0,0x3b541cc1,0x7d08002d,0x7d04005b}},	//   soaa, екур, êdsr, ajis, 
   {{0x7c2404ba,0x2bdc07b7,0x995c0118,0xdce40153}},	//   azir, _नैरा, _kůň_, _likę, 
   {{0x7c24110c,0x7d040014,0x79240b00,0x00000000}},	//   bzir, cjis, ньчж, --, 
   {{0x66e41cc2,0x066400d1,0xa2bc1cc3,0xa7a80022}},	//   дола, ﻴﯩﻨﯩ, _शाल्, цкла_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x65681cc4,0xd5ac0d62,0x0a68030d,0x00000000}},	//   tmeh, لہٕ_, _ырми_, --, 
   {{0xfdf80302,0x87e4014b,0x00000000,0x00000000}},	//   לצות_, _нюзе, --, --, 
   {{0x0474066d,0x65681cc5,0x94700e4a,0x25dc10eb}},	//   _ہلاک_, rmeh, نگها, _कैरी_, 
   {{0x65681cc6,0x69c00793,0xdb140789,0x232800d4}},	//   smeh, _äles, tuyé, іони_, 
   {{0xf7481cc7,0x7c2402e8,0x21681cc8,0x61441cc9}},	//   _علمي_, zzir, жини_, дена, 
   {{0x8c38002f,0xb0640014,0x00000000,0x00000000}},	//   _meßb, کھى۪, --, --, 
   {{0xd9a805d7,0xb0f801c6,0x00000000,0x00000000}},	//   _चट्ट, чээх_, --, --, 
   {{0x69d41cca,0xf1a8004b,0xdb1406af,0x7c240010}},	//   _opze, _ځايه_, puyé, vzir, 
   {{0x7d041ccb,0x00000000,0x00000000,0x00000000}},	//   tjis, --, --, --, 
   {{0x7c2401c0,0x7d040009,0x00000000,0x00000000}},	//   tzir, ujis, --, --, 
   {{0x7d041ccc,0x7c241ccd,0x5f28023a,0x1ae401b9}},	// [1780] rjis, uzir, _моим_, моам, 
   {{0x2a6c01e4,0x76441cce,0xfe9400f2,0xcfb40677}},	//   _ŝeba_, şiyi, _سیرج, _קליי_, 
   {{0x1d081ccf,0x3f80003a,0x25dc00ab,0x02cc00dc}},	//   _дени_, _huiu_, _कैली_, त्यभ, 
   {{0xb7c400c7,0x39400254,0x00000000,0x00000000}},	//   еркқ, õis_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x386001e4,0x02cc00cd,0xe9a800f7,0x00000000}},	//   ĥir_, त्मभ, زدۅن_, --, 
   {{0xd5b81cd0,0x75840241,0x00000000,0x00000000}},	//   іск_, _ẹgbé, --, --, 
   {{0x06801cd1,0xfd6400b8,0x49b00150,0x00000000}},	//   нгән, _pauṃ, _шәуу, --, 
   {{0x69c00036,0x661c0213,0xa3d81cd2,0x00000000}},	//   _äler, _əski, डौल_, --, 
   {{0x59d002fe,0x78a001e6,0x2544005f,0x1cdc0327}},	//   _सहार, _hemv, vēle_, _རིའ_, 
   {{0x32181ab0,0x78a001e3,0xc1b401c6,0x5f0000cd}},	//   áry_, _kemv, млэх_, शान्_, 
   {{0x92bc00bd,0x3f8007c5,0xdce40064,0x00000000}},	//   ঁজে_, _buiu_, _tikę, --, 
   {{0x78a01cd3,0x3f801cd4,0x066400d1,0x00000000}},	//   _memv, _cuiu_, ﻴﯩﻠﯩ, --, 
   {{0x78a01cd5,0x3f8007c5,0x00000000,0x00000000}},	//   _lemv, _duiu_, --, --, 
   {{0x6ef400a2,0x31341cd6,0x00000000,0x00000000}},	//   _aýbä, _пекр, --, --, 
   {{0x3f800268,0xde3c001f,0xecc4009d,0x00000000}},	//   _fuiu_, ደሚያገ, эшгү, --, 
   {{0x3f801cd7,0x3c580276,0x7c840354,0x6af40166}},	// [1790] _guiu_, дитэ_, тусе, нзаф, 
   {{0x799c0142,0xc278010f,0x00000000,0x00000000}},	//   _bwrw, ַרדי, --, --, 
   {{0x78a01cd8,0x7ac40801,0xc9841cd9,0x799c0042}},	//   _bemv, ъсте, фузи, _cwrw, 
   {{0x1cdc0003,0x25601cda,0x3d1c01e1,0xa3340023}},	//   _རིར_, kóla_, _tíwa_, _ብወትሃ, 
   {{0x22580210,0x00000000,0x00000000,0x00000000}},	//   ęski_, --, --, --, 
   {{0x78a000f1,0x7c2005d1,0xaad40248,0x00000000}},	//   _eemv, _ümra, _àlàó_, --, 
   {{0x6aa41cdb,0x05f4002b,0x799c0042,0x369401ec}},	//   mahf, _bhūḥ_, _gwrw, тшіс, 
   {{0x6aa405b1,0x2d801cdc,0x6610031c,0xa020032e}},	//   lahf, _muhe_, _ċekċ, _þögn, 
   {{0x2d801cdd,0x2fc80218,0xf778031c,0x68e8004e}},	//   _luhe_, _nqag_, _fiħ_, _iaed, 
   {{0x290c18a6,0x68e81cde,0x78a01cdf,0xa2041ce0}},	//   _hoea_, _haed, _zemv, епод, 
   {{0x68e81ce1,0x3f800a73,0x290c02b5,0x78a01ce2}},	//   _kaed, _suiu_, _koea_, _yemv, 
   {{0x4acc0db3,0x3f800311,0x290c01a6,0x6b9c03ac}},	//   स्तव, _puiu_, _joea_, _owsg, 
   {{0x290c1ce3,0x2d800270,0x68e804ce,0x256000d2}},	//   _moea_, _auhe_, _maed, cóla_, 
   {{0x68e81ce4,0x1cdc0156,0x2d801ce5,0x657800b0}},	//   _laed, _རིཤ_, _buhe_, _hiwh, 
   {{0x6aa402d0,0x00000000,0x00000000,0x00000000}},	//   dahf, --, --, --, 
   {{0x20000054,0x68e81ce6,0x2d801ce7,0x00000000}},	//   pxki_, _naed, _duhe_, --, 
   {{0x1c441ce8,0x78a01ce9,0x65780455,0x799c02d0}},	// [17a0] хнам, _remv, _miwh, _swrw, 
   {{0x78a01cea,0x63a81ceb,0x64580334,0x68e80334}},	//   _semv, isen, _mywi, _aaed, 
   {{0x63a81cec,0x68e81ced,0xefbc001f,0x78a01cee}},	//   hsen, _baed, ታየው_, _pemv, 
   {{0x63a81cef,0x68e81730,0x26c40784,0x657802b1}},	//   ksen, _caed, _aclo_, _niwh, 
   {{0x68e81cf0,0x63a81cf1,0x645801c8,0x18681cf2}},	//   _daed, jsen, _nywi, чади_, 
   {{0x63a81cf3,0x78a01cf4,0x290c007f,0x68e80381}},	//   dsen, _wemv, _eoea_, _eaed, 
   {{0x63a81cf5,0x68e8001f,0x64580784,0x78a01cf6}},	//   esen, _faed, _aywi, _temv, 
   {{0x63a81cf7,0x645803cb,0x68e81cf8,0x6124032e}},	//   fsen, _bywi, _gaed, _hólf, 
   {{0x64581cf9,0x63a81cfa,0x65781cfb,0x57b00220}},	//   _cywi, gsen, _diwh, _сұлт, 
   {{0x2560026c,0x290c01f7,0x2bd000af,0x6458012d}},	//   róla_, _zoea_, हऽता, _dywi, 
   {{0x63a81cfc,0x290c0a73,0x130400fd,0xca38001f}},	//   asen, _yoea_, _үзем, _ጨዋታዎ, 
   {{0x63a81cfd,0x2d801cfe,0x645803cb,0x256000e4}},	//   bsen, _ruhe_, _fywi, póla_, 
   {{0x2d801cff,0x645800a9,0x63a801d3,0xdd681d00}},	//   _suhe_, _gywi, csen, _ﺳﺎﭘﺎ_, 
   {{0x2d80005b,0x4474010f,0x00000000,0x00000000}},	//   _puhe_, _נעגל_, --, --, 
   {{0xdb0c0241,0xd138010a,0xca2c0150,0x64581d01}},	//   _àjùm, _нхи_, _ﺩﻓﺎ_, _zywi, 
   {{0xb9180055,0xdb14007f,0x66040108,0x9f40013d}},	//   _gneḥ_, lryè, ähki, evkä_, 
   {{0x68e80393,0x2d8000ca,0xfe7001ed,0x6124032e}},	// [17b0] _raed, _wuhe_, لدہ_, _bólf, 
   {{0x68e80097,0x394400ef,0x2d8000d7,0xcf2401c8}},	//   _saed, _ajms_, _tuhe_, _سرخي, 
   {{0xc3300302,0x290c079b,0xe94413f9,0x63a81d02}},	//   נוע_, _poea_, پرای, zsen, 
   {{0x9f5002e2,0x6ecc1d03,0x1d780092,0x7be000cc}},	//   _aryè_, द्रु, _በሴቶች_, _নপৰো, 
   {{0x257005ce,0x290c1d04,0x68e8006f,0x657802b1}},	//   _ušli_, _voea_, _vaed, _riwh, 
   {{0xd7ec0b38,0x61240008,0x64581d05,0x68e81d06}},	//   زكى_, _gólf, _rywi, _waed, 
   {{0x68e816b8,0x290c1d07,0x657800b0,0x63a80334}},	//   _taed, _toea_, _piwh, wsen, 
   {{0x63a81d08,0x26c40354,0x798800f2,0x31680208}},	//   tsen, _wclo_, _édwa, _nhaz_, 
   {{0xe2981d09,0xa77400fd,0x232802e8,0xd9b00133}},	//   мап_, _алач, допи_, _مڕۆد, 
   {{0x3168003a,0xdedc02d3,0x00000000,0x00000000}},	//   _ahaz_, ሕትን_, --, --, 
   {{0x657804fe,0x64580034,0x672002d0,0xf3c81d0a}},	//   _tiwh, _wywi, _illj, وبیه_, 
   {{0x63a81d0b,0xa2bc1d0c,0x6e2800df,0x3d1c01e1}},	//   psen, _शाक्, ĝebl, _ríwo_, 
   {{0xa3e40dc5,0x61e000a9,0x256000d2,0x254400e2}},	//   _पनि_, swll, lólo_, cēla_, 
   {{0xb46402bf,0x53980375,0x61e00142,0xa1f403f6}},	//   _скіл, _חיסו, pwll, _аџиј, 
   {{0xdca41d0d,0xdb14010b,0x00000000,0x00000000}},	//   кави, gtyý, --, --, 
   {{0x3168025c,0x326001d9,0xa3e407f7,0x61241d0e}},	//   _ghaz_, _دۆپہ, _पना_, _sólf, 
   {{0x4fe401c0,0x4c801d0f,0xfb841d10,0x3d1c0241}},	// [17c0] _амын_, рлув, ادری, _wíwo_, 
   {{0x25600296,0x4b201d11,0x61241d12,0x9b3c0092}},	//   kólo_, амув, _bólg, _በየካቲ, 
   {{0x18a412b4,0x9d4400fd,0x00000000,0x00000000}},	//   ваем, _аенд, --, --, 
   {{0x67201d13,0xdcfc1d14,0xe99404fb,0x61240a87}},	//   _allj, _kupč, اهنگ, _dólg, 
   {{0x2ba81d15,0x6ac80c58,0x67200076,0x3ab4008e}},	//   _चौपा, ৰয়ো, _bllj, _бәет, 
   {{0xcf9000c8,0x3ce00158,0x612408a5,0x00000000}},	//   סטו_, leiv_, _fólg, --, 
   {{0xdcfc0010,0x60d402d0,0x394401f4,0xaa6401af}},	//   _lupč, _obym, _tjms_, _берһ, 
   {{0x18681d16,0x254400e2,0x67201d17,0x13a400e5}},	//   _жаби_, tēla_, _ellj, نچتی_, 
   {{0x67400014,0xdb140100,0x98340006,0x00000000}},	//   _گێوٕ, tryè, _рэві, --, 
   {{0x51841d18,0x31681d19,0x60d40129,0xf8640117}},	//   кума, _shaz_, _abym, _авғо, 
   {{0x1d30001f,0x54c413cf,0x2f1c01e1,0xcb10010f}},	//   _በገንዘ, _абеб, _sìgo_, ילז_, 
   {{0x498402d3,0xf8b40959,0x00000000,0x00000000}},	//   _ንነብሱ_, ुलिय, --, --, 
   {{0xc05802bf,0xf2c400d1,0x6d401d1a,0xc95000d9}},	//   вір_, _йөни, élam, שמר_, 
   {{0x8230183b,0x00000000,0x00000000,0x00000000}},	//   اریا, --, --, --, 
   {{0xc20c1d1b,0x5fb00037,0xfc380092,0x00000000}},	//   _тє_, _जिअल, _በመፈለ, --, 
   {{0x612401e7,0x8d740133,0x00000000,0x00000000}},	//   _rólg, ئاسا, --, --, 
   {{0x8aa41d1c,0x61241d1d,0x00000000,0x00000000}},	// [17d0] вред, _sólg, --, --, 
   {{0x6e9800a7,0xef1000f1,0x00000000,0x00000000}},	//   _явор_, _چټک_, --, --, 
   {{0xdcfc041a,0x7bc00158,0x6d3401a9,0xce680f06}},	//   _zupč, _åmun, _бенф, _юрид_, 
   {{0x3ce0002f,0x205c0092,0x00000000,0x00000000}},	//   ceiv_, _ለሕብረ, --, --, 
   {{0x2ca81d1e,0xaac40451,0xb81400c7,0x8c640006}},	//   maad_, _مڪان, аҧтә, _штод, 
   {{0xd2441d1f,0x2ca80050,0xe5a400d1,0x2eb01d20}},	//   _هن_, laad_, гики, _जयोत, 
   {{0xa2e401d5,0x00000000,0x00000000,0x00000000}},	//   қонд, --, --, --, 
   {{0xa3e81d21,0xdedc1772,0x2ca81d22,0x49440166}},	//   едиа_, ሕትና_, naad_, _рэгб, 
   {{0x291c1d23,0x2ba81d24,0x1ae403d4,0xa0a41d25}},	//   mkwa_, _चौमा, নাৰা, һанд, 
   {{0x2ca80014,0x291c009a,0xdcfc0e04,0xb9dc0023}},	//   haad_, lkwa_, _rupč, _አቲ_, 
   {{0xa0a41d26,0xbbd01d27,0x291c01f2,0x2ca81d28}},	//   ланд, _सङ्क, okwa_, kaad_, 
   {{0xdcfc0960,0x291c1d29,0x2ca80009,0xe1241d2a}},	//   _pupč, nkwa_, jaad_, умми, 
   {{0x2ca80050,0x291c1d2b,0xf4840408,0xd36c00f2}},	//   daad_, ikwa_, _тухн, تهی_, 
   {{0x248c1d2c,0xdb140113,0xfe7815bf,0x944001d3}},	//   lcem_, kuyá, күп_, _چھین, 
   {{0x14e40c58,0x2ca80014,0x3ce00c86,0x25600174}},	//   কাৰী_, faad_, teiv_, hólm_, 
   {{0x248c1d2d,0x02cc1d2e,0x2ca81d2f,0x5f340166}},	//   ncem_, त्रभ, gaad_, _әхиф, 
   {{0x3ce00183,0x61240a90,0x20040023,0x248c0381}},	// [17e0] reiv_, _cóle, _çoi_, icem_, 
   {{0x5eac015b,0x291c1d30,0x4f98010f,0x248c0205}},	//   ঞ্জে, ekwa_, _רביצ, hcem_, 
   {{0x2ca80050,0x99141d31,0x248c0010,0xadb40150}},	//   baad_, льді, kcem_, _پۇقا_, 
   {{0x60c406a3,0x2ca81d32,0x248c1d33,0x00000000}},	//   ngkm, caad_, jcem_, --, 
   {{0xb8dc1d34,0x645c00af,0x248c1d35,0x420c00dc}},	//   _आय_, üsil, dcem_, ाहुः_, 
   {{0x291c1d36,0x2c10012c,0x248c00d8,0xcc3800df}},	//   akwa_, णहरू_, ecem_, _װעלט, 
   {{0xf48405c2,0x94840209,0x8b200798,0xd9440117}},	//   қуқн, лыпд, _удре, _беви, 
   {{0x82bc031c,0x73d801a9,0x2ba809ab,0x00000000}},	//   _མཐུའ, вдир_, _चौडा, --, 
   {{0x56f01d37,0xede000bc,0x00000000,0x00000000}},	//   _гүлс, _पन्छ, --, --, 
   {{0x0b380020,0x1cdc031c,0x2ca81d38,0x32541d39}},	//   _በከተማ, _རིཀ_, zaad_, ивпр, 
   {{0x2ca80050,0x248c1d3a,0x8b54010f,0xaf340092}},	//   yaad_, bcem_, רייס_, _ባለማወ, 
   {{0x2ca80a81,0x461000aa,0x53a41086,0x248c0de2}},	//   xaad_, _دومر, _бадб, ccem_, 
   {{0xbf9400e5,0x3d081d3b,0xbe340092,0x00000000}},	//   یگیڈ, हाने_, _አስገዳ, --, 
   {{0x2ca80050,0x61240008,0x11f40014,0xabdc0150}},	//   waad_, _róle, _موتک_, _ﺇﺴﻨﺎ, 
   {{0x2ca81d3c,0x2d841d3d,0x70941d3e,0xa634001f}},	//   taad_, êle_, _кайф, _እንደሰ, 
   {{0xad241a59,0x61241d3f,0xac94141c,0x00000000}},	//   جىرى, _póle, рааш, --, 
   {{0x2ca81d40,0x5fb0000d,0x6714000d,0x999800a2}},	// [17f0] raad_, _जिएल, _तकलक_, lypň_, 
   {{0x2ca81d41,0x61240789,0xdec000d1,0x659000b8}},	//   saad_, _vóle, _мәсо, _hāhe, 
   {{0x6590170b,0x7b641d42,0x2ca80b21,0x248c1d43}},	//   _kāhe, стте, paad_, ycem_, 
   {{0x61240085,0x2ba81715,0x7c84013e,0x2ca80014}},	//   _tóle, _चौथा, _гуре, qaad_, 
   {{0x65901d44,0xef480023,0xe6c400ae,0x00000000}},	//   _māhe, _ዓብደል, لتغي, --, 
   {{0x81d8045e,0x291c1d45,0x645c00c5,0x248c012d}},	//   ঠিত_, skwa_, üsim, wcem_, 
   {{0x2ba8038e,0x6ab402d0,0x248c1d46,0xff18011a}},	//   _चौता, _idzf, tcem_, רקות_, 
   {{0x6590002b,0xfe38010f,0x00000000,0x00000000}},	//   _nāhe, טרוי_, --, --, 
   {{0xa6340020,0xe450007b,0x00000000,0x00000000}},	//   _እንዲሰ, غضب_, --, --, 
   {{0x248c1d47,0xd36c1d48,0xe1f802bf,0xdedc0023}},	//   scem_, وهي_, вго_, ሕድና_, 
   {{0x248c1d49,0x62641d4a,0x30a00150,0xc7940408}},	//   pcem_, рвна, _ﺃﺩﺒﻴ_, _арçы, 
   {{0x65900055,0x61240321,0x6ae000fe,0xe4740166}},	//   _cāhe, _sólb, নাটো, _кулэ, 
   {{0xdcfc1d4b,0x65900055,0x84640395,0x5f8000d1}},	//   _atpğ, _dāhe, _съже, غۇدە, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcfc00b8,0x9d5401d5,0xe50800cd,0xdd9006c2}},	//   _aupā, لنست, वापि_, توز_, 
   {{0x06ac1d4c,0xa2cc02c3,0x10a0030d,0x00000000}},	//   চ্চি, थभक्, _диън, --, 
  
   {{0x5ac81d4d,0x1be80107,0x00000000,0x00000000}},	// [1800] клам_, ъдаи_, --, --, 
   {{0x256009cc,0x5a940454,0xdd881171,0x00000000}},	//   fólk_, рраф, _ибод_, --, 
   {{0xd12c04d3,0x2d84012c,0x00000000,0x00000000}},	//   _رمی_, ílet_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x59d00aff,0xe50800cd,0x00000000,0x00000000}},	//   _सहकर, वानि_, --, --, 
   {{0x501802e4,0x256006ea,0x8f980677,0xda6406c5}},	//   כונו, bólk_, דיסי, _نازي, 
   {{0x61340e3c,0xceb00375,0x98a402bf,0x7bc41d4e}},	//   ršlj, קיה_, _вибе, luiu, 
   {{0xd9440209,0x2c0c03d4,0x00000000,0x00000000}},	//   _теби, _সেয়ে_, --, --, 
   {{0x659002b5,0x7bc41d4f,0xa91c00ef,0x569400fb}},	//   _rāhe, nuiu, _dižd, _ҡаҡт, 
   {{0x7bc41d50,0x4c2c0092,0x9654030d,0x00000000}},	//   iuiu, _በጉባኤ, _къеч, --, 
   {{0x79801d51,0x65900374,0x00000000,0x00000000}},	//   _kimw, _pāhe, --, --, 
   {{0x1cdc025c,0x7bc40869,0x00000000,0x00000000}},	//   _རིཊ_, kuiu, --, --, 
   {{0x50641d52,0x79801d53,0x25a807f5,0x7bc40194}},	//   ртна, _mimw, ćale_, juiu, 
   {{0x79801d54,0x659002b5,0x63bc1d55,0x30040022}},	//   _limw, _wāhe, ásne, азҭг, 
   {{0xfd881d56,0x8d741d57,0x65900374,0x3f84066a}},	//   иёти_, لارا, _tāhe, ímur_, 
   {{0x7980015c,0xc27800c8,0x427806a9,0xdcfc00ef}},	//   _nimw, _ברוי, _באוג, _pupā, 
   {{0x7bc41d58,0xdb140986,0x0b88011c,0x00000000}},	// [1810] guiu, kuyä, тсби_, --, 
   {{0x7980035a,0xa91c01a6,0x2d840789,0xbcf001e4}},	//   _aimw, _miže, íles_, roɩa, 
   {{0x79800537,0x7bc40093,0xc0580014,0xa91c0010}},	//   _bimw, auiu, _مشیا_, _liže, 
   {{0x645c00af,0xdcfc00b0,0x7bc404cc,0x79800142}},	//   üsik, _tupā, buiu, _cimw, 
   {{0x612405a4,0x79801d59,0x6d5c0522,0x7bc41730}},	//   _jóla, _dimw, _iksa, cuiu, 
   {{0x66e41d5a,0x6d5c089c,0x798008e7,0xa6c81d5b}},	//   сока, _hksa, _eimw, улка_, 
   {{0xa3a8134e,0x6b8c031c,0x9f4c01d3,0x00000000}},	//   गीन_, lqag, énél_, --, 
   {{0x69c41d5c,0x24e8013e,0x2248107d,0x00000000}},	//   muhe, умии_, _ćak_, --, 
   {{0x3d08069f,0x69c418a6,0xf7940953,0xd05c03b9}},	//   हाते_, luhe, _матэ, _taqə, 
   {{0x79800516,0x00000000,0x00000000,0x00000000}},	//   _zimw, --, --, --, 
   {{0x69c40334,0x79800223,0x04b40014,0xa91c00ef}},	//   nuhe, _yimw, _نپاں_, _eiže, 
   {{0x61241d5d,0x592c0135,0x61441d5e,0x25601d5f}},	//   _bóla, ྩིགས_, сема, kóli_, 
   {{0x69c41d60,0x00000000,0x00000000,0x00000000}},	//   huhe, --, --, --, 
   {{0x6d5c1d61,0x61241d62,0x5398025f,0x2294007b}},	//   _aksa, _dóla, _עיצו, _الغس, 
   {{0xb638001f,0x69c40037,0x27ec1d63,0x61240332}},	//   _እንደቀ, juhe, _lsen_, _eóla, 
   {{0x2ba81533,0x61341d64,0x27ec1d65,0x6124032e}},	//   _चौहा, kšli, _osen_, _fóla, 
   {{0x79801d66,0x27ec013f,0xf388001e,0x6b8c1d67}},	// [1820] _rimw, _nsen_, _lợn_, gqag, 
   {{0xa3a81d68,0x7bc40393,0x79801d69,0x69c402d2}},	//   गीय_, ruiu, _simw, fuhe, 
   {{0x69c41d6a,0x27ec1d6b,0x6d5c0418,0x79800455}},	//   guhe, _asen_, _fksa, _pimw, 
   {{0x1d081d6c,0x79800784,0x6e2003cd,0x6b8c0327}},	//   _семи_, _qimw, ølbe, bqag, 
   {{0x7bc41730,0x69c41d6d,0x7980009f,0x00000000}},	//   quiu, auhe, _vimw, --, 
   {{0x798000ca,0x1cdc025c,0x69c41d6e,0x25a4015d}},	//   _wimw, _རིཌ_, buhe, _bwll_, 
   {{0x79801d6f,0xa91c0171,0xc6d01d70,0x27ec1d71}},	//   _timw, _siže, ستوت, _esen_, 
   {{0xf8b0034c,0x25a40042,0xf3f8010b,0xecc007f7}},	//   _آکا_, _dwll_, иңе_, एलएफ, 
   {{0xb6380020,0xc7a0050b,0x4acc1d72,0xd3781d73}},	//   _እንዲቀ, _нитк, स्कव, лчо_, 
   {{0xb378037e,0x795400a2,0x61241d74,0x00000000}},	//   _sでbs, _düwş, _róla, --, 
   {{0x6124066a,0x23a805f9,0xf3880208,0x16a80107}},	//   _sóla, चीबद, _gợn_, _авҷи_, 
   {{0xc5f00302,0x61241d75,0x4a78010f,0x09f4011a}},	//   _מדע_, _póla, טריב, צמכם_, 
   {{0x69c40112,0x00000000,0x00000000,0x00000000}},	//   zuhe, --, --, --, 
   {{0x65901d76,0x4ac406ab,0x69c402c4,0xa7fc01d3}},	//   _hāha, _लाइव, yuhe, _szűk, 
   {{0xd04403be,0xe188001e,0x65901d77,0xdce80055}},	//   _əməl, _hẳn_, _kāha, _śnāt, 
   {{0x61241d78,0x25601d79,0x69c41d7a,0xfd880107}},	//   _tóla, tóli_, vuhe, сёри_, 
   {{0x659004fe,0xdcfc0311,0x69c41d7b,0x8d8401b9}},	// [1830] _māha, _supă, wuhe, руҳд, 
   {{0x69c41d7c,0x4ea401c0,0xdcfc054e,0x69c0072b}},	//   tuhe, _уриа, _pupă, _ålek, 
   {{0x2ba81d7d,0x0a680107,0xb05400f1,0x6b8c01a9}},	//   _चौरा, ураи_, _دپکت, sqag, 
   {{0x69c41d7e,0x6d5c0bc9,0xf38801fb,0xacc800f7}},	//   ruhe, _uksa, _rợn_, _өгүз_, 
   {{0x69c41d7f,0x66e4007f,0x6b8c0869,0x00000000}},	//   suhe, _lékņ, qqag, --, 
   {{0x69c402f6,0x25a40368,0xa59412e7,0x2cb80208}},	//   puhe, _pwll_, орищ, _hdsd_, 
   {{0x69c40023,0x6590002b,0x254400e2,0xd90c01d3}},	//   quhe, _bāha, lēli_, ریے_, 
   {{0xe3b81d80,0x1cdc0135,0xe3b00244,0x659000cd}},	//   аби_, _རིབ_, ورخ_, _cāha, 
   {{0x27ec1d81,0x6590002b,0x00000000,0x00000000}},	//   _usen_, _dāha, --, --, 
   {{0xdb14049b,0xf388004d,0xe2c816ac,0x25a403cb}},	//   styö, _tợn_, جودو_, _twll_, 
   {{0x8ebc009e,0xe508002b,0xd24c00e5,0x00000000}},	//   ইভাগ, वादि_, ہنی_, --, 
   {{0x6f04004d,0x659000b8,0xd24c004b,0x28d003ba}},	//   _anhc, _gāha, ځنی_, _हाफि, 
   {{0xd24c0edf,0x20540108,0x2ba809ab,0x00000000}},	//   فنی_, ютор, _चौला, --, 
   {{0xed5000c6,0xe2981d82,0xe7f0033f,0x5f740127}},	//   _ו̾_, _так_, _आईना_, تاجر, 
   {{0x1cdc031c,0x8e801d83,0x21680798,0x5fb4012d}},	//   _རིད_, дгре, _кики_, _अटकल, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x8c38002f,0xd00c007b,0x1c440022,0x93540345}},	// [1840] _meßw, _للي_, цнам, _ارۆچ, 
   {{0x2cb8010a,0x5de40354,0x98a401a6,0xa0c40ee8}},	//   _edsd_, _джоа, rhoč_, _ايکو, 
   {{0xa3a8023e,0x7f5c1d84,0x5d740117,0x00000000}},	//   गीत_, morq, _мумф, --, 
   {{0x6d4007ea,0x7f5c1d85,0x200401ab,0x47e000cc}},	//   élat, lorq, _àois_, পিনী, 
   {{0xc7900137,0x65901d86,0x61240241,0x37f8010b}},	//   وشوب, _rāha, _lólo, селэ_, 
   {{0xd5b81d87,0x27e81d88,0x6e380428,0x98a81d89}},	//   аси_, çana_, _ñabü, ımın_, 
   {{0x65900374,0x7f5c0077,0xe188004d,0x27e8031c}},	//   _pāha, iorq, _sẳn_, ħana_, 
   {{0xe9700220,0x89d41c3b,0x1de0012d,0x612402d2}},	//   _كۇلد, _گوہر_, _पहनत, _sóln, 
   {{0x25a8098d,0xc2f0045e,0x7f5c03f0,0x969400a7}},	//   ćala_, জানি_, korq, _дреш, 
   {{0x65900325,0x63bc01ed,0x7f5c06af,0x25b40014}},	//   _wāha, ásna, jorq, _کۆٹھ_, 
   {{0x659004fe,0x28d01d8a,0x7f5c1d8b,0x612400d8}},	//   _tāha, _हामि, dorq, _cólo, 
   {{0xd1381d8c,0xf3880051,0x940400f1,0x00000000}},	//   рхо_, _hợm_, _وواه, --, 
   {{0x61fc00e2,0x6590002b,0xb6440150,0xa91c01ef}},	//   āsla, _jāhn, _ﺎﻑ_, _jiža, 
   {{0x254400e2,0x7f5c003a,0x00000000,0x00000000}},	//   vēli_, gorq, --, --, 
   {{0x61241d8d,0x03540a7c,0x0ca801f0,0x645c000d}},	//   _gólo, _ויגש_, итаи_, üsiv, 
   {{0x69c003d4,0x2544005f,0xf3880208,0xdce40064}},	//   _ålei, tēli_, _lợm_, _mikė, 
   {{0x61240077,0x7f5c003a,0xa91c0219,0xe1e801d9}},	// [1850] _móll, borq, _niža, _نى۪و_, 
   {{0x6f041d8e,0x9508031c,0x06dc00eb,0x00000000}},	//   _unhc, _ཀོའི_, _যোনি, --, 
   {{0x3f680798,0x00000000,0x00000000,0x00000000}},	//   _фиќо_, --, --, --, 
   {{0xec141d8f,0x67d4119e,0x3bd40139,0x00000000}},	//   _فوجد, зоду, bäq_, --, 
   {{0x3d081d90,0x65900055,0x38640042,0xf3880208}},	//   हारे_, _cāhn, _cymr_, _bợm_, 
   {{0xdce40064,0xa91c0171,0x00000000,0x00000000}},	//   _bikė, _diža, --, --, 
   {{0xd7f8151c,0x98a402f0,0x978000f2,0xf4a80092}},	//   _ғσя_, choď_, ریمه, _መቀመጥ_, 
   {{0x61240005,0x67d416c3,0x7f5c022e,0x00000000}},	//   _cóll, _нобу, zorq, --, 
   {{0x6124002e,0x7f5c0407,0xa4440116,0x29d4007c}},	//   _dóll, yorq, янид, låa_, 
   {{0x61241d91,0xdedc0023,0x0584014b,0x00000000}},	//   _pólo, ዕትን_, _дудм, --, 
   {{0x644c0953,0xaadc012a,0x238401d9,0x626400a8}},	//   _žaid, न्यक, _کٔتِ, явоа, 
   {{0x659000b0,0x63ac0327,0x612400e5,0xa4d400d4}},	//   _hāho, _ħanf, _góll, _ході, 
   {{0x65900325,0x7f5c1d92,0xd12c1d93,0xc2f00154}},	//   _kāho, torq, امُ_, জাবি_, 
   {{0x61240085,0x4ac41d94,0x606c001f,0x5398011a}},	//   _tólo, _लागव, _በንግድ_, _היסו, 
   {{0xc254040b,0x65900374,0x61241d95,0x7f5c0393}},	//   _بخشت, _māho, _hólm, rorq, 
   {{0x7f5c1d96,0x91b80375,0x00000000,0x00000000}},	//   sorq, _המקי, --, --, 
   {{0xc1d81d97,0x3b181d98,0x7f5c02d1,0x00000000}},	// [1860] _बहुग, _porq_, porq, --, 
   {{0x1cdc1b35,0x613400f3,0x7f5c0784,0xa91c0010}},	//   _རིམ_, ršlu, qorq, _riža, 
   {{0x659000b8,0x00000000,0x00000000,0x00000000}},	//   _sāhn, --, --, --, 
   {{0xa91c1d99,0x00000000,0x00000000,0x00000000}},	//   _piža, --, --, --, 
   {{0x612400e4,0x6ec404f2,0x4c801436,0x00000000}},	//   _róll, _عتیق, _плюв, --, 
   {{0x7bc40137,0x28d005f9,0x61241d9a,0xd39400fd}},	//   mriu, _हाथि, _sóll, җәдә_, 
   {{0x98a41d9b,0x61240436,0xc87c1432,0x18a41d9c}},	//   _ниве, _póll, ışan_, _навм, 
   {{0x7794036b,0x39b802e2,0x7bc4000d,0x00000000}},	//   _قیصا, mčs_, oriu, --, 
   {{0x39b80100,0x7bc40076,0xdb1400a2,0xdddc013a}},	//   lčs_, nriu, gryç, _vzpř, 
   {{0x96641d9d,0xdce402d5,0xa91c012c,0x7bc40024}},	//   _екзе, _tikė, _jižn, iriu, 
   {{0x612400e8,0x7bc41d9e,0x39b81d9f,0x0ed00d79}},	//   _tóll, hriu, nčs_, _ताबड, 
   {{0x7bc41da0,0x53b404a9,0xa91c01a6,0xf48401d5}},	//   kriu, _еғир_, _ližn, _قاشی, 
   {{0xb4e8007d,0x612402fb,0x69c008fb,0x7acc033f}},	//   मजी_, _gólm, _ålev, ालाअ, 
   {{0x7bc41da1,0xa91c1da2,0x00000000,0x00000000}},	//   driu, _nižn, --, --, 
   {{0x7bc41da3,0x39b8007f,0x00000000,0x00000000}},	//   eriu, jčs_, --, --, 
   {{0x7bc404cc,0x29d405ac,0x39b80100,0x00000000}},	//   friu, våa_, dčs_, --, 
   {{0x70541da4,0xc158025f,0x799c02d0,0x7bc41da5}},	// [1870] _زندا, _משהו_, _atrw, griu, 
   {{0x6590002b,0x29d40158,0x00000000,0x00000000}},	//   _bāhl, tåa_, --, --, 
   {{0x79a4074d,0x65901da6,0x799c035a,0x7bc41da7}},	//   ерче, _rāho, _ctrw, ariu, 
   {{0xba741da8,0x7bc41da9,0x29d40158,0x50bc00dc}},	//   رالت, briu, råa_, ्लिष, 
   {{0x7bc41daa,0x799c083a,0xc2f0045e,0x6d4c1dab}},	//   criu, _etrw, জাতি_, mnaa, 
   {{0x6d4c1dac,0x0f180490,0x6b9c002f,0xe3e80014}},	//   lnaa, _नकोस_, _itsg, ۪کان_, 
   {{0x25a808ad,0x6d4c1dad,0x6124032e,0x00000000}},	//   ćalo_, onaa, _sólm, --, 
   {{0x6d4c1dae,0x63bc0122,0x56900131,0x2fd80051}},	//   nnaa, ásno, наәт, ktsg_, 
   {{0x6d4c1daf,0xe3e8036b,0x644c0006,0x659002b1}},	//   inaa, تکان_, _žaib, _tāho, 
   {{0x6d4c0a4e,0x20f8004d,0x6aa41db0,0x63ac031c}},	//   hnaa, _ỏi_, nbhf, _ħand, 
   {{0x6d4c1db1,0x69c400a9,0xa3000032,0x6aa41db0}},	//   knaa, nrhe, еүҙе, ibhf, 
   {{0xe7d01db2,0x254400da,0x7bc40006,0x6d4c1db3}},	//   _समाप, tēlu_, yriu, jnaa, 
   {{0x6b9c1db4,0x69c40730,0x6d4c1db5,0x92bc0154}},	//   _ntsg, hrhe, dnaa, ুড়ে_, 
   {{0x65681db6,0xf1a81db7,0x7bc40357,0x6d4c1db8}},	//   lleh, _کاوه_, vriu, enaa, 
   {{0x4ac406ab,0xa91c110c,0x6d4c1db9,0xa3a8134e}},	//   _लाजव, _nižo, fnaa, गीर_, 
   {{0x6d4c1dba,0x69c41dbb,0x39b8033b,0xc0d80023}},	//   gnaa, drhe, včs_, ርቦም_, 
   {{0x8c401dbc,0x799c0368,0x5fd01dbd,0x63ac1dbe}},	// [1880] вете, _strw, _तमिल, _çand, 
   {{0x7bc41dbf,0x65681dc0,0x6d4c1dc1,0x39b80100}},	//   rriu, hleh, anaa, tčs_, 
   {{0x69c41dc2,0x6d4c1dc3,0x2d9400a7,0x65900055}},	//   grhe, bnaa, _пряс, _bāhm, 
   {{0x7bc41dc4,0x6d4c0014,0x61240174,0x5cc40014}},	//   priu, cnaa, _sólj, _کتھِ, 
   {{0x66001dc5,0x69c41dc6,0x65681dc7,0xaab81dc8}},	//   _arlk, arhe, dleh, زدەر_, 
   {{0x61240579,0xc3200729,0x7c241dc9,0x656801e0}},	//   _bólk, যোতি_, myir, eleh, 
   {{0x65680086,0x69c403cb,0x799c012d,0xb81c03d4}},	//   fleh, crhe, _utrw, _দেশত_, 
   {{0x6ba4049f,0xdb0400cc,0x65681dca,0xf388004d}},	//   _åtgä, _avkø, gleh, _hợi_, 
   {{0x7c241dcb,0xa3a80490,0x6600002f,0xb9cc1954}},	//   nyir, गील_, _erlk, _ሲሶ_, 
   {{0x612419cf,0x656806a3,0xc7a0013d,0x00000000}},	//   _fólk, aleh, _рифк, --, 
   {{0x7c241dcc,0x6d4c1dcd,0x65681dce,0x77f81682}},	//   hyir, ynaa, bleh, ṱaḓ, 
   {{0xf38807ae,0x7c240134,0x14241dcf,0x6d4c1dd0}},	//   _lợi_, kyir, _одем, xnaa, 
   {{0x28d01dd1,0x7c240223,0x61ec0e04,0x03140133}},	//   _हासि, jyir, _ćale, ستیت_, 
   {{0x7c24006f,0x6d4c1dd2,0x69c40142,0x00000000}},	//   dyir, wnaa, yrhe, --, 
   {{0x6d4c1dd3,0x9f50007f,0xae4403c7,0x6aac00fe}},	//   tnaa, _msyè_, رپرو, _চালো, 
   {{0x6d4c1dd4,0xa91c1dd5,0x69c40118,0x42c401af}},	//   unaa, _rižo, vrhe, _егән_, 
   {{0x6d4c1dd6,0x4ea41dd7,0xc0d80023,0xdb241dd8}},	// [1890] rnaa, _орна, ርኦም_, کولی, 
   {{0x6d4c1dd9,0xdb140699,0x69c41dda,0x0a680022}},	//   snaa, nsyè, trhe, ореи_, 
   {{0x6d4c1ddb,0x7054036b,0x6568058a,0x7c241418}},	//   pnaa, _زنگا, yleh, ayir, 
   {{0x69c41ddc,0x7c241ddd,0x6b9c02fa,0x6d4c0014}},	//   rrhe, byir, _ttsg, qnaa, 
   {{0x066404a2,0x7c841dde,0x7c240796,0xdc440374}},	//   ﺴﯩﻨﯩ, _ауре, cyir, _tūār, 
   {{0x65680649,0x7a8400db,0x96d8134e,0x00000000}},	//   wleh, رشەم, प्लॉ, --, 
   {{0x65681ddf,0xf3880016,0xd5ac0a81,0x966000d8}},	//   tleh, _gợi_, مہٕ_, лкше, 
   {{0xa5641de0,0x96640023,0x00000000,0x00000000}},	//   رگان, _ምንጽጻ, --, --, 
   {{0x13e41de1,0xa3a80b7d,0xc7640075,0xa3c00dad}},	//   емый_, गीं_, _قائى, ौंध_, 
   {{0x69c003a1,0x65681de2,0x254400e2,0x00000000}},	//   _åles, sleh, tēls_, --, 
   {{0x21681de3,0x6e2005ac,0x660000d7,0x25a80066}},	//   зини_, ølbl, _urlk, _رضای_, 
   {{0x7c240548,0x61241de4,0xdce4002b,0x00000000}},	//   yyir, _kóli, _vikī, --, 
   {{0x44241de5,0x612409f3,0xf3f41de6,0x00000000}},	//   _تراف, _jóli, _аңы_, --, 
   {{0x7c241446,0xd1b80092,0x00000000,0x00000000}},	//   vyir, ዳለች_, --, --, 
   {{0xdd901de7,0x61441de8,0x3fd002f5,0x3d28015e}},	//   اور_, _пека, িবেষ, وتری_, 
   {{0x7c240433,0xaadc012c,0x00000000,0x00000000}},	//   tyir, न्सक, --, --, 
   {{0xf388001e,0x9b880f84,0x7c240337,0xdb5001f7}},	// [18a0] _sợi_, سنال_, uyir, هَر_, 
   {{0x38e8031c,0xa91c00ef,0x7c240022,0x612401a8}},	//   _ལིངྒ, _dižm, ryir, _sólh, 
   {{0x7c241de9,0xdddc0034,0xda640338,0x28d00456}},	//   syir, _wypł, راطي, _हाशि, 
   {{0x61241dea,0x59d0073d,0xd7f81deb,0x830c031c}},	//   _bóli, दंबर, зук_, _ཏོའུ_, 
   {{0xa7fc01ed,0x61241dec,0xe84801f7,0x7b8401ec}},	//   _szűr, _cóli, وجهن_, _ағад, 
   {{0x07a00640,0x2ba8012d,0x00000000,0x00000000}},	//   ћајн, _चौटा, --, --, 
   {{0x61241ded,0x60d4003a,0x00000000,0x00000000}},	//   _eóli, _ocym, --, --, 
   {{0x61241dee,0x2610000d,0x00000000,0x00000000}},	//   _fóli, _थपरी_, --, --, 
   {{0xe9700075,0x84940597,0x53441def,0x00000000}},	//   _ئۇند, رئيس_, ехна, --, 
   {{0xa91c0fb7,0x60d402d0,0x2d84004e,0xf5240327}},	//   _nižj, _acym, ílez_, ལིངྒ_, 
   {{0x53c01df0,0xa2a000bc,0x46a0014b,0x00000000}},	//   _शिवश, _गभर्, _сахв, --, 
   {{0xa5c00598,0xb7f41df1,0x629405c7,0x50640f89}},	//   _төше, _इनाम_, ñzor, етга, 
   {{0x06641df2,0x6d401df3,0xdb14007f,0xd614009f}},	//   ﺴﯩﻠﯩ, èlam, psyè, _آڪڙا_, 
   {{0x8460001f,0x4ea41df4,0x00000000,0x00000000}},	//   _ስትሆን_, эрма, --, --, 
   {{0x28d00d0d,0x7dc401a9,0x00000000,0x00000000}},	//   _हालि, лётд, --, --, 
   {{0xe7f00490,0xa91c02f0,0x0ed006e3,0x00000000}},	//   _आईला_, _pižm, _तावड, --, 
   {{0x50641df5,0xd24c00f1,0x8f08010a,0x00000000}},	// [18b0] _ятка, _خنډ_, _ехна_, --, 
   {{0xa91c0427,0x61240174,0x6e94072d,0x00000000}},	//   _vižm, _róli, _جلدا, --, 
   {{0xa7fc00dd,0x2a8401f0,0x00000000,0x00000000}},	//   _gyűj, тъаҳ, --, --, 
   {{0x61240008,0x61e40295,0xac941df6,0x00000000}},	//   _póli, _ähle, _шамш, --, 
   {{0x2ca81df7,0x00000000,0x00000000,0x00000000}},	//   mbad_, --, --, --, 
   {{0x2ca81df8,0x20d800a2,0x3834035b,0xaa58009b}},	//   lbad_, _išiō_, ынчр, _жигу_, 
   {{0x659002b1,0x36940220,0x569007b5,0xf6641df9}},	//   _kāhi, ушіс, шајт, лешү, 
   {{0x2ca81dfa,0x61240d12,0x00000000,0x00000000}},	//   nbad_, _tóli, --, --, 
   {{0x290c1dfb,0x65901dfc,0x44281dfd,0x2ca81dfe}},	//   _inea_, _māhi, ác_, ibad_, 
   {{0x2ca80a06,0x60d40142,0x066400cf,0x00000000}},	//   hbad_, _scym, _كااپ, --, 
   {{0xa0a41dff,0x290c05ac,0xfdcc015b,0x2ca81e00}},	//   канд, _knea_, _লন্ড, kbad_, 
   {{0x65901d86,0xdb14020c,0x00000000,0x00000000}},	//   _nāhi, rsyé, --, --, 
   {{0x290c0270,0x2ca81e01,0xc444006c,0xe3540304}},	//   _mnea_, dbad_, _سیدن_, _иткэ, 
   {{0x545004a9,0x0bc800d1,0x2ca8002f,0x224800cd}},	//   _әвәт, _ﺗﻪﻫﺮ, ebad_, _śaku_, 
   {{0x290c0270,0xbcf001e4,0x2ca80112,0xdcfc0055}},	//   _onea_, koɩt, fbad_, _utpī, 
   {{0xf28800c8,0x2ca801a4,0x65900055,0xa91c0171}},	//   _אָפֿ, gbad_, _cāhi, _dižk, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [18c0] --, --, --, --, 
   {{0x290c150c,0x2ca81e02,0x00000000,0x00000000}},	//   _anea_, abad_, --, --, 
   {{0x3eb81e03,0x2ca81e04,0xabc400fb,0x59740022}},	//   mart_, bbad_, _ҙарҙ, ҭыҵу, 
   {{0x3eb81e05,0x2ca801ab,0xf3880208,0x5824004e}},	//   lart_, cbad_, _hợt_, кмеб, 
   {{0x6c7405f5,0x0d2000f7,0x569002dd,0x00000000}},	//   _бурх, _түтү, қақт, --, 
   {{0x3eb81e06,0x290c0d43,0x612406ea,0x3cf801f9}},	//   nart_, _enea_, _gólv, _उघडे_, 
   {{0x7afc1e07,0x63ac031c,0x612408a5,0x588400c7}},	//   _iart, _ħana, _hólu, хыҧа, 
   {{0x7afc1e08,0x3eb80876,0xdb140113,0xf3f81e09}},	//   _hart, hart_, muyñ, ениш_, 
   {{0x3eb800c0,0x17841e0a,0x6124148b,0x2c0400dc}},	//   kart_, _агам, _jólu, रियं_, 
   {{0x7afc05f5,0x00000000,0x00000000,0x00000000}},	//   _jart, --, --, --, 
   {{0x3eb80493,0x2ca80067,0x6d400066,0x00000000}},	//   dart_, ybad_, èlak, --, 
   {{0x7afc0240,0xd3c4010b,0x25a00419,0x00000000}},	//   _lart, _айдй, íhle_, --, 
   {{0x4fc40801,0x65900374,0x7afc1e0b,0xdedc0023}},	//   ъсна, _rāhi, _oart, ንስኡ_, 
   {{0x0cc80bb2,0x63ac1e0c,0xdb140113,0xf3880208}},	//   िल्म, _çana, kuyñ, _cợt_, 
   {{0x65901e0d,0x2ca801a4,0x39440109,0xabdc01ec}},	//   _pāhi, tbad_, _omms_, _ﺇﻴﻘﺎ, 
   {{0xad241e0e,0x61240321,0xac18004e,0x2ca80037}},	//   دىرى, _bólu, нобу_, ubad_, 
   {{0x7afc1e0f,0x3eb81e10,0x2ca81e11,0x25a80989}},	// [18d0] _bart, bart_, rbad_, ćali_, 
   {{0x3eb81e12,0x7afc1e13,0x65900053,0x2ca80e89}},	//   cart_, _cart, _wāhi, sbad_, 
   {{0x61241e14,0x659002b1,0xfb8412c4,0x7afc1e15}},	//   _vólv, _tāhi, рытн, _dart, 
   {{0x7afc1e16,0xe8580e67,0x612402d2,0xe5a40131}},	//   _eart, наеш_, _fólu, ңили, 
   {{0x1cdc0003,0x61240162,0xa7e4129d,0xdd3800df}},	//   _ལྡི_, _tólv, اكتى, _נעשכ, 
   {{0xd1d402d3,0xd7ec1456,0x00000000,0x00000000}},	//   ካእታ_, سكى_, --, --, 
   {{0x3a8402d5,0x3d080073,0xa91c01ef,0xe6d8032e}},	//   _вытв, हाचे_, _liži, _áríð, 
   {{0x3eb818a6,0x7afc1e17,0x3944031c,0x290c01c6}},	//   zart_, _zart, _gmms_, _unea_, 
   {{0xa8541e18,0x7afc1e19,0x0ed006ab,0xe3b000c6}},	//   _скач, _yart, _तांड, حرب_, 
   {{0x31681e1a,0x788000bc,0xd7e800db,0xc5e800cc}},	//   _akaz_, _dívč, _سومۇ_, কিবা_, 
   {{0x3eb81e1b,0x6ab41e1c,0xa5200209,0xe4d40b73}},	//   vart_, _mezf, _гүйҗ, _مقاد, 
   {{0xf1a804d3,0x672001a6,0x6ab40165,0x6590002b}},	//   کایه_, _holj, _lezf, _bāhv, 
   {{0xa2e41e1d,0x67201e1e,0xd24c01b9,0x00000000}},	//   _болд, _kolj, قنی_, --, 
   {{0x6ff4025c,0x612401ed,0x62040050,0xabdc0150}},	//   _བརྫུ_, _rólu, _موتٕ, _ﺇﺴﻘﺎ, 
   {{0xe4f80782,0x61241e1f,0xf388001e,0x3eb80112}},	//   ्यपि_, _bólt, _vợt_, rart_, 
   {{0x7afc1e20,0x5c141c65,0x3eb81e21,0xdce40055}},	//   _sart, льзу, sart_, _vikį, 
   {{0x3eb81e22,0x6ab40419,0x00000000,0x00000000}},	// [18e0] part_, _bezf, --, --, 
   {{0x7afc1e23,0x3eb8013c,0x4c800890,0xaac41e24}},	//   _qart, qart_, слув, لتمن, 
   {{0x7afc1e25,0x9d441e26,0x65901e27,0x18a41e28}},	//   _vart, _бенд, _kāhu, гаем, 
   {{0x7afc1e29,0x61241427,0x00000000,0x00000000}},	//   _wart, _tólu, --, --, 
   {{0x7afc1e2a,0x65901e2b,0x23641505,0x1cdc025c}},	//   _tart, _māhu, kolj_, _ལྡག_, 
   {{0x6590166a,0x7afc0c8c,0x9f4c02e2,0x6e340ca8}},	//   _lāhu, _uart, ènèl_, _àgbè, 
   {{0x6720041a,0xd5641e2c,0x39440139,0x95c8074d}},	//   _dolj, лтип, _tmms_, хула_, 
   {{0x18681e2d,0x39440162,0x659000b8,0x00000000}},	//   _заби_, _umms_, _nāhu, --, 
   {{0x67201e2e,0x6d400607,0x74541e2f,0xd6780116}},	//   _folj, ūlag, جھائ, ﻤﯩﻼﺭ_, 
   {{0xa3b410f7,0x67201e30,0x23641e31,0xa91c0301}},	//   _जबर_, _golj, golj_, _riži, 
   {{0x6124022c,0x6590002b,0x4d7c0046,0x00000000}},	//   _nóls, _bāhu, _ﺣﺎﯞﯨ, --, 
   {{0x672005be,0x6590002b,0xe1c40073,0xa91c00ef}},	//   _zolj, _cāhu, _विरघ, _piži, 
   {{0x5edc015b,0xc0581e32,0x23641a48,0x0440030d}},	//   য়নে, гір_, bolj_, _лецн, 
   {{0x7f941e33,0x61241427,0x6720025c,0x25bc0139}},	//   сарх, _sólt, _xolj, _äylä_, 
   {{0x1cdc0135,0x3134010b,0xdddc013a,0xc20c01af}},	//   _ལྡང_, _вейр, _kypř, _ує_, 
   {{0x31681e34,0xa12401d9,0x61e40139,0x0c841e35}},	//   _ukaz_, _نوى۪, _ähla, гызм, 
   {{0x8aa40edb,0x70580131,0xfbd001d9,0x3d940150}},	// [18f0] гред, _шаир_, ۪تہ_, _қияр, 
   {{0x612408a5,0x00000000,0x00000000,0x00000000}},	//   _fóls, --, --, --, 
   {{0x6720000f,0x296400f1,0x00000000,0x00000000}},	//   _rolj, لیسۍ_, --, --, 
   {{0x67201e36,0x27380036,0xf7840014,0xcc840133}},	//   _solj, _kèng_, ۅلنَ, _مۆزه_, 
   {{0xc7c40022,0x9cd4011a,0x00f8010f,0x00000000}},	//   усеи, _דורה_, טזאם_, --, 
   {{0x27380036,0x637c020c,0x28d01b97,0x59d00118}},	//   _mèng_, mèng, _हाकि, दूहर, 
   {{0x23640fb7,0x61ec0cf4,0xf0440092,0x00000000}},	//   volj_, _ćalo, _የኦሊም, --, 
   {{0xa5241e37,0xf60802f2,0xdddc01ef,0x64a400f0}},	//   рмид, اتوه_, _cypř, јапа, 
   {{0xc0ec1e38,0x65900b3a,0x2738034c,0x888006ce}},	//   _ቅዳሴ_, _rāhu, _nèng_, _ایشن, 
   {{0x36d40d1d,0x24a40014,0x48ec00bc,0xdb0c03e0}},	//   _гофр, دٕکِ, ीएको_, şköp, 
   {{0xf7701e39,0x659002b1,0x26c401e4,0x27ec01c7}},	//   _راك_, _pāhu, _idlo_, _hpen_, 
   {{0x3e7c01e1,0x00000000,0x00000000,0x00000000}},	//   _látí_, --, --, --, 
   {{0x27380066,0x68e81e3a,0x612405f7,0xa0740220}},	//   _cèng_, _mbed, _sóls, рынш, 
   {{0x27380036,0x6124148b,0x765806be,0x00000000}},	//   _dèng_, _póls, _çayç, --, 
   {{0xa0a41e3b,0x63a81e3c,0x65900053,0x68e81e3d}},	//   _кайд, lpen, _tāhu, _obed, 
   {{0xf38801dc,0x63a81e3e,0x27ec1e3f,0x68e80327}},	//   _hợp_, open, _open_, _nbed, 
   {{0x4d6002bf,0x5bc40372,0x00000000,0x00000000}},	// [1900] ікув, شقال, --, --, 
   {{0x63a81e40,0xed580107,0x61e00200,0x00000000}},	//   ipen, воӣ_, otll, --, 
   {{0x27ec1e41,0x61e01e42,0xeb740006,0x13f0000d}},	//   _apen_, ntll, сытэ, _अन्ह_, 
   {{0x57a41e43,0x760001ed,0x26c41e44,0x637c04fb}},	//   ашка, házá, _adlo_, lènd, 
   {{0x76001e45,0x63a80196,0x25a400db,0x2738004d}},	//   kázá, jpen, _atll_, _xèng_, 
   {{0x68e81e46,0x73d801d5,0xe7b000db,0x00000000}},	//   _ebed, ҳдир_, سۅمد, --, 
   {{0x291c01ee,0x00000000,0x00000000,0x00000000}},	//   bjwa_, --, --, --, 
   {{0xa91c0c53,0x68e80241,0x25a000d0,0x73d801d5}},	//   _bižu, _gbed, íhla_, гдир_, 
   {{0x27e81e47,0x63a81e48,0x07a0136b,0xc7a00c56}},	//   çant_, gpen, _матн, _митк, 
   {{0x2738020c,0x00000000,0x00000000,0x00000000}},	//   _rèng_, --, --, --, 
   {{0x63a80036,0xe6d802d2,0xe5c800f2,0x00000000}},	//   apen, _áráð, _مظنه_, --, 
   {{0x94841e49,0x61240321,0x637c020c,0x73341e4a}},	//   _кылд, _sólr, yèng, _گىتا, 
   {{0xb4c4060c,0x637c00db,0x3ccc00fe,0x93241e4b}},	//   ौली_, fènd, াভাৱ, _پرشن, 
   {{0x73340075,0x637c1e4c,0x00000000,0x00000000}},	//   _دىتا, gènd, --, --, 
   {{0xb63804ce,0x637c020c,0xd13801af,0x00000000}},	//   _ｄｌ_, wèng, _ахп_, --, 
   {{0x637c020c,0xdedc0023,0x61340153,0x00000000}},	//   tèng, ንትኻ_, kšly, --, 
   {{0xe4f80a28,0x7bc0003a,0x00000000,0x00000000}},	// [1910] ्यति_, _æmul, --, --, 
   {{0x8aa41e4d,0x637c0214,0xf0040107,0x7b140305}},	//   ррад, rèng, _кӯҳи, одух, 
   {{0xc9840965,0x63a805f5,0x27ec0204,0x291c1e4e}},	//   ауди, zpen, _spen_, tjwa_, 
   {{0x27381e4f,0x637c1e50,0xe6181e51,0x68e80165}},	//   _mène_, mène, ғди_, _qbed, 
   {{0x63a81e52,0x6d4c1e53,0x291c02c4,0x637c1e54}},	//   xpen, miaa, rjwa_, lène, 
   {{0x22000309,0x6aa805d1,0x00000000,0x00000000}},	//   nçhá_, _şeff, --, --, 
   {{0x291c00fb,0x76000118,0xf3880208,0xda6c00ec}},	//   pjwa_, vázá, _rợp_, _ٻڏل_, 
   {{0x6d4c0eda,0x68e80640,0x34f00131,0xe1f80022}},	//   niaa, _ubed, җҗәт, ҳго_, 
   {{0x63a81e55,0x6d4c0418,0x637c004a,0x5edc009e}},	//   upen, iiaa, hène, য়তে, 
   {{0x63a81e56,0x6d4c00c5,0xe1f8004e,0xe2c81e57}},	//   rpen, hiaa, гго_, دودو_, 
   {{0x63a81e58,0x22481d39,0x27380129,0xd00401e0}},	//   spen, упни_, _cène_, ҙере_, 
   {{0x61e0004e,0x6d4c0108,0x00000000,0x00000000}},	//   rtll, jiaa, --, --, 
   {{0x65680093,0x02c00166,0xd494011a,0x84640395}},	//   moeh, _дилү, _הכנת_, _тъже, 
   {{0x2cb80165,0x65681e59,0xe2c81e5a,0xdee40114}},	//   _aesd_, loeh, _صوبو_, љови, 
   {{0x443c1e5b,0x9d54182f,0x637c1e5c,0x6d4c1e5d}},	//   lzu_, منست, rènd, fiaa, 
   {{0x6d4c1e5e,0xe0d815ed,0x443c1e5f,0xe6d80d12}},	//   giaa, _сви_, ozu_, _áræð, 
   {{0x443c1e60,0x28d01e61,0x2cb80789,0xdd10025c}},	// [1920] nzu_, _हाजि, _desd_, _iżżu, 
   {{0x65681e62,0x443c009d,0x5a9401f0,0x6c5400d4}},	//   hoeh, izu_, сраф, іттє, 
   {{0x656801ee,0x637c0129,0x6d400309,0xb7ec0154}},	//   koeh, cène, ëlac, ওয়াত_, 
   {{0x6d4c0936,0xdef800c7,0x00000000,0x00000000}},	//   ciaa, _рыҩ_, --, --, 
   {{0x7d041e63,0xdb0801e7,0x00000000,0x00000000}},	//   mdis, ánói, --, --, 
   {{0x7d041e64,0x443c1e65,0xdb0c0241,0xdcfc00ef}},	//   ldis, dzu_, _àjàm, _tupē, 
   {{0x7d041e66,0x98a41e28,0xbda40023,0xd5e80451}},	//   odis, _гибе, ዋህቦም_, اعتن_, 
   {{0x74140f1b,0x65680327,0xa91c0171,0xe7f001f9}},	//   قوبا, goeh, _dižs, _आईचा_, 
   {{0x7d041e67,0x1cdc0135,0x2738007f,0x00000000}},	//   idis, _ལྡབ_, _sène_, --, 
   {{0x7d04049b,0x2738067c,0x612408ce,0xdb100139}},	//   hdis, _pène_, _sólp, _ügär, 
   {{0x443c1e68,0x6568020c,0xaadc00bc,0xfd5800b8}},	//   azu_, boeh, न्टक, bhaḥ, 
   {{0x637c1e69,0x7d041e6a,0x25b40014,0x225000d0}},	//   vène, jdis, _بۆٹھ_, úzka_, 
   {{0x50641e6b,0x7d041e6c,0x6d4c1e6d,0x850004d3}},	//   стна, ddis, viaa, _روون, 
   {{0x7d040548,0x27381e6e,0x32380023,0x637c1e6f}},	//   edis, _tène_, _ብጉልባ, tène, 
   {{0x6d4c1e70,0x8d741e71,0xb80002f5,0x7980035a}},	//   tiaa, مارا, ্হিত_, _ohmw, 
   {{0x7d041e72,0x637c06af,0x00000000,0x00000000}},	//   gdis, rène, --, --, 
   {{0x6d4c1e73,0x00000000,0x00000000,0x00000000}},	// [1930] riaa, --, --, --, 
   {{0x6d4c1e74,0x7d041e75,0xfb841e76,0x798002d0}},	//   siaa, adis, пыхн, _ahmw, 
   {{0x443c1e77,0x637c0228,0xac941e78,0x7d041e79}},	//   zzu_, lènc, _манш, bdis, 
   {{0x443c1e7a,0x6d4c0140,0x7d0401e4,0x00000000}},	//   yzu_, qiaa, cdis, --, 
   {{0x637c1e7b,0xe4f80882,0xf9901e7c,0xf4ac0150}},	//   nènc, ्यसि_, ربم_, _ﺴﺘﺸﻜ, 
   {{0x443c1e7d,0x65681e7e,0xd5ac0014,0x16a400d4}},	//   vzu_, woeh, چہٕ_, овши_, 
   {{0xf7700502,0x65681e7f,0xd5ac0d62,0x00000000}},	//   راه_, toeh, نہٕ_, --, 
   {{0x443c05f5,0x63ac05d1,0x67d400cf,0xe57800f0}},	//   tzu_, _çank, _мобу, јзи_, 
   {{0x443c04ce,0xa4440075,0x51a002dd,0x00000000}},	//   uzu_, юнид, _ﺍﻟﺨﻁ_, --, 
   {{0xa1c41e80,0x1cdc1e81,0x637c0228,0x7d04036e}},	//   обод, _ལྡན_, dènc, zdis, 
   {{0x443c0034,0xa7fc01ed,0xb5940124,0x7d041e82}},	//   szu_, _gyűr, _еихш, ydis, 
   {{0x21681e83,0x20881e84,0xe3b0009f,0x798002d0}},	//   рими_, ийни_, _قرت_, _xhmw, 
   {{0x637c00f7,0x7d041e85,0x8ee00154,0x00000000}},	//   gènc, vdis, য়নগ, --, 
   {{0x6d5c0227,0x7d041e86,0xfe781e87,0x1798011a}},	//   _ajsa, wdis, йүп_, יישב, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2fcc1e88,0x7d041e89,0x637c020c,0x3ba40022}},	//   šega_, udis, bènc, злаҳ, 
   {{0x637c0228,0x6e20022c,0x6d40017a,0x00000000}},	// [1940] cènc, ølbr, ëlaa, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d040334,0x09e0023a,0x00000000,0x00000000}},	//   pdis, дохн, --, --, 
   {{0x7d040d62,0x1d081e8a,0x00000000,0x00000000}},	//   qdis, _теми_, --, --, 
   {{0x386000ac,0x6aa806be,0x09e400eb,0x00000000}},	//   çir_, _şefe, ফিগা, --, 
   {{0xcb24004b,0xd7780023,0x3860003d,0x7bc400c0}},	//   _وړلو_, _ፖሊቲካ_, ħir_, msiu, 
   {{0x98a400ee,0xae0c0406,0xc68c009f,0x00000000}},	//   _миве, हियन_, نِه_, --, 
   {{0x38c800aa,0x7bc40006,0x1c0c0acd,0x7388010b}},	//   _داسی_, osiu, सिपल_, әриң_, 
   {{0x7bc41e8b,0x74140597,0x799c1e8c,0x9f4000f2}},	//   nsiu, سودا, _hurw, atké_, 
   {{0x799c1e8d,0x637c00f7,0xa3280113,0x128802e8}},	//   _kurw, vènc, _p葵ac, ищни_, 
   {{0x799c1e8e,0xd258010b,0x4b78010f,0x00000000}},	//   _jurw, рцп_, שטיג, --, 
   {{0x09cc03f4,0x799c1e8f,0x7bc41e90,0x637c0228}},	//   _রহমা, _murw, ksiu, tènc, 
   {{0x7bc40007,0x6e94024c,0x00000000,0x00000000}},	//   jsiu, зигу, --, --, 
   {{0x637c0372,0x799c14dc,0x00000000,0x00000000}},	//   rènc, _ourw, --, --, 
   {{0x637c0228,0x799c1e91,0xf4cc015b,0x63ac031c}},	//   sènc, _nurw, লভীব, _ħani, 
   {{0x13dc00cc,0x00000000,0x00000000,0x00000000}},	//   _বৈয়, --, --, --, 
   {{0x7bc41e92,0x799c02d0,0x637c1e93,0x00000000}},	// [1950] gsiu, _aurw, lèna, --, 
   {{0x799c1e94,0x7ff41e95,0x9f4000d7,0x00000000}},	//   _burw, _آسيا, ytké_, --, 
   {{0x7bc41e96,0x799c0042,0x637c020c,0xb17c01e4}},	//   asiu, _curw, nèna, ntĥo, 
   {{0x799c1e97,0xc9841e98,0x00000000,0x00000000}},	//   _durw, цузи, --, --, 
   {{0x2d881730,0xd90c01ed,0x5edc015b,0x6f040175}},	//   mmae_, ھیے_, য়রে, _kahc, 
   {{0x799c1e99,0x2738007f,0x637c020c,0x2d880381}},	//   _furw, _bèna_, kèna, lmae_, 
   {{0x6b9c1e9a,0x799c1e9b,0x6f04047e,0x637c020c}},	//   _husg, _gurw, _mahc, jèna, 
   {{0x69c41e9c,0x6aa41e9d,0x6b9c1e9e,0xe3b81e9f}},	//   mshe, lchf, _kusg, бби_, 
   {{0x69c40731,0x1c0c05d7,0xc6e4109a,0x6b941ea0}},	//   lshe, सियल_, _міжп, _kizg, 
   {{0x6b9c1ea1,0x46681ea2,0x799c0223,0x69c41ea3}},	//   _musg, _крем_, _yurw, oshe, 
   {{0x69c41ea4,0x6b941ea5,0x637c1ea6,0x6aa41ea7}},	//   nshe, _mizg, gèna, ichf, 
   {{0x293400df,0x00000000,0x00000000,0x00000000}},	//   פאָן_, --, --, --, 
   {{0x6f041ea8,0x2ee001ee,0x6b9c0209,0x69c41ea9}},	//   _bahc, _bchf_, _nusg, hshe, 
   {{0x637c00f2,0xdd90004b,0x53980375,0x6d400af9}},	//   bèna, ځوس_, _פיצו, ëlan, 
   {{0x6b9c1eaa,0x69c41eab,0x637c067c,0x6f040009}},	//   _ausg, jshe, cèna, _dahc, 
   {{0xf1a8168d,0x6b9c026c,0x7bc41eac,0x6b94005f}},	//   _باوه_, _busg, tsiu, _aizg, 
   {{0xd00c1ead,0x69c41eae,0x5ac81eaf,0x6b941eb0}},	// [1960] _ملي_, eshe, йлам_, _bizg, 
   {{0x7bc41eb1,0x799c1eb2,0x6b941eb3,0x6b9c01c3}},	//   rsiu, _purw, _cizg, _dusg, 
   {{0x7bc41eb4,0xdca41768,0x799c0784,0x6b9c005a}},	//   ssiu, _нани, _qurw, _eusg, 
   {{0x68f80649,0x6aa4000f,0x59d000e1,0x7bc41eb5}},	//   gewd, achf, दूगर, psiu, 
   {{0x69c41eb6,0x6b9c1eb7,0x6b9403f9,0x799c1594}},	//   ashe, _gusg, _fizg, _wurw, 
   {{0x799c0230,0x69c40009,0x473002bf,0xd5b81eb8}},	//   _turw, bshe, нніс, бси_, 
   {{0x799c1eb9,0x69c41eba,0xbacc01ec,0x00000000}},	//   _uurw, cshe, _ﻗﯘﺷﺎ, --, 
   {{0x34941ebb,0x6b94022e,0x637c02e2,0x18a4074d}},	//   майр, _zizg, vèna, _хаам, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x637c0699,0x88380302,0xe72800aa,0xdcfc0064}},	//   tèna, _התמו, _وسلو_, _tupė, 
   {{0xb9e407db,0x2d88003a,0xcb10011a,0x25700228}},	//   _ከኣ_, ymae_, גלת_, رۇۇس, 
   {{0x2738007f,0x8678008f,0x6f04047e,0xd1381ebc}},	//   _jènn_, _פראו, _sahc, схо_, 
   {{0xcfa411ed,0x6f04014f,0x637c020c,0x6aa40042}},	//   яшни, _pahc, sèna, ychf, 
   {{0x2fcc1ebd,0x69c41ebe,0x6b9c00a3,0x637c07c2}},	//   šego_, yshe, _rusg, pèna, 
   {{0x6b9c0421,0x6f040007,0x6b940240,0x69c40067}},	//   _susg, _vahc, _rizg, xshe, 
   {{0x6b9407d6,0x6b9c1ebf,0x69c4005c,0x6aa40142}},	//   _sizg, _pusg, vshe, wchf, 
   {{0xfe7000dd,0x2d881ec0,0x69c41ec1,0x8138005e}},	// [1970] ندہ_, rmae_, wshe, _ءسىز_, 
   {{0x69c41ec2,0x6b9401b9,0x2d88003a,0x00000000}},	//   tshe, _qizg, smae_, --, 
   {{0x6aa41ec3,0xac980220,0xdb241ec4,0x69c40ba7}},	//   rchf, _وندا_, بولی, ushe, 
   {{0x69c41ec5,0x6aa41ec6,0xe8541ec7,0x66000334}},	//   rshe, schf, وناد, _rslk, 
   {{0x68f81ec8,0x69c41ec9,0xfc6400a7,0x6b941eca}},	//   rewd, sshe, _зърн, _tizg, 
   {{0x69c41ecb,0x76c400d1,0x00000000,0x00000000}},	//   pshe, ىغىل, --, --, 
   {{0xb4e8000d,0x76c4036b,0x69c40003,0x00000000}},	//   यभू_, رغول, qshe, --, 
   {{0x61e40209,0xbe3c0375,0xa4f80073,0x44a000db}},	//   _ähli, מעות, ्येच_, رۅتق, 
   {{0xd85400db,0x00000000,0x00000000,0x00000000}},	//   _жетө, --, --, --, 
   {{0x45a008c9,0x644c02d5,0xdedc1b49,0xd34403e6}},	//   _كەتك, _žais, ንትን_, وینه_, 
   {{0x77640137,0x63ac0135,0xa51c0153,0x00000000}},	//   éixe, _ħanu, _вялi, --, 
   {{0x637c0ba1,0x00000000,0x00000000,0x00000000}},	//   cènn, --, --, --, 
   {{0xa2e40dd8,0x00000000,0x00000000,0x00000000}},	//   _жолд, --, --, --, 
   {{0xb37c02d3,0x33940108,0xdddc00de,0xb38400c0}},	//   _ብብዙሕ_, _зачё, _uzpū, _зліл, 
   {{0x1b0400bd,0x1d080261,0x2fc81ecc,0x81b40011}},	//   রামে_, оеви_, _evag_, _চমক_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9b040aa5,0xc0ec001f,0x27380100,0x1f640b01}},	// [1980] мзад, _ቅዳሜ_, _rènn_, _оким, 
   {{0x2738007f,0x4c8006ed,0x98a003e0,0x5ac8003b}},	//   _sènn_, тлув, _ıkı_, ілем_, 
   {{0x63500118,0x9d441ecd,0x5d6800d8,0x00000000}},	//   měně, _женд, _миом_, --, 
   {{0x312000dc,0x00000000,0x00000000,0x00000000}},	//   यायः_, --, --, --, 
   {{0xc7a00314,0x07a01ece,0x00000000,0x00000000}},	//   вичк, вачн, --, --, 
   {{0xf1c00030,0x3ce01ecf,0x764400c7,0x00000000}},	//   úšky_, lgiv_, нҭза, --, 
   {{0x8a000faa,0xda700050,0x312000dc,0xdedc001f}},	//   _изре, _شُر_, यामः_, ንስና_, 
   {{0x3ce01ed0,0x00000000,0x00000000,0x00000000}},	//   ngiv_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2e4400e8,0x00000000,0x00000000,0x00000000}},	//   _jëfé_, --, --, --, 
   {{0x2fc81ed1,0x333c0332,0xcad4011a,0x850005af}},	//   _svag_, _vlvx_, ווית_, روین, 
   {{0x92bc03f4,0x91481ed2,0xae0c00af,0x00000000}},	//   ইলে_, ічна_, हिसन_, --, 
   {{0xf6ec031c,0x54340832,0xffe40229,0x72d401af}},	//   _ལྡོང, _ترار, кюрн, _золф, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2010058a,0x7f941ed3,0x9f5000e5,0x00000000}},	//   _eryi_, тарх, óbát_, --, 
   {{0x2fc8002b,0x25a000d7,0x00000000,0x00000000}},	//   _tvag_, íhli_, --, --, 
   {{0x63ac1ed4,0xc0dc0020,0x506401a9,0xcfa802f2}},	// [1990] _çant, ንንም_, _ютка, _بابم_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd3641af6,0x8cc800af,0x00000000,0x00000000}},	//   _ڕه_, तृशो, --, --, 
   {{0x2d981ed5,0x2ca81ed6,0x9cd400d9,0x00000000}},	//   _iise_, mcad_, _אורה_, --, 
   {{0x6d9001a2,0x2ca80014,0xd7041ed7,0x2d981ed8}},	//   _sťah, lcad_, енше_, _hise_, 
   {{0x2d981ed9,0x249c02d3,0xdac40131,0x00000000}},	//   _kise_, _ቀዳሞት_, _سېنى_, --, 
   {{0x2ca80009,0x1b040154,0x92bc00eb,0xe58400db}},	//   ncad_, রাণে_, ইলো_, رۅشۉ_, 
   {{0x2d981eda,0xe4581edb,0x92bc03d4,0x64a40124}},	//   _mise_, яжи_, ইলৈ_, _ҟала, 
   {{0x2d981edc,0xd7640132,0x2ca80009,0xdcfc0171}},	//   _lise_, _كەنى_, hcad_, _pupī, 
   {{0x78a41edd,0x2d981ede,0xf748004b,0xb38c0023}},	//   žive, _oise_, _تللي_, _መኣዝን_, 
   {{0x2d981edf,0xdedc1ee0,0xa0680640,0xe0441ee1}},	//   _nise_, ንድን_, зама_, енми, 
   {{0xa0341ee2,0x4fa01ee3,0x1b04015b,0x2ca80067}},	//   رىست, лияв, রাতে_, dcad_, 
   {{0x03640014,0xf36401e0,0x638400db,0x00000000}},	//   _تٔتی_, _үтән, _ягла, --, 
   {{0x2d981ee4,0x637c020c,0xa4fc0327,0x2ca80009}},	//   _bise_, nènm, _དྲོག_, fcad_, 
   {{0x71580046,0x2d981ee5,0x2ca80009,0x00000000}},	//   _орыс_, _cise_, gcad_, --, 
   {{0x2d981ee6,0x8c400a5b,0x2600012d,0x3ce00254}},	// [19a0] _dise_, гете, _वैसी_, rgiv_, 
   {{0x2d981ee7,0x2ca80067,0x612402d2,0x00000000}},	//   _eise_, acad_, _róly, --, 
   {{0x533404ac,0x2d981ee8,0x795403e6,0x2ca80009}},	//   ענען_, _fise_, نێسا, bcad_, 
   {{0x5974034c,0x60c41ee9,0x97c41eea,0x2d981bce}},	//   رداز, nakm, ейде, _gise_, 
   {{0xc8c41eeb,0xa4fc025c,0xd4981b15,0x2c001eec}},	//   روون_, _དྲེག_, үри_, _күтм, 
   {{0xd5b81eed,0x2d981eee,0xe7380142,0x00000000}},	//   пси_, _zise_, _stŵr_, --, 
   {{0xceb0025f,0x2d981eef,0x6ff4031c,0x60c41ef0}},	//   ניה_, _yise_, _བརྐུ_, kakm, 
   {{0x38c81ef1,0x59741ef2,0x60c41ef3,0x2d98008e}},	//   _زاری_, _чыгу, jakm, _xise_, 
   {{0x75d4021a,0x60c406df,0x12e401ce,0x7c240005}},	//   ريکا, dakm, нінг, nxir, 
   {{0x637c1ef4,0x63800124,0x00000000,0x00000000}},	//   lènj, аҳча, --, --, 
   {{0x60c401e4,0xd2581ef5,0x65900055,0xd34401d5}},	//   fakm, яци_, _lāhy, ویچه_, 
   {{0x4a580677,0x60c400ef,0x00000000,0x00000000}},	//   לדיו, gakm, --, --, 
   {{0xb4bc0316,0xb4040107,0x5eb00154,0x00000000}},	//   अरी_, _рӯйд, _জয়ে, --, 
   {{0x2d981ef6,0xae0c069f,0x72d4009b,0xf0b001d3}},	//   _sise_, हिलन_, _рокф, دیکھ, 
   {{0x2d980b91,0xf8d00574,0x60c41d9f,0x8778010f}},	//   _pise_, हणाय, bakm, פאלי, 
   {{0x51840b8d,0x032007dd,0x3014035b,0xad240075}},	//   _яула, _адән, _адир, خىرى, 
   {{0x2ca801d9,0x863c1ef7,0x00000000,0x00000000}},	// [19b0] rcad_, ባልነት, --, --, 
   {{0x659000b8,0x2d981ef8,0x2ca81ef9,0x3eb40419}},	//   _dāhy, _wise_, scad_, čatí_, 
   {{0x70541efa,0x2d981efb,0x412407d6,0x7c240de2}},	//   _سنگا, _tise_, _شفیق, axir, 
   {{0x637c0d29,0x2d980c3a,0x6c54104e,0xe8580153}},	//   vènm, _uise_, _акму, маеш_, 
   {{0x7c841efc,0x66e41efd,0x27e8145e,0x00000000}},	//   _буре, вола, îan_, --, 
   {{0x63ac0115,0x9ba000d1,0x637c02e2,0xece000bc}},	//   _ɩand, _ئەلى, tènm, _फाँफ, 
   {{0xa4fc1efe,0x77640005,0xa5c4013d,0x00000000}},	//   _དྲུག_, éixa, төзе, --, 
   {{0x2000033f,0xf9880220,0x799400f3,0x00000000}},	//   ywki_, _كەلۋ_, _бисф, --, 
   {{0x78a401a6,0xc76400d1,0x80b0012d,0x60c41eff}},	//   živc, _كائى, ंडसे, vakm, 
   {{0x7bc0036e,0xdedc0092,0x00000000,0x00000000}},	//   _çmue, ንድና_, --, --, 
   {{0x21681f00,0x61440a83,0x60c41f01,0x7c240083}},	//   дини_, вена, takm, zxir, 
   {{0x35f81370,0x6aa81f02,0x25a00419,0x00000000}},	//   _سرمد_, _şefl, íhlu_, --, 
   {{0x60c41f03,0x7c240e14,0x00000000,0x00000000}},	//   rakm, xxir, --, --, 
   {{0x22141f04,0xd24c04fb,0xf1a80133,0x6448002f}},	//   _афир, _ژنو_, بایه_, mzei, 
   {{0x64481f05,0x60c41f06,0x6590002b,0x5de4011c}},	//   lzei, pakm, _sāhy, ъжва, 
   {{0x7c2401c6,0x8d600354,0xdcf40153,0x65900055}},	//   txir, авсе, plyč, _pāhy, 
   {{0x64480639,0x9f840853,0x5f741f07,0x00000000}},	// [19c0] nzei, _игид, _لادر, --, 
   {{0x64480730,0x63bc1f08,0x7c240014,0x0b40008e}},	//   izei, ásny, rxir, анун, 
   {{0x64480730,0xdd881ee3,0x5a941f09,0x26000210}},	//   hzei, _обод_, траф, _वैली_, 
   {{0xd7f80372,0x7c240bc9,0xdca41f0a,0x39401f0b}},	//   дук_, pxir, _шами, óis_, 
   {{0x87e00b32,0x48e00410,0xd7880066,0x00000000}},	//   ающе, рочв, وختم_, --, 
   {{0x64481f0c,0x7a100055,0x00000000,0x00000000}},	//   dzei, _ṛtuy, --, --, 
   {{0xd5640131,0x6448002f,0xd7c405af,0x74541f0d}},	//   ктип, ezei, روژه_, گھائ, 
   {{0x64480730,0x01ac00cc,0x00000000,0x00000000}},	//   fzei, _কিংদ, --, --, 
   {{0x06801f0e,0x644803fa,0x312000dc,0x33741f0f}},	//   лгән, gzei, यासः_, лгир, 
   {{0x87b40375,0x60c00115,0x833001c6,0x8c400139}},	//   _סלבס_, _ĵoma, иных, _öşeg, 
   {{0x55041f10,0xd7640137,0xd7d00118,0x00000000}},	//   _ачла, _كەچى_, _सिँच, --, 
   {{0x5184026a,0x64480e78,0x506401c6,0x00000000}},	//   ђуна, bzei, втга, --, 
   {{0x93441f11,0xe81400e1,0x1ae001f9,0x2ec4004e}},	//   _инде, ढिया_, _पांथ, лөнм, 
   {{0xc0ec001f,0x91e001e0,0x704400cf,0x00000000}},	//   _ህዳር_, _кәмһ, _ەردە, --, 
   {{0x8d741f12,0x00000000,0x00000000,0x00000000}},	//   نارا, --, --, --, 
   {{0xd7d01f13,0x4ee00011,0x00000000,0x00000000}},	//   _सिंच, য়েল, --, --, 
   {{0x80b00073,0x00000000,0x00000000,0x00000000}},	// [19d0] ंडरे, --, --, --, 
   {{0x16001f14,0x312000cd,0xaa9401a9,0xeeb8010a}},	//   लबार_, यावः_, гизч, _ялош_, 
   {{0xfaa4016c,0x64481f15,0x00000000,0x00000000}},	//   ршун, zzei, --, --, 
   {{0x61e401e3,0x00000000,0x00000000,0x00000000}},	//   _åhle, --, --, --, 
   {{0xbc68009f,0xe7580150,0x00000000,0x00000000}},	//   _لمَن_, ниді_, --, --, 
   {{0x637c0066,0x6448022e,0x00000000,0x00000000}},	//   rènk, vzei, --, --, 
   {{0x78a41326,0xd764005e,0xdb04012c,0x3a980276}},	//   živa, دەلى_, _utká, _акрэ_, 
   {{0x2408169c,0x64481f16,0x637c1f17,0xf8e402de}},	//   ении_, tzei, mèni, _ەسەپ, 
   {{0x290c1f18,0x68e81f19,0xdbd003fa,0xdb1400ee}},	//   _iaea_, _iced, _müßt, hsyý, 
   {{0x64481f1a,0x290c1f1b,0x386001e7,0x00000000}},	//   rzei, _haea_, úire_, --, 
   {{0x64481f1c,0x290c1f1d,0x26c401e4,0x637c020c}},	//   szei, _kaea_, _ielo_, nèni, 
   {{0x26c41f1e,0x71241e4a,0x61440eed,0xb5580139}},	//   _helo_, لىپم, уема, _иихф_, 
   {{0x26c41f1f,0x290c096b,0x25a41f20,0x68e80198}},	//   _kelo_, _maea_, _hull_, _mced, 
   {{0x25a41f21,0x26c4098d,0x290c1f22,0x5f041f23}},	//   _kull_, _jelo_, _laea_, ызга, 
   {{0x26c41f24,0x290c00fb,0x68e8127b,0x63a81f25}},	//   _melo_, _oaea_, _oced, lqen, 
   {{0x61e01f26,0x26c41f27,0x68e800aa,0x25a41f28}},	//   mull, _lelo_, _nced, _mull_, 
   {{0x61e01f29,0x63a80944,0x25a4007c,0xdc6801c6}},	// [19e0] lull, nqen, _lull_, хаад_, 
   {{0x290c0093,0x68e81f2a,0x26c41f2b,0x25a40109}},	//   _aaea_, _aced, _nelo_, _oull_, 
   {{0x61e01f2c,0x290c00fb,0x637c1f2d,0x2738067c}},	//   null, _baea_, gèni, _gèni_, 
   {{0x68e81f2e,0x61e00194,0x290c0142,0xe0e00011}},	//   _cced, iull, _caea_, _বসুন, 
   {{0x26c41f2f,0x290c00fb,0x00000000,0x00000000}},	//   _belo_, _daea_, --, --, 
   {{0x61e01f30,0x26c41f31,0x290c0421,0x68e8127b}},	//   kull, _celo_, _eaea_, _eced, 
   {{0x26c41f32,0x290c1509,0x25a407de,0x61e01f33}},	//   _delo_, _faea_, _cull_, jull, 
   {{0x26c41f34,0x290c1f35,0x25a40e21,0x14c80022}},	//   _eelo_, _gaea_, _dull_, хыки_, 
   {{0x26c41f36,0x63a80944,0x00000000,0x00000000}},	//   _felo_, gqen, --, --, 
   {{0x26c41f37,0x25a41f38,0xd6281f39,0x660c0210}},	//   _gelo_, _full_, _позе_, łaka, 
   {{0x61e01f3a,0xdb040598,0x6aa80790,0x25a40f85}},	//   gull, _itkä, _şefk, _gull_, 
   {{0x94841f3b,0x26c40f72,0x3ea4013f,0x00000000}},	//   _йылд, _zelo_, ɛmti_, --, 
   {{0x54341f3c,0x61e01368,0xdce40171,0xca6801ec}},	//   _حرار, aull, _dikļ, зiлi, 
   {{0x61e01f3d,0x26c40077,0x73340131,0x00000000}},	//   bull, _xelo_, _خىتا, --, 
   {{0x61e01f3e,0x25a40077,0x25dc0037,0x00000000}},	//   cull, _xull_, _गमछी_, --, 
   {{0x27381f3f,0x637c1f40,0x70440150,0x00000000}},	//   _vèni_, vèni, _ەرگە, --, 
   {{0xd1f8044e,0x6fd802e5,0xde40001f,0x7c840395}},	// [19f0] ዋእቲ_, _भटिं, ከላከል, буфе, 
   {{0x39441f41,0xead41f42,0x68e81f43,0xdbdc0162}},	//   _alms_, рожь, _sced, _víðg, 
   {{0x26c41f44,0x290c1f45,0xcbc400f1,0xfb840108}},	//   _relo_, _paea_, _څېرو_, сытн, 
   {{0x26c41f46,0x25a41f47,0x78a41f48,0x63a802d1}},	//   _selo_, _rull_, živn, yqen, 
   {{0x26c41f49,0x25a406bb,0x290c1f4a,0x61e01f4b}},	//   _pelo_, _sull_, _vaea_, zull, 
   {{0x61e00cfe,0x290c0053,0x68e8009a,0x7bc00023}},	//   yull, _waea_, _wced, _çmua, 
   {{0x290c1f4c,0xd5ac0c8b,0xb0b406ab,0x68e80356}},	//   _taea_, وفو_, ंडाग, _tced, 
   {{0x25a40228,0x61e01f4d,0x26c41f4e,0x68e80af2}},	//   _vull_, vull, _welo_, _uced, 
   {{0xa3e40c66,0xa8541f4f,0x26c41f50,0x25a40493}},	//   बंध_, _ткач, _telo_, _wull_, 
   {{0x61e01f51,0xe2981f52,0x26c40421,0x25a41f53}},	//   tull, кап_, _uelo_, _tull_, 
   {{0xe1241f54,0x61e00140,0xe4d40814,0x63a81f55}},	//   амни, uull, _نقاد, sqen, 
   {{0x61e01f56,0xa3e406ab,0x65780117,0x63a8014f}},	//   rull, बंद_, _ukwh, pqen, 
   {{0x61e01f57,0x31681f58,0x22580034,0x00000000}},	//   sull, _djaz_, ńsk_, --, 
   {{0x61e01f59,0xdee41f5a,0xd0040063,0xc58400f1}},	//   pull, јови, јере_, _شپږم_, 
   {{0x61e01f5b,0x3f8400da,0xdd901a9b,0x00000000}},	//   qull, ēmu_, قوس_, --, 
   {{0x20541f5c,0x637c1f5d,0xdb14002e,0xa2dc043e}},	//   _втор, gènv, ppyë, पलक्, 
   {{0x67200327,0x00000000,0x00000000,0x00000000}},	// [1a00] _onlj, --, --, --, 
   {{0xb17c01e4,0x4b200329,0x8b200d1d,0x00000000}},	//   muĥa, омув, одуе, --, 
   {{0xa3e41f5e,0x7f5c0113,0x5f440014,0xa6880150}},	//   बूत_, mirq, _منکل, _ﺯﺍﻻﻝ_, 
   {{0xd944026a,0xdb0402d3,0x7f5c0113,0x00000000}},	//   једи, _kukë, lirq, --, 
   {{0x7d041f5f,0xd70419bf,0x4cb802e4,0x985406ed}},	//   meis, изди, _בזכו, јтеш, 
   {{0xed5801f1,0x73d802a9,0x9f400200,0x765c032e}},	//   ďže_, қдор_, dukë_, _þryk, 
   {{0x645c1f60,0x1c0c02ab,0x60d402d0,0xdb040200}},	//   úsin, सिकल_, _odym, _lukë, 
   {{0x7d041f61,0x44a0104b,0x66040784,0x7f5c03b9}},	//   neis, يمىق, çhka, hirq, 
   {{0x6aa81f62,0x7f5c02d1,0x195802dd,0x00000000}},	//   _şefi, kirq, _заңы_, --, 
   {{0x7d041f63,0x60d41f64,0x16740063,0xdb041f65}},	//   heis, _adym, _кћер, _utkä, 
   {{0x7d041f66,0x154400f3,0x00000000,0x00000000}},	//   keis, _кежм, --, --, 
   {{0x7d04023a,0xdb040023,0xd1381f67,0x7778022e}},	//   jeis, _bukë, тхо_, lovx, 
   {{0x7d041f68,0x6720000f,0x60d41f69,0x4ea41f6a}},	//   deis, _ynlj, _ddym, ирва, 
   {{0x9324021a,0xc05800d6,0x7f5c0309,0xdb040240}},	//   _څرګن, рію_, girq, _dukë, 
   {{0x7d041f6b,0x637c004e,0x29dc03b2,0xf1940395}},	//   feis, gènu, _máað_, _ликь, 
   {{0x7d041f6c,0x00000000,0x00000000,0x00000000}},	//   geis, --, --, --, 
   {{0x6e941f6d,0x7f5c0784,0x644c0024,0x8aa40cb6}},	// [1a10] _گلدا, birq, _žaiz, аред, 
   {{0x7f5c0309,0x7c200841,0x00000000,0x00000000}},	//   cirq, _šmrc, --, --, 
   {{0x6e941f6e,0xdb0401c7,0x637c0214,0x00000000}},	//   _دلدا, _zukë, mènt, --, 
   {{0xd2440050,0x637c00f2,0x7d0401e4,0x31781f6f}},	//   _ہن_, lènt, ceis, nosz_, 
   {{0xff501f70,0x00000000,0x00000000,0x00000000}},	//   _رخی_, --, --, --, 
   {{0xa3e4000d,0x00000000,0x00000000,0x00000000}},	//   बंस_, --, --, --, 
   {{0x31780827,0x00000000,0x00000000,0x00000000}},	//   kosz_, --, --, --, 
   {{0xa5241f71,0x637c00f2,0x660c0210,0x4b50009f}},	//   смид, hènt, łako, _اَڀر, 
   {{0x52e000e1,0x7f5c0784,0x14201f72,0xc0ec01f3}},	//   पलूस, yirq, здым, _ህዳሴ_, 
   {{0x7d041f73,0xdddc0118,0x7f5c025c,0x00000000}},	//   zeis, _expř, xirq, --, 
   {{0x7d041f74,0xdb0400e8,0xc4cc01d3,0x77901a4b}},	//   yeis, _sukë, _ہےں_, _تیوا, 
   {{0x9f40020c,0x7f5c1f75,0xdb040240,0x7d0401f4}},	//   muké_, wirq, _pukë, xeis, 
   {{0x7d041f76,0xdb04007f,0x9f4000f2,0x7f5c02d1}},	//   veis, _fukè, luké_, tirq, 
   {{0x7d041f77,0x602400c7,0x2164013d,0x00000000}},	//   weis, _ҳдиа, ртүг, --, 
   {{0x7d041f78,0x7f5c0986,0xe0600133,0x5330041b}},	//   teis, rirq, تێکی, _хејт, 
   {{0x21f00548,0xed58013e,0x20c401b9,0xa0580f47}},	//   máh_, ҳоӣ_, _уйим, _مؤخر_, 
   {{0x21f00429,0x637c0066,0x7f5c02d1,0xdee40120}},	// [1a20] láh_, bènt, pirq, _лопи, 
   {{0x7d041f79,0x637c1f7a,0x7f5c0113,0x9f04004b}},	//   seis, cènt, qirq, _اودو, 
   {{0x9938063b,0x7d0411ad,0x38c81f7b,0x21f0011f}},	//   ляду_, peis, لاشی_, náh_, 
   {{0x9f40020c,0x29dc03b2,0x81c803d4,0xf8b80022}},	//   duké_, _sáað_, _ৰঙা_, рҩа_, 
   {{0x637c020c,0x9b8812ea,0x645c00d0,0x98a400c7}},	//   nèns, _منحل_, úsil, аиҵе, 
   {{0x21f00548,0xeb740153,0xabc401af,0x00000000}},	//   káh_, _дысэ, _фарҙ, --, 
   {{0xceb00bd9,0x8f980a1e,0x21f0011f,0x637c0066}},	//   ליג_, ניצי, jáh_, hèns, 
   {{0x73d81f7c,0xdb04020c,0x21f00429,0x9484010b}},	//   адир_, _sukè, dáh_, йыпд, 
   {{0x637c02e2,0x51a00150,0x562801ec,0x932400f2}},	//   yènt, _ﺍﻟﺘﻁ_, _әжем_, مردن, 
   {{0x1b040154,0x870800e5,0x9f400241,0x00000000}},	//   রাকে_, _معمہ_, buké_, --, 
   {{0x21f00429,0x637c0ffb,0x9f400214,0x4b78010f}},	//   gáh_, vènt, cuké_, רטיג, 
   {{0xd14801b9,0x4a98010f,0x2bd80ebb,0x00000000}},	//   اشدن_, טייג, _ढिला, --, 
   {{0x637c0137,0x2738067c,0x3da40107,0x31781f7d}},	//   tènt, _gèns_, ҷруб, rosz_, 
   {{0x21f00548,0xdce40139,0x11f41f7e,0x6e200a7f}},	//   báh_, _pkkğ, _هوتک_, ålbo, 
   {{0x21f0011f,0x7e280d30,0x3134014b,0x858001e1}},	//   cáh_, біта_, _мекр, _ẹniẹ, 
   {{0x78a41f7f,0xa1b402f2,0x00000000,0x00000000}},	//   živj, _بجوڵ, --, --, 
   {{0x637c00e4,0x00000000,0x00000000,0x00000000}},	// [1a30] pènt, --, --, --, 
   {{0x321c00d7,0x8aa401a9,0x00000000,0x00000000}},	//   _krvy_, срад, --, --, 
   {{0xc9841f80,0x00000000,0x00000000,0x00000000}},	//   буди, --, --, --, 
   {{0x28f80108,0x2c700ca8,0x00000000,0x00000000}},	//   редь_, _ẹdun_, --, --, 
   {{0x6aa80276,0x6d4c0b4f,0xa6c81f81,0x6358007f}},	//   _şefu, mhaa, алла_, wňnm, 
   {{0x70b41f82,0x21f0011f,0x9f400066,0x7b6401ec}},	//   ंडुल, yáh_, tuké_, _етсе, 
   {{0x21f00429,0x7f3c010f,0x888000e5,0x00000000}},	//   xáh_, רעוו, _کیشن, --, 
   {{0x6d4c1f83,0xa4440116,0x21f000d7,0x00000000}},	//   nhaa, жнид, váh_, --, 
   {{0x86e81f84,0x38340276,0xdb04002e,0x21f00548}},	//   _معاف_, _ентр, _suké, wáh_, 
   {{0xe1f81f85,0x21f0011f,0x00000000,0x00000000}},	//   аго_, táh_, --, --, 
   {{0x6d4c1f86,0x46681f87,0x97300fa2,0x00000000}},	//   khaa, _срам_, _تکنا, --, 
   {{0x21f00429,0x6b28031c,0x637c07b0,0x00000000}},	//   ráh_, _ལོའོ_, tèns, --, 
   {{0x6d4c1f88,0x23281f89,0x21f0011f,0x656800d7}},	//   dhaa, _воли_, sáh_, mneh, 
   {{0x65681f8a,0xdb04003e,0x637c04fb,0x443c1f8b}},	//   lneh, _tuké, rèns, myu_, 
   {{0x637c0502,0xa3e40c2e,0xfe7800f7,0x21f00548}},	//   sèns, बूर_, сүн_, qáh_, 
   {{0x6d4c1f8c,0xdb14023a,0x00000000,0x00000000}},	//   ghaa, nsyö, --, --, 
   {{0x443c1f8d,0x6600005a,0x65681f8e,0x78a40010}},	// [1a40] nyu_, _lplk, ineh, živk, 
   {{0x443c013f,0x61e00194,0x6d4c058a,0x6568002f}},	//   iyu_, orll, ahaa, hneh, 
   {{0x9a680597,0x5ca400c2,0x0b14007b,0x68f80142}},	//   جمال_, _минб, تقلة_, ffwd, 
   {{0x6d4c1f8f,0x443c1f90,0x98a41f91,0x6aa80790}},	//   chaa, kyu_, циде, _şeft, 
   {{0xd7081f92,0x18681f93,0x65680030,0x443c1f94}},	//   инде_, шади_, dneh, jyu_, 
   {{0x501806a9,0x443c1f95,0x6568035a,0x4730187f}},	//   יונו, dyu_, eneh, мніс, 
   {{0xd9440d06,0x656803fa,0x1a640066,0x00000000}},	//   _деви, fneh, _بیای_, --, 
   {{0x443c0083,0x65681f96,0x058001ec,0x00000000}},	//   fyu_, gneh, муым, --, 
   {{0x443c1f97,0xa3e40d2c,0x61e00077,0x87e40046}},	//   gyu_, बूल_, erll, _وتكە, 
   {{0x72d00131,0x321c1f98,0x32541f99,0x63e000d1}},	//   رەبچ, _prvy_, звор, رۋىل, 
   {{0x6d4c102c,0x65681f9a,0x443c1574,0xc0d80023}},	//   yhaa, bneh, ayu_, _ክኢላ_, 
   {{0x65681f9b,0xc68c0014,0x443c04ce,0x3ce4033f}},	//   cneh, _شِن_, byu_, गलों_, 
   {{0x61e01f9c,0x443c1f9d,0x7c200306,0x00000000}},	//   arll, cyu_, _šmrn, --, 
   {{0x61e0037e,0x6d4c00b0,0xd14801d5,0x300400c7}},	//   brll, whaa, اشگن_, озҭг, 
   {{0xd1c805f5,0x6d4c1f9e,0xb63c00b5,0x201c02b1}},	//   _тулд_, thaa, _ｇｓ_, ātia_, 
   {{0x2afc012c,0x00000000,0x00000000,0x00000000}},	//   र्नु_, --, --, --, 
   {{0xc0d802d3,0xd1480014,0xc0f40023,0x6b84014f}},	// [1a50] _ክኢሉ_, _مشکن_, ልኦም_, tlhg, 
   {{0x6d4c1f9f,0xe86405f5,0x65681f98,0xa03401ec}},	//   shaa, үхдү, zneh, _رىپت, 
   {{0x2fc8079b,0x6d4c198f,0x6568058a,0xa8880116}},	//   _hwag_, phaa, yneh, әйла_, 
   {{0x443c1fa0,0xf9901fa1,0x00000000,0x00000000}},	//   yyu_, نبن_, --, --, 
   {{0x88041fa2,0x6d5c1fa3,0x656801f1,0x7af001b8}},	//   تظام, _imsa, vneh, äitö, 
   {{0x39a803e3,0xdc38011a,0xe5a400cf,0x49b80133}},	//   _ağsu_, _העשר, пики, _نارد_, 
   {{0x65681fa4,0x24880cf4,0x443c03f0,0x63b8015d}},	//   tneh, _šam_, wyu_, _stwn, 
   {{0x443c0bed,0x70b401ad,0x38c80137,0xd88401d9}},	//   tyu_, ंडोल, _муун_, _کھٔن_, 
   {{0x65681fa5,0x3f980368,0x443c0099,0x00000000}},	//   rneh, ymru_, uyu_, --, 
   {{0x65681fa6,0x443c1fa7,0xdb14023a,0x69c0025c}},	//   sneh, ryu_, ssyö, _ħlej, 
   {{0x443c1fa8,0x776400db,0x656800d7,0x66e401af}},	//   syu_, èixe, pneh, _моҡа, 
   {{0x21681fa9,0x443c0bf1,0xe8900023,0x61e00200}},	//   сими_, pyu_, _ዝሓስቡ_, rrll, 
   {{0x4ac80da0,0x00000000,0x00000000,0x00000000}},	//   िराव, --, --, --, 
   {{0x6d5c1faa,0xdb040158,0x98780375,0xca6800fa}},	//   _amsa, _utkø, מארט, зiмi, 
   {{0x61441fab,0xf9f80327,0x3f980327,0xdddc013a}},	//   _нека, _པཱེན_, rmru_, _vypů, 
   {{0x2d941fac,0xdd88013e,0x91d8010f,0x00000000}},	//   друс, ёбад_, _פֿופ, --, 
   {{0x2fc80368,0xdddc01ef,0x00000000,0x00000000}},	// [1a60] _gwag_, _typů, --, --, 
   {{0x6d5c03bd,0xa3cc1fad,0xdc6801d5,0xd1b00345}},	//   _emsa, षीय_, _ҳамд_, _تیێک, 
   {{0x1d080334,0x00000000,0x00000000,0x00000000}},	//   _лени_, --, --, --, 
   {{0xed040137,0x00000000,0x00000000,0x00000000}},	//   _قوپپ, --, --, --, 
   {{0x0c2002d5,0x680001d3,0xbb740eff,0xd7c40073}},	//   _змян, _rájö, _قۇرع, रींच, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d5c022c,0x8b2000a7,0x68f0005b,0x00000000}},	//   _ymsa, _ядре, ähdö, --, 
   {{0xf9041fae,0x6aa008a5,0x00000000,0x00000000}},	//   _تأسی, _úlfa, --, --, 
   {{0xd3781faf,0x97c40345,0x00000000,0x00000000}},	//   йчо_, _رقاو, --, --, 
   {{0x15b00533,0x6610088b,0xcc540375,0xd8cc00d1}},	//   _كەتس, äkkä, פסיק_, _ﻗﯩﻼﻟ, 
   {{0x2fc81590,0x201000ca,0x00000000,0x00000000}},	//   _swag_, _asyi_, --, --, 
   {{0xf8cc1fb0,0x92bc0154,0x2fd8007b,0x984c06be}},	//   ारिय, েলে_, يوجد_, lğıc_, 
   {{0xb4e8121d,0xc95000d9,0x91cc000d,0x00000000}},	//   बली_, תמר_, _दबवै, --, 
   {{0x27e8026c,0xd14800f2,0x4ea41fb1,0x984c0213}},	//   àani_, _گشتن_, ярма, nğıc_, 
   {{0xf8cc1fb2,0x6fd80574,0xfe7000c6,0xf1c80150}},	//   ाराय, _भटकं, هدف_, _بوعى_, 
   {{0x2fc80280,0xdb04013c,0xd24c01d3,0x00000000}},	//   _twag_, _nukâ, _لنڈ_, --, 
   {{0x2fc8012d,0xf41400df,0x00000000,0x00000000}},	// [1a70] _uwag_, ופּ_, --, --, 
   {{0x7b141fb3,0x41a80037,0x00000000,0x00000000}},	//   ндух, _घूँस, --, --, 
   {{0x7f3c0302,0x442801fb,0xc0f40023,0xe3bc0154}},	//   _לעזו, ̣c_, ልጦም_, _ইয়াব, 
   {{0x6d5c1fb4,0x2bb40412,0xe8f80816,0xb4f801f9}},	//   _umsa, _अंपा, ілл_, ्जोप_, 
   {{0xe7381fb5,0x00000000,0x00000000,0x00000000}},	//   жел_, --, --, --, 
   {{0x2d881fb6,0x66e41fb7,0xbdf81fb8,0x0ebc0709}},	//   llae_, фока, _بریا_, ्रिड, 
   {{0x2d880393,0x00000000,0x00000000,0x00000000}},	//   olae_, --, --, --, 
   {{0xe3b81fb9,0x92bc0154,0xe57801a9,0x64a4004e}},	//   оби_, েলো_, ўзи_, майа, 
   {{0x2d881fba,0x79240354,0x00000000,0x00000000}},	//   ilae_, _яьрж, --, --, 
   {{0xf8681fbb,0x9f400270,0xaadc1fbc,0xba080092}},	//   _عملي_, tukí_, मणिक, _ወባ_, 
   {{0x77900b29,0x8c1000eb,0x00000000,0x00000000}},	//   _حیوا, সমিন_, --, --, 
   {{0x61441fbd,0xb5c80066,0x00000000,0x00000000}},	//   фема, _روهم_, --, --, 
   {{0x34941fbe,0x942400d1,0xd36c00f1,0x00000000}},	//   _зацр, _يومۇ, اهۍ_, --, 
   {{0x51940020,0x626405c5,0xdb040784,0x2d88199b}},	//   መለከተ_, _овла, _pukí, elae_, 
   {{0x8fa01fbf,0x00000000,0x00000000,0x00000000}},	//   таре, --, --, --, 
   {{0xa06800db,0x00000000,0x00000000,0x00000000}},	//   _майа_, --, --, --, 
   {{0xdc6801c6,0xd00c02dd,0x25a00419,0x00000000}},	// [1a80] цаад_, _ەلۋ_, íhly_, --, 
   {{0x2d881fc0,0x39a80166,0xa3e400ab,0xe84000bc}},	//   alae_, _aşsa_, _फिन_, ůběž, 
   {{0x5de41fc1,0xd378010f,0x9f041bf4,0x9f2000d1}},	//   _южна, קרעט, _فوکو, _كۈڭۈ, 
   {{0x9cb41fc2,0x2d88003a,0x58841fc3,0xa3ac1fc4}},	//   _زمست, clae_, мыла, कदा_, 
   {{0x6c7401c6,0xbe640023,0x00000000,0x00000000}},	//   _зурх, _ፍልጠታ, --, --, 
   {{0xd5b81fc5,0x9f4000d7,0x00000000,0x00000000}},	//   оси_, ytký_, --, --, 
   {{0xfbb00f22,0x00000000,0x00000000,0x00000000}},	//   _ছবিত, --, --, --, 
   {{0xb4e81d8a,0x5edc00cd,0x00000000,0x00000000}},	//   बले_, कृत्_, --, --, 
   {{0x12e41cb8,0x00000000,0x00000000,0x00000000}},	//   мінг, --, --, --, 
   {{0x46e4010b,0x92bc009e,0x8838011a,0x662800e5}},	//   _одун_, েল্_, _ותמו, éskö, 
   {{0x3b181fc6,0x85741fc7,0xdb04002e,0x2d88003a}},	//   _marq_, ясәт_, _mukà, ylae_, 
   {{0x3b180784,0x78a40306,0x00000000,0x00000000}},	//   _larq_, živu, --, --, 
   {{0x59cc0574,0x104802bf,0x2d88017a,0x4fc401c4}},	//   हीतर, іями_, vlae_, ьсна, 
   {{0x2bb413b4,0x733407d2,0x63bc0419,0x40340114}},	//   _अंबा, _سىبا, ísne, њерс, 
   {{0x2d881fc8,0x26d8016b,0x00000000,0x00000000}},	//   tlae_, _ɛso_, --, --, 
   {{0xa3e4069f,0x66040784,0x00000000,0x00000000}},	//   बूक_, çhki, --, --, 
   {{0x3b1801a9,0x2d880af9,0x25e400bc,0x00000000}},	// [1a90] _barq_, rlae_, _टिभी_, --, 
   {{0x2d8805e4,0x09a407b7,0x00000000,0x00000000}},	//   slae_, गद्य, --, --, 
   {{0x2d881fc9,0x00000000,0x00000000,0x00000000}},	//   plae_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3b18036b,0xf21005f9,0x00000000,0x00000000}},	//   _farq_, ़बड़_, --, --, 
   {{0x06cc00eb,0xe7940066,0x64a40124,0x00000000}},	//   _রাহি, راشک, ҭака, --, 
   {{0x2bb401ad,0x8d90001f,0x69c00135,0x855400e5}},	//   _अंडा, _ሁኔታው_, _ħlew, ویئر_, 
   {{0xad44001f,0x09c8000d,0x00000000,0x00000000}},	//   _የወጣቶ, ाठीय, --, --, 
   {{0xa7740006,0x7d0001e3,0x3b18022e,0xe3b0007b}},	//   _злач, _ömse, _yarq_, درب_, 
   {{0x46800e46,0x4e0c1fca,0x7c2001a6,0xdb041aa9}},	//   _иқла, ाबाई_, _šmrk, _kuká, 
   {{0xdb040022,0xe5e41fcb,0x36d401f0,0x00000000}},	//   _juká, _سزای, _рохр, --, 
   {{0x261001a6,0x00000000,0x00000000,0x00000000}},	//   _išo_, --, --, --, 
   {{0xdb0403f7,0xd24c1fcc,0x80a80154,0x00000000}},	//   _luká, لنی_, কুন্, --, 
   {{0x3eac1fcd,0xdb0400c7,0x38600332,0x00000000}},	//   ødt_, _ouká, úiri_, --, 
   {{0x236404f3,0x3eb8004e,0x00000000,0x00000000}},	//   milj_, rcrt_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x63ac0395,0xa06800ee,0xdd9401ec,0x00000000}},	// [1aa0] _èand, _хапа_, даңы, --, 
   {{0x23640267,0x4c800116,0xdb0401d3,0x00000000}},	//   nilj_, улув, _buká, --, 
   {{0x590806a6,0xd9441fce,0x261000d7,0xdb0401ef}},	//   зеем_, нежи, _nšo_, _cuká, 
   {{0xdb0403da,0x225000d0,0x6a9400d4,0x00000000}},	//   _duká, úzky_, трує, --, 
   {{0xdb040022,0x261000ef,0xb71800f3,0x00000000}},	//   _euká, _ašo_, долф_, --, 
   {{0x7bc41fcf,0xc7a01fd0,0xdb0400d7,0x00000000}},	//   mpiu, гичк, _fuká, --, 
   {{0x06cc015b,0x95c8109a,0x7bc41fd1,0x00000000}},	//   _রাশি, чула_, lpiu, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bc405b1,0xd7c80338,0xf8cc1fd2,0x00000000}},	//   npiu, _رواه_, ारीप, --, 
   {{0xf48407d6,0x85000214,0x00c80150,0x7bc400c0}},	//   _یاشی, پوین, _ﺒﺘﺭﺘ, ipiu, 
   {{0x82d4009d,0x00000000,0x00000000,0x00000000}},	//   эдэс_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x45080003,0xba08001f,0x2bb41098,0x23640cf4}},	//   _ཁྲིར_, _ወጣ_, _अंधा, bilj_, 
   {{0x4ea41fd3,0xbfa81fd4,0x91e000fb,0x00000000}},	//   ерба, етсе_, _йәмһ, --, 
   {{0x8318123b,0x00000000,0x00000000,0x00000000}},	//   _מוגז, --, --, --, 
   {{0xdb040232,0x2bb41fd5,0x6ab81f14,0x00000000}},	//   _ruká, _अंदा, इड्र, --, 
   {{0xcb44009d,0x00000000,0x00000000,0x00000000}},	// [1ab0] нхжи, --, --, --, 
   {{0x62240228,0x8c3401f0,0xbc381fd6,0x00000000}},	//   _سوۋە, _ҷомӣ_, رسقا_, --, 
   {{0x4ea401c0,0xdeb40375,0x6e940022,0xf8cc00dc}},	//   _яриа, _בפתח_, _шиоу, ारूप, 
   {{0xc9840a11,0x3a740022,0x00000000,0x00000000}},	//   رشاي, ылхр, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7e7400a2,0xdaa00137,0xaa5c0408,0x4ba400db}},	//   _çepç, _چەكپ, _дегi, _чөбү_, 
   {{0xf7701fd7,0xc444130e,0x236400f3,0x00000000}},	//   حان_, کیشن_, vilj_, --, 
   {{0x7c2001a6,0x69c41fd8,0xa52400d1,0x00000000}},	//   _šmri, mphe, тмид, --, 
   {{0x23640960,0x00000000,0x00000000,0x00000000}},	//   tilj_, --, --, --, 
   {{0x69c41fd9,0x291c017a,0x00000000,0x00000000}},	//   ophe, ldwa_, --, --, 
   {{0x69c41fda,0xa3e402ab,0xe51400a8,0x04840014}},	//   nphe, बूज_, _афлэ, بٕکی_, 
   {{0xa0681fdb,0x69c40472,0x6f04007b,0x236401a6}},	//   дама_, iphe, _abhc, silj_, 
   {{0x62240131,0xa07402dd,0x69c401ab,0x30741fdc}},	//   رىڭل, тынш, hphe, гурс, 
   {{0x2d980009,0x2244002d,0x5f0400a7,0xe2841fdd}},	//   _ahse_, pylk_, ъзга, _илли, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x60240124,0x7bc40270,0x69c41fde,0x1fb4014b}},	//   _адиа, tpiu, dphe, _исор, 
   {{0x291c0c8a,0x5ba81fdf,0x8c40023a,0x7bc400a3}},	// [1ac0] ddwa_, дкам_, аете, upiu, 
   {{0x7bc41fe0,0x00000000,0x00000000,0x00000000}},	//   rpiu, --, --, --, 
   {{0x7bc41fe1,0x1b0400fe,0x986400e5,0x00000000}},	//   spiu, ৰালে_, ھیئے_, --, 
   {{0xd7e41fe2,0x7bc41fe3,0x09e00640,0x61e4007c}},	//   віко, ppiu, роцн, _åhlu, 
   {{0x69c406a3,0xeb300228,0x00000000,0x00000000}},	//   aphe, _گۉلد, --, --, 
   {{0x69c401d4,0x73c401e0,0x34bc00dc,0x00000000}},	//   bphe, ңәле, ैर्द, --, 
   {{0x69c40e89,0xceb00302,0x00000000,0x00000000}},	//   cphe, סיה_, --, --, 
   {{0x38c81fe4,0xdb040166,0x68d4013d,0xe6c40220}},	//   _ساری_, _bukç, _бюфф, _ەتني, 
   {{0x49140490,0x5dc401ec,0x00000000,0x00000000}},	//   _नसतो_, _ﺩﻨﻴﻴ, --, --, 
   {{0x2bb41fe5,0x00000000,0x00000000,0x00000000}},	//   _अंसा, --, --, --, 
   {{0x0f3c0092,0x00000000,0x00000000,0x00000000}},	//   _ዓለማየ, --, --, --, 
   {{0x27e81fe6,0x98b80024,0x00000000,0x00000000}},	//   šane_, ėpė_, --, --, 
   {{0x69c40165,0xc1741422,0x543406c2,0x00000000}},	//   zphe, рлящ, _جرار, --, 
   {{0x995c00bc,0x130402dd,0xc7b0011a,0x00000000}},	//   _nůž_, _شىعۋ_, יבש_, --, 
   {{0x7e4400f3,0xdcfc00d7,0x814400db,0x291c0210}},	//   ахте, _dupľ, _چنىن, ydwa_, 
   {{0x63ac02e8,0xf8cc1fe7,0x6e241710,0x637c007f}},	//   _èanc, ारोप, _vrhb, dèny, 
   {{0x63ac021c,0x09c80a59,0xcf9800d8,0x00000000}},	// [1ad0] _éant, ाठ्य, _ојо_, --, 
   {{0x69c41fe8,0x3b541fe9,0x9510031c,0x6f040332}},	//   tphe, акур, _ཉིའི_, _ubhc, 
   {{0x66e4036b,0x69c4009a,0x00000000,0x00000000}},	//   ҳола, uphe, --, --, 
   {{0xfce400d8,0x2d9801ef,0x00000000,0x00000000}},	//   _коџо, _uhse_, --, --, 
   {{0xdb040793,0x6d4c1fea,0xd8b40214,0x310400dc}},	//   _bukä, mkaa, اگفا_, ष्यः_, 
   {{0x6d4c0d62,0x77841feb,0x69c41fec,0x27fc0042}},	//   lkaa, аліз, pphe, rtwn_, 
   {{0x7f3c008f,0x27fc0042,0x00000000,0x00000000}},	//   ועגו, stwn_, --, --, 
   {{0x6d4c1fed,0x6b84036b,0x25881e4a,0x00000000}},	//   nkaa, lohg, رچاپ_, --, 
   {{0x386000c6,0x4aa400dc,0x6d4c1fee,0xe3a8059f}},	//   úirt_, _कृतव, ikaa, нкид_, 
   {{0x96c803f3,0x6d4c1fef,0x344400d1,0x6b8401a9}},	//   _स्पॉ, hkaa, рүши_, nohg, 
   {{0xe65800c6,0x21681ff0,0x61441ff1,0x15e8012d}},	//   _ثلاث_, еини_, гена, _टियर_, 
   {{0x6d4c1ff2,0x6b84014f,0x00000000,0x00000000}},	//   jkaa, hohg, --, --, 
   {{0x6d4c0050,0x6568049b,0x69c00109,0xf2f803e6}},	//   dkaa, mieh, _élef, روێژ_, 
   {{0x65681ff3,0x6d4c1ff4,0x34940107,0x00000000}},	//   lieh, ekaa, _тачр, --, 
   {{0xfe781ff5,0x1d08163f,0x6d4c01d9,0xc1040075}},	//   түн_, неви_, fkaa, _күнл, 
   {{0x6d4c1ff6,0x2bb41df0,0x60541063,0x00000000}},	//   gkaa, _अंशा, _منعط, --, 
   {{0x5f741ff7,0x220401d9,0x64481ff8,0x9f4002b5}},	// [1ae0] _مادر, _شِکٲ, nyei, tukä_, 
   {{0x60d4037e,0x64480086,0x6d4c1ff9,0x656803fa}},	//   _heym, iyei, akaa, hieh, 
   {{0x6d4c01d9,0x65681ffa,0x4ef80a7c,0x00000000}},	//   bkaa, kieh, _אליג, --, 
   {{0x39401ffb,0x60d41ffc,0x6d4c0072,0xdbdc01e1}},	//   ðis_, _jeym, ckaa, _tíàg, 
   {{0x7d041ffd,0x60d41ffe,0x656817b8,0x48e01fff}},	//   mfis, _meym, dieh, сочв, 
   {{0x7d042000,0x7c242001,0x60d402d1,0xf7702002}},	//   lfis, mvir, _leym, ڭاچ_, 
   {{0x7d042003,0xbacc0ed1,0x6568002f,0x4ed8010f}},	//   ofis, _ﺗﯘﺗﺎ, fieh, ײַונ, 
   {{0x74142004,0x98a41eed,0x1ae40c60,0x656803ac}},	//   لوبا, _бибе, _шоҳм, gieh, 
   {{0x7c242005,0x1368192a,0xb6c41206,0x7d042006}},	//   nvir, ешни_, _көйд, ifis, 
   {{0xa3e42007,0x7c2404ba,0x932401d5,0xdb0401f4}},	//   _फिर_, ivir, چرگن, _etkö, 
   {{0x60d42008,0x656801f1,0x6d4c0548,0x7d040250}},	//   _beym, bieh, ykaa, kfis, 
   {{0x518403b7,0x656801f1,0x60d42009,0x6d4c0009}},	//   ѓуна, cieh, _ceym, xkaa, 
   {{0x7d04200a,0x60d4200b,0x8f080116,0x50640006}},	//   dfis, _deym, нхва_, утна, 
   {{0x7d04200c,0x7c24200d,0x96c802ab,0x60d400ad}},	//   efis, dvir, _स्मॉ, _eeym, 
   {{0x7d04200e,0x6d4c200f,0x8d742010,0xadd40063}},	//   ffis, tkaa, هارا, робљ, 
   {{0x7d042011,0x60d42012,0x9f400589,0x41c00046}},	//   gfis, _geym, trkã_, _اقيق, 
   {{0x6d4c2013,0x7c24005c,0x417400f1,0x92b40154}},	// [1af0] rkaa, gvir, _داوس, জরী_, 
   {{0x65680639,0x6d4c2014,0x7d042015,0x0ca8013d}},	//   zieh, skaa, afis, _үтми_, 
   {{0x6d4c0cfe,0x7c24005b,0x6a1402dd,0x7d042016}},	//   pkaa, avir, рмеу, bfis, 
   {{0x7c2405b8,0xa3e42017,0x7d04009f,0x97200014}},	//   bvir, _फिल_, cfis, ۪ہلو, 
   {{0x644803ac,0x00000000,0x00000000,0x00000000}},	//   xyei, --, --, --, 
   {{0xb8ec0a28,0x656801c7,0x24b40150,0x65c40064}},	//   _श्_, wieh, _ﹼﻘﺘﻬ, абка, 
   {{0x65682018,0xdde40064,0xe634009d,0x00000000}},	//   tieh, _įpūt, рхлэ, --, 
   {{0x79a403b7,0x63bc0c5e,0x6fb401f9,0x64480108}},	//   _груе, ísno, ंदां, tyei, 
   {{0x656817b8,0x00000000,0x00000000,0x00000000}},	//   rieh, --, --, --, 
   {{0x60d42019,0x6568201a,0x06cc0154,0xd0b006be}},	//   _seym, sieh, _রাকি, mşək, 
   {{0x60d4201b,0x7c240e8a,0x7d04201c,0x65680196}},	//   _peym, zvir, yfis, pieh, 
   {{0xa0a4201d,0x7c24022c,0x602401c0,0x60d4047e}},	//   ианд, yvir, адма, _qeym, 
   {{0x7c24003e,0x60d4022e,0x974c0241,0x00000000}},	//   xvir, _veym, _ọ̀rọ_, --, 
   {{0x60d4201e,0x7d04201f,0x7c242020,0xddc401a9}},	//   _weym, wfis, vvir, ибги, 
   {{0x60d42021,0xfcdc0092,0x399c01e7,0x00000000}},	//   _teym, _ሕንጻ_, líse_, --, 
   {{0x7c240953,0x81c8009e,0x00000000,0x00000000}},	//   tvir, _লিপ_, --, --, 
   {{0xdee417fb,0x7d042022,0x7c24004c,0x00000000}},	// [1b00] _копи, rfis, uvir, --, 
   {{0x9e6405b0,0xd00c1de5,0xe190001f,0x00000000}},	//   _ввод, _کلی_, _ማህበሩ_, --, 
   {{0x399c0597,0x200000c5,0x7d042023,0x7d0001e3}},	//   híse_, ltki_, pfis, _ömso, 
   {{0x7c242024,0x06cc0154,0x8d7400f1,0xd8240139}},	//   pvir, _রাগি, _ناټا, идеи, 
   {{0x20002025,0x7794190f,0x2b9001b9,0x3de800cc}},	//   ntki_, میرا, _کیلس, _পহিল, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb0c02d3,0xcb6400a8,0x09e010fc,0x212000b5}},	//   _libë, _таре_, _морн, kdkh_, 
   {{0x27e82026,0x399c00c6,0x00000000,0x00000000}},	//   šana_, físe_, --, --, 
   {{0x362401d3,0x8cd40037,0x2000012d,0x9344007b}},	//   _گواہ, बरतो, jtki_, لخدم, 
   {{0x39442027,0x7338016c,0xb3542028,0x534400c7}},	//   _homs_, узор_, скош, рхиа, 
   {{0x39442029,0xe6b401d5,0x8ab4010f,0x2000202a}},	//   _koms_, _المگ, יליג_, etki_, 
   {{0x3f5402b5,0x39440024,0xdb0c0240,0x20000010}},	//   _räua_, _joms_, _bibë, ftki_, 
   {{0x7afc05a1,0x3944202b,0x399c01e7,0xd414072d}},	//   _ocrt, _moms_, císe_, _خباث, 
   {{0x3944202c,0x27f80217,0xb8d8031c,0xdb0c0240}},	//   _loms_, _åsne_, _ཛུ_, _dibë, 
   {{0xaa040316,0x39440b4f,0x2000012d,0x00000000}},	//   _रहेछ_, _ooms_, atki_, --, 
   {{0x3944202d,0xac1800f7,0xa3cc202e,0xdb0c0200}},	//   _noms_, лобу_, षीक_, _fibë, 
   {{0xdb0c007f,0x3168009d,0x299800d1,0x00000000}},	// [1b10] _kibè, _imaz_, ﯘﺭﭼﻪ_, --, 
   {{0x2ef4202f,0x7afc00db,0x0ac4010b,0x00000000}},	//   _узор, _ccrt, рщам, --, 
   {{0x39440793,0x6f140407,0x49a40e92,0x00000000}},	//   _boms_, mezc, ајда, --, 
   {{0xdb0c2030,0x39442031,0x6f142032,0xe85802e8}},	//   _libè, _coms_, lezc, лаеш_, 
   {{0xdbd4010e,0xec34010f,0x00000000,0x00000000}},	//   _käýe, _האָר_, --, --, 
   {{0xd7ec2033,0x6f142034,0x2d88054e,0x8704011c}},	//   ركى_, nezc, loae_, ряде, 
   {{0x31682035,0x3944014a,0xaa5819ba,0x00000000}},	//   _omaz_, _foms_, _сиву_, --, 
   {{0x39442036,0x2000033f,0x2d88003a,0x26c80115}},	//   _goms_, ytki_, noae_, ŝao_, 
   {{0xa8242037,0xe2b401c6,0xf9640345,0xa85401f4}},	//   _دکان, йснэ, _بۆنێ, _укач, 
   {{0xda0c0c4c,0xb9e002d3,0x36d42038,0xdb0c036e}},	//   _सहमत_, _እብ_, _моур, _ribë, 
   {{0xe69403dd,0x6f140154,0xdb0c020c,0xdb040124}},	//   _الاد, dezc, _dibè, _pukú, 
   {{0x67202039,0xa5340276,0x2258033f,0x2600002e}},	//   _halj, _ынеч, ąsk_, móo_, 
   {{0x6720203a,0x24f80022,0x260017bb,0xa878010f}},	//   _kalj, _анҵы_, lóo_, ראָר, 
   {{0x2000203b,0x67200bc9,0x9e640131,0x00000000}},	//   rtki_, _jalj, مازن, --, 
   {{0x6720203c,0x3eac203d,0x2000203e,0xaea800c6}},	//   _malj, ädt_, stki_, لطفل_, 
   {{0x7afc05be,0x5f74203f,0x00000000,0x00000000}},	//   _scrt, _گابر, --, --, 
   {{0x67200b21,0x39442040,0x02d8000d,0x00000000}},	// [1b20] _oalj, _roms_, _मजाभ, --, 
   {{0x39442041,0x67202042,0x5f741056,0x26001bce}},	//   _soms_, _nalj, _دابر, kóo_, 
   {{0x2600172e,0x394404cc,0x4f200139,0x61e0036e}},	//   jóo_, _poms_, _эдэб, nsll, 
   {{0xdb0c043b,0x98d82043,0xe1900092,0xdcfc0166}},	//   _mibé, اباز_, _ማኅበሩ_, _tupı, 
   {{0x67201368,0xdb0c2044,0x39442045,0x06cc015b}},	//   _balj, _libé, _voms_, _রাজি, 
   {{0x7afc07f5,0x78180037,0x00000000,0x00000000}},	//   _ucrt, _धनीक_, --, --, 
   {{0x39442046,0xdb0c0ba1,0x260000e8,0x61e002d0}},	//   _toms_, _ribè, góo_, jsll, 
   {{0x6720002d,0xdb0c00db,0x00000000,0x00000000}},	//   _ealj, _sibè, --, --, 
   {{0x672002d3,0x38600e89,0xded40092,0x00000000}},	//   _falj, ùird_, ራሩን_, --, 
   {{0x69c02047,0x8c180302,0x67202048,0x26000077}},	//   _élec, נויי, _galj, bóo_, 
   {{0x71782049,0xc1b401c6,0x01c401d3,0x00000000}},	//   ибор_, йлэх_, یویٹ_, --, 
   {{0xdb0c204a,0xd138204b,0x1b0400fe,0x00000000}},	//   _dibé, ухо_, ৰাটে_, --, 
   {{0xc058204c,0x6f140407,0xdb0c204d,0x63b800a2}},	//   бір_, tezc, _tibè, _guwn, 
   {{0x80dc0729,0xc0580845,0x3f640138,0x00000000}},	//   _ভাণ্, сію_, птсб, --, 
   {{0x65b40f8b,0x6f14204e,0xdb0c204f,0x00000000}},	//   _tšhe, rezc, _gibé, --, 
   {{0x63b80054,0x1aa80183,0x0c84013d,0x5dac0ef6}},	//   _yuwn, খুৱা, бызм, _ﺳﺎﻧﺴ, 
   {{0xdb0c020c,0x88d4015b,0x68fc00a2,0x00000000}},	// [1b30] _zibé, _হালক, _ösdi, --, 
   {{0x8aa406ed,0x2d54003b,0x00000000,0x00000000}},	//   бред, _gåen_, --, --, 
   {{0xdb242050,0x2bb40490,0x9ed80032,0x26000077}},	//   تولی, _अंका, _өмөт_, xóo_, 
   {{0xe8542051,0x01f8010f,0xe6d02052,0x00000000}},	//   يناد, רפאל, हर्ज, --, 
   {{0x67202053,0x26002054,0x29d40216,0x1b0400fe}},	//   _palj, wóo_, sťa_, ৰাজে_, 
   {{0x27e82055,0x2fc8089c,0x78a400e4,0x00000000}},	//   šano_, _mtag_, ýiva, --, 
   {{0x39a80139,0x63b80210,0x00000000,0x00000000}},	//   _aşsu_, _suwn, --, --, 
   {{0x6720094a,0xdb0c2056,0x2fc82057,0xd1dc0023}},	//   _walj, _ribé, _otag_, ዓወተ_, 
   {{0x67202058,0xdb0c2059,0x2fc80070,0x25e405f9}},	//   _talj, _sibé, _ntag_, _टिकी_, 
   {{0x97000075,0x399c00d2,0x442001e4,0x51f400ec}},	//   _يېنى, mísa_, ĉj_, ڊسٽر, 
   {{0xe298205a,0x4424205b,0x2fc801f5,0x00000000}},	//   ран_, _گراف, _atag_, --, 
   {{0x2d5401bf,0x00000000,0x00000000,0x00000000}},	//   _såen_, --, --, --, 
   {{0xa2e4205c,0x2bb4205d,0xdef80184,0x399c00d2}},	//   _долд, _अंगा, һың_, nísa_, 
   {{0xdb0c205e,0x20e8004d,0x3d0c012c,0x61e0036e}},	//   _tibé, ời_, ड्ने_, psll, 
   {{0xdef8205f,0x61442060,0x2fc80048,0x290c013f}},	//   лың_, _мека, _etag_, _obea_, 
   {{0x2fc8030d,0x68e82061,0x00000000,0x00000000}},	//   _ftag_, _nded, --, --, 
   {{0x2d54072b,0xdb5001f7,0xccb00139,0x80a800eb}},	// [1b40] _tåen_, وَر_, дәрь, _ক্র্, 
   {{0x68e82062,0x3f540036,0x290c054e,0x4c640276}},	//   _aded, _käum_, _abea_, циун_, 
   {{0x1d082063,0x9d442064,0x19f80276,0x2fc8022e}},	//   _кени_, _денд, рэзь_, _ztag_, 
   {{0x98480032,0x290c0076,0x19880022,0x00000000}},	//   ияла_, _cbea_, шбеи_, --, 
   {{0x68e82065,0x3ce00218,0x57a42066,0xbd880451}},	//   _dded, maiv_, ошка, _ننڍن_, 
   {{0x68e82067,0xc950035b,0x3ce001e7,0x00000000}},	//   _eded, зтәы, laiv_, --, 
   {{0xda0c2068,0x3178012d,0xe7b000db,0x8a00009b}},	//   _सहित_, ynsz_, رۅمد, _озре, 
   {{0x3ce0007f,0x73d801b9,0xc5a401c8,0xd9540244}},	//   naiv_, бдир_, يُون_, _بنرخ, 
   {{0x8d58008f,0xd3782069,0x00000000,0x00000000}},	//   יכקי, ичо_, --, --, 
   {{0x3ce001d4,0x68e80419,0x27f8007c,0x00000000}},	//   haiv_, _zded, _åsna_, --, 
   {{0x2fc8206a,0x20100100,0x68e801bf,0x00000000}},	//   _stag_, _apyi_, _yded, --, 
   {{0xdbd00e2d,0xca480150,0x00000000,0x00000000}},	//   _küät, _ﻁﻠﺏ_, --, --, 
   {{0xad2406ba,0x06cc0183,0xb37c0092,0x00000000}},	//   ۋىسى, _ৰাতি, ኖረውን_, --, 
   {{0xdb0c025a,0x8de81b15,0x0cd0206b,0xdc780092}},	//   _sibî, ифба_, तर्म, _ተመራጭ_, 
   {{0x2010007f,0x25fc070f,0x7f940107,0x4ea401a9}},	//   _epyi_, रूपी_, фарх, юрма, 
   {{0x2fc8206c,0x8d7401ed,0x3da4206d,0xe8d80037}},	//   _ttag_, زازا, друб, _ढ़ेच, 
   {{0x0ca8206e,0x2fc8003e,0x00000000,0x00000000}},	// [1b50] ртви_, _utag_, --, --, 
   {{0x399c066a,0x88d4015b,0x68e80042,0x63bc0162}},	//   vísa_, _হাইক, _sded, ísni, 
   {{0xdb0c01d3,0x68e80200,0x00000000,0x00000000}},	//   óján, _pded, --, --, 
   {{0x26c40204,0x7ec001e1,0x00000000,0x00000000}},	//   _sflo_, _tàpó, --, --, 
   {{0xdd380375,0x5d380375,0x25fc07af,0x00000000}},	//   _הערכ, _התרא, रूनी_, --, 
   {{0x94f40327,0x399c03b2,0xf748009a,0x00000000}},	//   བུའི_, rísa_, يلني_, --, 
   {{0x3b6401d9,0xe618013e,0x0cbc00eb,0x00000000}},	//   _تێلہ, ёди_, েণীত, --, 
   {{0xded4206f,0x3f540036,0xd90c01d9,0x68e82070}},	//   _ኪዳን_, _räum_, _میٔ_, _uded, 
   {{0x2cb800b5,0xdb0400a2,0xb50800f7,0x9fe400eb}},	//   _mgsd_, _luký, تۉنۅ_, _পঙ্গ, 
   {{0x26c4014b,0xe694035b,0x36d400f3,0x00000000}},	//   _uflo_, _еизы, _жофр, --, 
   {{0x232800c2,0x46680a5b,0xff8400a2,0xf0880115}},	//   _ҳоли_, _трам_, _üçiň_, _ענ_, 
   {{0xe2982071,0x9f400316,0xd24c06f6,0xdb14007f}},	//   _қай_, mské_, انَ_, npyò, 
   {{0x9f40031d,0x23281159,0xa3e40d2e,0x3ce004cc}},	//   lské_, _голи_, _फिट_, vaiv_, 
   {{0x442c0f89,0x80cc2072,0x443c0003,0x00000000}},	//   _irg_, _थ्रे, mxu_, --, 
   {{0x9f400300,0x2bb41533,0x442c0263,0xd24c2073}},	//   nské_, _अंजा, _hrg_, _منو_, 
   {{0x442c06df,0xa6c00154,0xe0d802e8,0xbac003d4}},	//   _krg_, উরিট, _уви_, ইৰাছ, 
   {{0x52dc000e,0x27e82074,0x00000000,0x00000000}},	// [1b60] _মাতৃ, šanj_, --, --, 
   {{0x8b202075,0x797c007f,0x3ce00332,0x3db002dd}},	//   ндуе, tčwo, saiv_, _ﺳﯟﯨﻘ, 
   {{0x9f400122,0x00000000,0x00000000,0x00000000}},	//   jské_, --, --, --, 
   {{0x442c2076,0x9f4002fd,0x18a42077,0x78a40022}},	//   _org_, dské_, паем, ýivo, 
   {{0x69c00085,0x98a42078,0xdbd0013d,0x443c0327}},	//   _élen, чиде, _qüät, jxu_, 
   {{0x2b14030d,0xdb0c00e5,0x00000000,0x00000000}},	//   _оьср, _kibí, --, --, 
   {{0x442c2079,0xded41e38,0x443c1bce,0x8b000118}},	//   _arg_, _ኪዳነ_, exu_, ářec, 
   {{0x442c207a,0xceb006a9,0xd76401d3,0x00000000}},	//   _brg_, עיה_, _کارٹ, --, 
   {{0x442c01c7,0x443c207b,0xd1d00092,0xe7b00137}},	//   _crg_, gxu_, ያዙት_, رۅۅد, 
   {{0x442c207c,0x3254207d,0x9f400216,0x99880118}},	//   _drg_, двор, bské_, _krbů_, 
   {{0x442c207e,0x443c00e8,0x5ee000cc,0x00000000}},	//   _erg_, axu_, বলাই, --, 
   {{0x65b4207f,0x443c030d,0x463800c8,0x442c0115}},	//   _tšha, bxu_, _לעבע, _frg_, 
   {{0xc0582080,0xdb0c007b,0x4fc42081,0x94200131}},	//   пір_, _aibí, ясна, _سوغۇ, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x80dc00bd,0x2cb8020b,0x00000000,0x00000000}},	//   _ভার্, _pgsd_, --, --, 
   {{0xebd800a7,0x00000000,0x00000000,0x00000000}},	//   ждаш_, --, --, --, 
   {{0x7bc0004a,0xdb0401e1,0x9f40022a,0x0ba818fd}},	// [1b70] _émul, _nukó, zské_, مائى_, 
   {{0x8aa42082,0xdcec0882,0x7ac42083,0x14f800eb}},	//   пред, ākār, есце, ্যয়ী_, 
   {{0x70542084,0xaa182085,0xd8c801f2,0x25a800d0}},	//   _رنگا, تياط_, _ịpịr, ňali_, 
   {{0x9f400232,0xdb042086,0xf99000ec,0x443c0175}},	//   vské_, _zukü, هبن_, yxu_, 
   {{0x443c2087,0x7c84014b,0x00000000,0x00000000}},	//   xxu_, _зуре, --, --, 
   {{0x9f4003c6,0xaae00927,0x49b82088,0x00000000}},	//   tské_, _फ़िक, _هارد_, --, 
   {{0x442c1570,0x60c40267,0xe6180212,0x88b401af}},	//   _srg_, yckm, іди_, _еҫер_, 
   {{0x442c2089,0x9f400e96,0x443c05f5,0x36180212}},	//   _prg_, rské_, txu_, яцію_, 
   {{0xdb1000e4,0x6d5c01ef,0x80dc00eb,0x00000000}},	//   _ágãr, _mlsa, _ভাল্, --, 
   {{0xa1c4163b,0x04fc00bd,0x9f40012c,0x443c208a}},	//   мбод, ্যের_, pské_, rxu_, 
   {{0x6d5c208b,0xd76401d5,0xf99001d3,0x00000000}},	//   _olsa, _تنلی, _شبہ_, --, 
   {{0x442c0f03,0xdb040005,0xdb0c01e7,0x00000000}},	//   _trg_, _yukó, _ribí, --, 
   {{0x442c208c,0x443c208d,0xdb0c0419,0x00000000}},	//   _urg_, qxu_, _sibí, --, 
   {{0x6d5c208e,0xd24c04d3,0x671c0210,0x00000000}},	//   _alsa, انێ_, फ़िक_, --, 
   {{0xf1a8208f,0x00000000,0x00000000,0x00000000}},	//   تایه_, --, --, --, 
   {{0x2d942090,0xb3800023,0x00000000,0x00000000}},	//   ерус, _ዕብዳን_, --, --, 
   {{0x71242091,0x9f500ad9,0x1b48013e,0x00000000}},	// [1b80] _سريل, ðbót_, озаи_, --, 
   {{0x6d5c2092,0xda6400c6,0x00000000,0x00000000}},	//   _elsa, واضي, --, --, 
   {{0x69c001ed,0x09e001d5,0xd94400d4,0x00000000}},	//   _élel, вохн, межи, --, 
   {{0xed0401ec,0x00000000,0x00000000,0x00000000}},	//   _كوپپ, --, --, --, 
   {{0x1b200022,0x48e000a7,0xca680150,0x00000000}},	//   _иҟаҳ, точв, дiгi, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x16dc01ad,0x00000000,0x00000000,0x00000000}},	//   _नजीब, --, --, --, 
   {{0x98a40228,0x73d80209,0x77a40ba1,0xddcc00e5}},	//   _жибе, пдир_, dòxe, nzbő, 
   {{0x15e81098,0xd824084c,0x46cc043e,0x00000000}},	//   _टिकर_, _юдаи, _स्वह, --, 
   {{0xc87c2093,0x00000000,0x00000000,0x00000000}},	//   üşen_, --, --, --, 
   {{0x5504022e,0x00000000,0x00000000,0x00000000}},	//   _жчла, --, --, --, 
   {{0xdb0c05da,0x00000000,0x00000000,0x00000000}},	//   _libà, --, --, --, 
   {{0x85002094,0x93442095,0x81c80154,0x00000000}},	//   _شوون, _онде, _লিঃ_, --, 
   {{0xb8e00489,0x4508025c,0xb8d0031c,0xcdd82096}},	//   _གཔ_, _གཡོར_, _ནཻ_, жња_, 
   {{0x42f8123b,0x00000000,0x00000000,0x00000000}},	//   _והוס, --, --, --, 
   {{0xd24c0014,0xcfb401ec,0x00000000,0x00000000}},	//   _منڈ_, _ﺼﺎﺩﻗ, --, --, 
   {{0xada400d1,0x3d9401f4,0x00000000,0x00000000}},	// [1b90] даңл, титр, --, --, 
   {{0x6a740174,0xca4401ec,0x00000000,0x00000000}},	//   _nýfø, _ﺘﻀﺭ_, --, --, 
   {{0x6f040055,0x386001c3,0x6d5c03e0,0x65a400e5}},	//   _ichc, ùirn_, _tlsa, lóhe, 
   {{0x69c006fd,0xfaa42097,0x6e24036b,0x4508025c}},	//   _élem, тшун, _ishb, _གཡེར_, 
   {{0xe7382098,0xbef82099,0x7cd8010b,0x2ee0209a}},	//   зел_, _عریض_, _юмяр_, _kehf_, 
   {{0x61340724,0x6604209b,0xd8200b7e,0x84780023}},	//   _külä, епка, удши, _ይስማዕ_, 
   {{0xe6101da4,0x09040588,0x556000d1,0x00000000}},	//   اشت_, _очам, گۇنك, --, 
   {{0x69c4209c,0x65a400e5,0x23d41771,0x39a401a9}},	//   mqhe, kóhe, нцор, _ашув, 
   {{0x291c209d,0x96c803f3,0xdb0c00dd,0x67d400ee}},	//   mewa_, _स्कॉ, _hibá, _чозу, 
   {{0x291c209e,0x65b41ebd,0xb714005b,0x00000000}},	//   lewa_, _tšho, _идущ, --, 
   {{0x69c4209f,0xb1d80108,0xf1b80327,0x00000000}},	//   nqhe, мьях_, wwġa_, --, 
   {{0x291c20a0,0x6f0401b9,0x00000000,0x00000000}},	//   newa_, _achc, --, --, 
   {{0x25ac20a1,0xdb0c043b,0x6e2420a2,0x00000000}},	//   mmel_, _libá, _ashb, --, 
   {{0x291c20a3,0x61340598,0x25ac20a4,0x2328013e}},	//   hewa_, _bülä, lmel_, _хоки_, 
   {{0x291c20a5,0x61340139,0x8fa00276,0x00000000}},	//   kewa_, _cülä, уаре, --, 
   {{0x291c20a6,0x6f0402d0,0x69c40175,0xdb14005b}},	//   jewa_, _echc, dqhe, npyö, 
   {{0x291c20a7,0xd00c14a0,0xf1a803e6,0x6e2401a9}},	// [1ba0] dewa_, _هلي_, _تاوه_, _eshb, 
   {{0xe62407ae,0x25ac0327,0x31c40166,0xddcc00e5}},	//   _đông_, hmel_, _ясәв, szbő, 
   {{0x291c20a8,0x9f400030,0x613420a9,0x2d840165}},	//   fewa_, nskí_, _gülä, élec_, 
   {{0x291c20aa,0x399c20ab,0x00000000,0x00000000}},	//   gewa_, mísk_, --, --, 
   {{0x7bc420ac,0x31040882,0x779420ad,0xb9080073}},	//   qqiu, ष्टः_, نیرا, _मज_, 
   {{0x4508025c,0xdb140108,0x25ac0135,0x61340139}},	//   _གཡུར_, epyö, emel_, _yülä, 
   {{0x291c20ae,0x888001ec,0xd7040166,0x65a400e5}},	//   bewa_, _ұлтж, _үзби, zóhe, 
   {{0x07a00831,0x291c20af,0x058020b0,0x25ac005c}},	//   _ҡатн, cewa_, луым, gmel_, 
   {{0x17840022,0x00000000,0x00000000,0x00000000}},	//   _згам, --, --, --, 
   {{0x25ac08cd,0xd6280261,0x62f00022,0xb35400f5}},	//   amel_, _нозе_, аҧшт, ткош, 
   {{0x941c00ac,0x74140214,0xcb10011a,0x00000000}},	//   _ərəb_, روگا, אלת_, --, 
   {{0x25d81060,0x02a020b1,0x6f0404cc,0xff2004ce}},	//   _آهنگ_, ырым, _schc, _rayと, 
   {{0x6e240022,0x4084010b,0x613420b2,0x00000000}},	//   _sshb, гурб, _sülä, --, 
   {{0x291c20b3,0x9f4000d7,0x399c032e,0x00000000}},	//   zewa_, bskí_, físk_, --, 
   {{0xbe8820b4,0x291c20b5,0xdb0c005c,0x61340139}},	//   есте_, yewa_, _kibæ, _qülä, 
   {{0x429800d9,0xb03407a5,0x00000000,0x00000000}},	//   _מסוב, _аниш, --, --, 
   {{0x291c004c,0xfbd0009a,0x320c0432,0x00000000}},	// [1bb0] vewa_, متل_, ltdy_, --, 
   {{0x6e2401ee,0x63ac011c,0x61340724,0x291c20b6}},	//   _tshb, _èant, _tülä, wewa_, 
   {{0x291c20b7,0x6e24006c,0x7af8022c,0x25ac0109}},	//   tewa_, _ushb, óvta, ymel_, 
   {{0xa6dc00cc,0x00000000,0x00000000,0x00000000}},	//   _ঠাইট, --, --, --, 
   {{0x291c20b8,0xe72805f5,0xc770004e,0xaee40055}},	//   rewa_, долд_, лткө, ceṣy, 
   {{0x291c20b9,0x36e80a52,0x9ba00075,0x00000000}},	//   sewa_, ىرىپ_, _نەقى, --, 
   {{0x291c20ba,0x966018d9,0x25ac20bb,0x048c01e1}},	//   pewa_, икше, tmel_, _àjẹs, 
   {{0xd5ac20bc,0x847401e1,0x3f5401c7,0x9f4000d0}},	//   يفو_, _aáwẹ, _häut_, vskí_, 
   {{0x25ac20bd,0x9f400c67,0xac9401f3,0xc1b40588}},	//   rmel_, nskã_, _ሙስሊም_, қәкы, 
   {{0xdd0000f3,0x25ac072b,0xdb14005b,0x9f4000d0}},	//   _čučk, smel_, spyö, tskí_, 
   {{0x36d409fe,0x96c803f3,0x2ba8000d,0x320c00a2}},	//   _сохр, _स्टॉ, _कठना, gtdy_, 
   {{0x27e811f9,0x27ec0183,0x399c20be,0x9f4000d0}},	//   šanu_, _kven_, vísk_, rskí_, 
   {{0xd24c20bf,0x9f400004,0x84740248,0x25fc033f}},	//   منی_, jskã_, _fáwẹ, रूरी_, 
   {{0x7bc006ed,0x399c20c0,0x00000000,0x00000000}},	//   _émui, tísk_, --, --, 
   {{0xdd9020c1,0x81c8009e,0xc1e00150,0xc10401e0}},	//   لوس_, _লিক_, _حۋجي, _йүнл, 
   {{0x20540025,0x399c20c0,0x1cb4031c,0x160003ce}},	//   _атор, rísk_, _ཝུད_, रंतर_, 
   {{0xa068011c,0x9c2420c2,0x00000000,0x00000000}},	// [1bc0] _цапа_, ъдад, --, --, 
   {{0xddc40022,0xfe7801c6,0xc1b400c7,0x386001ab}},	//   _ибои, _зүг_, _шәҿы, ùirm_, 
   {{0x27ec20c3,0x6bd404da,0x5908005b,0x00000000}},	//   _aven_, نتەر, деем_, --, 
   {{0x77a40ba1,0x795402f2,0x00000000,0x00000000}},	//   dòxa, دێرا, --, --, 
   {{0x1e1c1ee0,0x27ec03cd,0x81ac0154,0x4c8002e8}},	//   _ስልጠና, _cven_, কআপ_, _вляв, 
   {{0x7d0420c4,0x7c2420c5,0xb6c800e5,0x00000000}},	//   lgis, mwir, راتے_, --, 
   {{0x27ec20c6,0x3f5401c7,0x7c2420c7,0x160002a0}},	//   _even_, _häus_, lwir, रंधर_, 
   {{0x699420c8,0x00000000,0x00000000,0x00000000}},	//   _брух, --, --, --, 
   {{0x7c2420c9,0x7d0420ca,0x27ec0e04,0x81c80154}},	//   nwir, igis, _gven_, _লিগ_, 
   {{0x1cb40135,0xe8f8016c,0x7c240810,0x3f540036}},	//   _ཝུན_, _олӣ_, iwir, _mäus_, 
   {{0x7c2420cb,0x7d0400fb,0x27ec0010,0x27e820cc}},	//   hwir, kgis, _zven_, šant_, 
   {{0x7c2420cd,0x09d402a6,0x4270130f,0x00000000}},	//   kwir, _হিমা, ргюс, --, 
   {{0x27ec067c,0x752001f7,0x7c2420ce,0x320c0466}},	//   _xven_, memz, jwir, stdy_, 
   {{0x69c00395,0x7c2420cf,0x9f400c67,0xc32c0050}},	//   _èleg, dwir, vskã_, _وٕن_, 
   {{0x313420d0,0x7dc401b9,0x7c24002f,0x00000000}},	//   _бейр, иётд, ewir, --, 
   {{0x2d54037e,0x7c24002f,0x00000000,0x00000000}},	//   _nået_, fwir, --, --, 
   {{0x7c241813,0x7c9400c6,0x3cf801ad,0xaf600092}},	// [1bd0] gwir, لشكا, एलजे_, _ማገልገ, 
   {{0x9f400004,0x7658023a,0x317820d1,0xf3f403d4}},	//   rskã_, kyvy, lisz_, _অহাৰ_, 
   {{0x7c24090c,0x6f0000a3,0xe8f8013d,0x00000000}},	//   awir, òlcu, енеч_, --, 
   {{0x7c240537,0x13c80183,0x9f4002fd,0x31781f6f}},	//   bwir, লীয়, mská_, nisz_, 
   {{0x9f4004bf,0x78240a2c,0xcbb40220,0x65a420d2}},	//   lská_, لعول, _ағаш_, jóha, 
   {{0xbdf820d3,0xdb0c0724,0xdb040793,0x00000000}},	//   _ثریا_, _cibä, _sukö, --, 
   {{0x9f4003c6,0x2d54019b,0xdb0c0793,0x00000000}},	//   nská_, _fået_, _dibä, --, 
   {{0x2d54019b,0xa52412d7,0x27ec003b,0x8a74014b}},	//   _gået_, умид, _tven_, _зиҳӣ_, 
   {{0x27ec009a,0xe70420d4,0xe3b820d5,0x95b4035b}},	//   _uven_, _مسای, нби_, ыршә, 
   {{0x611820d6,0x399c09f3,0x7d040790,0xdb0c0139}},	//   _mālō, vísi_, zgis, _gibä, 
   {{0x9f400313,0x2d980ac8,0x7520014b,0x7c240099}},	//   jská_, _okse_, bemz, zwir, 
   {{0x9f400122,0xf53000c6,0x7c240042,0x00000000}},	//   dská_, _وإن_, ywir, --, 
   {{0x7d0420d7,0x645c03cd,0xa07401ec,0x00000000}},	//   vgis, øsid, уынш, --, 
   {{0x2d982005,0x57d00ed1,0x7c240bd7,0x3f5401c7}},	//   _akse_, ﻟﺪﯨﺮ, vwir, _räus_, 
   {{0x31780034,0x7d0420d8,0x00000000,0x00000000}},	//   bisz_, tgis, --, --, 
   {{0x7c2420d9,0x3178033f,0x1278010f,0x7d0420da}},	//   twir, cisz_, _ראקע, ugis, 
   {{0x8c4020db,0x5ba820dc,0x2120003e,0x81c8009e}},	// [1be0] бете, екам_, mekh_, _লিট_, 
   {{0x200020dd,0x7c2420de,0x2d9805ac,0x9f400216}},	//   muki_, rwir, _ekse_, bská_, 
   {{0x7c2420df,0x200020e0,0x2d980270,0x752001f7}},	//   swir, luki_, _fkse_, yemz, 
   {{0xd7e820e1,0x588420e2,0x200001af,0x7c2402ce}},	//   емде_, лыла, ouki_, pwir, 
   {{0x200020e3,0x1d98001f,0x8d94001f,0x7c240309}},	//   nuki_, _መብቶች_, _መጥቷል_, qwir, 
   {{0x2d5420e4,0xdbd00037,0x3178012d,0x765820e5}},	//   _fåes_, _müüt, zisz_, tyvy, 
   {{0x200020e6,0x06cc0c58,0x795403e6,0xdbd00254}},	//   huki_, _ৰাখি, _پێشا, _lüüt, 
   {{0x200020e7,0xd90c20e8,0x550420e9,0x00000000}},	//   kuki_, _ریت_, учка, --, 
   {{0xe97020ea,0x12e420eb,0x200020ec,0x9f400306}},	//   _بۇند, лінг, juki_, zská_, 
   {{0x200020ed,0x7520021a,0x3178033f,0x926803c5}},	//   duki_, semz, wisz_, ерма_, 
   {{0x362400dd,0x5fbc01ad,0x069002dd,0x5dc80150}},	//   _خواہ, _एंजल, _ﭘﺎﻳﯩ, _ﻓﺎﻻﺴ, 
   {{0x9f400232,0x200020ee,0x6ae0033f,0x32400023}},	//   vská_, fuki_, _फ़्र, _ንዘለኣ, 
   {{0x69c020ef,0xb4e020f0,0x9f4002f0,0xc1740108}},	//   _élev, थरी_, wská_, слящ, 
   {{0x9f400232,0x3178068f,0x00000000,0x00000000}},	//   tská_, sisz_, --, --, 
   {{0x3178006d,0x21200472,0x4380007b,0xd06006be}},	//   pisz_, bekh_, _دلوق, _ərən, 
   {{0x9f400232,0x200020f1,0xac180114,0x00000000}},	//   rská_, buki_, кобу_, --, 
   {{0x200020f2,0x6b7420f3,0xab740117,0x00000000}},	// [1bf0] cuki_, алау, агаш, --, 
   {{0x9f4000bc,0x952c0327,0x00000000,0x00000000}},	//   pská_, _ྩིའི_, --, --, 
   {{0xb36802d3,0x4290001f,0x8aa420f4,0xdd9001d9}},	//   _ሽወደን_, _ማንነት_, урад, _ژوپ_, 
   {{0x65b40f8b,0x2d9800c5,0x00000000,0x00000000}},	//   _tšhi, _ukse_, --, --, 
   {{0x6d4c20f5,0x0af0009d,0x00000000,0x00000000}},	//   mjaa, _гүзэ, --, --, 
   {{0x6d4c20f6,0x28d4134e,0x5c78010f,0x77840024}},	//   ljaa, _ड्रि, _יארה, бліз, 
   {{0x200020f7,0xff58010f,0x6d4c0e03,0x34c001e1}},	//   zuki_, רבוך_, ojaa, _ẹdọ_, 
   {{0x6d4c20f8,0x2000105c,0x69d420f9,0x00000000}},	//   njaa, yuki_, _itze, --, 
   {{0x13e40724,0x7bc00098,0x20000208,0x6d4c005b}},	//   амый_, _émut, xuki_, ijaa, 
   {{0x200019a2,0xc984036b,0xdbd000af,0x466802bf}},	//   vuki_, _руҳи, _rüüt, _прем_, 
   {{0x216820fa,0x21c40374,0xdbd000af,0x6d4c057b}},	//   вини_, _kēhi_, _süüt, kjaa, 
   {{0x200020fb,0x6d4c20fc,0x80dc015b,0xdbd000c5}},	//   tuki_, jjaa, _ভাঙ্, _püüt, 
   {{0x324002d3,0x6d4c01f5,0x21200083,0x656801ab}},	//   _ንዘልኣ, djaa, rekh_, mheh, 
   {{0x200020fd,0x263404fe,0x6d4c20fe,0x212001b3}},	//   ruki_, _kāo_, ejaa, sekh_, 
   {{0x200020ff,0xdea001d5,0x6d4c017a,0x925400f0}},	//   suki_, تیدی, fjaa, _вајт_, 
   {{0x6d4c2100,0x21c40374,0xdd902101,0xdbd000c5}},	//   gjaa, _nēhi_, آور_, _tüüt, 
  
   {{0x6448172e,0x69d40323,0x20000944,0x00000000}},	// [1c00] nxei, _atze, quki_, --, 
   {{0x6d4c2102,0x0b402103,0x64480d2a,0x5f74143e}},	//   ajaa, онун, ixei, _خابر, 
   {{0x6d4c0254,0x4ef8011a,0x00000000,0x00000000}},	//   bjaa, _בליג, --, --, 
   {{0xd7f82104,0x3f982105,0x394002d1,0xd23800df}},	//   вук_, loru_, ñis_, כגעל, 
   {{0x38602106,0x65682107,0x69d42108,0x00000000}},	//   áir_, dheh, _etze, --, 
   {{0x3f982109,0x35b40131,0x00000000,0x00000000}},	//   noru_, әбир, --, --, 
   {{0x25fc1d94,0x964405f5,0x386015ad,0x12c40066}},	//   रंगी_, рэлд, šir_, یتدپ, 
   {{0x3f980316,0xa6e80016,0x65680280,0x74140597}},	//   horu_, _ngươ, gheh, موبا, 
   {{0x0680210a,0x5344210b,0x3374013e,0x00000000}},	//   йгән, ахна, йгир, --, 
   {{0x4494210c,0x96940262,0x69d4002d,0x847c0023}},	//   рвью_, _креш, _ytze, _ዕድመን_, 
   {{0x69c0066d,0x3f98210d,0x65680472,0xe7b4210e}},	//   _élet, doru_, bheh, _اللھ, 
   {{0x92d4045e,0x5064210f,0x65682110,0x00000000}},	//   িণে_, атга, cheh, --, 
   {{0x938806bb,0xd0700023,0xa594009f,0x00000000}},	//   _иска_, _ኣድላዩ_, _اُنڪ, --, 
   {{0x09d400bd,0x3f982111,0x6d4c0cf9,0xc0ec0092}},	//   _হিসা, goru_, wjaa, _ኅዳር_, 
   {{0x6d4c2112,0xfeb801f7,0xadd40063,0x720401e2}},	//   tjaa, لافت_, собљ, _اوعم, 
   {{0x7d68036b,0x658000b0,0x417400f1,0x06cc03d4}},	//   ашув_, tēhi, _وايس, _ৰাছি, 
   {{0x6d4c2113,0x21c402b5,0x4ae80108,0x00000000}},	// [1c10] rjaa, _rēhi_, вьем_, --, 
   {{0x6d4c2114,0x3f9819f5,0x658002b1,0x8cb800dc}},	//   sjaa, coru_, rēhi, _शृणो, 
   {{0x21c40374,0x6d4c01f5,0x7a300332,0x00000000}},	//   _pēhi_, pjaa, vótá, --, 
   {{0x658002b5,0x797c00b0,0xb4e002c3,0x00000000}},	//   pēhi, tōwa, थरो_, --, 
   {{0x6c842115,0x7c84084c,0x2fc8003e,0x63a02116}},	//   _طلسم, _дуре, _juag_, ylln, 
   {{0x2fc80190,0xa7a82117,0x65a400e5,0xbd9c0092}},	//   _muag_, ыкла_, tóho, _ሀብታም_, 
   {{0x6568052f,0x2fc80190,0xd6cc2118,0x21c400b0}},	//   theh, _luag_, رقي_, _tēhi_, 
   {{0x79942119,0x3afc0ca8,0xf42000fe,0xd6b80154}},	//   _дисф, _tápà_, বিনৰ_, ুরূপ, 
   {{0x64480005,0x65680108,0x7958022e,0x00000000}},	//   uxei, rheh, _титр_, --, 
   {{0x6568211a,0x68e8211b,0x63a00194,0x3f9800e8}},	//   sheh, _heed, ulln, xoru_, 
   {{0x63a00998,0x68e8211c,0x26c40010,0x69c001d3}},	//   rlln, _keed, _iglo_, _éles, 
   {{0x68e80a81,0x656801ee,0x3f98211d,0x63a00175}},	//   _jeed, qheh, woru_, slln, 
   {{0x3f98211e,0x3438211f,0x68e82120,0x2fc80457}},	//   toru_, _پسند_, _meed, _cuag_, 
   {{0x68e82121,0x358c044e,0xdcf4007f,0xfe4401c6}},	//   _leed, _ሕቶታት_, riyč, омгү, 
   {{0xdee4036b,0x25fc2122,0xdef82123,0x00000000}},	//   _қони, रंटी_, кың_, --, 
   {{0x68e80c3e,0x3f982124,0x290c2125,0x00000000}},	//   _need, soru_, _ncea_, --, 
   {{0x3f980588,0x26c401fa,0x8c4010e2,0x2fc80076}},	// [1c20] poru_, _oglo_, пете, _guag_, 
   {{0x290c084c,0x00000000,0x00000000,0x00000000}},	//   _acea_, --, --, --, 
   {{0xcf540d65,0x68e80548,0x2fc80211,0x0f5400c8}},	//   _הבית_, _beed, _zuag_, _היים_, 
   {{0x26c4010f,0x2fc80211,0x68e80009,0x290c2126}},	//   _aglo_, _yuag_, _ceed, _ccea_, 
   {{0x290c0175,0x68e82127,0xf77800c7,0x00000000}},	//   _dcea_, _deed, аҧа_, --, 
   {{0x07b4007b,0x99e800f2,0x482000db,0x00000000}},	//   مهنة_, _معرق_, سىىق, --, 
   {{0x68e82128,0xdb2400aa,0x75880023,0x00000000}},	//   _feed, _پوځی, _ዝህልዎ_, --, 
   {{0x68e82129,0xf3f8006c,0xf8b8212a,0x26c402f0}},	//   _geed, аниш_, _көл_, _eglo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68e8212b,0x2fc80441,0x721809ac,0xe80c1c54}},	//   _zeed, _ruag_, ажор_, _समता_, 
   {{0x68e8212c,0x2130003e,0xcb9804ae,0x2d8401d3}},	//   _yeed, _bayh_, רסיט, élek_, 
   {{0x2fc80457,0x68e8058a,0x00000000,0x00000000}},	//   _puag_, _xeed, --, --, 
   {{0x2fc80218,0x5434212d,0x91c80fc8,0xf2c4212e}},	//   _quag_, _درار, _संवै, _мөни, 
   {{0x2fc80070,0xdb0c05ac,0x5694030d,0x00000000}},	//   _vuag_, _gibø, _таçт, --, 
   {{0xad240075,0x43d001e2,0xcd340240,0x00000000}},	//   يىسى, _وڅیړ, _ብሽክለ, --, 
   {{0x2fc8212f,0x21301529,0x6ed801f9,0xed0405af}},	//   _tuag_, _gayh_, _ब्रँ, تورپ, 
   {{0x68e82130,0x636c2131,0x31680200,0x00000000}},	// [1c30] _reed, _dúnf, _ilaz_, --, 
   {{0x3168030a,0x68e82132,0x25f8000d,0x7c842133}},	//   _hlaz_, _seed, _ईटली_, чусе, 
   {{0x39440175,0x636c0241,0x31680165,0x68e82134}},	//   _bnms_, _fúnf, _klaz_, _peed, 
   {{0x9f50007f,0x68e80429,0xe91802bf,0xad4000f7}},	//   _avyè_, _qeed, роді_, _تۉرۉ, 
   {{0xbae800bd,0x2d880381,0x68e82135,0x316804a7}},	//   _পারছ, mnae_, _veed, _mlaz_, 
   {{0xe7382136,0xadec05f9,0x68e80e21,0x7c700092}},	//   рек_, _जबान_, _weed, ቸግራል_, 
   {{0x636c2137,0x68e82138,0x2d882139,0xfb84213a}},	//   _húng, _teed, onae_, _хыян, 
   {{0x2d88213b,0xa9080014,0x636c0248,0x290c0356}},	//   nnae_, _خٲرٕ_, _kúng, _ucea_, 
   {{0x25fc130b,0x2d88213c,0x386008c2,0x00000000}},	//   रूजी_, inae_, ùirt_, --, 
   {{0x31680166,0xa5f8213d,0xe3580484,0x50cc0055}},	//   _alaz_, _вежу_, ршиш_, _ānāṃ_, 
   {{0xe124213e,0x2d88213f,0x31680156,0x7af803b2}},	//   омни, knae_, _blaz_, óvti, 
   {{0x24182140,0x65780493,0xd1c40006,0x614400d8}},	//   _воды_, _umwh, ўляе_, цема, 
   {{0x2d880493,0x1fa801b9,0x9f400419,0x00000000}},	//   dnae_, икми_, mskú_, --, 
   {{0x2d882141,0x3168013d,0x658002b5,0x9f4000d0}},	//   enae_, _elaz_, rēhu, lskú_, 
   {{0x316804cc,0x3eac2142,0x82200327,0x8fa02143}},	//   _flaz_, ådt_, _འགྲི_, фаре, 
   {{0x2d881730,0x9f4001f1,0x31680156,0x636c02d2}},	//   gnae_, nskú_, _glaz_, _búng, 
   {{0x636c007b,0x442c02d2,0x00000000,0x00000000}},	// [1c40] _cúng, _jsg_, --, --, 
   {{0x2d8816b8,0x9f04158b,0x636c0332,0x1dd02144}},	//   anae_, _بودو, _dúng, _दंपत, 
   {{0x442c0263,0xb6040139,0x636c2145,0x63bc0419}},	//   _lsg_, _kráş, _túnf, ísny, 
   {{0x9f4000d0,0x28d409ab,0x00000000,0x00000000}},	//   jskú_, डुलि, --, --, 
   {{0x636c2146,0x9f400419,0x87d0027d,0x00000000}},	//   _gúng, dskú_, وغوا, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x636c0022,0x5f1000dc,0x645c2147,0x6724000d}},	//   _múnd, _तान्_, øsin, õhja, 
   {{0x200001a9,0x29d401a9,0x00000000,0x00000000}},	//   krki_, _хўрс, --, --, 
   {{0x17840064,0x00000000,0x00000000,0x00000000}},	//   _дгам, --, --, --, 
   {{0x636c002d,0x8c180375,0xb27400d8,0x00000000}},	//   _núnd, סויי, злош, --, 
   {{0x31682148,0x8b00012c,0x9f4000d7,0x20002149}},	//   _plaz_, _úřed, bskú_, erki_, 
   {{0x442c04cc,0x77a4004e,0xdc3803e0,0x00000000}},	//   _fsg_, dòxi, hçıv, --, 
   {{0x31680165,0xe73001d3,0x00000000,0x00000000}},	//   _vlaz_, _غصے_, --, --, 
   {{0xd2580798,0x00000000,0x00000000,0x00000000}},	//   _вци_, --, --, --, 
   {{0x442c0076,0x2d880393,0x636c214a,0x2000012d}},	//   _zsg_, tnae_, _dúnd, arki_, 
   {{0x31680b91,0x200005be,0xc0d0001f,0x442c0142}},	//   _ulaz_, brki_, ጥቷል_, _ysg_, 
   {{0xfbd0214b,0x636c214c,0x2d88214d,0xa114004b}},	// [1c50] نتل_, _fúnd, rnae_, _رسيږ, 
   {{0x636c214e,0x8aa4214f,0xdcf40882,0x2d880493}},	//   _gúnd, оред, riyā, snae_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd5a4015e,0xdeb40375,0x636c032e,0xd36400f1}},	//   _سف_, _מפתח_, _túng, _ړه_, 
   {{0x5f1000dc,0x9cd402e4,0xef3402d3,0x9f400030}},	//   _ताम्_, _מורה_, _ብምድል, vskú_, 
   {{0x442c05e4,0xd24400c6,0x00000000,0x00000000}},	//   _rsg_, _كن_, --, --, 
   {{0x81ac009e,0x442c03e0,0x9f400030,0x37a8010b}},	//   _কংস_, _ssg_, tskú_, цтцн_, 
   {{0x442c2150,0x636c003a,0x20000ad9,0x09bc031c}},	//   _psg_, _múne, yrki_, _གངྒ_, 
   {{0x02c4036b,0x9f4000d0,0xa7742151,0xf48400d8}},	//   оқли_, rskú_, _елач, дуќн, 
   {{0x468007d6,0x86f0009f,0x00000000,0x00000000}},	//   _оқла, _آياچ, --, --, 
   {{0xe2982152,0xd24c04d3,0x636c00c6,0x26cc0618}},	//   сан_, ۆنی_, _rúnd, āloā_, 
   {{0x442c2153,0xd24c004b,0xe2980124,0x00000000}},	//   _tsg_, چنی_, иаҿ_, --, 
   {{0x55502154,0x645c2155,0xd24c2156,0x442c2157}},	//   _سپور, äsid, ننی_, _usg_, 
   {{0xdc3803be,0x77a4004e,0x80a0043e,0x5438010f}},	//   xçıv, tòxi, _गुणे, _לענא, 
   {{0x75f80139,0x6ac000eb,0xa49001e2,0x81a801e2}},	//   _gäzā, শুতো, _تیښت, _وضعې_, 
   {{0xbae82158,0x77a4004e,0xadec012d,0x636c01e1}},	//   _পাইছ, ròxi, _जबरन_, _wúnd, 
   {{0x5bc42159,0x636c0248,0x00000000,0x00000000}},	// [1c60] سقال, _túnd, --, --, 
   {{0x636c215a,0x9cc8215b,0x2f1401d3,0x10380375}},	//   _fúne, рыңа_, rúgó_, _פגיע, 
   {{0x069000d1,0xeb5400cf,0x00000000,0x00000000}},	//   _ﭘﺎﻛﯩ, بىلگ, --, --, 
   {{0x25700008,0x9f04006c,0xad24215c,0x00000000}},	//   _hálf_, _بوگو, _قىپى, --, 
   {{0xe7f4012c,0x645c0158,0x1cb801e2,0x00000000}},	//   ुंगा_, øsil, _دادب_, --, 
   {{0x50180302,0x636c002d,0x00000000,0x00000000}},	//   מונו, _lúnb, --, --, 
   {{0xc71400f1,0x00000000,0x00000000,0x00000000}},	//   ستوئ_, --, --, --, 
   {{0x1dbc00dc,0x7afc0175,0xd91800f1,0x18680672}},	//   ्दित, _hdrt, _ديرش_, _лаби_, 
   {{0x186800c7,0x00000000,0x00000000,0x00000000}},	//   _уааи_, --, --, --, 
   {{0xb4ac038e,0xb4bc0574,0xca7402d3,0x00000000}},	//   _गरी_, _आणी_, በርኩም_, --, 
   {{0x1dbc215d,0x00000000,0x00000000,0x00000000}},	//   ्दात, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2448215e,0x00000000,0x00000000,0x00000000}},	//   _وجهي_, --, --, --, 
   {{0x645c01f4,0x00000000,0x00000000,0x00000000}},	//   äsie, --, --, --, 
   {{0x7f94215f,0xd24401c6,0x3134004e,0x4ad0000d}},	//   харх, _хэли, _жейр, _तलबव, 
   {{0x646400ee,0xad242160,0x65a401d3,0x8d74029e}},	//   _ätiý, بىرى, tóhi, سازا, 
   {{0x0dc8039b,0x01342161,0x0ca8030d,0x00000000}},	// [1c70] руҳи_, _سعيد, стви_, --, 
   {{0x83680201,0x65a401ed,0x3f840098,0x61f4013d}},	//   _ስለዚህ_, róhi, émut_, _äglä, 
   {{0x6e94084c,0xadb4005b,0xcfa80244,0x00000000}},	//   _цину, _обош, _پاکم_, --, 
   {{0x636c00d2,0xdd902162,0xb4bc01f9,0x00000000}},	//   _kúnc, _لوپ_, _आणू_, --, 
   {{0xf7702163,0x19c00b8d,0xf9900691,0x69c000f2}},	//   گان_, тәрг, دبل_, _èlem, 
   {{0x80a007f7,0x8038011a,0x00000000,0x00000000}},	//   _ऐडसे, פנוע_, --, --, 
   {{0x95d40724,0x797c02b1,0x00000000,0x00000000}},	//   үдәт_, kōwh, --, --, 
   {{0xdbcc06be,0xa96802f2,0x8a740117,0x00000000}},	//   _qıçl, _بمرم_, _диҳӣ_, --, 
   {{0x291c009a,0x636c0241,0x00000000,0x00000000}},	//   mfwa_, _rúnb, --, --, 
   {{0xe1f82164,0x066400dd,0x65a41d0e,0xa90c000d}},	//   ого_, _ٹائپ, jóhv, _हाँफ_, 
   {{0xdb0c007f,0x85440276,0x00000000,0x00000000}},	//   _kibò, _нэде, --, --, 
   {{0x291c2165,0xdb0c0139,0x00000000,0x00000000}},	//   nfwa_, _sibü, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2ce80327,0xd42400ec,0x68ec0162,0x00000000}},	//   _འབུབ, _آڻين_, ðadj, --, 
   {{0x291c2166,0x636c2167,0x02a401c0,0x7094001f}},	//   kfwa_, _túnb, _эрдм, _ያድርጉ_, 
   {{0x61e000db,0x27e80306,0x00000000,0x00000000}},	//   mpll, šany_, --, --, 
   {{0x672002ae,0x1fb42168,0xdbd40724,0x3f840393}},	// [1c80] _oblj, _осор, _mäçe, émus_, 
   {{0xbb5403e6,0x40e80244,0x00000000,0x00000000}},	//   رۆزب, _بوکێ_, --, --, 
   {{0x7afc0010,0x00000000,0x00000000,0x00000000}},	//   _vdrt, --, --, --, 
   {{0x2d8401d3,0xdbd4010b,0x8c0800fe,0x00000000}},	//   élet_, _näçe, ৰিজন_, --, 
   {{0xb4ac038e,0x60240134,0x87d42169,0x257003b2}},	//   _गरे_, _wɔmf, وبوس_, _máld_, 
   {{0x7afc0010,0x00000000,0x00000000,0x00000000}},	//   _udrt, --, --, --, 
   {{0x8b000316,0xb0a4216a,0x745400e5,0x1a640244}},	//   _úřad, _गुनग, کھائ, _تیای_, 
   {{0xd8241b88,0x743412e7,0x05b4216b,0x86b001ec}},	//   _одби, ениф, وديت_, тәуі, 
   {{0x160007f7,0xe8041431,0x00000000,0x00000000}},	//   रूजर_, _रिया_, --, --, 
   {{0xd7f80022,0x7980035a,0x32540454,0xd6280798}},	//   _гуҧ_, _hmmw, евор, _мозе_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe7f40034,0x80a0076e,0xe8040709,0x00000000}},	//   ुंचा_, _गुहे, _रिमा_, --, 
   {{0xc0c8084c,0x00000000,0x00000000,0x00000000}},	//   дуре_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x79800083,0x490c121d,0x4390216c,0xc32c00d1}},	//   _ommw, _डालो_, _шашс, _ئەپ_, 
   {{0x9f4002fd,0x320c010e,0x00000000,0x00000000}},	//   mský_, mudy_, --, --, 
   {{0x9f4004bf,0x320c216d,0xdb0c0ba1,0xf41c015b}},	// [1c90] lský_, ludy_, _ribò, তিকর_, 
   {{0x636c00d2,0x7980216e,0x257003b2,0x00000000}},	//   _kúna, _ammw, _tálg_, --, 
   {{0xdeb0005e,0x9f400e96,0x257000e4,0x291c216f}},	//   _бұры, nský_, _hále_, tfwa_, 
   {{0x4adc2170,0x2d8c0de2,0x645c03cd,0xdd10010e}},	//   _प्रव, _ñee_, øsik, müşi, 
   {{0x291c2171,0x636c0597,0xba742172,0x9d1800c8}},	//   rfwa_, _lúna, _یافت, _צושט, 
   {{0x79800337,0x00000000,0x00000000,0x00000000}},	//   _emmw, --, --, --, 
   {{0x6d5c2173,0x9f400122,0x25700241,0xe61800d4}},	//   _kosa, jský_, _lále_, їди_, 
   {{0x6d5c2174,0x9f400122,0x6b84022e,0x320c00a2}},	//   _josa, dský_, lihg, dudy_, 
   {{0x6d5c2175,0x4ad00073,0xe36400cf,0x00000000}},	//   _mosa, _तलाव, екпи, --, 
   {{0x6d5c2176,0x27ec020c,0x636c09f3,0x67200010}},	//   _losa, _iwen_, _búna, _ublj, 
   {{0x636c00c6,0x69c8020c,0xf7700075,0x27ec0156}},	//   _cúna, _kiee, _ئاق_, _hwen_, 
   {{0x6d5c2177,0x27ec2178,0x636c007b,0xa3d42179}},	//   _nosa, _kwen_, _dúna, _зодч, 
   {{0x27ec0699,0x6568217a,0x00000000,0x00000000}},	//   _jwen_, mkeh, --, --, 
   {{0x27ec13ca,0x443c217b,0x9f40217c,0x25700316}},	//   _mwen_, mvu_, bský_, _dále_, 
   {{0x6d5c217d,0x27ec217e,0x443c217f,0x63a02180}},	//   _bosa, _lwen_, lvu_, moln, 
   {{0x6d5c2181,0x69c82182,0x27ec2183,0x63a0022e}},	//   _cosa, _niee, _owen_, loln, 
   {{0x6d5c2184,0x443c2185,0x41ac033f,0x65680022}},	// [1ca0] _dosa, nvu_, _टीएस, ikeh, 
   {{0x6d5c02d0,0x443c2186,0x3ab40131,0x90980375}},	//   _eosa, ivu_, вәбт, _מספק, 
   {{0x6d5c2187,0x69c802ea,0x65682188,0x27ec2189}},	//   _fosa, _biee, kkeh, _awen_, 
   {{0x443c04b9,0x6d5c218a,0x27ec0295,0x69c806d1}},	//   kvu_, _gosa, _bwen_, _ciee, 
   {{0x69c8218b,0x63a0218c,0x9f4000bc,0x656800d7}},	//   _diee, koln, zský_, dkeh, 
   {{0x6d5c055a,0x27ec218d,0x443c00d2,0x69c80076}},	//   _zosa, _dwen_, dvu_, _eiee, 
   {{0x69c80270,0x6d5c218e,0x27ec218f,0x443c2190}},	//   _fiee, _yosa, _ewen_, evu_, 
   {{0x9f4003c6,0x27ec0097,0x09d41c82,0x636c2191}},	//   vský_, _fwen_, _হিচা, _rúna, 
   {{0x443c022c,0x636c03b2,0x00000000,0x00000000}},	//   gvu_, _súna, --, --, 
   {{0x320c2192,0x9f400232,0x07a00139,0x63a02193}},	//   tudy_, tský_, _баун, goln, 
   {{0x27ec083a,0x69c80066,0x443c2194,0x257002fb}},	//   _zwen_, _yiee, avu_, _sále_, 
   {{0x9f402195,0x443c2196,0x65682197,0xb4840032}},	//   rský_, bvu_, ckeh, _икеһ, 
   {{0x63a02198,0x09d403d4,0x443c0051,0x00000000}},	//   boln, _হিছা, cvu_, --, 
   {{0x6d5c2199,0x63a0219a,0x9f40219b,0x636c219c}},	//   _sosa, coln, pský_, _túna, 
   {{0x636c219d,0x25700248,0x5f1001f9,0x00000000}},	//   _kúnn, _wále_, _तार्_, --, 
   {{0xd13805f5,0x6d5c219e,0xd6b0009e,0x257000d7}},	//   _ххк_, _qosa, _চলায, _tále_, 
   {{0x6d5c219f,0xc0f40023,0x00000000,0x00000000}},	// [1cb0] _vosa, ፍኦም_, --, --, 
   {{0x6d5c21a0,0x65680419,0x00000000,0x00000000}},	//   _wosa, zkeh, --, --, 
   {{0x6d5c21a1,0x69c821a2,0x27ec21a3,0x443c21a4}},	//   _tosa, _piee, _swen_, zvu_, 
   {{0x27ec21a5,0x443c21a6,0x6d5c21a7,0xfaa421a8}},	//   _pwen_, yvu_, _uosa, ушун, 
   {{0xfe7004d3,0x69c8002f,0x0c840139,0xdce4002b}},	//   _ندێ_, _viee, _чынм, _ulkā, 
   {{0x443c1418,0x00000000,0x00000000,0x00000000}},	//   vvu_, --, --, --, 
   {{0x63a021a9,0xe80c07f7,0x65680419,0x00000000}},	//   voln, _समका_, tkeh, --, 
   {{0x63a0068f,0x27ec007f,0x636c0332,0x64a4004e}},	//   woln, _twen_, _cúnn, кайа, 
   {{0x65680639,0x67d421aa,0x636c0241,0x27ec21ab}},	//   rkeh, _розу, _dúnn, _uwen_, 
   {{0x443c21ac,0x656821ad,0x934021ae,0xd5a407d6}},	//   rvu_, skeh, анье, _یللی, 
   {{0x443c21af,0x2c1c015b,0xf7d008b0,0x636c0ca8}},	//   svu_, নিয়ে_, ﮕﯩﻠﻪ, _fúnn, 
   {{0x98a40421,0x636c0248,0x63a021b0,0x00000000}},	//   leoā_, _gúnn, soln, --, 
   {{0x63a00f72,0xb0a421b1,0x42c0015b,0x6620000d}},	//   poln, _गुदग, োরেশ, _महुए_, 
   {{0x25ac21b2,0xffa405f5,0xf1b40131,0xe2c800f7}},	//   llel_, улгү, _ﭼﯩﻘﻘ, _قوشو_, 
   {{0x25ac21b3,0x539802e4,0x8e8021b4,0x00000000}},	//   olel_, _קיצו, агре, --, 
   {{0xd00c00b2,0xe04421b5,0x00000000,0x00000000}},	//   _ڀلي_, _ании, --, --, 
   {{0x91b80375,0x636c0419,0x00000000,0x00000000}},	// [1cc0] _קמפי, _júno, --, --, 
   {{0x25ac21b6,0x832c031c,0x9f400174,0x9e64014b}},	//   hlel_, _ཨིསུ_, rskó_, _авод, 
   {{0xefe00092,0x25ac0139,0x00000000,0x00000000}},	//   ናየው_, klel_, --, --, 
   {{0x588421b7,0xa3d021b8,0x00000000,0x00000000}},	//   кыла, वदा_, --, --, 
   {{0x7d0801e1,0x636c01e1,0x25ac21b9,0x00000000}},	//   _eèrà, _rúnn, dlel_, --, 
   {{0x636c1941,0x25ac0254,0xa9c400cf,0x00000000}},	//   _súnn, elel_, _ۅزقو, --, 
   {{0xd5b821ba,0x645c21bb,0x25ac05d5,0x75d4143e}},	//   мси_, äsin, flel_, ديبا, 
   {{0x25ac21bc,0x3dc00100,0x69b40037,0x00000000}},	//   glel_, nmiw_, ेषणी, --, 
   {{0x92ac00fe,0xd0e021bd,0x18a400c7,0x41cc00c5}},	//   _কলে_, _क्षण_, _раам, _संउस, 
   {{0x31bc0b7c,0x45d00022,0x00000000,0x00000000}},	//   ोद्ध, ыцәт, --, --, 
   {{0xcb100302,0xdb0c0793,0x23780023,0x25ac0156}},	//   בלת_, _fibö, ësja_, blel_, 
   {{0x3a380f85,0x82a00022,0x00000000,0x00000000}},	//   _msrp_, ршье, --, --, 
   {{0x3a3800a3,0x636c0248,0x8fe000fb,0x00000000}},	//   _lsrp_, _kúnl, шәйҙ, --, 
   {{0x69c000f2,0x00000000,0x00000000,0x00000000}},	//   _èlev, --, --, --, 
   {{0x636c00c6,0xc33002e4,0x43800345,0x257021be}},	//   _múnl, _כוס_, _خلوق, _hála_, 
   {{0x518421bf,0x257021c0,0x4638010f,0xb1140114}},	//   _шула, _kála_, ועלע, _смиш, 
   {{0x3cd421c1,0x636c01e1,0xd1f80023,0x00000000}},	// [1cd0] ржус, _oúnl, ጋእቲ_, --, 
   {{0x3a38009a,0x257021c2,0xf3f41c82,0x201c0276}},	//   _bsrp_, _mála_, _আমাৰ_, ătit_, 
   {{0x257000d2,0xe8041f14,0x3dc00455,0xdb080162}},	//   _lála_, _रिहा_, bmiw_, ínái, 
   {{0x3a3805da,0x67d421c3,0x00000000,0x00000000}},	//   _dsrp_, году, --, --, 
   {{0x6024016b,0x2d881730,0x4b500014,0x31b802f0}},	//   _kɔma, miae_, _پێار, céze_, 
   {{0x2d880483,0x6f140097,0x636c0332,0x00000000}},	//   liae_, ngzc, _cúnl, --, 
   {{0x25ac0770,0x6ab402d0,0x00000000,0x00000000}},	//   tlel_, _uzzf, --, --, 
   {{0x224804b9,0x2d880483,0x257021c4,0x61e4062c}},	//   _čak_, niae_, _bála_, _çhli, 
   {{0x69d421c5,0x257000d2,0x636c01e1,0x25ac21c6}},	//   _huze, _cála_, _fúnl, rlel_, 
   {{0x68f821c7,0x25ac0122,0x69d421c8,0x2570007b}},	//   lawd, slel_, _kuze, _dála_, 
   {{0x69d421c9,0xa18821ca,0xa1c421cb,0xe28421cc}},	//   _juze, ебна_, лбод, улни, 
   {{0x69d421cd,0x9f5c012c,0x257001e7,0x68f821ce}},	//   _muze, čtí_, _fála_, nawd, 
   {{0x69d421cf,0x2d881730,0x701802dd,0x4ac00b98}},	//   _luze, diae_, кірт_, वेतव, 
   {{0xe29821d0,0x02c00724,0x69d40156,0x9ea821d1}},	//   _пал_, _килү, _ouze, евга_, 
   {{0x3eac037e,0x2d8821d2,0xe80c0034,0xab68012d}},	//   ædt_, fiae_, _समझा_, zyżó, 
   {{0x2d881730,0x3a380334,0xdd10010e,0xdca4011c}},	//   giae_, _rsrp_, _düşu, габи, 
   {{0x1c4421d3,0x69d421d4,0x68f821d5,0xf1a802f2}},	// [1ce0] ынам, _auze, dawd, _جاوه_, 
   {{0x69d421d6,0x3a3801f7,0xe80c0073,0x23b80241}},	//   _buze, _psrp_, _समजा_, bèje_, 
   {{0xd94421d7,0x69d40165,0x2d8816b8,0x636c0241}},	//   лежи, _cuze, biae_, _rúnl, 
   {{0x69d421d8,0x2d881730,0x68f821d9,0x00000000}},	//   _duze, ciae_, gawd, --, 
   {{0xb6c801ed,0x645c0108,0x00000000,0x00000000}},	//   ھاتے_, äsil, --, --, 
   {{0x69d421da,0x07a021db,0xc7a01920,0xb6c800e5}},	//   _fuze, бачн, бичк, پاتے_, 
   {{0x2a3400a8,0x69d421dc,0x257021dd,0xea6421de}},	//   _кэтр, _guze, _sála_, _پھلی, 
   {{0x636c007b,0x68f80067,0x2570032e,0x049801e1}},	//   _dúnm, cawd, _pála_, _ìlọr, 
   {{0x69d4152d,0x349421df,0x938821e0,0x337421e1}},	//   _zuze, рапр, есна_, игир, 
   {{0x69d40dd4,0x28b800a8,0x2d88003a,0x257003b2}},	//   _yuze, _русэ_, ziae_, _vála_, 
   {{0x3938001f,0x636c01e1,0x60c80213,0x2d88003a}},	//   _በምዕራ, _gúnm, əlmə, yiae_, 
   {{0x25700085,0x76480175,0x2d880381,0xd13821e2}},	//   _tála_, _irdy, xiae_, ххо_, 
   {{0x2d8816b8,0x645c21e3,0x00000000,0x00000000}},	//   viae_, øsit, --, --, 
   {{0x44781a4c,0x84140375,0x00e400d1,0x00000000}},	//   _אנדע, _עקוב_, _ﺋﯩﺸﻘ, --, 
   {{0x2d880483,0x1b180154,0x636c0cad,0x024001f7}},	//   tiae_, ড়াই_, _oúnj, _هَوَ, 
   {{0x6024016b,0x2d880393,0x00000000,0x00000000}},	//   _wɔma, uiae_, --, --, 
   {{0x2d880de4,0x31780175,0x00000000,0x00000000}},	// [1cf0] riae_, mhsz_, --, --, 
   {{0x2d880483,0xadd80124,0x68f80083,0x23b8007f}},	//   siae_, _имоу_, wawd, pèje_, 
   {{0x2d8816b8,0x6fdc015b,0x68f821e4,0x69d403e3}},	//   piae_, _বিয়ে, tawd, _quze, 
   {{0x8880035c,0x69d421e5,0x636c0ca8,0xb33c0135}},	//   میزن, _vuze, _rúnm, koħo, 
   {{0x68f8006d,0x764821e6,0x636c0248,0x0ca821e7}},	//   rawd, _ardy, _dúnj, _سطحي_, 
   {{0x68f800a9,0x69d421e8,0x186421e9,0x645c0f23}},	//   sawd, _tuze, раши_, äsim, 
   {{0x7f3c00c8,0x636c0248,0x6f0402e2,0x9ba021ea}},	//   געוו, _fúnj, _mdhc, _بەلى, 
   {{0xd3440b28,0x49b80214,0x68f8014f,0xb4e40051}},	//   یینه_, _سازد_, qawd, _nhàđ, 
   {{0x27fc0369,0x44280ba1,0xe7041d0a,0x00000000}},	//   qswn_, ïc_, _نسای, --, 
   {{0xe3b000c6,0x2d980010,0x636c21eb,0x00000000}},	//   غرة_, _ljse_, _túnm, --, 
   {{0xc5f401b9,0x2b4001e7,0x67240254,0x37c401f7}},	//   _ёғи_, idhc_, õhju, _ايلف, 
   {{0xd24c107f,0xe04406b3,0xa0680640,0xf6f00241}},	//   بچه_, анми, вама_, _iṣẹt, 
   {{0xdfa421ec,0x30740064,0x320c21ed,0x10a000cf}},	//   لحسي, бурс, ardy_, жиян, 
   {{0x25700241,0x30740108,0x60d000ef,0x00000000}},	//   _kálo_, суюс, _ņemā, --, 
   {{0x0fc000d6,0x9cf421ee,0x00000000,0x00000000}},	//   ійсн, ичаш, --, --, 
   {{0x257004bf,0xaaa80cb4,0xdcb021ef,0x00000000}},	//   _málo_, _कड़क, قىز_, --, 
   {{0x25700241,0x9f40007c,0x5ba800f5,0x8c4000c7}},	// [1d00] _lálo_, dskö_, вкам_, оете, 
   {{0xdcf406b9,0x00000000,0x00000000,0x00000000}},	//   ıcın, --, --, --, 
   {{0x19f800a8,0x629c002f,0x00000000,0x00000000}},	//   тэзь_, ßsoh, --, --, 
   {{0x636c04d4,0x5ca4033a,0x4e2400db,0x00000000}},	//   _búnk, _вимб, _тоюн_, --, 
   {{0x97c421f0,0x31b80306,0x888001c6,0x00000000}},	//   айде, néza_, олцж, --, 
   {{0x636c002d,0x320c0209,0xdb50009f,0x257001ef}},	//   _dúnk, yrdy_, _بَس_, _bálo_, 
   {{0x31b8019f,0xf62800cf,0x00000000,0x00000000}},	//   héza_, اتتۇ_, --, --, 
   {{0x636c21f1,0x00000000,0x00000000,0x00000000}},	//   _fúnk, --, --, --, 
   {{0x68ec056a,0xa9980395,0xd4980395,0x00000000}},	//   ñade, _сърф_, ърк_, --, 
   {{0x33740108,0x68f400d7,0x00000000,0x00000000}},	//   сгор, ľadň, --, --, 
   {{0x0bb40302,0x200c0618,0x6f040175,0xa2c801bc}},	//   שלים_, _āfia_, _rdhc, _हृद्, 
   {{0x672c041a,0xc68c01d9,0x00000000,0x00000000}},	//   đaje, _تِم_, --, --, 
   {{0x49040490,0x5434009f,0x00000000,0x00000000}},	//   हणतो_, _خرار, --, --, 
   {{0x35a002d3,0x00000000,0x00000000,0x00000000}},	//   _ውህበት_, --, --, --, 
   {{0x59a421f2,0x9f4001f4,0x00000000,0x00000000}},	//   गकार, yskö_, --, --, 
   {{0x6c840736,0x37ac0154,0x00000000,0x00000000}},	//   ملزم, গগির, --, --, 
   {{0x7cd801ca,0x31b800d7,0x8f08030d,0x3d180037}},	// [1d10] рмур_, céza_, _ихна_, _फारे_, 
   {{0x8ae410f5,0xac9421f3,0x6fb400f1,0xaa5800f3}},	//   ріал, _ҳамш, _دمخا, лизу_, 
   {{0x1fe0015b,0x636c01e1,0x00000000,0x00000000}},	//   _বিএস, _súnk, --, --, 
   {{0x2b40037e,0x645c0793,0x2bd821f4,0xac9401c6}},	//   sdhc_, äsik, _ماسک_, _гамш, 
   {{0x66e421f5,0x3f8400e8,0x257001e1,0x41d00b98}},	//   бола, ëmug_, _sálo_, _संघस, 
   {{0xdc3804ac,0x8038008f,0x77840212,0x00000000}},	//   _געשר, ינדע_, оліз, --, 
   {{0x8234001f,0xb9e40212,0x4ac021f6,0x00000000}},	//   _ይካሄዳ, _міти, वेशव, --, 
   {{0xe29821f7,0x636c000f,0x17e400cc,0x00000000}},	//   ғам_, _túnk, _নিৰি, --, 
   {{0x636c01b8,0x21680aac,0xa2c811bc,0xe5e401ec}},	//   _húni, ҳини_, हेन्, _ﺍﻨﻌﻜ, 
   {{0xc6a421f8,0x36d400d8,0xdcf40166,0x35f81291}},	//   _креи, _дофр, kiyğ, _چرند_, 
   {{0x216821f9,0x636c00dd,0x614421fa,0xe29821fb}},	//   гини_, _júni, бена, ѓам_, 
   {{0x249c0457,0x636c21fc,0x31b80306,0x00000000}},	//   _txwm_, _múni, téza_, --, 
   {{0x64c401d5,0x3ce021fd,0x00000000,0x00000000}},	//   _ايشل, vciv_, --, --, 
   {{0x442c0ac5,0x31b802f0,0x257008ce,0x00000000}},	//   _ipg_, réza_, _málm_, --, 
   {{0x1d0808da,0x2bbc0b8f,0x636c02d2,0x3ce001e7}},	//   леви_, ्गना, _núni, tciv_, 
   {{0x442c0ac5,0x00000000,0x00000000,0x00000000}},	//   _kpg_, --, --, --, 
   {{0x645c005b,0xd11400d9,0x9b0421fe,0x00000000}},	// [1d20] äsih, _הקפה_, йзад, --, 
   {{0x442c21ff,0x636c2200,0x3ce0054e,0x00000000}},	//   _mpg_, _búni, sciv_, --, 
   {{0x20002201,0x25701f60,0x3ce0054e,0x00000000}},	//   lski_, _páll_, pciv_, --, 
   {{0x442c107d,0x6e2000db,0x2000033f,0x636c02d2}},	//   _opg_, àlbe, oski_, _dúni, 
   {{0xf4240003,0xdcb000cf,0x442c0f85,0x00000000}},	//   _འདེད_, _رىس_, _npg_, --, 
   {{0x394002d5,0x20000280,0x7c242202,0xc7a02203}},	//   žis_, iski_, mtir, пичк, 
   {{0x7c242204,0xd9442205,0xe3180156,0x8af806a9}},	//   ltir, _леви, ྱུནཔ_, _תהלי, 
   {{0x442c01c4,0xd5b80a8f,0x200000c5,0x60d40142}},	//   _bpg_, ысл_, kski_, _ngym, 
   {{0x7c242206,0x94a82207,0x442c0b0e,0xb4d82208}},	//   ntir, ытка_, _cpg_, _ाली_, 
   {{0x20000552,0x7c242209,0x2d840077,0x60d40a08}},	//   dski_, itir, élez_, _agym, 
   {{0x7c24006c,0x6024013f,0x442c220a,0x636c00d2}},	//   htir, _dɔmm, _epg_, _lúnw, 
   {{0x442c0077,0x00000000,0x00000000,0x00000000}},	//   _fpg_, --, --, --, 
   {{0x442c0998,0x2bbc00cd,0x00000000,0x00000000}},	//   _gpg_, ्गमा, --, --, 
   {{0x7c24220b,0x60d400dd,0x40341fbe,0x909c0055}},	//   dtir, _egym, џерс, _āśāy, 
   {{0x7c24220c,0x20000254,0x00000000,0x00000000}},	//   etir, aski_, --, --, 
   {{0x7c24220d,0x2000220e,0x636c1d75,0x95f8015b}},	//   ftir, bski_, _rúni, _ইমাম_, 
   {{0xac18220f,0x7c242210,0x442c0798,0xdb681ee0}},	// [1d30] розу_, gtir, _xpg_, _ቱሪዝም_, 
   {{0x636c2211,0x645c0108,0x00000000,0x00000000}},	//   _púni, äsii, --, --, 
   {{0x7c242212,0x25701d0e,0x2bbc00bc,0x60d4010e}},	//   atir, _sálm_, ्गबा, _ygym, 
   {{0xac182213,0x7c242214,0x636c01e1,0x79a400d8}},	//   _кому_, btir, _fúnw, прче, 
   {{0x7c242215,0x636c01e1,0x7c8400d8,0xfb541d37}},	//   ctir, _gúnw, _еуре, تپەد, 
   {{0x636c1427,0x442c2216,0x00000000,0x00000000}},	//   _túni, _rpg_, --, --, 
   {{0xf4240003,0x442c008b,0x65c400f5,0xe80419cc}},	//   _འདུད_, _spg_, обка, _रिका_, 
   {{0x24081ab7,0x20002217,0x442c0042,0xa2c800dc}},	//   ании_, yski_, _ppg_, _हृष्, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2042218,0xdb1c01a8,0x6384109a,0x00000000}},	//   опод, ympí, ігна, --, 
   {{0x20002219,0x7c2401c0,0xa1b80021,0xe69400c6}},	//   wski_, ztir, иумф_, _بلاد, 
   {{0x200004b9,0x7c24221a,0x6024221b,0x2454221c}},	//   tski_, ytir, _wɔmm, _وناس, 
   {{0x442c1ded,0x8444221d,0x3074013e,0x7c240009}},	//   _upg_, _دخال, пурс, xtir, 
   {{0x2000221e,0xc0cc0201,0x6448221f,0x00000000}},	//   rski_, _በኩል_, mvei, --, 
   {{0xb8fc0867,0x636c01e1,0x9d4401d5,0x00000000}},	//   _རྔ_, _súnw, оевд, --, 
   {{0x20002220,0x5bd00b33,0x00000000,0x00000000}},	//   pski_, तद्व, --, --, 
   {{0x64482221,0x7c240083,0x00000000,0x00000000}},	// [1d40] nvei, utir, --, --, 
   {{0x64482222,0x9b0402dd,0x63ac02d2,0xda64007b}},	//   ivei, ізед, _íand, ياضي, 
   {{0x62802223,0x2f540022,0xcf54011a,0x644810f1}},	//   nzlo, _хтыс, _ובית_, hvei, 
   {{0x6448032e,0x2570032e,0xb4d801ef,0x00000000}},	//   kvei, _dálk_, _ाले_, --, 
   {{0x7c242224,0x68ec0724,0x18342225,0x64482226}},	//   qtir, ñada, تراح, jvei, 
   {{0x636c2227,0x65780165,0xdbcc0724,0x7dd801e4}},	//   _kúnu, _alwh, _tıñl, _eŭse, 
   {{0x7afc2228,0x64482229,0xd9580640,0x628000d7}},	//   _iert, evei, _краљ_, jzlo, 
   {{0x7afc0204,0x1868006c,0x8ebc015b,0x98a4222a}},	//   _hert, _каби_, _আলমগ, _дибе, 
   {{0x7afc222b,0x335400cf,0x644802d2,0x00000000}},	//   _kert, зүлө_, gvei, --, 
   {{0x3944222c,0x7afc222d,0x872800f1,0x7c200166}},	//   _hams_, _jert, _نغمې_, _ämru, 
   {{0x394403a2,0x64481140,0x953c074d,0x00000000}},	//   _kams_, avei, _аслă_, --, 
   {{0x3944222e,0x7afc222f,0x00000000,0x00000000}},	//   _jams_, _lert, --, --, 
   {{0x644804fb,0x7afc0b21,0x25a000d7,0x00000000}},	//   cvei, _oert, éhle_, --, 
   {{0x25a82230,0x7afc2231,0x394400b0,0xb4c82232}},	//   čale_, _nert, _lams_, ोखी_, 
   {{0xccf8026a,0x645c023a,0x628000d7,0x00000000}},	//   ића_, äsiv, czlo, --, 
   {{0x3944005f,0x7afc2233,0x636c03b2,0x7058014b}},	//   _nams_, _aert, _dúnu, _гаир_, 
   {{0x7afc2234,0x7d242235,0x67f001e1,0x6b7405a2}},	// [1d50] _bert, ьфре, _mójò, плау, 
   {{0x39440395,0x31680156,0x00000000,0x00000000}},	//   _aams_, _hoaz_, --, --, 
   {{0x64482236,0x3168030a,0x49a400d8,0x00000000}},	//   zvei, _koaz_, ојда, --, 
   {{0x7afc2237,0x316801c4,0x39442238,0x64482239}},	//   _eert, _joaz_, _cams_, yvei, 
   {{0x66e4223a,0x636c00d2,0x31680198,0x7afc223b}},	//   пола, _kúnt, _moaz_, _fert, 
   {{0xe738223c,0x7afc223d,0x31680165,0xaa58223e}},	//   сек_, _gert, _loaz_, _лигу_, 
   {{0x39440093,0xa8a404d3,0x64480007,0x7768022e}},	//   _fams_, _کڵاو, wvei, _dodx, 
   {{0x7afc223f,0x64482240,0x3944014a,0x3168030a}},	//   _zert, tvei, _gams_, _noaz_, 
   {{0x291c00b5,0xc4440214,0x7afc01a9,0x13e40166}},	//   mgwa_, تیشن_, _yert, пмый_, 
   {{0x64482241,0x25702242,0xd04c00ac,0x628017da}},	//   rvei, _máli_, _ödəm, tzlo, 
   {{0xa91c02d5,0x31682243,0x61440902,0x00000000}},	//   _amži, _boaz_, пена, --, 
   {{0x24181301,0xdcf40882,0x636c0413,0x6280002f}},	//   _годы_, khyā, _rúnu, rzlo, 
   {{0x316801c6,0x25ac2244,0x62802245,0x00000000}},	//   _doaz_, moel_, szlo, --, 
   {{0xdcf40a28,0x636c007b,0x7768058a,0x54640107}},	//   dhyā, _cúnt, _xodx, _хашм_, 
   {{0x291c2246,0x12f80302,0x636c00c6,0x8fa02247}},	//   kgwa_, _ההצב, _dúnt, харе, 
   {{0x7afc2248,0x25ac2249,0xa0a4224a,0x316801c6}},	//   _sert, noel_, _найд, _goaz_, 
   {{0x1fb40276,0x636c01e1,0x9b080aac,0x3944045a}},	// [1d60] _нсор, _fúnt, йнаб_, _rams_, 
   {{0x3944224b,0x636c224c,0x3168009d,0x7afc224d}},	//   _sams_, _gúnt, _zoaz_, _qert, 
   {{0x7afc224e,0x19b8224f,0xaee40882,0x25ac05e4}},	//   _vert, будь_, saṃy, koel_, 
   {{0x7afc2250,0xdcf40a28,0x25ac2251,0x291c2252}},	//   _wert, bhyā, joel_, ggwa_, 
   {{0x25ac2253,0x672c05a1,0x7b8401ec,0xdb1c0332}},	//   doel_, đajn, _قاسە, ampá, 
   {{0x7afc2254,0x636c056a,0x291c2255,0x4cb80375}},	//   _uert, _xúnt, agwa_, _לזכו, 
   {{0x25ac2256,0x67200784,0x9a1005d9,0x4b780a7c}},	//   foel_, _dclj, _سڃاڻ, _פאלו, 
   {{0x25ac0368,0x2a6400a3,0xfcdc0023,0x00000000}},	//   goel_, _àlba_, _ንሕጊ_, --, 
   {{0xb4c806ab,0xb89800e5,0x00000000,0x00000000}},	//   ोखे_, _بھائ_, --, --, 
   {{0x316805c7,0xb27400d8,0x00000000,0x00000000}},	//   _soaz_, длош, --, --, 
   {{0x25ac2257,0x636c08a5,0x00000000,0x00000000}},	//   boel_, _rúnt, --, --, 
   {{0x25ac0687,0x92c02258,0x636c2259,0x95c800d8}},	//   coel_, _ışın, _súnt, _улеб_, 
   {{0x645c225a,0x316805c7,0x636c0124,0x25a80451}},	//   äsit, _voaz_, _púnt, _بدلي_, 
   {{0x3358084c,0x636c02d2,0x0874010f,0x249800d7}},	//   _факэ_, _dúns, לעכט_, úsme_, 
   {{0xae1c1533,0x316805c7,0x25700162,0xfe540006}},	//   बंधन_, _toaz_, _sáli_, нкрэ, 
   {{0xdcf40882,0x2570225b,0x645c01e3,0x00000000}},	//   thyā, _páli_, åsig, --, 
   {{0x636c21eb,0x00000000,0x00000000,0x00000000}},	// [1d70] _gúns, --, --, --, 
   {{0x636c0241,0x257003b2,0x644c0064,0x00000000}},	//   _húnr, _váli_, _šaik, --, 
   {{0x68ec1280,0xe9f80220,0x2d84004a,0x636c110e}},	//   ñado, інді_, èles_, _kúnr, 
   {{0xd244225c,0x2570225d,0xfbd80a17,0xad400228}},	//   _ین_, _táli_, _भूकम, _جۉرۉ, 
   {{0x25ac225e,0x291c020c,0xb4c800e1,0xd24400ec}},	//   voel_, rgwa_, ोखो_, _ڌن_, 
   {{0x25ac0af9,0x00000000,0x00000000,0x00000000}},	//   woel_, --, --, --, 
   {{0x25ac0430,0xe5a4225f,0x0bd00116,0x00000000}},	//   toel_, мики, _ﭘﯘﻗﺮ, --, 
   {{0xc1740198,0x2bbc1df0,0x00000000,0x00000000}},	//   _kiɗe_, ्गवा, --, --, 
   {{0x290c2260,0x68e801e1,0x9420010b,0x25ac030a}},	//   _idea_, _ifed, вмые, roel_, 
   {{0x27ec2261,0xb2f4023a,0xe2980063,0x636c2131}},	//   _iten_, няющ, жао_, _rúns, 
   {{0x25ac2262,0xd5ac2263,0xda7800c8,0xa63402bf}},	//   poel_, طفی_, ַנשר, _інді, 
   {{0x36342264,0x645c023a,0x27e80356,0x00000000}},	//   _سرمس, äsis, ţanu_, --, 
   {{0xd24c2265,0x5f940116,0x00000000,0x00000000}},	//   هنی_, җиңт, --, --, 
   {{0xdfd02266,0x443c2267,0x27ec01e4,0x03c40032}},	//   ئيس_, mwu_, _mten_, _эсем, 
   {{0x443c0943,0x27ec0004,0x9d54182f,0xdef80510}},	//   lwu_, _lten_, ونست, йың_, 
   {{0x290c2165,0x27e80943,0x27ec0428,0x636c2268}},	//   _ndea_, ̭ana_, _oten_, _túns, 
   {{0xed340323,0x27ec2269,0x443c226a,0xa2c80b4c}},	// [1d80] ээрэ, _nten_, nwu_, हेर्, 
   {{0x290c226b,0x68e8226c,0x443c226d,0x00000000}},	//   _adea_, _afed, iwu_, --, 
   {{0x27ec226e,0xddc4023a,0x9cc801ec,0x00000000}},	//   _aten_, _обои, сыңа_, --, 
   {{0x3d1810f7,0x443c05db,0xaac401b9,0x5c14010a}},	//   _फाटे_, kwu_, رتلن, _оьгу, 
   {{0x7d04226f,0x4f8401d9,0x4c6401a9,0x00000000}},	//   mais, _رایہ, _жиян_, --, 
   {{0x7d042270,0x68e80489,0x290c2271,0x443c0135}},	//   lais, _efed, _edea_, dwu_, 
   {{0x27ec2272,0x443c2273,0xa3c02274,0x68e803cb}},	//   _eten_, ewu_, ंतन_, _ffed, 
   {{0x4d78010f,0x6eb004af,0x699400c0,0x5de401ec}},	//   ַריע, _आँसु, _зрух, _ﻋﺎﻤﻴ, 
   {{0x443c05db,0x00000000,0x00000000,0x00000000}},	//   gwu_, --, --, --, 
   {{0x7d042275,0x636c004e,0x00000000,0x00000000}},	//   hais, _búnq, --, --, 
   {{0x7d042276,0x443c0094,0x7e68007c,0x80a800eb}},	//   kais, awu_, ädpl, _গণগ্, 
   {{0x7d042277,0x443c00ca,0xc5f002e4,0x00000000}},	//   jais, bwu_, _ידע_, --, 
   {{0x147400db,0x7d042278,0xb2a80014,0x00000000}},	//   _تااج, dais, تُھم_, --, 
   {{0xc05801ce,0x636c0248,0x00000000,0x00000000}},	//   фію_, _wúnr, --, --, 
   {{0x8d742279,0x7d04227a,0x4240035b,0x3134010b}},	//   وارا, fais, _ахыб, _зейр, 
   {{0x7d04227b,0x7520009f,0xc0cc01f3,0x00000000}},	//   gais, ngmz, በርም_, --, 
   {{0x2bbc227c,0xd7dc07f7,0x9a6c0092,0x00000000}},	// [1d90] ्गला, _फूलच, _በላከው_, --, 
   {{0x25701427,0x27ec0055,0x00000000,0x00000000}},	//   _hált_, _rten_, --, --, 
   {{0xfd1c00c6,0x27ec227d,0x290c0004,0x7e040100}},	//   _ŝάŝ_, _sten_, _pdea_, _pčsň, 
   {{0x7d04227e,0x317801f0,0xe94401d5,0x443c012d}},	//   cais, nksz_, عرای, ywu_, 
   {{0x16700131,0x25700162,0x5d78010f,0x00000000}},	//   ңқур, _mált_, _זארק, --, 
   {{0x9bf8011a,0x00000000,0x00000000,0x00000000}},	//   _מהשט, --, --, --, 
   {{0x443c227f,0x00000000,0x00000000,0x00000000}},	//   wwu_, --, --, --, 
   {{0x443c0034,0x290c2280,0x68e8009f,0xa524013e}},	//   twu_, _udea_, _ufed, хмид, 
   {{0x27ec10f5,0x09c800cd,0x31b801ef,0x00000000}},	//   _uten_, िषीय, cézi_, --, 
   {{0x7d042281,0x443c2282,0x00000000,0x00000000}},	//   zais, rwu_, --, --, 
   {{0x7d042283,0x81e40011,0x25702284,0x00000000}},	//   yais, মীন_, _sálu_, --, 
   {{0xe45000c6,0x00000000,0x00000000,0x00000000}},	//   _مضت_, --, --, --, 
   {{0x7d042285,0xdeb801f3,0x00000000,0x00000000}},	//   vais, ሲውን_, --, --, 
   {{0x7d042286,0x2d842287,0xdfd000ae,0x00000000}},	//   wais, ëlen_, طيز_, --, 
   {{0xb80400dc,0x00000000,0x00000000,0x00000000}},	//   _bhṛś, --, --, --, 
   {{0x80b400d1,0x00000000,0x00000000,0x00000000}},	//   _ۋەھش, --, --, --, 
   {{0x7d040b86,0xdee42288,0xdb1c023a,0x25700aab}},	// [1da0] rais, _попи, ympä, _háls_, 
   {{0x7d042289,0xd9b8228a,0x9b440127,0x24c000cc}},	//   sais, ेष्ट, عناو, _উলাহ, 
   {{0x7d04228b,0x4ef80302,0xb0680d73,0xb5200210}},	//   pais, _מהיו, _فصیل_, _यालय_, 
   {{0x4aac0490,0x25700008,0x18a4228c,0xa9c40066}},	//   _जुळव, _máls_, наем, نزنو, 
   {{0xb8e8130b,0xeaf800d1,0x00000000,0x00000000}},	//   _उर_, سرەت_, --, --, 
   {{0xaee40882,0xdb240248,0x9af4007b,0xa8540166}},	//   raṇy, _àpàp, _سكرت, тешә, 
   {{0x8ba0030d,0x00000000,0x00000000,0x00000000}},	//   _сирж, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x81e4015b,0x320000e8,0x44f00116,0x00000000}},	//   মীম_, _ňiy_, دسىز, --, 
   {{0xecc4228d,0x3f840de2,0x32540454,0x26b000db}},	//   लेटफ, ëmul_, ввор, دەۅز, 
   {{0x067c0ed1,0x00000000,0x00000000,0x00000000}},	//   ﺭﺍﻟﯩ, --, --, --, 
   {{0x54680801,0x4a9800c8,0x63ac032e,0x00000000}},	//   _наем_, לייג, _íann, --, 
   {{0xc95006a9,0x257001ed,0x636c002d,0x00000000}},	//   אמר_, _vált_, _túnp, --, 
   {{0x136400b2,0x42700139,0x65cc02dd,0x00000000}},	//   _ڊاڪٽ, _әгъс, _ﺗﺎﯕﺠ, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2ef40c04,0x2a6c0210,0x00000000,0x00000000}},	// [1db0] _изпр, _łeb_, --, --, 
   {{0x8aa4228e,0xa6d404c5,0x7980002f,0xa91c01ef}},	//   нред, _স্ফট, _almw, _mlže, 
   {{0x02f8010f,0x00000000,0x00000000,0x00000000}},	//   פלאמ, --, --, --, 
   {{0xc17403f9,0xc0bc02d3,0x397800d3,0xecc401c6}},	//   _kiɗa_, _ተጋሩ_, нсію_, _ашгү, 
   {{0x6d5c228f,0x6844036b,0x6d4c058a,0x00000000}},	//   _insa, тнла, mdaa, --, 
   {{0x6d4c2290,0xdc540014,0x8d8401b9,0x98e400fb}},	//   ldaa, _شرُک, _آشگن, нсәһ, 
   {{0x61ec2291,0x6d4c0014,0x6d5c04ce,0xe568009d}},	//   _čalo, odaa, _knsa, дийд_, 
   {{0x6d4c2292,0x58000075,0x00000000,0x00000000}},	//   ndaa, _چۈنك, --, --, 
   {{0x6d5c0280,0x69c82293,0x5ef40882,0x6d4c2294}},	//   _mnsa, _ihee, ्रम्_, idaa, 
   {{0xb9e02295,0x6d5c08cd,0x69c80270,0x6d4c0014}},	//   _ብቻ_, _lnsa, _hhee, hdaa, 
   {{0x69c80190,0xdce40a54,0x6d4c2296,0x6d5c2297}},	//   _khee, _lokā, kdaa, _onsa, 
   {{0x798002d0,0x250800f2,0x00000000,0x00000000}},	//   _xlmw, _آرای_, --, --, 
   {{0x65682298,0x69c800a3,0xdce400e2,0x2328009d}},	//   mjeh, _mhee, _nokā, _жоли_, 
   {{0x6d5c2299,0x6d4c229a,0x69c81368,0x6568229b}},	//   _ansa, edaa, _lhee, ljeh, 
   {{0x6d4c01f5,0xee140006,0xfe7801c6,0x69c801f4}},	//   fdaa, льтэ, хүн_, _ohee, 
   {{0x6568229c,0xc17403f9,0x2d9400ee,0x69c800ad}},	//   njeh, _fiɗa_, грус, _nhee, 
   {{0x1ae4229d,0xcd2402e8,0xa0a4030d,0x00000000}},	// [1dc0] возм, ъжте_, _шаид, --, 
   {{0xa3c01fe5,0x6d4c229e,0x69c8229f,0x3b84001f}},	//   ंति_, adaa, _ahee, ካሪዎች_, 
   {{0x3f9822a0,0x69c807ab,0x6d4c102c,0xd944010b}},	//   miru_, _bhee, bdaa, кежи, 
   {{0x3f98122d,0x6d4c0050,0x69c822a1,0xa91c02fb}},	//   liru_, cdaa, _chee, _alžb, 
   {{0x69c814cc,0xa3c00d35,0xdce40055,0xdcf422a2}},	//   _dhee, ंता_, _gokā, nkyč, 
   {{0x3f9822a3,0x69c822a4,0xa9240030,0x31b800bc}},	//   niru_, _ehee, _rožň, lézt_, 
   {{0x6d5c22a5,0x7bdc009a,0x8f980a7c,0xb59408ca}},	//   _ynsa, _iiru, ויסי, ликш, 
   {{0x7bdc22a6,0x46e40184,0x69c80072,0xb8f40055}},	//   _hiru, ндән_, _ghee, _kiṭī, 
   {{0x73d822a7,0x3f9822a8,0x999802b5,0x674401d3}},	//   ндир_, kiru_, nupō_, ítjü, 
   {{0x97000075,0x9694053f,0x7bdc22a9,0x3f9822aa}},	//   _ئېغى, _иреш, _jiru, jiru_, 
   {{0x6d4c0050,0x69c8009a,0x999800b0,0x00000000}},	//   ydaa, _yhee, hupō_, --, 
   {{0x7bdc22ab,0x6d4c22ac,0x705422ad,0x999802b1}},	//   _liru, xdaa, هنجا, kupō_, 
   {{0x68ec0789,0x7bdc01ab,0x93880798,0x1b1800eb}},	//   ñadi, _oiru, _оска_, ন্যে_, 
   {{0x7bdc22ae,0xafc41e0e,0x3f9822af,0xdce4005f}},	//   _niru, ايسى, giru_, _rokā, 
   {{0x6d4c22b0,0xcdd80640,0x00000000,0x00000000}},	//   tdaa, дња_, --, --, 
   {{0x7bdc22b1,0x672c05ce,0x2bc400e1,0xf1b80327}},	//   _airu, đaji, वतभा, buġa_, 
   {{0x6d4c22b2,0x7bdc22b3,0x69c822b4,0x00000000}},	// [1dd0] rdaa, _biru, _rhee, --, 
   {{0x09c81161,0x7bdc22b5,0x6d4c22b6,0x69c822b7}},	//   िष्य, _ciru, sdaa, _shee, 
   {{0x69c80457,0x7bdc22b8,0x70540133,0x00000000}},	//   _phee, _diru, _شنگا, --, 
   {{0x6d5c22b9,0x6d4c0050,0x6024013f,0xdce4150c}},	//   _unsa, qdaa, _kɔmp, _tokā, 
   {{0x7bdc22ba,0xec3400c8,0x69c80810,0x7648010e}},	//   _firu, _גאָר_, _vhee, _asdy, 
   {{0x7bdc22bb,0x69c80d8b,0xb7480150,0x00000000}},	//   _giru, _whee, кпіз_, --, 
   {{0x69c822bc,0x656800fb,0x6f040455,0xdcf4012d}},	//   _thee, tjeh, _mehc, łcąc, 
   {{0x6f04012c,0x69c80009,0x2b400036,0x00000000}},	//   _lehc, _uhee, lehc_, --, 
   {{0x7b080724,0x7bdc22bd,0xf7701893,0x3f980453}},	//   _östä, _yiru, _ڈال_, yiru_, 
   {{0xf77022be,0x67d422bf,0x6f04047e,0x656822c0}},	//   _وال_, _созу, _nehc, sjeh, 
   {{0x656822c1,0xdde0107d,0x00000000,0x00000000}},	//   pjeh, _žuži, --, --, 
   {{0x3f9822c2,0x21681188,0x208822c3,0xe6c001c8}},	//   wiru_, хими_, ейми_, _پڪڙي, 
   {{0x3f9822c4,0x31b80118,0x717000cf,0x00000000}},	//   tiru_, vézt_, تۇيا, --, 
   {{0xdca401d5,0x00000000,0x00000000,0x00000000}},	//   қази, --, --, --, 
   {{0xe1f013e1,0x7bdc22c5,0x3f9822c6,0x1b18015b}},	//   _است_, _riru, riru_, ন্ডে_, 
   {{0x3f9822c7,0x7f9400ac,0x999800b0,0xd00c00f1}},	//   siru_, _müqə, tupō_, _ځلي_, 
   {{0x7bdc22c8,0x3f9805ce,0xe0d81985,0x9a6815b4}},	// [1de0] _piru, piru_, _яви_, کمال_, 
   {{0x3f98094a,0x7bdc03f0,0x7b840131,0x999802b1}},	//   qiru_, _qiru, جارە, rupō_, 
   {{0x7bdc22c9,0xf3f40183,0x1d081b50,0xb8f400cd}},	//   _viru, _ইয়াৰ_, _пени_, _niṣī, 
   {{0x7bdc22ca,0x9f9407dd,0xdc6801c6,0x00000000}},	//   _wiru, _шықә, _замд_, --, 
   {{0xb8f40055,0x00000000,0x00000000,0x00000000}},	//   _aiṣī, --, --, --, 
   {{0x7bdc16b8,0x47300212,0x3dc0015d,0x5fb4190c}},	//   _uiru, йніс, lliw_, ृतिल, 
   {{0x8b000118,0x645c1f53,0xaa6401ee,0x00000000}},	//   ířec, åsin, _керһ, --, 
   {{0x29540408,0x00000000,0x00000000,0x00000000}},	//   _къур, --, --, --, 
   {{0x7dd800c8,0x644c00f3,0x18a422cb,0x660002d0}},	//   _aŭsk, _šair, _саам, _ewlk, 
   {{0x88380375,0xa2640208,0x00000000,0x00000000}},	//   _אתמו, _trộ, --, --, 
   {{0x4ebc03f4,0x8778008f,0xe78400d8,0x717400ae}},	//   _আল্ল, _ראבי, _туѓо, لهدا, 
   {{0x6f04014f,0x00000000,0x00000000,0x00000000}},	//   _sehc, --, --, --, 
   {{0x3dc022cc,0x7dd8010f,0x3448013e,0x00000000}},	//   dliw_, _eŭsk, _рӯйи_, --, 
   {{0x1b18000e,0x823022cd,0x8474001f,0x6f04014f}},	//   ন্তে_, جریا, ራክሽን_, _qehc, 
   {{0xa3c010f4,0x6f0422ce,0x6024016b,0x3dc00142}},	//   ंतर_, _vehc, _wɔmp, fliw_, 
   {{0x7de402dd,0x00000000,0x00000000,0x00000000}},	//   сірд, --, --, --, 
   {{0xcb1806ed,0x6f0422cf,0xf414010f,0x00000000}},	// [1df0] еќе_, _tehc, יפּ_, --, 
   {{0x3dc022d0,0x7ff40c8b,0x00000000,0x00000000}},	//   aliw_, _اسيا, --, --, 
   {{0xe8dc00dc,0xe9b40124,0x00000000,0x00000000}},	//   यश्च, абжь, --, --, 
   {{0x7f9406be,0x00000000,0x00000000,0x00000000}},	//   _rüqə, --, --, --, 
   {{0x660002b9,0x6a840022,0xc77000db,0x00000000}},	//   _swlk, ылҧа, йткө, --, 
   {{0x6b8002e3,0x2d88020c,0x5c3400df,0x7ac40408}},	//   ịgbo, lhae_, _דרשן_, _ӳсте, 
   {{0x2d880069,0xdb1000e4,0xe570007b,0x00000000}},	//   ohae_, _ägár, قطة_, --, 
   {{0x2d8822d1,0xb8f400b8,0x87e401a9,0x69c40150}},	//   nhae_, _viṣī, _бюже, _төзб, 
   {{0xb81c202e,0x872422d2,0x64a422d3,0xa3c003e5}},	//   _नियम_, _معام, рапа, ंतल_, 
   {{0x65141a90,0x00000000,0x00000000,0x00000000}},	//   _چوائ, --, --, --, 
   {{0x651422d4,0x2d8822d5,0x6eb000c5,0xc6780023}},	//   _نوائ, khae_, _आँगु, ክራሲያ_, 
   {{0x672c05ce,0x00000000,0x00000000,0x00000000}},	//   đaju, --, --, --, 
   {{0xa4d400d4,0xb63c0092,0x9d4400e5,0x00000000}},	//   _тоді, _ሰርተፊ, یئرن, --, 
   {{0x645822d6,0x248c01d4,0x2d8800b0,0x00000000}},	//   _irwi, mzem_, ehae_, --, 
   {{0x8fa022d7,0x81e0015b,0xb804002b,0x1d9422d8}},	//   царе, _পৌর_, _kiṃś, араё, 
   {{0x6458033f,0xb5d001ec,0x00000000,0x00000000}},	//   _krwi, _ﺗﺎﻟﻌ, --, --, 
   {{0x71240137,0x9b0407a5,0x64580332,0x248c22d9}},	// [1e00] _ارىل, изад, _jrwi, nzem_, 
   {{0x2d8800fb,0x248c22da,0xee3801f0,0x00000000}},	//   ahae_, izem_, ънӣ_, --, 
   {{0x81e400bd,0x590800a7,0x00000000,0x00000000}},	//   মীর_, веем_, --, --, 
   {{0x2d8822db,0x1c1c044b,0x00000000,0x00000000}},	//   chae_, _पिपल_, --, --, 
   {{0x98a422dc,0xfaf801d3,0x01e00150,0x00000000}},	//   шиде, _مہذب_, _ﺍﻟﻔﺨ, --, 
   {{0x248c22dd,0xab0822de,0xc7a000a7,0x7c2422df}},	//   dzem_, _متفق_, оичк, muir, 
   {{0xdab822e0,0x645822e1,0x644c00c0,0x00000000}},	//   _شهرت_, _arwi, _šaip, --, 
   {{0x27e80084,0x4aac000d,0x645822e2,0x00000000}},	//   ̭ani_, _जुटव, _brwi, --, 
   {{0xdef80023,0xd3a40835,0x94a802e8,0x94840166}},	//   ዋሩን_, ироп, ътка_, рыйд, 
   {{0x7e7c0649,0x64582182,0x00000000,0x00000000}},	//   kyrp, _drwi, --, --, 
   {{0x0cc022e3,0x7c2422e4,0x672c110c,0xbf2000c5}},	//   _शर्म, huir, đajt, _बाड़न_, 
   {{0x7c240841,0x6458010a,0x9fa40032,0x45d41884}},	//   kuir, _frwi, ҡырҙ, _ﺟﺎﻳﻼ, 
   {{0x636c00d2,0x248c0034,0x7c240841,0x53a40117}},	//   _lúny, czem_, juir, _кадб, 
   {{0x7c2422e5,0x4ea422e6,0x833000c0,0x00000000}},	//   duir, арба, _мніх, --, 
   {{0x2d8822e7,0xcd041d0f,0x00000000,0x00000000}},	//   thae_, ичаи, --, --, 
   {{0x7c2422e8,0x2d8800d8,0x518400f0,0x00000000}},	//   fuir, uhae_, _њука, --, 
   {{0x427c0020,0x70580b2c,0xc4d0008f,0x61ec0171}},	// [1e10] _ጦርነት_, _сапр_, ַגע_, _čali, 
   {{0x25a81821,0x636c03b2,0xc25001d3,0x1b180154}},	//   čali_, _búny, _اکیڈ, ন্সে_, 
   {{0x2d880393,0xa91c01f1,0x9be801e0,0x7f3c05d0}},	//   phae_, _dlžn, _ҡырҡ_, _יעזו, 
   {{0x79a422e9,0xac1800d6,0xf99022ea,0xd5a422eb}},	//   орче, _йому_, وبن_, _رف_, 
   {{0x7c240276,0x1c1c0037,0x00000000,0x00000000}},	//   cuir, _पियल_, --, --, 
   {{0x248c0fb7,0x98f40075,0x636c01e1,0x6b74036b}},	//   vzem_, لغۇچ, _fúny, _улгу, 
   {{0x636c22ec,0xff180375,0x7f3c010f,0x48f400bc}},	//   _gúny, בקות_, דעוו, उँदो_, 
   {{0xd364034c,0x248c00f7,0xa9a40050,0xefe402d3}},	//   _בه_, tzem_, _امرى, ማማዕ_, 
   {{0xe3b822ed,0xd764036b,0xb80400dc,0x00000000}},	//   лби_, _گنلی, _viṃś, --, 
   {{0x64a422ee,0x248c22ef,0xa068036b,0x442c0051}},	//   _қала, rzem_, қага_, _vqg_, 
   {{0xe29822f0,0x248c1b7a,0x7c240276,0x00000000}},	//   уан_, szem_, zuir, --, 
   {{0xa06822f1,0xbb240150,0x69ac01f9,0xc1780166}},	//   гама_, _ﹼﺴﻡ_, जवटी, рҗи_, 
   {{0x64581389,0x645c22f2,0x555022f3,0xe4540209}},	//   _urwi, æsid, _رپور, _ыкды, 
   {{0x64480368,0xdd140432,0x63840209,0x00000000}},	//   mwei, _bäşd, _ыгла, --, 
   {{0x6448097d,0xfe4401e0,0x5ba8023b,0x048000cd}},	//   lwei, әнғо, ҳкам_, _ākṛt, 
   {{0x7c2422f4,0x64480295,0xb3240327,0xdcb015bf}},	//   tuir, owei, _འཐོང_, كىز_, 
   {{0x644822f5,0x9d4401e0,0x05dc000d,0x00000000}},	// [1e20] nwei, _һенд, _पूछब, --, 
   {{0x7c2422f6,0xdca422f7,0x2eec013f,0x1e8400d8}},	//   ruir, _ҳами, ɛefo_, _глом, 
   {{0x644822f8,0x7c2408ad,0x9d4422f9,0x5398008d}},	//   hwei, suir, _ленд, ניעו, 
   {{0x2d980048,0xdca422fa,0x6448043b,0x588422fb}},	//   _gmse_, _гами, kwei, йыла, 
   {{0x7c2422fc,0x4f840014,0x2d9822fd,0x48100212}},	//   quir, _ضایہ, _төрө_, зміс, 
   {{0x644822fe,0xb324031c,0xacb000d1,0x3e58013a}},	//   dwei, _འཐེང_, _غەلب, _kčt_, 
   {{0xd5b822ff,0x2d9803d4,0x94100213,0x2b9001d5}},	//   лси_, _ymse_, ədək_, _تیلس, 
   {{0x644803fa,0x3e58033b,0xa3800254,0x00000000}},	//   fwei, _mčt_, õõnd, --, 
   {{0x12e40046,0x64482300,0x3e58033b,0xe9701075}},	//   йінг, gwei, _lčt_, _تۇند, 
   {{0x6ac4000f,0xdb10013d,0x675400e5,0x758801e2}},	//   _útfû, _ägär, _وینس_, دۍچې_, 
   {{0x3e58033b,0xd4e400a7,0x588401ec,0x00000000}},	//   _nčt_, _люли, _тыңа, --, 
   {{0x644803fa,0x43d001d9,0x7a1c054e,0x00000000}},	//   bwei, _ہٲنز, mătă, --, 
   {{0x657c0267,0x00000000,0x00000000,0x00000000}},	//   öshe, --, --, --, 
   {{0x3e58033b,0x2d982301,0x2ee401bf,0x00000000}},	//   _bčt_, _smse_, ølf_, --, 
   {{0x7a1c084c,0x8778008d,0x72040bbf,0x31340137}},	//   nătă, נאלי, _بوعم, _дейр, 
   {{0xad242302,0x3e580100,0x00000000,0x00000000}},	//   تىرى, _dčt_, --, --, 
   {{0xab740120,0x48f400bc,0x6fb42303,0xc9840022}},	// [1e30] огаш, उँसो_, _ومبا, ҩуеи, 
   {{0x3e580699,0xdd14013d,0xdce40064,0x00000000}},	//   _fčt_, _täşd, _mokę, --, 
   {{0x64481a80,0x7ff42304,0x00000000,0x00000000}},	//   zwei, _وسیا, --, --, 
   {{0xf1c812eb,0x2d98009a,0x6448152c,0x00000000}},	//   रतिन, _umse_, ywei, --, 
   {{0x2bd80133,0x19c01de6,0x64482305,0xe5ac0241}},	//   _ناسک_, фәрг, xwei, _ìbẹ́, 
   {{0x27e02306,0xb8d406c2,0x26c00135,0x00000000}},	//   öhn_, ستنش, żhom_, --, 
   {{0xf1c808e6,0x39a401d9,0x870400db,0xff18011a}},	//   रतान, _کینہ, _ۇبال, זקות_, 
   {{0x64482307,0xe5782308,0xdaa02309,0x6e34000d}},	//   twei, рзи_, _تەمپ, itzb, 
   {{0xa8a4168d,0x6448230a,0xf9d400a8,0xa3e806ed}},	//   _بڵاو, uwei, _хотэ, јдоа_, 
   {{0x64481c1b,0xe3b001d5,0x00000000,0x00000000}},	//   rwei, برب_, --, --, 
   {{0x6448230b,0x7a1c0276,0x61440153,0x2168146a}},	//   swei, cătă, оена, аини_, 
   {{0xc1740198,0x64a400d1,0x64480036,0x00000000}},	//   _kiɗi_, _қаһа, pwei, --, 
   {{0x3e5802e2,0x9fc80353,0xc4c401f7,0x27fc0327}},	//   _sčt_, игма_, _اتاو, npwn_, 
   {{0xf1b8025c,0x00000000,0x00000000,0x00000000}},	//   rrġa_, --, --, --, 
   {{0xaf98230c,0xf644010a,0x00000000,0x00000000}},	//   стях_, _яхăн, --, --, 
   {{0xa0a4230d,0x3e58007f,0xa3c0230e,0x00000000}},	//   _майд, _včt_, ंतक_, --, 
   {{0xf1a804d3,0xdc6801c6,0x00000000,0x00000000}},	// [1e40] _داوه_, шаад_, --, --, 
   {{0x7dd800c8,0x3e5802bd,0x0b40024c,0x00000000}},	//   _aŭst, _tčt_, мнун, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5f44230f,0x61e400d2,0x7a1c0356,0xd238010f}},	//   _انگل, _éhlu, vătă, יגעל, 
   {{0xa3b80490,0x00000000,0x00000000,0x00000000}},	//   चवा_, --, --, --, 
   {{0x9af4007b,0x0f3400df,0x00000000,0x00000000}},	//   _ذكرت, ַרפט_, --, --, 
   {{0x3c340139,0x00000000,0x00000000,0x00000000}},	//   läv_, --, --, --, 
   {{0x7a1c0356,0xdb1c01e7,0x05b41541,0xd90c029e}},	//   rătă, ilpí, يديت_, _شیت_, 
   {{0x13682310,0x38c801d3,0x00000000,0x00000000}},	//   ашни_, _طاری_, --, --, 
   {{0xe7b000cf,0x00000000,0x00000000,0x00000000}},	//   _كۅند, --, --, --, 
   {{0x658400ae,0x00000000,0x00000000,0x00000000}},	//   áthó, --, --, --, 
   {{0x25a001c7,0x506407a5,0x02a000c7,0x00000000}},	//   éhlt_, отга, ьрым, --, 
   {{0x49082311,0xf7780327,0xb6240220,0x00000000}},	//   ारतो_, _koħ_, _ﺫﻩ_, --, 
   {{0xb3240dd4,0x00000000,0x00000000,0x00000000}},	//   _འཐིང_, --, --, --, 
   {{0xb8cc031c,0x6e3401bf,0xca3802dd,0x00000000}},	//   _པཨ_, utzb, _ﻓﻤﺎ_, --, 
   {{0x3f740166,0x30142312,0x257001ef,0x00000000}},	//   _aşuı_, _едир, _bály_, --, 
   {{0x392c001f,0xe570008f,0xd7c80a59,0x2610012d}},	// [1e50] ተዳደራ, ײַן_, िताच, _धौनी_, 
   {{0xc1740198,0xba740214,0x00000000,0x00000000}},	//   _riɗi_, ژانت, --, --, 
   {{0x9ff400f1,0xbfb400ae,0x00000000,0x00000000}},	//   _وزیږ, _تحيت, --, --, 
   {{0xb9e80046,0x81e402f5,0x4c80036b,0x00000000}},	//   іміз_, মীক_, _قیزق, --, 
   {{0xa2c0190c,0x4ab401f9,0x00000000,0x00000000}},	//   _रुन्, _अडकव, --, --, 
   {{0x36e80145,0x00000000,0x00000000,0x00000000}},	//   يرىپ_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe7942313,0x2bd82314,0x00000000,0x00000000}},	//   _کارک, भगवा, --, --, 
   {{0x69d81ccd,0x68e80327,0x00000000,0x00000000}},	//   mmwe, _iged, --, --, 
   {{0x69d82315,0x2328041b,0xe3b0007b,0x00000000}},	//   lmwe, љони_, عرة_, --, 
   {{0x27ec2316,0xd5a40efc,0x69d80549,0x00000000}},	//   _huen_, _کلنی, omwe, --, 
   {{0x27ec0066,0x68e80327,0x69d802e2,0xdee40092}},	//   _kuen_, _jged, nmwe, ማዋን_, 
   {{0xc0bc0020,0x27e42317,0x290c01e0,0x27ec005a}},	//   _ተቋም_, _kiln_, _meea_, _juen_, 
   {{0x221400a7,0x201c2318,0x330800db,0x3c3401e3}},	//   _ефир, čti_, _ۇيۇپ_, väv_, 
   {{0x657804fe,0x63a02319,0x68e8231a,0xe8e405d9}},	//   _kowh, miln, _oged, _ڄڻ_, 
   {{0x68e8231b,0x657801d9,0x63a0231c,0x27ec06af}},	//   _nged, _jowh, liln, _ouen_, 
   {{0x27ec05f5,0x6280231d,0x657802b1,0x6b80063f}},	// [1e60] _nuen_, lylo, _mowh, _ịgak, 
   {{0x63a0231e,0x68e8231f,0x847402d3,0x69d801f5}},	//   niln, _aged, ራርሓን_, emwe, 
   {{0x5ed8015b,0x62802320,0xaac40214,0x27ec2321}},	//   _ব্রে, nylo, وتمن, _auen_, 
   {{0x27ec2322,0x290c00a8,0x63a02323,0x65781a7b}},	//   _buen_, _ceea_, hiln, _nowh, 
   {{0x7d042324,0x63a02325,0x27e400a2,0x290c2326}},	//   mbis, kiln, _biln_, _deea_, 
   {{0x27ec0323,0x26c4038e,0x62802327,0x69d82328}},	//   _duen_, _bylo_, kylo, amwe, 
   {{0x63a02329,0x68ec232a,0x290c0076,0x27ec005a}},	//   diln, žada, _feea_, _euen_, 
   {{0x7d04232b,0xb6080316,0x6578232c,0x27ec00db}},	//   nbis, jišť, _cowh, _fuen_, 
   {{0x27ec00e8,0x7d04232d,0xe3b8002d,0xb6080c5e}},	//   _guen_, ibis, rrűn_, dišť, 
   {{0x63a0232e,0xb5fc0135,0x7c24232f,0x7d04020c}},	//   giln, _arġe, irir, hbis, 
   {{0x27ec152d,0x7c2407d6,0x7d042330,0x00000000}},	//   _zuen_, hrir, kbis, --, 
   {{0x27ec2331,0x7c242332,0x9594001f,0x6578010e}},	//   _yuen_, krir, ዎቻችን_, _gowh, 
   {{0x63a02333,0x7d042334,0x6280002e,0x26c40200}},	//   biln, dbis, aylo, _zylo_, 
   {{0x62802335,0x7c242336,0x7d042337,0x00000000}},	//   bylo, drir, ebis, --, 
   {{0x43380302,0x69c0022c,0xbb60001f,0x62800210}},	//   _העוב, _íleg, _ለማቋቋ, cylo, 
   {{0x7d041089,0x7c242338,0x3eac02f0,0x00000000}},	//   gbis, frir, _šitý_, --, 
   {{0x7c242339,0x0ae800db,0xc0bc0092,0x3d94233a}},	// [1e70] grir, مراي_, _ተቋሙ_, хитр, 
   {{0x290c233b,0xefe40023,0x7d04058a,0x00000000}},	//   _seea_, ዛማዲ_, abis, --, 
   {{0x7d0422a9,0x7c24233c,0x27ec0a40,0x48a81945}},	//   bbis, arir, _suen_, әтем_, 
   {{0x290c01ee,0xfaa40e46,0x776802d0,0x24880135}},	//   _qeea_, хшун, _andx, _żamm_, 
   {{0x27ec233d,0x17240156,0x6280233e,0x7c2407ea}},	//   _quen_, _རྐངམ_, zylo, crir, 
   {{0x27ec01c7,0x6578233f,0xf7940006,0x0058011a}},	//   _vuen_, _sowh, начэ, פשות_, 
   {{0x63a02340,0x62800076,0x657802b1,0x69d8009a}},	//   viln, xylo, _powh, pmwe, 
   {{0x68e82341,0x63a00034,0x27ec2342,0x0ef8012c}},	//   _uged, wiln, _tuen_, ्रुस_, 
   {{0x63a02343,0x26c40042,0xb60800d7,0x00000000}},	//   tiln, _wylo_, višť, --, 
   {{0x62802344,0xb370001f,0x7d04002f,0x00000000}},	//   tylo, _ብቻውን_, zbis, --, 
   {{0x63a00fb7,0xa91c110c,0xc7f400b5,0xe3b001d3}},	//   riln, _alži, lパ_, ٹرک_, 
   {{0x7c242345,0xa0a42346,0xfe782347,0x00000000}},	//   yrir, дамд, җүм_, --, 
   {{0x63a02348,0x31b802fb,0xb16400fb,0x25ac2349}},	//   piln, nézy_, хняһ, mnel_, 
   {{0x98a404fe,0x7dd80115,0x7c24234a,0x63a0234b}},	//   ngoā_, _aŭsp, vrir, qiln, 
   {{0xe2981def,0x7c2402d1,0x7f900166,0x2eb4234c}},	//   _фай_, wrir, _näqe, естс, 
   {{0x25ac234d,0x7c24234e,0x31680036,0xb5fc0135}},	//   nnel_, trir, _gnaz_, _urġe, 
   {{0x7d04234f,0x7c2405b8,0x6f180332,0x00000000}},	// [1e80] rbis, urir, éacó, --, 
   {{0x7c242350,0x9f042351,0x2000033f,0x00000000}},	//   rrir, _تودو, mpki_, --, 
   {{0x68ec0030,0x7c24000d,0x00000000,0x00000000}},	//   ľadn, srir, --, --, 
   {{0x7c240801,0xd00c2352,0x18a4005b,0x00000000}},	//   prir, _حلی_, маем, --, 
   {{0x7f900724,0x38600162,0x00000000,0x00000000}},	//   _täqd, íir_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb33c0327,0x76b400c7,0x00000000,0x00000000}},	//   jiħa, хәац, --, --, 
   {{0x25ac2353,0xdb1c0200,0x00000000,0x00000000}},	//   gnel_, kopë, --, --, 
   {{0x93242354,0xe97000cf,0x73c4010b,0x31b800d0}},	//   وردن, _حۇند, нәке, cézy_, 
   {{0x25ac0548,0xd78800f2,0x00000000,0x00000000}},	//   anel_, _بخرم_, --, --, 
   {{0xa2c01971,0x32180232,0x00000000,0x00000000}},	//   _रुद्, éry_, --, --, 
   {{0x54680024,0x00000000,0x00000000,0x00000000}},	//   _маем_, --, --, --, 
   {{0xc0582355,0x53b4036b,0x31680208,0xa9d400d1}},	//   мір_, _оғир_, _vnaz_, ﯘﺭﯨﻴ, 
   {{0x0ef82356,0x00000000,0x00000000,0x00000000}},	//   ्रेस_, --, --, --, 
   {{0xf40000eb,0x00000000,0x00000000,0x00000000}},	//   _এটির_, --, --, --, 
   {{0xdb1c180f,0x00000000,0x00000000,0x00000000}},	//   lopè, --, --, --, 
   {{0xcee801d9,0x7de40220,0xfa50001f,0x0b840014}},	// [1e90] _وردن_, тірд, _ዘላለማ, وٝری_, 
   {{0xdb1c0066,0xc0840092,0xf4000154,0xc904012d}},	//   nopè, ሮግራሙ_, _এটার_, शर्म_, 
   {{0x25ac2357,0x00000000,0x00000000,0x00000000}},	//   ynel_, --, --, --, 
   {{0x68ec01f1,0x31b82358,0x6f142359,0x00000000}},	//   ľado, tézy_, lazc, --, 
   {{0x68ec0232,0x6d4c235a,0x3ea0001f,0xd9141bf4}},	//   žado, meaa, _ፍልሰታ_, ريوش_, 
   {{0x6d4c235b,0x7b64235c,0x4df00b26,0x00000000}},	//   leaa, _итсе, _अढाई_, --, 
   {{0x80c8015b,0xb9c400cf,0x00000000,0x00000000}},	//   রেপ্, رقۇي, --, --, 
   {{0x25ac0dd4,0xc8640801,0x6d4c235d,0x2d88016b}},	//   unel_, _отзи, neaa, nkae_, 
   {{0x3834235e,0xa2c001f9,0x00000000,0x00000000}},	//   _интр, रॅन्, --, --, 
   {{0xbab01c82,0x1828107f,0xe298026a,0xdb1c00db}},	//   _কৰিছ, _رقمی_, зао_, gopè, 
   {{0x25ac235f,0x2d88020b,0x6d4c023a,0xd5ac01d3}},	//   pnel_, kkae_, keaa, شفی_, 
   {{0x68f800d2,0x60242360,0x09bc00cc,0x30740023}},	//   ncwd, ндма, েদকা, _ኪመጽእ_, 
   {{0x80c800bd,0x6d4c2301,0x1b180011,0x1fb406ed}},	//   রেন্, deaa, ন্টে_, есвр, 
   {{0xdb1c02d3,0xdfd02361,0xe2982362,0xa91c00ef}},	//   ropë, ايس_, _нал_, _ilžu, 
   {{0xdd902363,0x4dc40131,0x1ea82364,0x00000000}},	//   هوس_, ﯩﻜﯩﻨ, ساسي_, --, 
   {{0x0ef801ad,0x00000000,0x00000000,0x00000000}},	//   ्रॉस_, --, --, --, 
   {{0xdb1c0085,0x00000000,0x00000000,0x00000000}},	// [1ea0] lopé, --, --, --, 
   {{0x5bc42365,0x6f1402ea,0xa3c02366,0x68ec1d55}},	//   رقال, cazc, ूति_, žadl, 
   {{0x6d4c01c7,0x8b8400db,0x8b2000d8,0x00000000}},	//   beaa, راكۅ, удхе, --, 
   {{0x3804013e,0x00000000,0x00000000,0x00000000}},	//   водҳ, --, --, --, 
   {{0x4c640873,0x645c0008,0xa3c0146b,0x1ba801d3}},	//   _зиян_, æsil, ूता_, _فاسٹ_, 
   {{0x50180375,0xdb1c2367,0x00000000,0x00000000}},	//   לונו, kopé, --, --, 
   {{0x5bbc2368,0x00000000,0x00000000,0x00000000}},	//   ्तीव, --, --, --, 
   {{0x09e02369,0xd498013e,0xe3b8000f,0x00000000}},	//   _босн, зро_, brűk_, --, 
   {{0x73d8236a,0xdb1c00db,0x46e401e0,0x34940064}},	//   мдир_, topè, мдән_, тапр, 
   {{0x96941142,0xb5fc031c,0x2cec000d,0xd2540066}},	//   _преш, _erġa, _झल्ल_, فیتش_, 
   {{0xdb1c1497,0x6d4c0083,0xf194236b,0x932401d5}},	//   ropè, yeaa, винь, ورگن, 
   {{0xdce402e2,0x0ef805d7,0xdb0c236c,0x81b40154}},	//   _ankč, ्र्स_, _akbü, _জীব_, 
   {{0x5fd0007d,0x6d4c0076,0x00000000,0x00000000}},	//   _दीहल, veaa, --, --, 
   {{0x73c401e0,0x6d4c0066,0x733410de,0x3da40107}},	//   _шәйе, weaa, _شىبا, ҳруб, 
   {{0x6f14236d,0xdb1c003e,0x7c2800b8,0x00000000}},	//   razc, copé, _ādra, --, 
   {{0x8d74236e,0xdb0c00e5,0x2fdc0153,0x00000000}},	//   رازا, _okbó, _žygį_, --, 
   {{0xb81c16da,0x6fb801b9,0x00000000,0x00000000}},	// [1eb0] _निगम_, _огир_, --, --, 
   {{0x6d4c08e3,0x764801bf,0x7f94074d,0x00000000}},	//   seaa, _opdy, _баьх, --, 
   {{0x6d4c0641,0x6db4236f,0xf7780327,0x7dfc02e2}},	//   peaa, _айну, _jiħu_, _pčse, 
   {{0xa91c151c,0xdeb00220,0x99980100,0x00000000}},	//   _možg, _тұсы, nspň_, --, 
   {{0x39442370,0x00000000,0x00000000,0x00000000}},	//   _dbms_, --, --, --, 
   {{0x39440280,0x386401a6,0x1864119e,0x39b80100}},	//   _ebms_, _drmr_, таши_, včse_, 
   {{0x97301b2c,0x00000000,0x00000000,0x00000000}},	//   شکلا, --, --, --, 
   {{0x7f90013d,0x9c8400ef,0x80c407b6,0x00000000}},	//   _mäqa, _fočē, रथमे, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb1c2371,0xe1f80137,0xe7182372,0x00000000}},	//   topé, мго_, _آيات_, --, 
   {{0xe29802ac,0x05440323,0xa5340108,0x00000000}},	//   фан_, _зүйл_, _анеч, --, 
   {{0xdb1c2373,0x709c0882,0xe4d800c6,0xd24c0592}},	//   ropé, _śikṣ, _قوات_, آنَ_, 
   {{0x8edc03f4,0x00000000,0x00000000,0x00000000}},	//   _ব্লগ, --, --, --, 
   {{0xb8040055,0x764800a2,0x00000000,0x00000000}},	//   _akṛś, _ypdy, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdcb02374,0x3bd40139,0x32d40024,0x00000000}},	//   لىز_, däqa_, _сціс, --, 
   {{0xa91c04b9,0x5f040801,0x67202375,0x1be8013e}},	// [1ec0] _možd, _изпа, _odlj, ддаи_, 
   {{0x8c402376,0x60d400b5,0x1e840fc0,0x7f900166}},	//   рефе, _izym, _алом, _fäqa, 
   {{0xdee42377,0x00000000,0x00000000,0x00000000}},	//   _јони, --, --, --, 
   {{0x984800d4,0xdca4022e,0x00000000,0x00000000}},	//   дяка_, _аами, --, --, 
   {{0x17a0013e,0x46a4000d,0x2ce4022e,0xe9940066}},	//   ақаҳ, _केबह, _бўёв, دهنگ, 
   {{0x7f900bc9,0x00000000,0x00000000,0x00000000}},	//   _yäqa, --, --, --, 
   {{0x98b003ee,0x41b411a0,0x595400f3,0xd938014b}},	//   ıyı_, ीवास, _иђах, _очаш_, 
   {{0x3254013e,0xceb000d9,0x00000000,0x00000000}},	//   ҳвор, ייו_, --, --, 
   {{0x74140244,0x645c007c,0xddcc00e5,0x85700150}},	//   دوخا, åsip, nybű, рлых, 
   {{0x79802378,0xb9ec02d3,0x27f80066,0xa91c0427}},	//   _homw, _ኔረ_, _ésna_, _požg, 
   {{0x79800925,0x60d42379,0x00000000,0x00000000}},	//   _komw, _azym, --, --, 
   {{0x28d80050,0x316c237a,0x8230158b,0x00000000}},	//   बेकि, ñez_, گریا, --, 
   {{0x79800925,0x60d4033f,0x24940014,0x9474007b}},	//   _momw, _czym, _مۅٹھ_, _جداا, 
   {{0x79800925,0x9f5002e2,0x03a0237b,0x8230085b}},	//   _lomw, _juyè_, _кичо, دریا, 
   {{0xdb0400bc,0x5274010b,0xca6801ec,0xa3c003ce}},	//   ámýc, _шуду, гiнi, ूतर_, 
   {{0xa91c0232,0x7980237c,0x31341d0f,0x7f900139}},	//   _kože, _nomw, _сеир, _väqa, 
   {{0xebd80a31,0xa91c237d,0x7aec016b,0x7f900139}},	// [1ed0] едаш_, _jože, ɛntɛ, _wäqa, 
   {{0xa91c04b9,0x4174237e,0xad4000db,0x00000000}},	//   _može, _ماۋس, _گۉرۉ, --, 
   {{0x7980237f,0xa91c0e3c,0xefe4001f,0x7ac40006}},	//   _bomw, _lože, ዛኛው_, асце, 
   {{0x79802380,0xaa9000c7,0x60d4010b,0x7bc002d2}},	//   _comw, аҳҳә, _yzym, _ímun, 
   {{0x68440019,0xa91c08a4,0x6d5c2381,0x79802382}},	//   унла, _nože, _iasa, _domw, 
   {{0x6d5c2383,0x79800295,0x00000000,0x00000000}},	//   _hasa, _eomw, --, --, 
   {{0x6d5c2384,0xe5a42385,0x79800198,0xa7fc002d}},	//   _kasa, лики, _fomw, _grűn, 
   {{0xe4581515,0x79800295,0xa91c0306,0x5550185e}},	//   ежи_, _gomw, _bože, مپىر, 
   {{0x69c80770,0xa91c0063,0xa3e82386,0xd5440108}},	//   _ikee, _vožd, ндиа_, упые_, 
   {{0x6d5c2387,0x4908038e,0x2bd8028a,0x79801813}},	//   _lasa, ारको_, _बीमा, _zomw, 
   {{0x79801813,0x69c82388,0x60d42389,0x6d5c238a}},	//   _yomw, _kkee, _szym, _oasa, 
   {{0x63880051,0x00000000,0x00000000,0x00000000}},	//   _bênê, --, --, --, 
   {{0xf48403f6,0x643800df,0x00000000,0x00000000}},	//   _вујн, _נײַג, --, --, 
   {{0x443c238b,0x6d5c238c,0x6458238d,0x1ec800db}},	//   mtu_, _aasa, _iswi, елги_, 
   {{0x69c8238e,0xa91c238f,0xaf9800d4,0x5398011a}},	//   _okee, _zože, ттях_, _ריצו, 
   {{0x5bbc1161,0x69c80070,0x5de42390,0x2d942391}},	//   ्त्व, _nkee, ужба, арус, 
   {{0x7980004c,0x3ba4013e,0x70540354,0x00000000}},	// [1ee0] _romw, алаҳ, _кĕте, --, 
   {{0x443c2392,0x69c82393,0x6d5c2394,0x79802395}},	//   itu_, _akee, _easa, _somw, 
   {{0x6d5c2396,0x443c2397,0x79801813,0x00000000}},	//   _fasa, htu_, _pomw, --, 
   {{0x6d5c2398,0x79800455,0x4e78010f,0x6458012d}},	//   _gasa, _qomw, _נאכצ, _oswi, 
   {{0x443c2399,0x8eb004fb,0x79800099,0x6c74239a}},	//   jtu_, _نمیش, _vomw, _курх, 
   {{0x6d5c239b,0x69c8239c,0x443c0c67,0x79800925}},	//   _zasa, _ekee, dtu_, _womw, 
   {{0x6d5c239d,0x645802c4,0x443c239e,0x7980239f}},	//   _yasa, _aswi, etu_, _tomw, 
   {{0x6d5c0a81,0xa91c041a,0x69c8005a,0xd7f000ae}},	//   _xasa, _pože, _gkee, _هكر_, 
   {{0x38c8168d,0x7bdc23a0,0x94741c36,0xf8b004d3}},	//   _شاری_, _khru, ادعا, _بکا_, 
   {{0xa91c0010,0xdb1c0518,0x44940108,0xb4c406b1}},	//   _vože, kopí, увью_, _एडी_, 
   {{0x443c23a1,0x645807a9,0x3f980003,0x00000000}},	//   atu_, _eswi, dhru_, --, 
   {{0xa91c151c,0xa6942377,0x00000000,0x00000000}},	//   _tože, _труј, --, --, 
   {{0x443c23a2,0x80c80154,0x00000000,0x00000000}},	//   ctu_, রেস্, --, --, 
   {{0xa3c000cd,0x94a801af,0xc62400cc,0x00000000}},	//   ूतः_, _отһа_, _মহতা_, --, 
   {{0x6d5c23a3,0xcdd823a4,0x27e80268,0x02f800d9}},	//   _pasa, ења_, ìani_, _אלומ, 
   {{0x6d5c23a5,0x64580368,0x68ec0024,0x46a400c5}},	//   _qasa, _yswi, žadi, _कइसह, 
   {{0x6d5c23a6,0x7bdc23a7,0xed5800fb,0xc98400d1}},	// [1ef0] _vasa, _bhru, ноң_, һуди, 
   {{0x6d5c23a8,0x7bdc0bec,0x69c80731,0x6d9000cc}},	//   _wasa, _chru, _skee, _gåan, 
   {{0x443c0323,0xdeb0005e,0x7bdc23a9,0xaa5423aa}},	//   ztu_, _дұры, _dhru, рвеш, 
   {{0x443c23ab,0x6d5c14d0,0x7bdc23ac,0xfc3001d3}},	//   ytu_, _uasa, _ehru, تحہ_, 
   {{0x443c23ad,0x0c84010b,0x7bdc01e7,0x9d180115}},	//   xtu_, _сынм, _fhru, _בורט, 
   {{0x8ae41c26,0x7bdc23ae,0x645804cc,0xab940220}},	//   _бібл, _ghru, _rswi, _тигі, 
   {{0xaab8166d,0x443c0135,0xf60801c8,0x00000000}},	//   _आशिक, wtu_, هتيه_, --, 
   {{0x443c23af,0x7bdc02fd,0x6458003e,0xd6cc00c6}},	//   ttu_, _zhru, _pswi, بقى_, 
   {{0x443c23b0,0xa91c151c,0xe3b8072c,0xdb1c00d7}},	//   utu_, _tožb, кби_, zopí, 
   {{0x443c23b1,0x1c1c00e1,0x645800b5,0x67d40c75}},	//   rtu_, _पिघल_, _vswi, _тозу, 
   {{0x659423b2,0xe10823b3,0x765c00e4,0xa2280395}},	//   _кажу, кенд_, _áryp, ъжна_, 
   {{0x645823b4,0x2934008f,0xc0e0010c,0x926000d1}},	//   _tswi, סאָן_, _ዑመር_, زگىم, 
   {{0x645800ec,0x3f9823b5,0x20b823b6,0x443c23b7}},	//   _uswi, thru_, тынь_, qtu_, 
   {{0xa2e40e26,0x232800d6,0xd0040d6f,0xaf3401d9}},	//   _колд, _роки_, рере_, ٝرِت, 
   {{0xe29823b8,0xd36c009f,0x29d4007c,0x00000000}},	//   _шак_, _زهي_, våan_, --, 
   {{0x7bdc23b9,0xd24c038b,0x80c80eac,0xdb1c23ba}},	//   _shru, _آني_, রেষ্, ropí, 
   {{0xd00c23bb,0x7bdc00a3,0x00000000,0x00000000}},	// [1f00] _قلي_, _phru, --, --, 
   {{0x25a800bc,0x3f8c0037,0x00000000,0x00000000}},	//   čaly_, ödud_, --, --, 
   {{0x9d4423bc,0x7bc001e1,0x00000000,0x00000000}},	//   _кенд, _ímum, --, --, 
   {{0xdc340131,0xa91c0010,0x00000000,0x00000000}},	//   _پىسخ, _rožc, --, --, 
   {{0x7bdc23bd,0x985423be,0x00000000,0x00000000}},	//   _thru, ртеш, --, --, 
   {{0xf74801f7,0x5fc423bf,0x00000000,0x00000000}},	//   الغي_, लकिल, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd4140124,0x9868022e,0x00000000,0x00000000}},	//   қьҩы, _иибб_, --, --, 
   {{0x57e823c0,0x3e58033b,0x5fc423c1,0x18a423c2}},	//   _адам_, _lōt_, लकाल, _таам, 
   {{0x07a023c3,0x88380302,0x00000000,0x00000000}},	//   _даун, _בתמו, --, --, 
   {{0x3e580100,0x00000000,0x00000000,0x00000000}},	//   _nōt_, --, --, --, 
   {{0xa91c0e3c,0x00000000,0x00000000,0x00000000}},	//   _koža, --, --, --, 
   {{0x3448013e,0x73c401ee,0x0fe000db,0x00000000}},	//   _сӯйи_, _гәне, жөнү, --, 
   {{0x926800c7,0xa2c0185d,0xa91c0219,0x48b000fe}},	//   _ариа_, _रुक्, _moža, _জৰুৰ, 
   {{0xbe8823c4,0xa3100030,0x63bc01d3,0x00000000}},	//   асте_, äčšo, ésne, --, 
   {{0x8d7400db,0x40c801f2,0xd12c00db,0xb11423c5}},	//   جاسا, ọrị_, _تۅح_, _умиш, 
   {{0xdce402d5,0x7bf800a8,0x660c107d,0x8c340107}},	// [1f10] _mokė, интр_, ćaki, розӣ_, 
   {{0xdce40064,0x46a4000d,0x00000000,0x00000000}},	//   _lokė, _कइलह, --, --, 
   {{0xd1ec0201,0x00000000,0x00000000,0x00000000}},	//   _ሁለት_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x67d423c6,0x3e58007f,0x3b1803b9,0xfda801af}},	//   боду, _zōt_, _ferq_, _төрҙ_, 
   {{0xa91c0306,0x0a6800f3,0x00000000,0x00000000}},	//   _doža, _ирби_, --, --, 
   {{0xa6c823c7,0xaa9400c6,0xeae40183,0x361802d5}},	//   ылка_, _الأث, _প্ৰম, ацыю_, 
   {{0xa2c00490,0x00000000,0x00000000,0x00000000}},	//   _रुग्, --, --, --, 
   {{0x291c23c8,0x9f5001e1,0x18b023c9,0x64a423ca}},	//   mawa_, _buyì_, _нәшр, сапа, 
   {{0x291c23cb,0x86b002dd,0x4ad80073,0xe358022e}},	//   lawa_, _мәйі, _भराव, ушиш_, 
   {{0x65140ef8,0x6e34110c,0xa91c23cc,0xc6a400f3}},	//   _هوائ, juzb, _zoža, _траи, 
   {{0x291c23cd,0x68ec0232,0xf65000cf,0x070802c3}},	//   nawa_, žadu, _تئك_, _स्तव_, 
   {{0x25ac23ce,0xe1f023cf,0x291c02b5,0x7dfc033b}},	//   miel_, _کست_, iawa_, _pčso, 
   {{0x291c23d0,0xdb1c23d1,0x25ac23d2,0x3e58007f}},	//   hawa_, kopá, liel_, _pōt_, 
   {{0x8fa023d3,0xa7fc0b21,0xdc340166,0x248c01d3}},	//   чаре, _brűk, _bäğe, lyem_, 
   {{0x291c23d4,0xdb1c02fb,0xdca41cf2,0x3b18025c}},	//   jawa_, dopá, баби, _serq_, 
   {{0x291c23d5,0xf1a803e6,0xa06823d6,0xe8180316}},	// [1f20] dawa_, _خاوه_, _сапа_, नीमा_, 
   {{0x25ac23d7,0xa91c23d8,0xa3dc06ab,0x61e423d9}},	//   hiel_, _roža, _थीम_, lmkl, 
   {{0x25ac23da,0x248c016b,0x291c23db,0xa91c0427}},	//   kiel_, hyem_, fawa_, _soža, 
   {{0x291c23dc,0xa91c0b9d,0x248c013f,0x25ac0489}},	//   gawa_, _poža, kyem_, jiel_, 
   {{0x25ac23dd,0xb5fc0003,0xd764036b,0x00000000}},	//   diel_, _irġi, ینچی, --, 
   {{0x9b9423de,0xdb1c0077,0x00000000,0x00000000}},	//   _الست, bopá, --, --, 
   {{0x291c23df,0x25ac207e,0xd1ec0020,0x638401ef}},	//   bawa_, fiel_, _ሁለቱ_, _méně, 
   {{0x291c23e0,0x25ac23e1,0x00000000,0x00000000}},	//   cawa_, giel_, --, --, 
   {{0xf8dc00af,0x09e001c0,0xca6802dd,0x0460084c}},	//   _बरिय, _хотн, гiзi, птэм, 
   {{0x9f94003a,0xfdc40037,0x6e3401b9,0x86940166}},	//   lææ_, वकुफ, yuzb, ртәт_, 
   {{0xa91c23e2,0x25ac23e3,0xcb1023e4,0xb5fc0327}},	//   _možn, biel_, הלת_, _orġi, 
   {{0xf48423e5,0xa91c012c,0x9f500248,0x00000000}},	//   _واشی, _ložn, _wuyì_, --, 
   {{0x13a807d6,0x00000000,0x00000000,0x00000000}},	//   _ینچی_, --, --, --, 
   {{0x291c23e6,0x92a800c6,0xa91c1821,0xf1640241}},	//   zawa_, _খৡৣ_, _nožn, _imọ̀_, 
   {{0x291c23e7,0xfdc405f9,0x04b401ed,0x271c009e}},	//   yawa_, वकूफ, _نھیں_, _নামো_, 
   {{0x291c02c4,0x00000000,0x00000000,0x00000000}},	//   xawa_, --, --, --, 
   {{0x291c23e8,0x06680131,0xd7b823e9,0x0bf000db}},	// [1f30] vawa_, _ﺳﯧﻠﯩ, ेवाच, سياڭ, 
   {{0x291c23ea,0x25ac23eb,0xdb1c23ec,0x00000000}},	//   wawa_, ziel_, topá, --, 
   {{0x291c23ed,0x248c23ee,0x2d84004a,0xcae023ef}},	//   tawa_, zyem_, êles_, केंड_, 
   {{0x6ab81971,0x291c0451,0x25ac1529,0x248c011f}},	//   _आशीर, uawa_, xiel_, yyem_, 
   {{0x291c23f0,0xf77023f1,0x25ac23f2,0x2d9823f3}},	//   rawa_, کان_, viel_, _ilse_, 
   {{0x291c23f4,0x248c1529,0x25ac23f5,0xdb1c00e4}},	//   sawa_, vyem_, wiel_, popá, 
   {{0x291c094a,0x9ba023f6,0x25ac23f7,0xe9e8007b}},	//   pawa_, _تەلى, tiel_, _نفسى_, 
   {{0x248c061c,0x291c0481,0x61e4035a,0xf7700e56}},	//   tyem_, qawa_, xmkl, _ۋال_, 
   {{0x25ac23f8,0x92e400bd,0x00000000,0x00000000}},	//   riel_, যুৎ_, --, --, 
   {{0x25ac23f9,0x248c03e0,0xe3a802e8,0x7e7c0175}},	//   siel_, ryem_, ркод_, yxrp, 
   {{0x25ac23fa,0x2d9800a2,0x248c007f,0x80dc00bc}},	//   piel_, _olse_, syem_, _नरहे, 
   {{0x248c007f,0xe04401a9,0x3688004e,0xa06800db}},	//   pyem_, онми, _усун_, аама_, 
   {{0x10a023fb,0xb5c80214,0x61e423fc,0x00000000}},	//   диян, _اونم_, rmkl, --, 
   {{0xaab823fd,0x92a801ed,0x57f80115,0x00000000}},	//   _आशंक, ائیہ_, ילשו, --, 
   {{0xa91c23fe,0x2d9801a6,0xe81823ff,0x9d541541}},	//   _rožn, _blse_, नीता_, ينست, 
   {{0x290800e8,0x00000000,0x00000000,0x00000000}},	//   ñaal_, --, --, --, 
   {{0x8c402400,0x5ba82401,0x3bd40139,0x00000000}},	// [1f40] мете, акам_, läqi_, --, 
   {{0xa91c2402,0x2d982403,0x00000000,0x00000000}},	//   _božo, _else_, --, --, 
   {{0xdee407a5,0x5398011a,0x00000000,0x00000000}},	//   _фони, סיעו, --, --, 
   {{0xbd24031c,0x00000000,0x00000000,0x00000000}},	//   _འཇིཊ_, --, --, --, 
   {{0x7d042404,0xa91c151c,0x97c42405,0x6f040208}},	//   mcis, _tožn, ойде, _yfhc, 
   {{0x7c242406,0x7d042407,0x1a240014,0x00000000}},	//   msir, lcis, _ورزُ, --, 
   {{0x7c242408,0x07a00261,0xdb1c005c,0x9984010a}},	//   lsir, ќајн, topæ, _мăкш, 
   {{0x7d042409,0x7c240083,0x0d94010f,0x00000000}},	//   ncis, osir, ַכים_, --, 
   {{0x7d04240a,0xdb1c04ce,0xdcf40205,0x00000000}},	//   icis, ropæ, niyı, --, 
   {{0x7c24240b,0x92681914,0x938800c7,0x6d900158}},	//   isir, арма_, рсиа_, _påak, 
   {{0x7dfc0100,0x8af808d8,0x7c24022e,0x7d040205}},	//   _dčsk, יליז, hsir, kcis, 
   {{0x7c24240c,0xdb1c0108,0x6380035b,0x261801e1}},	//   ksir, lopä, дҳәа, _ṣoge_, 
   {{0x7c2408a4,0x00000000,0x00000000,0x00000000}},	//   jsir, --, --, --, 
   {{0x09b41788,0xc05800d6,0x7d04240d,0x7c24240e}},	//   _अद्य, цію_, ecis, dsir, 
   {{0x8d74240f,0x87780677,0x7f900139,0x645c0135}},	//   يارا, סאלי, _xäqi, ħsie, 
   {{0x7c242410,0x75202411,0x7d0400aa,0xdb1c0112}},	//   fsir, namz, gcis, hopä, 
   {{0x7c242412,0xb5fc0327,0xdb1c005b,0xcfa802cb}},	// [1f50] gsir, _irġu, kopä, _نادم_, 
   {{0x09b02413,0x7d042414,0x35cc0cb4,0xf3fc0183}},	//   ंच्य, acis, ावड़, _এবাৰ_, 
   {{0x75201bb6,0x2d98067c,0x7c242415,0x6b50032e}},	//   kamz, _tlse_, asir, _aðgæ, 
   {{0xc8b00d00,0x7d042416,0x7c242417,0x00000000}},	//   ولاک, ccis, bsir, --, 
   {{0x6c78008f,0xdb1c0037,0x67d400f3,0x7c2400e5}},	//   _האָפ, fopä, поду, csir, 
   {{0xbdf82263,0x80c8015b,0xdb1c0112,0xd5bc00b8}},	//   _دریا_, রেক্, gopä, _śāpa_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x75202418,0x7f90013d,0x3ebc011a,0x00000000}},	//   gamz, _väqi, יצוב, --, 
   {{0xf77005d9,0x00000000,0x00000000,0x00000000}},	//   _ڄام_, --, --, --, 
   {{0xf7702419,0x3ca803d4,0x7f900139,0xa91c00d7}},	//   _لام_, _কুঁৱ, _täqi, _možm, 
   {{0x2168241a,0x7c2403da,0xa91c0171,0x00000000}},	//   бини_, zsir, _ložm, --, 
   {{0x7d040548,0x64540083,0x645c0135,0x00000000}},	//   xcis, ăzib, ħsib, --, 
   {{0xa91c241b,0x00000000,0x00000000,0x00000000}},	//   _nožm, --, --, --, 
   {{0x7c24074d,0x224402fa,0x00000000,0x00000000}},	//   vsir, ptlk_, --, --, 
   {{0x7c24241c,0xdb1c0267,0x7d040205,0x00000000}},	//   wsir, nopå, tcis, --, 
   {{0x7c24241d,0xf1a8088c,0x91e0241e,0x7d0406af}},	//   tsir, _وايه_, _поще, ucis, 
   {{0x7d04241f,0xe31801fb,0xa6d000cc,0x00000000}},	// [1f60] rcis, _điể, াধিট, --, 
   {{0xdb1c0158,0x7d041486,0x75200156,0x61f414ea}},	//   kopå, scis, zamz, _hiyl, 
   {{0x4ef8025f,0x7c242420,0x7520014b,0x39b8007f}},	//   _להיו, ssir, yamz, lčsi_, 
   {{0xd7f805c5,0xd00c2421,0x82f8031c,0x21202422}},	//   бук_, _جلی_, _ནུའུ_, nakh_, 
   {{0xdb1c0844,0x636400b0,0x7c242423,0x7794114f}},	//   topä, _kōnē, qsir, ویرا, 
   {{0xc7a02424,0x07a02425,0x60d402f6,0xb8f4007d}},	//   ничк, начн, _myym, _सँ_, 
   {{0xdb1c2426,0x2120009a,0xa3c017ee,0x7520009f}},	//   ropä, kakh_, ्कन_, tamz, 
   {{0x7f90013d,0x99e401af,0x00000000,0x00000000}},	//   _täqw, _эҫең_, --, --, 
   {{0x21202427,0x75202428,0x73c41de6,0x60d40108}},	//   dakh_, ramz, мәке, _nyym, 
   {{0xb9cc001f,0x97c40166,0xd378030d,0x00000000}},	//   _ቶሎ_, _эйзе, счи_, --, 
   {{0xa91c00c0,0xd574003b,0x00000000,0x00000000}},	//   _alžy, _нудь, --, --, 
   {{0x21200472,0xc1080276,0x86780375,0x6aa00205}},	//   gakh_, зэре_, _לרבו, _ülfe, 
   {{0x6ab82429,0xa91c242a,0x9f50010e,0x61f4010b}},	//   _आश्र, _božj, _atyñ_, _diyl, 
   {{0xa91c242b,0xfa080327,0x00000000,0x00000000}},	//   _rožm, _ཆེ༵ན_, --, --, 
   {{0x2120242c,0x61f401a9,0xc7d40375,0x3ec40064}},	//   bakh_, _fiyl, פולי_, естб, 
   {{0x7d24242d,0x61f40139,0x00000000,0x00000000}},	//   еффе, _giyl, --, --, 
   {{0x6ecc242e,0xdb0c07a8,0x3d0c00c5,0xb2740022}},	// [1f70] _दुरु, _imbê, ़ड़े_, _хкқә, 
   {{0xaa9401a9,0x00000000,0x00000000,0x00000000}},	//   мизч, --, --, --, 
   {{0xecf8242f,0xbb840597,0x00000000,0x00000000}},	//   _менш_, علمي, --, --, 
   {{0xba7402dd,0x61f401a9,0xac9401b9,0x00000000}},	//   عالت, _xiyl, _жамш, --, 
   {{0x6d4c020b,0xa3c00490,0x00000000,0x00000000}},	//   mfaa, ्कम_, --, --, 
   {{0x6d4c2430,0x21202431,0x00000000,0x00000000}},	//   lfaa, zakh_, --, --, 
   {{0xb8f42432,0x98b000e2,0xa91c1151,0x6d4c058a}},	//   _सु_, īcām_, _jožk, ofaa, 
   {{0x24082433,0x6d4c2434,0xa2ac2435,0x00000000}},	//   онии_, nfaa, ुपस्, --, 
   {{0x6d4c0421,0x69d800f1,0x00000000,0x00000000}},	//   ifaa, mlwe, --, --, 
   {{0xdb0c006a,0x69d82436,0x6d4c01d9,0x6d9003cd}},	//   _ambê, llwe, hfaa, _gåav, 
   {{0x69d82437,0x7f9000fd,0x21200de2,0xa91c2438}},	//   olwe, _mäqt, takh_, _nožk, 
   {{0x61f4022e,0x2454007b,0x00000000,0x00000000}},	//   _qiyl, _يناس, --, --, 
   {{0x69d82439,0x7dfc243a,0x232807d8,0x6d4c000f}},	//   ilwe, _mōse, _доли_, dfaa, 
   {{0x69d8243b,0xd9a8243c,0x6568243d,0x98b0068f}},	//   hlwe, _कष्ट, ldeh, żyć_, 
   {{0x6d4c243e,0x69d80117,0x63a0009a,0xfe780137}},	//   ffaa, klwe, mhln, чүн_, 
   {{0x6568243f,0x6d4c0083,0xc0bc2440,0xe8e400ec}},	//   ndeh, gfaa, _ሰላሙ_, _مڻ_, 
   {{0x7164005e,0x69d80028,0x6aa4030a,0x00000000}},	// [1f80] _سايك, dlwe, ezhf, --, 
   {{0x69d8000a,0x64482441,0x6d4c2442,0x63a0014b}},	//   elwe, itei, afaa, nhln, 
   {{0x64482443,0x6d4c0218,0x62800165,0x7f5c047e}},	//   htei, bfaa, nxlo, merq, 
   {{0xaae42444,0x656801a4,0x6d4c0067,0xdcb002dd}},	//   رسلو, jdeh, cfaa, _ٴىس_, 
   {{0xdb0c008c,0xa3bc0882,0x80dc04c5,0x2bd80034}},	//   þjón, _इदं_, ণশক্, _बीका, 
   {{0x65680ae3,0x69d805e4,0x64482445,0x7f5c2446}},	//   edeh, alwe, dtei, nerq, 
   {{0x2a34084c,0x64482447,0x46640108,0x00000000}},	//   _пэтр, etei, дрым_, --, 
   {{0x64482448,0x7f5c0113,0x3e480e78,0x3f982449}},	//   ftei, herq, ißt_, hkru_, 
   {{0x39440120,0x27e401ab,0x3f98244a,0x6448244b}},	//   _icms_, _fhln_, kkru_, gtei, 
   {{0x969406bb,0x657814dc,0x27e401ab,0x999802b1}},	//   _ореш, _enwh, _ghln_, kupū_, 
   {{0x6448244c,0x7f5c244d,0xdb0c0200,0x6568244e}},	//   atei, derq, _ambë, bdeh, 
   {{0xdb0c0194,0x644803fa,0x9578001f,0xa91c244f}},	//   _ejbø, btei, ጮቻችን_, _rožk, 
   {{0x14e02450,0x3e4803fa,0x644801e7,0x7afc07f5}},	//   _परिण, eßt_, ctei, _ogrt, 
   {{0x61ec01a2,0x7f5c2451,0x69d80007,0x9f48007f}},	//   _ďale, gerq, zlwe, nmbè_, 
   {{0xdb0c2452,0x77680067,0x51840063,0xdb1c00c7}},	//   _imbè, _madx, _жупа, bopú, 
   {{0xa2ac038e,0x6d4c2453,0x69d80007,0xdedc0023}},	//   ुपर्, ufaa, xlwe, ዒልካ_, 
   {{0xab7407d6,0x6d4c2454,0x2ae000ab,0xc2f00154}},	// [1f90] нгаш, rfaa, _करहु_, চুদি_, 
   {{0x6d4c2455,0x4fc40826,0x7f5c2456,0x656813d5}},	//   sfaa, _іспа, cerq, zdeh, 
   {{0x69d80b58,0x64482457,0x316801c7,0x6d4c01c7}},	//   tlwe, ztei, _kaaz_, pfaa, 
   {{0x64482458,0xa91c2230,0x6aa40165,0x6d4c0009}},	//   ytei, _koži, rzhf, qfaa, 
   {{0xdb0c0214,0x31682459,0x64481437,0xa91c0427}},	//   _ombè, _maaz_, xtei, _joži, 
   {{0xa3dc068f,0x66e4245a,0x23dc13f5,0xa91c0427}},	//   _थीं_, нола, _नींद, _moži, 
   {{0x92c011ba,0xe91800d6,0x3ddc025a,0xa91c245b}},	//   ্ধু_, _нові_, _âzwâ_, _loži, 
   {{0x6448245c,0xdb0c020c,0x7afc0841,0x39440010}},	//   ttei, _ambè, _zgrt, _gcms_, 
   {{0x6568245d,0xa91c245e,0x756801ed,0x77680009}},	//   rdeh, _noži, بینہ_, _fadx, 
   {{0x6568245f,0xf77400c7,0x2fd001a6,0x3f980327}},	//   sdeh, _аҧш_, jozg_, xkru_, 
   {{0x21682460,0x61442461,0x31680009,0x00000000}},	//   пини_, нена, _baaz_, --, 
   {{0x67202462,0x21682463,0x64482464,0x6280036b}},	//   _helj, чими_, ptei, rxlo, 
   {{0x66002465,0x7f5c2466,0x601402e3,0x02cc11a6}},	//   _hulk, terq, _ẹmbr, _सुरभ, 
   {{0x66002467,0xdd902468,0xb46402bf,0x672000f3}},	//   _kulk, گور_, _шкіл, _jelj, 
   {{0x66000664,0xe2982469,0x6d900158,0x7f5c02d1}},	//   _julk, _хай_, _nåas, rerq, 
   {{0xdd90246a,0x6600246b,0x3f98246c,0xdb0c246d}},	//   دور_, _mulk, skru_, _imbé, 
   {{0x7f5c246e,0x6600002d,0x672003ac,0x00000000}},	// [1fa0] perq, _lulk, _oelj, --, 
   {{0x6720246f,0xa3c01533,0x9e642470,0x660005da}},	//   _nelj, ्कि_, _звод, _oulk, 
   {{0xa91c0427,0xcee001ec,0xaec4004e,0x192c0092}},	//   _zoži, _бұрқ, _үбөл, _አምልኮ, 
   {{0xd8242471,0x99d400cf,0xd7f82472,0x80c800fe}},	//   едди, رتاا, пук_, ৰেণ্, 
   {{0x67202473,0x66002474,0x00000000,0x00000000}},	//   _belj, _aulk, --, --, 
   {{0x66002475,0x67200fb7,0xdb0c0066,0xacb000d1}},	//   _bulk, _celj, _ombé, _ئەكب, 
   {{0x66000100,0x67202476,0xdd100055,0x02cc01bc}},	//   _culk, _delj, _aüũu, _सुलभ, 
   {{0x66002477,0x67200254,0x00000000,0x00000000}},	//   _dulk, _eelj, --, --, 
   {{0xdb0c00d5,0x5ed00490,0x67202478,0x380401f0}},	//   _ambé, _दुसऱ, _felj, _розҳ, 
   {{0xc4500597,0x67200209,0x66002479,0xa91c247a}},	//   اضيع, _gelj, _fulk, _roži, 
   {{0x668000aa,0x6600247b,0xa91c0427,0x62840129}},	//   _نیول, _gulk, _soži, _àhol, 
   {{0x672005a1,0xa91c247c,0xa7fc002d,0xc68c0014}},	//   _zelj, _poži, _krűp, _دِم_, 
   {{0xe6280597,0x6600247d,0xdb0c003e,0x92c0015b}},	//   ĥôŗ_, _zulk, _embé, ্ধে_, 
   {{0xa91c01ef,0x00000000,0x00000000,0x00000000}},	//   _voži, --, --, --, 
   {{0x660001d9,0x2fd001a6,0x00000000,0x00000000}},	//   _xulk, rozg_, --, --, 
   {{0xa91c09a8,0x2bd807d0,0x6d900158,0xdce4247e}},	//   _toži, _बीजा, _råas, _alkı, 
   {{0x41c4082e,0x7de40220,0x6d900158,0x6d8401d9}},	// [1fb0] _حقيق, уірд, _såas, _یۅسہ_, 
   {{0x6e940022,0x4ae801f4,0x00000000,0x00000000}},	//   _аиоу, пьем_, --, --, 
   {{0x70e0000d,0x7f90013d,0x00000000,0x00000000}},	//   _नरुल, _täqr, --, --, 
   {{0xba74247f,0xdd140030,0x15c80055,0xd2440133}},	//   داكت, _päťd, _gṛṇī, _ێن_, 
   {{0x66002480,0x67202481,0x9ba00131,0x00000000}},	//   _sulk, _pelj, _ھەمى, --, 
   {{0x66002482,0x5cc005f5,0x00000000,0x00000000}},	//   _pulk, _төсв, --, --, 
   {{0xe5a42483,0x66000009,0x2ca80489,0x04840133}},	//   кики, _qulk, lzad_, کڕای_, 
   {{0x6720030a,0x2d882484,0x00000000,0x00000000}},	//   _welj, njae_, --, --, 
   {{0x67202485,0x290c2486,0x7dfc03a0,0x14202487}},	//   _telj, _ifea_, _mōsa, адым, 
   {{0xc6a42488,0x66002489,0xe298248a,0x75c800bc}},	//   _преи, _tulk, дао_, věze, 
   {{0x2d88248b,0xb2f40b32,0x3dc00227,0xd5ac036b}},	//   kjae_, ляющ, yniw_, صفی_, 
   {{0xe194248c,0x75c80118,0x00000000,0x00000000}},	//   троэ, těze, --, --, 
   {{0x2ca8248d,0xd00c0592,0xe36407a5,0x00000000}},	//   jzad_, يلَ_, _акли, --, 
   {{0x443c0a4d,0x2ca805be,0x645802d0,0x00000000}},	//   muu_, dzad_, _ipwi, --, 
   {{0x443c248e,0x290c0421,0x6d90248f,0x1d0800db}},	//   luu_, _ofea_, _råar, деби_, 
   {{0xa91c23cc,0x443c00b5,0xca64022e,0x00000000}},	//   _kožu, ouu_, _rejа, --, 
   {{0x443c2490,0xd1e8044e,0x4938001f,0x6d90007c}},	// [1fc0] nuu_, _ዘረባ_, _አምራቾ, _påar, 
   {{0x9f042491,0x290c20d6,0x443c0421,0xed58016c}},	//   _جودو, _afea_, iuu_, моӣ_, 
   {{0x443c2492,0x6cb80166,0xc2f00154,0x00000000}},	//   huu_, _җыяр_, চুরি_, --, 
   {{0x443c2493,0x64582494,0x290c0005,0xe3b8009e}},	//   kuu_, _opwi, _cfea_, ুতিব, 
   {{0xc32402a6,0x06ac00fe,0xa91c00ef,0x00000000}},	//   _মানি_, _চুলি, _nožu, --, 
   {{0x443c2495,0x68ec0209,0x645c0327,0x00000000}},	//   duu_, ýada, ħsil, --, 
   {{0x64580295,0xdce4007f,0xabc401e0,0x00000000}},	//   _apwi, _makč, _сарҙ, --, 
   {{0xd4980364,0x443c2496,0xa91c110c,0x75cc0073}},	//   дро_, fuu_, _božu, ावेळ, 
   {{0x443c2497,0xa91c0427,0x9f580200,0x629401bf}},	//   guu_, _požv, _cipë_, øzon, 
   {{0xa91c107d,0xdce40153,0x96b40063,0xb9dc0257}},	//   _dožu, _nakč, _исељ, _ኤሊ_, 
   {{0x64582498,0x443c2499,0xc7d40375,0x00000000}},	//   _epwi, auu_, _יומי_, --, 
   {{0x443c249a,0xe8181b90,0xfbd800eb,0x00000000}},	//   buu_, नीका_, থগিত, --, 
   {{0x443c249b,0xa3c001ad,0xa3dc000d,0x291006be}},	//   cuu_, ्कश_, _थीक_, _əza_, 
   {{0x2fc40254,0x9998013a,0x00000000,0x00000000}},	//   õlg_, kupů_, --, --, 
   {{0xa3c0023e,0x0264008e,0x7e281cd0,0x00000000}},	//   ्कर_, _ашый_, кіта_, --, 
   {{0xc0f00020,0x0dc80835,0x518400d8,0x00000000}},	//   ቀርም_, фуги_, _јука, --, 
   {{0x2d880077,0xa91c00d7,0x7d08032e,0x4fc400c0}},	// [1fd0] rjae_, _možt, _séró, _асна, 
   {{0x2ca80165,0x6f080241,0x6bd800e3,0x00000000}},	//   rzad_, _dèbó, رواس_, --, 
   {{0xc984249c,0x443c249d,0x00000000,0x00000000}},	//   куди, zuu_, --, --, 
   {{0x443c249e,0xf99005d9,0xdd90249f,0xac180276}},	//   yuu_, يبن_, _هوپ_, _пому_, 
   {{0x443c0d62,0x7c8424a0,0x9f58007f,0xb86400f1}},	//   xuu_, _куре, _bipè_, لاوو, 
   {{0x443c24a1,0xfe7024a2,0x1ae003d4,0xa91c0171}},	//   vuu_, _ادی_, _বলৰা, _rožu, 
   {{0x443c00b4,0xc6a400a7,0x98f400d1,0x0948014b}},	//   wuu_, ърди, نغۇچ, _очаи_, 
   {{0x443c248e,0xa91c05ce,0x7d80001f,0x88b401af}},	//   tuu_, _požu, _የሙዚቃ_, _иҫер_, 
   {{0xa3c01ab2,0xb33c031c,0x07440334,0x00000000}},	//   ्कल_, ghħo, _ахем, --, 
   {{0x443c0a4d,0x75c80118,0xdb1c00c7,0x53c400db}},	//   ruu_, tězc, kopý, лгым_, 
   {{0xe29824a3,0x443c0a4d,0xf77024a4,0x64a400c7}},	//   хан_, suu_, _باق_, _әала, 
   {{0xa134007b,0x00000000,0x00000000,0x00000000}},	//   دردش, --, --, --, 
   {{0x443c198f,0xdce40100,0x00000000,0x00000000}},	//   quu_, _pakč, --, --, 
   {{0xa2e424a5,0x442c24a6,0x00000000,0x00000000}},	//   _йолд, _ivg_, --, --, 
   {{0x442c01ed,0x00000000,0x00000000,0x00000000}},	//   _hvg_, --, --, --, 
   {{0xdcb024a7,0x1fb419b8,0x80c80183,0xf2c401e0}},	//   مىز_, _әсир, ৰেষ্, _әсән, 
   {{0xa2ac04e4,0x00000000,0x00000000,0x00000000}},	// [1fe0] ुपक्, --, --, --, 
   {{0x442c24a8,0xc0e40116,0x99980118,0x1f640229}},	//   _mvg_, _йоқк, tupů_, _ском, 
   {{0x2c0403d4,0x00000000,0x00000000,0x00000000}},	//   শীলৈ_, --, --, --, 
   {{0x9f580699,0x18a4005b,0x442c002f,0x98a4031c}},	//   _sipè_, лаем, _ovg_, nfoħ_, 
   {{0x442c05e4,0x491007f7,0xa91c0419,0xbef401f9}},	//   _nvg_, दड़ो_, _rožt, _आणुन_, 
   {{0xa91c02fb,0x00000000,0x00000000,0x00000000}},	//   _božs, --, --, --, 
   {{0x9f58007f,0x442c0d63,0x995800d8,0x2bd00825}},	//   _vipè_, _avg_, _пјаф_, तकरा, 
   {{0x743424a9,0x442c24aa,0xca940115,0x00000000}},	//   аниф, _bvg_, _גדלי_, --, 
   {{0xd32424ab,0x48e00a83,0x9f58020c,0xa91c0024}},	//   льни, _готв, _tipè_, _vožt, 
   {{0x325424ac,0xbef40490,0x045424ad,0x00000000}},	//   авор, _आणून_, اجيت_, --, 
   {{0x442c002f,0xdb1c0210,0x00000000,0x00000000}},	//   _evg_, lopó, --, --, 
   {{0x442c0395,0x733424ae,0x14c8005b,0x0580014b}},	//   _fvg_, دىگا, _пыли_, _гушм, 
   {{0x442c24af,0xc5f00302,0xdb1c24b0,0xc0c824b1}},	//   _gvg_, _הדף_, nopó, гуре_, 
   {{0xa3c001bc,0xdb1c0118,0x00000000,0x00000000}},	//   ्कः_, topý, --, --, 
   {{0x442c002f,0x00000000,0x00000000,0x00000000}},	//   _zvg_, --, --, --, 
   {{0x823024b2,0x8d7424b3,0xc2780bd9,0x00000000}},	//   _اروا, داسا, _טרוי, --, 
   {{0xc32403d4,0xe6e00034,0x0fe000ee,0xdb1c00e4}},	// [1ff0] _মাতি_, _फर्ज, _гөвү, jopó, 
   {{0x798024b4,0xbcf40108,0x00000000,0x00000000}},	//   _anmw, спущ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x28b80276,0x9f5801e1,0x7c5800db,0x3f8c0254}},	//   кулэ_, _ripé_, ئلەر_, öduv_, 
   {{0x9f5801e1,0x00000000,0x00000000,0x00000000}},	//   _sipé_, --, --, --, 
   {{0x442c24b5,0x26580798,0xdc3800d9,0x00000000}},	//   _rvg_, вриќ_, _בעשר, --, 
   {{0x16a41363,0xa91c0010,0x442c24b6,0xa6c802e8}},	//   ивши_, _anže, _svg_, ълка_, 
   {{0xdce400b8,0xd8840014,0xe57800c7,0x00000000}},	//   _hakā, _چھون_, тзи_, --, 
   {{0x291c24b7,0x18b00116,0xdce424b8,0x39400332}},	//   mbwa_, _мәшр, _kakā, óise_, 
   {{0xe7a802f8,0xdb1c067c,0x69c80fac,0x68e80857}},	//   _कतिप, lopò, _hjee, _ized, 
   {{0xdce424b9,0x26d024ba,0xa2e424bb,0xc79400c7}},	//   _makā, _âzo_, ронд, _ирҧы, 
   {{0x442c172e,0x69c804ba,0x66040030,0xdb1c24bc}},	//   _tvg_, _jjee, íhku, nopò, 
   {{0xe3b024bd,0x291c24be,0xd83c00d0,0x69c801e1}},	//   _ورت_, ibwa_, _účte_, _mjee, 
   {{0xdce400b8,0x1ea80b24,0x00000000,0x00000000}},	//   _nakā, نازي_, --, --, 
   {{0x69c824bf,0x291c033b,0x6ee4009a,0x21a4003b}},	//   _ojee, kbwa_, مسفل, _вийм, 
   {{0x3d20068f,0x69c824c0,0xe1f001fd,0x2d940a89}},	//   बरें_, _njee, _بست_, брус, 
  
   {{0xdce400b8,0x291c007f,0x00000000,0x00000000}},	// [2000] _bakā, dbwa_, --, --, 
   {{0x69c824c1,0x109823e4,0x291c0a49,0xdce400dc}},	//   _ajee, _סביב, ebwa_, _cakā, 
   {{0x68e824c2,0x75ec002d,0xdce407d7,0xcb6424c3}},	//   _azed, lûze, _dakā, рахе_, 
   {{0xdb1c24c4,0x291c0083,0xd5400241,0xf3fc00fe}},	//   topó, gbwa_, _mẹ́f, _এবছৰ_, 
   {{0x8eb024c5,0xa91c24c6,0x69c801f5,0xd54001e1}},	//   _همیش, _požr, _djee, _lẹ́f, 
   {{0xdb1c24c7,0x68e805b8,0x69c804ba,0xdce4002b}},	//   ropó, _dzed, _ejee, _gakā, 
   {{0x68e80107,0xda7001d9,0x79800083,0x291c0a49}},	//   _ezed, _بُز_, _tnmw, bbwa_, 
   {{0xdb1c24c8,0x59dc02a0,0x00000000,0x00000000}},	//   popó, _फीचर, --, --, 
   {{0x73d824c9,0x46e40b8d,0x06e4151e,0xdce4002b}},	//   лдир_, лдән_, лмәк_, _yakā, 
   {{0xd37824ca,0x00000000,0x00000000,0x00000000}},	//   тчи_, --, --, --, 
   {{0xaf0000bd,0x7bdc017a,0xab78010f,0x870800e5}},	//   ্রমণ_, _mkru, אָרז, _شعلہ_, 
   {{0x3d20012d,0x00000000,0x00000000,0x00000000}},	//   बरों_, --, --, --, 
   {{0xdb0c0109,0x93e401d5,0x00000000,0x00000000}},	//   _ombà, _кўкл, --, --, 
   {{0x7bdc013b,0x2cac00ee,0x00000000,0x00000000}},	//   _nkru, _ýedi_, --, --, 
   {{0xdce424cb,0x00000000,0x00000000,0x00000000}},	//   _rakā, --, --, --, 
   {{0xdce41991,0xe7ec02e5,0xd24c01d3,0x00000000}},	//   _sakā, _चीना_, _فنڈ_, --, 
   {{0xdce40f40,0x6be400c6,0xf414010f,0x7054009a}},	// [2010] _pakā, مكرم, מפּ_, _انخا, 
   {{0x95040135,0xfbd0004b,0x69c801f5,0x7bdc013a}},	//   _ངུའི_, وتل_, _sjee, _ckru, 
   {{0x68e800dd,0x9f580109,0x7ff424cc,0xaa5424cd}},	//   _szed, _mipì_, _بسيا, свеш, 
   {{0x7bdc1529,0xe61807d6,0x00000000,0x00000000}},	//   _ekru, қди_, --, --, 
   {{0xe73824ce,0xdb1c1f40,0x75c800bc,0x1ee812ea}},	//   гел_, ropò, tězn, _لویی_, 
   {{0x8a1424cf,0xe57800a9,0x291c04ba,0x23a80241}},	//   _نظرا, glŷn_, sbwa_, _kúje_, 
   {{0xf77024d0,0x69c824d1,0xdb1c004e,0x39400332}},	//   بان_, _tjee, popò, óisc_, 
   {{0x69c80050,0x6b940161,0xdb0c0022,0x9f9401a8}},	//   _ujee, _hozg, _imbá, hæð_, 
   {{0x69d824d2,0xbee402f8,0x68e824d3,0x6f04014f}},	//   mowe, _गर्न_, _uzed, _oghc, 
   {{0x69d824d4,0xf770027d,0x00000000,0x00000000}},	//   lowe, _يال_, --, --, 
   {{0x6b94089e,0x237c044e,0x00000000,0x00000000}},	//   _mozg, _ንገዛእ_, --, --, 
   {{0xa2e424d5,0x69d824d6,0x6b9401e4,0x75ec045f}},	//   _қойд, nowe, _lozg, tûze, 
   {{0xd24c1482,0x248824d7,0x20d424d8,0xaf000183}},	//   ونی_, _çam_, сінс, ্ৰমণ_, 
   {{0x443c24d9,0x69d824da,0x232824db,0x201c007f}},	//   mru_, howe, _соки_, ďti_, 
   {{0xdee424dc,0x236424dd,0x69d824de,0x7bdc0100}},	//   сови, melj_, kowe, _rkru, 
   {{0x443c24df,0xdde824e0,0x6f04016d,0x69d80034}},	//   oru_, ارسه_, _eghc, jowe, 
   {{0x443c24e1,0x69d8068f,0x6b9424e2,0x3f8c00c5}},	// [2020] nru_, dowe, _bozg, ödus_, 
   {{0x6b940007,0x443c24e3,0x69d80086,0x00000000}},	//   _cozg, iru_, eowe, --, 
   {{0x69d8016c,0x443c24e4,0x22440051,0x00000000}},	//   fowe, hru_, nulk_, --, 
   {{0x5d840491,0xd94424e5,0x69d824e6,0x23642230}},	//   _الحل, седи, gowe, helj_, 
   {{0x6b940369,0xdb0c0077,0x236424e7,0x98540798}},	//   _fozg, _embá, kelj_, стеш, 
   {{0x236405be,0x6b9400ee,0xb8f400b8,0x2244007f}},	//   jelj_, _gozg, _akṣī, kulk_, 
   {{0x9f500789,0x69d8012d,0x15c8002b,0x00000000}},	//   _huyó_, bowe, _mṛṇā, --, 
   {{0x98a40262,0x443c24e8,0x4a980a1e,0x8604007b}},	//   _либе, fru_, _גילג, حقيق_, 
   {{0x443c24e9,0x6b9424ea,0x9f580395,0x23641a48}},	//   gru_, _yozg, _pipì_, felj_, 
   {{0x23640427,0x15c800cd,0x136801f0,0x00000000}},	//   gelj_, _nṛṇā, ушии_, --, 
   {{0x443c24eb,0x674400bc,0xf28801c6,0x00000000}},	//   aru_, ňují, рөлд_, --, 
   {{0x68440022,0x67ec0022,0x00000000,0x00000000}},	//   _ынӡа, rúje, --, --, 
   {{0x443c24ec,0xa4840451,0x9f9401a8,0x23640427}},	//   cru_, _وجهن, tæð_, belj_, 
   {{0x4fc424ed,0x06ac02f5,0x69d824ee,0x63a024ef}},	//   ссма, _চুটি, zowe, ckln, 
   {{0x69d824f0,0x82301913,0x6b9424f1,0x741401f7}},	//   yowe, _فريا, _rozg, _اوڪا, 
   {{0x69d80472,0x00000000,0x00000000,0x00000000}},	//   xowe, --, --, --, 
   {{0x6b94009d,0x8c340107,0xa3dc01f9,0x00000000}},	// [2030] _pozg, созӣ_, ढतच_, --, 
   {{0x6844001f,0x69d824f2,0x09b00a59,0x15c80055}},	//   _የልማት, wowe, ूच्य, _gṛṇā, 
   {{0x69d824f3,0xdb0c01bf,0xdcf40419,0x8af403b9}},	//   towe, _ombæ, chyľ, _şəbn, 
   {{0x443c24f4,0x23640010,0x00000000,0x00000000}},	//   yru_, zelj_, --, --, 
   {{0x6d5c22a9,0x69d824f5,0xaad800e1,0x684400d3}},	//   _ibsa, rowe, _बुरक, інка, 
   {{0x69d824f6,0x443c24f7,0xdb0c0162,0x7a300022}},	//   sowe, vru_, _ambæ, _ẽtee, 
   {{0x443c24f8,0x66c40588,0x236409a8,0x87240150}},	//   wru_, цәаж, velj_, _ۇعام, 
   {{0x443c24f9,0xdd040055,0xdc540244,0x00000000}},	//   tru_, _āpīp, _ارێک, --, 
   {{0x443c24fa,0x00000000,0x00000000,0x00000000}},	//   uru_, --, --, --, 
   {{0xdb0c09f3,0x9f58004e,0xe3b824fb,0x00000000}},	//   _embæ, _pipí_, рбо_, --, 
   {{0x6d5c0745,0xa18824fc,0x443c24fd,0x00000000}},	//   _obsa, абна_, sru_, --, 
   {{0x443c24fe,0x23640427,0x2244007c,0xaf000154}},	//   pru_, selj_, rulk_, ্রাণ_, 
   {{0x23640e3c,0x443c02d1,0x00000000,0x00000000}},	//   pelj_, qru_, --, --, 
   {{0xdce4033f,0x25ac0115,0x22440037,0x9ea8009d}},	//   _jaką, lhel_, pulk_, авга_, 
   {{0x1d0824ff,0x9f500248,0x1d9401a9,0x00000000}},	//   иеви_, _buyò_, ораё, --, 
   {{0x6d5c0076,0x9c2401a9,0x00000000,0x00000000}},	//   _cbsa, ждад, --, --, 
   {{0x6d5c02b9,0xa0682500,0x248c1513,0x15c800cd}},	// [2040] _dbsa, _тапа_, nxem_, _tṛṇā, 
   {{0x0fc00046,0x61e41f53,0x5f44141b,0x6d5c02d0}},	//   _ойын, llkl, _بندل, _ebsa, 
   {{0x61e42501,0x00000000,0x00000000,0x00000000}},	//   olkl, --, --, --, 
   {{0xc9802502,0x248c01a9,0x58842503,0x00000000}},	//   души, kxem_, жыка, --, 
   {{0x25ac0214,0xdb1c0200,0xadc401af,0x00000000}},	//   dhel_, nipë, _хаяһ, --, 
   {{0xc7a023b3,0xfbc800ec,0x61e4002f,0x9078011a}},	//   мичк, _اڀري_, hlkl, יטני, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25ac2504,0xdeec01f3,0x61e4005c,0x34940139}},	//   ghel_, _ጀግና_, jlkl, заир, 
   {{0x93882505,0x00000000,0x00000000,0x00000000}},	//   асна_, --, --, --, 
   {{0x61e42506,0xfbd800cc,0x00000000,0x00000000}},	//   elkl, _থওঁত, --, --, 
   {{0xcb100302,0x25ac009a,0x27e803f9,0xa020000d}},	//   ולת_, bhel_, ɓan_, _ööjo, 
   {{0xdce4033f,0x23a80092,0xdec80023,0xdb0c2507}},	//   _zaką, _ህገወጥ_, _በልካ_, _umbæ, 
   {{0x25d8034c,0x3dc000e8,0xcf980120,0x2eb400cd}},	//   _اهنگ_, diiw_, ајв_, ृप्त, 
   {{0x4ea410e4,0x00000000,0x00000000,0x00000000}},	//   орба, --, --, --, 
   {{0x6d5c01ab,0x625c031c,0xd13800c0,0xb4b401ee}},	//   _pbsa, għoġ, _кхп_, _фиҙә, 
   {{0x51841638,0x4638008f,0x423400df,0x8260009f}},	//   _фука, יעלע, _ונהל_, _آهين, 
   {{0x82b40f50,0xdb24006a,0xc19c0375,0x649c01e4}},	// [2050] _བཟོའ, _âpûp, _כשהי, rɨig, 
   {{0x09d00a28,0x25ac0dd4,0xdec802d3,0x0af001c6}},	//   तव्य, zhel_, _በልኩ_, дүгэ, 
   {{0xaf00015b,0x00000000,0x00000000,0x00000000}},	//   ্রহণ_, --, --, --, 
   {{0x6d5c0c8c,0x67ec04d4,0x25ac009a,0x00000000}},	//   _ubsa, dúja, xhel_, --, 
   {{0xdb1c2508,0x2d982509,0x6d4c250a,0x248c0548}},	//   kipè, _iose_, mgaa, xxem_, 
   {{0x2d98250b,0x7b64250c,0x8a1800f2,0x00000000}},	//   _hose_, _отсе, _نترس_, --, 
   {{0x25ac250d,0x67ec00dd,0x7dfc0270,0xe5a404a9}},	//   thel_, gúja, _sōsi, зийи, 
   {{0x6d4c0680,0x2d98250e,0x00000000,0x00000000}},	//   ngaa, _jose_, --, --, 
   {{0x2d98250f,0x795004d3,0xe3b82510,0x6d4c2511}},	//   _mose_, _شێوا, йби_, igaa, 
   {{0x25ac2512,0x2d982513,0x248c2456,0x6d4c0036}},	//   shel_, _lose_, rxem_, hgaa, 
   {{0x25ac2514,0xaabc0846,0x6d4c2515,0x80c800fe}},	//   phel_, ्पिक, kgaa, ৰেঞ্, 
   {{0x6d4c2516,0x2d982517,0x36040132,0xa3a80014}},	//   jgaa, _nose_, _قولف, _گُتل_, 
   {{0x6d4c2518,0x261001fb,0x30742519,0x65680076}},	//   dgaa, _háo_, мурс, meeh, 
   {{0x2d98020c,0x6d4c251a,0x6568251b,0xdb1c251c}},	//   _aose_, egaa, leeh, cipè, 
   {{0x2d98251d,0x6d4c251e,0x6448251f,0xdb1c0023}},	//   _bose_, fgaa, luei, sipë, 
   {{0x2d982520,0x6d4c2521,0x9ea80aac,0x26100051}},	//   _cose_, ggaa, авҳа_, _máo_, 
   {{0xdb1c2522,0x7a0c2523,0x1c442524,0x64482525}},	// [2060] qipë, _iğti, янам, nuei, 
   {{0x6d4c2526,0x9f580241,0x644800a3,0x75c80118}},	//   agaa, _fipá_, iuei, tězk, 
   {{0xdcf82527,0x2d982528,0x644806c8,0x261001fb}},	//   _گردش_, _fose_, huei, _náo_, 
   {{0x5f442529,0x2d98252a,0xaf0003d4,0x6448252b}},	//   _بنگل, _gose_, ্ৰহণ_, kuei, 
   {{0xa3bc05ba,0x6448252c,0x6568000d,0x4810155b}},	//   ीचा_, juei, deeh, еміс, 
   {{0x261001dc,0x2d980537,0x64480228,0xdb1c252d}},	//   _báo_, _zose_, duei, kipé, 
   {{0x2d98252e,0xd5b8252f,0x261007ae,0x6568002d}},	//   _yose_, йси_, _cáo_, feeh, 
   {{0xdedc0023,0x26100051,0x741402f2,0x2d982530}},	//   ዒልና_, _dáo_, ووبا, _xose_, 
   {{0x64482531,0x27f000c0,0x69940345,0x00000000}},	//   guei, _šonų_, _تێنس_, --, 
   {{0x7dfc007f,0xdee80b82,0x9388035b,0x47c0003b}},	//   _včsy, ሙርን_, ссиа_, _збув, 
   {{0xf28c0998,0x6d4c2532,0x6568009f,0x0ed82533}},	//   criﬁ, ygaa, beeh, _मुंड, 
   {{0x64482534,0x70542535,0x31080137,0x69c00241}},	//   buei, ونجا, өнүп_, _ìlet, 
   {{0x64482536,0x2d982537,0x6d4c2538,0xd3c400cf}},	//   cuei, _rose_, vgaa, _ىتتى, 
   {{0x2258068f,0x30e000dc,0x2d982539,0x6d4c0067}},	//   ńska_, _गुणः_, _sose_, wgaa, 
   {{0x6d4c253a,0xdb1c253b,0x6494031c,0x2d98253c}},	//   tgaa, cipé, _eżiġ, _pose_, 
   {{0x6d4c253d,0x2d980200,0x00000000,0x00000000}},	//   ugaa, _qose_, --, --, 
   {{0x6d4c253e,0x2d980e8a,0x6b7405a2,0x417401ec}},	// [2070] rgaa, _vose_, млау, _سايس, 
   {{0x6d4c253f,0x2d982540,0x65682541,0x9f5801e1}},	//   sgaa, _wose_, zeeh, _tipá_, 
   {{0x2d982542,0x6d4c2543,0x6448002f,0x9d500133}},	//   _tose_, pgaa, zuei, رچێت, 
   {{0xdb1c02f6,0x261001fb,0x2d980064,0x00000000}},	//   enpä, _ráo_, _uose_, --, 
   {{0x656801a4,0x261001fb,0x00000000,0x00000000}},	//   veeh, _sáo_, --, --, 
   {{0x66e41621,0x65680083,0x26100051,0x00000000}},	//   мола, weeh, _páo_, --, 
   {{0x9ba02544,0x6568022f,0xe9180212,0x7f3c00df}},	//   _جەلى, teeh, _мові_, זעוו, 
   {{0x64482545,0xdb1c005b,0xe7ec00e1,0x29980092}},	//   tuei, anpä, _चीरा_, ሊምፒክ_, 
   {{0x7a0c00a2,0x656800a3,0xa3b82546,0x00000000}},	//   _eştd, reeh, قادر_, --, 
   {{0xf7702547,0x65682548,0x2610001e,0x64482549}},	//   _مام_, seeh, _táo_, ruei, 
   {{0x64481140,0xe298254a,0x630401d5,0xb5c800f2}},	//   suei, цан_, بودل, _کونم_, 
   {{0x64480618,0xdb1c254b,0x985c001f,0xa97800df}},	//   puei, ripé, _ሳይሆኑ_, קאָכ, 
   {{0x6448254c,0x7a0c05d1,0x290800e8,0xa3b80066}},	//   quei, _işte, ñaay_, _واتر_, 
   {{0x63040517,0xa7fc01d3,0x00000000,0x00000000}},	//   _قوشل, _zsűr, --, --, 
   {{0xdb0c0129,0x5de402d5,0x00000000,0x00000000}},	//   _embû, джва, --, --, 
   {{0xdd90254d,0x00000000,0x00000000,0x00000000}},	//   خور_, --, --, --, 
   {{0x5f74254e,0xdd9401ec,0xdb1c0108,0x00000000}},	// [2080] _قادر, паңы, ynpä, --, 
   {{0x03c80051,0x00000000,0x00000000,0x00000000}},	//   _điện, --, --, --, 
   {{0x1d08254f,0x61f40649,0x9a682550,0x3a38017a}},	//   _мени_, _khyl, تمال_, _qvrp_, 
   {{0xdca407d6,0x5ca4010a,0x00000000,0x00000000}},	//   _жами, _жимб, --, --, 
   {{0x2a6c00f3,0x61f400d8,0xd7f81d0f,0xf8a401c6}},	//   _ćebe_, _mhyl, оук_, эгдү, 
   {{0x7a0c084c,0xe6c800cd,0xdcfc0064,0x00000000}},	//   _aşte, िपूज, _švėg, --, 
   {{0x6b8002d2,0x00000000,0x00000000,0x00000000}},	//   _ólga, --, --, --, 
   {{0xdce400c0,0xf8b80132,0x00000000,0x00000000}},	//   _sakę, _нөл_, --, --, 
   {{0x13682551,0x4c98008f,0x0ee801ad,0xd49823be}},	//   ошни_, ַשטע, _टर्स_, юрк_, 
   {{0x8898011a,0x69c00ca8,0x00000000,0x00000000}},	//   _ובמי, _ìler, --, --, 
   {{0xc32400fe,0x00000000,0x00000000,0x00000000}},	//   _মাখি_, --, --, --, 
   {{0x61f42552,0x46a008ca,0xc69000d9,0x393c0023}},	//   _chyl, _шахв, _שאף_, ረታዉያ, 
   {{0xe6ac0248,0x00000000,0x00000000,0x00000000}},	//   _ìbòò, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa3bc033f,0x00000000,0x00000000,0x00000000}},	//   ीचर_, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3cfc01c0,0x3c58084c,0x00000000,0x00000000}},	// [2090] рvv_, митэ_, --, --, 
   {{0x21f001f1,0x21d41d86,0xac940107,0x61f40200}},	//   máha_, rāhe_, _ҷамш, _zhyl, 
   {{0x21f00af2,0xfd1001ed,0x60d40175,0xa82401d3}},	//   láha_, اجہ_, _zxym, ڑکان, 
   {{0x69c800c8,0x9f5802f6,0x9c800219,0xac942553}},	//   _ĉees, _eipä_, ščad, _замш, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b7401c4,0x00000000,0x00000000,0x00000000}},	//   _ялгу, --, --, --, 
   {{0xba280014,0x23b40241,0x2fc0045a,0x21f000e4}},	//   _ٲسِم_, _lùjù_, _mmhg_, háha_, 
   {{0x393c02d3,0x21f000e4,0xe2980116,0xf8c001f9}},	//   ረታውያ, káha_, җам_, _शेवय, 
   {{0x290c0395,0x44280ba1,0x61f40142,0xa7b8013d}},	//   _igea_, èc_, _rhyl, _елау_, 
   {{0xdb0c006a,0x61f403a2,0xa91c00c0,0xe2b4009d}},	//   _albê, _shyl, _rožy, есмэ, 
   {{0x61f42554,0x00000000,0x00000000,0x00000000}},	//   _phyl, --, --, --, 
   {{0x22580034,0x68e804ba,0xa0682555,0xa91c0006}},	//   ńsko_, _kyed, пама_, _požy, 
   {{0x32082556,0x6abc0b33,0x224400b5,0x00000000}},	//   _diay_, ्पुर, srlk_, --, 
   {{0x65780374,0x61f40493,0x24580100,0x705002f2}},	//   _hawh, _whyl, mèm_, گۆیا, 
   {{0x61f40649,0x24582557,0x65780374,0x68e804ba}},	//   _thyl, lèm_, _kawh, _lyed, 
   {{0x32080016,0x68e8013e,0x290c2558,0x65782559}},	//   _giay_, _oyed, _ngea_, _jawh, 
   {{0x68e8255a,0x8c40255b,0x657804fe,0xf390001e}},	// [20a0] _nyed, лете, _mawh, _mảnh_, 
   {{0x6abc255c,0x290c0154,0x320805da,0xf3900208}},	//   ्पूर, _agea_, _ziay_, _lảnh_, 
   {{0x68e8255d,0x657802d0,0x66280165,0xf3900051}},	//   _ayed, _oawh, łskʷ, _oảnh_, 
   {{0x2010255e,0x68e80083,0x657802b5,0x644400b0}},	//   _kuyi_, _byed, _nawh, _āhin, 
   {{0x201002a8,0xdb1c255f,0xd7e402d5,0x00000000}},	//   _juyi_, lipí, ніко, --, 
   {{0x657800b0,0x201002a8,0x290c2560,0x24582561}},	//   _aawh, _muyi_, _egea_, dèm_, 
   {{0x68e82562,0x7c242563,0xd9442564,0xd044016b}},	//   _eyed, lpir, _певи, _ɑmɑm, 
   {{0xf39007ae,0x24580100,0x00000000,0x00000000}},	//   _cảnh_, fèm_, --, --, 
   {{0x7c242565,0x68e8013f,0x94a82566,0x2010198f}},	//   npir, _gyed, ятка_, _nuyi_, 
   {{0x3208003e,0x21f00306,0xd244010b,0x7c242567}},	//   _siay_, váha_, нэми, ipir, 
   {{0x65780369,0xdb0c2568,0x0bb40375,0x7c240200}},	//   _fawh, _albë, גלים_, hpir, 
   {{0x7c240cfe,0x20102569,0x65780327,0x24580ba1}},	//   kpir, _buyi_, _gawh, bèm_, 
   {{0x64580472,0xe874001f,0x628402d2,0x53a40006}},	//   _gqwi, _በፍጹም_, _áhon, _падб, 
   {{0x7c24151c,0xaad80037,0x3294007b,0x44f00006}},	//   dpir, _बुझक, _للتأ, _спіс, 
   {{0xfe70066d,0x0ed8256a,0x7c240200,0xbed4119e}},	//   یدہ_, _मुखड, epir, горј, 
   {{0x201000d2,0x46c000c5,0x00000000,0x00000000}},	//   _fuyi_, _वइसह, --, --, 
   {{0x3cfc256b,0x7c24256c,0xa02003e0,0x00000000}},	// [20b0] लेले_, gpir, _şöva, --, 
   {{0xa91c256d,0x21d40882,0x3b54084c,0x00000000}},	//   _inži, māha_, лкур, --, 
   {{0xc3300302,0xa93413d6,0x2458007f,0x00000000}},	//   רוע_, вееш, zèm_, --, 
   {{0x245802bd,0xac18004e,0xcd480107,0x00000000}},	//   yèm_, _оому_, _эчод_, --, 
   {{0x65780374,0xf39001fb,0x7c8400ee,0x1dc0256e}},	//   _rawh, _rảnh_, _йуре, _төрн, 
   {{0x18a0256f,0x65782570,0x98a02571,0xf39001fb}},	//   рашм, _sawh, рише, _sảnh_, 
   {{0x657802b1,0x290c0c86,0xf1e001bc,0x2458033b}},	//   _pawh, _tgea_, नवान, wèm_, 
   {{0xd6cc0491,0xdb0c0ba1,0x6578047e,0xa5080276}},	//   تقى_, _albè, _qawh, мейа_, 
   {{0x68e82572,0x65780810,0xa024009e,0x7a0c2573}},	//   _uyed, _vawh, _বিভব_, _işta, 
   {{0x213005b1,0x20100083,0x245802e2,0x00000000}},	//   _seyh_, _ruyi_, rèm_, --, 
   {{0x65780325,0xa91c01fa,0x20100b45,0x7c242574}},	//   _tawh, _anži, _suyi_, zpir, 
   {{0x20102575,0xa0a400d1,0x7c242576,0x2458007f}},	//   _puyi_, вамд, ypir, pèm_, 
   {{0x7c242577,0x201001b9,0x9f48004e,0x7cf80241}},	//   xpir, _quyi_, llbé_, _múrí, 
   {{0x64482578,0x201002b9,0xe8400023,0xdb0c0174}},	//   mrei, _vuyi_, _ኣይተቐ, _umbø, 
   {{0xd0042579,0xdee41049,0x6448257a,0x6abc257b}},	//   тере_, тови, lrei, ्पोर, 
   {{0xd00c066d,0x6280257c,0x442c002f,0x00000000}},	//   صلہ_, mvlo, _kwg_, --, 
   {{0x6280257d,0xa3c40882,0x4d600798,0xd5bc00b8}},	// [20c0] lvlo, _एषा_, јкув, _śāka_, 
   {{0x7c24257e,0x6448257f,0xd00c2580,0x442c03cb}},	//   rpir, irei, _گلی_, _mwg_, 
   {{0x64482581,0x62802582,0x442c0097,0x8c400276}},	//   hrei, nvlo, _lwg_, леӂе, 
   {{0x64482583,0x18a411db,0x442c05b1,0xd00c2584}},	//   krei, каем, _owg_, _دلی_, 
   {{0x442c0211,0x487000f7,0x98540137,0xffe000b8}},	//   _nwg_, لدوس, ттеш, _ṛṣis_, 
   {{0x62802585,0xda702586,0x7cd8030d,0x00000000}},	//   kvlo, _پُر_, ăмăр_, --, 
   {{0x07a007b5,0x99740022,0xc7a00120,0x4b78010f}},	//   рајн, _иуаш, ријк, _קאלו, 
   {{0x64482587,0x442c2588,0x248805be,0x62802589}},	//   frei, _bwg_, _šama_, dvlo, 
   {{0x6448258a,0xdb0c01d3,0x057000d1,0x649c01e4}},	//   grei, _albé, شايد, sɨin, 
   {{0x442c0207,0x75c800bc,0xb27400d8,0x38040117}},	//   _dwg_, tězs, глош, _созҳ, 
   {{0x26100010,0x442c167c,0xcb340a1e,0x62800b4f}},	//   _cšod_, _ewg_, כניק_, gvlo, 
   {{0x6448258b,0x442c03cb,0xf484258c,0xd4e401d5}},	//   brei, _fwg_, _ماتی, _июли, 
   {{0xc058005e,0x7d000af2,0x037401d3,0x902807d5}},	//   кір_, _úmsh, رحیت_, ьцна_, 
   {{0xdce403e0,0x4fc400c7,0x00000000,0x00000000}},	//   _nokı, тсма, --, --, 
   {{0x2fcc05ce,0x2fd0026c,0x442c01e4,0xa4f400e5}},	//   đeg_, rnzg_, _zwg_, _لکیر_, 
   {{0x442c0457,0x21d402b1,0x7058004e,0x0c8400cf}},	//   _ywg_, pāha_, _заир_, кызм, 
   {{0x6abc258d,0x62940030,0x656c035b,0x03b400fe}},	// [20d0] ्प्र, äzov, _ñahe, ীকৰণ, 
   {{0x8aa4258e,0x60c0010e,0x00000000,0x00000000}},	//   кред, _ýoma, --, --, 
   {{0x65b40413,0x6e941291,0x00000000,0x00000000}},	//   _háhe, _صلحا, --, --, 
   {{0x3eac20e4,0x6448258f,0x2f140014,0x6934049e}},	//   ødte_, yrei, _جِگر, унду, 
   {{0x39440845,0x96640023,0x65b401ef,0x00000000}},	//   рніг, _መርገጻ, _jáhe, --, 
   {{0x64482590,0x442c01d4,0xdb1c004e,0x270c00bc}},	//   vrei, _rwg_, cipà, िखेर_, 
   {{0x64482591,0x442c01ab,0x98e40032,0xbb582592}},	//   wrei, _swg_, ксәһ, _шарх_, 
   {{0x442c01d4,0x64980120,0x60d80356,0x00000000}},	//   _pwg_, етор_, ştmi, --, 
   {{0x2ca82593,0x628001f5,0x240801f0,0xdce4013d}},	//   nyad_, wvlo, ннии_, _yokı, 
   {{0x62801a7c,0x375400db,0x00000000,0x00000000}},	//   tvlo, _ەپەس, --, --, 
   {{0x64482594,0xe4e400ee,0x36d412e7,0x62800165}},	//   srei, _өсдү, _кофр, uvlo, 
   {{0x442c0190,0x62802595,0x291c014b,0xdb1c07c5}},	//   _twg_, rvlo, ncwa_, zipà, 
   {{0x3fc80502,0x62800b4f,0x442c0112,0x00000000}},	//   ندسی_, svlo, _uwg_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x1ea805e6,0x00000000,0x00000000,0x00000000}},	//   راسي_, --, --, --, 
   {{0x25ac2596,0x65b402d2,0x00000000,0x00000000}},	//   nkel_, _fáhe, --, --, 
   {{0x291c009a,0xdb1c004e,0xed340276,0x00000000}},	// [20e0] dcwa_, tipà, рэсэ, --, 
   {{0x9f5c2597,0x61e42598,0x25ac00af,0xdb1c0077}},	//   ötä_, lokl, hkel_, fipá, 
   {{0x25ac2599,0x533400c8,0xdb0c07c5,0xdb1c0109}},	//   kkel_, רנען_, _imbü, ripà, 
   {{0x61e4259a,0x9f580ffb,0x291c01f0,0xe9e40212}},	//   nokl, _ripù_, gcwa_, аціо, 
   {{0x17c80137,0xdce4013d,0xd7c40108,0xdcf40055}},	//   нгди_, _tokı, лёко, bdyā, 
   {{0x25ac259b,0xc9500124,0x50d8010f,0x1ae400f3}},	//   ekel_, атәы, עקסא, _богм, 
   {{0xdb1c259c,0x61e4259d,0xabc401e0,0x21f000bc}},	//   cipá, kokl, _тарҙ, táhl_, 
   {{0xd498259e,0x25ac259f,0x61e425a0,0x5b240124}},	//   еро_, gkel_, jokl, _шьҭа, 
   {{0x5690005e,0x61e400da,0x73d825a1,0x39440165}},	//   рақт, dokl, кдир_, _idms_, 
   {{0x1cb008ea,0x958425a2,0x25ac25a3,0x21f000bc}},	//   ྐྱར_, _әлде, akel_, sáhl_, 
   {{0xdb0c00d2,0x61e425a4,0xe5780042,0x00000000}},	//   _imbó, fokl, rlŷr_, --, 
   {{0x25ac25a5,0x61e425a6,0x65b403b2,0xd9f417ee}},	//   ckel_, gokl, _páhe, ेषित_, 
   {{0xc2e0006c,0xdb0c05d5,0x73c425a7,0xf43411ca}},	//   _қўши, _ambü, _پيغم, _телэ, 
   {{0x4390010b,0x03a003f6,0x21d400dc,0x00000000}},	//   _гашс, _гиљо, bāho_, --, 
   {{0x0ba40046,0x39440789,0x61e425a8,0x2ca80142}},	//   қшам, _odms_, bokl, wyad_, 
   {{0x61e425a9,0xa2d0012c,0x00000000,0x00000000}},	//   cokl, डपर्, --, --, 
   {{0x644400b0,0x7a0c00a2,0x4c140214,0xcc14009a}},	// [20f0] _āhik, _aşto, ابرس, اذرب, 
   {{0x25ac01e4,0xdb1c1e0b,0x00000000,0x00000000}},	//   zkel_, tipá, --, --, 
   {{0xfbd025aa,0x2ca825ab,0x25ac25ac,0x3f840134}},	//   ستك_, syad_, ykel_, ɛmu_, 
   {{0x6e2401ab,0xdb0c0174,0x25ac025c,0x00000000}},	//   _ithb, _umbý, xkel_, --, 
   {{0xf770004b,0x7a0c06be,0x00000000,0x00000000}},	//   ګان_, _eşto, --, --, 
   {{0x2258068f,0x39440f85,0x248825ad,0xdb1c00e5}},	//   ński_, _edms_, _šamo_, pipá, 
   {{0x25ac007d,0x61e425ae,0x98d001f2,0x3944005c}},	//   tkel_, yokl, sịpụ, _fdms_, 
   {{0xa44425af,0x00000000,0x00000000,0x00000000}},	//   анид, --, --, --, 
   {{0x61e425b0,0x00000000,0x00000000,0x00000000}},	//   vokl, --, --, --, 
   {{0x316825b1,0x6e240c8c,0x62640120,0x00000000}},	//   _abaz_, _othb, авоа, --, 
   {{0x224800a7,0xe1f8004e,0x00000000,0x00000000}},	//   ъпни_, кго_, --, --, 
   {{0x31681529,0x61e40024,0x5688010f,0x00000000}},	//   _cbaz_, uokl, _שטײַ, --, 
   {{0x6e240597,0x80c0012c,0x00000000,0x00000000}},	//   _athb, _लेखे, --, --, 
   {{0x443c25b2,0x61e40522,0xdfd025b3,0x21d40374}},	//   msu_, sokl, زيز_, pāho_, 
   {{0xa91c0745,0x61e425b4,0xdc2c03b9,0x5f0402e8}},	//   _každ, pokl, _bığl, рзва, 
   {{0x443c25b5,0x00000000,0x00000000,0x00000000}},	//   osu_, --, --, --, 
   {{0x443c25b6,0xa91c25b7,0x6e24035a,0xdca41fbe}},	// [2100] nsu_, _mažd, _ethb, јази, 
   {{0x443c25b8,0x2fcc0036,0x00000000,0x00000000}},	//   isu_, éegt_, --, --, 
   {{0xfe5804d3,0x5a94013e,0x8f980a1e,0x443c25b9}},	//   _حیزب_, шраф, _סיטי, hsu_, 
   {{0xeaf80075,0xdb1c05d1,0x5d54004e,0x00000000}},	//   ھرەت_, kipç, _өкүт, --, 
   {{0x8d7425ba,0xac740023,0xeaf80116,0x00000000}},	//   _ئاپا, ጠልጢሉ_, پرەت_, --, 
   {{0x6e2402d0,0xdb0c00d7,0x00000000,0x00000000}},	//   _ythb, _hlbí, --, --, 
   {{0x443c25bb,0xdb0c004e,0xa91c16a3,0xdec80092}},	//   esu_, _embò, _bažd, _በውኃ_, 
   {{0x98a425bc,0x18a425bd,0x00000000,0x00000000}},	//   _кибе, _кабм, --, --, 
   {{0x79800428,0x23a800d2,0x443c25be,0xb0c40034}},	//   _iamw, _lúju_, gsu_, _लेंग, 
   {{0x798025bf,0xa3c40882,0x93a425c0,0xdb0c09e8}},	//   _hamw, _एषः_, ршид, _umbó, 
   {{0x443c25c1,0x75ec019f,0xe6840124,0x67ec01ed}},	//   asu_, wûzu, _гәык_, gúju, 
   {{0x443c25c2,0xdb1c25c3,0x932400f2,0xa4f0008e}},	//   bsu_, lipä, درکن, _çişü_, 
   {{0xcfa425c4,0x798025c5,0x8d7402c0,0x84600801}},	//   ашви, _mamw, یارا, _дъще, 
   {{0x79800585,0xdb1c25c6,0xd1001025,0xdc2c0205}},	//   _lamw, nipä, रेषण_, _sığl, 
   {{0xc3f80302,0x76a8013f,0xf23801d5,0x00000000}},	//   _שלוש, bɛye, _ёпиш_, --, 
   {{0xa91c08ad,0x798025c7,0xdb1c25c6,0xd018014b}},	//   _kaže, _namw, hipä, _ифо_, 
   {{0xdb1c25c8,0x4b24007b,0xbc3800be,0xa3bc01f9}},	// [2110] kipä, لعاف, لسلا_, ीचच_, 
   {{0xa91c02d5,0x80c025c9,0x1cb00327,0xdb0c01d3}},	//   _maže, _लेटे, ྐྱེ_, _elbí, 
   {{0x798025ca,0x7a0c00a2,0xdb0c0129,0x7ac417a0}},	//   _bamw, _eştm, _albâ, осце, 
   {{0xfe7025cb,0x7980015d,0xd24400f7,0x00000000}},	//   _کدی_, _camw, _ۉن_, --, 
   {{0x798025cc,0x6d5c03ac,0xa91c0306,0x49b801d5}},	//   _damw, _icsa, _naže, _یارد_, 
   {{0x79800086,0xdb1c00af,0xd2441d00,0x00000000}},	//   _eamw, gipä, _ىن_, --, 
   {{0xe6880137,0x79800142,0xba74007b,0x443c00d7}},	//   انبى_, _famw, _وافت, wsu_, 
   {{0x443c07ad,0x798025cd,0x00000000,0x00000000}},	//   tsu_, _gamw, --, --, 
   {{0x69c825ce,0xdb1c000d,0x00000000,0x00000000}},	//   _imee, bipä, --, --, 
   {{0x443c25cf,0x798025d0,0x639407d8,0xa0a40032}},	//   rsu_, _zamw, сшиф, ҡанд, 
   {{0x443c25d1,0xf77025d2,0x798025d3,0xa2e425d4}},	//   ssu_, _زال_, _yamw, сонд, 
   {{0x443c25d5,0xe8e40327,0xf6502586,0x00000000}},	//   psu_, _སྙོག, _آئل_, --, 
   {{0x69c825d6,0xa91c2375,0x644400b0,0x95e404b3}},	//   _mmee, _gaže, _āhiw, _اينۇ, 
   {{0x6d5c25d7,0x84c000fd,0x00000000,0x00000000}},	//   _acsa, _гәүд, --, --, 
   {{0xa91c25d8,0x65b40122,0x69c825d9,0x5dd8010b}},	//   _zaže, _záha, _omee, гфар_, 
   {{0x2d942503,0x3d2825da,0x91e000a7,0xe3f80451}},	//   орус, شتری_, _ноще, _جوڙڻ_, 
   {{0x798025db,0x3ba40107,0x00000000,0x00000000}},	// [2120] _ramw, олаҳ, --, --, 
   {{0x69c825dc,0xed58016c,0xe8e4025c,0x6ee001f2}},	//   _amee, лоӣ_, _སྙེག, _ịbel, 
   {{0x798025dd,0x2bb80574,0x9f0400f1,0x3eb00311}},	//   _pamw, _इतरा, _دودو, ântă_, 
   {{0x798025de,0xdec8010c,0x00000000,0x00000000}},	//   _qamw, _በልና_, --, --, 
   {{0x79801cbd,0x51580375,0xdb1c16ca,0x67ec01d3}},	//   _vamw, רכנו, tipä, yújt, 
   {{0x798025df,0xd49825e0,0x69c825e1,0xa91c25e2}},	//   _wamw, ғри_, _emee, _raže, 
   {{0xa91c25e3,0xdb1c25e4,0x798025e5,0x65b425e6}},	//   _saže, ripä, _tamw, _sáha, 
   {{0xa91c02d5,0xdb1c25e7,0x69c80036,0x65b40162}},	//   _paže, sipä, _gmee, _páha, 
   {{0xd7f0007b,0xf8b025e8,0x73c400fb,0xdb1c01f4}},	//   _فكر_, _تکا_, жәйе, pipä, 
   {{0xd37825e9,0xa91c098d,0x65b402fb,0x00000000}},	//   учи_, _važe, _váha, --, 
   {{0xc7b00375,0x050c0055,0x58d401ee,0x00000000}},	//   _צבע_, _śītī_, _тоҡт, --, 
   {{0xa91c0118,0xc2b400d4,0x00000000,0x00000000}},	//   _taže, слює_, --, --, 
   {{0xd4f41a57,0x00000000,0x00000000,0x00000000}},	//   _اثاث, --, --, --, 
   {{0x823000dd,0x65b401ef,0x00000000,0x00000000}},	//   _کروا, _jáhn, --, --, 
   {{0x09cc000e,0x765c03cd,0x00000000,0x00000000}},	//   িকতা, _åryd, --, --, 
   {{0x7bdc0003,0x4638010f,0x8de801a9,0x00000000}},	//   _ajru, טעלע, уфга_, --, 
   {{0xdb0c00db,0xeb3825ea,0x69c80076,0x00000000}},	// [2130] _albà, изаш_, _rmee, --, 
   {{0x69c825eb,0x7afc010a,0x00000000,0x00000000}},	//   _smee, _bzrt, --, --, 
   {{0x954003e3,0xa91c013a,0x00000000,0x00000000}},	//   _əşrə, _ražb, --, --, 
   {{0xe8e40327,0x6d5c02d0,0x00000000,0x00000000}},	//   _སྙུག, _ucsa, --, --, 
   {{0xe7380c56,0xa91c0306,0x417c008f,0x00000000}},	//   аел_, _pažb, טנאב, --, 
   {{0x8d740131,0x00000000,0x00000000,0x00000000}},	//   _ئاھا, --, --, --, 
   {{0x660425ec,0x56901677,0x00000000,0x00000000}},	//   опка, дајт, --, --, 
   {{0x69c825ed,0x386001c3,0x00000000,0x00000000}},	//   _umee, àirc_, --, --, 
   {{0x3e70006a,0xe3b825ee,0x69d8014b,0x39140108}},	//   _kötö_, иби_, mnwe, _хмур, 
   {{0x1cb0031c,0x2600002e,0x87d425ef,0x00000000}},	//   ྐྱི_, kóog_, _اغرا, --, 
   {{0x6b8002d2,0x00000000,0x00000000,0x00000000}},	//   _ólgu, --, --, --, 
   {{0x69d825f0,0x33b000d1,0x208801d5,0x7a4000e5}},	//   nnwe, _ۋەير, айми_, _hátá, 
   {{0x09a4069f,0x64a425f1,0xdbc400af,0x7a30007f}},	//   _खवैय, _фала, mööb, _kòtò, 
   {{0x440425f2,0x232825f3,0x69d80112,0x6568002f}},	//   _учеб, _токи_, hnwe, lfeh, 
   {{0xdd9025f4,0x51f401d3,0x00000000,0x00000000}},	//   ووس_, _ڈسٹر, --, --, 
   {{0x656825f5,0x69d80196,0x7bdc0158,0x7a4001d3}},	//   nfeh, jnwe, _sjru, _látá, 
   {{0xfaf80029,0x9f5801e1,0xdbc801c0,0xfb1801d3}},	// [2140] _šī_, _dipò_, агад_, مراں_, 
   {{0x69d825f6,0x7a0c0cc1,0xe81c0c2e,0xdb0c01f6}},	//   enwe, _işti, _पढ़ा_, _albá, 
   {{0x65b425f7,0x9f580241,0x9f0404fb,0xf0000139}},	//   _náho, _fipò_, _گوگو, _чүри, 
   {{0x69d8009a,0x65b40118,0x00000000,0x00000000}},	//   gnwe, _sáhn, --, --, 
   {{0x7a400241,0x00000000,0x00000000,0x00000000}},	//   _bátá, --, --, --, 
   {{0x69d8017a,0x9f58007f,0x1b740214,0x65b400d7}},	//   anwe, _zipò_, _بدحج, _báho, 
   {{0xd5b825f8,0x8f9825f9,0x316c0161,0xdb0c02d2}},	//   иси_, ייסי, ŵezi_, _ambö, 
   {{0x77b4004e,0x7a0c0356,0x656800e5,0x2da40092}},	//   _tàxo, _oşti, gfeh, _ወገኖቼ_, 
   {{0x65b40118,0x81e000eb,0x00000000,0x00000000}},	//   _táhn, থতা_, --, --, 
   {{0xe8e4003d,0x3e7c01e4,0xccf0011a,0x644425fa}},	//   _སྙིག, _oŭt_, וכח_, _āhit, 
   {{0x741425fb,0x65680e78,0xf28801c0,0x4bf8008f}},	//   _کوتا, bfeh, сөлд_, שליס, 
   {{0xd46825fc,0x7658019f,0xa91c00ef,0x65b401ef}},	//   _виде_, muvy, _kaža, _jáhl, 
   {{0x3e7c01e4,0x65b425fd,0x765801f7,0x9f4c0122}},	//   _aŭt_, _záho, luvy, šným_, 
   {{0x9f580699,0xa91c02d5,0xb4c825fe,0x3f9c004e}},	//   _sipò_, _maža, ोपी_, _òvul_, 
   {{0xa91c0960,0x0ef0015b,0xbe8825ff,0x82300b24}},	//   _laža, ছেনঃ_, осте_, _قريا, 
   {{0x65b402fd,0x22500030,0x22a401f0,0xf8bc00cd}},	//   _náhl, ázke_, _хушҳ, ्छाय, 
   {{0xa91c04b9,0x7024031c,0xec1401e2,0xfc6402e8}},	// [2150] _naža, _འཕྲུ_, سواد, дъхн, 
   {{0x765807a8,0xfc3000c6,0x68300248,0x7e7c0042}},	//   kuvy, ضحك_, _lódò, bwrp, 
   {{0x7a400491,0x21d40053,0x41c40014,0x37d0015b}},	//   _rátá, wāhi_, _رٲیِ, াকার, 
   {{0x1cb00135,0x3eac03fa,0x59a402ab,0xa91c2600}},	//   ྐྱང_, ädte_, कॉलर, _baža, 
   {{0x69d82601,0x7a400ca8,0xe72801c6,0x00000000}},	//   rnwe, _pátá, болд_, --, 
   {{0xa91c2602,0x0058011a,0x00000000,0x00000000}},	//   _daža, קשות_, --, --, 
   {{0xc9742603,0xdb0c00b5,0x6568002f,0xa934010a}},	//   _وارث, _albæ, tfeh, _невш, 
   {{0x3178006d,0x795822f7,0x65b40313,0xa91c1dd5}},	//   jesz_, _миср_, _váho, _faža, 
   {{0x317801ed,0x65682604,0x651401ed,0x7e7c0165}},	//   desz_, rfeh, _ہوائ, zwrp, 
   {{0x65682605,0x65b40216,0xe3b823be,0x00000000}},	//   sfeh, _záhl, сбо_, --, 
   {{0x65680639,0x45a00075,0x65142606,0x333c0175}},	//   pfeh, _يەتك, _فوائ, _devx_, 
   {{0x21682607,0x00000000,0x00000000,0x00000000}},	//   щими_, --, --, --, 
   {{0xdb040793,0xe35400ee,0xe5081e24,0xb5c80345}},	//   _ämög, _етйэ, _ايشو_, _بونم_, 
   {{0x66082608,0x21f002fb,0x00000000,0x00000000}},	//   lmek, váhu_, --, --, 
   {{0x0204013e,0x7a0c0139,0x137800f1,0x2174009b}},	//   _оҷон, _iştv, _دجنګ_, _еупр, 
   {{0x3178068f,0x9c242609,0x6608260a,0xd24c00c6}},	//   cesz_, здад, nmek, _إني_, 
   {{0x6608004b,0x00000000,0x00000000,0x00000000}},	// [2160] imek, --, --, --, 
   {{0x6608260b,0xa91c260c,0x65b4013a,0x7658260d}},	//   hmek, _raža, _sáhl, yuvy, 
   {{0x6608260e,0xa91c05a1,0x2008260f,0x00000000}},	//   kmek, _saža, mmbi_, --, 
   {{0xa91c0006,0x9f480122,0xceb00375,0x00000000}},	//   _paža, dobé_, _ניר_, --, 
   {{0xdb0c019f,0x660800c5,0x44f805c7,0x5cf401c4}},	//   _ambô, dmek, _n̪_, _хяну, 
   {{0xa91c098d,0x3a38020b,0x80d4015b,0x6608004b}},	//   _važa, _twrp_, _সরঞ্, emek, 
   {{0x5ac4025c,0x20081418,0xdce40153,0x65b40118}},	//   _གཟིམ, imbi_, _pakė, _táhl, 
   {{0x44f805c7,0x76582610,0x6608010e,0x00000000}},	//   _b̪_, ruvy, gmek, --, 
   {{0xa91c0989,0x62942611,0xb4c800cd,0x317800e5}},	//   _kažn, åzon, ोपे_, vesz_, 
   {{0x44f805c7,0x12e401ec,0x19dc0150,0x88b8011a}},	//   _d̪_, зімг, _ﺃﻓﻀﻠ, _הזמי, 
   {{0x3dc00472,0x317801d3,0x00000000,0x00000000}},	//   khiw_, tesz_, --, --, 
   {{0xa91c08a4,0x21d402b5,0x2bb800cd,0x00000000}},	//   _lažn, kāhu_, _इत्थ, --, 
   {{0x26080d5f,0xf0e81870,0x826001d5,0x73c40150}},	//   ागरी_, زىسى_, وهین, _және, 
   {{0x03a02612,0x7538033f,0x00000000,0x00000000}},	//   _пичо, ńczą, --, --, 
   {{0x7ee42613,0x43802614,0x2fd00010,0x00000000}},	//   ецте, _سليق, rizg_, --, 
   {{0x70580131,0x2b40037e,0xe81c0037,0x00000000}},	//   _даир_, wahc_, _पढला_, --, 
   {{0xa91c02d5,0x62840008,0x6c142615,0x3d3800a8}},	// [2170] _bažn, _áhor, ддаф, яптэ_, 
   {{0xf6b80156,0x66082616,0x2fd001a9,0x00000000}},	//   ྐྱོང, zmek, qizg_, --, 
   {{0xa91c0953,0xfe242617,0x386008c2,0xdb1400b8}},	//   _dažn, _пьян, àirn_, _įcãk, 
   {{0x2bb801f9,0x21d400b8,0x00000000,0x00000000}},	//   _इतका, bāhu_, --, --, 
   {{0x81b003f9,0x2d982618,0x7648036e,0x660803e0}},	//   _jiɓa, _inse_, _avdy, vmek, 
   {{0xdc5404d3,0x8bf404c5,0x2d882619,0xa69410fc}},	//   _کرێک, _অংকন_, ldae_, дриј, 
   {{0x6608261a,0x80d40c58,0xe628004b,0xe5a400d1}},	//   tmek, _সৰঞ্, زګان_, дийи, 
   {{0x2d88261b,0x76480076,0x44f805c7,0x9f48261c}},	//   ndae_, _dvdy, _p̪_, robé_, 
   {{0x6608261d,0x2d88261e,0x00000000,0x00000000}},	//   rmek, idae_, --, --, 
   {{0xe7940a81,0x6608261f,0xd7640075,0xe3b000c6}},	//   _تارک, smek, _يەنى_, ئرة_, 
   {{0x2d980925,0xd7e8129d,0x2d88017a,0xf6502620}},	//   _onse_, _بولۇ_, kdae_, _مئن_, 
   {{0xa91c0006,0x44f805c7,0xdb1c036e,0x00000000}},	//   _mažo, _t̪_, thpë, --, 
   {{0xa91c05a1,0x2d880ea0,0x10a02621,0x00000000}},	//   _lažo, ddae_, виян, --, 
   {{0x2d982622,0x3fcc09bd,0x2d882623,0xf4c40209}},	//   _anse_, লক্ষ, edae_, şýän_, 
   {{0x248c2624,0xa91c2625,0xdb1c0023,0x3dc00fec}},	//   lvem_, _ražn, shpë, thiw_, 
   {{0x5bb40c93,0x21742626,0x21d400b0,0x57a80073}},	//   ःस्व, _цукр, tāhu_, _कव्ह, 
   {{0xa91c1326,0x5ba82627,0xa3b00254,0x8c402628}},	// [2180] _pažn, окам_, _टका_, кете, 
   {{0x2d982629,0x2d880393,0x00000000,0x00000000}},	//   _ense_, adae_, --, --, 
   {{0xa91c04b9,0xdce400b0,0x248c262a,0x4f98011a}},	//   _važn, _kakī, hvem_, _וביצ, 
   {{0xdcf40100,0xa91c262b,0x248c0450,0x00000000}},	//   leyč, _dažo, kvem_, --, 
   {{0x6c740364,0xa91c022a,0x00000000,0x00000000}},	//   _пурх, _tažn, --, --, 
   {{0xa91c107d,0x8c400640,0x60c0010b,0x248c00e5}},	//   _fažo, _јере, _ýomu, dvem_, 
   {{0x7c240054,0x00000000,0x00000000,0x00000000}},	//   lqir, --, --, --, 
   {{0x77b40228,0xc7200032,0x1ddc262c,0x00000000}},	//   _màxi, ндәй, नचित, --, 
   {{0x7c24262d,0x1868262e,0xe8500133,0x00000000}},	//   nqir, _фази_, _مۆند, --, 
   {{0x9268262f,0xf8b005d9,0xa91c2630,0x2d88003a}},	//   орма_, _لکڻ_, _lažl, zdae_, 
   {{0x7c242631,0xc7d4025d,0x3c242632,0x2d880ea0}},	//   hqir, _קובי_, _löv_, ydae_, 
   {{0x225004bf,0x82302633,0xcb100375,0xa91c01ef}},	//   ázka_, کریا, כלת_, _nažl, 
   {{0x3c2400ac,0x461004fb,0x22582634,0x00000000}},	//   _növ_, _شوهر, ąska_, --, 
   {{0x1cb00dd4,0x7c2406be,0x00000000,0x00000000}},	//   ྐྱབ_, dqir, --, --, 
   {{0x657400e5,0x00000000,0x00000000,0x00000000}},	//   őzhe, --, --, --, 
   {{0xa91c0029,0x00000000,0x00000000,0x00000000}},	//   _ražo, --, --, --, 
   {{0x2d882635,0x7c2400aa,0x0ba818fd,0x4cdc00eb}},	// [2190] rdae_, gqir, يائى_, _মরহু, 
   {{0x2d880660,0x09d40490,0x3b542636,0x3c242632}},	//   sdae_, ढच्य, ккур, _döv_, 
   {{0x248c012c,0xbf140050,0x160c2637,0xe9b400c7}},	//   zvem_, _لوٝب, ागार_, нбжь, 
   {{0xac1817d8,0x2d982638,0x7c2401b9,0x00000000}},	//   _ному_, _unse_, bqir, --, 
   {{0x67d42639,0x00000000,0x00000000,0x00000000}},	//   ноду, --, --, --, 
   {{0x77841cb8,0x00000000,0x00000000,0x00000000}},	//   кліз, --, --, --, 
   {{0x26d8013f,0x65b4032e,0x00000000,0x00000000}},	//   _ɛsow_, _háhi, --, --, 
   {{0xff180375,0x65b402fb,0x248c00bc,0xdcf4007f}},	//   וקות_, _káhi, tvem_, zeyč, 
   {{0x248c007f,0xe854072d,0xf8f40024,0x00000000}},	//   uvem_, _سناد, _аптэ, --, 
   {{0xf770263a,0x248c263b,0xa91c0024,0x2488263c}},	//   _نام_, rvem_, _mažm, _šams_, 
   {{0x85880b87,0x7a0c03b9,0x65940107,0x00000000}},	//   _мёда_, _iştr, _пажу, --, 
   {{0x3634263d,0x56b4008f,0x7c24263e,0x00000000}},	//   _شرمس, _אפען_, yqir, --, 
   {{0x60b401d5,0x65b402d2,0x4f480023,0x936c0055}},	//   رمسئ, _náhi, _ንምዝር, _ṅgāṅ, 
   {{0x6448263f,0x78a41073,0x3c2401e3,0xa2e40108}},	//   msei, äivi, _röv_, _полд, 
   {{0x64482640,0xa91c0989,0x00000000,0x00000000}},	//   lsei, _pažl, --, --, 
   {{0x442c2641,0xdca42642,0x64482643,0x12d40150}},	//   _ktg_, наби, osei, _ﺘﺒﻠﻭ, 
   {{0x64482644,0x9f4800cf,0xdcf40100,0x59b42645}},	// [21a0] nsei, lobí_, peyč, _अकबर, 
   {{0x442c019b,0x644801c3,0x7c242646,0x1e8420c8}},	//   _mtg_, isei, rqir, _злом, 
   {{0x64480369,0x9d442647,0xdb1c000d,0x7ddc0139}},	//   hsei, _пенд, mipü, bäsе, 
   {{0xdca42648,0x20180053,0x18682649,0x442c0c86}},	//   _зами, _hipi_, зади_, _otg_, 
   {{0x201818a6,0x7c240194,0x6448005c,0x00000000}},	//   _kipi_, qqir, jsei, --, 
   {{0x6448264a,0xc7a0189d,0x07a007c6,0xd1c40023}},	//   dsei, личк, лачн, _ጽዑቕ_, 
   {{0x2018264b,0x64481140,0xa91c16a3,0x8af40064}},	//   _mipi_, esei, _zažm, _знёс_, 
   {{0x9f48031d,0xa91c151c,0x442c264c,0x6448264d}},	//   dobí_, _lažj, _btg_, fsei, 
   {{0x48e00d1d,0x00000000,0x00000000,0x00000000}},	//   _ботв, --, --, --, 
   {{0x442c264e,0x2018264f,0x61f40209,0xd24c0014}},	//   _dtg_, _nipi_, _akyl, مۆت_, 
   {{0x96942650,0x442c143a,0xa2802651,0x64482652}},	//   _яраш, _etg_, لیوو, asei, 
   {{0x64482653,0x442c2654,0x268814a0,0x324401e0}},	//   bsei, _ftg_, _زخمي_, неүг, 
   {{0x442c0998,0x2018166a,0xc5ec121e,0x00000000}},	//   _gtg_, _bipi_, _آن_, --, 
   {{0x61f402d0,0xa91c0427,0x2268005b,0x7dc401b9}},	//   _ekyl, _ražm, ötkö_, қёсд, 
   {{0x201807ab,0x0290007b,0xca4c0150,0xdb0c2655}},	//   _dipi_, _مؤيد, _ﺍﻋﺎ_, _àjèj, 
   {{0x65b400e4,0x00000000,0x00000000,0x00000000}},	//   _páhi, --, --, --, 
   {{0x32082656,0xa2980b82,0x6ad82429,0xfc300efe}},	// [21b0] _ihay_, _ፈተናን_, भप्र, محل_, 
   {{0x20180048,0x4ea4009b,0x00000000,0x00000000}},	//   _gipi_, _зрма, --, --, 
   {{0x320801fb,0x64480399,0x8ae400d4,0x00000000}},	//   _khay_, zsei, хіал, --, 
   {{0xdb0c006a,0x2018249d,0x32080109,0x64482657}},	//   _kobê, _zipi_, _jhay_, ysei, 
   {{0x50b02658,0x477001ec,0xec14007b,0x6448002f}},	//   ुनिष, лқау, _لوحد, xsei, 
   {{0xa91c02d5,0x66180113,0x644800c5,0xa6980114}},	//   _kažk, _siwk, vsei, дњих_, 
   {{0x3208035a,0x6618012d,0x00000000,0x00000000}},	//   _ohay_, _piwk, --, --, 
   {{0x64482659,0x442c0020,0xe578016c,0xc9840032}},	//   tsei, _ptg_, фзи_, _яуги, 
   {{0x442c265a,0xa814265b,0x6448265c,0xd5ac007b}},	//   _qtg_, _адаш, usei, تفي_, 
   {{0x3208265d,0x68e80c8c,0x6378265e,0x00000000}},	//   _ahay_, _ixed, фсир_, --, 
   {{0x6448265f,0xa2e42660,0x32080280,0x20182661}},	//   ssei, тонд, _bhay_, _ripi_, 
   {{0x32082662,0x442c2663,0x20182664,0x64482665}},	//   _chay_, _ttg_, _sipi_, psei, 
   {{0x442c2666,0x9f480232,0x63840209,0x64480399}},	//   _utg_, sobí_, _агла, qsei, 
   {{0x320814dc,0xb3700092,0x00000000,0x00000000}},	//   _ehay_, ባቢውን_, --, --, 
   {{0x20182667,0x8fa02668,0xdb1c0254,0x00000000}},	//   _vipi_, шаре, ripü, --, 
   {{0x61f40921,0x3208047e,0x20180477,0xa91c00e2}},	//   _ukyl, _ghay_, _wipi_, _dažk, 
   {{0x20182669,0xa3d402e5,0x79580241,0x00000000}},	// [21c0] _tipi_, _सगा_, _lúwà, --, 
   {{0x2018266a,0xa2c411bc,0x200c01e1,0xf38c00df}},	//   _uipi_, ानप्, _òfi_, ּראָ, 
   {{0xcf54025f,0x0f5404ac,0x68e8035a,0x320802d0}},	//   _בבית_, _ביים_, _axed, _yhay_, 
   {{0x3eb800ad,0x29d40306,0xdb1c02f0,0xe9c40022}},	//   myrt_, sťan_, tipó, лахҿ, 
   {{0x893401ec,0x61e408a5,0x00000000,0x00000000}},	//   тпіс_, _íhlu, --, --, 
   {{0xa6ac0183,0x3eb8062c,0xdb1c00e4,0x00000000}},	//   _কেইট, oyrt_, ripó, --, 
   {{0x68e8266b,0x9a140022,0xcb64030d,0x00000000}},	//   _exed, _афаш, _шаре_, --, 
   {{0xa2c400e0,0xd5b00073,0xceb0011a,0xa91c013a}},	//   ानन्, _जवळज, שיה_, _nažh, 
   {{0x65b402f0,0x7afc010e,0x3944266c,0x335400db}},	//   _náhu, _hyrt, _iems_, гүлө_, 
   {{0x7afc0652,0x8d800020,0x3208266d,0x3944005c}},	//   _kyrt, ርበታል_, _shay_, _hems_, 
   {{0x3208266e,0x59b4266f,0xd3940032,0x27e82670}},	//   _phay_, _अकार, еҙҙә_, éane_, 
   {{0x39442671,0x00000000,0x00000000,0x00000000}},	//   _jems_, --, --, --, 
   {{0x6284006a,0x394400b5,0x3eb80076,0x00000000}},	//   _âhon, _mems_, eyrt_, --, 
   {{0x40340d31,0x39442672,0x3eb803cd,0xd160035b}},	//   рерс, _lems_, fyrt_, ынҭқ, 
   {{0x32082673,0xdb0c02d3,0x0db82674,0xe888001f}},	//   _thay_, _dobë, وارث_, _በውስጡ_, 
   {{0x32082675,0x39442676,0x00000000,0x00000000}},	//   _uhay_, _nems_, --, --, 
   {{0x6b740bd6,0x3eb81368,0x52e02677,0x70942678}},	// [21d0] ллау, ayrt_, _पशुस, _сапф, 
   {{0x7afc2679,0x3eb80363,0xd12c00db,0xed501374}},	//   _byrt, byrt_, _دۅڭ_, _گھس_, 
   {{0x7afc0142,0x65b40306,0x6d7c0023,0x00000000}},	//   _cyrt, _záhu, _ብጎይታ_, --, 
   {{0xe944267a,0x7afc0194,0xa91c267b,0xf7700014}},	//   ارای, _dyrt, _kaži, ۪ان_, 
   {{0x9f480085,0x88c4267c,0xdb0c007f,0x3da40953}},	//   lobá_, ختال, _lobè, _трэб, 
   {{0xa91c02d5,0x66e4267d,0xdb1c007f,0x00000000}},	//   _maži, лола, sipò, --, 
   {{0xf770267e,0x3944267f,0xdb0c02e2,0x9ba00c50}},	//   تان_, _fems_, _nobè, _دەلى, 
   {{0x39442680,0x6e242681,0x75d80124,0x00000000}},	//   _gems_, _muhb, кьыс_, --, 
   {{0x7afc044e,0x69d82682,0x00000000,0x00000000}},	//   _zyrt, miwe, --, --, 
   {{0x69d82683,0x13e40724,0xa91c0306,0xa0a40b01}},	//   liwe, лмый_, _naži, ҳамд, 
   {{0x21682684,0x61442685,0xdb0c2686,0x3944009a}},	//   нини_, лена, _cobè, _yems_, 
   {{0x69d82687,0xdb0c068c,0x9f480122,0x525400c7}},	//   niwe, _dobè, dobá_, ыхьӡ, 
   {{0xd24c2688,0x9f4800a3,0x59b40037,0xa91c0c5e}},	//   ينی_, tobà_, _अकसर, _baži, 
   {{0x3eb82689,0x69d8268a,0x76a8016b,0x386001c3}},	//   tyrt_, hiwe, wɛyi, àiri_, 
   {{0x69d8268b,0xd36c16cb,0x2eb41064,0xa91c1ebf}},	//   kiwe, _رهي_, астс, _daži, 
   {{0x69d80451,0x6e24268c,0x3f8c268d,0xdee41086}},	//   jiwe, _duhb, ždu_, воҳи, 
   {{0x3944268e,0x69d8268f,0x672009a8,0x7afc2690}},	// [21e0] _rems_, diwe, _oglj, _syrt, 
   {{0x39442691,0x7afc138f,0x0b402692,0x69d8017a}},	//   _sems_, _pyrt, йнун, eiwe, 
   {{0xdb0c02ea,0x6e240007,0x26c801e4,0xad2400e5}},	//   _kobé, _guhb, ŝaoj_, ارہو, 
   {{0xa91c1b5c,0x69d80a1d,0x7afc036e,0x5cf40024}},	//   _zaži, giwe, _vyrt, _бягу, 
   {{0xdb0c043b,0xd7f82693,0x394401e3,0x7afc0042}},	//   _mobé, нук_, _vems_, _wyrt, 
   {{0x7afc003a,0x69d82694,0x765c0fac,0x2600002e}},	//   _tyrt, aiwe, _åryk, sóol_, 
   {{0x2604069f,0xf1c00232,0x69d82695,0x394404cc}},	//   _हीही_, ášky_, biwe, _tems_, 
   {{0x35b42696,0x69d82697,0xd1f4001f,0xdb0c2698}},	//   рбир, ciwe, _ለፊት_, _robè, 
   {{0x41a80050,0xa2d82699,0x13680801,0x73c401e0}},	//   गानस, _फेब्, ншни_, ҫәһе, 
   {{0xc7a00022,0xb2740408,0x07a00229,0x00000000}},	//   _лиук, алош, _лаун, --, 
   {{0xdb0c02ea,0x63b401ed,0xa91c269a,0xa3d409ab}},	//   _bobé, özna, _raži, _सगर_, 
   {{0x506405f5,0xf484006c,0x0ecc00c5,0xa6ac00fe}},	//   лтга, _ناتی, _हेगड, _কেকট, 
   {{0x6e2407d6,0xa91c02d5,0xdb0c0036,0x50640006}},	//   _suhb, _paži, _dobé, ытна, 
   {{0x69d8269b,0x4fc4269c,0x9f480798,0x00000000}},	//   ziwe, усма, tobá_, --, 
   {{0xa91c02d5,0x8a940220,0x69d8269d,0xb33c0327}},	//   _važi, _ءﻭﻧﺪ, yiwe, jjħi, 
   {{0x69d807a9,0xdb0c269e,0xd1b80228,0x65b4032e}},	//   xiwe, _gobé, _ساعا_, _háhr, 
   {{0x69d8269f,0x41c426a0,0xca4c0150,0x00000000}},	// [21f0] viwe, _دقيق, _ﺍﻋﺘ_, --, 
   {{0x69d826a1,0x0ae826a2,0x6e2420a9,0x4ae8005b}},	//   wiwe, ىراي_, _tuhb, ньем_, 
   {{0x69d807a9,0xd1cc0023,0x786400d1,0x00000000}},	//   tiwe, _ባሮት_, ەدىك, --, 
   {{0x89340597,0x202402e8,0xa91c0153,0x7de001ef}},	//   اعضا, _èpiù_, _mažv, _písň, 
   {{0x69d826a3,0x9ce80014,0xfc780023,0x00000000}},	//   riwe, _لوَے_, _ኣጋጢሙ_, --, 
   {{0xd24426a4,0x65b403c6,0x69d826a5,0xfe7026a6}},	//   _ون_, _náhr, siwe, _بدی_, 
   {{0x69d826a7,0x2ca80009,0xb8fc07b7,0x00000000}},	//   piwe, lxad_, _णे_, --, 
   {{0x69d8004b,0x60c0025c,0x6498026b,0x7de0013a}},	//   qiwe, _żomm, втор_, _tísň, 
   {{0xdb0c0139,0x00000000,0x00000000,0x00000000}},	//   _robé, --, --, --, 
   {{0x6720098d,0xe298026a,0x96900014,0xa3d40073}},	//   _uglj, вао_, _ڈیٖش, _सगळ_, 
   {{0xd5ac26a8,0xdb0c0036,0x21a400c7,0x00000000}},	//   سفی_, _pobé, аинм, --, 
   {{0xd1d0010c,0xa91c00de,0x00000000,0x00000000}},	//   _ከፊቱ_, _dažv, --, --, 
   {{0x81b003f9,0xa11402e9,0xa07401ec,0x55b8011a}},	//   _jiɓi, شوست, шынш, _שמנו, 
   {{0x201c26a9,0xdb1c01b8,0x25ac00c5,0x2600002e}},	//   öti_, mipö, ljel_, kóok_, 
   {{0xdb0c013a,0xdb1c0108,0x00000000,0x00000000}},	//   _blbý, lipö, --, --, 
   {{0x65b401a2,0x91e026aa,0x00000000,0x00000000}},	//   _záhr, _моще, --, --, 
   {{0x5b340f1b,0xa91c01a6,0x60080cdd,0xe7c40073}},	// [2200] لعار, _kažu, _иним_, वसाप, 
   {{0xde28036b,0xed58013e,0xdb0c0356,0x00000000}},	//   _ижод_, коӣ_, _dobî, --, 
   {{0xa91c26ab,0x25ac26ac,0xa3cc2122,0x9f0412ea}},	//   _mažu, kjel_, _रतन_, _خودو, 
   {{0x25ac26ad,0xdb1c0793,0x61e426ae,0x00000000}},	//   jjel_, kipö, nnkl, --, 
   {{0x57a426af,0x61e426b0,0x25ac0118,0xfcc401e0}},	//   ишка, inkl, djel_, _уҙам, 
   {{0x8c400da9,0x61e4002f,0xda641e5a,0xa91c00ef}},	//   _фере, hnkl, _پاسي, _nažu, 
   {{0x4b781203,0x9f58145e,0xd94426b1,0x27e800ae}},	//   _שאלו, _akpë_, _веби, éana_, 
   {{0xd49826b2,0x25ac0240,0x61e401a4,0xdb0c0142}},	//   вро_, gjel_, jnkl, _hobï, 
   {{0x81b003f9,0xa91c00f3,0x56900220,0xf3f821fa}},	//   _giɓi, _sažv, сақт, лниш_, 
   {{0xd1f4044e,0x61e40af9,0xa91c0024,0x00000000}},	//   ለዎት_, enkl, _pažv, --, 
   {{0xa91c1ebf,0x91a009bb,0x00000000,0x00000000}},	//   _dažu, गालै, --, --, 
   {{0x05b000c6,0xdb0c015d,0x6aa0032e,0x00000000}},	//   _وملح, _lobï, _álfe, --, 
   {{0xdb0c0365,0xdb1c0254,0x339400c0,0x00000000}},	//   _albü, mipõ, _галё, --, 
   {{0x61e426b3,0xdb1c0037,0xd1cc0092,0x00000000}},	//   ankl, lipõ, _ባዮች_, --, 
   {{0x82f401b9,0xc32c075e,0x00000000,0x00000000}},	//   _پروز_, _تەپ_, --, --, 
   {{0x823026b4,0x3da426b5,0xdb1c0254,0x00000000}},	//   _بروا, оруб, nipõ, --, 
   {{0xe2380092,0x00000000,0x00000000,0x00000000}},	// [2210] _የተሳና, --, --, --, 
   {{0x2ca801d9,0x00000000,0x00000000,0x00000000}},	//   rxad_, --, --, --, 
   {{0x6e940491,0x00000000,0x00000000,0x00000000}},	//   _الجا, --, --, --, 
   {{0xdb0c26b6,0xf9d400d4,0x00000000,0x00000000}},	//   _albó, оцію, --, --, 
   {{0x2258012d,0xdb1c0037,0xe7f401f9,0x00000000}},	//   ąski_, dipõ, ेतला_, --, 
   {{0x29000882,0x6818007f,0xdb1c01b8,0x9f4826b7}},	//   āha_, _kňdi, vipö, llbò_, 
   {{0x89a40014,0xa91c00ef,0xa68401d5,0x00000000}},	//   _پھاہ_, _ražu, ёлид, --, 
   {{0x394026b8,0xa2c40882,0x6b840c6a,0xdb0c01e1}},	//   ðist_, ानस्, lehg, _mobì, 
   {{0x26c026b9,0xe6941f7a,0x38600013,0x25ac16ba}},	//   šho_, _گلاد, àirt_, rjel_, 
   {{0x87e400fd,0x53c40166,0xdb1c0108,0x00000000}},	//   _тюбе, йгым_, ripö, --, 
   {{0xf77026ba,0xdb1c26bb,0x57f8010f,0xb33c0327}},	//   _تاق_, bipõ, _עלעו, jjħu, 
   {{0xe29801e0,0x25ac031c,0x38600332,0x00000000}},	//   _ҡал_, qjel_, áirg_, --, 
   {{0x61e426bc,0x656826bd,0xa6ac00cc,0x00000000}},	//   rnkl, mgeh, _কেচট, --, 
   {{0x656826be,0xa0a400c7,0xdfd001f7,0x00000000}},	//   lgeh, _ҳаид, سيز_, --, 
   {{0xfe7800f7,0x00000000,0x00000000,0x00000000}},	//   шүн_, --, --, --, 
   {{0xa0a40022,0xdb1006af,0x1d2426bf,0xd254011a}},	//   _гаид, _égér, смам, _השקה_, 
   {{0x0c20075e,0xdc2826c0,0x3dc004cc,0x681800a2}},	// [2220] змун, اسره_, rkiw_, _eňdi, 
   {{0x3dc00227,0x65680ade,0x21f002fb,0x6b8426c1}},	//   skiw_, hgeh, váhy_, gehg, 
   {{0xdb0c02e2,0x656800a2,0x00000000,0x00000000}},	//   _albò, kgeh, --, --, 
   {{0x27e800c6,0x65680d27,0x5f740133,0x00000000}},	//   éann_, jgeh, _ئاکر, --, 
   {{0x8d7400db,0xa2d808e9,0x656826c2,0xdb1c0254}},	//   _ااپا, _फेस्, dgeh, vipõ, 
   {{0x65682287,0x18a402dd,0x00000000,0x00000000}},	//   egeh, _қазм, --, --, 
   {{0x8f980302,0x656826c3,0x2a3426c4,0x9f840051}},	//   טיסי, fgeh, _мэтр, _rôì_, 
   {{0x656826c5,0x7434084c,0x35f401b9,0x75d426c6}},	//   ggeh, ониф, ўпир, تيبا, 
   {{0xdb0c0798,0xdddc00ef,0x932407d6,0xb79400ec}},	//   _mobí, _appū, یرگن, _وائڙ, 
   {{0x32542082,0xd62826c7,0x73d8136b,0xa91c00c0}},	//   овор, _боже_, рдор_, _važt, 
   {{0xc318045e,0x6568002f,0x4b780a7c,0x785401d3}},	//   _দ্বি_, bgeh, נאטו, _ایڈز_, 
   {{0x645c26c8,0x490c00bc,0x00000000,0x00000000}},	//   ásic, तेको_, --, --, 
   {{0xc05801ec,0x1bf800bc,0x00000000,0x00000000}},	//   йір_, ्ताल_, --, --, 
   {{0x741426c9,0xb4e405d7,0xa2c4043e,0x00000000}},	//   _بوتا, फपी_, ानश्, --, 
   {{0xdb0c26ca,0xada401e0,0xab880014,0x2f180108}},	//   _lobâ, ҙаҡл, یٖرن_, ровь_, 
   {{0xc0cc0092,0xa2c400cd,0x00000000,0x00000000}},	//   ጠርም_, ानर्, --, --, 
   {{0xdb0c02fd,0xebd826cb,0xe2a403b2,0x00000000}},	// [2230] _dobí, адаш_, óðve_, --, 
   {{0x8aa4010b,0xdb0c0241,0x00000000,0x00000000}},	//   йред, _tobì, --, --, 
   {{0xc3300375,0xa91c0010,0x656826cc,0xcb08009d}},	//   פוף_, _nažr, ygeh, ухад_, 
   {{0xdb0c26cd,0x6b840112,0x00000000,0x00000000}},	//   _gobí, sehg, --, --, 
   {{0x27e826ce,0xbd8801d9,0x2f1401d9,0x00000000}},	//   éano_, _انُن_, _دِگر, --, 
   {{0xdb0c0276,0x00000000,0x00000000,0x00000000}},	//   _dobâ, --, --, --, 
   {{0x656826cf,0x3ffc008f,0x386000a3,0x00000000}},	//   tgeh, אפגע, àirr_, --, 
   {{0xe4581cb6,0xa91c00e2,0x65680158,0x00000000}},	//   ажи_, _dažr, ugeh, --, 
   {{0x656826d0,0x69c826d1,0x2918004a,0xe7440032}},	//   rgeh, _ilee, _àsa_, _һүҙе_, 
   {{0x656826d2,0x386026d3,0x00000000,0x00000000}},	//   sgeh, áire_, --, --, 
   {{0xf77026d4,0x69c826d5,0x656826d6,0x00000000}},	//   _سال_, _klee, pgeh, --, 
   {{0x216826d7,0x386008a4,0x6e2801e4,0x00000000}},	//   шими_, šire_, ĉebl, --, 
   {{0x9f480085,0xdb0c26d8,0x69c80363,0xa91c0010}},	//   mobú_, _robí, _mlee, _zažr, 
   {{0xd9b426d9,0xe29826da,0xa3cc1a22,0x00000000}},	//   _अक्ट, _вак_, _रति_, --, 
   {{0x69c826db,0xdb0c0118,0x5dd826dc,0x00000000}},	//   _olee, _pobí, афар_, --, 
   {{0x225003c6,0xe1f0034c,0xdb0c0798,0x6b800205}},	//   ázku_, _تست_, _lobã, _ılga, 
   {{0x1b48013e,0xdb0c003a,0x2258012d,0xdc68003b}},	// [2240] изаи_, _vobí, ąsku_, разд_, 
   {{0x69c826dd,0x00000000,0x00000000,0x00000000}},	//   _alee, --, --, --, 
   {{0x8eb00f31,0xdb0c25e6,0x69c826de,0x192c0023}},	//   _ہمیش, _tobí, _blee, _ብሓልዮ, 
   {{0x69c826df,0x5ca4039e,0x00000000,0x00000000}},	//   _clee, _димб, --, --, 
   {{0x69c80156,0xdb0c00d8,0x9f4800d0,0x718c00df}},	//   _dlee, _bobã, dobú_, טװאַ, 
   {{0x69c826e0,0x290c0099,0x3a380618,0x5fcc0490}},	//   _elee, _dzea_, _ttrp_, होचल, 
   {{0xeb9004ac,0x69c826e1,0x7bdc06be,0xa2d807af}},	//   _אָן_, _flee, _imru, _फेल्, 
   {{0x69c826e2,0x9cfc00cc,0x6aa001a8,0x00000000}},	//   _glee, ূখীন_, _álfa, --, 
   {{0x3a24009a,0x249c0042,0xdb1c0784,0x73d80982}},	//   _iimp_, _crwm_, shpä, йдир_, 
   {{0x3a2426e3,0x69c80165,0x249c03cb,0x00000000}},	//   _himp_, _zlee, _drwm_, --, 
   {{0x69c8049b,0xc7b00375,0x3a240254,0x15b000d1}},	//   _ylee, _קבע_, _kimp_, _يەتس, 
   {{0x453000db,0xc2b400d4,0x00000000,0x00000000}},	//   _قىمر, іляє_, --, --, 
   {{0xc95006a9,0x249c0142,0xf434010b,0x00000000}},	//   ומר_, _grwm_, _эелэ, --, 
   {{0x3a241590,0xcf240597,0x2cac0327,0x28bc26e4}},	//   _limp_, ترحي, _ħed_, ्नति, 
   {{0xcdd826e5,0x92f001c6,0x601002d2,0x00000000}},	//   ања_, _цүнх, dæmd, --, 
   {{0x7bdc26e6,0x8658010f,0x00000000,0x00000000}},	//   _amru, ידלי, --, --, 
   {{0x32180a73,0x69c80161,0xfc300966,0x00000000}},	// [2250] mmsy_, _rlee, نحل_, --, 
   {{0x95280003,0x290c0589,0x3a240165,0x69c826e7}},	//   _ཤུའི_, _rzea_, _aimp_, _slee, 
   {{0x69c826e8,0x8ae410f5,0xaa940597,0x6dc00137}},	//   _plee, ціал, ثلاث, _كۅسۅ, 
   {{0x16080034,0x3a2414b0,0x7bdc0200,0x00000000}},	//   _हीलर_, _cimp_, _emru, --, 
   {{0x69c826e9,0xe73826ea,0x3a240156,0x1ee804fb}},	//   _vlee, бел_, _dimp_, _نویی_, 
   {{0x2d880381,0xe730009a,0x00000000,0x00000000}},	//   leae_, رصت_, --, --, 
   {{0x69c80156,0x3a24007c,0x00000000,0x00000000}},	//   _tlee, _fimp_, --, --, 
   {{0xd90c066d,0x2d8826eb,0x386000c6,0x290c01c6}},	//   ئیے_, neae_, áirc_, _tzea_, 
   {{0x478805cc,0x6b940166,0x44280051,0x00000000}},	//   _всем_, _kazg, êc_, --, 
   {{0x6b9426ec,0x00000000,0x00000000,0x00000000}},	//   _jazg, --, --, --, 
   {{0x6b9426ed,0x9f4c02fd,0x3a240165,0xe1f826ee}},	//   _mazg, áním_, _yimp_, йго_, 
   {{0x6b9426ef,0x249c03cb,0x92601870,0x00000000}},	//   _lazg, _trwm_, رگىم, --, 
   {{0x9f4c00bc,0x2bc001f9,0x00000000,0x00000000}},	//   šním_, _एवढा, --, --, 
   {{0xdd9026f0,0x443c26f1,0x00000000,0x00000000}},	//   کور_, mpu_, --, --, 
   {{0x443c26f2,0x6010008c,0x248c0036,0x998402f0}},	//   lpu_, væmd, lwem_, bloň_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b940399,0x443c0842,0x3a24030a,0x48d80210}},	// [2260] _bazg, npu_, _rimp_, _खेलो_, 
   {{0x3a2426f3,0x443c26f4,0x7b840075,0x58840588}},	//   _simp_, ipu_, بارە, ҧыла, 
   {{0x443c0842,0x2d88003a,0x8c40010b,0x00000000}},	//   hpu_, beae_, _җесе, --, 
   {{0x443c01f2,0x248c02e3,0xdb2401b9,0x3f9826f5}},	//   kpu_, kwem_, زوچی, ldru_, 
   {{0xdce40115,0x3a240489,0x443c0978,0xdb0c26f6}},	//   _bakĥ, _vimp_, jpu_, _dobá, 
   {{0xebb80882,0x3a24003b,0x6b9426f7,0x443c0978}},	//   tuḥ_, _wimp_, _gazg, dpu_, 
   {{0x3a240262,0x2bc00490,0x443c0064,0x248c0210}},	//   _timp_, _शकता, epu_, ewem_, 
   {{0x3a2404d4,0xdb0c0332,0x986803e0,0x00000000}},	//   _uimp_, _gobá, _göğe_, --, 
   {{0x6b9426f8,0x7980035a,0x443c26f9,0x00000000}},	//   _yazg, _ibmw, gpu_, --, 
   {{0x63ac0198,0xaf700023,0x88380375,0xdb0c0306}},	//   _ɗang, ብታትና_, _לתמו, _zobá, 
   {{0x443c26fa,0x3f980327,0x4270009d,0x41a808a3}},	//   apu_, ddru_, нгэс, गांस, 
   {{0x3f98005f,0x443c016d,0x2d88003a,0x00000000}},	//   edru_, bpu_, xeae_, --, 
   {{0x25640014,0x53a426fb,0x85980375,0x443c037e}},	//   _زانُ, _надб, _לשאו, cpu_, 
   {{0x82300ee8,0x798002d0,0x00000000,0x00000000}},	//   بریا, _lbmw, --, --, 
   {{0x263400b0,0x2d880393,0x518400f3,0x00000000}},	//   _kāoa_, teae_, _еупа, --, 
   {{0x3f980ffb,0x260000e8,0x6b940139,0x92f0054e}},	//   adru_, lóor_, _sazg, ăşăm, 
   {{0x263402b5,0x2d8816b8,0x953c001f,0x6b940240}},	// [2270] _māoa_, reae_, _በኢንተ, _pazg, 
   {{0xbca400c6,0xdb0c00d0,0x2d8826fc,0x2600002e}},	//   عملي, _sobá, seae_, nóor_, 
   {{0x6b9426fd,0x7b6426fe,0x2d88003a,0xa3cc23ef}},	//   _vazg, этте, peae_, रसत_, 
   {{0x443c016d,0x3eac26ff,0x6b940139,0x248c0210}},	//   ypu_, ådte_, _wazg, ywem_, 
   {{0x6d5c03ac,0x6b942700,0xa91c00d7,0x21f00327}},	//   _idsa, _tazg, _obže, nġha_, 
   {{0x38600c63,0x98a02701,0x798002d0,0xa9080451}},	//   áira_, тише, _ebmw, ٽيڪل_, 
   {{0xc6a40853,0x248c2702,0x9f5c06af,0xdb0c01e7}},	//   ярди, wwem_, ôté_, _tobá, 
   {{0x386008a4,0x248c033f,0x7980035a,0x443c2703}},	//   šira_, twem_, _gbmw, tpu_, 
   {{0x6f08012c,0x443c2704,0x6adc041c,0xdce8002b}},	//   řech, upu_, _मधुर, _ānīt, 
   {{0x4a28025c,0x00000000,0x00000000,0x00000000}},	//   _སྤོལ_, --, --, --, 
   {{0xa1881d5a,0x443c0978,0xf77002dd,0x248c0af9}},	//   обна_, spu_, _حاق_, swem_, 
   {{0x443c2705,0x6b2c0327,0x00000000,0x00000000}},	//   ppu_, _ཧུའོ_, --, --, 
   {{0xc4f80e83,0x66082706,0x26000de2,0x443c0978}},	//   _اعضا_, mlek, bóor_, qpu_, 
   {{0x6d5c2707,0x442c003a,0x9ea82708,0xa2e4004e}},	//   _adsa, _iug_, овга_, _оолд, 
   {{0x442c2709,0x4424270a,0xd004270b,0x6608270c}},	//   _hug_, _iin_, фере_, olek, 
   {{0x4424270d,0x4a281e81,0x66080724,0x3f98054e}},	//   _hin_, _སྤེལ_, nlek, sdru_, 
   {{0x442c270e,0x9c24270f,0x644c067c,0x66082710}},	// [2280] _jug_, ддад, _çaid, ilek, 
   {{0x44240b45,0x6d5c2711,0x5f4400f1,0xa3cc00cd}},	//   _jin_, _edsa, _تندل, रसि_, 
   {{0x442c2712,0x6608013d,0x6eb42713,0x0e600166}},	//   _lug_, klek, _उपयु, _икэн, 
   {{0x44242714,0x66082715,0x442c0276,0xd9442716}},	//   _lin_, jlek, _oug_, феди, 
   {{0x66082717,0x44242718,0x442c0457,0x645c2719}},	//   dlek, _oin_, _nug_, ásil, 
   {{0x4424271a,0x6ee401b9,0xc7a024fc,0xda64009d}},	//   _nin_, _آسیل, кичк, _овги, 
   {{0x34b808dd,0x442c0375,0x263402b1,0x07a02096}},	//   ेन्द, _aug_, _pāoa_, тајн, 
   {{0x4424271b,0x6608271c,0x629c0618,0x442c271d}},	//   _ain_, glek, āsol, _bug_, 
   {{0x4424271e,0x442c271f,0xa30000fd,0x92e80154}},	//   _bin_, _cug_, ңүче, _মরে_, 
   {{0x2e440100,0x12e402dd,0x442c0e21,0x44242720}},	//   _jèfò_, дімг, _dug_, _cin_, 
   {{0x442c08c2,0x44f0006c,0xa2c407b6,0x25c801d3}},	//   _eug_, فسیز, ानग्, átló_, 
   {{0x44242721,0x442c2722,0x00000000,0x00000000}},	//   _ein_, _fug_, --, --, 
   {{0x442c0bfa,0xf0e800d1,0x00000000,0x00000000}},	//   _gug_, سىسى_, --, --, 
   {{0x44242723,0xdb0c014a,0xa2d807f7,0x78a40108}},	//   _gin_, _kobä, _फेक्, äivy, 
   {{0x442c2724,0x8e240798,0x76580064,0x00000000}},	//   _zug_, дфад, nsvy, --, 
   {{0x44242725,0x442c0457,0x7fb80166,0x60d800df}},	//   _zin_, _yug_, _aşqı, ŝtma, 
   {{0x44242726,0x00000000,0x00000000,0x00000000}},	// [2290] _yin_, --, --, --, 
   {{0x44242727,0x66082728,0x4a280327,0x09c400cd}},	//   _xin_, zlek, _སྤུལ_, लस्य, 
   {{0x660800ee,0xdb0c01c7,0x00000000,0x00000000}},	//   ylek, _nobä, --, --, 
   {{0x6d5c04ce,0x66082729,0x28bc0950,0xa9c000f7}},	//   _udsa, xlek, ्नलि, دۅرۉ, 
   {{0xdd38025f,0x66080dfe,0xe738272a,0x52c808a3}},	//   _מערכ, vlek, пел_, ानुस, 
   {{0xe738272b,0x2d98272c,0xe61004fb,0xa6941b88}},	//   чек_, _hase_, گشت_, ериј, 
   {{0x4424272d,0x6608272e,0x2d98272f,0x442c2730}},	//   _rin_, tlek, _kase_, _sug_, 
   {{0xdb0c2731,0x9f4802fb,0x970000d1,0xe6102732}},	//   _dobä, dobý_, دېمى, دشت_, 
   {{0x66082733,0x74f805f5,0x44242734,0x442c2735}},	//   rlek, дээс_, _pin_, _qug_, 
   {{0xe3b006d5,0x44242736,0xe8bc03f3,0x66082737}},	//   ارة_, _qin_, ्नीच, slek, 
   {{0x44242738,0x66082739,0xdb0c008e,0x00000000}},	//   _vin_, plek, _gobä, --, 
   {{0x442c273a,0x4424273b,0x2b500165,0x52740066}},	//   _tug_, _win_, _lezc_, راپز, 
   {{0x4424273c,0x3074273d,0x10a0273e,0x00000000}},	//   _tin_, курс, гиян, --, 
   {{0x25bc273f,0x44242740,0x2d980363,0x356800fb}},	//   _howl_, _uin_, _aase_, _ерән_, 
   {{0x2d982741,0x9290009b,0x00000000,0x00000000}},	//   _base_, _бајц, --, --, 
   {{0x2d982742,0x25bc0076,0xa3cc033f,0x21740139}},	//   _case_, _jowl_, रसव_, _чукр, 
   {{0x2d980077,0x00000000,0x00000000,0x00000000}},	// [22a0] _dase_, --, --, --, 
   {{0x61e42743,0x25bc01f5,0x2d9826e7,0xbac400cc}},	//   likl, _lowl_, _ease_, _এইবছ, 
   {{0xdee4013e,0x60c42744,0x5eb80154,0x00000000}},	//   _чони, lykm, _উইকে, --, 
   {{0x61e42745,0x00000000,0x00000000,0x00000000}},	//   nikl, --, --, --, 
   {{0x79a40032,0x6818007f,0xe9700145,0x0d740066}},	//   ерҙе, _pňdp, شۇلد, _سیلک_, 
   {{0x2d981b5c,0xb7d801ec,0x61e42746,0xa3e001ad}},	//   _zase_, بوتا_, hikl, नोम_, 
   {{0x7e7c01e0,0x2d982747,0x61e42748,0x25bc2749}},	//   ntrp, _yase_, kikl, _bowl_, 
   {{0xceb0025f,0x25bc1caa,0xdb0c01b8,0x61e4086f}},	//   ריה_, _cowl_, _vobä, jikl, 
   {{0x61e4274a,0x53e4274b,0x2b5401d9,0x9868274c}},	//   dikl, ецна, _سیۆد_, _хизб_, 
   {{0xb5d80150,0xded00092,0xf8b000ec,0x60c400a2}},	//   _ﺀﺑﯩﺰ, ኩሏን_, _مکڻ_, dykm, 
   {{0x25bc274d,0x6b8000fd,0x61e4274e,0xaa2801d9}},	//   _fowl_, _ölge, fikl, _رسہٕ_, 
   {{0xa2c01cd1,0x25bc0003,0x61e4274f,0x00000000}},	//   рәшк, _gowl_, gikl, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2d982750,0x43902751,0xb4cc107c,0xd2580798}},	//   _sase_, _башс, रनी_, _еци_, 
   {{0x2d982752,0x61e40fe3,0x25bc0204,0xef1000f7}},	//   _pase_, bikl, _yowl_, рүнө, 
   {{0x2d9803b4,0x60100158,0x00000000,0x00000000}},	//   _qase_, ræma, --, --, 
   {{0xa91c2753,0x6b74008e,0x8240001f,0x0320013d}},	// [22b0] _obža, клау, _የተሳሳ, _идән, 
   {{0x2d982754,0xa2c423e9,0x6aa0032e,0x00000000}},	//   _wase_, ानच्, _álfk, --, 
   {{0x2d982755,0xbf140bd6,0xdeb00150,0xadbc0064}},	//   _tase_, _бүрә, _кұры, _данi, 
   {{0x2d98003a,0x645c00e4,0x00000000,0x00000000}},	//   _uase_, ásik, --, --, 
   {{0xcf242756,0xdb0c0623,0x25bc0076,0xa30c00e1}},	//   _ترکي, _robå, _rowl_, _हर्ज_, 
   {{0x61e42757,0x25bc039a,0x00000000,0x00000000}},	//   zikl, _sowl_, --, --, 
   {{0x98f404a9,0x9ba00075,0x79a42758,0x6934014b}},	//   ىغۇچ, _خەلى, _өрте, _анбу, 
   {{0x25bc058a,0x00000000,0x00000000,0x00000000}},	//   _qowl_, --, --, --, 
   {{0x61e42759,0x00000000,0x00000000,0x00000000}},	//   vikl, --, --, --, 
   {{0xf770275a,0x13e4008e,0x00000000,0x00000000}},	//   _هام_, кмый_, --, --, 
   {{0x2168275b,0xc648275c,0x25bc1368,0x626402e8}},	//   мини_, _رجال_, _towl_, ъвна, 
   {{0xd3e401d5,0x00000000,0x00000000,0x00000000}},	//   _یقنی, --, --, --, 
   {{0x61e4275d,0x00000000,0x00000000,0x00000000}},	//   rikl, --, --, --, 
   {{0xe28400b1,0x60c4275e,0xe5a4010a,0x5040104e}},	//   _алки, rykm, _пиçи, рерб, 
   {{0xe3b0021a,0x61e4275f,0x52b0007b,0xf644074d}},	//   _مرګ_, pikl, _نموذ, _ыхăн, 
   {{0x8d601429,0x61e4022e,0x00000000,0x00000000}},	//   ивсе, qikl, --, --, 
   {{0x7e7c1a48,0x00000000,0x00000000,0x00000000}},	// [22c0] strp, --, --, --, 
   {{0x9f482760,0x20182761,0x00000000,0x00000000}},	//   robó_, _تتبع_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x18682762,0xa3cc00c5,0x00000000,0x00000000}},	//   дади_, रसँ_, --, --, 
   {{0xd7f82763,0x0c980092,0x00000000,0x00000000}},	//   мук_, _ቅርሶች_, --, --, 
   {{0xda642764,0xbdc800e5,0xb88c0092,0x00000000}},	//   _لاري, _آدھے_, _ማይጨው_, --, 
   {{0xa91c0006,0x1994009b,0x00000000,0x00000000}},	//   _mažy, _ијар, --, --, 
   {{0xd87422f3,0x310400dc,0xa91c0153,0x00000000}},	//   _لائب, रथमः_, _lažy, --, 
   {{0xb4cc13b4,0xa3cc0b7c,0xed880023,0x52c811bc}},	//   रने_, रसं_, _ምጽባይ_, ान्स, 
   {{0x27e8004a,0x0e7402d3,0x674400bc,0x2604004e}},	//   éant_, _ይግብኦ_, čují, кчөг, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x550401d5,0x00000000,0x00000000,0x00000000}},	//   _ичла, --, --, --, 
   {{0x63c40510,0x50640395,0x00000000,0x00000000}},	//   ýunç, ътна, --, --, 
   {{0xa3e02765,0xa3cc00cd,0x00000000,0x00000000}},	//   नोद_, रसः_, --, --, 
   {{0x3d3801f2,0xa91c0024,0x00000000,0x00000000}},	//   _ọwa_, _dažy, --, --, 
   {{0x61f40240,0xac942766,0x2bbc0709,0x00000000}},	//   _gjyl, лабш, ोस्थ, --, 
   {{0x32082767,0xa9a42768,0xd01801af,0x00000000}},	// [22d0] _ikay_, ғилд, _офо_, --, 
   {{0xdce400d7,0xc8b0015e,0x00000000,0x00000000}},	//   _fakľ, یلاک, --, --, 
   {{0x32080784,0x61f400a2,0xdb0c00d7,0x00000000}},	//   _kkay_, _yjyl, _zobú, --, 
   {{0x700001f2,0x684c0023,0x00000000,0x00000000}},	//   _ịcho, _ዝተረድ, --, --, 
   {{0xa884215c,0x00000000,0x00000000,0x00000000}},	//   التى, --, --, --, 
   {{0xaa5c2769,0x00000000,0x00000000,0x00000000}},	//   _негi, --, --, --, 
   {{0x06e0276a,0x320802c2,0xf3f800fe,0x00000000}},	//   _केशव_, _okay_, ঁতাৰ_, --, 
   {{0x320800ca,0x28140133,0x81e800fe,0x00000000}},	//   _nkay_, _ڵواس, _ভৱন_, --, 
   {{0x27e8276b,0xe3b0276c,0x00000000,0x00000000}},	//   éans_, مرد_, --, --, 
   {{0xdb0c0332,0x36880ce8,0x9f5400e5,0x00000000}},	//   _robú, хсән_, égük_, --, 
   {{0xb2f407d8,0xf77001c8,0x04840014,0x2bf000cc}},	//   ияющ, _ذال_, رٕگی_, _জীৱই_, 
   {{0x9f4c03c6,0xa068276d,0x20180240,0xdb0c00d0}},	//   čník_, нама_, _shpi_, _pobú, 
   {{0xa91c02d5,0xc60c11b1,0x23840014,0xc3d802dd}},	//   _pažy, ातीय_, _مٔشِ, _жөнi, 
   {{0x320802d0,0x701801ce,0x42c4014b,0xfe44009d}},	//   _ekay_, віст_, _аҳон_, имгү, 
   {{0x21a4004e,0x4c640116,0xd00c007b,0x00000000}},	//   _бийм, һитн_, سلف_, --, 
   {{0x63b4276e,0x00000000,0x00000000,0x00000000}},	//   šanč, --, --, --, 
   {{0x5ba8276f,0x65782770,0xdb0c0fac,0x00000000}},	// [22e0] нкам_, _mcwh, _hobø, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x779404fb,0xdb0c01bf,0x4c900aac,0x320803ac}},	//   ییرا, _jobø, _қиёс, _ykay_, 
   {{0xdb0c002d,0x9d44010b,0x99b00154,0x05a0000d}},	//   _ynbê, _щемд, চস্ক, _खोलब, 
   {{0xd7e41ed2,0x6010005c,0x06800014,0x29000205}},	//   ліко, hæmm, ۅلوُ, şhan_, 
   {{0xacb011dc,0x00000000,0x00000000,0x00000000}},	//   _بەكب, --, --, --, 
   {{0xb4cc00dc,0x46640166,0x00000000,0x00000000}},	//   रन्_, грым_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x320801f7,0xdb1c2771,0x987410fc,0xa784072d}},	//   _rkay_, skpä, _љубљ, _چشمو, 
   {{0x32080113,0xd3782772,0x08c01422,0xe8f41de6}},	//   _skay_, хчи_, _убун, _әһә_, 
   {{0x0bb402e4,0x00000000,0x00000000,0x00000000}},	//   אלים_, --, --, --, 
   {{0xc2b400d4,0xa56406c2,0x00000000,0x00000000}},	//   улює_, _ندهن, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x40342773,0x44f00006,0xed582774,0x00000000}},	//   серс, _упіс, _žž_, --, 
   {{0x8bc416c3,0x32080051,0x02a00153,0x7e44004e}},	//   қсад, _tkay_, _грым, йхте, 
   {{0x32082775,0x9f482776,0xfd7401c0,0x5fc401ad}},	//   _ukay_, nibê_, йлсэ, रॉबल, 
   {{0xa3e007f7,0x00000000,0x00000000,0x00000000}},	// [22f0] नोव_, --, --, --, 
   {{0xbc680451,0x3b54004e,0x00000000,0x00000000}},	//   املن_, йкур, --, --, 
   {{0x8aa42777,0x00000000,0x00000000,0x00000000}},	//   ырад, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x995401ec,0x00000000,0x00000000,0x00000000}},	//   сiби_, --, --, --, 
   {{0x6d4c2778,0x00000000,0x00000000,0x00000000}},	//   lbaa, --, --, --, 
   {{0x6d4c0067,0x00000000,0x00000000,0x00000000}},	//   obaa, --, --, --, 
   {{0x6d4c2779,0x00000000,0x00000000,0x00000000}},	//   nbaa, --, --, --, 
   {{0x851c277a,0x6d4c277b,0x69d8013f,0x00000000}},	//   मेंट_, ibaa, mhwe, --, 
   {{0xe284035b,0x6d4c0067,0x2328277c,0x53c40166}},	//   алои, hbaa, копи_, игым_, 
   {{0x6d4c1aa7,0x7dd801e7,0xdce40171,0xe3b0277d}},	//   kbaa, _híse, _sakļ, مرگ_, 
   {{0x6d4c0196,0x6010037e,0xe124277e,0x69d80134}},	//   jbaa, ræmm, имни, nhwe, 
   {{0x6d4c277f,0xbb1c07d2,0x00000000,0x00000000}},	//   dbaa, _ﺷﺎﻡ_, --, --, 
   {{0x64482780,0x6d4c0083,0xd46426b1,0x00000000}},	//   mpei, ebaa, _тише_, --, 
   {{0xdd902781,0x69d82782,0x6d4c2783,0x7dd800d2}},	//   يوس_, khwe, fbaa, _líse, 
   {{0x62802784,0x6d4c2785,0x38600552,0x20542786}},	//   mtlo, gbaa, širi_, _ктор, 
   {{0xd00c066d,0x644803f5,0x69d82787,0x27200b4c}},	// [2300] سلہ_, npei, dhwe, मधुर_, 
   {{0x6d4c2788,0xef18013e,0x644801ab,0x62800175}},	//   abaa, тмӣ_, ipei, otlo, 
   {{0x7f5c2789,0x6280021a,0x6d4c0bc1,0x00000000}},	//   marq, ntlo, bbaa, --, 
   {{0xed340323,0x2250278a,0xf958040b,0x7f5c0784}},	//   _гэрэ, ázky_, اساں_, larq, 
   {{0x38600597,0x913800c8,0x62800e78,0x2714004d}},	//   éir_, דענק, htlo, _án_, 
   {{0x7f5c278b,0x7dd8278c,0x6f0803ee,0x00000000}},	//   narq, _díse, şece, --, 
   {{0x69d80117,0x7f5c0194,0x644801f5,0xa4180073}},	//   bhwe, iarq, epei, _नीधप_, 
   {{0x69d8278d,0x7dd80597,0xa2a8278e,0xef3c001f}},	//   chwe, _físe, टिन्, ካሄደው, 
   {{0x0308068f,0x7f5c03f0,0x6280033f,0xdce40205}},	//   _सुबह_, karq, etlo, _kakı, 
   {{0x44f0278f,0x3a3800de,0x00000000,0x00000000}},	//   تسىز, _kurp_, --, --, 
   {{0x6d4c2790,0xcb340a1e,0x6aa001a8,0x628001bf}},	//   ybaa, יניק_, _álft, gtlo, 
   {{0xf4840133,0x37b80183,0x9f4802e2,0xdce42791}},	//   _هاتی, _অতিৰ, libè_, _lakı, 
   {{0x92b4015b,0x6818010e,0x7f5c01a9,0x645c0419}},	//   ছনে_, _aňdy, farq, ásit, 
   {{0x7f5c2792,0x92142793,0x6d4c2794,0xdce405d1}},	//   garq, _धीरज_, wbaa, _nakı, 
   {{0x6d4c2795,0x62802796,0x69d80472,0xd1640395}},	//   tbaa, ctlo, yhwe, _къпи, 
   {{0x6d4c2797,0x69d82798,0x629c1c52,0x00000000}},	//   ubaa, xhwe, āsot, --, 
   {{0xdce42799,0x6d4c279a,0x7f5c279b,0x00000000}},	// [2310] _bakı, rbaa, barq, --, 
   {{0x6d4c279c,0x8aa4279d,0x3a38279e,0xdce40205}},	//   sbaa, иред, _burp_, _cakı, 
   {{0x69d81253,0x6d4c2595,0x7dd8279f,0x3a3827a0}},	//   thwe, pbaa, _síse, _curp_, 
   {{0x80a427a1,0x7dd80316,0x6fd80ffb,0x6d4c27a2}},	//   _امین, _píse, _dìce, qbaa, 
   {{0x69d827a3,0xdce40205,0x00000000,0x00000000}},	//   rhwe, _fakı, --, --, 
   {{0xdce40139,0x681800a2,0xc60c09fa,0x00000000}},	//   _gakı, _yňdy, ात्य_, --, 
   {{0x644803a2,0x69d827a4,0xded0001f,0x3a3800a2}},	//   wpei, phwe, _የዜና_, _gurp_, 
   {{0x69d827a5,0x070400f1,0xadf827a6,0x04380092}},	//   qhwe, هيږي_, ्किन_, _በባለሙ, 
   {{0xdce427a7,0x7f5c0986,0x240827a8,0xdb0c0248}},	//   _yakı, yarq, лнии_, _àjòj, 
   {{0xa3e027a9,0x628027aa,0xe298026a,0xdce40724}},	//   नों_, ttlo, гао_, _xakı, 
   {{0x644827ab,0x66f400ee,0xe74401e0,0xadf8013a}},	//   spei, _упжу, _күҙе_, ्कान_, 
   {{0x64481057,0x7f5c03f0,0xe7380124,0x6d4027ac}},	//   ppei, warq, _реҧ_, _şlan, 
   {{0x7f5c27ad,0x660827ae,0x9f48020c,0xa3b801c8}},	//   tarq, moek, libé_, _ماثر_, 
   {{0xd91827af,0xc3481064,0x660827b0,0x21640137}},	//   טורל, _ряде_, loek, штүг, 
   {{0x7f5c27b1,0x601005f7,0xdce40790,0xa3e000cd}},	//   rarq, næmi, _rakı, नोः_, 
   {{0xdce403ee,0x7f5c02d1,0x9f3401ec,0x660827b2}},	//   _sakı, sarq, реңі, noek, 
   {{0x7f5c27b3,0x5b3427b4,0x3a380165,0xdb0c0306}},	// [2320] parq, معار, _surp_, _dobý, 
   {{0x660827b5,0x2600011f,0x7f5c03f0,0x2d8c0de2}},	//   hoek, róoy_, qarq, _ñeen_, 
   {{0xdce40598,0x660827b6,0x200827b7,0x9f48020c}},	//   _vakı, koek, mobi_, jibé_, 
   {{0x200827b8,0x7dd827b9,0x9f480129,0x657c00a3}},	//   lobi_, _dísc, dibé_, òshl, 
   {{0x1cb827ba,0xdce40ab7,0x660827bb,0x64440374}},	//   _صاحب_, _takı, doek, _ōhin, 
   {{0x200827bc,0x8c4009a5,0x3a3827bd,0x9ad40006}},	//   nobi_, _хере, _turp_, _любі, 
   {{0x644c068c,0x00000000,0x00000000,0x00000000}},	//   _çaij, --, --, --, 
   {{0x200827be,0xd49827bf,0x6608009d,0x00000000}},	//   hobi_, гро_, goek, --, 
   {{0x73d81751,0xdb0c0793,0x3944009f,0xd9780022}},	//   идир_, _lobü, _ifms_, _арҕә_, 
   {{0x249c007f,0x2008009a,0x9f480129,0x00000000}},	//   _dswm_, jobi_, bibé_, --, 
   {{0x660827c0,0x200827c1,0x55e40139,0x9f480129}},	//   boek, dobi_, _ложб, cibé_, 
   {{0x386000f3,0xe5780042,0x9618007b,0xbb4c0150}},	//   širu_, ghŷd_, _صغار_, _ﺍﻹﻴ_, 
   {{0x200827c2,0xdb0c0085,0x2ed027c3,0x73c402dd}},	//   fobi_, _kobó, सन्त, _дәне, 
   {{0x63ac03f9,0x03a00276,0x20080083,0x2cac0306}},	//   _ɗank, _ничо, gobi_, _šedo_, 
   {{0xdb0c0118,0x00000000,0x00000000,0x00000000}},	//   _pobý, --, --, --, 
   {{0x21f027c4,0xdb0c0085,0x00000000,0x00000000}},	//   tšhe_, _lobó, --, --, 
   {{0x200827c5,0x316801c4,0x7dd80332,0x6eb427c6}},	// [2330] bobi_, _idaz_, _sísc, _उपकु, 
   {{0x66080936,0x00000000,0x00000000,0x00000000}},	//   zoek, --, --, --, 
   {{0x6fb427c7,0xfbd000c6,0xd1dc02d3,0xcb1800d8}},	//   _همکا, رتك_, _ዓሌት_, уќа_, 
   {{0x7dd80077,0xdd901b40,0x660801c4,0x311c00cd}},	//   _vísc, _قوپ_, xoek, _नराः_, 
   {{0x7648010b,0x660801e4,0x48d40154,0x7658002b}},	//   _atdy, voek, তপ্র, _āraṇ, 
   {{0x660808c8,0x2ca80978,0xa7a827c8,0x00000000}},	//   woek, mvad_, ркка_, --, 
   {{0x2ca827c9,0x660827ca,0xdb0c0c57,0x00000000}},	//   lvad_, toek, _dobó, --, 
   {{0xa44427cb,0xe61803b7,0xc0e0001f,0x20080472}},	//   онид, јди_, _ነዋሪ_, zobi_, 
   {{0x386000c6,0x9f480066,0xa91c0306,0x2ca8016d}},	//   áirt_, sibé_, _obži, nvad_, 
   {{0x66080151,0x7dd8013d,0x2ca80254,0xdc2c0139}},	//   soek, _mísa, ivad_, _yııl, 
   {{0x2ca827cc,0x7dd800d2,0x6608003e,0x6eb4095f}},	//   hvad_, _lísa, poek, _उपगु, 
   {{0x249c0211,0x9508063f,0x26d80165,0x00000000}},	//   _tswm_, ịzịg, _ęsoh_, --, 
   {{0x200827cd,0x34940b3e,0x2ca80978,0xd24c27ce}},	//   tobi_, _нацр, jvad_, _ینو_, 
   {{0x232827cf,0x2ca827d0,0x25e404af,0xd00c0592}},	//   _коли_, dvad_, जोरी_, َلَ_, 
   {{0x443c27d1,0xa2e4006c,0x53980375,0x2ca8000d}},	//   lqu_, _фойд, _כיסו, evad_, 
   {{0x200827d2,0xe7e801ad,0x2d8c1574,0x00000000}},	//   sobi_, झोता_, _ñeel_, --, 
   {{0x443c27d3,0x1be8013e,0x7dd800bc,0xe204121d}},	// [2340] nqu_, адаи_, _císa, रवीण_, 
   {{0x443c06af,0x7dd808ce,0x20080454,0x6f080205}},	//   iqu_, _dísa, qobi_, şeca, 
   {{0x3f9827d4,0x2ca800af,0x7094001f,0xdb0c27d5}},	//   meru_, avad_, ያደርጉ_, _robó, 
   {{0x2ca8014f,0xdb0c0210,0x00000000,0x00000000}},	//   bvad_, _sobó, --, --, 
   {{0x443c0978,0xdb0c0210,0x00000000,0x00000000}},	//   jqu_, _pobó, --, --, 
   {{0x3f9827d6,0x48d80183,0x443c0978,0x00000000}},	//   neru_, বপূৰ, dqu_, --, 
   {{0xd94400d1,0x443c0003,0x00000000,0x00000000}},	//   _меви, equ_, --, --, 
   {{0x3f9827d7,0x394400d8,0x443c0135,0x99d40244}},	//   heru_, _ufms_, fqu_, _بقرت, 
   {{0x3f9827d8,0x224827d9,0x443c047e,0x7dd80166}},	//   keru_, _čaka_, gqu_, _xísa, 
   {{0x3f98041a,0xc5100131,0x00000000,0x00000000}},	//   jeru_, ببىت, --, --, 
   {{0x443c0766,0x764827da,0x8c18011a,0x2ca8030a}},	//   aqu_, _utdy, שויי, zvad_, 
   {{0x443c016d,0x2ca8016d,0x00000000,0x00000000}},	//   bqu_, yvad_, --, --, 
   {{0x3f9827db,0x798002d0,0x910402e8,0x9f480042}},	//   feru_, _mcmw, ючод, ribî_, 
   {{0xdde000f3,0x2ca8016d,0x7dd80a87,0x603001ef}},	//   _ćušk, vvad_, _rísa, _němě, 
   {{0xfeb827dc,0x63740022,0xadf800bc,0x2ca80455}},	//   يافت_, _ỹngu, ्कलन_, wvad_, 
   {{0x7dd801f1,0x3168005a,0xb62c037e,0xc32c1c3e}},	//   _písa, _udaz_, _ｒｉ_, _جەپ_, 
   {{0x9f840086,0xb05427dd,0xa3e0000d,0xb33c0327}},	// [2350] _eôñ_, ọọrọ_, नोक_, ndħo, 
   {{0x3f9827de,0x7dd809f3,0xdb0c1497,0x2ca827df}},	//   ceru_, _vísa, _robò, rvad_, 
   {{0x2ca8016d,0x443c022e,0x00000000,0x00000000}},	//   svad_, zqu_, --, --, 
   {{0xdb240214,0x2ca8047e,0x443c27e0,0x00000000}},	//   سونی, pvad_, yqu_, --, 
   {{0x6d5c00da,0x2ca8016d,0x00000000,0x00000000}},	//   _iesa, qvad_, --, --, 
   {{0x05a01524,0x798027e1,0xdc38011a,0x443c0978}},	//   _खोजब, _ecmw, _לעשר, vqu_, 
   {{0x6d5c27e2,0xba7427e3,0x443c047e,0xc6a401d5}},	//   _kesa, _يافت, wqu_, юрди, 
   {{0x6d5c27e4,0x3f9827e5,0x80b402f5,0xfb340953}},	//   _jesa, zeru_, ুনত্, _інтэ, 
   {{0x29180ad9,0x3f9827e6,0x443c0ba1,0x649801b9}},	//   _ása_, yeru_, uqu_, ётир_, 
   {{0x443c27e7,0x33d40212,0x00000000,0x00000000}},	//   rqu_, діют, --, --, 
   {{0x443c27e8,0xe71827e9,0x69c803a0,0x3f9827ea}},	//   squ_, _ايات_, _koee, veru_, 
   {{0x3f9827eb,0x9ae8004d,0x443c0978,0x00000000}},	//   weru_, _mabư_, pqu_, --, 
   {{0x69c80032,0xe44827ec,0xddcc151c,0x7dd802d2}},	//   _moee, _التى_, jubš, _bísn, 
   {{0x6d5c0156,0x6458047e,0xe29800d8,0x00000000}},	//   _aesa, _iwwi, _гак_, --, 
   {{0x6d5c27ed,0x3f9827ee,0x00000000,0x00000000}},	//   _besa, reru_, --, --, 
   {{0x3f9827ef,0x64580472,0x1c4427f0,0x2d940166}},	//   seru_, _kwwi, знам, мрус, 
   {{0x3f9827f1,0xa2a827f2,0x3ba40107,0x3d28030f}},	// [2360] peru_, टिव्, млаҳ, زتری_, 
   {{0x6d5c27f3,0x798002d0,0x6eb4023e,0x00000000}},	//   _eesa, _scmw, _उपचु, --, 
   {{0x6d5c27f4,0x69c801e0,0xcf540375,0xf8b401ad}},	//   _fesa, _boee, _מבית_, ंम्प, 
   {{0x6d5c27f5,0xd8380108,0xc8340023,0xbf580055}},	//   _gesa, бэк_, _ክሰምዕ, _ārṣe_, 
   {{0x8eb00214,0x00000000,0x00000000,0x00000000}},	//   _قمیش, --, --, --, 
   {{0x6d5c27f6,0x00000000,0x00000000,0x00000000}},	//   _zesa, --, --, --, 
   {{0x6d5c27f7,0x64580003,0x030800e1,0x8f980a1e}},	//   _yesa, _awwi, _सुलह_, מיסי, 
   {{0x6458003e,0x9f48011f,0x8af8011a,0x7dd801ef}},	//   _bwwi, nibâ_, _ההלי, _míso, 
   {{0x7dd800d2,0xd4981086,0xdb1c0254,0x6d4006be}},	//   _líso, ёри_, hkpü, _şlak, 
   {{0x69c801f5,0xdb1c000d,0xe70800db,0xb9dc0092}},	//   _zoee, kkpü, حتۇن_, _በሱ_, 
   {{0x9f48026c,0x7dd801e1,0x73341870,0x00000000}},	//   ribì_, _níso, بىدا, --, 
   {{0xd498033a,0x00000000,0x00000000,0x00000000}},	//   _грк_, --, --, --, 
   {{0x94240046,0x7dd8012c,0x6d5c27f8,0x3a2401ef}},	//   _емде, _písn, _resa, _mhmp_, 
   {{0x6e94008e,0x00000000,0x00000000,0x00000000}},	//   мигу, --, --, --, 
   {{0x6d5c27f9,0x9f4800eb,0x2d8c0de2,0xd2440137}},	//   _pesa, cibí_, _ñeek_, _ээли, 
   {{0x6d5c27fa,0x42f80302,0x7bdc005c,0xa2a800cd}},	//   _qesa, _להוס, _alru, टिर्, 
   {{0x6d5c27fb,0xfd740323,0x7bdc0083,0x7dd827fc}},	// [2370] _vesa, элтэ, _blru, _tísn, 
   {{0x6e9827fd,0x4ea427fe,0x4ba40137,0x0fe01e4a}},	//   _двор_, _ерма, чөмү_, _чөмү, 
   {{0x69c827ff,0xa3e005d7,0x6010005c,0x00000000}},	//   _poee, नोट_, ræmt, --, 
   {{0x7bdc2800,0x3a240789,0x6d5c2801,0xc3300375}},	//   _elru, _chmp_, _uesa, גוע_, 
   {{0xe73806ed,0x628400e4,0x00000000,0x00000000}},	//   оел_, _ãhov, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5690147e,0x7c200036,0x64580142,0xaa541cd0}},	//   вајт, _ëmra, _swwi, _іваш, 
   {{0x44a0010b,0xd90c0583,0x3a2401ef,0x00000000}},	//   егиң, ایے_, _ghmp_, --, 
   {{0x66d400b2,0x00000000,0x00000000,0x00000000}},	//   _ڪيائ, --, --, --, 
   {{0x7dd80789,0xa3e80212,0xa2a82802,0xf91c032e}},	//   _aísl, ідна_, टिल्, _íþað_, 
   {{0xa2e42803,0x00000000,0x00000000,0x00000000}},	//   фонд, --, --, --, 
   {{0x67202804,0x00000000,0x00000000,0x00000000}},	//   _izlj, --, --, --, 
   {{0x64580ba7,0x7dd82805,0x64a42806,0x01e400db}},	//   _uwwi, _dísl, _цала, _үйлү, 
   {{0x7dd801f1,0xe2c800f2,0x00000000,0x00000000}},	//   _píso, _ووشو_, --, --, 
   {{0xe7e4007d,0xd3442807,0x00000000,0x00000000}},	//   _कतना_, _تیپه_, --, --, 
   {{0xe1f004fb,0x7dd8066a,0x00000000,0x00000000}},	//   _جست_, _gísl, --, --, 
   {{0xa008007b,0x3f8c0037,0x00000000,0x00000000}},	// [2380] _وقبل_, õdus_, --, --, 
   {{0x67202808,0x00000000,0x00000000,0x00000000}},	//   _ozlj, --, --, --, 
   {{0xf0001206,0xa5bc0024,0x00000000,0x00000000}},	//   _сүри, rmųj, --, --, 
   {{0x7e7c0784,0x9f480109,0x2124013a,0x00000000}},	//   murp, libà_, _úohs_, --, 
   {{0x5fd0006d,0x7e7c2809,0x00000000,0x00000000}},	//   _हवाल, lurp, --, --, 
   {{0x1648011c,0x00000000,0x00000000,0x00000000}},	//   очип_, --, --, --, 
   {{0x37c40184,0x63ac0198,0xa3b0033f,0xdab8007b}},	//   _үҙеб, _ɗant, _ऑफ़_, _ظهرت_, 
   {{0x2cac000a,0xc2140134,0x998405c7,0x00000000}},	//   _šedi_, _nkɔ_, mmoů_, --, 
   {{0xd49802bf,0x38c81079,0xd4040815,0x00000000}},	//   іри_, _عاری_, дяни, --, 
   {{0xc214013b,0x7e7c280a,0x32540276,0x461001b9}},	//   _akɔ_, kurp, нвор, _یولر, 
   {{0xc7b006a9,0x7dd8032e,0x580000d1,0xd734030d}},	//   _שבע_, _písl, _كۈچك, _цхаь, 
   {{0x7e7c03f0,0xe6d802d2,0x00000000,0x00000000}},	//   durp, _íráð, --, --, 
   {{0xd3c4280b,0x660400d5,0x3cf8012d,0x4084004e}},	//   _ойдй, éhke, ंपों_, курб, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb8d00003,0x7e7c280c,0x02a0280d,0x00000000}},	//   _ཐན_, gurp, _арым, --, 
   {{0x8d74280e,0x9f480589,0xfbd004fb,0x0204008e}},	//   باسا, tibã_, یتل_, _үзән, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2390] --, --, --, --, 
   {{0x7e7c01c0,0xec14280f,0x00000000,0x00000000}},	//   burp, رواد, --, --, 
   {{0x2f1801c6,0x00000000,0x00000000,0x00000000}},	//   _хонь_, --, --, --, 
   {{0x88f001ec,0x00000000,0x00000000,0x00000000}},	//   кілә, --, --, --, 
   {{0x6e2c0429,0x00000000,0x00000000,0x00000000}},	//   mmab, --, --, --, 
   {{0x6e2c2810,0x63ac03f9,0x7b7404fb,0xb4c8033f}},	//   lmab, _ɗans, _لطفا, ईहै_, 
   {{0x6e2c2811,0x4990065f,0xdec00092,0x00000000}},	//   omab, _لیار, _ትተን_, --, 
   {{0x67200427,0xeb34215c,0xa2bc041c,0x00000000}},	//   _vzlj, _يىڭد, षमस्, --, 
   {{0x601004ce,0x69d82812,0xbb1c0150,0x00000000}},	//   kæmp, mkwe, _ﺷﺎﻕ_, --, 
   {{0xdb0c0793,0x69d82813,0x64a40075,0x00000000}},	//   _vobö, lkwe, _җака, --, 
   {{0xd24c2814,0x7dd82815,0x69d82816,0x601000b5}},	//   ینی_, _sísm, okwe, dæmp, 
   {{0x69d82817,0x7dd80232,0x36d40209,0xbbdc00dc}},	//   nkwe, _písm, _шохр, _यत्क, 
   {{0xa3d41413,0xb5c80214,0xa87800df,0xbb3802dd}},	//   _подч, _تونم_, האָר, _ﻗﺎﻡ_, 
   {{0x53a02818,0x644402b5,0x7dd80162,0x6e2c03ac}},	//   _башб, _ōhiw, _vísm, emab, 
   {{0x44240639,0xdee41639,0x9f4800cf,0x236401a6}},	//   _ihn_, хови, ribà_, malj_, 
   {{0x6e2c2819,0xd24c0597,0x644c067c,0x442401ab}},	//   gmab, _اني_, _çais, _hhn_, 
   {{0x921400c8,0x9c240697,0xdd9402dd,0x716400f7}},	// [23a0] _אַזױ_, едад, маңы, _شايك, 
   {{0x7e7c03a2,0x26e400bd,0x4424017a,0x69d8281a}},	//   purp, _কখনো_, _jhn_, ekwe, 
   {{0x4424281b,0x7e7c0309,0x00000000,0x00000000}},	//   _mhn_, qurp, --, --, 
   {{0x69d8281c,0xceb00bd4,0x442401ab,0x09e0036b}},	//   gkwe, _עיר_, _lhn_, лохн, 
   {{0x2364281d,0x7dd80118,0x00000000,0x00000000}},	//   kalj_, _lísk, --, --, 
   {{0x69d8281e,0x4424017a,0x00000000,0x00000000}},	//   akwe, _nhn_, --, --, 
   {{0x2364281f,0x7dd8032e,0x00000000,0x00000000}},	//   dalj_, _nísk, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x09e02820,0xe000012c,0x195801ec,0xbb381884}},	//   _сотн, ोवाद_, _маңы_, _ﻗﺎﻥ_, 
   {{0x44240175,0xb4580020,0x236401a6,0x00000000}},	//   _chn_, _ያደረጉ, galj_, --, 
   {{0x7a7c02d3,0x442401ab,0x6e2c2821,0xa3b00c4c}},	//   _ብቐጥታ_, _dhn_, ymab, _ऑफर_, 
   {{0x4424016b,0xdb0c01e3,0x562800cf,0x8af80a7c}},	//   _ehn_, _inbä, _эжем_, להיי, 
   {{0x236417a3,0x44242822,0x00000000,0x00000000}},	//   balj_, _fhn_, --, --, 
   {{0x44242823,0x7dd803b2,0x9f4800d8,0x44ac0022}},	//   _ghn_, _físk, tibá_, _ñasẽ_, 
   {{0x644c0240,0x82b02824,0x6d480014,0x00000000}},	//   _çair, _محيط, ِلرِ_, --, 
   {{0x6e2c2825,0x51842826,0x00000000,0x00000000}},	//   umab, _чука, --, --, 
   {{0x7dd82827,0x6e2c2828,0x99880153,0x00000000}},	// [23b0] _získ, rmab, _lubų_, --, 
   {{0x7dd800d2,0xdb0c00a2,0xdec80092,0x00000000}},	//   _lísh, _onbä, _አልኩ_, --, 
   {{0xa0340302,0x69d800d2,0xbb8400c6,0x41c40101}},	//   _שאתה_, tkwe, المي, _شقیق, 
   {{0xdb0c0798,0xfaa40139,0x00000000,0x00000000}},	//   _robô, ышун, --, --, 
   {{0x69d8257d,0x19c00daf,0x394401ec,0xc0e02829}},	//   rkwe, шәрг, уніг, _ነጋሶ_, 
   {{0x69d8282a,0x00000000,0x00000000,0x00000000}},	//   skwe, --, --, --, 
   {{0xd7ec282b,0x23640960,0x69d8282c,0xe5a40075}},	//   تكو_, valj_, pkwe, вийи, 
   {{0xfa78069c,0xc06c00b8,0xfa340736,0x7dd802d2}},	//   _ካልኣይ_, _eṣyā, _مرقد, _rísk, 
   {{0x2364282d,0x7dd801e7,0xdb0c007c,0xc0e00092}},	//   talj_, _dísh, _enbä, _ነፋስ_, 
   {{0x7dd8282e,0xdb0c00d7,0x00000000,0x00000000}},	//   _písk, _tobô, --, --, 
   {{0xf674282f,0x236401a6,0xb4580092,0x92000171}},	//   _مانخ, ralj_, _ያደርጉ, _čārl, 
   {{0xa0682830,0x23640e3c,0x7dd801ef,0x00000000}},	//   мама_, salj_, _vísk, --, 
   {{0x44242831,0x93c82832,0x23640e3c,0x25ac007c}},	//   _thn_, سایہ_, palj_, mdel_, 
   {{0x7dd82833,0x1ea82834,0x25ac0548,0x248c0429}},	//   _tísk, وازي_, ldel_, mtem_, 
   {{0x248c2835,0x6fd800a3,0x7dd801e7,0x00000000}},	//   ltem_, _mìch, _hísi, --, 
   {{0x248c2836,0x6b940139,0x33b00131,0x7dd808a5}},	//   otem_, _abzg, _نەۋر, _kísi, 
   {{0x248c2837,0x8c402838,0xa2a823ef,0x5ba81220}},	// [23c0] ntem_, иете, टिक्, мкам_, 
   {{0x248c2839,0x7dd8283a,0x00000000,0x00000000}},	//   item_, _mísi, --, --, 
   {{0x248c283b,0x7dd800d2,0x6f78008f,0xdee4283c}},	//   htem_, _lísi, _אָרג, _рони, 
   {{0x248c283d,0x25ac0010,0x00000000,0x00000000}},	//   ktem_, jdel_, --, --, 
   {{0x9f48003a,0x7dd8283e,0x248c283f,0x49700150}},	//   ribæ_, _rísh, jtem_, рліс, 
   {{0x248c2840,0x25ac2841,0x48100d30,0x00000000}},	//   dtem_, edel_, аміс, --, 
   {{0x248c16b8,0x7c3c0ba7,0x98b00790,0x8c1400f1}},	//   etem_, _iirr, ıcık_, _شيفر_, 
   {{0x7c3c2842,0x25ac005c,0x2d8c002e,0x248c2843}},	//   _hirr, gdel_, _ñeet_, ftem_, 
   {{0x248c0429,0x7c3c2844,0xf8b001d9,0x73d800fb}},	//   gtem_, _kirr, _دکا_, едпр_, 
   {{0x7c3c2845,0x25ac03bd,0x660c2846,0x19580184}},	//   _jirr, adel_, čaka, _хаҡы_, 
   {{0x248c2847,0x27e80c09,0x7c3c2848,0x25ac0135}},	//   atem_, ɗan_, _mirr, bdel_, 
   {{0xcb1006a9,0x248c011f,0x63800124,0x00000000}},	//   ילת_, btem_, аҳәа, --, 
   {{0x248c2849,0x7c3c284a,0x33940064,0x00000000}},	//   ctem_, _oirr, _балё, --, 
   {{0x7c3c284b,0x00000000,0x00000000,0x00000000}},	//   _nirr, --, --, --, 
   {{0xc2c02266,0xb5fc031c,0xef100137,0x6e4400f2}},	//   _نيوي, _ewġe, сүнө, انرم, 
   {{0x7c3c284c,0xfd7401c0,0x61e40112,0x225000d0}},	//   _airr, илсэ, chkl, ízke_, 
   {{0x7c3c284d,0x22480010,0x00000000,0x00000000}},	// [23d0] _birr, _čaki_, --, --, 
   {{0x7c3c284e,0x3b54284f,0x7c842850,0x00000000}},	//   _cirr, икур, јуте, --, 
   {{0x7c3c2851,0x248c00dd,0xaed40220,0xe9782852}},	//   _dirr, ztem_, _сонш, ебеш_, 
   {{0xe7e413b4,0x248c2853,0xefc80023,0xdb1000e5}},	//   कसभा_, ytem_, _አዝዩ_, ágáv, 
   {{0x7c3c0731,0x6e3c045f,0x6d4c0014,0x67d42854}},	//   _firr, _iisb, mcaa, лоду, 
   {{0x6e3c03f9,0x7c3c1368,0x7dd803b2,0xe7280353}},	//   _hisb, _girr, _rísi, нолд_, 
   {{0x6e3c2855,0x6d4c0548,0xdb4c0014,0x6b840455}},	//   _kisb, ocaa, _ژێے_, mghg, 
   {{0x248c2856,0x26c8098d,0x6d4c2857,0x7c3c01c0}},	//   ttem_, ćao_, ncaa, _zirr, 
   {{0x6e3c0385,0xf9d4010b,0x7c3c0009,0x248c0036}},	//   _misb, _тотэ, _yirr, utem_, 
   {{0x248c2858,0x7dd811c3,0x25ac1347,0x6b840097}},	//   rtem_, _vísi, sdel_, nghg, 
   {{0x44f80165,0x998401a6,0x6e3c02d0,0x66d40592}},	//   _wɪ_, lmoš_, _oisb, _حيائ, 
   {{0x64b41f84,0x6e3c2859,0x248c285a,0xdee400c2}},	//   _محتر, _nisb, ptem_, қоби, 
   {{0x248c0429,0x04640022,0x6d4c058a,0x24f80352}},	//   qtem_, _ртем, dcaa, _янды_, 
   {{0x6d4c285b,0x6e3c285c,0x61e4285d,0x6568285e}},	//   ecaa, _aisb, shkl, laeh, 
   {{0x6e3c285f,0xf3f00597,0xd4040451,0x6d4c2860}},	//   _bisb, _بأن_, _حڪيم_, fcaa, 
   {{0x7c3c2861,0x6e3c0014,0xa0a40022,0x65682862}},	//   _sirr, _cisb, _баид, naeh, 
   {{0x6e3c2863,0x62802864,0x214404fe,0xdb781d0f}},	// [23e0] _disb, lulo, āwhā_, есеш_, 
   {{0x65682865,0x63a02866,0x6e3c1196,0x3d0402e5}},	//   haeh, neln, _eisb, _रखीं_, 
   {{0x62802867,0x656803a0,0x6d4c0067,0x24480208}},	//   nulo, kaeh, bcaa, _lúm_, 
   {{0x6d4c07d5,0x5f442868,0x7c3c2869,0x63a0286a}},	//   ccaa, _جنگل, _wirr, heln, 
   {{0x7c3c003d,0x6280286b,0x2448286c,0x7dd800d2}},	//   _tirr, hulo, _núm_, _sísw, 
   {{0xda64286d,0x63a008ad,0x7c3c286e,0x00000000}},	//   _ماري, jeln, _uirr, --, 
   {{0x63a0286f,0x1ae400c9,0x62802870,0xe7e40d2c}},	//   deln, _совм, julo, _कतरा_, 
   {{0x6e3c0a81,0xc0f002d3,0x63a0000d,0x00000000}},	//   _xisb, ጀርስ_, eeln, --, 
   {{0x6448074d,0x1cb80489,0x80a42871,0x244801fb}},	//   gqei, མའི_, _चैले, _cúm_, 
   {{0x61f42872,0x62802873,0x93a42097,0x70540424}},	//   _amyl, fulo, ушид, ینجا, 
   {{0x62802874,0x21e000c7,0xaed40327,0x6d4c0009}},	//   gulo, _sóha_, ུགབོ, ycaa, 
   {{0x15442875,0x244801e7,0x61f40205,0x6d4c0009}},	//   _седм, _fúm_, _cmyl, xcaa, 
   {{0x6e3c2876,0xc1080276,0x24482877,0x4610009a}},	//   _risb, гэре_, _gúm_, _اونر, 
   {{0x61f4009a,0x6e3c047e,0x41c401ec,0x4730030d}},	//   _emyl, _sisb, _ۇقىق, _енĕс, 
   {{0x6d4c07d5,0x6e3c0280,0x438000f7,0x63b400d0}},	//   tcaa, _pisb, _الىق, ôzne, 
   {{0xefbc0023,0x6d4c058a,0x201800ef,0x2c1c00cd}},	//   ቶንዮ_, ucaa, _ekpi_, _बीजं_, 
   {{0x6d4c2878,0x6e3c2879,0x24480208,0x216400cf}},	// [23f0] rcaa, _visb, _xúm_, _өтөг, 
   {{0x0a68287a,0x6d4c287b,0x6e3c0066,0x2ef4287c}},	//   ерди_, scaa, _wisb, _взор, 
   {{0xdb0c003a,0x6e3c287d,0x61f403cb,0x682c00e4}},	//   _habê, _tisb, _ymyl, lúdg, 
   {{0x63a0287e,0xc33005d0,0x00000000,0x00000000}},	//   zeln, צוף_, --, --, 
   {{0x47700046,0x6280287f,0x2d98198f,0xefc80092}},	//   йқау, zulo, _ibse_, _አምድ_, 
   {{0x24482880,0x65682881,0xb68c02d3,0x7dd802d2}},	//   _rúm_, waeh, _ዘይኮኑ_, _dísu, 
   {{0x65c407d8,0x49b00022,0x656800b0,0x63a01bbf}},	//   ибка, _гәлу, taeh, veln, 
   {{0x62802882,0x660c0fb7,0x32082883,0x656800d8}},	//   vulo, čako, _njay_, uaeh, 
   {{0x63a02884,0xa3b82885,0x2bc82886,0x65682887}},	//   teln, نادر_, रापा, raeh, 
   {{0x62802888,0x66182889,0x23d4288a,0x386000e4}},	//   tulo, _wkwk, рцир, ãire_, 
   {{0xa204288b,0xf77002e9,0x63a0288c,0x6568288d}},	//   ипод, _رال_, reln, paeh, 
   {{0x63a0288e,0x6280288f,0xa3b41414,0x38600311}},	//   seln, rulo, _चोर_, ţire_, 
   {{0x7dd8038e,0x63a02890,0x62802891,0x3d04068f}},	//   _míst, peln, sulo, _रखें_, 
   {{0x7dd80232,0x2d982892,0x0eb000af,0x9f480789}},	//   _líst, _abse_, ुमंड, libú_, 
   {{0x21742893,0x2bc82894,0xb7f8072a,0x9d44010b}},	//   _купр, राना, ्चतम_, иевд, 
   {{0x2d982895,0x290c0077,0x61f402f0,0x7dd802d2}},	//   _cbse_, _oxea_, _umyl, _níst, 
  
   {{0xa0a400ee,0xd12c00db,0x4d44011c,0x00000000}},	// [2400] _тапд, _ۉمۉ_, рпун_, --, 
   {{0x7dd803b2,0xb33c0327,0x00000000,0x00000000}},	//   _rísu, leħa, --, --, 
   {{0x0f780a1e,0x7dd80248,0x596401d5,0x00000000}},	//   _בריל, _sísu, аъла, --, 
   {{0x7dd801e7,0xdb0c0200,0x00000000,0x00000000}},	//   _císt, _habë, --, --, 
   {{0x88c400b8,0xdb0c0200,0x00000000,0x00000000}},	//   _niśī, _kabë, --, --, 
   {{0x7dd805f7,0x7c040451,0x051403d4,0xa3b406b1}},	//   _vísu, _اڀرن, দেৱৰ_, _चोल_, 
   {{0x7dd801e7,0x00000000,0x00000000,0x00000000}},	//   _físt, --, --, --, 
   {{0xdb0c0240,0x4e7800df,0x76580064,0x00000000}},	//   _labë, דאקצ, rpvy, --, 
   {{0x335400cf,0x00000000,0x00000000,0x00000000}},	//   бүлө_, --, --, --, 
   {{0x2bc80b7c,0xd3940d52,0xdb0c0248,0x645c0022}},	//   राया, рәдә_, _àkóy, ãsia, 
   {{0x0bb40302,0x52240108,0x00000000,0x00000000}},	//   בלים_, ифма, --, --, 
   {{0x05802896,0x7dd82897,0xd4982898,0x22500306}},	//   _душм, _míss, _арк_, ízka_, 
   {{0x2bc82899,0x7648289a,0xdb0c0240,0x629c0356}},	//   रामा, _hudy, _babë, ăsoa, 
   {{0x7648289b,0xb7f81ab2,0x439000c0,0x00000000}},	//   _kudy, ्चिम_, _маіс, --, 
   {{0xdb0c025a,0x5f18000d,0x32080076,0x60c0025c}},	//   _wabê, _मुद्_, _tjay_, _ġome, 
   {{0x60c0000a,0x7648289c,0x3208289d,0x2bc809fa}},	//   _šome, _mudy, _ujay_, राभा, 
   {{0x6b741919,0xab740228,0xcb440124,0x3218289e}},	// [2410] йлау, йгаш, ахеи, mosy_, 
   {{0xdb0c034c,0x3218289f,0x764828a0,0x7dd828a1}},	//   _kabè, losy_, _oudy, _síst, 
   {{0xdb0c0100,0x2bc828a2,0x7dd80118,0x4ea41fbe}},	//   _jabè, राबा, _píst, _трпа, 
   {{0x321828a3,0xfe2428a4,0xdf5400f1,0x00000000}},	//   nosy_, _мьян, _پریښ, --, 
   {{0x7dd8022c,0xdb0c1497,0x31680165,0x7648033f}},	//   _víst, _labè, _meaz_, _audy, 
   {{0x7648068f,0x2ca807ab,0x321806d9,0x2d8828a5}},	//   _budy, mwad_, hosy_, lgae_, 
   {{0x2ca80368,0x321828a6,0x76480042,0x7dd81427}},	//   lwad_, kosy_, _cudy, _tíst, 
   {{0x2d8828a7,0xe298020a,0x00000000,0x00000000}},	//   ngae_, қам_, --, --, 
   {{0x321803d1,0x2ca80368,0x9f48004e,0xc7a00014}},	//   dosy_, nwad_, ribú_, _ؤری, 
   {{0xdb0c007f,0xe28428a8,0x88c400cd,0xe79411c5}},	//   _babè, блои, _viśī, _دارک, 
   {{0x216828a9,0x316801c4,0x321828aa,0xe7840116}},	//   лини_, _beaz_, fosy_, _вуҗо, 
   {{0x321828ab,0x2ca80100,0xddcc00e2,0xdb0c0200}},	//   gosy_, kwad_, rsbū, _sabë, 
   {{0x31680165,0x672028ac,0xd5a40133,0xdb0c0200}},	//   _deaz_, _hylj, _دلنی, _pabë, 
   {{0xd9180302,0x764806d1,0x23280131,0x4610006c}},	//   רושל, _yudy, _йоли_, _اوچر, 
   {{0xe29828ad,0xdb0c1f3f,0x321805da,0x76481180}},	//   _сай_, _gabè, bosy_, _xudy, 
   {{0x229028ae,0x672002d2,0xdd9001e7,0x527800df}},	//   mák_, _mylj, ثور_, _ענפא, 
   {{0x2ca8089c,0xdb0c007f,0x00000000,0x00000000}},	// [2420] gwad_, _zabè, --, --, 
   {{0x9f8428af,0xdb0c28b0,0x6720090c,0xfb8428b1}},	//   _угод, _habé, _oylj, تدری, 
   {{0xdb0c28b2,0x3f9828b3,0x229028b4,0x77680076}},	//   _kabé, mfru_, nák_, _redx, 
   {{0x3eb828b5,0x2ca80158,0x3f9801e4,0x00000000}},	//   mvrt_, bwad_, lfru_, --, 
   {{0xd7f828b6,0xdb0c02ea,0x764828b7,0x2ca80014}},	//   лук_, _mabé, _sudy, cwad_, 
   {{0x2bc828b8,0x6720002d,0x229028b9,0xdb0c003e}},	//   राणा, _bylj, kák_, _labé, 
   {{0x229028ba,0x3eb8151c,0x764806be,0xc674007b}},	//   ják_, nvrt_, _qudy, محيط_, 
   {{0x229028bb,0x76480564,0x672428bc,0x67200162}},	//   dák_, _vudy, ühja, _dylj, 
   {{0x05700ed1,0xdb0c068c,0x5344009d,0x4d78010f}},	//   سايد, _sabè, йхна, ארפע, 
   {{0xb27428bd,0x229028be,0x672028bf,0xedc4098a}},	//   олош, fák_, _fylj, _लच्छ, 
   {{0x22900429,0x7648079b,0x321828c0,0x644c00d8}},	//   gák_, _uudy, tosy_, _éain, 
   {{0xd4680cfc,0xdb0c003e,0x924c001f,0x506428c1}},	//   _биде_, _cabé, _አደረጃ, йтга, 
   {{0x321828c2,0xdce40327,0x682c0030,0xdb0c02f0}},	//   rosy_, _dekċ, súde, _dabé, 
   {{0x32181311,0x229028c3,0x9590001f,0xdb0c00f2}},	//   sosy_, bák_, ጃዎችን_, _tabè, 
   {{0x823428c4,0x321806d9,0x5184033a,0x229026f6}},	//   تریا, posy_, _лупа, cák_, 
   {{0x2ca80142,0x00000000,0x00000000,0x00000000}},	//   twad_, --, --, --, 
   {{0x2d880381,0x00000000,0x00000000,0x00000000}},	// [2430] rgae_, --, --, --, 
   {{0x2bc806ff,0x4ae80354,0x6b7402dd,0x2d88003a}},	//   राधा, льем_, ілеу, sgae_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd36415fa,0x6dc00228,0x2d88004e,0xa9840137}},	//   _ښه_, _تۅرۅ, _өйүп_, تۅرۅ_, 
   {{0x672028c5,0x2bc828c6,0x7c8428c7,0x229028c8}},	//   _sylj, रादा, _нуре, zák_, 
   {{0x229028c9,0xfe70036b,0x8bc80276,0xb6b8031c}},	//   yák_, _تدی_, _сымб_, _ཚནྡྷ, 
   {{0xc95801a9,0x00000000,0x00000000,0x00000000}},	//   _бўз_, --, --, --, 
   {{0x229028ca,0xdb0c0109,0xdb2401d5,0x79940107}},	//   vák_, _kabî, _ذوقی, _нисф, 
   {{0xa5080801,0x22900548,0x00000000,0x00000000}},	//   репа_, wák_, --, --, 
   {{0x229028cb,0xdb0c28cc,0x22500122,0xd7d40014}},	//   ták_, _sabé, ízko_, _وصلک, 
   {{0xd5ac0502,0x23280364,0xdb0c28cd,0x65941078}},	//   رفی_, рони_, _pabé, _мажу, 
   {{0x229028c3,0x63ac02a8,0x363400c6,0x1b1400eb}},	//   rák_, _ɗany, _فرنس, থেকে_, 
   {{0x229028cb,0x660828ce,0x20d40006,0x94c800f1}},	//   sák_, mnek, цінс, _ناوې_, 
   {{0xa2e428cf,0x645828d0,0x3eb81050,0x229028d1}},	//   _молд, _itwi, tvrt_, pák_, 
   {{0x660828d2,0xdb0c0098,0x22900548,0x5f1800e1}},	//   onek, _tabé, qák_, _मुश्_, 
   {{0x628001a6,0x3f980327,0x00000000,0x00000000}},	//   mrlo, sfru_, --, --, 
   {{0x660828d3,0x9f340220,0x7dd801e7,0x7bd8005b}},	// [2440] inek, сеңі, _dísp, övuo, 
   {{0x62802595,0xc1740198,0x6608002f,0xd9e028d4}},	//   orlo, _doɗe_, hnek, पस्ट, 
   {{0x660828d5,0x644c00b8,0x00000000,0x00000000}},	//   knek, _ũail, --, --, 
   {{0x660828d6,0x18a402bf,0x645828d7,0x628028d8}},	//   jnek, жадм, _otwi, irlo, 
   {{0x645828d9,0xdce40010,0x7dd800d8,0x62800112}},	//   _ntwi, _kekč, _uísq, hrlo, 
   {{0x660801c0,0x9610107c,0x628001a9,0xe51c0037}},	//   enek, डक्ट_, krlo, _पड़ि_, 
   {{0x645828da,0x66080472,0x8b201173,0x070400ec}},	//   _atwi, fnek, _ждре, يڊمي_, 
   {{0xd49828db,0x66080ac8,0xdef402d3,0xfa240327}},	//   аро_, gnek, _ዎያነ_, _འཚིན_, 
   {{0x628028dc,0xb5480022,0x00000000,0x00000000}},	//   erlo, аҧҵа_, --, --, 
   {{0x4f880023,0x28100116,0x00000000,0x00000000}},	//   ንቀቕታ_, _كۈنس, --, --, 
   {{0x9f5805d5,0x62840212,0x2bdc0764,0xb6c401c6}},	//   _impè_, _åhol, _यवसा, _хөлд, 
   {{0x60c028dd,0xd5a404fb,0x00000000,0x00000000}},	//   _šoma, _گلچی, --, --, 
   {{0x628028de,0x682c00c6,0xa3b428df,0x00000000}},	//   arlo, lúda, _चोक_, --, 
   {{0x09c428e0,0x00000000,0x00000000,0x00000000}},	//   _रच्य, --, --, --, 
   {{0x2bc828e1,0x2ee40008,0x926800d8,0x00000000}},	//   रासा, álf_, _трла_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7dd828e2,0x201801a8,0x82340472,0x00000000}},	// [2450] _vísp, ófið_, _تروا, --, 
   {{0x80a428e3,0x660c0427,0xbc68007b,0xcc140066}},	//   _کمین, čaki, تمكن_, آذرب, 
   {{0x660828e4,0x00000000,0x00000000,0x00000000}},	//   ynek, --, --, --, 
   {{0xdd9013ef,0x2bc818cc,0xd0fc0073,0x00000000}},	//   _كوپ_, राहा, _उधाण_, --, 
   {{0x48a8008e,0x00000000,0x00000000,0x00000000}},	//   ртем_, --, --, --, 
   {{0x6608031c,0xa7a828e5,0x00000000,0x00000000}},	//   wnek, скка_, --, --, 
   {{0x660828e6,0xdb0c0109,0x64580034,0xd90c00f1}},	//   tnek, _jabì, _stwi, نیې_, 
   {{0x2bc82017,0x9f5807c5,0x9730141d,0x00000000}},	//   रावा, _empè_, رکلا, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x660828e7,0xe28428e8,0x682c0030,0x46601b56}},	//   snek, плои, búda, _قۇتق, 
   {{0xdce4007f,0x62800430,0x3940107d,0x4cdc00fe}},	//   _rekč, urlo, žist_, _নেমু, 
   {{0x66080784,0xdce40306,0x628028e9,0x69c000bc}},	//   qnek, _sekč, rrlo, _रोमी, 
   {{0x645828ea,0xe36428eb,0x00000000,0x00000000}},	//   _utwi, _екли, --, --, 
   {{0xdfd0035d,0xe3b028ec,0x00000000,0x00000000}},	//   ريز_, _سرت_, --, --, 
   {{0xb8040055,0x88c00154,0x929000d8,0x00000000}},	//   _anṛś, ্নিক, _зајц, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0d80009d,0x00000000,0x00000000,0x00000000}},	// [2460] элтн, --, --, --, 
   {{0x88c004c5,0x682c0309,0x0c2028ed,0x00000000}},	//   ্নাক, yúda, емун, --, 
   {{0x34a8102f,0x9f0428ee,0xdb0c002f,0x00000000}},	//   _कन्द, _روحو, _unbü, --, 
   {{0x61e40549,0x00000000,0x00000000,0x00000000}},	//   nkkl, --, --, --, 
   {{0x394028ef,0x2bc828f0,0x48e028f1,0x00000000}},	//   äis_, राशा, ноцв, --, 
   {{0xdb0c28f2,0x682c0077,0xd73001c6,0x00000000}},	//   _habí, túda, ндлө, --, 
   {{0xdb0c00d0,0x2bc817c6,0xf1c0013a,0x690403e3}},	//   _kabí, रारा, íšky_, _ərdə, 
   {{0x682c007b,0xceb00375,0x00000000,0x00000000}},	//   rúda, תיה_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x325428f3,0x61e4017a,0x00000000,0x00000000}},	//   мвор, ekkl, --, --, 
   {{0x27e00112,0xc7b0011a,0xe6c400ae,0x00000000}},	//   öhne_, _רבע_, _يتمي, --, 
   {{0xdb0c02f8,0x741400ec,0xa2c00352,0x00000000}},	//   _nabí, _ڪوتا, тәшк, --, 
   {{0x4fc400a7,0x932400e5,0x7bc801e1,0x00000000}},	//   псва, _کرشن, _òduw, --, 
   {{0x741428f4,0xdfd000f1,0x8538011a,0x00000000}},	//   _توتا, نيټ_, _הגדי, --, 
   {{0xa3b416f0,0xef1000f7,0xdb0c02f0,0xca68155b}},	//   _चोट_, түнө, _babí, мiнi, 
   {{0xdb0c1dec,0x61e411a1,0x645c00ae,0x00000000}},	//   _cabí, ckkl, ísig, --, 
   {{0x4fc4035b,0x2bc828f5,0xb0140640,0x3014014b}},	// [2470] _есна, राला, _омиљ, _одир, 
   {{0x77f8012c,0x645c00df,0x00000000,0x00000000}},	//   ्चोक_, ŭsig, --, --, 
   {{0xdb0c00d8,0x00000000,0x00000000,0x00000000}},	//   _fabí, --, --, --, 
   {{0x6c54004e,0xfcf80092,0x00000000,0x00000000}},	//   _окму, ጋግጡ_, --, --, 
   {{0x2038001f,0xf9900bce,0xa88828f6,0x8cc4030d}},	//   _በህብረ, ابم_, ійка_, _хĕлĕ_, 
   {{0x8d7428f7,0xdb0c0308,0x00000000,0x00000000}},	//   _باھا, _zabí, --, --, 
   {{0xdce400da,0xb8d400af,0x61e4143a,0x00000000}},	//   _iekā, _छै_, ykkl, --, 
   {{0xe45828f8,0x3e5802f0,0x00000000,0x00000000}},	//   ожи_, _učte_, --, --, 
   {{0x69c828f9,0xdce40069,0xc74428fa,0xef18012d}},	//   _inee, _kekā, _فضاي, ęży_, 
   {{0x69c801d4,0xf79428fb,0xa2e428fc,0x00000000}},	//   _hnee, _пауэ, доод, --, 
   {{0x9f58019f,0x682c00d0,0x69c828fd,0x00000000}},	//   _umpé_, lúdo, _knee, --, 
   {{0xa3c828fe,0x00000000,0x00000000,0x00000000}},	//   _लचक_, --, --, --, 
   {{0x250813e1,0x61e40373,0xc0c8004b,0xdb0c28ff}},	//   _برای_, rkkl, سېده_, _rabí, 
   {{0xdb0c2900,0xdce400da,0x660c151c,0x94240228}},	//   _sabí, _nekā, čaku, _قونۇ, 
   {{0x5dd82901,0x02c000db,0x4da80116,0x00000000}},	//   офар_, _чийү, ﺷﻠﯩﻨ, --, 
   {{0x69c82252,0x7f7c005e,0xfcf80092,0xe1080f06}},	//   _nnee, ﺌﻴل_, ጋግጥ_, _мейд_, 
   {{0x205407d6,0x3d281b2c,0x1c442902,0x60e800d4}},	// [2480] _ўтир, ستری_, днам, _ємом_, 
   {{0x69c82903,0x9f482904,0x5f741dd8,0x00000000}},	//   _anee, ribó_, _کاکر, --, 
   {{0x684c02d3,0xdb0c008e,0xdce400de,0x00000000}},	//   _ንሰለስ, _tabí, _dekā, --, 
   {{0x9f48026c,0x00000000,0x00000000,0x00000000}},	//   cibò_, --, --, --, 
   {{0x28a81524,0xdce40171,0xd9ac012d,0x00000000}},	//   चौलि, _fekā, _घसीट, --, 
   {{0x69c82905,0x236401fa,0xc950035b,0x682c00d7}},	//   _enee, jblj_, нтәы, súdn, 
   {{0xdb0c025a,0x7bdc007b,0x3c34007c,0x00000000}},	//   _wabâ, _ioru, rävd_, --, 
   {{0x7bdc2906,0xc8800365,0x69c80076,0xdb2002d1}},	//   _horu, üğü_, _gnee, _ñuñu, 
   {{0x7bdc2907,0xb8f400cd,0x00000000,0x00000000}},	//   _koru, _koṭī, --, --, 
   {{0x7bdc08fb,0xbbdc0210,0x00000000,0x00000000}},	//   _joru, _मकोक, --, --, 
   {{0x7bdc2908,0x00000000,0x00000000,0x00000000}},	//   _moru, --, --, --, 
   {{0x7bdc2909,0x15b00075,0x2d8c00e8,0x550402ac}},	//   _loru, _شەخس, _ñeex_, _очла, 
   {{0xf1f401c0,0xdb0c007f,0xc05801ec,0x7bdc0cad}},	//   _үзлэ, _labà, діс_, _ooru, 
   {{0x7bdc290a,0x00000000,0x00000000,0x00000000}},	//   _noru, --, --, --, 
   {{0x682c000f,0xff040108,0x00000000,0x00000000}},	//   dúdl, вятн, --, --, 
   {{0x7094023b,0xdce400e2,0xf07801b9,0xb81400fe}},	//   _заиф, _sekā, _ейиш_, িতিত_, 
   {{0x7bdc290b,0x682c00d2,0xdd1400f7,0x25a8002e}},	// [2490] _boru, fúdl, ептө, _ñale_, 
   {{0x7bdc290c,0x5f180574,0x0ae800db,0x00000000}},	//   _coru, _मुक्_, يراي_, --, 
   {{0xdb0c2852,0xe5680419,0xb81400fe,0x3f140153}},	//   _cabà, _líšč, িতাত_, _адэс, 
   {{0x7bdc0de4,0xdb0c06ed,0xa8740220,0xc33004ae}},	//   _eoru, _sabã, елді, דוע_, 
   {{0xfcf80023,0x00000000,0x00000000,0x00000000}},	//   ጋግጾ_, --, --, --, 
   {{0xfe700214,0x682c00d7,0x7b440116,0x00000000}},	//   _حدی_, rúdo, رئەل, --, 
   {{0x26c002f8,0x68340209,0x48fc05f9,0x9aa00014}},	//   ího_, _aýdý, _शेरो_, _مۅلو, 
   {{0x69c8290d,0x7bdc0365,0xfcf8044e,0x3c3400e4}},	//   _unee, _zoru, ጋግጽ_, räve_, 
   {{0x7bdc290e,0x543400dd,0xa9680724,0xdec80257}},	//   _yoru, کرٹر, _миңа_, _አውን_, 
   {{0x3834013d,0x62640276,0xd4040014,0x7bdc290f}},	//   _анур, нвоа, ى۪نم_, _xoru, 
   {{0xdb0c1dee,0xa2e42910,0x28b40f44,0x00000000}},	//   _kabá, хонд, _आईडि, --, 
   {{0xbbdc1b51,0xe1f00f0d,0x00000000,0x00000000}},	//   _मक्क, اسد_, --, --, 
   {{0x25ac2911,0x64a42912,0xa43812c4,0xc5082913}},	//   meel_, _чала, _езду_, _بتال_, 
   {{0x25ac2914,0xd24c00b2,0xdb0c2915,0x00000000}},	//   leel_, _ڏنو_, _inbö, --, 
   {{0x5f180c2e,0x7bdc2916,0x248c00d8,0x00000000}},	//   _मुख्_, _roru, luem_, --, 
   {{0x7bdc2917,0x25ac2918,0x9f5801e7,0xdb0c0306}},	//   _soru, neel_, _impí_, _nabá, 
   {{0x7bdc2919,0x248c291a,0x10a0010b,0x6ab401d3}},	// [24a0] _poru, nuem_, _биын, _aszf, 
   {{0x25ac291b,0x7bdc291c,0x1f64160b,0xce4401c6}},	//   heel_, _qoru, _яком, _үзье_, 
   {{0x7bdc291d,0x25ac291e,0xdb0c291f,0xf0002920}},	//   _voru, keel_, _babá, _түри, 
   {{0x7bdc2921,0xd70809a5,0xdb0c01e7,0x25ac2922}},	//   _woru, үнде_, _cabá, jeel_, 
   {{0x25ac2923,0x05d0013a,0x00000000,0x00000000}},	//   deel_, थानब, --, --, 
   {{0xeff0044e,0xdb0c0109,0xd6d81468,0x7bdc03ac}},	//   _ፍቓድ_, _tabà, зти_, _uoru, 
   {{0x25ac2924,0x21e003b2,0xea9409a0,0x39581954}},	//   feel_, _jóhs_, _иштэ, ፈሳውያ, 
   {{0xdb0c0548,0x25ac1bce,0x0f34010f,0x8570011c}},	//   _gabá, geel_, ערקט_, глъх, 
   {{0x248c2925,0xd40416a8,0x9984030a,0x25e000c5}},	//   guem_, еяни, lloů_, _ओकरी_, 
   {{0xdb0c1315,0x0900084c,0xd3782926,0x00000000}},	//   _zabá, _спун, ччи_, --, 
   {{0x25ac1dd0,0x7dd800dd,0x454000d1,0xf4842927}},	//   beel_, _dísz, نچۇق, راکی, 
   {{0x7a3800d2,0x25ac0014,0x248c0798,0xfcf80023}},	//   sítf, ceel_, buem_, ጋግጹ_, 
   {{0x0fe00137,0x854001af,0x644c0055,0x00000000}},	//   гөнү, _йэше, _ũaiv, --, 
   {{0xc32c2928,0x00000000,0x00000000,0x00000000}},	//   _گەپ_, --, --, --, 
   {{0xdb0c01e1,0x00000000,0x00000000,0x00000000}},	//   _àkèy, --, --, --, 
   {{0xc32c1a59,0x5678001f,0x427002e8,0x00000000}},	//   _دەپ_, _አይነቱ_, _сгъс, --, 
   {{0xb034010b,0x00000000,0x00000000,0x00000000}},	// [24b0] _иниш, --, --, --, 
   {{0xdb0c1ada,0x25ac2929,0x4f6800db,0x59c41777}},	//   _sabá, zeel_, _эшим_, _रोबर, 
   {{0x25ac292a,0xfc30007b,0x248c0200,0xfee4022e}},	//   yeel_, صحك_, zuem_, _бўям, 
   {{0x25ac1bce,0x00000000,0x00000000,0x00000000}},	//   xeel_, --, --, --, 
   {{0x25ac292b,0x79800204,0x6d5c011f,0x67d4292c}},	//   veel_, _ddmw, _ifsa, коду, 
   {{0x25ac292d,0x6d5c009a,0x6e2c292e,0x248c0369}},	//   weel_, _hfsa, llab, vuem_, 
   {{0x25ac292f,0x6e2c2930,0xd6cc0137,0xdb0c2931}},	//   teel_, olab, ققو_, _tabá, 
   {{0x6e2c2932,0x2bc81d27,0xa91c00a1,0x248c2933}},	//   nlab, राका, _adže, tuem_, 
   {{0x25ac1574,0x6e2c2934,0x3914022e,0x00000000}},	//   reel_, ilab, _бмтр, --, 
   {{0x6e2c2935,0xeff00023,0x25ac2936,0x248c2937}},	//   hlab, _ፍቓዱ_, seel_, ruem_, 
   {{0x6d5c2938,0x25ac057b,0x248c01b8,0xf7700a11}},	//   _ofsa, peel_, suem_, _داق_, 
   {{0x69d82939,0x25ac208d,0x64c4007b,0xd09806be}},	//   njwe, qeel_, _ليصل, lçəy, 
   {{0x248c293a,0x6568293b,0xdd90293c,0x6e2c293d}},	//   quem_, mbeh, یوس_, dlab, 
   {{0x65680627,0x7a38293e,0x6d5c293f,0x6e2c2940}},	//   lbeh, míte, _afsa, elab, 
   {{0x6e2c2941,0x442405b1,0x7a382942,0x00000000}},	//   flab, _ikn_, líte, --, 
   {{0x6e2c2943,0x65682944,0xa6e80016,0xdca40131}},	//   glab, nbeh, _trươ, каби, 
   {{0x7a382945,0xd12c10fe,0x44242946,0xa3e40490}},	// [24c0] níte, _ومى_, _kkn_, _नवा_, 
   {{0x26c40395,0x6e2c2947,0x6d5c03ee,0x4424009f}},	//   _orlo_, alab, _efsa, _jkn_, 
   {{0x44242948,0x7a380332,0x00000000,0x00000000}},	//   _mkn_, híte, --, --, 
   {{0x6e2c2949,0x6568294a,0x58840962,0x4424294b}},	//   clab, jbeh, выка, _lkn_, 
   {{0x26c401c0,0xadc40075,0x4c800153,0xed34294c}},	//   _arlo_, _саяһ, _кляв, _бэрэ, 
   {{0x656801f1,0x798003ac,0xc7a000d8,0x7a38294d}},	//   ebeh, _wdmw, иичк, díte, 
   {{0xa3d41428,0x65680ea0,0x787801d3,0x33740116}},	//   हान_, fbeh, _búvá, ңгир, 
   {{0x4424294e,0x09e007d8,0xdcf4294f,0x00000000}},	//   _akn_, _косн, leyı, --, 
   {{0x4424207a,0x7a3800dd,0x26c401c4,0x09e02950}},	//   _bkn_, gíte, _erlo_, _тотн, 
   {{0xdcf40205,0x00000000,0x00000000,0x00000000}},	//   neyı, --, --, --, 
   {{0x65682951,0x44240036,0x6e2c2952,0x657c022e}},	//   bbeh, _dkn_, ylab, аshd, 
   {{0x850007d6,0x6e2c0077,0x00000000,0x00000000}},	//   اوین, xlab, --, --, 
   {{0xf0e81c02,0xdb0c01b8,0x44242953,0x66100133}},	//   رىسى_, _habä, _fkn_, _دژوا, 
   {{0x44240077,0x6e2c2954,0x74140150,0x6e9401c4}},	//   _gkn_, wlab, _حوتا, лигу, 
   {{0x6e2c2955,0xdcf40205,0x00000000,0x00000000}},	//   tlab, deyı, --, --, 
   {{0x5184115c,0x6e2c00a3,0x00000000,0x00000000}},	//   _рука, ulab, --, --, 
   {{0x6e2c2956,0x44240a4d,0x31782957,0x201c02b1}},	// [24d0] rlab, _ykn_, masz_, ōtia_, 
   {{0x317800f8,0x6e2c2958,0xa3d41c15,0x442405b1}},	//   lasz_, slab, हाय_, _xkn_, 
   {{0xdb0c025a,0x16202122,0x69d82959,0x7a38295a}},	//   _nabä, मवार_, tjwe, zíte, 
   {{0x60c01ebd,0x3c34295b,0x79a400db,0x3178295c}},	//   _šomi, räva_, ирче, nasz_, 
   {{0xa7a8295d,0xbb2c00d1,0x5ec80154,0x6568047e}},	//   екла_, ﻧﻨﻰ_, রহণে, vbeh, 
   {{0xe738295e,0x76400076,0x656801f5,0xdbd0010b}},	//   нел_, emmy, wbeh, _küýs, 
   {{0x3178295f,0x2d9801f7,0xe5a40131,0x00000000}},	//   kasz_, _kcse_, гийи, --, 
   {{0x26c404b9,0x442406f2,0xdb0c01c7,0x656801a4}},	//   _vrlo_, _skn_, _dabä, ubeh, 
   {{0x65682960,0x31780034,0x7dcc0139,0x74f801c6}},	//   rbeh, dasz_, _mösе, вээс_, 
   {{0x7a382961,0x7640062c,0x00000000,0x00000000}},	//   ríte, ammy, --, --, 
   {{0x7a382962,0xa91c098d,0x26c402e8,0x2d980395}},	//   síte, _udžb, _urlo_, _ocse_, 
   {{0x44242963,0x7a3801ed,0x65680455,0x7e7c01e4}},	//   _wkn_, píte, qbeh, vsrp, 
   {{0x442401a6,0x7a38004e,0xbb6c0131,0xb5c80214}},	//   _tkn_, lítc, _ﺷﯘﯕﺎ_, _جونم_, 
   {{0x66082964,0x25bc2965,0x44240113,0xd24c2966}},	//   liek, _hawl_, _ukn_, _کني_, 
   {{0x64402967,0x53980302,0x9f9400c5,0xdb0c013d}},	//   mmli, _ניקו, müük_, _xabä, 
   {{0x660811f9,0xe1f00502,0x2d98007f,0x21740733}},	//   niek, _دست_, _ccse_, _сукр, 
   {{0xbb5800b5,0xd00c004b,0x25bc015d,0x9f3402dd}},	// [24e0] _ageで_, _ډلي_, _mawl_, теңі, 
   {{0x64402968,0x2d9801ab,0x9f042969,0x6608296a}},	//   nmli, _ecse_, _موخو, hiek, 
   {{0x6608296b,0xdee4296c,0x2008296d,0x2bc8296e}},	//   kiek, _сони, mibi_, राजा, 
   {{0x2008296f,0xceb0008f,0x64402970,0x66080af9}},	//   libi_, _פיר_, hmli, jiek, 
   {{0x7a1c012c,0x2cb8030a,0xdbd000c5,0xdb0c0139}},	//   jčte, _gssd_, _küüs, _sabä, 
   {{0xc8c42971,0x3178012d,0xaaac166d,0x00000000}},	//   اوون_, zasz_, _घनचक, --, 
   {{0x645c09cc,0x66082595,0x25bc2972,0xdbd00037}},	//   ísin, fiek, _bawl_, _müüs, 
   {{0x20082973,0x64400649,0x66082974,0xd9442975}},	//   hibi_, emli, giek, _беби, 
   {{0x20082976,0x779404d3,0x25bc003d,0x2bc82977}},	//   kibi_, _نیشا, _dawl_, राचा, 
   {{0x200823db,0x64400270,0x3178012d,0x33742978}},	//   jibi_, gmli, wasz_, шгор, 
   {{0x66082979,0xa91c05be,0x16640640,0x31781790}},	//   biek, _idža, _свем, tasz_, 
   {{0x6440297a,0x66080034,0xf8b801ad,0xe6840116}},	//   amli, ciek, _इनाय, _тәшк_, 
   {{0x3dc000a9,0x657c0bcd,0x3178297b,0x64400175}},	//   ddiw_, ðshe, rasz_, bmli, 
   {{0x682c297c,0x20080548,0x5338030d,0xa3d4084d}},	//   túdi, gibi_, _пуйă, हाण_, 
   {{0x25bc01ab,0xdbd0000d,0x317801d3,0xbe880108}},	//   _yawl_, _düüs, pasz_, лсте_, 
   {{0xa3d402c3,0x7054297d,0xa2640051,0x682c00d7}},	//   हाथ_, _پندا, _muộ, rúdi, 
   {{0x2008297e,0x1ae000bd,0xa91c0960,0xdbd000af}},	// [24f0] bibi_, _গেলে_, _odža, _füüs, 
   {{0x6608297f,0x682c00d8,0xdbd00432,0xb33c031c}},	//   ziek, púdi, _tüýs, leħq, 
   {{0xa3d42980,0x7ff400f1,0xdb0c0241,0x00000000}},	//   हात_, _دسيا, _àkìy, --, 
   {{0xac942981,0x66080036,0x8c5400f7,0x69d42982}},	//   _камш, xiek, _مئسا, णाधी, 
   {{0xa3e42983,0x9f480295,0x69240b3e,0x64401081}},	//   _नवल_, _ùjòn_, јмла, ymli, 
   {{0x25bc00a9,0x6608068f,0x5ea001d9,0xca742984}},	//   _sawl_, wiek, _دۅہل, _مارغ, 
   {{0x66082985,0xa264004d,0x25bc2986,0x00000000}},	//   tiek, _cuộ, _pawl_, --, 
   {{0x20082987,0x6e3c0165,0x25bc2988,0x7eac005b}},	//   zibi_, _jhsb, _qawl_, _höpö, 
   {{0xfa340722,0x20080296,0xb464030f,0xa7b801ee}},	//   _طرفد, yibi_, یدیه, _илау_, 
   {{0x66082989,0x20081529,0x7a38298a,0x13e4023a}},	//   siek, xibi_, míta, имый_, 
   {{0x2168298b,0x7a3801ed,0x6fb8031c,0x6608298c}},	//   кини_, líta, _བལྟའ, piek, 
   {{0xdbd00254,0x7eac01f4,0x00000000,0x00000000}},	//   _süüs, _löpö, --, --, 
   {{0x2008298d,0x046400a8,0xe7b80490,0xa3d4298e}},	//   tibi_, _стем, _इसाप, हाद_, 
   {{0xdb0c00d2,0x248c298f,0xe3b000f2,0xdd9000ec}},	//   _cabû, mrem_, _ذرت_, ڪور_, 
   {{0x20082990,0x5de42991,0x248c007c,0x92540798}},	//   ribi_, ажва, lrem_, _кајт_, 
   {{0x06ac2992,0x248c0483,0x20082993,0x7a3801d3}},	//   কিপি, orem_, sibi_, kíta, 
   {{0x248c06a3,0xb1640032,0x61f402d0,0x20080098}},	// [2500] nrem_, _уныһ, _ilyl, pibi_, 
   {{0x907804ac,0xdfb804fb,0x248c004e,0x20082994}},	//   _שטיי, _شاخص_, irem_, qibi_, 
   {{0x248c2995,0xdcf4007f,0x00000000,0x00000000}},	//   hrem_, mayč, --, --, 
   {{0x248c0903,0x18682996,0xdd20054e,0xdb0c2997}},	//   krem_, вади_, _cîţi, _kabú, 
   {{0xdb0c00d2,0xd7f821ba,0x6c3001ed,0x7c3c036e}},	//   _jabú, кук_, _کہلا, _thrr, 
   {{0xda642998,0x06ac04c5,0x248c2999,0x7ebc01bf}},	//   _ناري, কিনি, drem_, _gåpå, 
   {{0x248c299a,0x68f406be,0x69c005dc,0x00000000}},	//   erem_, _əzdi, _रोकी, --, 
   {{0x248c299b,0x80b807f7,0xd874299c,0x7a38299d}},	//   frem_, ेटाइ, _نائب, bíta, 
   {{0x248c1028,0x6aa801fa,0x7a3800fd,0x918001fb}},	//   grem_, _ćefi, cíta, _nếu_, 
   {{0x53e4299e,0x61f4010e,0x38a00ba1,0x5344299f}},	//   рциа, _alyl, mòr_, ихна, 
   {{0x248c29a0,0x4b7800c8,0xd5b829a1,0x5f04033f}},	//   arem_, כטיג, _асл_, _हेल्_, 
   {{0x248c29a2,0x20180113,0x5064036b,0x94a829a3}},	//   brem_, _ajpi_, итга, _атка_, 
   {{0xfeb829a4,0x248c29a5,0x38a029a6,0x00000000}},	//   یافت_, crem_, nòr_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x61f429a7,0x628403cd,0x38a000a3,0x3eb8015d}},	//   _flyl, _åhop, hòr_, gwrt_, 
   {{0xb398001f,0x4f940588,0x7eac29a8,0x59c401ad}},	//   _ጉዳዩን_, ырҭу, _söpö, _रोलर, 
   {{0x7eac2776,0x8b6400cf,0xd7c40490,0x320829a9}},	// [2510] _pöpö, لاام, लयाच, _imay_, 
   {{0x6fb429aa,0x7a381a09,0x38a00086,0x0a680e92}},	//   _امدا, víta, dòr_, врди_, 
   {{0x0534044e,0xdb0c00d0,0xba740a11,0x248c00d7}},	//   _ብድሕሪ, _zabú, قانت, zrem_, 
   {{0x06ac000e,0xc9840283,0x91800208,0x248c29ab}},	//   কিমি, ружи, _yếu_, yrem_, 
   {{0x32080429,0x38a00561,0x7c84014b,0x7eb0007f}},	//   _mmay_, gòr_, _муре, pòpò, 
   {{0x645c29ac,0x320801b9,0x7a3829ad,0x248c0205}},	//   ísim, _lmay_, ríta, vrem_, 
   {{0x7a3829ae,0xa3d40a8a,0x2cb429af,0x3208035a}},	//   síta, हास_, şadı_, _omay_, 
   {{0x248c29b0,0xff1806a9,0x76c40131,0x3208022e}},	//   trem_, יקות_, زغىل, _nmay_, 
   {{0x38a0067c,0x248c29b1,0xa3b801f7,0xd1e80b82}},	//   còr_, urem_, هادر_, ቆናት_, 
   {{0x320829b2,0x06ac00cc,0x4cb000fe,0x4dcc00fe}},	//   _amay_, কিবি, ীমপু, ৰসিং, 
   {{0x85b80014,0xefe40092,0x248c29b3,0x00000000}},	//   _لاشس_, _ማሟያ_, srem_, --, 
   {{0x248c29b4,0xa06829b5,0x682c007b,0x00000000}},	//   prem_, лама_, rúdu, --, 
   {{0x10a00121,0x00000000,0x00000000,0x00000000}},	//   пиян, --, --, --, 
   {{0xe29829b6,0x657800b0,0x320814dc,0x6458020c}},	//   _бак_, _hewh, _emay_, _iuwi, 
   {{0x670c02f8,0x22940411,0x657802b5,0x645829b7}},	//   िपटक_, _العس, _kewh, _huwi, 
   {{0x645829b8,0x62800728,0x2fc000a2,0x61f4010e}},	//   _kuwi, mslo, _eahg_, _ulyl, 
   {{0x645802ce,0x5ba829b9,0x146027dd,0x657800b0}},	// [2520] _juwi, лкам_, _kọọp, _mewh, 
   {{0x62800656,0x645829ba,0x181400dc,0xdca40131}},	//   oslo, _muwi, _तदेव_, _һами, 
   {{0x645829bb,0x628029bc,0x320814dc,0xcf540302}},	//   _luwi, nslo, _ymay_, _לבית_, 
   {{0x657829bd,0x5ca41142,0xdca429be,0x628001f5}},	//   _newh, _лимб, _лами, islo, 
   {{0x645802d1,0xdb0c0158,0x00000000,0x00000000}},	//   _nuwi, _labø, --, --, 
   {{0x5bf40050,0xb3ac00cc,0xa2981954,0xacb000d1}},	//   _آسا, _কোনজ, _ጉባኤን_, _تەكب, 
   {{0x46640962,0x38a0067c,0xdb0c0ca8,0x7584072d}},	//   брым_, sòr_, _àkày, قیام, 
   {{0x645829bf,0x62802611,0x38a00ba1,0x8e78010f}},	//   _buwi, dslo, pòr_, אנקה, 
   {{0x64580066,0xf3f804a9,0x7a3801ed,0x628029c0}},	//   _cuwi, иниш_, líto, eslo, 
   {{0x27e40198,0x645829c1,0x628029c2,0x6d400115}},	//   _goln_, _duwi, fslo, _ŝlak, 
   {{0x02a029c3,0x56f001c0,0x7a3801d3,0x00000000}},	//   прям, _хүйс, níto, --, 
   {{0x6458016b,0xd7600244,0x00000000,0x00000000}},	//   _fuwi, _بۆژی, --, --, 
   {{0x64580309,0xfbc800cd,0x00000000,0x00000000}},	//   _guwi, रयाम, --, --, 
   {{0xb4e40490,0xb4d40490,0x1368036b,0x7a3801ed}},	//   नही_, हमी_, _ёшли_, kíto, 
   {{0xa3d40abd,0x320801b9,0x7a3801d3,0x64580112}},	//   हार_, _tmay_, jíto, _zuwi, 
   {{0x320829c4,0x64580098,0x7a3829c5,0x705829c6}},	//   _umay_, _yuwi, díto, _каир_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2530] --, --, --, --, 
   {{0xf1a429c7,0x9f480165,0x00000000,0x00000000}},	//   ग्रन, ñjãb_, --, --, 
   {{0x4ea400f7,0xd1d800b7,0xb4e429c8,0x7a3800e5}},	//   _урпа, _ፖስት_, नहु_, gíto, 
   {{0x2bf40073,0x645c03b2,0x80a402f2,0x00000000}},	//   _इतकं_, ísik, _بمین, --, 
   {{0x657829c9,0x27e409a8,0x7a380118,0xc98401b9}},	//   _rewh, _poln_, mítl, _қуви, 
   {{0x628029ca,0x60c00086,0xd8840014,0x7a3803b2}},	//   yslo, _âome, تھِن_, lítl, 
   {{0x645829cb,0xe73829cc,0xa91c05be,0x65780374}},	//   _suwi, шек_, _idžm, _pewh, 
   {{0x645829cd,0xb8d400db,0x00000000,0x00000000}},	//   _puwi, تتۅش, --, --, 
   {{0xa3d412eb,0x645803f0,0xf1dc00dc,0x6aa4045a}},	//   हाल_, _quwi, यानन, lthf, 
   {{0x628029ce,0xe284010a,0x00000000,0x00000000}},	//   tslo, олои, --, --, 
   {{0x657829cf,0x6aa429d0,0x00000000,0x00000000}},	//   _tewh, nthf, --, --, 
   {{0x645829d1,0x6aa429d2,0x95e40137,0xe50800ec}},	//   _tuwi, ithf, _ويلۇ, _پيتو_, 
   {{0x316c29d3,0x64580280,0x62800250,0xb5940139}},	//   ñeza_, _uuwi, sslo, _хичш, 
   {{0x628029d4,0x7a3800e5,0x7d0001a8,0x00000000}},	//   pslo, yíto, _ýmsi, --, 
   {{0xe29829d5,0x21a409a5,0xddc40353,0x4f380014}},	//   _тай_, _дийм, обви, لتِھ_, 
   {{0xdee4013e,0x99640356,0x5d680117,0x7a3801d3}},	//   боҳи, _mîţu_, риам_, víto, 
   {{0x10a00046,0x9c6401d5,0x8ff800ec,0x00000000}},	// [2540] _жиын, زهاو, _چرپر_, --, 
   {{0x602400d6,0xb0682824,0x682c0306,0x7a3801d3}},	//   _єдна, _اصيل_, zúdr, títo, 
   {{0x99840244,0x00000000,0x00000000,0x00000000}},	//   قلاو, --, --, --, 
   {{0xa3d429d6,0xf1dc146b,0x7a3801ed,0x75fc00e5}},	//   हाँ_, यायन, ríto, _kéze, 
   {{0x7a3800dd,0xb8f400b8,0x41ac29d7,0x48e000f5}},	//   síto, _maṇī, ट्यस, моцв, 
   {{0x7a3829d8,0x75fc01d3,0x5de002dd,0xdcf400cd}},	//   píto, _méze, _ﺇﻗﻠﻴ, cayā, 
   {{0x75fc01d3,0xf1dc29d9,0xe1c8012d,0x7a3800e5}},	//   _léze, यामन, ियाघ, lítm, 
   {{0x95c8026a,0xc9c4004b,0xf8b8010b,0xdcf4010e}},	//   рука_, _وژنه_, _гөк_, ngyį, 
   {{0xa3d429da,0x75fc00dd,0xb1140154,0xe5e800a2}},	//   हां_, _néze, _সর্ব_, _ýaýç, 
   {{0xaf7002d3,0xf1dc0118,0x00000000,0x00000000}},	//   እታትና_, याभन, --, --, 
   {{0x321805da,0x5fdc0404,0x0bb4011a,0xc80400f1}},	//   tnsy_, मानल, חלים_, _بښنه_, 
   {{0xf4840133,0xb9e40092,0x00000000,0x00000000}},	//   _فاتی, _የአ_, --, --, 
   {{0xf48403b6,0x4fc41d4a,0x201c01a9,0x00000000}},	//   _راشی, осва, еti_, --, 
   {{0x75fc01c7,0xd2580114,0xa3d400cd,0x00000000}},	//   _déze, _кци_, हाः_, --, 
   {{0x15ec00c5,0xfb0000e2,0x7a3803b2,0x00000000}},	//   _जवार_, _šūnu_, títl, --, 
   {{0xc33005e1,0x8d741d37,0xc48029db,0x02f802e4}},	//   _קוק_, تاسا, _эләк, _כלומ, 
   {{0x301429dc,0x75fc01d3,0x76b0015b,0x00000000}},	// [2550] _ндир, _kézb, চটিএ, --, 
   {{0x0f800014,0x91a40950,0xebc4013d,0x00000000}},	//   _زیرُ, ट्रै, чәмн, --, 
   {{0xca300952,0xe5ac00d8,0xdd90004b,0x657c022e}},	//   _ﺯﻭﺭ_, _àaçã, _ګوټ_, аshl, 
   {{0x6aa429dd,0x7a3801ed,0x67fc01e1,0x6fd801f9}},	//   rthf, lítj, _mèje, मावू, 
   {{0x6e2c29de,0xb86401e2,0x00000000,0x00000000}},	//   moab, واوو, --, --, 
   {{0x6e2c0770,0x5fdc0490,0x97c0023a,0x7a3801d3}},	//   loab, मायल, ейше, nítj, 
   {{0x98f40131,0x00000000,0x00000000,0x00000000}},	//   يغۇچ, --, --, --, 
   {{0x6e2c00b5,0x3e3c0092,0x00000000,0x00000000}},	//   noab, _በእነር, --, --, 
   {{0xa5080276,0x7a3801d3,0x00000000,0x00000000}},	//   сепа_, kítj, --, --, 
   {{0xe298283c,0x240801d5,0x9984012d,0x6e2c0051}},	//   бао_, ённи_, cioł_, hoab, 
   {{0x6e2c025a,0x232829df,0x82400023,0xb8f400b8}},	//   koab, сони_, _ባህልታ, _paṇī, 
   {{0xd24c168d,0x6e2c0099,0xe928031c,0x75fc0129}},	//   ێنی_, joab, _སྙོབ_, _péze, 
   {{0x6e2c0311,0x00000000,0x00000000,0x00000000}},	//   doab, --, --, --, 
   {{0x50a00131,0x75fc0129,0x6fd41cb8,0x7a3800e5}},	//   رەپل, _véze, місц, gítj, 
   {{0xdee402bf,0xd00413dc,0xdb0c02d2,0xf8b802c3}},	//   чови, чере_, _babý, _इन्प, 
   {{0x1d080228,0x6e2c017a,0x00000000,0x00000000}},	//   беби_, goab, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2560] --, --, --, --, 
   {{0x92e0015b,0xa13429e0,0x04a400ef,0x00000000}},	//   _নেয়_, _ورکش, _čīlē_, --, 
   {{0x7a3800dd,0x6e2c016b,0x9cc829e1,0xab68007b}},	//   sítm, boab, шыңа_, تحقق_, 
   {{0x98a40588,0x7a3802fb,0xc8c41b87,0x5f7404f2}},	//   зиде, mítk, लिंट, _باکر, 
   {{0x0d80010b,0x00000000,0x00000000,0x00000000}},	//   _ялян, --, --, --, 
   {{0x26081533,0x7d0429e2,0xdb0c29e3,0x00000000}},	//   ़ोसी_, mzis, _zabý, --, 
   {{0x8c4029e4,0xb4d40882,0xa3d407af,0x3ce0003a}},	//   _чере, हम्_, हाई_, lxiv_, 
   {{0xd4980faa,0xceb0025f,0xd5b80166,0xcb34008f}},	//   бро_, גיה_, сск_, _זאלי_, 
   {{0x7d0429e5,0x38c81060,0xdb0c29e6,0x7a3800e5}},	//   nzis, _بازی_, _labü, yítj, 
   {{0x6e2c056a,0xd32429e7,0x7d000008,0x27e00e78}},	//   zoab, зьми, _ýmsu, öhnt_, 
   {{0x316c056a,0xf194010a,0x7a3829e8,0x00000000}},	//   ñezo_, минь, vítj, --, 
   {{0x7d0429e9,0xbbc829ea,0x7a380122,0xa3d401ad}},	//   kzis, रयुक, dítk, हाउ_, 
   {{0x6e2c05da,0x7d0429eb,0x7a3801d3,0x112801f0}},	//   voab, jzis, títj, сюни_, 
   {{0x7d0429ec,0x1ae003f4,0xdb0c29ed,0xd36c00db}},	//   dzis, _গেছে_, _babü, _حۇد_, 
   {{0x6e2c0175,0xc4380302,0x7a3801d3,0x926829ee}},	//   toab, _התגי, rítj, _урла_, 
   {{0xdb0c29ef,0x7a3801ed,0x7d04014b,0xacf800cf}},	//   _dabü, sítj, fzis, онбу_, 
   {{0x7d0429f0,0x6e2c0072,0x7a3800e5,0x00000000}},	// [2570] gzis, roab, pítj, --, 
   {{0xf044144b,0x6e2c01e0,0x7a3819db,0xdb0c012d}},	//   _تعبی, soab, líth, _nabó, 
   {{0x2d580323,0x7d0429f1,0x7a380118,0x00000000}},	//   _минь_, azis, cítk, --, 
   {{0xcbc4004b,0x7d040311,0x6dc000f7,0x4238010f}},	//   _ډېرو_, bzis, _جۅرۅ, ִנגל_, 
   {{0x31680472,0x00000000,0x00000000,0x00000000}},	//   _mfaz_, --, --, --, 
   {{0xfe7029f2,0x3e5800b0,0x2ca801e6,0x7a380332}},	//   _جدی_, _hōta_, mtad_, híth, 
   {{0x2ca829f3,0xf4040183,0x7a3801d3,0x00000000}},	//   ltad_, ৰকাৰ_, kíth, --, 
   {{0xba7400f2,0x06ac00eb,0x00000000,0x00000000}},	//   _سافت, কিলি, --, --, 
   {{0x2ca829f4,0xf77004d3,0x7a3829f5,0xdb4c0014}},	//   ntad_, _ڕان_, zítk, _مێے_, 
   {{0xdb0c0077,0x00000000,0x00000000,0x00000000}},	//   _gabó, --, --, --, 
   {{0x7d0429f6,0x39640423,0xf67401c6,0xe71805af}},	//   zzis, _åsså_, _згхэ, _بيات_, 
   {{0x2ca829f7,0xa91c00f3,0xe5e404fb,0xdb0c29f8}},	//   ktad_, _adži, _تزئی, _kabò, 
   {{0xdb0c007f,0xb5fc0327,0x3ce00393,0xb33c0003}},	//   _jabò, _suġg, xxiv_, egħd, 
   {{0xdb0c0005,0xffa401c0,0x7a3802f0,0x25ac007c}},	//   _xabó, элгү, títk, lfel_, 
   {{0xdb0c004e,0x2ca807de,0x7d04009a,0x2bd00210}},	//   _labò, etad_, wzis, _सफ़ा, 
   {{0x3ce001d4,0x2ca80267,0xa3d40254,0x75fc0129}},	//   txiv_, ftad_, हाक_, _kéza, 
   {{0x2ca829f9,0xf1a8088c,0x25ac29fa,0x7a38012c}},	// [2580] gtad_, _رايه_, ifel_, sítk, 
   {{0x7d0429fb,0xabc40032,0x25ac007f,0x7a3829fc}},	//   rzis, науҙ, hfel_, míti, 
   {{0x75fc06af,0x2ca8030a,0x25ac01e3,0x7d0401d3}},	//   _léza, atad_, kfel_, szis, 
   {{0x25ac0196,0x2ca803f9,0x61e429fd,0xdb0c29fe}},	//   jfel_, btad_, njkl, _sabó, 
   {{0x7a3829ff,0xdb0c2a00,0x25ac2a01,0xb33c025c}},	//   níti, _cabò, dfel_, mgħe, 
   {{0xdb0c033b,0x25ac0e78,0xb33c025c,0x00000000}},	//   _dabò, efel_, lgħe, --, 
   {{0x25ac2a02,0x7a3800e5,0x00000000,0x00000000}},	//   ffel_, yíth, --, --, 
   {{0xfec00729,0xd90c2a03,0xd94400ee,0x68ec0240}},	//   _উপাধ, _پیت_, _жеби, ëndë, 
   {{0xdb0c067c,0x316801a9,0x7a3801d3,0xf1dc00cd}},	//   _tabó, _rfaz_, víth, यासन, 
   {{0x79802a04,0xa3d42a05,0xefcc02d3,0xa91c0010}},	//   _hemw, हाग_, _ኣሎዎ_, _sežg, 
   {{0x2ca82a06,0x79800810,0xa2840032,0x6b800254}},	//   ztad_, _kemw, нъяһ, _õlge, 
   {{0xdef80201,0x7a380077,0x2bd401ad,0xdbd40037}},	//   _ዋርካ_, fíti, _डोना, _hääb, 
   {{0xc5f00375,0x79802a07,0xdbd40037,0x2ca80175}},	//   _בדף_, _memw, _kääb, xtad_, 
   {{0x79802a08,0xbbc82a09,0x7a3801ed,0xdbd40037}},	//   _lemw, रयोक, síth, _jääb, 
   {{0x79802a0a,0x7f5800d1,0xeff00023,0xb33c025c}},	//   _oemw, дарс_, _ግናይ_, fgħe, 
   {{0x2ca82a0b,0x798005b8,0x7a3800ae,0xc32c0116}},	//   ttad_, _nemw, bíti, _خەپ_, 
   {{0x7a3802fb,0x2ca80165,0x823401c8,0x7dc401d5}},	// [2590] cíti, utad_, _جروا, ъёрд, 
   {{0x2ca82a0c,0xbf640014,0x417401ec,0xa91c2a0d}},	//   rtad_, _لگٲو, _كاۋس, _ježe, 
   {{0x2ca82a0e,0x25ac2a0f,0x798004ba,0xdb0c067c}},	//   stad_, yfel_, _bemw, _sabò, 
   {{0xdb240502,0xa91c2a10,0x00000000,0x00000000}},	//   رونی, _leže, --, --, 
   {{0x6d5c2a11,0x798002e2,0x25ac01e6,0x00000000}},	//   _igsa, _demw, vfel_, --, 
   {{0x61e400f3,0x00000000,0x00000000,0x00000000}},	//   zjkl, --, --, --, 
   {{0x25ac0262,0x49b80502,0x79800083,0x3b540022}},	//   tfel_, _وارد_, _femw, _акрр, 
   {{0xba4405f5,0x64982a12,0x7980015d,0x25ac0112}},	//   _ахуй, птор_, _gemw, ufel_, 
   {{0x25ac2a13,0xa91c0030,0x7a381709,0x6d5c0334}},	//   rfel_, _beže, xíti, _mgsa, 
   {{0xc7442a14,0x79800810,0x69002a15,0x69c801c4}},	//   _قضاي, _zemw, ızdı, _haee, 
   {{0x79801813,0xa91c2a16,0x69c80098,0x25ac03fa}},	//   _yemw, _deže, _kaee, pfel_, 
   {{0x6d5c2a17,0x60002a18,0xddc40055,0xdbd4010e}},	//   _ngsa, _môme, _dikś, _täçb, 
   {{0x69c82a19,0xb33c0327,0x00000000,0x00000000}},	//   _maee, ggħb, --, --, 
   {{0xdfd02a1a,0x6d5c010b,0x94242374,0xd7e00073}},	//   ديس_, _agsa, _كونۇ, पायच, 
   {{0x6e280122,0x9f5807c5,0x247c007f,0x7a3801d3}},	//   čebn, _impü_, lňm_, síti, 
   {{0x69c82a1b,0xdb1001ed,0xa3c40073,0x7a3801d3}},	//   _naee, _ígér, _उघड_, lítv, 
   {{0x1c442a1c,0x79802a1d,0x6b840ac5,0x247c0100}},	// [25a0] енам, _remw, fahg, nňm_, 
   {{0x26c42a1e,0x7980006f,0x75fc01ed,0x41ac27a6}},	//   _oslo_, _semw, _nézn, ट्रस, 
   {{0x8f9800c8,0x7980006f,0xdbd40254,0x3eb00356}},	//   _ציטי, _pemw, _rääb, întă_, 
   {{0x5fdc0316,0x79800477,0x69c80042,0x60000129}},	//   मावल, _qemw, _caee, _dôme, 
   {{0x6b842a1f,0x0d202a20,0x26c42a21,0x69c80363}},	//   bahg, _бүтү, _aslo_, _daee, 
   {{0x79802a22,0x6d5c01a6,0xf778031c,0x00000000}},	//   _wemw, _zgsa, _roħs_, --, 
   {{0x69c80093,0x7bdc2a23,0x8f98008f,0xa91c2230}},	//   _faee, _inru, ליסי, _reže, 
   {{0xd4982a24,0x69c80142,0xa91c2a25,0x247c02e2}},	//   про_, _gaee, _seže, fňm_, 
   {{0x57b002dd,0x8a140677,0x00000000,0x00000000}},	//   _бұлт, _נחמו_, --, --, 
   {{0xba0802d3,0x93a4013e,0x656800d0,0x73d808ca}},	//   _ፋሕ_, хшид, aceh, фдор_, 
   {{0x645c2a26,0xa3d42a27,0x69d401f9,0x00000000}},	//   ísir, हाज_, णाची, --, 
   {{0xa91c00de,0x00000000,0x00000000,0x00000000}},	//   _edžu, --, --, --, 
   {{0x7bdc2a28,0x25a82a29,0xa91c0010,0x6b84020c}},	//   _onru, _آدمي_, _teže, yahg, 
   {{0xa91c2a2a,0x00000000,0x00000000,0x00000000}},	//   _idžt, --, --, --, 
   {{0x6f0800df,0x00000000,0x00000000,0x00000000}},	//   ĝeco, --, --, --, 
   {{0x7bdc2a2b,0x6f0801e4,0xa91c01ef,0x00000000}},	//   _anru, ŝeco, _ježc, --, 
   {{0x69c80165,0xa3d40073,0x6b84047e,0xa91c00de}},	// [25b0] _raee, हाच_, tahg, _mežc, 
   {{0x69c804fb,0x2ef4014b,0x0fe0004e,0xfe7000e5}},	//   _saee, _азор, _сөмү, شدہ_, 
   {{0x69c80156,0x6b842a2c,0xdec000c7,0x247c0100}},	//   _paee, rahg, _кәто, zňm_, 
   {{0x6d5c2a2d,0xfa34009f,0x7ac4035b,0x3d0c012d}},	//   _ugsa, هرند, ысуе, _ठेके_, 
   {{0xfd440153,0x00000000,0x00000000,0x00000000}},	//   _бэрн, --, --, --, 
   {{0xea9400aa,0xe7382a2e,0x69c8003e,0x6b840334}},	//   _لارښ, мел_, _waee, qahg, 
   {{0x69c80618,0xa91c00d0,0x97800214,0x247c007f}},	//   _taee, _bežc, شینه, wňm_, 
   {{0xa91c187e,0x660c01f1,0x75fc0129,0xdb0c01e1}},	//   _vežb, ďako, _dézo, _ìjám, 
   {{0x65682a2f,0xf1a400bc,0xa8540117,0x00000000}},	//   rceh, ग्छन, _акач, --, 
   {{0x7a1c007f,0x39142a30,0x00000000,0x00000000}},	//   včti, _смур, --, --, 
   {{0xf1dc2413,0x74e801c6,0xf770007b,0x7a3800e5}},	//   यांन, ддөг_, _طال_, rítv, 
   {{0xddc40115,0x7a382a31,0x21680108,0x00000000}},	//   _bikŝ, sítv, ьими_, --, 
   {{0x64a42a32,0x7a382a33,0x66e800c0,0x00000000}},	//   _рала, pítv, _dūkš, --, 
   {{0xe2982a34,0xdb1c007c,0x630000db,0x00000000}},	//   _жак_, ldpå, _ەۋگە, --, 
   {{0x8e800276,0x765c06af,0xfbe01c15,0x9e5800d8}},	//   игре, _éryt, नासम, драф_, 
   {{0xe1f00133,0xdb1c007c,0xdd90007b,0xf1d8012d}},	//   _خست_, ndpå, شوط_, _बोपन, 
   {{0xd24c0f13,0x4d602a35,0xb33c0003,0xa008007b}},	// [25c0] _بني_, ркув, mgħa, _يقبل_, 
   {{0xd00c035d,0xb33c003d,0x38c800e5,0x00000000}},	//   _ولي_, lgħa, ہاتی_, --, 
   {{0xdb0c2a36,0x682c0419,0x00000000,0x00000000}},	//   _labö, búdz, --, --, 
   {{0xb33c038f,0x38c807d6,0x60d42a37,0x7a1c00b0}},	//   ngħa, فاتی_, _krym, kōte, 
   {{0xc2140134,0x00000000,0x00000000,0x00000000}},	//   _mmɔ_, --, --, --, 
   {{0x7bdc2a38,0x3dc00036,0x88b007d6,0x7a380413}},	//   _unru, leiw_, شیمچ, vítu, 
   {{0xcac42a39,0x86c02a3a,0x6b80000d,0x47c800f1}},	//   _игре_, ليون, _õlga, بانۍ_, 
   {{0xfbe0012c,0x60d4015d,0x39580023,0xdb1c0254}},	//   नावम, _orym, ገሳውያ, rdpä, 
   {{0xd4042a3b,0xb33c031c,0x16940014,0x00000000}},	//   вяни, dgħa, رٕکھ_, --, 
   {{0x9f5800db,0xc770001f,0x3dc001c7,0xb33c031c}},	//   _alpí_, ከናወኑ_, heiw_, egħa, 
   {{0xdddc0374,0x60d42a3c,0xb33c031c,0x7a3801d3}},	//   _aupō, _arym, fgħa, sítu, 
   {{0x75fc01ed,0x60d42a3d,0xf1dc00bc,0xd4980798}},	//   _kézm, _brym, याइन, _жрк_, 
   {{0x60d4015d,0x99840165,0x7a3801d3,0x00000000}},	//   _crym, lloų_, líts, --, 
   {{0x2cb80109,0x60d42a3e,0xc9500375,0x00000000}},	//   _rpsd_, _drym, ימר_, --, 
   {{0x0d640801,0x60d40393,0xa91c00e2,0x682c002d}},	//   възм, _erym, _meža, túdz, 
   {{0xa91c2a3f,0x60d4044e,0x50640fc0,0x1ee801d3}},	//   _leža, _frym, _итоа, روقی_, 
   {{0xebd82a40,0x32180170,0x60d42a41,0xdb1c020c}},	// [25d0] ндаш_, misy_, _grym, lepè, 
   {{0x32182a42,0xa91c2a43,0x7a3800e5,0x00000000}},	//   lisy_, _neža, kíts, --, 
   {{0x67fc02e2,0x7b642a44,0x60d81a14,0x0ac402e8}},	//   _sèjo, ртуе, ātme, ъщам, 
   {{0xf9902a45,0x32182a46,0x5ef8011a,0xb4f40243}},	//   قبه_, nisy_, _נפרד, ेनाय_, 
   {{0xa91c2a47,0xf8a80133,0x00000000,0x00000000}},	//   _beža, ندوه_, --, --, 
   {{0x68442a48,0x00000000,0x00000000,0x00000000}},	//   ынла, --, --, --, 
   {{0x7a382a49,0x2d880093,0x32180109,0xc984084c}},	//   gíts, oaae_, kisy_, _аузи, 
   {{0x85541547,0xdb1c2a4a,0x28080024,0x00000000}},	//   نیار_, depè, _šunį_, --, 
   {{0x89342a4b,0xe4582a4c,0x88800345,0x00000000}},	//   _شعرا, нжи_, _ئیتن, --, 
   {{0x60d40023,0x7a3802d2,0x00000000,0x00000000}},	//   _rrym, bíts, --, --, 
   {{0x2d880053,0x7a382a4d,0xb33c003d,0x32182a4e}},	//   kaae_, mítr, tgħa, fisy_, 
   {{0x75242a4f,0x60d4012d,0x00000000,0x00000000}},	//   _žize, _prym, --, --, 
   {{0xf3c8036b,0xb33c0135,0x657c0162,0xd654011a}},	//   ربیه_, rgħa, ðshu, _עינת_, 
   {{0xf1dc0316,0x60d405e4,0x23282a50,0xca6801ec}},	//   याउन, _vrym, _поли_, лiмi, 
   {{0x442405b1,0x53980375,0x00000000,0x00000000}},	//   _ijn_, _טיסו, --, --, 
   {{0xdb0c2776,0x60000086,0x60d4040c,0x998402f0}},	//   _mabô, _dôma, _trym, choň_, 
   {{0x248c2a51,0x9c242a52,0x1da8102f,0x3dc00036}},	// [25e0] nsem_, гдад, ङ्गत, reiw_, 
   {{0x248c05d5,0xef180107,0xdb1c036e,0x90c00108}},	//   isem_, хмӣ_, qepë, _убье, 
   {{0x9ea801c0,0xa91c2a53,0x44240051,0xd7e001f9}},	//   _явна_, _reža, _mjn_, पासच, 
   {{0x248c2a54,0x533400c8,0xa91c0219,0x442401a4}},	//   ksem_, אנען_, _seža, _ljn_, 
   {{0x248c012c,0x4424010f,0xca682a55,0xa91c00ef}},	//   jsem_, _ojn_, лiгi, _peža, 
   {{0x442402f0,0xdce40153,0xe10400fe,0x32180205}},	//   _njn_, _sekė, _উশাহ_, zisy_, 
   {{0x248c2a56,0xa91c0153,0xcf90010f,0x00000000}},	//   esem_, _veža, זטו_, --, 
   {{0x442400c8,0xd9540014,0x34940588,0xdb1c0124}},	//   _ajn_, _منزخ, ааир, jepé, 
   {{0xa91c2a57,0x7a382a58,0x32182a59,0x248c01ed}},	//   _teža, síts, visy_, gsem_, 
   {{0x44240356,0x07a0030d,0xc7a00108,0x7a3800e5}},	//   _cjn_, _гафн, _гифк, píts, 
   {{0x32182a5a,0x2d88013f,0x8c3402e4,0xdce40153}},	//   tisy_, yaae_, רטיס_, _tekė, 
   {{0xf0e804a9,0xd7e01fbc,0x44240327,0x600005da}},	//   پىسى_, पावच, _ejn_, _rôma, 
   {{0x44f40814,0x321803d1,0xdb1c0066,0x25d80451}},	//   _مروج_, risy_, sepè, _جهنگ_, 
   {{0x76402a5b,0x32180170,0x4424058a,0xcbbc0eac}},	//   llmy, sisy_, _gjn_, _উচ্ছ, 
   {{0x32182a5c,0xa91c2a5d,0x68f8033f,0xb33c031c}},	//   pisy_, _nežn, zywd, mgħo, 
   {{0x51842a5e,0x44240010,0xb33c0003,0x00000000}},	//   _сука, _zjn_, lgħo, --, 
   {{0xada400d1,0x64b801e4,0xfbe00073,0x00000000}},	// [25f0] лаңл, sʈiv, नांम, --, 
   {{0xddc40598,0xa91c01a2,0x44240208,0x60000051}},	//   _tikş, _bežn, _xjn_, _hômn, 
   {{0x8fd00184,0xe97405e6,0xbc381df2,0x80cc009e}},	//   _кәңә, لهاد, اسقا_, ামণ্, 
   {{0x248c2a5f,0xd3642a60,0xa91c09a8,0xc9840137}},	//   ysem_, _ژه_, _dežn, اشاي, 
   {{0x06ac00fe,0x417c011a,0x00000000,0x00000000}},	//   কিছি, תנדב, --, --, 
   {{0x248c151c,0xa6941614,0x6aa000cc,0xdb1c01ed}},	//   vsem_, ариј, _ålfo, zepé, 
   {{0x7a380174,0x248c012d,0x75fc00e5,0x00000000}},	//   rítr, wsem_, _kézh, --, 
   {{0xf9882a61,0x7a3803b2,0xdde40064,0x9b400244}},	//   _منفي_, sítr, _įpūs, _بۆمو, 
   {{0xdb0c006a,0x74f805f5,0xa5082a62,0xa91c0171}},	//   _wabô, гээс_, тепа_, _iežo, 
   {{0x248c2a63,0x00000000,0x00000000,0x00000000}},	//   rsem_, --, --, --, 
   {{0x248c2a64,0x23282a65,0x7a1c0093,0xdb1c020c}},	//   ssem_, тони_, lōta, tepé, 
   {{0xa0682a66,0x248c00c5,0x75fc01d3,0xf1dc2a67}},	//   кама_, psem_, _nézh, यागन, 
   {{0xa91c00e2,0x44240208,0xdb1c01d3,0xb33c031c}},	//   _mežo, _tjn_, repé, bgħo, 
   {{0x2bd405b7,0x6608038f,0x5f042a68,0x53a0009d}},	//   _डोला, lhek, азга, _дашб, 
   {{0x53980302,0x7a1c02b5,0x00000000,0x00000000}},	//   _סיקו, hōta, --, --, 
   {{0x3e580053,0xa91c2a69,0x7a1c02b5,0x21740166}},	//   _kōti_, _režn, kōta, _тукр, 
   {{0x1b7400db,0x64402a6a,0x5ca40120,0x5ba8001b}},	// [2600] لداج, olli, ризб, ккам_, 
   {{0x64402a6b,0x01e800cc,0x1e8400f0,0x4c800116}},	//   nlli, _পতিদ, _клом, юлув, 
   {{0x66082a6c,0xdee410ae,0x4f98011a,0xa91c00d7}},	//   khek, _тони, _בביצ, _bežo, 
   {{0x60000109,0x66082a6d,0x6b541b04,0x64402a6e}},	//   _kômo, jhek, стух, hlli, 
   {{0x3e5802b5,0x66082a6f,0x64402a70,0x8d600212}},	//   _nōti_, dhek, klli, _євре, 
   {{0x64402a71,0x481002bf,0x7a1c007f,0x660801f4}},	//   jlli, оміс, tčts, ehek, 
   {{0x07a00063,0xec2801ee,0x00000000,0x00000000}},	//   цајн, _серҙ_, --, --, 
   {{0x6440049b,0xd5b82a72,0x75fc01ed,0x00000000}},	//   elli, тск_, _kézi, --, 
   {{0x75fc007f,0x186802bf,0x53e400c7,0x46100014}},	//   _jézi, _рази_, ацна, زوٝر, 
   {{0x6440089c,0x75fc06af,0xa91c0432,0x00000000}},	//   glli, _mézi, _mežl, --, 
   {{0x66082a73,0xa3c4033f,0x95c80417,0x75fc2a74}},	//   bhek, उज़_, _аула_, _lézi, 
   {{0x66082a75,0x64402a76,0x2c7c0248,0xb33c031c}},	//   chek, alli, _jádò_, sgħo, 
   {{0x64401529,0x60000120,0xa91c0118,0x9424004e}},	//   blli, _cômo, _nežl, _кмде, 
   {{0x32740092,0x0314029e,0xb33c0003,0xb6100150}},	//   ለሥልጣ, اتیت_, qgħo, _ﺷﻰ_, 
   {{0x60d80a28,0xcfa82a77,0x00000000,0x00000000}},	//   ātma, _یادم_, --, --, 
   {{0x75fc2a78,0x8d7413d0,0xd1b80150,0x29100213}},	//   _bézi, شارا, _شاعا_, _əzab_, 
   {{0xfd8801d5,0x00000000,0x00000000,0x00000000}},	// [2610] рёси_, --, --, --, 
   {{0x75fc0129,0x66082a79,0x9e7400ec,0x6a140116}},	//   _dézi, zhek, _گهٽت, әмду, 
   {{0x2c7c0241,0xa91c00f3,0x660801f4,0x00000000}},	//   _bádò_, _pežo, yhek, --, 
   {{0x66080007,0x7a1c02b1,0x6e040014,0x6440036e}},	//   xhek, tōta, _چِھن, zlli, 
   {{0x64402a7a,0x66081682,0xd7e00490,0x48a80daf}},	//   ylli, vhek, पांच, ттем_, 
   {{0xa7a80228,0x7a1c00b0,0x66080374,0xe728009d}},	//   укка_, rōta, whek, лолд_, 
   {{0xa91c0e3c,0x3e5802e2,0x644001bf,0x00000000}},	//   _težo, _sōti_, vlli, --, 
   {{0x3e5804fe,0x67fc00e4,0x64402a7b,0x660800b5}},	//   _pōti_, _mèji, wlli, uhek, 
   {{0x66082a7c,0x64402a7d,0xa91c2a7e,0x795807a5}},	//   rhek, tlli, _kežm, _витр_, 
   {{0x64402a7f,0xf7702a80,0xe51c00af,0x00000000}},	//   ulli, _قام_, _बइठि_, --, 
   {{0x6608124c,0x64402a81,0x6e3c005c,0xd76400f2}},	//   phek, rlli, _oksb, _انمی, 
   {{0x64402a82,0x66080184,0x3e5800b0,0x00000000}},	//   slli, qhek, _tōti_, --, 
   {{0x2bfc0073,0x6aa40112,0x36341291,0x0fe00073}},	//   _एवढं_, huhf, _برلس, खांश_, 
   {{0x75fc003e,0x6fac0490,0x644003f0,0xa91c00c0}},	//   _rézi, _जाणू, qlli, _nežm, 
   {{0xf1d802e5,0xd24c0133,0x00000000,0x00000000}},	//   _बोवन, بنێ_, --, --, 
   {{0x200803a2,0x75fc00d8,0x5f042a83,0x00000000}},	//   shbi_, _pézi, азҳа, --, 
   {{0x6aa00158,0x00000000,0x00000000,0x00000000}},	// [2620] _ålfj, --, --, --, 
   {{0x61f42a84,0x6e3c2a85,0x7fa40244,0x00000000}},	//   _hoyl, _eksb, _بلدۆ, --, 
   {{0x20182a86,0x34c41b61,0xa91c0219,0x61f42a87}},	//   _impi_, _वन्द, _dežm, _koyl, 
   {{0x61f4006c,0x9b942a88,0x994800c6,0x186801b9}},	//   _joyl, _گلست, هلال_, гади_, 
   {{0x61f41368,0x00000000,0x00000000,0x00000000}},	//   _moyl, --, --, --, 
   {{0xdb1c29ae,0x61f42a89,0xda640451,0x00000000}},	//   lepí, _loyl, _هاري, --, 
   {{0x66182a8a,0x61f400ad,0xdb0c023a,0x8c1805d0}},	//   _bmwk, _ooyl, äjän, _עולי, 
   {{0xe9702a8b,0x38c8085b,0x00000000,0x00000000}},	//   _قۇمد, _پاری_, --, --, 
   {{0x8cd82a8c,0x2018002e,0x04900023,0xf98801e2}},	//   नियो, _ompi_, _መቐይሮ_, _منځي_, 
   {{0xdbd40139,0x75fc01d3,0x00000000,0x00000000}},	//   _näüb, _nézv, --, --, 
   {{0x61f4129f,0x969400db,0x00000000,0x00000000}},	//   _boyl, _ыраш, --, --, 
   {{0x2018094a,0xd4a400ee,0x00000000,0x00000000}},	//   _ampi_, _гидй, --, --, 
   {{0x61f42a8d,0x33940006,0x6fac1431,0x324401e0}},	//   _doyl, _далё, _जादू, йеүг, 
   {{0x6e3c05b1,0x61f400ad,0x33580276,0x7a1c02b5}},	//   _sksb, _eoyl, _калэ_, kōto, 
   {{0xa3d40316,0x61f40076,0xa3c42a8e,0x00000000}},	//   ाएर_, _foyl, उजर_, --, 
   {{0x201806cc,0xa91c09a8,0x61f4010e,0x00000000}},	//   _empi_, _dežj, _goyl, --, 
   {{0x32080875,0x8d8408ca,0x00000000,0x00000000}},	// [2630] _ilay_, _қунд, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3208017a,0x61f4022e,0xc278010f,0x2b18166d}},	//   _klay_, _yoyl, ָרדי, _येशु_, 
   {{0x80cc00bd,0x00000000,0x00000000,0x00000000}},	//   ামর্, --, --, --, 
   {{0x32082a8f,0xdb0c0139,0x75fc01ed,0x5fdc0073}},	//   _mlay_, _abbä, _jézu, _फोडल, 
   {{0x32082a90,0x00000000,0x00000000,0x00000000}},	//   _llay_, --, --, --, 
   {{0x32082a91,0xf1c800cd,0x00000000,0x00000000}},	//   _olay_, िजान, --, --, 
   {{0xf1d81533,0xa91c2a92,0xd6cc06f6,0x49b82a93}},	//   _बोलन, _ježk, ئقي_, _حاسد_, 
   {{0xdb1c084c,0xc7a812e1,0x24082a94,0xd8a40150}},	//   cepâ, _مدال_, инии_, _ۇشەۋ, 
   {{0x61f42a95,0x32082a96,0xc6a40a5b,0x00000000}},	//   _soyl, _alay_, _грди, --, 
   {{0x0e100882,0x320800db,0x61f4036a,0xca2800d1}},	//   ṣṭav, _blay_, _poyl, ﺧﺸﺎ_, 
   {{0x20182a1f,0x61f4047e,0xa91c0010,0x32082a97}},	//   _smpi_, _qoyl, _nežk, _clay_, 
   {{0xa0682a98,0x61f40363,0xb5c80214,0xf1c8012d}},	//   рага_, _voyl, _دونم_, िज़न, 
   {{0xdee401c0,0xdef8010b,0x32082a99,0x61f4002e}},	//   ооги, ңың_, _elay_, _woyl, 
   {{0x32082a9a,0x8d70001f,0x61f42a9b,0xa91c00d0}},	//   _flay_, _ቤታቸው_, _toyl, _bežk, 
   {{0x7e7c0194,0x32080175,0xdbd00139,0x00000000}},	//   rprp, _glay_, _küçs, --, 
   {{0xdb1c0599,0x769001e1,0x92300137,0xb33c031c}},	// [2640] repí, _kóyá, _تىيش, egħh, 
   {{0x2d9801e4,0xa91c09a8,0x20182a9c,0x320801a9}},	//   _edse_, _težj, _umpi_, _zlay_, 
   {{0x2ca4000f,0x5ac82a9d,0x769001e1,0x32082a9e}},	//   _ālde_, рлем_, _móyá, _ylay_, 
   {{0xa3d4006d,0xa2b000cd,0x00000000,0x00000000}},	//   ाएँ_, _अमन्, --, --, 
   {{0x7a1c0093,0x2bd41d94,0x48702a9f,0x00000000}},	//   sōto, _डोका, ودوس, --, 
   {{0x5c0403e6,0xdb1c00d8,0xb7d800ec,0x5b34009d}},	//   _بکرێ_, repâ, صوبا_, _дэбу, 
   {{0x6fac1533,0x46640eed,0x5fb007c1,0x2b901dd8}},	//   _जासू, орым_, _जानल, _سینس, 
   {{0x3e580093,0x75fc01ed,0x27300372,0xb5fc025c}},	//   _tōtu_, _nézt, رۉنس, _kuġi, 
   {{0xa3d4006d,0x69dc04d4,0x39c0007f,0x5fc80846}},	//   ाएं_, _ósea, _včsč_, ाजाल, 
   {{0x96b80064,0xb33c025c,0x00000000,0x00000000}},	//   _вуду_, lgħi, --, --, 
   {{0x32082aa0,0x3944062c,0x167001d5,0x00000000}},	//   _play_, _hyms_, _ўқир, --, 
   {{0x80ac2aa1,0x225000a2,0xf1e800cc,0xb33c025c}},	//   _जमशे, _chyk_, খস্হ_, ngħi, 
   {{0x769001e1,0xdbd00790,0x3c3401f4,0x00000000}},	//   _fóyá, _güçs, sävy_, --, 
   {{0xb5bc03d4,0x00000000,0x00000000,0x00000000}},	//   _অফিচ, --, --, --, 
   {{0x28d0000b,0x657807ea,0x320806d9,0x43700131}},	//   _दैनि, _éché, _tlay_, _تۇپر, 
   {{0x9f5c0296,0xb5fc0327,0x21340129,0x320802d0}},	//   ótá_, _buġi, éché_, _ulay_, 
   {{0x316800dd,0xb33c031c,0xa9a400ee,0x00000000}},	// [2650] _igaz_, dgħi, җилд, --, 
   {{0x5fb00490,0x24880023,0x6f8000cf,0xdfd00451}},	//   _जायल, _çame_, _سۇرۅ, _ٻيٽ_, 
   {{0xa91c2aa2,0x39441368,0x00000000,0x00000000}},	//   _težk, _ayms_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x88c40e26,0xa0240166,0xd5e00051,0xa91c0064}},	//   تتال, _unöç, _giỏ, _keži, 
   {{0xa91c2aa3,0x2ca82aa4,0xc7b8059f,0x00000000}},	//   _ježi, muad_, рёд_, --, 
   {{0xd7ec2aa5,0xf420015b,0xa91c2aa6,0xb33c0135}},	//   اكى_, নকার_, _meži, bgħi, 
   {{0xe298052f,0x316807ab,0xa91c2aa7,0xe81c29d9}},	//   ҙам_, _ngaz_, _leži, _भगवा_, 
   {{0x753401c6,0x39442aa8,0xe5240212,0xdb1c00d7}},	//   дээх, _gyms_, ядип, mepá, 
   {{0xa91c2aa9,0x24080107,0xe7b4134e,0x00000000}},	//   _neži, снои_, _आउटप, --, 
   {{0xf7702aaa,0x21682097,0x4900012c,0xe2980063}},	//   _شال_, йини_, वनको_, љам_, 
   {{0x06c02aab,0x00000000,0x00000000,0x00000000}},	//   ্মদি, --, --, --, 
   {{0xa91c2aac,0x2ab42aad,0xdb0c0036,0x6384013d}},	//   _beži, håb_, _pcbë, _егла, 
   {{0x600005da,0x25ac2aae,0x3168005a,0x9e642aaf}},	//   _kômi, lgel_, _egaz_, كارن, 
   {{0x25ac0368,0xd378011a,0xdb1c03df,0x00000000}},	//   ogel_, _פרקט, kepá, --, 
   {{0x75fc020c,0xc1040116,0x2ab4005c,0x12f8011a}},	//   _hézr, _жүмл, dåb_, _להצב, 
   {{0x25ac04cc,0x60240276,0x75fc00e5,0x00000000}},	// [2660] igel_, _ндиа, _kézr, --, 
   {{0x394401e3,0x25ac0112,0xabc400fb,0x00000000}},	//   _ryms_, hgel_, мауҙ, --, 
   {{0x39442ab0,0x25ac00a2,0x00000000,0x00000000}},	//   _syms_, kgel_, --, --, 
   {{0x38c8130e,0x25ac00f3,0xdb1c00db,0xa6e000eb}},	//   قاتی_, jgel_, repà, বহাট, 
   {{0x25ac2ab1,0xb0d4012d,0xd7f80166,0x00000000}},	//   dgel_, दिएग, йук_, --, 
   {{0x25ac2ab2,0xe8e800f1,0xb33c025c,0x69dc032e}},	//   egel_, ترمو_, sgħi, _ósen, 
   {{0x60000798,0x995400d4,0x00000000,0x00000000}},	//   _cômi, хiви_, --, --, 
   {{0x25ac2ab3,0x3944039a,0xf9c42ab4,0x95c80116}},	//   ggel_, _tyms_, _تحسی, сука_, 
   {{0x05700873,0x55042081,0x00000000,0x00000000}},	//   رايد, ячка, --, --, 
   {{0xc1b80323,0xd7742ab5,0x25ac00d8,0x00000000}},	//   үлэх_, _رائع, agel_, --, 
   {{0x2d9c033f,0x99840156,0x877800d9,0x00000000}},	//   ówek_, nnoů_, _האבי, --, 
   {{0xb9e4044e,0xa91c0427,0xb0b027c6,0x00000000}},	//   _ከአ_, _seži, _जमदग, --, 
   {{0x4638008f,0x482000db,0xa91c00ef,0x93240633}},	//   _פעדע, _تىەق, _peži, ترکن, 
   {{0x86280020,0x5fb001f9,0x00000000,0x00000000}},	//   _ድህነት, _जाणल, --, --, 
   {{0xa91c2ab6,0x316804cc,0xdb1c2ab7,0xb27401d5}},	//   _veži, _tgaz_, lepæ, _ўлиш, 
   {{0xc2780375,0xdddc0118,0x00000000,0x00000000}},	//   _פרחי, _kupř, --, --, 
   {{0x42381203,0xa91c04b9,0x62940306,0x417400f1}},	// [2670] _מנהל_, _teži, ázov, _ښایس, 
   {{0xaf5000c7,0xfd7401c6,0x92bc00cc,0x00000000}},	//   _аҽгә, _үлээ, ঁটী_, --, 
   {{0x3fd801c6,0xdb1c2ab8,0x25ac007c,0x00000000}},	//   _эмээ_, tepá, ygel_, --, 
   {{0x0dc80a2c,0xf4d8009e,0x2ca80165,0x2ab4005c}},	//   _ابدى_, _তথৈব, puad_, råb_, 
   {{0x89340491,0x6e2c2ab9,0xb33c025c,0xdb1c00e4}},	//   أعضا, mnab, mgħu, repá, 
   {{0xd3642aba,0xb5fc0327,0xfeb80bce,0xb33c031c}},	//   _له_, _muġu, _بایت_, lgħu, 
   {{0x25ac0c86,0xc17402a8,0x69dc04d4,0xd6cc2abb}},	//   tgel_, _haɗe_, _óseo, لقو_, 
   {{0x6e2c2abc,0xc17402a8,0x25ac09b6,0x60000798}},	//   nnab, _kaɗe_, ugel_, _vômi, 
   {{0x69d80134,0x6e2c1351,0x00000000,0x00000000}},	//   mdwe, inab, --, --, 
   {{0x25ac2abd,0x93c00311,0x6e2c0112,0x00000000}},	//   sgel_, _ţăra, hnab, --, 
   {{0x6e2c2abe,0xe51c00c5,0x69d8015d,0x00000000}},	//   knab, _बेरि_, odwe, --, 
   {{0x85b02abf,0x00000000,0x00000000,0x00000000}},	//   _чәкч, --, --, --, 
   {{0x6e2c00a9,0xdd900014,0x00000000,0x00000000}},	//   dnab, ێوس_, --, --, 
   {{0x6284062c,0x6e2c2ac0,0xb33c0327,0x201c007f}},	//   _çhoo, enab, egħu, òti_, 
   {{0x2cc80327,0xb33c031c,0xa91c0171,0x6e2c08a5}},	//   ངསའབ, fgħu, _iežu, fnab, 
   {{0x6e2c2ac1,0xdb1c2ac2,0xa3d42ac3,0x53300798}},	//   gnab, lepç, ाएक_, _шејт, 
   {{0x62800cf9,0x20542ac4,0x69d82ac5,0xad6400ae}},	// [2680] lplo, _отор, ddwe, فاكه, 
   {{0xc17402a8,0xa91c00f3,0x6e2c2ac6,0x26c404e6}},	//   _daɗe_, _ježu, anab, _oplo_, 
   {{0x62800100,0x69d80d27,0xb33c0003,0xa91c0171}},	//   nplo, fdwe, bgħu, _mežu, 
   {{0x98a42ac7,0x69d80d27,0x6e2c1eba,0x9f58036e}},	//   диде, gdwe, cnab, _lopë_, 
   {{0xed340323,0x8d742ac8,0x2fc00ac5,0x00000000}},	//   _зэрэ, _تاپا, _ybhg_, --, 
   {{0x7d0401f0,0x8cd81157,0x628001f5,0xa91c0064}},	//   myis, निरो, kplo, _nežu, 
   {{0x7d042ac9,0x2488031c,0xddc400b8,0xe79401d9}},	//   lyis, _ħama_, _nikū, راوک, 
   {{0xd4980b64,0xceb0025f,0x35b40019,0x7d040472}},	//   оро_, דיה_, хбир, oyis, 
   {{0x7d042aca,0x26c40037,0x62802acb,0xeb140248}},	//   nyis, _eplo_, eplo, _òòré_, 
   {{0x9f580023,0xdb1c072b,0x63c401ef,0x00000000}},	//   _copë_, repæ, _čuní, --, 
   {{0x6e2c2acc,0x0ca8033f,0xb6c40cdd,0x8b040153}},	//   ynab, _चम्म, _чөлд, _tręš, 
   {{0x75d40046,0x20c803f3,0x7d04049b,0xd4680724}},	//   _سيتا, िबंध, kyis, _диде_, 
   {{0xdb1c25c6,0x826403e6,0x62800af9,0x92bc015b}},	//   lepä, کهێن, aplo, ঁটে_, 
   {{0x76402acd,0xdb1c06ed,0xc17403f9,0x7d04006f}},	//   lomy, cepç, _raɗe_, dyis, 
   {{0xb8e00135,0x7d041418,0x15f01b76,0x629401d3}},	//   _ཀཱ_, eyis, _आचार_, ázot, 
   {{0xc3300302,0x76402ace,0x6e2c08cd,0x7d041459}},	//   _שוק_, nomy, unab, fyis, 
   {{0xdb1c000d,0xb33c025c,0x00000000,0x00000000}},	// [2690] hepä, rgħu, --, --, 
   {{0x76402acf,0x6b8401ab,0xdb1c0108,0xaed4014b}},	//   homy, ubhg, kepä, _зоош, 
   {{0x76402ad0,0x7d042ad1,0x62540051,0xe7d81df0}},	//   komy, ayis, báod, _योगप, 
   {{0x7640068f,0x7d042ad2,0xdb1c2ad3,0x69d80ea0}},	//   jomy, byis, depä, udwe, 
   {{0x69d82ad4,0x99942ad5,0x69dc2ad6,0xf1c00882}},	//   rdwe, رپور_, _ósem, ष्यन, 
   {{0xca740075,0x9f580100,0x00000000,0x00000000}},	//   _يازغ, _bopè_, --, --, 
   {{0x76400472,0xdb1c2ad7,0x00000000,0x00000000}},	//   fomy, gepä, --, --, 
   {{0x76402ad8,0xf1c000dc,0x6280007c,0x00000000}},	//   gomy, ष्मन, vplo, --, 
   {{0x48742ad9,0x64c400f1,0x62800076,0x00000000}},	//   _آدرس, ريدل, wplo, --, 
   {{0x62802ad4,0xdb1c0037,0x00000000,0x00000000}},	//   tplo, bepä, --, --, 
   {{0x04ec015b,0xa91c0064,0x764000a2,0x00000000}},	//   টনের_, _vežu, bomy, --, 
   {{0xa0a42ada,0x62802adb,0x76402adc,0x7d040a55}},	//   намд, rplo, comy, yyis, 
   {{0x60640116,0x42cc00eb,0x00000000,0x00000000}},	//   нҗиң_, িমেশ, --, --, 
   {{0x660811c0,0xdb1c05ac,0x7a1c00b0,0x7d04005b}},	//   lkek, lepå, rōti, vyis, 
   {{0x6d5800ee,0xcee42add,0x660803ac,0xa2e401fe}},	//   ýwan, ндре_, okek, _чойд, 
   {{0x64402ade,0x7d042adf,0x66082ae0,0x60000798}},	//   loli, tyis, nkek, _rômu, 
   {{0x64402ae1,0x7d040099,0xa91c00e2,0x2240007c}},	// [26a0] ooli, uyis, _mežs, mokk_, 
   {{0x22402ae2,0x9f842ae3,0x7d042ae4,0x60d42ae5}},	//   lokk_, _ягод, ryis, _isym, 
   {{0x7640014b,0x6440004e,0x7d042ae6,0xcfb4011a}},	//   yomy, ioli, syis, _אליי_, 
   {{0x7d040230,0x9f5800e8,0xddc400c7,0xdb1c00c5}},	//   pyis, _nopé_, _oikũ, vepä, 
   {{0x64402ae7,0x76400223,0x6c74035b,0x8f50036b}},	//   koli, vomy, _аусх, _لنیش, 
   {{0x64402ae8,0x66082ae9,0x764004ba,0xf8c0000d}},	//   joli, ekek, womy, _एहीप, 
   {{0x64402aea,0xddc400e4,0x3ce00099,0x76402aeb}},	//   doli, _aikũ, lviv_, tomy, 
   {{0xdb1c00af,0x9f58004a,0x6440003a,0xcb640006}},	//   repä, _copé_, eoli, _часе_, 
   {{0xdddc00da,0xf8d41715,0xdb1c1073,0x9f580129}},	//   _atpū, _धनिय, sepä, _dopé_, 
   {{0x64402aec,0x76402aed,0xa91c0153,0x660801f4}},	//   goli, somy, _vežt, akek, 
   {{0x03c00046,0x325401f0,0xc794211f,0xb33c0327}},	//   усым, квор, _سپنا_, egħr, 
   {{0x66082aee,0xf26c001f,0x68440022,0xa2b00b02}},	//   ckek, _አደገኛ_, _знӡа, _अमर्, 
   {{0x629402fb,0x00000000,0x00000000,0x00000000}},	//   ázor, --, --, --, 
   {{0x20d42aef,0x31780354,0xefb001d3,0xdec80023}},	//   džić_, scsz_, جیدگ, ሽጥን_, 
   {{0x2240031c,0x00000000,0x00000000,0x00000000}},	//   bokk_, --, --, --, 
   {{0xb11400aa,0x931001ed,0xa91c0171,0x00000000}},	//   _لوبغ, _لوڈش, _mežr, --, 
   {{0x313400d1,0xebd8010b,0x30140006,0x0ba42af0}},	// [26b0] _шеир, мдаш_, _адпр, ешем, 
   {{0x6608005a,0x09b800cd,0x00000000,0x00000000}},	//   zkek, ोज्य, --, --, 
   {{0xc1740c09,0xe9d80034,0xcf24143e,0x69dc1427}},	//   _haɗa_, _paź_, _سردي, _ósek, 
   {{0x64402af1,0xc1740b45,0xe80804aa,0x7a1c02b5}},	//   zoli, _kaɗa_, वस्थ_, kōtu, 
   {{0xfbb81d4c,0x2d882af2,0x64402af3,0x79840309}},	//   ীয়ত, mbae_, yoli, ñiwa, 
   {{0x2ca82af4,0x78a42af5,0x64402af6,0x2d880393}},	//   mrad_, áiva, xoli, lbae_, 
   {{0x66082af7,0x7c342af8,0x2ca80112,0x00000000}},	//   tkek, _серх, lrad_, --, 
   {{0x64402af9,0x78a40989,0x2ca814d0,0x2d8801f9}},	//   woli, šiva, orad_, nbae_, 
   {{0x2ca82afa,0x64402afb,0xc1740b45,0xdb1c0fac}},	//   nrad_, toli, _naɗa_, repå, 
   {{0x2ca82afc,0x64400142,0xa2e42afd,0x6fac01f9}},	//   irad_, uoli, воод, _जागू, 
   {{0x2ca80122,0x22402afe,0x00000000,0x00000000}},	//   hrad_, tokk_, --, --, 
   {{0xe5e404fb,0x2ca82aff,0x64402b00,0xe8080118}},	//   _جزئی, krad_, soli, वसका_, 
   {{0x22402b01,0x65c00220,0xc0c800f1,0x00000000}},	//   rokk_, _бұқа, رېده_, --, 
   {{0xc17402a8,0x64402b02,0x2ca82b03,0x2d88003a}},	//   _daɗa_, qoli, drad_, ebae_, 
   {{0x53980375,0x2ca82b04,0x00000000,0x00000000}},	//   _חיצו, erad_, --, --, 
   {{0xc1740b45,0x60d405da,0xfb540131,0x2ca8002f}},	//   _faɗa_, _tsym, ۇراھ, frad_, 
   {{0x2ca82220,0xdc680323,0xdc282073,0x3d28158b}},	// [26c0] grad_, даад_, وسطه_, رتری_, 
   {{0x3ce02b05,0x20d401a6,0x38bc00e4,0x2c6c013a}},	//   rviv_, ržić_, hárã_, _sždc_, 
   {{0x3f982b06,0x2ca82b07,0xdcb00131,0x00000000}},	//   maru_, arad_, _ھىس_, --, 
   {{0x3f982b08,0x3c942b09,0x2ca82b0a,0xc1740b45}},	//   laru_, _میرز, brad_, _yaɗa_, 
   {{0xd7f80276,0x2ca80100,0xa91c013a,0xd838013d}},	//   дуй_, crad_, _sežr, мэк_, 
   {{0x3f982b0b,0x1cc00135,0x8ca401ad,0x00000000}},	//   naru_, _གྱར_, _चितो, --, 
   {{0x69640075,0x7bdc2b0c,0xc95000c7,0x10680150}},	//   ندۇق, _iaru, лтәы, _ﺳﻮﺯﯨ, 
   {{0x7bdc2b0d,0x3f982b0e,0x75b801d5,0x1dc000bc}},	//   _haru, haru_, хлиё_, शभित, 
   {{0x3f982b0f,0x7bdc2b10,0xb8f400b8,0x04b401d3}},	//   karu_, _karu, _kaṭī, نھوں_, 
   {{0x3a240280,0x3f982b11,0x2d880369,0x2c6c00d0}},	//   _hmmp_, jaru_, zbae_, _kľdr_, 
   {{0x7bdc2b12,0x3f982b13,0x81dc09bd,0x04400120}},	//   _maru, daru_, ঠান_, реќн, 
   {{0x7bdc2b14,0x7a1c00b0,0x2ca82b15,0x46a40118}},	//   _laru, pōtu, yrad_, _गितह, 
   {{0x3f982b16,0x9f440208,0x10681870,0x00000000}},	//   faru_, _đoá_, _ﺳﻮﺭﯨ, --, 
   {{0x2ca805c7,0xc950011a,0xae0415bf,0x7b14022e}},	//   vrad_, שמש_, گورى, 智ull, 
   {{0x92f02b17,0x386c0175,0xcdd80114,0x7f940108}},	//   _түнх, _midr_, мња_, расх, 
   {{0x2ca82b18,0x7bdc2b19,0xc0d00023,0x00000000}},	//   trad_, _aaru, ብሶም_, --, 
   {{0x3f982b1a,0xcfa41638,0x2d8816b8,0xcfd82b1b}},	// [26d0] baru_, _ишни, rbae_, দাবন, 
   {{0x7bdc2b1c,0x3f982b1d,0x2ca82b1e,0x8b6400db}},	//   _caru, caru_, rrad_, ناام, 
   {{0xba742b1f,0x3a74035b,0x00000000,0x00000000}},	//   لانت, алхр, --, --, 
   {{0xc330025f,0x7bdc1730,0xa6842b20,0x2ca82b21}},	//   בוע_, _earu, қлид, prad_, 
   {{0x7bdc2b22,0x60000109,0x24580129,0x2ca806be}},	//   _faru, _kômp, lème_, qrad_, 
   {{0x7bdc2b23,0xfe7000aa,0xdddc2b24,0x00000000}},	//   _garu, _ددی_, _kupş, --, 
   {{0x8cd8089a,0x600005da,0xa44400d1,0x5690033a}},	//   निको, _mômp, һнид, бајт, 
   {{0x7bdc2b25,0x2458004a,0x00000000,0x00000000}},	//   _zaru, ième_, --, --, 
   {{0x3f982b26,0x29182b27,0x245806af,0x6b9401a9}},	//   yaru_, _åsa_, hème_, _kezg, 
   {{0x7bdc0a81,0x6b940989,0x87d417b9,0x3f980054}},	//   _xaru, _jezg, _جغرا, xaru_, 
   {{0x3f982b28,0xa228188b,0x6b942b29,0x33f42b2a}},	//   varu_, ежна_, _mezg, рчыс, 
   {{0x3f982b2b,0x6b940165,0x245806af,0x990001e4}},	//   waru_, _lezg, dème_, ŝĉen, 
   {{0x3f982b2c,0x00000000,0x00000000,0x00000000}},	//   taru_, --, --, --, 
   {{0x2a6c1a80,0xe0442b2d,0xe2982b2e,0x2fd00139}},	//   _lieb_, унги, _зак_, gezg_, 
   {{0x3f982b2f,0x7bdc2b30,0x31c8015b,0x24580129}},	//   raru_, _raru, ষয়শ, gème_, 
   {{0x3f982b31,0x55000248,0x00000000,0x00000000}},	//   saru_, _ìṣèl, --, --, 
   {{0x3f982b32,0x6b942b33,0x1be80364,0xb8f40055}},	// [26e0] paru_, _bezg, ндаи_, _maṣī, 
   {{0x3f982b34,0x4d601d11,0xd0f40375,0x6cc401e0}},	//   qaru_, скув, _עמית_, рифҡ, 
   {{0x7bdc2b35,0x2a6c0003,0x6b940311,0xf1c001bc}},	//   _varu, _bieb_, _dezg, ष्वन, 
   {{0x7bdc2b36,0x386c2b37,0x6b9402d0,0x00000000}},	//   _waru, _sidr_, _eezg, --, 
   {{0x2a6c2b38,0x98480b2c,0x00000000,0x00000000}},	//   _dieb_, няка_, --, --, 
   {{0xd6d82b39,0x6b942b3a,0x78a40e3c,0x7bdc2b3b}},	//   ети_, _gezg, šivo, _uaru, 
   {{0x5fb0069f,0xfd5001fb,0x00000000,0x00000000}},	//   _जाईल, _nghẹ, --, --, 
   {{0xa5bc0006,0x1cc0031c,0xdb1c005c,0x00000000}},	//   liųj, _གྱོ_, depø, --, 
   {{0x1cd0031c,0x75fc01d3,0x991402d5,0xe8480137}},	//   _ེགས_, _kézz, _сьві, رجۇن_, 
   {{0x7a1c01af,0x63ac0c09,0xa5bc0024,0xb4e4012c}},	//   pōts, _ɓang, niųj, _पछी_, 
   {{0x2a6c0369,0x245806af,0x8c180375,0xdb1c005c}},	//   _yieb_, xème_, גויי, gepø, 
   {{0x54e42b3c,0xa2d42b3d,0x00000000,0x00000000}},	//   _مستق, _बनर्, --, --, 
   {{0x93e4036b,0x934401ec,0x0fe000db,0x73c4190b}},	//   _бўйл, _өнде, бөнү, _кәне, 
   {{0xc1740198,0x75fc01ed,0x1cc00327,0x94700014}},	//   _faɗo_, _nézz, _གྱེ_, _پۯگا, 
   {{0x6e942b3e,0xdbd00112,0xdddc0166,0x6b942b3f}},	//   рибу, _süßs, _qupş, _rezg, 
   {{0x6b942b40,0x2458004a,0xf1a800bc,0xdfd80107}},	//   _sezg, rème_, _कयिन, нъӣ_, 
   {{0x8234085d,0x2458026c,0x2a6c002f,0x00000000}},	// [26f0] _دروا, sème_, _rieb_, --, 
   {{0xbd682b41,0x798003ac,0x2a6c0112,0xa5bc0064}},	//   урсе_, _afmw, _sieb_, giųj, 
   {{0x7c842b42,0x4f68013d,0x18780023,0xf1a80210}},	//   _ҳусе, _яшим_, _ብሃገር_, _कयान, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6b942b43,0xa9340c9e,0x7c842b44,0xa5bc00c0}},	//   _tezg, шедш, _гусе, biųj, 
   {{0xec240131,0x6b9402d0,0x2c6c00c0,0xbb300092}},	//   _ئىسپ, _uezg, _iždo_, ጥቷቸዋ, 
   {{0xe5700597,0xc98407d6,0x81dc0183,0xbb58030d}},	//   يطة_, _бузи, ঠাত_, _барх_, 
   {{0x1b1c015b,0x0ba80137,0xaa582b45,0x8c34014b}},	//   _বুকে_, _تاڭى_, _рибу_, _роҳӣ_, 
   {{0x69c80cad,0x88800214,0x00000000,0x00000000}},	//   _ibee, _ایتن, --, --, 
   {{0x68e82b46,0x291c01c8,0x135402d3,0x00000000}},	//   _ired, mzwa_, _ግሉጽነ, --, 
   {{0x68e80156,0x291c009f,0x3914247f,0xa5d40798}},	//   _hred, lzwa_, _پوەز, _вжеш, 
   {{0x37041955,0x973000f2,0x00000000,0x00000000}},	//   _учув, _بکها, --, --, 
   {{0x291c2b47,0x69c82b48,0xa5080063,0x00000000}},	//   nzwa_, _mbee, _јела_, --, 
   {{0x68e80066,0xa34801a9,0x00000000,0x00000000}},	//   _mred, _изла_, --, --, 
   {{0x9e640058,0x92f42b49,0x69c82b4a,0x1d9401b9}},	//   لارن, _نفوذ_, _obee, ираё, 
   {{0x44242b4b,0x68e82b4c,0x1cc0031c,0xdca4023a}},	//   _hmn_, _ored, _གྱུ_, иаби, 
   {{0x9c242b4d,0x75fc04cc,0x68e801e1,0x00000000}},	// [2700] адад, _pézz, _nred, --, 
   {{0x291c2b4e,0x69c82b4f,0x9f580589,0x51580375}},	//   dzwa_, _abee, _copã_, _בכפו, 
   {{0xf778003d,0x69c81418,0x68e82b50,0x44242b51}},	//   _naħa_, _bbee, _ared, _mmn_, 
   {{0x69c82b52,0xa5bc0006,0x44242b53,0xdd9000ec}},	//   _cbee, siųj, _lmn_, _ڏوھ_, 
   {{0x80c409bd,0x69c80036,0x7e642b54,0x44242b55}},	//   শিক্, _dbee, mmip, _omn_, 
   {{0x68e803b4,0x44242b56,0x69c80a49,0x99842b57}},	//   _dred, _nmn_, _ebee, dnoť_, 
   {{0x68e82b58,0xd6d80432,0x3e7c012c,0x8f98008f}},	//   _ered, ттл_, _jít_, דיצי, 
   {{0x69c82b59,0x3e7c0316,0x442405da,0x35f42b5a}},	//   _gbee, _mít_, _amn_, спир, 
   {{0x3e7c2b5b,0x93882773,0x998405c7,0xc47401b9}},	//   _lít_, ксна_, lioů_, لینچ_, 
   {{0x5fb0069f,0x44242b5c,0xb804002b,0xe8e805af}},	//   _जागल, _cmn_, _daṃś, _حرفو_, 
   {{0x68e82b5d,0x44242b5e,0x3e7c2b5f,0x9984030a}},	//   _zred, _dmn_, _nít_, nioů_, 
   {{0x741403e6,0x00000000,0x00000000,0x00000000}},	//   _گوتا, --, --, --, 
   {{0x44242b60,0x99840165,0x7e6401ef,0x00000000}},	//   _fmn_, hioů_, dmip, --, 
   {{0x44240073,0x74140b43,0x33840014,0x3e7c001e}},	//   _gmn_, _دوتا, _الغٲ, _bít_, 
   {{0xb4b40032,0x02a02b61,0x2488031c,0x34940139}},	//   _тиҙә, _дрым, _ħami_, _таһр, 
   {{0x51840598,0xef180034,0x99840165,0xad242b62}},	//   _тука, ąż_, dioů_, مىزى, 
   {{0x2458067c,0x82640214,0xbd7800d4,0x00000000}},	// [2710] lèma_, _بهين, рбує_, --, 
   {{0x46a40307,0x7e64000d,0xf4b400cc,0x00000000}},	//   _गिलह, amip, _জৈৱব, --, 
   {{0x7e6400f2,0x2458180f,0xdeb001ec,0x00000000}},	//   bmip, nèma_, _нұры, --, 
   {{0x68e82b63,0x7e640066,0x684400d1,0xcc840133}},	//   _pred, cmip, әнка, _نۆره_, 
   {{0xb9c40597,0x2d982b64,0x291c01c8,0x68e8031c}},	//   تقني, _iese_, uzwa_, _qred, 
   {{0x1cc02b65,0x6e2c2b66,0x68e82b67,0x2d982b68}},	//   _གྱི_, liab, _vred, _hese_, 
   {{0x2d982b69,0x44242b6a,0xb8040882,0x3e7c004d}},	//   _kese_, _rmn_, _saṃś, _xít_, 
   {{0x68e82b6b,0x2d982b6c,0xdb1400c6,0x69c80117}},	//   _tred, _jese_, _ócái, _ubee, 
   {{0x2d982b6d,0x46d4012c,0x00000000,0x00000000}},	//   _mese_, _भैरह, --, --, 
   {{0x6e2c2b6e,0x2d982b6f,0xdb1c0022,0xddc40064}},	//   hiab, _lese_, hepý, _mikš, 
   {{0x7e640309,0xddc400de,0x360400e5,0x00000000}},	//   ymip, _likš, _ڈولف, --, 
   {{0x2d982b70,0x3e7c004d,0x36041291,0x00000000}},	//   _nese_, _rít_, _وولف, --, 
   {{0x44242b71,0xddc408ad,0xd6540375,0x998405c7}},	//   _tmn_, _nikš, _פינת_, zioů_, 
   {{0x2d982b72,0x3e7c2b73,0x3ec80c60,0x00000000}},	//   _aese_, _pít_, ақом_, --, 
   {{0x2d982b74,0xddc402d5,0x53980375,0x6e2c2b75}},	//   _bese_, _aikš, _עסקא, fiab, 
   {{0x2d982b76,0x6e2c2b77,0x3e7c2b78,0x1b1c015b}},	//   _cese_, giab, _vít_, _বুঝে_, 
   {{0x2d982b79,0x7e642b7a,0x5ca400cf,0xdbc801c6}},	// [2720] _dese_, rmip, сизб, лгад_, 
   {{0x2d982b7b,0x78a402fb,0x3e7c2b7c,0x7e64000d}},	//   _eese_, šivk, _tít_, smip, 
   {{0x6e2c2b7d,0xd24c2b7e,0x2d982b7f,0x00000000}},	//   biab, _زنی_, _fese_, --, 
   {{0x2d980660,0x4f840014,0x99840156,0x6e8000e4}},	//   _gese_, _پایہ, rioů_, _ẽngú, 
   {{0xdb1c00dd,0x91b80375,0x2ba4078a,0xed340de7}},	//   lepü, רמני, गृहा, _дэрэ, 
   {{0x818c01ec,0xaab800db,0x00000000,0x00000000}},	//   _ﺒﻘﻴﺔ_, ادەر_, --, --, 
   {{0x2d982b80,0x07a00f14,0x8b200353,0x00000000}},	//   _yese_, чајн, _едре, --, 
   {{0xd5b82b81,0xc6d02002,0xda780032,0x00000000}},	//   уск_, ستىت, _аяҡ_, --, 
   {{0xb78801af,0x00000000,0x00000000,0x00000000}},	//   _кәйе_, --, --, --, 
   {{0x6e2c2b82,0xdb24031c,0x2874010b,0x07a00124}},	//   ziab, _རྟོཌ_, _фытр, _наун, 
   {{0x95c82b83,0x4bf80bd9,0x75a40022,0x33580276}},	//   _була_, אליס, _дылҧ, ранэ_, 
   {{0xdb1c2b84,0x6e2c0077,0x24580ba1,0x00000000}},	//   lepó, xiab, rèma_, --, 
   {{0x2d982b85,0xc0f4001f,0xfbd807f7,0x80b0012d}},	//   _rese_, _ሌተር_, ड़ाम, अंगे, 
   {{0x2d982b86,0xddc40171,0x00000000,0x00000000}},	//   _sese_, _rikš, --, --, 
   {{0x2d982b87,0x87780bd4,0xdb1c0124,0xddc400ef}},	//   _pese_, ראלי, tepý, _sikš, 
   {{0x1cc02b88,0x31340220,0x3eac0efe,0x2d980240}},	//   _གྱང_, _мейр, ádta_, _qese_, 
   {{0x2d982b89,0x6e2c2b8a,0x62840363,0x645c0024}},	// [2730] _vese_, riab, _çhor, įsiv, 
   {{0x2d982b8b,0x6e2c0441,0xfbd004fb,0xaed401c0}},	//   _wese_, siab, فتم_, _доош, 
   {{0x2d982b8c,0x6d40033f,0x6e2c003a,0xe3bc00fe}},	//   _tese_, _ślad, piab, _অসমব, 
   {{0x75200354,0x2d980421,0xddc4005f,0x00000000}},	//   kzmz, _uese_, _tikš, --, 
   {{0x6e3c01a4,0xebc42b8d,0x7d242b8e,0x00000000}},	//   _ijsb, _мәжн, _ефре, --, 
   {{0x6d5c005f,0xac18001b,0x765c0055,0x00000000}},	//   _izsa, _тогу_, _īrya, --, 
   {{0x39c00618,0x7b54007b,0x00000000,0x00000000}},	//   _sōsō_, _فضفض, --, --, 
   {{0xa91c00ef,0x00000000,0x00000000,0x00000000}},	//   _mežz, --, --, --, 
   {{0xe3b02b8f,0xab28010b,0x00000000,0x00000000}},	//   ورد_, _соңа_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc17403f9,0xe2981b88,0x04280023,0xf7702b90}},	//   _haɗi_, јам_, _ብወገን, _كام_, 
   {{0x21680116,0x00000000,0x00000000,0x00000000}},	//   иини_, --, --, --, 
   {{0x6d5c00b0,0xd24c004b,0x79840113,0x00000000}},	//   _nzsa, ځنۍ_, ñiwi, --, 
   {{0x248c016b,0x6e3c036e,0x04642b91,0x00000000}},	//   mpem_, _ajsb, _утем, --, 
   {{0x248c2b92,0x6d5c2b93,0x00000000,0x00000000}},	//   lpem_, _azsa, --, --, 
   {{0x248c003a,0x78a416a3,0xdb1c01d3,0xdd8801f0}},	//   opem_, šivi, repü, рбад_, 
   {{0x248c05b1,0x61f40857,0x6e20017a,0xdb1c0254}},	// [2740] npem_, _inyl, ëlba, sepü, 
   {{0x61e42b94,0xc17403f9,0x248c004e,0x00000000}},	//   ldkl, _naɗi_, ipem_, --, 
   {{0x6d5c02d0,0x6b500023,0x00000000,0x00000000}},	//   _ezsa, _ንጢሞቴ, --, --, 
   {{0xd9d00e8e,0x27e802a8,0x3eb82b95,0x988002d3}},	//   بەرگ, ɓani_, murt_, _ክሰርሑ_, 
   {{0xc1740198,0x97e00588,0x3eb82b96,0xd7f80022}},	//   _baɗi_, мҩаҧ, lurt_, иук_, 
   {{0xacd804ac,0x3940025c,0xd7e400db,0x00000000}},	//   _פֿרי, ħis_, زوعۇ_, --, 
   {{0xc1740b45,0x795403e6,0x4aa4014b,0x87d400db}},	//   _daɗi_, _کێشا, _мкрн_, زبوس_, 
   {{0xd9442b97,0x61e401f5,0x043c0023,0x00000000}},	//   _деби, jdkl, _ይብጻሕ, --, 
   {{0xc1740b45,0x3eb82b98,0x236801e4,0xdb1c0022}},	//   _faɗi_, hurt_, _ĝaja_, pepó, 
   {{0x3eb82b99,0x136811b2,0xd3781638,0x61f40109}},	//   kurt_, ишни_, шчи_, _anyl, 
   {{0x248c013f,0x61e40d27,0x4b78008f,0xe7f40166}},	//   apem_, fdkl, יטיג, _эчтэ, 
   {{0x20182b9a,0x7af80b1a,0x3eb8262b,0x00000000}},	//   _alpi_, øvty, durt_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3eb82b9b,0x10482b9c,0x61e4000f,0x61f4035a}},	//   furt_, рями_, adkl, _enyl, 
   {{0x3eb82b9d,0x63b400d0,0x00000000,0x00000000}},	//   gurt_, ózne, --, --, 
   {{0x20182b9e,0x92642b9f,0x68ec00d7,0x00000000}},	//   _elpi_, _بدتم, ťadi, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [2750] --, --, --, --, 
   {{0x3eb803fa,0x32082ba0,0x6fb82ba1,0x62240014}},	//   burt_, _hoay_, _угор_, _وى۪ل, 
   {{0x0a6816c3,0x3eb807de,0x8ca42ba2,0x8aa401b9}},	//   арди_, curt_, _चिको, юрад, 
   {{0x248c0077,0x99842ba3,0xadd81a71,0x00000000}},	//   ypem_, rhoş_, _умму_, --, 
   {{0x6d5c2ba4,0xa2a001bc,0xbdc400d1,0x00000000}},	//   _uzsa, _कौन्, _تەقۋ, --, 
   {{0xa6941614,0x66e407d6,0x3208004d,0x397c0023}},	//   приј, зока, _loay_, _ብዓልቲ_, 
   {{0x9ba02ba5,0x32080009,0xe5a40131,0x4e0c0401}},	//   _سەنى, _ooay_, пийи, _सवाई_, 
   {{0xd6cc0979,0x6b840368,0x7f3c010f,0xc8a802e8}},	//   اقي_, lchg, יעוו, _въже_, 
   {{0x69d82ba6,0xc1740198,0x00000000,0x00000000}},	//   mewe, _taɗi_, --, --, 
   {{0x6b842ba7,0x4830021a,0x94202ba8,0x61f4072b}},	//   nchg, _غواړ, емье, _snyl, 
   {{0x320828ab,0xe3b0267a,0x6b842ba9,0x98680131}},	//   _boay_, ورگ_, ichg, _اللە_, 
   {{0x61442baa,0x69d82bab,0x00000000,0x00000000}},	//   зема, newe, --, --, 
   {{0x61e42bac,0x69d82bad,0x6fcc00cd,0xb5cc0150}},	//   rdkl, iewe, द्भू, _ﺒﺄﻀﻌ, 
   {{0x69d82bae,0x81dc2baf,0x3eb806f2,0xc31004c5}},	//   hewe, ঠাই_, turt_, াছবি_, 
   {{0xe8e400ec,0x5398011a,0x00000000,0x00000000}},	//   _ڌڻ_, _היצו, --, --, 
   {{0x69d82bb0,0x27e42bb1,0x6b84002d,0xc0e40b82}},	//   jewe, _laln_, echg, ምህር_, 
   {{0x69d82bb2,0x3eb82bb3,0x2fd0043b,0x5ba81e76}},	// [2760] dewe, surt_, ́ngɔ_, йкам_, 
   {{0xdce400da,0x27e4017a,0xcf8c01d9,0x2ee00240}},	//   _iekļ, _naln_, _مژِ_, _fshf_, 
   {{0x69d80161,0x22802bb4,0x8f78011a,0x0f7808c3}},	//   fewe, _jók_, _לניק, _לאיב, 
   {{0x69d809f9,0x63a02bb5,0x3208001e,0x00000000}},	//   gewe, haln, _xoay_, --, 
   {{0x26c40477,0x4c802bb6,0xddd4012d,0xf1c000cd}},	//   _aqlo_, _пляв, zmyś, ष्टन, 
   {{0x9f580004,0x36d42bb7,0x00000000,0x00000000}},	//   _topä_, докр, --, --, 
   {{0x63a02bb8,0x69d82bb9,0x8c180302,0x65780334}},	//   daln, bewe, _פולי, _bgwh, 
   {{0xc17402a8,0x09e02bba,0xd5e0004d,0x63a00175}},	//   _haɗu_, _посн, _khỏ, ealn, 
   {{0xc1740198,0x32080c6a,0x1dcc00dc,0xdce400e2}},	//   _kaɗu_, _roay_, ह्यत, _nekļ, 
   {{0x22801f60,0x32082bbb,0xf6c4022e,0x00000000}},	//   _bók_, _soay_, _биpи_, --, 
   {{0x95c82bbc,0xd6282bbd,0x00000000,0x00000000}},	//   _глеб_, _ложе_, --, --, 
   {{0x63a000af,0x867800d9,0x63800124,0x00000000}},	//   aaln, _הראו, нҳәа, --, 
   {{0x320805da,0x50642bbe,0xd76002f2,0x00000000}},	//   _voay_, зтва, _تۆژی, --, 
   {{0x69d82bbf,0xb4e802ab,0x74142bc0,0x228002d2}},	//   zewe, मटी_, _زوبا, _fók_, 
   {{0x69d800ec,0x93581513,0x6e20017a,0x998402f0}},	//   yewe, _урду_, ëlbo, dnož_, 
   {{0x69d802c4,0x43380375,0xc33000d9,0x00000000}},	//   xewe, _לעוב, _רוק_, --, 
   {{0x1cc00003,0x69d82bc1,0xd24c0050,0xbec40055}},	// [2770] _གྱད_, vewe, _لۆگ_, _śīty, 
   {{0x69d82bc2,0xf778025c,0x705404fb,0xadec00af}},	//   wewe, _daħk_, _زنجا, _चोरन_, 
   {{0x6b842bc3,0x00000000,0x00000000,0x00000000}},	//   rchg, --, --, --, 
   {{0x63a02bc4,0x27e42bc5,0x6b8422f8,0xfb84013d}},	//   zaln, _saln_, schg, _җырн, 
   {{0xba742bc6,0xed500451,0x69d82bc7,0x10400092}},	//   رامت, _شھر_, rewe, _የህትመ, 
   {{0x69d80925,0x63a0058a,0xbea80244,0xf5340240}},	//   sewe, xaln, _بهێن_, _ክትኮነ, 
   {{0x63a00f72,0x69d82bc8,0xb7c800c6,0x96f40798}},	//   valn, pewe, سبوك_, дејт_, 
   {{0x63a02bc9,0x466003cc,0x22800174,0x00000000}},	//   waln, رۇشق, _rók_, --, 
   {{0x92bc045e,0xc17403f9,0xc8b0004b,0xe508027d}},	//   ুটো_, _yaɗu_, _سلاک, زيدو_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x04ec015b,0x62800369,0x1cc0031c,0x00000000}},	//   য়নের_, uqlo, _གྱན_, --, 
   {{0x63a02bca,0xa0a42bcb,0x62802bcc,0x00000000}},	//   saln, мамд, rqlo, --, 
   {{0x63a02bcd,0xa5bc02d5,0x1aa8033f,0xa5080798}},	//   paln, siųs, _चट्ठ, _фела_, 
   {{0x228026b8,0xe2982bce,0x63a003d9,0x04640354}},	//   _tók_, _дак_, qaln, _этем, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb7d40241,0xd5e00051,0x00000000,0x00000000}},	//   _iṣeg, _phỏ, --, --, 
   {{0xdb1c01f4,0x00000000,0x00000000,0x00000000}},	// [2780] nepö, --, --, --, 
   {{0x8d600b32,0x3e7c00df,0x4d6002bf,0xb33c0003}},	//   твуе, _aŭte_, ткув, laħa, 
   {{0x1a280108,0x9e64011c,0xea940139,0x00000000}},	//   ожжи_, _овод, ешчэ, --, 
   {{0x81dc00cc,0xd5e00051,0x00000000,0x00000000}},	//   ঠাক_, _thỏ, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe4f0000d,0x9f4802d2,0x00000000,0x00000000}},	//   _अछ़ि_, _þjón_, --, --, 
   {{0x86c02bcf,0xd5b82bd0,0xdddc2bd1,0x47c800f1}},	//   نيون, осп_, _nupū, تانۍ_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x057002dd,0xc670007b,0xb4e802db,0x00000000}},	//   پايد, خطوب, मटे_, --, 
   {{0x69cc0142,0xd394013d,0x00000000,0x00000000}},	//   ŵaet, фәдә_, --, --, 
   {{0x0bb4025f,0x2874052f,0xefe0044e,0x07a02bd2}},	//   ולים_, _яҡшы_, ነታዊ_, _рахн, 
   {{0xa81802dd,0xda1c0118,0x00000000,0x00000000}},	//   _وتەر_, पसित_, --, --, 
   {{0xdb1c000d,0x00000000,0x00000000,0x00000000}},	//   mepõ, --, --, --, 
   {{0xdb1c000d,0x00000000,0x00000000,0x00000000}},	//   lepõ, --, --, --, 
   {{0xf31805f5,0x60c001e4,0xadd40640,0x99840165}},	//   _хойш_, _ĥome, новљ, nnoų_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2f2400e8,0x8bc40063,0xefe0001f,0x00000000}},	// [2790] _bëgé_, дсед, ነሳው_, --, 
   {{0x3dc01c06,0x50640bbf,0xdce403e0,0xdb1c0037}},	//   agiw_, _تطبق, _cekı, hepõ, 
   {{0xdb1c01b8,0x00000000,0x00000000,0x00000000}},	//   zepö, --, --, --, 
   {{0x1cc00156,0x32182bd3,0xc9800023,0x0ddc0092}},	//   _གྱམ_, nksy_, _ክበጽሖ_, _ዓቀፉ_, 
   {{0xd36415fa,0xc03c0020,0x7c840588,0xddd4010e}},	//   _څه_, _ባለሥል, _аусе, lmyş, 
   {{0xd3641af6,0x2ca800c5,0x2d88003a,0xd7e40150}},	//   _مه_, msad_, lcae_, емше_, 
   {{0x7ac42bd4,0x2ca82bd5,0xddd4010e,0x00000000}},	//   _исте, lsad_, nmyş, --, 
   {{0x2d882bd6,0xdb1c0108,0xdddc00c0,0x2ca82bd7}},	//   ncae_, tepö, _rupū, osad_, 
   {{0x2ca81c81,0x79c82bd8,0x2d880393,0x79502bd9}},	//   nsad_, _توقف_, icae_, _پێوا, 
   {{0xdddc02b5,0x2ca8000d,0xddd400a2,0xd8b414af}},	//   _pupū, isad_, kmyş, _سگها_, 
   {{0x34842bda,0x00000000,0x00000000,0x00000000}},	//   нгөг, --, --, --, 
   {{0x2ca82bdb,0x339802d3,0x00000000,0x00000000}},	//   ksad_, መስረተ_, --, --, 
   {{0xa1142bdc,0xdb1c000f,0x2ca82bdd,0x6fb00210}},	//   روست, lepô, jsad_, _जयशं, 
   {{0x201c2bde,0xdee405f5,0x443001b8,0x2ca82bdf}},	//   óti_, ноги, _öx_, dsad_, 
   {{0x93100133,0x6d580003,0x00000000,0x00000000}},	//   _مووش, żwal, --, --, 
   {{0x0ddc001f,0x2ca82be0,0xdce403e0,0x00000000}},	//   _ዓቀፍ_, fsad_, _sekı, --, 
   {{0x15f00c2e,0xc21001d9,0xa514031c,0x2ca82be1}},	// [27a0] _अफसर_, _مٔژ_, ིརིག_, gsad_, 
   {{0x2d880393,0x00000000,0x00000000,0x00000000}},	//   acae_, --, --, --, 
   {{0x3f982be2,0x2ca80192,0x3ce0033b,0x2c00010b}},	//   mbru_, asad_, swiv_, шүрм, 
   {{0x2d882be3,0xe9e40212,0x0f34008f,0xdb1c0c6a}},	//   ccae_, кціо, _טריט_, ngpé, 
   {{0x7b840150,0xe9800131,0x24bc00d1,0xa2a01408}},	//   _لازە, рқун, _ﻣﻪﯞﺟ, _कौस्, 
   {{0xcdcc004b,0x3eb80076,0x00000000,0x00000000}},	//   _پښې_, orrt_, --, --, 
   {{0x8c402be4,0x81b82158,0x2480001f,0xabc401e0}},	//   _сере, ঘ্য_, _የሁለት_, _шарҙ, 
   {{0x96442be5,0xda640ccb,0x35f40120,0xceb0011a}},	//   ээлд, _سازي, тпир, איה_, 
   {{0x7d042be6,0x3f980003,0xdb1c000d,0x2d840139}},	//   nxis, kbru_, repõ, _şlek_, 
   {{0x3d080034,0xdb1c00c5,0x00000000,0x00000000}},	//   _सपने_, sepõ, --, --, 
   {{0x26100998,0xb6c402dd,0xf19400f5,0x00000000}},	//   _cáos_, _рөлд, кинь, --, 
   {{0xca300075,0x3eb8010a,0x00000000,0x00000000}},	//   ﺭﻏﺎ_, drrt_, --, --, 
   {{0xf4842be7,0x7d040227,0x2ca80009,0x00000000}},	//   _شاشی, jxis, xsad_, --, 
   {{0xb4ac0490,0x906021ef,0x3f982be8,0xffe42be9}},	//   गळी_, انسۇ, gbru_, люсн, 
   {{0x518400f3,0x00000000,0x00000000,0x00000000}},	//   _пупа, --, --, --, 
   {{0x2ca82bea,0x2d88003a,0x00000000,0x00000000}},	//   tsad_, ucae_, --, --, 
   {{0x7d042beb,0x2ca81c06,0x2d880381,0x3f982bec}},	// [27b0] gxis, usad_, rcae_, bbru_, 
   {{0x2ca82bed,0x2d882bee,0x2bd82bef,0x00000000}},	//   rsad_, scae_, بارک_, --, 
   {{0x2ca82bf0,0xd5a400f2,0x00000000,0x00000000}},	//   ssad_, _پف_, --, --, 
   {{0x6fcc2bf1,0x2ca82bf2,0x00000000,0x00000000}},	//   द्रू, psad_, --, --, 
   {{0x9f580100,0x2ca8036b,0xf99001c8,0x0854004e}},	//   _anpè_, qsad_, صبن_, нчкө_, 
   {{0xec3404ac,0x76402bf3,0x4914012d,0x00000000}},	//   _יאָר_, enmy, बैगो_, --, 
   {{0xbdd001e4,0x95380092,0x764002d2,0x00000000}},	//   liɨa, _እስከተ, fnmy, --, 
   {{0xba7402de,0x693400e8,0xdb2400e5,0xeb1c01f9}},	//   _ماقت, 茜eya, _شوقی, पनीत_, 
   {{0xd1e0001f,0x9f58007f,0x63b41155,0xa8740064}},	//   ምንት_, _enpè_, ózno, _алаі, 
   {{0x76402bf4,0x00000000,0x00000000,0x00000000}},	//   anmy, --, --, --, 
   {{0x23282bf5,0x00000000,0x00000000,0x00000000}},	//   фони_, --, --, --, 
   {{0x65942bf6,0xa53400f3,0x00000000,0x00000000}},	//   _раду, _инеч, --, --, 
   {{0x66082bf7,0x786405da,0x7d04031c,0x00000000}},	//   mjek, lòva, xxis, --, 
   {{0x66080209,0x3e7c0115,0x73c400f2,0x00000000}},	//   ljek, _aŭta_, _ميهم, --, 
   {{0x8fa02685,0x64402bf8,0x6608208d,0x4fa00395}},	//   расе, mnli, ojek, рисв, 
   {{0xd24c212c,0x66082bf9,0x3c240036,0x7d04009d}},	//   _ونو_, njek, _möve_, txis, 
   {{0x64402bfa,0x60240953,0x660801f5,0xdca41606}},	// [27c0] onli, _адпа, ijek, тази, 
   {{0x7d042bfb,0x64402bfc,0xabc40032,0x66080821}},	//   rxis, nnli, лауҙ, hjek, 
   {{0x64402bfd,0x66082bfe,0x78640268,0xcfb400df}},	//   inli, kjek, jòva, _בליי_, 
   {{0x64400730,0x7d040bc9,0x660804ba,0xb33c0327}},	//   hnli, pxis, jjek, daħl, 
   {{0xc03c0020,0x66080023,0xa9c417b9,0x00000000}},	//   _ባለስል, djek, ازمو, --, 
   {{0x64400936,0x8d742bff,0xfaa410e8,0xc5e800fe}},	//   jnli, _جاپا, _مجری, কাফা_, 
   {{0xc5e800bd,0x46a02c00,0x5984014b,0x00000000}},	//   কানা_, ашыб, _албб, --, 
   {{0x64402c01,0xcb642c02,0x66082c03,0x7640005b}},	//   enli, _расе_, gjek, unmy, 
   {{0xb4ac0490,0x22400ac5,0xf4842c04,0xdddc01ef}},	//   गळे_, dnkk_, دابی, _lupů, 
   {{0xe7c8068f,0x64401427,0x660800e4,0x295402e8}},	//   _रायप, gnli, ajek, _съср, 
   {{0x81ac009e,0x6284003e,0x1de00073,0x81cc00eb}},	//   খলন_, _éhol, _पसंत, রজন_, 
   {{0x64400a85,0x05802c05,0x52d0000d,0x00000000}},	//   anli, _кушм, _तहीस, --, 
   {{0xe7c82c06,0x73c40032,0x798002d0,0xd574005b}},	//   _रामप, _йәне, _mgmw, _ружь, 
   {{0xd01800d8,0x00000000,0x00000000,0x00000000}},	//   ффм_, --, --, --, 
   {{0x5fd01af8,0x00000000,0x00000000,0x00000000}},	//   द्धल, --, --, --, 
   {{0x2008036e,0x00000000,0x00000000,0x00000000}},	//   ajbi_, --, --, --, 
   {{0x0ba407d8,0xdeb00220,0x82340472,0x00000000}},	// [27d0] вшем, _құты, _خروا, --, 
   {{0x798002d0,0x5fd00073,0x7cd80454,0x4ea4022e}},	//   _agmw, द्दल, ъмур_, _ирма, 
   {{0x7ac40b3b,0x9e640023,0xdfd0009f,0x00000000}},	//   исце, _ጸገምና_, _ايپ_, --, 
   {{0xc3300302,0xa3d82c07,0x00000000,0x00000000}},	//   סוף_, _डॉन_, --, --, 
   {{0x66081727,0x644017b8,0x48a8013e,0x6934084c}},	//   vjek, ynli, фтем_, ынду, 
   {{0xa6c82c08,0x00000000,0x00000000,0x00000000}},	//   елка_, --, --, --, 
   {{0x66082c09,0x64402c0a,0x6d5c0200,0x49b800be}},	//   tjek, vnli, _hysa, _يارد_, 
   {{0x24e82c0b,0x7864068c,0x6d5c0306,0xd5e00051}},	//   емии_, ròva, _kysa, _chò, 
   {{0x66082c0c,0xc7c40022,0xe504007b,0x64401d0e}},	//   rjek, _асеи, ابعي, tnli, 
   {{0x6d5c2c0d,0x66081a84,0x644003fa,0xe3b000c6}},	//   _mysa, sjek, unli, حرة_, 
   {{0x21a42c0e,0x6d5c2c0f,0xa6c82c10,0xc7640131}},	//   линм, _lysa, _سوشل_, _شائى, 
   {{0x1e842c11,0xb4642c12,0x6d5c2c13,0x00000000}},	//   ғлам, лкөл, _oysa, --, 
   {{0xf4840261,0xf6500137,0x00000000,0x00000000}},	//   _кујн, _بئل_, --, --, 
   {{0xf778038f,0xf43400f7,0x00000000,0x00000000}},	//   _taħt_, _кечэ, --, --, 
   {{0x6d5c2c14,0x1c4402a9,0x69c8127b,0x02c000cf}},	//   _aysa, ҳнам, _ocee, _тийү, 
   {{0x69c80070,0x6d5c05ac,0x2d942c15,0x68e82c16}},	//   _ncee, _bysa, ирус, _osed, 
   {{0x6d5c015d,0x00000000,0x00000000,0x00000000}},	// [27e0] _cysa, --, --, --, 
   {{0x69c82c17,0x6d5c2c18,0x1098123b,0xbd4401e2}},	//   _acee, _dysa, _רביב, هنځي, 
   {{0x68e82c19,0xd13402d3,0x6d5c058a,0xdd1000de}},	//   _ased, _ኣስተው, _eysa, _kļūt, 
   {{0x1d080aa8,0x6d5c2c1a,0xa7a00150,0x18800023}},	//   _земи_, _fysa, _ﺎﺩﺍﺓ_, _ክሰግር_, 
   {{0x6d5c2c1b,0xd5e0004d,0x00000000,0x00000000}},	//   _gysa, _nhó, --, --, 
   {{0x3db00eac,0x2c0400dc,0x4ed400fe,0x00000000}},	//   ঙ্খল, राणं_, হিৰল, --, 
   {{0x68e82c1c,0xd5e0004d,0x182801d5,0x672c0115}},	//   _esed, _phò, وقچی_, ŝajn, 
   {{0xd4980364,0x34b42c1d,0xa280068f,0xb4b401b9}},	//   нро_, абиё, łość_, айиш, 
   {{0x628400d8,0xe8e800f1,0x2ee000bc,0xc68c0014}},	//   _éhoj, _لرلو_, _पन्त, _ہِل_, 
   {{0x53e40124,0x7864067c,0x743400f5,0x9d1000fe}},	//   уциа, mòvo, рноф, _সেৱন_, 
   {{0xcc54008f,0x00000000,0x00000000,0x00000000}},	//   רביי_, --, --, --, 
   {{0x044000d1,0x2ee000bc,0x00000000,0x00000000}},	//   _һечн, _पनौत, --, --, 
   {{0x2748006a,0x3e7c008f,0x68e805b1,0x386c010e}},	//   _tînï_, _aŭto_, _xsed, _khdr_, 
   {{0x6d5c2c1e,0x74142c1f,0xc05802dd,0x2d8c0003}},	//   _rysa, _خوتا, гіс_, _żee_, 
   {{0x386c01ab,0x00000000,0x00000000,0x00000000}},	//   _mhdr_, --, --, --, 
   {{0x95e000ab,0x00000000,0x00000000,0x00000000}},	//   _खसोट_, --, --, --, 
   {{0xbf140184,0xe8140037,0xc3c000cf,0xd24c00e5}},	// [27f0] _һүрә, _तकला_, _төөл, _ونڈ_, 
   {{0x6d5c04bf,0x00000000,0x00000000,0x00000000}},	//   _vysa, --, --, --, 
   {{0x78bc00da,0xddc400b8,0xdeb002dd,0x6d5c2c20}},	//   _ārva, _cikų, _мұры, _wysa, 
   {{0x68e8007f,0x31680240,0xa9c00228,0x00000000}},	//   _psed, _kzaz_, تۅرۉ, --, 
   {{0xe94404fb,0x7a3801e4,0xae94004d,0x6d5c03e0}},	//   جرای, aŭto, _kẹos, _uysa, 
   {{0x25a8151c,0x68e80dfe,0x00000000,0x00000000}},	//   _žal_, _vsed, --, --, 
   {{0x8d740075,0x66041d0f,0x672c01e4,0xe610007b}},	//   _جاھا, ипка, ĝajo, قشة_, 
   {{0x68e82c21,0x69c80998,0x57b02c22,0x22480115}},	//   _tsed, _ucee, ббәт, _ĉako_, 
   {{0x68e814dc,0xf778031c,0x2918032e,0x3d0800cd}},	//   _used, _daħq_, _æsa_, समये_, 
   {{0x39142c23,0xc6a4009b,0x00000000,0x00000000}},	//   _умур, _брди, --, --, 
   {{0x2a6c2c24,0x316801ed,0x9f580241,0xe3642c25}},	//   _kheb_, _azaz_, _lopò_, ркни, 
   {{0xa4d402bf,0xe3b02c26,0xd5e00051,0x00000000}},	//   _воді, حرک_, _thó, --, 
   {{0x386c0175,0xdddc0356,0xf6741867,0xc5e800cc}},	//   _yhdr_, _lupţ, _االخ, কাদা_, 
   {{0xa0682c27,0x8fa02c28,0xfaf8005f,0xe3b82c29}},	//   тага_, жаре, _šīm_, _рбк_, 
   {{0xdee42c2a,0x31682c2b,0xd36c0451,0x98a40010}},	//   шови, _ezaz_, _ٺهي_, vzoč_, 
   {{0xbdd001e4,0x00000000,0x00000000,0x00000000}},	//   riɨo, --, --, --, 
  
   {{0xa2a00bca,0xd24c009f,0xeb1401e1,0x00000000}},	// [2800] कीर्, _تني_, _òòjé_, --, 
   {{0x2a6c0161,0x5fa8033f,0xd00c007b,0x00000000}},	//   _aheb_, _क़िल, _يلي_, --, 
   {{0xaec00220,0x5ac800fb,0x59842c2c,0x00000000}},	//   _нұрл, тлем_, алеб, --, 
   {{0x2a6c2c2d,0x5fd02c2e,0x3c2401e3,0x00000000}},	//   _cheb_, द्रल, _döva_, --, 
   {{0x386c2c2f,0x6bd41066,0xd944084c,0xa3c42c30}},	//   _phdr_, شتەر, шеди, एला_, 
   {{0x985400a8,0xd6d82c31,0x81cc00eb,0x4870009a}},	//   штеш, вти_, রজি_, يدوس, 
   {{0xda780116,0x00000000,0x00000000,0x00000000}},	//   _җяң_, --, --, --, 
   {{0x6d400055,0x00000000,0x00000000,0x00000000}},	//   _ślai, --, --, --, 
   {{0x81ac015b,0x57e806ed,0xb4e007f7,0xd40403c5}},	//   খলা_, _идам_, दबे_, аяни, 
   {{0xd88802dd,0x00000000,0x00000000,0x00000000}},	//   _ﻗﻮﻳﯟ, --, --, --, 
   {{0xdb0c01ef,0xd7340354,0x32542c32,0xb23c0150}},	//   _odbí, _тхаь, йвор, емнi, 
   {{0x25dc2c33,0xc1ac00d1,0xb9e41954,0xd7f80354}},	//   _कॉपी_, _ﻳﯩﺮﺍ, _ቫን_, _пуç_, 
   {{0x0678011a,0x00000000,0x00000000,0x00000000}},	//   _סנדל, --, --, --, 
   {{0x9fa0002e,0x04d8010f,0x9f580248,0x00000000}},	//   _bëñu_, _סקול, _ropò_, --, 
   {{0xbe882c34,0x6e9400fb,0xae4400f2,0x00000000}},	//   исте_, сибу, مپسو, --, 
   {{0xdddc0356,0x3c24007c,0x82340f17,0xfe0400d8}},	//   _rupţ, _röva_, _وريا, оџум, 
   {{0x25dc2c35,0xacf802dd,0x3c24007c,0xaa580131}},	// [2810] _कॉफी_, ынау_, _söva_, қиду_, 
   {{0xada401e0,0x3cf8000d,0xa2ac0073,0xb33c0327}},	//   раҡл, _उछरे_, ूंच्, taħh, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2a6c0211,0xcb8c02d3,0x14c40a8a,0x00000000}},	//   _qheb_, _ዝጀመረ_, लढाण, --, 
   {{0x105c0092,0x00000000,0x00000000,0x00000000}},	//   _ለህትመ, --, --, --, 
   {{0x1d140375,0x6e0000f1,0x00000000,0x00000000}},	//   _הקשר_, _بېړن, --, --, 
   {{0xd90c00f1,0x00000000,0x00000000,0x00000000}},	//   ویې_, --, --, --, 
   {{0xa3d8012c,0x986800db,0x00000000,0x00000000}},	//   ड्न_, _ەلكە_, --, --, 
   {{0xe4580aa8,0x852003e6,0xa8142519,0x4a7401af}},	//   лжи_, ڵوگۆ, _лдаш, _быҡт, 
   {{0x291c2c36,0x00000000,0x00000000,0x00000000}},	//   mywa_, --, --, --, 
   {{0xe7182c37,0x182801d5,0x61e000a2,0x20040051}},	//   _حيات_, _حقلی_, _ıolb, _đoi_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x25ac2c38,0xa6b800cc,0x00000000,0x00000000}},	//   mael_, _আহিয়, --, --, 
   {{0xa2e4010b,0x25ac020c,0x00000000,0x00000000}},	//   _гокд, lael_, --, --, 
   {{0x66f81025,0xc214013f,0x9e642c39,0x64a40116}},	//   ्मिक_, _toɔ_, مارن, _таһа, 
   {{0x25ac2c3a,0x442401a4,0x2d8400a2,0xa06801a9}},	//   nael_, _hln_, _şler_, таҳа_, 
   {{0x61e42c3b,0x6fb000ab,0x00000000,0x00000000}},	// [2820] mekl, _जयचं, --, --, 
   {{0x61e42c3c,0x60c42c3d,0x44242c3e,0xdddc00ef}},	//   lekl, mukm, _jln_, _dupš, 
   {{0xdddc0f8b,0x60c42c3f,0x6fa801c6,0xd7f80b01}},	//   _eupš, lukm, _өвөг_, ғул_, 
   {{0x61e42c40,0x38c8006c,0x44240ffb,0x4e24010b}},	//   nekl, لاتی_, _lln_, _гоюн_, 
   {{0x25ac00a9,0x7e642c41,0xd838010b,0x5cf4013d}},	//   dael_, mlip, лэк_, _уяну, 
   {{0x7e642c42,0x442403b9,0x61e42c43,0x00000000}},	//   llip, _nln_, hekl, --, 
   {{0x61e42c44,0x248c011f,0x7bdc2c45,0x60c4022e}},	//   kekl, eqem_, _ibru, hukm, 
   {{0x7e64113c,0x61e42c46,0x248c011f,0x7afc2c47}},	//   nlip, jekl, fqem_, _irrt, 
   {{0x44242c48,0x61e42c49,0x99840165,0x7e642c4a}},	//   _bln_, dekl, lhoů_, ilip, 
   {{0x442400b5,0x7e6402c1,0x7afc0200,0x4804014b}},	//   _cln_, hlip, _krrt, _леун_, 
   {{0x25ac1028,0x7bdc2c4b,0x61e42c4c,0x00000000}},	//   bael_, _mbru, fekl, --, 
   {{0x61e42c4d,0x44240789,0xcb100375,0x7e64107d}},	//   gekl, _eln_, ללת_, jlip, 
   {{0x7bdc2c4e,0x661c2c4f,0x44242c50,0x00000000}},	//   _obru, öske, _fln_, --, 
   {{0x7e6401ee,0x7f942c51,0x70a805d7,0x7afc25d7}},	//   elip, зарх, _कबील, _orrt, 
   {{0x61e42c52,0x291c033f,0x403404b0,0xff0406a6}},	//   bekl, zywa_, черс, пятн, 
   {{0x7e642c53,0x61e42c54,0xa29404d3,0xcd44001f}},	//   glip, cekl, _بدوڵ, _በመክፈ, 
   {{0x7bdc01ab,0x7afc0175,0x8d380092,0x4238011a}},	// [2830] _bbru, _arrt, _በዘላቂ, _לנהל_, 
   {{0x7afc020b,0x7e642c55,0x25ac00d8,0x5fa800bc}},	//   _brrt, alip, zael_, करणल, 
   {{0x7e642c56,0xb33c0327,0x00000000,0x00000000}},	//   blip, bbħe, --, --, 
   {{0x291c00aa,0x7e642c57,0x7bdc2c58,0x7afc020b}},	//   tywa_, clip, _ebru, _drrt, 
   {{0x6e2c03e0,0x7afc2c59,0xa7a81d39,0x278800c7}},	//   mhab, _errt, акла_, аӡеи_, 
   {{0x6e2c2c5a,0x61e42c5b,0xa6942424,0x291c033f}},	//   lhab, zekl, ориј, rywa_, 
   {{0x248c011f,0x99840165,0x25ac0113,0x94dc06be}},	//   wqem_, choů_, tael_, _içər_, 
   {{0x6e2c2c5c,0xbb480597,0x0ba80e26,0x6a2404fb}},	//   nhab, _الفن_, _جاڭى_, _بفرم, 
   {{0x25ac2c5d,0x442410eb,0x61e412e8,0x36d400c7}},	//   rael_, _pln_, vekl, _ҭоур, 
   {{0xe70414a5,0x69d82c5e,0x6e2c2c5f,0x25ac016b}},	//   _وسای, lfwe, hhab, sael_, 
   {{0x6e2c2c60,0xf9900014,0x25b827dc,0x44241c1e}},	//   khab, _آبہ_, _نهاد_, _vln_, 
   {{0x6e2c2c61,0x60c42c62,0x61e4017a,0x9f5801e1}},	//   jhab, tukm, uekl, _nnpá_, 
   {{0x61e42c63,0x6e2c2c64,0x248c011f,0x4424000d}},	//   rekl, dhab, qqem_, _tln_, 
   {{0x6e2c003a,0xa878010f,0xf494010a,0x00000000}},	//   ehab, יאָר, _хăрн, --, 
   {{0x61e42c65,0x60c40098,0xbdd001e4,0x7e642c66}},	//   pekl, sukm, liɨi, tlip, 
   {{0x22b400da,0x7e64157b,0x7bdc0bdf,0x69d801f5}},	//   māk_, ulip, _sbru, jfwe, 
   {{0x22b400da,0x7e642c67,0x5ba82c68,0x99840165}},	// [2840] lāk_, rlip, икам_, zioų_, 
   {{0x7e642c69,0x69d82c6a,0x6e2c04ba,0x00000000}},	//   slip, efwe, ahab, --, 
   {{0x6e2c2c6b,0xd24c2c6c,0x22b400da,0x7e640bc2}},	//   bhab, _سنی_, nāk_, plip, 
   {{0x6e2c2c6d,0xceb00375,0x00000000,0x00000000}},	//   chab, _קיר_, --, --, 
   {{0xd7e82c6e,0xf3f800e2,0x24880332,0x00000000}},	//   имде_, loģe_, _éamh_, --, 
   {{0x69d801f5,0x22b400e2,0xe97003cc,0x00000000}},	//   afwe, kāk_, رۇلد, --, 
   {{0xdcf42c6f,0x786400cf,0xea6400e5,0x00000000}},	//   mayı, nòvi, _کھلی, --, 
   {{0xdcf42c70,0x597400c7,0x22b400e2,0x99840165}},	//   layı, _дызу, dāk_, rioų_, 
   {{0x77940244,0x00000000,0x00000000,0x00000000}},	//   _فیشا, --, --, --, 
   {{0x18680c04,0x47c02c71,0x68ec2c72,0x6e2c2c73}},	//   _тази_, _обув, çade, zhab, 
   {{0x92682c74,0x22b4005f,0xd6282c75,0x290000b0}},	//   ирма_, gāk_, _коже_, āhae_, 
   {{0x6e2c2c76,0xdcf40205,0x6ef4013a,0x00000000}},	//   xhab, hayı, hýbá, --, 
   {{0xdcf41ae4,0x764001f4,0x3d040210,0x00000000}},	//   kayı, mimy, रमों_, --, 
   {{0x76402c77,0x22b400da,0x6e2c00ec,0xae1c0037}},	//   limy, bāk_, whab, _नवहन_, 
   {{0xdcf42c78,0x786426b7,0x752003ac,0xdb1c265c}},	//   dayı, gòvi, lymz, ngpä, 
   {{0x2bdc1971,0xac940588,0x9de40327,0x764001f4}},	//   न्ना, зааш, _སྒྱེ, nimy, 
   {{0x6e2c2c79,0x82e4025c,0x8d742c7a,0xdd0c0205}},	// [2850] rhab, _འགོའ, زارا, rışc, 
   {{0x6e2c2c7b,0xd24c1d1f,0x76402c7c,0x22582c7d}},	//   shab, _سنڌ_, himy, čske_, 
   {{0x76402c7e,0x69d81cea,0x7864004e,0x6e2c2c7f}},	//   kimy, tfwe, còvi, phab, 
   {{0x6e2c0921,0x76400223,0x69d80112,0xfa341bf4}},	//   qhab, jimy, ufwe, ورند, 
   {{0x9de40135,0x22b400da,0x76400113,0x01fc08d8}},	//   _སྒྲེ, zāk_, dimy, יפאל, 
   {{0xac5400ec,0xdcf403b9,0x00000000,0x00000000}},	//   _ڀرڳڙ, cayı, --, --, 
   {{0xdce400e2,0x7640033b,0x69d80112,0xac941171}},	//   _izkā, fimy, pfwe, _фаҳш, 
   {{0x764000ca,0x69d80369,0x22b41a14,0x00000000}},	//   gimy, qfwe, vāk_, --, 
   {{0xf7702c80,0xbc680014,0xa9a40131,0xaac80073}},	//   _یام_, _طمہن_, _миңд, ांवक, 
   {{0x87042c81,0x22b4005f,0xe4500116,0x00000000}},	//   _وبال, tāk_, عضة_, --, 
   {{0x2bdc2c82,0xfbcc012c,0x76402c83,0x00000000}},	//   न्या, ालतम, bimy, --, 
   {{0x22b411f9,0x2c6c278a,0x26f82c84,0x15e002ab}},	//   rāk_, _vždy_, ्मीर_, _कॉपर_, 
   {{0x22b4005f,0xdcf4083c,0x00000000,0x00000000}},	//   sāk_, yayı, --, --, 
   {{0x2bdc0b7c,0xa03400cf,0x00000000,0x00000000}},	//   न्मा, سىزت, --, --, 
   {{0x64402c85,0x91a80c58,0xdb0c05ac,0x2c0402e5}},	//   mili, _কাৰ্, _åkøy, राईं_, 
   {{0xdb1c007c,0xd334011a,0x00000000,0x00000000}},	//   ngpå, _מרצה_, --, --, 
   {{0x22402c86,0xdcf42c87,0x61440484,0x64402c88}},	// [2860] mikk_, tayı, _хепа, oili, 
   {{0x61f42c89,0x6618039a,0x2240168c,0x7640019c}},	//   _hayl, _lowk, likk_, zimy, 
   {{0x61f42c8a,0xdcf41ae6,0x76400223,0x64402c8b}},	//   _kayl, rayı, yimy, iili, 
   {{0x64402c8c,0x61f42c8d,0x20182c8e,0x224003a1}},	//   hili, _jayl, _hopi_, nikk_, 
   {{0x64402c8f,0xdcf40790,0xc98000d1,0x0d802c90}},	//   kili, payı, нуши, _плюн, 
   {{0x64402c91,0x20182c92,0x764000ca,0x02d800dc}},	//   jili, _jopi_, wimy, _बहून, 
   {{0x64402c93,0x6618070d,0x20182c94,0x22402c95}},	//   dili, _bowk, _mopi_, kikk_, 
   {{0x61f42c96,0xa3d82c97,0x20182c98,0x64402c99}},	//   _nayl, ड्स_, _lopi_, eili, 
   {{0x76402c9a,0xf434084c,0x2240143a,0x661c10ee}},	//   rimy, депэ, dikk_, öska, 
   {{0x20180de2,0x1cd8031c,0x20d4003a,0x76402c9b}},	//   _nopi_, ྡ྄ར_, dæi_, simy, 
   {{0x61f42c9c,0x46a02c9d,0x224003a1,0x66180493}},	//   _bayl, _захв, fikk_, _fowk, 
   {{0x61f42c9e,0x22402c9f,0x661800a2,0x644012ef}},	//   _cayl, gikk_, _gowk, aili, 
   {{0x61f42ca0,0x20182ca1,0x44440014,0x2bdc0b4c}},	//   _dayl, _bopi_, _کرنہ, न्डा, 
   {{0x20182ca2,0x6e3c2ca3,0x94200228,0x3d0000bc}},	//   _copi_, _smsb, _سوعۇ, रिने_, 
   {{0x224003cd,0x64b40790,0x00000000,0x00000000}},	//   bikk_, _eşiğ, --, --, 
   {{0x61f42ca4,0x7db4007b,0x224000e5,0x00000000}},	//   _gayl, ّصلا, cikk_, --, 
   {{0x32080d62,0x20180421,0xc1bc0302,0xbba82ca5}},	// [2870] _inay_, _fopi_, _המחש, गरूक, 
   {{0x628400d8,0x20182ca6,0x3208004d,0x61f42ca7}},	//   _éhor, _gopi_, _hnay_, _zayl, 
   {{0x61f42ca8,0x15d801ec,0xa7e400d1,0x00000000}},	//   _yayl, _ﺃﺤﺎﺩ, ېكتى, --, 
   {{0x61f4102c,0x64402ca9,0x6e3c02d0,0x19c00022}},	//   _xayl, zili, _umsb, кәуг, 
   {{0x9f58023a,0xfcc800d1,0x20182caa,0x1f500023}},	//   _enpä_, _нурй_, _yopi_, _ዘስደም, 
   {{0x64402cab,0x201802c4,0x6618058a,0xdce400e2}},	//   xili, _xopi_, _sowk, _uzkā, 
   {{0x32082cac,0x02d8000d,0x91bc27a6,0xba0800d1}},	//   _onay_, _बहेन, ्लाई, تتەك_, 
   {{0x64400f7b,0x76c400d1,0x00000000,0x00000000}},	//   wili, رغىل, --, --, 
   {{0x61f42cad,0x3d001971,0x74f801c6,0x9f5801e3}},	//   _rayl, रिये_, пээс_, _inpå_, 
   {{0x61f42cae,0x32082caf,0xe7b42cb0,0x6618020b}},	//   _sayl, _anay_, _آماد, _wowk, 
   {{0x61f42cb1,0x22402cb2,0x20182cb3,0x661800a2}},	//   _payl, tikk_, _ropi_, _towk, 
   {{0x21682896,0x61f42cb4,0x20182cb5,0x2bdc2cb6}},	//   жими_, _qayl, _sopi_, न्ता, 
   {{0x224003a1,0x61f42cb7,0x9f480798,0x00000000}},	//   rikk_, _vayl, cebê_, --, 
   {{0x61f40986,0x22401a82,0x23282cb8,0xdee42cb9}},	//   _wayl, sikk_, _моли_, моги, 
   {{0x2240000d,0xfbcc194b,0x00000000,0x00000000}},	//   pikk_, ालसम, --, --, 
   {{0x74a4095f,0x61f403e3,0x00000000,0x00000000}},	//   चीकृ, _uayl, --, --, 
   {{0x20182cba,0xdb0c0ea0,0x0f4802d3,0x00000000}},	// [2880] _topi_, _gebê, _ዘድልየ, --, 
   {{0x32080109,0x25dc2cbb,0xcf8c01d9,0xcb4801ec}},	//   _znay_, क्ती_, _نژِ_, дiрi, 
   {{0x2bdc2cbc,0x3e480276,0x5f4404fb,0xa2a00490}},	//   न्धा, eşte_, _آنجل, कीच्, 
   {{0xfaf800da,0x1d0800cf,0x00000000,0x00000000}},	//   _šīs_, _деми_, --, --, 
   {{0x249c0218,0x08942cbd,0xd8380006,0x1278010f}},	//   _ntwm_, وضوع_, жэй_, קאנע, 
   {{0x68ec2cbe,0x2bdc29ea,0x399400d2,0x3f980ffb}},	//   çada, न्दा, _bûsó_, ncru_, 
   {{0xdb0c00e8,0x3e480356,0xcb6404c2,0x00000000}},	//   _mebë, aşte_, _жаре_, --, 
   {{0x8a0002e8,0xdb0c0200,0x00000000,0x00000000}},	//   _изсе, _lebë, --, --, 
   {{0x25bc0042,0x1fc400cc,0x62940115,0x00000000}},	//   _ddwl_, শ্যস, ŭzol, --, 
   {{0xdecc010c,0xd5e80014,0x00000000,0x00000000}},	//   ብለን_, _ژٹان_, --, --, 
   {{0xdb0c00d2,0x97242cbf,0x00000000,0x00000000}},	//   _sebê, _تفاو, --, --, 
   {{0xd6242cc0,0xd50800ec,0x00000000,0x00000000}},	//   _تعطي, _وٺان_, --, --, 
   {{0xae0c07f7,0xdb0c0200,0xf8bc00cc,0x00000000}},	//   हासन_, _bebë, _আঙুঠ, --, 
   {{0x74142cc1,0x22580419,0x00000000,0x00000000}},	//   _سوبا, čska_, --, --, 
   {{0xb900025c,0x00000000,0x00000000,0x00000000}},	//   _ཧད_, --, --, --, 
   {{0x3f980ffb,0x32082cc2,0x32d8003e,0x00000000}},	//   acru_, _unay_, méy_, --, 
   {{0x32d82cc3,0x00000000,0x00000000,0x00000000}},	// [2890] léy_, --, --, --, 
   {{0xdb0c2cc4,0x41740150,0x1fc42cc5,0x70542cc6}},	//   _kebè, _جاىس, শ্বস, _سنجا, 
   {{0xfbd000f1,0x7cf801d3,0xba7400e5,0x96ac010a}},	//   شتل_, túrá, چانت, _чiир_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c040034,0x6fc00183,0xec34010f,0xae0c0037}},	//   राओं_, শ্ৰে, _טאָר_, हावन_, 
   {{0x99840032,0xf414015b,0x661c08c5,0x974c0023}},	//   мтәһ, িসার_, ösko, _ዕንወት, 
   {{0xd5e80135,0x00000000,0x00000000,0x00000000}},	//   _རྒྱག, --, --, --, 
   {{0x31681529,0xe50801e2,0xe75800f2,0x7534009d}},	//   _nyaz_, سيدو_, _کلاغ_, вээх, 
   {{0xdb0c00cf,0x387c0175,0x7b080166,0xe2c80798}},	//   _bebè, cmvr_, _üstä, плод_, 
   {{0x31682cc7,0x33f400f7,0x32d80de2,0xe5e00153}},	//   _ayaz_, тчыс, géy_, _былi_, 
   {{0xdb0c007f,0x00000000,0x00000000,0x00000000}},	//   _debè, --, --, --, 
   {{0xa5082c31,0xe4d801e2,0x00000000,0x00000000}},	//   _хела_, _روغت_, --, --, 
   {{0x31680100,0x60c40327,0xa3c404af,0x3f8c0162}},	//   _dyaz_, rrkm, एलओ_, ødu_, 
   {{0x9e740063,0x00000000,0x00000000,0x00000000}},	//   ећај, --, --, --, 
   {{0x2bdc276a,0xb308009f,0x00000000,0x00000000}},	//   न्सा, _آغول_, --, --, 
   {{0xda582cc8,0x3f98017a,0xf7780327,0x00000000}},	// [28a0] үреш_, pcru_, _waħx_, --, 
   {{0xc5e8015b,0x4d602cc9,0x00000000,0x00000000}},	//   কাটা_, укув, --, --, 
   {{0x4fd41a4c,0xe7c82cca,0x1e842ccb,0x9f48020c}},	//   _אויב_, _राजप, _плом, kebé_, 
   {{0xdca400cf,0x661c007c,0x00000000,0x00000000}},	//   _пами, öskl, --, --, 
   {{0x2bdc2ccc,0x1cc8025c,0x18682ccd,0xae0c0037}},	//   न्हा, _ཊའི_, пади_, हारन_, 
   {{0x25dc2cce,0xb9082982,0x986401d9,0x00000000}},	//   क्सी_, _बह_, ریاے_, --, 
   {{0x32d8011f,0xbbcc012c,0xfce00023,0x629400df}},	//   xéy_, ालीक, _ሓዲጉ_, ŭzoj, 
   {{0xdb0c2ccf,0xca340220,0xa5bc00c0,0x00000000}},	//   _rebè, _ﯗﻟﺖ_, lkųj, --, 
   {{0x788400c7,0x2bdc00dc,0x32d80098,0x98a40107}},	//   _акаҷ, न्वा, wéy_, _чизе, 
   {{0xccf00302,0x88b80375,0x72d000d1,0xa9740798}},	//   רכז_, _מזמי, لەتچ, _русј, 
   {{0x07a02cd0,0xdb0c1d62,0x316805b1,0xf4842c04}},	//   _сахн, _bebé, _syaz_, _یاتی, 
   {{0x32d817bb,0xd1640107,0x00000000,0x00000000}},	//   réy_, еъги, --, --, 
   {{0xdb0c09c2,0x0f38001f,0x32d8003e,0x201c01a9}},	//   _debé, _አስመረ, séy_, аti_, 
   {{0xd754044e,0x63ac10fb,0xdb0c007f,0x148400ec}},	//   _ውሕስነ, _đang, _tebè, _ڪپڙي_, 
   {{0xa3d82cd1,0x00000000,0x00000000,0x00000000}},	//   _डॉट_, --, --, --, 
   {{0xdb0c2cd2,0x28d02356,0x56200183,0x9e6c0092}},	//   _gebé, _समलि, বোৰক_, _በጥሞና_, 
   {{0x31680b6f,0x8bc42cd3,0x00000000,0x00000000}},	// [28b0] _uyaz_, есед, --, --, 
   {{0x7bf82cd4,0x1ea800ec,0x00000000,0x00000000}},	//   ннур_, _ڪاٿي_, --, --, 
   {{0x41740214,0xf1c401f9,0x00000000,0x00000000}},	//   _لایس, _वयान, --, --, 
   {{0xf990168d,0x68ec2cd5,0xcfa80345,0x00000000}},	//   مبه_, çado, _باکم_, --, 
   {{0xd3641732,0x00000000,0x00000000,0x00000000}},	//   _چه_, --, --, --, 
   {{0xd3642cd6,0x97c00c9e,0xab940640,0xc1740a1e}},	//   _نه_, айше, _јављ, נחס_, 
   {{0x9ba00075,0x1cdc031c,0xda0000c5,0x00000000}},	//   _ئەمى, _རཱོ_, _रोवत_, --, 
   {{0x24982cd7,0x64981411,0x00000000,0x00000000}},	//   ísmo_, мтор_, --, --, 
   {{0x9f4800f7,0xe89402d5,0xdb0c2cd8,0x3e4803e0}},	//   rebé_, _разь, _rebé, nşta_, 
   {{0x68e82cd9,0xe3b0007b,0xdb0c2cda,0xe2980114}},	//   _iped, جرة_, _sebé, мао_, 
   {{0xe8d0146b,0x3f8c01a6,0x21a42cdb,0x00000000}},	//   _समुच, žduk_, кинм, --, 
   {{0xa1142cdc,0x1fa800bc,0x00000000,0x00000000}},	//   پوست, कर्ड, --, --, 
   {{0x6f040332,0x3914030d,0x00000000,0x00000000}},	//   _arhc, _умăр, --, --, 
   {{0x25dc1b42,0x68e80083,0x7018177b,0xe3642cdd}},	//   क्री_, _mped, ніст_, _икли, 
   {{0x9e642cde,0xdb0c003e,0x9f480158,0x00000000}},	//   نارن, _tebé, ndbø_, --, 
   {{0xe8d0032c,0x9f580240,0x68e803ac,0x05100154}},	//   _समूच, _hapë_, _oped, িনীর_, 
   {{0x6f0402c4,0x9f58036e,0x1278010f,0xd7d001f9}},	// [28c0] _erhc, _kapë_, _קאפע, _सालच, 
   {{0x9f580023,0xbbcc012c,0xb7bc00de,0x2bdc00bc}},	//   _japë_, ालेक, _koģe, न्ला, 
   {{0x68e82cdf,0x00000000,0x00000000,0x00000000}},	//   _aped, --, --, --, 
   {{0x01b0015b,0xdb0801e1,0x00000000,0x00000000}},	//   _কাঁদ, _ènít, --, --, 
   {{0x68e81529,0xec1000d1,0xdca400d8,0x00000000}},	//   _cped, _گۈلد, _јаги, --, 
   {{0x913808a8,0xe9800131,0x69dc0432,0x8ba026ef}},	//   וענק, сқун, _ösen, _вирж, 
   {{0x68e80428,0x24a4001f,0x2b900d73,0x291801ab}},	//   _eped, _ለሁለት_, _ایمس, _àsan_, 
   {{0x24800020,0x35f42830,0xd498016c,0x7e64004c}},	//   _ከሁለት_, упир, мро_, noip, 
   {{0xaa640108,0x00000000,0x00000000,0x00000000}},	//   _стёк, --, --, --, 
   {{0x7e642ce0,0x98742377,0x00000000,0x00000000}},	//   hoip, _рубљ, --, --, 
   {{0x1db02ce1,0x0bb402e4,0xd774007b,0x00000000}},	//   जरात, כלים_, _شائع, --, 
   {{0x27e82ce2,0xd7d007c1,0x68e8035a,0x7e6400e4}},	//   đane_, _साँच, _yped, joip, 
   {{0xc5101291,0xccd002dd,0x00000000,0x00000000}},	//   _نبوت, _ﻓﻘﺎل_, --, --, 
   {{0xbbcc0303,0x93040798,0x00000000,0x00000000}},	//   ालोक, _аџил, --, --, 
   {{0x1cdc031c,0x92e8036b,0x704401ec,0xd5e00208}},	//   _རཱུ_, _آرتق_, _ەرجە, _giọ, 
   {{0x7e640618,0xfda40640,0xa34c0419,0x9268030d}},	//   goip, ијум, ščák, _юрла_, 
   {{0xd7d000af,0x9f5802bd,0xdd000205,0x00000000}},	// [28d0] _सांच, _lapè_, ğuğu, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68e82ce3,0x7e64073c,0xbf1416c8,0xe9440214}},	//   _sped, boip, _күрә, گرای, 
   {{0x6a70005c,0xa93401f4,0x00000000,0x00000000}},	//   råfo, лееш, --, --, 
   {{0x6e2c2ce4,0xe9441272,0xf9901ec7,0x2c74009f}},	//   mkab, درای, زبن_, _مُحس, 
   {{0x6e2c2ce5,0x9200002b,0x00000000,0x00000000}},	//   lkab, _śālm, --, --, 
   {{0x2ba82ce6,0xba74075e,0x6e2c009f,0x48ec033f}},	//   _च्या, _چاقت, okab, _इनको_, 
   {{0xba74247f,0xcd440020,0x9f48143a,0xa2e408ca}},	//   _ناقت, _በመንፈ, rdbø_, қомд, 
   {{0x68e82ce7,0x6e2c2ce8,0x9f58036e,0xa95400f3}},	//   _uped, ikab, _papë_, _сваљ, 
   {{0x7e642ce9,0x6e2c2cea,0xa9240154,0x00000000}},	//   zoip, hkab, _মেথড_, --, 
   {{0x6e2c2ceb,0xe2842cec,0x7e6401c8,0x0510015b}},	//   kkab, ллои, yoip, িনের_, 
   {{0xa0a41fd6,0xe3b00014,0x65942ced,0x36342cee}},	//   ламд, جرک_, _саду, _پرمس, 
   {{0x6e2c0067,0xdce40153,0x7e6401f4,0x00000000}},	//   dkab, _pykč, voip, --, 
   {{0x9f580098,0x63042cef,0x6e2c0fda,0xd2a401ec}},	//   _hapé_, _موتل, ekab, _өкше_, 
   {{0x7e642cf0,0xd0040276,0x6e2c0009,0xa2e42cf1}},	//   toip, ыере_, fkab, _сойд, 
   {{0x6e2c2cf2,0x3e7c01e4,0x645c0264,0x3d00190e}},	//   gkab, _oƭte_, ésif, रिले_, 
   {{0xdca42cf3,0x7e642cf4,0x80e8000d,0x6d4006be}},	// [28e0] уази, roip, _ओहिओ_, _əlag, 
   {{0x6e2c0099,0x1c0c2cf5,0x00000000,0x00000000}},	//   akab, साइल_, --, --, 
   {{0x6e44022c,0x7e642cf6,0x6e2c2cf7,0x8f9800df}},	//   útbú, poip, bkab, _ריטי, 
   {{0x6e2c2cf8,0x9f5802e2,0xb4f801ad,0xd1d40092}},	//   ckab, _rapè_, ्टमय_, _ርዳታ_, 
   {{0x9f582b1d,0x3c2400ac,0x1cdc0327,0x394008c2}},	//   _sapè_, _dövr_, _རཱི_, àis_, 
   {{0x7d040516,0xb8dc007d,0x99840165,0x3ce00356}},	//   mvis, _आब_, skoů_, mtiv_, 
   {{0x3ce02165,0xda00000d,0x00000000,0x00000000}},	//   ltiv_, _रोअत_, --, --, 
   {{0xceb00302,0x9f582cf9,0x7d042cfa,0xb3680023}},	//   זיה_, _capé_, ovis, _ሳንዱቕ_, 
   {{0x7d0417f9,0x3ce02cfb,0x25b808a7,0xbec40055}},	//   nvis, ntiv_, ðsla_, _śīly, 
   {{0x7d042cfc,0x28c82cfd,0x88800120,0x00000000}},	//   ivis, _रिति, _глуж, --, 
   {{0x7d04049b,0x32542cfe,0x3ce000c5,0x97540063}},	//   hvis, ивор, htiv_, _стаљ, 
   {{0x3ce02cff,0xdb0c02f0,0x6e2c2d00,0x00000000}},	//   ktiv_, _nebí, xkab, --, 
   {{0xc5f00302,0x6e2c0083,0xc1b80a89,0xca200150}},	//   _לדף_, vkab, ылях_, _ﺸﻁﺏ_, 
   {{0x6d4003b9,0x00000000,0x00000000,0x00000000}},	//   _əlad, --, --, --, 
   {{0xdb0c04d4,0x1c0c0ce0,0x765c00e4,0x7d042d01}},	//   _bebí, साईल_, _êrys, evis, 
   {{0x7d042d02,0x8d840137,0x712404b3,0x21340129}},	//   fvis, гузд, _نىعم, êché_, 
   {{0xdb0c09ff,0x661c023a,0x629413d5,0x7d042d03}},	// [28f0] _debí, öski, ízov, gvis, 
   {{0x6e2c019b,0x6e980798,0x00000000,0x00000000}},	//   skab, _ивор_, --, --, 
   {{0x7d042d04,0xbca80075,0x00000000,0x00000000}},	//   avis, ندەك_, --, --, 
   {{0x7d040e8a,0x2d4c01e4,0xf3e80154,0xe4e40037}},	//   bvis, _tɾe_, _কোমর_, _कहलि_, 
   {{0x3ce02d05,0xab940212,0x9f580129,0x7c84084c}},	//   ctiv_, _вигі, _rapé_, руӂе, 
   {{0x2ca8034c,0xfbcc00bd,0x9f58026c,0x6d5c2d06}},	//   mpad_, র্বত, _sapé_, _ixsa, 
   {{0x2ca82d07,0x9c60215c,0x00000000,0x00000000}},	//   lpad_, _بۇلو, --, --, 
   {{0xc214013f,0x00000000,0x00000000,0x00000000}},	//   _ahɔn_, --, --, --, 
   {{0xdee41e38,0xe57807d6,0x2ca80b4f,0x7d0009c2}},	//   ዝብና_, ъзи_, npad_, _ámst, 
   {{0xa4442d08,0xe2e4003b,0x00000000,0x00000000}},	//   рнод, ажоп, --, --, 
   {{0x9f582d09,0x7d0405b8,0x6378136b,0xa2e4013e}},	//   _tapé_, zvis, ъсир_, шонд, 
   {{0xf7482d0a,0x7d042d0b,0x2ca81ef9,0x6d5c2d0c}},	//   _حلمي_, yvis, kpad_, _oxsa, 
   {{0x25ac2d0d,0x23dc12eb,0x2ca8007c,0x00000000}},	//   mbel_, _मापद, jpad_, --, 
   {{0x7d042d0e,0x645c2d0f,0x2ca8079b,0xe0e40086}},	//   vvis, ésid, dpad_, _òòmo_, 
   {{0xc4442d10,0x6d5c2d11,0x81c00eac,0x7d042d12}},	//   _لیکن_, _axsa, ুভব_, wvis, 
   {{0x630416cb,0x3ce0038f,0x7d042d13,0x25ac2b92}},	//   _موڪل, ttiv_, tvis, nbel_, 
   {{0x25ac04fb,0x1c442d14,0x7d040194,0x2ca82d15}},	// [2900] ibel_, анам, uvis, gpad_, 
   {{0xdb0c2d16,0x09e000fe,0x00000000,0x00000000}},	//   _rebâ, _নোলা, --, --, 
   {{0x3ce02d17,0x7d042d18,0x6d5c2d19,0x25ac2d1a}},	//   stiv_, svis, _exsa, kbel_, 
   {{0x7d042d1b,0x25ac0196,0xd9d02ba5,0x3f942d1c}},	//   pvis, jbel_, تەرگ, şbuğ_, 
   {{0xa04002d3,0x25ac00f3,0x6aa80010,0xd8f4010b}},	//   _ኣብነታ, dbel_, _čefe, рчеь, 
   {{0x25ac2d1d,0x00000000,0x00000000,0x00000000}},	//   ebel_, --, --, --, 
   {{0xb90800aa,0x19b80276,0x00000000,0x00000000}},	//   _څښتن_, _аузь_, --, --, 
   {{0x27e81326,0x34b412d7,0x25ac017a,0xd7d00d26}},	//   đana_, ббиё, gbel_, _साकच, 
   {{0x15e00574,0x8e34010f,0x73c401e0,0xfbcc00eb}},	//   क्षर_, ינקא_, бәйе, র্ণত, 
   {{0x3a240156,0x25ac2d1e,0x28740022,0x71400023}},	//   _homp_, abel_, _лыхр, _ኣስማቶ, 
   {{0xd3782d1f,0x14c00073,0xf2e82d20,0x61e4002f}},	//   ъчи_, _शिकण, اکته_, ffkl, 
   {{0x2ca82d21,0x3a240165,0xabdc0150,0x6d4006be}},	//   ypad_, _jomp_, _ﺇﻫﻤﺎ, _əlab, 
   {{0x32040118,0x00000000,0x00000000,0x00000000}},	//   ěly_, --, --, --, 
   {{0x10482d22,0x3a240b4f,0x50642d23,0x68ec0798}},	//   тями_, _lomp_, ртма, çadi, 
   {{0xc05810f5,0x645c2d24,0x25dc08e9,0xcdd8041b}},	//   рія_, ésie, क्की_, кња_, 
   {{0x7bdc2d25,0x2ca8017a,0x3a242d26,0x82641fb8}},	//   _acru, tpad_, _nomp_, _وهون, 
   {{0x8d8401d5,0x00000000,0x00000000,0x00000000}},	// [2910] рувд, --, --, --, 
   {{0x2ca806a3,0x0ba42d27,0x00000000,0x00000000}},	//   rpad_, ршам, --, --, 
   {{0xd1bc0020,0x25ac0af9,0x6e9401c8,0xadbc00c0}},	//   _ሶስት_, ybel_, _دلجا, _панi, 
   {{0x2ca801e6,0x7bdc0857,0x3a242d28,0x3df400c0}},	//   ppad_, _ecru, _comp_, _дзюс, 
   {{0x3a240165,0x2248002e,0x00000000,0x00000000}},	//   _domp_, _ňakk_, --, --, 
   {{0x3a240156,0x7bdc00c6,0x8aa42d29,0x067c06ba}},	//   _eomp_, _gcru, _врад, ﺯﯨﻨﯩ, 
   {{0x26c02d2a,0x25ac08cd,0x7afc05b1,0x4b500014}},	//   ého_, tbel_, _gsrt, _بێار, 
   {{0x26c82d2b,0xa3a82d2c,0x25ac2d2d,0x3a240165}},	//   čao_, गुन_, ubel_, _gomp_, 
   {{0xa4442d2e,0x7bdc0083,0x69d82d2f,0x693401ee}},	//   йнид, _ycru, mgwe, _унау, 
   {{0xc6e4090b,0x7bdc034c,0x3a240165,0x69d8030a}},	//   _відп, _xcru, _zomp_, lgwe, 
   {{0x9f5808e5,0xe3642d30,0x25ac257c,0xa348041b}},	//   _capì_, скни, pbel_, узна_, 
   {{0xe1f000c6,0x61e40112,0x394001c3,0xa4d400d4}},	//   أسد_, ufkl, ùisg_, _годі, 
   {{0x64a42d31,0x661c01a8,0x9c800118,0x69d80142}},	//   _уала, ösku, řčic, igwe, 
   {{0x8fa01dde,0xa878008f,0x00000000,0x00000000}},	//   заре, טאָר, --, --, 
   {{0x69d82d32,0xb80400cd,0x7bdc003a,0x28d0033f}},	//   kgwe, _adṛś, _rcru, _समझि, 
   {{0x7bdc2d33,0xdb0c0306,0x629401e4,0xfb1801d9}},	//   _scru, _nebá, ŭzos, یراں_, 
   {{0x3a242d34,0x9b9400cf,0x6284002f,0xa29c012d}},	// [2920] _romp_, مشاش, mmko, _ऐंड्, 
   {{0xd37c1505,0xdec000b7,0x3a24002e,0x69d801f5}},	//   šćem_, ትሪክ_, _somp_, egwe, 
   {{0x5f042d35,0x3a242d36,0x9f58007f,0x9f041077}},	//   _узна, _pomp_, _enpò_, _اوجو, 
   {{0xd6d8016c,0x69d80337,0x5984034f,0x00000000}},	//   ҳти_, ggwe, блеб, --, 
   {{0x98480816,0x1cb800e3,0xdb0c2d37,0x62842d38}},	//   ляка_, _حاجب_, _debá, imko, 
   {{0xd6d82d39,0x69d82d3a,0x00000000,0x00000000}},	//   гти_, agwe, --, --, 
   {{0x69d80099,0x3d002d3b,0xfe1c1df1,0x00000000}},	//   bgwe, रिके_, _पचास_, --, 
   {{0xc214013f,0x9f58026c,0x628401e4,0x09e02d3c}},	//   _nnɔ_, _rapì_, jmko, _носн, 
   {{0xd4042cf1,0x00000000,0x00000000,0x00000000}},	//   бяни, --, --, --, 
   {{0x96b82d3d,0x93242c10,0x62842d3e,0x00000000}},	//   _буду_, مرجن, emko, --, 
   {{0x2bdc0b4c,0x36180330,0x9d0400eb,0x87941e24}},	//   न्टा, _پراگ_, োনয়ন_, _اَمر_, 
   {{0x78a40356,0xb33c031c,0xc1ac07d2,0x00000000}},	//   ţivu, xbħu, _ﺳﯩﺮﺍ, --, 
   {{0x9148188b,0x645c2d3f,0x0678008f,0x9f480fac}},	//   учна_, ésic, _ענדל, nebæ_, 
   {{0x6e9406ed,0x6284017a,0x69d80165,0x067c2d40}},	//   живу, amko, zgwe, ﺯﯨﻠﯩ, 
   {{0x62940115,0x00000000,0x00000000,0x00000000}},	//   ŭzor, --, --, --, 
   {{0x28c8146c,0x99840306,0x00000000,0x00000000}},	//   _रिलि, zkoš_, --, --, 
   {{0x261803ce,0xb33c031c,0x00000000,0x00000000}},	// [2930] भाती_, rbħu, --, --, 
   {{0x09b000dc,0xada401e0,0xdb0c299d,0x69d80142}},	//   ुण्य, саҡл, _sebá, wgwe, 
   {{0xaab402bf,0x9f5800e4,0x00000000,0x00000000}},	//   ійді, _yapí_, --, --, 
   {{0x69d8030a,0x2bdc28f5,0x00000000,0x00000000}},	//   ugwe, न्जा, --, --, 
   {{0x69d82d41,0xa9680640,0x7c2c2b96,0x00000000}},	//   rgwe, јила_, ålrø, --, 
   {{0x69d82d42,0x00000000,0x00000000,0x00000000}},	//   sgwe, --, --, --, 
   {{0xe7382d43,0x62842d44,0x00000000,0x00000000}},	//   рей_, ymko, --, --, 
   {{0xe7f4068f,0x998404a7,0x00000000,0x00000000}},	//   _इसका_, skoš_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x68ec067c,0x394000a3,0x00000000,0x00000000}},	//   çadu, ùise_, --, --, 
   {{0x38602d45,0x29001d76,0xc5b0009d,0x00000000}},	//   éire_, āhau_, _ерлө, --, 
   {{0x290c2d46,0x7b200960,0x26c00306,0xaad000c5}},	//   _krea_, _ušuš, áhou_, _हिनक, 
   {{0x291c0921,0x62842d47,0x00000000,0x00000000}},	//   nxwa_, rmko, --, --, 
   {{0xdfd000c6,0x628401e4,0xb46401ec,0x00000000}},	//   بيس_, smko, _екіл, --, 
   {{0x683c026c,0x69c80a55,0xa3a817ee,0x44242d48}},	//   _ièdd, _odee, गुण_, _ion_, 
   {{0x6d0402ab,0x290c005a,0x00000000,0x00000000}},	//   रिंग_, _orea_, --, --, 
   {{0x44242d49,0x62541ebd,0x9c24192a,0xdb980640}},	// [2940] _kon_, tšof, одад, атељ_, 
   {{0x69c814cc,0x44242d4a,0xee38013e,0x1bb82d4b}},	//   _adee, _jon_, анӣ_, شائع_, 
   {{0x44242d4c,0x290c2d4d,0x62840395,0x8af403b9}},	//   _mon_, _area_, _èhos, _üəll, 
   {{0x290c2d4e,0x8f780375,0xd98002dd,0x00000000}},	//   _brea_, _כניק, _ﺩﻭﺭﻩ_, --, 
   {{0x290c2d4f,0x44242d50,0x69c80334,0x9aa80131}},	//   _crea_, _oon_, _ddee, انچە_, 
   {{0x44242d51,0x69c82d52,0x00000000,0x00000000}},	//   _non_, _edee, --, --, 
   {{0x290c005a,0x3e480311,0x00000000,0x00000000}},	//   _erea_, eşti_, --, --, 
   {{0x44242d53,0x3dc00295,0x290c2d54,0xcf900375}},	//   _aon_, naiw_, _frea_, וטו_, 
   {{0x290c0276,0x94842d55,0x76900124,0xa8a42d56}},	//   _grea_, жынд, _ẽysa, _فصلو, 
   {{0x1cdc0156,0xdb0c013c,0x93882d57,0x00000000}},	//   _རཱན_, _vebæ, исна_, --, 
   {{0x44242d58,0x69c800b5,0x645c2d59,0x8c38002f}},	//   _don_, _ydee, ésia, _fußf, 
   {{0x44242d5a,0x00000000,0x00000000,0x00000000}},	//   _eon_, --, --, --, 
   {{0x44242d5b,0xc21800d6,0xdf480020,0x268800aa}},	//   _fon_, ією_, _አስፈፃ, _اخلي_, 
   {{0xdb1c0120,0x00000000,0x00000000,0x00000000}},	//   rapê, --, --, --, 
   {{0x22a404fe,0x7f942d5c,0x00000000,0x00000000}},	//   _pēke_, дарх, --, --, 
   {{0xd1b80133,0x00000000,0x00000000,0x00000000}},	//   _ئاغا_, --, --, --, 
   {{0x44242d5d,0xc0d8001f,0xd36c05a9,0xbd680064}},	// [2950] _yon_, ርቧል_, _سۇڭ_, орфе_, 
   {{0x44242d5e,0xaa5001e1,0x00000000,0x00000000}},	//   _xon_, _ṣàá_, --, --, 
   {{0x94f8003d,0x7ac41064,0xdb1c004e,0xf9900133}},	//   _དགའི_, дсче, napè, ۆبه_, 
   {{0x290c2d5f,0x7b640801,0x88f00150,0x00000000}},	//   _prea_, фтуе, дікә, --, 
   {{0xf9900dc3,0xdde801b9,0xdb1c00e4,0x00000000}},	//   نبه_, _ارپه_, hapè, --, 
   {{0x290c00a8,0x68441719,0xa52401f0,0x00000000}},	//   _vrea_, янла, ҷмид, --, 
   {{0x44242d60,0xbb58030d,0x3cdc0210,0x00000000}},	//   _ron_, _дарх_, गूठे_, --, 
   {{0x44242d61,0x290c2d62,0xdb1c0ba1,0xe618039b}},	//   _son_, _trea_, dapè, сди_, 
   {{0xaa44010b,0x290c0f85,0xa2bc2d63,0x00000000}},	//   _деңл, _urea_, वीन्, --, 
   {{0x44242d64,0x9f5801e1,0xe85801f7,0x00000000}},	//   _qon_, _lapá_, _اسرڻ_, --, 
   {{0x44242d65,0xdb0c2d66,0x683c0129,0x00000000}},	//   _von_, _gebä, _cède, --, 
   {{0x44242d67,0x8c380e78,0x63e401e2,0x00000000}},	//   _won_, _fußg, _کېدې_, --, 
   {{0x44242d68,0x250800f2,0x00000000,0x00000000}},	//   _ton_, _درای_, --, --, 
   {{0x9f582d69,0x44242d6a,0x25bc015d,0x26182d6b}},	//   _papà_, _uon_, _hewl_, भावी_, 
   {{0xe7ec2d6c,0x25bc2d6d,0xe2c800aa,0xdb1c2d6e}},	//   च्या_, _kewl_, _اوبو_, capè, 
   {{0xdd900736,0xdca40124,0x5ca400c7,0xdb1c0200}},	//   ّور_, зааи, зиаб, sapë, 
   {{0x8d600961,0x3dc00036,0xd83c00d0,0xa0c401f7}},	// [2960] евте, raiw_, účka_, _عيدو, 
   {{0x62942d6f,0xe9e40589,0x2d9800a2,0x28e40150}},	//   _hiyo, åºno_, _egse_, _ﺍﺴﺘﻠ, 
   {{0x62942d70,0x4f980375,0x60c4143a,0x00000000}},	//   _kiyo, _לביצ, lskm, --, 
   {{0x62942d71,0x25bc031c,0xdb1c2d72,0x00000000}},	//   _jiyo, _newl_, napé, --, 
   {{0x62942d73,0xdb0c09a5,0xdd902d74,0x60c42d75}},	//   _miyo, _sebä, _سوس_, nskm, 
   {{0x62942d76,0xe9800075,0xdb1c0124,0x00000000}},	//   _liyo, тқун, hapé, --, 
   {{0x8f980bd9,0x62940428,0x91c400cc,0x00000000}},	//   זיצי, _oiyo, ষ্টখ, --, 
   {{0xaad021b8,0x39842d77,0xdb1c00e4,0x00000000}},	//   _हितक, _قیاف, japé, --, 
   {{0xdb1c00d8,0x00000000,0x00000000,0x00000000}},	//   dapé, --, --, --, 
   {{0x6294037e,0x81d4009e,0x00000000,0x00000000}},	//   _aiyo, স্ম_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x62942d78,0xdb1c2d79,0xe6b401b9,0x46a00006}},	//   _ciyo, rapè, _آلنگ, _чацв, 
   {{0x62942d7a,0x9f5800d8,0xd468252c,0x26181d94}},	//   _diyo, _rapá_, _лиде_, भारी_, 
   {{0xc950025f,0x4ea405f5,0x629404ce,0x9f580241}},	//   תמש_, зраа, _eiyo, _sapá_, 
   {{0x9f582d7b,0x62942d7c,0xa91c0010,0x0874008f}},	//   _papá_, _fiyo, _izže, פעלט_, 
   {{0xdb1c2d7d,0x62942d7e,0x6fb400ec,0x76400051}},	//   capé, _giyo, _ڪمدا, nhmy, 
   {{0x8d740597,0xd24c00aa,0xd8600521,0xac942d7f}},	// [2970] سارا, _لنډ_, zọọt, дааш, 
   {{0x6294023b,0x00000000,0x00000000,0x00000000}},	//   _ziyo, --, --, --, 
   {{0x6db4010b,0x9f5801e1,0x00000000,0x00000000}},	//   _ойну, _tapá_, --, --, 
   {{0x62942d80,0x69cc2d81,0x3eac00d7,0xefe800e5}},	//   _xiyo, दृढी, ídte_, _اٹھو_, 
   {{0x8c3809f0,0xbb5000b5,0x202803b2,0x23dc1b76}},	//   _auße, _comサ_, _útið_, _मालद, 
   {{0x6d4003b9,0x00000000,0x00000000,0x00000000}},	//   _əlal, --, --, --, 
   {{0xca7426c0,0x261800e1,0x00000000,0x00000000}},	//   _فارغ, भाली_, --, --, 
   {{0xcfe000cc,0x45a00145,0xff18011a,0x00000000}},	//   য়িন, رەتك, לקות_, --, 
   {{0xc9840323,0x62942d82,0x3a8402d5,0x645c00d8}},	//   _хуви, _riyo, _чырв, ésio, 
   {{0x62942d83,0x7e9c02b5,0xd860063f,0x8c38002f}},	//   _siyo, _hōpe, pọọt, _fuße, 
   {{0x62942d84,0x7e9c0374,0xdb1c2d85,0x00000000}},	//   _piyo, _kōpe, tapé, --, 
   {{0x1c080574,0x629407d6,0x764003cb,0x221402a9}},	//   _होईल_, _qiyo, chmy, ффор, 
   {{0xdb1c2d86,0x66082d87,0x22a400ef,0x62942d88}},	//   rapé, mdek, _dēka_, _viyo, 
   {{0x66082d89,0xdfd000c6,0x62942d8a,0x60c42d8b}},	//   ldek, ضير_, _wiyo, rskm, 
   {{0x2cb80003,0x62942d8c,0xb4242d8d,0x64402d8e}},	//   _བསུབ, _tiyo, _سعوو, mhli, 
   {{0x7e9c00b0,0xa3a82d8f,0x6440014f,0x8c38002f}},	//   _nōpe, गुर_, lhli, _nußb, 
   {{0x6144119e,0xd0640150,0x00000000,0x00000000}},	// [2980] _цепа, _ﺍﻳﯩﭗ_, --, --, 
   {{0x64402d90,0x660802f6,0x5f7400d1,0xdbc401e3}},	//   nhli, hdek, _يادر, _lööf, 
   {{0x66082d91,0x20182d92,0x1e842b2d,0x50180a7c}},	//   kdek, _inpi_, _олом, _וויו, 
   {{0xa2d42d93,0xceb006a9,0x6e3c0477,0x00000000}},	//   _भिन्, _שיר_, _glsb, --, 
   {{0x66082252,0x2018020b,0x64400067,0x00000000}},	//   ddek, _knpi_, khli, --, 
   {{0x645c07ea,0x66080373,0xdf240150,0xf63c00d1}},	//   ésil, edek, _ءﯨﻨﯩ, ﻟﻼﮬ_, 
   {{0xda641216,0x64400571,0x8c380730,0x6d4000ac}},	//   _قاري, dhli, _fußb, _əlam, 
   {{0x66082d94,0x6440002f,0x069002dd,0xe3d400eb}},	//   gdek, ehli, _ﺟﺎﻧﯩ, ত্মব, 
   {{0xdb0c2d95,0xb7bc005f,0x6ba401e3,0x349402e8}},	//   _nebú, _loģi, _åtgå, наир, 
   {{0x64402d96,0x660800ab,0x20080010,0xa3a82ca5}},	//   ghli, adek, jdbi_, गुल_, 
   {{0x78a00223,0x95c80124,0x660801e4,0x8bd4010f}},	//   _humv, _дула_, bdek, וויו_, 
   {{0x78a02d97,0x51840323,0x20182d98,0x34940022}},	//   _kumv, дуга, _anpi_, ьаҿр, 
   {{0x64402d99,0x63ac2d9a,0x00000000,0x00000000}},	//   bhli, _şane, --, --, 
   {{0x64402d9b,0xdb0c2d9c,0x78a02d9d,0x84100022}},	//   chli, _debú, _mumv, _амшх, 
   {{0xb8e00ed9,0x78a00455,0x2c440022,0x00000000}},	//   _ཁས_, _lumv, ҕьаҳ, --, 
   {{0x27e81326,0x201802bd,0x63ac0e04,0x15e02c33}},	//   đani_, _enpi_, _đani, क्चर_, 
   {{0x78a0015c,0x7e9c02b5,0x313400a8,0xc1bc011a}},	// [2990] _numv, _rōpe, _чепр, _ומחש, 
   {{0x660803ee,0x32082d9e,0x4ea404a2,0x4bd800f2}},	//   zdek, _haay_, _орма, تبرد_, 
   {{0x0a682d9f,0x32082da0,0xbb840116,0x00000000}},	//   орди_, _kaay_, _ﺩﺍﻧﻪ_, --, 
   {{0x78a02da1,0x6f04036b,0x32080694,0x644000d7}},	//   _bumv, _ishc, _jaay_, zhli, 
   {{0x78a02da2,0x32082da3,0x66082da4,0xf8a81046}},	//   _cumv, _maay_, vdek, ودوه_, 
   {{0x78a0010f,0x32082da5,0x01380375,0x5c700139}},	//   _dumv, _laay_, ורדת_, _бһут, 
   {{0x645c2da6,0x66082da7,0xe5a40075,0xd1c402d3}},	//   ésim, tdek, нийи, ጽንታ_, 
   {{0x3208089c,0x66082da8,0xd90c00dd,0xba900150}},	//   _naay_, udek, جیے_, _ﺑﺎﻳﮕ, 
   {{0x9f58025a,0x64402da9,0x27e80b45,0x00000000}},	//   _zapä_, thli, ƙan_, --, 
   {{0x68e801f0,0xe3b00597,0x64400007,0xb7fc07f7}},	//   _iqed, درة_, uhli, _एसएम_, 
   {{0x32082daa,0x78a02dab,0x66082dac,0xfbcc0154}},	//   _baay_, _zumv, pdek, র্কত, 
   {{0x78a00516,0x21682dad,0x3208058a,0x64402dae}},	//   _yumv, зими_, _caay_, shli, 
   {{0xdb0c0086,0x6f040c8c,0x10a02daf,0x78a00218}},	//   _debù, _ashc, лиян, _xumv, 
   {{0xe2c82db0,0xc44401d5,0x7018187f,0xe3b000ae}},	//   _فوتو_, _آیدن_, міст_, _صرت_, 
   {{0x32082db1,0x5e9400c6,0x00000000,0x00000000}},	//   _faay_, فلسط, --, --, 
   {{0x68e8014b,0x320800e8,0x00000000,0x00000000}},	//   _oqed, _gaay_, --, --, 
   {{0xa2d4012c,0x0e600166,0x00000000,0x00000000}},	// [29a0] _भिड्, уктн, --, --, 
   {{0x9f480158,0x78a0005c,0xa6c40154,0x202002f0}},	//   kebø_, _rumv, _এমনট, ásič_, 
   {{0x68e801f0,0x78a00c86,0x9f482d8b,0x32082da0}},	//   _aqed, _sumv, jebø_, _yaay_, 
   {{0xda641b45,0x320817bb,0x78a0047e,0xfbd005d9}},	//   راضي, _xaay_, _pumv, _چڪا_, 
   {{0x683c0066,0x78a0047e,0xb3740023,0xfbd000ec}},	//   _sèda, _qumv, _ራዕድን_, _نڪا_, 
   {{0x78a00810,0x36d42db2,0x683c007f,0xdb1c1aa9}},	//   _vumv, вокр, _pèda, lapí, 
   {{0x8c1804ac,0x78a0015c,0x68e801f0,0xcb642db3}},	//   _צולי, _wumv, _eqed, _заре_, 
   {{0x65780142,0xdb1c0f91,0x4b78010f,0x00000000}},	//   _bywh, napí, _זאלו, --, 
   {{0x3208002e,0xd0c80011,0x2ab40248,0xa2bc21b8}},	//   _raay_, _লঙ্ঘ, _túbò_, वीस्, 
   {{0x32082db4,0x4d6800d1,0x335400cf,0x00000000}},	//   _saay_, ﺳﯩﯟﯨ, күлө_, --, 
   {{0x320801f5,0xa91c0427,0x56f002dd,0x142402dd}},	//   _paay_, _izža, _сүйс, _үдем, 
   {{0xb0a405f9,0xdb1c00c7,0x154400d8,0x00000000}},	//   _गंदग, japí, _пеем, --, 
   {{0x50640b2b,0x63800022,0x2c2c0023,0x00000000}},	//   етва, лҳәа, _ተዛሪቡ, --, 
   {{0x32082db5,0x518408ca,0x161c0b4c,0x00000000}},	//   _waay_, дуҳа, भावर_, --, 
   {{0x320800e8,0x27f003e0,0x00000000,0x00000000}},	//   _taay_, _özne_, --, --, 
   {{0xa2d42db6,0xd6b002f5,0xdb1c0407,0xc0d00023}},	//   _भित्, _ঘটায, gapí, እሶም_, 
   {{0x6c740114,0x00000000,0x00000000,0x00000000}},	// [29b0] влађ, --, --, --, 
   {{0xac1800d4,0x6d4003e3,0x00000000,0x00000000}},	//   ьозу_, _əlah, --, --, 
   {{0xbf140131,0x6f0402d0,0x00000000,0x00000000}},	//   _йүрә, _ushc, --, --, 
   {{0xba740244,0x00000000,0x00000000,0x00000000}},	//   هانت, --, --, --, 
   {{0x645c003e,0x5ea40154,0x00000000,0x00000000}},	//   ésik, গীদে, --, --, 
   {{0x7e9c04fe,0x776801f5,0x98a02db7,0x9f4803cd}},	//   _hōpa, _bxdx, шише, tebø_, 
   {{0x7e9c04fe,0x1c082db8,0xaa582db9,0xd1b80020}},	//   _kōpa, _होटल_, _живу_, ዳሉት_, 
   {{0x9f482dba,0xb9c4009f,0x00000000,0x00000000}},	//   rebø_, _مقفي, --, --, 
   {{0x68e80107,0x9f4803cd,0x753401c6,0x94e40ed8}},	//   _uqed, sebø_, гээх, نکوف_, 
   {{0xa2d400dc,0xdb1c02f0,0x22500d2e,0x00000000}},	//   _भिद्, zapí, _smyk_, --, 
   {{0x33f40598,0xb9cc001f,0xe3642dbb,0x00000000}},	//   учыс, _ዳቦ_, ткни, --, 
   {{0x27e82625,0xa0a42dbc,0x55501176,0xc4dc00cc}},	//   đanu_, камд, اپیر, _ভনীজ, 
   {{0xa5082dbd,0x00000000,0x00000000,0x00000000}},	//   _цела_, --, --, --, 
   {{0xa0682dbe,0x910016a4,0x2a7c015d,0x00000000}},	//   фага_, јпре, hlwb_, --, 
   {{0xd4642dbf,0x44e803b2,0xdee40107,0x00000000}},	//   _шише_, lø_, ъови, --, 
   {{0x5254035b,0x645c0066,0xd12c00f1,0x9f480241}},	//   _ахьӡ, èsif, _ژمي_, _àjín_, 
   {{0xa2bc00cd,0x44e801bf,0xc0d00023,0x00000000}},	// [29c0] वीर्, nø_, እቶም_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2b38084c,0xa13413de,0xdb1c295a,0xe7240133}},	//   няцэ_, _سرکش, papí, _اڵ_, 
   {{0x44e81347,0x5d84007b,0x48700271,0x81d40154}},	//   kø_, _للجل, یدوس, স্র_, 
   {{0x17080489,0x61f4044e,0x09e02dc0,0xd9442dc1}},	//   _གནངམ_, _mbyl, рочн, ъеди, 
   {{0x2b4c0118,0xdb1c0022,0x00000000,0x00000000}},	//   _řece_, rapâ, --, --, 
   {{0x7d042dc2,0xca742dc3,0x5a942dc4,0xd6c00ec9}},	//   lwis, رمۇش_, _араф, جمعی, 
   {{0x26182dc5,0xd0b006be,0x89d401f7,0x00000000}},	//   भागी_, _eşəl, _لوفر_, --, 
   {{0x18a42dc6,0x7d042dc7,0x57e82dc8,0x6254000a}},	//   _разм, nwis, _одам_, tšon, 
   {{0xa4900424,0x61f42dc9,0x72d000d1,0x975400f3}},	//   مینت, _abyl, مەتچ, _итељ, 
   {{0x7d042dca,0x07a00e4e,0x00000000,0x00000000}},	//   hwis, _тахн, --, --, 
   {{0x9fa40184,0x44e82dcb,0x06900046,0x3ce00254}},	//   ғырҙ, bø_, _ﺟﺎﻳﯩ, kuiv_, 
   {{0x65b0052f,0x32ec013f,0x855401ed,0x7d040100}},	//   _уҡыт, _mɛyi_, _لیٹر_, jwis, 
   {{0x7e9c02b5,0x00000000,0x00000000,0x00000000}},	//   _rōpa, --, --, --, 
   {{0xb03404a9,0x0dc801a9,0xadd40063,0x9258007b}},	//   نىڭغ, дузи_, ловљ, _يشعر_, 
   {{0x7d042dcc,0x12842dcd,0x24700023,0x7e440124}},	//   fwis, _جمعی_, _ስብሓት_, ахуе, 
   {{0xe9a42dce,0x506400fd,0x7d042dcf,0x8bc4023a}},	// [29d0] қалп, _атна, gwis, всед, 
   {{0xada40032,0x61f400bc,0x261807f7,0x6fb42dd0}},	//   таҡл, _zbyl, _मोनी_, _حمدا, 
   {{0xbed801c0,0x61f801d3,0x8c380112,0x4174030f}},	//   _идэх_, őtle, _fußn, _مایس, 
   {{0x7d042dd1,0x7e9c02b1,0x00000000,0x00000000}},	//   bwis, _tōpa, --, --, 
   {{0x62540219,0xc0d80092,0x8c0800eb,0x00000000}},	//   dšol, _ይባስ_, রাবন_, --, 
   {{0xd3642dd2,0xb8d40214,0xfbcc03d4,0x00000000}},	//   _هه_, شتهش, ৰ্বত, --, 
   {{0x2ca80009,0xdb1c00e4,0x7c380254,0x00000000}},	//   lqad_, rapã, övre, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6148004a,0xe5782dd3,0x00000000,0x00000000}},	//   _mêlé, эзи_, --, --, 
   {{0x44e803d4,0x057401d5,0xdb1c2dd4,0x00000000}},	//   rø_, _یاشد, lapá, --, 
   {{0x7d042dd5,0x637800fd,0x44e821e3,0x00000000}},	//   zwis, эсир_, sø_, --, 
   {{0x9f5803a0,0x7d040034,0xdb0c0216,0x3e780092}},	//   _tapú_, ywis, _nebý, _በፖስታ_, 
   {{0x25ac007f,0xb8f400b8,0x00000000,0x00000000}},	//   mcel_, _veṇī, --, --, 
   {{0x25ac2dd6,0xc5e005f9,0xcd28001f,0x645c00f2}},	//   lcel_, _गाँठ_, ሰግናለ, èsid, 
   {{0xdb1c2dd7,0x7d040ba7,0x9e641fae,0x25ac054e}},	//   kapá, wwis, هارن, ocel_, 
   {{0x25ac2dd8,0x7d042dd9,0x6d400cc1,0x205400d1}},	//   ncel_, twis, _əlav, _әтир, 
   {{0x7d0413eb,0x212400a2,0x5d680022,0x661c007c}},	// [29e0] uwis, _çoh_, хиам_, ösky, 
   {{0x7d042dda,0x683c020c,0x5f742ddb,0x5bc42ddc}},	//   rwis, _bèdm, _ماجر, اقال, 
   {{0x7d042ddd,0x41b82dde,0xc5e005f9,0x61480129}},	//   swis, _आभास, _गांठ_, _fêlé, 
   {{0x7d042ddf,0x98a42de0,0x4e240209,0xdb1c004e}},	//   pwis, гиде, _боюн_, rapà, 
   {{0x6e280428,0x7e642de1,0x91b8011a,0x00000000}},	//   _òeba, mnip, גמני, --, 
   {{0x7e9c02b5,0x8ba000ee,0xd37c16a3,0x7b840220}},	//   _kōpo, _гирж, šćim_, _نازە, 
   {{0xd5e002e3,0xf7040724,0x7e642c4a,0x6e340cad}},	//   _nhọ, рҗем, onip, _àgbé, 
   {{0x7e642de2,0x00000000,0x00000000,0x00000000}},	//   nnip, --, --, --, 
   {{0x80a02de3,0xdb0c014a,0x7e642de4,0x44b02de5}},	//   _गंगे, _lebü, inip, ббыс, 
   {{0x26180574,0x56900220,0x7e642de6,0x036801e1}},	//   _मोठी_, шақт, hnip, _ìsọf, 
   {{0xa3e405ba,0x7e642de7,0x7e9c00b0,0xd5e0004d}},	//   _फार_, knip, _nōpo, _chọ, 
   {{0x3eb80219,0x61e401e3,0x00000000,0x00000000}},	//   dprt_, ggkl, --, --, 
   {{0x53442de8,0x27140208,0x8c080154,0xb7bc0171}},	//   _әхла, _ánh_, রাতন_, _enģe, 
   {{0xdb0c01b8,0x7afc0010,0x33940006,0x7e642de9}},	//   _bebü, _oprt, _калё, enip, 
   {{0x645c004e,0x4e8802e8,0xdb1c0162,0x40340395}},	//   èsie, ещам_, lapæ, щерс, 
   {{0xdb0c2dea,0x645c0129,0xadb42deb,0x877800df}},	//   _debü, ésiv, рбаш, גאלי, 
   {{0x26c000dd,0x6cd40228,0x8c380112,0x00000000}},	// [29f0] ához_, شقاا, _fußl, --, 
   {{0x2ca801d9,0x624400e8,0x7e642dec,0xb2fc031c}},	//   rqad_, _góob, anip, _ྐྱོང_, 
   {{0xdb0c0730,0x2ca80009,0x7c842ded,0x25e409ab}},	//   _gebü, sqad_, суте, _टाली_, 
   {{0x2d88004e,0x06900220,0x7e6401ef,0x00000000}},	//   _үйүп_, _ﺟﺎﻋﯩ, cnip, --, 
   {{0xdb1c2af5,0x6e2c2dee,0x6aa80427,0xdd900137}},	//   rapá, mjab, _čefu, _ووپ_, 
   {{0xdb1c2def,0xf9902df0,0x6d4c01a4,0x00000000}},	//   sapá, سبن_, mzaa, --, 
   {{0x6d4c2df1,0xaa9400d6,0x6f14010a,0xdb4c0014}},	//   lzaa, _вивч, nvzc, _ہێے_, 
   {{0xe6182df2,0x6d4c2df3,0x6ab402d0,0x49b80133}},	//   тди_, ozaa, _itzf, _سارد_, 
   {{0xa4440019,0x6d4c2df4,0xf62800db,0xa5640101}},	//   инид, nzaa, اسىى_, جگان, 
   {{0x22a40374,0x25ac2df5,0x6d4c2df6,0x31182314}},	//   _hēki_, scel_, izaa, दिनः_, 
   {{0x22480116,0x1cd80327,0x8c38002f,0x352802dd}},	//   впни_, _ཡྀན_, _rußl, _ەسىپ_, 
   {{0x6e2c22a9,0x62441bce,0x6d4c01a4,0x00000000}},	//   jjab, _sóob, kzaa, --, 
   {{0xcfb402a6,0xa0a42df7,0x6e2c2df8,0x644c03a2}},	//   _জয়ন, рагд, djab, _ïaio, 
   {{0x6d4c0196,0x26180b03,0x7e9c2df9,0xae0401e0}},	//   dzaa, _मोती_, _pōpo, ҙоуҙ, 
   {{0xa2e42dfa,0x6d4c2d3a,0x645c2dfb,0x612c013d}},	//   _тойд, ezaa, ésiu, _bеlä, 
   {{0x7e640481,0xdee41ee3,0xdcb02dfc,0x6d4c01f5}},	//   unip, лоҳи, قىر_, fzaa, 
   {{0x7e642dfd,0x7afc0263,0x2714000f,0xdb0c067c}},	// [2a00] rnip, _sprt, _lān_, _nebò, 
   {{0x6e2c2dfe,0x0c2000f7,0x8c380112,0x00000000}},	//   ajab, омун, _fußm, --, 
   {{0x6d4c2dff,0x27140055,0x6e2c0055,0x00000000}},	//   azaa, _nān_, bjab, --, 
   {{0x63ac2e00,0x4e002e01,0x7e640309,0x6d4c0175}},	//   _şanl, _дзюб, qnip, bzaa, 
   {{0x39402e02,0xa3b405b5,0x22500306,0x2c100073}},	//   áis_, जडा_, ézky_, _डोकं_, 
   {{0xdb0c02e2,0xfaa401b9,0x81cc00eb,0x00000000}},	//   _debò, _هجری, _লাফ_, --, 
   {{0x39402e03,0x683c0066,0x37c40184,0x1da82e04}},	//   šis_, _mèdh, _һәйб, _कलात, 
   {{0x26182e05,0xd62400c6,0xceb005d0,0x00000000}},	//   _मोदी_, شعبي, חיה_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x07a00117,0x6e2c031c,0x00000000,0x00000000}},	//   _дафн, zjab, --, --, 
   {{0x22480054,0x6d4c2e06,0x74142e07,0x7980015d}},	//   _ŋaka_, zzaa, لوکا, _hymw, 
   {{0xdb1c2e08,0xdec802d3,0x6f080210,0x00000000}},	//   mapä, ጽእን_, łeck, --, 
   {{0xdb1c2e09,0x51842e0a,0x34b42e0b,0x645c004e}},	//   lapä, руна, _امتز, èsic, 
   {{0xdb1c0137,0x645c004a,0x853802e4,0x161c02e5}},	//   capç, ésit, _בגדי, भाकर_, 
   {{0x24982e0c,0xdb1c2e0d,0x6e2c2519,0xc324007b}},	//   ïsme_, napä, tjab, _نكون_, 
   {{0x11e8092f,0x6d4c0d27,0x2370002d,0x42c400d1}},	//   _شعبي_, tzaa, ûzje_, _өгән_, 
   {{0x6e2c2e0e,0xdb1c007d,0x7980002d,0xbca80131}},	// [2a10] rjab, hapä, _nymw, ۇدەك_, 
   {{0x6d4c0936,0x29e40943,0xdb1c2e0f,0x6e2c01c6}},	//   rzaa, _ḓa_, kapä, sjab, 
   {{0x6d4c2e10,0xddd400bc,0x612c0139,0xa91c00d7}},	//   szaa, slyš, _tеlä, _myže, 
   {{0x6d4c01f5,0x80a4135f,0xdb1c0037,0xddd400c0}},	//   pzaa, _دمین, dapä, plyš, 
   {{0x81d411ba,0x79800368,0x1dc01945,0x090400cf}},	//   স্ক_, _cymw, _хөсн, рчем, 
   {{0xefd40092,0x00000000,0x00000000,0x00000000}},	//   ራቸዉ_, --, --, --, 
   {{0x3950013f,0xa9080451,0x00000000,0x00000000}},	//   _ɑnsɑ_, ئيڪل_, --, --, 
   {{0x81cc1d4c,0x683c19c6,0x62540024,0x271400b8}},	//   _লাভ_, _mèdi, ršok, _vān_, 
   {{0x798000a9,0xdb1c2e11,0x67d400ee,0x6498084c}},	//   _gymw, tapç, _гозу, лтор_, 
   {{0xe4482dfc,0x27140882,0x290c2e12,0xa4440117}},	//   الدى_, _tān_, _isea_, снод, 
   {{0x21a4191e,0x24480174,0x38600ba1,0xa91c0432}},	//   йинм, _rúmd_, èire_, _wyžd, 
   {{0x76402e13,0xb3842e14,0xf77018fd,0xa91c0419}},	//   ckmy, өлөл, _غال_, _tyžd, 
   {{0x645c2e15,0xf67419f9,0xf6500228,0x00000000}},	//   ésis, _بالخ, _تئل_, --, 
   {{0x4aa40073,0x73c400f7,0x00000000,0x00000000}},	//   गदाव, _ۇيۇم, --, --, 
   {{0x6440002f,0x00000000,0x00000000,0x00000000}},	//   mkli, --, --, --, 
   {{0x290c2e16,0xfe78104b,0x1d082e17,0x8c38002f}},	//   _osea_, рүм_, леби_, _fußk, 
   {{0xdc680323,0x9f5802b5,0xcfe002f5,0x64402e18}},	// [2a20] гаад_, _hapü_, য়জন, okli, 
   {{0xefd40201,0x64402e19,0x7980017a,0xdb1c0309}},	//   ራቸው_, nkli, _rymw, yapä, 
   {{0x64402e1a,0x290c0b23,0x79800175,0xcee001ec}},	//   ikli, _asea_, _symw, _нұрқ, 
   {{0x290c0048,0xbb300e2c,0xdb1c00c5,0x64402e1b}},	//   _bsea_, ﻪﺳﻰ_, vapä, hkli, 
   {{0x64402e1c,0xd7f82e1d,0x2cd401b9,0x00000000}},	//   kkli, гуй_, _мюрр, --, 
   {{0xaad000e1,0xfc4401ed,0xdb1c023a,0xb9002e1e}},	//   _हिचक, _بھرپ, tapä, _थि_, 
   {{0x6440049f,0x290c1140,0x261805b5,0x01e00349}},	//   dkli, _esea_, _मोही_, য্যদ, 
   {{0xd1dc2e1f,0x64402e20,0x9f5800e4,0xc6f412c4}},	//   ንቦት_, ekli, _hapó_, ёных_, 
   {{0xdb1c2e21,0xd498013e,0x26c40042,0x64402e22}},	//   sapä, лро_, _ewlo_, fkli, 
   {{0x9f580137,0x15e81d8a,0xdb1c2e23,0xb3c8015b}},	//   _japó_, _टावर_, papä, _শাহজ, 
   {{0x6d400cc1,0x9f5800e4,0xe87401b9,0xa91c0306}},	//   _əlaq, _papý_, _بنلگ, _vyže, 
   {{0x64402e24,0x9f5807c5,0x683c004e,0x3ce00174}},	//   akli, _dapü_, _rèdi, kriv_, 
   {{0x6440005c,0x683c0100,0x867808d8,0xc0d80092}},	//   bkli, _sèdi, _גראו, _ይባል_, 
   {{0x64402e25,0x683c0100,0x50642e26,0x53940023}},	//   ckli, _pèdi, стма, _መሓዙት_, 
   {{0xc0581ed2,0x3ce0000d,0x00000000,0x00000000}},	//   сія_, eriv_, --, --, 
   {{0x683c0100,0x60d8007f,0x069007d2,0x00000000}},	//   _vèdi, ņtma, _ﺟﺎﻟﯩ, --, 
   {{0x8d8401b9,0x00000000,0x00000000,0x00000000}},	// [2a30] сувд, --, --, --, 
   {{0x9f582e27,0x7f54001f,0x99b80154,0x00000000}},	//   _capó_, ሙያዎች, ুলোক, --, 
   {{0xa91c0427,0xfbd0007b,0x29d42e28,0x00000000}},	//   _izži, عتك_, قياس, --, 
   {{0x64402e29,0xa2bc2e2a,0x00000000,0x00000000}},	//   zkli, वीट्, --, --, 
   {{0x64402e2b,0x00000000,0x00000000,0x00000000}},	//   ykli, --, --, --, 
   {{0x8aa40577,0xe7382e2c,0x68442e2d,0x00000000}},	//   _град, иел_, юнла, --, 
   {{0x81d40d42,0x24780023,0x62540419,0x00000000}},	//   স্ট_, _ብፖሊስ_, mšov, --, 
   {{0x625402fb,0x5690041b,0x00000000,0x00000000}},	//   lšov, мајт, --, --, 
   {{0x89342e2e,0xe9d80034,0x60c0025c,0x290c01f4}},	//   _اعزا, _idź_, _ħomo, _usea_, 
   {{0xf9902e2f,0x26181889,0x64402e30,0x62542e31}},	//   _سبق_, _मोरी_, ukli, nšov, 
   {{0x64402e32,0xa2282b97,0x074401c6,0x645c0129}},	//   rkli, ажна_, _ухам, ésiq, 
   {{0x64402e33,0x62582e34,0x36d401c6,0x00000000}},	//   skli, ррор_, _хоцр, --, 
   {{0xa2d42e35,0x20882e36,0x00000000,0x00000000}},	//   _भिक्, ийми_, --, --, 
   {{0x625400d0,0xe7ec2e37,0x00000000,0x00000000}},	//   jšov, च्चा_, --, --, 
   {{0x7e9c00b0,0x8fa02e38,0x9e58039b,0x4fa000a7}},	//   _hōpi, даре, араф_, дирв, 
   {{0x7e9c0374,0xb8fc0135,0x3f8400e2,0x1e84109a}},	//   _kōpi, _རྗ_, āmu_, ілам, 
   {{0x9f58067c,0xdbc82e39,0x00000000,0x00000000}},	// [2a40] _papó_, игад_, --, --, 
   {{0x62842e3a,0x81b00198,0x9f580268,0x2a6c003e}},	//   llko, _daɓe, _dapò_, _ajeb_, 
   {{0xe7ec2e3b,0xdb0c01b8,0x3f8c00c5,0xa2bc2e3c}},	//   च्छा_, _lebö, üdud_, वीच्, 
   {{0x94080134,0x625400d7,0x5984011c,0xaac40472}},	//   _ɔmɑn_, ašov, олеб, ستمن, 
   {{0xa3e82413,0xc2140134,0x9f582e3d,0xabd40116}},	//   यला_, _nkɔm_, _tapó_, ززەت, 
   {{0xa3e40cb4,0x62841196,0x00000000,0x00000000}},	//   _फाग_, hlko, --, --, 
   {{0x81b00c09,0x38c82e3e,0xcb640354,0x00000000}},	//   _zaɓe, _گازی_, _даре_, --, 
   {{0x624400e8,0x62842611,0xdb1c00e4,0x8f9800d9}},	//   _sóon, jlko, kapú, סיקי, 
   {{0xd4042e3f,0x97d801e2,0x00000000,0x00000000}},	//   ояни, _نظار_, --, --, 
   {{0xb35400d6,0x62842e40,0x645c0098,0x00000000}},	//   зкош, elko, ésip, --, 
   {{0x683c00db,0x00000000,0x00000000,0x00000000}},	//   _cèdu, --, --, --, 
   {{0xb9e40125,0x8c380112,0x06b40133,0xd5d4030d}},	//   _ያን_, _fußw, _بچوک_, _хiам, 
   {{0xdb0c014a,0x62540122,0xd4680139,0x5468014b}},	//   _gebö, yšov, _киде_, _кадм_, 
   {{0x9f580699,0x62842e41,0x74142e42,0x00000000}},	//   _rapò_, alko, _روبا, --, 
   {{0x62440de2,0x38b008c2,0x628402fb,0x00000000}},	//   _kóol, _làr_, blko, --, 
   {{0x2cb82e43,0xa91c012c,0x9f580ca8,0xf4840133}},	//   _ptsd_, _lyža, _papò_, _باڵی, 
   {{0x62440694,0xebd801a9,0xad400372,0x00000000}},	// [2a50] _móol, йдаш_, رۉسۉ, --, 
   {{0x64dc05ba,0x70542e44,0x8b440b24,0x00000000}},	//   _मिसळ, _رنجا, يضان, --, 
   {{0x62540e9a,0x2bdc0118,0x00000000,0x00000000}},	//   ršov, मणबा, --, --, 
   {{0xc33004ac,0x38b001ab,0x2fd0026c,0x60d400e4}},	//   ווע_, _bàr_, lazg_, _yvym, 
   {{0x4054006c,0x38b001c3,0x62540122,0x00000000}},	//   _رئیس, _càr_, pšov, --, 
   {{0x38b001ab,0x7e9c02b1,0x2fd02e45,0x244800c7}},	//   _dàr_, _rōpi, nazg_, _oúma_, 
   {{0xe7382e46,0x3ffc04ac,0x37a82e47,0x6244002e}},	//   сей_, יפגע, әтән_, _bóol, 
   {{0x62440de2,0xc95807d6,0x38b001ab,0x00000000}},	//   _cóol, _кўз_, _fàr_, --, 
   {{0x29180407,0x38b001ab,0x00000000,0x00000000}},	//   _ésa_, _gàr_, --, --, 
   {{0x67d4009d,0x6284031c,0x00000000,0x00000000}},	//   _хожу, wlko, --, --, 
   {{0x2bfc01ad,0x4de8012c,0xe718007b,0x60d401ef}},	//   र्यू_, टलाई_, _ديات_, _svym, 
   {{0x64c400b2,0xdb1000dd,0x683c026c,0x7e9c0374}},	//   _فيصل, égév, _vèdu, _tōpi, 
   {{0x66082e48,0xd24c0592,0xe2980116,0xf124009d}},	//   meek, انُ_, _һак_, мьёо, 
   {{0xa3e40d1a,0x62840165,0xa878010f,0x60c0010e}},	//   _फाट_, slko, מאָר, _çomm, 
   {{0x44242e49,0xa91c00ef,0x00000000,0x00000000}},	//   _inn_, _izžu, --, --, 
   {{0x6244002e,0x66082e4a,0x442400a3,0xd24c00c6}},	//   _kóom, neek, _hnn_, _منى_, 
   {{0xdb1c03b2,0x00000000,0x00000000,0x00000000}},	// [2a60] lapø, --, --, --, 
   {{0x44242e4b,0x66082e4c,0x4c8006ed,0x2fd001a6}},	//   _jnn_, heek, елув, cazg_, 
   {{0x66082e4d,0x10380375,0x442401ab,0x20e003b2}},	//   keek, _הגיע, _mnn_, _fæið_, 
   {{0xdca42e4e,0x20082e4f,0x66082e50,0x442401ab}},	//   _нами, lebi_, jeek, _lnn_, 
   {{0x44241675,0xbc742e51,0xa91c0122,0x66082e52}},	//   _onn_, _قۇرب, _pyža, deek, 
   {{0x20082e53,0x8c0800eb,0xaac40137,0xd7f801c4}},	//   nebi_, রাউন_, ستۅن, ёул_, 
   {{0xa91c0232,0x1c0003f3,0x7bdc2e54,0x6608011f}},	//   _vyža, _रॉयल_, _idru, feek, 
   {{0x44242e55,0x624400e8,0x15b02e56,0xd4982e57}},	//   _ann_, _bóom, رەتس, әри_, 
   {{0x48e02e58,0x94842e59,0x20082e5a,0x44242e5b}},	//   _потв, зынд, kebi_, _bnn_, 
   {{0x20081710,0x62441bce,0x44240f85,0x244801e7}},	//   jebi_, _wóol, _cnn_, _púma_, 
   {{0x7e9c0053,0x660824c1,0x44240036,0x2fd001a6}},	//   _hōpu, beek, _dnn_, vazg_, 
   {{0x44242e5c,0x7e9c0374,0x00000000,0x00000000}},	//   _enn_, _kōpu, --, --, 
   {{0x20081246,0x95842e5d,0x81cc015b,0x6244002e}},	//   febi_, _элде, _লাশ_, _góom, 
   {{0x44242e5e,0x7bdc2e5f,0xc05802d5,0xdb1c00e4}},	//   _gnn_, _ndru, піс_, sapù, 
   {{0x6254000a,0xff042607,0x8c3803fa,0x2fd0107d}},	//   tšot, нятн, _mußt, razg_, 
   {{0x7bdc2e60,0xade800f2,0x1ee800f2,0x00000000}},	//   _adru, تفرم_, توفی_, --, 
   {{0x20082e61,0x62542ba4,0x2bb805d7,0x44240042}},	// [2a70] bebi_, ršot, इडला, _ynn_, 
   {{0x66082e62,0x20082e63,0x62700421,0x44240fac}},	//   zeek, cebi_, māoa, _xnn_, 
   {{0x81b00b45,0x7bdc03cb,0x66082e64,0x24bc0154}},	//   _haɓa, _ddru, yeek, _ইয়াহ, 
   {{0x81b00198,0x7bdc036e,0x66082e65,0x00000000}},	//   _kaɓa, _edru, xeek, --, 
   {{0x66082e66,0x8d841f10,0xf9902e67,0xcc8403e6}},	//   veek, _хунд, هبه_, _فۆره_, 
   {{0x66082e68,0x81b003f9,0xef3402dd,0x00000000}},	//   week, _maɓa, _ءﯨﺸﯩ, --, 
   {{0x66080c8a,0xba281066,0x645c2e69,0x442401bf}},	//   teek, تسەم_, èsim, _rnn_, 
   {{0x7bdc2e6a,0xdb242e6b,0xe5a404a9,0x4424058a}},	//   _zdru, _توفی, мийи, _snn_, 
   {{0x66082e6c,0x20081aac,0x81cc00bd,0x8c38002f}},	//   reek, yebi_, _লাল_, _fußt, 
   {{0x66082e6d,0x291c2e6e,0xe3b000c6,0x99940050}},	//   seek, mvwa_, خرة_, _کھۅر_, 
   {{0x6e280428,0x4424004d,0xa348109a,0xa5f8003b}},	//   _òebw, _vnn_, ізма_, _межу_, 
   {{0xf7482e6f,0x20081992,0x44240a4e,0x1fc41025}},	//   _علني_, webi_, _wnn_, वर्ड, 
   {{0x24182e70,0x20082e71,0x367000db,0x291c0100}},	//   _моды_, tebi_, _حۇيز, nvwa_, 
   {{0xa91c0122,0x6720110c,0x10a0022e,0xe3640fac}},	//   _lyžo, _krlj, киян, _окли, 
   {{0x20082e72,0x10a02e73,0x00000000,0x00000000}},	//   rebi_, тирн, --, --, 
   {{0x20082e74,0x672005ce,0xbf2801e1,0xfaf80421}},	//   sebi_, _mrlj, _aṣòr, _īī_, 
   {{0x81b002a8,0x20080521,0x6294022e,0xd598010f}},	// [2a80] _gaɓa, pebi_, _ihyo, ַבעל, 
   {{0x1da802e5,0x291c1cea,0x67200841,0xbd44004b}},	//   _कलकत, dvwa_, _orlj, ونځي, 
   {{0x81b00b45,0x712401d5,0xddc4005b,0x00000000}},	//   _zaɓa, _قریل, _обни, --, 
   {{0x7e9c0418,0x5334008f,0x9f9400c7,0xb9b42099}},	//   _pōpu, ונען_, _ныҟә, رمتع, 
   {{0x7e642e75,0x00000000,0x00000000,0x00000000}},	//   miip, --, --, --, 
   {{0x7bdc04b9,0x9f48006a,0x7e642e76,0x672007f5}},	//   _udru, ngbï_, liip, _brlj, 
   {{0x7c3c12ef,0x169401d9,0x00000000,0x00000000}},	//   _iorr, وٕتھ_, --, --, 
   {{0x7e642e77,0x67201050,0x7c3c2e78,0x7e9c02b1}},	//   niip, _drlj, _horr, _tōpu, 
   {{0x7c3c2e79,0x6244002e,0x04140011,0x81b400eb}},	//   _korr, _tóoj, তানী_, টরা_, 
   {{0x7c3c2e7a,0x9f580022,0x672008a4,0x7e642e7b}},	//   _jorr, _hapõ_, _frlj, hiip, 
   {{0x78a80472,0x81b00b45,0x6244002e,0xe7d4036b}},	//   _iidv, _saɓa, _góok, _سمنگ, 
   {{0x7c3c2e7c,0x63ac2e7d,0x68ec0006,0xa91c0219}},	//   _lorr, _şant, žodž, _izžr, 
   {{0x62940280,0x7e64022f,0x7c3c2e7e,0x00000000}},	//   _dhyo, diip, _oorr, --, 
   {{0x78a80356,0x00000000,0x00000000,0x00000000}},	//   _jidv, --, --, --, 
   {{0x627006c8,0x78a82e7f,0x291c004c,0x4ea42e80}},	//   māon, _midv, zvwa_, драа, 
   {{0x78a82e81,0x81b00b45,0x7e6420ac,0x026800fd}},	//   _lidv, _taɓa, giip, _ошый_, 
   {{0x4fc42e82,0x7c3c2e83,0xa91c2e84,0x78a8035a}},	// [2a90] _осна, _borr, _ryžo, _oidv, 
   {{0x6f040016,0x09d40490,0xe54400d8,0x22902e85}},	//   _tphc, डण्य, écéé, máka_, 
   {{0x7c3c2e86,0x22902358,0x7e642e87,0x00000000}},	//   _dorr, láka_, biip, --, 
   {{0x7c3c0076,0x625401fa,0x6d342e88,0x291c02e2}},	//   _eorr, nšop, _земф, tvwa_, 
   {{0x6e3c2e89,0x78a82e8a,0x672008a4,0xdd900451}},	//   _iosb, _bidv, _srlj, _موٽ_, 
   {{0x7c3c2e8b,0x67200b91,0x6e3c2e8c,0x78a80055}},	//   _gorr, _prlj, _hosb, _cidv, 
   {{0x6e3c0660,0x5b00004b,0x86340023,0x8c380112}},	//   _kosb, _مېلم, _ኤለክት, _fußr, 
   {{0x7c3c2e8d,0x6e3c0455,0xfbd001d9,0xf7702e8e}},	//   _zorr, _josb, _متہ_, جاه_, 
   {{0x6e3c0240,0x6294164b,0x2290022a,0x00000000}},	//   _mosb, _rhyo, jáka_, --, 
   {{0x870425aa,0x6e3c2e8f,0x672005ce,0x62940526}},	//   _يبال, _losb, _trlj, _shyo, 
   {{0x63ac2e90,0x62642e91,0x6aa82e92,0x6e3c062c}},	//   _şans, евна, _kief, _oosb, 
   {{0x7e640109,0x6e3c2e93,0xf0880375,0x244801e1}},	//   xiip, _nosb, _הנ_, _túmo_, 
   {{0xc5682ad5,0x7e640108,0x00000000,0x00000000}},	//   _بحال_, viip, --, --, 
   {{0x6aa82e94,0xdfd0007b,0x718000c7,0x61280092}},	//   _lief, طير_, рқье, ድሞቻች, 
   {{0x66182e95,0xfe780372,0x343801d9,0x6e3c2e96}},	//   _kawk, дүн_, _تسند_, _bosb, 
   {{0x7c3c2e97,0x6aa82e98,0x6e3c2e99,0x629400b5}},	//   _sorr, _nief, _cosb, _uhyo, 
   {{0x9c242e9a,0x66182e9b,0x6e3c00a9,0x644c03a2}},	// [2aa0] ндад, _mawk, _dosb, _ïais, 
   {{0xdca42e9c,0x7c3c2e9d,0x6e3c009a,0x6618183a}},	//   хази, _qorr, _eosb, _lawk, 
   {{0xd1d4067d,0x7c3c2e9e,0x6e3c0333,0xf3f41c82}},	//   _ክሳብ_, _vorr, _fosb, _অসমৰ_, 
   {{0x78a82e9f,0x81b00198,0x20182ea0,0xdb1c01b8}},	//   _sidv, _maɓo, _hapi_, mapü, 
   {{0x20182ea1,0xc98004a9,0xdb1c2ea2,0x5f742ea3}},	//   _kapi_, луши, lapü, _زاگر, 
   {{0x20182ea4,0x75242ea5,0x6aa80fac,0x78a80477}},	//   _japi_, _šizo, _eief, _qidv, 
   {{0x6aa808f5,0x20182ea6,0x78a82ea7,0xda642ea8}},	//   _fief, _mapi_, _vidv, _كاري, 
   {{0x66182ea9,0x20182eaa,0x6aa80089,0x78a8003b}},	//   _cawk, _lapi_, _gief, _widv, 
   {{0x1cac2eab,0x9f48006a,0xa4f42eac,0x78a82ead}},	//   _ནངས_, ngbâ_, نکور_, _tidv, 
   {{0x61f42eae,0x201800dd,0x229002fb,0xdb1c2eaf}},	//   _acyl, _napi_, váka_, kapü, 
   {{0x62541ebd,0x6618039a,0x461000aa,0xdb1c014a}},	//   tšop, _fawk, _څومر, japü, 
   {{0x2018079b,0xdb1c2eb0,0x66181605,0x229023d1}},	//   _aapi_, dapü, _gawk, táka_, 
   {{0x26182871,0xeb0c27c6,0xdb1c0022,0x00000000}},	//   _मोटी_, _सन्त_, vapý, --, 
   {{0x20181022,0xdb1c014a,0x22902eb1,0x6e3c2eb2}},	//   _capi_, fapü, ráka_, _sosb, 
   {{0x2018060a,0x6e3c2eb3,0x81b003f9,0x229002f0}},	//   _dapi_, _posb, _gaɓo, sáka_, 
   {{0x20180a73,0x9f580100,0x6e3c0455,0xdb1c00e4}},	//   _eapi_, _rapô_, _qosb, hapó, 
   {{0x31342eb4,0x6aa82eb5,0x7db400c6,0x6e3c017a}},	// [2ab0] _репр, _rief, اصفا, _vosb, 
   {{0x20182eb6,0xdfd005d9,0x6aa80042,0xdb1c0588}},	//   _gapi_, _پيٽ_, _sief, japó, 
   {{0xdb1c00c7,0x6e3c2eb7,0xa91c00d7,0x6aa80171}},	//   papý, _tosb, _vyžm, _pief, 
   {{0x2018009d,0x8a400133,0x244802d2,0x00000000}},	//   _zapi_, دێرن, _rúmm_, --, 
   {{0x20182eb8,0x6aa80158,0x66180072,0x8c380112}},	//   _yapi_, _vief, _rawk, _fußp, 
   {{0xd9402eb9,0x66182eba,0x2018005a,0xdb1c00c7}},	//   реши, _sawk, _xapi_, gapó, 
   {{0x6aa80730,0x66182ebb,0xe3b0221d,0x9ba000f7}},	//   _tief, _pawk, یرد_, _نەكى, 
   {{0x66182b34,0x00000000,0x00000000,0x00000000}},	//   _qawk, --, --, --, 
   {{0xdb0c145e,0x74f805f5,0x81b003f9,0x09d402f5}},	//   _ngbê, нээс_, _saɓo, _হাপা, 
   {{0x61f428a5,0x6aa80064,0x5eac00d1,0x00000000}},	//   _scyl, _čefy, _ﻳﺎﯞﺭ, --, 
   {{0x20182ebc,0x661802d1,0x26c002f0,0x7c2802d2}},	//   _rapi_, _tawk, íhod_, _ódre, 
   {{0x21682ebd,0x20182ebe,0x661802d0,0xe2980120}},	//   дими_, _sapi_, _uawk, ќам_, 
   {{0x20182ebf,0x2934010f,0xe53402e8,0x00000000}},	//   _papi_, דאָן_, _шедь, --, 
   {{0x61f40a73,0x63842ec0,0xdb1c0793,0xd24c004b}},	//   _wcyl, _игла, tapü, منۍ_, 
   {{0x627816c3,0x20182ec1,0x8c38002f,0x09d40154}},	//   _осиё_, _vapi_, _rußp, _হানা, 
   {{0x20182ec2,0x2ee40008,0x61f402d0,0xe124022e}},	//   _wapi_, álfa_, _ucyl, _амии, 
   {{0x20182ec3,0x6b9402d0,0xe7d00ce0,0xdb1c00e4}},	// [2ac0] _tapi_, _azzg, हराप, japò, 
   {{0xefd40020,0xd00c00db,0x00000000,0x00000000}},	//   ያቸው_, _ۇلۋ_, --, --, 
   {{0x22900022,0x00000000,0x00000000,0x00000000}},	//   náko_, --, --, --, 
   {{0x27e803f9,0x5e600137,0x656c0419,0x00000000}},	//   ɗani_, _ئچسە, _ľahn, --, 
   {{0x3ea02ec4,0xd860035b,0x499015cf,0xd8382ec5}},	//   mmit_, аҵаҩ, һшәт, дэй_, 
   {{0x3ea02ec6,0xb7d800c6,0x51580375,0x36d4004e}},	//   lmit_, روبا_, וכנו, гокр, 
   {{0x8c1805d0,0xde3c0092,0x00000000,0x00000000}},	//   _קולי, _ያከናው, --, --, 
   {{0x3ea00d04,0x80b802f5,0x4664008e,0x5ee8012c}},	//   nmit_, _অবন্, крым_, _छिन्_, 
   {{0x3ea02ec7,0xdb1c067c,0x3afc0139,0x00000000}},	//   imit_, capò, líp_, --, 
   {{0x3ea02ec8,0x73382ec9,0x2874030d,0x74342ec9}},	//   hmit_, езор_, _йыхр, уноф, 
   {{0x22500660,0x3ea0011f,0x25bc0042,0x56f002dd}},	//   _blyk_, kmit_, _ffwl_, _түйс, 
   {{0x3ea0016d,0x55042eca,0x00000000,0x00000000}},	//   jmit_, _ачка, --, --, 
   {{0x81cc09bd,0x88c4002b,0x09d40011,0xd3240022}},	//   _লাখ_, _gośī, _হামা, хьҿи, 
   {{0x3ea00429,0x00000000,0x00000000,0x00000000}},	//   emit_, --, --, --, 
   {{0x40342ecb,0x42540014,0x645c0ea0,0xc05800d4}},	//   шерс, _چۆپر, ësie, тія_, 
   {{0x02a42ecc,0x3ea02ecd,0x645c005f,0xdb0c0241}},	//   _крым, gmit_, īsie, _igbè, 
   {{0x8d8401d5,0x00000000,0x00000000,0x00000000}},	// [2ad0] тувд, --, --, --, 
   {{0x3ea02ece,0x06e00154,0x00000000,0x00000000}},	//   amit_, _মহসি, --, --, 
   {{0xe81c2ecf,0x3ea00fa9,0x09d4009e,0x2250010e}},	//   _योगा_, bmit_, _হাবা, _ylyk_, 
   {{0x3ea00276,0xcd04010b,0xa6c400d1,0xa908007b}},	//   cmit_, _ичги, ۇقتى, فيصل_, 
   {{0x656c0419,0x7f84114f,0x00000000,0x00000000}},	//   _ľaho, _ملین, --, --, 
   {{0xdb1c007f,0x00000000,0x00000000,0x00000000}},	//   rapò, --, --, --, 
   {{0x27e82ed0,0x8aa42ed1,0x8a4004d3,0x998400fb}},	//   ğan_, _арад, _پێشن, ктәһ, 
   {{0x27e82ed2,0xa91c01f1,0x65780175,0x00000000}},	//   şan_, _lyži, _pxwh, --, 
   {{0xa5642ed3,0x69d82ed4,0xdb0c0cad,0xe508004b}},	//   دگان, mawe, _agbè, ريدو_, 
   {{0x3ea0044e,0x69d82ed5,0x22502694,0x00000000}},	//   zmit_, lawe, _slyk_, --, 
   {{0x3ea02ed6,0xe364022e,0x00000000,0x00000000}},	//   ymit_, укни, --, --, 
   {{0x69d800b2,0xddd40232,0x244801e1,0xa4d400d4}},	//   nawe, chyň, _múmi_, _боді, 
   {{0xdb0c0241,0xd5ac2ed7,0xa5082ed8,0x00000000}},	//   _egbè, _عفو_, _чела_, --, 
   {{0x69d82ed9,0xa0682eda,0x244800e4,0x81cc00fe}},	//   hawe, хага_, _oúmi_, _লাও_, 
   {{0x69d82edb,0x2eb42edc,0x37d8015b,0x3ea02edd}},	//   kawe, истс, _সামর, tmit_, 
   {{0x3ea02ede,0x69d82edf,0xdee4024c,0xe6d000bc}},	//   umit_, jawe, коҳи, _सबैज, 
   {{0x69d82ee0,0x3ea02ee1,0x6244002e,0xdb0c01e1}},	// [2ae0] dawe, rmit_, _dóot, _igbé, 
   {{0x62842ee2,0x3ea02ee3,0xa3e802a0,0x46b000bc}},	//   loko, smit_, यलट_, ँदाह, 
   {{0x3ea02ee4,0x69d80009,0xa2e000fe,0x5f44007b}},	//   pmit_, fawe, _বহুখ, _إنجل, 
   {{0x24842ee5,0x62842ee6,0x69d82ee7,0x6ab40369}},	//   holm_, noko, gawe, _duzf, 
   {{0x18682ee8,0x6284009f,0x9f8c000d,0xed341de6}},	//   нади_, ioko, rõõm_, _кэрэ, 
   {{0x62842ee9,0xf70807a5,0x00000000,0x00000000}},	//   hoko, вфиқ_, --, --, 
   {{0x69d82eea,0xdb0c01e1,0x00000000,0x00000000}},	//   bawe, _ogbé, --, --, 
   {{0x62441bce,0x86200133,0xda70009f,0x00000000}},	//   _xóot, یکۆل, _اُر_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xdb0c0248,0x98a400fd,0x00000000,0x00000000}},	//   _agbé, _сизе, --, --, 
   {{0x62842eeb,0x33940006,0x81cc04c5,0xd7bc002e}},	//   foko, ранё, _লাজ_, _l胃kk_, 
   {{0x62842eec,0x66800214,0xc05801ec,0x00000000}},	//   goko, _ویول, ңір_, --, 
   {{0x855401ed,0xc108008e,0x00000000,0x00000000}},	//   _میٹر_, лэре_, --, --, 
   {{0x69d82eed,0x24842cd8,0x645c020c,0xef540124}},	//   zawe, colm_, èsit, акгь, 
   {{0x62842eee,0x69d82eef,0xa91c2195,0xd36c0137}},	//   boko, yawe, _vyži, _رۇح_, 
   {{0x62842ef0,0x244808a7,0x2370045f,0x1c002ef1}},	//   coko, _rúmi_, úzje_, र्सल_, 
   {{0xe6d02cfd,0x69d8006f,0x32082ef2,0x00000000}},	// [2af0] _सब्ज, vawe, _ibay_, --, 
   {{0x69d82ef3,0x7bf82ef4,0xaed400cf,0x00000000}},	//   wawe, лнур_, _коош, --, 
   {{0x69d82ef5,0x9ce80014,0x60c000a2,0x6e94292c}},	//   tawe, _یوَے_, _çomr, _вину, 
   {{0x8d842ef6,0xeb040406,0x00000000,0x00000000}},	//   _бугд, _रहीत_, --, --, 
   {{0x69d82ef7,0x80a42ef8,0x32080694,0xa3e40037}},	//   rawe, _خمین, _mbay_, _बएल_, 
   {{0x62442ef9,0xb80001ad,0x627000b0,0x00000000}},	//   _jóor, ल्लम_, tāok, --, 
   {{0x69d82efa,0x62842efb,0x32082efc,0xbea80244}},	//   pawe, yoko, _obay_, _جهێن_, 
   {{0x628407a9,0x62440248,0x2bdc2efd,0x00000000}},	//   xoko, _lóor, मणका, --, 
   {{0x27b00131,0x24840254,0xe6100066,0x00000000}},	//   _һәқс, tolm_, مشک_, --, 
   {{0x62842efe,0x32082eff,0x290c0798,0x00000000}},	//   woko, _abay_, _ipea_, --, 
   {{0xe29815ed,0x6eb00406,0x78bc0010,0xf77000e5}},	//   као_, _आंगु, _črvi, _ٹال_, 
   {{0xe1242f00,0xf7702f01,0x67241141,0x00000000}},	//   амми, _عال_, åhju, --, 
   {{0x624401e1,0x161c1b51,0x84c40114,0x00000000}},	//   _bóor, _मोटर_, _сљед, --, 
   {{0x32082f02,0x70180845,0x5ed800eb,0xd78c0023}},	//   _ebay_, ліст_, বংসে, _ምንባራ_, 
   {{0x62842f03,0x624400e8,0xceb4004e,0x00000000}},	//   poko, _dóor, иштө, --, 
   {{0x13d82f04,0x62841cdf,0x290c0270,0x201c0024}},	//   _দায়, qoko, _opea_, žti_, 
   {{0x04f000cc,0x9d440114,0x00000000,0x00000000}},	// [2b00] _অনুৰ_, језд, --, --, 
   {{0x26c401af,0x624400e8,0x00000000,0x00000000}},	//   _otlo_, _góor, --, --, 
   {{0x32082f05,0x290c2f06,0x26c42f07,0x00000000}},	//   _ybay_, _apea_, _ntlo_, --, 
   {{0xdb1c2f08,0x38c80133,0xa91c02f0,0x00000000}},	//   kapö, هاتی_, _lyžu, --, 
   {{0x8914036b,0x98a42f09,0xdb1c01f4,0x00000000}},	//   لغوز_, аиде, japö, --, 
   {{0x986400dd,0x1c002f0a,0x00000000,0x00000000}},	//   جیئے_, र्शल_, --, --, 
   {{0x290c05f5,0xd5e0063f,0x46e40032,0x627002b1}},	//   _epea_, _nkọ, ңдән_, pāoh, 
   {{0x960802d5,0xd94400cf,0x422000cd,0x00000000}},	//   тэка_, _кеби, ययोः_, --, 
   {{0xd4982f0b,0x26c400fb,0xd90c2f0c,0xdb0c01bf}},	//   кро_, _etlo_, _آیت_, _afbø, 
   {{0x32080280,0x76d80117,0xb2e001ec,0x00000000}},	//   _sbay_, _будӣ_, _ﻋﻨﻭﺍ, --, 
   {{0x0bb4025f,0x6f08068f,0x78840014,0x84300212}},	//   ילים_, łecz, _پێژِ_, інює, 
   {{0x81b003f9,0xeeb82f0d,0x6244002e,0xe97000f7}},	//   _zaɓi, ғлаш_, _sóor, _بۇۇد, 
   {{0x660c2f0e,0xc6900375,0x00000000,0x00000000}},	//   _ñaka, _ואף_, --, --, 
   {{0x920000e2,0xdb1c0254,0x00000000,0x00000000}},	//   _šādo, lapõ, --, --, 
   {{0x4500081f,0x09d400bd,0xc438011a,0x00000000}},	//   _མདོར_, _হাসা, _בתגי, --, 
   {{0x81ac02a6,0xc5fc04c5,0x8778008f,0x6b740032}},	//   গড়_, ্যথা_, דאלי, ҡлау, 
   {{0x656c01a2,0x38a0067c,0x6244002e,0x8bb4007b}},	// [2b10] _ľahk, mòrf_, _tóor, لإضا, 
   {{0x8bc400c2,0x13d8015b,0xdb1c000d,0x8c5400db}},	//   рсад, _দাড়, hapõ, جئرا, 
   {{0x290c009f,0x2bc8012c,0x8aa4133a,0xdb1c0254}},	//   _spea_, ाँबा, ардд, kapõ, 
   {{0xdb1c0254,0x00000000,0x00000000,0x00000000}},	//   japõ, --, --, --, 
   {{0x6924036b,0xb9e802dd,0xdb1c0254,0x00000000}},	//   смла, рміз_, dapõ, --, 
   {{0x6d4c2f0f,0x26100051,0x7c84014b,0x00000000}},	//   myaa, _ạo_, _дусе, --, 
   {{0x6d4c2f10,0xb92001f2,0x612c0109,0x00000000}},	//   lyaa, _karị_, _kôlô, --, 
   {{0x80b803f4,0xb920063f,0xd704005b,0x6d4c0009}},	//   _অবস্, _jarị_, ёные_, oyaa, 
   {{0x6d4c2f11,0x81b003f9,0x2cb80036,0x290c2f12}},	//   nyaa, _taɓi, _jusd_, _upea_, 
   {{0x6d4c0014,0xdb1c2f13,0x00000000,0x00000000}},	//   iyaa, rapö, --, --, 
   {{0x6d4c2f14,0xdb1c0254,0xa91c0064,0x00000000}},	//   hyaa, bapõ, _vyžu, --, 
   {{0xb92000b4,0x6d4c0a49,0xeb0400c5,0x2448032e}},	//   _narị_, kyaa, _रहैत_, _rúmu_, 
   {{0xc5fc03d4,0x64c42f15,0x60642f16,0xa97800df}},	//   ্যদা_, _ايتل, йҗиң_, ראָכ, 
   {{0xa0742f17,0x6d4c2f18,0x461004fb,0xa0a401c6}},	//   сымш, dyaa, _دوچر, сагд, 
   {{0x6d4c01d9,0x8c380112,0x00000000,0x00000000}},	//   eyaa, _fußz, --, --, 
   {{0xdcb007a7,0x6d4c2f19,0xabd401ec,0x3ce00254}},	//   كىر_, fyaa, _ﺘﺩﺍﻋ, tsiv_, 
   {{0x6d4c2f1a,0xc2c000b2,0xdc7400c7,0x00000000}},	// [2b20] gyaa, _ايڊي, быжь, --, 
   {{0x3ce02f1b,0x2cb80175,0x649c0036,0xb0b4012d}},	//   rsiv_, _dusd_, bèie, ंदरग, 
   {{0x6d4c2f1c,0x158808b0,0x2cb80175,0x00000000}},	//   ayaa, ﺗﯩﺴﯩ, _eusd_, --, 
   {{0x6d4c2f1d,0xaa6400d4,0x79c801a9,0x00000000}},	//   byaa, отік, рқаб_, --, 
   {{0xdd902f1e,0xdcb00220,0xdb0c01e1,0x6d4c0067}},	//   _روس_, _ءىس_, _igbí, cyaa, 
   {{0x7d042f1f,0xb90000e1,0xa91c0024,0x9f48002e}},	//   mtis, _दब_, _ryžt, _ójóo_, 
   {{0x7d042f20,0x09d400bd,0x00000000,0x00000000}},	//   ltis, _হারা, --, --, 
   {{0x645c044e,0xceb00302,0x00000000,0x00000000}},	//   ësin, היה_, --, --, 
   {{0x7d042f21,0xdb1c000d,0xaa4801ee,0x00000000}},	//   ntis, rapõ, _тотҡ_, --, 
   {{0x7d042f22,0x33742f23,0x73d8013e,0xdb1c0254}},	//   itis, жгор, шдор_, sapõ, 
   {{0x7d042f24,0x81b003f9,0x244808a5,0x00000000}},	//   htis, _maɓu, _rúmt_, --, 
   {{0x7d0400ed,0x6d4c2f25,0xd06000ac,0x4b78010f}},	//   ktis, yyaa, ərəc, ראטו, 
   {{0x6d4c0050,0x51842f26,0x60d403cb,0xd38800ee}},	//   xyaa, суна, _cwym, _өйде_, 
   {{0x80b800bd,0x612c0109,0x60d40042,0x249401d9}},	//   _অবশ্, _sôlô, _dwym, _وۅٹھ_, 
   {{0x7d042f27,0x612c0109,0x63ac010f,0x6d4c0009}},	//   etis, _pôlô, _ĝang, wyaa, 
   {{0x7d042f28,0x3d14007d,0x8d8400f7,0x63ac0115}},	//   ftis, _नईखे_, бузд, _ŝang, 
   {{0xdb0c145e,0x6d4c0d04,0x7d042f29,0x60d4015d}},	// [2b30] _ngbâ, uyaa, gtis, _gwym, 
   {{0x6d4c2f2a,0x00000000,0x00000000,0x00000000}},	//   ryaa, --, --, --, 
   {{0xdb0c025a,0x6d4c2f2b,0x63ac0790,0x00000000}},	//   _agbâ, syaa, _şanz, --, 
   {{0x7d0403b2,0x02f8010f,0x00000000,0x00000000}},	//   btis, רלאמ, --, --, 
   {{0x7d042f2c,0x6d4c0cfe,0x627000b0,0x2cb00139}},	//   ctis, qyaa, māot, _tizd_, 
   {{0xd5e00241,0xdb1c0109,0xe9d8033f,0x69c800dc}},	//   _amò, tapô, _weź_, _ह्री, 
   {{0x70b40034,0x00000000,0x00000000,0x00000000}},	//   ंदुल, --, --, --, 
   {{0x81b003f9,0x24e82c31,0xb6580006,0x00000000}},	//   _zaɓu, амии_, йшых_, --, 
   {{0xe4582f2d,0x1fa42f2e,0xd5ac00aa,0x29182f2f}},	//   ижи_, _खण्ड, نځه_, _èsa_, 
   {{0x48742f30,0x38a0068c,0x60d4015d,0x244808ce}},	//   _ادرس, gòrd_, _rwym, _rúms_, 
   {{0x4f78001f,0x16040073,0xdb0c02d2,0x7d0401d3}},	//   _አቤቱታ_, व्हर_, _ofbý, ztis, 
   {{0x7d042f31,0xa3b412eb,0x00000000,0x00000000}},	//   ytis, _झलक_, --, --, 
   {{0x7d04003a,0x00000000,0x00000000,0x00000000}},	//   xtis, --, --, --, 
   {{0x66082f32,0x38a00ba1,0x65940022,0x00000000}},	//   lfek, còrd_, _лаҵу, --, 
   {{0xe2982f33,0x1fa82f34,0xc0e8001f,0x64400369}},	//   _как_, ркви_, ማየሁ_, mjli, 
   {{0x7d042f35,0xdbe02f36,0x38a0067c,0x60d4015d}},	//   ttis, खण्ड_, mòre_, _twym, 
   {{0x7d042f37,0xe0d000c6,0x66082f38,0x38a00ba1}},	// [2b40] utis, _غزة_, ifek, lòre_, 
   {{0x7d042f39,0x64400007,0xdce400de,0xeff80092}},	//   rtis, njli, _izkļ, ቋቸው_, 
   {{0x9f042f3a,0xda6402bf,0x00000000,0x00000000}},	//   _بوجو, овжи, --, --, 
   {{0x6080001f,0x76400175,0x19f40014,0x0b180154}},	//   _የቅጣት_, xjmy, زِتھ_, ণমূল_, 
   {{0xdca40372,0x81b003f9,0x7d042f3b,0x00000000}},	//   _мами, _taɓu, qtis, --, 
   {{0x66082f3c,0x229002f0,0xd6e800d8,0x00000000}},	//   efek, máku_, афил_, --, 
   {{0xc9600491,0x7bdc2f3d,0x229002fb,0x00000000}},	//   _ɑƞɑ_, _ieru, láku_, --, 
   {{0x7bdc2f3e,0x68ec0114,0xdb0c0241,0xa91c00d0}},	//   _heru, šada, _igbà, _vyžr, 
   {{0x7bdc2f3f,0xa90800eb,0x00000000,0x00000000}},	//   _keru, লিউড_, --, --, 
   {{0x3a242f40,0x7bdc2f41,0x248801e4,0x2dcc1884}},	//   _hamp_, _jeru, _ƭama_, _ﺑﯩﻠﻤ, 
   {{0x7bdc27ed,0xd5e80014,0xd1cc0023,0x229002f0}},	//   _meru, _نٹان_, ባራቱ_, háku_, 
   {{0x7bdc2f42,0x3a242f43,0x62841427,0x00000000}},	//   _leru, _jamp_, _íhol, --, 
   {{0x70b402a0,0xd49800d8,0x22900c5e,0x86780115}},	//   ंदेल, _крк_, jáku_, _דראו, 
   {{0x7bdc2f44,0x38a0067c,0x63ac01e4,0x3a24029d}},	//   _neru, bòre_, _ŝane, _lamp_, 
   {{0xb8fc081f,0xff042f45,0xcdd807fa,0x3a240156}},	//   _ཡས_, мятн, иња_, _oamp_, 
   {{0x7bdc2f46,0xb63c00b5,0xb3bc0154,0xfbd001d9}},	//   _aeru, _ｇｒ_, _আজিজ, ۆتم_, 
   {{0x7bdc2f47,0xdb0c0248,0x32180109,0x386c2f48}},	// [2b50] _beru, _agbà, mesy_, _omdr_, 
   {{0x7bdc2f49,0x32182f4a,0xfbd000c6,0xb8f40055}},	//   _ceru, lesy_, نتم_, _ceṭī, 
   {{0x7bdc2f4b,0x627004fe,0x649c0ba1,0xfe7000e5}},	//   _deru, māor, nèia, ردہ_, 
   {{0x321806d9,0x7bdc2f4c,0x3a240375,0xad400137}},	//   nesy_, _eeru, _camp_, _كۉزۉ, 
   {{0xcfa82f4d,0x7bdc2f4e,0x69340137,0x3a24045a}},	//   _حاکم_, _feru, янду, _damp_, 
   {{0xd82011ed,0x386c0618,0x321800e4,0xfeb81e4b}},	//   едши, _cmdr_, hesy_, _دایت_, 
   {{0x645c0023,0x00000000,0x00000000,0x00000000}},	//   ësim, --, --, --, 
   {{0x386c02fa,0x7bdc2f4f,0x32180109,0x3a242f50}},	//   _emdr_, _zeru, jesy_, _gamp_, 
   {{0x32180109,0x848402d3,0xdb0c0241,0x07180d2e}},	//   desy_, _ምእማን_, _igbá, _भैरव_, 
   {{0x7bdc056a,0x3a24107d,0x3914010b,0xfdb80807}},	//   _xeru, _zamp_, _юмур, _अल्फ, 
   {{0x3a240369,0xdbdc01e1,0x321805da,0x66082f51}},	//   _yamp_, _díèd, fesy_, pfek, 
   {{0x67200e3c,0x23c0032e,0x00000000,0x00000000}},	//   _islj, _bæjó_, --, --, 
   {{0x2a6c0134,0x55b80375,0x569808a8,0xf65000db}},	//   _mmeb_, _המנו, _פינצ, _جئل_, 
   {{0x394002f6,0x291c0e14,0x55500c75,0x2290022a}},	//   äisi_, iwwa_, _سپىر, váku_, 
   {{0x7bdc2f52,0x9f480158,0x68f801a4,0x91000014}},	//   _reru, ngbø_, huwd, وژیو, 
   {{0x22900306,0x32182f53,0x68f80432,0x00000000}},	//   táku_, cesy_, kuwd, --, 
   {{0x7bdc2f54,0x3a242f55,0xdd902f56,0xa06801f0}},	// [2b60] _peru, _ramp_, روط_, _гапа_, 
   {{0x3a241bce,0xdb0c0cad,0x229002fb,0x68f801f5}},	//   _samp_, _agbá, ráku_, duwd, 
   {{0x68f80196,0x1c000034,0xafc401ec,0x5018011a}},	//   euwd, र्गल_, _تيپى, _פוטו, 
   {{0x7bdc2f57,0xfe5801d5,0x645c0200,0x37d800cc}},	//   _weru, _بیرب_, ësij, _ঠাইৰ, 
   {{0x7bdc0092,0x3a242f58,0xf91804fb,0xd7e400d4}},	//   _teru, _vamp_, تراژ_, пійо, 
   {{0x3a241bb7,0xd6d8016c,0x7bdc16b8,0x1ae4013d}},	//   _wamp_, бти_, _ueru, _ногм, 
   {{0x6b9400ee,0x3a240356,0x88b001d5,0x00000000}},	//   _gyzg, _tamp_, ریمچ, --, 
   {{0x4b780375,0xd5642f59,0x00000000,0x00000000}},	//   _האלו, зтоп, --, --, 
   {{0x32180030,0xf42000fe,0x5fbc08df,0x993800d4}},	//   vesy_, বাসৰ_, ्डाल, _уяву_, 
   {{0xdecc0023,0xddc801ec,0x81b400eb,0xa17c0092}},	//   እለን_, _ﺑﯩﺰﺑ, য়রা_, _የንፁህ_, 
   {{0x32182f5a,0xa8440244,0x00000000,0x00000000}},	//   tesy_, _تکنۆ, --, --, 
   {{0x63ac008f,0xb9e40b82,0x15440329,0x145800c7}},	//   _ŝanc, _ካን_, _неем, ршҩы_, 
   {{0x32182f5b,0x627002b5,0xdb080162,0x00000000}},	//   resy_, tāor, _ónær, --, 
   {{0x32180170,0xf42000fe,0x04402f5c,0xddd42f5d}},	//   sesy_, বাহৰ_, _печн, lkyň, 
   {{0x98a4009b,0x842000db,0x00000000,0x00000000}},	//   jvoč_, _سىين, --, --, 
   {{0xddd400d0,0x55f80154,0x00000000,0x00000000}},	//   nkyň, _আসুক_, --, --, 
   {{0x7274044e,0x627002b5,0x2bc8012c,0x48d40154}},	// [2b70] _ብረታዊ_, pāor, ाँला, _সম্র, 
   {{0x649c0036,0x7c9400d1,0x00000000,0x00000000}},	//   hèin, ىشلا, --, --, 
   {{0xead8005e,0x69cc0428,0xe7a4005f,0x00000000}},	//   імді_, ñaeo, ādīš, --, 
   {{0xfaf02f5e,0x2ee401a8,0xe9740244,0x6e18009f}},	//   اثل_, álfu_, وهاد, _بيحس_, 
   {{0xddd40030,0x65e401ec,0x5ec00154,0x00000000}},	//   dkyň, _ﺍﺩﯨﻠ, ষীদে, --, 
   {{0xf7702f5f,0xe7380209,0x291c00ca,0xddd40210}},	//   گاه_, жек_, rwwa_, chył, 
   {{0xab9402bf,0x6ac401d5,0x660c0de2,0x00000000}},	//   _циві, _آقرم, _ñakk, --, 
   {{0x09d400eb,0x00000000,0x00000000,0x00000000}},	//   _হাকা, --, --, --, 
   {{0x69c80270,0x88d402f5,0x6cd40150,0x00000000}},	//   _ifee, _সমকক, _ﺘﺨﺯﻴ, --, 
   {{0x68e82f60,0x00000000,0x00000000,0x00000000}},	//   _ived, --, --, --, 
   {{0x1c000918,0x67202f61,0x68e8037e,0x5908031c}},	//   र्टल_, _uslj, _hved, _གདོས_, 
   {{0x68e82f62,0xe5e401d5,0x38a0180f,0x4428012d}},	//   _kved, _آزای, mòra_, śc_, 
   {{0x160410eb,0xc1780116,0x3f9c01ef,0x00000000}},	//   _वॉटर_, яҗи_, _švu_, --, 
   {{0x89200327,0xa0680166,0x00000000,0x00000000}},	//   _རླབྶ_, цага_, --, --, 
   {{0x44242558,0x28dc29c8,0x69c82f63,0xd0040b7e}},	//   _ian_, नीति, _ofee, ьере_, 
   {{0x44242f64,0x68e82f65,0x69c81418,0x4508031c}},	//   _han_, _oved, _nfee, _ཁྱོར_, 
   {{0x41b40014,0x38a0068c,0xb82400fe,0x9c242bcb}},	// [2b80] _سۅسر, hòra_, পাতত_, мдад, 
   {{0xee380364,0x69c82f66,0x44242f67,0xc0cc0092}},	//   онӣ_, _afee, _jan_, ባኛል_, 
   {{0x4424228f,0x68e82f68,0x2ee401a8,0x68ec0419}},	//   _man_, _aved, álft_, šadl, 
   {{0x44242f69,0x1c0007f7,0x00000000,0x00000000}},	//   _lan_, र्जल_, --, --, 
   {{0x4424193f,0x58842f6a,0xddd40419,0x38140108}},	//   _oan_, мыка, vkyň, емлё, 
   {{0x44242f6b,0xdca4152d,0x45081b4b,0x69c801af}},	//   _nan_, _цаги, _ཁྱེར_, _efee, 
   {{0x68e82f6c,0x69c80a49,0xddd400d7,0x2af40108}},	//   _eved, _ffee, tkyň, _пятё, 
   {{0x44242f6d,0xdecc0023,0x80d400eb,0x00000000}},	//   _aan_, እለና_, _তিন্, --, 
   {{0x44242f6e,0xddd42f6f,0xc6a000a7,0x73c401e0}},	//   _ban_, rkyň, ърши, нәйе, 
   {{0x44242f70,0x38a0067c,0xddd42f71,0x96b80064}},	//   _can_, bòra_, skyň, _дуду_, 
   {{0x44242f72,0x68e82f73,0xa2c005d7,0xddd40419}},	//   _dan_, _zved, _रूद्, pkyň, 
   {{0x44242f74,0x926802bf,0x00000000,0x00000000}},	//   _ean_, ірна_, --, --, 
   {{0x44242f75,0xe80403e5,0x68e800b5,0xc0c8084c}},	//   _fan_, _रामा_, _xved, дусе_, 
   {{0x44242f76,0xb6380150,0x00000000,0x00000000}},	//   _gan_, _ﺘﻅ_, --, --, 
   {{0x2bdc0490,0x50280023,0x00ac07d2,0xfbe400eb}},	//   यरसा, _ብዝከኣ, _ﺳﻮﺗﺘ, মলাত, 
   {{0x44242f77,0x6db42f78,0x00000000,0x00000000}},	//   _zan_, ейбу, --, --, 
   {{0x44242f79,0x62440694,0x00000000,0x00000000}},	// [2b90] _yan_, _nóoy, --, --, 
   {{0x44242f7a,0x69c80cf9,0x00000000,0x00000000}},	//   _xan_, _sfee, --, --, 
   {{0xdb0c006a,0xe9442f7b,0x59080327,0x00000000}},	//   _ngbä, کرای, _གདུས_, --, 
   {{0x37d8015b,0xdb0c01d3,0x2bdc012d,0x00000000}},	//   _সাগর, áján, यरहा, --, 
   {{0xe6ec01a2,0xcce40597,0xbd940046,0xd7ec2f7c}},	//   _väčš, _تسجي, _ақтө, ڭكى_, 
   {{0x3b3c0092,0x00000000,0x00000000,0x00000000}},	//   _በጋምቤ, --, --, --, 
   {{0x44242f7d,0x2d982d8b,0x00000000,0x00000000}},	//   _ran_, _hyse_, --, --, 
   {{0x2d982f7e,0x68e80b34,0xfaa400d1,0x4508031c}},	//   _kyse_, _tved, _ашун, _ཁྱུར_, 
   {{0xe57809fe,0x68e80e96,0x44242f7f,0x74f801c0}},	//   язи_, _uved, _pan_, мээс_, 
   {{0x44242f80,0x2d982f81,0x00000000,0x00000000}},	//   _qan_, _myse_, --, --, 
   {{0x44242f82,0xe2982f83,0x2d980e38,0x87042f84}},	//   _van_, зан_, _lyse_, _زبال, 
   {{0x44242f85,0x62440de2,0xdce400d7,0x00000000}},	//   _wan_, _jóox, _vykĺ, --, 
   {{0x44242f86,0xb6380150,0x00000000,0x00000000}},	//   _tan_, _ﺘﺅ_, --, --, 
   {{0x44242f87,0x645c0194,0x64a401c4,0x00000000}},	//   _uan_, êsid, _яала, --, 
   {{0x3d10013f,0x3228023a,0x2d982f88,0x68ec00e5}},	//   _yεwכ_, ötyä_, _ayse_, áadj, 
   {{0x2d980142,0xc2b42f89,0x00000000,0x00000000}},	//   _byse_, _шөпш, --, --, 
   {{0x6294014b,0x1278010f,0x00000000,0x00000000}},	// [2ba0] _ikyo, _מאקע, --, --, 
   {{0x61e42f8a,0x2d980450,0x00000000,0x00000000}},	//   lakl, _dyse_, --, --, 
   {{0x09d42f8b,0x20c4001e,0x62940083,0x6cd40150}},	//   _হাজা, _hôi_, _kkyo, _ﺘﻨﺼﻴ, 
   {{0x61e42f8c,0x2d980142,0x00000000,0x00000000}},	//   nakl, _fyse_, --, --, 
   {{0x9fe00154,0xd5b82f8d,0x00000000,0x00000000}},	//   বলীগ, үси_, --, --, 
   {{0xd6d82f8e,0x20c40016,0xe8042cce,0x61e42f8f}},	//   пти_, _môi_, _राणा_, hakl, 
   {{0x4c901d18,0x61e42f90,0x7e6403a2,0x20c4001e}},	//   _сиёс, kakl, ohip, _lôi_, 
   {{0xc214013f,0x7e6401f7,0x62941418,0x61e42f91}},	//   _nbɔ_, nhip, _nkyo, jakl, 
   {{0x61e42f92,0xd4042f93,0x20c401fb,0x5dd40150}},	//   dakl, няни, _nôi_, _ﺘﺘﻤﻴ, 
   {{0xc2140134,0x62942f94,0x1a6403e6,0x00000000}},	//   _abɔ_, _akyo, _تیڤی_, --, 
   {{0x7e642f95,0xd3782f96,0x61e42f97,0xd7040212}},	//   khip, ячи_, fakl, _їзди, 
   {{0xe6840032,0x20c42f98,0x64640055,0x00000000}},	//   _үҙәк_, _bôi_, _ātių, --, 
   {{0x7e640882,0x99900209,0xc68c13ea,0x0fe000f7}},	//   dhip, ýyň_, _اِن_, лөнү, 
   {{0x62942f99,0x1cdc031c,0x4508031c,0x657c002d}},	//   _ekyo, _ལྦེ_, _ཁྱིར_, úshe, 
   {{0x61e42f9a,0x8330082e,0xb8ec025c,0x2d9803cd}},	//   bakl, _مريض, _ྱང_, _syse_, 
   {{0x61e40365,0x7c3c0784,0x43980302,0x645c0023}},	//   cakl, _anrr, _מבוג, ësiv, 
   {{0x8d742f9b,0xa3cc07f7,0x614405a9,0x09bc00cc}},	// [2bb0] رارا, षुव_, _لىيە, _উজলা, 
   {{0xe80404fa,0x7e6402b5,0x2d980306,0x00000000}},	//   _राधा_, ahip, _vyse_, --, 
   {{0x7c941823,0x2d982f9c,0x7e640882,0xadbc0064}},	//   اشقا, _wyse_, bhip, _манi, 
   {{0x7e642f9d,0x7c3c00e4,0xdd9000ec,0x00000000}},	//   chip, _enrr, _چوٽ_, --, 
   {{0x6e3c0730,0x6e2c2f9e,0x20c401fb,0x7c580131}},	//   _insb, mdab, _xôi_, بلەر_, 
   {{0x6e2c2f9f,0x61e42fa0,0x99840165,0x7b6401ec}},	//   ldab, zakl, adoů_, _өтсе, 
   {{0x61e42fa1,0x6e2c0067,0x81d800cc,0x00000000}},	//   yakl, odab, াণত_, --, 
   {{0x6e2c2fa2,0x7f3c008f,0xfbd00050,0x693401af}},	//   ndab, לעוו, _نتہ_, _инбу, 
   {{0x1fe002a6,0x69d82fa3,0x6e2c00c7,0x59080135}},	//   _বাসস, mbwe, idab, _གདགས_, 
   {{0xdb0c025a,0x69d817da,0x62942fa4,0x20c42fa5}},	//   _ngbû, lbwe, _skyo, _rôi_, 
   {{0x61e42fa6,0x6aa82fa7,0x20c4001e,0x03e000fe}},	//   takl, _khef, _sôi_, _খাদী_, 
   {{0x6e2c0218,0x05b800ab,0x7e640200,0x00000000}},	//   jdab, _उलटब, xhip, --, 
   {{0x61e42fa8,0x6e2c2fa9,0x69d820c7,0x00000000}},	//   rakl, ddab, ibwe, --, 
   {{0x6e3c2faa,0x23342fab,0x61e42fac,0xa0a401c0}},	//   _ansb, _ахир, sakl, тагд, 
   {{0x7e642fad,0x61e42fae,0xe2840209,0x5f0400a7}},	//   thip, pakl, _илки, ъзва, 
   {{0x20c401dc,0xfdd002f5,0x1cdc025c,0x6e2c0158}},	//   _tôi_, িণ্ড, _ལྦུ_, gdab, 
   {{0x65682faf,0x61442fb0,0x6e3c1e0b,0x660c0022}},	// [2bc0] nzeh, _репа, _dnsb, _ñaku, 
   {{0x69d82fb1,0x6e3c0450,0x6e2c2fb2,0x65682fb3}},	//   ebwe, _ensb, adab, izeh, 
   {{0x7e642fb4,0x59082fb5,0x65680112,0x46b000cd}},	//   phip, _གདངས_, hzeh, ुदाह, 
   {{0x7e64094a,0x6e3c0798,0xd12c2fb6,0x65680036}},	//   qhip, _gnsb, _امی_, kzeh, 
   {{0x6aa80066,0x186816c3,0x0d20049e,0x5f741f0d}},	//   _dhef, мади_, _күтү, _ساگر, 
   {{0x656802b9,0x69d80083,0x6aa82fb7,0x394000e2}},	//   dzeh, abwe, _ehef, ģis_, 
   {{0x6aa80943,0xa2c001ad,0x0704004b,0x73c400c7}},	//   _fhef, _रूल्, نيوي_, қәле, 
   {{0xb7bc005f,0x656801c7,0xda6400ec,0x00000000}},	//   _maģi, fzeh, _شازي, --, 
   {{0x34940124,0x78a8037e,0x85000fb4,0x65680036}},	//   лаир, _thdv, لوين, gzeh, 
   {{0x6e2c2fb8,0x5dd401ec,0x850004f2,0x00000000}},	//   zdab, _ﺘﻘﻴﻴ, گوین, --, 
   {{0x6e2c0548,0x741412ea,0x2c3400df,0x00000000}},	//   ydab, نوکا, אָרם_, --, 
   {{0x35c4013e,0x6568002f,0x6e2c058a,0x6aa80200}},	//   _садҳ, bzeh, xdab, _xhef, 
   {{0x51842fb9,0x6e2c00e2,0x00000000,0x00000000}},	//   туна, vdab, --, --, 
   {{0x645c02d3,0x6e2c0009,0x00000000,0x00000000}},	//   ësit, wdab, --, --, 
   {{0x3ce805f9,0x69d80009,0x00000000,0x00000000}},	//   _चौबे_, ybwe, --, --, 
   {{0x68ec2fba,0xe1c000ee,0x6e2c2fbb,0x4ea401a9}},	//   šadi, _гөрй, udab, трга, 
   {{0x6aa82fbc,0x3208035a,0x3134252c,0x00000000}},	// [2bd0] _rhef, _icay_, _сепр, --, 
   {{0x6aa82fbd,0x3f842fbe,0x09c8041c,0xddd400d7}},	//   _shef, ğmur_, ाड्य, rnyš, 
   {{0x6aa80b58,0xddc4068f,0xbae4007b,0xeff80023}},	//   _phef, _dokł, لكلي, ላኸይ_, 
   {{0xbca80075,0x66e407d6,0x6e2c058a,0xe8040a8a}},	//   ىدەك_, ҳока, qdab, _राहा_, 
   {{0x69d826bd,0xdd3003b9,0x00000000,0x00000000}},	//   rbwe, məşq, --, --, 
   {{0xe5a404a9,0x00000000,0x00000000,0x00000000}},	//   һийи, --, --, --, 
   {{0x3208127b,0xd7ec007b,0x00000000,0x00000000}},	//   _ocay_, سكي_, --, --, 
   {{0xe5a40075,0x656801c7,0xf7a800d1,0x80d400eb}},	//   лийи, tzeh, ﺷﯘﻧﺪ, _তিস্, 
   {{0x67d42fbf,0xa5d82fc0,0x00000000,0x00000000}},	//   _бозу, وبکر_, --, --, 
   {{0x32080857,0x65682fc1,0xa63401ec,0x00000000}},	//   _acay_, rzeh, _әнді, --, 
   {{0x65682fc2,0x00000000,0x00000000,0x00000000}},	//   szeh, --, --, --, 
   {{0x27e40295,0x26c4003a,0x656801c7,0x61442fc3}},	//   _heln_, _iulo_, pzeh, гема, 
   {{0x645c069c,0x29180139,0x3e800139,0x00000000}},	//   ësis, _äsad_, dätе_, --, 
   {{0x26c42fc4,0xa0340aaf,0xf1b40032,0x320802d0}},	//   _kulo_, دىست, шҡы_, _ecay_, 
   {{0x26c40ca8,0xa3cc00dc,0xb7bc0171,0x00000000}},	//   _julo_, षुः_, _paģi, --, 
   {{0x26c42fc5,0xe8e405d9,0x1e94030d,0xd354011a}},	//   _mulo_, _وڻ_, ургр, _תיקי_, 
   {{0x20741b74,0x116400dd,0x26c4016d,0xddc4033f}},	// [2be0] _бунё, _ملٹی_, _lulo_, _pokł, 
   {{0xefd4001f,0x21640137,0x00000000,0x00000000}},	//   ካቸው_, _атүг, --, --, 
   {{0x26c42fc6,0x320803ac,0xe72402f2,0x00000000}},	//   _nulo_, _ycay_, _بڵ_, --, 
   {{0x1988013e,0x3ce806e3,0xdef00092,0x00000000}},	//   нбеи_, _चौथे_, _ውሃና_, --, 
   {{0x26c4003a,0x27e40139,0x00000000,0x00000000}},	//   _aulo_, _beln_, --, --, 
   {{0x3ea02fc7,0x26c42fc8,0xf7b807d6,0xc8c403e6}},	//   llit_, _bulo_, نگاش_, دوون_, 
   {{0x26c42fc9,0x3ea00108,0xcc74011a,0xe814000d}},	//   _culo_, olit_, _עגלת_, _दउरा_, 
   {{0x26c4113c,0x3ea02fca,0x00000000,0x00000000}},	//   _dulo_, nlit_, --, --, 
   {{0x18a40137,0x00000000,0x00000000,0x00000000}},	//   _баам, --, --, --, 
   {{0x26c4011f,0xf8b005d9,0x3ea02fcb,0x13680139}},	//   _fulo_, _ڏکڻ_, hlit_, ешми_, 
   {{0x3ea02fcc,0x26c42fcd,0x80d400cc,0x91580241}},	//   klit_, _gulo_, _তিষ্, _ọ̀n_, 
   {{0x645c0240,0x3ea02fce,0x2fc000a2,0x0bb4011a}},	//   ësir, jlit_, _sghg_, טלים_, 
   {{0x3ea02fcf,0x4638008f,0x26c401c6,0xa8180150}},	//   dlit_, _רעדע, _zulo_, _ستەر_, 
   {{0x50642fd0,0x26c4009a,0x3ea02fd1,0x00000000}},	//   утма, _yulo_, elit_, --, 
   {{0x26c42fd2,0x3ea02fd3,0x00000000,0x00000000}},	//   _xulo_, flit_, --, --, 
   {{0x3ea02fd4,0x2bdc0882,0x1cdc0327,0x17740023}},	//   glit_, यर्थ, _ལྦང_, _ክንድኡ_, 
   {{0x9f48025a,0x00000000,0x00000000,0x00000000}},	// [2bf0] nabê_, --, --, --, 
   {{0x3ea02fd5,0x0b8800d8,0x00000000,0x00000000}},	//   alit_, нсеи_, --, --, 
   {{0xfbd000aa,0x0ba428eb,0xbb8400c6,0x5ae400d1}},	//   ستل_, ушам, ملكي, لقلە, 
   {{0x27e40b4b,0x3ea02fd6,0x26c42fd7,0x7f84036b}},	//   _seln_, clit_, _rulo_, _چلین, 
   {{0xc77000f7,0xda14000d,0x3834009d,0x00000000}},	//   өткө, _धउरत_, өнцр, --, 
   {{0x26c42fd8,0xfc6402e8,0x5d78010f,0x00000000}},	//   _pulo_, _лъсн, _יארק, --, 
   {{0x18640801,0x8aa40861,0x03e003d4,0xd6cc004b}},	//   ращи_, _брад, _খালী_, وقو_, 
   {{0xbb840491,0x661c01e4,0x00000000,0x00000000}},	//   _الفي, ĵsko, --, --, 
   {{0xeb980075,0x22500174,0x26c40ca8,0xb93400f3}},	//   _чиң_, _royk_, _wulo_, _летј, 
   {{0x26c42fd9,0x2da001ec,0x3ea02fda,0x00000000}},	//   _tulo_, _ﺃﻭﻟﻰ_, zlit_, --, 
   {{0x3ea02fdb,0xf86825a7,0x3834084c,0x67d4014b}},	//   ylit_, _حملي_, _ынфр, _боҷу, 
   {{0xe6a4004e,0x3ea001b9,0x1fe000eb,0x00000000}},	//   _тузү, xlit_, _বাইস, --, 
   {{0x3ea00205,0x00000000,0x00000000,0x00000000}},	//   vlit_, --, --, --, 
   {{0x3ea0062c,0x00000000,0x00000000,0x00000000}},	//   wlit_, --, --, --, 
   {{0x3ea02fdc,0x9e740063,0x630400d1,0x2328014b}},	//   tlit_, аћај, _ئوبل, _ройи_, 
   {{0x3f8c003d,0x3ea02fdd,0xe2982fde,0x11e00395}},	//   ħdu_, ulit_, _шай_, _джъм, 
  
   {{0x3ea005a4,0x63ac00df,0xd2b4011a,0x9c8800d1}},	// [2c00] rlit_, _ŝanh, _דלקת_, پپاق_, 
   {{0x3ea02fdf,0x998400d7,0x00000000,0x00000000}},	//   slit_, jdoš_, --, --, 
   {{0xf1a82fe0,0x5f440244,0x00000000,0x00000000}},	//   _لایه_, _ئنجل, --, --, 
   {{0x62842fe1,0x38a00428,0x00000000,0x00000000}},	//   nnko, mòri_, --, --, 
   {{0x62842fe2,0xd82422f7,0x397800ec,0x4e24030d}},	//   inko, идди, دشاھ_, _тоян_, 
   {{0x7d042fe3,0x62840112,0x6cb801af,0x2d9801ee}},	//   muis, hnko, _быср_, _сөсө_, 
   {{0x7d042fe4,0x61f402d0,0xf74800ec,0x8c1808c3}},	//   luis, _odyl, العي_, _שולי, 
   {{0x628401a4,0x7d040393,0x59742fe5,0x60d401e3}},	//   jnko, ouis, _кызу, _otym, 
   {{0x7d042fe6,0xca700345,0x00000000,0x00000000}},	//   nuis, _بۆنک, --, --, 
   {{0x62842fe7,0x98a42fe8,0x61f42fe9,0x22900306}},	//   enko, _тизе, _adyl, máky_, 
   {{0x7d042fea,0x229002fb,0x60d42feb,0x98540210}},	//   huis, láky_, _atym, głą_, 
   {{0x7d042fec,0x6284143a,0x00000000,0x00000000}},	//   kuis, gnko, --, --, 
   {{0x7d042fed,0x61f40cfd,0x4fc40801,0x22900306}},	//   juis, _ddyl, исва, náky_, 
   {{0x03742fee,0x7d042fef,0xdedc044e,0x62842ff0}},	//   احیت_, duis, ሕሪኡ_, anko, 
   {{0x60d42ff1,0x92682ff2,0xfc5802d3,0x38a00ba1}},	//   _etym, _арпа_, _የረጋግ, gòri_, 
   {{0xdce40365,0x7d042ff3,0x2c1800dc,0x5f300092}},	//   _aykı, fuis, न्नं_, _ችግራቸ, 
   {{0x7d042ff4,0xa3cc03e5,0x2290219b,0x60d400a2}},	// [2c10] guis, षुक_, jáky_, _gtym, 
   {{0x22900216,0x00000000,0x00000000,0x00000000}},	//   dáky_, --, --, --, 
   {{0x6e942ff5,0x41740066,0x00000000,0x00000000}},	//   _гину, _هایس, --, --, 
   {{0x7d042ff6,0xe8f40597,0xed500014,0x60d401f4}},	//   buis, مستخ, _ٹھر_, _ytym, 
   {{0x7d04213b,0xd364004b,0x98540210,0x423800df}},	//   cuis, _ځه_, złą_, ינאל_, 
   {{0xd3640272,0x26d802fb,0x9f480100,0x00000000}},	//   _فه_, _čsob_, fabè_, --, 
   {{0x62840034,0x78240137,0x998415b2,0xe7380395}},	//   ynko, زعول, rdoš_, уей_, 
   {{0x22900306,0x28200092,0xba0800cf,0x672c0210}},	//   báky_, _ተፎካካ, _ەتەك_, łajo, 
   {{0x22900306,0x8464010b,0xd840022a,0x17e400fe}},	//   cáky_, изиң_, áčí_, _নাৰি, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c1800dc,0xc66800ee,0x36d42ff7,0x60d4012d}},	//   न्यं_, _ишде_, _дохр, _stym, 
   {{0x62842ff8,0x201805b1,0x36340150,0x00000000}},	//   unko, _sbpi_, _ورنس, --, 
   {{0x62842ff9,0x200c01b8,0x38a00086,0x66080cf0}},	//   rnko, _öfik_, wòri_, mgek, 
   {{0x66082ffa,0x1dd8012c,0x7d042ffb,0x38a02508}},	//   lgek, युनत, vuis, tòri_, 
   {{0x62840158,0x7fb401b9,0xc21001d9,0x2290022a}},	//   pnko, زلرچ, _ۂژ_, záky_, 
   {{0x66082ffc,0x7d042ffd,0xf1d005d7,0x9f482ffe}},	//   ngek, tuis, थुआन, nabé_, 
   {{0x60d4009a,0x38a0068c,0x6608002f,0x2d940153}},	// [2c20] _utym, sòri_, igek, орфс, 
   {{0x7d042fff,0x66080732,0x22900122,0x4d60034f}},	//   ruis, hgek, váky_, чкув, 
   {{0x7d043000,0xec3401b9,0x58840022,0x00000000}},	//   suis, تولگ, ҩыла, --, 
   {{0x7d043001,0xd1d00020,0x35a40020,0x22900122}},	//   puis, _ጨዋታ_, ገንባት_, táky_, 
   {{0x66083002,0x7d043003,0x98a43004,0x649c0ba1}},	//   dgek, quis, биде, nèis, 
   {{0x200824ba,0x22900122,0xd9440116,0x91b800d9}},	//   ngbi_, ráky_, _қези, אמני, 
   {{0x59080003,0x66083005,0x95c80b3b,0x22900306}},	//   _གདམས_, fgek, лупа_, sáky_, 
   {{0x66083006,0x229002f0,0x4664004e,0x9a9c010a}},	//   ggek, páky_, йрым_, _чугi, 
   {{0xa5080131,0xddc40153,0x200803e0,0x4d7800df}},	//   لىيە_, _alkū, kgbi_, ָריע, 
   {{0x84840023,0x00000000,0x00000000,0x00000000}},	//   _ዝብልን_, --, --, --, 
   {{0x9f480214,0xdb0c0241,0x8c180677,0x00000000}},	//   babé_, _igbó, נוטי, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x73c43007,0xdb08032e,0x00000000,0x00000000}},	//   _мәне, _ánæs, --, --, 
   {{0x2e3401f2,0x0f7001d5,0xd9a80154,0x00000000}},	//   _ụf_, зғор, _ওলাম, --, 
   {{0x1cdc0156,0x44780375,0x00000000,0x00000000}},	//   _ལསཔ_, _תנוע, --, --, 
   {{0xae0421ef,0xadd83008,0x00000000,0x00000000}},	//   تورى, рмау_, --, --, 
   {{0xcbc43009,0x463800c8,0x649c068c,0xdb0c0241}},	// [2c30] مزاي, נעמע, mèir, _ogbó, 
   {{0x660802ce,0x649c0ba1,0xddc4013a,0x00000000}},	//   zgek, lèir, _mokř, --, 
   {{0x66080af9,0x6ed40210,0xdfd00066,0x00000000}},	//   ygek, _bąbe, _تيپ_, --, 
   {{0xdb0c0ca8,0x649c067c,0xdd980107,0x2be80154}},	//   _agbó, nèir, ушӣ_, খলেই_, 
   {{0x6f1401af,0xfbe8015b,0x16f40327,0x69340137}},	//   ltzc, _পারত, ྗེའམ_, юнду, 
   {{0xf990300a,0x9f48020c,0x6d4c0009,0x97c400fb}},	//   ربن_, wabé_, mxaa, ҙрәһ, 
   {{0xb8d006e3,0x66082a28,0x6d4c300b,0xaa440032}},	//   _टी_, tgek, lxaa, _һеңл, 
   {{0xc98400f3,0xe8041777,0x00000000,0x00000000}},	//   _лузи, _राका_, --, --, 
   {{0x6608300c,0x6d4c0429,0x649c067c,0x9f480066}},	//   rgek, nxaa, dèir, rabé_, 
   {{0x6608300d,0x6ed40210,0x00000000,0x00000000}},	//   sgek, _ząbe, --, --, 
   {{0x224806ed,0x6608053d,0x17080ed8,0x00000000}},	//   апни_, pgek, _نفلی_, --, 
   {{0x2c180882,0x00000000,0x00000000,0x00000000}},	//   न्तं_, --, --, --, 
   {{0x672002d0,0xe5a400d8,0x00000000,0x00000000}},	//   _hplj, _ќили, --, --, 
   {{0x6d4c058a,0x00000000,0x00000000,0x00000000}},	//   dxaa, --, --, --, 
   {{0xd36c0592,0x10a0300e,0x6d4c058a,0x00000000}},	//   _لهو_, фирн, exaa, --, 
   {{0x30d800cc,0x00000000,0x00000000,0x00000000}},	//   _তিৰস, --, --, --, 
   {{0x1be80364,0x1d08300f,0x9db806a6,0x6d4c0067}},	// [2c40] идаи_, рези_, рыву_, gxaa, 
   {{0x67200989,0xf1b80216,0x656c010e,0x5ed41291}},	//   _oplj, ýše_, _ýahu, _وتجز, 
   {{0xdb0c0241,0x6d4c3010,0x5b24007b,0x2c1800dc}},	//   _agbò, axaa, تفال, न्धं_, 
   {{0x6d4c3011,0x09e003b7,0x9d443004,0xdd940124}},	//   bxaa, доцн, _демд, _ҳаҭы, 
   {{0xa3d8000d,0x00000000,0x00000000,0x00000000}},	//   ़डा_, --, --, --, 
   {{0x2c1800dc,0x8d780092,0x00000000,0x00000000}},	//   न्दं_, ሪያቸው_, --, --, 
   {{0xdb0c0248,0x3d1400fd,0x7e643012,0x59b800bc}},	//   _egbò, läw_, okip, ेशहर, 
   {{0x7e643013,0xddc40118,0x00000000,0x00000000}},	//   nkip, _pokř, --, --, 
   {{0xceb006a9,0x38a0068c,0x5ba800c5,0x35c80022}},	//   ויה_, fòrt_, _करुव, аҳҵо_, 
   {{0x33743014,0xb9e00020,0x88b001d9,0x7e6401f4}},	//   згор, _ጦር_, _ہیۆچ, hkip, 
   {{0x3d140227,0x7e643015,0xdeb80b82,0x00000000}},	//   häw_, kkip, ታምን_, --, 
   {{0x63b40122,0x00000000,0x00000000,0x00000000}},	//   ýzna, --, --, --, 
   {{0x6d4c102c,0x649c067c,0x00000000,0x00000000}},	//   xxaa, rèir, --, --, 
   {{0xad2404da,0x3d140166,0x394001f4,0x00000000}},	//   ۋىزى, däw_, äisy_, --, 
   {{0x649c0561,0x0874010f,0x00000000,0x00000000}},	//   pèir, קעלט_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6d4c0009,0xd01802e8,0x656c010e,0x98540210}},	// [2c50] uxaa, _кфн_, _ýaht, słę_, 
   {{0x7e64013c,0x6d4c0014,0xdb1c0306,0x00000000}},	//   akip, rxaa, _šváb, --, 
   {{0x7e64020c,0x6d4c0009,0x00000000,0x00000000}},	//   bkip, sxaa, --, --, 
   {{0xba743016,0x7e643017,0x672c012d,0x3d140139}},	//   وانت, ckip, łajk, bäw_, 
   {{0xf9a401d9,0xf0340023,0x00000000,0x00000000}},	//   وٕمُ, _ብምስም, --, --, 
   {{0xd5e001e1,0xeff80092,0x00000000,0x00000000}},	//   _alò, ላቸዉ_, --, --, 
   {{0x25a80f03,0xefcc01f3,0xfb8400c0,0x00000000}},	//   _šal_, _ኤንድ_, _жытн, --, 
   {{0x5378044e,0x24080131,0x00000000,0x00000000}},	//   _ኣሕዋት_, әнни_, --, --, 
   {{0x69c83018,0xf8f40276,0x649801ee,0x00000000}},	//   _igee, _оптэ, йтор_, --, 
   {{0x68e83019,0x7e64005a,0x33d40212,0xb924007b}},	//   _iwed, zkip, міют, _تفكي, 
   {{0x7e641bb7,0x68e8301a,0x00000000,0x00000000}},	//   ykip, _hwed, --, --, 
   {{0x68e82c6b,0x00000000,0x00000000,0x00000000}},	//   _kwed, --, --, --, 
   {{0x38a0068c,0x613401d3,0xe80401f9,0x00000000}},	//   còrs_, dülá, _राञा_, --, 
   {{0x68e805b8,0x232800d8,0x201c301b,0x00000000}},	//   _mwed, _гоки_, ýti_, --, 
   {{0x1ea8301c,0x69c80a55,0x68e81992,0x1fa8301d}},	//   ماري_, _ogee, _lwed, скви_, 
   {{0x69c8301e,0x4370301f,0x7e640194,0x68e83020}},	//   _ngee, _нуқт, ukip, _owed, 
   {{0x7e643021,0x68e83022,0x00000000,0x00000000}},	// [2c60] rkip, _nwed, --, --, 
   {{0x7e643023,0xeff80201,0x69c83024,0x9f483025}},	//   skip, ላቸው_, _agee, labí_, 
   {{0x68e83026,0xe8043027,0xd24c3028,0x9058011a}},	//   _awed, _राजा_, _شنی_, _הכית, 
   {{0x9f480789,0x19f40014,0x00000000,0x00000000}},	//   nabí_, سِتھ_, --, --, 
   {{0x69c800e4,0xd7f83029,0xf8b001e2,0x00000000}},	//   _dgee, буй_, نکئ_, --, 
   {{0xdcb0302a,0xb8f4302b,0x7d04302c,0x3ce004cc}},	//   _سىز_, _सं_, mris, mpiv_, 
   {{0x25c003be,0xd5e00241,0x7d041d81,0x68e8302d}},	//   ərlə_, _aló, lris, _ewed, 
   {{0x69c804ba,0xc028009e,0x656c0327,0xf4d80117}},	//   _ggee, মায়ণ_, _żaha, омиш_, 
   {{0xd498302e,0x68e800a9,0x7d04302f,0x00000000}},	//   йро_, _gwed, nris, --, 
   {{0x7d043030,0x73c40032,0xdb0802d2,0x00000000}},	//   iris, мәйе, _ínót, --, 
   {{0x7d043031,0x68e80d27,0xe87401d5,0x95c83032}},	//   hris, _zwed, _تنلگ, _лула_, 
   {{0x38a0067c,0x9a940092,0x00000000,0x00000000}},	//   pòrs_, _ሆኖአል_, --, --, 
   {{0x386c00bc,0x416800d8,0x00000000,0x00000000}},	//   _kldr_, пјрм_, --, --, 
   {{0x7d043033,0x94100605,0xf1e00131,0x00000000}},	//   dris, _ɔyɛ_, _ﺋﯩﻨﺘ, --, 
   {{0x7d043034,0x82f400e3,0x00000000,0x00000000}},	//   eris, _فريز_, --, --, 
   {{0x7d043035,0x69ac000d,0x63640023,0x9268030d}},	//   fris, _जरली, _ዝመጣጠ, _ырла_, 
   {{0x7d043036,0x82343037,0xaffc0212,0x21300205}},	// [2c70] gris, _سريا, _копi, _gsyh_, 
   {{0x68e8006f,0xbec80171,0x00000000,0x00000000}},	//   _rwed, _skūš, --, --, 
   {{0x7d043038,0x68e80155,0x00000000,0x00000000}},	//   aris, _swed, --, --, 
   {{0x7d180491,0x68e80d72,0x386c0109,0x3ce8012d}},	//   éasá, _pwed, _aldr_, _चौके_, 
   {{0x7d043039,0xe944303a,0x6d840014,0x499000e5}},	//   cris, برای, _غۅطہ_, ریئر, 
   {{0x01380302,0xdb0c067c,0xd9400137,0x00000000}},	//   פרות_, _ozbè, теши, --, 
   {{0xb8f40243,0x1dd813da,0x00000000,0x00000000}},	//   _सू_, युवत, --, --, 
   {{0x69c80a40,0x386c0327,0x68e8303b,0x56900f5c}},	//   _ugee, _eldr_, _twed, кајт, 
   {{0x68e8303c,0x852003e6,0xe578303d,0xc7c406ed}},	//   _uwed, رودۆ, юзи_, _есеи, 
   {{0x2a6c303e,0xdde404fe,0x00000000,0x00000000}},	//   _hleb_, _āpōp, --, --, 
   {{0xa228303f,0x2a6c3040,0x04fc015b,0x7d0400b5}},	//   ожна_, _kleb_, ্বের_, zris, 
   {{0x7d043041,0x2a6c020b,0x00000000,0x00000000}},	//   yris, _jleb_, --, --, 
   {{0x5ba83042,0x7d04022e,0x00000000,0x00000000}},	//   _कर्व, xris, --, --, 
   {{0x63843043,0x9f480589,0x24802305,0x64a40166}},	//   _огла, jabã_, _öhm_, _юала, 
   {{0x9e643044,0x7d043045,0x4fa0011c,0x00000000}},	//   وارن, wris, вирв, --, 
   {{0xdde801a9,0xd12c00ec,0x00000000,0x00000000}},	//   ترسه_, _چمي_, --, --, 
   {{0xd12c04fb,0x00000000,0x00000000,0x00000000}},	// [2c80] _نمي_, --, --, --, 
   {{0xed3405f5,0x3ac80213,0x5f2828ed,0x00000000}},	//   ээсэ, _aşpa_, _доом_, --, 
   {{0x2a6c062c,0x00000000,0x00000000,0x00000000}},	//   _bleb_, --, --, --, 
   {{0x3a200510,0x7d043046,0x2a6c003e,0x998402f2}},	//   ýip_, pris, _cleb_, ولاو, 
   {{0x611002ea,0x3ea003a2,0xaac43047,0x660c00e4}},	//   _bɛlɛ, moit_, رتمن, _ñaky, 
   {{0xd6d83048,0x3ea005c7,0x2a6c003e,0x1768010b}},	//   оти_, loit_, _eleb_, жрип_, 
   {{0x7a24007f,0xf1a4000d,0x3940010f,0x00000000}},	//   _pčtč, _गुनन, ŭis_, --, 
   {{0x2a6c3049,0xd5641b0a,0x00000000,0x00000000}},	//   _gleb_, дтоп, --, --, 
   {{0x62840162,0x18a400db,0xd40400f5,0x00000000}},	//   _íhoy, _жаам, мяни, --, 
   {{0x09000a89,0x3ea00076,0x985401a9,0xd49801a9}},	//   _шпун, hoit_, _ўташ, ўри_, 
   {{0xd37800d6,0x3ea00649,0x41c4031c,0x73880116}},	//   ючи_, koit_, _གུཔྟ, яриң_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x0fe00228,0x3ea0054e,0x00000000,0x00000000}},	//   көнү, doit_, --, --, 
   {{0x32040209,0x104802bf,0x33940024,0x00000000}},	//   şly_, цями_, _палё, --, 
   {{0xc058242f,0x00000000,0x00000000,0x00000000}},	//   фія_, --, --, --, 
   {{0x02a4035b,0x3ea0036e,0xf48402f2,0xddd4010e}},	//   _ирым, goit_, _تاڵی, njyň, 
   {{0x86580375,0x00000000,0x00000000,0x00000000}},	// [2c90] קדמי, --, --, --, 
   {{0x291800de,0x6ab800cd,0x00000000,0x00000000}},	//   _īsa_, ेद्र, --, --, 
   {{0x2a6c304a,0x00000000,0x00000000,0x00000000}},	//   _pleb_, --, --, --, 
   {{0x0ea405f9,0x3ea0304b,0x2ab4005c,0x00000000}},	//   _कीचड, coit_, kåbe_, --, 
   {{0xf1a41d8a,0x2a6c0076,0x6e2c304c,0x00000000}},	//   _गुमन, _vleb_, meab, --, 
   {{0xe7382e9a,0x6e2c304d,0x1cac025c,0x6e2800e8}},	//   зек_, leab, _ཕེར_, _ñebb, 
   {{0xa6c41a59,0xddc40139,0x2a6c0254,0x3f9c0162}},	//   ىقتى, _kokş, _tleb_, _øvut_, 
   {{0xbb48304e,0x00000000,0x00000000,0x00000000}},	//   _تلفن_, --, --, --, 
   {{0xddc40166,0x00000000,0x00000000,0x00000000}},	//   _mokş, --, --, --, 
   {{0xe4500491,0x6e2c304f,0x67d4010b,0x888001d3}},	//   اضة_, heab, _чожу, _جیتن, 
   {{0xe2840861,0x4e0c0316,0x1cac031c,0x00000000}},	//   елни, िलाई_, _ཕེལ_, --, 
   {{0x69d80042,0xa4d400d4,0x00000000,0x00000000}},	//   ncwe, _зоді, --, --, 
   {{0xe4b80220,0x3ea03050,0x952001b9,0xd36c0214}},	//   _елді_, voit_, _یکیم, لهی_, 
   {{0xa0683051,0x27300427,0xd24c0220,0xa878010f}},	//   чага_, _kšn_, _ۇنى_, לאָר, 
   {{0x3ea026bb,0xa0a43052,0x629c0010,0x6e2c00ae}},	//   toit_, _җанд, čsob, feab, 
   {{0x6e2c3053,0xdb0c003e,0x00000000,0x00000000}},	//   geab, _uzbé, --, --, 
   {{0x3ea03054,0x1c443055,0xeb400092,0x201c0254}},	// [2ca0] roit_, ннам, _የሚገለ, õtis_, 
   {{0x62843056,0x3ea00129,0x4c800353,0x00000000}},	//   liko, soit_, глув, --, 
   {{0x6e2c2caa,0x4fd4011a,0x3124004e,0x79ac00d1}},	//   beab, _רוטב_, _здөг, ﺴﺘﯩﻤ, 
   {{0x6e2c3057,0x69d83058,0x62843059,0xf1a401ad}},	//   ceab, gcwe, niko, _गुडन, 
   {{0x62840810,0x0d2000d1,0x9984030a,0xfcc401ee}},	//   iiko, _йүтү, reoů_, _аҙам, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6284305a,0x7bdc04ce,0x24840254,0x00000000}},	//   kiko, _ifru, dilm_, --, 
   {{0x6284305b,0x34c80303,0x00000000,0x00000000}},	//   jiko, रद्द, --, --, 
   {{0x6284305c,0x19b80323,0x35b4305d,0xddd401d3}},	//   diko, _хувь_, ъбир, nnyű, 
   {{0x6e2c305e,0x62840af9,0x1cac0327,0x2ab4005c}},	//   zeab, eiko, _ཕེས_, råbe_, 
   {{0x6e2c009f,0xd62800d8,0x99d000eb,0x00000000}},	//   yeab, _ноже_, ারীক, --, 
   {{0x6284305f,0x93440ed0,0x39440254,0x2484000d}},	//   giko, _үнде, _krms_, ailm_, 
   {{0x7bdc3060,0x93a801ed,0x6e2c045a,0x7afc0171}},	//   _ofru, _کاشف_, veab, _lvrt, 
   {{0xc0583061,0x74143062,0x7afc0139,0x62843063}},	//   ніс_, _شوبا, _ovrt, aiko, 
   {{0x62843064,0x6e2c3065,0xf16401e1,0x7f943066}},	//   biko, teab, _iyọ̀_, гарх, 
   {{0x7bdc3067,0x62843068,0xad2c0092,0x00000000}},	//   _afru, ciko, _ስርጭቶ, --, 
   {{0x6e2c3069,0x9f48306a,0x7afc00b8,0x7e440124}},	// [2cb0] reab, rabá_, _avrt, ыхре, 
   {{0x6e2c306b,0xf8b801fb,0x705400f7,0xbca800d1}},	//   seab, _nhĩ_, _شنجا, ۈدەك_, 
   {{0x6e2c02ea,0xab6c001f,0x7afc1a48,0x39442517}},	//   peab, _በዚያው_, _cvrt, _arms_, 
   {{0xe8f40244,0x00000000,0x00000000,0x00000000}},	//   نستخ, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6284306c,0xc710002b,0xf8b80208,0x00000000}},	//   ziko, _amūḍ, _chĩ_, --, 
   {{0x6284306d,0x3944004e,0xa694147e,0xfbe800fe}},	//   yiko, _erms_, криј, _পাচত, 
   {{0x6284306e,0xf1640248,0x39440175,0xdd8c00e5}},	//   xiko, _ayọ̀_, _frms_, _اڈہ_, 
   {{0x7afc19d6,0x49000c75,0x799400d8,0x57b004b4}},	//   _zvrt, _сүлг, _битф, лбәт, 
   {{0x6284306f,0x7bdc01c6,0x291c009f,0x00000000}},	//   wiko, _xfru, mtwa_, --, 
   {{0xe2983070,0xe3b802d5,0x9f5c0205,0x00000000}},	//   дан_, ьбо_, ütü_, --, 
   {{0xfbe80183,0xe5a400c7,0x24840037,0x00000000}},	//   _পাছত, _ҧиҧи, silm_, --, 
   {{0xf65000f4,0x95b400c7,0x00000000,0x00000000}},	//   _دئل_, _иршә, --, --, 
   {{0x62843071,0x291c3072,0xf1b400fb,0x00000000}},	//   siko, itwa_, ыҡы_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7bdc3073,0x291c3074,0x62841bce,0xddc400ef}},	//   _sfru, ktwa_, qiko, _alkš, 
   {{0x291c0054,0x21743075,0x21140073,0x00000000}},	// [2cc0] jtwa_, _шукр, _तमिळ_, --, 
   {{0x1f640588,0x28d40131,0x00000000,0x00000000}},	//   _аком, ﻟﻪﺗﻠ, --, --, 
   {{0xdbdc01e1,0x00000000,0x00000000,0x00000000}},	//   _bíòd, --, --, --, 
   {{0xddc400ef,0x1988035b,0x394401ef,0xfde800f1}},	//   _elkš, мбеи_, _prms_, _سکرو_, 
   {{0x2bf000fe,0x00000000,0x00000000,0x00000000}},	//   _চাৰে_, --, --, --, 
   {{0x7afc3076,0x3a2402fa,0x48100212,0x81d800eb}},	//   _tvrt, _wbmp_, иміс, িরি_, 
   {{0x7c3c2d53,0x39440798,0x7afc110c,0x629400b5}},	//   _iarr, _wrms_, _uvrt, _ojyo, 
   {{0x7c3c3077,0xcf9000d9,0x00000000,0x00000000}},	//   _harr, יטו_, --, --, 
   {{0x291c0034,0x75843078,0x81d8015b,0x89d4036b}},	//   ctwa_, ыңда, িরা_, _شولر_, 
   {{0x7c3c3079,0xdb0c0356,0x76d80107,0x00000000}},	//   _jarr, _izbâ, _зудӣ_, --, 
   {{0x7c3c307a,0x00000000,0x00000000,0x00000000}},	//   _marr, --, --, --, 
   {{0x7c3c307b,0x55e40114,0x68ec0356,0x03c00139}},	//   _larr, _родб, ţade, шсым, 
   {{0x7c3c307c,0x316c307d,0x63800124,0x29c000a2}},	//   _oarr, áez_, иҳәа, _ỳaz_, 
   {{0x7c3c307e,0x534401c6,0x00000000,0x00000000}},	//   _narr, _ахиа, --, --, 
   {{0x4ea4009d,0x00000000,0x00000000,0x00000000}},	//   враа, --, --, --, 
   {{0x7c3c307f,0x8d743080,0x6b742cc8,0x291c0472}},	//   _aarr, پارا, ңлау, ytwa_, 
   {{0x7c3c3081,0x201c0137,0x6fc40154,0x79ac00d1}},	// [2cd0] _barr, òtic_, ্রেই, ﺴﺘﯧﻤ, 
   {{0x7c3c3082,0xb034228c,0x5ee00154,0x00000000}},	//   _carr, _снош, _ফিরে, --, 
   {{0x7c3c3083,0x09c80882,0x8bc40138,0x1f2401d9}},	//   _darr, िश्य, тсад, _یِیہ, 
   {{0x7c3c3084,0x63b402f0,0x7de40816,0x3a2001e4}},	//   _earr, ýzni, _вірд, ϲipe_, 
   {{0x69243085,0x6e3c035a,0xc27c05d0,0x574401ec}},	//   умла, _iasb, וראי, ғзым_, 
   {{0x7c3c3086,0x6e3c3087,0xfc6406bb,0x6c78010f}},	//   _garr, _hasb, _късн, _טאָפ, 
   {{0x64a43088,0x6e3c3089,0x291c308a,0x09d8015b}},	//   ғана, _kasb, stwa_, দরবা, 
   {{0x7c3c308b,0x9f5c004a,0xe61801e0,0x00000000}},	//   _zarr, ûté_, хди_, --, 
   {{0x7c3c308c,0x6e3c308d,0x64a40022,0x00000000}},	//   _yarr, _masb, лаиа, --, 
   {{0x649c0228,0x7c3c308e,0x6e3c0af9,0x49b000d1}},	//   nèix, _xarr, _lasb, _йәһу, 
   {{0xf770308f,0xf8683090,0x684401e0,0x6ed40210}},	//   _وام_, _جملي_, _инҡа, _dąbk, 
   {{0x6e3c3091,0x00000000,0x00000000,0x00000000}},	//   _nasb, --, --, --, 
   {{0x81ac09bd,0xa6a800db,0xc1040116,0x00000000}},	//   কেন_, _قاچق_, шүпл, --, 
   {{0x65680526,0xdfd03092,0x6ed4012d,0x04640f06}},	//   myeh, صير_, _gąbk, _штем, 
   {{0x7c3c3093,0x65680280,0x00000000,0x00000000}},	//   _rarr, lyeh, --, --, 
   {{0x7c3c3094,0x6e3c0548,0x442405b1,0x6aa8009b}},	//   _sarr, _casb, _hbn_, _nkef, 
   {{0x65683095,0x61443096,0xdcb01473,0x9c240220}},	// [2ce0] nyeh, _сепа, مىر_, лдад, 
   {{0x7c3c3097,0x61f43098,0x6e3c0e89,0x6aa8035a}},	//   _qarr, _heyl, _easb, _akef, 
   {{0x7c3c3099,0x61f4309a,0x6e3c309b,0x60d4309c}},	//   _varr, _keyl, _fasb, _huym, 
   {{0xe3c400bd,0x7c3c309d,0x61f4047e,0x99d0015b}},	//   _এভাব, _warr, _jeyl, ার্ক, 
   {{0x61f4309e,0x58840598,0x44240b94,0x0d80309f}},	//   _meyl, лыка, _obn_, _глян, 
   {{0x442430a0,0x61f430a1,0x60d40280,0x7c3c30a2}},	//   _nbn_, _leyl, _muym, _uarr, 
   {{0x572430a3,0x6aa80093,0x6e3c00ca,0xfbb830a4}},	//   ارتق, _fkef, _yasb, _अरिम, 
   {{0x61f430a5,0x6e3c058a,0x57b00150,0x00000000}},	//   _neyl, _xasb, _құйт, --, 
   {{0x442430a6,0x8500004b,0xe9a40050,0x20180356}},	//   _bbn_, موين, _پۯون_, _ocpi_, 
   {{0x20180175,0x12e402dd,0x741430a7,0x44240f85}},	//   _ncpi_, лімг, جودا, _cbn_, 
   {{0x61f430a8,0x4424017a,0x47d00451,0xc68c0014}},	//   _beyl, _dbn_, _ايمر, _کِن_, 
   {{0x2018031c,0x656800ca,0x60d4037e,0x442430a9}},	//   _acpi_, byeh, _buym, _ebn_, 
   {{0x442401ab,0x61f430aa,0x60d40139,0x518430ab}},	//   _fbn_, _deyl, _cuym, ууна, 
   {{0x850000aa,0x60d42fbe,0x76400728,0xddd40055}},	//   _اوون, _duym, ldmy, bhyū, 
   {{0xb4c00141,0xceb8026a,0x6e3c30ac,0x61f430ad}},	//   ंगी_, еља_, _pasb, _feyl, 
   {{0x6e3c30ae,0x4ea430af,0x764030b0,0x43b00150}},	//   _qasb, урга, ndmy, _دەپء, 
   {{0x6e3c30b1,0xb80423ef,0x60d4010e,0x31340354}},	// [2cf0] _vasb, रणाम_, _guym, _тепр, 
   {{0x6aa830b2,0x6e3c30b3,0x61f430b4,0x00000000}},	//   _skef, _wasb, _zeyl, --, 
   {{0x649c0228,0x6e3c0ac5,0x61f40009,0xa03400d1}},	//   rèix, _tasb, _yeyl, _ئىپت, 
   {{0x61f400ac,0x60d4011f,0x6e3c30b5,0xb4c02cbb}},	//   _xeyl, _yuym, _uasb, ंगु_, 
   {{0xc27c008f,0x00000000,0x00000000,0x00000000}},	//   ערדי, --, --, --, 
   {{0x1cac0327,0xa764004e,0x00000000,0x00000000}},	//   _ཕེག_, иклд, --, --, 
   {{0x44240010,0x6aa80327,0x57800055,0x6f000332}},	//   _rbn_, _tkef, _kāṇā_, álch, 
   {{0x6aa802d0,0xd75401e2,0x00000000,0x00000000}},	//   _ukef, ؤليت_, --, --, 
   {{0x4424010a,0xb4c02232,0x74f801c0,0x61f430b6}},	//   _pbn_, ंगू_, лээс_, _reyl, 
   {{0x61f430b7,0x278801ee,0x00000000,0x00000000}},	//   _seyl, _иреү_, --, --, 
   {{0x44240175,0x60d401a9,0x00000000,0x00000000}},	//   _vbn_, _suym, --, --, 
   {{0x61f40978,0x614430b8,0x216800d6,0x20180129}},	//   _qeyl, аема, вими_, _scpi_, 
   {{0x2018056a,0x4424004d,0x60d430b9,0x00000000}},	//   _pcpi_, _tbn_, _quym, --, 
   {{0xd46430ba,0x442430bb,0x61f430bc,0x1ea80451}},	//   _више_, _ubn_, _weyl, چاري_, 
   {{0x61f430bd,0x644030be,0x1ea830bf,0x578000b8}},	//   _teyl, mdli, ناري_, _bāṇā_, 
   {{0x53980375,0x1cac031c,0x3afc0248,0x3aec0241}},	//   _ביצו, _ཕེང_, _lápá_, _lòpò_, 
   {{0xc050069c,0x64400b1d,0x7874026c,0x1cb8007b}},	// [2d00] _ኣገልግ, odli, _làva, نائب_, 
   {{0xd1b80201,0xd12c30c0,0xeff8001f,0x2c640014}},	//   ተኞች_, _کمی_, ዋቸው_, ٝدمُ, 
   {{0x9ac401ed,0x00000000,0x00000000,0x00000000}},	//   لگرہ_, --, --, --, 
   {{0x50d00014,0x644030c1,0xf38c010f,0x00000000}},	//   _دٲیر, hdli, עראָ, --, 
   {{0xc9a40556,0xc980005b,0xd83830c2,0x00000000}},	//   авце_, жущи, вэй_, --, 
   {{0xc2e82baf,0x644001a4,0xf1b80030,0x36d41d0f}},	//   _কিনি_, jdli, ýši_, бокр, 
   {{0x644030c3,0x00000000,0x00000000,0x00000000}},	//   ddli, --, --, --, 
   {{0x64400639,0xda700014,0x95c80414,0x6e600092}},	//   edli, _بُر_, купа_, _ወገኖች, 
   {{0x644001a4,0x76400423,0x5fc40073,0x00000000}},	//   fdli, rdmy, ळेतल, --, 
   {{0xb4c0006d,0x534430c4,0x644030c5,0x2450167e}},	//   ंगे_, ахма, gdli, كچىس, 
   {{0x2250207a,0x9d20015b,0x4bf80375,0xf98800f1}},	//   _bnyk_, নিয়ন_, כליס, _شخړه_, 
   {{0x644030c6,0xe63805d9,0x25640014,0x00000000}},	//   adli, _ميمڻ_, _گامُ, --, 
   {{0x93e401b9,0x506430c7,0x6440031c,0x64d000cd}},	//   _кўйл, атва, bdli, सदृश, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2c180490,0x2b4c013a,0x00000000,0x00000000}},	//   _पाहू_, _čec_, --, --, 
   {{0xeff00020,0x66d40006,0x313400d8,0x63bc0210}},	// [2d10] ቃላይ_, _iške, _ѓеор, ęsne, 
   {{0xa3bc07f7,0x00000000,0x00000000,0x00000000}},	//   _आरम_, --, --, --, 
   {{0x29d402dd,0xa7e4278f,0x6e480092,0x00000000}},	//   مياس, ەكتى, ነምግባ, --, 
   {{0x99900209,0x3afc01e1,0x6f140205,0xe97800db}},	//   ýyş_, _sápá_, muzc, лбеш_, 
   {{0xf9900133,0x0dc80cfc,0x5fdc0406,0x9de40014}},	//   وبه_, _јуни_, _मलमल, _چہہٕ_, 
   {{0xb4c020f0,0xd1b8001f,0x22900219,0xf8a80006}},	//   ंगो_, ተኞቹ_, mške_, авік_, 
   {{0xa7a830c8,0x9410013f,0xbb580116,0xdd140166}},	//   ыкка_, _ɔyɔ_, _карх_, _käşe, 
   {{0x232815d1,0x9f48026c,0xc98430c9,0x64400076}},	//   қоми_, ubbé_, _кузи, wdli, 
   {{0xa3c808ec,0x22901109,0x644030ca,0xe63003e3}},	//   लेन_, nške_, tdli, _eşşə, 
   {{0x478830cb,0x66d40010,0xc2e800fe,0x7af801e1}},	//   _исем_, _aške, _কিবি_, _àatà, 
   {{0x644030cc,0xe7b430cd,0x88c400cd,0x00000000}},	//   rdli, _اماد, _vaśī, --, 
   {{0x27202d7b,0x6f1430ce,0x76640014,0xdd1400fd}},	//   món_, duzc, _وُلم, _näşe, 
   {{0x272030cf,0xa5081639,0x5a98010f,0xe5b4008e}},	//   lón_, _села_, רשרא, _уйды, 
   {{0x408800fb,0x81d80154,0x00000000,0x00000000}},	//   рҙом_, িরই_, --, --, 
   {{0xdee430d0,0x27200f71,0x630430d1,0x99580139}},	//   соби, nón_, _اوبل, käşe_, 
   {{0x2250045f,0x27200077,0x92902377,0x2bf000fe}},	//   _unyk_, ión_, _најц, _চাগৈ_, 
   {{0x272030d2,0xdd140139,0x9b8830d3,0xd00c00e5}},	// [2d20] hón_, _däşe, گنال_, ظلہ_, 
   {{0x272030d4,0x00000000,0x00000000,0x00000000}},	//   kón_, --, --, --, 
   {{0x272030d5,0xf1a816e6,0x5f4430d6,0x6f1430d7}},	//   jón_, _مایه_, _انجل, cuzc, 
   {{0x2720097a,0xa3c80490,0xa0340131,0x91000133}},	//   dón_, लेय_, _ئىھت, _بژێو, 
   {{0x18680517,0x00000000,0x00000000,0x00000000}},	//   лади_, --, --, --, 
   {{0x272030d8,0x00000000,0x00000000,0x00000000}},	//   fón_, --, --, --, 
   {{0x272030d9,0xdd1400fd,0xa3c80a8a,0x9f480162}},	//   gón_, _yäşe, लेम_, gabø_, 
   {{0x93f0016b,0xb6c801d3,0x2b90030f,0xb4c01c5d}},	//   _ɔyε_, جاتے_, _تیمس, ंग्_, 
   {{0xf8b81e0e,0x99900034,0xb47800d1,0xbbb800bc}},	//   _көк_, żył_, ийиф_, _अरुक, 
   {{0x272030da,0xf484034d,0x201c00db,0x88c430db}},	//   bón_, تابی, òtil_, _paśū, 
   {{0x2720307d,0xd5b0034c,0x87080014,0x00000000}},	//   cón_, _کفش_, _معنہ_, --, 
   {{0x95480101,0x91e007f7,0x41e402d5,0x0bb4011a}},	//   _مشتق_, कुंज_, зіра, מלים_, 
   {{0xf4841272,0xa3c813f5,0xefe40023,0x00000000}},	//   _واتی, लेब_, ማሚዑ_, --, 
   {{0x644c0198,0x387c0175,0x22900427,0xbbb80118}},	//   _ɗaik, nhvr_, vške_, _अरूक, 
   {{0xfc5802d3,0x00000000,0x00000000,0x00000000}},	//   _ከረጋግ, --, --, --, 
   {{0xa3bc000d,0x072c0150,0x00000000,0x00000000}},	//   _आरत_, _ﺩﯗﯓ_, --, --, 
   {{0x272028f2,0x92541d18,0x320830dc,0x8cd0012d}},	// [2d30] zón_, _вақт_, _iday_, _भूखो, 
   {{0x6f1430dd,0x272030de,0x7bf8008e,0xc4d0011a}},	//   puzc, yón_, йнур_, פגע_, 
   {{0x27201709,0x00000000,0x00000000,0x00000000}},	//   xón_, --, --, --, 
   {{0x272030df,0xf1bc012d,0x00000000,0x00000000}},	//   vón_, _ईरान, --, --, 
   {{0xd5a41fa2,0x7c040116,0x00000000,0x00000000}},	//   _آف_, زبەك, --, --, 
   {{0x27200540,0xd3640272,0x9f4806ea,0x387c0076}},	//   tón_, _قه_, tabø_, ghvr_, 
   {{0x320830e0,0x7b6430e1,0x00000000,0x00000000}},	//   _oday_, _етте, --, --, 
   {{0x272030cf,0x32081bce,0x2bf00349,0x9f4803b2}},	//   rón_, _nday_, _চায়ে_, rabø_, 
   {{0x272030e2,0x04200135,0x9f4805ac,0x64a430e3}},	//   són_, _འཁྱམ_, sabø_, жапа, 
   {{0x272030e4,0x320830e5,0x1cac031c,0x68e80857}},	//   pón_, _aday_, _ཕེབ_, _ited, 
   {{0x320830e6,0x68e800f3,0x7f5c05b1,0x232830e7}},	//   _bday_, _hted, xxrq, шони_, 
   {{0xc6a4011c,0x00000000,0x00000000,0x00000000}},	//   _урзи, --, --, --, 
   {{0x320830e8,0xf49400f2,0x3e7c013a,0x00000000}},	//   _dday_, _کشند, _jíte_, --, 
   {{0x201c30e9,0x68e8055a,0x3208127b,0x28e00037}},	//   üti_, _mted, _eday_, _पढनि, 
   {{0xbbb80406,0x931000db,0x00000000,0x00000000}},	//   _अरेक, _قووش, --, --, 
   {{0x68e8127b,0xe0d8156c,0x43700b01,0x201c031c}},	//   _oted, _кви_, _муқт, żti_, 
   {{0x1c1c000d,0x00000000,0x00000000,0x00000000}},	// [2d40] _पादल_, --, --, --, 
   {{0xa3bc032c,0x9f580200,0x00000000,0x00000000}},	//   _आरा_, _jepë_, --, --, 
   {{0x68e814dc,0x6d5800b0,0x3208035a,0x00000000}},	//   _ated, äwar, _yday_, --, 
   {{0x32080175,0xddc40153,0x5398011a,0x26d801ef}},	//   _xday_, _jokū, ביעו, _čsop_, 
   {{0x81ac015b,0xa3c80490,0xef18033f,0x5fdc2cfd}},	//   কের_, लेत_, ąże_, _मलाल, 
   {{0x7d0430ea,0x36d40b2b,0x00000000,0x00000000}},	//   msis, покр, --, --, 
   {{0x7d0430eb,0x8b200b7f,0x2a7c01d4,0x68e802d0}},	//   lsis, _одре, bhwb_, _eted, 
   {{0xddc400ef,0x00000000,0x00000000,0x00000000}},	//   _nokū, --, --, --, 
   {{0xd49830ec,0x34941f09,0xa50800d1,0x656c031c}},	//   иро_, запр, مىيە_, _żahr, 
   {{0x7d0430ed,0x88b00d73,0x00000000,0x00000000}},	//   isis, _قینچ, --, --, 
   {{0x7d0430ee,0x1cac0135,0xdb0c0139,0x00000000}},	//   hsis, _ཕེན_, _uzbä, --, 
   {{0x7d0430ef,0x95c81920,0x3208022e,0xe9700137}},	//   ksis, _кула_, _qday_, _تۇۇد, 
   {{0xf5240dd4,0x7d0430f0,0x66d430f1,0x00000000}},	//   _འདྲཝ_, jsis, _iška, --, 
   {{0x7d0430f2,0x04400114,0x00000000,0x00000000}},	//   dsis, _жељн, --, --, 
   {{0x81ac09bd,0x7d0430f3,0x4e8800a7,0x320802d0}},	//   কেল_, esis, ащам_, _tday_, 
   {{0x7d0430f4,0x320830f5,0x2a7c0218,0x87780a7c}},	//   fsis, _uday_, xhwb_, באלי, 
   {{0x7d0430f6,0x9f58007f,0x00000000,0x00000000}},	// [2d50] gsis, _lepè_, --, --, 
   {{0x22900219,0x6ed4033f,0x0cd80118,0x00000000}},	//   mška_, _dąbr, _बढीम, --, 
   {{0x68e830f7,0x7d0430f8,0x00000000,0x00000000}},	//   _sted, asis, --, --, 
   {{0x213000e4,0x92bc00fe,0x6fb40101,0x8d5c0092}},	//   _ypyh_, েৱৰ_, _ومکا, _ታዋቂው_, 
   {{0x7d0430f9,0x22900427,0x9e58011a,0xf1bc1408}},	//   csis, nška_, _הכרט, ोधिन, 
   {{0x68e801f1,0x3e7c012c,0x48a830fa,0x9ac00327}},	//   _vted, _víte_, штем_, _ċċed, 
   {{0x68e8068f,0x6aa800df,0xca7401e0,0xd7ec0116}},	//   _wted, _ĉeff, _һуҡы, دكى_, 
   {{0x9f580100,0xba742a8b,0x79900036,0x3e7c01e1}},	//   _depè_, _قاقت, ühwä, _títe_, 
   {{0x68e803cd,0xf8ac0124,0xe48801b9,0x0dc40023}},	//   _uted, _аҩ_, ййид_, _ጸርፊ_, 
   {{0x9f580240,0xe12400d1,0x00000000,0x00000000}},	//   _qepë_, үмни, --, --, 
   {{0xf1a830fb,0x229002d5,0x00000000,0x00000000}},	//   _עס_, eška_, --, --, 
   {{0x7d0430fc,0x2eb430fd,0xd36c009f,0x00000000}},	//   ysis, ंतोत, اهَ_, --, 
   {{0xbbb8038e,0x7d040548,0x37d003d4,0xe3b030fe}},	//   _अर्क, xsis, _স্পৰ, برک_, 
   {{0x154030ff,0xf1e00131,0x00000000,0x00000000}},	//   _чешм, _ﺋﯩﻘﺘ, --, --, 
   {{0xa068005e,0x7d043100,0x10a0009d,0x00000000}},	//   _ғана_, wsis, хирн, --, 
   {{0x7d040680,0x22900010,0x9f6000e5,0x00000000}},	//   tsis, bška_, _épít_, --, 
   {{0x7d043101,0x00000000,0x00000000,0x00000000}},	// [2d60] usis, --, --, --, 
   {{0x7d043102,0x14d4011a,0xe1f801af,0x00000000}},	//   rsis, פועל_, _тѳҫ_, --, 
   {{0x7d0417ce,0x3ce00477,0xaca80014,0x0d20004e}},	//   ssis, sqiv_, تھَے_, _үүсү, 
   {{0x61e43103,0x81ac00bd,0x7d043104,0x1c1c3105}},	//   nckl, কেঃ_, psis, _पावल_, 
   {{0x7d043106,0x00000000,0x00000000,0x00000000}},	//   qsis, --, --, --, 
   {{0x91b80375,0xda6405af,0x00000000,0x00000000}},	//   זמני, _کاسي, --, --, 
   {{0x29180158,0x00000000,0x00000000,0x00000000}},	//   _åsan_, --, --, --, 
   {{0x7e643107,0x6aa80115,0x8b98011a,0x00000000}},	//   njip, _ĉefg, _הבלת, --, 
   {{0xa3c8000b,0x9f580098,0x7e64004c,0x1dbc00dc}},	//   लेस_, _depé_, ijip, ्धित, 
   {{0x05703108,0x2290151c,0x33743109,0x61e4002f}},	//   عايد, vška_, дгор, eckl, 
   {{0x4ce002f5,0x00000000,0x00000000,0x00000000}},	//   _পিছু, --, --, --, 
   {{0x1dbc0b7c,0x6b8003e0,0x00000000,0x00000000}},	//   ्धात, _ülge, --, --, 
   {{0x7e64000f,0x22900118,0x66d400d7,0xc174011c}},	//   djip, uška_, _uška, елящ, 
   {{0x2290310a,0x61e40363,0x82f42927,0x2eb40950}},	//   rška_, ackl, _کروز_, ंत्त, 
   {{0x9f48004e,0xb4b817cb,0x00000000,0x00000000}},	//   dabó_, चती_, --, --, 
   {{0x02a40953,0x8778008f,0xd24409a5,0x7e640200}},	//   _прым, זאלי, _хэки, gjip, 
   {{0xfeb804fb,0xf8cc00cd,0x00000000,0x00000000}},	// [2d70] سافت_, ाषाय, --, --, 
   {{0xddc4007f,0x629402fb,0xfd44009d,0x00000000}},	//   _makň, ézov, ээсн, --, 
   {{0xddc402e2,0xb5dc01ec,0x1c1c000d,0x7c8400d8}},	//   _lakň, _өнiм, _पारल_, хуте, 
   {{0xdfd0310b,0x00000000,0x00000000,0x00000000}},	//   _جيپ_, --, --, --, 
   {{0x7c580075,0x6aa800df,0xf4140183,0x78b80175}},	//   تلەر_, _ĉefd, ত্যৰ_, flvv, 
   {{0x9f480548,0x9f580241,0x6d4c0254,0x00000000}},	//   cabó_, _sepé_, mvaa, --, 
   {{0x6d4c310c,0x61e401e6,0x37d00183,0x89a401d9}},	//   lvaa, yckl, _স্বৰ, _کھاہ_, 
   {{0x24e8310d,0x8d700092,0xdbcc03e0,0xe91800c0}},	//   омии_, _የመስኖ_, _sıçm, _мобі_, 
   {{0x6d4c310e,0x12e402dd,0x6f140210,0x00000000}},	//   nvaa, _ﺍﻟﻨﻭ, hrzc, --, 
   {{0xefdc001f,0xa2e4310f,0x6d4c0108,0x876400f3}},	//   ሔራዊ_, моод, ivaa, _нђел, 
   {{0x3e7c066a,0x06d4015b,0x6d4c3110,0x1b7800df}},	//   _líta_, _সবকি, hvaa, ַטשע, 
   {{0x66d40006,0x7a243111,0x6d4c0037,0x6e2c01e4}},	//   _iško, _tōtō, kvaa, jfab, 
   {{0x61e40198,0x6d4c01a4,0x6f14033f,0xdb0c022a}},	//   rckl, jvaa, erzc, _rybí, 
   {{0x6e2c0196,0x2fc0030a,0x6d4c0ea0,0x9f480100}},	//   efab, _bzhg_, dvaa, dabò_, 
   {{0xa3c804fa,0x6d4c3112,0x6e2c3113,0x7e64020c}},	//   लेश_, evaa, ffab, tjip, 
   {{0x22900219,0x6d4c017a,0x3e7c3114,0x6e2c01bf}},	//   mško_, fvaa, _bíta_, gfab, 
   {{0x9f58025a,0xdb0c0316,0x6d4c1af3,0x1c442f8d}},	// [2d80] _gepî_, _vybí, gvaa, мнам, 
   {{0x28e00034,0x66d40219,0x7e64002d,0x00000000}},	//   _पढ़ि, _oško, sjip, --, 
   {{0x6d4c3115,0x22903116,0x00000000,0x00000000}},	//   avaa, nško_, --, --, 
   {{0x9f480100,0x6d4c01bf,0x7cf4022e,0x22900064}},	//   babò_, bvaa, bоrо, iško_, 
   {{0x0d8000ee,0xed34084c,0x5f740133,0x00000000}},	//   _алян, _пэрэ, _راگر, --, 
   {{0xd6e83117,0x3fb008b0,0x6aa8010f,0xb4bc000d}},	//   офил_, ﺳﺘﺎﻧ, _ĉefe, _आठे_, 
   {{0x7bdc3118,0xc044044e,0xeb300137,0x73d8010b}},	//   _igru, _ብዝተፈ, _مۉلد, үдир_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x66d40024,0x8500009f,0x229000c0,0xc5840116}},	//   _iškl, نوين, eško_, ۋھۇم_, 
   {{0xb4b816ae,0x08c03119,0x68ec311a,0xc7ac00e5}},	//   चते_, _абун, íade, اڑے_, 
   {{0xd628311b,0xa3c80490,0x7bdc01a6,0x6d4c05b8}},	//   _може_, लेल_, _mgru, zvaa, 
   {{0xae1c13f5,0x6d4c01f4,0x987c0213,0x00000000}},	//   _फाइन_, yvaa, mçıq_, --, 
   {{0x1048311c,0x44f002d5,0x7bdc311d,0x12e40150}},	//   ояви_, _апіс, _ogru, _ﺍﻟﻬﻭ, 
   {{0x7bdc034c,0x6d4c311e,0xc058311f,0x9f48067c}},	//   _ngru, vvaa, міс_, vabò_, 
   {{0xf54800b4,0xce68013e,0x37d003d4,0x66d4022a}},	//   _hụ_, орад_, _স্তৰ, _oškl, 
   {{0x7bdc2815,0x6d4c3120,0x78740ba1,0xf5480051}},	//   _agru, tvaa, _dàvi, _kụ_, 
   {{0xf54801f2,0xe1c00184,0x6d4c3121,0x7afc0067}},	// [2d90] _jụ_, _бөрй, uvaa, _awrt, 
   {{0xf5480521,0x6d4c3122,0x80b40022,0x3e7c0306}},	//   _mụ_, rvaa, _ибых, _víta_, 
   {{0x3a240048,0x6e2c3123,0x6d4c3124,0x6aa80115}},	//   _bcmp_, pfab, svaa, _ĉefb, 
   {{0x1dbc0d2c,0x6d4c0d27,0x3a240393,0x3e7c0241}},	//   ्धशत, pvaa, _ccmp_, _títa_, 
   {{0x80183125,0xf5483126,0x3a240334,0x3944054e}},	//   _عزیز_, _nụ_, _dcmp_, _csms_, 
   {{0xb4b80a59,0xf41400fe,0xa3c80118,0x00000000}},	//   चतो_, ত্তৰ_, लेँ_, --, 
   {{0x7afc00a9,0x7c3001d3,0x00000000,0x00000000}},	//   _gwrt, ékrő, --, --, 
   {{0xf5483127,0x22900010,0x7bdc0210,0x66c400e4}},	//   _bụ_, vško_, _zgru, kóke, 
   {{0xf54807ae,0x3944073c,0x386c01bf,0x987c06be}},	//   _cụ_, _gsms_, _fodr_, açıq_, 
   {{0x291c3128,0xf5480016,0x7b0801b8,0x95803129}},	//   muwa_, _dụ_, _ästä, улье, 
   {{0x291c312a,0xa3c809fd,0xf6740882,0x66d402fb}},	//   luwa_, लें_, ṛtaṃ_, _uško, 
   {{0xbbdc1533,0x22900b3d,0xf5480051,0xc5b0004e}},	//   _बल्क, rško_, _fụ_, _ирлө, 
   {{0xf548312b,0x2a6c0369,0x291c312c,0x787400db}},	//   _gụ_, _moeb_, nuwa_, _sàvi, 
   {{0x2a6c312d,0xe4c40116,0x1c1c00c5,0x00000000}},	//   _loeb_, _яйли, _पाइल_, --, 
   {{0x291c312e,0x02c8016c,0xb4240345,0xf5480051}},	//   huwa_, _оқои_, _شعوو, _zụ_, 
   {{0x291c1d1f,0x72940124,0x9400013f,0x7bdc312f}},	//   kuwa_, _ашьх, ɑkɑ_, _sgru, 
   {{0x291c3130,0x7afc0042,0x3a24045a,0x26cc01e7}},	// [2da0] juwa_, _swrt, _rcmp_, imeo_, 
   {{0x291c3131,0x1ab800dc,0xcfb800eb,0x00000000}},	//   duwa_, ेष्ठ, ঃখজন, --, 
   {{0x386c0077,0xc1e4005e,0xefd40092,0xabc41d00}},	//   _rodr_, _ﺍﯞﺩﺍ, ጫቸው_, _ﺩﺍﻧﺎ, 
   {{0x39443132,0x6aa80115,0x26cc01e4,0xb4bc000d}},	//   _psms_, _ĉefc, jmeo_, _आठ्_, 
   {{0x3ea03133,0x291c3134,0x38c83135,0x1c1c0073}},	//   mnit_, guwa_, واتی_, _पाऊल_, 
   {{0x7bdc0209,0x3ea03136,0xf54802e3,0x9f580306}},	//   _ugru, lnit_, _rụ_, _lepí_, 
   {{0x3ea03137,0x291c0333,0x5018011a,0xf5480051}},	//   onit_, auwa_, לוסו, _sụ_, 
   {{0x3ea03138,0x291c23db,0xb4b800dc,0x39440037}},	//   nnit_, buwa_, चत्_, _tsms_, 
   {{0x3ea03139,0x291c009a,0x3e7c0118,0x491407f7}},	//   init_, cuwa_, _líto_, _नियो_, 
   {{0xf54801dc,0x3ea0313a,0xaee40882,0x245015bf}},	//   _vụ_, hnit_, nuṣy, لچىس, 
   {{0x3ea0313b,0x3e7c01e1,0x1c1c000d,0x00000000}},	//   knit_, _níto_, _पाईल_, --, 
   {{0xf548001e,0x9584313c,0x8778008f,0xd6280c9e}},	//   _tụ_, _плее, _מאבי, _ходе_, 
   {{0x3ea000bc,0x00000000,0x00000000,0x00000000}},	//   dnit_, --, --, --, 
   {{0x3ea0313d,0xb624313e,0xbacc02dd,0x00000000}},	//   enit_, _ﯨﻦ_, _ﺑﺎﺑﺎ, --, 
   {{0x78740ffb,0xbfa8313f,0x291c3140,0xc05801ce}},	//   _fàvv, етте_, zuwa_, хія_, 
   {{0x3ea03141,0x291c3142,0x8d840137,0x03b8011a}},	//   gnit_, yuwa_, нузд, _מצול, 
   {{0xdb0c0232,0x2a6c0369,0x291c3143,0x2dd42bda}},	// [2db0] _rybá, _roeb_, xuwa_, тжар, 
   {{0x3ea03144,0x00000000,0x00000000,0x00000000}},	//   anit_, --, --, --, 
   {{0x291c3145,0x2a6c000d,0xefc40023,0x26cc0051}},	//   wuwa_, _poeb_, _ጸግዒ_, ymeo_, 
   {{0x291c3146,0x29d42928,0x81ac09bd,0x3ea03147}},	//   tuwa_, نياس, কেও_, cnit_, 
   {{0xddc403b9,0xdde802f2,0x00000000,0x00000000}},	//   _inkş, _ترپه_, --, --, 
   {{0x291c3148,0xe7383149,0x1d140375,0x79a40022}},	//   ruwa_, дек_, _בקשר_, ырхе, 
   {{0x291c314a,0x8aa40212,0x18640d1d,0x78a400e4}},	//   suwa_, _зрад, тащи_, éiva, 
   {{0x81ac11ba,0x291c314b,0xd6cc314c,0x77a80014}},	//   কেট_, puwa_, يقو_, رێنہ_, 
   {{0x26cc314d,0xe57000c6,0x1660005b,0x995800a2}},	//   rmeo_, شطة_, рвым, jäňe_, 
   {{0x290c0421,0xf990314e,0x3ea0314f,0x00000000}},	//   _ivea_, _طبق_, znit_, --, 
   {{0x3ea03150,0xae20012d,0x00000000,0x00000000}},	//   ynit_, यलान_, --, --, 
   {{0x290c0158,0x00000000,0x00000000,0x00000000}},	//   _kvea_, --, --, --, 
   {{0x3ea000bc,0x3e7c01ef,0x00000000,0x00000000}},	//   vnit_, _síto_, --, --, 
   {{0x3ea00076,0x00000000,0x00000000,0x00000000}},	//   wnit_, --, --, --, 
   {{0x4424010a,0xdee43151,0x3ea03152,0x544000d1}},	//   _icn_, тоби, tnit_, _ئۆپك, 
   {{0x3ea03153,0x44240072,0xdb0c0129,0xc1b4008e}},	//   unit_, _hcn_, _àdéf, _бәгы, 
   {{0xa0681411,0x4424004d,0x81ac0154,0x00000000}},	// [2dc0] _жапа_, _kcn_, কেজ_, --, 
   {{0x3ea03154,0x6aa800c8,0x442400b5,0x3e7c00d0}},	//   snit_, _ĉefa, _jcn_, _títo_, 
   {{0x290c3155,0xa3d03156,0x3ea03157,0x1a281422}},	//   _avea_, वधि_, pnit_, джеи_, 
   {{0x3ea00cfe,0x62840051,0x1c1c0037,0x00000000}},	//   qnit_, nhko, _पाकल_, --, 
   {{0x44243158,0x588409a5,0x98a40427,0x00000000}},	//   _ocn_, кыка, stoč_, --, 
   {{0xdca43159,0x68ec315a,0x44240334,0x38c8315b}},	//   _раги, íada, _ncn_, راشی_, 
   {{0xabc40184,0x290c0254,0x00000000,0x00000000}},	//   _барҙ, _evea_, --, --, 
   {{0x4424315c,0xddc4007f,0x752401e4,0x00000000}},	//   _acn_, _lakō, _ĥizb, --, 
   {{0x4424315d,0x9484315e,0xd4c4300e,0x62840067}},	//   _bcn_, вынд, ксоп, dhko, 
   {{0x442400db,0x73c40184,0x7414315f,0x12e402dd}},	//   _ccn_, ләйе, دودا, кімг, 
   {{0x8c1804ac,0x44240334,0x04603160,0xd7040124}},	//   וויי, _dcn_, ртым, _рзеи, 
   {{0x43901d0b,0x62843161,0xabc40150,0x82f40066}},	//   раюс, ghko, _ﺩﺍﻴﺎ, کریز_, 
   {{0x76400296,0x4424005c,0xf4343162,0x648c00a2}},	//   memy, _fcn_, _белэ, _iºin, 
   {{0x1c1c16f0,0x74140d28,0x78740ffb,0x752000e2}},	//   _पागल_, _صوبا, _tàvu, mumz, 
   {{0x66c401ed,0x7f943163,0x00000000,0x00000000}},	//   lóka, аарх, --, --, 
   {{0x62843164,0xc25400a7,0x645c00e2,0x00000000}},	//   chko, _вкъщ, ēsie, --, 
   {{0x75200921,0x51841ed2,0xfd74084c,0x6e9402dd}},	// [2dd0] numz, _шука, алтэ, _ەلجا, 
   {{0x76403165,0xa3c83166,0x5dc4215c,0x00000000}},	//   hemy, लेक_, امكە, --, 
   {{0x75200921,0x7640023a,0x290c3167,0x6e94014b}},	//   humz, kemy, _svea_, _бину, 
   {{0x75200fec,0x22803168,0xc330011a,0xc0cc0023}},	//   kumz, _kóka_, יוע_, ኣዛር_, 
   {{0xc9840075,0x8d843169,0x66c41686,0x12e40220}},	//   خشاي, _рунд, jóka, _ﺍﻟﻴﻭ, 
   {{0xb4ac0316,0x66d40006,0x6da40588,0xa5240107}},	//   कको_, _iški, _аиҭа, ҳмид, 
   {{0x4424316a,0xe738316b,0xdd100432,0xdc980677}},	//   _rcn_, хей_, _küşt, _טישל, 
   {{0x4424316c,0x764001bf,0x3774064e,0x00000000}},	//   _scn_, gemy, рышс, --, 
   {{0xdd1007c4,0x75201cdf,0x290c03a0,0x39b800a8}},	//   _müşt, gumz, _uvea_, _алтэ_, 
   {{0x229009a8,0x7790158b,0xddc40064,0x00000000}},	//   mški_, _ژیوا, _jokš, --, 
   {{0x22900e04,0x76400064,0x00000000,0x00000000}},	//   lški_, bemy, --, --, 
   {{0x66c408a7,0x22800252,0xe284013e,0xddc4316d}},	//   bóka, _bóka_, улми, _lokš, 
   {{0xddc400b0,0x7520009a,0xf1a4316e,0x6608316f}},	//   _pakō, cumz, арён, maek, 
   {{0x62843170,0x03640050,0x4424147b,0x66083171}},	//   shko, _لٔتی_, _ucn_, laek, 
   {{0x26dc3172,0xe2983173,0xa3c83174,0x66d401a6}},	//   _kiwo_, _пак_, लेख_, _aški, 
   {{0x64403175,0x66083176,0x26dc020c,0x61440022}},	//   leli, naek, _jiwo_, _беиа, 
   {{0x62940230,0xdd1003ee,0xddc40024,0x26dc01e1}},	// [2de0] _imyo, _düşt, _bokš, _miwo_, 
   {{0x76403177,0x21200115,0x22403178,0x2c0000cf}},	//   zemy, mukh_, lekk_, жүрм, 
   {{0x66083179,0x6440084c,0x2008317a,0x30040137}},	//   kaek, ieli, mabi_, _өзөг, 
   {{0x6440077e,0x2008317b,0x66c4317c,0x60dc014f}},	//   heli, labi_, yóka, _hipm, 
   {{0x6608317d,0x60dc0139,0x0930009a,0x00000000}},	//   daek, _kipm, مروج, --, 
   {{0x2008317e,0x6440317f,0x2240003d,0x26dc0076}},	//   nabi_, jeli, hekk_, _aiwo_, 
   {{0x64403180,0xd6d83181,0x76403182,0x26dc0699}},	//   deli, нти_, temy, _biwo_, 
   {{0x26dc0b45,0x21200b6f,0xdca400c2,0x64403183}},	//   _ciwo_, kukh_, _раҳи, eeli, 
   {{0x76403184,0xa508040d,0x26dc3185,0x22403186}},	//   remy, نىيە_, _diwo_, dekk_, 
   {{0x64403187,0x75203188,0xc214013f,0x6294037e}},	//   geli, rumz, _adɔ_, _amyo, 
   {{0x20083189,0x75200065,0x2874030d,0x00000000}},	//   dabi_, sumz, _тытр, --, 
   {{0x75200451,0x8cc81d15,0x66c401d3,0x741404f2}},	//   pumz, _तीनो, lókn, دوگا, 
   {{0x6440318a,0x20080337,0xdd102ca8,0xc6b4010f}},	//   beli, fabi_, _rüşt, _גלאז_, 
   {{0x6440318b,0x62940a49,0x657c318c,0x2ef41d1c}},	//   celi, _emyo, øshe, изгр, 
   {{0x447804ac,0x9f580093,0x60dc047e,0x26dc318d}},	//   _אנגע, _pepá_, _dipm, _yiwo_, 
   {{0x6aa8010f,0x2280318e,0x00000000,0x00000000}},	//   _ĉefo, _tóka_, --, --, 
   {{0xddc40024,0x614403cc,0x60d802e2,0x00000000}},	// [2df0] _pokš, _نىيە, ňtma, --, 
   {{0x66f002b1,0x229009a8,0x20080009,0x70540244}},	//   _hāke, vški_, cabi_, _ئندا, 
   {{0x8bc400a6,0x66d40024,0x66f000b8,0x66c401d3}},	//   усад, _iškv, _kāke, dókn, 
   {{0x6440318f,0xa3c828d4,0x7ff40424,0xad241c62}},	//   zeli, लेट_, _پسیا, _پىسى, 
   {{0x64403190,0x66f03191,0x66080124,0x00000000}},	//   yeli, _māke, vaek, --, 
   {{0x64403192,0x26dc02bd,0x48b000eb,0x00000000}},	//   xeli, _siwo_, টগ্র, --, 
   {{0x26dc3193,0x66083194,0xdb640023,0x00000000}},	//   _piwo_, taek, _ሰሚዖም_, --, 
   {{0x64403195,0x7f3c00c8,0x20083196,0x00000000}},	//   weli, געהו, zabi_, --, 
   {{0xe5a404a9,0x200804ce,0x66083197,0x26dc01e2}},	//   рипи, yabi_, raek, _viwo_, 
   {{0x26dc3198,0x66083199,0x2008009d,0x6440319a}},	//   _wiwo_, saek, xabi_, ueli, 
   {{0x6264319b,0x2008319c,0x6aa808fb,0x291c0083}},	//   авна, vabi_, _kjef, lrwa_, 
   {{0x2008319d,0x60dc002d,0x291c0099,0xa5f80640}},	//   wabi_, _sipm, orwa_, _реду_, 
   {{0x273001dc,0x2008319e,0x2240319f,0xa3c831a0}},	//   _hơn_, tabi_, rekk_, लेज_, 
   {{0x69c8009f,0x644031a1,0x224031a2,0x60dc014f}},	//   _mzee, qeli, sekk_, _qipm, 
   {{0x200831a3,0x1e9431a4,0xfe782dc3,0xd00431a5}},	//   rabi_, арар, гүн_, ресе_, 
   {{0x200831a6,0x291c083a,0x3e7c0085,0x62940472}},	//   sabi_, krwa_, _kíti_, _umyo, 
   {{0x69c802ea,0x614431a7,0x1d081a92,0x60dc02f0}},	// [2e00] _nzee, _тепа, тези_, _tipm, 
   {{0x6aa80810,0x291c1529,0x20080429,0x66d40064}},	//   _ajef, drwa_, qabi_, _išku, 
   {{0x9ea831a8,0xa3c80490,0x291c31a9,0x6aa8143a}},	//   _авна_, लेच_, erwa_, _bjef, 
   {{0x533404ac,0xbe3400db,0x228001e1,0xcb640114}},	//   ינען_, _دۉرب, _móko_, јаце_, 
   {{0x186831aa,0x6aa80139,0x3e7c0162,0x22800ca8}},	//   кади_, _djef, _níti_, _lóko_, 
   {{0x69c803ec,0x6aa8005c,0x3e7c0332,0x00000000}},	//   _dzee, _ejef, _síth_, --, 
   {{0x3cec03f3,0xcb641142,0x27300016,0x69c831ab}},	//   _अंडे_, _каре_, _cơn_, _ezee, 
   {{0x66c431ac,0x3e7c03b2,0x998402b5,0x27300208}},	//   sókn, _bíti_, ngoū_, _dơn_, 
   {{0x66f002b1,0xf8b82cc8,0x3e7c00d0,0x22900010}},	//   _rāke, _йөк_, _cíti_, nšku_, 
   {{0x7ae031ad,0x22900024,0x66f00055,0x843000d4}},	//   _himt, išku_, _sāke, оньє, 
   {{0x66f00325,0x7ae031ae,0xa824247f,0xdd2000b8}},	//   _pāke, _kimt, _اۋىل_, _dįũy, 
   {{0x22800248,0x7ae0025c,0x69dc013a,0x00000000}},	//   _dóko_, _jimt, _úsec, --, 
   {{0x7ae0003e,0x948431af,0x22900306,0xe6b40066}},	//   _mimt, _выйд, jšku_, _النگ, 
   {{0x66f002b5,0x04401b04,0x6aa8008f,0x78b8022e}},	//   _wāke, _мечн, _ĉefm, novv, 
   {{0xceb8026a,0x66f002b1,0xddc40034,0x03a00a5b}},	//   вља_, _tāke, _nakł, _миљо, 
   {{0x9e9431b0,0x7ae031b1,0x49140118,0x00000000}},	//   ماقچ, _nimt, _निलो_, --, 
   {{0x291c0223,0x78b800b5,0xb7f81025,0x7094014b}},	// [2e10] xrwa_, kovv, ुराम_, _гапф, 
   {{0x6aa831b2,0x32080076,0xc1bc0375,0x69c80036}},	//   _sjef, _heay_, _במחש, _rzee, 
   {{0x7ae0020b,0x39f401f2,0x3208062c,0x69c804e6}},	//   _bimt, _ịzọ_, _keay_, _szee, 
   {{0x291c2035,0xba7431b3,0x7ae031b4,0x9f58010e}},	//   trwa_, يانت, _cimt, _depä_, 
   {{0x27300016,0x7ae031b5,0x32080076,0x291c0433}},	//   _sơn_, _dimt, _meay_, urwa_, 
   {{0x6c840597,0x291c1556,0x66e431b6,0x66c431b7}},	//   _السم, rrwa_, бока, tóko, 
   {{0x06dc04c5,0x7ae031b8,0x3e7c00bc,0xd7ec31b9}},	//   _যৌগি, _fimt, _síti_, ركي_, 
   {{0x7ae002d5,0x291c1529,0x6aa801f0,0x69c80036}},	//   _gimt, prwa_, _ujef, _tzee, 
   {{0xddc4068f,0x69c801c8,0x78b800e4,0x22800248}},	//   _zakł, _uzee, bovv, _sóko_, 
   {{0xe5a431ba,0x7ae031bb,0x6ab8127b,0x216800c2}},	//   _қили, _zimt, lowf, ҳими_, 
   {{0x7ae00218,0xe3b000c6,0x68e8054e,0x58b8008f}},	//   _yimt, ثرة_, _hued, _עמעצ, 
   {{0x68e031bc,0x7b180084,0x68e831bd,0x09d80154}},	//   _hild, ḓul, _kued, _ড্যা, 
   {{0x68e031be,0x6f0403ac,0x6474013d,0x3cec0210}},	//   _kild, _awhc, _гыйф, _अंधे_, 
   {{0x68e031bf,0x68e80433,0x232831c0,0x44f831c1}},	//   _jild, _mued, _боки_, _iª_, 
   {{0x68e80a40,0x44f80005,0x1ea80451,0x32080076}},	//   _lued, _hª_, هاري_, _feay_, 
   {{0x320800ad,0x68e806af,0x00000000,0x00000000}},	//   _geay_, _oued, --, --, 
   {{0x6ab801ab,0x7ae00006,0x68e002d0,0x22900118}},	// [2e20] dowf, _rimt, _oild, ušku_, 
   {{0x7ae031c2,0x44f831c3,0x225003f0,0x00000000}},	//   _simt, _mª_, _hayk_, --, 
   {{0x225031c4,0xe7240345,0x00000000,0x00000000}},	//   _kayk_, _تڵ_, --, --, 
   {{0x68e80a40,0x225002d1,0x68e00368,0x7ae031c5}},	//   _bued, _jayk_, _aild, _qimt, 
   {{0x7ae00218,0x225031c6,0x9f58007c,0xd838009d}},	//   _vimt, _mayk_, _depå_, гэй_, 
   {{0x68e831c7,0x68e031c8,0x00000000,0x00000000}},	//   _dued, _cild, --, --, 
   {{0x68e031c9,0x78b831ca,0x44f801e4,0x7ae031cb}},	//   _dild, rovv, _aª_, _timt, 
   {{0x68e804e6,0x68e031cc,0x66c42507,0x00000000}},	//   _fued, _eild, bókm, --, 
   {{0xd5b81e76,0x09f4007b,0x5984004e,0x00000000}},	//   ыск_, _طفلة_, _улаб, --, 
   {{0x68e026b8,0x44f80005,0xf4b800cc,0x657c03cd}},	//   _gild, _dª_, ীদ্ব, øsha, 
   {{0x44f80077,0x291805ac,0x225006be,0xa5bc0153}},	//   _eª_, _åsar_, _bayk_, ngųj, 
   {{0x8500021a,0x25a80552,0x68e031cd,0x6aa8010f}},	//   _کوون, _žale_, _zild, _ĉefk, 
   {{0x68e0006c,0x32080076,0x938800d1,0x7f94010b}},	//   _yild, _veay_, _әсла_, җатх, 
   {{0x68e00050,0x66f004fe,0x00000000,0x00000000}},	//   _xild, _hāka, --, --, 
   {{0x66f031ce,0xfd7405f5,0x66d40006,0x00000000}},	//   _kāka, үлсэ, _iškr, --, 
   {{0x82a41fbe,0x66f00171,0x00000000,0x00000000}},	//   _најж, _jāka, --, --, 
   {{0x66f031cf,0xdc340139,0x00000000,0x00000000}},	// [2e30] _māka, _qäğb, --, --, 
   {{0x68e831d0,0x66f00069,0x6ad02314,0x00000000}},	//   _rued, _lāka, तग्र, --, 
   {{0x68e831d1,0x68e001b9,0xa0340375,0xdb2401b9}},	//   _sued, _rild, _ואתה_, قولی, 
   {{0x68e831d2,0x66f00029,0xdc340139,0x00000000}},	//   _pued, _nāka, _täğb, --, 
   {{0x68e831d3,0x68e031d4,0xa96831d5,0xe94431d6}},	//   _qued, _pild, рила_, ترای, 
   {{0x68e0006c,0x6d5c31d7,0x00000000,0x00000000}},	//   _qild, _irsa, --, --, 
   {{0x68e031d8,0x66f00171,0x00000000,0x00000000}},	//   _vild, _bāka, --, --, 
   {{0xf42431d9,0x9ba008c9,0x68e031da,0x68e831db}},	//   _འཐུད_, _تەمى, _wild, _tued, 
   {{0x6aa801e4,0x66c400e5,0x00000000,0x00000000}},	//   _ĉefh, lókk, --, --, 
   {{0x6d5c08ad,0x22500309,0x68e00c8c,0x67d431dc}},	//   _mrsa, _sayk_, _uild, _дозу, 
   {{0xf868004b,0x00000000,0x00000000,0x00000000}},	//   _دملي_, --, --, --, 
   {{0x6d5c31dd,0x00000000,0x00000000,0x00000000}},	//   _orsa, --, --, --, 
   {{0xa50831de,0x3e7c0579,0x205431df,0x7a4008a5}},	//   _тела_, _mítt_, отвр, _hátæ, 
   {{0x394031e0,0x6e3c31e1,0x225002d1,0xdee431e2}},	//   çisi_, _absb, _wayk_, жови, 
   {{0x6d5c31e3,0x9e6431e4,0x78a401e7,0x00000000}},	//   _arsa, يارن, éivi, --, 
   {{0x6d5c31e5,0x6e3c0175,0x3e7c03b2,0x00000000}},	//   _brsa, _cbsb, _nítt_, --, 
   {{0x20740fab,0x6d5c01ab,0x648c00c6,0xa0740276}},	// [2e40] _дунё, _crsa, _cúig, _дынш, 
   {{0x6d5c09a8,0x648c01e7,0x00000000,0x00000000}},	//   _drsa, _dúig, --, --, 
   {{0x6d5c31e6,0x9b4431e7,0xf1a804d3,0x3e7c0162}},	//   _ersa, تناو, _نایه_, _bítt_, 
   {{0x6d5c03b9,0x19c40353,0x99840472,0x00000000}},	//   _frsa, обем, يلاو, --, 
   {{0x3ea031e8,0x66f00325,0x9b680032,0x3940004e}},	//   miit_, _rāka, ышҡа_, ïis_, 
   {{0x3ea031e9,0x66f031ea,0xc01c03d4,0x00000000}},	//   liit_, _sāka, দ্ৰণ_, --, 
   {{0x66f031eb,0x61f40142,0x00000000,0x00000000}},	//   _pāka, _ofyl, --, --, 
   {{0xad2c0201,0x3ea031ec,0xda6431ed,0x8c1c0f22}},	//   _ድርጅቶ, niit_, _باسي, ন্দন_, 
   {{0x18a431ee,0x94a80261,0x1bec01ad,0x95c80064}},	//   _даам, итоа_, _जलाल_, шука_, 
   {{0x3ea031ef,0x7a400ad9,0x66f002b1,0xe8b031f0}},	//   hiit_, _fátæ, _wāka, _كەنج, 
   {{0x66f00053,0x3ea031f1,0x00000000,0x00000000}},	//   _tāka, kiit_, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x3ea031f2,0x3b500023,0x41e401ec,0x6488009d}},	//   diit_, _ዘጋጠመ, діра, рсөг_, 
   {{0x339406a6,0x66d402f0,0x00000000,0x00000000}},	//   _налё, _uškr, --, --, 
   {{0xc05810f5,0x3ea00eda,0x61f40042,0x0ee8023a}},	//   ція_, fiit_, _ffyl, рьги_, 
   {{0x3ea00af5,0x82f431f3,0x6d5c31f4,0x0dc80395}},	//   giit_, _بروز_, _prsa, аузи_, 
   {{0x98c80034,0xddd4010e,0x00000000,0x00000000}},	// [2e50] िताए, ndyň, --, --, 
   {{0x3e7c0579,0x6d5c2a53,0x8bc431f5,0xcee831f6}},	//   _sítt_, _vrsa, осед, _پردن_, 
   {{0xa80004d4,0x3ea031f7,0x66c4032e,0x00000000}},	//   _íñig, biit_, bókh, --, 
   {{0x6d5c31f8,0x3ea031f9,0xddd400a2,0x00000000}},	//   _trsa, ciit_, kdyň, --, 
   {{0x6e2c31fa,0x6d5c31fb,0x6f1431fc,0x3e7c041e}},	//   mgab, _ursa, lszc, _vítt_, 
   {{0x66e431fd,0x6d4c31fe,0x6e2c31ff,0xd7a40d79}},	//   пока, mwaa, lgab, गपंच, 
   {{0x6d4c3200,0x3e7c022c,0x6e2c0083,0x2ca000b5}},	//   lwaa, _títt_, ogab, mihd_, 
   {{0x6e2c2747,0x7b181682,0x98f40131,0x6d4c3201}},	//   ngab, ḓuh, زغۇچ, owaa, 
   {{0xad2c0020,0x6d4c3202,0x6e2c3203,0x7754001f}},	//   _ድርጊቶ, nwaa, igab, መሰረተ, 
   {{0x6d4c3204,0x6e2c3205,0x3ea03206,0xe3b00127}},	//   iwaa, hgab, ziit_, فرج_, 
   {{0x6e2c3207,0x6d4c3208,0x3ea03209,0x7790320a}},	//   kgab, hwaa, yiit_, _لیوا, 
   {{0x6d4c320b,0x66f00374,0xd5ac0214,0x20180332}},	//   kwaa, _hāko, ئفی_, _sdpi_, 
   {{0x3ea00af5,0x66f018a6,0x6f14068f,0x7b180943}},	//   viit_, _kāko, eszc, ṱuk, 
   {{0x6e2c320c,0xd57402e4,0x3ea0320d,0x3b500023}},	//   egab, _מתנה_, wiit_, _ዘጋጥመ, 
   {{0x66f0320e,0x6e2c2155,0x3ea0320f,0x5f04166f}},	//   _māko, fgab, tiit_, язва, 
   {{0x6e2c3210,0x66f0123c,0x6d4c3211,0x3ea00194}},	//   ggab, _lāko, fwaa, uiit_, 
   {{0x6d4c3212,0x3ea03213,0x5ce4215c,0x752401e4}},	// [2e60] gwaa, riit_, سكال, _ĥizk, 
   {{0x3ea03214,0x66f000da,0x6e2c3215,0x62843216}},	//   siit_, _nāko, agab, lkko, 
   {{0x6d4c2442,0x3ea03217,0x6e2c3218,0x628401f5}},	//   awaa, piit_, bgab, okko, 
   {{0x66c408a7,0x6d4c0a49,0xddc400ef,0x00000000}},	//   bóki, bwaa, _rakņ, --, 
   {{0x6284023a,0x0d2004a9,0xbdc801d3,0x69dc03b2}},	//   ikko, _пүтү, _گدھے_, _úsel, 
   {{0x7b840150,0x648c00ae,0x62840254,0x913800df}},	//   _قازە, _lúib, hkko, מענק, 
   {{0x6aa800df,0x5018010f,0x63ac0055,0x00000000}},	//   _ĉefv, צוקו, _śann, --, 
   {{0x25a80153,0x00000000,0x00000000,0x00000000}},	//   _žala_, --, --, --, 
   {{0x34941a5c,0x12e40220,0x6f140210,0x5984010a}},	//   дапр, _ﺍﻟﻘﻭ, zszc, _элаб, 
   {{0x62843219,0x6f140034,0xc914008d,0x6e2c321a}},	//   ekko, yszc, _מחמת_, zgab, 
   {{0x6d4c0196,0x6e2c2ce5,0x66f00171,0x00000000}},	//   zwaa, ygab, _jākl, --, 
   {{0x6d4c321b,0x66f00171,0x00000000,0x00000000}},	//   ywaa, _mākl, --, --, 
   {{0xdb0c0205,0x00d801ec,0x6f140210,0x00000000}},	//   _aybü, _ﺜﺎﺒﺘ, wszc, --, 
   {{0xe520038e,0x6284321c,0x6e2c0009,0x3944036e}},	//   _मिति_, akko, wgab, _mpms_, 
   {{0x6e2c321d,0x6d4c0752,0xc4380375,0x2eec01e4}},	//   tgab, wwaa, _לתגי, ĉefo_, 
   {{0x6284321e,0x6d4c321f,0x6f14033f,0x00000000}},	//   ckko, twaa, rszc, --, 
   {{0x6e2c3220,0x6d4c0280,0x1dc001c6,0x506400c0}},	// [2e70] rgab, uwaa, вөрн, _етна, 
   {{0x6e2c3221,0x6d4c3222,0x3df405f5,0x228003b2}},	//   sgab, rwaa, _үзэс, _róki_, 
   {{0x6d4c057b,0x7afc0175,0x3e7c00bc,0x648c01e7}},	//   swaa, _ctrt, _vítr_, _húic, 
   {{0xfbd02ab5,0x66f000da,0x6d4c01a4,0x2280033f}},	//   اتك_, _sāko, pwaa, _póki_, 
   {{0x6d4c3223,0x66f002b1,0x2d4c041a,0xcfa83224}},	//   qwaa, _pāko, _uže_, _خاکم_, 
   {{0x6aa800c8,0xc5f429d9,0x18643225,0xe7303226}},	//   _ĉefu, ीर्य_, даши_, نصب_, 
   {{0x62840b1a,0x648c01e7,0x66f00171,0x00000000}},	//   ykko, _lúic, _vāko, --, 
   {{0x3694023a,0xbb58037e,0x228003b2,0x57f00116}},	//   ешьс, _useで_, _tóki_, нпәт, 
   {{0x39440ac5,0x09d8015b,0x66f00374,0x648c007b}},	//   _gpms_, _ড্রা, _tāko, _núic, 
   {{0x544000d1,0x00000000,0x00000000,0x00000000}},	//   نچىك, --, --, --, 
   {{0x4788010a,0x00000000,0x00000000,0x00000000}},	//   _усам_, --, --, --, 
   {{0x21a400d1,0x62843227,0x00000000,0x00000000}},	//   димм, ukko, --, --, 
   {{0x62840664,0x00000000,0x00000000,0x00000000}},	//   rkko, --, --, --, 
   {{0x6284033d,0x648c007b,0x6304036b,0xc4d80063}},	//   skko, _dúic, _قوتل, _уђе_, 
   {{0x23d03228,0xdfd000ec,0xd36c00f1,0x00000000}},	//   _हरिद, ئيز_, _نهو_, --, 
   {{0x1ea83229,0xd05406be,0xddc40118,0x00000000}},	//   زازي_, _mixə, _zakř, --, 
   {{0x7afc0334,0xb0f801c0,0xdc7400c7,0x00000000}},	// [2e80] _strt, _нээх_, мыжь, --, 
   {{0x0c200209,0x3944045a,0xbc7400cf,0x00000000}},	//   кмун, _rpms_, رۇزب, --, 
   {{0xdb0800a2,0x00000000,0x00000000,0x00000000}},	//   _önür, --, --, --, 
   {{0xba180472,0x00000000,0x00000000,0x00000000}},	//   سيتا_, --, --, --, 
   {{0x6aa8010f,0xda700a81,0x66c400c7,0x7d2400e5}},	//   _ĉeft, _یُس_, nóku, _سہان, 
   {{0x7b1806d6,0xd05403b9,0xd05c03b9,0x00000000}},	//   ḓuv, _bixə, _buqə, --, 
   {{0x66c400e4,0x8cb0012d,0x00000000,0x00000000}},	//   hóku, _आदतो, --, --, 
   {{0xdb0c0034,0x8