use strict;
use warnings;

package App::Embra::Util;
$App::Embra::Util::VERSION = '0.001'; # TRIAL
# ABSTRACT: place for misc. code

use String::RewritePrefix;


sub expand_config_package_name {
    my( $class, $pkg_name ) = @_;
    String::RewritePrefix->rewrite(
        {
          '=' => '',
          '@' => 'App::Embra::PluginBundle::',
          ''  => 'App::Embra::Plugin::',
        },
        $pkg_name,
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Util - place for misc. code

=head1 VERSION

version 0.001

=head1 METHODS

=head2 expand_config_package_name

    App::Embra::Util->expand_config_package_name( $pkg_name )

Returns C<$pkg_name> rewritten into a package name. If C<$pkg_name> starts with C<=>, it is treated as a package name and returned unmodified. Otherwise, a copy of it is prefixed with C<App::Embra::Plugin> (and then C<Bundle>, if it starts with C<@>) and returned.

Used by L<App::Embra::MVP::Assembler> and L<App::Embra::App::Command::listdeps>, to turn section names in config files into package names.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
