# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails;
  use Moose;
  has Command => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Interval => (is => 'ro', isa => 'Int');
  has Retries => (is => 'ro', isa => 'Int');
  has StartPeriod => (is => 'ro', isa => 'Int');
  has Timeout => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails object:

  $service_obj->Method(Att1 => { Command => $value, ..., Timeout => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Command

=head1 DESCRIPTION

The container health check command and associated configuration
parameters for the container.

=head1 ATTRIBUTES


=head2 Command => ArrayRef[Str|Undef]

The command that the container runs to determine whether it is healthy.


=head2 Interval => Int

The time period in seconds between each health check execution. The
default value is 30 seconds.


=head2 Retries => Int

The number of times to retry a failed health check before the container
is considered unhealthy. The default value is 3.


=head2 StartPeriod => Int

The optional grace period in seconds that allows containers time to
bootstrap before failed health checks count towards the maximum number
of retries.


=head2 Timeout => Int

The time period in seconds to wait for a health check to succeed before
it is considered a failure. The default value is 5.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

