/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_Container({"alternateClassNames":[],"aliases":{"widget":["container"]},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.Panel","Ext.Toolbar","Ext.Viewport","Ext.menu.Menu"],"extends":"Ext.BoxComponent","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.Component' rel='Ext.Component' class='docClass'>Ext.Component</a><div class='subclass '><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='docClass'>Ext.BoxComponent</a><div class='subclass '><strong>Ext.Container</strong></div></div></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='docClass'>Ext.Panel</a></div><div class='dependency'><a href='#!/api/Ext.Toolbar' rel='Ext.Toolbar' class='docClass'>Ext.Toolbar</a></div><div class='dependency'><a href='#!/api/Ext.Viewport' rel='Ext.Viewport' class='docClass'>Ext.Viewport</a></div><div class='dependency'><a href='#!/api/Ext.menu.Menu' rel='Ext.menu.Menu' class='docClass'>Ext.menu.Menu</a></div><h4>Files</h4><div class='dependency'><a href='source/Container.html#Ext-Container' target='_blank'>Container.js</a></div></pre><div class='doc-contents'><p>Base class for any <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a> that may contain other Components. Containers handle the\nbasic behavior of containing items, namely adding, inserting and removing items.</p>\n\n\n\n\n<p>The most commonly used Container classes are <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>, <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a> and <a href=\"#!/api/Ext.TabPanel\" rel=\"Ext.TabPanel\" class=\"docClass\">Ext.TabPanel</a>.\nIf you do not need the capabilities offered by the aforementioned classes you can create a lightweight\nContainer to be encapsulated by an HTML element to your specifications by using the\n<code><b><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></b></code> config option. This is a useful technique when creating\nembedded <a href=\"#!/api/Ext.layout.ColumnLayout\" rel=\"Ext.layout.ColumnLayout\" class=\"docClass\">column</a> layouts inside <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">FormPanels</a>\nfor example.</p>\n\n\n\n\n<p>The code below illustrates both how to explicitly create a Container, and how to implicitly\ncreate one using the <b><code>'container'</code></b> xtype:\n<pre><code>// explicitly create a Container\nvar embeddedColumns = new <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>({\n    autoEl: 'div',  // This is the default\n    layout: 'column',\n    defaults: {\n        // implicitly create Container by specifying xtype\n        xtype: 'container',\n        autoEl: 'div', // This is the default.\n        layout: 'form',\n        columnWidth: 0.5,\n        style: {\n            padding: '10px'\n        }\n    },\n//  The two items below will be Ext.Containers, each encapsulated by a &lt;DIV> element.\n    items: [{\n        items: {\n            xtype: 'datefield',\n            name: 'startDate',\n            fieldLabel: 'Start date'\n        }\n    }, {\n        items: {\n            xtype: 'datefield',\n            name: 'endDate',\n            fieldLabel: 'End date'\n        }\n    }]\n});</code></pre></p>\n\n\n\n\n<p><u><b>Layout</b></u></p>\n\n\n<p>Container classes delegate the rendering of child Components to a layout\nmanager class which must be configured into the Container using the\n<code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code> configuration property.</p>\n\n\n<p>When either specifying child <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> of a Container,\nor dynamically <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">adding</a> Components to a Container, remember to\nconsider how you wish the Container to arrange those child elements, and\nwhether those child elements need to be sized using one of Ext's built-in\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> schemes. By default, Containers use the\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">ContainerLayout</a> scheme which only\nrenders child components, appending them one after the other inside the\nContainer, and <b>does not apply any sizing</b> at all.</p>\n\n\n<p>A common mistake is when a developer neglects to specify a\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> (e.g. widgets like GridPanels or\nTreePanels are added to Containers for which no <code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code>\nhas been specified). If a Container is left to use the default\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">ContainerLayout</a> scheme, none of its\nchild components will be resized, or changed in any way when the Container\nis resized.</p>\n\n\n<p>Certain layout managers allow dynamic addition of child components.\nThose that do include <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a>,\n<a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>, <a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>, and\n<a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">Ext.layout.TableLayout</a>. For example:\n<pre><code>//  Create the GridPanel.\nvar myNewGrid = new <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>({\n    store: myStore,\n    columns: myColumnModel,\n    title: 'Results', // the title becomes the title of the tab\n});\n\nmyTabPanel.add(myNewGrid); // <a href=\"#!/api/Ext.TabPanel\" rel=\"Ext.TabPanel\" class=\"docClass\">Ext.TabPanel</a> implicitly uses <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">CardLayout</a>\nmyTabPanel.<a href=\"#!/api/Ext.TabPanel-method-setActiveTab\" rel=\"Ext.TabPanel-method-setActiveTab\" class=\"docClass\">setActiveTab</a>(myNewGrid);\n</code></pre></p>\n\n\n<p>The example above adds a newly created GridPanel to a TabPanel. Note that\na TabPanel uses <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a> as its layout manager which\nmeans all its child items are sized to <a href=\"#!/api/Ext.layout.FitLayout\" rel=\"Ext.layout.FitLayout\" class=\"docClass\">fit</a>\nexactly into its client area.\n<p><b><u>Overnesting is a common problem</u></b>.\nAn example of overnesting occurs when a GridPanel is added to a TabPanel\nby wrapping the GridPanel <i>inside</i> a wrapping Panel (that has no\n<code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code> specified) and then add that wrapping Panel\nto the TabPanel. The point to realize is that a GridPanel <b>is</b> a\nComponent which can be added directly to a Container. If the wrapping Panel\nhas no <code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code> configuration, then the overnested\nGridPanel will not be sized as expected.<p>\n\n<p><u><b>Adding via remote configuration</b></u></p>\n\n<p>A server side script can be used to add Components which are generated dynamically on the server.\nAn example of adding a GridPanel to a TabPanel where the GridPanel is generated by the server\nbased on certain parameters:\n</p>\n<pre><code>// execute an Ajax request to invoke server side script:\n<a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n    url: 'gen-invoice-grid.php',\n    // send additional parameters to instruct server script\n    params: {\n        startDate: <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>('start-date').getValue(),\n        endDate: <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>('end-date').getValue()\n    },\n    // process the response object to add it to the TabPanel:\n    success: function(xhr) {\n        var newComponent = eval(xhr.responseText); // see discussion below\n        myTabPanel.add(newComponent); // add the component to the TabPanel\n        myTabPanel.setActiveTab(newComponent);\n    },\n    failure: function() {\n        Ext.Msg.alert(\"Grid create failed\", \"Server communication failure\");\n    }\n});\n</code></pre>\n<p>The server script needs to return an executable Javascript statement which, when processed\nusing <code>eval()</code>, will return either a config object with an <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a>,\nor an instantiated Component. The server might return this for example:</p>\n<pre><code>(function() {\n    function formatDate(value){\n        return value ? value.dateFormat('M d, Y') : '';\n    };\n\n    var store = new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({\n        url: 'get-invoice-data.php',\n        baseParams: {\n            startDate: '01/01/2008',\n            endDate: '01/31/2008'\n        },\n        reader: new <a href=\"#!/api/Ext.data.JsonReader\" rel=\"Ext.data.JsonReader\" class=\"docClass\">Ext.data.JsonReader</a>({\n            record: 'transaction',\n            idProperty: 'id',\n            totalRecords: 'total'\n        }, [\n           'customer',\n           'invNo',\n           {name: 'date', type: 'date', dateFormat: 'm/d/Y'},\n           {name: 'value', type: 'float'}\n        ])\n    });\n\n    var grid = new <a href=\"#!/api/Ext.grid.GridPanel\" rel=\"Ext.grid.GridPanel\" class=\"docClass\">Ext.grid.GridPanel</a>({\n        title: 'Invoice Report',\n        bbar: new <a href=\"#!/api/Ext.PagingToolbar\" rel=\"Ext.PagingToolbar\" class=\"docClass\">Ext.PagingToolbar</a>(store),\n        store: store,\n        columns: [\n            {header: \"Customer\", width: 250, dataIndex: 'customer', sortable: true},\n            {header: \"Invoice Number\", width: 120, dataIndex: 'invNo', sortable: true},\n            {header: \"Invoice Date\", width: 100, dataIndex: 'date', renderer: formatDate, sortable: true},\n            {header: \"Value\", width: 120, dataIndex: 'value', renderer: 'usMoney', sortable: true}\n        ],\n    });\n    store.load();\n    return grid;  // return instantiated component\n})();\n</code></pre>\n<p>When the above code fragment is passed through the <code>eval</code> function in the success handler\nof the Ajax request, the code is executed by the Javascript processor, and the anonymous function\nruns, and returns the instantiated grid component.</p>\n<p>Note: since the code above is <i>generated</i> by a server script, the <code>baseParams</code> for\nthe Store, the metadata to allow generation of the Record layout, and the ColumnModel\ncan all be generated into the code since these are all known on the server.</p>\n\n</p></p></p></div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-activeItem' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-activeItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-activeItem' class='name expandable'>activeItem</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>A string component id or the numeric index of the component that should be initially activated within the\ncontainer's...</div><div class='long'><p>A string component id or the numeric index of the component that should be initially activated within the\ncontainer's layout on render.  For example, activeItem: 'item-1' or activeItem: 0 (index 0 = the first\nitem in the container's collection).  activeItem only applies to layout styles that can display\nitems one at a time (like <a href=\"#!/api/Ext.layout.AccordionLayout\" rel=\"Ext.layout.AccordionLayout\" class=\"docClass\">Ext.layout.AccordionLayout</a>, <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a> and\n<a href=\"#!/api/Ext.layout.FitLayout\" rel=\"Ext.layout.FitLayout\" class=\"docClass\">Ext.layout.FitLayout</a>).  Related to <a href=\"#!/api/Ext.layout.ContainerLayout-property-activeItem\" rel=\"Ext.layout.ContainerLayout-property-activeItem\" class=\"docClass\">Ext.layout.ContainerLayout.activeItem</a>.</p>\n</div></div></div><div id='cfg-allowDomMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-allowDomMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-allowDomMove' class='name expandable'>allowDomMove</a><span> : Boolean</span></div><div class='description'><div class='short'>Whether the component can move the Dom node when rendering (defaults to true). ...</div><div class='long'><p>Whether the component can move the Dom node when rendering (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-anchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-anchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-anchor' class='name expandable'>anchor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use an Anc...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use an <b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">AnchorLayout</a> (or subclass thereof).</b>\nbased layout manager, for example:<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a></li>\n<li>specifying <code>layout: 'anchor' // or 'form', or 'absolute'</code></li>\n</ul></div></p>\n\n\n<p>See <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>.<a href=\"#!/api/Ext.layout.AnchorLayout-cfg-anchor\" rel=\"Ext.layout.AnchorLayout-cfg-anchor\" class=\"docClass\">anchor</a> also.</p>\n\n</div></div></div><div id='cfg-applyTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-applyTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-applyTo' class='name expandable'>applyTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element corresponding to a DIV\nthat is already present in the document that specifies some structural markup for this\ncomponent.</p>\n\n\n<div><ul>\n<li><b>Description</b> : <ul>\n<div class=\"sub-desc\">When <tt>applyTo</tt> is used, constituent parts of the component can also be specified\nby id or CSS class name within the main element, and the component being created may attempt\nto create its subcomponents from that markup if applicable.</div>\n</ul></li>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n<div class=\"sub-desc\">If applyTo is specified, any value passed for <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a> will be ignored and the target\nelement's parent node will automatically be used as the component's container.</div>\n</ul></li>\n</ul></div>\n\n</div></div></div><div id='cfg-autoDestroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-autoDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-autoDestroy' class='name expandable'>autoDestroy</a><span> : Boolean</span></div><div class='description'><div class='short'>If true the container will automatically destroy any contained component that is removed from it, else\ndestruction mu...</div><div class='long'><p>If true the container will automatically destroy any contained component that is removed from it, else\ndestruction must be handled manually (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-autoEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoEl' class='name expandable'>autoEl</a><span> : Mixed</span></div><div class='description'><div class='short'>A tag name or DomHelper spec used to create the Element which will\nencapsulate this Component. ...</div><div class='long'><p>A tag name or <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> spec used to create the <a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a>,\nand <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>, this defaults to <b><tt>'div'</tt></b>. The more complex Ext classes use a more complex\nDOM structure created by their own onRender methods.</p>\n\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n\n<pre><code>{\n    xtype: 'box',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'box',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'box',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n\n<p>Defaults to: <code>'div'</code></p></div></div></div><div id='cfg-autoHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoHeight' class='name expandable'>autoHeight</a><span> : Boolean</span></div><div class='description'><div class='short'>True to use height:'auto', false to use fixed height (or allow it to be managed by its parent\nContainer's layout mana...</div><div class='long'><p>True to use height:'auto', false to use fixed height (or allow it to be managed by its parent\nContainer's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>. Defaults to false.</p>\n\n\n<p><b>Note</b>: Although many components inherit this config option, not all will\nfunction as expected with a height of 'auto'. Setting autoHeight:true means that the\nbrowser will manage height based on the element's contents, and that Ext will not manage it at all.</p>\n\n\n<p>If the <i>browser</i> is managing the height, be aware that resizes performed by the browser in response\nto changes within the structure of the Component cannot be detected. Therefore changes to the height might\nresult in elements needing to be synchronized with the new height. Example:</p>\n\n\n<pre><code>var w = new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    title: 'Window',\n    width: 600,\n    autoHeight: true,\n    items: {\n        title: 'Collapse Me',\n        height: 400,\n        collapsible: true,\n        border: false,\n        listeners: {\n            beforecollapse: function() {\n                w.el.shadow.hide();\n            },\n            beforeexpand: function() {\n                w.el.shadow.hide();\n            },\n            collapse: function() {\n                w.syncShadow();\n            },\n            expand: function() {\n                w.syncShadow();\n            }\n        }\n    }\n}).show();\n</code></pre>\n\n</div></div></div><div id='cfg-autoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoScroll' class='name expandable'>autoScroll</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, false...</div><div class='long'><p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, <code>false</code> to clip any overflowing content (defaults to <code>false</code>).</p>\n</div></div></div><div id='cfg-autoShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoShow' class='name expandable'>autoShow</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the component should check for hidden classes (e.g. ...</div><div class='long'><p>True if the component should check for hidden classes (e.g. 'x-hidden' or 'x-hide-display') and remove\nthem on render (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoWidth' class='name expandable'>autoWidth</a><span> : Boolean</span></div><div class='description'><div class='short'>True to use width:'auto', false to use fixed width (or allow it to be managed by its parent\nContainer's layout manager. ...</div><div class='long'><p>True to use width:'auto', false to use fixed width (or allow it to be managed by its parent\nContainer's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>. Defaults to false.</p>\n\n\n<p><b>Note</b>: Although many components  inherit this config option, not all will\nfunction as expected with a width of 'auto'. Setting autoWidth:true means that the\nbrowser will manage width based on the element's contents, and that Ext will not manage it at all.</p>\n\n\n<p>If the <i>browser</i> is managing the width, be aware that resizes performed by the browser in response\nto changes within the structure of the Component cannot be detected. Therefore changes to the width might\nresult in elements needing to be synchronized with the new width. For example, where the target element is:</p>\n\n\n<pre><code>&lt;div id='grid-container' style='margin-left:25%;width:50%'>&lt;/div>\n</code></pre>\n\n\n<p>A Panel rendered into that target element must listen for browser window resize in order to relay its\nchild items when the browser changes its width:</p>\n\n<pre><code>var myPanel = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    renderTo: 'grid-container',\n    monitorResize: true, // relay on browser resize\n    title: 'Panel',\n    height: 400,\n    autoWidth: true,\n    layout: 'hbox',\n    layoutConfig: {\n        align: 'stretch'\n    },\n    defaults: {\n        flex: 1\n    },\n    items: [{\n        title: 'Box 1',\n    }, {\n        title: 'Box 2'\n    }, {\n        title: 'Box 3'\n    }],\n});\n</code></pre>\n\n</div></div></div><div id='cfg-boxMaxHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxHeight' class='name expandable'>boxMaxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMaxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxWidth' class='name expandable'>boxMaxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinHeight' class='name expandable'>boxMinHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinWidth' class='name expandable'>boxMinWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-bubbleEvents' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should be bubbled to any parent container. ...</div><div class='long'><p>An array of events that, when fired, should be bubbled to any parent container.\nSee <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">Ext.util.Observable.enableBubble</a>.\nDefaults to <code>['add', 'remove']</code>.\n\n</p><p>Defaults to: <code>['add', 'remove']</code></p><p>Overrides: <a href='#!/api/Ext.Component-cfg-bubbleEvents' rel='Ext.Component-cfg-bubbleEvents' class='docClass'>Ext.Component.bubbleEvents</a></p></div></div></div><div id='cfg-bufferResize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-bufferResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-bufferResize' class='name expandable'>bufferResize</a><span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>When set to true (50 milliseconds) or a number of milliseconds, the layout assigned for this container will buffer\nth...</div><div class='long'><p>When set to true (50 milliseconds) or a number of milliseconds, the layout assigned for this container will buffer\nthe frequency it calculates and does a re-layout of components. This is useful for heavy containers or containers\nwith a large quantity of sub-components for which frequent layout calls would be expensive. Defaults to <code>50</code>.</p>\n<p>Defaults to: <code>50</code></p></div></div></div><div id='cfg-clearCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-clearCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-clearCls' class='name expandable'>clearCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide...</div><div class='long'><p>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide field clearing (defaults to\n<tt>'x-form-clear-left'</tt>).</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container\n\n\n<p>which has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout\nmanager (e.g. <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>) and either a\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> is specified or <tt>isFormField=true</tt> is specified.</p><br></p>\n\n<p>See <a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a> also.</p>\n\n</div></div></div><div id='cfg-cls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-cls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-cls' class='name expandable'>cls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element (defaults to ''). ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element (defaults to '').  This can be\nuseful for adding customized styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-contentEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-contentEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-contentEl' class='name expandable'>contentEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content\nfor this component.</p>\n\n\n<ul>\n<li><b>Description</b> :\n<div class=\"sub-desc\">This config option is used to take an existing HTML element and place it in the layout element\nof a new component (it simply moves the specified DOM element <i>after the Component is rendered</i> to use as the content.</div></li>\n<li><b>Notes</b> :\n<div class=\"sub-desc\">The specified HTML element is appended to the layout element of the component <i>after any configured\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">HTML</a> has been inserted</i>, and so the document will not contain this element at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.</div>\n<div class=\"sub-desc\">The specified HTML element used will not participate in any <code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code>\nscheme that the Component may use. It is just HTML. Layouts operate on child <code><b><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></b></code>.</div>\n<div class=\"sub-desc\">Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to\nprevent a brief flicker of the content before it is rendered to the panel.</div></li>\n</ul>\n\n</div></div></div><div id='cfg-ctCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ctCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ctCls' class='name expandable'>ctCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's container. ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's container. This can be useful for\nadding customized styles to the container or any of its children using standard CSS rules.  See\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a>.<a href=\"#!/api/Ext.layout.ContainerLayout-cfg-extraCls\" rel=\"Ext.layout.ContainerLayout-cfg-extraCls\" class=\"docClass\">extraCls</a> also.</p>\n\n\n<p><b>Note</b>: <tt>ctCls</tt> defaults to <tt>''</tt> except for the following class\nwhich assigns a value by default:\n<div class=\"mdetail-params\"><ul>\n<li>Box Layout : <tt>'x-box-layout-ct'</tt></li>\n</ul></div>\nTo configure the above Class with an extra CSS class append to the default.  For example,\nfor BoxLayout (Hbox and Vbox):\n<pre><code>ctCls: 'x-box-layout-ct custom-class'\n</code></pre>\n</p>\n\n</div></div></div><div id='cfg-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-data' class='name not-expandable'>data</a><span> : Mixed</span></div><div class='description'><div class='short'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div><div class='long'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div></div></div><div id='cfg-defaultType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-defaultType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-defaultType' class='name expandable'>defaultType</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default xtype of child Components to create in this Container when\na child item is specified as a raw configurati...</div><div class='long'><p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n\n\n<p>Defaults to <code>'panel'</code>, except <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a> which defaults to <code>'menuitem'</code>,\nand <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a> and <a href=\"#!/api/Ext.ButtonGroup\" rel=\"Ext.ButtonGroup\" class=\"docClass\">Ext.ButtonGroup</a> which default to <code>'button'</code>.</p>\n\n<p>Defaults to: <code>'panel'</code></p></div></div></div><div id='cfg-defaults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-defaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-defaults' class='name expandable'>defaults</a><span> : Object|<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>This option is a means of applying default settings to all added items whether added through the items\nconfig or via ...</div><div class='long'><p>This option is a means of applying default settings to all added items whether added through the <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>\nconfig or via the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> or <a href=\"#!/api/Ext.Container-method-insert\" rel=\"Ext.Container-method-insert\" class=\"docClass\">insert</a> methods.</p>\n\n\n<p>If an added item is a config object, and <b>not</b> an instantiated Component, then the default properties are\nunconditionally applied. If the added item <b>is</b> an instantiated Component, then the default properties are\napplied conditionally so as not to override existing properties in the item.</p>\n\n\n<p>If the defaults option is specified as a function, then the function will be called using this Container as the\nscope (<code>this</code> reference) and passing the added item as the first parameter. Any resulting object\nfrom that call is then applied to the item as default properties.</p>\n\n\n<p>For example, to automatically apply padding to the body of each of a set of\ncontained <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a> items, you could pass: <code>defaults: {bodyStyle:'padding:15px'}</code>.</p>\n\n\n<p>Usage:</p>\n\n\n<pre><code>defaults: {               // defaults are applied to items, not the container\n    autoScroll:true\n},\nitems: [\n    {\n        xtype: 'panel',   // defaults <b>do not</b> have precedence over\n        id: 'panel1',     // options in config objects, so the defaults\n        autoScroll: false // will not be applied here, panel1 will be autoScroll:false\n    },\n    new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({       // defaults <b>do</b> have precedence over options\n        id: 'panel2',     // options in components, so the defaults\n        autoScroll: false // will be applied here, panel2 will be autoScroll:true.\n    })\n]\n</code></pre>\n\n</div></div></div><div id='cfg-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>Render this component disabled (default is false). ...</div><div class='long'><p>Render this component disabled (default is false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-disabledClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-disabledClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-disabledClass' class='name expandable'>disabledClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>CSS class added to the component when it is disabled (defaults to 'x-item-disabled'). ...</div><div class='long'><p>CSS class added to the component when it is disabled (defaults to 'x-item-disabled').</p>\n<p>Defaults to: <code>'x-item-disabled'</code></p></div></div></div><div id='cfg-fieldLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-fieldLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-fieldLabel' class='name expandable'>fieldLabel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The label text to display next to this Component (defaults to ''). ...</div><div class='long'><p>The label text to display next to this Component (defaults to '').</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\n\n\n<p>has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p><br></p>\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-flex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-flex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-flex' class='name expandable'>flex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use a BoxL...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use a <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a>.</b>\nEach child Component with a <code>flex</code> property will be flexed either vertically (by a VBoxLayout)\nor horizontally (by an HBoxLayout) according to the item's <b>relative</b> <code>flex</code> value\ncompared to the sum of all Components with <code>flex</code> value specified. Any child items that have\neither a <code>flex = 0</code> or <code>flex = undefined</code> will not be 'flexed' (the initial size will not be changed).\n\n</p></div></div></div><div id='cfg-forceLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-forceLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-forceLayout' class='name expandable'>forceLayout</a><span> : Boolean</span></div><div class='description'><div class='short'>If true the container will force a layout initially even if hidden or collapsed. ...</div><div class='long'><p>If true the container will force a layout initially even if hidden or collapsed. This option\nis useful for forcing forms to render in collapsed or hidden containers. (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-height' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-height' class='name expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The height of this component in pixels (defaults to auto). ...</div><div class='long'><p>The height of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>Render this component hidden (default is false). ...</div><div class='long'><p>Render this component hidden (default is false). If <tt>true</tt>, the\n<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method will be called internally.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hideBorders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-hideBorders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-hideBorders' class='name expandable'>hideBorders</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide the borders of each contained component, false to defer to the component's existing\nborder settings (def...</div><div class='long'><p>True to hide the borders of each contained component, false to defer to the component's existing\nborder settings (defaults to false).</p>\n</div></div></div><div id='cfg-hideLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideLabel' class='name expandable'>hideLabel</a><span> : Boolean</span></div><div class='description'><div class='short'>true to completely hide the label element\n(label and separator). ...</div><div class='long'><p><tt>true</tt> to completely hide the label element\n(<a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">label</a> and <a href=\"#!/api/Ext.Component-cfg-labelSeparator\" rel=\"Ext.Component-cfg-labelSeparator\" class=\"docClass\">separator</a>). Defaults to <tt>false</tt>.\nBy default, even if you do not specify a <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> the space will still be\nreserved so that the field will line up with other fields that do have labels.\nSetting this to <tt>true</tt> will cause the field to not reserve that space.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield'\n        hideLabel: true\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-hideMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideMode' class='name expandable'>hideMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>How this component should be hidden. ...</div><div class='long'><p>How this component should be hidden. Supported values are <tt>'visibility'</tt>\n(css visibility), <tt>'offsets'</tt> (negative offset position) and <tt>'display'</tt>\n(css display).</p>\n\n\n<br><p><b>Note</b>: the default of <tt>'display'</tt> is generally preferred\n\n\n<p>since items are automatically laid out when they are first shown (no sizing\nis done while hidden).</p></p>\n<p>Defaults to: <code>'display'</code></p></div></div></div><div id='cfg-hideParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideParent' class='name expandable'>hideParent</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the...</div><div class='long'><p>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the component itself (defaults to false).  For example, this can be used as a shortcut for a hide\nbutton on a window by setting hide:true on the button when adding it to its parent container.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-html' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-html' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-html' class='name expandable'>html</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>An HTML fragment, or a DomHelper specification to use as the layout element\ncontent (defaults to ''). ...</div><div class='long'><p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element\ncontent (defaults to ''). The HTML content is added after the component is rendered,\nso the document will not contain this HTML at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.\nThis content is inserted into the body <i>before</i> any configured <a href=\"#!/api/Ext.Component-cfg-contentEl\" rel=\"Ext.Component-cfg-contentEl\" class=\"docClass\">contentEl</a> is appended.</p>\n</div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id of this component (defaults to an auto-assigned id). ...</div><div class='long'><p>The <b>unique</b> id of this component (defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>).\nYou should assign an id if you need to be able to access the component later and you do\nnot have an object reference available (e.g., using <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>).</p>\n\n\n<p>Note that this id will also be used as the element id for the containing HTML element\nthat is rendered to the page for this component. This allows you to write id-based CSS\nrules to style the specific instance of this component uniquely, and also to select\nsub-elements using this component's id as the parent.</p>\n\n\n<p><b>Note</b>: to avoid complications imposed by a unique <tt>id</tt> also see\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n</div></div></div><div id='cfg-itemCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemCls' class='name expandable'>itemCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered by a Container which\nhas been configured to use the Fo...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\nhas been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p>\n\n\n<br>\n\n\n<p>An additional CSS class to apply to the div wrapping the form item\nelement of this field.  If supplied, <tt>itemCls</tt> at the <b>field</b> level will override\nthe default <tt>itemCls</tt> supplied at the <b>container</b> level. The value specified for\n<tt>itemCls</tt> will be added to the default class (<tt>'x-form-item'</tt>).</p>\n\n\n<p>Since it is applied to the item wrapper (see\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>), it allows\nyou to write standard CSS rules that can apply to the field, the label (if specified), or\nany other element within the markup for the field.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>// Apply a style to the field&#39;s label:\n&lt;style>\n    .required .x-form-item-label {font-weight:bold;color:red;}\n&lt;/style>\n\nnew Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        itemCls: 'required' //this label will be styled\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Favorite Color'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-itemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemId' class='name expandable'>itemId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An itemId can be used as an alternative way to get a reference to a component\nwhen no object reference is available. ...</div><div class='long'><p>An <tt>itemId</tt> can be used as an alternative way to get a reference to a component\nwhen no object reference is available.  Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with\n<a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt>'s. Since <code>itemId</code>'s are an index to the\ncontainer's internal MixedCollection, the <code>itemId</code> is scoped locally to the container --\navoiding potential conflicts with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a> which requires a <b>unique</b>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({ //\n    <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <tt><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></tt>.</p>\n\n</div></div></div><div id='cfg-items' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-items' class='name expandable'>items</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>** IMPORTANT: be sure to specify a &lt;code&gt;layout&lt;/code&gt; if needed ! **\n\n\nA single item, or an array of chi...</div><div class='long'><pre><b>** IMPORTANT</b>: be sure to <b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">specify a &lt;code&gt;layout&lt;/code&gt;</a> if needed ! **</b></pre>\n\n\n<p>A single item, or an array of child Components to be added to this container,\nfor example:</p>\n\n\n<pre><code>// specifying a single item\nitems: {...},\nlayout: 'fit',    // specify a layout!\n\n// specifying multiple items\nitems: [{...}, {...}],\nlayout: 'anchor', // specify a layout!\n</code></pre>\n\n\n<p>Each item may be:</p>\n\n\n<div><ul class=\"mdetail-params\">\n<li>any type of object based on <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></li>\n<li>a fully instanciated object or</li>\n<li>an object literal that:</li>\n<div><ul class=\"mdetail-params\">\n<li>has a specified <code><a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a></code></li>\n<li>the <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">Ext.Component.xtype</a> specified is associated with the Component\ndesired and should be chosen from one of the available xtypes as listed\nin <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</li>\n<li>If an <code><a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a></code> is not explicitly\nspecified, the <a href=\"#!/api/Ext.Container-cfg-defaultType\" rel=\"Ext.Container-cfg-defaultType\" class=\"docClass\">defaultType</a> for that Container is used.</li>\n<li>will be \"lazily instanciated\", avoiding the overhead of constructing a fully\ninstanciated Component object</li>\n</ul></div></ul></div>\n\n\n<p><b>Notes</b>:</p>\n\n\n<div><ul class=\"mdetail-params\">\n<li>Ext uses lazy rendering. Child Components will only be rendered\nshould it become necessary. Items are automatically laid out when they are first\nshown (no sizing is done while hidden), or in response to a <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> call.</li>\n<li>Do not specify <code><a href=\"#!/api/Ext.Panel-cfg-contentEl\" rel=\"Ext.Panel-cfg-contentEl\" class=\"docClass\">contentEl</a></code>/\n<code><a href=\"#!/api/Ext.Panel-cfg-html\" rel=\"Ext.Panel-cfg-html\" class=\"docClass\">html</a></code> with <code>items</code>.</li>\n</ul></div>\n\n</div></div></div><div id='cfg-labelSeparator' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelSeparator' class='name expandable'>labelSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The separator to display after the text of each\nfieldLabel. ...</div><div class='long'><p>The separator to display after the text of each\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.  This property may be configured at various levels.\nThe order of precedence is:\n<div class=\"mdetail-params\"><ul>\n<li>field / component level</li>\n<li>container level</li>\n<li><a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">layout level</a> (defaults to colon <tt>':'</tt>)</li>\n</ul></div>\nTo display no separator for this field's label specify empty string ''.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    layoutConfig: {\n        labelSeparator: '~'   // layout config has lowest priority (defaults to ':')\n    },\n    <a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>: '>>',     // config at container level\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Field 1',\n        labelSeparator: '...' // field/component level config supersedes others\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Field 2' // labelSeparator will be '='\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-labelStyle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelStyle' class='name expandable'>labelStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS style specification string to apply directly to this field's\nlabel. ...</div><div class='long'><p>A CSS style specification string to apply directly to this field's\nlabel.  Defaults to the container's labelStyle value if set (e.g.,\n<tt><a href=\"#!/api/Ext.layout.FormLayout-property-labelStyle\" rel=\"Ext.layout.FormLayout-property-labelStyle\" class=\"docClass\">Ext.layout.FormLayout.labelStyle</a></tt> , or '').</p>\n\n\n<br><p><b>Note</b>: see the note for <code><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></code>.</p><br>\n\n\n<p>Also see <code><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></code> and\n<code><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</code></p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        labelStyle: 'font-weight:bold;'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-layout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-layout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-layout' class='name expandable'>layout</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>*Important: In order for child items to be correctly sized and\npositioned, typically a layout manager must be specifi...</div><div class='long'><p><b>*Important</b>: In order for child items to be correctly sized and\npositioned, typically a layout manager <b>must</b> be specified through\nthe <code>layout</code> configuration option.</p>\n\n\n<br><p>The sizing and positioning of child items is the responsibility of\n\n\n<p>the Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p></p>\n\n<pre><code>new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    width:300, height: 300,\n    layout: 'fit', // explicitly set layout manager: override the default (layout:'auto')\n    items: [{\n        title: 'Panel inside a Window'\n    }]\n}).show();\n</code></pre>\n\n\n<p>If the <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).\nSome container classes implicitly specify a default layout\n(e.g. FormPanel specifies <code>layout:'form'</code>). Other specific\npurpose classes internally specify/manage their internal layout (e.g.\nGridPanel, TabPanel, TreePanel, Toolbar, Menu, etc.).</p>\n\n\n<br><p><b><code>layout</code></b> may be specified as either as an Object or\n\n\n<p>as a String:</p><div><ul class=\"mdetail-params\"></p>\n\n<p><li><u>Specify as an Object</u></li></p>\n\n<div><ul class=\"mdetail-params\">\n<li>Example usage:</li>\n<pre><code>layout: {\n    type: 'vbox',\n    padding: '5',\n    align: 'left'\n}\n</code></pre>\n\n<li><code><b>type</b></code></li>\n<br/><p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a> will be created and used.</p>\n<br/><p>Valid layout <code>type</code> values are:</p>\n<div class=\"sub-desc\"><ul class=\"mdetail-params\">\n<li><code><b><a href=\"#!/api/Ext.layout.AbsoluteLayout\" rel=\"Ext.layout.AbsoluteLayout\" class=\"docClass\">absolute</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.AccordionLayout\" rel=\"Ext.layout.AccordionLayout\" class=\"docClass\">accordion</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">anchor</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">auto</a></b></code> &nbsp;&nbsp;&nbsp; <b>Default</b></li>\n<li><code><b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">border</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">card</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ColumnLayout\" rel=\"Ext.layout.ColumnLayout\" class=\"docClass\">column</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.FitLayout\" rel=\"Ext.layout.FitLayout\" class=\"docClass\">fit</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">form</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.HBoxLayout\" rel=\"Ext.layout.HBoxLayout\" class=\"docClass\">hbox</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.MenuLayout\" rel=\"Ext.layout.MenuLayout\" class=\"docClass\">menu</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">table</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ToolbarLayout\" rel=\"Ext.layout.ToolbarLayout\" class=\"docClass\">toolbar</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.VBoxLayout\" rel=\"Ext.layout.VBoxLayout\" class=\"docClass\">vbox</a></b></code></li>\n</ul></div>\n\n<li>Layout specific configuration properties</li>\n<br/><p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p>\n\n</ul></div>\n\n\n<p><li><u>Specify as a String</u></li></p>\n\n<div><ul class=\"mdetail-params\">\n<li>Example usage:</li>\n<pre><code>layout: 'vbox',\nlayoutConfig: {\n    padding: '5',\n    align: 'left'\n}\n</code></pre>\n<li><code><b>layout</b></code></li>\n<br/><p>The layout <code>type</code> to be used for this container (see list\nof valid layout type values above).</p><br/>\n<li><code><b><a href=\"#!/api/Ext.Container-cfg-layoutConfig\" rel=\"Ext.Container-cfg-layoutConfig\" class=\"docClass\">layoutConfig</a></b></code></li>\n<br/><p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p>\n</ul></div>\n\n\n<p></ul></div></p>\n</div></div></div><div id='cfg-layoutConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-layoutConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-layoutConfig' class='name not-expandable'>layoutConfig</a><span> : Object</span></div><div class='description'><div class='short'><p>This is a config object containing properties specific to the chosen\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> if <b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b>\nhas been specified as a <i>string</i>.</p></p>\n</div><div class='long'><p>This is a config object containing properties specific to the chosen\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> if <b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b>\nhas been specified as a <i>string</i>.</p></p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-margins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-margins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-margins' class='name expandable'>margins</a><span> : Object</span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nor one of the two <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a> subclasses.</b></p>\n\n\n<p>An object containing margins to apply to this BoxComponent in the\nformat:</p>\n\n\n<pre><code>{\n    top: (top margin),\n    right: (right margin),\n    bottom: (bottom margin),\n    left: (left margin)\n}</code></pre>\n\n\n<p>May also be a string containing space-separated, numeric margin values. The order of the\nsides associated with each value matches the way CSS processes margin values:</p>\n\n\n<p><div class=\"mdetail-params\"><ul>\n<li>If there is only one value, it applies to all sides.</li>\n<li>If there are two values, the top and bottom borders are set to the first value and the\nright and left are set to the second.</li>\n<li>If there are three values, the top is set to the first value, the left and right are set\nto the second, and the bottom is set to the third.</li>\n<li>If there are four values, they apply to the top, right, bottom, and left, respectively.</li>\n</ul></div></p>\n\n\n<p>Defaults to:</p>\n\n\n<pre><code>{top:0, right:0, bottom:0, left:0}\n</code></pre>\n\n</div></div></div><div id='cfg-monitorResize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-monitorResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-monitorResize' class='name expandable'>monitorResize</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically monitor window resize events to handle anything that is sensitive to the current size\nof the vi...</div><div class='long'><p>True to automatically monitor window resize events to handle anything that is sensitive to the current size\nof the viewport.  This value is typically managed by the chosen <code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code> and should not need\nto be set manually.</p>\n</div></div></div><div id='cfg-overCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-overCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-overCls' class='name expandable'>overCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and removed when the mouse moves out. (defaults to '').  This can be\nuseful for adding customized 'active' or 'hover' styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-pageX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageX' class='name not-expandable'>pageX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-pageY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageY' class='name not-expandable'>pageY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-plugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-plugins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-plugins' class='name expandable'>plugins</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An object or array of objects that will provide custom functionality for this component. ...</div><div class='long'><p>An object or array of objects that will provide custom functionality for this component.  The only\nrequirement for a valid plugin is that it contain an init method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.\nWhen a component is created, if any plugins are available, the component will call the init method on each\nplugin, passing a reference to itself.  Each plugin can then call methods or respond to events on the\ncomponent as needed to provide its functionality.</p>\n</div></div></div><div id='cfg-ptype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ptype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ptype' class='name expandable'>ptype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered ptype to create. ...</div><div class='long'><p>The registered <tt>ptype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a Plugin is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>ptype</tt> will be looked up at render time up to determine what\ntype of Plugin to create.<br><br>\nIf you create your own Plugins, you may register them using\n<a href=\"#!/api/Ext.ComponentMgr-method-registerPlugin\" rel=\"Ext.ComponentMgr-method-registerPlugin\" class=\"docClass\">Ext.ComponentMgr.registerPlugin</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-ref' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ref' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ref' class='name expandable'>ref</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A path specification, relative to the Component's ownerCt\nspecifying into which ancestor Container to place a named r...</div><div class='long'><p>A path specification, relative to the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>\nspecifying into which ancestor Container to place a named reference to this Component.</p>\n\n\n<p>The ancestor axis can be traversed by using '/' characters in the path.\nFor example, to put a reference to a Toolbar Button into <i>the Panel which owns the Toolbar</i>:</p>\n\n\n<pre><code>var myGrid = new <a href=\"#!/api/Ext.grid.EditorGridPanel\" rel=\"Ext.grid.EditorGridPanel\" class=\"docClass\">Ext.grid.EditorGridPanel</a>({\n    title: 'My EditorGridPanel',\n    store: myStore,\n    colModel: myColModel,\n    tbar: [{\n        text: 'Save',\n        handler: saveChanges,\n        disabled: true,\n        ref: '../saveButton'\n    }],\n    listeners: {\n        afteredit: function() {\n//          The button reference is in the GridPanel\n            myGrid.saveButton.enable();\n        }\n    }\n});\n</code></pre>\n\n\n<p>In the code above, if the <code>ref</code> had been <code>'saveButton'</code>\nthe reference would have been placed into the Toolbar. Each '/' in the <code>ref</code>\nmoves up one level from the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n\n<p>Also see the <code><a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a></code> and <code><a href=\"#!/api/Ext.Component-event-removed\" rel=\"Ext.Component-event-removed\" class=\"docClass\">removed</a></code> events.</p>\n\n</div></div></div><div id='cfg-region' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-region' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-region' class='name expandable'>region</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nlayout manager (e.g. specifying <tt>layout:'border'</tt>).</p>\n\n\n<br>\n\n\n<p>See <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">Ext.layout.BorderLayout</a> also.</p>\n\n</div></div></div><div id='cfg-renderTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-renderTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-renderTo' class='name expandable'>renderTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into. ...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into.</p>\n\n\n<div><ul>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">Do <u>not</u> use this option if the Component is to be a child item of\na <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>. It is the responsibility of the\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>'s <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>\nto render and manage its child items.</div>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n</ul></li>\n</ul></div>\n\n\n<p>See <tt><a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a></tt> also.</p>\n\n</div></div></div><div id='cfg-resizeEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-cfg-resizeEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-resizeEvent' class='name expandable'>resizeEvent</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The event to listen to for resizing in layouts. ...</div><div class='long'><p>The event to listen to for resizing in layouts. Defaults to <code>'resize'</code>.</p>\n<p>Defaults to: <code>'resize'</code></p></div></div></div><div id='cfg-stateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateEvents' class='name expandable'>stateEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). ...</div><div class='long'><p>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). <code>stateEvents</code> may be any type\nof event supported by this component, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateId' class='name expandable'>stateId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, o...</div><div class='long'><p>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, otherwise null if the\ncomponent is using a generated id).</p>\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateful' class='name expandable'>stateful</a><span> : Boolean</span></div><div class='description'><div class='short'>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. ...</div><div class='long'><p>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. The component must have\neither a <code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> assigned\nfor state to be managed. Auto-generated ids are not guaranteed to be stable\nacross page loads and cannot be relied upon to save and restore the same\nstate for a component.<p>\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n<p>To set the state provider for the current page:</p>\n<pre><code><a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n    expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now\n}));\n</code></pre>\n<p>A stateful Component attempts to save state when one of the events\nlisted in the <code><a href=\"#!/api/Ext.Component-cfg-stateEvents\" rel=\"Ext.Component-cfg-stateEvents\" class=\"docClass\">stateEvents</a></code> configuration fires.</p>\n<p>To save state, a stateful Component first serializes its state by\ncalling <b><code>getState</code></b>. By default, this function does\nnothing. The developer must provide an implementation which returns an\nobject hash which represents the Component's restorable state.</p>\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the Component's <code>stateId</code>, or, if that is not\nspecified, its <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>During construction, a stateful Component attempts to <i>restore</i>\nits state by calling <a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the\n<code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code>, or, if that is not specified, the\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>The resulting object is passed to <b><code>applyState</code></b>.\nThe default implementation of <code>applyState</code> simply copies\nproperties into the object, but a developer may override this to support\nmore behaviour.</p>\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.Component-event-beforestaterestore\" rel=\"Ext.Component-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.Component-event-staterestore\" rel=\"Ext.Component-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.Component-event-beforestatesave\" rel=\"Ext.Component-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.Component-event-statesave\" rel=\"Ext.Component-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n\n</p></p></div></div></div><div id='cfg-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-style' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-style' class='name expandable'>style</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom style specification to be applied to this component's Element. ...</div><div class='long'><p>A custom style specification to be applied to this component's Element.  Should be a valid argument to\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n        new <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>({\n            text: 'Send',\n            minWidth: '100',\n            style: {\n                marginBottom: '10px'\n            }\n        })\n    ]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-tabTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-tabTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-tabTip' class='name expandable'>tabTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is a child item of a TabPanel. ...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is a child item of a TabPanel.</p>\n\n\n<p>A string to be used as innerHTML (html tags are accepted) to show in a tooltip when mousing over\nthe associated tab selector element. <a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a>.init()\nmust be called in order for the tips to render.</p>\n</div></div></div><div id='cfg-tpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tpl' class='name expandable'>tpl</a><span> : Mixed</span></div><div class='description'><div class='short'>An Ext.Template, Ext.XTemplate\nor an array of strings to form an Ext.XTemplate. ...</div><div class='long'><p>An <bold><a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></bold>, <bold><a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></bold>\nor an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>.\nUsed in conjunction with the <code><a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a></code> and\n<code><a href=\"#!/api/Ext.Component-cfg-tplWriteMode\" rel=\"Ext.Component-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n</div></div></div><div id='cfg-tplWriteMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tplWriteMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tplWriteMode' class='name expandable'>tplWriteMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The Ext.(X)Template method to use when\nupdating the content area of the Component. ...</div><div class='long'><p>The Ext.(X)Template method to use when\nupdating the content area of the Component. Defaults to <tt>'overwrite'</tt>\n(see <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code>).</p>\n<p>Defaults to: <code>'overwrite'</code></p></div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-width' class='name expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The width of this component in pixels (defaults to auto). ...</div><div class='long'><p>The width of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-x' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-x' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-x' class='name not-expandable'>x</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-xtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered xtype to create. ...</div><div class='long'><p>The registered <tt>xtype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a child item of a Container is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>xtype</tt> will be looked up at render time up to determine what\ntype of child Component to create.<br><br>\nThe predefined xtypes are listed <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">here</a>.</p>\n\n<br><br>\n\n\n<p>If you subclass Components to create your own Components, you may register\nthem using <a href=\"#!/api/Ext.ComponentMgr-method-registerType\" rel=\"Ext.ComponentMgr-method-registerType\" class=\"docClass\">Ext.ComponentMgr.registerType</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-y' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-y' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-y' class='name not-expandable'>y</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-boxReady' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-boxReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-boxReady' class='name expandable'>boxReady</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, set in afterRender to signify that the component has been rendered ...</div><div class='long'><p>private, set in afterRender to signify that the component has been rendered</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-deferHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-deferHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-deferHeight' class='name expandable'>deferHeight</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, used to defer height settings to subclasses ...</div><div class='long'><p>private, used to defer height settings to subclasses</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is disabled. ...</div><div class='long'><p>True if this component is disabled. Read-only.</p>\n</div></div></div><div id='property-el' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-el' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-el' class='name expandable'>el</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Ext.Element which encapsulates this Component. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component. Read-only.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <code><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></code> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a>\nconfig for a suggestion, or use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n\n<p>See also <tt><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">getEl</a></tt></p>\n\n</div></div></div><div id='property-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is hidden. ...</div><div class='long'><p>True if this component is hidden. Read-only.</p>\n</div></div></div><div id='property-initialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-initialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-initialConfig' class='name expandable'>initialConfig</a><span> : Object</span></div><div class='description'><div class='short'>This Component's initial configuration specification. ...</div><div class='long'><p>This Component's initial configuration specification. Read-only.</p>\n</div></div></div><div id='property-items' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-property-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-property-items' class='name not-expandable'>items</a><span> : MixedCollection</span></div><div class='description'><div class='short'><p>The collection of components in this container as a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></p>\n</div><div class='long'><p>The collection of components in this container as a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></p>\n</div></div></div><div id='property-ownerCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-ownerCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-ownerCt' class='name expandable'>ownerCt</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>This Component's owner Container (defaults to undefined, and is set automatically when\nthis Component is added to a C...</div><div class='long'><p>This Component's owner <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> (defaults to undefined, and is set automatically when\nthis Component is added to a Container).  Read-only.</p>\n\n<p><b>Note</b>: to access items within the Container see <tt><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></tt>.</p>\n\n</div></div></div><div id='property-refOwner' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-refOwner' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-refOwner' class='name expandable'>refOwner</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>The ancestor Container into which the ref reference was inserted if this Component\nis a child of a Container, and has...</div><div class='long'><p>The ancestor Container into which the <a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a> reference was inserted if this Component\nis a child of a Container, and has been configured with a <code>ref</code>.</p>\n</div></div></div><div id='property-rendered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-rendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-rendered' class='name expandable'>rendered</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component has been rendered. ...</div><div class='long'><p>True if this component has been rendered. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.BoxComponent-method-constructor' class='name expandable'>Ext.Container</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>The configuration options.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Component-method-constructor' rel='Ext.Component-method-constructor' class='docClass'>Ext.Component.constructor</a></p></div></div></div><div id='method-add' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-add' class='name expandable'>add</a>( <span class='pre'>component</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Adds Component(s) to this Container. ...</div><div class='long'><p>Adds <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>(s) to this Container.</p>\n\n\n<br><p><b>Description</b></u> :\n\n\n<div><ul class=\"mdetail-params\">\n<li>Fires the <a href=\"#!/api/Ext.Container-event-beforeadd\" rel=\"Ext.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before adding</li>\n<li>The Container's <a href=\"#!/api/Ext.Container-cfg-defaults\" rel=\"Ext.Container-cfg-defaults\" class=\"docClass\">default config values</a> will be applied\naccordingly (see <code><a href=\"#!/api/Ext.Container-cfg-defaults\" rel=\"Ext.Container-cfg-defaults\" class=\"docClass\">defaults</a></code> for details).</li>\n<li>Fires the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> event after the component has been added.</li>\n</ul></div>\n\n\n<br><p><b>Notes</b></u> :\n\n\n<div><ul class=\"mdetail-params\">\n<li>If the Container is <i>already rendered</i> when <code>add</code>\nis called, you may need to call <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes\nany unrendered child Components to be rendered. This is required so that you can\n<code>add</code> multiple child components if needed while only refreshing the layout\nonce. For example:\n<pre><code>var tb = new <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a>();\ntb.render(document.body);  // toolbar is rendered\ntb.add({text:'Button 1'}); // add multiple items (<a href=\"#!/api/Ext.Container-cfg-defaultType\" rel=\"Ext.Container-cfg-defaultType\" class=\"docClass\">defaultType</a> for <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a> is 'button')\ntb.add({text:'Button 2'});\ntb.<a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a>();             // refresh the layout\n</code></pre></li>\n<li><i>Warning:</i> Containers directly managed by the BorderLayout layout manager\nmay not be removed or added.  See the Notes for <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a>\nfor more details.</li>\n</ul></div>\n\n</p></p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>component</span> : ...Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Either one or more Components to add or an Array of Components to add.  See\n<code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> for additional information.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The Components that were added.</p>\n</div></li></ul></div></div></div><div id='method-addClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-addClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-addClass' class='name expandable'>addClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds a CSS class to the component's underlying element. ...</div><div class='long'><p>Adds a CSS class to the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-adjustPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustPosition' class='name expandable'>adjustPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-adjustSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustSize' class='name expandable'>adjustSize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterRender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-afterRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-afterRender' class='name expandable'>afterRender</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-method-afterRender' rel='Ext.BoxComponent-method-afterRender' class='docClass'>Ext.BoxComponent.afterRender</a></p></div></div></div><div id='method-applyDefaults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-applyDefaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-applyDefaults' class='name expandable'>applyDefaults</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyToMarkup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-applyToMarkup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-applyToMarkup' class='name expandable'>applyToMarkup</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Apply this component to existing markup that is valid. ...</div><div class='long'><p>Apply this component to existing markup that is valid. With this function, no call to render() is required.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beforeDestroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-beforeDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-beforeDestroy' class='name expandable'>beforeDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-bubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-bubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-bubble' class='name expandable'>bubble</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Bubbles up the component/container heirarchy, calling the specified function with each component. ...</div><div class='long'><p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current node)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-canLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-canLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-canLayout' class='name expandable'>canLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>We can only lay out if there is a view area in which to layout. ...</div><div class='long'><p>We can only lay out if there is a view area in which to layout.\ndisplay:none on the layout target, <em>or any of its parent elements</em> will mean it has no view area.</p>\n</div></div></div><div id='method-cascade' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-cascade' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-cascade' class='name expandable'>cascade</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Cascades down the component/container heirarchy from this component (called first), calling the specified function wi...</div><div class='long'><p>Cascades down the component/container heirarchy from this component (called first), calling the specified function with\neach component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe cascade is stopped on that branch.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current component)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (defaults to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-cloneConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-cloneConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-cloneConfig' class='name expandable'>cloneConfig</a>( <span class='pre'>overrides</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Clone the current component using the original config values passed into this instance by default. ...</div><div class='long'><p>Clone the current component using the original config values passed into this instance by default.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>A new config containing any properties to override in the cloned version.\nAn id property can be passed on this object, otherwise one will be generated to avoid duplicates.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>clone The cloned copy of this component</p>\n</div></li></ul></div></div></div><div id='method-createComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-createComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-createComponent' class='name expandable'>createComponent</a>( <span class='pre'>config, defaultType</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>defaultType</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the c...</div><div class='long'><p>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the component from its <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a> (if applicable) and unregistering it from\n<a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>.  Destruction is generally handled automatically by the framework and this method\nshould usually not need to be called directly.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-disable' class='name expandable'>disable</a>( <span class='pre'>silent</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Disable this component and fire the 'disable' event. ...</div><div class='long'><p>Disable this component and fire the 'disable' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-doLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-doLayout' class='name expandable'>doLayout</a>( <span class='pre'>[shallow], [force]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force this container's layout to be recalculated. ...</div><div class='long'><p>Force this container's layout to be recalculated. A call to this function is required after adding a new component\nto an already rendered container, or possibly after changing sizing/position properties of child components.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>True to only calc the layout of this component, and let child components auto\ncalc layouts as required (defaults to false, which calls doLayout recursively for each subcontainer)</p>\n</div></li><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>True to force a layout to occur, even if the item is hidden.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doRemove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-doRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-doRemove' class='name expandable'>doRemove</a>( <span class='pre'>c, autoDestroy</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>autoDestroy</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Enable this component and fire the 'enable' event. ...</div><div class='long'><p>Enable this component and fire the 'enable' event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-find' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-find' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-find' class='name expandable'>find</a>( <span class='pre'>prop, value</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by property ...</div><div class='long'><p>Find a component under this container at any level by property</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prop</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findBy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-findBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findBy' class='name expandable'>findBy</a>( <span class='pre'>fn, [scope]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by a custom function. ...</div><div class='long'><p>Find a component under this container at any level by a custom function. If the passed function returns\ntrue, the component will be included in the results. The passed function is called with the arguments (component, this container).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-findById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findById' class='name expandable'>findById</a>( <span class='pre'>id</span> ) : Object<strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Find a component under this container at any level by id ...</div><div class='long'><p>Find a component under this container at any level by id</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Fairly useless method, since you can just use <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>. Should be removed for 4.0\nIf you need to test if an id belongs to a container, you can use getCmp and findParent*.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-findByType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-findByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findByType' class='name expandable'>findByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by xtype or class ...</div><div class='long'><p>Find a component under this container at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Class<div class='sub-desc'><p>The xtype string for a component, or the class of the component directly</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findParentBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentBy' class='name expandable'>findParentBy</a>( <span class='pre'>fn</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by a custom function. ...</div><div class='long'><p>Find a container above this component at any level by a custom function. If the passed function returns\ntrue, the container will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The custom function to call with the arguments (container, this component).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container for which the custom function returns true</p>\n</div></li></ul></div></div></div><div id='method-findParentByType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentByType' class='name expandable'>findParentByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by xtype or class ...</div><div class='long'><p>Find a container above this component at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container which matches the given xtype or class</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-focus' class='name expandable'>focus</a>( <span class='pre'>[selectText], [delay]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Try to focus this component. ...</div><div class='long'><p>Try to focus this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectText</span> : Boolean (optional)<div class='sub-desc'><p>If applicable, true to also select the text in this component</p>\n</div></li><li><span class='pre'>delay</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Delay the focus this number of milliseconds (true for 10 milliseconds)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-get' class='name expandable'>get</a>( <span class='pre'>key</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Get a component contained by this container (alias for items.get(key)) ...</div><div class='long'><p>Get a component contained by this container (alias for items.get(key))</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Should be removed in 4.0, since getComponent does the same thing.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index or id of the component</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-getBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[local]</span> ) : Object</div><div class='description'><div class='short'>Gets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Gets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>box An object in the format {x, y, width, height}</p>\n</div></li></ul></div></div></div><div id='method-getBubbleTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getBubbleTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getBubbleTarget' class='name expandable'>getBubbleTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy. ...</div><div class='long'><p>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>the Container which owns this Component.</p>\n</div></li></ul></div></div></div><div id='method-getComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-getComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getComponent' class='name expandable'>getComponent</a>( <span class='pre'>comp</span> ) : Object</div><div class='description'><div class='short'>Examines this container's items property\nand gets a direct child component of this container. ...</div><div class='long'><p>Examines this container's <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> <b>property</b>\nand gets a direct child component of this container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>This parameter may be any of the following:</p>\n\n<div><ul class=\"mdetail-params\">\n<li>a <b><code>String</code></b> : representing the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code>\nor <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> of the child component </li>\n<li>a <b><code>Number</code></b> : representing the position of the child component\nwithin the <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> <b>property</b></li>\n</ul></div>\n\n\n<p>For additional information see <a href=\"#!/api/Ext.util.MixedCollection-method-get\" rel=\"Ext.util.MixedCollection-method-get\" class=\"docClass\">Ext.util.MixedCollection.get</a>.\n\n</p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> The component (if found).</p>\n</div></li></ul></div></div></div><div id='method-getComponentId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-getComponentId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getComponentId' class='name expandable'>getComponentId</a>( <span class='pre'>comp</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private - used as the key lookup function for the items collection ...</div><div class='long'><p>private - used as the key lookup function for the items collection</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the Ext.Element which encapsulates this Component. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.Component-cfg-listeners\" rel=\"Ext.Component-cfg-listeners\" class=\"docClass\">listeners</a> config for a suggestion,\nor use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which encapsulates this Component.</p>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current height of the component's underlying element. ...</div><div class='long'><p>Gets the current height of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the id of this component or automatically generates and\nreturns an id if an id is not defined yet:\n\n'ext-comp...</div><div class='long'><p>Returns the <code>id</code> of this component or automatically generates and\nreturns an <code>id</code> if an <code>id</code> is not defined yet:</p>\n\n<pre><code>'ext-comp-' + (++<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.AUTO_ID)\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>id</p>\n</div></li></ul></div></div></div><div id='method-getItemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getItemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getItemId' class='name expandable'>getItemId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the itemId of this component. ...</div><div class='long'><p>Returns the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> of this component.  If an\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> was not assigned through configuration the\n<code>id</code> is returned using <code><a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">getId</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-getLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getLayout' class='name expandable'>getLayout</a>( <span class='pre'></span> ) : ContainerLayout</div><div class='description'><div class='short'>Returns the layout currently in use by the container. ...</div><div class='long'><p>Returns the layout currently in use by the container.  If the container does not currently have a layout\nset, a default <a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a> will be created and set as the container's layout.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>ContainerLayout</span><div class='sub-desc'><p>layout The container's layout</p>\n</div></li></ul></div></div></div><div id='method-getLayoutTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-getLayoutTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getLayoutTarget' class='name expandable'>getLayoutTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the Element to be used to contain the child Components of this Container. ...</div><div class='long'><p>Returns the Element to be used to contain the child Components of this Container.</p>\n\n\n<p>An implementation is provided which returns the Container's <a href=\"#!/api/Ext.Container-method-getEl\" rel=\"Ext.Container-method-getEl\" class=\"docClass\">Element</a>, but\nif there is a more complex structure to a Container, this may be overridden to return\nthe element into which the <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> renders child Components.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element to render child Components into.</p>\n</div></li></ul></div></div></div><div id='method-getOuterSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getOuterSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getOuterSize' class='name expandable'>getOuterSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element, including space taken by its margins. ...</div><div class='long'><p>Gets the current size of the component's underlying element, including space taken by its margins.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width + left/right margins), height: (element height + top/bottom margins)}</p>\n</div></li></ul></div></div></div><div id='method-getPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getPosition' class='name expandable'>getPosition</a>( <span class='pre'>[local]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the current XY position of the component's underlying element. ...</div><div class='long'><p>Gets the current XY position of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY position of the element (e.g., [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getResizeEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getResizeEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getResizeEl' class='name expandable'>getResizeEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the outermost Element of this Component which defines the Components overall size. ...</div><div class='long'><p>Returns the outermost Element of this Component which defines the Components overall size.</p>\n\n\n<p><i>Usually</i> this will return the same Element as <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code>,\nbut in some cases, a Component may have some more wrapping Elements around its main\nactive Element.</p>\n\n\n<p>An example is a ComboBox. It is encased in a <i>wrapping</i> Element which\ncontains both the <code>&lt;input></code> Element (which is what would be returned\nby its <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code> method, <i>and</i> the trigger button Element.\nThis Element is returned as the <code>resizeEl</code>.\n\n</p><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which is to be resized by size managing layouts.</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getSize' class='name expandable'>getSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element. ...</div><div class='long'><p>Gets the current size of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current width of the component's underlying element. ...</div><div class='long'><p>Gets the current width of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXType' class='name expandable'>getXType</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the xtype for this component as registered with Ext.ComponentMgr. ...</div><div class='long'><p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype</p>\n</div></li></ul></div></div></div><div id='method-getXTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXTypes' class='name expandable'>getXTypes</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns this Component's xtype hierarchy as a slash-delimited string. ...</div><div class='long'><p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXTypes());  // alerts 'component/box/field/textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype hierarchy string</p>\n</div></li></ul></div></div></div><div id='method-hasLayoutPending' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-hasLayoutPending' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-hasLayoutPending' class='name expandable'>hasLayoutPending</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-hide' class='name expandable'>hide</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Hide this component. ...</div><div class='long'><p>Hide this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforehide\" rel=\"Ext.Component-event-beforehide\" class=\"docClass\">beforehide</a>' event and return\n<tt>false</tt> to cancel hiding the component.  Fires the '<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>'\nevent after hiding the component. Note this method is called internally if\nthe component is configured to be <code><a href=\"#!/api/Ext.Component-cfg-hidden\" rel=\"Ext.Component-cfg-hidden\" class=\"docClass\">hidden</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-initComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-initComponent' class='name expandable'>initComponent</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-method-initComponent' rel='Ext.BoxComponent-method-initComponent' class='docClass'>Ext.BoxComponent.initComponent</a></p></div></div></div><div id='method-initItems' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-initItems' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-initItems' class='name expandable'>initItems</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-initRef' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-initRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-initRef' class='name expandable'>initRef</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to establish a reference to a component. ...</div><div class='long'><p>Method to establish a reference to a component.</p>\n</div></div></div><div id='method-insert' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-insert' class='name expandable'>insert</a>( <span class='pre'>index, component</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Inserts a Component into this Container at a specified index. ...</div><div class='long'><p>Inserts a Component into this Container at a specified index. Fires the\n<a href=\"#!/api/Ext.Container-event-beforeadd\" rel=\"Ext.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before inserting, then fires the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> event after the\nComponent has been inserted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the Component will be inserted\ninto the Container's items collection</p>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The child Component to insert.<br><br>\nExt uses lazy rendering, and will only render the inserted Component should\nit become necessary.<br><br>\nA Component config object may be passed in order to avoid the overhead of\nconstructing a real Component object if lazy rendering might mean that the\ninserted Component will not be rendered immediately. To take advantage of\nthis 'lazy instantiation', set the <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">Ext.Component.xtype</a> config\nproperty to the registered type of the Component wanted.<br><br>\nFor a list of all available xtypes, see <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>component The Component (or config object) that was\ninserted with the Container's default config values applied.</p>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this component is visible. ...</div><div class='long'><p>Returns true if this component is visible.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component is visible, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isXType' class='name expandable'>isXType</a>( <span class='pre'>xtype, [shallow]</span> ) : Boolean</div><div class='description'><div class='short'>Tests whether or not this Component is of a specific xtype. ...</div><div class='long'><p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (shallow = true).</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('box');       // true, descended from BoxComponent\nvar isBoxInstance = t.isXType('box', true); // false, not a direct BoxComponent instance\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>();\nconsole.log(c.isXType(c));\nconsole.log(c.isXType(<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>));\n</code></pre>\n\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component descends from the specified xtype, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-lookupComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-lookupComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-lookupComponent' class='name expandable'>lookupComponent</a>( <span class='pre'>comp</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mon' class='name expandable'>mon</a>( <span class='pre'>item, ename, fn, scope, opt</span> )</div><div class='description'><div class='short'>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. ...</div><div class='long'><p>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. Usage:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), 'selectionchange', handleSelectionChange, null, {buffer: 50});\n</pre>\n\n\n<p></code></p>\n\n<p>or:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), {\n    selectionchange: handleSelectionChange,\n    buffer: 50\n});\n</pre>\n\n\n<p></code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mun' class='name expandable'>mun</a>( <span class='pre'>item, ename, fn, scope</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.Component-method-mon\" rel=\"Ext.Component-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li></ul></div></div></div><div id='method-nextSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-nextSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-nextSibling' class='name expandable'>nextSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the next component in the owning container ...</div><div class='long'><p>Returns the next component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onAdd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onAdd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onAdd' class='name expandable'>onAdd</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onAdded' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onAdded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onAdded' class='name expandable'>onAdded</a>( <span class='pre'>container, pos</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\n\nMethod to manage awareness of when components are added to their\nrespective Container, firing an added event. ...</div><div class='long'><p>private</p>\n\n<p>Method to manage awareness of when components are added to their\nrespective Container, firing an added event.\nReferences are established at add time rather than at render time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Component-method-onAdded' rel='Ext.Component-method-onAdded' class='docClass'>Ext.Component.onAdded</a></p></div></div></div><div id='method-onBeforeAdd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onBeforeAdd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onBeforeAdd' class='name expandable'>onBeforeAdd</a>( <span class='pre'>item</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onLayout' class='name expandable'>onLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-onPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-onPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-onPosition' class='name expandable'>onPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubcl...</div><div class='long'><p>// protected\nCalled after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='method-onRemove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onRemove' class='name expandable'>onRemove</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onRemoved' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onRemoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onRemoved' class='name expandable'>onRemoved</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. ...</div><div class='long'><p>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. References are properly\ncleaned up after removing a component from its owning container.</p>\n</div></div></div><div id='method-onResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-onResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-onResize' class='name expandable'>onResize</a>( <span class='pre'>adjWidth, adjHeight, rawWidth, rawHeight</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>// protected\nCalled after the component is resized, this method is empty by default but can be implemented by any\nsub...</div><div class='long'><p>// protected\nCalled after the component is resized, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a resize occurs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='method-onShow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-onShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onShow' class='name expandable'>onShow</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-previousSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-previousSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-previousSibling' class='name expandable'>previousSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the previous component in the owning container ...</div><div class='long'><p>Returns the previous component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-remove' class='name expandable'>remove</a>( <span class='pre'>component, [autoDestroy]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Removes a component from this container. ...</div><div class='long'><p>Removes a component from this container.  Fires the <a href=\"#!/api/Ext.Container-event-beforeremove\" rel=\"Ext.Container-event-beforeremove\" class=\"docClass\">beforeremove</a> event before removing, then fires\nthe <a href=\"#!/api/Ext.Container-method-remove\" rel=\"Ext.Container-method-remove\" class=\"docClass\">remove</a> event after the component has been removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>component</span> : Component/String<div class='sub-desc'><p>The component reference or id to remove.</p>\n</div></li><li><span class='pre'>autoDestroy</span> : Boolean (optional)<div class='sub-desc'><p>True to automatically invoke the removed Component's <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">Ext.Component.destroy</a> function.\nDefaults to the value of this Container's <a href=\"#!/api/Ext.Container-cfg-autoDestroy\" rel=\"Ext.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> config.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>component The Component that was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-removeAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-removeAll' class='name expandable'>removeAll</a>( <span class='pre'>[autoDestroy]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Removes all components from this container. ...</div><div class='long'><p>Removes all components from this container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>autoDestroy</span> : Boolean (optional)<div class='sub-desc'><p>True to automatically invoke the removed Component's <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">Ext.Component.destroy</a> function.\nDefaults to the value of this Container's <a href=\"#!/api/Ext.Container-cfg-autoDestroy\" rel=\"Ext.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> config.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of the destroyed components</p>\n</div></li></ul></div></div></div><div id='method-removeClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-removeClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-removeClass' class='name expandable'>removeClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes a CSS class from the component's underlying element. ...</div><div class='long'><p>Removes a CSS class from the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to remove</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-render' class='name expandable'>render</a>( <span class='pre'>[container], [position]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Render this Component into the passed HTML element. ...</div><div class='long'><p>Render this Component into the passed HTML element.</p>\n\n\n<p><b>If you are using a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> object to house this Component, then\ndo not use the render method.</b></p>\n\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n\n<p>Certain layout managers allow dynamic addition of child components. Those that do\ninclude <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a>, <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>,\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>, <a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">Ext.layout.TableLayout</a>.</p>\n\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes any\nunrendered child Components to be rendered. This is required so that you can add multiple\nchild components if needed while only refreshing the layout once.</p>\n\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager.\nIf you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n\n<p><b>Omitting the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</b></p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : Element/HTMLElement/String (optional)<div class='sub-desc'><p>The element this Component should be\nrendered into. If it is being created from existing markup, this should be omitted.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The element ID or DOM node index within the container <b>before</b>\nwhich this component will be inserted (defaults to appending to the end of the container)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setAutoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setAutoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setAutoScroll' class='name expandable'>setAutoScroll</a>( <span class='pre'>scroll</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the overflow on the content element of the component. ...</div><div class='long'><p>Sets the overflow on the content element of the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scroll</span> : Boolean<div class='sub-desc'><p>True to allow the Component to auto scroll.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setDisabled' class='name expandable'>setDisabled</a>( <span class='pre'>disabled</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function for setting disabled/enabled by boolean. ...</div><div class='long'><p>Convenience function for setting disabled/enabled by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'>height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the height of the component. ...</div><div class='long'><p>Sets the height of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style.</li>\n<li><i>undefined</i> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-setLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-setLayout' class='name expandable'>setLayout</a>( <span class='pre'>layout</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>layout</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setPagePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPagePosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPagePosition' class='name expandable'>setPagePosition</a>( <span class='pre'>x, y</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the page XY position of the component. ...</div><div class='long'><p>Sets the page XY position of the component.  To set the left and top instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPosition\" rel=\"Ext.BoxComponent-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPosition' class='name expandable'>setPosition</a>( <span class='pre'>left, top</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the left and top of the component. ...</div><div class='long'><p>Sets the left and top of the component.  To set the page XY position instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPagePosition\" rel=\"Ext.BoxComponent-method-setPagePosition\" class=\"docClass\">setPagePosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new left</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new top</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setSize' class='name expandable'>setSize</a>( <span class='pre'>width, height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width and height of this BoxComponent. ...</div><div class='long'><p>Sets the width and height of this BoxComponent. This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n<li><code>undefined</code> to leave the width unchanged.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set (not required if a size object is passed as the first arg).\nThis may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n<li><code>undefined</code> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'>visible</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function to hide or show this component by boolean. ...</div><div class='long'><p>Convenience function to hide or show this component by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Boolean<div class='sub-desc'><p>True to show, false to hide</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'>width</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width of the component. ...</div><div class='long'><p>Sets the width of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-shouldBufferLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-method-shouldBufferLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-shouldBufferLayout' class='name expandable'>shouldBufferLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-show' class='name expandable'>show</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Show this component. ...</div><div class='long'><p>Show this component.  Listen to the '<a href=\"#!/api/Ext.Component-event-beforeshow\" rel=\"Ext.Component-event-beforeshow\" class=\"docClass\">beforeshow</a>' event and return\n<tt>false</tt> to cancel showing the component.  Fires the '<a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>'\nevent after showing the component.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-syncSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-syncSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-syncSize' class='name expandable'>syncSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force the component's size to recalculate based on the underlying element's current height and width. ...</div><div class='long'><p>Force the component's size to recalculate based on the underlying element's current height and width.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-update' class='name expandable'>update</a>( <span class='pre'>htmlOrData, loadScripts, callback</span> )</div><div class='description'><div class='short'>Update the content area of a component. ...</div><div class='long'><p>Update the content area of a component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlOrData</span> : Mixed<div class='sub-desc'><p>If this component has been configured with a template via the tpl config\nthen it will use this argument as data to populate the template.\nIf this component was not configured with a template, the components\ncontent area will be updated via <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> update</p>\n</div></li><li><span class='pre'>loadScripts</span> : Boolean<div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Defaults to false</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Callback to execute when scripts have finished loading</p>\n</div></li></ul></div></div></div><div id='method-updateBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-updateBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-updateBox' class='name expandable'>updateBox</a>( <span class='pre'>box</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Sets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : Object<div class='sub-desc'><p>An object in the format {x, y, width, height}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-add' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-event-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-add' class='name expandable'>add</a>( <span class='pre'>this, component, index</span> )</div><div class='description'><div class='short'>@bubbles\nFires after any Ext.Component is added or inserted into the container. ...</div><div class='long'><p>@bubbles\nFires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component that was added</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the component was added to the container's items collection</p>\n</div></li></ul></div></div></div><div id='event-added' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-added' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-added' class='name expandable'>added</a>( <span class='pre'>this, ownerCt, index</span> )</div><div class='description'><div class='short'>Fires when a component is added to an Ext.Container ...</div><div class='long'><p>Fires when a component is added to an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='event-afterlayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-event-afterlayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-afterlayout' class='name expandable'>afterlayout</a>( <span class='pre'>this, layout</span> )</div><div class='description'><div class='short'>Fires when the components in this container are arranged by the associated layout manager. ...</div><div class='long'><p>Fires when the components in this container are arranged by the associated layout manager.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>layout</span> : ContainerLayout<div class='sub-desc'><p>The ContainerLayout implementation for this container</p>\n</div></li></ul></div></div></div><div id='event-afterrender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-afterrender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-afterrender' class='name expandable'>afterrender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component rendering is finished. ...</div><div class='long'><p>Fires after the component rendering is finished.</p>\n\n\n<p>The afterrender event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocesed\nby any afterRender method defined for the Component, and, if <a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a>, after state\nhas been restored.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeadd' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-event-beforeadd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-beforeadd' class='name expandable'>beforeadd</a>( <span class='pre'>this, component, index</span> )</div><div class='description'><div class='short'>Fires before any Ext.Component is added or inserted into the container. ...</div><div class='long'><p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.\nA handler can return false to cancel the add.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component being added</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the component will be added to the container's items collection</p>\n</div></li></ul></div></div></div><div id='event-beforedestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforedestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforedestroy' class='name expandable'>beforedestroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is destroyed. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed. Return false from an event handler to stop the <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforehide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforehide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforehide' class='name expandable'>beforehide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is hidden by calling the hide method. ...</div><div class='long'><p>Fires before the component is hidden by calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.\nReturn false from an event handler to stop the hide.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeremove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-event-beforeremove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-beforeremove' class='name expandable'>beforeremove</a>( <span class='pre'>this, component</span> )</div><div class='description'><div class='short'>Fires before any Ext.Component is removed from the container. ...</div><div class='long'><p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.  A handler can return\nfalse to cancel the remove.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component being removed</p>\n</div></li></ul></div></div></div><div id='event-beforerender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforerender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforerender' class='name expandable'>beforerender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is rendered. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return false from an\nevent handler to stop the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeshow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforeshow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforeshow' class='name expandable'>beforeshow</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is shown by calling the show method. ...</div><div class='long'><p>Fires before the component is shown by calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.\nReturn false from an event handler to stop the show.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforestaterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestaterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestaterestore' class='name expandable'>beforestaterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is restored. ...</div><div class='long'><p>Fires before the state of the component is restored. Return false from an event handler to stop the restore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. If this\nevent is not vetoed, then the state object is passed to <b><tt>applyState</tt></b>. By default,\nthat simply copies property values into this Component. The method maybe overriden to\nprovide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-beforestatesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestatesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestatesave' class='name expandable'>beforestatesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires before the state of the component is saved to the configured state provider. Return false to stop the save.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-destroy' class='name expandable'>destroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is destroyed. ...</div><div class='long'><p>Fires after the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-disable' class='name expandable'>disable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is disabled. ...</div><div class='long'><p>Fires after the component is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-enable' class='name expandable'>enable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is enabled. ...</div><div class='long'><p>Fires after the component is enabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-hide' class='name expandable'>hide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is hidden. ...</div><div class='long'><p>Fires after the component is hidden.\nFires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-move' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-move' class='name expandable'>move</a>( <span class='pre'>this, x, y</span> )</div><div class='description'><div class='short'>Fires after the component is moved. ...</div><div class='long'><p>Fires after the component is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='event-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Container'>Ext.Container</span><br/><a href='source/Container.html#Ext-Container-event-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-remove' class='name expandable'>remove</a>( <span class='pre'>this, component</span> )</div><div class='description'><div class='short'>@bubbles\nFires after any Ext.Component is removed from the container. ...</div><div class='long'><p>@bubbles\nFires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component that was removed</p>\n</div></li></ul></div></div></div><div id='event-removed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-removed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-removed' class='name expandable'>removed</a>( <span class='pre'>this, ownerCt</span> )</div><div class='description'><div class='short'>Fires when a component is removed from an Ext.Container ...</div><div class='long'><p>Fires when a component is removed from an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li></ul></div></div></div><div id='event-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-render' class='name expandable'>render</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component markup is rendered. ...</div><div class='long'><p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-resize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-resize' class='name expandable'>resize</a>( <span class='pre'>this, adjWidth, adjHeight, rawWidth, rawHeight</span> )</div><div class='description'><div class='short'>Fires after the component is resized. ...</div><div class='long'><p>Fires after the component is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='event-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-show' class='name expandable'>show</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is shown when calling the show method. ...</div><div class='long'><p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-staterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-staterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-staterestore' class='name expandable'>staterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is restored. ...</div><div class='long'><p>Fires after the state of the component is restored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. This is passed\nto <b><tt>applyState</tt></b>. By default, that simply copies property values into this\nComponent. The method maybe overriden to provide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-statesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-statesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-statesave' class='name expandable'>statesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires after the state of the component is saved to the configured state provider.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.Component","Ext.BoxComponent"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Container.html#Ext-Container","filename":"Container.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"boxReady","id":"property-boxReady"},{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"deferHeight","id":"property-deferHeight"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"disabled","id":"property-disabled"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"el","id":"property-el"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"hidden","id":"property-hidden"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"initialConfig","id":"property-initialConfig"},{"tagname":"property","owner":"Ext.Container","meta":{},"name":"items","id":"property-items"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"ownerCt","id":"property-ownerCt"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"refOwner","id":"property-refOwner"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"rendered","id":"property-rendered"}],"cfg":[{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"activeItem","id":"cfg-activeItem"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"allowDomMove","id":"cfg-allowDomMove"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"anchor","id":"cfg-anchor"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"applyTo","id":"cfg-applyTo"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"autoDestroy","id":"cfg-autoDestroy"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"autoEl","id":"cfg-autoEl"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoHeight","id":"cfg-autoHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoScroll","id":"cfg-autoScroll"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"autoShow","id":"cfg-autoShow"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoWidth","id":"cfg-autoWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxHeight","id":"cfg-boxMaxHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxWidth","id":"cfg-boxMaxWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinHeight","id":"cfg-boxMinHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinWidth","id":"cfg-boxMinWidth"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"bubbleEvents","id":"cfg-bubbleEvents"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"bufferResize","id":"cfg-bufferResize"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"clearCls","id":"cfg-clearCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"cls","id":"cfg-cls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"contentEl","id":"cfg-contentEl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ctCls","id":"cfg-ctCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"data","id":"cfg-data"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"defaultType","id":"cfg-defaultType"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"defaults","id":"cfg-defaults"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"disabled","id":"cfg-disabled"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"disabledClass","id":"cfg-disabledClass"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"fieldLabel","id":"cfg-fieldLabel"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"flex","id":"cfg-flex"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"forceLayout","id":"cfg-forceLayout"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"height","id":"cfg-height"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"hideBorders","id":"cfg-hideBorders"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideLabel","id":"cfg-hideLabel"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideMode","id":"cfg-hideMode"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideParent","id":"cfg-hideParent"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"html","id":"cfg-html"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemCls","id":"cfg-itemCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemId","id":"cfg-itemId"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"items","id":"cfg-items"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelSeparator","id":"cfg-labelSeparator"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelStyle","id":"cfg-labelStyle"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"layout","id":"cfg-layout"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"layoutConfig","id":"cfg-layoutConfig"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"margins","id":"cfg-margins"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"monitorResize","id":"cfg-monitorResize"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"overCls","id":"cfg-overCls"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageX","id":"cfg-pageX"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageY","id":"cfg-pageY"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"plugins","id":"cfg-plugins"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ptype","id":"cfg-ptype"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ref","id":"cfg-ref"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"region","id":"cfg-region"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"renderTo","id":"cfg-renderTo"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"resizeEvent","id":"cfg-resizeEvent"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateEvents","id":"cfg-stateEvents"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateId","id":"cfg-stateId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateful","id":"cfg-stateful"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"style","id":"cfg-style"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"tabTip","id":"cfg-tabTip"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tpl","id":"cfg-tpl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tplWriteMode","id":"cfg-tplWriteMode"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"x","id":"cfg-x"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"xtype","id":"cfg-xtype"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"y","id":"cfg-y"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"add","id":"method-add"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"addClass","id":"method-addClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustPosition","id":"method-adjustPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustSize","id":"method-adjustSize"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"afterRender","id":"method-afterRender"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"applyDefaults","id":"method-applyDefaults"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"applyToMarkup","id":"method-applyToMarkup"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"beforeDestroy","id":"method-beforeDestroy"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"bubble","id":"method-bubble"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"canLayout","id":"method-canLayout"},{"tagname":"method","owner":"Ext.Container","meta":{"chainable":true},"name":"cascade","id":"method-cascade"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"cloneConfig","id":"method-cloneConfig"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"createComponent","id":"method-createComponent"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.Container","meta":{"chainable":true},"name":"doLayout","id":"method-doLayout"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"doRemove","id":"method-doRemove"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"find","id":"method-find"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"findBy","id":"method-findBy"},{"tagname":"method","owner":"Ext.Container","meta":{"deprecated":{"text":"Fairly useless method, since you can just use Ext.getCmp. Should be removed for 4.0\nIf you need to test if an id belongs to a container, you can use getCmp and findParent*."}},"name":"findById","id":"method-findById"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"findByType","id":"method-findByType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentBy","id":"method-findParentBy"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentByType","id":"method-findParentByType"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"focus","id":"method-focus"},{"tagname":"method","owner":"Ext.Container","meta":{"deprecated":{"text":"Should be removed in 4.0, since getComponent does the same thing."}},"name":"get","id":"method-get"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getBox","id":"method-getBox"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getBubbleTarget","id":"method-getBubbleTarget"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"getComponent","id":"method-getComponent"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"getComponentId","id":"method-getComponentId"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getHeight","id":"method-getHeight"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getId","id":"method-getId"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getItemId","id":"method-getItemId"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"getLayout","id":"method-getLayout"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"getLayoutTarget","id":"method-getLayoutTarget"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getOuterSize","id":"method-getOuterSize"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getPosition","id":"method-getPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getResizeEl","id":"method-getResizeEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getSize","id":"method-getSize"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getWidth","id":"method-getWidth"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXType","id":"method-getXType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXTypes","id":"method-getXTypes"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"hasLayoutPending","id":"method-hasLayoutPending"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"hide","id":"method-hide"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"initComponent","id":"method-initComponent"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"initItems","id":"method-initItems"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"initRef","id":"method-initRef"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"insert","id":"method-insert"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isVisible","id":"method-isVisible"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isXType","id":"method-isXType"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"lookupComponent","id":"method-lookupComponent"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mon","id":"method-mon"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mun","id":"method-mun"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"nextSibling","id":"method-nextSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onAdd","id":"method-onAdd"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onAdded","id":"method-onAdded"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onBeforeAdd","id":"method-onBeforeAdd"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onLayout","id":"method-onLayout"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"onPosition","id":"method-onPosition"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onRemove","id":"method-onRemove"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onRemoved","id":"method-onRemoved"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"onResize","id":"method-onResize"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onShow","id":"method-onShow"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"previousSibling","id":"method-previousSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"removeAll","id":"method-removeAll"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"removeClass","id":"method-removeClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"render","id":"method-render"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setAutoScroll","id":"method-setAutoScroll"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setDisabled","id":"method-setDisabled"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setHeight","id":"method-setHeight"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"setLayout","id":"method-setLayout"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPagePosition","id":"method-setPagePosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPosition","id":"method-setPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setSize","id":"method-setSize"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setVisible","id":"method-setVisible"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setWidth","id":"method-setWidth"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"shouldBufferLayout","id":"method-shouldBufferLayout"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"show","id":"method-show"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"syncSize","id":"method-syncSize"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"update","id":"method-update"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"updateBox","id":"method-updateBox"}],"event":[{"tagname":"event","owner":"Ext.Container","meta":{},"name":"add","id":"event-add"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"added","id":"event-added"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"afterlayout","id":"event-afterlayout"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"afterrender","id":"event-afterrender"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"beforeadd","id":"event-beforeadd"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforedestroy","id":"event-beforedestroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforehide","id":"event-beforehide"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"beforeremove","id":"event-beforeremove"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforerender","id":"event-beforerender"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforeshow","id":"event-beforeshow"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestaterestore","id":"event-beforestaterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestatesave","id":"event-beforestatesave"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"destroy","id":"event-destroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"disable","id":"event-disable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"enable","id":"event-enable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"hide","id":"event-hide"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"move","id":"event-move"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"remove","id":"event-remove"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"removed","id":"event-removed"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"render","id":"event-render"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"resize","id":"event-resize"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"show","id":"event-show"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"staterestore","id":"event-staterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"statesave","id":"event-statesave"}],"css_mixin":[]},"inheritable":null,"private":null,"component":true,"name":"Ext.Container","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.Container","mixins":[],"mixedInto":[]});