# Generated by default/object.tt
package Paws::Macie2::BucketCriteriaAdditionalProperties;
  use Moose;
  has Eq => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eq', traits => ['NameInRequest']);
  has Gt => (is => 'ro', isa => 'Int', request_name => 'gt', traits => ['NameInRequest']);
  has Gte => (is => 'ro', isa => 'Int', request_name => 'gte', traits => ['NameInRequest']);
  has Lt => (is => 'ro', isa => 'Int', request_name => 'lt', traits => ['NameInRequest']);
  has Lte => (is => 'ro', isa => 'Int', request_name => 'lte', traits => ['NameInRequest']);
  has Neq => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'neq', traits => ['NameInRequest']);
  has Prefix => (is => 'ro', isa => 'Str', request_name => 'prefix', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BucketCriteriaAdditionalProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BucketCriteriaAdditionalProperties object:

  $service_obj->Method(Att1 => { Eq => $value, ..., Prefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BucketCriteriaAdditionalProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Eq

=head1 DESCRIPTION

Specifies the operator to use in a property-based condition that
filters the results of a query for information about S3 buckets.

=head1 ATTRIBUTES


=head2 Eq => ArrayRef[Str|Undef]

The value for the property matches (equals) the specified value. If you
specify multiple values, Macie uses OR logic to join the values.


=head2 Gt => Int

The value for the property is greater than the specified value.


=head2 Gte => Int

The value for the property is greater than or equal to the specified
value.


=head2 Lt => Int

The value for the property is less than the specified value.


=head2 Lte => Int

The value for the property is less than or equal to the specified
value.


=head2 Neq => ArrayRef[Str|Undef]

The value for the property doesn't match (doesn't equal) the specified
value. If you specify multiple values, Amazon Macie uses OR logic to
join the values.


=head2 Prefix => Str

The name of the bucket begins with the specified value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

