/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.grid.server.ServletRequestWrappingHttpRequest;
import org.openqa.selenium.grid.server.ServletResponseWrappingHttpResponse;
import org.openqa.selenium.grid.server.W3CCommandHandler;
import org.openqa.selenium.grid.web.CombinedRoute;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.json.Json;

class CommandHandlerServlet
extends HttpServlet {
    private final Routes routes;
    private final Injector injector;

    public CommandHandlerServlet(Routes routes) {
        Objects.requireNonNull(routes);
        this.routes = ((CombinedRoute)Routes.combine(routes, new Routes[0]).fallbackTo(new W3CCommandHandler((req, res) -> {
            throw new UnsupportedCommandException(String.format("Unknown command: (%s) %s", new Object[]{req.getMethod(), req.getUri()}));
        }))).build();
        this.injector = Injector.builder().register(new Json()).build();
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServletRequestWrappingHttpRequest request = new ServletRequestWrappingHttpRequest(req);
        ServletResponseWrappingHttpResponse response = new ServletResponseWrappingHttpResponse(resp);
        Optional<CommandHandler> possibleMatch = this.routes.match(this.injector, request);
        if (!possibleMatch.isPresent()) {
            throw new IllegalStateException("It should not be possible to get here");
        }
        possibleMatch.get().execute(request, response);
    }
}

