$spops = {
   user => {
     class        => 'OpenInteract::User',
     code_class   => 'OpenInteract::User',
     isa          => [ qw/ OpenInteract::SPOPS::DBI SPOPS::Secure  
                           SPOPS::DBI::MySQL  SPOPS::DBI / ],
     field        => [ qw/ user_id first_name last_name email language
                           title last_login num_logins login_name password 
                           removal_date notes theme_id / ],
     id_field     => 'user_id',
     increment_field => 1,
     sequence_name   => 'oi_sys_user_seq',
     no_insert    => [ qw/ user_id / ],
     skip_undef   => [ qw/ last_login num_logins password language theme_id / ],
     no_update    => [ qw/ user_id / ],
     base_table   => 'sys_user',
     sql_defaults => [ qw/ language theme_id / ],
     alias        => [],
     has_a        => { 'OpenInteract::Theme' => [ 'theme_id' ], },
     links_to     => { 'OpenInteract::Group' => 'sys_group_user' },
     fetch_by     => [],
     creation_security => { 
        u => undef,
        g   => { 3 => 'WRITE' },
        w   => 'READ',
     },
     track        => { create => 0, update => 1, remove => 1 },
     display      => { url => '/User/show/' },
     name         => sub { return $_[0]->full_name },
     object_name  => 'User',

# SMB-specific settings. Uncomment only if you need them.
#             smb_pdc    => 'MyPDC',
#             smb_bdc    => 'MyBDC',
#             smb_domain => 'MyDomain',
#             smb_use_internal_auth => 1,
   },

};