=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsAutoshapesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_autoshapes_get_worksheet_autoshape
#
# Get autoshape info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $autoshape_number The autoshape number. (required)
# @param string $format Exported format. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'autoshape_number' => {
        data_type => 'int',
        description => 'The autoshape number.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Exported format.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_autoshapes_get_worksheet_autoshape' } = { 
    	summary => 'Get autoshape info.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_autoshapes_get_worksheet_autoshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # verify the required parameter 'autoshape_number' is set
    unless (exists $args{'autoshape_number'}) {
      croak("Missing the required parameter 'autoshape_number' when calling cells_autoshapes_get_worksheet_autoshape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoshapes/{autoshapeNumber}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'autoshape_number'}) {
        my $_base_variable = "{" . "autoshapeNumber" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'autoshape_number'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_autoshapes_get_worksheet_autoshapes
#
# Get worksheet autoshapes info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_autoshapes_get_worksheet_autoshapes' } = { 
    	summary => 'Get worksheet autoshapes info.',
        params => $params,
        returns => 'AutoShapesResponse',
        };
}
# @return AutoShapesResponse
#
sub cells_autoshapes_get_worksheet_autoshapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_autoshapes_get_worksheet_autoshapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_autoshapes_get_worksheet_autoshapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoshapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('AutoShapesResponse', $response);
    return $_response_object;
}

1;
