#! /usr/bin/perl -w -I ..
#
# ... Tests via check_template.pl
#
# $Id: check_template.t, v 1.0 2006/02/01 Alex Peeters Exp $
#

use strict;
use Test;
use ASNMTAP::Asnmtap::Plugins::NPTest;

use vars qw($tests);
BEGIN {$tests = 10; plan tests => $tests}

my $t;
my $prefix = '../plugins/templates';
my $plugin = 'check_template.pl';

if ( -x "$prefix/$plugin" ) {
  $t += checkCmd( "$prefix/$plugin -V", 3, "/$plugin/");
  $t += checkCmd( "$prefix/$plugin -h", 3);
  $t += checkCmd( "$prefix/$plugin", 3, "/Missing command line argument host/");
  $t += checkCmd( "$prefix/$plugin -H hostname", 3, "/Missing command line argument warning/");
  $t += checkCmd( "$prefix/$plugin -H hostname -w 10", 3, "/Missing command line argument critical/");
  $t += checkCmd( "$prefix/$plugin -H hostname -w 10 -c 20", 2);
}

exit(0) if defined($Test::Harness::VERSION);
exit($tests - $t);
