//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

Boolean TURLView::valid(unsigned short int usi_command)	{
//	Purpose:	Check the validity of the view.
//	Arguments:	usi_command	The command to check the validity of.
//	Return Value:	Boolean	True	The view is valid.
//				False	The view is not valid.
//	Remarks/Portability/Dependencies/Restrictions:
//		Used in conjunction with validView.
//	Revision History:
//		12-27-93	created

	//	Check the validity of our class only when appropriate.
	//	Otherwise, must be OK.
	switch(usi_command)	{
	case cmValid:
		return(B_valid);
	default:
		return(True);
	}
}
