//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

Boolean TURLView::selectAnchor(HTChildAnchor *HTCAp_anchor)	{
//	Purpose:	Select an anchor from the current HText.
//	Arguments:	HTCAp_anchor	The anchor to select.
//	Return Value:	Boolean	True	The anchor was selected.
//				False	The anchor was not found.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-02-94	created
//		02-25-94	Modified to hold the anchor value until
//				ready to select the anchor in the view.

	//	Is the anchor valid in the first place?
	if(HTCAp_anchor == NULL)	{
		return(False);
	}

	//	Just save the value of the anchor to be selected for now.
	HTCAp_2BSelected = HTCAp_anchor;
	return(True);
}
