//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

unsigned short int TURLView::HTMLColor(signed long int sli_chars, unsigned
	short int usi_colorindex)	{
//	Purpose:	Take an offset into an HText stream and return
//			an appropriate color with regards to fonts, anchors,
//			and the video display mode.
//	Arguments:	sli_chars	The offset into the HText stream.
//			usi_colorindex	The offset into the palette entries
//					for the color for the video mode.
//	Return Value:	unsigned short int	The color.
//	Remarks/Portability/Dependencies/Restrictions:
//		Bypassing TVision's color palettes for ease of configuation.
//	Revision History:
//		01-29-94	created
//		04-04-94	Added a search color.
//		04-20-94	Increased performance by not searching through
//				all anchors all the time for a match.

	//	Go through the anchors, intelligently deciding if sli_chars
	//	is within an anchor.
	auto TextAttribute *TAp_check = NULL;

	//	First, check if there is search text to highlight.
	if(TAp_search != NULL)	{
		if(TAp_search->inRange(sli_chars) == 1)	{
			//	Check to make sure that this is also not
			//	the selected anchor.
			if(TAp_selected != NULL)	{
				if(TAp_selected->inRange(sli_chars) == 1)
				{
					return(SearchSelectedColor);
				}
			}
			return(SearchColor);
		}
	}

	//	Start from the beginning index of the first anchor on possibly
	//	on the screen already indexed by the draw function for us. If
	//	our offset ever passes that of sli_chars, then consider that
	//	it is not inside an anchor, check the one after it too for
	//	nested anchors, but save this index until the next time draw
	//	is called.
	auto Boolean B_check2 = False;

	while(ssi_fasterpussycat < TNSCp_anchors->getCount())	{
		//	Obtain the anchor.
		TAp_check = (TextAttribute *)(TNSCp_anchors->at(
			ssi_fasterpussycat));

		//	If already past what we are checking, break.
		if(sli_chars < TAp_check->getBegin())	{
			break;
		}

		//	Next, determine if in the range of the anchor.
		if(TAp_check->inRange(sli_chars) == 1)	{
			//	Is this the selected anchor?
			if(TAp_selected == TAp_check)	{
				return(SelectedColor);
			}

			//	Okay, isn't the selected anchor, but is the
			//	next anchor nested into this one, and if so,
			//	is it the selected anchor?
			if(B_check2 != True)	{
				B_check2 = True;
				ssi_fasterpussycat++;
				continue;
			}

			return(AnchorColor);
		}

		//	Check the next one.
		ssi_fasterpussycat++;
	}

	//	not in any range, just display normally.
	//	Could have been checked last time....
	if(B_check2 == True)	{
		ssi_fasterpussycat--;
		return(AnchorColor);
	}
	return(TextColor);
}
