//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-04	Split all members to seperate files to enhance
//				overlay support.
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TKeys
#include"tdoslynx.h"
#include"globals.h"

TStatusLine *TDosLynx::initStatusLine(TRect TR_r)	{
//	Purpose:	Initialize the status line.
//	Arguments:	TR_r	Dimensions of the status line.
//	Return Value:	TStatusLine *	the new status line.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-10-93	created

	//	Move top to one line above the bottom
	TR_r.a.y = TR_r.b.y - 1;
	//	Create the status line and it's items, then return it.
	return(new TStatusLine(TR_r, *new TStatusDef(0, 0xFFFF) +
		*new TStatusItem(NULL, kbAltX, cmQuit) +
		*new TStatusItem(NULL, kbF3, cmOpenURL) +
		*new TStatusItem(NULL, kbAltF3, cmClose) +
		*new TStatusItem(NULL, kbF5, cmZoom) +
		*new TStatusItem(NULL, kbF10, cmMenu) +
		*new TStatusItem(NULL, kbAltF5, cmResize) +
		*new TStatusItem("~Prior~", kbNoKey, cmPreviousDocument) +
		*new TStatusItem("~Activate~", kbNoKey, cmSelectAnchor) +
		*new TStatusItem("~Next~", kbNoKey, cmNextAnchor) +
		*new TStatusItem("~Previous~", kbNoKey, cmPreviousAnchor) +
		*new TStatusItem(NULL, kbF1, cmHotList) +
		*new TStatusItem(NULL, kbF4, cmSearchAgainDLX) +
		*new TStatusItem(NULL, kbF2, cmSaveDLX) +
		*new TStatusItem("~Search~", kbF7, cmSearchIndex) +
		*new TStatusItem(NULL, kbF9, cmHomePage)
		));
}
